// height_field — image and function variants
#version 3.8;
#include "include/ZZ_KW_Tools.inc"

MACRO_SCENE_PREAMBLE("height_field — image and function variants")

#ifndef(S_VARIANT) #declare S_VARIANT = 1; #end // 1..2; override with +declare=S_VARIANT=2 or use animation clock
#declare S_N = 2;
#declare S_EX = S_VARIANT;

#if (defined(clock))
    #declare S_EX = 1 + int(clamp(clock,0,1)*(S_N-1) + 0.5);
#end

#switch (S_EX)
    #case (1)
        height_field {pgm "assets/hf_test.pgm" smooth texture {T_DEFAULT} translate <-0.5,-1,4.5> scale <1,0.4,1>}
        MACRO_CAPTION_INDEXED("height_field", S_EX, S_N)
        #break
    #case (2)
        // Function-based height_field: x,y in [0,1]; z scaled by height values
        #declare F_H = function(u,v){ 0.5 + 0.5*sin(6.28318*u)*cos(6.28318*v) };
        height_field {function 128,128 {F_H(x,y)} texture {T_DEFAULT} translate <-0.5,-1,4.5> scale <1,0.4,1>}
        MACRO_CAPTION_INDEXED("height_field", S_EX, S_N)
        #break
#end


// ***end of code***
