// turbulence/octaves — multipanel
#version 3.8;
#include "include/ZZ_KW_Tools.inc"

MACRO_SCENE_PREAMBLE("turbulence/octaves — multipanel")

#declare A1D_T = array[4] {0, 0.4, 0.8, 1.2};
#declare A1D_O = array[4] {0, 2, 4, 8};
#declare S_COLS = 4; #declare S_SP = 1.5;
#declare S_i = 0;
#while (S_i < 4)
    MACRO_PANEL_POS(S_i, S_COLS, S_SP)
    box {<-0.6,-0.6,4.4>, <0.6,0.6,5.6>
        texture {pigment {granite turbulence A1D_T[S_i] octaves A1D_O[S_i] color_map {[0 rgb <0.2,0.2,0.6>] [1 rgb <0.8,0.2,0.2>]}} finish {diffuse 0.9}}
        translate V_P
    }
    text {ttf "timrom.ttf" concat("turb=", str(A1D_T[S_i],0,1), ", oct=", str(A1D_O[S_i],0,0)) 0.05, 0 texture {pigment {rgb <0.05,0.05,0.05>}} translate <V_P.x-0.6, -0.9, 5.1> scale 0.18}
    #declare S_i = S_i + 1;
#end
MACRO_CAPTION("granite with turbulence/octaves — 2×2 comparison")


// ***end of code***
