
// ZZ_KW_Tools.inc — Utilities for compact, doc-style demos
#version 3.8;

// Default items kept terse; default camera is used (no camera statement)
#macro MACRO_DEFAULT_LIGHT()
    light_source {<-30, 60, -30> color rgb <1,1,1>}
#end

#macro MACRO_CHECKER_FLOOR(S_Y)
    plane {y, S_Y texture {pigment {checker rgb <0.85,0.85,0.85>, rgb <0.25,0.25,0.25>} finish {diffuse 0.9}}}
#end

#declare T_DEFAULT = texture {pigment {rgb <0.75,0.85,1.0>} finish {phong 0.5}};
#declare T_CHROME  = texture {pigment {rgb <0.85,0.85,0.90>} finish {reflection 0.2 specular 0.7 roughness 0.01 conserve_energy}};

#macro MACRO_LABEL(S_TEXT)
    text {ttf "timrom.ttf" S_TEXT 0.05, 0 texture {pigment {rgb <0.1,0.1,0.1>}} translate <-2.7, 2.2, 4.9> scale 0.3}
#end

#macro MACRO_CAPTION(S_TEXT)
    text {ttf "timrom.ttf" S_TEXT 0.05, 0 texture {pigment {rgb <0.05,0.05,0.05>}} translate <-2.7, -1.8, 5.1> scale 0.25}
#end

#macro MACRO_CAPTION_INDEXED(S_NAME, S_EX, S_N)
    #local S_STR = concat(S_NAME, ": example ", str(S_EX,0,0), " of ", str(S_N,0,0));
    MACRO_CAPTION(S_STR)
#end

#macro MACRO_SCENE_PREAMBLE(S_LABEL)
    global_settings {assumed_gamma 1}
    background {rgb <1,1,1>}
    MACRO_DEFAULT_LIGHT()
    MACRO_CHECKER_FLOOR(-1)
    MACRO_LABEL(S_LABEL)
#end

// Minimal axes for function plots or panels
#macro MACRO_AXES_UNIT()
    cylinder {<0,0,0>, <1,0,0>, 0.02 texture {pigment {rgb <1,0,0>}}}
    cylinder {<0,0,0>, <0,1,0>, 0.02 texture {pigment {rgb <0,1,0>}}}
    cylinder {<0,0,0>, <0,0,1>, 0.02 texture {pigment {rgb <0,0,1>}}}
#end

// Panel helper: place N panels on a grid with given cols
#macro MACRO_PANEL_POS(S_INDEX, S_COLS, S_SPACING)
    // Zero-based index; returns a translate vector via #local V_P
    #local S_ROW = int(S_INDEX/S_COLS);
    #local S_COL = mod(S_INDEX, S_COLS);
    #local V_P = <(S_COL-(S_COLS-1)/2.0)*S_SPACING, 0, 5 + S_ROW*0>;
#end

// ***end of code***
