
#version 3.8;

#macro MACRO_GRAPH_1D(F_FUNC, S_XMIN, S_XMAX, S_YMIN, S_YMAX, S_SAMPLES)
    // Draw axes rectangle and polyline for y=F(x) on a unit panel centered at <0,0,5>
    #local S_N = max(2, S_SAMPLES);
    #local V_SCALE = <2.5/(S_XMAX-S_XMIN), 1.8/(S_YMAX-S_YMIN), 1>;
    #local V_SHIFT = <-1.25 - S_XMIN*V_SCALE.x, -0.9 - S_YMIN*V_SCALE.y, 5>;
    // Axes box
    box {<-1.25,-0.9,4.99>, <1.25,0.9,4.98> texture {pigment {rgb <1,1,1>}}}
    // Grid lines (light)
    #local S_G = 5;
    #local S_i = 0;
    #while (S_i <= S_G)
        #local S_t = S_i/S_G;
        #local S_x = S_XMIN + (S_XMAX-S_XMIN)*S_t;
        #local S_y = S_YMIN + (S_YMAX-S_YMIN)*S_t;
        cylinder {<(-1.25), (-0.9 + 1.8*S_t), 4.97>, <(1.25), (-0.9 + 1.8*S_t), 4.97>, 0.003 texture {pigment {rgb <0.85,0.85,0.85>}}}
        cylinder {<(-1.25 + 2.5*S_t), (-0.9), 4.97>, <(-1.25 + 2.5*S_t), (0.9), 4.97>, 0.003 texture {pigment {rgb <0.85,0.85,0.85>}}}
        #local S_i = S_i + 1;
    #end
    // Plot polyline as short cylinders
    #local S_k = 0;
    #local V_prev = <0,0,0>;
    #while (S_k < S_N)
        #local S_xt = S_XMIN + (S_XMAX-S_XMIN)*S_k/(S_N-1);
        #local S_yt = F_FUNC(S_xt);
        #local V_curr = <S_xt, S_yt, 0>;
        #local V_currT = <V_curr.x*V_SCALE.x + V_SHIFT.x, V_curr.y*V_SCALE.y + V_SHIFT.y, 4.96>;
        #if (S_k > 0)
            cylinder {V_prev, V_currT, 0.01 texture {pigment {rgb <0.2,0.2,0.2>}}}
        #end
        #local V_prev = V_currT;
        #local S_k = S_k + 1;
    #end
#end

// ***end of code***
