
# POV-Ray 3.8 Keyword Examples — Pack v2 (compact formatting)

**Conventions**
- No explicit camera (use default camera).
- Compact spacing: `keyword {next ...}` (no extra space after `{`).
- Prefer `rgb` (avoid deprecated `color`).
- Reusable defaults: `T_DEFAULT`, `T_CHROME`, checker floor, simple light.
- In-scene captions via `MACRO_CAPTION()` and `MACRO_CAPTION_INDEXED()`.
- Every file ends with `// ***end of code***`.

## Quick start
Render any `*.pov` directly. To switch variants in files that support them:

- Set a variant index: `+declare=S_VARIANT=2`
- Or use animation clock across variants: `+KFI0 +KFF1 +KI0 +KF1 +KC`

## Index scene & animation across topics
- `INDEX_Keywords.pov` lets you pick a scene name:
  - `+declare=S_SCENE="acos"`
- Or animate across a built-in list:
  - `+KFI0 +KFF7 +KI0 +KF1 +KC` (sweeps the list of 8 entries)

> **Tip on filenames**: Use `+O` or an INI with `Output_File_Name=acos_example` for per-run names. POV-Ray appends frame numbers automatically for animations.

## New examples (different from earlier pack)
- `primitives/height_field_variants.pov` — image vs function height_field with captions.
- `modifiers/turbulence_octaves_panel.pov` — 2×2 multipanel showing turbulence & octaves.
- `modifiers/open_compare.pov` — side-by-side open vs closed cone.
- `functions/acos_demo.pov` — plots acos(x) with domain/range notes.
- `media/volumetric_spotlight.pov` — physically plausible single-scattering beam.
- `photons/caustics_glass.pov` — targeted photons for crisp caustics with gather tuning.
- `INDEX_Keywords.pov` — switch or animate across scenes.

## Why these media & photons setups?
- **Media**: Using `scattering {1,...}` with `method 3` and modest `samples` yields a more physically grounded look than pure `emission`, with faster convergence than high sample counts in `method 1`. Keep the container `open hollow` and use a fully transparent pigment to avoid surface shading artifacts.
- **Photons**: A moderate `spacing` with a two-stage `gather` (min,max) balances detail and smoothness. `target` on the glass object concentrates photons where they matter, and `conserve_energy` in the finish keeps reflections/refractions physically consistent.

## Batch rendering all keywords (idea)
Two approaches:
1. **Per-file batch**: render all `*.pov` in a script, naming each with `+O` to include the keyword (e.g., `+Oacos_example.png`).
2. **Single index animation**: extend `A1D_LIST` in `INDEX_Keywords.pov` to include all keywords; render once with `+KFI0 +KFF<N-1>`.

## Notes
- Fonts: uses `timrom.ttf` for labels; change in `MACRO_LABEL()`/`MACRO_CAPTION()` if needed.
- Extend the pack by adding more `snippets/*.inc` and listing them in `A1D_LIST`.

