
#ifndef(S_SCENE) #declare S_SCENE = "sphere"; #end
#declare A1D_LIST = array[8] {"sphere","height_field","turbulence_panel","open_compare","acos","media","photons","box"};
#declare S_N = dimension_size(A1D_LIST,1);
#if (defined(clock)) #declare S_SCENE = A1D_LIST[int(clamp(clock,0,1)*(S_N-1)+0.5)]; #end
MACRO_SCENE_PREAMBLE(concat("INDEX — ", S_SCENE))
#if (strcmp(S_SCENE,"sphere")=0)
    #include "snippets/sphere.inc"
#end
#if (strcmp(S_SCENE,"box")=0)
    #include "snippets/box.inc"
#end
#if (strcmp(S_SCENE,"height_field")=0)
    #include "snippets/height_field_fn.inc"
    MACRO_CAPTION("height_field (function variant) — see primitives/height_field_variants for more")
#end
#if (strcmp(S_SCENE,"turbulence_panel")=0)
    #include "snippets/turbulence_panel.inc"
#end
#if (strcmp(S_SCENE,"open_compare")=0)
    #include "snippets/open_compare.inc"
#end
#if (strcmp(S_SCENE,"acos")=0)
    #include "snippets/acos_demo.inc"
#end
#if (strcmp(S_SCENE,"media")=0)
    #include "snippets/media_vol_spot.inc"
#end
#if (strcmp(S_SCENE,"photons")=0)
    #include "snippets/photons_demo.inc"
#end
// ***end of code***
