
// ZZ_KW_Tools.inc — Utility macros for consistent demo scenes
// Style: Uppercase identifiers, type-prefixed, default camera avoided
// Requires: POV-Ray 3.8

#version 3.8;

#macro MACRO_DEFAULT_LIGHT()
    light_source { < -30, 60, -30 > color rgb <1,1,1> }
#end

#macro MACRO_CHECKER_FLOOR(S_Y)
    plane { y, S_Y
        texture {
            pigment { checker color rgb <0.85,0.85,0.85>, color rgb <0.25,0.25,0.25> }
            finish { diffuse 0.9 specular 0.0 }
        }
    }
#end

#macro MACRO_LABEL(S_TEXT)
    // Uses a typical font shipped with POV-Ray; adjust if missing on your system.
    text { ttf "timrom.ttf" S_TEXT 0.05, 0
        texture { pigment { color rgb <0.1,0.1,0.1> } }
        translate <-2.7, 2.2, 4.9>
        scale 0.3
    }
#end

#macro MACRO_DOC_STYLE_TEXTURE()
    texture {
        pigment { color rgb <0.75,0.85,1.0> }
        finish { phong 0.5 reflection 0 }
    }
#end

#macro MACRO_AXES()
    // Simple RGB axes at the origin, short to avoid clutter.
    cylinder { <0,0,0>, <1,0,0>, 0.02 texture { pigment { color rgb <1,0,0> } } }
    cylinder { <0,0,0>, <0,1,0>, 0.02 texture { pigment { color rgb <0,1,0> } } }
    cylinder { <0,0,0>, <0,0,1>, 0.02 texture { pigment { color rgb <0,0,1> } } }
#end

#macro MACRO_SCENE_PREAMBLE(S_LABEL)
    global_settings { assumed_gamma 1 }
    background { color rgb <1,1,1> }
    MACRO_DEFAULT_LIGHT()
    MACRO_CHECKER_FLOOR(-1)
    MACRO_LABEL(S_LABEL)
#end

// A reusable transform for examples
#declare T_DEMO = transform { translate <0,0,5> };

// ***end of code***
