# POV-Ray 3.8 Keyword Examples — Starter Pack

This pack provides short, didactic examples for many core POV-Ray 3.8 keywords. Each example avoids an explicit camera to use the default camera, and adopts documentation-like styling (checker floor, simple lighting).


## How to use

- Open any `*.pov` file and render.
- Ensure a standard TTF like `timrom.ttf` is available for labels.
- Assets live in `assets/`.
- Utilities live in `include/ZZ_KW_Tools.inc`.


## Covered examples (by folder/file)

- csg/difference.pov
- csg/intersection.pov
- csg/merge.pov
- csg/union.pov
- directives/fopen_write_read.pov
- directives/if_while_switch.pov
- directives/ifdef_undef_debug.pov
- directives/macro_and_local.pov
- directives/version_include.pov
- environment/background.pov
- environment/fog.pov
- environment/sky_sphere.pov
- global/global_photons.pov
- global/global_radiosity.pov
- interior/hollow_media.pov
- interior/interior_ior_caustics.pov
- isosurface/isosurface_function.pov
- language/object_and_declare.pov
- lighting/area_light.pov
- lighting/light_source_basic.pov
- lighting/shadowless.pov
- lighting/spotlight.pov
- materials/material_block.pov
- mesh/mesh2.pov
- mesh/smooth_triangle.pov
- mesh/triangle.pov
- modifiers/bounded_clipped.pov
- modifiers/no_shadow_image_reflection.pov
- primitives/box.pov
- primitives/cone.pov
- primitives/cylinder.pov
- primitives/disc.pov
- primitives/height_field.pov
- primitives/plane.pov
- primitives/sphere.pov
- primitives/torus.pov
- swept/lathe.pov
- swept/prism.pov
- swept/sor.pov
- text/text_ttf.pov
- textures/bozo_wood_marble.pov
- textures/checker_pattern.pov
- textures/finish_reflection_specular.pov
- textures/gradient_and_color_map.pov
- textures/image_map.pov
- textures/normal_bumps.pov
- textures/pigment_color.pov
- textures/turbulence_and_warp.pov
- transforms/matrix.pov
- transforms/rotate.pov
- transforms/scale.pov
- transforms/transform_block.pov
- transforms/translate.pov

## Notes

- This is a **starter** set; additional keywords (e.g., blobs, quartic/quadrics, parametric, splines, advanced media and radiosity controls, photons fine-tuning, texture maps variants, function-based pigments, etc.) can be added next.

- Each file ends with `// ***end of code***` per your preference.

- Identifiers are uppercase and prefixed by type (S_, V_, A1D_, O_, T_) where used.
