#version 3.6; 
#version unofficial MegaPOV 1.2;
#include "pprocess.inc"   


PP_Init_IPoint_Outputs()
PP_Init_Alpha_Output()
PP_Init_INormal_Outputs()

global_settings {
  assumed_gamma 1.0
  
  post_process{  
    function { f_output_ipoint_x(x,y) }
    function { f_output_ipoint_y(x,y) }
    function { f_output_ipoint_z(x,y) } 
    function { f_output_alpha(x,y) }       
    save_file  "interpoint.bmp" 
     }
    
    post_process{
    function { f_output_inormal_x(x,y) }
    function { f_output_inormal_y(x,y) }
    function { f_output_inormal_z(x,y) }
    function { f_output_alpha(x,y) } 
    save_file "normal.bmp"
    }  

 radiosity {
    pretrace_start 0.08           
    pretrace_end   0.04          
    count 300                     
    nearest_count 5            
    error_bound 1.8            
    recursion_limit 2          
  }
}

//************************* λ *****************************************    
#declare camera_za=0;      
#declare camera_aa=0;
#declare h1=7000;   
#declare h2=1229.574517; 
#declare camera_dist=8229.574517;
                                      
#declare camera_y = camera_dist*cos(radians(camera_za));
#declare camera_LL = camera_dist*sin(radians(camera_za));
#declare camera_x = camera_LL*sin(radians(camera_aa));
#declare camera_z = camera_LL*cos(radians(camera_aa));
                   
camera              
{                
angle 3.48002                                                                                                                                                                                                                            
location <camera_x,camera_y,camera_z >  
look_at <0,0,0>  
right x                                                                     
up y  
}

                                                                                                                                                                                  
//************************** ̫ļλ *************************************** 
#declare sun_za = 16.52; 
#declare sun_aa = 120.30; 
#declare sun_dist = 154086000000;  
                   
#declare sun_y = sun_dist*cos(radians(sun_za));
#declare sun_LL = sun_dist*sin(radians(sun_za)); 
#declare sun_x = sun_LL*sin(radians(sun_aa));  
#declare sun_z = sun_LL*cos(radians(sun_aa));  


light_source {<sun_x,sun_y,sun_z>
             color rgb 1    
             }        
                                       
//---------------------------- objects in scene ----------------------------                  
// draw a geometry stored in a file 
#declare geom_file_name = "XYZ.txt"; 
#declare spec_file_name = "REFr.txt"; 
// find max_x,max_y,max_z 
#declare max_x=414718.250000;  
#declare max_y=1511.800049 ;
#declare max_z=3492897.250000;
#fopen   Input_geom_file geom_file_name read
#while(defined(Input_geom_file)) 
    #read(Input_geom_file,x1,y1,z1,x2,y2,z2,x3,y3,z3)  
    #if(x1>max_x)
        #declare max_x = x1;
    #end
    #if(x2>max_x)
        #declare max_x = x2;
    #end
    #if(x3>max_x)
        #declare max_x = x3;
    #end
    #if(y1>max_y)
        #declare max_y = y1;
    #end
    #if(y2>max_y)
        #declare max_y = y2;
    #end
    #if(y3>max_y)
        #declare max_y = y3;
    #end
    #if(z1>max_z)
        #declare max_z = z1;
    #end
    #if(z2>max_z)
        #declare max_z = z2;
    #end
    #if(z3>max_z)
        #declare max_z = z3;
    #end
    
#end 
#debug concat(str(max_x,15,2),str(max_y,15,2),str(max_z,15,2),"\n")  
 
// find min_x,min_y,min_z 
#declare min_x=414218.750000;  
#declare min_y=1101.500000 ;
#declare min_z=3492397.750000;
#fopen   Input_geom_file geom_file_name read
#while(defined(Input_geom_file)) 
    #read(Input_geom_file,x1,y1,z1,x2,y2,z2,x3,y3,z3) 
    #if(x1<min_x)
        #declare min_x = x1;
    #end
    #if(x2<min_x)
        #declare min_x = x2;
    #end
    #if(x3<min_x)
        #declare min_x = x3;
    #end
    #if(y1<min_y)
        #declare min_y = y1;
    #end
    #if(y2<min_y)
        #declare min_y = y2;
    #end
    #if(y3<min_y)
        #declare min_y = y3;
    #end
    #if(z1<min_z)
        #declare min_z = z1;
    #end
    #if(z2<min_z)
        #declare min_z = z2;
    #end
    #if(z3<min_z)
        #declare min_z = z3;
    #end 
#end 
#debug concat(str(min_x,15,2),str(min_y,15,2),str(min_z,15,2),"\n")  

// find the center of the geometry   
#declare center_x = (min_x+max_x)*0.5;      
#declare center_y = (min_y+max_y)*0.5;
#declare center_z = (min_z+max_z)*0.5;
#debug concat(str(center_x,15,2),str(center_y,15,2),str(center_z,15,2),"\n\n")     
        
// move the center of the geometry to the original    
     
#declare n = 0;
#fopen   Input_geom_file geom_file_name read
#fopen   Input_spec_file spec_file_name read 
#while(defined(Input_geom_file)) 
#while(defined(Input_spec_file))     
    #read(Input_geom_file,x1,y1,z1)  
    #read(Input_spec_file,ref)  
 
        box    
        {
        -0.25,0.25                  
        translate<x1-center_x,y1-center_y,z1-center_z>   
        pigment{color rgb 1}                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          
        finish {                                      
              ambient 0  
              diffuse ref     
               }          
        no_shadow 
        }  
        
    #declare n = n + 1;
#end      
#debug concat(str(n,15,2),"\n")  
#end                                                             






    