// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.6
// Desc: Photon Scene Template
// Date: mm/dd/yy
// Auth: ?
//

// The_Secret.pov: Exported from Wings 3D 0.99.03 

#include "rad_def.inc"

#ifndef (Radiosity)
#declare Radiosity = on;
#end

global_settings{
  assumed_gamma 1.0
  max_trace_level 5
  ambient_light 0
  #if (Radiosity)
  radiosity {
    pretrace_start 0.08
    pretrace_end   0.004
    count 300
    nearest_count 10
    error_bound 0.15
    recursion_limit 3
    low_error_factor 0.5
    gray_threshold 0
    minimum_reuse 1/1024
    brightness 1.0
    adc_bailout 0.01/2
  }
  #end
  //radiosity { Rad_Settings(Radiosity_IndoorLQ, off, off) }
}
#if (Radiosity)
  background { rgb 1000 }
#end
#declare camera_location = 10*<-10.373286, 14.563304, -29.587552>;
camera{
	 perspective
	 location camera_location
	 right x*image_width/image_height
	 up y
	 angle 60
	 look_at 10*<0,10,0>
}
#if (!Radiosity)
  //light_source { 10*<0,9,38> color rgb 100 }
  light_source { camera_location color rgb 0.1 }
#end

#declare BlurryNormal = normal { bumps 0.02 scale 0.0001 }

#declare wm_Wall = texture{
  pigment{ color rgb <1,1,1> }
  finish {
    ambient  0
    diffuse  0.7 brilliance  1
    specular 0.0
  }
}
#declare wm_Hinges = texture{
  pigment{ color rgb <0.9,0.9,0.9> }
  finish {
    ambient  0
    diffuse  0.7 brilliance 1
    specular 0
    reflection { 0.5 metallic } conserve_energy
    metallic
  }
  normal { BlurryNormal }
}
#declare wm_Handle = texture{
  pigment{ color rgb <0.2,0.2,0.2> }
  finish {
    ambient  0
    diffuse  0.7 brilliance 1
    specular 0 // 1 roughness 0.01
    reflection { 0.0, 0.3 fresnel } conserve_energy
  }
  normal { BlurryNormal }
}
#declare wm_Door = texture{
  pigment{ color rgb <1,1,1> }
  finish {
    ambient  0
    diffuse  0.7 brilliance 1
    specular 0 // 1 roughness 0.01
    reflection { 0.0, 0.3 fresnel } conserve_energy
  }
  normal { BlurryNormal }
}
#declare wm_Catch = texture{
  pigment{ color rgb <0.9,0.9,0.9> }
  finish {
    ambient  0
    diffuse  0.7 brilliance 1
    specular 0
    reflection { 0.5 metallic } conserve_energy
    metallic
  }
  normal { BlurryNormal }
}


#declare Walls = difference {
  box { <16,27,1>, <-31,-1,-41> }
  box { <15,26,0>, <-30,-2,-40> } // room
  box { <4.5,20.5,2>, <-4.5,-0.5,-1> } // door
  #texture { wm_Wall }
}
#declare Floor = plane { y, 0.001
  texture {
    pigment { image_map { jpeg "Parquetry_plain.jpg" interpolate 2 } rotate x*90 scale 250 }
    finish {
      ambient 0
      diffuse 0.7
      specular 0
      //reflection { 0.0 0.7 fresnel }
      conserve_energy
    }
    normal { BlurryNormal }
  }
}


#declare wo_0_Hinges = mesh2{
	 vertex_vectors { 196, <4.101427, 2.400000, -0.325000>, <4.107028, 2.400000, -0.296845>, <4.122976, 2.400000, -0.272976>, <4.146845, 2.400000, -0.257028>, <4.175000, 2.400000, -0.251427>, <4.203155, 2.400000, -0.257028>, <4.227024, 2.400000, -0.272976>, <4.242972, 2.400000, -0.296845>, <4.248573, 2.400000, -0.325000>, <4.242972, 2.400000, -0.353155>, 
			<4.227024, 2.400000, -0.377024>, <4.203155, 2.400000, -0.392972>, <4.175000, 2.400000, -0.398573>, <4.146845, 2.400000, -0.392972>, <4.122976, 2.400000, -0.377024>, <4.107028, 2.400000, -0.353155>, <4.101427, 1.600000, -0.325000>, <4.107028, 1.600000, -0.296845>, <4.122976, 1.600000, -0.272976>, <4.146845, 1.600000, -0.257028>, <4.175000, 1.600000, -0.251427>, 
			<4.203155, 1.600000, -0.257028>, <4.227024, 1.600000, -0.272976>, <4.242972, 1.600000, -0.296845>, <4.248573, 1.600000, -0.325000>, <4.242972, 1.600000, -0.353155>, <4.227024, 1.600000, -0.377024>, <4.203155, 1.600000, -0.392972>, <4.175000, 1.600000, -0.398573>, <4.146845, 1.600000, -0.392972>, <4.122976, 1.600000, -0.377024>, <4.107028, 1.600000, -0.353155>, 
			<4.101427, 18.400000, -0.325000>, <4.107028, 18.400000, -0.296845>, <4.122976, 18.400000, -0.272976>, <4.146845, 18.400000, -0.257028>, <4.175000, 18.400000, -0.251427>, <4.203155, 18.400000, -0.257028>, <4.227024, 18.400000, -0.272976>, <4.242972, 18.400000, -0.296845>, <4.248573, 18.400000, -0.325000>, <4.242972, 18.400000, -0.353155>, <4.227024, 18.400000, -0.377024>, 
			<4.203155, 18.400000, -0.392972>, <4.175000, 18.400000, -0.398573>, <4.146845, 18.400000, -0.392972>, <4.122976, 18.400000, -0.377024>, <4.107028, 18.400000, -0.353155>, <4.101427, 17.600000, -0.325000>, <4.107028, 17.600000, -0.296845>, <4.122976, 17.600000, -0.272976>, <4.146845, 17.600000, -0.257028>, <4.175000, 17.600000, -0.251427>, <4.203155, 17.600000, -0.257028>, 
			<4.227024, 17.600000, -0.272976>, <4.242972, 17.600000, -0.296845>, <4.248573, 17.600000, -0.325000>, <4.242972, 17.600000, -0.353155>, <4.227024, 17.600000, -0.377024>, <4.203155, 17.600000, -0.392972>, <4.175000, 17.600000, -0.398573>, <4.146845, 17.600000, -0.392972>, <4.122976, 17.600000, -0.377024>, <4.107028, 17.600000, -0.353155>, <4.102855, 2.400000, -0.310649>, 
			<4.102855, 2.400000, -0.339351>, <4.101427, 2.000000, -0.325000>, <4.113838, 2.400000, -0.284133>, <4.107028, 2.000000, -0.296845>, <4.134133, 2.400000, -0.263838>, <4.122976, 2.000000, -0.272976>, <4.160649, 2.400000, -0.252855>, <4.146845, 2.000000, -0.257028>, <4.189351, 2.400000, -0.252855>, <4.175000, 2.000000, -0.251427>, <4.215867, 2.400000, -0.263838>, 
			<4.203155, 2.000000, -0.257028>, <4.236162, 2.400000, -0.284133>, <4.227024, 2.000000, -0.272976>, <4.247145, 2.400000, -0.310649>, <4.242972, 2.000000, -0.296845>, <4.247145, 2.400000, -0.339351>, <4.248573, 2.000000, -0.325000>, <4.236162, 2.400000, -0.365867>, <4.242972, 2.000000, -0.353155>, <4.215867, 2.400000, -0.386162>, <4.227024, 2.000000, -0.377024>, 
			<4.189351, 2.400000, -0.397145>, <4.203155, 2.000000, -0.392972>, <4.160649, 2.400000, -0.397145>, <4.175000, 2.000000, -0.398573>, <4.134133, 2.400000, -0.386162>, <4.146845, 2.000000, -0.392972>, <4.113838, 2.400000, -0.365867>, <4.122976, 2.000000, -0.377024>, <4.107028, 2.000000, -0.353155>, <4.102855, 1.600000, -0.310649>, <4.102855, 1.600000, -0.339351>, 
			<4.113838, 1.600000, -0.284133>, <4.134133, 1.600000, -0.263838>, <4.160649, 1.600000, -0.252855>, <4.189351, 1.600000, -0.252855>, <4.215867, 1.600000, -0.263838>, <4.236162, 1.600000, -0.284133>, <4.247145, 1.600000, -0.310649>, <4.247145, 1.600000, -0.339351>, <4.236162, 1.600000, -0.365867>, <4.215867, 1.600000, -0.386162>, <4.189351, 1.600000, -0.397145>, 
			<4.160649, 1.600000, -0.397145>, <4.134133, 1.600000, -0.386162>, <4.113838, 1.600000, -0.365867>, <4.102855, 18.400000, -0.310649>, <4.102855, 18.400000, -0.339351>, <4.101427, 18.000000, -0.325000>, <4.113838, 18.400000, -0.284133>, <4.107028, 18.000000, -0.296845>, <4.134133, 18.400000, -0.263838>, <4.122976, 18.000000, -0.272976>, <4.160649, 18.400000, -0.252855>, 
			<4.146845, 18.000000, -0.257028>, <4.189351, 18.400000, -0.252855>, <4.175000, 18.000000, -0.251427>, <4.215867, 18.400000, -0.263838>, <4.203155, 18.000000, -0.257028>, <4.236162, 18.400000, -0.284133>, <4.227024, 18.000000, -0.272976>, <4.247145, 18.400000, -0.310649>, <4.242972, 18.000000, -0.296845>, <4.247145, 18.400000, -0.339351>, <4.248573, 18.000000, -0.325000>, 
			<4.236162, 18.400000, -0.365867>, <4.242972, 18.000000, -0.353155>, <4.215867, 18.400000, -0.386162>, <4.227024, 18.000000, -0.377024>, <4.189351, 18.400000, -0.397145>, <4.203155, 18.000000, -0.392972>, <4.160649, 18.400000, -0.397145>, <4.175000, 18.000000, -0.398573>, <4.134133, 18.400000, -0.386162>, <4.146845, 18.000000, -0.392972>, <4.113838, 18.400000, -0.365867>, 
			<4.122976, 18.000000, -0.377024>, <4.107028, 18.000000, -0.353155>, <4.102855, 17.600000, -0.310649>, <4.102855, 17.600000, -0.339351>, <4.113838, 17.600000, -0.284133>, <4.134133, 17.600000, -0.263838>, <4.160649, 17.600000, -0.252855>, <4.189351, 17.600000, -0.252855>, <4.215867, 17.600000, -0.263838>, <4.236162, 17.600000, -0.284133>, <4.247145, 17.600000, -0.310649>, 
			<4.247145, 17.600000, -0.339351>, <4.236162, 17.600000, -0.365867>, <4.215867, 17.600000, -0.386162>, <4.189351, 17.600000, -0.397145>, <4.160649, 17.600000, -0.397145>, <4.134133, 17.600000, -0.386162>, <4.113838, 17.600000, -0.365867>, <4.175000, 2.400000, -0.325000>, <4.175000, 1.600000, -0.325000>, <4.102855, 2.000000, -0.339351>, <4.113838, 2.000000, -0.365867>, 
			<4.134133, 2.000000, -0.386162>, <4.160649, 2.000000, -0.397145>, <4.189351, 2.000000, -0.397145>, <4.215867, 2.000000, -0.386162>, <4.236162, 2.000000, -0.365867>, <4.247145, 2.000000, -0.339351>, <4.247145, 2.000000, -0.310649>, <4.236162, 2.000000, -0.284133>, <4.215867, 2.000000, -0.263838>, <4.189351, 2.000000, -0.252855>, <4.160649, 2.000000, -0.252855>, 
			<4.134133, 2.000000, -0.263838>, <4.113838, 2.000000, -0.284133>, <4.102855, 2.000000, -0.310649>, <4.175000, 18.400000, -0.325000>, <4.175000, 17.600000, -0.325000>, <4.102855, 18.000000, -0.339351>, <4.113838, 18.000000, -0.365867>, <4.134133, 18.000000, -0.386162>, <4.160649, 18.000000, -0.397145>, <4.189351, 18.000000, -0.397145>, <4.215867, 18.000000, -0.386162>, 
			<4.236162, 18.000000, -0.365867>, <4.247145, 18.000000, -0.339351>, <4.247145, 18.000000, -0.310649>, <4.236162, 18.000000, -0.284133>, <4.215867, 18.000000, -0.263838>, <4.189351, 18.000000, -0.252855>, <4.160649, 18.000000, -0.252855>, <4.134133, 18.000000, -0.263838>, <4.113838, 18.000000, -0.284133>, <4.102855, 18.000000, -0.310649>}
	 //#local average_center = <4.175000, 10.000000, -0.325000>;
	 normal_vectors { 708, <-1.000000, -0.000000, 0.000000>, <-0.923880, -0.000000, 0.382683>, <-0.707107, 0.000000, 0.707107>, <-0.382683, 0.000000, 0.923880>, <0.000000, -0.000000, 1.000000>, <0.382683, 0.000000, 0.923880>, <0.707107, 0.000000, 0.707107>, <0.923880, 0.000000, 0.382683>, <1.000000, 0.000000, 0.000000>, <0.923880, 0.000000, -0.382683>, 
			<0.707107, 0.000000, -0.707107>, <0.382683, 0.000000, -0.923880>, <-0.000000, -0.000000, -1.000000>, <-0.382683, -0.000000, -0.923880>, <-0.707107, 0.000000, -0.707107>, <-0.923880, 0.000000, -0.382683>, <-0.999802, 0.000000, 0.019887>, <-0.916086, -0.000000, 0.400981>, <-0.692904, 0.000000, 0.721029>, <-0.364234, 0.000000, 0.931307>, <0.019887, 0.000000, 0.999802>, 
			<0.400981, 0.000000, 0.916086>, <0.721029, 0.000000, 0.692904>, <0.931307, 0.000000, 0.364234>, <0.999802, 0.000000, -0.019887>, <0.916086, 0.000000, -0.400981>, <0.692904, 0.000000, -0.721029>, <0.364234, 0.000000, -0.931307>, <-0.019887, -0.000000, -0.999802>, <-0.400981, -0.000000, -0.916086>, <-0.721029, 0.000000, -0.692904>, <-0.931307, 0.000000, -0.364234>, 
			<0.000000, 1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.980785, 0.000000, -0.195090>, <-0.831470, 0.000000, -0.555570>, <-0.555570, 0.000000, -0.831470>, <-0.195090, 0.000000, -0.980785>, <0.195090, -0.000000, -0.980785>, <0.555570, 0.000000, -0.831470>, <0.831470, -0.000000, -0.555570>, <0.980785, 0.000000, -0.195090>, <0.980785, 0.000000, 0.195090>, 
			<0.831470, 0.000000, 0.555570>, <0.555570, 0.000000, 0.831470>, <0.195090, -0.000000, 0.980785>, <-0.195090, 0.000000, 0.980785>, <-0.555570, 0.000000, 0.831470>, <-0.831470, -0.000000, 0.555570>, <-0.980785, 0.000000, 0.195090>, <0.000000, 1.000000, -0.000000>, <0.000000, -1.000000, -0.000000>, <-0.983408, -0.000000, -0.181408>, <-0.839129, 0.000000, -0.543933>, 
			<-0.567100, 0.000000, -0.823649>, <-0.208735, 0.000000, -0.977972>, <0.181408, -0.000000, -0.983408>, <0.543933, 0.000000, -0.839129>, <0.823649, 0.000000, -0.567100>, <0.977972, 0.000000, -0.208735>, <0.983408, 0.000000, 0.181408>, <0.839129, 0.000000, 0.543933>, <0.567100, 0.000000, 0.823649>, <0.208735, -0.000000, 0.977972>, <-0.181408, 0.000000, 0.983408>, 
			<-0.543933, 0.000000, 0.839129>, <-0.823649, -0.000000, 0.567100>, <-0.977972, 0.000000, 0.208735>, <0.000000, 1.000000, -0.000000>, <0.000000, 1.000000, -0.000000>, <-0.999451, 0.000000, -0.033134>, <-0.999451, 0.000000, -0.033134>, <-0.999451, 0.000000, -0.033134>, <0.000000, 1.000000, -0.000000>, <0.000000, 1.000000, -0.000000>, <-0.936052, 0.000000, 0.351862>, 
			<-0.936052, 0.000000, 0.351862>, <-0.936052, 0.000000, 0.351862>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <-0.730148, 0.000000, 0.683289>, <-0.730148, 0.000000, 0.683289>, <-0.730148, 0.000000, 0.683289>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <-0.413085, 0.000000, 0.910692>, <-0.413085, 0.000000, 0.910692>, 
			<-0.413085, 0.000000, 0.910692>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <-0.033134, 0.000000, 0.999451>, <-0.033134, 0.000000, 0.999451>, <-0.033134, 0.000000, 0.999451>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.351862, 0.000000, 0.936052>, <0.351862, 0.000000, 0.936052>, <0.351862, 0.000000, 0.936052>, 
			<0.000000, 1.000000, -0.000000>, <0.000000, 1.000000, -0.000000>, <0.683289, 0.000000, 0.730148>, <0.683289, 0.000000, 0.730148>, <0.683289, 0.000000, 0.730148>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.910692, 0.000000, 0.413085>, <0.910692, 0.000000, 0.413085>, <0.910692, 0.000000, 0.413085>, <0.000000, 1.000000, -0.000000>, 
			<0.000000, 1.000000, -0.000000>, <0.999451, 0.000000, 0.033134>, <0.999451, 0.000000, 0.033134>, <0.999451, 0.000000, 0.033134>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.936052, 0.000000, -0.351862>, <0.936052, 0.000000, -0.351862>, <0.936052, 0.000000, -0.351862>, <0.000000, 1.000000, -0.000000>, <0.000000, 1.000000, -0.000000>, 
			<0.730148, -0.000000, -0.683289>, <0.730148, -0.000000, -0.683289>, <0.730148, -0.000000, -0.683289>, <0.000000, 1.000000, -0.000000>, <0.000000, 1.000000, -0.000000>, <0.413085, 0.000000, -0.910692>, <0.413085, 0.000000, -0.910692>, <0.413085, 0.000000, -0.910692>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.033134, -0.000000, -0.999451>, 
			<0.033134, -0.000000, -0.999451>, <0.033134, -0.000000, -0.999451>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <-0.351862, -0.000000, -0.936052>, <-0.351862, -0.000000, -0.936052>, <-0.351862, -0.000000, -0.936052>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <-0.683289, 0.000000, -0.730148>, <-0.683289, 0.000000, -0.730148>, 
			<-0.683289, 0.000000, -0.730148>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <-0.910692, 0.000000, -0.413085>, <-0.910692, 0.000000, -0.413085>, <-0.910692, 0.000000, -0.413085>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.999451, 0.000000, 0.033134>, <-0.999451, 0.000000, 0.033134>, <-0.999451, 0.000000, 0.033134>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.910692, -0.000000, 0.413085>, <-0.910692, -0.000000, 0.413085>, <-0.910692, -0.000000, 0.413085>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.683289, 0.000000, 0.730148>, <-0.683289, 0.000000, 0.730148>, <-0.683289, 0.000000, 0.730148>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <-0.351862, 0.000000, 0.936052>, <-0.351862, 0.000000, 0.936052>, <-0.351862, 0.000000, 0.936052>, <0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, -0.000000>, <0.033134, -0.000000, 0.999451>, <0.033134, -0.000000, 0.999451>, <0.033134, -0.000000, 0.999451>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.413085, 0.000000, 0.910692>, <0.413085, 0.000000, 0.910692>, <0.413085, 0.000000, 0.910692>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.730148, 0.000000, 0.683289>, <0.730148, 0.000000, 0.683289>, <0.730148, 0.000000, 0.683289>, <0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, -0.000000>, <0.936052, 0.000000, 0.351862>, 
			<0.936052, 0.000000, 0.351862>, <0.936052, 0.000000, 0.351862>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.999451, 0.000000, -0.033134>, <0.999451, 0.000000, -0.033134>, <0.999451, 0.000000, -0.033134>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.910692, 0.000000, -0.413085>, <0.910692, 0.000000, -0.413085>, 
			<0.910692, 0.000000, -0.413085>, <0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, -0.000000>, <0.683289, 0.000000, -0.730148>, <0.683289, 0.000000, -0.730148>, <0.683289, 0.000000, -0.730148>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.351862, -0.000000, -0.936052>, <0.351862, -0.000000, -0.936052>, <0.351862, -0.000000, -0.936052>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.033134, 0.000000, -0.999451>, <-0.033134, 0.000000, -0.999451>, <-0.033134, 0.000000, -0.999451>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.413085, 0.000000, -0.910692>, <-0.413085, 0.000000, -0.910692>, <-0.413085, 0.000000, -0.910692>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <-0.730148, 0.000000, -0.683289>, <-0.730148, 0.000000, -0.683289>, <-0.730148, 0.000000, -0.683289>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.936052, 0.000000, -0.351862>, <-0.936052, 0.000000, -0.351862>, <-0.936052, 0.000000, -0.351862>, <0.000000, 1.000000, -0.000000>, <0.000000, 1.000000, -0.000000>, 
			<-0.999451, 0.000000, -0.033134>, <-0.999451, 0.000000, -0.033134>, <-0.999451, 0.000000, -0.033134>, <0.000000, 1.000000, -0.000000>, <0.000000, 1.000000, -0.000000>, <-0.936052, 0.000000, 0.351862>, <-0.936052, 0.000000, 0.351862>, <-0.936052, 0.000000, 0.351862>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <-0.730148, 0.000000, 0.683289>, 
			<-0.730148, 0.000000, 0.683289>, <-0.730148, 0.000000, 0.683289>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <-0.413085, 0.000000, 0.910692>, <-0.413085, 0.000000, 0.910692>, <-0.413085, 0.000000, 0.910692>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <-0.033134, 0.000000, 0.999451>, <-0.033134, 0.000000, 0.999451>, 
			<-0.033134, 0.000000, 0.999451>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.351862, 0.000000, 0.936052>, <0.351862, 0.000000, 0.936052>, <0.351862, 0.000000, 0.936052>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.683289, 0.000000, 0.730148>, <0.683289, 0.000000, 0.730148>, <0.683289, 0.000000, 0.730148>, 
			<0.000000, 1.000000, -0.000000>, <0.000000, 1.000000, -0.000000>, <0.910692, 0.000000, 0.413085>, <0.910692, 0.000000, 0.413085>, <0.910692, 0.000000, 0.413085>, <0.000000, 1.000000, -0.000000>, <0.000000, 1.000000, -0.000000>, <0.999451, 0.000000, 0.033134>, <0.999451, 0.000000, 0.033134>, <0.999451, 0.000000, 0.033134>, <0.000000, 1.000000, 0.000000>, 
			<0.000000, 1.000000, 0.000000>, <0.936052, 0.000000, -0.351862>, <0.936052, 0.000000, -0.351862>, <0.936052, 0.000000, -0.351862>, <0.000000, 1.000000, -0.000000>, <0.000000, 1.000000, -0.000000>, <0.730148, -0.000000, -0.683289>, <0.730148, -0.000000, -0.683289>, <0.730148, -0.000000, -0.683289>, <0.000000, 1.000000, -0.000000>, <0.000000, 1.000000, -0.000000>, 
			<0.413085, 0.000000, -0.910692>, <0.413085, 0.000000, -0.910692>, <0.413085, 0.000000, -0.910692>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.033134, -0.000000, -0.999451>, <0.033134, -0.000000, -0.999451>, <0.033134, -0.000000, -0.999451>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <-0.351862, -0.000000, -0.936052>, 
			<-0.351862, -0.000000, -0.936052>, <-0.351862, -0.000000, -0.936052>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <-0.683289, 0.000000, -0.730148>, <-0.683289, 0.000000, -0.730148>, <-0.683289, 0.000000, -0.730148>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <-0.910692, 0.000000, -0.413085>, <-0.910692, 0.000000, -0.413085>, 
			<-0.910692, 0.000000, -0.413085>, <0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, -0.000000>, <-1.000000, -0.000000, 0.000000>, <-1.000000, -0.000000, 0.000000>, <-1.000000, -0.000000, 0.000000>, <-1.000000, -0.000000, 0.000000>, <0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, -0.000000>, <-0.923880, -0.000000, 0.382683>, <-0.923880, -0.000000, 0.382683>, 
			<-0.923880, -0.000000, 0.382683>, <-0.923880, -0.000000, 0.382683>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.707107, 0.000000, 0.707107>, <-0.707107, 0.000000, 0.707107>, <-0.707107, 0.000000, 0.707107>, <-0.707107, 0.000000, 0.707107>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.382683, 0.000000, 0.923880>, 
			<-0.382683, 0.000000, 0.923880>, <-0.382683, 0.000000, 0.923880>, <-0.382683, 0.000000, 0.923880>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.000000, -0.000000, 1.000000>, <-0.000000, -0.000000, 1.000000>, <0.000000, -0.000000, 1.000000>, <0.000000, -0.000000, 1.000000>, <0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, -0.000000>, 
			<0.382683, 0.000000, 0.923880>, <0.382683, 0.000000, 0.923880>, <0.382683, 0.000000, 0.923880>, <0.382683, 0.000000, 0.923880>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.707107, 0.000000, 0.707107>, <0.707107, 0.000000, 0.707107>, <0.707107, 0.000000, 0.707107>, <0.707107, 0.000000, 0.707107>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.923880, 0.000000, 0.382683>, <0.923880, 0.000000, 0.382683>, <0.923880, 0.000000, 0.382683>, <0.923880, 0.000000, 0.382683>, <0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, -0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
			<0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, -0.000000>, <0.923880, 0.000000, -0.382683>, <0.923880, 0.000000, -0.382683>, <0.923880, 0.000000, -0.382683>, <0.923880, 0.000000, -0.382683>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.707107, 0.000000, -0.707107>, <0.707107, 0.000000, -0.707107>, <0.707107, 0.000000, -0.707107>, 
			<0.707107, 0.000000, -0.707107>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.382683, -0.000000, -0.923880>, <0.382683, -0.000000, -0.923880>, <0.382683, -0.000000, -0.923880>, <0.382683, -0.000000, -0.923880>, <0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, -0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, 
			<0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.382683, 0.000000, -0.923880>, <-0.382683, 0.000000, -0.923880>, <-0.382683, 0.000000, -0.923880>, <-0.382683, 0.000000, -0.923880>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.707107, 0.000000, -0.707107>, 
			<-0.707107, 0.000000, -0.707107>, <-0.707107, 0.000000, -0.707107>, <-0.707107, 0.000000, -0.707107>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.923880, 0.000000, -0.382683>, <-0.923880, 0.000000, -0.382683>, <-0.923880, 0.000000, -0.382683>, <-0.923880, 0.000000, -0.382683>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, 
			<-0.986606, 0.000000, 0.163120>, <-0.986606, 0.000000, 0.163120>, <-0.986606, 0.000000, 0.163120>, <0.000000, 1.000000, -0.000000>, <0.000000, 1.000000, -0.000000>, <-0.973929, 0.000000, -0.226855>, <-0.973929, 0.000000, -0.226855>, <-0.973929, 0.000000, -0.226855>, <0.000000, 1.000000, -0.000000>, <0.000000, 1.000000, -0.000000>, <-0.849082, 0.000000, 0.528261>, 
			<-0.849082, 0.000000, 0.528261>, <-0.849082, 0.000000, 0.528261>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <-0.582293, 0.000000, 0.812979>, <-0.582293, 0.000000, 0.812979>, <-0.582293, 0.000000, 0.812979>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <-0.226855, 0.000000, 0.973929>, <-0.226855, 0.000000, 0.973929>, 
			<-0.226855, 0.000000, 0.973929>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.163120, 0.000000, 0.986606>, <0.163120, 0.000000, 0.986606>, <0.163120, 0.000000, 0.986606>, <0.000000, 1.000000, -0.000000>, <0.000000, 1.000000, -0.000000>, <0.528261, 0.000000, 0.849082>, <0.528261, 0.000000, 0.849082>, <0.528261, 0.000000, 0.849082>, 
			<0.000000, 1.000000, -0.000000>, <0.000000, 1.000000, -0.000000>, <0.812979, 0.000000, 0.582293>, <0.812979, 0.000000, 0.582293>, <0.812979, 0.000000, 0.582293>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.973929, 0.000000, 0.226855>, <0.973929, 0.000000, 0.226855>, <0.973929, 0.000000, 0.226855>, <0.000000, 1.000000, -0.000000>, 
			<0.000000, 1.000000, -0.000000>, <0.986606, 0.000000, -0.163120>, <0.986606, 0.000000, -0.163120>, <0.986606, 0.000000, -0.163120>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.849082, -0.000000, -0.528261>, <0.849082, -0.000000, -0.528261>, <0.849082, -0.000000, -0.528261>, <0.000000, 1.000000, -0.000000>, <0.000000, 1.000000, -0.000000>, 
			<0.582293, 0.000000, -0.812979>, <0.582293, 0.000000, -0.812979>, <0.582293, 0.000000, -0.812979>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.226855, 0.000000, -0.973929>, <0.226855, 0.000000, -0.973929>, <0.226855, 0.000000, -0.973929>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <-0.163120, 0.000000, -0.986606>, 
			<-0.163120, 0.000000, -0.986606>, <-0.163120, 0.000000, -0.986606>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <-0.528261, -0.000000, -0.849082>, <-0.528261, -0.000000, -0.849082>, <-0.528261, -0.000000, -0.849082>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <-0.812979, 0.000000, -0.582293>, <-0.812979, 0.000000, -0.582293>, 
			<-0.812979, 0.000000, -0.582293>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.973929, -0.000000, 0.226855>, <-0.973929, -0.000000, 0.226855>, <-0.973929, -0.000000, 0.226855>, <0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, -0.000000>, <-0.986606, -0.000000, -0.163120>, <-0.986606, -0.000000, -0.163120>, <-0.986606, -0.000000, -0.163120>, 
			<0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, -0.000000>, <-0.812979, 0.000000, 0.582293>, <-0.812979, 0.000000, 0.582293>, <-0.812979, 0.000000, 0.582293>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.528261, 0.000000, 0.849082>, <-0.528261, 0.000000, 0.849082>, <-0.528261, 0.000000, 0.849082>, <0.000000, -1.000000, -0.000000>, 
			<0.000000, -1.000000, -0.000000>, <-0.163120, -0.000000, 0.986606>, <-0.163120, -0.000000, 0.986606>, <-0.163120, -0.000000, 0.986606>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.226855, 0.000000, 0.973929>, <0.226855, 0.000000, 0.973929>, <0.226855, 0.000000, 0.973929>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.582293, 0.000000, 0.812979>, <0.582293, 0.000000, 0.812979>, <0.582293, 0.000000, 0.812979>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.849082, 0.000000, 0.528261>, <0.849082, 0.000000, 0.528261>, <0.849082, 0.000000, 0.528261>, <0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, -0.000000>, <0.986606, 0.000000, 0.163120>, 
			<0.986606, 0.000000, 0.163120>, <0.986606, 0.000000, 0.163120>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.973929, 0.000000, -0.226855>, <0.973929, 0.000000, -0.226855>, <0.973929, 0.000000, -0.226855>, <0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, -0.000000>, <0.812979, 0.000000, -0.582293>, <0.812979, 0.000000, -0.582293>, 
			<0.812979, 0.000000, -0.582293>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.528261, -0.000000, -0.849082>, <0.528261, -0.000000, -0.849082>, <0.528261, -0.000000, -0.849082>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.163120, 0.000000, -0.986606>, <0.163120, 0.000000, -0.986606>, <0.163120, 0.000000, -0.986606>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.226855, 0.000000, -0.973929>, <-0.226855, 0.000000, -0.973929>, <-0.226855, 0.000000, -0.973929>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.582293, 0.000000, -0.812979>, <-0.582293, 0.000000, -0.812979>, <-0.582293, 0.000000, -0.812979>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <-0.849082, 0.000000, -0.528261>, <-0.849082, 0.000000, -0.528261>, <-0.849082, 0.000000, -0.528261>, <0.000000, 1.000000, -0.000000>, <0.000000, 1.000000, -0.000000>, <-0.986606, 0.000000, 0.163120>, <-0.986606, 0.000000, 0.163120>, <-0.986606, 0.000000, 0.163120>, <0.000000, 1.000000, -0.000000>, <0.000000, 1.000000, -0.000000>, 
			<-0.973929, 0.000000, -0.226855>, <-0.973929, 0.000000, -0.226855>, <-0.973929, 0.000000, -0.226855>, <0.000000, 1.000000, -0.000000>, <0.000000, 1.000000, -0.000000>, <-0.849082, 0.000000, 0.528261>, <-0.849082, 0.000000, 0.528261>, <-0.849082, 0.000000, 0.528261>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <-0.582293, 0.000000, 0.812979>, 
			<-0.582293, 0.000000, 0.812979>, <-0.582293, 0.000000, 0.812979>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <-0.226855, 0.000000, 0.973929>, <-0.226855, 0.000000, 0.973929>, <-0.226855, 0.000000, 0.973929>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.163120, 0.000000, 0.986606>, <0.163120, 0.000000, 0.986606>, 
			<0.163120, 0.000000, 0.986606>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.528261, 0.000000, 0.849082>, <0.528261, 0.000000, 0.849082>, <0.528261, 0.000000, 0.849082>, <0.000000, 1.000000, -0.000000>, <0.000000, 1.000000, -0.000000>, <0.812979, 0.000000, 0.582293>, <0.812979, 0.000000, 0.582293>, <0.812979, 0.000000, 0.582293>, 
			<0.000000, 1.000000, -0.000000>, <0.000000, 1.000000, -0.000000>, <0.973929, 0.000000, 0.226855>, <0.973929, 0.000000, 0.226855>, <0.973929, 0.000000, 0.226855>, <0.000000, 1.000000, -0.000000>, <0.000000, 1.000000, -0.000000>, <0.986606, 0.000000, -0.163120>, <0.986606, 0.000000, -0.163120>, <0.986606, 0.000000, -0.163120>, <0.000000, 1.000000, 0.000000>, 
			<0.000000, 1.000000, 0.000000>, <0.849082, -0.000000, -0.528261>, <0.849082, -0.000000, -0.528261>, <0.849082, -0.000000, -0.528261>, <0.000000, 1.000000, -0.000000>, <0.000000, 1.000000, -0.000000>, <0.582293, 0.000000, -0.812979>, <0.582293, 0.000000, -0.812979>, <0.582293, 0.000000, -0.812979>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, 
			<0.226855, 0.000000, -0.973929>, <0.226855, 0.000000, -0.973929>, <0.226855, 0.000000, -0.973929>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <-0.163120, 0.000000, -0.986606>, <-0.163120, 0.000000, -0.986606>, <-0.163120, 0.000000, -0.986606>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <-0.528261, -0.000000, -0.849082>, 
			<-0.528261, -0.000000, -0.849082>, <-0.528261, -0.000000, -0.849082>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <-0.812979, 0.000000, -0.582293>, <-0.812979, 0.000000, -0.582293>, <-0.812979, 0.000000, -0.582293>, <0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, -0.000000>, <-0.980785, 0.000000, 0.195090>, <-0.980785, 0.000000, 0.195090>, 
			<0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, -0.000000>, <-0.980785, -0.000000, -0.195090>, <-0.980785, -0.000000, -0.195090>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.831470, 0.000000, 0.555570>, <-0.831470, 0.000000, 0.555570>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.555570, 0.000000, 0.831470>, 
			<-0.555570, 0.000000, 0.831470>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.195090, 0.000000, 0.980785>, <-0.195090, 0.000000, 0.980785>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.195090, 0.000000, 0.980785>, <0.195090, 0.000000, 0.980785>, <0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, -0.000000>, 
			<0.555570, 0.000000, 0.831470>, <0.555570, 0.000000, 0.831470>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.831470, 0.000000, 0.555570>, <0.831470, 0.000000, 0.555570>, <0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, -0.000000>, <0.980785, 0.000000, 0.195090>, <0.980785, 0.000000, 0.195090>, <0.000000, -1.000000, -0.000000>, 
			<0.000000, -1.000000, -0.000000>, <0.980785, 0.000000, -0.195090>, <0.980785, 0.000000, -0.195090>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.831470, 0.000000, -0.555570>, <0.831470, 0.000000, -0.555570>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.555570, 0.000000, -0.831470>, <0.555570, 0.000000, -0.831470>, 
			<0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, -0.000000>, <0.195090, 0.000000, -0.980785>, <0.195090, 0.000000, -0.980785>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.195090, 0.000000, -0.980785>, <-0.195090, 0.000000, -0.980785>, <0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, -0.000000>, <-0.555570, 0.000000, -0.831470>, 
			<-0.555570, 0.000000, -0.831470>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.831470, 0.000000, -0.555570>, <-0.831470, 0.000000, -0.555570>}
	 texture_list { 1, texture{wm_Hinges}}
	 face_indices { 384, <1, 67, 160>, 0, <1, 160, 64>, 0, <64, 160, 0>, 0, <160, 65, 0>, 0, <65, 160, 15>, 0, <160, 93, 15>, 0, <14, 93, 160>, 0, <160, 91, 14>, 0, <13, 91, 160>, 0, <160, 89, 13>, 0, 
			<12, 89, 160>, 0, <12, 160, 87>, 0, <11, 87, 160>, 0, <11, 160, 85>, 0, <10, 85, 160>, 0, <10, 160, 83>, 0, <9, 83, 160>, 0, <9, 160, 81>, 0, <8, 81, 160>, 0, <8, 160, 79>, 0, <7, 79, 160>, 0, 
			<7, 160, 77>, 0, <6, 77, 160>, 0, <6, 160, 75>, 0, <5, 75, 160>, 0, <5, 160, 73>, 0, <4, 73, 160>, 0, <4, 160, 71>, 0, <3, 71, 160>, 0, <3, 160, 69>, 0, <2, 69, 160>, 0, <2, 160, 67>, 0, 
			<16, 97, 161>, 0, <16, 161, 96>, 0, <17, 96, 161>, 0, <17, 161, 98>, 0, <18, 98, 161>, 0, <18, 161, 99>, 0, <19, 99, 161>, 0, <19, 161, 100>, 0, <20, 100, 161>, 0, <20, 161, 101>, 0, <21, 101, 161>, 0, 
			<21, 161, 102>, 0, <22, 102, 161>, 0, <22, 161, 103>, 0, <23, 103, 161>, 0, <23, 161, 104>, 0, <104, 161, 24>, 0, <161, 105, 24>, 0, <105, 161, 25>, 0, <161, 106, 25>, 0, <106, 161, 26>, 0, <161, 107, 26>, 0, 
			<107, 161, 27>, 0, <161, 108, 27>, 0, <28, 108, 161>, 0, <28, 161, 109>, 0, <161, 110, 29>, 0, <29, 109, 161>, 0, <161, 111, 30>, 0, <30, 110, 161>, 0, <31, 111, 161>, 0, <31, 161, 97>, 0, <95, 162, 65>, 0, 
			<65, 15, 95>, 0, <162, 66, 0>, 0, <0, 65, 162>, 0, <66, 162, 97>, 0, <66, 97, 16>, 0, <31, 97, 162>, 0, <162, 95, 31>, 0, <94, 163, 93>, 0, <93, 14, 94>, 0, <163, 95, 15>, 0, <15, 93, 163>, 0, 
			<95, 163, 111>, 0, <95, 111, 31>, 0, <30, 111, 163>, 0, <163, 94, 30>, 0, <92, 164, 91>, 0, <91, 13, 92>, 0, <164, 94, 14>, 0, <14, 91, 164>, 0, <94, 164, 110>, 0, <94, 110, 30>, 0, <29, 110, 164>, 0, 
			<164, 92, 29>, 0, <90, 165, 89>, 0, <89, 12, 90>, 0, <165, 92, 13>, 0, <13, 89, 165>, 0, <92, 165, 109>, 0, <92, 109, 29>, 0, <28, 109, 165>, 0, <165, 90, 28>, 0, <88, 166, 87>, 0, <87, 11, 88>, 0, 
			<166, 90, 12>, 0, <12, 87, 166>, 0, <90, 166, 108>, 0, <90, 108, 28>, 0, <27, 108, 166>, 0, <166, 88, 27>, 0, <86, 167, 85>, 0, <85, 10, 86>, 0, <167, 88, 11>, 0, <11, 85, 167>, 0, <88, 167, 107>, 0, 
			<88, 107, 27>, 0, <26, 107, 167>, 0, <167, 86, 26>, 0, <84, 168, 83>, 0, <83, 9, 84>, 0, <168, 86, 10>, 0, <10, 83, 168>, 0, <86, 168, 106>, 0, <86, 106, 26>, 0, <25, 106, 168>, 0, <168, 84, 25>, 0, 
			<82, 169, 81>, 0, <81, 8, 82>, 0, <169, 84, 9>, 0, <9, 81, 169>, 0, <84, 169, 105>, 0, <84, 105, 25>, 0, <24, 105, 169>, 0, <169, 82, 24>, 0, <80, 170, 79>, 0, <79, 7, 80>, 0, <170, 82, 8>, 0, 
			<8, 79, 170>, 0, <82, 170, 104>, 0, <82, 104, 24>, 0, <23, 104, 170>, 0, <170, 80, 23>, 0, <78, 171, 77>, 0, <77, 6, 78>, 0, <171, 80, 7>, 0, <7, 77, 171>, 0, <80, 171, 103>, 0, <80, 103, 23>, 0, 
			<22, 103, 171>, 0, <171, 78, 22>, 0, <76, 172, 75>, 0, <75, 5, 76>, 0, <172, 78, 6>, 0, <6, 75, 172>, 0, <78, 172, 102>, 0, <78, 102, 22>, 0, <21, 102, 172>, 0, <172, 76, 21>, 0, <74, 173, 73>, 0, 
			<73, 4, 74>, 0, <173, 76, 5>, 0, <5, 73, 173>, 0, <76, 173, 101>, 0, <76, 101, 21>, 0, <20, 101, 173>, 0, <173, 74, 20>, 0, <72, 174, 71>, 0, <71, 3, 72>, 0, <174, 74, 4>, 0, <4, 71, 174>, 0, 
			<74, 174, 100>, 0, <74, 100, 20>, 0, <19, 100, 174>, 0, <174, 72, 19>, 0, <70, 175, 69>, 0, <69, 2, 70>, 0, <175, 72, 3>, 0, <3, 69, 175>, 0, <72, 175, 99>, 0, <72, 99, 19>, 0, <18, 99, 175>, 0, 
			<175, 70, 18>, 0, <68, 176, 67>, 0, <67, 1, 68>, 0, <176, 70, 2>, 0, <2, 67, 176>, 0, <70, 176, 98>, 0, <70, 98, 18>, 0, <17, 98, 176>, 0, <176, 68, 17>, 0, <66, 177, 64>, 0, <64, 0, 66>, 0, 
			<177, 68, 1>, 0, <1, 64, 177>, 0, <68, 177, 96>, 0, <68, 96, 17>, 0, <16, 96, 177>, 0, <177, 66, 16>, 0, <33, 115, 178>, 0, <33, 178, 112>, 0, <112, 178, 32>, 0, <178, 113, 32>, 0, <113, 178, 47>, 0, 
			<178, 141, 47>, 0, <46, 141, 178>, 0, <178, 139, 46>, 0, <45, 139, 178>, 0, <178, 137, 45>, 0, <44, 137, 178>, 0, <44, 178, 135>, 0, <43, 135, 178>, 0, <43, 178, 133>, 0, <42, 133, 178>, 0, <42, 178, 131>, 0, 
			<41, 131, 178>, 0, <41, 178, 129>, 0, <40, 129, 178>, 0, <40, 178, 127>, 0, <39, 127, 178>, 0, <39, 178, 125>, 0, <38, 125, 178>, 0, <38, 178, 123>, 0, <37, 123, 178>, 0, <37, 178, 121>, 0, <36, 121, 178>, 0, 
			<36, 178, 119>, 0, <35, 119, 178>, 0, <35, 178, 117>, 0, <34, 117, 178>, 0, <34, 178, 115>, 0, <48, 145, 179>, 0, <48, 179, 144>, 0, <49, 144, 179>, 0, <49, 179, 146>, 0, <50, 146, 179>, 0, <50, 179, 147>, 0, 
			<51, 147, 179>, 0, <51, 179, 148>, 0, <52, 148, 179>, 0, <52, 179, 149>, 0, <53, 149, 179>, 0, <53, 179, 150>, 0, <54, 150, 179>, 0, <54, 179, 151>, 0, <55, 151, 179>, 0, <55, 179, 152>, 0, <152, 179, 56>, 0, 
			<179, 153, 56>, 0, <153, 179, 57>, 0, <179, 154, 57>, 0, <154, 179, 58>, 0, <179, 155, 58>, 0, <155, 179, 59>, 0, <179, 156, 59>, 0, <60, 156, 179>, 0, <60, 179, 157>, 0, <179, 158, 61>, 0, <61, 157, 179>, 0, 
			<179, 159, 62>, 0, <62, 158, 179>, 0, <63, 159, 179>, 0, <63, 179, 145>, 0, <143, 180, 113>, 0, <113, 47, 143>, 0, <180, 114, 32>, 0, <32, 113, 180>, 0, <180, 145, 48>, 0, <48, 114, 180>, 0, <63, 145, 180>, 0, 
			<180, 143, 63>, 0, <142, 181, 141>, 0, <141, 46, 142>, 0, <181, 143, 47>, 0, <47, 141, 181>, 0, <181, 159, 63>, 0, <63, 143, 181>, 0, <62, 159, 181>, 0, <181, 142, 62>, 0, <140, 182, 139>, 0, <139, 45, 140>, 0, 
			<182, 142, 46>, 0, <46, 139, 182>, 0, <182, 158, 62>, 0, <62, 142, 182>, 0, <61, 158, 182>, 0, <182, 140, 61>, 0, <138, 183, 137>, 0, <137, 44, 138>, 0, <183, 140, 45>, 0, <45, 137, 183>, 0, <183, 157, 61>, 0, 
			<61, 140, 183>, 0, <60, 157, 183>, 0, <183, 138, 60>, 0, <136, 184, 135>, 0, <135, 43, 136>, 0, <184, 138, 44>, 0, <44, 135, 184>, 0, <184, 156, 60>, 0, <60, 138, 184>, 0, <59, 156, 184>, 0, <184, 136, 59>, 0, 
			<134, 185, 133>, 0, <133, 42, 134>, 0, <185, 136, 43>, 0, <43, 133, 185>, 0, <185, 155, 59>, 0, <59, 136, 185>, 0, <58, 155, 185>, 0, <185, 134, 58>, 0, <132, 186, 131>, 0, <131, 41, 132>, 0, <186, 134, 42>, 0, 
			<42, 131, 186>, 0, <186, 154, 58>, 0, <58, 134, 186>, 0, <57, 154, 186>, 0, <186, 132, 57>, 0, <130, 187, 129>, 0, <129, 40, 130>, 0, <187, 132, 41>, 0, <41, 129, 187>, 0, <187, 153, 57>, 0, <57, 132, 187>, 0, 
			<56, 153, 187>, 0, <187, 130, 56>, 0, <128, 188, 127>, 0, <127, 39, 128>, 0, <188, 130, 40>, 0, <40, 127, 188>, 0, <188, 152, 56>, 0, <56, 130, 188>, 0, <55, 152, 188>, 0, <188, 128, 55>, 0, <126, 189, 125>, 0, 
			<125, 38, 126>, 0, <189, 128, 39>, 0, <39, 125, 189>, 0, <189, 151, 55>, 0, <55, 128, 189>, 0, <54, 151, 189>, 0, <189, 126, 54>, 0, <124, 190, 123>, 0, <123, 37, 124>, 0, <190, 126, 38>, 0, <38, 123, 190>, 0, 
			<190, 150, 54>, 0, <54, 126, 190>, 0, <53, 150, 190>, 0, <190, 124, 53>, 0, <122, 191, 121>, 0, <121, 36, 122>, 0, <191, 124, 37>, 0, <37, 121, 191>, 0, <191, 149, 53>, 0, <53, 124, 191>, 0, <52, 149, 191>, 0, 
			<191, 122, 52>, 0, <120, 192, 119>, 0, <119, 35, 120>, 0, <192, 122, 36>, 0, <36, 119, 192>, 0, <192, 148, 52>, 0, <52, 122, 192>, 0, <51, 148, 192>, 0, <192, 120, 51>, 0, <118, 193, 117>, 0, <117, 34, 118>, 0, 
			<193, 120, 35>, 0, <35, 117, 193>, 0, <193, 147, 51>, 0, <51, 120, 193>, 0, <50, 147, 193>, 0, <193, 118, 50>, 0, <116, 194, 115>, 0, <115, 33, 116>, 0, <194, 118, 34>, 0, <34, 115, 194>, 0, <194, 146, 50>, 0, 
			<50, 118, 194>, 0, <49, 146, 194>, 0, <194, 116, 49>, 0, <114, 195, 112>, 0, <112, 32, 114>, 0, <195, 116, 33>, 0, <33, 112, 195>, 0, <195, 144, 49>, 0, <49, 116, 195>, 0, <48, 144, 195>, 0, <195, 114, 48>, 0}
	 normal_indices { 384, <73, 414, 32>, <74, 32, 404>, <405, 32, 68>, <32, 409, 69>, <410, 32, 143>, <32, 479, 144>, <138, 480, 32>, <32, 474, 139>, <133, 475, 32>, <32, 469, 134>, 
			<128, 470, 32>, <129, 32, 464>, <123, 465, 32>, <124, 32, 459>, <118, 460, 32>, <119, 32, 454>, <113, 455, 32>, <114, 32, 449>, <108, 450, 32>, <109, 32, 444>, <103, 445, 32>, 
			<104, 32, 439>, <98, 440, 32>, <99, 32, 434>, <93, 435, 32>, <94, 32, 429>, <88, 430, 32>, <89, 32, 424>, <83, 425, 32>, <84, 32, 419>, <78, 420, 32>, <79, 32, 415>, 
			<148, 489, 33>, <149, 33, 484>, <153, 485, 33>, <154, 33, 494>, <158, 495, 33>, <159, 33, 499>, <163, 500, 33>, <164, 33, 504>, <168, 505, 33>, <169, 33, 509>, <173, 510, 33>, 
			<174, 33, 514>, <178, 515, 33>, <179, 33, 519>, <183, 520, 33>, <184, 33, 524>, <525, 33, 188>, <33, 529, 189>, <530, 33, 193>, <33, 534, 194>, <535, 33, 198>, <33, 539, 199>, 
			<540, 33, 203>, <33, 544, 204>, <208, 545, 33>, <209, 33, 549>, <33, 554, 213>, <214, 550, 33>, <33, 559, 218>, <219, 555, 33>, <223, 560, 33>, <224, 33, 490>, <15, 34, 411>, 
			<412, 145, 15>, <34, 0, 70>, <71, 413, 34>, <0, 34, 491>, <0, 492, 150>, <225, 493, 34>, <34, 15, 226>, <14, 35, 481>, <482, 140, 14>, <35, 15, 146>, <147, 483, 35>, 
			<15, 35, 561>, <15, 562, 227>, <220, 563, 35>, <35, 14, 221>, <13, 36, 476>, <477, 135, 13>, <36, 14, 141>, <142, 478, 36>, <14, 36, 556>, <14, 557, 222>, <215, 558, 36>, 
			<36, 13, 216>, <12, 37, 471>, <472, 130, 12>, <37, 13, 136>, <137, 473, 37>, <13, 37, 551>, <13, 552, 217>, <210, 553, 37>, <37, 12, 211>, <11, 38, 466>, <467, 125, 11>, 
			<38, 12, 131>, <132, 468, 38>, <12, 38, 546>, <12, 547, 212>, <205, 548, 38>, <38, 11, 206>, <10, 39, 461>, <462, 120, 10>, <39, 11, 126>, <127, 463, 39>, <11, 39, 541>, 
			<11, 542, 207>, <200, 543, 39>, <39, 10, 201>, <9, 40, 456>, <457, 115, 9>, <40, 10, 121>, <122, 458, 40>, <10, 40, 536>, <10, 537, 202>, <195, 538, 40>, <40, 9, 196>, 
			<8, 41, 451>, <452, 110, 8>, <41, 9, 116>, <117, 453, 41>, <9, 41, 531>, <9, 532, 197>, <190, 533, 41>, <41, 8, 191>, <7, 42, 446>, <447, 105, 7>, <42, 8, 111>, 
			<112, 448, 42>, <8, 42, 526>, <8, 527, 192>, <185, 528, 42>, <42, 7, 186>, <6, 43, 441>, <442, 100, 6>, <43, 7, 106>, <107, 443, 43>, <7, 43, 521>, <7, 522, 187>, 
			<180, 523, 43>, <43, 6, 181>, <5, 44, 436>, <437, 95, 5>, <44, 6, 101>, <102, 438, 44>, <6, 44, 516>, <6, 517, 182>, <175, 518, 44>, <44, 5, 176>, <4, 45, 431>, 
			<432, 90, 4>, <45, 5, 96>, <97, 433, 45>, <5, 45, 511>, <5, 512, 177>, <170, 513, 45>, <45, 4, 171>, <3, 46, 426>, <427, 85, 3>, <46, 4, 91>, <92, 428, 46>, 
			<4, 46, 506>, <4, 507, 172>, <165, 508, 46>, <46, 3, 166>, <2, 47, 421>, <422, 80, 2>, <47, 3, 86>, <87, 423, 47>, <3, 47, 501>, <3, 502, 167>, <160, 503, 47>, 
			<47, 2, 161>, <1, 48, 416>, <417, 75, 1>, <48, 2, 81>, <82, 418, 48>, <2, 48, 496>, <2, 497, 162>, <155, 498, 48>, <48, 1, 156>, <0, 49, 406>, <407, 72, 0>, 
			<49, 1, 76>, <77, 408, 49>, <1, 49, 486>, <1, 487, 157>, <151, 488, 49>, <49, 0, 152>, <233, 574, 50>, <234, 50, 564>, <565, 50, 228>, <50, 569, 229>, <570, 50, 303>, 
			<50, 639, 304>, <298, 640, 50>, <50, 634, 299>, <293, 635, 50>, <50, 629, 294>, <288, 630, 50>, <289, 50, 624>, <283, 625, 50>, <284, 50, 619>, <278, 620, 50>, <279, 50, 614>, 
			<273, 615, 50>, <274, 50, 609>, <268, 610, 50>, <269, 50, 604>, <263, 605, 50>, <264, 50, 599>, <258, 600, 50>, <259, 50, 594>, <253, 595, 50>, <254, 50, 589>, <248, 590, 50>, 
			<249, 50, 584>, <243, 585, 50>, <244, 50, 579>, <238, 580, 50>, <239, 50, 575>, <308, 648, 51>, <309, 51, 644>, <314, 645, 51>, <315, 51, 652>, <320, 653, 51>, <321, 51, 656>, 
			<326, 657, 51>, <327, 51, 660>, <332, 661, 51>, <333, 51, 664>, <338, 665, 51>, <339, 51, 668>, <344, 669, 51>, <345, 51, 672>, <350, 673, 51>, <351, 51, 676>, <677, 51, 356>, 
			<51, 680, 357>, <681, 51, 362>, <51, 684, 363>, <685, 51, 368>, <51, 688, 369>, <689, 51, 374>, <51, 692, 375>, <380, 693, 51>, <381, 51, 696>, <51, 700, 386>, <387, 697, 51>, 
			<51, 704, 392>, <393, 701, 51>, <398, 705, 51>, <399, 51, 649>, <31, 52, 571>, <572, 305, 31>, <52, 16, 230>, <231, 573, 52>, <52, 650, 310>, <311, 16, 52>, <400, 651, 52>, 
			<52, 31, 401>, <30, 53, 641>, <642, 300, 30>, <53, 31, 306>, <307, 643, 53>, <53, 706, 402>, <403, 31, 53>, <394, 707, 53>, <53, 30, 395>, <29, 54, 636>, <637, 295, 29>, 
			<54, 30, 301>, <302, 638, 54>, <54, 702, 396>, <397, 30, 54>, <388, 703, 54>, <54, 29, 389>, <28, 55, 631>, <632, 290, 28>, <55, 29, 296>, <297, 633, 55>, <55, 698, 390>, 
			<391, 29, 55>, <382, 699, 55>, <55, 28, 383>, <27, 56, 626>, <627, 285, 27>, <56, 28, 291>, <292, 628, 56>, <56, 694, 384>, <385, 28, 56>, <376, 695, 56>, <56, 27, 377>, 
			<26, 57, 621>, <622, 280, 26>, <57, 27, 286>, <287, 623, 57>, <57, 690, 378>, <379, 27, 57>, <370, 691, 57>, <57, 26, 371>, <25, 58, 616>, <617, 275, 25>, <58, 26, 281>, 
			<282, 618, 58>, <58, 686, 372>, <373, 26, 58>, <364, 687, 58>, <58, 25, 365>, <24, 59, 611>, <612, 270, 24>, <59, 25, 276>, <277, 613, 59>, <59, 682, 366>, <367, 25, 59>, 
			<358, 683, 59>, <59, 24, 359>, <23, 60, 606>, <607, 265, 23>, <60, 24, 271>, <272, 608, 60>, <60, 678, 360>, <361, 24, 60>, <352, 679, 60>, <60, 23, 353>, <22, 61, 601>, 
			<602, 260, 22>, <61, 23, 266>, <267, 603, 61>, <61, 674, 354>, <355, 23, 61>, <346, 675, 61>, <61, 22, 347>, <21, 62, 596>, <597, 255, 21>, <62, 22, 261>, <262, 598, 62>, 
			<62, 670, 348>, <349, 22, 62>, <340, 671, 62>, <62, 21, 341>, <20, 63, 591>, <592, 250, 20>, <63, 21, 256>, <257, 593, 63>, <63, 666, 342>, <343, 21, 63>, <334, 667, 63>, 
			<63, 20, 335>, <19, 64, 586>, <587, 245, 19>, <64, 20, 251>, <252, 588, 64>, <64, 662, 336>, <337, 20, 64>, <328, 663, 64>, <64, 19, 329>, <18, 65, 581>, <582, 240, 18>, 
			<65, 19, 246>, <247, 583, 65>, <65, 658, 330>, <331, 19, 65>, <322, 659, 65>, <65, 18, 323>, <17, 66, 576>, <577, 235, 17>, <66, 18, 241>, <242, 578, 66>, <66, 654, 324>, 
			<325, 18, 66>, <316, 655, 66>, <66, 17, 317>, <16, 67, 566>, <567, 232, 16>, <67, 17, 236>, <237, 568, 67>, <67, 646, 318>, <319, 17, 67>, <312, 647, 67>, <67, 16, 313>}
}
#declare wo_1_Walls = mesh2{
	 vertex_vectors { 282, <15.000000, 0.000000, 1.000000>, <15.000000, 20.500000, 1.000000>, <4.500000, 20.500000, 1.000000>, <4.500000, 0.000000, 1.000000>, <15.000000, 0.000000, 0.000000>, <15.000000, 20.500000, 0.000000>, <4.500000, 20.500000, 0.000000>, <4.500000, 0.000000, 0.000000>, <15.000000, 26.000000, 1.000000>, <15.000000, 26.000000, 0.000000>, 
			<-4.500000, 20.500000, 1.000000>, <-4.500000, 20.500000, 0.000000>, <-30.000000, 26.000000, 0.000000>, <-30.000000, 26.000000, 1.000000>, <-30.000000, 20.500000, 1.000000>, <-30.000000, 20.500000, 0.000000>, <-30.000000, 0.000000, 0.000000>, <-30.000000, 0.000000, 1.000000>, <-4.500000, 0.000000, 1.000000>, <-4.500000, 0.000000, 0.000000>, <-30.000000, 27.000000, 1.000000>, 
			<-30.000000, 27.000000, 0.000000>, <15.000000, 27.000000, 0.000000>, <15.000000, 27.000000, 1.000000>, <16.000000, 20.500000, 1.000000>, <16.000000, 20.500000, 0.000000>, <16.000000, 26.000000, 1.000000>, <16.000000, 26.000000, 0.000000>, <16.000000, 27.000000, 1.000000>, <16.000000, 27.000000, 0.000000>, <16.000000, 0.000000, 0.000000>, <16.000000, 0.000000, 1.000000>, 
			<-31.000000, 26.000000, 0.000000>, <-31.000000, 26.000000, 1.000000>, <-31.000000, 20.500000, 1.000000>, <-31.000000, 20.500000, 0.000000>, <-31.000000, 27.000000, 0.000000>, <-31.000000, 27.000000, 1.000000>, <-31.000000, 0.000000, 1.000000>, <-31.000000, 0.000000, 0.000000>, <15.000000, 20.500000, -40.000000>, <15.000000, 26.000000, -40.000000>, <-30.000000, 26.000000, -40.000000>, 
			<-30.000000, 20.500000, -40.000000>, <-30.000000, 27.000000, -40.000000>, <15.000000, 27.000000, -40.000000>, <16.000000, 20.500000, -40.000000>, <16.000000, 26.000000, -40.000000>, <-31.000000, 26.000000, -40.000000>, <-31.000000, 20.500000, -40.000000>, <-31.000000, 0.000000, -40.000000>, <-30.000000, 0.000000, -40.000000>, <15.000000, 0.000000, -40.000000>, <16.000000, 0.000000, -40.000000>, 
			<-31.000000, 27.000000, -40.000000>, <16.000000, 27.000000, -40.000000>, <15.000000, 20.500000, -41.000000>, <15.000000, 26.000000, -41.000000>, <-30.000000, 26.000000, -41.000000>, <-30.000000, 20.500000, -41.000000>, <-30.000000, 27.000000, -41.000000>, <15.000000, 27.000000, -41.000000>, <16.000000, 20.500000, -41.000000>, <16.000000, 26.000000, -41.000000>, <-31.000000, 26.000000, -41.000000>, 
			<-31.000000, 20.500000, -41.000000>, <-31.000000, 27.000000, -41.000000>, <15.000000, 0.000000, -41.000000>, <16.000000, 0.000000, -41.000000>, <16.000000, 27.000000, -41.000000>, <-31.000000, 0.000000, -41.000000>, <-30.000000, 0.000000, -41.000000>, <15.000000, 10.250000, 1.000000>, <9.750000, 0.000000, 1.000000>, <15.000000, 0.000000, 0.500000>, <9.750000, 20.500000, 1.000000>, 
			<15.500000, 20.500000, 1.000000>, <4.500000, 10.250000, 1.000000>, <4.500000, 20.500000, 0.500000>, <4.500000, 0.000000, 0.500000>, <15.000000, 10.250000, 0.000000>, <9.750000, 0.000000, 0.000000>, <9.750000, 20.500000, 0.000000>, <4.500000, 10.250000, 0.000000>, <15.000000, 23.250000, 1.000000>, <15.500000, 26.000000, 1.000000>, <15.000000, 23.250000, 0.000000>, 
			<-4.500000, 20.500000, 0.500000>, <0.000000, 20.500000, 1.000000>, <0.000000, 20.500000, 0.000000>, <-30.500000, 26.000000, 1.000000>, <-7.500000, 26.000000, 0.000000>, <-30.000000, 23.250000, 1.000000>, <-7.500000, 26.000000, 1.000000>, <-30.000000, 20.500000, -20.000000>, <-17.250000, 20.500000, 1.000000>, <-30.000000, 23.250000, 0.000000>, <-17.250000, 20.500000, 0.000000>, 
			<-30.000000, 0.000000, 0.500000>, <-30.000000, 10.250000, 0.000000>, <-17.250000, 0.000000, 1.000000>, <-30.000000, 10.250000, 1.000000>, <-4.500000, 0.000000, 0.500000>, <-4.500000, 10.250000, 1.000000>, <-17.250000, 0.000000, 0.000000>, <-4.500000, 10.250000, 0.000000>, <-30.000000, 26.500000, 1.000000>, <-30.000000, 26.000000, -20.000000>, <-30.000000, 27.000000, 0.500000>, 
			<-7.500000, 27.000000, 0.000000>, <15.000000, 26.500000, 1.000000>, <15.000000, 27.000000, 0.500000>, <-7.500000, 27.000000, 1.000000>, <16.000000, 20.500000, 0.500000>, <16.000000, 20.500000, -20.000000>, <16.000000, 26.000000, 0.500000>, <16.000000, 26.000000, -20.000000>, <15.500000, 27.000000, 1.000000>, <16.000000, 26.500000, 1.000000>, <15.500000, 27.000000, 0.000000>, 
			<16.000000, 27.000000, 0.500000>, <16.000000, 26.500000, 0.000000>, <15.500000, 0.000000, 0.000000>, <16.000000, 10.250000, 0.000000>, <15.500000, 0.000000, 1.000000>, <16.000000, 0.000000, 0.500000>, <16.000000, 10.250000, 1.000000>, <16.000000, 23.250000, 1.000000>, <16.000000, 23.250000, 0.000000>, <-31.000000, 26.000000, -20.000000>, <-31.000000, 26.000000, 0.500000>, 
			<-30.500000, 20.500000, 1.000000>, <-31.000000, 20.500000, 0.500000>, <-30.500000, 27.000000, 0.000000>, <-31.000000, 26.500000, 0.000000>, <-30.500000, 27.000000, 1.000000>, <-31.000000, 27.000000, 0.500000>, <-31.000000, 26.500000, 1.000000>, <-31.000000, 23.250000, 0.000000>, <-30.500000, 0.000000, 1.000000>, <-31.000000, 10.250000, 1.000000>, <-30.500000, 0.000000, 0.000000>, 
			<-31.000000, 0.000000, 0.500000>, <-31.000000, 10.250000, 0.000000>, <-31.000000, 23.250000, 1.000000>, <15.000000, 20.500000, -20.000000>, <15.000000, 26.000000, -20.000000>, <-30.000000, 27.000000, -20.000000>, <15.000000, 27.000000, -20.000000>, <16.000000, 20.500000, -40.500000>, <16.000000, 26.000000, -40.500000>, <-31.000000, 26.000000, -40.500000>, <-31.000000, 20.500000, -20.000000>, 
			<-30.000000, 23.250000, -40.000000>, <-31.000000, 0.000000, -20.000000>, <-31.000000, 10.250000, -40.000000>, <-30.000000, 0.000000, -20.000000>, <-30.500000, 0.000000, -40.000000>, <-30.000000, 10.250000, -40.000000>, <-31.000000, 23.250000, -40.000000>, <16.000000, 23.250000, -40.000000>, <-7.500000, 26.000000, -40.000000>, <-7.500000, 27.000000, -40.000000>, <15.000000, 0.000000, -20.000000>, 
			<15.000000, 10.250000, -40.000000>, <16.000000, 0.000000, -20.000000>, <15.500000, 0.000000, -40.000000>, <16.000000, 10.250000, -40.000000>, <-31.000000, 27.000000, -20.000000>, <-30.500000, 27.000000, -40.000000>, <-31.000000, 26.500000, -40.000000>, <16.000000, 27.000000, -20.000000>, <16.000000, 26.500000, -40.000000>, <15.500000, 27.000000, -40.000000>, <15.000000, 23.250000, -40.000000>, 
			<15.000000, 26.500000, -41.000000>, <-30.000000, 26.500000, -41.000000>, <-30.500000, 20.500000, -41.000000>, <-30.000000, 27.000000, -40.500000>, <15.000000, 27.000000, -40.500000>, <15.500000, 20.500000, -41.000000>, <15.500000, 26.000000, -41.000000>, <-30.500000, 26.000000, -41.000000>, <-31.000000, 20.500000, -40.500000>, <-30.000000, 23.250000, -41.000000>, <-31.000000, 27.000000, -40.500000>, 
			<-30.500000, 27.000000, -41.000000>, <-31.000000, 26.500000, -41.000000>, <-31.000000, 23.250000, -41.000000>, <15.000000, 23.250000, -41.000000>, <-7.500000, 27.000000, -41.000000>, <15.000000, 0.000000, -40.500000>, <15.000000, 10.250000, -41.000000>, <16.000000, 0.000000, -40.500000>, <15.500000, 0.000000, -41.000000>, <16.000000, 10.250000, -41.000000>, <16.000000, 23.250000, -41.000000>, 
			<-7.500000, 26.000000, -41.000000>, <16.000000, 27.000000, -40.500000>, <16.000000, 26.500000, -41.000000>, <15.500000, 27.000000, -41.000000>, <-31.000000, 0.000000, -40.500000>, <-31.000000, 10.250000, -41.000000>, <-30.000000, 0.000000, -40.500000>, <-30.500000, 0.000000, -41.000000>, <-30.000000, 10.250000, -41.000000>, <-7.500000, 20.500000, -41.000000>, <-7.500000, 0.000000, -41.000000>, 
			<-7.500000, 0.000000, -40.000000>, <-7.500000, 20.500000, -40.000000>, <-14.937500, 23.020833, 0.000000>, <6.812500, 23.020833, 0.000000>, <9.750000, 10.250000, 1.000000>, <4.500000, 10.250000, 0.500000>, <9.750000, 0.000000, 0.500000>, <9.750000, 10.250000, 0.000000>, <16.000000, 10.250000, 0.500000>, <-5.000000, 22.333333, 1.000000>, <-31.000000, 23.250000, 0.500000>, 
			<16.000000, 23.250000, 0.500000>, <-7.500000, 27.000000, 0.500000>, <0.000000, 20.500000, 0.500000>, <-3.750000, 23.250000, 0.000000>, <-17.250000, 0.000000, 0.500000>, <-31.000000, 10.250000, 0.500000>, <-17.250000, 10.250000, 1.000000>, <-4.500000, 10.250000, 0.500000>, <-17.250000, 10.250000, 0.000000>, <-7.500000, 26.500000, -41.000000>, <-31.000000, 26.500000, 0.500000>, 
			<-7.500000, 26.500000, 1.000000>, <16.000000, 26.500000, 0.500000>, <15.500000, 26.500000, 1.000000>, <15.500000, 27.000000, 0.500000>, <15.500000, 26.500000, -41.000000>, <15.500000, 10.250000, -41.000000>, <15.500000, 0.000000, 0.500000>, <15.500000, 10.250000, 1.000000>, <15.500000, 23.250000, 1.000000>, <15.500000, 23.250000, -41.000000>, <-30.500000, 26.500000, -41.000000>, 
			<-30.500000, 27.000000, 0.500000>, <-30.500000, 26.500000, 1.000000>, <-30.500000, 23.250000, -41.000000>, <-30.500000, 10.250000, 1.000000>, <-30.500000, 0.000000, 0.500000>, <-30.500000, 10.250000, -41.000000>, <-30.500000, 23.250000, 1.000000>, <-30.000000, 23.250000, -20.000000>, <-7.500000, 27.000000, -20.000000>, <-31.000000, 10.250000, -20.000000>, <-30.500000, 0.000000, -20.000000>, 
			<-30.000000, 10.250000, -20.000000>, <-31.000000, 23.250000, -20.000000>, <16.000000, 23.250000, -20.000000>, <-7.500000, 26.000000, -20.000000>, <15.000000, 10.250000, -20.000000>, <15.500000, 0.000000, -20.000000>, <16.000000, 10.250000, -20.000000>, <-30.500000, 27.000000, -20.000000>, <-31.000000, 26.500000, -20.000000>, <16.000000, 26.500000, -20.000000>, <15.500000, 27.000000, -20.000000>, 
			<15.000000, 23.250000, -20.000000>, <-30.500000, 27.000000, -40.500000>, <-31.000000, 26.500000, -40.500000>, <-31.000000, 23.250000, -40.500000>, <-7.500000, 27.000000, -40.500000>, <15.500000, 0.000000, -40.500000>, <16.000000, 10.250000, -40.500000>, <16.000000, 23.250000, -40.500000>, <16.000000, 26.500000, -40.500000>, <15.500000, 27.000000, -40.500000>, <-31.000000, 10.250000, -40.500000>, 
			<-30.500000, 0.000000, -40.500000>, <-7.500000, 10.250000, -41.000000>, <-7.500000, 0.000000, -40.500000>, <-7.500000, 10.250000, -40.000000>, <-7.500000, 23.250000, -41.000000>, <-7.500000, 23.250000, -40.000000>, <-21.500000, 22.333333, 0.000000>, <11.500000, 22.333333, 0.000000>}
	 //#local average_center = <-6.691046, 17.525857, -17.680851>;
	 normal_vectors { 1319, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, 1.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <-1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
			<0.000000, 1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, -1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, 
			<1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 1.000000, 0.000000>, 
			<0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, 1.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
			<-1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, 
			<0.000000, 1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, 0.000000, -1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, 
			<0.000000, 0.000000, 1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, 
			<-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, 
			<0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, 
			<0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, 
			<0.000000, 0.000000, -1.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, 1.000000>, 
			<0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, -1.000000>, 
			<0.000000, 0.000000, -1.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, 
			<1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, 
			<0.000000, 0.000000, 1.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, 
			<0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
			<0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
			<1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
			<1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
			<1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, 
			<-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-1.000000, 0.000000, 0.000000>, 
			<-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, 
			<-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <-1.000000, 0.000000, 0.000000>, 
			<-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, -1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, 
			<-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, -1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <1.000000, 0.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, 
			<0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
			<1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
			<-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, 
			<-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, 
			<0.000000, -1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, 
			<-1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, 
			<0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, 
			<0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, 
			<0.000000, 0.000000, -1.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, 
			<0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
			<0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, 
			<-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, 
			<-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, 
			<0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, 
			<0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, 
			<-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, 
			<-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, 
			<0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, 
			<0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, 
			<0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
			<1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <1.000000, 0.000000, 0.000000>, 
			<1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, 
			<0.000000, 0.000000, 1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <1.000000, 0.000000, 0.000000>, 
			<1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
			<0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
			<1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, 
			<0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, 
			<0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, 
			<0.000000, 0.000000, 1.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
			<1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
			<1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
			<1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
			<1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
			<1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
			<0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, 
			<-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, 
			<0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, 
			<0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, 
			<-1.000000, 0.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, 
			<0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, 
			<-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, 
			<-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, 
			<-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, 
			<-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, 
			<-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, 
			<0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
			<1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, 
			<-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
			<1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
			<1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, 
			<0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
			<1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, 
			<0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, 
			<-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
			<1.000000, 0.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, 
			<0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
			<0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, 
			<0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, -1.000000>, 
			<0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, 
			<0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, 
			<0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, 
			<0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, 
			<0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, 
			<0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, 
			<0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, 
			<0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, 
			<0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, 
			<0.000000, 0.000000, -1.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, 
			<0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, 
			<0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, 
			<0.000000, 1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <-1.000000, 0.000000, 0.000000>, 
			<-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, 
			<0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>}
	 texture_list { 1, texture{wm_Wall}}
	 face_indices { 560, <1, 75, 212>, 0, <1, 212, 72>, 0, <72, 212, 73>, 0, <72, 73, 0>, 0, <73, 212, 3>, 0, <212, 77, 3>, 0, <77, 212, 75>, 0, <75, 2, 77>, 0, <2, 78, 77>, 0, <78, 213, 77>, 0, 
			<77, 213, 3>, 0, <213, 79, 3>, 0, <79, 213, 83>, 0, <83, 7, 79>, 0, <6, 83, 213>, 0, <6, 213, 78>, 0, <3, 79, 73>, 0, <79, 214, 73>, 0, <73, 214, 0>, 0, <214, 74, 0>, 0, <74, 214, 81>, 0, 
			<81, 4, 74>, 0, <7, 81, 214>, 0, <7, 214, 79>, 0, <4, 81, 215>, 0, <215, 80, 4>, 0, <80, 215, 82>, 0, <82, 5, 80>, 0, <215, 83, 6>, 0, <6, 82, 215>, 0, <7, 83, 81>, 0, <83, 215, 81>, 0, 
			<31, 125, 126>, 0, <125, 216, 126>, 0, <24, 126, 216>, 0, <216, 113, 24>, 0, <113, 216, 123>, 0, <123, 25, 113>, 0, <30, 123, 216>, 0, <30, 216, 125>, 0, <92, 217, 93>, 0, <93, 13, 92>, 0, <8, 93, 217>, 0, 
			<8, 217, 84>, 0, <75, 1, 84>, 0, <75, 84, 217>, 0, <75, 217, 2>, 0, <217, 88, 2>, 0, <88, 217, 10>, 0, <217, 95, 10>, 0, <95, 217, 92>, 0, <95, 92, 14>, 0, <33, 130, 144>, 0, <130, 218, 144>, 0, 
			<34, 144, 218>, 0, <218, 132, 34>, 0, <132, 218, 138>, 0, <138, 35, 132>, 0, <32, 138, 218>, 0, <32, 218, 130>, 0, <115, 219, 128>, 0, <128, 27, 115>, 0, <25, 128, 219>, 0, <25, 219, 113>, 0, <24, 113, 127>, 0, 
			<113, 219, 127>, 0, <26, 127, 219>, 0, <219, 115, 26>, 0, <108, 220, 109>, 0, <109, 21, 108>, 0, <22, 109, 220>, 0, <22, 220, 111>, 0, <23, 111, 112>, 0, <111, 220, 112>, 0, <20, 112, 220>, 0, <220, 108, 20>, 0, 
			<221, 87, 11>, 0, <11, 89, 221>, 0, <87, 221, 88>, 0, <87, 88, 10>, 0, <2, 88, 221>, 0, <221, 78, 2>, 0, <78, 221, 89>, 0, <89, 6, 78>, 0, <6, 89, 211>, 0, <89, 222, 211>, 0, <211, 222, 91>, 0, 
			<91, 9, 211>, 0, <91, 222, 210>, 0, <91, 210, 12>, 0, <11, 210, 222>, 0, <11, 222, 89>, 0, <16, 104, 223>, 0, <16, 223, 98>, 0, <17, 98, 100>, 0, <98, 223, 100>, 0, <18, 100, 223>, 0, <223, 102, 18>, 0, 
			<102, 223, 104>, 0, <104, 19, 102>, 0, <142, 224, 143>, 0, <143, 39, 142>, 0, <35, 143, 224>, 0, <35, 224, 132>, 0, <132, 224, 140>, 0, <132, 140, 34>, 0, <38, 140, 224>, 0, <224, 142, 38>, 0, <103, 225, 100>, 0, 
			<103, 100, 18>, 0, <100, 225, 17>, 0, <225, 101, 17>, 0, <101, 225, 95>, 0, <95, 14, 101>, 0, <225, 103, 10>, 0, <10, 95, 225>, 0, <226, 102, 19>, 0, <19, 105, 226>, 0, <102, 226, 103>, 0, <102, 103, 18>, 0, 
			<10, 103, 226>, 0, <226, 87, 10>, 0, <87, 226, 105>, 0, <105, 11, 87>, 0, <99, 227, 104>, 0, <99, 104, 16>, 0, <104, 227, 19>, 0, <227, 105, 19>, 0, <105, 227, 97>, 0, <97, 11, 105>, 0, <227, 99, 15>, 0, 
			<15, 97, 227>, 0, <58, 176, 197>, 0, <176, 228, 197>, 0, <57, 197, 228>, 0, <228, 175, 57>, 0, <175, 228, 190>, 0, <190, 61, 175>, 0, <60, 190, 228>, 0, <60, 228, 176>, 0, <37, 136, 137>, 0, <136, 229, 137>, 0, 
			<33, 137, 229>, 0, <229, 130, 33>, 0, <130, 229, 134>, 0, <134, 32, 130>, 0, <36, 134, 229>, 0, <36, 229, 136>, 0, <8, 110, 93>, 0, <110, 230, 93>, 0, <93, 230, 13>, 0, <230, 106, 13>, 0, <106, 230, 112>, 0, 
			<112, 20, 106>, 0, <23, 112, 230>, 0, <23, 230, 110>, 0, <120, 231, 121>, 0, <121, 29, 120>, 0, <27, 121, 231>, 0, <27, 231, 115>, 0, <26, 115, 118>, 0, <115, 231, 118>, 0, <28, 118, 231>, 0, <231, 120, 28>, 0, 
			<110, 232, 117>, 0, <117, 23, 110>, 0, <232, 118, 28>, 0, <28, 117, 232>, 0, <26, 118, 85>, 0, <118, 232, 85>, 0, <85, 232, 8>, 0, <232, 110, 8>, 0, <111, 233, 119>, 0, <119, 22, 111>, 0, <233, 120, 29>, 0, 
			<29, 119, 233>, 0, <28, 120, 117>, 0, <120, 233, 117>, 0, <23, 117, 233>, 0, <233, 111, 23>, 0, <199, 234, 200>, 0, <200, 69, 199>, 0, <61, 200, 234>, 0, <61, 234, 175>, 0, <57, 175, 181>, 0, <175, 234, 181>, 0, 
			<63, 181, 234>, 0, <234, 199, 63>, 0, <68, 194, 235>, 0, <235, 195, 68>, 0, <195, 235, 180>, 0, <180, 62, 195>, 0, <235, 192, 56>, 0, <56, 180, 235>, 0, <67, 192, 194>, 0, <192, 235, 194>, 0, <74, 236, 124>, 0, 
			<74, 124, 0>, 0, <124, 236, 31>, 0, <236, 125, 31>, 0, <125, 236, 122>, 0, <122, 30, 125>, 0, <4, 122, 236>, 0, <4, 236, 74>, 0, <237, 126, 24>, 0, <24, 76, 237>, 0, <31, 126, 124>, 0, <126, 237, 124>, 0, 
			<0, 124, 237>, 0, <237, 72, 0>, 0, <72, 237, 76>, 0, <76, 1, 72>, 0, <238, 127, 26>, 0, <26, 85, 238>, 0, <24, 127, 76>, 0, <127, 238, 76>, 0, <76, 238, 1>, 0, <238, 84, 1>, 0, <84, 238, 85>, 0, 
			<85, 8, 84>, 0, <62, 180, 239>, 0, <239, 196, 62>, 0, <196, 239, 181>, 0, <181, 63, 196>, 0, <239, 189, 57>, 0, <57, 181, 239>, 0, <56, 189, 180>, 0, <189, 239, 180>, 0, <182, 240, 58>, 0, <240, 176, 58>, 0, 
			<176, 240, 186>, 0, <186, 60, 176>, 0, <66, 186, 240>, 0, <66, 240, 187>, 0, <64, 187, 182>, 0, <187, 240, 182>, 0, <108, 241, 135>, 0, <108, 135, 20>, 0, <135, 241, 37>, 0, <241, 136, 37>, 0, <136, 241, 133>, 0, 
			<133, 36, 136>, 0, <21, 133, 241>, 0, <21, 241, 108>, 0, <90, 242, 33>, 0, <242, 137, 33>, 0, <137, 242, 135>, 0, <135, 37, 137>, 0, <20, 135, 242>, 0, <20, 242, 106>, 0, <13, 106, 90>, 0, <106, 242, 90>, 0, 
			<64, 182, 243>, 0, <64, 243, 188>, 0, <65, 188, 177>, 0, <188, 243, 177>, 0, <59, 177, 243>, 0, <243, 184, 59>, 0, <184, 243, 182>, 0, <182, 58, 184>, 0, <101, 244, 139>, 0, <101, 139, 17>, 0, <139, 244, 38>, 0, 
			<244, 140, 38>, 0, <140, 244, 131>, 0, <131, 34, 140>, 0, <244, 101, 14>, 0, <14, 131, 244>, 0, <98, 245, 141>, 0, <141, 16, 98>, 0, <245, 142, 39>, 0, <39, 141, 245>, 0, <38, 142, 139>, 0, <142, 245, 139>, 0, 
			<17, 139, 245>, 0, <245, 98, 17>, 0, <71, 204, 246>, 0, <246, 205, 71>, 0, <205, 246, 177>, 0, <177, 59, 205>, 0, <246, 202, 65>, 0, <65, 177, 246>, 0, <70, 202, 204>, 0, <202, 246, 204>, 0, <131, 247, 34>, 0, 
			<247, 144, 34>, 0, <144, 247, 90>, 0, <90, 33, 144>, 0, <13, 90, 247>, 0, <13, 247, 92>, 0, <14, 92, 131>, 0, <92, 247, 131>, 0, <96, 248, 12>, 0, <248, 107, 12>, 0, <107, 248, 153>, 0, <153, 42, 107>, 0, 
			<43, 153, 248>, 0, <43, 248, 94>, 0, <15, 94, 96>, 0, <94, 248, 96>, 0, <148, 249, 109>, 0, <148, 109, 22>, 0, <109, 249, 21>, 0, <249, 147, 21>, 0, <147, 249, 162>, 0, <162, 44, 147>, 0, <249, 148, 45>, 0, 
			<45, 162, 249>, 0, <143, 250, 39>, 0, <250, 154, 39>, 0, <154, 250, 155>, 0, <155, 50, 154>, 0, <250, 152, 49>, 0, <49, 155, 250>, 0, <152, 250, 143>, 0, <152, 143, 35>, 0, <141, 251, 16>, 0, <251, 156, 16>, 0, 
			<156, 251, 157>, 0, <157, 51, 156>, 0, <50, 157, 251>, 0, <50, 251, 154>, 0, <39, 154, 141>, 0, <154, 251, 141>, 0, <94, 252, 158>, 0, <158, 43, 94>, 0, <51, 158, 252>, 0, <51, 252, 156>, 0, <16, 156, 99>, 0, 
			<156, 252, 99>, 0, <15, 99, 252>, 0, <252, 94, 15>, 0, <152, 253, 159>, 0, <159, 49, 152>, 0, <48, 159, 253>, 0, <48, 253, 129>, 0, <129, 253, 138>, 0, <129, 138, 32>, 0, <138, 253, 35>, 0, <253, 152, 35>, 0, 
			<116, 254, 160>, 0, <160, 47, 116>, 0, <46, 160, 254>, 0, <46, 254, 114>, 0, <114, 254, 128>, 0, <114, 128, 25>, 0, <128, 254, 27>, 0, <254, 116, 27>, 0, <12, 107, 91>, 0, <107, 255, 91>, 0, <9, 91, 255>, 0, 
			<255, 146, 9>, 0, <146, 255, 161>, 0, <161, 41, 146>, 0, <42, 161, 255>, 0, <42, 255, 107>, 0, <80, 256, 4>, 0, <256, 163, 4>, 0, <163, 256, 164>, 0, <164, 52, 163>, 0, <256, 145, 40>, 0, <40, 164, 256>, 0, 
			<5, 145, 80>, 0, <145, 256, 80>, 0, <122, 257, 30>, 0, <257, 165, 30>, 0, <165, 257, 166>, 0, <166, 53, 165>, 0, <52, 166, 257>, 0, <52, 257, 163>, 0, <4, 163, 122>, 0, <163, 257, 122>, 0, <114, 258, 167>, 0, 
			<167, 46, 114>, 0, <53, 167, 258>, 0, <53, 258, 165>, 0, <30, 165, 123>, 0, <165, 258, 123>, 0, <123, 258, 25>, 0, <258, 114, 25>, 0, <133, 259, 36>, 0, <259, 168, 36>, 0, <168, 259, 169>, 0, <169, 54, 168>, 0, 
			<259, 147, 44>, 0, <44, 169, 259>, 0, <147, 259, 133>, 0, <147, 133, 21>, 0, <129, 260, 170>, 0, <170, 48, 129>, 0, <54, 170, 260>, 0, <54, 260, 168>, 0, <36, 168, 134>, 0, <168, 260, 134>, 0, <134, 260, 32>, 0, 
			<260, 129, 32>, 0, <121, 261, 29>, 0, <261, 171, 29>, 0, <171, 261, 172>, 0, <172, 55, 171>, 0, <47, 172, 261>, 0, <47, 261, 116>, 0, <116, 261, 121>, 0, <116, 121, 27>, 0, <148, 262, 173>, 0, <173, 45, 148>, 0, 
			<55, 173, 262>, 0, <55, 262, 171>, 0, <29, 171, 119>, 0, <171, 262, 119>, 0, <22, 119, 262>, 0, <262, 148, 22>, 0, <145, 263, 174>, 0, <174, 40, 145>, 0, <263, 146, 41>, 0, <41, 174, 263>, 0, <9, 146, 86>, 0, 
			<146, 263, 86>, 0, <5, 86, 263>, 0, <263, 145, 5>, 0, <169, 264, 54>, 0, <264, 185, 54>, 0, <185, 264, 186>, 0, <186, 66, 185>, 0, <264, 178, 60>, 0, <60, 186, 264>, 0, <44, 178, 169>, 0, <178, 264, 169>, 0, 
			<151, 265, 187>, 0, <187, 64, 151>, 0, <66, 187, 265>, 0, <66, 265, 185>, 0, <54, 185, 170>, 0, <185, 265, 170>, 0, <48, 170, 265>, 0, <265, 151, 48>, 0, <183, 266, 188>, 0, <188, 65, 183>, 0, <64, 188, 266>, 0, 
			<64, 266, 151>, 0, <48, 151, 159>, 0, <151, 266, 159>, 0, <49, 159, 266>, 0, <266, 183, 49>, 0, <45, 179, 162>, 0, <179, 267, 162>, 0, <44, 162, 267>, 0, <267, 178, 44>, 0, <178, 267, 190>, 0, <190, 60, 178>, 0, 
			<267, 179, 61>, 0, <61, 190, 267>, 0, <166, 268, 53>, 0, <268, 193, 53>, 0, <193, 268, 194>, 0, <194, 68, 193>, 0, <67, 194, 268>, 0, <67, 268, 191>, 0, <52, 191, 166>, 0, <191, 268, 166>, 0, <149, 269, 195>, 0, 
			<195, 62, 149>, 0, <68, 195, 269>, 0, <68, 269, 193>, 0, <53, 193, 167>, 0, <193, 269, 167>, 0, <46, 167, 269>, 0, <269, 149, 46>, 0, <150, 270, 196>, 0, <196, 63, 150>, 0, <62, 196, 270>, 0, <62, 270, 149>, 0, 
			<46, 149, 160>, 0, <149, 270, 160>, 0, <47, 160, 270>, 0, <270, 150, 47>, 0, <172, 271, 55>, 0, <271, 198, 55>, 0, <198, 271, 199>, 0, <199, 69, 198>, 0, <63, 199, 271>, 0, <63, 271, 150>, 0, <47, 150, 172>, 0, 
			<150, 271, 172>, 0, <179, 272, 200>, 0, <200, 61, 179>, 0, <69, 200, 272>, 0, <69, 272, 198>, 0, <55, 198, 173>, 0, <198, 272, 173>, 0, <45, 173, 272>, 0, <272, 179, 45>, 0, <155, 273, 50>, 0, <273, 201, 50>, 0, 
			<201, 273, 202>, 0, <202, 70, 201>, 0, <273, 183, 65>, 0, <65, 202, 273>, 0, <49, 183, 155>, 0, <183, 273, 155>, 0, <157, 274, 51>, 0, <274, 203, 51>, 0, <203, 274, 204>, 0, <204, 71, 203>, 0, <70, 204, 274>, 0, 
			<70, 274, 201>, 0, <50, 201, 157>, 0, <201, 274, 157>, 0, <192, 275, 206>, 0, <206, 56, 192>, 0, <59, 206, 275>, 0, <59, 275, 205>, 0, <205, 275, 207>, 0, <205, 207, 71>, 0, <207, 275, 67>, 0, <275, 192, 67>, 0, 
			<191, 276, 207>, 0, <207, 67, 191>, 0, <71, 207, 276>, 0, <71, 276, 203>, 0, <203, 276, 208>, 0, <203, 208, 51>, 0, <208, 276, 52>, 0, <276, 191, 52>, 0, <52, 164, 208>, 0, <164, 277, 208>, 0, <51, 208, 277>, 0, 
			<277, 158, 51>, 0, <158, 277, 209>, 0, <209, 43, 158>, 0, <40, 209, 277>, 0, <40, 277, 164>, 0, <184, 278, 206>, 0, <184, 206, 59>, 0, <206, 278, 56>, 0, <278, 189, 56>, 0, <189, 278, 197>, 0, <197, 57, 189>, 0, 
			<278, 184, 58>, 0, <58, 197, 278>, 0, <41, 161, 279>, 0, <41, 279, 174>, 0, <40, 174, 209>, 0, <174, 279, 209>, 0, <43, 209, 279>, 0, <279, 153, 43>, 0, <153, 279, 161>, 0, <161, 42, 153>, 0, <97, 280, 210>, 0, 
			<97, 210, 11>, 0, <12, 210, 280>, 0, <12, 280, 96>, 0, <280, 97, 15>, 0, <15, 96, 280>, 0, <9, 86, 281>, 0, <9, 281, 211>, 0, <82, 6, 211>, 0, <82, 211, 281>, 0, <82, 281, 5>, 0, <281, 86, 5>, 0}
	 normal_indices { 560, <78, 510, 2>, <79, 2, 492>, <493, 2, 498>, <494, 499, 72>, <500, 2, 90>, <2, 522, 91>, <523, 2, 511>, <512, 84, 524>, <85, 528, 525>, <529, 3, 526>, 
			<527, 3, 92>, <3, 534, 93>, <535, 3, 558>, <559, 116, 536>, <109, 560, 3>, <110, 3, 530>, <94, 537, 501>, <538, 4, 502>, <503, 4, 73>, <4, 504, 74>, <505, 4, 546>, 
			<547, 95, 506>, <117, 548, 4>, <118, 4, 539>, <96, 549, 5>, <5, 540, 97>, <541, 5, 552>, <553, 103, 542>, <5, 561, 111>, <112, 554, 5>, <119, 562, 550>, <563, 5, 551>, 
			<257, 809, 815>, <810, 6, 816>, <216, 817, 6>, <6, 737, 217>, <738, 6, 797>, <798, 222, 739>, <251, 799, 6>, <252, 6, 811>, <611, 7, 618>, <619, 152, 612>, <120, 620, 7>, 
			<121, 7, 564>, <513, 80, 565>, <514, 566, 7>, <515, 7, 86>, <7, 587, 87>, <588, 7, 132>, <7, 630, 133>, <631, 7, 613>, <632, 614, 158>, <267, 839, 923>, <840, 8, 924>, 
			<273, 925, 8>, <8, 851, 274>, <852, 8, 887>, <888, 279, 853>, <261, 889, 8>, <262, 8, 841>, <749, 9, 827>, <828, 234, 750>, <223, 829, 9>, <224, 9, 740>, <218, 741, 821>, 
			<742, 9, 822>, <228, 823, 9>, <9, 751, 229>, <707, 10, 713>, <714, 198, 708>, <204, 715, 10>, <205, 10, 725>, <210, 726, 731>, <727, 10, 732>, <192, 733, 10>, <10, 709, 193>, 
			<11, 581, 139>, <140, 592, 11>, <582, 11, 589>, <583, 590, 134>, <88, 591, 11>, <11, 531, 89>, <532, 11, 593>, <594, 113, 533>, <114, 595, 1>, <596, 12, 1>, <1, 12, 604>, 
			<605, 126, 1>, <606, 12, 0>, <607, 0, 146>, <141, 0, 12>, <142, 12, 597>, <170, 683, 13>, <171, 13, 647>, <177, 648, 659>, <649, 13, 660>, <183, 661, 13>, <13, 671, 184>, 
			<672, 13, 684>, <685, 187, 673>, <911, 14, 917>, <918, 300, 912>, <280, 919, 14>, <281, 14, 854>, <855, 14, 899>, <856, 900, 275>, <295, 901, 14>, <14, 913, 296>, <677, 15, 662>, 
			<678, 663, 185>, <664, 15, 178>, <15, 665, 179>, <666, 15, 633>, <634, 159, 667>, <15, 679, 135>, <136, 635, 15>, <16, 674, 188>, <189, 689, 16>, <675, 16, 680>, <676, 681, 186>, 
			<137, 682, 16>, <16, 584, 138>, <585, 16, 690>, <691, 143, 586>, <653, 17, 686>, <654, 687, 172>, <688, 17, 190>, <17, 692, 191>, <693, 17, 641>, <642, 144, 694>, <17, 655, 163>, 
			<164, 643, 17>, <414, 1115, 1241>, <1116, 18, 1242>, <408, 1243, 18>, <18, 1109, 409>, <1110, 18, 1199>, <1200, 432, 1111>, <426, 1201, 18>, <427, 18, 1117>, <291, 875, 881>, <876, 19, 882>, 
			<268, 883, 19>, <19, 842, 269>, <843, 19, 863>, <864, 263, 844>, <285, 865, 19>, <286, 19, 877>, <122, 719, 621>, <720, 20, 622>, <623, 20, 153>, <20, 695, 154>, <696, 20, 734>, 
			<735, 194, 697>, <211, 736, 20>, <212, 20, 721>, <779, 21, 785>, <786, 245, 780>, <235, 787, 21>, <236, 21, 752>, <230, 753, 767>, <754, 21, 768>, <240, 769, 21>, <21, 781, 241>, 
			<722, 22, 761>, <762, 213, 723>, <22, 770, 242>, <243, 763, 22>, <231, 771, 570>, <772, 22, 571>, <572, 22, 123>, <22, 724, 124>, <728, 23, 773>, <774, 206, 729>, <23, 782, 246>, 
			<247, 775, 23>, <244, 783, 764>, <784, 23, 765>, <214, 766, 23>, <23, 730, 215>, <1253, 24, 1259>, <1260, 478, 1254>, <433, 1261, 24>, <434, 24, 1112>, <410, 1113, 1145>, <1114, 24, 1146>, 
			<444, 1147, 24>, <24, 1255, 445>, <473, 1223, 25>, <25, 1229, 474>, <1230, 25, 1139>, <1140, 438, 1231>, <25, 1211, 402>, <403, 1141, 25>, <467, 1212, 1224>, <1213, 25, 1225>, <507, 26, 803>, 
			<508, 804, 75>, <805, 26, 258>, <26, 812, 259>, <813, 26, 791>, <792, 253, 814>, <98, 793, 26>, <99, 26, 509>, <27, 818, 219>, <220, 516, 27>, <260, 819, 806>, <820, 27, 807>, 
			<76, 808, 27>, <27, 495, 77>, <496, 27, 517>, <518, 81, 497>, <28, 824, 232>, <233, 573, 28>, <221, 825, 519>, <826, 28, 520>, <521, 28, 82>, <28, 567, 83>, <568, 28, 574>, 
			<575, 125, 569>, <439, 1142, 29>, <29, 1235, 440>, <1236, 29, 1148>, <1149, 446, 1237>, <29, 1193, 411>, <412, 1150, 29>, <404, 1194, 1143>, <1195, 29, 1144>, <1151, 30, 415>, <30, 1118, 416>, 
			<1119, 30, 1175>, <1176, 428, 1120>, <462, 1177, 30>, <463, 30, 1181>, <450, 1182, 1152>, <1183, 30, 1153>, <710, 31, 869>, <711, 870, 195>, <871, 31, 292>, <31, 878, 293>, <879, 31, 857>, 
			<858, 287, 880>, <199, 859, 31>, <200, 31, 712>, <598, 32, 270>, <32, 884, 271>, <885, 32, 872>, <873, 294, 886>, <196, 874, 32>, <197, 32, 698>, <155, 699, 599>, <700, 32, 600>, 
			<451, 1154, 33>, <452, 33, 1187>, <456, 1188, 1121>, <1189, 33, 1122>, <420, 1123, 33>, <33, 1163, 421>, <1164, 33, 1155>, <1156, 417, 1165>, <668, 34, 893>, <669, 894, 180>, <895, 34, 297>, 
			<34, 902, 298>, <903, 34, 845>, <846, 276, 904>, <34, 670, 160>, <161, 847, 34>, <650, 35, 905>, <906, 173, 651>, <35, 914, 301>, <302, 907, 35>, <299, 915, 896>, <916, 35, 897>, 
			<181, 898, 35>, <35, 652, 182>, <486, 1283, 36>, <36, 1289, 487>, <1290, 36, 1124>, <1125, 422, 1291>, <36, 1271, 457>, <458, 1126, 36>, <482, 1272, 1284>, <1273, 36, 1285>, <848, 37, 277>, 
			<37, 926, 278>, <927, 37, 601>, <602, 272, 928>, <156, 603, 37>, <157, 37, 615>, <162, 616, 849>, <617, 37, 850>, <636, 38, 147>, <38, 701, 148>, <702, 38, 977>, <978, 317, 703>, 
			<321, 979, 38>, <322, 38, 624>, <165, 625, 637>, <626, 38, 638>, <947, 39, 716>, <948, 717, 207>, <718, 39, 201>, <39, 941, 202>, <942, 39, 1031>, <1032, 327, 943>, <39, 949, 333>, 
			<334, 1033, 39>, <920, 40, 303>, <40, 983, 304>, <984, 40, 989>, <990, 363, 985>, <40, 971, 357>, <358, 991, 40>, <972, 40, 921>, <973, 922, 282>, <908, 41, 174>, <41, 995, 175>, 
			<996, 41, 1001>, <1002, 369, 997>, <364, 1003, 41>, <365, 41, 986>, <305, 987, 909>, <988, 41, 910>, <627, 42, 1007>, <1008, 323, 628>, <370, 1009, 42>, <371, 42, 998>, <176, 999, 656>, 
			<1000, 42, 657>, <166, 658, 42>, <42, 629, 167>, <974, 43, 1013>, <1014, 359, 975>, <351, 1015, 43>, <352, 43, 833>, <834, 43, 890>, <835, 891, 264>, <892, 43, 283>, <43, 976, 284>, 
			<755, 44, 1019>, <1020, 345, 756>, <339, 1021, 44>, <340, 44, 743>, <744, 44, 830>, <745, 831, 225>, <832, 44, 237>, <44, 757, 238>, <149, 704, 608>, <705, 45, 609>, <127, 610, 45>, 
			<45, 935, 128>, <936, 45, 1025>, <1026, 312, 937>, <318, 1027, 45>, <319, 45, 706>, <543, 46, 100>, <46, 1037, 101>, <1038, 46, 1043>, <1044, 377, 1039>, <46, 929, 306>, <307, 1045, 46>, 
			<104, 930, 544>, <931, 46, 545>, <794, 47, 254>, <47, 1049, 255>, <1050, 47, 1055>, <1056, 384, 1051>, <378, 1057, 47>, <379, 47, 1040>, <102, 1041, 795>, <1042, 47, 796>, <746, 48, 1061>, 
			<1062, 341, 747>, <385, 1063, 48>, <386, 48, 1052>, <256, 1053, 800>, <1054, 48, 801>, <802, 48, 226>, <48, 748, 227>, <860, 49, 288>, <49, 1067, 289>, <1068, 49, 1073>, <1074, 390, 1069>, 
			<49, 944, 328>, <329, 1075, 49>, <945, 49, 861>, <946, 862, 203>, <836, 50, 1079>, <1080, 353, 837>, <391, 1081, 50>, <392, 50, 1070>, <290, 1071, 866>, <1072, 50, 867>, <868, 50, 265>, 
			<50, 838, 266>, <788, 51, 248>, <51, 1085, 249>, <1086, 51, 1091>, <1092, 396, 1087>, <346, 1093, 51>, <347, 51, 758>, <759, 51, 789>, <760, 790, 239>, <950, 52, 1097>, <1098, 335, 951>, 
			<397, 1099, 52>, <398, 52, 1088>, <250, 1089, 776>, <1090, 52, 777>, <208, 778, 52>, <52, 952, 209>, <932, 53, 1103>, <1104, 308, 933>, <53, 938, 313>, <314, 1105, 53>, <129, 939, 576>, 
			<940, 53, 577>, <105, 578, 53>, <53, 934, 106>, <1076, 54, 393>, <54, 1169, 394>, <1170, 54, 1178>, <1179, 464, 1171>, <54, 1127, 429>, <430, 1180, 54>, <330, 1128, 1077>, <1129, 54, 1078>, 
			<965, 55, 1184>, <1185, 453, 966>, <465, 1186, 55>, <466, 55, 1172>, <395, 1173, 1082>, <1174, 55, 1083>, <354, 1084, 55>, <55, 967, 355>, <1157, 56, 1190>, <1191, 459, 1158>, <454, 1192, 56>, 
			<455, 56, 968>, <356, 969, 1016>, <970, 56, 1017>, <360, 1018, 56>, <56, 1159, 361>, <336, 1133, 1034>, <1134, 57, 1035>, <331, 1036, 57>, <57, 1130, 332>, <1131, 57, 1202>, <1203, 431, 1132>, 
			<57, 1135, 435>, <436, 1204, 57>, <1058, 58, 387>, <58, 1217, 388>, <1218, 58, 1226>, <1227, 475, 1219>, <468, 1228, 58>, <469, 58, 1205>, <380, 1206, 1059>, <1207, 58, 1060>, <953, 59, 1232>, 
			<1233, 441, 954>, <476, 1234, 59>, <477, 59, 1220>, <389, 1221, 1064>, <1222, 59, 1065>, <342, 1066, 59>, <59, 955, 343>, <959, 60, 1238>, <1239, 447, 960>, <442, 1240, 60>, <443, 60, 956>, 
			<344, 957, 1022>, <958, 60, 1023>, <348, 1024, 60>, <60, 961, 349>, <1094, 61, 399>, <61, 1247, 400>, <1248, 61, 1256>, <1257, 479, 1249>, <448, 1258, 61>, <449, 61, 962>, <350, 963, 1095>, 
			<964, 61, 1096>, <1136, 62, 1262>, <1263, 437, 1137>, <480, 1264, 62>, <481, 62, 1250>, <401, 1251, 1100>, <1252, 62, 1101>, <337, 1102, 62>, <62, 1138, 338>, <992, 63, 366>, <63, 1265, 367>, 
			<1266, 63, 1274>, <1275, 483, 1267>, <63, 1160, 460>, <461, 1276, 63>, <362, 1161, 993>, <1162, 63, 994>, <1004, 64, 372>, <64, 1277, 373>, <1278, 64, 1286>, <1287, 488, 1279>, <484, 1288, 64>, 
			<485, 64, 1268>, <368, 1269, 1005>, <1270, 64, 1006>, <1214, 65, 1295>, <1296, 405, 1215>, <423, 1297, 65>, <424, 65, 1292>, <1293, 65, 1301>, <1294, 1302, 489>, <1303, 65, 470>, <65, 1216, 471>, 
			<1208, 66, 1304>, <1305, 472, 1209>, <490, 1306, 66>, <491, 66, 1280>, <1281, 66, 1307>, <1282, 1308, 374>, <1309, 66, 381>, <66, 1210, 382>, <383, 1046, 1310>, <1047, 67, 1311>, <375, 1312, 67>, 
			<67, 1010, 376>, <1011, 67, 1313>, <1314, 324, 1012>, <309, 1315, 67>, <310, 67, 1048>, <1166, 68, 1298>, <1167, 1299, 425>, <1300, 68, 406>, <68, 1196, 407>, <1197, 68, 1244>, <1245, 413, 1198>, 
			<68, 1168, 418>, <419, 1246, 68>, <315, 1028, 69>, <316, 69, 1106>, <311, 1107, 1316>, <1108, 69, 1317>, <325, 1318, 69>, <69, 980, 326>, <981, 69, 1029>, <1030, 320, 982>, <644, 70, 0>, 
			<645, 0, 145>, <150, 0, 70>, <151, 70, 639>, <70, 646, 168>, <169, 640, 70>, <130, 579, 71>, <131, 71, 1>, <555, 115, 1>, <556, 1, 71>, <557, 71, 107>, <71, 580, 108>}
}
#declare wo_2_Frame = mesh2{
	 vertex_vectors { 914, <4.025000, 0.000000, -0.200000>, <4.050000, 0.000000, -0.200000>, <4.028125, 0.000000, -0.221875>, <4.050000, 0.000000, -0.225000>, <4.025000, 0.000000, 0.000000>, <4.050000, 0.000000, 0.000000>, <4.025000, 0.000000, 0.025000>, <4.050000, 0.000000, 0.025000>, <3.950000, 0.000000, 0.025000>, <3.950000, 0.000000, 0.000000>, 
			<3.925000, 0.000000, 0.025000>, <3.928125, 0.000000, 0.003125>, <3.928125, 17.418360, 0.003125>, <3.925000, 0.000000, 0.975000>, <3.950000, 0.000000, 0.975000>, <3.928125, 0.000000, 0.996875>, <3.928125, 17.418360, 0.996875>, <3.950000, 0.000000, 1.000000>, <4.025000, 0.000000, 0.975000>, <4.025000, 0.000000, 1.000000>, <4.050000, 0.000000, 0.975000>, 
			<4.050000, 0.000000, 1.000000>, <4.050000, 0.000000, 1.200000>, <4.025000, 0.000000, 1.200000>, <4.050000, 0.000000, 1.225000>, <4.028125, 0.000000, 1.221875>, <4.600000, 0.000000, -0.200000>, <4.600000, 0.000000, -0.025000>, <4.600000, 0.000000, 0.000000>, <4.600000, 0.000000, 1.000000>, <4.600000, 0.000000, 1.025000>, <4.600000, 0.000000, 1.200000>, 
			<4.600000, 0.000000, 1.225000>, <4.600000, 0.000000, -0.225000>, <4.625000, 0.000000, -0.200000>, <4.625000, 0.000000, -0.025000>, <4.621875, 0.000000, -0.003125>, <4.621875, 0.000000, 1.003125>, <4.625000, 0.000000, 1.025000>, <4.625000, 0.000000, 1.200000>, <4.621875, 0.000000, 1.221875>, <4.621875, 0.000000, -0.221875>, <4.025000, 17.503126, -0.200000>, 
			<4.050000, 17.525001, -0.225000>, <4.025000, 17.503126, 0.000000>, <3.950000, 17.437501, 0.000000>, <3.925000, 17.415626, 0.025000>, <3.925000, 17.415626, 0.975000>, <3.950000, 17.437501, 1.000000>, <4.025000, 17.503126, 1.000000>, <4.025000, 17.503126, 1.200000>, <4.050000, 17.525001, 1.225000>, <4.600000, 18.006252, 1.225000>, <4.600000, 18.006252, -0.225000>, 
			<4.625000, 20.600002, -0.200000>, <4.625000, 20.600002, -0.025000>, <4.625000, 20.600002, 1.025000>, <4.625000, 20.600002, 1.200000>, <4.028125, 17.505861, -0.221875>, <4.621875, 20.600002, 1.221875>, <4.028125, 17.505861, 1.221875>, <4.621875, 20.600002, 1.003125>, <4.621875, 20.600002, -0.221875>, <4.621875, 20.600002, -0.003125>, <4.025000, 20.025002, -0.200000>, 
			<4.050000, 20.050002, -0.225000>, <4.025000, 20.025002, 0.000000>, <3.950000, 19.950002, 0.000000>, <3.925000, 19.925001, 0.025000>, <3.925000, 19.925001, 0.975000>, <3.950000, 19.950002, 1.000000>, <4.025000, 20.025002, 1.000000>, <4.025000, 20.025002, 1.200000>, <4.050000, 20.050002, 1.225000>, <4.600000, 20.600002, 0.000000>, <4.600000, 20.600002, 1.000000>, 
			<4.600000, 20.600002, 1.225000>, <4.600000, 20.600002, -0.225000>, <4.621875, 20.621877, -0.200000>, <4.621875, 20.621877, -0.025000>, <4.621875, 20.621877, 1.025000>, <4.621875, 20.621877, 1.200000>, <4.028125, 20.028127, 1.221875>, <4.619444, 20.619446, -0.005556>, <4.619444, 20.619446, -0.219444>, <4.619444, 20.619446, 1.005556>, <3.928125, 19.928126, 0.996875>, 
			<4.028125, 20.028127, -0.221875>, <3.928125, 19.928126, 0.003125>, <4.619444, 20.619446, 1.219444>, <3.003125, 20.025002, -0.200000>, <3.021875, 20.050002, -0.225000>, <3.003125, 20.025002, 0.000000>, <2.946875, 19.950002, 0.000000>, <2.928125, 19.925001, 0.025000>, <2.928125, 19.925001, 0.975000>, <2.946875, 19.950002, 1.000000>, <3.003125, 20.025002, 1.000000>, 
			<3.003125, 20.025002, 1.200000>, <3.021875, 20.050002, 1.225000>, <3.434375, 20.600002, 1.225000>, <3.434375, 20.600002, -0.225000>, <4.600000, 20.625002, -0.200000>, <4.600000, 20.625002, -0.025000>, <4.600000, 20.625002, 1.025000>, <4.600000, 20.625002, 1.200000>, <2.930469, 19.928126, 0.996875>, <4.600000, 20.621877, -0.003125>, <3.005469, 20.028127, 1.221875>, 
			<2.930469, 19.928126, 0.003125>, <3.005469, 20.028127, -0.221875>, <4.600000, 20.621877, -0.221875>, <4.600000, 20.621877, 1.003125>, <4.600000, 20.621877, 1.221875>, <-4.025000, 0.000000, -0.200000>, <-4.050000, 0.000000, -0.200000>, <-4.028125, 0.000000, -0.221875>, <-4.050000, 0.000000, -0.225000>, <-4.025000, 0.000000, 0.000000>, <-4.050000, 0.000000, 0.000000>, 
			<-4.025000, 0.000000, 0.025000>, <-4.050000, 0.000000, 0.025000>, <-3.950000, 0.000000, 0.025000>, <-3.950000, 0.000000, 0.000000>, <-3.925000, 0.000000, 0.025000>, <-3.928125, 0.000000, 0.003125>, <-3.928125, 17.418360, 0.003125>, <-3.925000, 0.000000, 0.975000>, <-3.950000, 0.000000, 0.975000>, <-3.928125, 0.000000, 0.996875>, <-3.928125, 17.418360, 0.996875>, 
			<-3.950000, 0.000000, 1.000000>, <-4.025000, 0.000000, 0.975000>, <-4.025000, 0.000000, 1.000000>, <-4.050000, 0.000000, 0.975000>, <-4.050000, 0.000000, 1.000000>, <-4.050000, 0.000000, 1.200000>, <-4.025000, 0.000000, 1.200000>, <-4.050000, 0.000000, 1.225000>, <-4.028125, 0.000000, 1.221875>, <-4.600000, 0.000000, -0.200000>, <-4.600000, 0.000000, -0.025000>, 
			<-4.600000, 0.000000, 0.000000>, <-4.600000, 0.000000, 1.000000>, <-4.600000, 0.000000, 1.025000>, <-4.600000, 0.000000, 1.200000>, <-4.600000, 0.000000, 1.225000>, <-4.600000, 0.000000, -0.225000>, <-4.625000, 0.000000, -0.200000>, <-4.625000, 0.000000, -0.025000>, <-4.621875, 0.000000, -0.003125>, <-4.621875, 0.000000, 1.003125>, <-4.625000, 0.000000, 1.025000>, 
			<-4.625000, 0.000000, 1.200000>, <-4.621875, 0.000000, 1.221875>, <-4.621875, 0.000000, -0.221875>, <-4.025000, 17.503126, -0.200000>, <-4.050000, 17.525001, -0.225000>, <-4.025000, 17.503126, 0.000000>, <-3.950000, 17.437501, 0.000000>, <-3.925000, 17.415626, 0.025000>, <-3.925000, 17.415626, 0.975000>, <-3.950000, 17.437501, 1.000000>, <-4.025000, 17.503126, 1.000000>, 
			<-4.025000, 17.503126, 1.200000>, <-4.050000, 17.525001, 1.225000>, <-4.600000, 18.006252, 1.225000>, <-4.600000, 18.006252, -0.225000>, <-4.625000, 20.600002, -0.200000>, <-4.625000, 20.600002, -0.025000>, <-4.625000, 20.600002, 1.025000>, <-4.625000, 20.600002, 1.200000>, <-4.028125, 17.505861, -0.221875>, <-4.621875, 20.600002, 1.221875>, <-4.028125, 17.505861, 1.221875>, 
			<-4.621875, 20.600002, 1.003125>, <-4.621875, 20.600002, -0.221875>, <-4.621875, 20.600002, -0.003125>, <-4.025000, 20.025002, -0.200000>, <-4.050000, 20.050002, -0.225000>, <-4.025000, 20.025002, 0.000000>, <-3.950000, 19.950002, 0.000000>, <-3.925000, 19.925001, 0.025000>, <-3.925000, 19.925001, 0.975000>, <-3.950000, 19.950002, 1.000000>, <-4.025000, 20.025002, 1.000000>, 
			<-4.025000, 20.025002, 1.200000>, <-4.050000, 20.050002, 1.225000>, <-4.600000, 20.600002, 0.000000>, <-4.600000, 20.600002, 1.000000>, <-4.600000, 20.600002, 1.225000>, <-4.600000, 20.600002, -0.225000>, <-4.621875, 20.621877, -0.200000>, <-4.621875, 20.621877, -0.025000>, <-4.621875, 20.621877, 1.025000>, <-4.621875, 20.621877, 1.200000>, <-4.028125, 20.028127, 1.221875>, 
			<-4.619444, 20.619446, -0.005556>, <-4.619444, 20.619446, -0.219444>, <-4.619444, 20.619446, 1.005556>, <-3.928125, 19.928126, 0.996875>, <-4.028125, 20.028127, -0.221875>, <-3.928125, 19.928126, 0.003125>, <-4.619444, 20.619446, 1.219444>, <-3.003125, 20.025002, -0.200000>, <-3.021875, 20.050002, -0.225000>, <-3.003125, 20.025002, 0.000000>, <-2.946875, 19.950002, 0.000000>, 
			<-2.928125, 19.925001, 0.025000>, <-2.928125, 19.925001, 0.975000>, <-2.946875, 19.950002, 1.000000>, <-3.003125, 20.025002, 1.000000>, <-3.003125, 20.025002, 1.200000>, <-3.021875, 20.050002, 1.225000>, <-3.434375, 20.600002, 1.225000>, <-3.434375, 20.600002, -0.225000>, <-4.600000, 20.625002, -0.200000>, <-4.600000, 20.625002, -0.025000>, <-4.600000, 20.625002, 1.025000>, 
			<-4.600000, 20.625002, 1.200000>, <-2.930469, 19.928126, 0.996875>, <-4.600000, 20.621877, -0.003125>, <-3.005469, 20.028127, 1.221875>, <-2.930469, 19.928126, 0.003125>, <-3.005469, 20.028127, -0.221875>, <-4.600000, 20.621877, -0.221875>, <-4.600000, 20.621877, 1.003125>, <-4.600000, 20.621877, 1.221875>, <4.025000, 10.000001, -0.200000>, <4.037500, 0.000000, -0.200000>, 
			<4.025000, 0.000000, -0.212500>, <4.325000, 0.000000, -0.200000>, <4.050000, 0.000000, -0.212500>, <4.037500, 0.000000, -0.225000>, <4.025000, 0.000000, -0.100000>, <4.037500, 0.000000, 0.000000>, <4.050000, 0.000000, -0.100000>, <4.025000, 0.000000, 0.012500>, <4.037500, 0.000000, 0.025000>, <4.050000, 0.000000, 0.012500>, <3.950000, 0.000000, 0.012500>, 
			<3.987500, 0.000000, 0.025000>, <3.987500, 0.000000, 0.000000>, <3.925000, 9.950000, 0.025000>, <3.925000, 0.000000, 0.012500>, <3.937500, 0.000000, 0.025000>, <3.928125, 9.951563, 0.003125>, <3.937500, 0.000000, 0.000000>, <3.925000, 9.950000, 0.975000>, <3.925000, 0.000000, 0.500000>, <3.937500, 0.000000, 0.975000>, <3.950000, 0.000000, 0.500000>, 
			<3.928125, 9.951563, 0.996875>, <3.925000, 0.000000, 0.987500>, <3.937500, 0.000000, 1.000000>, <3.950000, 0.000000, 0.987500>, <4.025000, 0.000000, 0.987500>, <3.987500, 0.000000, 0.975000>, <3.987500, 0.000000, 1.000000>, <4.050000, 0.000000, 0.987500>, <4.037500, 0.000000, 0.975000>, <4.037500, 0.000000, 1.000000>, <4.325000, 0.000000, 1.200000>, 
			<4.037500, 0.000000, 1.200000>, <4.050000, 0.000000, 1.100000>, <4.025000, 0.000000, 1.100000>, <4.037500, 0.000000, 1.225000>, <4.050000, 0.000000, 1.212500>, <4.025000, 0.000000, 1.212500>, <4.050000, 0.000000, 0.500000>, <4.025000, 0.000000, 0.500000>, <4.612500, 0.000000, -0.200000>, <4.612500, 0.000000, -0.025000>, <4.612500, 0.000000, 0.000000>, 
			<4.612500, 0.000000, 1.025000>, <4.612500, 0.000000, 1.200000>, <4.325000, 0.000000, 1.225000>, <4.600000, 0.000000, 1.212500>, <4.600000, 0.000000, 0.500000>, <4.600000, 0.000000, 1.112500>, <4.600000, 0.000000, -0.012500>, <4.325000, 0.000000, -0.225000>, <4.600000, 10.287501, -0.225000>, <4.600000, 0.000000, -0.212500>, <4.600000, 0.000000, 1.012500>, 
			<4.600000, 0.000000, -0.112500>, <4.625000, 10.300001, -0.200000>, <4.625000, 10.300001, -0.025000>, <4.612500, 0.000000, 1.000000>, <4.625000, 10.300001, 1.025000>, <4.625000, 10.300001, 1.200000>, <4.625000, 0.000000, 1.012500>, <4.625000, 0.000000, 1.112500>, <4.612500, 0.000000, 1.225000>, <4.625000, 0.000000, 1.212500>, <4.625000, 0.000000, -0.112500>, 
			<4.612500, 0.000000, -0.225000>, <4.625000, 0.000000, -0.212500>, <4.625000, 0.000000, -0.012500>, <4.325000, 0.000000, 0.987500>, <4.325000, 0.000000, 1.012500>, <4.325000, 0.000000, 0.012500>, <4.325000, 0.000000, -0.012500>, <4.025000, 20.012502, -0.200000>, <4.050000, 10.012501, -0.225000>, <4.025000, 10.000001, 0.000000>, <3.950000, 9.962501, 0.000000>, 
			<3.950000, 9.962501, 1.000000>, <4.025000, 10.000001, 1.000000>, <4.025000, 10.000001, 1.200000>, <4.050000, 10.012501, 1.225000>, <4.600000, 10.300001, 0.000000>, <4.600000, 10.300001, 1.000000>, <4.600000, 10.287501, 1.225000>, <4.600000, 20.587502, -0.225000>, <4.625000, 20.612502, -0.200000>, <4.625000, 20.612502, -0.025000>, <4.625000, 20.612502, 1.025000>, 
			<4.625000, 20.612502, 1.200000>, <4.025000, 17.503126, 1.100000>, <3.937500, 17.426564, 1.000000>, <3.925000, 17.415626, 0.987500>, <4.025000, 17.503126, -0.100000>, <4.028125, 10.001563, -0.221875>, <4.025000, 17.503126, -0.212500>, <4.037500, 17.514064, -0.225000>, <4.621875, 10.298438, 1.221875>, <4.625000, 20.600002, 1.212500>, <4.611458, 18.015106, 1.225000>, 
			<4.325000, 17.765627, -0.225000>, <3.987500, 17.470314, 1.000000>, <4.028125, 10.001563, 1.221875>, <4.037500, 17.514064, 1.225000>, <4.025000, 17.503126, 1.212500>, <4.325000, 17.765627, 1.225000>, <4.621875, 10.300001, 1.003125>, <4.625000, 20.600002, 1.012500>, <3.925000, 17.415626, 0.500000>, <3.987500, 17.470314, 0.000000>, <4.621875, 10.298438, -0.221875>, 
			<4.611458, 18.015106, -0.225000>, <4.625000, 20.600002, -0.212500>, <4.621875, 10.300001, -0.003125>, <4.625000, 20.600002, -0.012500>, <4.625000, 20.600002, -0.112500>, <3.925000, 17.415626, 0.012500>, <3.937500, 17.426564, 0.000000>, <4.625000, 20.600002, 1.112500>, <4.012500, 20.025002, -0.200000>, <4.050000, 20.037502, -0.225000>, <4.025000, 20.012502, 0.000000>, 
			<3.950000, 19.937502, 0.000000>, <3.925000, 19.912501, 0.025000>, <3.925000, 19.912501, 0.975000>, <3.950000, 19.937502, 1.000000>, <4.025000, 20.012502, 1.000000>, <4.025000, 20.012502, 1.200000>, <4.050000, 20.037502, 1.225000>, <4.600000, 20.587502, 1.225000>, <4.587500, 20.600002, -0.225000>, <4.612500, 20.625002, -0.200000>, <4.612500, 20.625002, -0.025000>, 
			<4.612500, 20.625002, 1.025000>, <4.612500, 20.625002, 1.200000>, <4.025000, 20.025002, -0.100000>, <3.925000, 19.925001, 0.500000>, <4.028125, 20.015627, 1.221875>, <4.037500, 20.037502, 1.225000>, <4.025000, 20.025002, 1.212500>, <4.621875, 20.612502, -0.003125>, <4.621875, 20.621877, -0.012500>, <4.621875, 20.612502, -0.221875>, <4.621875, 20.621877, -0.212500>, 
			<4.621875, 20.621877, 1.112500>, <4.621875, 20.612502, 1.003125>, <4.621875, 20.621877, 1.012500>, <3.928125, 19.915626, 0.996875>, <3.937500, 19.937501, 1.000000>, <3.925000, 19.925001, 0.987500>, <4.028125, 20.015627, -0.221875>, <4.025000, 20.025002, -0.212500>, <4.037500, 20.037502, -0.225000>, <4.325000, 20.325002, 1.225000>, <3.928125, 19.915626, 0.003125>, 
			<3.925000, 19.925001, 0.012500>, <3.937500, 19.937501, 0.000000>, <4.025000, 20.025002, 1.100000>, <4.621875, 20.621877, -0.112500>, <3.987500, 19.987502, 0.000000>, <3.987500, 19.987502, 1.000000>, <4.600000, 20.600002, 0.500000>, <4.325000, 20.325002, -0.225000>, <4.621875, 20.612502, 1.221875>, <4.621875, 20.621877, 1.212500>, <4.037500, 20.050002, -0.225000>, 
			<4.012500, 20.025002, 0.000000>, <3.937500, 19.950002, 0.000000>, <3.912500, 19.925001, 0.025000>, <3.912500, 19.925001, 0.975000>, <3.937500, 19.950002, 1.000000>, <4.012500, 20.025002, 1.000000>, <4.012500, 20.025002, 1.200000>, <4.037500, 20.050002, 1.225000>, <4.587500, 20.600002, 1.225000>, <2.975000, 19.987502, 1.000000>, <3.915625, 19.928126, 0.996875>, 
			<2.937500, 19.937501, 1.000000>, <2.928125, 19.925001, 0.987500>, <4.612500, 20.621877, -0.003125>, <4.600000, 20.625002, -0.012500>, <3.003125, 20.025002, 1.100000>, <2.975000, 19.987502, 0.000000>, <2.928125, 19.925001, 0.500000>, <3.003125, 20.025002, -0.100000>, <3.228125, 20.325002, -0.225000>, <4.600000, 20.625002, -0.112500>, <3.228125, 20.325002, 1.225000>, 
			<4.015625, 20.028127, 1.221875>, <3.012500, 20.037502, 1.225000>, <3.003125, 20.025002, 1.212500>, <4.600000, 20.625002, 1.112500>, <3.915625, 19.928126, 0.003125>, <2.928125, 19.925001, 0.012500>, <2.937500, 19.937501, 0.000000>, <4.015625, 20.028127, -0.221875>, <3.003125, 20.025002, -0.212500>, <3.012500, 20.037502, -0.225000>, <4.612500, 20.621877, -0.221875>, 
			<3.441667, 20.611460, -0.225000>, <4.600000, 20.625002, -0.212500>, <4.612500, 20.621877, 1.003125>, <4.600000, 20.625002, 1.012500>, <4.612500, 20.621877, 1.221875>, <4.600000, 20.625002, 1.212500>, <3.441667, 20.611460, 1.225000>, <4.612500, 20.600002, -0.225000>, <4.612500, 20.600002, 1.225000>, <4.600000, 20.612502, -0.225000>, <4.600000, 20.612502, 1.225000>, 
			<4.612500, 20.600002, 0.000000>, <4.612500, 20.600002, 1.000000>, <4.600000, 20.612502, 0.000000>, <4.600000, 20.612502, 1.000000>, <-4.025000, 10.000001, -0.200000>, <-4.037500, 0.000000, -0.200000>, <-4.025000, 0.000000, -0.212500>, <-4.325000, 0.000000, -0.200000>, <-4.050000, 0.000000, -0.212500>, <-4.037500, 0.000000, -0.225000>, <-4.025000, 0.000000, -0.100000>, 
			<-4.037500, 0.000000, 0.000000>, <-4.050000, 0.000000, -0.100000>, <-4.025000, 0.000000, 0.012500>, <-4.037500, 0.000000, 0.025000>, <-4.050000, 0.000000, 0.012500>, <-3.950000, 0.000000, 0.012500>, <-3.987500, 0.000000, 0.025000>, <-3.987500, 0.000000, 0.000000>, <-3.925000, 9.950000, 0.025000>, <-3.925000, 0.000000, 0.012500>, <-3.937500, 0.000000, 0.025000>, 
			<-3.928125, 9.951563, 0.003125>, <-3.937500, 0.000000, 0.000000>, <-3.925000, 9.950000, 0.975000>, <-3.925000, 0.000000, 0.500000>, <-3.937500, 0.000000, 0.975000>, <-3.950000, 0.000000, 0.500000>, <-3.928125, 9.951563, 0.996875>, <-3.925000, 0.000000, 0.987500>, <-3.937500, 0.000000, 1.000000>, <-3.950000, 0.000000, 0.987500>, <-4.025000, 0.000000, 0.987500>, 
			<-3.987500, 0.000000, 0.975000>, <-3.987500, 0.000000, 1.000000>, <-4.050000, 0.000000, 0.987500>, <-4.037500, 0.000000, 0.975000>, <-4.037500, 0.000000, 1.000000>, <-4.325000, 0.000000, 1.200000>, <-4.037500, 0.000000, 1.200000>, <-4.050000, 0.000000, 1.100000>, <-4.025000, 0.000000, 1.100000>, <-4.037500, 0.000000, 1.225000>, <-4.050000, 0.000000, 1.212500>, 
			<-4.025000, 0.000000, 1.212500>, <-4.050000, 0.000000, 0.500000>, <-4.025000, 0.000000, 0.500000>, <-4.612500, 0.000000, -0.200000>, <-4.612500, 0.000000, -0.025000>, <-4.612500, 0.000000, 0.000000>, <-4.612500, 0.000000, 1.025000>, <-4.612500, 0.000000, 1.200000>, <-4.325000, 0.000000, 1.225000>, <-4.600000, 0.000000, 1.212500>, <-4.600000, 0.000000, 0.500000>, 
			<-4.600000, 0.000000, 1.112500>, <-4.600000, 0.000000, -0.012500>, <-4.325000, 0.000000, -0.225000>, <-4.600000, 10.287501, -0.225000>, <-4.600000, 0.000000, -0.212500>, <-4.600000, 0.000000, 1.012500>, <-4.600000, 0.000000, -0.112500>, <-4.625000, 10.300001, -0.200000>, <-4.625000, 10.300001, -0.025000>, <-4.612500, 0.000000, 1.000000>, <-4.625000, 10.300001, 1.025000>, 
			<-4.625000, 10.300001, 1.200000>, <-4.625000, 0.000000, 1.012500>, <-4.625000, 0.000000, 1.112500>, <-4.612500, 0.000000, 1.225000>, <-4.625000, 0.000000, 1.212500>, <-4.625000, 0.000000, -0.112500>, <-4.612500, 0.000000, -0.225000>, <-4.625000, 0.000000, -0.212500>, <-4.625000, 0.000000, -0.012500>, <-4.325000, 0.000000, 0.987500>, <-4.325000, 0.000000, 1.012500>, 
			<-4.325000, 0.000000, 0.012500>, <-4.325000, 0.000000, -0.012500>, <-4.025000, 20.012502, -0.200000>, <-4.050000, 10.012501, -0.225000>, <-4.025000, 10.000001, 0.000000>, <-3.950000, 9.962501, 0.000000>, <-3.950000, 9.962501, 1.000000>, <-4.025000, 10.000001, 1.000000>, <-4.025000, 10.000001, 1.200000>, <-4.050000, 10.012501, 1.225000>, <-4.600000, 10.300001, 0.000000>, 
			<-4.600000, 10.300001, 1.000000>, <-4.600000, 10.287501, 1.225000>, <-4.600000, 20.587502, -0.225000>, <-4.625000, 20.612502, -0.200000>, <-4.625000, 20.612502, -0.025000>, <-4.625000, 20.612502, 1.025000>, <-4.625000, 20.612502, 1.200000>, <-4.025000, 17.503126, 1.100000>, <-3.937500, 17.426564, 1.000000>, <-3.925000, 17.415626, 0.987500>, <-4.025000, 17.503126, -0.100000>, 
			<-4.028125, 10.001563, -0.221875>, <-4.025000, 17.503126, -0.212500>, <-4.037500, 17.514064, -0.225000>, <-4.621875, 10.298438, 1.221875>, <-4.625000, 20.600002, 1.212500>, <-4.611458, 18.015106, 1.225000>, <-4.325000, 17.765627, -0.225000>, <-3.987500, 17.470314, 1.000000>, <-4.028125, 10.001563, 1.221875>, <-4.037500, 17.514064, 1.225000>, <-4.025000, 17.503126, 1.212500>, 
			<-4.325000, 17.765627, 1.225000>, <-4.621875, 10.300001, 1.003125>, <-4.625000, 20.600002, 1.012500>, <-3.925000, 17.415626, 0.500000>, <-3.987500, 17.470314, 0.000000>, <-4.621875, 10.298438, -0.221875>, <-4.611458, 18.015106, -0.225000>, <-4.625000, 20.600002, -0.212500>, <-4.621875, 10.300001, -0.003125>, <-4.625000, 20.600002, -0.012500>, <-4.625000, 20.600002, -0.112500>, 
			<-3.925000, 17.415626, 0.012500>, <-3.937500, 17.426564, 0.000000>, <-4.625000, 20.600002, 1.112500>, <-4.012500, 20.025002, -0.200000>, <-4.050000, 20.037502, -0.225000>, <-4.025000, 20.012502, 0.000000>, <-3.950000, 19.937502, 0.000000>, <-3.925000, 19.912501, 0.025000>, <-3.925000, 19.912501, 0.975000>, <-3.950000, 19.937502, 1.000000>, <-4.025000, 20.012502, 1.000000>, 
			<-4.025000, 20.012502, 1.200000>, <-4.050000, 20.037502, 1.225000>, <-4.600000, 20.587502, 1.225000>, <-4.587500, 20.600002, -0.225000>, <-4.612500, 20.625002, -0.200000>, <-4.612500, 20.625002, -0.025000>, <-4.612500, 20.625002, 1.025000>, <-4.612500, 20.625002, 1.200000>, <-4.025000, 20.025002, -0.100000>, <-3.925000, 19.925001, 0.500000>, <-4.028125, 20.015627, 1.221875>, 
			<-4.037500, 20.037502, 1.225000>, <-4.025000, 20.025002, 1.212500>, <-4.621875, 20.612502, -0.003125>, <-4.621875, 20.621877, -0.012500>, <-4.621875, 20.612502, -0.221875>, <-4.621875, 20.621877, -0.212500>, <-4.621875, 20.621877, 1.112500>, <-4.621875, 20.612502, 1.003125>, <-4.621875, 20.621877, 1.012500>, <-3.928125, 19.915626, 0.996875>, <-3.937500, 19.937501, 1.000000>, 
			<-3.925000, 19.925001, 0.987500>, <-4.028125, 20.015627, -0.221875>, <-4.025000, 20.025002, -0.212500>, <-4.037500, 20.037502, -0.225000>, <-4.325000, 20.325002, 1.225000>, <-3.928125, 19.915626, 0.003125>, <-3.925000, 19.925001, 0.012500>, <-3.937500, 19.937501, 0.000000>, <-4.025000, 20.025002, 1.100000>, <-4.621875, 20.621877, -0.112500>, <-3.987500, 19.987502, 0.000000>, 
			<-3.987500, 19.987502, 1.000000>, <-4.600000, 20.600002, 0.500000>, <-4.325000, 20.325002, -0.225000>, <-4.621875, 20.612502, 1.221875>, <-4.621875, 20.621877, 1.212500>, <-4.037500, 20.050002, -0.225000>, <-4.012500, 20.025002, 0.000000>, <-3.937500, 19.950002, 0.000000>, <-3.912500, 19.925001, 0.025000>, <-3.912500, 19.925001, 0.975000>, <-3.937500, 19.950002, 1.000000>, 
			<-4.012500, 20.025002, 1.000000>, <-4.012500, 20.025002, 1.200000>, <-4.037500, 20.050002, 1.225000>, <-4.587500, 20.600002, 1.225000>, <-2.975000, 19.987502, 1.000000>, <-3.915625, 19.928126, 0.996875>, <-2.937500, 19.937501, 1.000000>, <-2.928125, 19.925001, 0.987500>, <-4.612500, 20.621877, -0.003125>, <-4.600000, 20.625002, -0.012500>, <-3.003125, 20.025002, 1.100000>, 
			<-2.975000, 19.987502, 0.000000>, <-2.928125, 19.925001, 0.500000>, <-3.003125, 20.025002, -0.100000>, <-3.228125, 20.325002, -0.225000>, <-4.600000, 20.625002, -0.112500>, <-3.228125, 20.325002, 1.225000>, <-4.015625, 20.028127, 1.221875>, <-3.012500, 20.037502, 1.225000>, <-3.003125, 20.025002, 1.212500>, <-4.600000, 20.625002, 1.112500>, <-3.915625, 19.928126, 0.003125>, 
			<-2.928125, 19.925001, 0.012500>, <-2.937500, 19.937501, 0.000000>, <-4.015625, 20.028127, -0.221875>, <-3.003125, 20.025002, -0.212500>, <-3.012500, 20.037502, -0.225000>, <-4.612500, 20.621877, -0.221875>, <-3.441667, 20.611460, -0.225000>, <-4.600000, 20.625002, -0.212500>, <-4.612500, 20.621877, 1.003125>, <-4.600000, 20.625002, 1.012500>, <-4.612500, 20.621877, 1.221875>, 
			<-4.600000, 20.625002, 1.212500>, <-3.441667, 20.611460, 1.225000>, <0.000000, 20.025002, -0.200000>, <0.000000, 20.600002, 0.000000>, <0.000000, 20.600002, 1.000000>, <0.000000, 20.600002, -0.225000>, <0.000000, 20.625002, -0.200000>, <0.000000, 20.625002, -0.025000>, <0.000000, 20.625002, 1.025000>, <0.000000, 20.625002, 1.200000>, <0.000000, 20.621877, 1.221875>, 
			<0.000000, 19.928126, 0.003125>, <0.000000, 20.621877, 1.003125>, <0.000000, 20.028127, 1.221875>, <0.000000, 20.028127, -0.221875>, <0.000000, 20.621877, -0.221875>, <0.000000, 20.621877, -0.003125>, <0.000000, 19.928126, 0.996875>, <-4.612500, 20.600002, -0.225000>, <-4.612500, 20.600002, 1.225000>, <-4.600000, 20.612502, -0.225000>, <-4.600000, 20.612502, 1.225000>, 
			<0.000000, 20.600002, 1.225000>, <0.000000, 20.050002, 1.225000>, <0.000000, 20.025002, 1.200000>, <0.000000, 20.025002, 1.000000>, <0.000000, 19.950002, 1.000000>, <0.000000, 19.925001, 0.975000>, <0.000000, 19.925001, 0.025000>, <0.000000, 19.950002, 0.000000>, <0.000000, 20.025002, 0.000000>, <0.000000, 20.050002, -0.225000>, <-4.612500, 20.600002, 0.000000>, 
			<-4.612500, 20.600002, 1.000000>, <-4.600000, 20.612502, 0.000000>, <-4.600000, 20.612502, 1.000000>, <4.037500, 0.000000, -0.212500>, <4.025000, 10.000001, -0.100000>, <4.037500, 0.000000, -0.100000>, <3.925000, 9.950000, 0.012500>, <4.037500, 0.000000, 0.012500>, <3.987500, 0.000000, 0.012500>, <3.987500, 9.981251, 0.000000>, <3.937500, 0.000000, 0.012500>, 
			<3.937500, 9.956251, 0.000000>, <3.925000, 9.950000, 0.500000>, <3.937500, 0.000000, 0.500000>, <3.925000, 9.950000, 0.987500>, <3.937500, 0.000000, 0.987500>, <3.987500, 0.000000, 0.987500>, <3.987500, 9.981251, 1.000000>, <4.037500, 0.000000, 0.987500>, <4.037500, 0.000000, 1.100000>, <4.025000, 10.000001, 1.100000>, <4.037500, 0.000000, 1.212500>, 
			<4.025000, 10.000001, 1.212500>, <4.037500, 0.000000, 0.500000>, <3.987500, 0.000000, 0.500000>, <4.325000, 0.000000, 0.500000>, <4.325000, 0.000000, 1.212500>, <4.325000, 10.150001, 1.225000>, <4.325000, 0.000000, -0.212500>, <4.325000, 0.000000, 1.000000>, <4.325000, 0.000000, -0.106250>, <4.612500, 0.000000, 1.012500>, <4.612500, 0.000000, 1.112500>, 
			<4.612500, 0.000000, 1.212500>, <4.612500, 10.293751, 1.225000>, <4.612500, 0.000000, -0.112500>, <4.612500, 0.000000, -0.212500>, <4.612500, 0.000000, -0.012500>, <4.325000, 0.000000, 1.106250>, <4.325000, 0.000000, 0.000000>, <3.937500, 9.956251, 1.000000>, <4.025000, 10.000001, -0.212500>, <4.037500, 10.006251, -0.225000>, <4.625000, 10.300001, 1.212500>, 
			<4.325000, 10.150001, -0.225000>, <4.037500, 10.006251, 1.225000>, <4.612500, 10.300001, 1.000000>, <4.625000, 10.300001, 1.012500>, <4.612500, 10.293751, -0.225000>, <4.625000, 10.300001, -0.212500>, <4.625000, 10.300001, -0.012500>, <4.612500, 10.300001, 0.000000>, <4.600000, 10.300001, 0.500000>, <4.625000, 10.300001, -0.112500>, <4.625000, 10.300001, 1.112500>, 
			<4.025000, 20.012502, -0.100000>, <3.925000, 19.912501, 0.500000>, <4.037500, 20.025002, 1.225000>, <4.025000, 20.012502, 1.212500>, <4.625000, 20.612502, -0.012500>, <4.612500, 20.612502, 0.000000>, <4.608333, 20.591669, -0.225000>, <4.625000, 20.612502, -0.212500>, <4.625000, 20.612502, 1.112500>, <4.625000, 20.612502, 1.012500>, <3.937500, 19.925001, 1.000000>, 
			<3.925000, 19.912501, 0.987500>, <4.025000, 20.012502, -0.212500>, <4.037500, 20.025002, -0.225000>, <4.325000, 20.312502, 1.225000>, <3.925000, 19.912501, 0.012500>, <3.937500, 19.925001, 0.000000>, <4.025000, 20.012502, 1.100000>, <4.625000, 20.612502, -0.112500>, <3.987500, 19.975002, 0.000000>, <3.987500, 19.975002, 1.000000>, <4.325000, 20.312502, -0.225000>, 
			<4.625000, 20.612502, 1.212500>, <4.608333, 20.591669, 1.225000>, <3.975000, 19.987502, 1.000000>, <3.925000, 19.937501, 1.000000>, <3.912500, 19.925001, 0.987500>, <4.612500, 20.625002, -0.012500>, <4.012500, 20.025002, 1.100000>, <3.975000, 19.987502, 0.000000>, <3.912500, 19.925001, 0.500000>, <4.012500, 20.025002, -0.100000>, <4.312500, 20.325002, -0.225000>, 
			<4.612500, 20.625002, -0.112500>, <4.312500, 20.325002, 1.225000>, <4.025000, 20.037502, 1.225000>, <4.012500, 20.025002, 1.212500>, <4.612500, 20.625002, 1.112500>, <3.912500, 19.925001, 0.012500>, <3.925000, 19.937501, 0.000000>, <4.012500, 20.025002, -0.212500>, <4.025000, 20.037502, -0.225000>, <4.612500, 20.625002, -0.212500>, <4.612500, 20.625002, 1.012500>, 
			<4.612500, 20.625002, 1.212500>, <4.591667, 20.608335, 1.225000>, <4.612500, 20.612502, -0.225000>, <4.612500, 20.612502, 1.225000>, <4.591667, 20.608335, -0.225000>, <4.612500, 20.612502, 1.000000>, <-4.037500, 0.000000, -0.212500>, <-4.025000, 10.000001, -0.100000>, <-4.037500, 0.000000, -0.100000>, <-3.925000, 9.950000, 0.012500>, <-4.037500, 0.000000, 0.012500>, 
			<-3.987500, 0.000000, 0.012500>, <-3.987500, 9.981251, 0.000000>, <-3.937500, 0.000000, 0.012500>, <-3.937500, 9.956251, 0.000000>, <-3.925000, 9.950000, 0.500000>, <-3.937500, 0.000000, 0.500000>, <-3.925000, 9.950000, 0.987500>, <-3.937500, 0.000000, 0.987500>, <-3.987500, 0.000000, 0.987500>, <-3.987500, 9.981251, 1.000000>, <-4.037500, 0.000000, 0.987500>, 
			<-4.037500, 0.000000, 1.100000>, <-4.025000, 10.000001, 1.100000>, <-4.037500, 0.000000, 1.212500>, <-4.025000, 10.000001, 1.212500>, <-4.037500, 0.000000, 0.500000>, <-3.987500, 0.000000, 0.500000>, <-4.325000, 0.000000, 0.500000>, <-4.325000, 0.000000, 1.212500>, <-4.325000, 10.150001, 1.225000>, <-4.325000, 0.000000, -0.212500>, <-4.325000, 0.000000, 1.000000>, 
			<-4.325000, 0.000000, -0.106250>, <-4.612500, 0.000000, 1.012500>, <-4.612500, 0.000000, 1.112500>, <-4.612500, 0.000000, 1.212500>, <-4.612500, 10.293751, 1.225000>, <-4.612500, 0.000000, -0.112500>, <-4.612500, 0.000000, -0.212500>, <-4.612500, 0.000000, -0.012500>, <-4.325000, 0.000000, 1.106250>, <-4.325000, 0.000000, 0.000000>, <-3.937500, 9.956251, 1.000000>, 
			<-4.025000, 10.000001, -0.212500>, <-4.037500, 10.006251, -0.225000>, <-4.625000, 10.300001, 1.212500>, <-4.325000, 10.150001, -0.225000>, <-4.037500, 10.006251, 1.225000>, <-4.612500, 10.300001, 1.000000>, <-4.625000, 10.300001, 1.012500>, <-4.612500, 10.293751, -0.225000>, <-4.625000, 10.300001, -0.212500>, <-4.625000, 10.300001, -0.012500>, <-4.612500, 10.300001, 0.000000>, 
			<-4.600000, 10.300001, 0.500000>, <-4.625000, 10.300001, -0.112500>, <-4.625000, 10.300001, 1.112500>, <-4.025000, 20.012502, -0.100000>, <-3.925000, 19.912501, 0.500000>, <-4.037500, 20.025002, 1.225000>, <-4.025000, 20.012502, 1.212500>, <-4.625000, 20.612502, -0.012500>, <-4.612500, 20.612502, 0.000000>, <-4.608333, 20.591669, -0.225000>, <-4.625000, 20.612502, -0.212500>, 
			<-4.625000, 20.612502, 1.112500>, <-4.625000, 20.612502, 1.012500>, <-3.937500, 19.925001, 1.000000>, <-3.925000, 19.912501, 0.987500>, <-4.025000, 20.012502, -0.212500>, <-4.037500, 20.025002, -0.225000>, <-4.325000, 20.312502, 1.225000>, <-3.925000, 19.912501, 0.012500>, <-3.937500, 19.925001, 0.000000>, <-4.025000, 20.012502, 1.100000>, <-4.625000, 20.612502, -0.112500>, 
			<-3.987500, 19.975002, 0.000000>, <-3.987500, 19.975002, 1.000000>, <-4.325000, 20.312502, -0.225000>, <-4.625000, 20.612502, 1.212500>, <-4.608333, 20.591669, 1.225000>, <-3.975000, 19.987502, 1.000000>, <-3.925000, 19.937501, 1.000000>, <-3.912500, 19.925001, 0.987500>, <-4.612500, 20.625002, -0.012500>, <0.000000, 20.612502, 0.000000>, <-4.012500, 20.025002, 1.100000>, 
			<-3.975000, 19.987502, 0.000000>, <-3.912500, 19.925001, 0.500000>, <-4.012500, 20.025002, -0.100000>, <-4.312500, 20.325002, -0.225000>, <-4.612500, 20.625002, -0.112500>, <-4.312500, 20.325002, 1.225000>, <-4.025000, 20.037502, 1.225000>, <-4.012500, 20.025002, 1.212500>, <-4.612500, 20.625002, 1.112500>, <-3.912500, 19.925001, 0.012500>, <-3.925000, 19.937501, 0.000000>, 
			<-4.012500, 20.025002, -0.212500>, <-4.025000, 20.037502, -0.225000>, <-4.612500, 20.625002, -0.212500>, <0.000000, 20.600002, 0.500000>, <-4.612500, 20.625002, 1.012500>, <-4.612500, 20.625002, 1.212500>, <-4.591667, 20.608335, 1.225000>, <0.000000, 20.625002, 1.212500>, <0.000000, 20.612502, 1.225000>, <0.000000, 20.025002, -0.100000>, <0.000000, 19.925001, 0.012500>, 
			<0.000000, 19.937501, 0.000000>, <0.000000, 20.325002, -0.225000>, <0.000000, 19.987502, 0.000000>, <0.000000, 20.625002, 1.012500>, <0.000000, 20.325002, 1.225000>, <0.000000, 20.037502, 1.225000>, <0.000000, 20.025002, 1.212500>, <0.000000, 19.925001, 0.500000>, <0.000000, 20.025002, 1.100000>, <0.000000, 20.025002, -0.212500>, <0.000000, 20.037502, -0.225000>, 
			<0.000000, 20.612502, -0.225000>, <0.000000, 20.625002, -0.212500>, <0.000000, 19.987502, 1.000000>, <0.000000, 20.625002, -0.012500>, <0.000000, 20.625002, 1.112500>, <0.000000, 19.937501, 1.000000>, <0.000000, 19.925001, 0.987500>, <0.000000, 20.625002, -0.112500>, <-4.612500, 20.612502, -0.225000>, <-4.612500, 20.612502, 1.225000>, <-4.591667, 20.608335, -0.225000>, 
			<-4.612500, 20.612502, 1.000000>, <0.000000, 20.612502, 1.000000>}
	 //#local average_center = <0.000000, 13.117523, 0.500000>;
	 normal_vectors { 3535, <-0.707107, 0.000000, -0.707107>, <-0.707107, 0.000000, 0.707107>, <-0.707107, 0.000000, -0.707107>, <-0.707107, 0.000000, 0.707107>, <0.577350, 0.577350, 0.577350>, <0.577350, 0.577350, -0.577350>, <0.577350, 0.577350, -0.577350>, <0.577350, 0.577350, 0.577350>, <-0.000000, -0.707100, 0.707114>, <0.000000, -0.707107, 0.707107>, 
			<0.000000, -0.707100, -0.707114>, <0.000000, -0.707107, -0.707107>, <0.707107, 0.000000, -0.707107>, <0.707107, 0.000000, 0.707107>, <0.707107, 0.000000, -0.707107>, <0.707107, 0.000000, 0.707107>, <-0.577350, 0.577350, 0.577350>, <-0.577350, 0.577350, -0.577350>, <-0.577350, 0.577350, -0.577350>, <-0.577350, 0.577350, 0.577350>, <0.000000, -0.707100, 0.707114>, 
			<0.000000, -0.707107, 0.707107>, <0.000000, -0.707100, -0.707114>, <-0.000000, -0.707107, -0.707107>, <-0.707107, 0.000000, -0.707107>, <-0.707107, -0.000000, 0.707107>, <-1.000000, 0.000000, 0.000000>, <-0.160182, 0.000000, 0.987087>, <-0.981372, -0.000000, 0.192118>, <-1.000000, 0.000000, 0.000000>, <-0.707107, 0.000000, -0.707107>, <-0.981372, 0.000000, -0.192118>, 
			<-0.160182, -0.000000, -0.987087>, <0.703544, 0.000008, 0.710652>, <0.139461, 0.000053, 0.990228>, <-0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, 1.000000>, <-0.707107, 0.000000, 0.707107>, <-0.160182, 0.000000, 0.987087>, <-0.987087, 0.000000, 0.160182>, <0.000000, 0.000000, 1.000000>, <0.707107, -0.000000, -0.707107>, <-1.000000, 0.000000, 0.000000>, 
			<0.000000, 0.000000, -1.000000>, <0.703544, 0.000008, -0.710652>, <0.139461, 0.000053, -0.990228>, <0.707107, 0.000000, 0.707107>, <-0.987087, 0.000000, -0.160182>, <-0.160182, 0.000000, -0.987087>, <-0.707107, 0.000000, 0.707107>, <0.763023, 0.183304, 0.619835>, <0.763023, 0.619835, 0.183304>, <0.763023, 0.183304, -0.619835>, <0.688137, 0.688137, -0.230078>, 
			<0.707107, 0.707107, 0.000000>, <0.763023, 0.183304, -0.619835>, <0.619835, 0.763023, -0.183304>, <-0.707107, 0.000000, 0.707107>, <-0.707107, 0.000000, -0.707107>, <-0.707107, 0.000000, -0.707107>, <0.707107, 0.707107, 0.000000>, <0.763023, 0.183304, 0.619835>, <0.763023, 0.619835, 0.183304>, <0.000000, 0.000000, 1.000000>, <0.000000, -0.707100, 0.707114>, 
			<-0.000000, -0.160177, 0.987088>, <-0.000000, -0.987087, 0.160187>, <0.153460, 0.698731, 0.698731>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -0.000000, -1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, -0.707107, 0.707107>, <0.000000, -0.160182, 0.987087>, 
			<0.000000, -0.987087, 0.160182>, <0.000000, -0.707100, -0.707114>, <0.000000, -0.987087, -0.160187>, <0.000000, -0.160177, -0.987088>, <0.000000, -0.707107, -0.707107>, <0.000000, -0.981372, -0.192118>, <-0.000000, -0.160182, -0.987087>, <0.183304, 0.619835, -0.763023>, <0.000119, 0.139431, -0.990232>, <0.230078, 0.688137, -0.688137>, <0.183304, 0.763023, 0.619835>, 
			<0.000119, 0.139431, 0.990232>, <0.707107, 0.000000, -0.707107>, <0.707107, -0.000000, 0.707107>, <1.000000, 0.000000, 0.000000>, <0.160182, 0.000000, 0.987087>, <0.987087, -0.000000, 0.160182>, <1.000000, 0.000000, 0.000000>, <0.707107, 0.000000, -0.707107>, <0.981372, 0.000000, -0.192118>, <0.160182, -0.000000, -0.987087>, <-0.703544, 0.000008, 0.710652>, 
			<-0.139461, 0.000053, 0.990228>, <0.000000, 0.000000, -1.000000>, <-0.000000, 0.000000, 1.000000>, <0.707107, 0.000000, 0.707107>, <0.160182, 0.000000, 0.987087>, <0.987087, 0.000000, 0.160182>, <-0.000000, 0.000000, 1.000000>, <-0.707107, -0.000000, -0.707107>, <1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <-0.703544, 0.000008, -0.710652>, 
			<-0.139461, 0.000053, -0.990228>, <-0.707107, 0.000000, 0.707107>, <0.987087, 0.000000, -0.160182>, <0.160182, 0.000000, -0.987087>, <0.707107, 0.000000, 0.707107>, <-0.763023, 0.183304, 0.619835>, <-0.619835, 0.763023, 0.183304>, <-0.763023, 0.183304, -0.619835>, <-0.688137, 0.688137, -0.230078>, <-0.707107, 0.707107, 0.000000>, <-0.763023, 0.183304, -0.619835>, 
			<-0.763023, 0.619835, -0.183304>, <0.707107, 0.000000, 0.707107>, <0.707107, 0.000000, -0.707107>, <0.707107, 0.000000, -0.707107>, <-0.707107, 0.707107, 0.000000>, <-0.763023, 0.183304, 0.619835>, <-0.619835, 0.763023, 0.183304>, <-0.000000, 0.000000, 1.000000>, <0.000000, -0.707100, 0.707114>, <0.000000, -0.160177, 0.987088>, <0.000000, -0.987087, 0.160187>, 
			<-0.183304, 0.619835, 0.763023>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.000000, -0.000000, -1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, -0.707107, 0.707107>, <0.000000, -0.160182, 0.987087>, <0.000000, -0.987087, 0.160182>, <0.000000, -0.707100, -0.707114>, 
			<0.000000, -0.987087, -0.160187>, <0.000000, -0.160177, -0.987088>, <-0.000000, -0.707107, -0.707107>, <-0.000000, -0.987087, -0.160182>, <0.000000, -0.160182, -0.987087>, <-0.153460, 0.698731, -0.698731>, <-0.000119, 0.139431, -0.990232>, <-0.183304, 0.763023, -0.619835>, <-0.230078, 0.688137, 0.688137>, <-0.000119, 0.139431, 0.990232>, <0.000000, 0.648182, 0.761485>, 
			<0.000000, -0.813728, -0.581246>, <0.000000, 0.707107, -0.707107>, <0.000000, -0.813733, 0.581238>, <0.000000, -0.813733, -0.581238>, <-0.000000, 0.648182, -0.761485>, <0.000000, 0.707107, 0.707107>, <0.000000, -0.813728, 0.581246>, <0.000000, -1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.987087, 0.000000, -0.160182>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, -1.000000, 0.000000>, <-0.160182, 0.000000, -0.987087>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.987087, 0.000000, 0.160182>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.987087, 0.000000, 0.160182>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.160179, 0.000007, 0.987088>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<-0.160182, -0.000000, 0.987087>, <-0.990535, 0.000000, -0.137262>, <-0.160182, 0.000000, -0.987087>, <0.987087, 0.000000, 0.160182>, <0.000000, -0.000000, -1.000000>, <-0.160182, 0.000000, 0.987087>, <0.160182, 0.000000, -0.987087>, <0.987087, 0.000000, -0.160182>, <0.160179, 0.000007, -0.987088>, <0.990535, 0.000000, -0.137262>, <0.987087, 0.000000, 0.160182>, 
			<0.160182, 0.000000, 0.987087>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-0.160182, 0.000000, 0.987087>, <-0.987087, 0.000000, 0.160182>, <0.969304, 0.173853, 0.173853>, <0.227725, 0.173434, 0.958156>, <0.108644, -0.031538, -0.993580>, 
			<0.969373, 0.195382, -0.148802>, <0.987087, 0.160182, 0.000000>, <0.958156, 0.227725, -0.173434>, <-0.160182, 0.000000, 0.987087>, <-0.990535, 0.000000, 0.137262>, <-0.990535, 0.000000, -0.137262>, <-0.160182, 0.000000, -0.987087>, <0.000000, 0.000000, 1.000000>, <-0.987087, 0.000000, -0.160182>, <-0.160182, 0.000000, -0.987087>, <-1.000000, 0.000000, 0.000000>, 
			<0.987087, 0.160182, 0.000000>, <0.000000, 0.000000, -1.000000>, <-0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, -1.000000>, <0.969304, 0.173853, 0.173853>, <0.108644, -0.031538, 0.993580>, <0.000000, 0.000000, 1.000000>, <0.000000, -0.160177, 0.987088>, <0.000000, -0.987087, 0.160187>, <0.227725, 0.958156, 0.173434>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, 0.000000, -1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -0.000000, -1.000000>, <0.192118, 0.981372, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, -0.160182, 0.987087>, <0.000000, -0.987087, 0.160182>, <0.160182, 0.987087, 0.000000>, <0.000000, -0.987087, -0.160187>, <0.000000, -0.160177, -0.987088>, 
			<0.000000, -0.990535, -0.137262>, <0.000000, -0.160182, -0.987087>, <0.170936, 0.970341, -0.170936>, <0.148802, 0.969373, -0.195382>, <0.227725, 0.958156, 0.173434>, <-0.031470, 0.108603, 0.993587>, <0.195382, 0.148802, -0.969373>, <0.195242, 0.195242, 0.961125>, <-0.031470, 0.108603, -0.993587>, <0.195242, 0.195242, -0.961125>, <0.000000, -1.000000, 0.000000>, 
			<1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.987087, 0.000000, -0.160182>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, -1.000000, 0.000000>, <0.160182, 0.000000, -0.987087>, <1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.987087, 0.000000, 0.160182>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.987087, 0.000000, 0.160182>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, -0.000000>, 
			<0.000000, -1.000000, 0.000000>, <-0.000000, 0.000000, 1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.160179, 0.000007, 0.987088>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.160182, -0.000000, 0.987087>, <0.990535, 0.000000, -0.137262>, <0.160182, 0.000000, -0.987087>, <-0.987087, 0.000000, 0.160182>, <-0.000000, -0.000000, -1.000000>, <0.160182, 0.000000, 0.987087>, <-0.160182, 0.000000, -0.987087>, <-0.987087, 0.000000, -0.160182>, 
			<-0.160179, 0.000007, -0.987088>, <-0.990535, 0.000000, -0.137262>, <-0.987087, 0.000000, 0.160182>, <-0.160182, 0.000000, 0.987087>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.160182, 0.000000, 0.987087>, <0.987087, 0.000000, 0.160182>, 
			<-0.958156, 0.227725, 0.173434>, <-0.227725, 0.173434, 0.958156>, <-0.108644, -0.031538, -0.993580>, <-0.969373, 0.195382, -0.148802>, <-0.987087, 0.160182, 0.000000>, <-0.969304, 0.173853, -0.173853>, <0.160182, 0.000000, 0.987087>, <0.987087, 0.000000, 0.160182>, <0.990535, 0.000000, -0.137262>, <0.160182, 0.000000, -0.987087>, <-0.000000, 0.000000, 1.000000>, 
			<0.987087, 0.000000, -0.160182>, <0.160182, 0.000000, -0.987087>, <1.000000, 0.000000, 0.000000>, <-0.981372, 0.192118, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, -1.000000>, <-0.958156, 0.227725, 0.173434>, <-0.108644, -0.031538, 0.993580>, <0.000000, 0.000000, 1.000000>, <0.000000, -0.160177, 0.987088>, 
			<0.000000, -0.987087, 0.160187>, <-0.148802, 0.969373, 0.195382>, <0.000000, 0.160182, 0.987087>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.000000, -0.000000, -1.000000>, <-0.160182, 0.987087, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, -0.160182, 0.987087>, 
			<0.000000, -0.987087, 0.160182>, <-0.160182, 0.987087, 0.000000>, <0.000000, -0.987087, -0.160187>, <0.000000, -0.137258, -0.990535>, <-0.000000, -0.990535, -0.137262>, <-0.000000, -0.160182, -0.987087>, <-0.195382, 0.969373, -0.148802>, <0.000000, 1.000000, 0.000000>, <-0.227725, 0.958156, -0.173434>, <-0.148802, 0.969373, 0.195382>, <0.031470, 0.108603, 0.993587>, 
			<0.000000, 0.987087, 0.160182>, <0.000000, 0.106632, 0.994299>, <0.000000, -1.000000, 0.000000>, <0.000000, -0.991764, -0.128082>, <0.000000, -0.213258, -0.976996>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.987087, -0.160182>, <0.000000, 0.000000, 1.000000>, <0.000000, -0.213264, 0.976995>, <0.000000, -0.991764, 0.128078>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -0.991764, -0.128078>, <0.000000, -0.213264, -0.976995>, <0.000000, 0.106632, -0.994299>, <0.000000, 0.990535, -0.137262>, <-0.000000, 0.000000, 1.000000>, <0.000000, 0.987087, 0.160182>, <0.000000, 1.000000, 0.000000>, <-0.000000, -0.213258, 0.976996>, <0.000000, -0.991764, 0.128082>, 
			<0.000000, 1.000000, 0.000000>, <-0.227725, 0.173434, -0.958156>, <-0.195242, 0.195242, 0.961125>, <0.031470, 0.108603, -0.993587>, <-0.195242, 0.195242, -0.961125>, <0.000000, 0.137262, -0.990535>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<-0.813733, 0.000000, -0.581238>, <-0.813733, 0.000000, -0.581238>, <-0.813733, 0.000000, -0.581238>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, -0.000000>, 
			<0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.813733, 0.000000, -0.581238>, <-0.813733, 0.000000, -0.581238>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.813733, 0.000000, -0.581238>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.813733, 0.000000, 0.581238>, <-0.813733, 0.000000, 0.581238>, <0.000000, -1.000000, 0.000000>, <-0.813733, 0.000000, 0.581238>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, -1.000000, 0.000000>, <-0.813733, 0.000000, 0.581238>, <-0.813733, 0.000000, 0.581238>, <-0.813733, 0.000000, 0.581238>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, 0.000000, -1.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.581238, 0.000000, 0.813733>, <0.581238, 0.000000, 0.813733>, <0.581238, 0.000000, 0.813733>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.581238, 0.000000, -0.813733>, <0.581238, 0.000000, -0.813733>, <0.581238, 0.000000, -0.813733>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.581238, 0.000000, 0.813733>, <0.581238, 0.000000, 0.813733>, <0.581238, 0.000000, 0.813733>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.581238, 0.000000, -0.813733>, <0.581238, 0.000000, -0.813733>, <0.581238, 0.000000, -0.813733>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-0.000000, 0.000000, -1.000000>, 
			<0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <-0.000000, 0.000000, -1.000000>, <-0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, 
			<0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, 
			<-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, 
			<0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-1.000000, 0.000000, 0.000000>, 
			<-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, 
			<-0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <-0.000000, 0.000000, -1.000000>, 
			<-0.000000, 0.000000, -1.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
			<1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
			<1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.613306, -0.035130, 0.789064>, <0.613306, -0.035130, 0.789064>, <0.613306, -0.035130, 0.789064>, <0.581238, 0.000000, 0.813733>, <0.613306, -0.035130, 0.789064>, <0.613306, -0.035130, 0.789064>, <0.581238, 0.000000, 0.813733>, <0.581238, 0.000000, 0.813733>, 
			<0.813733, -0.000000, -0.581238>, <0.813733, -0.000000, -0.581238>, <0.813733, -0.000000, -0.581238>, <0.581238, 0.000000, -0.813733>, <0.581238, 0.000000, -0.813733>, <0.581238, 0.000000, -0.813733>, <0.613306, -0.035130, -0.789064>, <0.613306, -0.035130, -0.789064>, <0.613306, -0.035130, -0.789064>, <0.613306, -0.035130, -0.789064>, <0.613306, -0.035130, -0.789064>, 
			<0.581238, 0.000000, -0.813733>, <0.581238, 0.000000, -0.813733>, <0.581238, 0.000000, -0.813733>, <0.813733, 0.000000, 0.581238>, <0.813733, 0.000000, 0.581238>, <0.813733, 0.000000, 0.581238>, <0.581238, 0.000000, 0.813733>, <0.581238, 0.000000, 0.813733>, <0.581238, 0.000000, 0.813733>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, 
			<-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, 
			<-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, 
			<-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, 
			<0.000000, -1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, 
			<0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, 
			<1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <-0.000000, 0.000000, -1.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, 
			<0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, -1.000000>, <-0.000000, 0.000000, -1.000000>, <-0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.707107, 0.707107, 0.000000>, 
			<0.707107, 0.707107, 0.000000>, <0.581238, 0.813733, 0.000000>, <0.581238, 0.813733, 0.000000>, <0.581238, 0.813733, 0.000000>, <0.707107, 0.707107, 0.000000>, <0.707107, 0.707107, 0.000000>, <0.581238, 0.813733, 0.000000>, <0.813733, 0.581238, 0.000000>, <0.813733, 0.581238, 0.000000>, <0.581238, 0.813733, 0.000000>, <0.581238, 0.813733, 0.000000>, 
			<0.813733, 0.581238, 0.000000>, <0.581238, 0.813733, 0.000000>, <0.813733, 0.581238, 0.000000>, <0.813733, 0.581238, 0.000000>, <0.581238, 0.813733, 0.000000>, <0.581238, 0.813733, 0.000000>, <0.813733, 0.581238, 0.000000>, <0.813733, 0.581238, 0.000000>, <0.813733, 0.581238, 0.000000>, <0.581238, 0.813733, 0.000000>, <0.813733, 0.581238, 0.000000>, 
			<0.581238, 0.813733, 0.000000>, <0.581238, 0.813733, 0.000000>, <-0.581238, 0.000000, 0.813733>, <-0.581238, 0.000000, 0.813733>, <-0.581238, 0.000000, 0.813733>, <0.000000, -0.581238, 0.813734>, <0.000000, -0.581238, 0.813734>, <0.000000, -0.581238, 0.813734>, <-0.581238, 0.000000, 0.813733>, <-0.581238, 0.000000, 0.813733>, <-0.581238, 0.000000, 0.813733>, 
			<0.000000, -0.581230, 0.813739>, <0.000000, -0.581230, 0.813739>, <0.000000, -0.581230, 0.813739>, <-0.581238, 0.000000, -0.813733>, <-0.581238, 0.000000, -0.813733>, <-0.581238, 0.000000, -0.813733>, <0.000000, -0.581238, -0.813734>, <0.000000, -0.581238, -0.813734>, <0.000000, -0.581238, -0.813734>, <-0.581238, 0.000000, -0.813733>, <-0.581238, 0.000000, -0.813733>, 
			<-0.581238, 0.000000, -0.813733>, <0.000000, -0.581230, -0.813739>, <0.000000, -0.581230, -0.813739>, <0.000000, -0.581230, -0.813739>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, 0.000000, -1.000000>, <0.000000, -0.000000, -1.000000>, <0.000000, -0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, -0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, -0.000000>, 
			<0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, 
			<0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, 
			<0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, -0.000000, -1.000000>, <0.000000, -0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, -0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, 
			<0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, 
			<0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, 
			<0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <-0.000000, 0.707107, 0.707107>, <-0.000000, 0.707107, 0.707107>, <0.000000, 0.813733, 0.581238>, <0.000000, 0.813733, 0.581238>, <0.000000, 0.813733, 0.581238>, <-0.000000, 0.813733, -0.581238>, <-0.000000, 0.813733, -0.581238>, <-0.000000, 0.813733, -0.581238>, <-0.042632, 0.485855, -0.872999>, 
			<-0.042632, 0.485855, -0.872999>, <-0.042632, 0.485855, -0.872999>, <-0.042632, 0.485855, -0.872999>, <-0.000000, 0.707107, -0.707107>, <-0.000000, 0.707107, -0.707107>, <-0.000000, 0.707107, -0.707107>, <-0.000000, 0.707107, -0.707107>, <0.000000, 0.581238, -0.813734>, <0.000000, 0.581238, -0.813734>, <0.000000, 0.581238, -0.813734>, <-0.000000, 0.581238, 0.813734>, 
			<-0.035055, 0.613275, 0.789092>, <-0.035055, 0.613275, 0.789092>, <-0.000000, 0.581238, 0.813734>, <-0.000000, 0.581238, 0.813734>, <-0.035055, 0.613275, 0.789092>, <-0.035055, 0.613275, 0.789092>, <-0.035055, 0.613275, 0.789092>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.813733, 0.000000, -0.581238>, <0.813733, 0.000000, -0.581238>, <0.813733, 0.000000, -0.581238>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, 
			<1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, 0.000000, -1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.813733, 0.000000, -0.581238>, <0.813733, 0.000000, -0.581238>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.813733, 0.000000, -0.581238>, <1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.813733, 0.000000, 0.581238>, <0.813733, 0.000000, 0.581238>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.813733, 0.000000, 0.581238>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.813733, 0.000000, 0.581238>, <0.813733, 0.000000, 0.581238>, <0.813733, 0.000000, 0.581238>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, 0.000000, -1.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.000000, 0.000000, -1.000000>, <-0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, 
			<-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.581238, 0.000000, 0.813733>, <-0.581238, 0.000000, 0.813733>, <-0.581238, 0.000000, 0.813733>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <-0.581238, 0.000000, -0.813733>, <-0.581238, 0.000000, -0.813733>, <-0.581238, 0.000000, -0.813733>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.581238, 0.000000, 0.813733>, <-0.581238, 0.000000, 0.813733>, <-0.581238, 0.000000, 0.813733>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<-0.581238, 0.000000, -0.813733>, <-0.581238, 0.000000, -0.813733>, <-0.581238, 0.000000, -0.813733>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, 
			<-0.000000, 0.000000, -1.000000>, <-0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <-0.000000, 0.000000, -1.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, 
			<0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
			<1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <-0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, 
			<-0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <-0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
			<1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <-0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, 
			<-0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, -1.000000>, <-0.000000, 0.000000, -1.000000>, <-0.000000, 0.000000, -1.000000>, <-0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <-1.000000, 0.000000, 0.000000>, 
			<-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, 
			<-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, 
			<-1.000000, 0.000000, 0.000000>, <-0.613306, -0.035130, 0.789064>, <-0.613306, -0.035130, 0.789064>, <-0.613306, -0.035130, 0.789064>, <-0.581238, 0.000000, 0.813733>, <-0.613306, -0.035130, 0.789064>, <-0.613306, -0.035130, 0.789064>, <-0.581238, 0.000000, 0.813733>, <-0.581238, 0.000000, 0.813733>, <-0.813733, -0.000000, -0.581238>, <-0.813733, -0.000000, -0.581238>, 
			<-0.813733, -0.000000, -0.581238>, <-0.581238, 0.000000, -0.813733>, <-0.581238, 0.000000, -0.813733>, <-0.581238, 0.000000, -0.813733>, <-0.613306, -0.035130, -0.789064>, <-0.613306, -0.035130, -0.789064>, <-0.613306, -0.035130, -0.789064>, <-0.613306, -0.035130, -0.789064>, <-0.613306, -0.035130, -0.789064>, <-0.581238, 0.000000, -0.813733>, <-0.581238, 0.000000, -0.813733>, 
			<-0.581238, 0.000000, -0.813733>, <-0.813733, 0.000000, 0.581238>, <-0.813733, 0.000000, 0.581238>, <-0.813733, 0.000000, 0.581238>, <-0.581238, 0.000000, 0.813733>, <-0.581238, 0.000000, 0.813733>, <-0.581238, 0.000000, 0.813733>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
			<0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <1.000000, 0.000000, 0.000000>, 
			<1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.000000, 0.000000, 1.000000>, 
			<0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <1.000000, 0.000000, 0.000000>, <-0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
			<1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, 
			<0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <-1.000000, 0.000000, 0.000000>, 
			<0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, 
			<0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, -1.000000>, <-0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <-0.000000, 0.000000, -1.000000>, <-0.000000, 0.000000, -1.000000>, <-0.707107, 0.707107, 0.000000>, <-0.707107, 0.707107, 0.000000>, <-0.813733, 0.581238, 0.000000>, 
			<-0.813733, 0.581238, 0.000000>, <-0.813733, 0.581238, 0.000000>, <-0.707107, 0.707107, 0.000000>, <-0.707107, 0.707107, 0.000000>, <-0.813733, 0.581238, 0.000000>, <-0.813733, 0.581238, 0.000000>, <-0.581238, 0.813733, 0.000000>, <-0.813733, 0.581238, 0.000000>, <-0.581238, 0.813733, 0.000000>, <-0.581238, 0.813733, 0.000000>, <-0.813733, 0.581238, 0.000000>, 
			<-0.813733, 0.581238, 0.000000>, <-0.581238, 0.813733, 0.000000>, <-0.813733, 0.581238, 0.000000>, <-0.581238, 0.813733, 0.000000>, <-0.581238, 0.813733, 0.000000>, <-0.581238, 0.813733, 0.000000>, <-0.813733, 0.581238, 0.000000>, <-0.813733, 0.581238, 0.000000>, <-0.581238, 0.813733, 0.000000>, <-0.581238, 0.813733, 0.000000>, <-0.813733, 0.581238, 0.000000>, 
			<0.581238, 0.000000, 0.813733>, <0.581238, 0.000000, 0.813733>, <0.581238, 0.000000, 0.813733>, <0.000000, -0.581238, 0.813734>, <0.000000, -0.581238, 0.813734>, <0.000000, -0.581238, 0.813734>, <0.581238, 0.000000, 0.813733>, <0.581238, 0.000000, 0.813733>, <0.581238, 0.000000, 0.813733>, <0.000000, -0.581230, 0.813739>, <0.000000, -0.581230, 0.813739>, 
			<0.000000, -0.581230, 0.813739>, <0.581238, 0.000000, -0.813733>, <0.581238, 0.000000, -0.813733>, <0.581238, 0.000000, -0.813733>, <-0.000000, -0.581238, -0.813734>, <-0.000000, -0.581238, -0.813734>, <-0.000000, -0.581238, -0.813734>, <0.581238, 0.000000, -0.813733>, <0.581238, 0.000000, -0.813733>, <0.581238, 0.000000, -0.813733>, <0.000000, -0.581230, -0.813739>, 
			<0.000000, -0.581230, -0.813739>, <0.000000, -0.581230, -0.813739>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.000000, 0.000000, -1.000000>, <-0.000000, -0.000000, -1.000000>, <-0.000000, -0.000000, -1.000000>, 
			<-0.000000, 0.000000, -1.000000>, <-0.000000, 0.000000, -1.000000>, <-0.000000, -0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, 
			<0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, 
			<0.000000, 0.000000, 1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, 
			<0.000000, 0.000000, 1.000000>, <-0.000000, -0.000000, -1.000000>, <-0.000000, -0.000000, -1.000000>, <-0.000000, -0.000000, -1.000000>, <-0.000000, 0.000000, -1.000000>, <-0.000000, 0.000000, -1.000000>, <-0.000000, 0.000000, -1.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, 
			<0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, 
			<0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 0.813733, 0.581238>, <0.000000, 0.813733, 0.581238>, 
			<0.000000, 0.813733, 0.581238>, <0.000000, 0.581238, 0.813734>, <0.000000, 0.581238, 0.813734>, <0.000000, 0.581238, 0.813734>, <0.000000, 0.707107, -0.707107>, <0.035055, 0.613275, -0.789092>, <0.035055, 0.613275, -0.789092>, <0.035055, 0.613275, -0.789092>, <0.000000, 0.707107, -0.707107>, <0.035055, 0.613275, -0.789092>, <0.035055, 0.613275, -0.789092>, 
			<0.000000, 0.581238, -0.813734>, <0.000000, 0.813733, -0.581238>, <0.000000, 0.813733, -0.581238>, <0.000000, 0.581238, -0.813734>, <0.000000, 0.581238, -0.813734>, <0.000000, 0.813733, -0.581238>, <0.000000, 0.707107, 0.707107>, <0.000000, 0.707107, 0.707107>, <0.042632, 0.485855, 0.872999>, <0.042632, 0.485855, 0.872999>, <0.042632, 0.485855, 0.872999>, 
			<0.042632, 0.485855, 0.872999>, <0.000000, 0.707107, 0.707107>, <0.000000, 0.707107, 0.707107>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.987087, 0.000000, -0.160182>, <-0.987087, 0.000000, -0.160182>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.213265, 0.000000, -0.976994>, <-0.213265, 0.000000, -0.976994>, <-0.213265, 0.000000, -0.976994>, 
			<-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <-1.000000, 0.000000, 0.000000>, 
			<-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-0.987087, 0.000000, -0.160182>, <-0.987087, 0.000000, -0.160182>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.213265, 0.000000, -0.976994>, <-0.213265, 0.000000, -0.976994>, <-0.213265, 0.000000, -0.976994>, 
			<-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.994299, 0.000000, 0.106632>, <-0.994299, 0.000000, 0.106632>, <-0.994299, 0.000000, 0.106632>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<-0.213265, 0.000000, 0.976994>, <-0.213265, 0.000000, 0.976994>, <-0.213265, 0.000000, 0.976994>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.213265, 0.000000, 0.976994>, <-0.213265, 0.000000, 0.976994>, <-0.213265, 0.000000, 0.976994>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.994299, 0.000000, 0.106632>, <-0.994299, 0.000000, 0.106632>, <-0.994299, 0.000000, 0.106632>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.106632, 0.000000, 0.994299>, <0.106632, 0.000000, 0.994299>, <0.106632, 0.000000, 0.994299>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, 
			<0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, -0.000000>, 
			<0.000000, -1.000000, -0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.000000, 0.000000, -1.000000>, <-0.000000, 0.000000, -1.000000>, <-0.000000, 0.000000, -1.000000>, 
			<0.000000, -0.000000, -1.000000>, <0.000000, -0.000000, -1.000000>, <0.000000, -0.000000, -1.000000>, <0.000000, -0.000000, -1.000000>, <0.000000, -0.000000, -1.000000>, <0.000000, -0.000000, -1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
			<1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.106632, 0.000000, -0.994299>, <0.106632, 0.000000, -0.994299>, <0.106632, 0.000000, -0.994299>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
			<1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.987087, 0.000000, -0.160182>, 
			<0.987087, 0.000000, -0.160182>, <0.987087, 0.000000, -0.160182>, <0.987087, 0.000000, -0.160182>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.106632, 0.000000, 0.994299>, <0.106632, 0.000000, 0.994299>, <0.106632, 0.000000, 0.994299>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.976994, 0.000000, 0.213265>, <0.976994, 0.000000, 0.213265>, <0.976994, 0.000000, 0.213265>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.106632, 0.000000, -0.994299>, <0.106632, 0.000000, -0.994299>, <0.106632, 0.000000, -0.994299>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.976994, 0.000000, -0.213265>, <0.976994, 0.000000, -0.213265>, <0.976994, 0.000000, -0.213265>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.976994, 0.000000, 0.213265>, <0.976994, 0.000000, 0.213265>, <0.976994, 0.000000, 0.213265>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-0.000000, -0.000000, -1.000000>, <-0.000000, -0.000000, -1.000000>, <-0.000000, -0.000000, -1.000000>, <-0.000000, -0.000000, -1.000000>, 
			<-0.000000, -0.000000, -1.000000>, <-0.000000, -0.000000, -1.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, 
			<0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, 
			<0.000000, 0.000000, 1.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, 
			<0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
			<0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <-0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, 
			<0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <-0.000000, 0.000000, -1.000000>, <-0.000000, 0.000000, -1.000000>, <-0.000000, 0.000000, -1.000000>, <0.987087, 0.160182, 0.000000>, <0.987087, 0.160182, 0.000000>, <0.976994, 0.213265, 0.000000>, <0.976994, 0.213265, 0.000000>, 
			<0.976994, 0.213265, 0.000000>, <0.976994, 0.213265, 0.000000>, <0.976994, 0.213265, 0.000000>, <0.976994, 0.213265, 0.000000>, <0.994299, 0.106632, 0.000000>, <0.994299, 0.106632, 0.000000>, <0.994299, 0.106632, 0.000000>, <0.976994, 0.213265, 0.000000>, <0.976994, 0.213265, 0.000000>, <0.976994, 0.213265, 0.000000>, <0.994299, 0.106632, 0.000000>, 
			<0.994299, 0.106632, 0.000000>, <0.994299, 0.106632, 0.000000>, <0.994299, 0.106632, 0.000000>, <0.994299, 0.106632, 0.000000>, <0.994299, 0.106632, 0.000000>, <0.976994, 0.213265, 0.000000>, <0.976994, 0.213265, 0.000000>, <0.976994, 0.213265, 0.000000>, <0.994299, 0.000000, 0.106632>, <0.994299, 0.000000, 0.106632>, <0.994299, 0.000000, 0.106632>, 
			<0.976994, 0.000000, 0.213265>, <0.976994, 0.000000, 0.213265>, <0.976994, 0.000000, 0.213265>, <0.987087, 0.000000, -0.160182>, <0.987087, 0.000000, -0.160182>, <0.987087, 0.000000, -0.160182>, <0.987087, 0.000000, -0.160182>, <0.987087, 0.000000, -0.160182>, <0.987087, 0.000000, -0.160182>, <0.987087, 0.000000, -0.160182>, <0.987087, 0.000000, -0.160182>, 
			<0.976994, 0.000000, -0.213265>, <0.976994, 0.000000, -0.213265>, <0.976994, 0.000000, -0.213265>, <0.994299, 0.000000, 0.106632>, <0.994299, 0.000000, 0.106632>, <0.994299, 0.000000, 0.106632>, <0.976994, 0.000000, 0.213265>, <0.976994, 0.000000, 0.213265>, <0.976994, 0.000000, 0.213265>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
			<1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, 
			<-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, 
			<0.000000, 0.000000, -1.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, 
			<0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, 
			<0.000000, 0.000000, 1.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, 
			<0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, -0.000000, -1.000000>, <0.000000, -0.000000, -1.000000>, <0.000000, -0.000000, -1.000000>, 
			<0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.106632, 0.994299, 0.000000>, <0.106632, 0.994299, 0.000000>, <0.106632, 0.994299, 0.000000>, <0.160182, 0.987087, 0.000000>, <0.160182, 0.987087, 0.000000>, <0.106632, 0.994299, 0.000000>, <0.106632, 0.994299, 0.000000>, <0.106632, 0.994299, 0.000000>, 
			<0.160182, 0.987087, 0.000000>, <0.160182, 0.987087, 0.000000>, <0.160182, 0.987087, 0.000000>, <0.160182, 0.987087, 0.000000>, <0.106632, 0.994299, 0.000000>, <0.106632, 0.994299, 0.000000>, <0.106632, 0.994299, 0.000000>, <0.213265, 0.976994, 0.000000>, <0.213265, 0.976994, 0.000000>, <0.213265, 0.976994, 0.000000>, <0.213265, 0.976994, 0.000000>, 
			<0.213265, 0.976994, 0.000000>, <0.213265, 0.976994, 0.000000>, <0.106632, 0.994299, 0.000000>, <0.106632, 0.994299, 0.000000>, <0.106632, 0.994299, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.106632, 0.000000, 0.994299>, <-0.106632, 0.000000, 0.994299>, <-0.106632, 0.000000, 0.994299>, <0.000000, -0.106632, 0.994299>, <0.000000, -0.106632, 0.994299>, 
			<0.000000, -0.106632, 0.994299>, <-0.976994, 0.000000, 0.213265>, <-0.976994, 0.000000, 0.213265>, <-0.976994, 0.000000, 0.213265>, <0.000000, -0.987087, 0.160182>, <0.000000, -0.987087, 0.160182>, <0.000000, -0.987087, 0.160182>, <0.000000, -0.987087, 0.160182>, <-0.106632, 0.000000, 0.994299>, <-0.106632, 0.000000, 0.994299>, <-0.106632, 0.000000, 0.994299>, 
			<0.000000, -0.106629, 0.994299>, <0.000000, -0.106629, 0.994299>, <0.000000, -0.106629, 0.994299>, <-0.976994, 0.000000, 0.213265>, <-0.976994, 0.000000, 0.213265>, <-0.976994, 0.000000, 0.213265>, <0.000000, -0.987087, 0.160187>, <0.000000, -0.987087, 0.160187>, <0.000000, -0.987087, 0.160187>, <0.000000, -0.987087, 0.160187>, <-0.976994, 0.000000, -0.213265>, 
			<-0.976994, 0.000000, -0.213265>, <-0.976994, 0.000000, -0.213265>, <0.000000, -0.976994, -0.213265>, <0.000000, -0.976994, -0.213265>, <0.000000, -0.976994, -0.213265>, <-0.106632, 0.000000, -0.994299>, <-0.106632, 0.000000, -0.994299>, <-0.106632, 0.000000, -0.994299>, <0.000000, -0.106632, -0.994299>, <0.000000, -0.106632, -0.994299>, <0.000000, -0.106632, -0.994299>, 
			<0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.987087, 0.000000, -0.160182>, <-0.987087, 0.000000, -0.160182>, <-0.987087, 0.000000, -0.160182>, <-0.987087, 0.000000, -0.160182>, <0.000000, -0.976993, -0.213271>, 
			<0.000000, -0.976993, -0.213271>, <0.000000, -0.976993, -0.213271>, <-0.106632, 0.000000, -0.994299>, <-0.106632, 0.000000, -0.994299>, <-0.106632, 0.000000, -0.994299>, <0.000000, -0.106629, -0.994299>, <0.000000, -0.106629, -0.994299>, <0.000000, -0.106629, -0.994299>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, 
			<0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <-0.000000, 0.000000, -1.000000>, 
			<-0.000000, 0.000000, -1.000000>, <-0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, -0.000000, -1.000000>, <0.000000, -0.000000, -1.000000>, <0.000000, -0.000000, -1.000000>, 
			<0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, 
			<0.000000, 0.000000, -1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, -0.000000>, 
			<0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, -0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, 
			<0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.000000, 0.987087, 0.160182>, 
			<-0.000000, 0.987087, 0.160182>, <-0.000000, 0.987087, 0.160182>, <-0.000000, 0.987087, 0.160182>, <0.000000, 0.987087, 0.160182>, <0.000000, 0.987087, 0.160182>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, 
			<0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 0.987087, -0.160182>, <0.000000, 0.987087, -0.160182>, <-0.000000, 0.976994, -0.213265>, <-0.000000, 0.976994, -0.213265>, 
			<-0.000000, 0.976994, -0.213265>, <0.000000, 0.987087, -0.160182>, <0.000000, 0.987087, -0.160182>, <0.000000, 0.987087, -0.160182>, <0.000000, 0.987087, -0.160182>, <0.000000, 0.987087, -0.160182>, <0.000000, 0.987087, -0.160182>, <-0.000000, 0.987087, 0.160182>, <-0.000000, 0.987087, 0.160182>, <-0.000000, 0.987087, 0.160182>, <-0.000000, 0.987087, 0.160182>, 
			<0.000000, 0.987087, 0.160182>, <0.000000, 0.987087, 0.160182>, <0.158691, -0.079346, -0.984135>, <0.158691, -0.079346, -0.984135>, <0.160182, 0.000000, -0.987087>, <0.160182, 0.000000, -0.987087>, <0.158691, -0.079346, 0.984135>, <0.158691, -0.079346, 0.984135>, <0.106632, 0.000000, 0.994299>, <0.106632, 0.000000, 0.994299>, <0.106632, 0.000000, 0.994299>, 
			<-0.000000, 0.213264, -0.976995>, <-0.000000, 0.213264, -0.976995>, <-0.000000, 0.213264, -0.976995>, <-0.079346, 0.158691, -0.984135>, <-0.079346, 0.158691, -0.984135>, <-0.079346, 0.158691, 0.984135>, <-0.079346, 0.158691, 0.984135>, <-0.000000, 0.106632, 0.994299>, <-0.000000, 0.106632, 0.994299>, <-0.000000, 0.106632, 0.994299>, <0.213265, 0.000000, 0.976994>, 
			<0.213265, 0.000000, 0.976994>, <0.213265, 0.000000, 0.976994>, <0.106632, 0.000000, 0.994299>, <0.106632, 0.000000, 0.994299>, <0.106632, 0.000000, 0.994299>, <0.213265, -0.000000, -0.976994>, <0.213265, -0.000000, -0.976994>, <0.213265, -0.000000, -0.976994>, <0.106632, 0.000000, -0.994299>, <0.106632, 0.000000, -0.994299>, <0.106632, 0.000000, -0.994299>, 
			<-0.000000, 0.160182, 0.987087>, <-0.000000, 0.160182, 0.987087>, <-0.000000, 0.160182, 0.987087>, <-0.000000, 0.160182, 0.987087>, <0.000000, 0.160182, 0.987087>, <0.000000, 0.160182, 0.987087>, <0.000000, 0.160182, 0.987087>, <0.000000, 0.160182, 0.987087>, <-0.000000, 0.106632, -0.994299>, <-0.000000, 0.106632, -0.994299>, <-0.000000, 0.106632, -0.994299>, 
			<0.000000, 0.160182, -0.987087>, <0.000000, 0.160182, -0.987087>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.987087, 0.000000, -0.160182>, <0.987087, 0.000000, -0.160182>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.213265, 0.000000, -0.976994>, <0.213265, 0.000000, -0.976994>, <0.213265, 0.000000, -0.976994>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
			<1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
			<1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.994299, 0.000000, -0.106632>, <0.994299, 0.000000, -0.106632>, <0.994299, 0.000000, -0.106632>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.213265, 0.000000, -0.976994>, <0.213265, 0.000000, -0.976994>, <0.213265, 0.000000, -0.976994>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
			<1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.987087, 0.000000, 0.160182>, 
			<0.987087, 0.000000, 0.160182>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.213265, 0.000000, 0.976994>, <0.213265, 0.000000, 0.976994>, <0.213265, 0.000000, 0.976994>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, 
			<0.000000, 0.000000, 1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.213265, 0.000000, 0.976994>, <0.213265, 0.000000, 0.976994>, <0.213265, 0.000000, 0.976994>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.987087, 0.000000, 0.160182>, <0.987087, 0.000000, 0.160182>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.106632, 0.000000, 0.994299>, <-0.106632, 0.000000, 0.994299>, 
			<-0.106632, 0.000000, 0.994299>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, -0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <-0.000000, -0.000000, -1.000000>, <-0.000000, -0.000000, -1.000000>, <-0.000000, -0.000000, -1.000000>, <0.000000, -0.000000, -1.000000>, <0.000000, -0.000000, -1.000000>, 
			<0.000000, -0.000000, -1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, 
			<-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <-0.106632, 0.000000, -0.994299>, <-0.106632, 0.000000, -0.994299>, <-0.106632, 0.000000, -0.994299>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, 
			<-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.976994, 0.000000, -0.213265>, <-0.976994, 0.000000, -0.213265>, <-0.976994, 0.000000, -0.213265>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.106632, 0.000000, 0.994299>, <-0.106632, 0.000000, 0.994299>, 
			<-0.106632, 0.000000, 0.994299>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.987087, 0.000000, 0.160182>, <-0.987087, 0.000000, 0.160182>, <-0.987087, 0.000000, 0.160182>, <-0.987087, 0.000000, 0.160182>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.106632, 0.000000, -0.994299>, <-0.106632, 0.000000, -0.994299>, <-0.106632, 0.000000, -0.994299>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <-0.976994, 0.000000, -0.213265>, <-0.976994, 0.000000, -0.213265>, <-0.976994, 0.000000, -0.213265>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.987087, 0.000000, 0.160182>, <-0.987087, 0.000000, 0.160182>, <-0.987087, 0.000000, 0.160182>, <-0.987087, 0.000000, 0.160182>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, -0.000000, -1.000000>, <0.000000, -0.000000, -1.000000>, <0.000000, -0.000000, -1.000000>, <0.000000, -0.000000, -1.000000>, 
			<0.000000, -0.000000, -1.000000>, <0.000000, -0.000000, -1.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, 
			<0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, 
			<0.000000, 0.000000, 1.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <-0.000000, 0.000000, 1.000000>, 
			<-0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, 
			<0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, 
			<0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, -1.000000>, <-0.000000, 0.000000, -1.000000>, <-0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <-0.987087, 0.160182, 0.000000>, <-0.987087, 0.160182, 0.000000>, <-0.994299, 0.106632, 0.000000>, <-0.994299, 0.106632, 0.000000>, 
			<-0.994299, 0.106632, 0.000000>, <-0.994299, 0.106632, 0.000000>, <-0.994299, 0.106632, 0.000000>, <-0.994299, 0.106632, 0.000000>, <-0.987087, 0.160182, 0.000000>, <-0.987087, 0.160182, 0.000000>, <-0.987087, 0.160182, 0.000000>, <-0.987087, 0.160182, 0.000000>, <-0.994299, 0.106632, 0.000000>, <-0.994299, 0.106632, 0.000000>, <-0.994299, 0.106632, 0.000000>, 
			<-0.976994, 0.213265, 0.000000>, <-0.976994, 0.213265, 0.000000>, <-0.976994, 0.213265, 0.000000>, <-0.976994, 0.213265, 0.000000>, <-0.976994, 0.213265, 0.000000>, <-0.976994, 0.213265, 0.000000>, <-0.994299, 0.106632, 0.000000>, <-0.994299, 0.106632, 0.000000>, <-0.994299, 0.106632, 0.000000>, <-0.987087, 0.000000, 0.160182>, <-0.987087, 0.000000, 0.160182>, 
			<-0.987087, 0.000000, 0.160182>, <-0.987087, 0.000000, 0.160182>, <-0.987087, 0.000000, 0.160182>, <-0.987087, 0.000000, 0.160182>, <-0.994299, 0.000000, -0.106632>, <-0.994299, 0.000000, -0.106632>, <-0.994299, 0.000000, -0.106632>, <-0.976994, 0.000000, -0.213265>, <-0.976994, 0.000000, -0.213265>, <-0.976994, 0.000000, -0.213265>, <-0.987087, 0.000000, -0.160182>, 
			<-0.987087, 0.000000, -0.160182>, <-0.976994, 0.000000, -0.213265>, <-0.976994, 0.000000, -0.213265>, <-0.976994, 0.000000, -0.213265>, <-0.987087, 0.000000, 0.160182>, <-0.987087, 0.000000, 0.160182>, <-0.987087, 0.000000, 0.160182>, <-0.987087, 0.000000, 0.160182>, <-0.987087, 0.000000, 0.160182>, <-0.987087, 0.000000, 0.160182>, <-1.000000, 0.000000, 0.000000>, 
			<-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, 
			<-1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.000000, 0.000000, -1.000000>, <-0.000000, 0.000000, -1.000000>, <-0.000000, 0.000000, -1.000000>, <-0.000000, 0.000000, -1.000000>, <-0.000000, 0.000000, -1.000000>, 
			<-0.000000, 0.000000, -1.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, 
			<0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
			<1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <1.000000, 0.000000, 0.000000>, 
			<1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
			<0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, 
			<-0.000000, 0.000000, 1.000000>, <-0.000000, -0.000000, -1.000000>, <-0.000000, -0.000000, -1.000000>, <-0.000000, -0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <-0.213265, 0.976994, 0.000000>, <-0.213265, 0.976994, 0.000000>, <-0.213265, 0.976994, 0.000000>, <-0.160182, 0.987087, 0.000000>, 
			<-0.160182, 0.987087, 0.000000>, <-0.213265, 0.976994, 0.000000>, <-0.213265, 0.976994, 0.000000>, <-0.213265, 0.976994, 0.000000>, <-0.106632, 0.994299, 0.000000>, <-0.106632, 0.994299, 0.000000>, <-0.106632, 0.994299, 0.000000>, <-0.213265, 0.976994, 0.000000>, <-0.213265, 0.976994, 0.000000>, <-0.213265, 0.976994, 0.000000>, <-0.106632, 0.994299, 0.000000>, 
			<-0.106632, 0.994299, 0.000000>, <-0.106632, 0.994299, 0.000000>, <-0.106632, 0.994299, 0.000000>, <-0.106632, 0.994299, 0.000000>, <-0.106632, 0.994299, 0.000000>, <-0.213265, 0.976994, 0.000000>, <-0.213265, 0.976994, 0.000000>, <-0.213265, 0.976994, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.106632, 0.000000, 0.994299>, 
			<0.106632, 0.000000, 0.994299>, <0.106632, 0.000000, 0.994299>, <0.000000, -0.106632, 0.994299>, <0.000000, -0.106632, 0.994299>, <0.000000, -0.106632, 0.994299>, <0.987087, 0.000000, 0.160182>, <0.987087, 0.000000, 0.160182>, <0.987087, 0.000000, 0.160182>, <0.987087, 0.000000, 0.160182>, <0.000000, -0.976994, 0.213265>, <0.000000, -0.976994, 0.213265>, 
			<0.000000, -0.976994, 0.213265>, <0.106632, 0.000000, 0.994299>, <0.106632, 0.000000, 0.994299>, <0.106632, 0.000000, 0.994299>, <0.000000, -0.106629, 0.994299>, <0.000000, -0.106629, 0.994299>, <0.000000, -0.106629, 0.994299>, <0.987087, 0.000000, 0.160182>, <0.987087, 0.000000, 0.160182>, <0.987087, 0.000000, 0.160182>, <0.987087, 0.000000, 0.160182>, 
			<0.000000, -0.976993, 0.213271>, <0.000000, -0.976993, 0.213271>, <0.000000, -0.976993, 0.213271>, <0.976994, 0.000000, -0.213265>, <0.976994, 0.000000, -0.213265>, <0.976994, 0.000000, -0.213265>, <-0.000000, -0.976994, -0.213265>, <-0.000000, -0.976994, -0.213265>, <-0.000000, -0.976994, -0.213265>, <0.106632, 0.000000, -0.994299>, <0.106632, 0.000000, -0.994299>, 
			<0.106632, 0.000000, -0.994299>, <0.000000, -0.106632, -0.994299>, <0.000000, -0.106632, -0.994299>, <0.000000, -0.106632, -0.994299>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.976994, 0.000000, -0.213265>, 
			<0.976994, 0.000000, -0.213265>, <0.976994, 0.000000, -0.213265>, <0.000000, -0.987087, -0.160187>, <0.000000, -0.987087, -0.160187>, <0.000000, -0.987087, -0.160187>, <0.000000, -0.987087, -0.160187>, <0.106632, 0.000000, -0.994299>, <0.106632, 0.000000, -0.994299>, <0.106632, 0.000000, -0.994299>, <0.000000, -0.160177, -0.987088>, <0.000000, -0.160177, -0.987088>, 
			<1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, 
			<0.000000, 0.000000, -1.000000>, <-0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, 
			<0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <-0.000000, 0.000000, -1.000000>, <-0.000000, 0.000000, -1.000000>, <-0.000000, 0.000000, -1.000000>, 
			<-0.000000, -0.000000, -1.000000>, <-0.000000, -0.000000, -1.000000>, <-0.000000, -0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, 
			<0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, -0.000000>, <-0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, 
			<0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, 
			<0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.987087, 0.160182>, <0.000000, 0.987087, 0.160182>, <0.000000, 0.987087, 0.160182>, <0.000000, 0.987087, 0.160182>, <0.000000, 0.987087, 0.160182>, <0.000000, 0.987087, 0.160182>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, 
			<0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 0.976994, -0.213265>, 
			<0.000000, 0.976994, -0.213265>, <0.000000, 0.976994, -0.213265>, <0.000000, 0.987087, -0.160182>, <0.000000, 0.987087, -0.160182>, <0.000000, 0.987087, -0.160182>, <0.000000, 0.987087, -0.160182>, <0.000000, 0.987087, -0.160182>, <0.000000, 0.987087, -0.160182>, <0.000000, 0.987087, -0.160182>, <0.000000, 0.987087, -0.160182>, <0.000000, 0.987087, 0.160182>, 
			<0.000000, 0.987087, 0.160182>, <0.000000, 0.987087, 0.160182>, <0.000000, 0.987087, 0.160182>, <0.000000, 0.987087, 0.160182>, <0.000000, 0.987087, 0.160182>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, 
			<0.000000, -0.000000, -1.000000>, <0.000000, -0.000000, -1.000000>, <0.000000, -0.000000, -1.000000>, <0.000000, -0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, 
			<0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, 
			<0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <-0.158691, -0.079346, -0.984135>, <-0.158691, -0.079346, -0.984135>, <-0.106632, 0.000000, -0.994299>, 
			<-0.106632, 0.000000, -0.994299>, <-0.106632, 0.000000, -0.994299>, <-0.158691, -0.079346, 0.984135>, <-0.158691, -0.079346, 0.984135>, <-0.106632, 0.000000, 0.994299>, <-0.106632, 0.000000, 0.994299>, <-0.106632, 0.000000, 0.994299>, <0.000000, 0.160182, -0.987087>, <0.000000, 0.160182, -0.987087>, <0.000000, 0.160182, -0.987087>, <0.000000, 0.160182, -0.987087>, 
			<0.079346, 0.158691, -0.984135>, <0.079346, 0.158691, -0.984135>, <0.079346, 0.158691, 0.984135>, <0.079346, 0.158691, 0.984135>, <0.000000, 0.106632, 0.994299>, <0.000000, 0.106632, 0.994299>, <0.000000, 0.106632, 0.994299>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, 
			<0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, 
			<-0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, <-0.000000, 0.000000, 1.000000>, <0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
			<0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, -0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, 
			<0.000000, 0.000000, -1.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, 0.000000, -1.000000>, <0.000000, -0.000000, -1.000000>, 
			<0.000000, -0.000000, -1.000000>, <0.000000, -0.000000, -1.000000>, <0.000000, -0.000000, -1.000000>, <-0.213265, 0.000000, 0.976994>, <-0.213265, 0.000000, 0.976994>, <-0.213265, 0.000000, 0.976994>, <-0.106632, 0.000000, 0.994299>, <-0.106632, 0.000000, 0.994299>, <-0.106632, 0.000000, 0.994299>, <-0.213265, -0.000000, -0.976994>, <-0.213265, -0.000000, -0.976994>, 
			<-0.213265, -0.000000, -0.976994>, <-0.106632, 0.000000, -0.994299>, <-0.106632, 0.000000, -0.994299>, <-0.106632, 0.000000, -0.994299>, <0.000000, 0.160182, 0.987087>, <0.000000, 0.160182, 0.987087>, <0.000000, 0.160182, 0.987087>, <0.000000, 0.160182, 0.987087>, <0.000000, 0.160182, 0.987087>, <0.000000, 0.160182, 0.987087>, <0.000000, 0.106632, -0.994299>, 
			<0.000000, 0.106632, -0.994299>, <0.000000, 0.106632, -0.994299>, <0.000000, 0.213264, -0.976995>, <0.000000, 0.213264, -0.976995>, <0.000000, 0.213264, -0.976995>}
	 texture_list { 1, texture{wm_Door}}
	 face_indices { 1824, <0, 230, 684>, 0, <0, 684, 229>, 0, <229, 684, 1>, 0, <684, 232, 1>, 0, <232, 684, 233>, 0, <233, 3, 232>, 0, <2, 233, 684>, 0, <2, 684, 230>, 0, <234, 685, 228>, 0, <228, 0, 234>, 0, 
			<685, 322, 42>, 0, <42, 228, 685>, 0, <322, 685, 305>, 0, <322, 305, 44>, 0, <4, 305, 685>, 0, <685, 234, 4>, 0, <236, 686, 229>, 0, <229, 1, 236>, 0, <686, 234, 0>, 0, <0, 229, 686>, 0, <234, 686, 235>, 0, 
			<234, 235, 4>, 0, <235, 686, 5>, 0, <686, 236, 5>, 0, <46, 345, 243>, 0, <345, 687, 243>, 0, <10, 243, 687>, 0, <687, 244, 10>, 0, <11, 244, 687>, 0, <687, 246, 11>, 0, <246, 687, 345>, 0, <345, 12, 246>, 0, 
			<239, 688, 235>, 0, <235, 5, 239>, 0, <688, 237, 4>, 0, <4, 235, 688>, 0, <237, 688, 238>, 0, <237, 238, 6>, 0, <238, 688, 7>, 0, <688, 239, 7>, 0, <6, 241, 689>, 0, <689, 237, 6>, 0, <237, 689, 242>, 0, 
			<242, 4, 237>, 0, <689, 240, 9>, 0, <9, 242, 689>, 0, <240, 689, 241>, 0, <240, 241, 8>, 0, <9, 306, 242>, 0, <306, 690, 242>, 0, <4, 242, 690>, 0, <690, 305, 4>, 0, <305, 690, 338>, 0, <338, 44, 305>, 0, 
			<690, 306, 45>, 0, <45, 338, 690>, 0, <8, 245, 691>, 0, <691, 240, 8>, 0, <240, 691, 247>, 0, <247, 9, 240>, 0, <691, 244, 11>, 0, <11, 247, 691>, 0, <244, 691, 245>, 0, <244, 245, 10>, 0, <692, 246, 12>, 0, 
			<12, 346, 692>, 0, <246, 692, 247>, 0, <246, 247, 11>, 0, <9, 247, 692>, 0, <692, 306, 9>, 0, <306, 692, 346>, 0, <346, 45, 306>, 0, <249, 693, 243>, 0, <243, 10, 249>, 0, <693, 337, 46>, 0, <46, 243, 693>, 0, 
			<337, 693, 248>, 0, <337, 248, 47>, 0, <248, 693, 13>, 0, <693, 249, 13>, 0, <251, 694, 245>, 0, <245, 8, 251>, 0, <694, 249, 10>, 0, <10, 245, 694>, 0, <249, 694, 250>, 0, <249, 250, 13>, 0, <250, 694, 14>, 0, 
			<694, 251, 14>, 0, <253, 695, 248>, 0, <248, 13, 253>, 0, <695, 321, 47>, 0, <47, 248, 695>, 0, <321, 695, 252>, 0, <252, 16, 321>, 0, <695, 253, 15>, 0, <15, 252, 695>, 0, <255, 696, 250>, 0, <250, 14, 255>, 0, 
			<696, 253, 13>, 0, <13, 250, 696>, 0, <253, 696, 254>, 0, <253, 254, 15>, 0, <254, 696, 17>, 0, <696, 255, 17>, 0, <14, 257, 697>, 0, <14, 697, 255>, 0, <255, 697, 258>, 0, <255, 258, 17>, 0, <258, 697, 19>, 0, 
			<697, 256, 19>, 0, <256, 697, 257>, 0, <257, 18, 256>, 0, <19, 308, 698>, 0, <19, 698, 258>, 0, <17, 258, 307>, 0, <258, 698, 307>, 0, <307, 698, 48>, 0, <698, 330, 48>, 0, <330, 698, 308>, 0, <308, 49, 330>, 0, 
			<18, 260, 699>, 0, <18, 699, 256>, 0, <256, 699, 261>, 0, <256, 261, 19>, 0, <261, 699, 21>, 0, <699, 259, 21>, 0, <259, 699, 260>, 0, <260, 20, 259>, 0, <264, 700, 261>, 0, <261, 21, 264>, 0, <700, 265, 19>, 0, 
			<19, 261, 700>, 0, <265, 700, 263>, 0, <265, 263, 23>, 0, <263, 700, 22>, 0, <700, 264, 22>, 0, <23, 309, 701>, 0, <701, 265, 23>, 0, <19, 265, 308>, 0, <265, 701, 308>, 0, <701, 319, 49>, 0, <49, 308, 701>, 0, 
			<319, 701, 309>, 0, <319, 309, 50>, 0, <267, 702, 263>, 0, <263, 22, 267>, 0, <702, 268, 23>, 0, <23, 263, 702>, 0, <268, 702, 266>, 0, <268, 266, 25>, 0, <266, 702, 24>, 0, <702, 267, 24>, 0, <25, 331, 703>, 0, 
			<25, 703, 268>, 0, <23, 268, 309>, 0, <268, 703, 309>, 0, <703, 333, 50>, 0, <50, 309, 703>, 0, <333, 703, 331>, 0, <331, 60, 333>, 0, <269, 704, 238>, 0, <238, 7, 269>, 0, <6, 238, 704>, 0, <6, 704, 270>, 0, 
			<18, 270, 260>, 0, <270, 704, 260>, 0, <260, 704, 20>, 0, <704, 269, 20>, 0, <270, 705, 241>, 0, <241, 6, 270>, 0, <705, 251, 8>, 0, <8, 241, 705>, 0, <251, 705, 257>, 0, <251, 257, 14>, 0, <257, 705, 18>, 0, 
			<705, 270, 18>, 0, <7, 301, 706>, 0, <7, 706, 269>, 0, <20, 269, 706>, 0, <20, 706, 299>, 0, <278, 29, 299>, 0, <278, 299, 706>, 0, <278, 706, 301>, 0, <301, 28, 278>, 0, <277, 707, 262>, 0, <262, 31, 277>, 0, 
			<707, 267, 22>, 0, <22, 262, 707>, 0, <267, 707, 276>, 0, <267, 276, 24>, 0, <276, 707, 32>, 0, <707, 277, 32>, 0, <32, 313, 708>, 0, <32, 708, 276>, 0, <24, 276, 310>, 0, <276, 708, 310>, 0, <310, 708, 51>, 0, 
			<708, 334, 51>, 0, <334, 708, 313>, 0, <313, 52, 334>, 0, <1, 232, 709>, 0, <1, 709, 231>, 0, <231, 709, 26>, 0, <709, 283, 26>, 0, <283, 709, 281>, 0, <281, 33, 283>, 0, <3, 281, 709>, 0, <3, 709, 232>, 0, 
			<299, 710, 259>, 0, <259, 20, 299>, 0, <21, 259, 710>, 0, <21, 710, 300>, 0, <30, 300, 284>, 0, <300, 710, 284>, 0, <284, 710, 29>, 0, <710, 299, 29>, 0, <285, 711, 231>, 0, <231, 26, 285>, 0, <711, 236, 1>, 0, 
			<1, 231, 711>, 0, <236, 711, 302>, 0, <236, 302, 5>, 0, <27, 302, 711>, 0, <711, 285, 27>, 0, <30, 284, 274>, 0, <284, 712, 274>, 0, <274, 712, 38>, 0, <712, 291, 38>, 0, <291, 712, 37>, 0, <712, 288, 37>, 0, 
			<29, 288, 712>, 0, <29, 712, 284>, 0, <292, 713, 274>, 0, <274, 38, 292>, 0, <30, 274, 713>, 0, <30, 713, 279>, 0, <31, 279, 275>, 0, <279, 713, 275>, 0, <275, 713, 39>, 0, <713, 292, 39>, 0, <294, 714, 275>, 0, 
			<275, 39, 294>, 0, <31, 275, 714>, 0, <31, 714, 277>, 0, <277, 714, 293>, 0, <277, 293, 32>, 0, <293, 714, 40>, 0, <714, 294, 40>, 0, <40, 326, 715>, 0, <40, 715, 293>, 0, <32, 293, 313>, 0, <293, 715, 313>, 0, 
			<313, 715, 52>, 0, <715, 328, 52>, 0, <328, 715, 326>, 0, <326, 59, 328>, 0, <295, 716, 271>, 0, <271, 34, 295>, 0, <26, 271, 716>, 0, <26, 716, 285>, 0, <27, 285, 272>, 0, <285, 716, 272>, 0, <272, 716, 295>, 0, 
			<272, 295, 35>, 0, <26, 283, 717>, 0, <26, 717, 271>, 0, <271, 717, 34>, 0, <717, 297, 34>, 0, <41, 297, 717>, 0, <717, 296, 41>, 0, <33, 296, 717>, 0, <33, 717, 283>, 0, <298, 718, 272>, 0, <272, 35, 298>, 0, 
			<27, 272, 718>, 0, <27, 718, 280>, 0, <28, 280, 273>, 0, <280, 718, 273>, 0, <273, 718, 36>, 0, <718, 298, 36>, 0, <719, 262, 22>, 0, <22, 264, 719>, 0, <262, 719, 279>, 0, <262, 279, 31>, 0, <279, 719, 30>, 0, 
			<719, 300, 30>, 0, <300, 719, 264>, 0, <264, 21, 300>, 0, <720, 239, 5>, 0, <5, 302, 720>, 0, <239, 720, 301>, 0, <239, 301, 7>, 0, <301, 720, 28>, 0, <720, 280, 28>, 0, <280, 720, 302>, 0, <302, 27, 280>, 0, 
			<15, 254, 252>, 0, <254, 721, 252>, 0, <252, 721, 16>, 0, <721, 320, 16>, 0, <320, 721, 307>, 0, <307, 48, 320>, 0, <17, 307, 721>, 0, <17, 721, 254>, 0, <42, 324, 722>, 0, <42, 722, 228>, 0, <228, 722, 0>, 0, 
			<722, 230, 0>, 0, <230, 722, 2>, 0, <722, 323, 2>, 0, <323, 722, 324>, 0, <324, 58, 323>, 0, <2, 323, 233>, 0, <323, 723, 233>, 0, <233, 723, 3>, 0, <723, 304, 3>, 0, <304, 723, 325>, 0, <325, 43, 304>, 0, 
			<58, 325, 723>, 0, <58, 723, 323>, 0, <327, 724, 290>, 0, <290, 57, 327>, 0, <39, 290, 724>, 0, <39, 724, 294>, 0, <294, 724, 326>, 0, <294, 326, 40>, 0, <326, 724, 59>, 0, <724, 327, 59>, 0, <304, 725, 281>, 0, 
			<304, 281, 3>, 0, <281, 725, 33>, 0, <725, 282, 33>, 0, <282, 725, 329>, 0, <329, 53, 282>, 0, <725, 304, 43>, 0, <43, 329, 725>, 0, <24, 310, 726>, 0, <24, 726, 266>, 0, <266, 726, 331>, 0, <266, 331, 25>, 0, 
			<331, 726, 60>, 0, <726, 332, 60>, 0, <332, 726, 310>, 0, <310, 51, 332>, 0, <29, 312, 288>, 0, <312, 727, 288>, 0, <288, 727, 37>, 0, <727, 335, 37>, 0, <335, 727, 440>, 0, <440, 61, 335>, 0, <75, 440, 727>, 0, 
			<75, 727, 312>, 0, <38, 291, 289>, 0, <291, 728, 289>, 0, <289, 728, 56>, 0, <728, 336, 56>, 0, <61, 336, 728>, 0, <61, 728, 335>, 0, <37, 335, 291>, 0, <335, 728, 291>, 0, <53, 340, 729>, 0, <53, 729, 282>, 0, 
			<282, 729, 296>, 0, <282, 296, 33>, 0, <296, 729, 41>, 0, <729, 339, 41>, 0, <339, 729, 340>, 0, <340, 62, 339>, 0, <34, 297, 730>, 0, <34, 730, 286>, 0, <286, 730, 54>, 0, <730, 341, 54>, 0, <62, 341, 730>, 0, 
			<62, 730, 339>, 0, <41, 339, 297>, 0, <339, 730, 297>, 0, <343, 731, 287>, 0, <287, 55, 343>, 0, <35, 287, 731>, 0, <35, 731, 298>, 0, <298, 731, 342>, 0, <298, 342, 36>, 0, <342, 731, 63>, 0, <731, 343, 63>, 0, 
			<36, 342, 732>, 0, <36, 732, 273>, 0, <273, 732, 311>, 0, <273, 311, 28>, 0, <311, 732, 74>, 0, <732, 439, 74>, 0, <439, 732, 342>, 0, <342, 63, 439>, 0, <28, 311, 733>, 0, <28, 733, 278>, 0, <278, 733, 312>, 0, 
			<278, 312, 29>, 0, <312, 733, 75>, 0, <733, 390, 75>, 0, <390, 733, 311>, 0, <311, 74, 390>, 0, <344, 734, 286>, 0, <286, 54, 344>, 0, <34, 286, 734>, 0, <34, 734, 295>, 0, <35, 295, 287>, 0, <295, 734, 287>, 0, 
			<287, 734, 344>, 0, <287, 344, 55>, 0, <347, 735, 289>, 0, <289, 56, 347>, 0, <38, 289, 735>, 0, <38, 735, 292>, 0, <39, 292, 290>, 0, <292, 735, 290>, 0, <290, 735, 57>, 0, <735, 347, 57>, 0, <322, 736, 303>, 0, 
			<303, 42, 322>, 0, <736, 364, 64>, 0, <64, 303, 736>, 0, <364, 736, 350>, 0, <364, 350, 66>, 0, <44, 350, 736>, 0, <736, 322, 44>, 0, <47, 353, 737>, 0, <737, 337, 47>, 0, <46, 337, 737>, 0, <737, 352, 46>, 0, 
			<737, 365, 68>, 0, <68, 352, 737>, 0, <365, 737, 353>, 0, <365, 353, 69>, 0, <51, 357, 738>, 0, <51, 738, 332>, 0, <332, 738, 366>, 0, <332, 366, 60>, 0, <366, 738, 82>, 0, <738, 367, 82>, 0, <367, 738, 357>, 0, 
			<357, 73, 367>, 0, <60, 366, 739>, 0, <60, 739, 333>, 0, <333, 739, 356>, 0, <356, 50, 333>, 0, <739, 368, 72>, 0, <72, 356, 739>, 0, <368, 739, 366>, 0, <366, 82, 368>, 0, <370, 740, 316>, 0, <316, 79, 370>, 0, 
			<55, 316, 740>, 0, <55, 740, 343>, 0, <343, 740, 369>, 0, <343, 369, 63>, 0, <369, 740, 83>, 0, <740, 370, 83>, 0, <83, 408, 741>, 0, <83, 741, 369>, 0, <63, 369, 741>, 0, <63, 741, 439>, 0, <439, 741, 441>, 0, 
			<439, 441, 74>, 0, <441, 741, 408>, 0, <408, 107, 441>, 0, <77, 435, 742>, 0, <77, 742, 314>, 0, <53, 314, 340>, 0, <314, 742, 340>, 0, <62, 340, 742>, 0, <742, 435, 62>, 0, <54, 341, 743>, 0, <54, 743, 315>, 0, 
			<315, 743, 78>, 0, <743, 372, 78>, 0, <84, 372, 743>, 0, <84, 743, 371>, 0, <62, 371, 341>, 0, <371, 743, 341>, 0, <373, 744, 317>, 0, <317, 80, 373>, 0, <56, 317, 744>, 0, <56, 744, 347>, 0, <57, 347, 318>, 0, 
			<347, 744, 318>, 0, <318, 744, 81>, 0, <744, 373, 81>, 0, <56, 336, 317>, 0, <336, 745, 317>, 0, <317, 745, 80>, 0, <745, 375, 80>, 0, <85, 375, 745>, 0, <85, 745, 374>, 0, <61, 374, 336>, 0, <374, 745, 336>, 0, 
			<48, 354, 746>, 0, <48, 746, 320>, 0, <320, 746, 376>, 0, <320, 376, 16>, 0, <376, 746, 86>, 0, <746, 377, 86>, 0, <377, 746, 354>, 0, <354, 70, 377>, 0, <16, 376, 747>, 0, <16, 747, 321>, 0, <47, 321, 747>, 0, 
			<747, 353, 47>, 0, <747, 378, 69>, 0, <69, 353, 747>, 0, <378, 747, 376>, 0, <376, 86, 378>, 0, <64, 380, 748>, 0, <64, 748, 303>, 0, <42, 303, 748>, 0, <748, 324, 42>, 0, <324, 748, 58>, 0, <748, 379, 58>, 0, 
			<379, 748, 380>, 0, <380, 87, 379>, 0, <58, 379, 325>, 0, <379, 749, 325>, 0, <43, 325, 749>, 0, <749, 349, 43>, 0, <349, 749, 381>, 0, <381, 65, 349>, 0, <87, 381, 749>, 0, <87, 749, 379>, 0, <52, 358, 750>, 0, 
			<52, 750, 334>, 0, <51, 334, 357>, 0, <334, 750, 357>, 0, <357, 750, 73>, 0, <750, 382, 73>, 0, <382, 750, 358>, 0, <358, 76, 382>, 0, <46, 352, 751>, 0, <751, 345, 46>, 0, <345, 751, 12>, 0, <751, 383, 12>, 0, 
			<383, 751, 384>, 0, <384, 88, 383>, 0, <384, 751, 352>, 0, <384, 352, 68>, 0, <12, 383, 346>, 0, <383, 752, 346>, 0, <45, 346, 752>, 0, <752, 351, 45>, 0, <351, 752, 385>, 0, <385, 67, 351>, 0, <88, 385, 752>, 0, 
			<88, 752, 383>, 0, <50, 356, 753>, 0, <753, 319, 50>, 0, <319, 753, 355>, 0, <355, 49, 319>, 0, <753, 386, 71>, 0, <71, 355, 753>, 0, <386, 753, 356>, 0, <386, 356, 72>, 0, <387, 754, 315>, 0, <315, 78, 387>, 0, 
			<54, 315, 754>, 0, <54, 754, 344>, 0, <55, 344, 316>, 0, <344, 754, 316>, 0, <316, 754, 79>, 0, <754, 387, 79>, 0, <45, 351, 338>, 0, <351, 755, 338>, 0, <44, 338, 755>, 0, <755, 350, 44>, 0, <350, 755, 388>, 0, 
			<388, 66, 350>, 0, <755, 351, 67>, 0, <67, 388, 755>, 0, <49, 355, 756>, 0, <49, 756, 330>, 0, <48, 330, 354>, 0, <330, 756, 354>, 0, <354, 756, 70>, 0, <756, 389, 70>, 0, <389, 756, 355>, 0, <355, 71, 389>, 0, 
			<53, 329, 757>, 0, <757, 314, 53>, 0, <314, 757, 391>, 0, <391, 77, 314>, 0, <757, 349, 65>, 0, <65, 391, 757>, 0, <43, 349, 329>, 0, <349, 757, 329>, 0, <393, 758, 318>, 0, <318, 81, 393>, 0, <57, 318, 758>, 0, 
			<57, 758, 327>, 0, <327, 758, 392>, 0, <327, 392, 59>, 0, <392, 758, 89>, 0, <758, 393, 89>, 0, <59, 436, 759>, 0, <59, 759, 328>, 0, <52, 328, 358>, 0, <328, 759, 358>, 0, <76, 358, 759>, 0, <76, 759, 436>, 0, 
			<71, 400, 389>, 0, <400, 760, 389>, 0, <70, 389, 760>, 0, <70, 760, 399>, 0, <399, 760, 404>, 0, <399, 404, 96>, 0, <97, 404, 760>, 0, <97, 760, 400>, 0, <70, 399, 377>, 0, <399, 761, 377>, 0, <377, 761, 86>, 0, 
			<761, 405, 86>, 0, <405, 761, 406>, 0, <406, 106, 405>, 0, <406, 761, 96>, 0, <761, 399, 96>, 0, <86, 405, 378>, 0, <405, 762, 378>, 0, <378, 762, 398>, 0, <398, 69, 378>, 0, <762, 407, 95>, 0, <95, 398, 762>, 0, 
			<106, 407, 762>, 0, <106, 762, 405>, 0, <409, 763, 361>, 0, <361, 103, 409>, 0, <79, 361, 763>, 0, <79, 763, 370>, 0, <370, 763, 83>, 0, <763, 408, 83>, 0, <408, 763, 409>, 0, <409, 107, 408>, 0, <72, 401, 764>, 0, 
			<764, 386, 72>, 0, <386, 764, 400>, 0, <400, 71, 386>, 0, <764, 410, 97>, 0, <97, 400, 764>, 0, <410, 764, 401>, 0, <410, 401, 98>, 0, <67, 396, 765>, 0, <765, 388, 67>, 0, <388, 765, 395>, 0, <395, 66, 388>, 0, 
			<765, 411, 92>, 0, <92, 395, 765>, 0, <411, 765, 396>, 0, <411, 396, 93>, 0, <69, 398, 766>, 0, <766, 365, 69>, 0, <365, 766, 397>, 0, <397, 68, 365>, 0, <766, 412, 94>, 0, <94, 397, 766>, 0, <412, 766, 398>, 0, 
			<412, 398, 95>, 0, <364, 767, 348>, 0, <348, 64, 364>, 0, <767, 413, 90>, 0, <90, 348, 767>, 0, <413, 767, 395>, 0, <413, 395, 92>, 0, <66, 395, 767>, 0, <767, 364, 66>, 0, <391, 768, 359>, 0, <359, 77, 391>, 0, 
			<359, 768, 101>, 0, <768, 414, 101>, 0, <414, 768, 394>, 0, <414, 394, 91>, 0, <65, 394, 768>, 0, <768, 391, 65>, 0, <415, 769, 360>, 0, <360, 102, 415>, 0, <78, 360, 769>, 0, <78, 769, 387>, 0, <79, 387, 361>, 0, 
			<387, 769, 361>, 0, <361, 769, 415>, 0, <361, 415, 103>, 0, <76, 403, 382>, 0, <403, 770, 382>, 0, <73, 382, 770>, 0, <73, 770, 402>, 0, <402, 770, 416>, 0, <402, 416, 99>, 0, <100, 416, 770>, 0, <100, 770, 403>, 0, 
			<73, 402, 367>, 0, <402, 771, 367>, 0, <367, 771, 82>, 0, <771, 417, 82>, 0, <417, 771, 418>, 0, <418, 108, 417>, 0, <99, 418, 771>, 0, <99, 771, 402>, 0, <82, 417, 368>, 0, <417, 772, 368>, 0, <368, 772, 401>, 0, 
			<401, 72, 368>, 0, <772, 419, 98>, 0, <98, 401, 772>, 0, <108, 419, 772>, 0, <108, 772, 417>, 0, <420, 773, 362>, 0, <362, 104, 420>, 0, <80, 362, 773>, 0, <80, 773, 373>, 0, <81, 373, 363>, 0, <373, 773, 363>, 0, 
			<363, 773, 105>, 0, <773, 420, 105>, 0, <68, 397, 774>, 0, <774, 384, 68>, 0, <384, 774, 421>, 0, <384, 421, 88>, 0, <421, 774, 109>, 0, <774, 422, 109>, 0, <422, 774, 397>, 0, <422, 397, 94>, 0, <88, 421, 775>, 0, 
			<88, 775, 385>, 0, <385, 775, 396>, 0, <396, 67, 385>, 0, <775, 423, 93>, 0, <93, 396, 775>, 0, <423, 775, 421>, 0, <421, 109, 423>, 0, <90, 425, 776>, 0, <90, 776, 348>, 0, <64, 348, 776>, 0, <776, 380, 64>, 0, 
			<380, 776, 424>, 0, <380, 424, 87>, 0, <424, 776, 110>, 0, <776, 425, 110>, 0, <87, 424, 777>, 0, <87, 777, 381>, 0, <65, 381, 394>, 0, <381, 777, 394>, 0, <394, 777, 91>, 0, <777, 426, 91>, 0, <426, 777, 424>, 0, 
			<424, 110, 426>, 0, <78, 372, 778>, 0, <78, 778, 360>, 0, <360, 778, 102>, 0, <778, 429, 102>, 0, <111, 429, 778>, 0, <111, 778, 427>, 0, <84, 427, 778>, 0, <84, 778, 372>, 0, <80, 375, 362>, 0, <375, 779, 362>, 0, 
			<362, 779, 104>, 0, <779, 431, 104>, 0, <112, 431, 779>, 0, <112, 779, 430>, 0, <85, 430, 779>, 0, <85, 779, 375>, 0, <433, 780, 363>, 0, <363, 105, 433>, 0, <81, 363, 780>, 0, <81, 780, 393>, 0, <393, 780, 89>, 0, 
			<780, 432, 89>, 0, <432, 780, 433>, 0, <433, 113, 432>, 0, <76, 438, 781>, 0, <76, 781, 403>, 0, <403, 781, 434>, 0, <403, 434, 100>, 0, <781, 438, 113>, 0, <113, 434, 781>, 0, <435, 782, 62>, 0, <782, 371, 62>, 0, 
			<371, 782, 84>, 0, <782, 427, 84>, 0, <427, 782, 437>, 0, <437, 111, 427>, 0, <77, 437, 782>, 0, <77, 782, 435>, 0, <89, 432, 783>, 0, <89, 783, 392>, 0, <783, 436, 59>, 0, <59, 392, 783>, 0, <436, 783, 438>, 0, 
			<438, 76, 436>, 0, <113, 438, 783>, 0, <113, 783, 432>, 0, <359, 101, 428>, 0, <359, 428, 784>, 0, <359, 784, 77>, 0, <784, 437, 77>, 0, <437, 784, 111>, 0, <784, 428, 111>, 0, <440, 785, 61>, 0, <785, 374, 61>, 0, 
			<374, 785, 85>, 0, <785, 430, 85>, 0, <430, 785, 112>, 0, <785, 442, 112>, 0, <75, 442, 440>, 0, <442, 785, 440>, 0, <786, 444, 115>, 0, <115, 447, 786>, 0, <444, 786, 114>, 0, <786, 445, 114>, 0, <116, 445, 786>, 0, 
			<786, 448, 116>, 0, <117, 448, 786>, 0, <117, 786, 447>, 0, <537, 787, 443>, 0, <443, 156, 537>, 0, <787, 449, 114>, 0, <114, 443, 787>, 0, <449, 787, 520>, 0, <449, 520, 118>, 0, <520, 787, 158>, 0, <787, 537, 158>, 0, 
			<449, 788, 444>, 0, <444, 114, 449>, 0, <115, 444, 788>, 0, <115, 788, 451>, 0, <119, 451, 450>, 0, <451, 788, 450>, 0, <450, 788, 118>, 0, <788, 449, 118>, 0, <124, 459, 458>, 0, <459, 789, 458>, 0, <458, 789, 160>, 0, 
			<789, 560, 160>, 0, <560, 789, 461>, 0, <461, 126, 560>, 0, <125, 461, 789>, 0, <125, 789, 459>, 0, <452, 790, 450>, 0, <450, 118, 452>, 0, <119, 450, 790>, 0, <119, 790, 454>, 0, <121, 454, 453>, 0, <454, 790, 453>, 0, 
			<453, 790, 120>, 0, <790, 452, 120>, 0, <118, 457, 791>, 0, <118, 791, 452>, 0, <120, 452, 456>, 0, <452, 791, 456>, 0, <122, 456, 791>, 0, <791, 455, 122>, 0, <455, 791, 457>, 0, <457, 123, 455>, 0, <118, 520, 792>, 0, 
			<118, 792, 457>, 0, <457, 792, 521>, 0, <457, 521, 123>, 0, <521, 792, 159>, 0, <792, 553, 159>, 0, <553, 792, 520>, 0, <520, 158, 553>, 0, <123, 462, 793>, 0, <123, 793, 455>, 0, <122, 455, 460>, 0, <455, 793, 460>, 0, 
			<124, 460, 793>, 0, <793, 459, 124>, 0, <459, 793, 125>, 0, <793, 462, 125>, 0, <125, 462, 461>, 0, <462, 794, 461>, 0, <461, 794, 126>, 0, <794, 561, 126>, 0, <561, 794, 521>, 0, <521, 159, 561>, 0, <123, 521, 794>, 0, 
			<123, 794, 462>, 0, <552, 795, 458>, 0, <458, 160, 552>, 0, <795, 464, 124>, 0, <124, 458, 795>, 0, <127, 464, 463>, 0, <464, 795, 463>, 0, <463, 795, 161>, 0, <795, 552, 161>, 0, <464, 796, 460>, 0, <460, 124, 464>, 0, 
			<796, 466, 122>, 0, <122, 460, 796>, 0, <128, 466, 465>, 0, <466, 796, 465>, 0, <465, 796, 127>, 0, <796, 464, 127>, 0, <536, 797, 463>, 0, <463, 161, 536>, 0, <127, 463, 797>, 0, <127, 797, 468>, 0, <129, 468, 797>, 0, 
			<797, 467, 129>, 0, <467, 797, 536>, 0, <536, 130, 467>, 0, <468, 798, 465>, 0, <465, 127, 468>, 0, <128, 465, 798>, 0, <128, 798, 470>, 0, <131, 470, 469>, 0, <470, 798, 469>, 0, <469, 798, 129>, 0, <798, 468, 129>, 0, 
			<473, 799, 131>, 0, <799, 470, 131>, 0, <470, 799, 472>, 0, <472, 128, 470>, 0, <132, 472, 799>, 0, <132, 799, 471>, 0, <471, 799, 473>, 0, <471, 473, 133>, 0, <131, 522, 473>, 0, <522, 800, 473>, 0, <473, 800, 133>, 0, 
			<800, 523, 133>, 0, <523, 800, 545>, 0, <545, 163, 523>, 0, <162, 545, 800>, 0, <162, 800, 522>, 0, <133, 476, 801>, 0, <801, 471, 133>, 0, <471, 801, 475>, 0, <475, 132, 471>, 0, <134, 475, 801>, 0, <134, 801, 474>, 0, 
			<474, 801, 476>, 0, <474, 476, 135>, 0, <480, 802, 476>, 0, <476, 133, 480>, 0, <135, 476, 802>, 0, <135, 802, 479>, 0, <136, 479, 478>, 0, <479, 802, 478>, 0, <478, 802, 137>, 0, <802, 480, 137>, 0, <133, 523, 803>, 0, 
			<133, 803, 480>, 0, <480, 803, 524>, 0, <480, 524, 137>, 0, <524, 803, 164>, 0, <803, 534, 164>, 0, <534, 803, 523>, 0, <523, 163, 534>, 0, <483, 804, 478>, 0, <478, 137, 483>, 0, <136, 478, 804>, 0, <136, 804, 482>, 0, 
			<138, 482, 481>, 0, <482, 804, 481>, 0, <481, 804, 139>, 0, <804, 483, 139>, 0, <137, 524, 805>, 0, <137, 805, 483>, 0, <139, 483, 805>, 0, <805, 546, 139>, 0, <546, 805, 548>, 0, <548, 174, 546>, 0, <548, 805, 524>, 0, 
			<524, 164, 548>, 0, <485, 806, 453>, 0, <453, 120, 485>, 0, <806, 484, 121>, 0, <121, 453, 806>, 0, <484, 806, 475>, 0, <484, 475, 134>, 0, <475, 806, 132>, 0, <806, 485, 132>, 0, <466, 807, 456>, 0, <456, 122, 466>, 0, 
			<807, 485, 120>, 0, <120, 456, 807>, 0, <485, 807, 472>, 0, <485, 472, 132>, 0, <472, 807, 128>, 0, <807, 466, 128>, 0, <134, 514, 808>, 0, <134, 808, 484>, 0, <121, 484, 808>, 0, <808, 516, 121>, 0, <516, 808, 493>, 0, 
			<493, 142, 516>, 0, <493, 808, 514>, 0, <493, 514, 143>, 0, <482, 809, 477>, 0, <477, 136, 482>, 0, <809, 492, 145>, 0, <145, 477, 809>, 0, <492, 809, 491>, 0, <492, 491, 146>, 0, <491, 809, 138>, 0, <809, 482, 138>, 0, 
			<138, 525, 491>, 0, <525, 810, 491>, 0, <491, 810, 146>, 0, <810, 528, 146>, 0, <528, 810, 549>, 0, <549, 166, 528>, 0, <165, 549, 810>, 0, <165, 810, 525>, 0, <811, 446, 140>, 0, <140, 498, 811>, 0, <446, 811, 115>, 0, 
			<811, 447, 115>, 0, <447, 811, 496>, 0, <496, 117, 447>, 0, <811, 498, 147>, 0, <147, 496, 811>, 0, <135, 515, 812>, 0, <812, 474, 135>, 0, <474, 812, 514>, 0, <514, 134, 474>, 0, <812, 499, 143>, 0, <143, 514, 812>, 0, 
			<499, 812, 515>, 0, <499, 515, 144>, 0, <115, 451, 813>, 0, <115, 813, 446>, 0, <446, 813, 500>, 0, <446, 500, 140>, 0, <813, 517, 141>, 0, <141, 500, 813>, 0, <119, 517, 451>, 0, <517, 813, 451>, 0, <506, 814, 489>, 0, 
			<506, 489, 152>, 0, <489, 814, 144>, 0, <814, 499, 144>, 0, <499, 814, 503>, 0, <503, 143, 499>, 0, <814, 506, 151>, 0, <151, 503, 814>, 0, <494, 815, 489>, 0, <489, 144, 494>, 0, <815, 507, 152>, 0, <152, 489, 815>, 0, 
			<507, 815, 490>, 0, <507, 490, 153>, 0, <490, 815, 145>, 0, <815, 494, 145>, 0, <492, 816, 490>, 0, <490, 145, 492>, 0, <816, 509, 153>, 0, <153, 490, 816>, 0, <509, 816, 508>, 0, <509, 508, 154>, 0, <146, 508, 816>, 0, 
			<816, 492, 146>, 0, <146, 528, 508>, 0, <528, 817, 508>, 0, <154, 508, 817>, 0, <817, 541, 154>, 0, <541, 817, 543>, 0, <543, 173, 541>, 0, <166, 543, 817>, 0, <166, 817, 528>, 0, <500, 818, 486>, 0, <486, 140, 500>, 0, 
			<818, 510, 148>, 0, <148, 486, 818>, 0, <510, 818, 487>, 0, <510, 487, 149>, 0, <487, 818, 500>, 0, <487, 500, 141>, 0, <819, 486, 148>, 0, <148, 512, 819>, 0, <486, 819, 140>, 0, <819, 498, 140>, 0, <498, 819, 511>, 0, 
			<511, 147, 498>, 0, <819, 512, 155>, 0, <155, 511, 819>, 0, <495, 820, 487>, 0, <487, 141, 495>, 0, <820, 513, 149>, 0, <149, 487, 820>, 0, <513, 820, 488>, 0, <513, 488, 150>, 0, <488, 820, 142>, 0, <820, 495, 142>, 0, 
			<494, 821, 477>, 0, <494, 477, 145>, 0, <477, 821, 136>, 0, <821, 479, 136>, 0, <479, 821, 515>, 0, <515, 135, 479>, 0, <821, 494, 144>, 0, <144, 515, 821>, 0, <516, 822, 454>, 0, <516, 454, 121>, 0, <454, 822, 119>, 0, 
			<822, 517, 119>, 0, <517, 822, 495>, 0, <495, 141, 517>, 0, <822, 516, 142>, 0, <142, 495, 822>, 0, <130, 535, 823>, 0, <130, 823, 467>, 0, <129, 467, 469>, 0, <467, 823, 469>, 0, <469, 823, 131>, 0, <823, 522, 131>, 0, 
			<522, 823, 535>, 0, <535, 162, 522>, 0, <114, 445, 824>, 0, <114, 824, 443>, 0, <443, 824, 156>, 0, <824, 539, 156>, 0, <539, 824, 538>, 0, <538, 172, 539>, 0, <824, 445, 116>, 0, <116, 538, 824>, 0, <117, 519, 825>, 0, 
			<117, 825, 448>, 0, <448, 825, 538>, 0, <448, 538, 116>, 0, <538, 825, 172>, 0, <825, 540, 172>, 0, <540, 825, 519>, 0, <519, 157, 540>, 0, <509, 826, 505>, 0, <505, 153, 509>, 0, <826, 542, 171>, 0, <171, 505, 826>, 0, 
			<826, 541, 173>, 0, <173, 542, 826>, 0, <154, 541, 509>, 0, <541, 826, 509>, 0, <827, 496, 147>, 0, <147, 497, 827>, 0, <496, 827, 519>, 0, <496, 519, 117>, 0, <519, 827, 157>, 0, <827, 544, 157>, 0, <544, 827, 497>, 0, 
			<497, 167, 544>, 0, <139, 546, 481>, 0, <546, 828, 481>, 0, <481, 828, 138>, 0, <828, 525, 138>, 0, <525, 828, 547>, 0, <547, 165, 525>, 0, <828, 546, 174>, 0, <174, 547, 828>, 0, <151, 550, 829>, 0, <151, 829, 503>, 0, 
			<143, 503, 527>, 0, <503, 829, 527>, 0, <189, 527, 829>, 0, <829, 681, 189>, 0, <681, 829, 550>, 0, <550, 175, 681>, 0, <551, 830, 504>, 0, <551, 504, 170>, 0, <504, 830, 152>, 0, <830, 506, 152>, 0, <151, 506, 550>, 0, 
			<506, 830, 550>, 0, <550, 830, 175>, 0, <830, 551, 175>, 0, <147, 511, 497>, 0, <511, 831, 497>, 0, <497, 831, 167>, 0, <831, 555, 167>, 0, <555, 831, 554>, 0, <554, 176, 555>, 0, <831, 511, 155>, 0, <155, 554, 831>, 0, 
			<832, 501, 168>, 0, <168, 556, 832>, 0, <501, 832, 148>, 0, <832, 512, 148>, 0, <155, 512, 554>, 0, <512, 832, 554>, 0, <554, 832, 176>, 0, <832, 556, 176>, 0, <513, 833, 502>, 0, <502, 149, 513>, 0, <833, 558, 169>, 0, 
			<169, 502, 833>, 0, <833, 557, 177>, 0, <177, 558, 833>, 0, <150, 557, 513>, 0, <557, 833, 513>, 0, <142, 526, 488>, 0, <526, 834, 488>, 0, <150, 488, 834>, 0, <834, 557, 150>, 0, <557, 834, 680>, 0, <680, 177, 557>, 0, 
			<834, 526, 188>, 0, <188, 680, 834>, 0, <143, 527, 835>, 0, <835, 493, 143>, 0, <493, 835, 526>, 0, <526, 142, 493>, 0, <835, 605, 188>, 0, <188, 526, 835>, 0, <605, 835, 527>, 0, <605, 527, 189>, 0, <510, 836, 501>, 0, 
			<501, 148, 510>, 0, <836, 559, 168>, 0, <168, 501, 836>, 0, <559, 836, 502>, 0, <559, 502, 169>, 0, <502, 836, 510>, 0, <502, 510, 149>, 0, <507, 837, 504>, 0, <504, 152, 507>, 0, <837, 562, 170>, 0, <170, 504, 837>, 0, 
			<562, 837, 505>, 0, <562, 505, 171>, 0, <505, 837, 153>, 0, <837, 507, 153>, 0, <579, 838, 518>, 0, <518, 178, 579>, 0, <838, 537, 156>, 0, <156, 518, 838>, 0, <537, 838, 565>, 0, <537, 565, 158>, 0, <565, 838, 180>, 0, 
			<838, 579, 180>, 0, <160, 567, 839>, 0, <160, 839, 552>, 0, <552, 839, 568>, 0, <552, 568, 161>, 0, <568, 839, 580>, 0, <568, 580, 183>, 0, <580, 839, 567>, 0, <567, 182, 580>, 0, <174, 581, 547>, 0, <581, 840, 547>, 0, 
			<547, 840, 165>, 0, <840, 572, 165>, 0, <572, 840, 582>, 0, <582, 187, 572>, 0, <840, 581, 196>, 0, <196, 582, 840>, 0, <164, 571, 841>, 0, <164, 841, 548>, 0, <174, 548, 841>, 0, <841, 581, 174>, 0, <581, 841, 583>, 0, 
			<583, 196, 581>, 0, <583, 841, 571>, 0, <571, 186, 583>, 0, <558, 842, 531>, 0, <531, 169, 558>, 0, <842, 585, 193>, 0, <193, 531, 842>, 0, <842, 584, 197>, 0, <197, 585, 842>, 0, <177, 584, 558>, 0, <584, 842, 558>, 0, 
			<177, 680, 843>, 0, <843, 584, 177>, 0, <197, 584, 843>, 0, <843, 623, 197>, 0, <623, 843, 682>, 0, <623, 682, 221>, 0, <188, 682, 680>, 0, <682, 843, 680>, 0, <167, 555, 529>, 0, <555, 844, 529>, 0, <191, 529, 844>, 0, 
			<844, 666, 191>, 0, <176, 666, 844>, 0, <176, 844, 555>, 0, <845, 530, 192>, 0, <192, 587, 845>, 0, <530, 845, 168>, 0, <845, 556, 168>, 0, <176, 556, 586>, 0, <556, 845, 586>, 0, <586, 845, 198>, 0, <845, 587, 198>, 0, 
			<562, 846, 532>, 0, <532, 170, 562>, 0, <846, 588, 194>, 0, <194, 532, 846>, 0, <588, 846, 533>, 0, <588, 533, 195>, 0, <533, 846, 171>, 0, <846, 562, 171>, 0, <590, 847, 532>, 0, <590, 532, 194>, 0, <532, 847, 170>, 0, 
			<847, 551, 170>, 0, <175, 551, 589>, 0, <551, 847, 589>, 0, <589, 847, 199>, 0, <847, 590, 199>, 0, <130, 591, 535>, 0, <591, 848, 535>, 0, <535, 848, 162>, 0, <848, 569, 162>, 0, <569, 848, 592>, 0, <592, 184, 569>, 0, 
			<848, 591, 200>, 0, <200, 592, 848>, 0, <161, 568, 849>, 0, <161, 849, 536>, 0, <130, 536, 849>, 0, <849, 591, 130>, 0, <591, 849, 593>, 0, <593, 200, 591>, 0, <593, 849, 568>, 0, <568, 183, 593>, 0, <156, 539, 850>, 0, 
			<156, 850, 518>, 0, <518, 850, 178>, 0, <850, 595, 178>, 0, <595, 850, 594>, 0, <594, 201, 595>, 0, <172, 594, 850>, 0, <172, 850, 539>, 0, <157, 564, 851>, 0, <157, 851, 540>, 0, <172, 540, 594>, 0, <540, 851, 594>, 0, 
			<594, 851, 201>, 0, <851, 596, 201>, 0, <596, 851, 564>, 0, <564, 179, 596>, 0, <165, 572, 549>, 0, <572, 852, 549>, 0, <549, 852, 166>, 0, <852, 573, 166>, 0, <573, 852, 597>, 0, <597, 190, 573>, 0, <187, 597, 852>, 0, 
			<187, 852, 572>, 0, <126, 598, 853>, 0, <126, 853, 560>, 0, <560, 853, 567>, 0, <560, 567, 160>, 0, <567, 853, 182>, 0, <853, 599, 182>, 0, <599, 853, 598>, 0, <598, 202, 599>, 0, <159, 566, 854>, 0, <159, 854, 561>, 0, 
			<126, 561, 598>, 0, <561, 854, 598>, 0, <598, 854, 202>, 0, <854, 600, 202>, 0, <600, 854, 566>, 0, <566, 181, 600>, 0, <163, 570, 855>, 0, <163, 855, 534>, 0, <534, 855, 571>, 0, <534, 571, 164>, 0, <571, 855, 186>, 0, 
			<855, 601, 186>, 0, <601, 855, 570>, 0, <570, 185, 601>, 0, <559, 856, 530>, 0, <530, 168, 559>, 0, <856, 602, 192>, 0, <192, 530, 856>, 0, <602, 856, 531>, 0, <602, 531, 193>, 0, <531, 856, 559>, 0, <531, 559, 169>, 0, 
			<158, 565, 857>, 0, <158, 857, 553>, 0, <553, 857, 566>, 0, <553, 566, 159>, 0, <566, 857, 181>, 0, <857, 603, 181>, 0, <603, 857, 565>, 0, <565, 180, 603>, 0, <162, 569, 545>, 0, <569, 858, 545>, 0, <545, 858, 163>, 0, 
			<858, 570, 163>, 0, <570, 858, 604>, 0, <604, 185, 570>, 0, <184, 604, 858>, 0, <184, 858, 569>, 0, <606, 859, 529>, 0, <529, 191, 606>, 0, <859, 544, 167>, 0, <167, 529, 859>, 0, <544, 859, 564>, 0, <544, 564, 157>, 0, 
			<564, 859, 179>, 0, <859, 606, 179>, 0, <542, 860, 533>, 0, <533, 171, 542>, 0, <860, 608, 195>, 0, <195, 533, 860>, 0, <860, 607, 203>, 0, <203, 608, 860>, 0, <173, 607, 542>, 0, <607, 860, 542>, 0, <166, 573, 543>, 0, 
			<573, 861, 543>, 0, <173, 543, 861>, 0, <861, 667, 173>, 0, <190, 667, 861>, 0, <190, 861, 573>, 0, <184, 614, 862>, 0, <862, 604, 184>, 0, <604, 862, 615>, 0, <615, 185, 604>, 0, <862, 619, 211>, 0, <211, 615, 862>, 0, 
			<210, 619, 614>, 0, <619, 862, 614>, 0, <200, 620, 863>, 0, <863, 592, 200>, 0, <592, 863, 614>, 0, <614, 184, 592>, 0, <863, 621, 210>, 0, <210, 614, 863>, 0, <621, 863, 620>, 0, <621, 620, 220>, 0, <183, 613, 864>, 0, 
			<183, 864, 593>, 0, <593, 864, 620>, 0, <620, 200, 593>, 0, <864, 622, 220>, 0, <220, 620, 864>, 0, <622, 864, 613>, 0, <613, 209, 622>, 0, <585, 865, 576>, 0, <576, 193, 585>, 0, <865, 624, 217>, 0, <217, 576, 865>, 0, 
			<624, 865, 221>, 0, <865, 623, 221>, 0, <197, 623, 865>, 0, <865, 585, 197>, 0, <441, 866, 651>, 0, <441, 651, 74>, 0, <651, 866, 188>, 0, <866, 682, 188>, 0, <221, 682, 866>, 0, <221, 866, 664>, 0, <107, 664, 441>, 0, 
			<664, 866, 441>, 0, <185, 615, 867>, 0, <185, 867, 601>, 0, <601, 867, 616>, 0, <601, 616, 186>, 0, <616, 867, 212>, 0, <867, 625, 212>, 0, <625, 867, 615>, 0, <615, 211, 625>, 0, <603, 180, 610>, 0, <603, 610, 868>, 0, 
			<181, 603, 868>, 0, <181, 868, 611>, 0, <611, 868, 626>, 0, <611, 626, 207>, 0, <206, 626, 868>, 0, <206, 868, 610>, 0, <182, 612, 869>, 0, <182, 869, 580>, 0, <580, 869, 613>, 0, <580, 613, 183>, 0, <613, 869, 627>, 0, 
			<613, 627, 209>, 0, <627, 869, 612>, 0, <612, 208, 627>, 0, <628, 870, 563>, 0, <563, 204, 628>, 0, <870, 579, 178>, 0, <178, 563, 870>, 0, <579, 870, 610>, 0, <579, 610, 180>, 0, <610, 870, 206>, 0, <870, 628, 206>, 0, 
			<215, 629, 871>, 0, <215, 871, 574>, 0, <574, 871, 606>, 0, <574, 606, 191>, 0, <871, 609, 179>, 0, <179, 606, 871>, 0, <609, 871, 629>, 0, <609, 629, 205>, 0, <602, 872, 575>, 0, <575, 192, 602>, 0, <872, 630, 216>, 0, 
			<216, 575, 872>, 0, <630, 872, 576>, 0, <630, 576, 217>, 0, <576, 872, 193>, 0, <872, 602, 193>, 0, <187, 617, 873>, 0, <873, 597, 187>, 0, <597, 873, 618>, 0, <618, 190, 597>, 0, <873, 631, 214>, 0, <214, 618, 873>, 0, 
			<213, 631, 617>, 0, <631, 873, 617>, 0, <196, 632, 874>, 0, <874, 582, 196>, 0, <582, 874, 617>, 0, <617, 187, 582>, 0, <874, 633, 213>, 0, <213, 617, 874>, 0, <633, 874, 632>, 0, <633, 632, 222>, 0, <186, 616, 875>, 0, 
			<186, 875, 583>, 0, <583, 875, 632>, 0, <632, 196, 583>, 0, <875, 634, 222>, 0, <222, 632, 875>, 0, <634, 875, 616>, 0, <616, 212, 634>, 0, <588, 876, 577>, 0, <577, 194, 588>, 0, <876, 635, 218>, 0, <218, 577, 876>, 0, 
			<635, 876, 578>, 0, <635, 578, 219>, 0, <578, 876, 195>, 0, <876, 588, 195>, 0, <636, 877, 599>, 0, <599, 202, 636>, 0, <599, 877, 612>, 0, <599, 612, 182>, 0, <612, 877, 208>, 0, <877, 637, 208>, 0, <637, 877, 223>, 0, 
			<877, 636, 223>, 0, <181, 611, 878>, 0, <181, 878, 600>, 0, <202, 600, 878>, 0, <202, 878, 636>, 0, <636, 878, 638>, 0, <636, 638, 223>, 0, <207, 638, 878>, 0, <878, 611, 207>, 0, <178, 595, 879>, 0, <178, 879, 563>, 0, 
			<563, 879, 204>, 0, <879, 640, 204>, 0, <640, 879, 224>, 0, <879, 639, 224>, 0, <639, 879, 595>, 0, <595, 201, 639>, 0, <609, 880, 596>, 0, <596, 179, 609>, 0, <201, 596, 880>, 0, <201, 880, 639>, 0, <639, 880, 641>, 0, 
			<639, 641, 224>, 0, <205, 641, 880>, 0, <880, 609, 205>, 0, <881, 575, 216>, 0, <216, 644, 881>, 0, <575, 881, 192>, 0, <881, 587, 192>, 0, <198, 587, 881>, 0, <198, 881, 642>, 0, <642, 881, 644>, 0, <642, 644, 225>, 0, 
			<390, 882, 652>, 0, <390, 652, 75>, 0, <189, 652, 882>, 0, <882, 605, 189>, 0, <605, 882, 651>, 0, <651, 188, 605>, 0, <74, 651, 882>, 0, <74, 882, 390>, 0, <646, 883, 577>, 0, <646, 577, 218>, 0, <577, 883, 194>, 0, 
			<883, 590, 194>, 0, <199, 590, 883>, 0, <199, 883, 645>, 0, <645, 883, 646>, 0, <645, 646, 226>, 0, <608, 884, 578>, 0, <578, 195, 608>, 0, <884, 648, 219>, 0, <219, 578, 884>, 0, <648, 884, 227>, 0, <884, 647, 227>, 0, 
			<203, 647, 884>, 0, <884, 608, 203>, 0, <618, 214, 649>, 0, <618, 649, 885>, 0, <190, 618, 885>, 0, <885, 669, 190>, 0, <227, 669, 885>, 0, <227, 885, 649>, 0, <433, 886, 113>, 0, <886, 658, 113>, 0, <658, 886, 648>, 0, 
			<648, 227, 658>, 0, <648, 886, 657>, 0, <657, 219, 648>, 0, <105, 657, 886>, 0, <105, 886, 433>, 0, <100, 434, 887>, 0, <100, 887, 670>, 0, <214, 670, 887>, 0, <214, 887, 649>, 0, <649, 887, 658>, 0, <658, 227, 649>, 0, 
			<113, 658, 434>, 0, <658, 887, 434>, 0, <413, 888, 650>, 0, <650, 90, 413>, 0, <204, 650, 888>, 0, <204, 888, 628>, 0, <628, 888, 678>, 0, <628, 678, 206>, 0, <92, 678, 888>, 0, <888, 413, 92>, 0, <422, 889, 659>, 0, 
			<422, 659, 109>, 0, <659, 889, 637>, 0, <637, 223, 659>, 0, <637, 889, 676>, 0, <637, 676, 208>, 0, <94, 676, 889>, 0, <889, 422, 94>, 0, <677, 93, 423>, 0, <677, 423, 890>, 0, <638, 207, 677>, 0, <638, 677, 890>, 0, 
			<223, 638, 890>, 0, <223, 890, 659>, 0, <109, 659, 890>, 0, <109, 890, 423>, 0, <414, 891, 653>, 0, <414, 653, 101>, 0, <653, 891, 629>, 0, <629, 215, 653>, 0, <891, 679, 205>, 0, <205, 629, 891>, 0, <91, 679, 891>, 0, 
			<91, 891, 414>, 0, <411, 892, 678>, 0, <678, 92, 411>, 0, <626, 206, 678>, 0, <626, 678, 892>, 0, <207, 626, 892>, 0, <207, 892, 677>, 0, <93, 677, 892>, 0, <892, 411, 93>, 0, <431, 893, 656>, 0, <431, 656, 104>, 0, 
			<218, 656, 893>, 0, <893, 646, 218>, 0, <226, 646, 893>, 0, <226, 893, 660>, 0, <112, 660, 431>, 0, <660, 893, 431>, 0, <99, 416, 894>, 0, <894, 671, 99>, 0, <213, 671, 894>, 0, <894, 631, 213>, 0, <631, 894, 670>, 0, 
			<670, 214, 631>, 0, <416, 100, 670>, 0, <416, 670, 894>, 0, <418, 895, 108>, 0, <895, 661, 108>, 0, <222, 661, 895>, 0, <895, 633, 222>, 0, <633, 895, 671>, 0, <671, 213, 633>, 0, <418, 99, 671>, 0, <418, 671, 895>, 0, 
			<419, 896, 672>, 0, <672, 98, 419>, 0, <212, 672, 896>, 0, <212, 896, 634>, 0, <634, 896, 661>, 0, <661, 222, 634>, 0, <108, 661, 419>, 0, <661, 896, 419>, 0, <412, 897, 676>, 0, <676, 94, 412>, 0, <208, 676, 897>, 0, 
			<208, 897, 627>, 0, <627, 897, 675>, 0, <627, 675, 209>, 0, <95, 675, 897>, 0, <897, 412, 95>, 0, <410, 898, 673>, 0, <673, 97, 410>, 0, <211, 673, 898>, 0, <211, 898, 625>, 0, <625, 898, 672>, 0, <625, 672, 212>, 0, 
			<98, 672, 898>, 0, <898, 410, 98>, 0, <425, 899, 662>, 0, <425, 662, 110>, 0, <662, 899, 640>, 0, <640, 224, 662>, 0, <204, 640, 650>, 0, <640, 899, 650>, 0, <90, 650, 899>, 0, <899, 425, 90>, 0, <679, 91, 426>, 0, 
			<679, 426, 900>, 0, <679, 900, 641>, 0, <641, 205, 679>, 0, <224, 641, 900>, 0, <224, 900, 662>, 0, <110, 662, 900>, 0, <110, 900, 426>, 0, <428, 901, 663>, 0, <428, 663, 111>, 0, <663, 901, 643>, 0, <643, 225, 663>, 0, 
			<215, 643, 901>, 0, <215, 901, 653>, 0, <101, 653, 901>, 0, <101, 901, 428>, 0, <902, 654, 102>, 0, <102, 429, 902>, 0, <216, 654, 902>, 0, <902, 644, 216>, 0, <225, 644, 902>, 0, <225, 902, 663>, 0, <111, 663, 429>, 0, 
			<663, 902, 429>, 0, <96, 404, 903>, 0, <96, 903, 674>, 0, <210, 674, 903>, 0, <903, 619, 210>, 0, <619, 903, 673>, 0, <673, 211, 619>, 0, <404, 97, 673>, 0, <404, 673, 903>, 0, <409, 904, 107>, 0, <904, 664, 107>, 0, 
			<664, 904, 624>, 0, <624, 221, 664>, 0, <624, 904, 655>, 0, <655, 217, 624>, 0, <103, 655, 904>, 0, <103, 904, 409>, 0, <420, 905, 657>, 0, <420, 657, 105>, 0, <219, 657, 635>, 0, <657, 905, 635>, 0, <635, 905, 656>, 0, 
			<656, 218, 635>, 0, <104, 656, 905>, 0, <104, 905, 420>, 0, <406, 906, 106>, 0, <906, 665, 106>, 0, <220, 665, 906>, 0, <906, 621, 220>, 0, <621, 906, 674>, 0, <621, 674, 210>, 0, <406, 96, 674>, 0, <406, 674, 906>, 0, 
			<407, 907, 675>, 0, <675, 95, 407>, 0, <209, 675, 907>, 0, <209, 907, 622>, 0, <622, 907, 665>, 0, <665, 220, 622>, 0, <106, 665, 407>, 0, <665, 907, 407>, 0, <415, 908, 655>, 0, <415, 655, 103>, 0, <217, 655, 908>, 0, 
			<908, 630, 217>, 0, <630, 908, 654>, 0, <654, 216, 630>, 0, <102, 654, 908>, 0, <102, 908, 415>, 0, <642, 909, 198>, 0, <909, 586, 198>, 0, <909, 666, 176>, 0, <176, 586, 909>, 0, <666, 909, 668>, 0, <666, 668, 191>, 0, 
			<225, 668, 642>, 0, <668, 909, 642>, 0, <173, 667, 910>, 0, <910, 607, 173>, 0, <203, 607, 910>, 0, <203, 910, 647>, 0, <910, 669, 227>, 0, <227, 647, 910>, 0, <669, 910, 667>, 0, <669, 667, 190>, 0, <191, 668, 911>, 0, 
			<191, 911, 574>, 0, <574, 911, 643>, 0, <574, 643, 215>, 0, <643, 911, 225>, 0, <911, 668, 225>, 0, <912, 589, 199>, 0, <199, 645, 912>, 0, <912, 681, 175>, 0, <175, 589, 912>, 0, <681, 912, 683>, 0, <681, 683, 189>, 0, 
			<226, 683, 912>, 0, <912, 645, 226>, 0, <442, 913, 112>, 0, <913, 660, 112>, 0, <660, 913, 683>, 0, <683, 226, 660>, 0, <189, 683, 913>, 0, <189, 913, 652>, 0, <75, 652, 913>, 0, <913, 442, 75>, 0}
	 normal_indices { 1824, <390, 1651, 160>, <391, 160, 1646>, <1647, 160, 397>, <160, 1660, 398>, <1661, 160, 1665>, <1666, 409, 1662>, <404, 1667, 160>, <405, 160, 1652>, <1671, 161, 1641>, <1642, 392, 1672>, 
			<161, 29, 629>, <630, 1643, 161>, <29, 161, 2080>, <29, 2081, 642>, <415, 2082, 161>, <161, 1673, 416>, <1683, 162, 1648>, <1649, 399, 1684>, <162, 1674, 393>, <394, 1650, 162>, <1675, 162, 1677>, 
			<1676, 1678, 417>, <1679, 162, 423>, <162, 1685, 424>, <654, 47, 1725>, <47, 163, 1726>, <453, 1727, 163>, <163, 1731, 454>, <459, 1732, 163>, <163, 24, 460>, <24, 163, 47>, <47, 0, 24>, 
			<1701, 164, 1680>, <1681, 425, 1702>, <164, 1689, 418>, <419, 1682, 164>, <1690, 164, 1695>, <1691, 1696, 429>, <1697, 164, 435>, <164, 1703, 436>, <430, 1713, 165>, <165, 1692, 431>, <1693, 165, 1719>, 
			<1720, 420, 1694>, <165, 1707, 447>, <448, 1721, 165>, <1708, 165, 1714>, <1709, 1715, 441>, <449, 2086, 1722>, <2087, 166, 1723>, <421, 1724, 166>, <166, 2083, 422>, <2084, 166, 43>, <43, 643, 2085>, 
			<166, 2088, 648>, <649, 43, 166>, <442, 1736, 167>, <167, 1710, 443>, <1711, 167, 1742>, <1743, 450, 1712>, <167, 1733, 461>, <462, 1744, 167>, <1734, 167, 1737>, <1735, 1738, 455>, <168, 24, 0>, 
			<0, 48, 168>, <24, 168, 1745>, <24, 1746, 463>, <451, 1747, 168>, <168, 2089, 452>, <2090, 168, 48>, <48, 650, 2091>, <1754, 169, 1728>, <1729, 456, 1755>, <169, 42, 655>, <656, 1730, 169>, 
			<42, 169, 1748>, <42, 1749, 661>, <1750, 169, 464>, <169, 1756, 465>, <1766, 170, 1739>, <1740, 444, 1767>, <170, 1757, 457>, <458, 1741, 170>, <1758, 170, 1760>, <1759, 1761, 466>, <1762, 170, 470>, 
			<170, 1768, 471>, <1772, 171, 1751>, <1752, 467, 1773>, <171, 28, 662>, <663, 1753, 171>, <28, 171, 25>, <25, 1, 28>, <171, 1774, 476>, <477, 25, 171>, <1784, 172, 1763>, <1764, 472, 1785>, 
			<172, 1775, 468>, <469, 1765, 172>, <1776, 172, 1778>, <1777, 1779, 478>, <1780, 172, 480>, <172, 1786, 481>, <473, 1796, 173>, <474, 173, 1787>, <1788, 173, 1802>, <1789, 1803, 482>, <1804, 173, 492>, 
			<173, 1790, 493>, <1791, 173, 1797>, <1798, 486, 1792>, <494, 2098, 174>, <495, 174, 1805>, <483, 1806, 2092>, <1807, 174, 2093>, <2094, 174, 668>, <174, 36, 669>, <36, 174, 2099>, <2100, 674, 36>, 
			<487, 1814, 175>, <488, 175, 1793>, <1794, 175, 1820>, <1795, 1821, 496>, <1822, 175, 506>, <175, 1808, 507>, <1809, 175, 1815>, <1816, 500, 1810>, <1838, 176, 1823>, <1824, 508, 1839>, <176, 1844, 497>, 
			<498, 1825, 176>, <1845, 176, 1832>, <1846, 1833, 519>, <1834, 176, 512>, <176, 1840, 513>, <520, 2104, 177>, <177, 1847, 521>, <499, 1848, 2101>, <1849, 177, 2102>, <177, 26, 675>, <676, 2103, 177>, 
			<26, 177, 2105>, <26, 2106, 680>, <1856, 178, 1835>, <1836, 514, 1857>, <178, 1862, 522>, <523, 1837, 178>, <1863, 178, 1850>, <1864, 1851, 531>, <1852, 178, 525>, <178, 1858, 526>, <532, 37, 179>, 
			<533, 179, 1865>, <524, 1866, 2107>, <1867, 179, 2108>, <179, 39, 681>, <682, 2109, 179>, <39, 179, 37>, <37, 3, 39>, <1868, 180, 1698>, <1699, 437, 1869>, <432, 1700, 180>, <433, 180, 1873>, 
			<489, 1874, 1817>, <1875, 180, 1818>, <1819, 180, 501>, <180, 1870, 502>, <1876, 181, 1716>, <1717, 434, 1877>, <181, 1769, 445>, <446, 1718, 181>, <1770, 181, 1799>, <1771, 1800, 475>, <1801, 181, 490>, 
			<181, 1878, 491>, <438, 2057, 182>, <439, 182, 1871>, <503, 1872, 182>, <504, 182, 2045>, <1921, 555, 2046>, <1922, 2047, 182>, <1923, 182, 2058>, <2059, 548, 1924>, <1915, 183, 1826>, <1827, 568, 1916>, 
			<183, 1859, 515>, <516, 1828, 183>, <1860, 183, 1909>, <1861, 1910, 527>, <1911, 183, 573>, <183, 1917, 574>, <575, 2128, 184>, <576, 184, 1912>, <528, 1913, 2110>, <1914, 184, 2111>, <2112, 184, 686>, 
			<184, 40, 687>, <40, 184, 2129>, <2130, 692, 40>, <400, 1663, 185>, <401, 185, 1655>, <1656, 185, 535>, <185, 1952, 536>, <1953, 185, 1940>, <1941, 579, 1954>, <410, 1942, 185>, <411, 185, 1664>, 
			<2048, 186, 1811>, <1812, 505, 2049>, <509, 1813, 186>, <510, 186, 2051>, <562, 2052, 1957>, <2053, 186, 1958>, <1959, 186, 556>, <186, 2050, 557>, <1963, 187, 1657>, <1658, 537, 1964>, <187, 1686, 402>, 
			<403, 1659, 187>, <1687, 187, 2063>, <1688, 2064, 426>, <542, 2065, 187>, <187, 1965, 543>, <563, 1960, 1897>, <1961, 188, 1898>, <1899, 188, 607>, <188, 1998, 608>, <1999, 188, 602>, <188, 1981, 603>, 
			<558, 1982, 188>, <559, 188, 1962>, <2004, 189, 1900>, <1901, 609, 2005>, <564, 1902, 189>, <565, 189, 1928>, <569, 1929, 1903>, <1930, 189, 1904>, <1905, 189, 613>, <189, 2006, 614>, <2016, 190, 1906>, 
			<1907, 615, 2017>, <570, 1908, 190>, <571, 190, 1918>, <1919, 190, 2010>, <1920, 2011, 577>, <2012, 190, 619>, <190, 2018, 620>, <621, 33, 191>, <622, 191, 2013>, <578, 2014, 2131>, <2015, 191, 2132>, 
			<2133, 191, 693>, <191, 34, 694>, <34, 191, 33>, <33, 728, 34>, <2022, 192, 1879>, <1880, 585, 2023>, <538, 1881, 192>, <539, 192, 1966>, <544, 1967, 1884>, <1968, 192, 1885>, <1886, 192, 2024>, 
			<1887, 2025, 592>, <540, 1955, 193>, <541, 193, 1882>, <1883, 193, 586>, <193, 2034, 587>, <624, 2035, 193>, <193, 2029, 625>, <580, 2030, 193>, <581, 193, 1956>, <2039, 194, 1888>, <1889, 593, 2040>, 
			<545, 1890, 194>, <546, 194, 1934>, <549, 1935, 1891>, <1936, 194, 1892>, <1893, 194, 597>, <194, 2041, 598>, <195, 1829, 517>, <518, 1841, 195>, <1830, 195, 1931>, <1831, 1932, 572>, <1933, 195, 566>, 
			<195, 2054, 567>, <2055, 195, 1842>, <1843, 511, 2056>, <196, 1704, 427>, <428, 2066, 196>, <1705, 196, 2060>, <1706, 2061, 440>, <2062, 196, 550>, <196, 1937, 551>, <1938, 196, 2067>, <2068, 547, 1939>, 
			<479, 1781, 25>, <1782, 197, 25>, <25, 197, 1>, <197, 27, 1>, <27, 197, 2095>, <2096, 670, 27>, <484, 2097, 197>, <485, 197, 1783>, <631, 31, 198>, <632, 198, 1644>, <1645, 198, 395>, 
			<198, 1653, 396>, <1654, 198, 406>, <198, 30, 407>, <30, 198, 31>, <31, 2, 30>, <408, 30, 1668>, <30, 199, 1669>, <1670, 199, 412>, <199, 2074, 413>, <2075, 199, 32>, <32, 636, 2076>, 
			<2, 32, 199>, <2, 199, 30>, <2163, 200, 1992>, <1993, 722, 2164>, <616, 1994, 200>, <617, 200, 2019>, <2020, 200, 33>, <2021, 33, 623>, <33, 200, 729>, <200, 2165, 730>, <2077, 201, 1943>, 
			<2078, 1944, 414>, <1945, 201, 582>, <201, 1946, 583>, <1947, 201, 35>, <35, 698, 1948>, <201, 2079, 637>, <638, 35, 201>, <529, 2113, 202>, <530, 202, 1853>, <1854, 202, 37>, <1855, 37, 534>, 
			<37, 202, 3>, <202, 38, 3>, <38, 202, 2114>, <2115, 688, 38>, <560, 2122, 1983>, <2123, 203, 1984>, <1985, 203, 604>, <203, 41, 605>, <41, 203, 2512>, <2513, 736, 41>, <822, 2514, 203>, 
			<823, 203, 2124>, <610, 2000, 1986>, <2001, 204, 1987>, <1988, 204, 716>, <204, 2169, 717>, <737, 2170, 204>, <738, 204, 41>, <606, 41, 2002>, <41, 204, 2003>, <699, 45, 205>, <700, 205, 1949>, 
			<1950, 205, 2031>, <1951, 2032, 584>, <2033, 205, 626>, <205, 44, 627>, <44, 205, 45>, <45, 742, 44>, <588, 2036, 206>, <589, 206, 1969>, <1970, 206, 704>, <206, 2175, 705>, <743, 2176, 206>, 
			<744, 206, 44>, <628, 44, 2037>, <44, 206, 2038>, <2180, 207, 1974>, <1975, 711, 2181>, <594, 1976, 207>, <595, 207, 2042>, <2043, 207, 46>, <2044, 46, 599>, <46, 207, 750>, <207, 2182, 751>, 
			<600, 46, 208>, <601, 208, 1894>, <1895, 208, 2116>, <1896, 2117, 552>, <2118, 208, 815>, <208, 2506, 816>, <2507, 208, 46>, <46, 752, 2508>, <553, 2119, 209>, <554, 209, 1925>, <1926, 209, 2125>, 
			<1927, 2126, 561>, <2127, 209, 824>, <209, 2379, 825>, <2380, 209, 2120>, <2121, 817, 2381>, <2186, 210, 1971>, <1972, 706, 2187>, <590, 1973, 210>, <591, 210, 2026>, <596, 2027, 1977>, <2028, 210, 1978>, 
			<1979, 210, 2188>, <1980, 2189, 712>, <2193, 211, 1989>, <1990, 718, 2194>, <611, 1991, 211>, <612, 211, 2007>, <618, 2008, 1995>, <2009, 211, 1996>, <1997, 211, 723>, <211, 2195, 724>, <29, 212, 2069>, 
			<2070, 633, 29>, <212, 2292, 756>, <757, 2071, 212>, <2293, 212, 2210>, <2294, 2211, 769>, <644, 2212, 212>, <212, 29, 645>, <664, 2227, 213>, <213, 42, 665>, <657, 42, 213>, <213, 2222, 658>, 
			<213, 2298, 780>, <781, 2223, 213>, <2299, 213, 2228>, <2300, 2229, 786>, <689, 2250, 214>, <690, 214, 38>, <38, 214, 49>, <38, 49, 3>, <49, 214, 870>, <214, 2304, 871>, <2305, 214, 2251>, 
			<2252, 809, 2306>, <3, 49, 215>, <3, 215, 39>, <39, 215, 2244>, <2245, 683, 39>, <215, 2310, 803>, <804, 2246, 215>, <2311, 215, 49>, <49, 872, 2312>, <51, 216, 2145>, <2146, 852, 51>, 
			<713, 2147, 216>, <714, 216, 2183>, <2184, 216, 50>, <2185, 50, 753>, <50, 216, 4>, <216, 51, 4>, <4, 67, 217>, <4, 217, 50>, <754, 50, 217>, <755, 217, 2509>, <2510, 217, 2518>, 
			<2511, 2519, 818>, <2520, 217, 67>, <67, 991, 2521>, <837, 2487, 218>, <838, 218, 2134>, <701, 2135, 45>, <2136, 218, 45>, <745, 45, 218>, <218, 2488, 746>, <707, 2177, 219>, <708, 219, 2140>, 
			<2141, 219, 845>, <219, 53, 846>, <5, 53, 219>, <5, 219, 52>, <747, 52, 2178>, <52, 219, 2179>, <54, 220, 2151>, <2152, 858, 54>, <719, 2153, 220>, <720, 220, 2196>, <725, 2197, 2157>, 
			<2198, 220, 2158>, <2159, 220, 864>, <220, 54, 865>, <721, 2171, 2154>, <2172, 221, 2155>, <2156, 221, 859>, <221, 56, 860>, <6, 56, 221>, <6, 221, 55>, <739, 55, 2173>, <55, 221, 2174>, 
			<671, 2232, 222>, <672, 222, 27>, <27, 222, 57>, <27, 57, 1>, <57, 222, 876>, <222, 2317, 877>, <2318, 222, 2233>, <2234, 792, 2319>, <1, 57, 223>, <1, 223, 28>, <666, 28, 223>, 
			<223, 2230, 667>, <223, 2323, 787>, <788, 2231, 223>, <2324, 223, 57>, <57, 878, 2325>, <758, 2330, 224>, <759, 224, 2072>, <634, 2073, 224>, <224, 31, 635>, <31, 224, 2>, <224, 58, 2>, 
			<58, 224, 2331>, <2332, 882, 58>, <2, 58, 32>, <58, 225, 32>, <639, 32, 225>, <225, 2204, 640>, <2205, 225, 2336>, <2337, 763, 2206>, <883, 2338, 225>, <884, 225, 58>, <695, 2256, 226>, 
			<696, 226, 40>, <691, 40, 2253>, <40, 226, 2254>, <2255, 226, 810>, <226, 2342, 811>, <2343, 226, 2257>, <2258, 830, 2344>, <659, 2224, 227>, <227, 47, 660>, <47, 227, 0>, <227, 59, 0>, 
			<59, 227, 2348>, <2349, 888, 59>, <2350, 227, 2225>, <2351, 2226, 782>, <0, 59, 48>, <59, 228, 48>, <651, 48, 228>, <228, 2216, 652>, <2217, 228, 2355>, <2356, 774, 2218>, <889, 2357, 228>, 
			<890, 228, 59>, <684, 2247, 229>, <229, 26, 685>, <26, 229, 2238>, <2239, 677, 26>, <229, 2361, 798>, <799, 2240, 229>, <2362, 229, 2248>, <2363, 2249, 805>, <60, 230, 2142>, <2143, 847, 60>, 
			<709, 2144, 230>, <710, 230, 2190>, <715, 2191, 2148>, <2192, 230, 2149>, <2150, 230, 853>, <230, 60, 854>, <653, 2219, 43>, <2220, 231, 43>, <646, 43, 231>, <231, 2213, 647>, <2214, 231, 2367>, 
			<2368, 770, 2215>, <231, 2221, 775>, <776, 2369, 231>, <678, 2241, 232>, <679, 232, 36>, <673, 36, 2235>, <36, 232, 2236>, <2237, 232, 793>, <232, 2373, 794>, <2374, 232, 2242>, <2243, 800, 2375>, 
			<702, 35, 233>, <233, 2137, 703>, <2138, 233, 2385>, <2386, 839, 2139>, <233, 2207, 764>, <765, 2387, 233>, <641, 2208, 35>, <2209, 233, 35>, <62, 234, 2160>, <2161, 866, 62>, <726, 2162, 234>, 
			<727, 234, 2166>, <2167, 234, 61>, <2168, 61, 731>, <61, 234, 7>, <234, 62, 7>, <732, 2491, 235>, <733, 235, 34>, <697, 34, 2259>, <34, 235, 2260>, <831, 2261, 235>, <832, 235, 2492>, 
			<801, 2427, 2376>, <2428, 236, 2377>, <795, 2378, 236>, <796, 236, 2421>, <2422, 236, 63>, <2423, 63, 931>, <937, 63, 236>, <938, 236, 2429>, <797, 2424, 2320>, <2425, 237, 2321>, <2322, 237, 879>, 
			<237, 64, 880>, <64, 237, 65>, <65, 8, 64>, <65, 237, 932>, <237, 2426, 933>, <881, 64, 2326>, <64, 238, 2327>, <2328, 238, 2415>, <2416, 789, 2329>, <238, 66, 925>, <926, 2417, 238>, 
			<8, 66, 238>, <8, 238, 64>, <2451, 239, 2273>, <2274, 974, 2452>, <855, 2275, 239>, <856, 239, 51>, <51, 239, 4>, <239, 67, 4>, <67, 239, 2453>, <2454, 992, 67>, <806, 2433, 240>, 
			<240, 2364, 807>, <2365, 240, 2430>, <2431, 802, 2366>, <240, 68, 939>, <940, 2432, 240>, <68, 240, 2434>, <68, 2435, 943>, <777, 2403, 241>, <241, 2370, 778>, <2371, 241, 2397>, <2398, 771, 2372>, 
			<241, 69, 907>, <908, 2399, 241>, <69, 241, 2404>, <69, 2405, 913>, <790, 2418, 242>, <242, 2301, 791>, <2302, 242, 2409>, <2410, 783, 2303>, <242, 70, 919>, <920, 2411, 242>, <70, 242, 2419>, 
			<70, 2420, 927>, <2295, 243, 2199>, <2200, 760, 2296>, <243, 71, 894>, <895, 2201, 243>, <71, 243, 2400>, <71, 2401, 909>, <772, 2402, 243>, <243, 2297, 773>, <2388, 244, 2262>, <2263, 840, 2389>, 
			<2264, 244, 961>, <244, 72, 962>, <72, 244, 2391>, <72, 2392, 901>, <766, 2393, 244>, <244, 2390, 767>, <2457, 245, 2268>, <2269, 967, 2458>, <848, 2270, 245>, <849, 245, 60>, <857, 60, 2276>, 
			<60, 245, 2277>, <2278, 245, 2459>, <2279, 2460, 975>, <833, 2445, 2345>, <2446, 246, 2346>, <812, 2347, 246>, <813, 246, 2439>, <2440, 246, 73>, <2441, 73, 949>, <955, 73, 246>, <956, 246, 2447>, 
			<814, 2442, 2307>, <2443, 247, 2308>, <2309, 247, 873>, <247, 74, 874>, <74, 247, 75>, <75, 9, 74>, <950, 75, 247>, <951, 247, 2444>, <875, 74, 2313>, <74, 248, 2314>, <2315, 248, 2436>, 
			<2437, 808, 2316>, <248, 76, 944>, <945, 2438, 248>, <9, 76, 248>, <9, 248, 74>, <2464, 249, 2280>, <2281, 979, 2465>, <861, 2282, 249>, <862, 249, 54>, <867, 54, 2286>, <54, 249, 2287>, 
			<2288, 249, 985>, <249, 2466, 986>, <784, 2412, 250>, <250, 2352, 785>, <2353, 250, 77>, <2354, 77, 891>, <77, 250, 10>, <250, 78, 10>, <78, 250, 2413>, <78, 2414, 921>, <892, 77, 251>, 
			<893, 251, 2358>, <2359, 251, 2406>, <2407, 779, 2360>, <251, 79, 914>, <915, 2408, 251>, <79, 251, 77>, <77, 10, 79>, <896, 81, 252>, <897, 252, 2202>, <761, 2203, 252>, <252, 2333, 762>, 
			<2334, 252, 80>, <2335, 80, 885>, <80, 252, 11>, <252, 81, 11>, <886, 80, 253>, <887, 253, 2339>, <768, 2340, 2394>, <2341, 253, 2395>, <2396, 253, 902>, <253, 82, 903>, <82, 253, 80>, 
			<80, 11, 82>, <850, 53, 254>, <851, 254, 2271>, <2272, 254, 968>, <254, 2470, 969>, <996, 2471, 254>, <997, 254, 83>, <5, 83, 254>, <5, 254, 53>, <863, 56, 2283>, <56, 255, 2284>, 
			<2285, 255, 980>, <255, 2475, 981>, <1003, 2476, 255>, <1004, 255, 85>, <6, 85, 255>, <6, 255, 56>, <2481, 256, 2289>, <2290, 987, 2482>, <868, 2291, 256>, <869, 256, 62>, <62, 256, 7>, 
			<256, 86, 7>, <86, 256, 2483>, <2484, 1010, 86>, <834, 2501, 257>, <835, 257, 2448>, <2449, 257, 87>, <2450, 87, 957>, <257, 2502, 1011>, <1012, 87, 257>, <2489, 258, 748>, <258, 52, 749>, 
			<52, 258, 5>, <258, 83, 5>, <83, 258, 2496>, <2497, 998, 83>, <841, 2498, 258>, <842, 258, 2490>, <7, 86, 259>, <7, 259, 61>, <259, 2493, 734>, <735, 61, 259>, <2494, 259, 2503>, 
			<2504, 836, 2495>, <1013, 2505, 259>, <1014, 259, 86>, <2265, 963, 84>, <2266, 84, 260>, <2267, 260, 843>, <260, 2499, 844>, <2500, 260, 999>, <260, 84, 1000>, <2515, 261, 740>, <261, 55, 741>, 
			<55, 261, 6>, <261, 85, 6>, <85, 261, 1005>, <261, 2526, 1006>, <826, 2527, 2516>, <2528, 261, 2517>, <262, 2536, 1025>, <1026, 2550, 262>, <2537, 262, 1018>, <262, 2541, 1019>, <1033, 2542, 262>, 
			<262, 2555, 1034>, <1038, 2556, 262>, <1039, 262, 2551>, <93, 263, 2531>, <2532, 1256, 93>, <263, 2560, 1020>, <1021, 2533, 263>, <2561, 263, 2971>, <2562, 2972, 1044>, <2973, 263, 1269>, <263, 93, 1270>, 
			<2563, 264, 2538>, <2539, 1022, 2564>, <1027, 2540, 264>, <1028, 264, 2572>, <1052, 2573, 2566>, <2574, 264, 2567>, <2568, 264, 1045>, <264, 2565, 1046>, <1082, 2620, 2614>, <2621, 265, 2615>, <2616, 265, 1281>, 
			<265, 111, 1282>, <111, 265, 88>, <88, 12, 111>, <1088, 88, 265>, <1089, 265, 2622>, <2578, 266, 2569>, <2570, 1047, 2579>, <1053, 2571, 266>, <1054, 266, 2590>, <1064, 2591, 2584>, <2592, 266, 2585>, 
			<2586, 266, 1058>, <266, 2580, 1059>, <1048, 2608, 267>, <1049, 267, 2581>, <1060, 2582, 2602>, <2583, 267, 2603>, <1070, 2604, 267>, <267, 2596, 1071>, <2597, 267, 2609>, <2610, 1076, 2598>, <1050, 2974, 268>, 
			<1051, 268, 2611>, <2612, 268, 2977>, <2613, 2978, 1077>, <2979, 268, 1275>, <268, 107, 1276>, <107, 268, 2975>, <2976, 1271, 107>, <1078, 2631, 269>, <1079, 269, 2599>, <1072, 2600, 2625>, <2601, 269, 2626>, 
			<1083, 2627, 269>, <269, 2623, 1084>, <2624, 269, 1090>, <269, 2632, 1091>, <1092, 2633, 88>, <2634, 270, 88>, <88, 270, 12>, <270, 112, 12>, <112, 270, 2980>, <2981, 1277, 112>, <1080, 2982, 270>, 
			<1081, 270, 2635>, <106, 271, 2617>, <2618, 1283, 106>, <271, 2642, 1085>, <1086, 2619, 271>, <1093, 2643, 2636>, <2644, 271, 2637>, <2638, 271, 1287>, <271, 106, 1288>, <2645, 272, 2628>, <2629, 1087, 2646>, 
			<272, 2654, 1073>, <1074, 2630, 272>, <1099, 2655, 2648>, <2656, 272, 2649>, <2650, 272, 1094>, <272, 2647, 1095>, <92, 273, 2639>, <2640, 1289, 92>, <1096, 2641, 273>, <1097, 273, 2660>, <1105, 2661, 273>, 
			<273, 89, 1106>, <89, 273, 92>, <92, 13, 89>, <2662, 274, 2651>, <2652, 1098, 2663>, <1100, 2653, 274>, <1101, 274, 2671>, <1110, 2672, 2665>, <2673, 274, 2666>, <2667, 274, 1107>, <274, 2664, 1108>, 
			<2689, 275, 1111>, <275, 2674, 1112>, <2675, 275, 2683>, <2684, 1102, 2676>, <1116, 2685, 275>, <1117, 275, 2677>, <2678, 275, 2690>, <2679, 2691, 1122>, <1113, 2983, 2692>, <2984, 276, 2693>, <2694, 276, 1123>, 
			<276, 2989, 1124>, <2990, 276, 100>, <100, 1299, 2991>, <1293, 100, 276>, <1294, 276, 2985>, <1125, 2707, 277>, <277, 2680, 1126>, <2681, 277, 2701>, <2702, 1118, 2682>, <1130, 2703, 277>, <1131, 277, 2695>, 
			<2696, 277, 2708>, <2697, 2709, 1136>, <2731, 278, 2710>, <2711, 1127, 2732>, <1137, 2712, 278>, <1138, 278, 2725>, <1142, 2726, 2719>, <2727, 278, 2720>, <2721, 278, 1148>, <278, 2733, 1149>, <1128, 2992, 279>, 
			<1129, 279, 2734>, <2735, 279, 2995>, <2736, 2996, 1150>, <2997, 279, 1305>, <279, 90, 1306>, <90, 279, 2993>, <2994, 1300, 90>, <2749, 280, 2722>, <2723, 1151, 2750>, <1143, 2724, 280>, <1144, 280, 2743>, 
			<1154, 2744, 2737>, <2745, 280, 2738>, <2739, 280, 1160>, <280, 2751, 1161>, <1152, 2998, 281>, <1153, 281, 2752>, <1162, 2753, 281>, <281, 101, 1163>, <101, 281, 103>, <103, 15, 101>, <103, 281, 2999>, 
			<3000, 1307, 103>, <2759, 282, 2587>, <2588, 1061, 2760>, <282, 2754, 1065>, <1066, 2589, 282>, <2755, 282, 2704>, <2756, 2705, 1132>, <2706, 282, 1119>, <282, 2761, 1120>, <2657, 283, 2605>, <2606, 1075, 2658>, 
			<283, 2762, 1062>, <1063, 2607, 283>, <2763, 283, 2686>, <2764, 2687, 1121>, <2688, 283, 1103>, <283, 2659, 1104>, <1133, 2936, 284>, <1134, 284, 2757>, <1067, 2758, 284>, <284, 2948, 1068>, <2949, 284, 2807>, 
			<2808, 1176, 2950>, <2809, 284, 2937>, <2810, 2938, 1183>, <2746, 285, 2713>, <2714, 1145, 2747>, <285, 2801, 1196>, <1197, 2715, 285>, <2802, 285, 2795>, <2803, 2796, 1202>, <2797, 285, 1155>, <285, 2748, 1156>, 
			<1157, 3001, 2798>, <3002, 286, 2799>, <2800, 286, 1203>, <286, 3019, 1204>, <3020, 286, 104>, <104, 1317, 3021>, <1311, 104, 286>, <1312, 286, 3003>, <287, 2545, 1165>, <1166, 2838, 287>, <2546, 287, 1029>, 
			<287, 2552, 1030>, <2553, 287, 2826>, <2827, 1040, 2554>, <287, 2839, 1208>, <1209, 2828, 287>, <1139, 2942, 288>, <288, 2698, 1140>, <2699, 288, 2939>, <2940, 1135, 2700>, <288, 2843, 1184>, <1185, 2941, 288>, 
			<2844, 288, 2943>, <2845, 2944, 1190>, <1031, 2575, 289>, <1032, 289, 2547>, <2548, 289, 2849>, <2549, 2850, 1167>, <289, 2954, 1171>, <1172, 2851, 289>, <1055, 2955, 2576>, <2956, 289, 2577>, <2886, 290, 2783>, 
			<2887, 2784, 1235>, <2785, 290, 1191>, <290, 2846, 1192>, <2847, 290, 2868>, <2869, 1186, 2848>, <290, 2888, 1230>, <1231, 2870, 290>, <2814, 291, 2786>, <2787, 1193, 2815>, <291, 2892, 1236>, <1237, 2788, 291>, 
			<2893, 291, 2789>, <2894, 2790, 1241>, <2791, 291, 1198>, <291, 2816, 1199>, <2804, 292, 2792>, <2793, 1200, 2805>, <292, 2904, 1242>, <1243, 2794, 292>, <2905, 292, 2898>, <2906, 2899, 1247>, <1205, 2900, 292>, 
			<292, 2806, 1206>, <1207, 3022, 2901>, <3023, 293, 2902>, <1248, 2903, 293>, <293, 97, 1249>, <97, 293, 98>, <98, 1353, 97>, <1318, 98, 293>, <1319, 293, 3024>, <2852, 294, 2765>, <2766, 1168, 2853>, 
			<294, 2911, 1214>, <1215, 2767, 294>, <2912, 294, 2770>, <2913, 2771, 1221>, <2772, 294, 2854>, <2773, 2855, 1173>, <295, 2768, 1216>, <1217, 2924, 295>, <2769, 295, 1169>, <295, 2840, 1170>, <2841, 295, 2918>, 
			<2919, 1210, 2842>, <295, 2925, 1251>, <1252, 2920, 295>, <2820, 296, 2774>, <2775, 1174, 2821>, <296, 2929, 1222>, <1223, 2776, 296>, <2930, 296, 2777>, <2931, 2778, 1226>, <2779, 296, 1177>, <296, 2822, 1178>, 
			<2817, 297, 2716>, <2818, 2717, 1201>, <2718, 297, 1146>, <297, 2728, 1147>, <2729, 297, 2945>, <2946, 1141, 2730>, <297, 2819, 1194>, <1195, 2947, 297>, <2951, 298, 2593>, <2952, 2594, 1069>, <2595, 298, 1056>, 
			<298, 2957, 1057>, <2958, 298, 2823>, <2824, 1175, 2959>, <298, 2953, 1179>, <1180, 2825, 298>, <13, 91, 299>, <13, 299, 89>, <1109, 89, 2668>, <89, 299, 2669>, <2670, 299, 1114>, <299, 2986, 1115>, 
			<2987, 299, 91>, <91, 1295, 2988>, <1023, 2543, 300>, <1024, 300, 2534>, <2535, 300, 1257>, <300, 95, 1258>, <95, 300, 94>, <94, 14, 95>, <300, 2544, 1035>, <1036, 94, 300>, <1041, 2965, 301>, 
			<1042, 301, 2557>, <2558, 301, 94>, <2559, 94, 1037>, <94, 301, 14>, <301, 96, 14>, <96, 301, 2966>, <2967, 1263, 96>, <2907, 302, 2880>, <2881, 1244, 2908>, <302, 3055, 1347>, <1348, 2882, 302>, 
			<302, 97, 1354>, <1355, 3056, 302>, <1250, 97, 2909>, <97, 302, 2910>, <303, 2829, 1211>, <1212, 2832, 303>, <2830, 303, 2968>, <2831, 2969, 1043>, <2970, 303, 1264>, <303, 99, 1265>, <99, 303, 2833>, 
			<2834, 1323, 99>, <1164, 101, 2740>, <101, 304, 2741>, <2742, 304, 1158>, <304, 3004, 1159>, <3005, 304, 102>, <102, 1313, 3006>, <304, 101, 15>, <15, 102, 304>, <1232, 105, 305>, <1233, 305, 2871>, 
			<1187, 2872, 3013>, <2873, 305, 3014>, <1448, 3015, 305>, <305, 3517, 1449>, <3518, 305, 105>, <105, 1361, 3519>, <3061, 306, 2874>, <3062, 2875, 1341>, <2876, 306, 1238>, <306, 2889, 1239>, <1234, 2890, 105>, 
			<2891, 306, 105>, <105, 306, 1362>, <306, 3063, 1363>, <1213, 2921, 2835>, <2922, 307, 2836>, <2837, 307, 1324>, <307, 109, 1325>, <109, 307, 108>, <108, 1367, 109>, <307, 2923, 1253>, <1254, 108, 307>, 
			<308, 2856, 1329>, <1330, 3067, 308>, <2857, 308, 1218>, <308, 2926, 1219>, <1255, 2927, 108>, <2928, 308, 108>, <108, 308, 1368>, <308, 3068, 1369>, <2932, 309, 2861>, <2862, 1224, 2933>, <309, 3072, 1336>, 
			<1337, 2863, 309>, <309, 110, 1375>, <1376, 3073, 309>, <1227, 110, 2934>, <110, 309, 2935>, <1181, 3007, 2780>, <3008, 310, 2781>, <1228, 2782, 310>, <310, 110, 1229>, <110, 310, 3511>, <3512, 1377, 110>, 
			<310, 3009, 1440>, <1441, 3513, 310>, <1188, 3016, 311>, <311, 2811, 1189>, <2812, 311, 3010>, <3011, 1182, 2813>, <311, 3273, 1442>, <1443, 3012, 311>, <3274, 311, 3017>, <3275, 3018, 1450>, <2914, 312, 2858>, 
			<2859, 1220, 2915>, <312, 3078, 1331>, <1332, 2860, 312>, <3079, 312, 2864>, <3080, 2865, 1338>, <2866, 312, 2916>, <2867, 2917, 1225>, <2895, 313, 2877>, <2878, 1240, 2896>, <313, 3085, 1342>, <1343, 2879, 313>, 
			<3086, 313, 2883>, <3087, 2884, 1349>, <2885, 313, 1245>, <313, 2897, 1246>, <3186, 314, 2960>, <2961, 1381, 3187>, <314, 93, 1259>, <1260, 2962, 314>, <93, 314, 3102>, <93, 3103, 1272>, <3104, 314, 1394>, 
			<314, 3188, 1395>, <1284, 3114, 315>, <1285, 315, 106>, <106, 315, 3120>, <106, 3121, 1290>, <3122, 315, 3192>, <3123, 3193, 1412>, <3194, 315, 3115>, <3116, 1406, 3195>, <15, 113, 102>, <113, 316, 102>, 
			<102, 316, 1314>, <316, 3145, 1315>, <3146, 316, 3199>, <3200, 1434, 3147>, <316, 113, 1495>, <1496, 3201, 316>, <1308, 3139, 317>, <1309, 317, 103>, <15, 103, 317>, <317, 113, 15>, <113, 317, 3205>, 
			<3206, 1497, 113>, <3207, 317, 3140>, <3141, 1428, 3208>, <3074, 318, 3036>, <3037, 1339, 3075>, <318, 115, 1477>, <1478, 3038, 318>, <318, 114, 16>, <16, 115, 318>, <1378, 114, 3076>, <114, 318, 3077>, 
			<1379, 3514, 319>, <319, 114, 1380>, <16, 114, 319>, <319, 131, 16>, <131, 319, 3523>, <131, 3524, 1614>, <1444, 3525, 3515>, <3526, 319, 3516>, <1326, 109, 3025>, <109, 320, 3026>, <1463, 3027, 320>, 
			<320, 3428, 1464>, <1370, 3429, 320>, <1371, 320, 109>, <321, 3031, 1470>, <1471, 117, 321>, <3032, 321, 1333>, <321, 3069, 1334>, <1372, 3070, 116>, <3071, 321, 116>, <116, 321, 17>, <321, 117, 17>, 
			<3088, 322, 3043>, <3044, 1344, 3089>, <322, 118, 1483>, <1484, 3045, 322>, <118, 322, 3049>, <118, 3050, 1489>, <3051, 322, 1350>, <322, 3090, 1351>, <120, 323, 3046>, <120, 3047, 1485>, <3048, 323, 1345>, 
			<323, 3064, 1346>, <1364, 3065, 119>, <3066, 323, 119>, <119, 323, 18>, <323, 120, 18>, <13, 121, 91>, <121, 324, 91>, <91, 324, 1296>, <324, 3127, 1297>, <3128, 324, 3212>, <3213, 1417, 3129>, 
			<324, 121, 1501>, <1502, 3214, 324>, <1291, 3124, 325>, <1292, 325, 92>, <13, 92, 325>, <325, 121, 13>, <121, 325, 3218>, <3219, 1503, 121>, <3220, 325, 3125>, <3126, 1413, 3221>, <1261, 95, 326>, 
			<1262, 326, 2963>, <2964, 326, 1382>, <326, 3225, 1383>, <3226, 326, 122>, <122, 1507, 3227>, <14, 122, 326>, <14, 326, 95>, <1266, 3096, 327>, <1267, 327, 96>, <14, 96, 122>, <96, 327, 122>, 
			<122, 327, 1508>, <327, 3231, 1509>, <3232, 327, 3097>, <3098, 1388, 3233>, <1316, 3148, 104>, <3149, 328, 104>, <104, 328, 1320>, <328, 3151, 1321>, <3152, 328, 3237>, <3238, 1456, 3153>, <1435, 3239, 328>, 
			<1436, 328, 3150>, <12, 123, 329>, <12, 329, 111>, <111, 329, 3117>, <111, 3118, 1286>, <3119, 329, 1407>, <329, 3243, 1408>, <3244, 329, 123>, <123, 1513, 3245>, <1278, 3108, 330>, <1279, 330, 112>, 
			<12, 112, 123>, <112, 330, 123>, <123, 330, 1514>, <330, 3250, 1515>, <3251, 330, 3109>, <3110, 1399, 3252>, <1301, 3133, 331>, <1302, 331, 90>, <90, 331, 3142>, <90, 3143, 1310>, <3144, 331, 1429>, 
			<331, 3255, 1430>, <3256, 331, 3134>, <3135, 1423, 3257>, <3081, 332, 3033>, <3034, 1335, 3082>, <332, 124, 1472>, <1473, 3035, 332>, <124, 332, 3039>, <124, 3040, 1479>, <3041, 332, 3083>, <3042, 3084, 1340>, 
			<1273, 3105, 333>, <1274, 333, 107>, <107, 333, 3111>, <107, 3112, 1280>, <3113, 333, 1400>, <333, 3261, 1401>, <3262, 333, 3106>, <3107, 1396, 3263>, <1298, 3130, 100>, <3131, 334, 100>, <100, 334, 1303>, 
			<334, 3136, 1304>, <3137, 334, 3267>, <3268, 1424, 3138>, <1418, 3269, 334>, <1419, 334, 3132>, <3279, 335, 3028>, <3029, 1465, 3280>, <335, 99, 1327>, <1328, 3030, 335>, <99, 335, 3099>, <99, 3100, 1268>, 
			<3101, 335, 1389>, <335, 3281, 1390>, <3057, 336, 3052>, <3053, 1352, 3058>, <336, 126, 1490>, <1491, 3054, 336>, <336, 125, 19>, <19, 126, 336>, <1356, 125, 3059>, <125, 336, 3060>, <1322, 3154, 98>, 
			<3155, 337, 98>, <1357, 98, 337>, <337, 3433, 1358>, <1457, 3434, 337>, <1458, 337, 3156>, <1420, 3315, 338>, <338, 3270, 1421>, <3271, 338, 3321>, <3322, 1425, 3272>, <338, 127, 1560>, <1561, 3323, 338>, 
			<1554, 127, 3316>, <127, 338, 3317>, <1504, 128, 339>, <339, 3215, 1505>, <3216, 339, 3318>, <3319, 1422, 3217>, <339, 129, 1555>, <1556, 3320, 339>, <129, 339, 128>, <129, 128, 20>, <1414, 3308, 340>, 
			<1415, 340, 3222>, <3223, 340, 128>, <128, 1506, 3224>, <340, 130, 20>, <20, 128, 340>, <130, 340, 3309>, <3310, 1549, 130>, <115, 341, 3168>, <3169, 1480, 115>, <341, 3345, 1597>, <1598, 3170, 341>, 
			<3346, 341, 1615>, <341, 131, 1616>, <16, 131, 341>, <341, 115, 16>, <2522, 342, 3387>, <2523, 3388, 819>, <3389, 342, 1445>, <342, 3527, 1446>, <1617, 3528, 342>, <1618, 342, 158>, <993, 158, 2524>, 
			<158, 342, 2525>, <1426, 3324, 343>, <1427, 343, 3258>, <3259, 343, 3327>, <3260, 3328, 1431>, <3329, 343, 1566>, <343, 132, 1567>, <132, 343, 3325>, <3326, 1562, 132>, <3264, 1397, 3291>, <3265, 3292, 344>, 
			<1402, 3266, 344>, <1403, 344, 3297>, <3298, 344, 133>, <3299, 133, 1537>, <1531, 133, 344>, <1532, 344, 3293>, <1409, 3302, 345>, <1410, 345, 3196>, <3197, 345, 3311>, <3198, 3312, 1416>, <3313, 345, 134>, 
			<3314, 134, 1550>, <134, 345, 3303>, <3304, 1543, 134>, <135, 346, 3091>, <3092, 1519, 135>, <346, 3189, 1384>, <1385, 3093, 346>, <3190, 346, 3294>, <3191, 3295, 1398>, <3296, 346, 1533>, <346, 135, 1534>, 
			<1584, 136, 347>, <1585, 347, 3157>, <3158, 347, 3282>, <3159, 3283, 1466>, <347, 3285, 1391>, <1392, 3284, 347>, <3286, 347, 136>, <3287, 136, 1525>, <124, 348, 3163>, <3164, 1474, 124>, <348, 3351, 1590>, 
			<1591, 3165, 348>, <3352, 348, 3171>, <3353, 3172, 1599>, <3173, 348, 1481>, <348, 124, 1482>, <1437, 3333, 349>, <349, 3240, 1438>, <3241, 349, 3339>, <3340, 1459, 3242>, <349, 137, 1578>, <1579, 3341, 349>, 
			<1572, 137, 3334>, <137, 349, 3335>, <1498, 138, 350>, <350, 3202, 1499>, <3203, 350, 3336>, <3337, 1439, 3204>, <350, 139, 1573>, <1574, 3338, 350>, <139, 350, 138>, <139, 138, 21>, <1432, 3330, 351>, 
			<1433, 351, 3209>, <3210, 351, 138>, <138, 1500, 3211>, <351, 140, 21>, <21, 138, 351>, <140, 351, 3331>, <3332, 1568, 140>, <118, 352, 3174>, <3175, 1486, 118>, <352, 3357, 1603>, <1604, 3176, 352>, 
			<3358, 352, 3180>, <3359, 3181, 1609>, <3182, 352, 1492>, <352, 118, 1493>, <141, 353, 3246>, <3247, 1516, 141>, <3248, 353, 3305>, <3249, 3306, 1411>, <3307, 353, 1544>, <353, 142, 1545>, <142, 353, 22>, 
			<353, 141, 22>, <1404, 3300, 354>, <1405, 354, 3253>, <1517, 3254, 354>, <1518, 354, 141>, <141, 354, 143>, <141, 143, 22>, <1538, 143, 354>, <354, 3301, 1539>, <1386, 3228, 355>, <1387, 355, 3094>, 
			<3095, 355, 1520>, <355, 145, 1521>, <145, 355, 23>, <355, 144, 23>, <144, 355, 3229>, <3230, 1510, 144>, <3288, 356, 3234>, <3235, 1393, 3289>, <1511, 3236, 356>, <1512, 356, 144>, <144, 356, 146>, 
			<144, 146, 23>, <1526, 146, 356>, <356, 3290, 1527>, <357, 3166, 1592>, <1593, 3364, 357>, <3167, 357, 1475>, <357, 117, 1476>, <17, 117, 357>, <17, 357, 147>, <147, 357, 3365>, <147, 3366, 1620>, 
			<2382, 358, 3393>, <2383, 3394, 827>, <1451, 3395, 358>, <358, 3276, 1452>, <3277, 358, 3390>, <3391, 1447, 3278>, <820, 3392, 358>, <821, 358, 2384>, <3369, 359, 3177>, <3370, 3178, 1605>, <3179, 359, 1487>, 
			<359, 120, 1488>, <18, 120, 359>, <18, 359, 149>, <149, 359, 3371>, <149, 3372, 1627>, <126, 360, 3183>, <3184, 1494, 126>, <360, 3375, 1610>, <1611, 3185, 360>, <3376, 360, 1633>, <360, 150, 1634>, 
			<19, 150, 360>, <360, 126, 19>, <3342, 1580, 151>, <3343, 151, 361>, <1460, 3344, 361>, <361, 3444, 1461>, <1635, 3445, 361>, <1636, 361, 151>, <2485, 362, 1015>, <362, 152, 1016>, <152, 362, 3377>, 
			<3378, 1637, 152>, <3379, 362, 3421>, <3422, 1612, 3380>, <988, 3423, 362>, <989, 362, 2486>, <958, 87, 363>, <959, 363, 3449>, <1581, 3450, 363>, <1582, 363, 151>, <151, 363, 152>, <152, 1638, 151>, 
			<1017, 152, 87>, <152, 363, 87>, <71, 364, 3381>, <3382, 898, 71>, <1522, 3383, 364>, <1523, 364, 135>, <135, 364, 3498>, <135, 3499, 1535>, <910, 3500, 364>, <364, 71, 911>, <78, 365, 153>, 
			<78, 153, 10>, <153, 365, 142>, <142, 22, 153>, <142, 365, 3486>, <142, 3487, 1546>, <922, 3488, 365>, <365, 78, 923>, <3492, 916, 79>, <3493, 79, 366>, <143, 1540, 3494>, <143, 3495, 366>, 
			<22, 143, 366>, <22, 366, 153>, <10, 153, 366>, <10, 366, 79>, <72, 367, 3398>, <72, 3399, 964>, <3400, 367, 136>, <136, 1586, 3401>, <367, 3505, 1528>, <1529, 136, 367>, <904, 3506, 367>, 
			<905, 367, 72>, <69, 368, 3501>, <3502, 912, 69>, <133, 1536, 3503>, <133, 3504, 368>, <1541, 133, 368>, <1542, 368, 3496>, <917, 3497, 368>, <368, 69, 918>, <2477, 369, 3415>, <2478, 3416, 982>, 
			<1606, 3417, 369>, <369, 3373, 1607>, <1628, 3374, 369>, <1629, 369, 154>, <1007, 154, 2479>, <154, 369, 2480>, <952, 73, 370>, <370, 3455, 953>, <1575, 3456, 370>, <370, 137, 1576>, <137, 370, 3451>, 
			<3452, 1583, 137>, <73, 960, 3453>, <73, 3454, 370>, <75, 371, 9>, <371, 155, 9>, <21, 155, 371>, <371, 139, 21>, <139, 371, 3457>, <3458, 1577, 139>, <75, 954, 3459>, <75, 3460, 371>, 
			<76, 372, 3461>, <3462, 946, 76>, <1569, 3463, 372>, <1570, 372, 140>, <140, 372, 155>, <155, 21, 140>, <9, 155, 76>, <155, 372, 76>, <70, 373, 3489>, <3490, 924, 70>, <1547, 3491, 373>, 
			<1548, 373, 134>, <134, 373, 3480>, <134, 3481, 1551>, <928, 3482, 373>, <373, 70, 929>, <68, 374, 3467>, <3468, 941, 68>, <1563, 3469, 374>, <1564, 374, 132>, <132, 374, 3464>, <132, 3465, 1571>, 
			<947, 3466, 374>, <374, 68, 948>, <81, 375, 156>, <81, 156, 11>, <156, 375, 145>, <145, 23, 156>, <1524, 145, 3384>, <145, 375, 3385>, <899, 3386, 375>, <375, 81, 900>, <3507, 906, 82>, 
			<3508, 82, 376>, <3509, 376, 146>, <146, 1530, 3510>, <23, 146, 376>, <23, 376, 156>, <11, 156, 376>, <11, 376, 82>, <84, 377, 157>, <84, 157, 1001>, <157, 377, 148>, <148, 1621, 157>, 
			<1587, 148, 377>, <1588, 377, 3402>, <965, 3403, 377>, <966, 377, 84>, <378, 3404, 970>, <971, 2472, 378>, <1594, 3405, 378>, <378, 3367, 1595>, <1622, 3368, 378>, <1623, 378, 157>, <1002, 157, 2473>, 
			<157, 378, 2474>, <934, 63, 379>, <935, 379, 3474>, <1557, 3475, 379>, <379, 127, 1558>, <127, 379, 3470>, <3471, 1565, 127>, <63, 942, 3472>, <63, 3473, 379>, <2455, 380, 994>, <380, 158, 995>, 
			<158, 380, 3347>, <3348, 1619, 158>, <3349, 380, 3409>, <3410, 1600, 3350>, <976, 3411, 380>, <977, 380, 2456>, <2467, 381, 3424>, <2468, 3425, 990>, <1613, 3426, 3360>, <3427, 381, 3361>, <3362, 381, 3418>, 
			<3419, 1608, 3363>, <983, 3420, 381>, <984, 381, 2469>, <65, 382, 8>, <382, 159, 8>, <20, 159, 382>, <382, 129, 20>, <129, 382, 3476>, <129, 3477, 1559>, <65, 936, 3478>, <65, 3479, 382>, 
			<66, 383, 3483>, <3484, 930, 66>, <1552, 3485, 383>, <1553, 383, 130>, <130, 383, 159>, <159, 20, 130>, <8, 159, 66>, <159, 383, 66>, <2461, 384, 3412>, <2462, 3413, 978>, <1601, 3414, 384>, 
			<384, 3354, 1602>, <3355, 384, 3406>, <3407, 1596, 3356>, <972, 3408, 384>, <973, 384, 2463>, <147, 385, 17>, <385, 116, 17>, <385, 3430, 1373>, <1374, 116, 385>, <3431, 385, 3438>, <3432, 3439, 1467>, 
			<1624, 3440, 147>, <3441, 385, 147>, <1359, 3435, 386>, <386, 125, 1360>, <19, 125, 386>, <19, 386, 150>, <386, 3446, 1639>, <1640, 150, 386>, <3447, 386, 3436>, <3448, 3437, 1462>, <1468, 3442, 387>, 
			<1469, 387, 3160>, <3161, 387, 148>, <3162, 148, 1589>, <148, 387, 1625>, <387, 3443, 1626>, <388, 119, 18>, <18, 149, 388>, <388, 3520, 1365>, <1366, 119, 388>, <3521, 388, 3529>, <3522, 3530, 1453>, 
			<1630, 3531, 388>, <388, 149, 1631>, <2529, 389, 1008>, <389, 154, 1009>, <154, 389, 3532>, <3533, 1632, 154>, <1454, 3534, 389>, <1455, 389, 3396>, <828, 3397, 389>, <389, 2530, 829>}
}
#declare wo_3_Handle = mesh2{
	 vertex_vectors { 5090, <-3.695145, 10.306097, -0.637401>, <-3.196422, 10.306097, -0.628695>, <-3.201802, 10.448538, -0.628789>, <-3.215958, 10.495211, -0.629036>, <-3.238946, 10.538225, -0.629438>, <-3.269882, 10.575928, -0.629978>, <-3.307579, 10.606869, -0.630636>, <-3.350586, 10.629860, -0.631386>, <-3.397252, 10.644018, -0.632201>, <-3.445783, 10.648799, -0.633048>, 
			<-3.494314, 10.644018, -0.633895>, <-3.540980, 10.629860, -0.634710>, <-3.583987, 10.606869, -0.635460>, <-3.621684, 10.575928, -0.636118>, <-3.652620, 10.538225, -0.636658>, <-3.675608, 10.495211, -0.637060>, <-3.689764, 10.448538, -0.637307>, <-3.695145, 9.693903, -0.637401>, <-3.689764, 9.551462, -0.637307>, <-3.675608, 9.504789, -0.637060>, <-3.652620, 9.461775, -0.636658>, 
			<-3.621684, 9.424072, -0.636118>, <-3.583987, 9.393131, -0.635460>, <-3.540980, 9.370140, -0.634710>, <-3.494314, 9.355982, -0.633895>, <-3.445783, 9.351201, -0.633048>, <-3.397252, 9.355982, -0.632201>, <-3.350586, 9.370140, -0.631386>, <-3.307579, 9.393131, -0.630636>, <-3.269882, 9.424072, -0.629978>, <-3.238946, 9.461775, -0.629438>, <-3.215958, 9.504789, -0.629036>, 
			<-3.201802, 9.551462, -0.628789>, <-3.196422, 9.693903, -0.628695>, <-3.520058, 9.678588, -0.634344>, <-3.513745, 9.471845, -0.634234>, <-3.497799, 9.447976, -0.633956>, <-3.473934, 9.432028, -0.633539>, <-3.445783, 9.426427, -0.633048>, <-3.417632, 9.432028, -0.632557>, <-3.393767, 9.447976, -0.632140>, <-3.377821, 9.471845, -0.631862>, <-3.371508, 9.678588, -0.631751>, 
			<-3.377821, 9.728155, -0.631862>, <-3.393767, 9.752024, -0.632140>, <-3.417632, 9.767972, -0.632557>, <-3.445783, 9.773573, -0.633048>, <-3.473934, 9.767972, -0.633539>, <-3.497799, 9.752024, -0.633956>, <-3.513745, 9.728155, -0.634234>, <-3.498449, 9.677541, -0.630842>, <-3.493977, 9.480057, -0.630764>, <-3.482682, 9.463150, -0.630567>, <-3.465778, 9.451853, -0.630271>, 
			<-3.445838, 9.447886, -0.629923>, <-3.425897, 9.451853, -0.629575>, <-3.408993, 9.463150, -0.629280>, <-3.397698, 9.480057, -0.629083>, <-3.393226, 9.677541, -0.629005>, <-3.397698, 9.719943, -0.629083>, <-3.408993, 9.736850, -0.629280>, <-3.425897, 9.748147, -0.629575>, <-3.445838, 9.752114, -0.629923>, <-3.465778, 9.748147, -0.630271>, <-3.482682, 9.736850, -0.630567>, 
			<-3.493977, 9.719943, -0.630764>, <-3.174657, 9.693370, -0.625190>, <-3.180508, 9.547215, -0.625292>, <-3.195903, 9.496458, -0.625561>, <-3.220902, 9.449680, -0.625997>, <-3.254546, 9.408679, -0.626584>, <-3.295540, 9.375030, -0.627300>, <-3.342311, 9.350027, -0.628116>, <-3.393060, 9.334630, -0.629002>, <-3.445838, 9.329431, -0.629923>, <-3.498615, 9.334630, -0.630845>, 
			<-3.549364, 9.350027, -0.631730>, <-3.596135, 9.375030, -0.632547>, <-3.637130, 9.408679, -0.633262>, <-3.670773, 9.449680, -0.633850>, <-3.695773, 9.496458, -0.634286>, <-3.711167, 9.547215, -0.634555>, <-3.717018, 9.693370, -0.634657>, <-3.711167, 10.452785, -0.634555>, <-3.695773, 10.503542, -0.634286>, <-3.670773, 10.550320, -0.633850>, <-3.637130, 10.591321, -0.633262>, 
			<-3.596135, 10.624970, -0.632547>, <-3.549364, 10.649973, -0.631730>, <-3.498615, 10.665370, -0.630845>, <-3.445838, 10.670569, -0.629923>, <-3.393060, 10.665370, -0.629002>, <-3.342311, 10.649973, -0.628116>, <-3.295540, 10.624970, -0.627300>, <-3.254546, 10.591321, -0.626584>, <-3.220902, 10.550320, -0.625997>, <-3.195903, 10.503542, -0.625561>, <-3.180508, 10.452785, -0.625292>, 
			<-3.174657, 10.306630, -0.625190>, <-3.717018, 10.306630, -0.634657>, <-3.171922, 9.693294, -0.603264>, <-3.177840, 9.546608, -0.603367>, <-3.193412, 9.495268, -0.603639>, <-3.218698, 9.447952, -0.604080>, <-3.252729, 9.406480, -0.604674>, <-3.294195, 9.372444, -0.605398>, <-3.341503, 9.347154, -0.606224>, <-3.392835, 9.331580, -0.607120>, <-3.446219, 9.326321, -0.608052>, 
			<-3.499603, 9.331580, -0.608984>, <-3.550936, 9.347154, -0.609880>, <-3.598244, 9.372444, -0.610705>, <-3.639710, 9.406480, -0.611429>, <-3.673740, 9.447952, -0.612023>, <-3.699027, 9.495268, -0.612465>, <-3.714599, 9.546608, -0.612736>, <-3.720517, 9.693294, -0.612840>, <-3.714599, 10.453392, -0.612736>, <-3.699027, 10.504732, -0.612465>, <-3.673740, 10.552048, -0.612023>, 
			<-3.639710, 10.593520, -0.611429>, <-3.598244, 10.627556, -0.610705>, <-3.550936, 10.652846, -0.609880>, <-3.499603, 10.668420, -0.608984>, <-3.446219, 10.673679, -0.608052>, <-3.392835, 10.668420, -0.607120>, <-3.341503, 10.652846, -0.606224>, <-3.294195, 10.627556, -0.605398>, <-3.252729, 10.593520, -0.604674>, <-3.218698, 10.552048, -0.604080>, <-3.193412, 10.504732, -0.603639>, 
			<-3.177840, 10.453392, -0.603367>, <-3.720517, 10.306706, -0.612840>, <-3.171922, 10.306706, -0.603264>, <-3.393226, 9.522459, -0.629005>, <-3.498449, 9.522459, -0.630842>, <-3.371508, 9.521412, -0.631751>, <-3.520058, 9.521412, -0.634344>, <-3.396703, 9.522608, -0.607187>, <-3.396703, 9.677392, -0.607187>, <-3.400911, 9.718770, -0.607261>, <-3.411542, 9.734683, -0.607446>, 
			<-3.427452, 9.745315, -0.607724>, <-3.446219, 9.749048, -0.608052>, <-3.464987, 9.745315, -0.608379>, <-3.480897, 9.734683, -0.608657>, <-3.491527, 9.718770, -0.608843>, <-3.495736, 9.677392, -0.608916>, <-3.495736, 9.522608, -0.608916>, <-3.491527, 9.481230, -0.608843>, <-3.480897, 9.465317, -0.608657>, <-3.464987, 9.454685, -0.608379>, <-3.446219, 9.450952, -0.608052>, 
			<-3.427452, 9.454685, -0.607724>, <-3.411542, 9.465317, -0.607446>, <-3.400911, 9.481230, -0.607261>, <-3.696890, 10.306097, -0.537416>, <-3.198167, 10.306097, -0.528711>, <-3.203547, 10.448538, -0.528804>, <-3.217703, 10.495211, -0.529052>, <-3.240691, 10.538225, -0.529453>, <-3.271628, 10.575928, -0.529993>, <-3.309324, 10.606869, -0.530651>, <-3.352332, 10.629860, -0.531401>, 
			<-3.398997, 10.644018, -0.532216>, <-3.447528, 10.648799, -0.533063>, <-3.496059, 10.644018, -0.533910>, <-3.542725, 10.629860, -0.534725>, <-3.585733, 10.606869, -0.535476>, <-3.623429, 10.575928, -0.536134>, <-3.654366, 10.538225, -0.536674>, <-3.677354, 10.495211, -0.537075>, <-3.691510, 10.448538, -0.537322>, <-3.696890, 9.693903, -0.537416>, <-3.691510, 9.551462, -0.537322>, 
			<-3.677354, 9.504789, -0.537075>, <-3.654366, 9.461775, -0.536674>, <-3.623429, 9.424072, -0.536134>, <-3.585733, 9.393131, -0.535476>, <-3.542725, 9.370140, -0.534725>, <-3.496059, 9.355982, -0.533910>, <-3.447528, 9.351201, -0.533063>, <-3.398997, 9.355982, -0.532216>, <-3.352332, 9.370140, -0.531401>, <-3.309324, 9.393131, -0.530651>, <-3.271628, 9.424072, -0.529993>, 
			<-3.240691, 9.461775, -0.529453>, <-3.217703, 9.504789, -0.529052>, <-3.203547, 9.551462, -0.528804>, <-3.198167, 9.693903, -0.528711>, <-3.176293, 9.693370, -0.531454>, <-3.182144, 9.547215, -0.531556>, <-3.197539, 9.496458, -0.531825>, <-3.222538, 9.449680, -0.532261>, <-3.256182, 9.408679, -0.532849>, <-3.297177, 9.375030, -0.533564>, <-3.343947, 9.350027, -0.534381>, 
			<-3.394696, 9.334630, -0.535266>, <-3.447474, 9.329431, -0.536188>, <-3.500251, 9.334630, -0.537109>, <-3.551000, 9.350027, -0.537995>, <-3.597771, 9.375030, -0.538811>, <-3.638766, 9.408679, -0.539527>, <-3.672409, 9.449680, -0.540114>, <-3.697409, 9.496458, -0.540550>, <-3.712803, 9.547215, -0.540819>, <-3.718654, 9.693370, -0.540921>, <-3.712803, 10.452785, -0.540819>, 
			<-3.697409, 10.503542, -0.540550>, <-3.672409, 10.550320, -0.540114>, <-3.638766, 10.591321, -0.539527>, <-3.597771, 10.624970, -0.538811>, <-3.551000, 10.649973, -0.537995>, <-3.500251, 10.665370, -0.537109>, <-3.447474, 10.670569, -0.536188>, <-3.394696, 10.665370, -0.535266>, <-3.343947, 10.649973, -0.534381>, <-3.297177, 10.624970, -0.533564>, <-3.256182, 10.591321, -0.532849>, 
			<-3.222538, 10.550320, -0.532261>, <-3.197539, 10.503542, -0.531825>, <-3.182144, 10.452785, -0.531556>, <-3.176293, 10.306630, -0.531454>, <-3.718654, 10.306630, -0.540921>, <-3.172794, 9.693294, -0.553271>, <-3.178713, 9.546608, -0.553375>, <-3.194284, 9.495268, -0.553647>, <-3.219571, 9.447952, -0.554088>, <-3.253601, 9.406480, -0.554682>, <-3.295067, 9.372444, -0.555406>, 
			<-3.342376, 9.347154, -0.556232>, <-3.393708, 9.331580, -0.557128>, <-3.447092, 9.326321, -0.558059>, <-3.500476, 9.331580, -0.558991>, <-3.551808, 9.347154, -0.559887>, <-3.599117, 9.372444, -0.560713>, <-3.640583, 9.406480, -0.561437>, <-3.674613, 9.447952, -0.562031>, <-3.699900, 9.495268, -0.562472>, <-3.715471, 9.546608, -0.562744>, <-3.721390, 9.693294, -0.562847>, 
			<-3.715471, 10.453392, -0.562744>, <-3.699900, 10.504732, -0.562472>, <-3.674613, 10.552048, -0.562031>, <-3.640583, 10.593520, -0.561437>, <-3.599117, 10.627556, -0.560713>, <-3.551808, 10.652846, -0.559887>, <-3.500476, 10.668420, -0.558991>, <-3.447092, 10.673679, -0.558059>, <-3.393708, 10.668420, -0.557128>, <-3.342376, 10.652846, -0.556232>, <-3.295067, 10.627556, -0.555406>, 
			<-3.253601, 10.593520, -0.554682>, <-3.219571, 10.552048, -0.554088>, <-3.194284, 10.504732, -0.553647>, <-3.178713, 10.453392, -0.553375>, <-3.721390, 10.306706, -0.562847>, <-3.172794, 10.306706, -0.553271>, <-3.397576, 9.522608, -0.557195>, <-3.397575, 9.677392, -0.557195>, <-3.401784, 9.718770, -0.557268>, <-3.412415, 9.734683, -0.557454>, <-3.428325, 9.745315, -0.557732>, 
			<-3.447092, 9.749048, -0.558059>, <-3.465859, 9.745315, -0.558387>, <-3.481769, 9.734683, -0.558665>, <-3.492400, 9.718770, -0.558850>, <-3.496609, 9.677392, -0.558924>, <-3.496609, 9.522608, -0.558924>, <-3.492400, 9.481230, -0.558850>, <-3.481769, 9.465317, -0.558665>, <-3.465859, 9.454685, -0.558387>, <-3.447092, 9.450952, -0.558059>, <-3.428325, 9.454685, -0.557732>, 
			<-3.412415, 9.465317, -0.557454>, <-3.401784, 9.481230, -0.557268>, <-3.394863, 9.522459, -0.535269>, <-3.394862, 9.677541, -0.535269>, <-3.399334, 9.719943, -0.535347>, <-3.410629, 9.736850, -0.535545>, <-3.427534, 9.748147, -0.535840>, <-3.447474, 9.752114, -0.536188>, <-3.467414, 9.748147, -0.536536>, <-3.484318, 9.736850, -0.536831>, <-3.495614, 9.719943, -0.537028>, 
			<-3.500085, 9.677541, -0.537106>, <-3.500086, 9.522459, -0.537106>, <-3.495614, 9.480057, -0.537028>, <-3.484318, 9.463150, -0.536831>, <-3.467414, 9.451853, -0.536536>, <-3.447474, 9.447886, -0.536188>, <-3.427534, 9.451853, -0.535840>, <-3.410629, 9.463150, -0.535545>, <-3.399334, 9.480057, -0.535347>, <-3.521803, 9.678588, -0.534360>, <-3.515490, 9.471845, -0.534249>, 
			<-3.499544, 9.447976, -0.533971>, <-3.475679, 9.432028, -0.533555>, <-3.447528, 9.426427, -0.533063>, <-3.419378, 9.432028, -0.532572>, <-3.395512, 9.447976, -0.532155>, <-3.379566, 9.471845, -0.531877>, <-3.373253, 9.678588, -0.531767>, <-3.379566, 9.728155, -0.531877>, <-3.395512, 9.752024, -0.532155>, <-3.419378, 9.767972, -0.532572>, <-3.447528, 9.773573, -0.533063>, 
			<-3.475679, 9.767972, -0.533555>, <-3.499544, 9.752024, -0.533971>, <-3.515490, 9.728155, -0.534249>, <-3.373254, 9.521412, -0.531767>, <-3.521804, 9.521412, -0.534360>, <-3.703871, 10.306097, -0.137477>, <-3.205148, 10.306097, -0.128771>, <-3.210528, 10.448538, -0.128865>, <-3.224684, 10.495211, -0.129112>, <-3.247672, 10.538225, -0.129514>, <-3.278609, 10.575928, -0.130054>, 
			<-3.316305, 10.606869, -0.130712>, <-3.359313, 10.629860, -0.131462>, <-3.405978, 10.644018, -0.132277>, <-3.454509, 10.648799, -0.133124>, <-3.503040, 10.644018, -0.133971>, <-3.549706, 10.629860, -0.134786>, <-3.592714, 10.606869, -0.135536>, <-3.630410, 10.575928, -0.136194>, <-3.661347, 10.538225, -0.136734>, <-3.684335, 10.495211, -0.137136>, <-3.698490, 10.448538, -0.137383>, 
			<-3.703871, 9.693903, -0.137477>, <-3.698490, 9.551462, -0.137383>, <-3.684335, 9.504789, -0.137136>, <-3.661347, 9.461775, -0.136734>, <-3.630410, 9.424072, -0.136194>, <-3.592714, 9.393131, -0.135536>, <-3.549706, 9.370140, -0.134786>, <-3.503040, 9.355982, -0.133971>, <-3.454509, 9.351201, -0.133124>, <-3.405978, 9.355982, -0.132277>, <-3.359313, 9.370140, -0.131462>, 
			<-3.316305, 9.393131, -0.130712>, <-3.278609, 9.424072, -0.130054>, <-3.247672, 9.461775, -0.129514>, <-3.224684, 9.504789, -0.129112>, <-3.210528, 9.551462, -0.128865>, <-3.205148, 9.693903, -0.128771>, <-3.528784, 9.678588, -0.134421>, <-3.522471, 9.471845, -0.134310>, <-3.506525, 9.447976, -0.134032>, <-3.482660, 9.432028, -0.133615>, <-3.454509, 9.426427, -0.133124>, 
			<-3.426359, 9.432028, -0.132633>, <-3.402493, 9.447976, -0.132216>, <-3.386547, 9.471845, -0.131938>, <-3.380234, 9.678588, -0.131828>, <-3.386547, 9.728155, -0.131938>, <-3.402493, 9.752024, -0.132216>, <-3.426359, 9.767972, -0.132633>, <-3.454509, 9.773573, -0.133124>, <-3.482660, 9.767972, -0.133615>, <-3.506525, 9.752024, -0.134032>, <-3.522471, 9.728155, -0.134310>, 
			<-3.507175, 9.677541, -0.130918>, <-3.502704, 9.480057, -0.130840>, <-3.491408, 9.463150, -0.130643>, <-3.474504, 9.451853, -0.130348>, <-3.454564, 9.447886, -0.130000>, <-3.434624, 9.451853, -0.129651>, <-3.417719, 9.463150, -0.129356>, <-3.406424, 9.480057, -0.129159>, <-3.401952, 9.677541, -0.129081>, <-3.406424, 9.719943, -0.129159>, <-3.417719, 9.736850, -0.129356>, 
			<-3.434624, 9.748147, -0.129651>, <-3.454564, 9.752114, -0.130000>, <-3.474504, 9.748147, -0.130348>, <-3.491408, 9.736850, -0.130643>, <-3.502704, 9.719943, -0.130840>, <-3.183383, 9.693370, -0.125266>, <-3.189234, 9.547215, -0.125368>, <-3.204629, 9.496458, -0.125637>, <-3.229628, 9.449680, -0.126073>, <-3.263272, 9.408679, -0.126661>, <-3.304267, 9.375030, -0.127376>, 
			<-3.351037, 9.350027, -0.128192>, <-3.401786, 9.334630, -0.129078>, <-3.454564, 9.329431, -0.130000>, <-3.507341, 9.334630, -0.130921>, <-3.558090, 9.350027, -0.131807>, <-3.604861, 9.375030, -0.132623>, <-3.645856, 9.408679, -0.133339>, <-3.679499, 9.449680, -0.133926>, <-3.704499, 9.496458, -0.134362>, <-3.719893, 9.547215, -0.134631>, <-3.725744, 9.693370, -0.134733>, 
			<-3.719893, 10.452785, -0.134631>, <-3.704499, 10.503542, -0.134362>, <-3.679499, 10.550320, -0.133926>, <-3.645856, 10.591321, -0.133339>, <-3.604861, 10.624970, -0.132623>, <-3.558090, 10.649973, -0.131807>, <-3.507341, 10.665370, -0.130921>, <-3.454564, 10.670569, -0.130000>, <-3.401786, 10.665370, -0.129078>, <-3.351037, 10.649973, -0.128192>, <-3.304267, 10.624970, -0.127376>, 
			<-3.263272, 10.591321, -0.126661>, <-3.229628, 10.550320, -0.126073>, <-3.204629, 10.503542, -0.125637>, <-3.189234, 10.452785, -0.125368>, <-3.183383, 10.306630, -0.125266>, <-3.725744, 10.306630, -0.134733>, <-3.180648, 9.693294, -0.103340>, <-3.186566, 9.546608, -0.103443>, <-3.202138, 9.495268, -0.103715>, <-3.227425, 9.447952, -0.104156>, <-3.261455, 9.406480, -0.104750>, 
			<-3.302921, 9.372444, -0.105474>, <-3.350229, 9.347154, -0.106300>, <-3.401562, 9.331580, -0.107196>, <-3.454946, 9.326321, -0.108128>, <-3.508330, 9.331580, -0.109060>, <-3.559662, 9.347154, -0.109956>, <-3.606970, 9.372444, -0.110781>, <-3.648436, 9.406480, -0.111505>, <-3.682467, 9.447952, -0.112099>, <-3.707753, 9.495268, -0.112541>, <-3.723325, 9.546608, -0.112812>, 
			<-3.729243, 9.693294, -0.112916>, <-3.723325, 10.453392, -0.112812>, <-3.707753, 10.504732, -0.112541>, <-3.682467, 10.552048, -0.112099>, <-3.648436, 10.593520, -0.111505>, <-3.606970, 10.627556, -0.110781>, <-3.559662, 10.652846, -0.109956>, <-3.508330, 10.668420, -0.109060>, <-3.454946, 10.673679, -0.108128>, <-3.401562, 10.668420, -0.107196>, <-3.350229, 10.652846, -0.106300>, 
			<-3.302921, 10.627556, -0.105474>, <-3.261455, 10.593520, -0.104750>, <-3.227425, 10.552048, -0.104156>, <-3.202138, 10.504732, -0.103715>, <-3.186566, 10.453392, -0.103443>, <-3.729243, 10.306706, -0.112916>, <-3.180648, 10.306706, -0.103340>, <-3.401953, 9.522459, -0.129081>, <-3.507176, 9.522459, -0.130918>, <-3.380235, 9.521412, -0.131828>, <-3.528785, 9.521412, -0.134421>, 
			<-3.405429, 9.522608, -0.107264>, <-3.405429, 9.677392, -0.107264>, <-3.409638, 9.718770, -0.107337>, <-3.420268, 9.734683, -0.107523>, <-3.436178, 9.745315, -0.107800>, <-3.454946, 9.749048, -0.108128>, <-3.473713, 9.745315, -0.108455>, <-3.489623, 9.734683, -0.108733>, <-3.500254, 9.718770, -0.108919>, <-3.504462, 9.677392, -0.108992>, <-3.504463, 9.522608, -0.108992>, 
			<-3.500254, 9.481230, -0.108919>, <-3.489623, 9.465317, -0.108733>, <-3.473713, 9.454685, -0.108455>, <-3.454946, 9.450952, -0.108128>, <-3.436178, 9.454685, -0.107800>, <-3.420268, 9.465317, -0.107523>, <-3.409638, 9.481230, -0.107337>, <-3.705616, 10.306097, -0.037492>, <-3.206893, 10.306097, -0.028787>, <-3.212273, 10.448538, -0.028881>, <-3.226429, 10.495211, -0.029128>, 
			<-3.249417, 10.538225, -0.029529>, <-3.280354, 10.575928, -0.030069>, <-3.318050, 10.606869, -0.030727>, <-3.361058, 10.629860, -0.031478>, <-3.407724, 10.644018, -0.032292>, <-3.456255, 10.648799, -0.033139>, <-3.504785, 10.644018, -0.033986>, <-3.551451, 10.629860, -0.034801>, <-3.594459, 10.606869, -0.035552>, <-3.632155, 10.575928, -0.036210>, <-3.663092, 10.538225, -0.036750>, 
			<-3.686080, 10.495211, -0.037151>, <-3.700236, 10.448538, -0.037398>, <-3.705616, 9.693903, -0.037492>, <-3.700236, 9.551462, -0.037398>, <-3.686080, 9.504789, -0.037151>, <-3.663092, 9.461775, -0.036750>, <-3.632155, 9.424072, -0.036210>, <-3.594459, 9.393131, -0.035552>, <-3.551451, 9.370140, -0.034801>, <-3.504785, 9.355982, -0.033986>, <-3.456255, 9.351201, -0.033139>, 
			<-3.407724, 9.355982, -0.032292>, <-3.361058, 9.370140, -0.031478>, <-3.318050, 9.393131, -0.030727>, <-3.280354, 9.424072, -0.030069>, <-3.249417, 9.461775, -0.029529>, <-3.226429, 9.504789, -0.029128>, <-3.212273, 9.551462, -0.028881>, <-3.206893, 9.693903, -0.028787>, <-3.185019, 9.693370, -0.031530>, <-3.190870, 9.547215, -0.031632>, <-3.206265, 9.496458, -0.031901>, 
			<-3.231264, 9.449680, -0.032338>, <-3.264908, 9.408679, -0.032925>, <-3.305903, 9.375030, -0.033640>, <-3.352674, 9.350027, -0.034457>, <-3.403423, 9.334630, -0.035343>, <-3.456200, 9.329431, -0.036264>, <-3.508977, 9.334630, -0.037185>, <-3.559726, 9.350027, -0.038071>, <-3.606497, 9.375030, -0.038887>, <-3.647492, 9.408679, -0.039603>, <-3.681136, 9.449680, -0.040190>, 
			<-3.706135, 9.496458, -0.040626>, <-3.721530, 9.547215, -0.040895>, <-3.727381, 9.693370, -0.040997>, <-3.721530, 10.452785, -0.040895>, <-3.706135, 10.503542, -0.040626>, <-3.681136, 10.550320, -0.040190>, <-3.647492, 10.591321, -0.039603>, <-3.606497, 10.624970, -0.038887>, <-3.559726, 10.649973, -0.038071>, <-3.508977, 10.665370, -0.037185>, <-3.456200, 10.670569, -0.036264>, 
			<-3.403423, 10.665370, -0.035343>, <-3.352674, 10.649973, -0.034457>, <-3.305903, 10.624970, -0.033640>, <-3.264908, 10.591321, -0.032925>, <-3.231264, 10.550320, -0.032338>, <-3.206265, 10.503542, -0.031901>, <-3.190870, 10.452785, -0.031632>, <-3.185019, 10.306630, -0.031530>, <-3.727381, 10.306630, -0.040997>, <-3.181521, 9.693294, -0.053348>, <-3.187439, 9.546608, -0.053451>, 
			<-3.203010, 9.495268, -0.053723>, <-3.228297, 9.447952, -0.054164>, <-3.262327, 9.406480, -0.054758>, <-3.303794, 9.372444, -0.055482>, <-3.351102, 9.347154, -0.056308>, <-3.402434, 9.331580, -0.057204>, <-3.455818, 9.326321, -0.058135>, <-3.509202, 9.331580, -0.059067>, <-3.560535, 9.347154, -0.059963>, <-3.607843, 9.372444, -0.060789>, <-3.649309, 9.406480, -0.061513>, 
			<-3.683339, 9.447952, -0.062107>, <-3.708626, 9.495268, -0.062548>, <-3.724198, 9.546608, -0.062820>, <-3.730116, 9.693294, -0.062923>, <-3.724198, 10.453392, -0.062820>, <-3.708626, 10.504732, -0.062548>, <-3.683339, 10.552048, -0.062107>, <-3.649309, 10.593520, -0.061513>, <-3.607843, 10.627556, -0.060789>, <-3.560535, 10.652846, -0.059963>, <-3.509202, 10.668420, -0.059067>, 
			<-3.455818, 10.673679, -0.058135>, <-3.402434, 10.668420, -0.057204>, <-3.351102, 10.652846, -0.056308>, <-3.303794, 10.627556, -0.055482>, <-3.262327, 10.593520, -0.054758>, <-3.228297, 10.552048, -0.054164>, <-3.203010, 10.504732, -0.053723>, <-3.187439, 10.453392, -0.053451>, <-3.730116, 10.306706, -0.062923>, <-3.181521, 10.306706, -0.053348>, <-3.406302, 9.522608, -0.057271>, 
			<-3.406302, 9.677392, -0.057271>, <-3.410510, 9.718770, -0.057345>, <-3.421141, 9.734683, -0.057530>, <-3.437051, 9.745315, -0.057808>, <-3.455818, 9.749048, -0.058135>, <-3.474585, 9.745315, -0.058463>, <-3.490495, 9.734683, -0.058741>, <-3.501126, 9.718770, -0.058926>, <-3.505335, 9.677392, -0.059000>, <-3.505335, 9.522608, -0.059000>, <-3.501126, 9.481230, -0.058926>, 
			<-3.490495, 9.465317, -0.058741>, <-3.474585, 9.454685, -0.058463>, <-3.455818, 9.450952, -0.058135>, <-3.437051, 9.454685, -0.057808>, <-3.421141, 9.465317, -0.057530>, <-3.410510, 9.481230, -0.057345>, <-3.403589, 9.522459, -0.035345>, <-3.403589, 9.677541, -0.035345>, <-3.408060, 9.719943, -0.035424>, <-3.419355, 9.736850, -0.035621>, <-3.436260, 9.748147, -0.035916>, 
			<-3.456200, 9.752114, -0.036264>, <-3.476140, 9.748147, -0.036612>, <-3.493045, 9.736850, -0.036907>, <-3.504340, 9.719943, -0.037104>, <-3.508812, 9.677541, -0.037182>, <-3.508812, 9.522459, -0.037182>, <-3.504340, 9.480057, -0.037104>, <-3.493045, 9.463150, -0.036907>, <-3.476140, 9.451853, -0.036612>, <-3.456200, 9.447886, -0.036264>, <-3.436260, 9.451853, -0.035916>, 
			<-3.419355, 9.463150, -0.035621>, <-3.408060, 9.480057, -0.035424>, <-3.530530, 9.678588, -0.034436>, <-3.524217, 9.471845, -0.034326>, <-3.508270, 9.447976, -0.034047>, <-3.484405, 9.432028, -0.033631>, <-3.456255, 9.426427, -0.033139>, <-3.428104, 9.432028, -0.032648>, <-3.404239, 9.447976, -0.032231>, <-3.388293, 9.471845, -0.031953>, <-3.381980, 9.678588, -0.031843>, 
			<-3.388293, 9.728155, -0.031953>, <-3.404239, 9.752024, -0.032231>, <-3.428104, 9.767972, -0.032648>, <-3.456255, 9.773573, -0.033139>, <-3.484405, 9.767972, -0.033631>, <-3.508270, 9.752024, -0.034047>, <-3.524216, 9.728155, -0.034326>, <-3.381980, 9.521412, -0.031843>, <-3.530530, 9.521412, -0.034436>, <-3.540406, 10.400000, -0.791993>, <-3.155171, 10.400000, -1.225447>, 
			<-3.293369, 10.400000, -1.221442>, <-3.349307, 10.400000, -1.205534>, <-3.401067, 10.400000, -1.179019>, <-3.446660, 10.400000, -1.142915>, <-3.484333, 10.400000, -1.098610>, <-3.512639, 10.400000, -1.047807>, <-3.530490, 10.400000, -0.992457>, <-3.532961, 10.437540, -0.791681>, <-3.155119, 10.437540, -1.217996>, <-3.292047, 10.437540, -1.214130>, <-3.346584, 10.437540, -1.198620>, 
			<-3.397047, 10.437540, -1.172769>, <-3.441498, 10.437540, -1.137569>, <-3.478227, 10.437540, -1.094374>, <-3.505824, 10.437540, -1.044843>, <-3.523227, 10.437540, -0.990881>, <-3.511760, 10.469365, -0.790792>, <-3.154971, 10.469365, -1.196776>, <-3.288281, 10.469365, -1.193305>, <-3.338828, 10.469365, -1.178930>, <-3.385599, 10.469365, -1.154970>, <-3.426797, 10.469365, -1.122346>, 
			<-3.460839, 10.469365, -1.082311>, <-3.486417, 10.469365, -1.036405>, <-3.502547, 10.469365, -0.986390>, <-3.480029, 10.490630, -0.789462>, <-3.154749, 10.490630, -1.165019>, <-3.282645, 10.490630, -1.162138>, <-3.327220, 10.490630, -1.149462>, <-3.368465, 10.490630, -1.128333>, <-3.404796, 10.490630, -1.099563>, <-3.434816, 10.490630, -1.064258>, <-3.457371, 10.490630, -1.023776>, 
			<-3.471596, 10.490630, -0.979670>, <-3.442601, 10.498097, -0.787893>, <-3.154487, 10.498097, -1.127559>, <-3.275997, 10.498097, -1.125375>, <-3.313527, 10.498097, -1.114701>, <-3.348254, 10.498097, -1.096912>, <-3.378844, 10.498097, -1.072689>, <-3.404119, 10.498097, -1.042964>, <-3.423110, 10.498097, -1.008878>, <-3.435087, 10.498097, -0.971743>, <-3.405173, 10.490630, -0.786324>, 
			<-3.154225, 10.490630, -1.090099>, <-3.269349, 10.490630, -1.088611>, <-3.299835, 10.490630, -1.079941>, <-3.328044, 10.490630, -1.065491>, <-3.352891, 10.490630, -1.045814>, <-3.373423, 10.490630, -1.021669>, <-3.388849, 10.490630, -0.993981>, <-3.398577, 10.490630, -0.963817>, <-3.373443, 10.469365, -0.784994>, <-3.154003, 10.469365, -1.058342>, <-3.263713, 10.469365, -1.057444>, 
			<-3.288227, 10.469365, -1.050473>, <-3.310910, 10.469365, -1.038853>, <-3.330890, 10.469365, -1.023031>, <-3.347399, 10.469365, -1.003616>, <-3.359804, 10.469365, -0.981352>, <-3.367627, 10.469365, -0.957096>, <-3.352241, 10.437540, -0.784106>, <-3.153855, 10.437540, -1.037122>, <-3.259947, 10.437540, -1.036620>, <-3.280471, 10.437540, -1.030783>, <-3.299462, 10.437540, -1.021055>, 
			<-3.316189, 10.437540, -1.007808>, <-3.330011, 10.437540, -0.991553>, <-3.340396, 10.437540, -0.972914>, <-3.346946, 10.437540, -0.952606>, <-3.344797, 10.400000, -0.783793>, <-3.153803, 10.400000, -1.029671>, <-3.258625, 10.400000, -1.029307>, <-3.277747, 10.400000, -1.023869>, <-3.295441, 10.400000, -1.014804>, <-3.311027, 10.400000, -1.002463>, <-3.323905, 10.400000, -0.987317>, 
			<-3.333582, 10.400000, -0.969950>, <-3.339684, 10.400000, -0.951029>, <-3.352241, 10.362460, -0.784106>, <-3.153855, 10.362460, -1.037122>, <-3.259947, 10.362460, -1.036620>, <-3.280471, 10.362460, -1.030783>, <-3.299462, 10.362460, -1.021055>, <-3.316189, 10.362460, -1.007808>, <-3.330011, 10.362460, -0.991553>, <-3.340396, 10.362460, -0.972914>, <-3.346946, 10.362460, -0.952606>, 
			<-3.373443, 10.330635, -0.784994>, <-3.154003, 10.330635, -1.058342>, <-3.263713, 10.330635, -1.057444>, <-3.288227, 10.330635, -1.050473>, <-3.310910, 10.330635, -1.038853>, <-3.330890, 10.330635, -1.023031>, <-3.347399, 10.330635, -1.003616>, <-3.359804, 10.330635, -0.981352>, <-3.367627, 10.330635, -0.957096>, <-3.405173, 10.309370, -0.786324>, <-3.154225, 10.309370, -1.090099>, 
			<-3.269349, 10.309370, -1.088611>, <-3.299835, 10.309370, -1.079941>, <-3.328044, 10.309370, -1.065491>, <-3.352891, 10.309370, -1.045814>, <-3.373423, 10.309370, -1.021669>, <-3.388849, 10.309370, -0.993981>, <-3.398577, 10.309370, -0.963817>, <-3.442601, 10.301903, -0.787893>, <-3.154487, 10.301903, -1.127559>, <-3.275997, 10.301903, -1.125375>, <-3.313527, 10.301903, -1.114701>, 
			<-3.348254, 10.301903, -1.096912>, <-3.378844, 10.301903, -1.072689>, <-3.404119, 10.301903, -1.042964>, <-3.423110, 10.301903, -1.008878>, <-3.435087, 10.301903, -0.971743>, <-3.480029, 10.309370, -0.789462>, <-3.154749, 10.309370, -1.165019>, <-3.282645, 10.309370, -1.162138>, <-3.327220, 10.309370, -1.149462>, <-3.368465, 10.309370, -1.128333>, <-3.404796, 10.309370, -1.099563>, 
			<-3.434816, 10.309370, -1.064258>, <-3.457371, 10.309370, -1.023776>, <-3.471596, 10.309370, -0.979670>, <-3.511760, 10.330635, -0.790792>, <-3.154971, 10.330635, -1.196776>, <-3.288281, 10.330635, -1.193305>, <-3.338828, 10.330635, -1.178930>, <-3.385599, 10.330635, -1.154970>, <-3.426797, 10.330635, -1.122346>, <-3.460839, 10.330635, -1.082311>, <-3.486417, 10.330635, -1.036405>, 
			<-3.502547, 10.330635, -0.986390>, <-3.532961, 10.362460, -0.791681>, <-3.155119, 10.362460, -1.217996>, <-3.292047, 10.362460, -1.214130>, <-3.346584, 10.362460, -1.198620>, <-3.397047, 10.362460, -1.172769>, <-3.441498, 10.362460, -1.137569>, <-3.478227, 10.362460, -1.094374>, <-3.505824, 10.362460, -1.044843>, <-3.523227, 10.362460, -0.990881>, <-2.243387, 10.400000, -0.910000>, 
			<-2.248755, 10.400000, -0.970085>, <-2.264664, 10.400000, -1.026023>, <-2.291179, 10.400000, -1.077783>, <-2.327283, 10.400000, -1.123376>, <-2.371588, 10.400000, -1.161049>, <-2.422391, 10.400000, -1.189355>, <-2.477740, 10.400000, -1.207205>, <-2.615714, 10.400000, -1.216031>, <-2.250838, 10.437540, -0.909948>, <-2.256068, 10.437540, -0.968762>, <-2.271578, 10.437540, -1.023300>, 
			<-2.297429, 10.437540, -1.073763>, <-2.332629, 10.437540, -1.118214>, <-2.375824, 10.437540, -1.154943>, <-2.425354, 10.437540, -1.182540>, <-2.479317, 10.437540, -1.199943>, <-2.616026, 10.437540, -1.208586>, <-2.272058, 10.469365, -0.909800>, <-2.276893, 10.469365, -0.964997>, <-2.291268, 10.469365, -1.015543>, <-2.315228, 10.469365, -1.062315>, <-2.347852, 10.469365, -1.103513>, 
			<-2.387886, 10.469365, -1.137555>, <-2.433793, 10.469365, -1.163132>, <-2.483807, 10.469365, -1.179263>, <-2.616915, 10.469365, -1.187385>, <-2.303815, 10.490630, -0.909578>, <-2.308060, 10.490630, -0.959361>, <-2.320736, 10.490630, -1.003936>, <-2.341865, 10.490630, -1.045181>, <-2.370635, 10.490630, -1.081512>, <-2.405939, 10.490630, -1.111532>, <-2.446422, 10.490630, -1.134087>, 
			<-2.490527, 10.490630, -1.148312>, <-2.618245, 10.490630, -1.155655>, <-2.341275, 10.498097, -0.909316>, <-2.344823, 10.498097, -0.952713>, <-2.355496, 10.498097, -0.990243>, <-2.373286, 10.498097, -1.024970>, <-2.397509, 10.498097, -1.055559>, <-2.427234, 10.498097, -1.080835>, <-2.461319, 10.498097, -1.099826>, <-2.498454, 10.498097, -1.111802>, <-2.619814, 10.498097, -1.118226>, 
			<-2.378735, 10.490630, -0.909054>, <-2.381587, 10.490630, -0.946065>, <-2.390256, 10.490630, -0.976551>, <-2.404707, 10.490630, -1.004760>, <-2.424383, 10.490630, -1.029607>, <-2.448529, 10.490630, -1.050139>, <-2.476216, 10.490630, -1.065565>, <-2.506381, 10.490630, -1.075293>, <-2.621383, 10.490630, -1.080798>, <-2.410493, 10.469365, -0.908832>, <-2.412753, 10.469365, -0.940429>, 
			<-2.419725, 10.469365, -0.964943>, <-2.431345, 10.469365, -0.987626>, <-2.447166, 10.469365, -1.007606>, <-2.466582, 10.469365, -1.024115>, <-2.488846, 10.469365, -1.036520>, <-2.513101, 10.469365, -1.044342>, <-2.622713, 10.469365, -1.049068>, <-2.431712, 10.437540, -0.908684>, <-2.433578, 10.437540, -0.936663>, <-2.439415, 10.437540, -0.957187>, <-2.449143, 10.437540, -0.976177>, 
			<-2.462389, 10.437540, -0.992905>, <-2.478645, 10.437540, -1.006727>, <-2.497284, 10.437540, -1.017112>, <-2.517591, 10.437540, -1.023662>, <-2.623602, 10.437540, -1.027867>, <-2.439163, 10.400000, -0.908632>, <-2.440891, 10.400000, -0.935341>, <-2.446329, 10.400000, -0.954463>, <-2.455393, 10.400000, -0.972157>, <-2.467735, 10.400000, -0.987743>, <-2.482880, 10.400000, -1.000621>, 
			<-2.500247, 10.400000, -1.010297>, <-2.519168, 10.400000, -1.016400>, <-2.623914, 10.400000, -1.020422>, <-2.431712, 10.362460, -0.908684>, <-2.433578, 10.362460, -0.936663>, <-2.439415, 10.362460, -0.957187>, <-2.449143, 10.362460, -0.976177>, <-2.462389, 10.362460, -0.992905>, <-2.478645, 10.362460, -1.006727>, <-2.497284, 10.362460, -1.017112>, <-2.517591, 10.362460, -1.023662>, 
			<-2.623602, 10.362460, -1.027867>, <-2.410493, 10.330635, -0.908832>, <-2.412753, 10.330635, -0.940429>, <-2.419725, 10.330635, -0.964943>, <-2.431345, 10.330635, -0.987626>, <-2.447166, 10.330635, -1.007606>, <-2.466582, 10.330635, -1.024115>, <-2.488846, 10.330635, -1.036520>, <-2.513101, 10.330635, -1.044342>, <-2.622713, 10.330635, -1.049068>, <-2.378735, 10.309370, -0.909054>, 
			<-2.381587, 10.309370, -0.946065>, <-2.390256, 10.309370, -0.976551>, <-2.404707, 10.309370, -1.004760>, <-2.424383, 10.309370, -1.029607>, <-2.448529, 10.309370, -1.050139>, <-2.476216, 10.309370, -1.065565>, <-2.506381, 10.309370, -1.075293>, <-2.621383, 10.309370, -1.080798>, <-2.341275, 10.301903, -0.909316>, <-2.344823, 10.301903, -0.952713>, <-2.355496, 10.301903, -0.990243>, 
			<-2.373286, 10.301903, -1.024970>, <-2.397509, 10.301903, -1.055559>, <-2.427234, 10.301903, -1.080835>, <-2.461319, 10.301903, -1.099826>, <-2.498454, 10.301903, -1.111802>, <-2.619814, 10.301903, -1.118226>, <-2.303815, 10.309370, -0.909578>, <-2.308060, 10.309370, -0.959361>, <-2.320736, 10.309370, -1.003936>, <-2.341865, 10.309370, -1.045181>, <-2.370635, 10.309370, -1.081512>, 
			<-2.405939, 10.309370, -1.111532>, <-2.446422, 10.309370, -1.134087>, <-2.490527, 10.309370, -1.148312>, <-2.618245, 10.309370, -1.155655>, <-2.272058, 10.330635, -0.909800>, <-2.276893, 10.330635, -0.964997>, <-2.291268, 10.330635, -1.015543>, <-2.315228, 10.330635, -1.062315>, <-2.347852, 10.330635, -1.103513>, <-2.387886, 10.330635, -1.137555>, <-2.433793, 10.330635, -1.163132>, 
			<-2.483807, 10.330635, -1.179263>, <-2.616915, 10.330635, -1.187385>, <-2.250838, 10.362460, -0.909948>, <-2.256068, 10.362460, -0.968762>, <-2.271578, 10.362460, -1.023300>, <-2.297429, 10.362460, -1.073763>, <-2.332629, 10.362460, -1.118214>, <-2.375824, 10.362460, -1.154943>, <-2.425354, 10.362460, -1.182540>, <-2.479317, 10.362460, -1.199943>, <-2.616026, 10.362460, -1.208586>, 
			<-2.251300, 10.437540, -0.843483>, <-2.243834, 10.400000, -0.843353>, <-2.251300, 10.362460, -0.843483>, <-2.272562, 10.330635, -0.843854>, <-2.304382, 10.309370, -0.844410>, <-2.341916, 10.301903, -0.845065>, <-2.379451, 10.309370, -0.845720>, <-2.411271, 10.330635, -0.846276>, <-2.432532, 10.362460, -0.846647>, <-2.439998, 10.400000, -0.846777>, <-2.432532, 10.437540, -0.846647>, 
			<-2.411271, 10.469365, -0.846276>, <-2.379451, 10.490630, -0.845720>, <-2.341916, 10.498097, -0.845065>, <-2.304382, 10.490630, -0.844410>, <-2.272562, 10.469365, -0.843854>, <-2.254623, 10.436367, -0.815412>, <-2.247390, 10.400000, -0.815286>, <-2.254623, 10.363633, -0.815412>, <-2.275220, 10.332803, -0.815772>, <-2.306046, 10.312202, -0.816310>, <-2.342407, 10.304969, -0.816944>, 
			<-2.378768, 10.312202, -0.817579>, <-2.409594, 10.332803, -0.818117>, <-2.430191, 10.363633, -0.818477>, <-2.437424, 10.400000, -0.818603>, <-2.430191, 10.436367, -0.818477>, <-2.409594, 10.467197, -0.818117>, <-2.378768, 10.487798, -0.817579>, <-2.342407, 10.495031, -0.816944>, <-2.306046, 10.487798, -0.816310>, <-2.275220, 10.467197, -0.815772>, <-2.277603, 10.426870, -0.812688>, 
			<-2.272259, 10.400000, -0.812594>, <-2.277603, 10.373130, -0.812688>, <-2.292821, 10.350352, -0.812953>, <-2.315596, 10.335131, -0.813351>, <-2.342462, 10.329787, -0.813820>, <-2.369327, 10.335131, -0.814289>, <-2.392102, 10.350352, -0.814686>, <-2.407320, 10.373130, -0.814952>, <-2.412664, 10.400000, -0.815045>, <-2.407320, 10.426870, -0.814952>, <-2.392102, 10.449648, -0.814686>, 
			<-2.369327, 10.464869, -0.814289>, <-2.342462, 10.470213, -0.813820>, <-2.315596, 10.464869, -0.813351>, <-2.292821, 10.449648, -0.812953>, <-3.556367, 10.400000, 0.122407>, <-3.186494, 10.400000, 0.569041>, <-3.324468, 10.400000, 0.560216>, <-3.379817, 10.400000, 0.542365>, <-3.430620, 10.400000, 0.514059>, <-3.474925, 10.400000, 0.476386>, <-3.511029, 10.400000, 0.430794>, 
			<-3.537544, 10.400000, 0.379034>, <-3.553453, 10.400000, 0.323095>, <-3.548916, 10.437540, 0.122355>, <-3.186182, 10.437540, 0.561596>, <-3.322891, 10.437540, 0.552954>, <-3.376854, 10.437540, 0.535550>, <-3.426384, 10.437540, 0.507953>, <-3.469579, 10.437540, 0.471224>, <-3.504779, 10.437540, 0.426774>, <-3.530630, 10.437540, 0.376310>, <-3.546140, 10.437540, 0.321773>, 
			<-3.527696, 10.469365, 0.122206>, <-3.185293, 10.469365, 0.540395>, <-3.318401, 10.469365, 0.532273>, <-3.368415, 10.469365, 0.516143>, <-3.414322, 10.469365, 0.490565>, <-3.454356, 10.469365, 0.456523>, <-3.486980, 10.469365, 0.415325>, <-3.510940, 10.469365, 0.368554>, <-3.525315, 10.469365, 0.318007>, <-3.495939, 10.490630, 0.121984>, <-3.183963, 10.490630, 0.508665>, 
			<-3.311681, 10.490630, 0.501322>, <-3.355786, 10.490630, 0.487098>, <-3.396269, 10.490630, 0.464542>, <-3.431573, 10.490630, 0.434522>, <-3.460343, 10.490630, 0.398191>, <-3.481472, 10.490630, 0.356946>, <-3.494148, 10.490630, 0.312371>, <-3.458479, 10.498097, 0.121723>, <-3.182394, 10.498097, 0.471237>, <-3.303754, 10.498097, 0.464813>, <-3.340889, 10.498097, 0.452836>, 
			<-3.374974, 10.498097, 0.433845>, <-3.404699, 10.498097, 0.408570>, <-3.428922, 10.498097, 0.377981>, <-3.446712, 10.498097, 0.343254>, <-3.457385, 10.498097, 0.305723>, <-3.421018, 10.490630, 0.121461>, <-3.180825, 10.490630, 0.433808>, <-3.295827, 10.490630, 0.428304>, <-3.325992, 10.490630, 0.418575>, <-3.353679, 10.490630, 0.403149>, <-3.377825, 10.490630, 0.382617>, 
			<-3.397501, 10.490630, 0.357770>, <-3.411952, 10.490630, 0.329561>, <-3.420621, 10.490630, 0.299075>, <-3.389261, 10.469365, 0.121239>, <-3.179495, 10.469365, 0.402078>, <-3.289107, 10.469365, 0.397353>, <-3.313362, 10.469365, 0.389530>, <-3.335626, 10.469365, 0.377126>, <-3.355042, 10.469365, 0.360616>, <-3.370863, 10.469365, 0.340636>, <-3.382483, 10.469365, 0.317953>, 
			<-3.389455, 10.469365, 0.293439>, <-3.368042, 10.437540, 0.121091>, <-3.178606, 10.437540, 0.380877>, <-3.284617, 10.437540, 0.376672>, <-3.304924, 10.437540, 0.370123>, <-3.323563, 10.437540, 0.359737>, <-3.339819, 10.437540, 0.345915>, <-3.353065, 10.437540, 0.329188>, <-3.362793, 10.437540, 0.310197>, <-3.368630, 10.437540, 0.289674>, <-3.360590, 10.400000, 0.121039>, 
			<-3.178294, 10.400000, 0.373432>, <-3.283040, 10.400000, 0.369410>, <-3.301961, 10.400000, 0.363308>, <-3.319327, 10.400000, 0.353632>, <-3.334473, 10.400000, 0.340753>, <-3.346815, 10.400000, 0.325168>, <-3.355879, 10.400000, 0.307474>, <-3.361317, 10.400000, 0.288351>, <-3.368042, 10.362460, 0.121091>, <-3.178606, 10.362460, 0.380877>, <-3.284617, 10.362460, 0.376672>, 
			<-3.304924, 10.362460, 0.370123>, <-3.323563, 10.362460, 0.359737>, <-3.339819, 10.362460, 0.345915>, <-3.353065, 10.362460, 0.329188>, <-3.362793, 10.362460, 0.310197>, <-3.368630, 10.362460, 0.289674>, <-3.389261, 10.330635, 0.121239>, <-3.179495, 10.330635, 0.402078>, <-3.289107, 10.330635, 0.397353>, <-3.313362, 10.330635, 0.389530>, <-3.335626, 10.330635, 0.377126>, 
			<-3.355042, 10.330635, 0.360616>, <-3.370863, 10.330635, 0.340636>, <-3.382483, 10.330635, 0.317953>, <-3.389455, 10.330635, 0.293439>, <-3.421018, 10.309370, 0.121461>, <-3.180825, 10.309370, 0.433808>, <-3.295827, 10.309370, 0.428304>, <-3.325992, 10.309370, 0.418575>, <-3.353679, 10.309370, 0.403149>, <-3.377825, 10.309370, 0.382617>, <-3.397501, 10.309370, 0.357770>, 
			<-3.411952, 10.309370, 0.329561>, <-3.420621, 10.309370, 0.299075>, <-3.458479, 10.301903, 0.121723>, <-3.182394, 10.301903, 0.471237>, <-3.303754, 10.301903, 0.464813>, <-3.340889, 10.301903, 0.452836>, <-3.374974, 10.301903, 0.433845>, <-3.404699, 10.301903, 0.408570>, <-3.428922, 10.301903, 0.377981>, <-3.446712, 10.301903, 0.343254>, <-3.457385, 10.301903, 0.305723>, 
			<-3.495939, 10.309370, 0.121984>, <-3.183963, 10.309370, 0.508665>, <-3.311681, 10.309370, 0.501322>, <-3.355786, 10.309370, 0.487098>, <-3.396269, 10.309370, 0.464542>, <-3.431573, 10.309370, 0.434522>, <-3.460343, 10.309370, 0.398191>, <-3.481472, 10.309370, 0.356946>, <-3.494148, 10.309370, 0.312371>, <-3.527696, 10.330635, 0.122206>, <-3.185293, 10.330635, 0.540395>, 
			<-3.318401, 10.330635, 0.532273>, <-3.368415, 10.330635, 0.516143>, <-3.414322, 10.330635, 0.490565>, <-3.454356, 10.330635, 0.456523>, <-3.486980, 10.330635, 0.415325>, <-3.510940, 10.330635, 0.368554>, <-3.525315, 10.330635, 0.318007>, <-3.548916, 10.362460, 0.122355>, <-3.186182, 10.362460, 0.561596>, <-3.322891, 10.362460, 0.552954>, <-3.376854, 10.362460, 0.535550>, 
			<-3.426384, 10.362460, 0.507953>, <-3.469579, 10.362460, 0.471224>, <-3.504779, 10.362460, 0.426774>, <-3.530630, 10.362460, 0.376310>, <-3.546140, 10.362460, 0.321773>, <-2.264256, 10.400000, 0.285607>, <-2.271718, 10.400000, 0.345468>, <-2.289569, 10.400000, 0.400817>, <-2.317875, 10.400000, 0.451620>, <-2.355548, 10.400000, 0.495925>, <-2.401141, 10.400000, 0.532029>, 
			<-2.452901, 10.400000, 0.558544>, <-2.508839, 10.400000, 0.574453>, <-2.647037, 10.400000, 0.578458>, <-2.271701, 10.437540, 0.285295>, <-2.278981, 10.437540, 0.343891>, <-2.296384, 10.437540, 0.397854>, <-2.323981, 10.437540, 0.447384>, <-2.360710, 10.437540, 0.490579>, <-2.405161, 10.437540, 0.525779>, <-2.455624, 10.437540, 0.551630>, <-2.510161, 10.437540, 0.567140>, 
			<-2.647089, 10.437540, 0.571006>, <-2.292903, 10.469365, 0.284406>, <-2.299661, 10.469365, 0.339401>, <-2.315791, 10.469365, 0.389415>, <-2.341369, 10.469365, 0.435322>, <-2.375411, 10.469365, 0.475356>, <-2.416609, 10.469365, 0.507980>, <-2.463380, 10.469365, 0.531940>, <-2.513927, 10.469365, 0.546315>, <-2.647237, 10.469365, 0.549787>, <-2.324633, 10.490630, 0.283076>, 
			<-2.330612, 10.490630, 0.332681>, <-2.344837, 10.490630, 0.376786>, <-2.367392, 10.490630, 0.417269>, <-2.397412, 10.490630, 0.452573>, <-2.433743, 10.490630, 0.481343>, <-2.474988, 10.490630, 0.502472>, <-2.519563, 10.490630, 0.515148>, <-2.647459, 10.490630, 0.518030>, <-2.362061, 10.498097, 0.281507>, <-2.367121, 10.498097, 0.324754>, <-2.379098, 10.498097, 0.361889>, 
			<-2.398089, 10.498097, 0.395974>, <-2.423364, 10.498097, 0.425699>, <-2.453954, 10.498097, 0.449922>, <-2.488681, 10.498097, 0.467712>, <-2.526211, 10.498097, 0.478385>, <-2.647721, 10.498097, 0.480569>, <-2.399489, 10.490630, 0.279938>, <-2.403631, 10.490630, 0.316827>, <-2.413359, 10.490630, 0.346992>, <-2.428785, 10.490630, 0.374679>, <-2.449317, 10.490630, 0.398825>, 
			<-2.474164, 10.490630, 0.418501>, <-2.502373, 10.490630, 0.432952>, <-2.532859, 10.490630, 0.441621>, <-2.647983, 10.490630, 0.443109>, <-2.431219, 10.469365, 0.278608>, <-2.434581, 10.469365, 0.310107>, <-2.442404, 10.469365, 0.334362>, <-2.454809, 10.469365, 0.356626>, <-2.471318, 10.469365, 0.376042>, <-2.491298, 10.469365, 0.391863>, <-2.513981, 10.469365, 0.403483>, 
			<-2.538495, 10.469365, 0.410455>, <-2.648205, 10.469365, 0.411352>, <-2.452421, 10.437540, 0.277719>, <-2.455262, 10.437540, 0.305617>, <-2.461812, 10.437540, 0.325924>, <-2.472197, 10.437540, 0.344563>, <-2.486019, 10.437540, 0.360819>, <-2.502746, 10.437540, 0.374065>, <-2.521737, 10.437540, 0.383793>, <-2.542261, 10.437540, 0.389630>, <-2.648353, 10.437540, 0.390133>, 
			<-2.459866, 10.400000, 0.277407>, <-2.462524, 10.400000, 0.304040>, <-2.468626, 10.400000, 0.322961>, <-2.478303, 10.400000, 0.340328>, <-2.491181, 10.400000, 0.355473>, <-2.506767, 10.400000, 0.367815>, <-2.524461, 10.400000, 0.376879>, <-2.543583, 10.400000, 0.382317>, <-2.648405, 10.400000, 0.382681>, <-2.452421, 10.362460, 0.277719>, <-2.455262, 10.362460, 0.305617>, 
			<-2.461812, 10.362460, 0.325924>, <-2.472197, 10.362460, 0.344563>, <-2.486019, 10.362460, 0.360819>, <-2.502746, 10.362460, 0.374065>, <-2.521737, 10.362460, 0.383793>, <-2.542261, 10.362460, 0.389630>, <-2.648353, 10.362460, 0.390133>, <-2.431219, 10.330635, 0.278608>, <-2.434581, 10.330635, 0.310107>, <-2.442404, 10.330635, 0.334362>, <-2.454809, 10.330635, 0.356626>, 
			<-2.471318, 10.330635, 0.376042>, <-2.491298, 10.330635, 0.391863>, <-2.513981, 10.330635, 0.403483>, <-2.538495, 10.330635, 0.410455>, <-2.648205, 10.330635, 0.411352>, <-2.399489, 10.309370, 0.279938>, <-2.403631, 10.309370, 0.316827>, <-2.413359, 10.309370, 0.346992>, <-2.428785, 10.309370, 0.374679>, <-2.449317, 10.309370, 0.398825>, <-2.474164, 10.309370, 0.418501>, 
			<-2.502373, 10.309370, 0.432952>, <-2.532859, 10.309370, 0.441621>, <-2.647983, 10.309370, 0.443109>, <-2.362061, 10.301903, 0.281507>, <-2.367121, 10.301903, 0.324754>, <-2.379098, 10.301903, 0.361889>, <-2.398089, 10.301903, 0.395974>, <-2.423364, 10.301903, 0.425699>, <-2.453954, 10.301903, 0.449922>, <-2.488681, 10.301903, 0.467712>, <-2.526211, 10.301903, 0.478385>, 
			<-2.647721, 10.301903, 0.480569>, <-2.324633, 10.309370, 0.283076>, <-2.330612, 10.309370, 0.332681>, <-2.344837, 10.309370, 0.376786>, <-2.367392, 10.309370, 0.417269>, <-2.397412, 10.309370, 0.452573>, <-2.433743, 10.309370, 0.481343>, <-2.474988, 10.309370, 0.502472>, <-2.519563, 10.309370, 0.515148>, <-2.647459, 10.309370, 0.518030>, <-2.292903, 10.330635, 0.284406>, 
			<-2.299661, 10.330635, 0.339401>, <-2.315791, 10.330635, 0.389415>, <-2.341369, 10.330635, 0.435322>, <-2.375411, 10.330635, 0.475356>, <-2.416609, 10.330635, 0.507980>, <-2.463380, 10.330635, 0.531940>, <-2.513927, 10.330635, 0.546315>, <-2.647237, 10.330635, 0.549787>, <-2.271701, 10.362460, 0.285295>, <-2.278981, 10.362460, 0.343891>, <-2.296384, 10.362460, 0.397854>, 
			<-2.323981, 10.362460, 0.447384>, <-2.360710, 10.362460, 0.490579>, <-2.405161, 10.362460, 0.525779>, <-2.455624, 10.362460, 0.551630>, <-2.510161, 10.362460, 0.567140>, <-2.647089, 10.362460, 0.571006>, <-2.269843, 10.437540, 0.218855>, <-2.262377, 10.400000, 0.218985>, <-2.269843, 10.362460, 0.218855>, <-2.291105, 10.330635, 0.218484>, <-2.322925, 10.309370, 0.217928>, 
			<-2.360459, 10.301903, 0.217273>, <-2.397994, 10.309370, 0.216618>, <-2.429814, 10.330635, 0.216063>, <-2.451075, 10.362460, 0.215691>, <-2.458541, 10.400000, 0.215561>, <-2.451075, 10.437540, 0.215691>, <-2.429814, 10.469365, 0.216063>, <-2.397994, 10.490630, 0.216618>, <-2.360459, 10.498097, 0.217273>, <-2.322925, 10.490630, 0.217928>, <-2.291105, 10.469365, 0.218484>, 
			<-2.272184, 10.436367, 0.190685>, <-2.264952, 10.400000, 0.190811>, <-2.272184, 10.363633, 0.190685>, <-2.292781, 10.332803, 0.190325>, <-2.323607, 10.312202, 0.189787>, <-2.359969, 10.304969, 0.189152>, <-2.396330, 10.312202, 0.188518>, <-2.427156, 10.332803, 0.187980>, <-2.447753, 10.363633, 0.187620>, <-2.454985, 10.400000, 0.187494>, <-2.447753, 10.436367, 0.187620>, 
			<-2.427156, 10.467197, 0.187980>, <-2.396330, 10.487798, 0.188518>, <-2.359969, 10.495031, 0.189152>, <-2.323607, 10.487798, 0.189787>, <-2.292781, 10.467197, 0.190325>, <-2.295055, 10.426870, 0.187160>, <-2.289711, 10.400000, 0.187253>, <-2.295055, 10.373130, 0.187160>, <-2.310273, 10.350352, 0.186894>, <-2.333049, 10.335131, 0.186497>, <-2.359914, 10.329787, 0.186028>, 
			<-2.386779, 10.335131, 0.185559>, <-2.409555, 10.350352, 0.185161>, <-2.424773, 10.373130, 0.184896>, <-2.430117, 10.400000, 0.184802>, <-2.424773, 10.426870, 0.184896>, <-2.409555, 10.449648, 0.185161>, <-2.386779, 10.464869, 0.185559>, <-2.359914, 10.470213, 0.186028>, <-2.333049, 10.464869, 0.186497>, <-2.310273, 10.449648, 0.186894>, <-3.693343, 10.424386, -0.637369>, 
			<-3.198223, 10.424386, -0.628727>, <-3.207736, 10.472222, -0.628893>, <-3.226398, 10.517282, -0.629219>, <-3.253490, 10.557835, -0.629691>, <-3.287973, 10.592322, -0.630293>, <-3.328519, 10.619419, -0.631001>, <-3.373572, 10.638083, -0.631787>, <-3.421401, 10.647598, -0.632622>, <-3.470166, 10.647598, -0.633474>, <-3.517994, 10.638083, -0.634308>, <-3.563047, 10.619419, -0.635095>, 
			<-3.603594, 10.592322, -0.635803>, <-3.638076, 10.557835, -0.636404>, <-3.665168, 10.517282, -0.636877>, <-3.683830, 10.472222, -0.637203>, <-3.693343, 9.575614, -0.637369>, <-3.683830, 9.527778, -0.637203>, <-3.665168, 9.482718, -0.636877>, <-3.638076, 9.442165, -0.636404>, <-3.603594, 9.407678, -0.635803>, <-3.563047, 9.380581, -0.635095>, <-3.517994, 9.361917, -0.634308>, 
			<-3.470166, 9.352402, -0.633474>, <-3.421401, 9.352402, -0.632622>, <-3.373572, 9.361917, -0.631787>, <-3.328519, 9.380581, -0.631001>, <-3.287973, 9.407678, -0.630293>, <-3.253490, 9.442165, -0.629691>, <-3.226398, 9.482718, -0.629219>, <-3.207736, 9.527778, -0.628893>, <-3.198223, 9.575614, -0.628727>, <-3.517918, 9.485649, -0.634307>, <-3.601244, 9.490596, -0.635762>, 
			<-3.506936, 9.459133, -0.634115>, <-3.564768, 9.435997, -0.635125>, <-3.486644, 9.438838, -0.633761>, <-3.510177, 9.399515, -0.634172>, <-3.460132, 9.427855, -0.633298>, <-3.445783, 9.386704, -0.633048>, <-3.431435, 9.427855, -0.632797>, <-3.381389, 9.399515, -0.631924>, <-3.404922, 9.438838, -0.632335>, <-3.326798, 9.435997, -0.630971>, <-3.384630, 9.459133, -0.631980>, 
			<-3.290322, 9.490596, -0.630334>, <-3.370795, 9.600000, -0.631739>, <-3.373649, 9.714351, -0.631789>, <-3.384630, 9.740867, -0.631980>, <-3.404922, 9.761162, -0.632335>, <-3.431435, 9.772145, -0.632797>, <-3.460132, 9.772145, -0.633298>, <-3.486644, 9.761162, -0.633761>, <-3.506936, 9.740867, -0.634115>, <-3.517918, 9.714351, -0.634307>, <-3.507679, 9.677990, -0.634128>, 
			<-3.496933, 9.489835, -0.630815>, <-3.502418, 9.476537, -0.634036>, <-3.489154, 9.471052, -0.630679>, <-3.489130, 9.456647, -0.633805>, <-3.474781, 9.456677, -0.630429>, <-3.469242, 9.443356, -0.633457>, <-3.456001, 9.448897, -0.630101>, <-3.445783, 9.438689, -0.633048>, <-3.435674, 9.448897, -0.629746>, <-3.422324, 9.443356, -0.632638>, <-3.416894, 9.456677, -0.629418>, 
			<-3.402437, 9.456647, -0.632291>, <-3.402521, 9.471052, -0.629167>, <-3.389148, 9.476537, -0.632059>, <-3.392721, 9.600000, -0.628996>, <-3.383887, 9.677990, -0.631968>, <-3.394742, 9.710165, -0.629032>, <-3.389148, 9.723463, -0.632059>, <-3.402521, 9.728948, -0.629167>, <-3.402437, 9.743353, -0.632291>, <-3.416894, 9.743323, -0.629418>, <-3.422324, 9.756644, -0.632638>, 
			<-3.435674, 9.751103, -0.629746>, <-3.445783, 9.761311, -0.633048>, <-3.456001, 9.751103, -0.630101>, <-3.469242, 9.756644, -0.633457>, <-3.474781, 9.743323, -0.630429>, <-3.489130, 9.743353, -0.633805>, <-3.489154, 9.728948, -0.630679>, <-3.502418, 9.723463, -0.634036>, <-3.496933, 9.710165, -0.630815>, <-3.695745, 10.000000, -0.637411>, <-3.195821, 10.000000, -0.628685>, 
			<-3.176616, 9.573480, -0.625224>, <-3.174004, 10.000000, -0.625179>, <-3.186962, 9.521459, -0.625405>, <-3.207256, 9.472456, -0.625759>, <-3.236719, 9.428355, -0.626273>, <-3.274219, 9.390850, -0.626928>, <-3.318313, 9.361382, -0.627697>, <-3.367308, 9.341085, -0.628553>, <-3.419322, 9.330737, -0.629461>, <-3.472354, 9.330737, -0.630386>, <-3.524367, 9.341085, -0.631294>, 
			<-3.573362, 9.361382, -0.632149>, <-3.617457, 9.390850, -0.632919>, <-3.654956, 9.428355, -0.633574>, <-3.684419, 9.472456, -0.634088>, <-3.704713, 9.521459, -0.634442>, <-3.715060, 9.573480, -0.634623>, <-3.717671, 10.000000, -0.634668>, <-3.704713, 10.478541, -0.634442>, <-3.684419, 10.527544, -0.634088>, <-3.654956, 10.571645, -0.633574>, <-3.617457, 10.609150, -0.632919>, 
			<-3.573362, 10.638618, -0.632149>, <-3.524367, 10.658915, -0.631294>, <-3.472354, 10.669263, -0.630386>, <-3.419322, 10.669263, -0.629461>, <-3.367308, 10.658915, -0.628553>, <-3.318313, 10.638618, -0.627697>, <-3.274219, 10.609150, -0.626928>, <-3.236719, 10.571645, -0.626273>, <-3.207256, 10.527544, -0.625759>, <-3.186962, 10.478541, -0.625405>, <-3.176616, 10.426520, -0.625224>, 
			<-3.715060, 10.426520, -0.634623>, <-3.171704, 10.306706, -0.615762>, <-3.171704, 9.693294, -0.615762>, <-3.177622, 9.546608, -0.615865>, <-3.193193, 9.495268, -0.616137>, <-3.218480, 9.447952, -0.616578>, <-3.252511, 9.406480, -0.617172>, <-3.293977, 9.372444, -0.617896>, <-3.341285, 9.347154, -0.618722>, <-3.392617, 9.331580, -0.619618>, <-3.446001, 9.326321, -0.620550>, 
			<-3.499385, 9.331580, -0.621482>, <-3.550718, 9.347154, -0.622378>, <-3.598026, 9.372444, -0.623203>, <-3.639492, 9.406480, -0.623927>, <-3.673522, 9.447952, -0.624521>, <-3.698809, 9.495268, -0.624963>, <-3.714381, 9.546608, -0.625234>, <-3.720299, 9.693294, -0.625338>, <-3.714381, 10.453392, -0.625234>, <-3.698809, 10.504732, -0.624963>, <-3.673522, 10.552048, -0.624521>, 
			<-3.639492, 10.593520, -0.623927>, <-3.598026, 10.627556, -0.623203>, <-3.550718, 10.652846, -0.622378>, <-3.499385, 10.668420, -0.621482>, <-3.446001, 10.673679, -0.620550>, <-3.392617, 10.668420, -0.619618>, <-3.341285, 10.652846, -0.618722>, <-3.293977, 10.627556, -0.617896>, <-3.252511, 10.593520, -0.617172>, <-3.218480, 10.552048, -0.616578>, <-3.193193, 10.504732, -0.616137>, 
			<-3.177622, 10.453392, -0.615865>, <-3.720299, 10.306706, -0.625338>, <-3.718536, 10.426825, -0.612805>, <-3.173903, 10.426825, -0.603298>, <-3.184368, 10.479444, -0.603481>, <-3.204896, 10.529010, -0.603839>, <-3.234697, 10.573618, -0.604360>, <-3.272628, 10.611554, -0.605022>, <-3.317229, 10.641361, -0.605800>, <-3.366788, 10.661891, -0.606665>, <-3.419399, 10.672358, -0.607584>, 
			<-3.473040, 10.672358, -0.608520>, <-3.525651, 10.661891, -0.609438>, <-3.575210, 10.641361, -0.610303>, <-3.619811, 10.611554, -0.611082>, <-3.657741, 10.573618, -0.611744>, <-3.687543, 10.529010, -0.612264>, <-3.708071, 10.479444, -0.612622>, <-3.718536, 9.573175, -0.612805>, <-3.708071, 9.520556, -0.612622>, <-3.687543, 9.470990, -0.612264>, <-3.657741, 9.426382, -0.611744>, 
			<-3.619811, 9.388446, -0.611082>, <-3.575210, 9.358639, -0.610303>, <-3.525651, 9.338109, -0.609438>, <-3.473040, 9.327642, -0.608520>, <-3.419399, 9.327642, -0.607584>, <-3.366788, 9.338109, -0.606665>, <-3.317229, 9.358639, -0.605800>, <-3.272628, 9.388446, -0.605022>, <-3.234697, 9.426382, -0.604360>, <-3.204896, 9.470990, -0.603839>, <-3.184368, 9.520556, -0.603481>, 
			<-3.173903, 9.573175, -0.603298>, <-3.171261, 10.000000, -0.603252>, <-3.721177, 10.000000, -0.612851>, <-3.189603, 9.549035, -0.628576>, <-3.183954, 9.693599, -0.628478>, <-3.183954, 10.306401, -0.628478>, <-3.189603, 10.450965, -0.628576>, <-3.204467, 10.499972, -0.628836>, <-3.228604, 10.545137, -0.629257>, <-3.261087, 10.584724, -0.629824>, <-3.300669, 10.617212, -0.630515>, 
			<-3.345826, 10.641353, -0.631303>, <-3.394826, 10.656219, -0.632158>, <-3.445783, 10.661239, -0.633048>, <-3.496741, 10.656219, -0.633937>, <-3.545740, 10.641353, -0.634793>, <-3.590898, 10.617212, -0.635581>, <-3.630479, 10.584724, -0.636272>, <-3.662962, 10.545137, -0.636839>, <-3.687100, 10.499972, -0.637260>, <-3.701963, 10.450965, -0.637520>, <-3.707613, 10.306401, -0.637618>, 
			<-3.707613, 9.693599, -0.637618>, <-3.701963, 9.549035, -0.637520>, <-3.687100, 9.500028, -0.637260>, <-3.662962, 9.454863, -0.636839>, <-3.630479, 9.415276, -0.636272>, <-3.590898, 9.382788, -0.635581>, <-3.545740, 9.358647, -0.634793>, <-3.496741, 9.343781, -0.633937>, <-3.445783, 9.338761, -0.633048>, <-3.394826, 9.343781, -0.632158>, <-3.345826, 9.358647, -0.631303>, 
			<-3.300669, 9.382788, -0.630515>, <-3.261087, 9.415276, -0.629824>, <-3.228604, 9.454863, -0.629257>, <-3.204467, 9.500028, -0.628836>, <-3.394743, 9.489835, -0.629032>, <-3.498955, 9.600000, -0.630851>, <-3.373649, 9.485649, -0.631789>, <-3.520772, 9.600000, -0.634357>, <-3.507679, 9.522010, -0.634128>, <-3.383888, 9.522010, -0.631968>, <-3.396227, 9.600000, -0.607179>, 
			<-3.396485, 9.522608, -0.619686>, <-3.398130, 9.709567, -0.607212>, <-3.396485, 9.677392, -0.619686>, <-3.405451, 9.727245, -0.607340>, <-3.400693, 9.718770, -0.619759>, <-3.418979, 9.740775, -0.607576>, <-3.411324, 9.734683, -0.619945>, <-3.436654, 9.748097, -0.607885>, <-3.427234, 9.745315, -0.620222>, <-3.455785, 9.748097, -0.608219>, <-3.446001, 9.749048, -0.620550>, 
			<-3.473460, 9.740775, -0.608527>, <-3.464768, 9.745315, -0.620877>, <-3.486988, 9.727245, -0.608763>, <-3.480678, 9.734683, -0.621155>, <-3.494309, 9.709567, -0.608891>, <-3.491309, 9.718770, -0.621341>, <-3.496212, 9.600000, -0.608924>, <-3.495518, 9.677392, -0.621414>, <-3.494309, 9.490433, -0.608891>, <-3.495518, 9.522608, -0.621414>, <-3.486988, 9.472755, -0.608763>, 
			<-3.491309, 9.481230, -0.621341>, <-3.473460, 9.459225, -0.608527>, <-3.480678, 9.465317, -0.621155>, <-3.455785, 9.451903, -0.608219>, <-3.464768, 9.454685, -0.620877>, <-3.436654, 9.451903, -0.607885>, <-3.446001, 9.450952, -0.620550>, <-3.418979, 9.459225, -0.607576>, <-3.427234, 9.454685, -0.620222>, <-3.405451, 9.472755, -0.607340>, <-3.411324, 9.465317, -0.619945>, 
			<-3.398130, 9.490433, -0.607212>, <-3.400693, 9.481230, -0.619759>, <-3.695089, 10.424386, -0.537384>, <-3.199968, 10.424386, -0.528742>, <-3.209482, 10.472222, -0.528908>, <-3.228143, 10.517282, -0.529234>, <-3.255236, 10.557835, -0.529707>, <-3.289718, 10.592322, -0.530309>, <-3.330265, 10.619419, -0.531016>, <-3.375318, 10.638083, -0.531803>, <-3.423146, 10.647598, -0.532638>, 
			<-3.471911, 10.647598, -0.533489>, <-3.519739, 10.638083, -0.534324>, <-3.564792, 10.619419, -0.535110>, <-3.605339, 10.592322, -0.535818>, <-3.639821, 10.557835, -0.536420>, <-3.666913, 10.517282, -0.536893>, <-3.685575, 10.472222, -0.537218>, <-3.695089, 9.575614, -0.537384>, <-3.685575, 9.527778, -0.537218>, <-3.666913, 9.482718, -0.536893>, <-3.639821, 9.442165, -0.536420>, 
			<-3.605339, 9.407678, -0.535818>, <-3.564792, 9.380581, -0.535110>, <-3.519739, 9.361917, -0.534324>, <-3.471911, 9.352402, -0.533489>, <-3.423146, 9.352402, -0.532638>, <-3.375318, 9.361917, -0.531803>, <-3.330265, 9.380581, -0.531016>, <-3.289718, 9.407678, -0.530309>, <-3.255236, 9.442165, -0.529707>, <-3.228143, 9.482718, -0.529234>, <-3.209482, 9.527778, -0.528908>, 
			<-3.199968, 9.575614, -0.528742>, <-3.697490, 10.000000, -0.537426>, <-3.197566, 10.000000, -0.528700>, <-3.178252, 9.573480, -0.531488>, <-3.175640, 10.000000, -0.531443>, <-3.188598, 9.521459, -0.531669>, <-3.208892, 9.472456, -0.532023>, <-3.238355, 9.428355, -0.532538>, <-3.275855, 9.390850, -0.533192>, <-3.319949, 9.361382, -0.533962>, <-3.368945, 9.341085, -0.534817>, 
			<-3.420958, 9.330737, -0.535725>, <-3.473990, 9.330737, -0.536651>, <-3.526003, 9.341085, -0.537558>, <-3.574998, 9.361382, -0.538414>, <-3.619093, 9.390850, -0.539183>, <-3.656592, 9.428355, -0.539838>, <-3.686055, 9.472456, -0.540352>, <-3.706350, 9.521459, -0.540706>, <-3.716696, 9.573480, -0.540887>, <-3.719307, 10.000000, -0.540933>, <-3.706350, 10.478541, -0.540706>, 
			<-3.686055, 10.527544, -0.540352>, <-3.656592, 10.571645, -0.539838>, <-3.619093, 10.609150, -0.539183>, <-3.574998, 10.638618, -0.538414>, <-3.526003, 10.658915, -0.537558>, <-3.473990, 10.669263, -0.536651>, <-3.420958, 10.669263, -0.535725>, <-3.368945, 10.658915, -0.534817>, <-3.319949, 10.638618, -0.533962>, <-3.275855, 10.609150, -0.533192>, <-3.238355, 10.571645, -0.532538>, 
			<-3.208892, 10.527544, -0.532023>, <-3.188598, 10.478541, -0.531669>, <-3.178252, 10.426520, -0.531488>, <-3.716696, 10.426520, -0.540887>, <-3.173013, 10.306706, -0.540773>, <-3.173013, 9.693294, -0.540773>, <-3.178931, 9.546608, -0.540877>, <-3.194502, 9.495268, -0.541148>, <-3.219789, 9.447952, -0.541590>, <-3.253819, 9.406480, -0.542184>, <-3.295285, 9.372444, -0.542908>, 
			<-3.342594, 9.347154, -0.543733>, <-3.393926, 9.331580, -0.544629>, <-3.447310, 9.326321, -0.545561>, <-3.500694, 9.331580, -0.546493>, <-3.552027, 9.347154, -0.547389>, <-3.599335, 9.372444, -0.548215>, <-3.640801, 9.406480, -0.548939>, <-3.674831, 9.447952, -0.549533>, <-3.700118, 9.495268, -0.549974>, <-3.715690, 9.546608, -0.550246>, <-3.721608, 9.693294, -0.550349>, 
			<-3.715690, 10.453392, -0.550246>, <-3.700118, 10.504732, -0.549974>, <-3.674831, 10.552048, -0.549533>, <-3.640801, 10.593520, -0.548939>, <-3.599335, 10.627556, -0.548215>, <-3.552027, 10.652846, -0.547389>, <-3.500694, 10.668420, -0.546493>, <-3.447310, 10.673679, -0.545561>, <-3.393926, 10.668420, -0.544629>, <-3.342594, 10.652846, -0.543733>, <-3.295285, 10.627556, -0.542908>, 
			<-3.253819, 10.593520, -0.542184>, <-3.219789, 10.552048, -0.541590>, <-3.194502, 10.504732, -0.541148>, <-3.178931, 10.453392, -0.540877>, <-3.721608, 10.306706, -0.550349>, <-3.719408, 10.426825, -0.562813>, <-3.174776, 10.426825, -0.553306>, <-3.185241, 10.479444, -0.553489>, <-3.205768, 10.529010, -0.553847>, <-3.235570, 10.573618, -0.554367>, <-3.273500, 10.611554, -0.555029>, 
			<-3.318102, 10.641361, -0.555808>, <-3.367660, 10.661891, -0.556673>, <-3.420271, 10.672358, -0.557591>, <-3.473913, 10.672358, -0.558528>, <-3.526524, 10.661891, -0.559446>, <-3.576082, 10.641361, -0.560311>, <-3.620684, 10.611554, -0.561089>, <-3.658614, 10.573618, -0.561751>, <-3.688416, 10.529010, -0.562272>, <-3.708943, 10.479444, -0.562630>, <-3.719408, 9.573175, -0.562813>, 
			<-3.708943, 9.520556, -0.562630>, <-3.688416, 9.470990, -0.562272>, <-3.658614, 9.426382, -0.561751>, <-3.620684, 9.388446, -0.561089>, <-3.576082, 9.358639, -0.560311>, <-3.526524, 9.338109, -0.559446>, <-3.473913, 9.327642, -0.558528>, <-3.420271, 9.327642, -0.557591>, <-3.367660, 9.338109, -0.556673>, <-3.318102, 9.358639, -0.555808>, <-3.273500, 9.388446, -0.555029>, 
			<-3.235570, 9.426382, -0.554367>, <-3.205768, 9.470990, -0.553847>, <-3.185241, 9.520556, -0.553489>, <-3.174776, 9.573175, -0.553306>, <-3.172134, 10.000000, -0.553260>, <-3.722050, 10.000000, -0.562859>, <-3.720953, 10.306706, -0.587843>, <-3.178276, 10.453392, -0.578371>, <-3.193848, 10.504732, -0.578643>, <-3.219135, 10.552048, -0.579084>, <-3.253165, 10.593520, -0.579678>, 
			<-3.294631, 10.627556, -0.580402>, <-3.341939, 10.652846, -0.581228>, <-3.393272, 10.668420, -0.582124>, <-3.446656, 10.673679, -0.583056>, <-3.500040, 10.668420, -0.583987>, <-3.551372, 10.652846, -0.584883>, <-3.598680, 10.627556, -0.585709>, <-3.640146, 10.593520, -0.586433>, <-3.674177, 10.552048, -0.587027>, <-3.699464, 10.504732, -0.587468>, <-3.715035, 10.453392, -0.587740>, 
			<-3.720953, 9.693294, -0.587843>, <-3.715035, 9.546608, -0.587740>, <-3.699464, 9.495268, -0.587468>, <-3.674177, 9.447952, -0.587027>, <-3.640146, 9.406480, -0.586433>, <-3.598680, 9.372444, -0.585709>, <-3.551372, 9.347154, -0.584883>, <-3.500040, 9.331580, -0.583987>, <-3.446656, 9.326321, -0.583056>, <-3.393272, 9.331580, -0.582124>, <-3.341939, 9.347154, -0.581228>, 
			<-3.294631, 9.372444, -0.580402>, <-3.253165, 9.406480, -0.579678>, <-3.219135, 9.447952, -0.579084>, <-3.193848, 9.495268, -0.578643>, <-3.178276, 9.546608, -0.578371>, <-3.172358, 9.693294, -0.578268>, <-3.172358, 10.306706, -0.578268>, <-3.191348, 9.549035, -0.528592>, <-3.185699, 9.693599, -0.528493>, <-3.185699, 10.306401, -0.528493>, <-3.191348, 10.450965, -0.528592>, 
			<-3.206212, 10.499972, -0.528851>, <-3.230349, 10.545137, -0.529272>, <-3.262833, 10.584724, -0.529839>, <-3.302414, 10.617212, -0.530530>, <-3.347572, 10.641353, -0.531318>, <-3.396571, 10.656219, -0.532174>, <-3.447528, 10.661239, -0.533063>, <-3.498486, 10.656219, -0.533953>, <-3.547485, 10.641353, -0.534808>, <-3.592643, 10.617212, -0.535596>, <-3.632224, 10.584724, -0.536287>, 
			<-3.664707, 10.545137, -0.536854>, <-3.688845, 10.499972, -0.537275>, <-3.703709, 10.450965, -0.537535>, <-3.709358, 10.306401, -0.537633>, <-3.709358, 9.693599, -0.537633>, <-3.703709, 9.549035, -0.537535>, <-3.688845, 9.500028, -0.537275>, <-3.664707, 9.454863, -0.536854>, <-3.632224, 9.415276, -0.536287>, <-3.592643, 9.382788, -0.535596>, <-3.547485, 9.358647, -0.534808>, 
			<-3.498486, 9.343781, -0.533953>, <-3.447528, 9.338761, -0.533063>, <-3.396571, 9.343781, -0.532174>, <-3.347572, 9.358647, -0.531318>, <-3.302414, 9.382788, -0.530530>, <-3.262833, 9.415276, -0.529839>, <-3.230349, 9.454863, -0.529272>, <-3.206212, 9.500028, -0.528851>, <-3.397139, 9.522608, -0.582191>, <-3.397139, 9.677392, -0.582191>, <-3.401348, 9.718770, -0.582265>, 
			<-3.411978, 9.734683, -0.582450>, <-3.427889, 9.745315, -0.582728>, <-3.446656, 9.749048, -0.583056>, <-3.465423, 9.745315, -0.583383>, <-3.481333, 9.734683, -0.583661>, <-3.491964, 9.718770, -0.583846>, <-3.496172, 9.677392, -0.583920>, <-3.496173, 9.522608, -0.583920>, <-3.491964, 9.481230, -0.583846>, <-3.481333, 9.465317, -0.583661>, <-3.465423, 9.454685, -0.583383>, 
			<-3.446656, 9.450952, -0.583056>, <-3.427889, 9.454685, -0.582728>, <-3.411978, 9.465317, -0.582450>, <-3.401348, 9.481230, -0.582265>, <-3.602990, 9.490596, -0.535777>, <-3.566513, 9.435997, -0.535140>, <-3.511922, 9.399515, -0.534187>, <-3.447528, 9.386704, -0.533063>, <-3.383134, 9.399515, -0.531939>, <-3.328543, 9.435997, -0.530986>, <-3.487860, 9.727245, -0.558771>, 
			<-3.399003, 9.490433, -0.557220>, <-3.437526, 9.748097, -0.557892>, <-3.474333, 9.740775, -0.558535>, <-3.437526, 9.451903, -0.557892>, <-3.406324, 9.472755, -0.557348>, <-3.497085, 9.600000, -0.558932>, <-3.474333, 9.459225, -0.558535>, <-3.419851, 9.459225, -0.557584>, <-3.487860, 9.472755, -0.558771>, <-3.406324, 9.727245, -0.557348>, <-3.397100, 9.600000, -0.557187>, 
			<-3.419851, 9.740775, -0.557584>, <-3.495182, 9.709567, -0.558899>, <-3.456658, 9.748097, -0.558226>, <-3.495182, 9.490433, -0.558899>, <-3.456658, 9.451903, -0.558226>, <-3.399002, 9.709567, -0.557220>, <-3.397794, 9.522608, -0.544697>, <-3.397794, 9.677392, -0.544697>, <-3.402002, 9.718770, -0.544770>, <-3.412633, 9.734683, -0.544956>, <-3.428543, 9.745315, -0.545234>, 
			<-3.447310, 9.749048, -0.545561>, <-3.466077, 9.745315, -0.545889>, <-3.481987, 9.734683, -0.546167>, <-3.492618, 9.718770, -0.546352>, <-3.496827, 9.677392, -0.546426>, <-3.496827, 9.522608, -0.546426>, <-3.492618, 9.481230, -0.546352>, <-3.481987, 9.465317, -0.546167>, <-3.466077, 9.454685, -0.545889>, <-3.447310, 9.450952, -0.545561>, <-3.428543, 9.454685, -0.545234>, 
			<-3.412633, 9.465317, -0.544956>, <-3.402002, 9.481230, -0.544770>, <-3.509424, 9.677990, -0.534144>, <-3.504163, 9.476537, -0.534052>, <-3.490875, 9.456647, -0.533820>, <-3.470987, 9.443356, -0.533473>, <-3.447528, 9.438689, -0.533063>, <-3.424069, 9.443356, -0.532654>, <-3.404182, 9.456647, -0.532307>, <-3.390893, 9.476537, -0.532075>, <-3.385633, 9.677990, -0.531983>, 
			<-3.390893, 9.723463, -0.532075>, <-3.404182, 9.743353, -0.532307>, <-3.424069, 9.756644, -0.532654>, <-3.447528, 9.761311, -0.533063>, <-3.470987, 9.756644, -0.533473>, <-3.490875, 9.743353, -0.533820>, <-3.504163, 9.723463, -0.534052>, <-3.385633, 9.522010, -0.531983>, <-3.509425, 9.522010, -0.534144>, <-3.437310, 9.751103, -0.536010>, <-3.522517, 9.600000, -0.534372>, 
			<-3.500591, 9.600000, -0.537115>, <-3.490790, 9.728948, -0.536944>, <-3.508681, 9.459133, -0.534131>, <-3.519663, 9.485649, -0.534322>, <-3.406667, 9.761162, -0.532350>, <-3.418531, 9.743323, -0.535682>, <-3.404157, 9.728948, -0.535432>, <-3.372540, 9.600000, -0.531754>, <-3.457637, 9.751103, -0.536365>, <-3.498569, 9.710165, -0.537080>, <-3.386376, 9.459133, -0.531996>, 
			<-3.396379, 9.489835, -0.535296>, <-3.508681, 9.740867, -0.534131>, <-3.488389, 9.438838, -0.533776>, <-3.519663, 9.714351, -0.534322>, <-3.433180, 9.427855, -0.532813>, <-3.418531, 9.456677, -0.535682>, <-3.488389, 9.761162, -0.533776>, <-3.498569, 9.489835, -0.537080>, <-3.476417, 9.743323, -0.536693>, <-3.437310, 9.448897, -0.536010>, <-3.386376, 9.740867, -0.531996>, 
			<-3.461877, 9.427855, -0.533314>, <-3.404157, 9.471052, -0.535432>, <-3.490790, 9.471052, -0.536944>, <-3.406667, 9.438838, -0.532350>, <-3.375394, 9.485649, -0.531804>, <-3.461877, 9.772145, -0.533314>, <-3.457637, 9.448897, -0.536365>, <-3.433180, 9.772145, -0.532813>, <-3.375394, 9.714351, -0.531804>, <-3.394357, 9.600000, -0.535261>, <-3.396379, 9.710165, -0.535296>, 
			<-3.476417, 9.456677, -0.536693>, <-3.612901, 9.606343, -0.535950>, <-3.282156, 9.606343, -0.530177>, <-3.292067, 9.490596, -0.530350>, <-3.611156, 9.606343, -0.635935>, <-3.280411, 9.606343, -0.630161>, <-3.445783, 10.253296, -0.633048>, <-3.381389, 10.240485, -0.631924>, <-3.326798, 10.204003, -0.630971>, <-3.290322, 10.149404, -0.630334>, <-3.280410, 10.013657, -0.630161>, 
			<-3.611156, 10.013657, -0.635935>, <-3.601244, 10.149404, -0.635762>, <-3.564768, 10.204003, -0.635125>, <-3.510177, 10.240485, -0.634172>, <-3.447528, 10.253296, -0.533063>, <-3.511922, 10.240485, -0.534187>, <-3.566513, 10.204003, -0.535140>, <-3.602990, 10.149404, -0.535777>, <-3.292067, 10.149404, -0.530350>, <-3.328543, 10.204003, -0.530986>, <-3.383134, 10.240485, -0.531939>, 
			<-3.612901, 10.013657, -0.535950>, <-3.282156, 10.013657, -0.530177>, <-3.702070, 10.424386, -0.137445>, <-3.206949, 10.424386, -0.128803>, <-3.216463, 10.472222, -0.128969>, <-3.235124, 10.517282, -0.129295>, <-3.262217, 10.557835, -0.129768>, <-3.296699, 10.592322, -0.130369>, <-3.337245, 10.619419, -0.131077>, <-3.382299, 10.638083, -0.131864>, <-3.430127, 10.647598, -0.132698>, 
			<-3.478892, 10.647598, -0.133550>, <-3.526720, 10.638083, -0.134385>, <-3.571773, 10.619419, -0.135171>, <-3.612320, 10.592322, -0.135879>, <-3.646802, 10.557835, -0.136481>, <-3.673894, 10.517282, -0.136953>, <-3.692556, 10.472222, -0.137279>, <-3.702070, 9.575614, -0.137445>, <-3.692556, 9.527778, -0.137279>, <-3.673894, 9.482718, -0.136953>, <-3.646802, 9.442165, -0.136481>, 
			<-3.612320, 9.407678, -0.135879>, <-3.571773, 9.380581, -0.135171>, <-3.526720, 9.361917, -0.134385>, <-3.478892, 9.352402, -0.133550>, <-3.430127, 9.352402, -0.132698>, <-3.382299, 9.361917, -0.131864>, <-3.337245, 9.380581, -0.131077>, <-3.296699, 9.407678, -0.130369>, <-3.262217, 9.442165, -0.129768>, <-3.235124, 9.482718, -0.129295>, <-3.216463, 9.527778, -0.128969>, 
			<-3.206949, 9.575614, -0.128803>, <-3.526644, 9.485649, -0.134383>, <-3.609971, 9.490596, -0.135838>, <-3.515662, 9.459133, -0.134191>, <-3.573494, 9.435997, -0.135201>, <-3.495370, 9.438838, -0.133837>, <-3.518903, 9.399515, -0.134248>, <-3.468858, 9.427855, -0.133375>, <-3.454509, 9.386704, -0.133124>, <-3.440161, 9.427855, -0.132874>, <-3.390115, 9.399515, -0.132000>, 
			<-3.413648, 9.438838, -0.132411>, <-3.335524, 9.435997, -0.131047>, <-3.393357, 9.459133, -0.132057>, <-3.299048, 9.490596, -0.130410>, <-3.379521, 9.600000, -0.131815>, <-3.382375, 9.714351, -0.131865>, <-3.393357, 9.740867, -0.132057>, <-3.413648, 9.761162, -0.132411>, <-3.440161, 9.772145, -0.132874>, <-3.468858, 9.772145, -0.133375>, <-3.495370, 9.761162, -0.133837>, 
			<-3.515662, 9.740867, -0.134191>, <-3.526644, 9.714351, -0.134383>, <-3.516405, 9.677990, -0.134204>, <-3.505659, 9.489835, -0.130891>, <-3.511144, 9.476537, -0.134113>, <-3.497880, 9.471052, -0.130756>, <-3.497856, 9.456647, -0.133881>, <-3.483507, 9.456677, -0.130505>, <-3.477968, 9.443356, -0.133534>, <-3.464727, 9.448897, -0.130177>, <-3.454509, 9.438689, -0.133124>, 
			<-3.444400, 9.448897, -0.129822>, <-3.431050, 9.443356, -0.132715>, <-3.425621, 9.456677, -0.129494>, <-3.411163, 9.456647, -0.132367>, <-3.411247, 9.471052, -0.129243>, <-3.397874, 9.476537, -0.132136>, <-3.401447, 9.600000, -0.129072>, <-3.392613, 9.677990, -0.132044>, <-3.403469, 9.710165, -0.129108>, <-3.397874, 9.723463, -0.132136>, <-3.411247, 9.728948, -0.129243>, 
			<-3.411163, 9.743353, -0.132367>, <-3.425621, 9.743323, -0.129494>, <-3.431050, 9.756644, -0.132715>, <-3.444400, 9.751103, -0.129822>, <-3.454509, 9.761311, -0.133124>, <-3.464727, 9.751103, -0.130177>, <-3.477968, 9.756644, -0.133534>, <-3.483507, 9.743323, -0.130505>, <-3.497856, 9.743353, -0.133881>, <-3.497880, 9.728948, -0.130756>, <-3.511144, 9.723463, -0.134113>, 
			<-3.505659, 9.710165, -0.130891>, <-3.704471, 10.000000, -0.137487>, <-3.204547, 10.000000, -0.128761>, <-3.185342, 9.573480, -0.125300>, <-3.182730, 10.000000, -0.125255>, <-3.195688, 9.521459, -0.125481>, <-3.215982, 9.472456, -0.125835>, <-3.245446, 9.428355, -0.126349>, <-3.282945, 9.390850, -0.127004>, <-3.327039, 9.361382, -0.127774>, <-3.376035, 9.341085, -0.128629>, 
			<-3.428048, 9.330737, -0.129537>, <-3.481080, 9.330737, -0.130462>, <-3.533093, 9.341085, -0.131370>, <-3.582088, 9.361382, -0.132225>, <-3.626183, 9.390850, -0.132995>, <-3.663682, 9.428355, -0.133650>, <-3.693145, 9.472456, -0.134164>, <-3.713440, 9.521459, -0.134518>, <-3.723786, 9.573480, -0.134699>, <-3.726397, 10.000000, -0.134744>, <-3.713440, 10.478541, -0.134518>, 
			<-3.693145, 10.527544, -0.134164>, <-3.663682, 10.571645, -0.133650>, <-3.626183, 10.609150, -0.132995>, <-3.582088, 10.638618, -0.132225>, <-3.533093, 10.658915, -0.131370>, <-3.481080, 10.669263, -0.130462>, <-3.428048, 10.669263, -0.129537>, <-3.376035, 10.658915, -0.128629>, <-3.327039, 10.638618, -0.127774>, <-3.282945, 10.609150, -0.127004>, <-3.245446, 10.571645, -0.126349>, 
			<-3.215982, 10.527544, -0.125835>, <-3.195688, 10.478541, -0.125481>, <-3.185342, 10.426520, -0.125300>, <-3.723786, 10.426520, -0.134699>, <-3.180430, 10.306706, -0.115838>, <-3.180430, 9.693294, -0.115838>, <-3.186348, 9.546608, -0.115941>, <-3.201920, 9.495268, -0.116213>, <-3.227206, 9.447952, -0.116655>, <-3.261237, 9.406480, -0.117249>, <-3.302703, 9.372444, -0.117972>, 
			<-3.350011, 9.347154, -0.118798>, <-3.401343, 9.331580, -0.119694>, <-3.454727, 9.326321, -0.120626>, <-3.508111, 9.331580, -0.121558>, <-3.559444, 9.347154, -0.122454>, <-3.606752, 9.372444, -0.123280>, <-3.648218, 9.406480, -0.124003>, <-3.682248, 9.447952, -0.124597>, <-3.707535, 9.495268, -0.125039>, <-3.723107, 9.546608, -0.125311>, <-3.729025, 9.693294, -0.125414>, 
			<-3.723107, 10.453392, -0.125311>, <-3.707535, 10.504732, -0.125039>, <-3.682248, 10.552048, -0.124597>, <-3.648218, 10.593520, -0.124003>, <-3.606752, 10.627556, -0.123280>, <-3.559444, 10.652846, -0.122454>, <-3.508111, 10.668420, -0.121558>, <-3.454727, 10.673679, -0.120626>, <-3.401343, 10.668420, -0.119694>, <-3.350011, 10.652846, -0.118798>, <-3.302703, 10.627556, -0.117972>, 
			<-3.261237, 10.593520, -0.117249>, <-3.227206, 10.552048, -0.116655>, <-3.201920, 10.504732, -0.116213>, <-3.186348, 10.453392, -0.115941>, <-3.729025, 10.306706, -0.125414>, <-3.727262, 10.426825, -0.112881>, <-3.182629, 10.426825, -0.103375>, <-3.193094, 10.479444, -0.103557>, <-3.213622, 10.529010, -0.103916>, <-3.243424, 10.573618, -0.104436>, <-3.281354, 10.611554, -0.105098>, 
			<-3.325955, 10.641361, -0.105876>, <-3.375514, 10.661891, -0.106741>, <-3.428125, 10.672358, -0.107660>, <-3.481766, 10.672358, -0.108596>, <-3.534377, 10.661891, -0.109514>, <-3.583936, 10.641361, -0.110379>, <-3.628537, 10.611554, -0.111158>, <-3.666468, 10.573618, -0.111820>, <-3.696269, 10.529010, -0.112340>, <-3.716797, 10.479444, -0.112699>, <-3.727262, 9.573175, -0.112881>, 
			<-3.716797, 9.520556, -0.112699>, <-3.696269, 9.470990, -0.112340>, <-3.666468, 9.426382, -0.111820>, <-3.628537, 9.388446, -0.111158>, <-3.583936, 9.358639, -0.110379>, <-3.534377, 9.338109, -0.109514>, <-3.481766, 9.327642, -0.108596>, <-3.428125, 9.327642, -0.107660>, <-3.375514, 9.338109, -0.106741>, <-3.325955, 9.358639, -0.105876>, <-3.281354, 9.388446, -0.105098>, 
			<-3.243424, 9.426382, -0.104436>, <-3.213622, 9.470990, -0.103916>, <-3.193094, 9.520556, -0.103557>, <-3.182629, 9.573175, -0.103375>, <-3.179988, 10.000000, -0.103328>, <-3.729904, 10.000000, -0.112927>, <-3.198329, 9.549035, -0.128652>, <-3.192680, 9.693599, -0.128554>, <-3.192680, 10.306401, -0.128554>, <-3.198329, 10.450965, -0.128652>, <-3.213193, 10.499972, -0.128912>, 
			<-3.237330, 10.545137, -0.129333>, <-3.269814, 10.584724, -0.129900>, <-3.309395, 10.617212, -0.130591>, <-3.354553, 10.641353, -0.131379>, <-3.403552, 10.656219, -0.132235>, <-3.454509, 10.661239, -0.133124>, <-3.505467, 10.656219, -0.134014>, <-3.554466, 10.641353, -0.134869>, <-3.599624, 10.617212, -0.135657>, <-3.639205, 10.584724, -0.136348>, <-3.671688, 10.545137, -0.136915>, 
			<-3.695826, 10.499972, -0.137336>, <-3.710690, 10.450965, -0.137596>, <-3.716339, 10.306401, -0.137694>, <-3.716339, 9.693599, -0.137694>, <-3.710690, 9.549035, -0.137596>, <-3.695826, 9.500028, -0.137336>, <-3.671688, 9.454863, -0.136915>, <-3.639205, 9.415276, -0.136348>, <-3.599624, 9.382788, -0.135657>, <-3.554466, 9.358647, -0.134869>, <-3.505467, 9.343781, -0.134014>, 
			<-3.454509, 9.338761, -0.133124>, <-3.403552, 9.343781, -0.132235>, <-3.354553, 9.358647, -0.131379>, <-3.309395, 9.382788, -0.130591>, <-3.269814, 9.415276, -0.129900>, <-3.237330, 9.454863, -0.129333>, <-3.213193, 9.500028, -0.128912>, <-3.403469, 9.489835, -0.129108>, <-3.507681, 9.600000, -0.130927>, <-3.382375, 9.485649, -0.131865>, <-3.529498, 9.600000, -0.134433>, 
			<-3.516405, 9.522010, -0.134204>, <-3.392614, 9.522010, -0.132044>, <-3.404953, 9.600000, -0.107255>, <-3.405211, 9.522608, -0.119762>, <-3.406856, 9.709567, -0.107288>, <-3.405211, 9.677392, -0.119762>, <-3.414177, 9.727245, -0.107416>, <-3.409419, 9.718770, -0.119835>, <-3.427705, 9.740775, -0.107652>, <-3.420050, 9.734683, -0.120021>, <-3.445380, 9.748097, -0.107961>, 
			<-3.435960, 9.745315, -0.120298>, <-3.464511, 9.748097, -0.108295>, <-3.454727, 9.749048, -0.120626>, <-3.482186, 9.740775, -0.108603>, <-3.473495, 9.745315, -0.120954>, <-3.495714, 9.727245, -0.108839>, <-3.489405, 9.734683, -0.121231>, <-3.503035, 9.709567, -0.108967>, <-3.500035, 9.718770, -0.121417>, <-3.504938, 9.600000, -0.109001>, <-3.504244, 9.677392, -0.121490>, 
			<-3.503035, 9.490433, -0.108967>, <-3.504244, 9.522608, -0.121490>, <-3.495714, 9.472755, -0.108839>, <-3.500035, 9.481230, -0.121417>, <-3.482186, 9.459225, -0.108603>, <-3.489405, 9.465317, -0.121231>, <-3.464511, 9.451903, -0.108295>, <-3.473495, 9.454685, -0.120954>, <-3.445380, 9.451903, -0.107961>, <-3.454727, 9.450952, -0.120626>, <-3.427705, 9.459225, -0.107652>, 
			<-3.435960, 9.454685, -0.120298>, <-3.414177, 9.472755, -0.107416>, <-3.420050, 9.465317, -0.120021>, <-3.406856, 9.490433, -0.107288>, <-3.409420, 9.481230, -0.119835>, <-3.703815, 10.424386, -0.037460>, <-3.208694, 10.424386, -0.028818>, <-3.218208, 10.472222, -0.028984>, <-3.236869, 10.517282, -0.029310>, <-3.263962, 10.557835, -0.029783>, <-3.298444, 10.592322, -0.030385>, 
			<-3.338991, 10.619419, -0.031092>, <-3.384044, 10.638083, -0.031879>, <-3.431872, 10.647598, -0.032714>, <-3.480637, 10.647598, -0.033565>, <-3.528465, 10.638083, -0.034400>, <-3.573518, 10.619419, -0.035186>, <-3.614065, 10.592322, -0.035894>, <-3.648547, 10.557835, -0.036496>, <-3.675640, 10.517282, -0.036969>, <-3.694301, 10.472222, -0.037294>, <-3.703815, 9.575614, -0.037460>, 
			<-3.694301, 9.527778, -0.037294>, <-3.675640, 9.482718, -0.036969>, <-3.648547, 9.442165, -0.036496>, <-3.614065, 9.407678, -0.035894>, <-3.573518, 9.380581, -0.035186>, <-3.528465, 9.361917, -0.034400>, <-3.480637, 9.352402, -0.033565>, <-3.431872, 9.352402, -0.032714>, <-3.384044, 9.361917, -0.031879>, <-3.338991, 9.380581, -0.031092>, <-3.298444, 9.407678, -0.030385>, 
			<-3.263962, 9.442165, -0.029783>, <-3.236869, 9.482718, -0.029310>, <-3.218208, 9.527778, -0.028984>, <-3.208694, 9.575614, -0.028818>, <-3.706216, 10.000000, -0.037502>, <-3.206293, 10.000000, -0.028776>, <-3.186978, 9.573480, -0.031565>, <-3.184366, 10.000000, -0.031519>, <-3.197324, 9.521459, -0.031745>, <-3.217619, 9.472456, -0.032099>, <-3.247082, 9.428355, -0.032614>, 
			<-3.284581, 9.390850, -0.033268>, <-3.328676, 9.361382, -0.034038>, <-3.377671, 9.341085, -0.034893>, <-3.429684, 9.330737, -0.035801>, <-3.482716, 9.330737, -0.036727>, <-3.534729, 9.341085, -0.037635>, <-3.583724, 9.361382, -0.038490>, <-3.627819, 9.390850, -0.039259>, <-3.665318, 9.428355, -0.039914>, <-3.694781, 9.472456, -0.040428>, <-3.715076, 9.521459, -0.040783>, 
			<-3.725422, 9.573480, -0.040963>, <-3.728033, 10.000000, -0.041009>, <-3.715076, 10.478541, -0.040783>, <-3.694781, 10.527544, -0.040428>, <-3.665318, 10.571645, -0.039914>, <-3.627819, 10.609150, -0.039259>, <-3.583724, 10.638618, -0.038490>, <-3.534729, 10.658915, -0.037635>, <-3.482716, 10.669263, -0.036727>, <-3.429684, 10.669263, -0.035801>, <-3.377671, 10.658915, -0.034893>, 
			<-3.328676, 10.638618, -0.034038>, <-3.284581, 10.609150, -0.033268>, <-3.247082, 10.571645, -0.032614>, <-3.217619, 10.527544, -0.032099>, <-3.197324, 10.478541, -0.031745>, <-3.186978, 10.426520, -0.031565>, <-3.725422, 10.426520, -0.040963>, <-3.181739, 10.306706, -0.040850>, <-3.181739, 9.693294, -0.040850>, <-3.187657, 9.546608, -0.040953>, <-3.203229, 9.495268, -0.041225>, 
			<-3.228515, 9.447952, -0.041666>, <-3.262546, 9.406480, -0.042260>, <-3.304012, 9.372444, -0.042984>, <-3.351320, 9.347154, -0.043810>, <-3.402652, 9.331580, -0.044706>, <-3.456036, 9.326321, -0.045637>, <-3.509420, 9.331580, -0.046569>, <-3.560753, 9.347154, -0.047465>, <-3.608061, 9.372444, -0.048291>, <-3.649527, 9.406480, -0.049015>, <-3.683557, 9.447952, -0.049609>, 
			<-3.708844, 9.495268, -0.050050>, <-3.724416, 9.546608, -0.050322>, <-3.730334, 9.693294, -0.050425>, <-3.724416, 10.453392, -0.050322>, <-3.708844, 10.504732, -0.050050>, <-3.683557, 10.552048, -0.049609>, <-3.649527, 10.593520, -0.049015>, <-3.608061, 10.627556, -0.048291>, <-3.560753, 10.652846, -0.047465>, <-3.509420, 10.668420, -0.046569>, <-3.456036, 10.673679, -0.045637>, 
			<-3.402652, 10.668420, -0.044706>, <-3.351320, 10.652846, -0.043810>, <-3.304012, 10.627556, -0.042984>, <-3.262546, 10.593520, -0.042260>, <-3.228515, 10.552048, -0.041666>, <-3.203229, 10.504732, -0.041225>, <-3.187657, 10.453392, -0.040953>, <-3.730334, 10.306706, -0.050425>, <-3.728135, 10.426825, -0.062889>, <-3.183502, 10.426825, -0.053382>, <-3.193967, 10.479444, -0.053565>, 
			<-3.214495, 10.529010, -0.053923>, <-3.244296, 10.573618, -0.054443>, <-3.282227, 10.611554, -0.055105>, <-3.326828, 10.641361, -0.055884>, <-3.376386, 10.661891, -0.056749>, <-3.428997, 10.672358, -0.057667>, <-3.482639, 10.672358, -0.058604>, <-3.535250, 10.661891, -0.059522>, <-3.584808, 10.641361, -0.060387>, <-3.629410, 10.611554, -0.061166>, <-3.667340, 10.573618, -0.061828>, 
			<-3.697142, 10.529010, -0.062348>, <-3.717670, 10.479444, -0.062706>, <-3.728135, 9.573175, -0.062889>, <-3.717670, 9.520556, -0.062706>, <-3.697142, 9.470990, -0.062348>, <-3.667340, 9.426382, -0.061828>, <-3.629410, 9.388446, -0.061166>, <-3.584808, 9.358639, -0.060387>, <-3.535250, 9.338109, -0.059522>, <-3.482639, 9.327642, -0.058604>, <-3.428997, 9.327642, -0.057667>, 
			<-3.376386, 9.338109, -0.056749>, <-3.326828, 9.358639, -0.055884>, <-3.282227, 9.388446, -0.055105>, <-3.244296, 9.426382, -0.054443>, <-3.214495, 9.470990, -0.053923>, <-3.193967, 9.520556, -0.053565>, <-3.183502, 9.573175, -0.053382>, <-3.180860, 10.000000, -0.053336>, <-3.730776, 10.000000, -0.062935>, <-3.729680, 10.306706, -0.087920>, <-3.187003, 10.453392, -0.078447>, 
			<-3.202574, 10.504732, -0.078719>, <-3.227861, 10.552048, -0.079160>, <-3.261891, 10.593520, -0.079754>, <-3.303357, 10.627556, -0.080478>, <-3.350665, 10.652846, -0.081304>, <-3.401998, 10.668420, -0.082200>, <-3.455382, 10.673679, -0.083132>, <-3.508766, 10.668420, -0.084064>, <-3.560098, 10.652846, -0.084960>, <-3.607407, 10.627556, -0.085785>, <-3.648873, 10.593520, -0.086509>, 
			<-3.682903, 10.552048, -0.087103>, <-3.708190, 10.504732, -0.087544>, <-3.723761, 10.453392, -0.087816>, <-3.729680, 9.693294, -0.087920>, <-3.723761, 9.546608, -0.087816>, <-3.708190, 9.495268, -0.087544>, <-3.682903, 9.447952, -0.087103>, <-3.648873, 9.406480, -0.086509>, <-3.607407, 9.372444, -0.085785>, <-3.560098, 9.347154, -0.084960>, <-3.508766, 9.331580, -0.084064>, 
			<-3.455382, 9.326321, -0.083132>, <-3.401998, 9.331580, -0.082200>, <-3.350665, 9.347154, -0.081304>, <-3.303357, 9.372444, -0.080478>, <-3.261891, 9.406480, -0.079754>, <-3.227861, 9.447952, -0.079160>, <-3.202574, 9.495268, -0.078719>, <-3.187003, 9.546608, -0.078447>, <-3.181084, 9.693294, -0.078344>, <-3.181084, 10.306706, -0.078344>, <-3.200074, 9.549035, -0.028668>, 
			<-3.194425, 9.693599, -0.028569>, <-3.194425, 10.306401, -0.028569>, <-3.200074, 10.450965, -0.028668>, <-3.214938, 10.499972, -0.028927>, <-3.239075, 10.545137, -0.029348>, <-3.271559, 10.584724, -0.029915>, <-3.311140, 10.617212, -0.030606>, <-3.356298, 10.641353, -0.031395>, <-3.405297, 10.656219, -0.032250>, <-3.456255, 10.661239, -0.033139>, <-3.507212, 10.656219, -0.034029>, 
			<-3.556211, 10.641353, -0.034884>, <-3.601369, 10.617212, -0.035672>, <-3.640950, 10.584724, -0.036363>, <-3.673434, 10.545137, -0.036930>, <-3.697571, 10.499972, -0.037351>, <-3.712435, 10.450965, -0.037611>, <-3.718084, 10.306401, -0.037710>, <-3.718084, 9.693599, -0.037710>, <-3.712435, 9.549035, -0.037611>, <-3.697571, 9.500028, -0.037351>, <-3.673434, 9.454863, -0.036930>, 
			<-3.640950, 9.415276, -0.036363>, <-3.601369, 9.382788, -0.035672>, <-3.556211, 9.358647, -0.034884>, <-3.507212, 9.343781, -0.034029>, <-3.456255, 9.338761, -0.033139>, <-3.405297, 9.343781, -0.032250>, <-3.356298, 9.358647, -0.031395>, <-3.311140, 9.382788, -0.030606>, <-3.271559, 9.415276, -0.029915>, <-3.239075, 9.454863, -0.029348>, <-3.214938, 9.500028, -0.028927>, 
			<-3.405866, 9.522608, -0.082267>, <-3.405865, 9.677392, -0.082267>, <-3.410074, 9.718770, -0.082341>, <-3.420705, 9.734683, -0.082526>, <-3.436615, 9.745315, -0.082804>, <-3.455382, 9.749048, -0.083132>, <-3.474149, 9.745315, -0.083459>, <-3.490059, 9.734683, -0.083737>, <-3.500690, 9.718770, -0.083923>, <-3.504899, 9.677392, -0.083996>, <-3.504899, 9.522608, -0.083996>, 
			<-3.500690, 9.481230, -0.083923>, <-3.490059, 9.465317, -0.083737>, <-3.474149, 9.454685, -0.083459>, <-3.455382, 9.450952, -0.083132>, <-3.436615, 9.454685, -0.082804>, <-3.420705, 9.465317, -0.082526>, <-3.410074, 9.481230, -0.082341>, <-3.611716, 9.490596, -0.035853>, <-3.575239, 9.435997, -0.035216>, <-3.520649, 9.399515, -0.034263>, <-3.456255, 9.386704, -0.033139>, 
			<-3.391860, 9.399515, -0.032015>, <-3.337270, 9.435997, -0.031062>, <-3.496587, 9.727245, -0.058847>, <-3.407729, 9.490433, -0.057296>, <-3.446253, 9.748097, -0.057969>, <-3.483059, 9.740775, -0.058611>, <-3.446253, 9.451903, -0.057969>, <-3.415050, 9.472755, -0.057424>, <-3.505811, 9.600000, -0.059008>, <-3.483059, 9.459225, -0.058611>, <-3.428578, 9.459225, -0.057660>, 
			<-3.496587, 9.472755, -0.058847>, <-3.415050, 9.727245, -0.057424>, <-3.405826, 9.600000, -0.057263>, <-3.428578, 9.740775, -0.057660>, <-3.503908, 9.709567, -0.058975>, <-3.465384, 9.748097, -0.058302>, <-3.503908, 9.490433, -0.058975>, <-3.465384, 9.451903, -0.058302>, <-3.407729, 9.709567, -0.057296>, <-3.406520, 9.522608, -0.044773>, <-3.406520, 9.677392, -0.044773>, 
			<-3.410728, 9.718770, -0.044847>, <-3.421359, 9.734683, -0.045032>, <-3.437269, 9.745315, -0.045310>, <-3.456036, 9.749048, -0.045637>, <-3.474804, 9.745315, -0.045965>, <-3.490714, 9.734683, -0.046243>, <-3.501344, 9.718770, -0.046428>, <-3.505553, 9.677392, -0.046502>, <-3.505553, 9.522608, -0.046502>, <-3.501344, 9.481230, -0.046428>, <-3.490714, 9.465317, -0.046243>, 
			<-3.474804, 9.454685, -0.045965>, <-3.456036, 9.450952, -0.045637>, <-3.437269, 9.454685, -0.045310>, <-3.421359, 9.465317, -0.045032>, <-3.410728, 9.481230, -0.044847>, <-3.518150, 9.677990, -0.034220>, <-3.512890, 9.476537, -0.034128>, <-3.499601, 9.456647, -0.033896>, <-3.479713, 9.443356, -0.033549>, <-3.456255, 9.438689, -0.033139>, <-3.432796, 9.443356, -0.032730>, 
			<-3.412908, 9.456647, -0.032383>, <-3.399620, 9.476537, -0.032151>, <-3.394359, 9.677990, -0.032059>, <-3.399620, 9.723463, -0.032151>, <-3.412908, 9.743353, -0.032383>, <-3.432796, 9.756644, -0.032730>, <-3.456255, 9.761311, -0.033139>, <-3.479713, 9.756644, -0.033549>, <-3.499601, 9.743353, -0.033896>, <-3.512889, 9.723463, -0.034128>, <-3.394359, 9.522010, -0.032059>, 
			<-3.518151, 9.522010, -0.034220>, <-3.446037, 9.751103, -0.036086>, <-3.531243, 9.600000, -0.034448>, <-3.509317, 9.600000, -0.037191>, <-3.499516, 9.728948, -0.037020>, <-3.517407, 9.459133, -0.034207>, <-3.528389, 9.485649, -0.034398>, <-3.415394, 9.761162, -0.032426>, <-3.427257, 9.743323, -0.035759>, <-3.412884, 9.728948, -0.035508>, <-3.381266, 9.600000, -0.031830>, 
			<-3.466363, 9.751103, -0.036441>, <-3.507295, 9.710165, -0.037156>, <-3.395102, 9.459133, -0.032072>, <-3.405105, 9.489835, -0.035372>, <-3.517407, 9.740867, -0.034207>, <-3.497115, 9.438838, -0.033853>, <-3.528389, 9.714351, -0.034398>, <-3.441906, 9.427855, -0.032889>, <-3.427257, 9.456677, -0.035759>, <-3.497115, 9.761162, -0.033853>, <-3.507295, 9.489835, -0.037156>, 
			<-3.485143, 9.743323, -0.036769>, <-3.446037, 9.448897, -0.036086>, <-3.395102, 9.740867, -0.032072>, <-3.470603, 9.427855, -0.033390>, <-3.412884, 9.471052, -0.035508>, <-3.499516, 9.471052, -0.037020>, <-3.415394, 9.438838, -0.032426>, <-3.384120, 9.485649, -0.031880>, <-3.470603, 9.772145, -0.033390>, <-3.466363, 9.448897, -0.036441>, <-3.441906, 9.772145, -0.032889>, 
			<-3.384120, 9.714351, -0.031880>, <-3.403083, 9.600000, -0.035337>, <-3.405105, 9.710165, -0.035372>, <-3.485143, 9.456677, -0.036769>, <-3.621627, 9.606343, -0.036026>, <-3.290882, 9.606343, -0.030253>, <-3.300793, 9.490596, -0.030426>, <-3.619882, 9.606343, -0.136011>, <-3.289137, 9.606343, -0.130237>, <-3.454509, 10.253296, -0.133124>, <-3.390115, 10.240485, -0.132000>, 
			<-3.335524, 10.204003, -0.131047>, <-3.299048, 10.149404, -0.130410>, <-3.289137, 10.013657, -0.130237>, <-3.619882, 10.013657, -0.136011>, <-3.609971, 10.149404, -0.135838>, <-3.573494, 10.204003, -0.135201>, <-3.518903, 10.240485, -0.134248>, <-3.456255, 10.253296, -0.033139>, <-3.520649, 10.240485, -0.034263>, <-3.575239, 10.204003, -0.035216>, <-3.611716, 10.149404, -0.035853>, 
			<-3.300793, 10.149404, -0.030426>, <-3.337270, 10.204003, -0.031062>, <-3.391860, 10.240485, -0.032015>, <-3.621627, 10.013657, -0.036026>, <-3.290882, 10.013657, -0.030253>, <-3.535260, 10.400000, -0.963738>, <-3.538509, 10.419134, -0.791913>, <-3.538509, 10.380866, -0.791913>, <-3.264500, 10.400000, -1.225207>, <-3.155158, 10.419134, -1.223548>, <-3.155158, 10.380866, -1.223548>, 
			<-3.321728, 10.400000, -1.214859>, <-3.293032, 10.419134, -1.219579>, <-3.293032, 10.380866, -1.219579>, <-3.375837, 10.400000, -1.193545>, <-3.348613, 10.419134, -1.203772>, <-3.348613, 10.380866, -1.203772>, <-3.424748, 10.400000, -1.162084>, <-3.400043, 10.419134, -1.177426>, <-3.400043, 10.380866, -1.177426>, <-3.466582, 10.400000, -1.121685>, <-3.445344, 10.419134, -1.141552>, 
			<-3.445344, 10.380866, -1.141552>, <-3.499731, 10.400000, -1.073902>, <-3.482777, 10.419134, -1.097530>, <-3.482777, 10.380866, -1.097530>, <-3.522920, 10.400000, -1.020569>, <-3.510902, 10.419134, -1.047051>, <-3.510902, 10.380866, -1.047051>, <-3.528639, 10.419134, -0.992056>, <-3.528639, 10.380866, -0.992056>, <-3.527878, 10.437540, -0.962880>, <-3.523908, 10.454490, -0.791301>, 
			<-3.263901, 10.437540, -1.217800>, <-3.155056, 10.454490, -1.208935>, <-3.319695, 10.437540, -1.207711>, <-3.290438, 10.454490, -1.205237>, <-3.372449, 10.437540, -1.186931>, <-3.343272, 10.454490, -1.190212>, <-3.420135, 10.437540, -1.156258>, <-3.392159, 10.454490, -1.165168>, <-3.460921, 10.437540, -1.116872>, <-3.435220, 10.454490, -1.131069>, <-3.493239, 10.437540, -1.070285>, 
			<-3.470802, 10.454490, -1.089223>, <-3.515848, 10.437540, -1.018289>, <-3.497537, 10.454490, -1.041240>, <-3.514396, 10.454490, -0.988963>, <-3.506857, 10.469365, -0.960439>, <-3.496928, 10.481549, -0.790171>, <-3.262195, 10.469365, -1.196707>, <-3.154867, 10.481549, -1.181933>, <-3.313906, 10.469365, -1.187356>, <-3.285646, 10.481549, -1.178737>, <-3.362800, 10.469365, -1.168096>, 
			<-3.333402, 10.481549, -1.165156>, <-3.406997, 10.469365, -1.139668>, <-3.377590, 10.481549, -1.142519>, <-3.444799, 10.469365, -1.103163>, <-3.416513, 10.481549, -1.111697>, <-3.474753, 10.469365, -1.059985>, <-3.448675, 10.481549, -1.073873>, <-3.495707, 10.469365, -1.011793>, <-3.472840, 10.481549, -1.030502>, <-3.488080, 10.481549, -0.983249>, <-3.475397, 10.490630, -0.956785>, 
			<-3.461678, 10.496194, -0.788693>, <-3.259641, 10.490630, -1.165138>, <-3.154620, 10.496194, -1.146653>, <-3.305243, 10.490630, -1.156892>, <-3.279385, 10.496194, -1.144113>, <-3.348360, 10.490630, -1.139908>, <-3.320506, 10.496194, -1.132419>, <-3.387335, 10.490630, -1.114838>, <-3.358556, 10.496194, -1.112927>, <-3.420671, 10.490630, -1.082646>, <-3.392071, 10.496194, -1.086386>, 
			<-3.447086, 10.490630, -1.044570>, <-3.419765, 10.496194, -1.053818>, <-3.465564, 10.490630, -1.002072>, <-3.440573, 10.496194, -1.016472>, <-3.453695, 10.496194, -0.975784>, <-3.438287, 10.498097, -0.952475>, <-3.423524, 10.496194, -0.787094>, <-3.256628, 10.498097, -1.127901>, <-3.154354, 10.496194, -1.108466>, <-3.295024, 10.498097, -1.120958>, <-3.272609, 10.496194, -1.106636>, 
			<-3.331327, 10.498097, -1.106657>, <-3.306548, 10.496194, -1.096984>, <-3.364143, 10.498097, -1.085550>, <-3.337953, 10.496194, -1.080896>, <-3.392210, 10.498097, -1.058445>, <-3.365616, 10.496194, -1.058991>, <-3.414450, 10.498097, -1.026386>, <-3.388473, 10.496194, -1.032109>, <-3.430008, 10.498097, -0.990604>, <-3.405647, 10.496194, -1.001285>, <-3.416478, 10.496194, -0.967703>, 
			<-3.401177, 10.490630, -0.948165>, <-3.388274, 10.481549, -0.785616>, <-3.253616, 10.490630, -1.090663>, <-3.154107, 10.481549, -1.073186>, <-3.284804, 10.490630, -1.085023>, <-3.266348, 10.481549, -1.072012>, <-3.314293, 10.490630, -1.073407>, <-3.293653, 10.481549, -1.064247>, <-3.340950, 10.490630, -1.056261>, <-3.318919, 10.481549, -1.051304>, <-3.363749, 10.490630, -1.034245>, 
			<-3.341174, 10.481549, -1.033680>, <-3.381814, 10.490630, -1.008203>, <-3.359563, 10.481549, -1.012054>, <-3.394452, 10.490630, -0.979137>, <-3.373380, 10.481549, -0.987255>, <-3.382094, 10.481549, -0.960238>, <-3.369717, 10.469365, -0.944511>, <-3.361295, 10.454490, -0.784485>, <-3.251062, 10.469365, -1.059094>, <-3.153918, 10.454490, -1.046183>, <-3.276141, 10.469365, -1.054559>, 
			<-3.261556, 10.454490, -1.045512>, <-3.299853, 10.469365, -1.045219>, <-3.283783, 10.454490, -1.039191>, <-3.321288, 10.469365, -1.031432>, <-3.304350, 10.454490, -1.028655>, <-3.339620, 10.469365, -1.013728>, <-3.322467, 10.454490, -1.014309>, <-3.354147, 10.469365, -0.992788>, <-3.337436, 10.454490, -0.996704>, <-3.364310, 10.469365, -0.969416>, <-3.348684, 10.454490, -0.976517>, 
			<-3.355777, 10.454490, -0.954524>, <-3.348696, 10.437540, -0.942069>, <-3.346694, 10.419134, -0.783873>, <-3.249356, 10.437540, -1.038001>, <-3.153816, 10.419134, -1.031570>, <-3.270352, 10.437540, -1.034204>, <-3.258962, 10.419134, -1.031170>, <-3.290205, 10.437540, -1.026384>, <-3.278442, 10.419134, -1.025631>, <-3.308150, 10.437540, -1.014841>, <-3.296466, 10.419134, -1.016397>, 
			<-3.323499, 10.437540, -1.000019>, <-3.312343, 10.419134, -1.003825>, <-3.335661, 10.437540, -0.982488>, <-3.325461, 10.419134, -0.988397>, <-3.344169, 10.437540, -0.962920>, <-3.335318, 10.419134, -0.970705>, <-3.341534, 10.419134, -0.951431>, <-3.341314, 10.400000, -0.941212>, <-3.346694, 10.380866, -0.783873>, <-3.248757, 10.400000, -1.030594>, <-3.153816, 10.380866, -1.031570>, 
			<-3.268320, 10.400000, -1.027056>, <-3.258962, 10.380866, -1.031170>, <-3.286816, 10.400000, -1.019770>, <-3.278442, 10.380866, -1.025631>, <-3.303537, 10.400000, -1.009015>, <-3.296466, 10.380866, -1.016397>, <-3.317837, 10.400000, -0.995205>, <-3.312343, 10.380866, -1.003825>, <-3.329169, 10.400000, -0.978871>, <-3.325461, 10.380866, -0.988397>, <-3.337096, 10.400000, -0.960639>, 
			<-3.335318, 10.380866, -0.970705>, <-3.341534, 10.380866, -0.951431>, <-3.348696, 10.362460, -0.942069>, <-3.361295, 10.345510, -0.784485>, <-3.249356, 10.362460, -1.038001>, <-3.153918, 10.345510, -1.046183>, <-3.270352, 10.362460, -1.034204>, <-3.261556, 10.345510, -1.045512>, <-3.290205, 10.362460, -1.026384>, <-3.283783, 10.345510, -1.039191>, <-3.308150, 10.362460, -1.014841>, 
			<-3.304350, 10.345510, -1.028655>, <-3.323499, 10.362460, -1.000019>, <-3.322467, 10.345510, -1.014309>, <-3.335661, 10.362460, -0.982488>, <-3.337436, 10.345510, -0.996704>, <-3.344169, 10.362460, -0.962920>, <-3.348684, 10.345510, -0.976517>, <-3.355777, 10.345510, -0.954524>, <-3.369717, 10.330635, -0.944511>, <-3.388274, 10.318451, -0.785616>, <-3.251062, 10.330635, -1.059094>, 
			<-3.154107, 10.318451, -1.073186>, <-3.276141, 10.330635, -1.054559>, <-3.266348, 10.318451, -1.072012>, <-3.299853, 10.330635, -1.045219>, <-3.293653, 10.318451, -1.064247>, <-3.321288, 10.330635, -1.031432>, <-3.318919, 10.318451, -1.051304>, <-3.339620, 10.330635, -1.013728>, <-3.341174, 10.318451, -1.033680>, <-3.354147, 10.330635, -0.992788>, <-3.359563, 10.318451, -1.012054>, 
			<-3.364310, 10.330635, -0.969416>, <-3.373380, 10.318451, -0.987255>, <-3.382094, 10.318451, -0.960238>, <-3.401177, 10.309370, -0.948165>, <-3.423524, 10.303806, -0.787094>, <-3.253616, 10.309370, -1.090663>, <-3.154354, 10.303806, -1.108466>, <-3.284804, 10.309370, -1.085023>, <-3.272609, 10.303806, -1.106636>, <-3.314293, 10.309370, -1.073407>, <-3.306548, 10.303806, -1.096984>, 
			<-3.340950, 10.309370, -1.056261>, <-3.337953, 10.303806, -1.080896>, <-3.363749, 10.309370, -1.034245>, <-3.365616, 10.303806, -1.058991>, <-3.381814, 10.309370, -1.008203>, <-3.388473, 10.303806, -1.032109>, <-3.394452, 10.309370, -0.979137>, <-3.405647, 10.303806, -1.001285>, <-3.416478, 10.303806, -0.967703>, <-3.438287, 10.301903, -0.952475>, <-3.461678, 10.303806, -0.788693>, 
			<-3.256628, 10.301903, -1.127901>, <-3.154620, 10.303806, -1.146653>, <-3.295024, 10.301903, -1.120958>, <-3.279385, 10.303806, -1.144113>, <-3.331327, 10.301903, -1.106657>, <-3.320506, 10.303806, -1.132419>, <-3.364143, 10.301903, -1.085550>, <-3.358556, 10.303806, -1.112927>, <-3.392210, 10.301903, -1.058445>, <-3.392071, 10.303806, -1.086386>, <-3.414450, 10.301903, -1.026386>, 
			<-3.419765, 10.303806, -1.053818>, <-3.430008, 10.301903, -0.990604>, <-3.440573, 10.303806, -1.016472>, <-3.453695, 10.303806, -0.975784>, <-3.475397, 10.309370, -0.956785>, <-3.496928, 10.318451, -0.790171>, <-3.259641, 10.309370, -1.165138>, <-3.154867, 10.318451, -1.181933>, <-3.305243, 10.309370, -1.156892>, <-3.285646, 10.318451, -1.178737>, <-3.348360, 10.309370, -1.139908>, 
			<-3.333402, 10.318451, -1.165156>, <-3.387335, 10.309370, -1.114838>, <-3.377590, 10.318451, -1.142519>, <-3.420671, 10.309370, -1.082646>, <-3.416513, 10.318451, -1.111697>, <-3.447086, 10.309370, -1.044570>, <-3.448675, 10.318451, -1.073873>, <-3.465564, 10.309370, -1.002072>, <-3.472840, 10.318451, -1.030502>, <-3.488080, 10.318451, -0.983249>, <-3.506857, 10.330635, -0.960439>, 
			<-3.523908, 10.345510, -0.791301>, <-3.262195, 10.330635, -1.196707>, <-3.155056, 10.345510, -1.208935>, <-3.313906, 10.330635, -1.187356>, <-3.290438, 10.345510, -1.205237>, <-3.362800, 10.330635, -1.168096>, <-3.343272, 10.345510, -1.190212>, <-3.406997, 10.330635, -1.139668>, <-3.392159, 10.345510, -1.165168>, <-3.444799, 10.330635, -1.103163>, <-3.435220, 10.345510, -1.131069>, 
			<-3.474753, 10.330635, -1.059985>, <-3.470802, 10.345510, -1.089223>, <-3.495707, 10.330635, -1.011793>, <-3.497537, 10.345510, -1.041240>, <-3.514396, 10.345510, -0.988963>, <-3.527878, 10.362460, -0.962880>, <-3.263901, 10.362460, -1.217800>, <-3.319695, 10.362460, -1.207711>, <-3.372449, 10.362460, -1.186931>, <-3.420135, 10.362460, -1.156258>, <-3.460921, 10.362460, -1.116872>, 
			<-3.493239, 10.362460, -1.070285>, <-3.515848, 10.362460, -1.018289>, <-2.244990, 10.400000, -0.941216>, <-2.245286, 10.419134, -0.909987>, <-2.245286, 10.380866, -0.909987>, <-2.255339, 10.400000, -0.998444>, <-2.250619, 10.419134, -0.969748>, <-2.250619, 10.380866, -0.969748>, <-2.276653, 10.400000, -1.052553>, <-2.266426, 10.419134, -1.025329>, <-2.266426, 10.380866, -1.025329>, 
			<-2.308114, 10.400000, -1.101464>, <-2.292772, 10.419134, -1.076759>, <-2.292772, 10.380866, -1.076759>, <-2.348512, 10.400000, -1.143298>, <-2.328645, 10.419134, -1.122060>, <-2.328645, 10.380866, -1.122060>, <-2.396296, 10.400000, -1.176447>, <-2.372667, 10.419134, -1.159493>, <-2.372667, 10.380866, -1.159493>, <-2.449628, 10.400000, -1.199636>, <-2.423146, 10.419134, -1.187618>, 
			<-2.423146, 10.380866, -1.187618>, <-2.506460, 10.400000, -1.211976>, <-2.478142, 10.419134, -1.205355>, <-2.478142, 10.380866, -1.205355>, <-2.615794, 10.419134, -1.214134>, <-2.615794, 10.380866, -1.214134>, <-2.252397, 10.437540, -0.940617>, <-2.259899, 10.454490, -0.909885>, <-2.262487, 10.437540, -0.996411>, <-2.264961, 10.454490, -0.967154>, <-2.283267, 10.437540, -1.049165>, 
			<-2.279986, 10.454490, -1.019988>, <-2.313940, 10.437540, -1.096851>, <-2.305029, 10.454490, -1.068874>, <-2.353326, 10.437540, -1.137637>, <-2.339129, 10.454490, -1.111936>, <-2.399913, 10.437540, -1.169955>, <-2.380975, 10.454490, -1.147518>, <-2.451909, 10.437540, -1.192564>, <-2.428958, 10.454490, -1.174252>, <-2.507317, 10.437540, -1.204594>, <-2.481234, 10.454490, -1.191112>, 
			<-2.616406, 10.454490, -1.199533>, <-2.273491, 10.469365, -0.938910>, <-2.286902, 10.481549, -0.909696>, <-2.282842, 10.469365, -0.990622>, <-2.291461, 10.481549, -0.962362>, <-2.302102, 10.469365, -1.039516>, <-2.305042, 10.481549, -1.010118>, <-2.330530, 10.469365, -1.083713>, <-2.327678, 10.481549, -1.054306>, <-2.367035, 10.469365, -1.121515>, <-2.358501, 10.481549, -1.093229>, 
			<-2.410213, 10.469365, -1.151469>, <-2.396324, 10.481549, -1.125391>, <-2.458405, 10.469365, -1.172423>, <-2.439696, 10.481549, -1.149556>, <-2.509759, 10.469365, -1.183573>, <-2.486948, 10.481549, -1.164796>, <-2.617537, 10.481549, -1.172553>, <-2.305059, 10.490630, -0.936357>, <-2.322182, 10.496194, -0.909449>, <-2.313306, 10.490630, -0.981959>, <-2.326085, 10.496194, -0.956101>, 
			<-2.330290, 10.490630, -1.025076>, <-2.337779, 10.496194, -0.997222>, <-2.355360, 10.490630, -1.064051>, <-2.357271, 10.496194, -1.035272>, <-2.387551, 10.490630, -1.097387>, <-2.383811, 10.496194, -1.068787>, <-2.425628, 10.490630, -1.123801>, <-2.416380, 10.496194, -1.096481>, <-2.468126, 10.490630, -1.142280>, <-2.453726, 10.496194, -1.117289>, <-2.513413, 10.490630, -1.152113>, 
			<-2.494414, 10.496194, -1.130411>, <-2.619014, 10.496194, -1.137303>, <-2.342297, 10.498097, -0.933344>, <-2.360369, 10.496194, -0.909183>, <-2.349240, 10.498097, -0.971740>, <-2.363561, 10.496194, -0.949324>, <-2.363540, 10.498097, -1.008043>, <-2.373213, 10.496194, -0.983264>, <-2.384648, 10.498097, -1.040858>, <-2.389301, 10.496194, -1.014669>, <-2.411752, 10.498097, -1.068926>, 
			<-2.411207, 10.496194, -1.042332>, <-2.443811, 10.498097, -1.091166>, <-2.438088, 10.496194, -1.065189>, <-2.479593, 10.498097, -1.106724>, <-2.468912, 10.496194, -1.082363>, <-2.517723, 10.498097, -1.115003>, <-2.502495, 10.496194, -1.093194>, <-2.620614, 10.496194, -1.099149>, <-2.379535, 10.490630, -0.930332>, <-2.395649, 10.481549, -0.908936>, <-2.385175, 10.490630, -0.961520>, 
			<-2.398185, 10.481549, -0.943063>, <-2.396791, 10.490630, -0.991009>, <-2.405951, 10.481549, -0.970369>, <-2.413936, 10.490630, -1.017665>, <-2.418894, 10.481549, -0.995634>, <-2.435953, 10.490630, -1.040464>, <-2.436517, 10.481549, -1.017890>, <-2.461995, 10.490630, -1.058530>, <-2.458144, 10.481549, -1.036279>, <-2.491060, 10.490630, -1.071168>, <-2.482942, 10.481549, -1.050096>, 
			<-2.522033, 10.490630, -1.077893>, <-2.509960, 10.481549, -1.058809>, <-2.622091, 10.481549, -1.063899>, <-2.411103, 10.469365, -0.927778>, <-2.422651, 10.454490, -0.908747>, <-2.415638, 10.469365, -0.952857>, <-2.424685, 10.454490, -0.938271>, <-2.424979, 10.469365, -0.976569>, <-2.431007, 10.454490, -0.960499>, <-2.438766, 10.469365, -0.998004>, <-2.441543, 10.454490, -0.981066>, 
			<-2.456470, 10.469365, -1.016336>, <-2.455889, 10.454490, -0.999183>, <-2.477410, 10.469365, -1.030863>, <-2.473494, 10.454490, -1.014152>, <-2.500782, 10.469365, -1.041025>, <-2.493681, 10.454490, -1.025400>, <-2.525687, 10.469365, -1.046433>, <-2.515674, 10.454490, -1.032493>, <-2.623222, 10.454490, -1.036920>, <-2.432197, 10.437540, -0.926072>, <-2.437264, 10.419134, -0.908645>, 
			<-2.435994, 10.437540, -0.947068>, <-2.439027, 10.419134, -0.935678>, <-2.443814, 10.437540, -0.966920>, <-2.444567, 10.419134, -0.955157>, <-2.455356, 10.437540, -0.984866>, <-2.453800, 10.419134, -0.973182>, <-2.470178, 10.437540, -1.000214>, <-2.466373, 10.419134, -0.989058>, <-2.487710, 10.437540, -1.012376>, <-2.481801, 10.419134, -1.002177>, <-2.507277, 10.437540, -1.020885>, 
			<-2.499492, 10.419134, -1.012034>, <-2.528129, 10.437540, -1.025412>, <-2.518766, 10.419134, -1.018250>, <-2.623834, 10.419134, -1.022319>, <-2.439604, 10.400000, -0.925472>, <-2.437264, 10.380866, -0.908645>, <-2.443141, 10.400000, -0.945035>, <-2.439027, 10.380866, -0.935678>, <-2.450427, 10.400000, -0.963532>, <-2.444567, 10.380866, -0.955157>, <-2.461182, 10.400000, -0.980252>, 
			<-2.453800, 10.380866, -0.973182>, <-2.474992, 10.400000, -0.994553>, <-2.466373, 10.380866, -0.989058>, <-2.491327, 10.400000, -1.005885>, <-2.481801, 10.380866, -1.002177>, <-2.509558, 10.400000, -1.013812>, <-2.499492, 10.380866, -1.012034>, <-2.528986, 10.400000, -1.018030>, <-2.518766, 10.380866, -1.018250>, <-2.623834, 10.380866, -1.022319>, <-2.432197, 10.362460, -0.926072>, 
			<-2.422651, 10.345510, -0.908747>, <-2.435994, 10.362460, -0.947068>, <-2.424685, 10.345510, -0.938271>, <-2.443814, 10.362460, -0.966920>, <-2.431007, 10.345510, -0.960499>, <-2.455356, 10.362460, -0.984866>, <-2.441543, 10.345510, -0.981066>, <-2.470178, 10.362460, -1.000214>, <-2.455889, 10.345510, -0.999183>, <-2.487710, 10.362460, -1.012376>, <-2.473494, 10.345510, -1.014152>, 
			<-2.507277, 10.362460, -1.020885>, <-2.493681, 10.345510, -1.025400>, <-2.528129, 10.362460, -1.025412>, <-2.515674, 10.345510, -1.032493>, <-2.623222, 10.345510, -1.036920>, <-2.411103, 10.330635, -0.927778>, <-2.395649, 10.318451, -0.908936>, <-2.415638, 10.330635, -0.952857>, <-2.398185, 10.318451, -0.943063>, <-2.424979, 10.330635, -0.976569>, <-2.405951, 10.318451, -0.970369>, 
			<-2.438766, 10.330635, -0.998004>, <-2.418894, 10.318451, -0.995634>, <-2.456470, 10.330635, -1.016336>, <-2.436517, 10.318451, -1.017890>, <-2.477410, 10.330635, -1.030863>, <-2.458144, 10.318451, -1.036279>, <-2.500782, 10.330635, -1.041025>, <-2.482942, 10.318451, -1.050096>, <-2.525687, 10.330635, -1.046433>, <-2.509960, 10.318451, -1.058809>, <-2.622091, 10.318451, -1.063899>, 
			<-2.379535, 10.309370, -0.930332>, <-2.360369, 10.303806, -0.909183>, <-2.385175, 10.309370, -0.961520>, <-2.363561, 10.303806, -0.949324>, <-2.396791, 10.309370, -0.991009>, <-2.373213, 10.303806, -0.983264>, <-2.413936, 10.309370, -1.017665>, <-2.389301, 10.303806, -1.014669>, <-2.435953, 10.309370, -1.040464>, <-2.411207, 10.303806, -1.042332>, <-2.461995, 10.309370, -1.058530>, 
			<-2.438088, 10.303806, -1.065189>, <-2.491060, 10.309370, -1.071168>, <-2.468912, 10.303806, -1.082363>, <-2.522033, 10.309370, -1.077893>, <-2.502495, 10.303806, -1.093194>, <-2.620614, 10.303806, -1.099149>, <-2.342297, 10.301903, -0.933344>, <-2.322182, 10.303806, -0.909449>, <-2.349240, 10.301903, -0.971740>, <-2.326085, 10.303806, -0.956101>, <-2.363540, 10.301903, -1.008043>, 
			<-2.337779, 10.303806, -0.997222>, <-2.384648, 10.301903, -1.040858>, <-2.357271, 10.303806, -1.035272>, <-2.411752, 10.301903, -1.068926>, <-2.383811, 10.303806, -1.068787>, <-2.443811, 10.301903, -1.091166>, <-2.416380, 10.303806, -1.096481>, <-2.479593, 10.301903, -1.106724>, <-2.453726, 10.303806, -1.117289>, <-2.517723, 10.301903, -1.115003>, <-2.494414, 10.303806, -1.130411>, 
			<-2.619014, 10.303806, -1.137303>, <-2.305059, 10.309370, -0.936357>, <-2.286902, 10.318451, -0.909696>, <-2.313306, 10.309370, -0.981959>, <-2.291461, 10.318451, -0.962362>, <-2.330290, 10.309370, -1.025076>, <-2.305042, 10.318451, -1.010118>, <-2.355360, 10.309370, -1.064051>, <-2.327678, 10.318451, -1.054306>, <-2.387551, 10.309370, -1.097387>, <-2.358501, 10.318451, -1.093229>, 
			<-2.425628, 10.309370, -1.123801>, <-2.396324, 10.318451, -1.125391>, <-2.468126, 10.309370, -1.142280>, <-2.439696, 10.318451, -1.149556>, <-2.513413, 10.309370, -1.152113>, <-2.486948, 10.318451, -1.164796>, <-2.617537, 10.318451, -1.172553>, <-2.273491, 10.330635, -0.938910>, <-2.259899, 10.345510, -0.909885>, <-2.282842, 10.330635, -0.990622>, <-2.264961, 10.345510, -0.967154>, 
			<-2.302102, 10.330635, -1.039516>, <-2.279986, 10.345510, -1.019988>, <-2.330530, 10.330635, -1.083713>, <-2.305029, 10.345510, -1.068874>, <-2.367035, 10.330635, -1.121515>, <-2.339129, 10.345510, -1.111936>, <-2.410213, 10.330635, -1.151469>, <-2.380975, 10.345510, -1.147518>, <-2.458405, 10.330635, -1.172423>, <-2.428958, 10.345510, -1.174252>, <-2.509759, 10.330635, -1.183573>, 
			<-2.481234, 10.345510, -1.191112>, <-2.616406, 10.345510, -1.199533>, <-2.252397, 10.362460, -0.940617>, <-2.262487, 10.362460, -0.996411>, <-2.283267, 10.362460, -1.049165>, <-2.313940, 10.362460, -1.096851>, <-2.353326, 10.362460, -1.137637>, <-2.399913, 10.362460, -1.169955>, <-2.451909, 10.362460, -1.192564>, <-2.507317, 10.362460, -1.204594>, <-2.885430, 10.400000, -1.221455>, 
			<-2.885560, 10.437540, -1.213989>, <-2.885931, 10.469365, -1.192727>, <-2.886487, 10.490630, -1.160907>, <-2.887142, 10.498097, -1.123373>, <-2.887797, 10.490630, -1.085839>, <-2.888353, 10.469365, -1.054018>, <-2.888724, 10.437540, -1.032757>, <-2.888854, 10.400000, -1.025291>, <-2.888724, 10.362460, -1.032757>, <-2.888353, 10.330635, -1.054018>, <-2.887797, 10.309370, -1.085839>, 
			<-2.887142, 10.301903, -1.123373>, <-2.886487, 10.309370, -1.160907>, <-2.885931, 10.330635, -1.192727>, <-2.885560, 10.362460, -1.213989>, <-2.245737, 10.419134, -0.843386>, <-2.250755, 10.437540, -0.874729>, <-2.245737, 10.380866, -0.843386>, <-2.243289, 10.400000, -0.874598>, <-2.260379, 10.345510, -0.843642>, <-2.250755, 10.362460, -0.874729>, <-2.287435, 10.318451, -0.844114>, 
			<-2.272016, 10.330635, -0.875100>, <-2.322785, 10.303806, -0.844731>, <-2.303836, 10.309370, -0.875655>, <-2.361047, 10.303806, -0.845399>, <-2.341371, 10.301903, -0.876310>, <-2.396397, 10.318451, -0.846016>, <-2.378905, 10.309370, -0.876965>, <-2.423453, 10.345510, -0.846488>, <-2.410725, 10.330635, -0.877521>, <-2.438095, 10.380866, -0.846744>, <-2.431987, 10.362460, -0.877892>, 
			<-2.438095, 10.419134, -0.846744>, <-2.439453, 10.400000, -0.878022>, <-2.423453, 10.454490, -0.846488>, <-2.431987, 10.437540, -0.877892>, <-2.396397, 10.481549, -0.846016>, <-2.410725, 10.469365, -0.877521>, <-2.361047, 10.496194, -0.845399>, <-2.378905, 10.490630, -0.876965>, <-2.322785, 10.496194, -0.844731>, <-2.341371, 10.498097, -0.876310>, <-2.287435, 10.481549, -0.844114>, 
			<-2.303836, 10.490630, -0.875655>, <-2.260379, 10.454490, -0.843642>, <-2.272016, 10.469365, -0.875100>, <-2.249233, 10.418536, -0.815318>, <-2.251627, 10.437540, -0.824736>, <-2.249233, 10.381464, -0.815318>, <-2.244161, 10.400000, -0.824606>, <-2.263418, 10.347213, -0.815566>, <-2.251627, 10.362460, -0.824736>, <-2.289628, 10.320999, -0.816023>, <-2.272889, 10.330635, -0.825107>, 
			<-2.323874, 10.306812, -0.816621>, <-2.304709, 10.309370, -0.825663>, <-2.360940, 10.306812, -0.817268>, <-2.342243, 10.301903, -0.826318>, <-2.395186, 10.320999, -0.817866>, <-2.379778, 10.309370, -0.826973>, <-2.421396, 10.347213, -0.818323>, <-2.411598, 10.330635, -0.827529>, <-2.435581, 10.381464, -0.818571>, <-2.432859, 10.362460, -0.827900>, <-2.435581, 10.418536, -0.818571>, 
			<-2.440325, 10.400000, -0.828030>, <-2.421396, 10.452787, -0.818323>, <-2.432859, 10.437540, -0.827900>, <-2.395186, 10.479001, -0.817866>, <-2.411598, 10.469365, -0.827529>, <-2.360940, 10.493188, -0.817268>, <-2.379778, 10.490630, -0.826973>, <-2.323874, 10.493188, -0.816621>, <-2.342243, 10.498097, -0.826318>, <-2.289628, 10.479001, -0.816023>, <-2.304709, 10.490630, -0.825663>, 
			<-2.263418, 10.452787, -0.815566>, <-2.272889, 10.469365, -0.825107>, <-2.285355, 10.411361, -0.812823>, <-2.263173, 10.432848, -0.812436>, <-2.285355, 10.388639, -0.812823>, <-2.256640, 10.400000, -0.812322>, <-2.294049, 10.367647, -0.812975>, <-2.263173, 10.367152, -0.812436>, <-2.310113, 10.351580, -0.813255>, <-2.281776, 10.339306, -0.812761>, <-2.331102, 10.342885, -0.813622>, 
			<-2.309619, 10.320699, -0.813247>, <-2.353821, 10.342885, -0.814018>, <-2.342462, 10.314165, -0.813820>, <-2.374810, 10.351580, -0.814384>, <-2.375304, 10.320699, -0.814393>, <-2.390874, 10.367647, -0.814665>, <-2.403147, 10.339306, -0.814879>, <-2.399568, 10.388639, -0.814817>, <-2.421751, 10.367152, -0.815204>, <-2.399568, 10.411361, -0.814817>, <-2.428283, 10.400000, -0.815318>, 
			<-2.390874, 10.432353, -0.814665>, <-2.421751, 10.432848, -0.815204>, <-2.374810, 10.448420, -0.814384>, <-2.403147, 10.460694, -0.814879>, <-2.353821, 10.457115, -0.814018>, <-2.375304, 10.479301, -0.814393>, <-2.331102, 10.457115, -0.813622>, <-2.342462, 10.485835, -0.813820>, <-2.310113, 10.448420, -0.813255>, <-2.309619, 10.479301, -0.813247>, <-2.294049, 10.432353, -0.812975>, 
			<-2.281776, 10.460694, -0.812761>, <-3.557218, 10.400000, 0.294226>, <-3.554468, 10.419134, 0.122393>, <-3.554468, 10.380866, 0.122393>, <-3.295748, 10.400000, 0.564986>, <-3.186414, 10.419134, 0.567144>, <-3.186414, 10.380866, 0.567144>, <-3.352580, 10.400000, 0.552647>, <-3.324066, 10.419134, 0.558365>, <-3.324066, 10.380866, 0.558365>, <-3.405912, 10.400000, 0.529457>, 
			<-3.379062, 10.419134, 0.540628>, <-3.379062, 10.380866, 0.540628>, <-3.453696, 10.400000, 0.496308>, <-3.429541, 10.419134, 0.512503>, <-3.429541, 10.380866, 0.512503>, <-3.494094, 10.400000, 0.454475>, <-3.473563, 10.419134, 0.475071>, <-3.473563, 10.380866, 0.475071>, <-3.525555, 10.400000, 0.405563>, <-3.509436, 10.419134, 0.429769>, <-3.509436, 10.380866, 0.429769>, 
			<-3.546869, 10.400000, 0.351454>, <-3.535782, 10.419134, 0.378339>, <-3.535782, 10.380866, 0.378339>, <-3.551589, 10.419134, 0.322758>, <-3.551589, 10.380866, 0.322758>, <-3.549811, 10.437540, 0.293627>, <-3.539854, 10.454490, 0.122291>, <-3.294891, 10.437540, 0.557604>, <-3.185802, 10.454490, 0.552543>, <-3.350299, 10.437540, 0.545574>, <-3.320974, 10.454490, 0.544123>, 
			<-3.402295, 10.437540, 0.522965>, <-3.373250, 10.454490, 0.527263>, <-3.448882, 10.437540, 0.490647>, <-3.421233, 10.454490, 0.500528>, <-3.488268, 10.437540, 0.449861>, <-3.463079, 10.454490, 0.464947>, <-3.518941, 10.437540, 0.402175>, <-3.497179, 10.454490, 0.421885>, <-3.539721, 10.437540, 0.349421>, <-3.522222, 10.454490, 0.372998>, <-3.537247, 10.454490, 0.320165>, 
			<-3.528717, 10.469365, 0.291921>, <-3.512852, 10.481549, 0.122103>, <-3.292449, 10.469365, 0.536583>, <-3.184671, 10.481549, 0.525564>, <-3.343803, 10.469365, 0.525433>, <-3.315260, 10.481549, 0.517806>, <-3.391995, 10.469365, 0.504479>, <-3.362512, 10.481549, 0.502567>, <-3.435173, 10.469365, 0.474525>, <-3.405884, 10.481549, 0.478402>, <-3.471678, 10.469365, 0.436724>, 
			<-3.443707, 10.481549, 0.446240>, <-3.500106, 10.469365, 0.392527>, <-3.474530, 10.481549, 0.407316>, <-3.519366, 10.469365, 0.343633>, <-3.497166, 10.481549, 0.363128>, <-3.510747, 10.481549, 0.315373>, <-3.497149, 10.490630, 0.289367>, <-3.477572, 10.496194, 0.121856>, <-3.288795, 10.490630, 0.505123>, <-3.183194, 10.496194, 0.490314>, <-3.334082, 10.490630, 0.495291>, 
			<-3.307794, 10.496194, 0.483422>, <-3.376580, 10.490630, 0.476812>, <-3.348482, 10.496194, 0.470299>, <-3.414657, 10.490630, 0.450397>, <-3.385828, 10.496194, 0.449491>, <-3.446848, 10.490630, 0.417062>, <-3.418397, 10.496194, 0.421798>, <-3.471918, 10.490630, 0.378086>, <-3.444937, 10.496194, 0.388282>, <-3.488902, 10.490630, 0.334969>, <-3.464429, 10.496194, 0.350233>, 
			<-3.476123, 10.496194, 0.309112>, <-3.459911, 10.498097, 0.286355>, <-3.439385, 10.496194, 0.121589>, <-3.284485, 10.498097, 0.468013>, <-3.181594, 10.496194, 0.452160>, <-3.322615, 10.498097, 0.459735>, <-3.299713, 10.496194, 0.446204>, <-3.358397, 10.498097, 0.444176>, <-3.333296, 10.496194, 0.435374>, <-3.390456, 10.498097, 0.421936>, <-3.364120, 10.496194, 0.418199>, 
			<-3.417560, 10.498097, 0.393869>, <-3.391001, 10.496194, 0.395342>, <-3.438668, 10.498097, 0.361053>, <-3.412907, 10.496194, 0.367679>, <-3.452968, 10.498097, 0.324750>, <-3.428995, 10.496194, 0.336275>, <-3.438647, 10.496194, 0.302335>, <-3.422673, 10.490630, 0.283342>, <-3.404105, 10.481549, 0.121343>, <-3.280175, 10.490630, 0.430903>, <-3.180117, 10.481549, 0.416910>, 
			<-3.311148, 10.490630, 0.424179>, <-3.292248, 10.481549, 0.411820>, <-3.340213, 10.490630, 0.411541>, <-3.319266, 10.481549, 0.403106>, <-3.366255, 10.490630, 0.393475>, <-3.344064, 10.481549, 0.389289>, <-3.388272, 10.490630, 0.370676>, <-3.365691, 10.481549, 0.370900>, <-3.405417, 10.490630, 0.344020>, <-3.383314, 10.481549, 0.348645>, <-3.417033, 10.490630, 0.314531>, 
			<-3.396257, 10.481549, 0.323379>, <-3.404023, 10.481549, 0.296074>, <-3.391105, 10.469365, 0.280788>, <-3.377103, 10.454490, 0.121154>, <-3.276521, 10.469365, 0.399443>, <-3.178986, 10.454490, 0.389930>, <-3.301426, 10.469365, 0.394036>, <-3.286534, 10.454490, 0.385503>, <-3.324798, 10.469365, 0.383873>, <-3.308527, 10.454490, 0.378410>, <-3.345738, 10.469365, 0.369347>, 
			<-3.328714, 10.454490, 0.367163>, <-3.363442, 10.469365, 0.351014>, <-3.346319, 10.454490, 0.352193>, <-3.377229, 10.469365, 0.329579>, <-3.360665, 10.454490, 0.334076>, <-3.386570, 10.469365, 0.305867>, <-3.371201, 10.454490, 0.313509>, <-3.377523, 10.454490, 0.291282>, <-3.370011, 10.437540, 0.279082>, <-3.362489, 10.419134, 0.121052>, <-3.274079, 10.437540, 0.378422>, 
			<-3.178374, 10.419134, 0.375329>, <-3.294931, 10.437540, 0.373895>, <-3.283442, 10.419134, 0.371261>, <-3.314498, 10.437540, 0.365387>, <-3.302716, 10.419134, 0.365045>, <-3.332030, 10.437540, 0.353225>, <-3.320407, 10.419134, 0.355188>, <-3.346852, 10.437540, 0.337876>, <-3.335835, 10.419134, 0.342069>, <-3.358394, 10.437540, 0.319931>, <-3.348408, 10.419134, 0.326192>, 
			<-3.366214, 10.437540, 0.300078>, <-3.357641, 10.419134, 0.308168>, <-3.363181, 10.419134, 0.288688>, <-3.362604, 10.400000, 0.278483>, <-3.362489, 10.380866, 0.121052>, <-3.273222, 10.400000, 0.371041>, <-3.178374, 10.380866, 0.375329>, <-3.292650, 10.400000, 0.366822>, <-3.283442, 10.380866, 0.371261>, <-3.310881, 10.400000, 0.358895>, <-3.302716, 10.380866, 0.365045>, 
			<-3.327216, 10.400000, 0.347563>, <-3.320407, 10.380866, 0.355188>, <-3.341026, 10.400000, 0.333263>, <-3.335835, 10.380866, 0.342069>, <-3.351781, 10.400000, 0.316543>, <-3.348408, 10.380866, 0.326192>, <-3.359067, 10.400000, 0.298046>, <-3.357641, 10.380866, 0.308168>, <-3.363181, 10.380866, 0.288688>, <-3.370011, 10.362460, 0.279082>, <-3.377103, 10.345510, 0.121154>, 
			<-3.274079, 10.362460, 0.378422>, <-3.178986, 10.345510, 0.389930>, <-3.294931, 10.362460, 0.373895>, <-3.286534, 10.345510, 0.385503>, <-3.314498, 10.362460, 0.365387>, <-3.308527, 10.345510, 0.378410>, <-3.332030, 10.362460, 0.353225>, <-3.328714, 10.345510, 0.367163>, <-3.346852, 10.362460, 0.337876>, <-3.346319, 10.345510, 0.352193>, <-3.358394, 10.362460, 0.319931>, 
			<-3.360665, 10.345510, 0.334076>, <-3.366214, 10.362460, 0.300078>, <-3.371201, 10.345510, 0.313509>, <-3.377523, 10.345510, 0.291282>, <-3.391105, 10.330635, 0.280788>, <-3.404105, 10.318451, 0.121343>, <-3.276521, 10.330635, 0.399443>, <-3.180117, 10.318451, 0.416910>, <-3.301426, 10.330635, 0.394036>, <-3.292248, 10.318451, 0.411820>, <-3.324798, 10.330635, 0.383873>, 
			<-3.319266, 10.318451, 0.403106>, <-3.345738, 10.330635, 0.369347>, <-3.344064, 10.318451, 0.389289>, <-3.363442, 10.330635, 0.351014>, <-3.365691, 10.318451, 0.370900>, <-3.377229, 10.330635, 0.329579>, <-3.383314, 10.318451, 0.348645>, <-3.386570, 10.330635, 0.305867>, <-3.396257, 10.318451, 0.323379>, <-3.404023, 10.318451, 0.296074>, <-3.422673, 10.309370, 0.283342>, 
			<-3.439385, 10.303806, 0.121589>, <-3.280175, 10.309370, 0.430903>, <-3.181594, 10.303806, 0.452160>, <-3.311148, 10.309370, 0.424179>, <-3.299713, 10.303806, 0.446204>, <-3.340213, 10.309370, 0.411541>, <-3.333296, 10.303806, 0.435374>, <-3.366255, 10.309370, 0.393475>, <-3.364120, 10.303806, 0.418199>, <-3.388272, 10.309370, 0.370676>, <-3.391001, 10.303806, 0.395342>, 
			<-3.405417, 10.309370, 0.344020>, <-3.412907, 10.303806, 0.367679>, <-3.417033, 10.309370, 0.314531>, <-3.428995, 10.303806, 0.336275>, <-3.438647, 10.303806, 0.302335>, <-3.459911, 10.301903, 0.286355>, <-3.477572, 10.303806, 0.121856>, <-3.284485, 10.301903, 0.468013>, <-3.183194, 10.303806, 0.490314>, <-3.322615, 10.301903, 0.459735>, <-3.307794, 10.303806, 0.483422>, 
			<-3.358397, 10.301903, 0.444176>, <-3.348482, 10.303806, 0.470299>, <-3.390456, 10.301903, 0.421936>, <-3.385828, 10.303806, 0.449491>, <-3.417560, 10.301903, 0.393869>, <-3.418397, 10.303806, 0.421798>, <-3.438668, 10.301903, 0.361053>, <-3.444937, 10.303806, 0.388282>, <-3.452968, 10.301903, 0.324750>, <-3.464429, 10.303806, 0.350233>, <-3.476123, 10.303806, 0.309112>, 
			<-3.497149, 10.309370, 0.289367>, <-3.512852, 10.318451, 0.122103>, <-3.288795, 10.309370, 0.505123>, <-3.184671, 10.318451, 0.525564>, <-3.334082, 10.309370, 0.495291>, <-3.315260, 10.318451, 0.517806>, <-3.376580, 10.309370, 0.476812>, <-3.362512, 10.318451, 0.502567>, <-3.414657, 10.309370, 0.450397>, <-3.405884, 10.318451, 0.478402>, <-3.446848, 10.309370, 0.417062>, 
			<-3.443707, 10.318451, 0.446240>, <-3.471918, 10.309370, 0.378086>, <-3.474530, 10.318451, 0.407316>, <-3.488902, 10.309370, 0.334969>, <-3.497166, 10.318451, 0.363128>, <-3.510747, 10.318451, 0.315373>, <-3.528717, 10.330635, 0.291921>, <-3.539854, 10.345510, 0.122291>, <-3.292449, 10.330635, 0.536583>, <-3.185802, 10.345510, 0.552543>, <-3.343803, 10.330635, 0.525433>, 
			<-3.320974, 10.345510, 0.544123>, <-3.391995, 10.330635, 0.504479>, <-3.373250, 10.345510, 0.527263>, <-3.435173, 10.330635, 0.474525>, <-3.421233, 10.345510, 0.500528>, <-3.471678, 10.330635, 0.436724>, <-3.463079, 10.345510, 0.464947>, <-3.500106, 10.330635, 0.392527>, <-3.497179, 10.345510, 0.421885>, <-3.519366, 10.330635, 0.343633>, <-3.522222, 10.345510, 0.372998>, 
			<-3.537247, 10.345510, 0.320165>, <-3.549811, 10.362460, 0.293627>, <-3.294891, 10.362460, 0.557604>, <-3.350299, 10.362460, 0.545574>, <-3.402295, 10.362460, 0.522965>, <-3.448882, 10.362460, 0.490647>, <-3.488268, 10.362460, 0.449861>, <-3.518941, 10.362460, 0.402175>, <-3.539721, 10.362460, 0.349421>, <-3.541636, 10.362460, -0.334675>, <-3.549102, 10.400000, -0.334806>, 
			<-3.541636, 10.437540, -0.334675>, <-3.520375, 10.469365, -0.334304>, <-3.488555, 10.490630, -0.333749>, <-3.451020, 10.498097, -0.333094>, <-3.413486, 10.490630, -0.332438>, <-3.381666, 10.469365, -0.331883>, <-3.360404, 10.437540, -0.331512>, <-3.352938, 10.400000, -0.331382>, <-3.360404, 10.362460, -0.331512>, <-3.381666, 10.330635, -0.331883>, <-3.413486, 10.309370, -0.332438>, 
			<-3.451020, 10.301903, -0.333094>, <-3.488555, 10.309370, -0.333749>, <-3.520375, 10.330635, -0.334304>, <-2.266948, 10.400000, 0.316748>, <-2.266154, 10.419134, 0.285527>, <-2.266154, 10.380866, 0.285527>, <-2.279287, 10.400000, 0.373580>, <-2.273569, 10.419134, 0.345066>, <-2.273569, 10.380866, 0.345066>, <-2.302477, 10.400000, 0.426912>, <-2.291306, 10.419134, 0.400062>, 
			<-2.291306, 10.380866, 0.400062>, <-2.335626, 10.400000, 0.474696>, <-2.319431, 10.419134, 0.450541>, <-2.319431, 10.380866, 0.450541>, <-2.377460, 10.400000, 0.515094>, <-2.356863, 10.419134, 0.494563>, <-2.356863, 10.380866, 0.494563>, <-2.426371, 10.400000, 0.546555>, <-2.402165, 10.419134, 0.530436>, <-2.402165, 10.380866, 0.530436>, <-2.480480, 10.400000, 0.567869>, 
			<-2.453595, 10.419134, 0.556782>, <-2.453595, 10.380866, 0.556782>, <-2.537708, 10.400000, 0.578218>, <-2.509176, 10.419134, 0.572589>, <-2.509176, 10.380866, 0.572589>, <-2.647050, 10.419134, 0.576559>, <-2.647050, 10.380866, 0.576559>, <-2.274330, 10.437540, 0.315891>, <-2.280755, 10.454490, 0.284915>, <-2.286360, 10.437540, 0.371299>, <-2.287812, 10.454490, 0.341974>, 
			<-2.308969, 10.437540, 0.423295>, <-2.304671, 10.454490, 0.394250>, <-2.341287, 10.437540, 0.469882>, <-2.331406, 10.454490, 0.442233>, <-2.382073, 10.437540, 0.509268>, <-2.366988, 10.454490, 0.484079>, <-2.429759, 10.437540, 0.539941>, <-2.410049, 10.454490, 0.518179>, <-2.482513, 10.437540, 0.560721>, <-2.458936, 10.454490, 0.543222>, <-2.538307, 10.437540, 0.570811>, 
			<-2.511770, 10.454490, 0.558247>, <-2.647152, 10.454490, 0.561945>, <-2.295351, 10.469365, 0.313449>, <-2.307734, 10.481549, 0.283784>, <-2.306501, 10.469365, 0.364803>, <-2.314128, 10.481549, 0.336260>, <-2.327455, 10.469365, 0.412995>, <-2.329368, 10.481549, 0.383512>, <-2.357409, 10.469365, 0.456173>, <-2.353533, 10.481549, 0.426884>, <-2.395211, 10.469365, 0.492678>, 
			<-2.385695, 10.481549, 0.464707>, <-2.439408, 10.469365, 0.521106>, <-2.424618, 10.481549, 0.495530>, <-2.488302, 10.469365, 0.540366>, <-2.468806, 10.481549, 0.518166>, <-2.540013, 10.469365, 0.549717>, <-2.516562, 10.481549, 0.531747>, <-2.647341, 10.481549, 0.534943>, <-2.326811, 10.490630, 0.309795>, <-2.342984, 10.496194, 0.282307>, <-2.336644, 10.490630, 0.355082>, 
			<-2.348513, 10.496194, 0.328794>, <-2.355122, 10.490630, 0.397580>, <-2.361635, 10.496194, 0.369482>, <-2.381537, 10.490630, 0.435657>, <-2.382443, 10.496194, 0.406828>, <-2.414873, 10.490630, 0.467848>, <-2.410137, 10.496194, 0.439397>, <-2.453848, 10.490630, 0.492918>, <-2.443652, 10.496194, 0.465937>, <-2.496965, 10.490630, 0.509902>, <-2.481702, 10.496194, 0.485429>, 
			<-2.542567, 10.490630, 0.518149>, <-2.522823, 10.496194, 0.497123>, <-2.647588, 10.496194, 0.499663>, <-2.363921, 10.498097, 0.305485>, <-2.381138, 10.496194, 0.280708>, <-2.372200, 10.498097, 0.343615>, <-2.385730, 10.496194, 0.320713>, <-2.387758, 10.498097, 0.379397>, <-2.396561, 10.496194, 0.354296>, <-2.409998, 10.498097, 0.411456>, <-2.413735, 10.496194, 0.385120>, 
			<-2.438065, 10.498097, 0.438560>, <-2.436592, 10.496194, 0.412001>, <-2.470881, 10.498097, 0.459668>, <-2.464255, 10.496194, 0.433907>, <-2.507184, 10.498097, 0.473968>, <-2.495660, 10.496194, 0.449995>, <-2.545580, 10.498097, 0.480911>, <-2.529599, 10.496194, 0.459647>, <-2.647854, 10.496194, 0.461476>, <-2.401031, 10.490630, 0.301175>, <-2.416388, 10.481549, 0.279230>, 
			<-2.407756, 10.490630, 0.332148>, <-2.420114, 10.481549, 0.313248>, <-2.420394, 10.490630, 0.361213>, <-2.428828, 10.481549, 0.340266>, <-2.438459, 10.490630, 0.387255>, <-2.442645, 10.481549, 0.365064>, <-2.461258, 10.490630, 0.409272>, <-2.461034, 10.481549, 0.386691>, <-2.487915, 10.490630, 0.426417>, <-2.483289, 10.481549, 0.404314>, <-2.517404, 10.490630, 0.438034>, 
			<-2.508555, 10.481549, 0.417257>, <-2.548592, 10.490630, 0.443673>, <-2.535860, 10.481549, 0.425023>, <-2.648101, 10.481549, 0.426196>, <-2.432491, 10.469365, 0.297521>, <-2.443367, 10.454490, 0.278099>, <-2.437898, 10.469365, 0.322426>, <-2.446431, 10.454490, 0.307534>, <-2.448061, 10.469365, 0.345798>, <-2.453524, 10.454490, 0.329527>, <-2.462588, 10.469365, 0.366738>, 
			<-2.464772, 10.454490, 0.349714>, <-2.480920, 10.469365, 0.384442>, <-2.479741, 10.454490, 0.367319>, <-2.502355, 10.469365, 0.398229>, <-2.497858, 10.454490, 0.381665>, <-2.526067, 10.469365, 0.407570>, <-2.518425, 10.454490, 0.392201>, <-2.551146, 10.469365, 0.412105>, <-2.540652, 10.454490, 0.398523>, <-2.648290, 10.454490, 0.399194>, <-2.453512, 10.437540, 0.295079>, 
			<-2.457968, 10.419134, 0.277487>, <-2.458039, 10.437540, 0.315931>, <-2.460674, 10.419134, 0.304442>, <-2.466547, 10.437540, 0.335498>, <-2.466890, 10.419134, 0.323716>, <-2.478709, 10.437540, 0.353030>, <-2.476747, 10.419134, 0.341407>, <-2.494058, 10.437540, 0.367852>, <-2.489865, 10.419134, 0.356835>, <-2.512003, 10.437540, 0.379394>, <-2.505742, 10.419134, 0.369408>, 
			<-2.531856, 10.437540, 0.387214>, <-2.523766, 10.419134, 0.378641>, <-2.552852, 10.437540, 0.391011>, <-2.543246, 10.419134, 0.384181>, <-2.648392, 10.419134, 0.384580>, <-2.460894, 10.400000, 0.294222>, <-2.457968, 10.380866, 0.277487>, <-2.465112, 10.400000, 0.313650>, <-2.460674, 10.380866, 0.304442>, <-2.473039, 10.400000, 0.331881>, <-2.466890, 10.380866, 0.323716>, 
			<-2.484371, 10.400000, 0.348216>, <-2.476747, 10.380866, 0.341407>, <-2.498671, 10.400000, 0.362026>, <-2.489865, 10.380866, 0.356835>, <-2.515391, 10.400000, 0.372781>, <-2.505742, 10.380866, 0.369408>, <-2.533888, 10.400000, 0.380067>, <-2.523766, 10.380866, 0.378641>, <-2.553451, 10.400000, 0.383604>, <-2.543246, 10.380866, 0.384181>, <-2.648392, 10.380866, 0.384580>, 
			<-2.453512, 10.362460, 0.295079>, <-2.443367, 10.345510, 0.278099>, <-2.458039, 10.362460, 0.315931>, <-2.446431, 10.345510, 0.307534>, <-2.466547, 10.362460, 0.335498>, <-2.453524, 10.345510, 0.329527>, <-2.478709, 10.362460, 0.353030>, <-2.464772, 10.345510, 0.349714>, <-2.494058, 10.362460, 0.367852>, <-2.479741, 10.345510, 0.367319>, <-2.512003, 10.362460, 0.379394>, 
			<-2.497858, 10.345510, 0.381665>, <-2.531856, 10.362460, 0.387214>, <-2.518425, 10.345510, 0.392201>, <-2.552852, 10.362460, 0.391011>, <-2.540652, 10.345510, 0.398523>, <-2.648290, 10.345510, 0.399194>, <-2.432491, 10.330635, 0.297521>, <-2.416388, 10.318451, 0.279230>, <-2.437898, 10.330635, 0.322426>, <-2.420114, 10.318451, 0.313248>, <-2.448061, 10.330635, 0.345798>, 
			<-2.428828, 10.318451, 0.340266>, <-2.462588, 10.330635, 0.366738>, <-2.442645, 10.318451, 0.365064>, <-2.480920, 10.330635, 0.384442>, <-2.461034, 10.318451, 0.386691>, <-2.502355, 10.330635, 0.398229>, <-2.483289, 10.318451, 0.404314>, <-2.526067, 10.330635, 0.407570>, <-2.508555, 10.318451, 0.417257>, <-2.551146, 10.330635, 0.412105>, <-2.535860, 10.318451, 0.425023>, 
			<-2.648101, 10.318451, 0.426196>, <-2.401031, 10.309370, 0.301175>, <-2.381138, 10.303806, 0.280708>, <-2.407756, 10.309370, 0.332148>, <-2.385730, 10.303806, 0.320713>, <-2.420394, 10.309370, 0.361213>, <-2.396561, 10.303806, 0.354296>, <-2.438459, 10.309370, 0.387255>, <-2.413735, 10.303806, 0.385120>, <-2.461258, 10.309370, 0.409272>, <-2.436592, 10.303806, 0.412001>, 
			<-2.487915, 10.309370, 0.426417>, <-2.464255, 10.303806, 0.433907>, <-2.517404, 10.309370, 0.438034>, <-2.495660, 10.303806, 0.449995>, <-2.548592, 10.309370, 0.443673>, <-2.529599, 10.303806, 0.459647>, <-2.647854, 10.303806, 0.461476>, <-2.363921, 10.301903, 0.305485>, <-2.342984, 10.303806, 0.282307>, <-2.372200, 10.301903, 0.343615>, <-2.348513, 10.303806, 0.328794>, 
			<-2.387758, 10.301903, 0.379397>, <-2.361635, 10.303806, 0.369482>, <-2.409998, 10.301903, 0.411456>, <-2.382443, 10.303806, 0.406828>, <-2.438065, 10.301903, 0.438560>, <-2.410137, 10.303806, 0.439397>, <-2.470881, 10.301903, 0.459668>, <-2.443652, 10.303806, 0.465937>, <-2.507184, 10.301903, 0.473968>, <-2.481702, 10.303806, 0.485429>, <-2.545580, 10.301903, 0.480911>, 
			<-2.522823, 10.303806, 0.497123>, <-2.647588, 10.303806, 0.499663>, <-2.326811, 10.309370, 0.309795>, <-2.307734, 10.318451, 0.283784>, <-2.336644, 10.309370, 0.355082>, <-2.314128, 10.318451, 0.336260>, <-2.355122, 10.309370, 0.397580>, <-2.329368, 10.318451, 0.383512>, <-2.381537, 10.309370, 0.435657>, <-2.353533, 10.318451, 0.426884>, <-2.414873, 10.309370, 0.467848>, 
			<-2.385695, 10.318451, 0.464707>, <-2.453848, 10.309370, 0.492918>, <-2.424618, 10.318451, 0.495530>, <-2.496965, 10.309370, 0.509902>, <-2.468806, 10.318451, 0.518166>, <-2.542567, 10.309370, 0.518149>, <-2.516562, 10.318451, 0.531747>, <-2.647341, 10.318451, 0.534943>, <-2.295351, 10.330635, 0.313449>, <-2.280755, 10.345510, 0.284915>, <-2.306501, 10.330635, 0.364803>, 
			<-2.287812, 10.345510, 0.341974>, <-2.327455, 10.330635, 0.412995>, <-2.304671, 10.345510, 0.394250>, <-2.357409, 10.330635, 0.456173>, <-2.331406, 10.345510, 0.442233>, <-2.395211, 10.330635, 0.492678>, <-2.366988, 10.345510, 0.484079>, <-2.439408, 10.330635, 0.521106>, <-2.410049, 10.345510, 0.518179>, <-2.488302, 10.330635, 0.540366>, <-2.458936, 10.345510, 0.543222>, 
			<-2.540013, 10.330635, 0.549717>, <-2.511770, 10.345510, 0.558247>, <-2.647152, 10.345510, 0.561945>, <-2.274330, 10.362460, 0.315891>, <-2.286360, 10.362460, 0.371299>, <-2.308969, 10.362460, 0.423295>, <-2.341287, 10.362460, 0.469882>, <-2.382073, 10.362460, 0.509268>, <-2.429759, 10.362460, 0.539941>, <-2.482513, 10.362460, 0.560721>, <-2.538307, 10.362460, 0.570811>, 
			<-2.916778, 10.400000, 0.574465>, <-2.916648, 10.437540, 0.566999>, <-2.916277, 10.469365, 0.545738>, <-2.915721, 10.490630, 0.513918>, <-2.915066, 10.498097, 0.476383>, <-2.914411, 10.490630, 0.438849>, <-2.913855, 10.469365, 0.407029>, <-2.913484, 10.437540, 0.385767>, <-2.913354, 10.400000, 0.378301>, <-2.913484, 10.362460, 0.385767>, <-2.913855, 10.330635, 0.407029>, 
			<-2.914411, 10.309370, 0.438849>, <-2.915066, 10.301903, 0.476383>, <-2.915721, 10.309370, 0.513918>, <-2.916277, 10.330635, 0.545738>, <-2.916648, 10.362460, 0.566999>, <-2.264280, 10.419134, 0.218952>, <-2.270389, 10.437540, 0.250100>, <-2.264280, 10.380866, 0.218952>, <-2.262923, 10.400000, 0.250230>, <-2.278922, 10.345510, 0.218696>, <-2.270389, 10.362460, 0.250100>, 
			<-2.305978, 10.318451, 0.218224>, <-2.291650, 10.330635, 0.249729>, <-2.341328, 10.303806, 0.217607>, <-2.323470, 10.309370, 0.249174>, <-2.379591, 10.303806, 0.216939>, <-2.361005, 10.301903, 0.248518>, <-2.414941, 10.318451, 0.216322>, <-2.398539, 10.309370, 0.247863>, <-2.441996, 10.345510, 0.215850>, <-2.430359, 10.330635, 0.247308>, <-2.456639, 10.380866, 0.215594>, 
			<-2.451621, 10.362460, 0.246937>, <-2.456639, 10.419134, 0.215594>, <-2.459087, 10.400000, 0.246806>, <-2.441996, 10.454490, 0.215850>, <-2.451621, 10.437540, 0.246937>, <-2.414941, 10.481549, 0.216322>, <-2.430359, 10.469365, 0.247308>, <-2.379591, 10.496194, 0.216939>, <-2.398539, 10.490630, 0.247863>, <-2.341328, 10.496194, 0.217607>, <-2.361005, 10.498097, 0.248518>, 
			<-2.305978, 10.481549, 0.218224>, <-2.323470, 10.490630, 0.249174>, <-2.278922, 10.454490, 0.218696>, <-2.291650, 10.469365, 0.249729>, <-2.266795, 10.418536, 0.190779>, <-2.269516, 10.437540, 0.200108>, <-2.266795, 10.381464, 0.190779>, <-2.262050, 10.400000, 0.200238>, <-2.280980, 10.347213, 0.190531>, <-2.269516, 10.362460, 0.200108>, <-2.307190, 10.320999, 0.190074>, 
			<-2.290778, 10.330635, 0.199737>, <-2.341435, 10.306812, 0.189476>, <-2.322598, 10.309370, 0.199181>, <-2.378502, 10.306812, 0.188829>, <-2.360132, 10.301903, 0.198526>, <-2.412747, 10.320999, 0.188231>, <-2.397666, 10.309370, 0.197871>, <-2.438957, 10.347213, 0.187774>, <-2.429487, 10.330635, 0.197315>, <-2.453142, 10.381464, 0.187526>, <-2.450748, 10.362460, 0.196944>, 
			<-2.453142, 10.418536, 0.187526>, <-2.458214, 10.400000, 0.196814>, <-2.438957, 10.452787, 0.187774>, <-2.450748, 10.437540, 0.196944>, <-2.412747, 10.479001, 0.188231>, <-2.429487, 10.469365, 0.197315>, <-2.378502, 10.493188, 0.188829>, <-2.397666, 10.490630, 0.197871>, <-2.341435, 10.493188, 0.189476>, <-2.360132, 10.498097, 0.198526>, <-2.307190, 10.479001, 0.190074>, 
			<-2.322598, 10.490630, 0.199181>, <-2.280980, 10.452787, 0.190531>, <-2.290778, 10.469365, 0.199737>, <-2.302807, 10.411361, 0.187025>, <-2.280625, 10.432848, 0.187412>, <-2.302807, 10.388639, 0.187025>, <-2.274092, 10.400000, 0.187526>, <-2.311501, 10.367647, 0.186873>, <-2.280625, 10.367152, 0.187412>, <-2.327566, 10.351580, 0.186592>, <-2.299229, 10.339306, 0.187087>, 
			<-2.348555, 10.342885, 0.186226>, <-2.327071, 10.320699, 0.186601>, <-2.371273, 10.342885, 0.185830>, <-2.359914, 10.314165, 0.186028>, <-2.392262, 10.351580, 0.185463>, <-2.392757, 10.320699, 0.185455>, <-2.408326, 10.367647, 0.185183>, <-2.420599, 10.339306, 0.184969>, <-2.417020, 10.388639, 0.185031>, <-2.439203, 10.367152, 0.184644>, <-2.417020, 10.411361, 0.185031>, 
			<-2.445736, 10.400000, 0.184530>, <-2.408326, 10.432353, 0.185183>, <-2.439203, 10.432848, 0.184644>, <-2.392262, 10.448420, 0.185463>, <-2.420599, 10.460694, 0.184969>, <-2.371273, 10.457115, 0.185830>, <-2.392757, 10.479301, 0.185455>, <-2.348555, 10.457115, 0.186226>, <-2.359914, 10.485835, 0.186028>, <-2.327566, 10.448420, 0.186592>, <-2.327071, 10.479301, 0.186601>, 
			<-2.311501, 10.432353, 0.186873>, <-2.299229, 10.460694, 0.187087>, <-3.619848, 9.525371, -0.636086>, <-3.593348, 9.461385, -0.635624>, <-3.544383, 9.412412, -0.634769>, <-3.480407, 9.385909, -0.633652>, <-3.411159, 9.385909, -0.632444>, <-3.347183, 9.412412, -0.631327>, <-3.298218, 9.461385, -0.630472>, <-3.271718, 9.525371, -0.630010>, <-3.505895, 9.488041, -0.634097>, 
			<-3.496744, 9.465944, -0.633937>, <-3.479834, 9.449032, -0.633642>, <-3.457740, 9.439879, -0.633257>, <-3.433826, 9.439879, -0.632839>, <-3.411732, 9.449032, -0.632454>, <-3.394823, 9.465944, -0.632158>, <-3.383293, 9.600000, -0.631957>, <-3.385671, 9.711959, -0.631999>, <-3.394823, 9.734056, -0.632158>, <-3.411732, 9.750968, -0.632454>, <-3.433826, 9.760121, -0.632839>, 
			<-3.457740, 9.760121, -0.633257>, <-3.479834, 9.750968, -0.633642>, <-3.496744, 9.734056, -0.633937>, <-3.505895, 9.711959, -0.634097>, <-3.718318, 10.426825, -0.625303>, <-3.173685, 10.426825, -0.615797>, <-3.184150, 10.479444, -0.615979>, <-3.204678, 10.529010, -0.616338>, <-3.234479, 10.573618, -0.616858>, <-3.272410, 10.611554, -0.617520>, <-3.317011, 10.641361, -0.618298>, 
			<-3.366569, 10.661891, -0.619163>, <-3.419180, 10.672358, -0.620082>, <-3.472822, 10.672358, -0.621018>, <-3.525433, 10.661891, -0.621936>, <-3.574991, 10.641361, -0.622801>, <-3.619593, 10.611554, -0.623580>, <-3.657523, 10.573618, -0.624242>, <-3.687325, 10.529010, -0.624762>, <-3.707853, 10.479444, -0.625120>, <-3.718318, 9.573175, -0.625303>, <-3.707853, 9.520556, -0.625120>, 
			<-3.687325, 9.470990, -0.624762>, <-3.657523, 9.426382, -0.624242>, <-3.619593, 9.388446, -0.623580>, <-3.574991, 9.358639, -0.622801>, <-3.525433, 9.338109, -0.621936>, <-3.472822, 9.327642, -0.621018>, <-3.419180, 9.327642, -0.620082>, <-3.366569, 9.338109, -0.619163>, <-3.317011, 9.358639, -0.618298>, <-3.272410, 9.388446, -0.617520>, <-3.234479, 9.426382, -0.616858>, 
			<-3.204678, 9.470990, -0.616338>, <-3.184150, 9.520556, -0.615979>, <-3.173685, 9.573175, -0.615797>, <-3.171043, 10.000000, -0.615750>, <-3.720959, 10.000000, -0.625349>, <-3.174339, 10.426825, -0.578302>, <-3.185845, 9.574394, -0.628511>, <-3.183323, 10.000000, -0.628467>, <-3.185845, 10.425606, -0.628511>, <-3.195834, 10.475833, -0.628685>, <-3.215429, 10.523146, -0.629027>, 
			<-3.243876, 10.565726, -0.629524>, <-3.280082, 10.601938, -0.630156>, <-3.322656, 10.630390, -0.630899>, <-3.369962, 10.649987, -0.631724>, <-3.420181, 10.659978, -0.632601>, <-3.471385, 10.659978, -0.633495>, <-3.521604, 10.649987, -0.634371>, <-3.568910, 10.630390, -0.635197>, <-3.611484, 10.601938, -0.635940>, <-3.647690, 10.565726, -0.636572>, <-3.676137, 10.523146, -0.637069>, 
			<-3.695732, 10.475833, -0.637411>, <-3.705721, 10.425606, -0.637585>, <-3.708243, 10.000000, -0.637629>, <-3.705721, 9.574394, -0.637585>, <-3.695732, 9.524167, -0.637411>, <-3.676137, 9.476854, -0.637069>, <-3.647690, 9.434274, -0.636572>, <-3.611484, 9.398062, -0.635940>, <-3.568910, 9.369610, -0.635197>, <-3.521604, 9.350013, -0.634371>, <-3.471385, 9.340022, -0.633495>, 
			<-3.420181, 9.340022, -0.632601>, <-3.369962, 9.350013, -0.631724>, <-3.322656, 9.369610, -0.630899>, <-3.280082, 9.398062, -0.630156>, <-3.243876, 9.434274, -0.629524>, <-3.215429, 9.476854, -0.629027>, <-3.195834, 9.524167, -0.628685>, <-3.508274, 9.600000, -0.634139>, <-3.385671, 9.488041, -0.631999>, <-3.396009, 9.600000, -0.619677>, <-3.397912, 9.709567, -0.619710>, 
			<-3.405233, 9.727245, -0.619838>, <-3.418761, 9.740775, -0.620074>, <-3.436436, 9.748097, -0.620383>, <-3.455567, 9.748097, -0.620717>, <-3.473242, 9.740775, -0.621025>, <-3.486770, 9.727245, -0.621261>, <-3.494091, 9.709567, -0.621389>, <-3.495994, 9.600000, -0.621422>, <-3.494091, 9.490433, -0.621389>, <-3.486770, 9.472755, -0.621261>, <-3.473242, 9.459225, -0.621025>, 
			<-3.455567, 9.451903, -0.620717>, <-3.436436, 9.451903, -0.620383>, <-3.418761, 9.459225, -0.620074>, <-3.405233, 9.472755, -0.619838>, <-3.397912, 9.490433, -0.619710>, <-3.719627, 10.426825, -0.550315>, <-3.174994, 10.426825, -0.540808>, <-3.185459, 10.479444, -0.540991>, <-3.205986, 10.529010, -0.541349>, <-3.235788, 10.573618, -0.541869>, <-3.273719, 10.611554, -0.542531>, 
			<-3.318320, 10.641361, -0.543310>, <-3.367878, 10.661891, -0.544175>, <-3.420489, 10.672358, -0.545093>, <-3.474131, 10.672358, -0.546029>, <-3.526742, 10.661891, -0.546948>, <-3.576300, 10.641361, -0.547813>, <-3.620902, 10.611554, -0.548591>, <-3.658832, 10.573618, -0.549253>, <-3.688634, 10.529010, -0.549774>, <-3.709162, 10.479444, -0.550132>, <-3.719627, 9.573175, -0.550315>, 
			<-3.709162, 9.520556, -0.550132>, <-3.688634, 9.470990, -0.549774>, <-3.658832, 9.426382, -0.549253>, <-3.620902, 9.388446, -0.548591>, <-3.576300, 9.358639, -0.547813>, <-3.526742, 9.338109, -0.546948>, <-3.474131, 9.327642, -0.546029>, <-3.420489, 9.327642, -0.545093>, <-3.367878, 9.338109, -0.544175>, <-3.318320, 9.358639, -0.543310>, <-3.273719, 9.388446, -0.542531>, 
			<-3.235788, 9.426382, -0.541869>, <-3.205986, 9.470990, -0.541349>, <-3.185459, 9.520556, -0.540991>, <-3.174994, 9.573175, -0.540808>, <-3.172352, 10.000000, -0.540762>, <-3.722268, 10.000000, -0.550361>, <-3.718972, 10.426825, -0.587809>, <-3.184804, 10.479444, -0.578485>, <-3.205332, 10.529010, -0.578843>, <-3.235134, 10.573618, -0.579363>, <-3.273064, 10.611554, -0.580025>, 
			<-3.317666, 10.641361, -0.580804>, <-3.367224, 10.661891, -0.581669>, <-3.419835, 10.672358, -0.582587>, <-3.473477, 10.672358, -0.583524>, <-3.526087, 10.661891, -0.584442>, <-3.575646, 10.641361, -0.585307>, <-3.620247, 10.611554, -0.586086>, <-3.658178, 10.573618, -0.586748>, <-3.687979, 10.529010, -0.587268>, <-3.708507, 10.479444, -0.587626>, <-3.718972, 9.573175, -0.587809>, 
			<-3.708507, 9.520556, -0.587626>, <-3.687979, 9.470990, -0.587268>, <-3.658178, 9.426382, -0.586748>, <-3.620247, 9.388446, -0.586086>, <-3.575646, 9.358639, -0.585307>, <-3.526087, 9.338109, -0.584442>, <-3.473477, 9.327642, -0.583524>, <-3.419835, 9.327642, -0.582587>, <-3.367224, 9.338109, -0.581669>, <-3.317666, 9.358639, -0.580804>, <-3.273064, 9.388446, -0.580025>, 
			<-3.235134, 9.426382, -0.579363>, <-3.205332, 9.470990, -0.578843>, <-3.184804, 9.520556, -0.578485>, <-3.174339, 9.573175, -0.578302>, <-3.171698, 10.000000, -0.578256>, <-3.721614, 10.000000, -0.587855>, <-3.187590, 9.574394, -0.528526>, <-3.185068, 10.000000, -0.528482>, <-3.187590, 10.425606, -0.528526>, <-3.197579, 10.475833, -0.528700>, <-3.217174, 10.523146, -0.529042>, 
			<-3.245621, 10.565726, -0.529539>, <-3.281827, 10.601938, -0.530171>, <-3.324401, 10.630390, -0.530914>, <-3.371707, 10.649987, -0.531740>, <-3.421927, 10.659978, -0.532616>, <-3.473130, 10.659978, -0.533510>, <-3.523350, 10.649987, -0.534387>, <-3.570655, 10.630390, -0.535212>, <-3.613229, 10.601938, -0.535955>, <-3.649436, 10.565726, -0.536587>, <-3.677883, 10.523146, -0.537084>, 
			<-3.697477, 10.475833, -0.537426>, <-3.707467, 10.425606, -0.537600>, <-3.709988, 10.000000, -0.537644>, <-3.707467, 9.574394, -0.537600>, <-3.697477, 9.524167, -0.537426>, <-3.677883, 9.476854, -0.537084>, <-3.649436, 9.434274, -0.536587>, <-3.613229, 9.398062, -0.535955>, <-3.570655, 9.369610, -0.535212>, <-3.523350, 9.350013, -0.534387>, <-3.473130, 9.340022, -0.533510>, 
			<-3.421927, 9.340022, -0.532616>, <-3.371707, 9.350013, -0.531740>, <-3.324401, 9.369610, -0.530914>, <-3.281827, 9.398062, -0.530171>, <-3.245621, 9.434274, -0.529539>, <-3.217174, 9.476854, -0.529042>, <-3.197579, 9.524167, -0.528700>, <-3.546128, 9.412412, -0.534784>, <-3.482152, 9.385909, -0.533668>, <-3.412905, 9.385909, -0.532459>, <-3.273464, 9.525371, -0.530025>, 
			<-3.348928, 9.412412, -0.531342>, <-3.595093, 9.461385, -0.535639>, <-3.510019, 9.600000, -0.534154>, <-3.507640, 9.711959, -0.534112>, <-3.498489, 9.734056, -0.533953>, <-3.481579, 9.750968, -0.533658>, <-3.459485, 9.760121, -0.533272>, <-3.435571, 9.760121, -0.532854>, <-3.413478, 9.750968, -0.532469>, <-3.396568, 9.734056, -0.532174>, <-3.387416, 9.711959, -0.532014>, 
			<-3.385038, 9.600000, -0.531972>, <-3.387416, 9.488041, -0.532014>, <-3.396568, 9.465944, -0.532174>, <-3.413478, 9.449032, -0.532469>, <-3.435571, 9.439879, -0.532854>, <-3.459485, 9.439879, -0.533272>, <-3.481579, 9.449032, -0.533658>, <-3.498489, 9.465944, -0.533953>, <-3.507641, 9.488041, -0.534112>, <-3.595093, 10.218615, -0.535639>, <-3.412905, 10.294091, -0.532459>, 
			<-3.348928, 10.267588, -0.531342>, <-3.546128, 10.267588, -0.534784>, <-3.621593, 10.154629, -0.536101>, <-3.482152, 10.294091, -0.533668>, <-3.299963, 10.218615, -0.530487>, <-3.273463, 10.154629, -0.530025>, <-3.487424, 9.727245, -0.583767>, <-3.398566, 9.490433, -0.582216>, <-3.437090, 9.748097, -0.582889>, <-3.473896, 9.740775, -0.583531>, <-3.610004, 9.800000, -0.535899>, 
			<-3.437090, 9.451903, -0.582889>, <-3.405887, 9.472755, -0.582344>, <-3.496648, 9.600000, -0.583928>, <-3.473896, 9.459225, -0.583531>, <-3.419415, 9.459225, -0.582580>, <-3.487424, 9.472755, -0.583767>, <-3.405887, 9.727245, -0.582344>, <-3.396664, 9.600000, -0.582183>, <-3.419415, 9.740775, -0.582580>, <-3.494745, 9.709567, -0.583895>, <-3.456221, 9.748097, -0.583223>, 
			<-3.494746, 9.490433, -0.583895>, <-3.456221, 9.451903, -0.583223>, <-3.398566, 9.709567, -0.582216>, <-3.437745, 9.748097, -0.545394>, <-3.497303, 9.600000, -0.546434>, <-3.488079, 9.727245, -0.546273>, <-3.420070, 9.740775, -0.545086>, <-3.406542, 9.727245, -0.544850>, <-3.456876, 9.748097, -0.545728>, <-3.495400, 9.709567, -0.546401>, <-3.399221, 9.490433, -0.544722>, 
			<-3.420070, 9.459225, -0.545086>, <-3.495400, 9.490433, -0.546401>, <-3.474551, 9.740775, -0.546037>, <-3.437745, 9.451903, -0.545394>, <-3.406542, 9.472755, -0.544850>, <-3.488079, 9.472755, -0.546273>, <-3.456876, 9.451903, -0.545728>, <-3.397318, 9.600000, -0.544689>, <-3.399221, 9.709567, -0.544722>, <-3.474551, 9.459225, -0.546037>, <-3.621593, 9.525371, -0.536101>, 
			<-3.299963, 9.461385, -0.530487>, <-3.283308, 9.800000, -0.630212>, <-3.619848, 10.154629, -0.636086>, <-3.411159, 10.294091, -0.632444>, <-3.347183, 10.267588, -0.631327>, <-3.298218, 10.218615, -0.630472>, <-3.271718, 10.154629, -0.630010>, <-3.608258, 9.800000, -0.635884>, <-3.593348, 10.218615, -0.635624>, <-3.544383, 10.267588, -0.634769>, <-3.480407, 10.294091, -0.633652>, 
			<-3.285053, 9.800000, -0.530227>, <-3.628574, 9.525371, -0.136162>, <-3.602074, 9.461385, -0.135700>, <-3.553109, 9.412412, -0.134845>, <-3.489133, 9.385909, -0.133728>, <-3.419886, 9.385909, -0.132520>, <-3.355909, 9.412412, -0.131403>, <-3.306944, 9.461385, -0.130548>, <-3.280445, 9.525371, -0.130086>, <-3.514622, 9.488041, -0.134173>, <-3.505470, 9.465944, -0.134014>, 
			<-3.488560, 9.449032, -0.133718>, <-3.466466, 9.439879, -0.133333>, <-3.442552, 9.439879, -0.132915>, <-3.420459, 9.449032, -0.132530>, <-3.403549, 9.465944, -0.132235>, <-3.392019, 9.600000, -0.132033>, <-3.394397, 9.711959, -0.132075>, <-3.403549, 9.734056, -0.132235>, <-3.420459, 9.750968, -0.132530>, <-3.442552, 9.760121, -0.132915>, <-3.466466, 9.760121, -0.133333>, 
			<-3.488560, 9.750968, -0.133718>, <-3.505470, 9.734056, -0.134014>, <-3.514621, 9.711959, -0.134173>, <-3.727044, 10.426825, -0.125379>, <-3.182411, 10.426825, -0.115873>, <-3.192876, 10.479444, -0.116055>, <-3.213404, 10.529010, -0.116414>, <-3.243205, 10.573618, -0.116934>, <-3.281136, 10.611554, -0.117596>, <-3.325737, 10.641361, -0.118374>, <-3.375296, 10.661891, -0.119239>, 
			<-3.427907, 10.672358, -0.120158>, <-3.481548, 10.672358, -0.121094>, <-3.534159, 10.661891, -0.122012>, <-3.583718, 10.641361, -0.122878>, <-3.628319, 10.611554, -0.123656>, <-3.666249, 10.573618, -0.124318>, <-3.696051, 10.529010, -0.124838>, <-3.716579, 10.479444, -0.125197>, <-3.727044, 9.573175, -0.125379>, <-3.716579, 9.520556, -0.125197>, <-3.696051, 9.470990, -0.124838>, 
			<-3.666249, 9.426382, -0.124318>, <-3.628319, 9.388446, -0.123656>, <-3.583718, 9.358639, -0.122878>, <-3.534159, 9.338109, -0.122012>, <-3.481548, 9.327642, -0.121094>, <-3.427907, 9.327642, -0.120158>, <-3.375296, 9.338109, -0.119239>, <-3.325737, 9.358639, -0.118374>, <-3.281136, 9.388446, -0.117596>, <-3.243205, 9.426382, -0.116934>, <-3.213404, 9.470990, -0.116414>, 
			<-3.192876, 9.520556, -0.116055>, <-3.182411, 9.573175, -0.115873>, <-3.179769, 10.000000, -0.115827>, <-3.729685, 10.000000, -0.125425>, <-3.183066, 10.426825, -0.078378>, <-3.194571, 9.574394, -0.128587>, <-3.192049, 10.000000, -0.128543>, <-3.194571, 10.425606, -0.128587>, <-3.204560, 10.475833, -0.128761>, <-3.224155, 10.523146, -0.129103>, <-3.252602, 10.565726, -0.129600>, 
			<-3.288808, 10.601938, -0.130232>, <-3.331382, 10.630390, -0.130975>, <-3.378688, 10.649987, -0.131801>, <-3.428908, 10.659978, -0.132677>, <-3.480111, 10.659978, -0.133571>, <-3.530331, 10.649987, -0.134448>, <-3.577636, 10.630390, -0.135273>, <-3.620210, 10.601938, -0.136016>, <-3.656417, 10.565726, -0.136648>, <-3.684864, 10.523146, -0.137145>, <-3.704458, 10.475833, -0.137487>, 
			<-3.714448, 10.425606, -0.137661>, <-3.716969, 10.000000, -0.137705>, <-3.714448, 9.574394, -0.137661>, <-3.704458, 9.524167, -0.137487>, <-3.684864, 9.476854, -0.137145>, <-3.656417, 9.434274, -0.136648>, <-3.620210, 9.398062, -0.136016>, <-3.577636, 9.369610, -0.135273>, <-3.530331, 9.350013, -0.134448>, <-3.480111, 9.340022, -0.133571>, <-3.428908, 9.340022, -0.132677>, 
			<-3.378688, 9.350013, -0.131801>, <-3.331382, 9.369610, -0.130975>, <-3.288808, 9.398062, -0.130232>, <-3.252602, 9.434274, -0.129600>, <-3.224155, 9.476854, -0.129103>, <-3.204560, 9.524167, -0.128761>, <-3.517000, 9.600000, -0.134215>, <-3.394397, 9.488041, -0.132075>, <-3.404735, 9.600000, -0.119753>, <-3.406638, 9.709567, -0.119787>, <-3.413959, 9.727245, -0.119914>, 
			<-3.427487, 9.740775, -0.120150>, <-3.445162, 9.748097, -0.120459>, <-3.464293, 9.748097, -0.120793>, <-3.481968, 9.740775, -0.121101>, <-3.495496, 9.727245, -0.121338>, <-3.502817, 9.709567, -0.121465>, <-3.504720, 9.600000, -0.121499>, <-3.502817, 9.490433, -0.121465>, <-3.495496, 9.472755, -0.121338>, <-3.481968, 9.459225, -0.121101>, <-3.464293, 9.451903, -0.120793>, 
			<-3.445162, 9.451903, -0.120459>, <-3.427487, 9.459225, -0.120150>, <-3.413959, 9.472755, -0.119914>, <-3.406638, 9.490433, -0.119787>, <-3.728353, 10.426825, -0.050391>, <-3.183720, 10.426825, -0.040884>, <-3.194185, 10.479444, -0.041067>, <-3.214713, 10.529010, -0.041425>, <-3.244514, 10.573618, -0.041945>, <-3.282445, 10.611554, -0.042607>, <-3.327046, 10.641361, -0.043386>, 
			<-3.376605, 10.661891, -0.044251>, <-3.429216, 10.672358, -0.045169>, <-3.482857, 10.672358, -0.046106>, <-3.535468, 10.661891, -0.047024>, <-3.585027, 10.641361, -0.047889>, <-3.629628, 10.611554, -0.048667>, <-3.667558, 10.573618, -0.049330>, <-3.697360, 10.529010, -0.049850>, <-3.717888, 10.479444, -0.050208>, <-3.728353, 9.573175, -0.050391>, <-3.717888, 9.520556, -0.050208>, 
			<-3.697360, 9.470990, -0.049850>, <-3.667558, 9.426382, -0.049330>, <-3.629628, 9.388446, -0.048667>, <-3.585027, 9.358639, -0.047889>, <-3.535468, 9.338109, -0.047024>, <-3.482857, 9.327642, -0.046106>, <-3.429216, 9.327642, -0.045169>, <-3.376605, 9.338109, -0.044251>, <-3.327046, 9.358639, -0.043386>, <-3.282445, 9.388446, -0.042607>, <-3.244514, 9.426382, -0.041945>, 
			<-3.214713, 9.470990, -0.041425>, <-3.194185, 9.520556, -0.041067>, <-3.183720, 9.573175, -0.040884>, <-3.181078, 10.000000, -0.040838>, <-3.730994, 10.000000, -0.050437>, <-3.727698, 10.426825, -0.087885>, <-3.193530, 10.479444, -0.078561>, <-3.214058, 10.529010, -0.078919>, <-3.243860, 10.573618, -0.079440>, <-3.281790, 10.611554, -0.080102>, <-3.326392, 10.641361, -0.080880>, 
			<-3.375950, 10.661891, -0.081745>, <-3.428561, 10.672358, -0.082664>, <-3.482203, 10.672358, -0.083600>, <-3.534814, 10.661891, -0.084518>, <-3.584372, 10.641361, -0.085383>, <-3.628973, 10.611554, -0.086162>, <-3.666904, 10.573618, -0.086824>, <-3.696706, 10.529010, -0.087344>, <-3.717233, 10.479444, -0.087702>, <-3.727698, 9.573175, -0.087885>, <-3.717233, 9.520556, -0.087702>, 
			<-3.696706, 9.470990, -0.087344>, <-3.666904, 9.426382, -0.086824>, <-3.628973, 9.388446, -0.086162>, <-3.584372, 9.358639, -0.085383>, <-3.534814, 9.338109, -0.084518>, <-3.482203, 9.327642, -0.083600>, <-3.428561, 9.327642, -0.082664>, <-3.375950, 9.338109, -0.081745>, <-3.326392, 9.358639, -0.080880>, <-3.281790, 9.388446, -0.080102>, <-3.243860, 9.426382, -0.079440>, 
			<-3.214058, 9.470990, -0.078919>, <-3.193530, 9.520556, -0.078561>, <-3.183066, 9.573175, -0.078378>, <-3.180424, 10.000000, -0.078332>, <-3.730340, 10.000000, -0.087931>, <-3.196316, 9.574394, -0.028602>, <-3.193795, 10.000000, -0.028558>, <-3.196316, 10.425606, -0.028602>, <-3.206305, 10.475833, -0.028776>, <-3.225900, 10.523146, -0.029118>, <-3.254347, 10.565726, -0.029615>, 
			<-3.290553, 10.601938, -0.030247>, <-3.333128, 10.630390, -0.030990>, <-3.380433, 10.649987, -0.031816>, <-3.430653, 10.659978, -0.032692>, <-3.481856, 10.659978, -0.033586>, <-3.532076, 10.649987, -0.034463>, <-3.579382, 10.630390, -0.035288>, <-3.621956, 10.601938, -0.036032>, <-3.658162, 10.565726, -0.036664>, <-3.686609, 10.523146, -0.037160>, <-3.706204, 10.475833, -0.037502>, 
			<-3.716193, 10.425606, -0.037677>, <-3.718714, 10.000000, -0.037721>, <-3.716193, 9.574394, -0.037677>, <-3.706204, 9.524167, -0.037502>, <-3.686609, 9.476854, -0.037160>, <-3.658162, 9.434274, -0.036664>, <-3.621956, 9.398062, -0.036032>, <-3.579382, 9.369610, -0.035288>, <-3.532076, 9.350013, -0.034463>, <-3.481856, 9.340022, -0.033586>, <-3.430653, 9.340022, -0.032692>, 
			<-3.380433, 9.350013, -0.031816>, <-3.333128, 9.369610, -0.030990>, <-3.290553, 9.398062, -0.030247>, <-3.254347, 9.434274, -0.029615>, <-3.225900, 9.476854, -0.029118>, <-3.206305, 9.524167, -0.028776>, <-3.554854, 9.412412, -0.034860>, <-3.490878, 9.385909, -0.033744>, <-3.421631, 9.385909, -0.032535>, <-3.282190, 9.525371, -0.030101>, <-3.357655, 9.412412, -0.031418>, 
			<-3.603820, 9.461385, -0.035715>, <-3.518745, 9.600000, -0.034230>, <-3.516367, 9.711959, -0.034189>, <-3.507215, 9.734056, -0.034029>, <-3.490305, 9.750968, -0.033734>, <-3.468212, 9.760121, -0.033348>, <-3.444297, 9.760121, -0.032931>, <-3.422204, 9.750968, -0.032545>, <-3.405294, 9.734056, -0.032250>, <-3.396142, 9.711959, -0.032090>, <-3.393764, 9.600000, -0.032049>, 
			<-3.396143, 9.488041, -0.032090>, <-3.405294, 9.465944, -0.032250>, <-3.422204, 9.449032, -0.032545>, <-3.444297, 9.439879, -0.032931>, <-3.468212, 9.439879, -0.033348>, <-3.490305, 9.449032, -0.033734>, <-3.507215, 9.465944, -0.034029>, <-3.516367, 9.488041, -0.034189>, <-3.603820, 10.218615, -0.035715>, <-3.421631, 10.294091, -0.032535>, <-3.357655, 10.267588, -0.031418>, 
			<-3.554854, 10.267588, -0.034860>, <-3.630319, 10.154629, -0.036178>, <-3.490878, 10.294091, -0.033744>, <-3.308689, 10.218615, -0.030564>, <-3.282190, 10.154629, -0.030101>, <-3.496150, 9.727245, -0.083843>, <-3.407292, 9.490433, -0.082292>, <-3.445816, 9.748097, -0.082965>, <-3.482622, 9.740775, -0.083607>, <-3.618730, 9.800000, -0.035975>, <-3.445816, 9.451903, -0.082965>, 
			<-3.414613, 9.472755, -0.082420>, <-3.505374, 9.600000, -0.084004>, <-3.482622, 9.459225, -0.083607>, <-3.428141, 9.459225, -0.082656>, <-3.496150, 9.472755, -0.083843>, <-3.414613, 9.727245, -0.082420>, <-3.405390, 9.600000, -0.082259>, <-3.428141, 9.740775, -0.082656>, <-3.503472, 9.709567, -0.083971>, <-3.464948, 9.748097, -0.083299>, <-3.503472, 9.490433, -0.083971>, 
			<-3.464948, 9.451903, -0.083299>, <-3.407292, 9.709567, -0.082292>, <-3.446471, 9.748097, -0.045470>, <-3.506029, 9.600000, -0.046510>, <-3.496805, 9.727245, -0.046349>, <-3.428796, 9.740775, -0.045162>, <-3.415268, 9.727245, -0.044926>, <-3.465602, 9.748097, -0.045804>, <-3.504126, 9.709567, -0.046477>, <-3.407947, 9.490433, -0.044798>, <-3.428796, 9.459225, -0.045162>, 
			<-3.504126, 9.490433, -0.046477>, <-3.483277, 9.740775, -0.046113>, <-3.446471, 9.451903, -0.045470>, <-3.415268, 9.472755, -0.044926>, <-3.496805, 9.472755, -0.046349>, <-3.465602, 9.451903, -0.045804>, <-3.406044, 9.600000, -0.044765>, <-3.407947, 9.709567, -0.044798>, <-3.483277, 9.459225, -0.046113>, <-3.630319, 9.525371, -0.036178>, <-3.308689, 9.461385, -0.030564>, 
			<-3.292034, 9.800000, -0.130288>, <-3.628574, 10.154629, -0.136162>, <-3.419886, 10.294091, -0.132520>, <-3.355909, 10.267588, -0.131403>, <-3.306944, 10.218615, -0.130548>, <-3.280444, 10.154629, -0.130086>, <-3.616985, 9.800000, -0.135960>, <-3.602074, 10.218615, -0.135700>, <-3.553109, 10.267588, -0.134845>, <-3.489133, 10.294091, -0.133728>, <-3.293779, 9.800000, -0.030303>, 
			<-3.264347, 10.419134, -1.223320>, <-3.321210, 10.419134, -1.213037>, <-3.374974, 10.419134, -1.191859>, <-3.423573, 10.419134, -1.160599>, <-3.465139, 10.419134, -1.120459>, <-3.498077, 10.419134, -1.072980>, <-3.521118, 10.419134, -1.019988>, <-3.533379, 10.419134, -0.963519>, <-3.263172, 10.454490, -1.208793>, <-3.317223, 10.454490, -1.199019>, <-3.368329, 10.454490, -1.178888>, 
			<-3.414525, 10.454490, -1.149174>, <-3.454037, 10.454490, -1.111018>, <-3.485345, 10.454490, -1.065887>, <-3.507247, 10.454490, -1.015515>, <-3.518902, 10.454490, -0.961838>, <-3.261001, 10.481549, -1.181951>, <-3.309857, 10.481549, -1.173117>, <-3.356051, 10.481549, -1.154920>, <-3.397807, 10.481549, -1.128062>, <-3.433521, 10.481549, -1.093573>, <-3.461821, 10.481549, -1.052780>, 
			<-3.481618, 10.481549, -1.007249>, <-3.492152, 10.481549, -0.958731>, <-3.258164, 10.496194, -1.146881>, <-3.300232, 10.496194, -1.139273>, <-3.340009, 10.496194, -1.123605>, <-3.375964, 10.496194, -1.100478>, <-3.406716, 10.496194, -1.070781>, <-3.431084, 10.496194, -1.035654>, <-3.448131, 10.496194, -0.996449>, <-3.457202, 10.496194, -0.954672>, <-3.255093, 10.496194, -1.108921>, 
			<-3.289815, 10.496194, -1.102642>, <-3.322645, 10.496194, -1.089710>, <-3.352321, 10.496194, -1.070621>, <-3.377703, 10.496194, -1.046110>, <-3.397816, 10.496194, -1.017118>, <-3.411886, 10.496194, -0.984760>, <-3.419372, 10.496194, -0.950278>, <-3.252256, 10.481549, -1.073850>, <-3.280190, 10.481549, -1.068799>, <-3.306603, 10.481549, -1.058395>, <-3.330478, 10.481549, -1.043038>, 
			<-3.350898, 10.481549, -1.023318>, <-3.367079, 10.481549, -0.999993>, <-3.378399, 10.481549, -0.973960>, <-3.384422, 10.481549, -0.946219>, <-3.250084, 10.454490, -1.047008>, <-3.272824, 10.454490, -1.042896>, <-3.294325, 10.454490, -1.034427>, <-3.313760, 10.454490, -1.021926>, <-3.330383, 10.454490, -1.005873>, <-3.343555, 10.454490, -0.986886>, <-3.352769, 10.454490, -0.965694>, 
			<-3.357672, 10.454490, -0.943112>, <-3.248909, 10.419134, -1.032482>, <-3.268838, 10.419134, -1.028878>, <-3.287680, 10.419134, -1.021456>, <-3.304712, 10.419134, -1.010500>, <-3.319280, 10.419134, -0.996432>, <-3.330823, 10.419134, -0.979793>, <-3.338899, 10.419134, -0.961221>, <-3.343196, 10.419134, -0.941430>, <-3.248909, 10.380866, -1.032482>, <-3.268838, 10.380866, -1.028878>, 
			<-3.287680, 10.380866, -1.021456>, <-3.304712, 10.380866, -1.010500>, <-3.319280, 10.380866, -0.996432>, <-3.330823, 10.380866, -0.979793>, <-3.338899, 10.380866, -0.961221>, <-3.343196, 10.380866, -0.941430>, <-3.250084, 10.345510, -1.047008>, <-3.272824, 10.345510, -1.042896>, <-3.294325, 10.345510, -1.034427>, <-3.313760, 10.345510, -1.021926>, <-3.330383, 10.345510, -1.005873>, 
			<-3.343555, 10.345510, -0.986886>, <-3.352769, 10.345510, -0.965694>, <-3.357672, 10.345510, -0.943112>, <-3.252256, 10.318451, -1.073850>, <-3.280190, 10.318451, -1.068799>, <-3.306603, 10.318451, -1.058395>, <-3.330478, 10.318451, -1.043038>, <-3.350898, 10.318451, -1.023318>, <-3.367079, 10.318451, -0.999993>, <-3.378399, 10.318451, -0.973960>, <-3.384422, 10.318451, -0.946219>, 
			<-3.255093, 10.303806, -1.108921>, <-3.289815, 10.303806, -1.102642>, <-3.322645, 10.303806, -1.089710>, <-3.352321, 10.303806, -1.070621>, <-3.377703, 10.303806, -1.046110>, <-3.397816, 10.303806, -1.017118>, <-3.411886, 10.303806, -0.984760>, <-3.419372, 10.303806, -0.950278>, <-3.258164, 10.303806, -1.146881>, <-3.300232, 10.303806, -1.139273>, <-3.340009, 10.303806, -1.123605>, 
			<-3.375964, 10.303806, -1.100478>, <-3.406716, 10.303806, -1.070781>, <-3.431084, 10.303806, -1.035654>, <-3.448131, 10.303806, -0.996449>, <-3.457202, 10.303806, -0.954672>, <-3.261001, 10.318451, -1.181951>, <-3.309857, 10.318451, -1.173117>, <-3.356051, 10.318451, -1.154920>, <-3.397807, 10.318451, -1.128062>, <-3.433521, 10.318451, -1.093573>, <-3.461821, 10.318451, -1.052780>, 
			<-3.481618, 10.318451, -1.007249>, <-3.492152, 10.318451, -0.958731>, <-3.263172, 10.345510, -1.208793>, <-3.317223, 10.345510, -1.199019>, <-3.368329, 10.345510, -1.178888>, <-3.414525, 10.345510, -1.149174>, <-3.454037, 10.345510, -1.111018>, <-3.485345, 10.345510, -1.065887>, <-3.507247, 10.345510, -1.015515>, <-3.518902, 10.345510, -0.961838>, <-3.264347, 10.380866, -1.223320>, 
			<-3.321210, 10.380866, -1.213037>, <-3.374974, 10.380866, -1.191859>, <-3.423573, 10.380866, -1.160599>, <-3.465139, 10.380866, -1.120459>, <-3.498077, 10.380866, -1.072980>, <-3.521118, 10.380866, -1.019988>, <-3.533379, 10.380866, -0.963519>, <-3.547200, 10.380866, -0.334772>, <-3.547200, 10.419134, -0.334772>, <-3.532557, 10.454490, -0.334517>, <-3.505501, 10.481549, -0.334045>, 
			<-3.470151, 10.496194, -0.333428>, <-3.431889, 10.496194, -0.332760>, <-3.396539, 10.481549, -0.332143>, <-3.369483, 10.454490, -0.331670>, <-3.354841, 10.419134, -0.331415>, <-3.354841, 10.380866, -0.331415>, <-3.369483, 10.345510, -0.331670>, <-3.396539, 10.318451, -0.332143>, <-3.431889, 10.303806, -0.332760>, <-3.470151, 10.303806, -0.333428>, <-3.505501, 10.318451, -0.334045>, 
			<-3.532557, 10.345510, -0.334517>, <-2.246878, 10.419134, -0.941063>, <-2.257160, 10.419134, -0.997926>, <-2.278338, 10.419134, -1.051690>, <-2.309598, 10.419134, -1.100289>, <-2.349739, 10.419134, -1.141855>, <-2.397218, 10.419134, -1.174792>, <-2.450209, 10.419134, -1.197834>, <-2.506678, 10.419134, -1.210095>, <-2.261405, 10.454490, -0.939888>, <-2.271179, 10.454490, -0.993939>, 
			<-2.291310, 10.454490, -1.045045>, <-2.321024, 10.454490, -1.091241>, <-2.359180, 10.454490, -1.130752>, <-2.404311, 10.454490, -1.162061>, <-2.454683, 10.454490, -1.183963>, <-2.508360, 10.454490, -1.195618>, <-2.288246, 10.481549, -0.937717>, <-2.297081, 10.481549, -0.986573>, <-2.315277, 10.481549, -1.032767>, <-2.342136, 10.481549, -1.074523>, <-2.376625, 10.481549, -1.110237>, 
			<-2.417418, 10.481549, -1.138536>, <-2.462949, 10.481549, -1.158334>, <-2.511467, 10.481549, -1.168868>, <-2.323317, 10.496194, -0.934880>, <-2.330924, 10.496194, -0.976948>, <-2.346593, 10.496194, -1.016725>, <-2.369720, 10.496194, -1.052680>, <-2.399417, 10.496194, -1.083432>, <-2.434543, 10.496194, -1.107800>, <-2.473748, 10.496194, -1.124847>, <-2.515526, 10.496194, -1.133918>, 
			<-2.361277, 10.496194, -0.931809>, <-2.367556, 10.496194, -0.966531>, <-2.380488, 10.496194, -0.999361>, <-2.399576, 10.496194, -1.029037>, <-2.424087, 10.496194, -1.054419>, <-2.453079, 10.496194, -1.074531>, <-2.485438, 10.496194, -1.088601>, <-2.519920, 10.496194, -1.096088>, <-2.396348, 10.481549, -0.928972>, <-2.401399, 10.481549, -0.956906>, <-2.411803, 10.481549, -0.983319>, 
			<-2.427160, 10.481549, -1.007194>, <-2.446880, 10.481549, -1.027614>, <-2.470205, 10.481549, -1.043795>, <-2.496238, 10.481549, -1.055115>, <-2.523979, 10.481549, -1.061138>, <-2.423189, 10.454490, -0.926800>, <-2.427301, 10.454490, -0.949540>, <-2.435771, 10.454490, -0.971041>, <-2.448272, 10.454490, -0.990476>, <-2.464324, 10.454490, -1.007099>, <-2.483312, 10.454490, -1.020271>, 
			<-2.504504, 10.454490, -1.029485>, <-2.527086, 10.454490, -1.034388>, <-2.437716, 10.419134, -0.925625>, <-2.441320, 10.419134, -0.945553>, <-2.448742, 10.419134, -0.964396>, <-2.459697, 10.419134, -0.981428>, <-2.473765, 10.419134, -0.995996>, <-2.490405, 10.419134, -1.007539>, <-2.508977, 10.419134, -1.015615>, <-2.528767, 10.419134, -1.019911>, <-2.437716, 10.380866, -0.925625>, 
			<-2.441320, 10.380866, -0.945553>, <-2.448742, 10.380866, -0.964396>, <-2.459697, 10.380866, -0.981428>, <-2.473765, 10.380866, -0.995996>, <-2.490405, 10.380866, -1.007539>, <-2.508977, 10.380866, -1.015615>, <-2.528767, 10.380866, -1.019911>, <-2.423189, 10.345510, -0.926800>, <-2.427301, 10.345510, -0.949540>, <-2.435771, 10.345510, -0.971041>, <-2.448272, 10.345510, -0.990476>, 
			<-2.464324, 10.345510, -1.007099>, <-2.483312, 10.345510, -1.020271>, <-2.504504, 10.345510, -1.029485>, <-2.527086, 10.345510, -1.034388>, <-2.396348, 10.318451, -0.928972>, <-2.401399, 10.318451, -0.956906>, <-2.411803, 10.318451, -0.983319>, <-2.427160, 10.318451, -1.007194>, <-2.446880, 10.318451, -1.027614>, <-2.470205, 10.318451, -1.043795>, <-2.496238, 10.318451, -1.055115>, 
			<-2.523979, 10.318451, -1.061138>, <-2.361277, 10.303806, -0.931809>, <-2.367556, 10.303806, -0.966531>, <-2.380488, 10.303806, -0.999361>, <-2.399576, 10.303806, -1.029037>, <-2.424087, 10.303806, -1.054419>, <-2.453079, 10.303806, -1.074531>, <-2.485438, 10.303806, -1.088601>, <-2.519920, 10.303806, -1.096088>, <-2.323317, 10.303806, -0.934880>, <-2.330924, 10.303806, -0.976948>, 
			<-2.346593, 10.303806, -1.016725>, <-2.369720, 10.303806, -1.052680>, <-2.399417, 10.303806, -1.083432>, <-2.434543, 10.303806, -1.107800>, <-2.473748, 10.303806, -1.124847>, <-2.515526, 10.303806, -1.133918>, <-2.288246, 10.318451, -0.937717>, <-2.297081, 10.318451, -0.986573>, <-2.315277, 10.318451, -1.032767>, <-2.342136, 10.318451, -1.074523>, <-2.376625, 10.318451, -1.110237>, 
			<-2.417418, 10.318451, -1.138536>, <-2.462949, 10.318451, -1.158334>, <-2.511467, 10.318451, -1.168868>, <-2.261405, 10.345510, -0.939888>, <-2.271179, 10.345510, -0.993939>, <-2.291310, 10.345510, -1.045045>, <-2.321024, 10.345510, -1.091241>, <-2.359180, 10.345510, -1.130752>, <-2.404311, 10.345510, -1.162061>, <-2.454683, 10.345510, -1.183963>, <-2.508360, 10.345510, -1.195618>, 
			<-2.246878, 10.380866, -0.941063>, <-2.257160, 10.380866, -0.997926>, <-2.278338, 10.380866, -1.051690>, <-2.309598, 10.380866, -1.100289>, <-2.349739, 10.380866, -1.141855>, <-2.397218, 10.380866, -1.174792>, <-2.450209, 10.380866, -1.197834>, <-2.506678, 10.380866, -1.210095>, <-2.342462, 10.400000, -0.813820>, <-2.885463, 10.419134, -1.219552>, <-2.885719, 10.454490, -1.204910>, 
			<-2.886191, 10.481549, -1.177854>, <-2.886808, 10.496194, -1.142504>, <-2.887476, 10.496194, -1.104242>, <-2.888093, 10.481549, -1.068892>, <-2.888565, 10.454490, -1.041836>, <-2.888821, 10.419134, -1.027194>, <-2.888821, 10.380866, -1.027194>, <-2.888565, 10.345510, -1.041836>, <-2.888093, 10.318451, -1.068892>, <-2.887476, 10.303806, -1.104242>, <-2.886808, 10.303806, -1.142504>, 
			<-2.886191, 10.318451, -1.177854>, <-2.885719, 10.345510, -1.204910>, <-2.885463, 10.380866, -1.219552>, <-2.245191, 10.419134, -0.874632>, <-2.245191, 10.380866, -0.874632>, <-2.259834, 10.345510, -0.874887>, <-2.286890, 10.318451, -0.875359>, <-2.322240, 10.303806, -0.875976>, <-2.360502, 10.303806, -0.876644>, <-2.395852, 10.318451, -0.877261>, <-2.422908, 10.345510, -0.877734>, 
			<-2.437550, 10.380866, -0.877989>, <-2.437550, 10.419134, -0.877989>, <-2.422908, 10.454490, -0.877734>, <-2.395852, 10.481549, -0.877261>, <-2.360502, 10.496194, -0.876644>, <-2.322240, 10.496194, -0.875976>, <-2.286890, 10.481549, -0.875359>, <-2.259834, 10.454490, -0.874887>, <-2.246064, 10.419134, -0.824639>, <-2.246064, 10.380866, -0.824639>, <-2.260707, 10.345510, -0.824895>, 
			<-2.287762, 10.318451, -0.825367>, <-2.323112, 10.303806, -0.825984>, <-2.361375, 10.303806, -0.826652>, <-2.396725, 10.318451, -0.827269>, <-2.423780, 10.345510, -0.827741>, <-2.438423, 10.380866, -0.827997>, <-2.438423, 10.419134, -0.827997>, <-2.423780, 10.454490, -0.827741>, <-2.396725, 10.481549, -0.827269>, <-2.361375, 10.496194, -0.826652>, <-2.323112, 10.496194, -0.825984>, 
			<-2.287762, 10.481549, -0.825367>, <-2.260707, 10.454490, -0.824895>, <-2.258305, 10.416742, -0.812351>, <-2.258305, 10.383258, -0.812351>, <-2.271117, 10.352322, -0.812575>, <-2.294790, 10.328644, -0.812988>, <-2.325722, 10.315830, -0.813528>, <-2.359201, 10.315830, -0.814112>, <-2.390133, 10.328644, -0.814652>, <-2.413806, 10.352322, -0.815065>, <-2.426618, 10.383258, -0.815289>, 
			<-2.426618, 10.416742, -0.815289>, <-2.413806, 10.447678, -0.815065>, <-2.390133, 10.471356, -0.814652>, <-2.359201, 10.484170, -0.814112>, <-2.325722, 10.484170, -0.813528>, <-2.294790, 10.471356, -0.812988>, <-2.271117, 10.447678, -0.812575>, <-3.295530, 10.419134, 0.563105>, <-3.351999, 10.419134, 0.550844>, <-3.404990, 10.419134, 0.527803>, <-3.452469, 10.419134, 0.494866>, 
			<-3.492610, 10.419134, 0.453299>, <-3.523870, 10.419134, 0.404700>, <-3.545048, 10.419134, 0.350936>, <-3.555330, 10.419134, 0.294074>, <-3.293848, 10.454490, 0.548628>, <-3.347525, 10.454490, 0.536974>, <-3.397897, 10.454490, 0.515071>, <-3.443028, 10.454490, 0.483763>, <-3.481184, 10.454490, 0.444251>, <-3.510898, 10.454490, 0.398055>, <-3.531029, 10.454490, 0.346949>, 
			<-3.540803, 10.454490, 0.292899>, <-3.290741, 10.481549, 0.521878>, <-3.339259, 10.481549, 0.511344>, <-3.384790, 10.481549, 0.491547>, <-3.425583, 10.481549, 0.463247>, <-3.460072, 10.481549, 0.427533>, <-3.486931, 10.481549, 0.385777>, <-3.505127, 10.481549, 0.339583>, <-3.513962, 10.481549, 0.290727>, <-3.286682, 10.496194, 0.486928>, <-3.328460, 10.496194, 0.477857>, 
			<-3.367665, 10.496194, 0.460811>, <-3.402791, 10.496194, 0.436443>, <-3.432488, 10.496194, 0.405690>, <-3.455615, 10.496194, 0.369735>, <-3.471284, 10.496194, 0.329959>, <-3.478891, 10.496194, 0.287890>, <-3.282288, 10.496194, 0.449098>, <-3.316770, 10.496194, 0.441612>, <-3.349129, 10.496194, 0.427542>, <-3.378121, 10.496194, 0.407429>, <-3.402632, 10.496194, 0.382047>, 
			<-3.421720, 10.496194, 0.352371>, <-3.434652, 10.496194, 0.319541>, <-3.440931, 10.496194, 0.284819>, <-3.278229, 10.481549, 0.414148>, <-3.305970, 10.481549, 0.408125>, <-3.332003, 10.481549, 0.396806>, <-3.355328, 10.481549, 0.380625>, <-3.375048, 10.481549, 0.360204>, <-3.390405, 10.481549, 0.336329>, <-3.400809, 10.481549, 0.309917>, <-3.405860, 10.481549, 0.281982>, 
			<-3.275122, 10.454490, 0.387399>, <-3.297704, 10.454490, 0.382496>, <-3.318896, 10.454490, 0.373281>, <-3.337884, 10.454490, 0.360109>, <-3.353936, 10.454490, 0.343486>, <-3.366437, 10.454490, 0.324051>, <-3.374907, 10.454490, 0.302550>, <-3.379019, 10.454490, 0.279811>, <-3.273441, 10.419134, 0.372922>, <-3.293231, 10.419134, 0.368625>, <-3.311803, 10.419134, 0.360550>, 
			<-3.328443, 10.419134, 0.349006>, <-3.342510, 10.419134, 0.334439>, <-3.353466, 10.419134, 0.317406>, <-3.360888, 10.419134, 0.298564>, <-3.364492, 10.419134, 0.278635>, <-3.273441, 10.380866, 0.372922>, <-3.293231, 10.380866, 0.368625>, <-3.311803, 10.380866, 0.360550>, <-3.328443, 10.380866, 0.349006>, <-3.342510, 10.380866, 0.334439>, <-3.353466, 10.380866, 0.317406>, 
			<-3.360888, 10.380866, 0.298564>, <-3.364492, 10.380866, 0.278635>, <-3.275122, 10.345510, 0.387399>, <-3.297704, 10.345510, 0.382496>, <-3.318896, 10.345510, 0.373281>, <-3.337884, 10.345510, 0.360109>, <-3.353936, 10.345510, 0.343486>, <-3.366437, 10.345510, 0.324051>, <-3.374907, 10.345510, 0.302550>, <-3.379019, 10.345510, 0.279811>, <-3.278229, 10.318451, 0.414148>, 
			<-3.305970, 10.318451, 0.408125>, <-3.332003, 10.318451, 0.396806>, <-3.355328, 10.318451, 0.380625>, <-3.375048, 10.318451, 0.360204>, <-3.390405, 10.318451, 0.336329>, <-3.400809, 10.318451, 0.309917>, <-3.405860, 10.318451, 0.281982>, <-3.282288, 10.303806, 0.449098>, <-3.316770, 10.303806, 0.441612>, <-3.349129, 10.303806, 0.427542>, <-3.378121, 10.303806, 0.407429>, 
			<-3.402632, 10.303806, 0.382047>, <-3.421720, 10.303806, 0.352371>, <-3.434652, 10.303806, 0.319541>, <-3.440931, 10.303806, 0.284819>, <-3.286682, 10.303806, 0.486928>, <-3.328460, 10.303806, 0.477857>, <-3.367665, 10.303806, 0.460811>, <-3.402791, 10.303806, 0.436443>, <-3.432488, 10.303806, 0.405690>, <-3.455615, 10.303806, 0.369735>, <-3.471284, 10.303806, 0.329959>, 
			<-3.478891, 10.303806, 0.287890>, <-3.290741, 10.318451, 0.521878>, <-3.339259, 10.318451, 0.511344>, <-3.384790, 10.318451, 0.491547>, <-3.425583, 10.318451, 0.463247>, <-3.460072, 10.318451, 0.427533>, <-3.486931, 10.318451, 0.385777>, <-3.505127, 10.318451, 0.339583>, <-3.513962, 10.318451, 0.290727>, <-3.293848, 10.345510, 0.548628>, <-3.347525, 10.345510, 0.536974>, 
			<-3.397897, 10.345510, 0.515071>, <-3.443028, 10.345510, 0.483763>, <-3.481184, 10.345510, 0.444251>, <-3.510898, 10.345510, 0.398055>, <-3.531029, 10.345510, 0.346949>, <-3.540803, 10.345510, 0.292899>, <-3.295530, 10.380866, 0.563105>, <-3.351999, 10.380866, 0.550844>, <-3.404990, 10.380866, 0.527803>, <-3.452469, 10.380866, 0.494866>, <-3.492610, 10.380866, 0.453299>, 
			<-3.523870, 10.380866, 0.404700>, <-3.545048, 10.380866, 0.350936>, <-3.555330, 10.380866, 0.294074>, <-2.268829, 10.419134, 0.316530>, <-2.281090, 10.419134, 0.372999>, <-2.304131, 10.419134, 0.425990>, <-2.337068, 10.419134, 0.473469>, <-2.378635, 10.419134, 0.513610>, <-2.427234, 10.419134, 0.544870>, <-2.480998, 10.419134, 0.566048>, <-2.537860, 10.419134, 0.576330>, 
			<-2.283306, 10.454490, 0.314848>, <-2.294961, 10.454490, 0.368525>, <-2.316863, 10.454490, 0.418897>, <-2.348171, 10.454490, 0.464028>, <-2.387683, 10.454490, 0.502184>, <-2.433879, 10.454490, 0.531898>, <-2.484985, 10.454490, 0.552029>, <-2.539036, 10.454490, 0.561803>, <-2.310056, 10.481549, 0.311741>, <-2.320590, 10.481549, 0.360259>, <-2.340387, 10.481549, 0.405790>, 
			<-2.368687, 10.481549, 0.446583>, <-2.404401, 10.481549, 0.481072>, <-2.446157, 10.481549, 0.507931>, <-2.492351, 10.481549, 0.526127>, <-2.541207, 10.481549, 0.534962>, <-2.345006, 10.496194, 0.307682>, <-2.354077, 10.496194, 0.349460>, <-2.371124, 10.496194, 0.388665>, <-2.395492, 10.496194, 0.423791>, <-2.426244, 10.496194, 0.453488>, <-2.462199, 10.496194, 0.476615>, 
			<-2.501976, 10.496194, 0.492284>, <-2.544044, 10.496194, 0.499891>, <-2.382836, 10.496194, 0.303288>, <-2.390322, 10.496194, 0.337770>, <-2.404392, 10.496194, 0.370129>, <-2.424505, 10.496194, 0.399121>, <-2.449887, 10.496194, 0.423632>, <-2.479563, 10.496194, 0.442720>, <-2.512393, 10.496194, 0.455652>, <-2.547115, 10.496194, 0.461931>, <-2.417786, 10.481549, 0.299229>, 
			<-2.423809, 10.481549, 0.326970>, <-2.435129, 10.481549, 0.353003>, <-2.451310, 10.481549, 0.376328>, <-2.471730, 10.481549, 0.396048>, <-2.495605, 10.481549, 0.411405>, <-2.522018, 10.481549, 0.421809>, <-2.549952, 10.481549, 0.426860>, <-2.444536, 10.454490, 0.296122>, <-2.449439, 10.454490, 0.318704>, <-2.458653, 10.454490, 0.339896>, <-2.471825, 10.454490, 0.358884>, 
			<-2.488448, 10.454490, 0.374936>, <-2.507883, 10.454490, 0.387437>, <-2.529384, 10.454490, 0.395907>, <-2.552124, 10.454490, 0.400019>, <-2.459012, 10.419134, 0.294441>, <-2.463309, 10.419134, 0.314231>, <-2.471385, 10.419134, 0.332803>, <-2.482928, 10.419134, 0.349443>, <-2.497496, 10.419134, 0.363511>, <-2.514528, 10.419134, 0.374466>, <-2.533370, 10.419134, 0.381888>, 
			<-2.553299, 10.419134, 0.385492>, <-2.459012, 10.380866, 0.294441>, <-2.463309, 10.380866, 0.314231>, <-2.471385, 10.380866, 0.332803>, <-2.482928, 10.380866, 0.349443>, <-2.497496, 10.380866, 0.363511>, <-2.514528, 10.380866, 0.374466>, <-2.533370, 10.380866, 0.381888>, <-2.553299, 10.380866, 0.385492>, <-2.444536, 10.345510, 0.296122>, <-2.449439, 10.345510, 0.318704>, 
			<-2.458653, 10.345510, 0.339896>, <-2.471825, 10.345510, 0.358884>, <-2.488448, 10.345510, 0.374936>, <-2.507883, 10.345510, 0.387437>, <-2.529384, 10.345510, 0.395907>, <-2.552124, 10.345510, 0.400019>, <-2.417786, 10.318451, 0.299229>, <-2.423809, 10.318451, 0.326970>, <-2.435129, 10.318451, 0.353003>, <-2.451310, 10.318451, 0.376328>, <-2.471730, 10.318451, 0.396048>, 
			<-2.495605, 10.318451, 0.411405>, <-2.522018, 10.318451, 0.421809>, <-2.549952, 10.318451, 0.426860>, <-2.382836, 10.303806, 0.303288>, <-2.390322, 10.303806, 0.337770>, <-2.404392, 10.303806, 0.370129>, <-2.424505, 10.303806, 0.399121>, <-2.449887, 10.303806, 0.423632>, <-2.479563, 10.303806, 0.442720>, <-2.512393, 10.303806, 0.455652>, <-2.547115, 10.303806, 0.461931>, 
			<-2.345006, 10.303806, 0.307682>, <-2.354077, 10.303806, 0.349460>, <-2.371124, 10.303806, 0.388665>, <-2.395492, 10.303806, 0.423791>, <-2.426244, 10.303806, 0.453488>, <-2.462199, 10.303806, 0.476615>, <-2.501976, 10.303806, 0.492284>, <-2.544044, 10.303806, 0.499891>, <-2.310056, 10.318451, 0.311741>, <-2.320590, 10.318451, 0.360259>, <-2.340387, 10.318451, 0.405790>, 
			<-2.368687, 10.318451, 0.446583>, <-2.404401, 10.318451, 0.481072>, <-2.446157, 10.318451, 0.507931>, <-2.492351, 10.318451, 0.526127>, <-2.541207, 10.318451, 0.534962>, <-2.283306, 10.345510, 0.314848>, <-2.294961, 10.345510, 0.368525>, <-2.316863, 10.345510, 0.418897>, <-2.348171, 10.345510, 0.464028>, <-2.387683, 10.345510, 0.502184>, <-2.433879, 10.345510, 0.531898>, 
			<-2.484985, 10.345510, 0.552029>, <-2.539036, 10.345510, 0.561803>, <-2.268829, 10.380866, 0.316530>, <-2.281090, 10.380866, 0.372999>, <-2.304131, 10.380866, 0.425990>, <-2.337068, 10.380866, 0.473469>, <-2.378635, 10.380866, 0.513610>, <-2.427234, 10.380866, 0.544870>, <-2.480998, 10.380866, 0.566048>, <-2.537860, 10.380866, 0.576330>, <-2.359914, 10.400000, 0.186028>, 
			<-2.916745, 10.419134, 0.572563>, <-2.916489, 10.454490, 0.557920>, <-2.916017, 10.481549, 0.530865>, <-2.915400, 10.496194, 0.495515>, <-2.914732, 10.496194, 0.457252>, <-2.914115, 10.481549, 0.421902>, <-2.913643, 10.454490, 0.394846>, <-2.913387, 10.419134, 0.380204>, <-2.913387, 10.380866, 0.380204>, <-2.913643, 10.345510, 0.394846>, <-2.914115, 10.318451, 0.421902>, 
			<-2.914732, 10.303806, 0.457252>, <-2.915400, 10.303806, 0.495515>, <-2.916017, 10.318451, 0.530865>, <-2.916489, 10.345510, 0.557920>, <-2.916745, 10.380866, 0.572563>, <-2.264825, 10.419134, 0.250197>, <-2.264825, 10.380866, 0.250197>, <-2.279468, 10.345510, 0.249942>, <-2.306524, 10.318451, 0.249469>, <-2.341873, 10.303806, 0.248852>, <-2.380136, 10.303806, 0.248184>, 
			<-2.415486, 10.318451, 0.247567>, <-2.442542, 10.345510, 0.247095>, <-2.457184, 10.380866, 0.246840>, <-2.457184, 10.419134, 0.246840>, <-2.442542, 10.454490, 0.247095>, <-2.415486, 10.481549, 0.247567>, <-2.380136, 10.496194, 0.248184>, <-2.341873, 10.496194, 0.248852>, <-2.306524, 10.481549, 0.249469>, <-2.279468, 10.454490, 0.249942>, <-2.263953, 10.419134, 0.200205>, 
			<-2.263953, 10.380866, 0.200205>, <-2.278595, 10.345510, 0.199949>, <-2.305651, 10.318451, 0.199477>, <-2.341001, 10.303806, 0.198860>, <-2.379263, 10.303806, 0.198192>, <-2.414613, 10.318451, 0.197575>, <-2.441669, 10.345510, 0.197103>, <-2.456311, 10.380866, 0.196847>, <-2.456311, 10.419134, 0.196847>, <-2.441669, 10.454490, 0.197103>, <-2.414613, 10.481549, 0.197575>, 
			<-2.379263, 10.496194, 0.198192>, <-2.341001, 10.496194, 0.198860>, <-2.305651, 10.481549, 0.199477>, <-2.278595, 10.454490, 0.199949>, <-2.275757, 10.416742, 0.187497>, <-2.275757, 10.383258, 0.187497>, <-2.288569, 10.352322, 0.187273>, <-2.312243, 10.328644, 0.186860>, <-2.343174, 10.315830, 0.186320>, <-2.376654, 10.315830, 0.185736>, <-2.407585, 10.328644, 0.185196>, 
			<-2.431259, 10.352322, 0.184783>, <-2.444071, 10.383258, 0.184559>, <-2.444071, 10.416742, 0.184559>, <-2.431259, 10.447678, 0.184783>, <-2.407585, 10.471356, 0.185196>, <-2.376654, 10.484170, 0.185736>, <-2.343174, 10.484170, 0.186320>, <-2.312243, 10.471356, 0.186860>, <-2.288569, 10.447678, 0.187273>}
	 //#local average_center = <-3.125607, 10.141737, -0.327414>;
	 normal_vectors { 9130, <0.721245, -0.020840, -0.692367>, <0.604564, 0.237174, -0.760428>, <0.489302, 0.454997, -0.744017>, <0.294829, 0.651912, -0.698632>, <0.010074, 0.816569, -0.577161>, <-0.223678, 0.591203, -0.774885>, <-0.441796, 0.476243, -0.760269>, <-0.639534, 0.282586, -0.714942>, <-0.696642, -0.020837, -0.717116>, <-0.639532, -0.282592, -0.714941>, 
			<-0.441796, -0.476243, -0.760269>, <-0.223678, -0.591203, -0.774885>, <0.010074, -0.816569, -0.577161>, <0.294829, -0.651912, -0.698632>, <0.489302, -0.454997, -0.744017>, <0.604567, -0.237167, -0.760428>, <0.647406, -0.006325, -0.762119>, <0.707691, -0.132435, -0.693999>, <0.661802, -0.281641, -0.694764>, <0.594385, -0.402955, -0.695941>, <0.551386, -0.555134, -0.622736>, 
			<0.400766, -0.591851, -0.699356>, <0.277855, -0.656271, -0.701502>, <0.144740, -0.695471, -0.703825>, <0.018114, -0.707945, -0.706036>, <-0.120089, -0.695471, -0.708448>, <-0.280336, -0.697940, -0.659008>, <-0.390569, -0.582149, -0.713133>, <-0.544016, -0.540433, -0.641856>, <-0.579435, -0.388499, -0.716466>, <-0.643846, -0.265570, -0.717590>, <-0.683040, -0.132435, -0.718274>, 
			<-0.620414, -0.006325, -0.784249>, <-0.683040, 0.132435, -0.718274>, <-0.643846, 0.265570, -0.717590>, <-0.579435, 0.388499, -0.716466>, <-0.544016, 0.540433, -0.641856>, <-0.390569, 0.582149, -0.713133>, <-0.280336, 0.697940, -0.659008>, <-0.120089, 0.695471, -0.708448>, <0.018114, 0.707945, -0.706036>, <0.144740, 0.695471, -0.703825>, <0.277855, 0.656271, -0.701502>, 
			<0.400766, 0.591851, -0.699356>, <0.551386, 0.555134, -0.622736>, <0.594385, 0.402955, -0.695941>, <0.661802, 0.281641, -0.694764>, <0.707691, 0.132435, -0.693999>, <0.719906, 0.005677, -0.694048>, <-0.695245, 0.005677, -0.718750>, <-0.805107, 0.021172, -0.592752>, <0.825303, 0.021173, -0.564293>, <0.620414, -0.006325, 0.784249>, <0.683040, -0.132435, 0.718274>, 
			<0.643846, -0.265570, 0.717590>, <0.579435, -0.388499, 0.716466>, <0.544016, -0.540433, 0.641856>, <0.390569, -0.582149, 0.713133>, <0.280336, -0.697940, 0.659008>, <0.120089, -0.695471, 0.708448>, <-0.014189, -0.582244, 0.812890>, <-0.144740, -0.695471, 0.703825>, <-0.277855, -0.656271, 0.701502>, <-0.400766, -0.591851, 0.699356>, <-0.551386, -0.555134, 0.622736>, 
			<-0.594385, -0.402955, 0.695941>, <-0.661802, -0.281641, 0.694764>, <-0.707691, -0.132435, 0.693999>, <-0.647406, -0.006325, 0.762119>, <-0.707691, 0.132435, 0.693999>, <-0.661802, 0.281641, 0.694764>, <-0.594385, 0.402955, 0.695941>, <-0.551386, 0.555134, 0.622736>, <-0.400766, 0.591851, 0.699356>, <-0.277855, 0.656271, 0.701502>, <-0.144740, 0.695471, 0.703825>, 
			<-0.014189, 0.582244, 0.812890>, <0.120089, 0.695471, 0.708448>, <0.280336, 0.697940, 0.659008>, <0.390569, 0.582149, 0.713133>, <0.544016, 0.540433, 0.641856>, <0.579435, 0.388499, 0.716466>, <0.643846, 0.265570, 0.717590>, <0.683040, 0.132435, 0.718274>, <0.695245, 0.005677, 0.718750>, <-0.719906, 0.005677, 0.694048>, <-0.825303, 0.021172, 0.564293>, 
			<-0.721245, -0.020837, 0.692367>, <-0.604567, -0.237167, 0.760428>, <-0.489302, -0.454997, 0.744017>, <-0.294829, -0.651912, 0.698632>, <-0.000678, -0.710431, 0.703767>, <0.223678, -0.591203, 0.774885>, <0.441796, -0.476243, 0.760269>, <0.639532, -0.282592, 0.714941>, <0.696642, -0.020840, 0.717116>, <0.805107, 0.021173, 0.592752>, <0.639529, 0.282598, 0.714941>, 
			<0.441796, 0.476243, 0.760269>, <0.223678, 0.591203, 0.774885>, <-0.000678, 0.710431, 0.703767>, <-0.294829, 0.651912, 0.698632>, <-0.489302, 0.454997, 0.744017>, <-0.604569, 0.237161, 0.760428>, <0.721245, -0.020840, -0.692367>, <0.604564, 0.237174, -0.760428>, <0.489302, 0.454997, -0.744017>, <0.294829, 0.651912, -0.698632>, <0.010074, 0.816569, -0.577161>, 
			<-0.223678, 0.591203, -0.774885>, <-0.441796, 0.476243, -0.760269>, <-0.639534, 0.282586, -0.714942>, <-0.696642, -0.020837, -0.717116>, <-0.639532, -0.282592, -0.714941>, <-0.441796, -0.476243, -0.760269>, <-0.223678, -0.591203, -0.774885>, <0.010074, -0.816569, -0.577161>, <0.294829, -0.651912, -0.698632>, <0.489302, -0.454997, -0.744017>, <0.604567, -0.237167, -0.760428>, 
			<0.647406, -0.006325, -0.762119>, <0.707691, -0.132435, -0.693999>, <0.661802, -0.281641, -0.694764>, <0.594385, -0.402955, -0.695941>, <0.551386, -0.555134, -0.622736>, <0.400766, -0.591851, -0.699356>, <0.277855, -0.656271, -0.701502>, <0.144740, -0.695471, -0.703825>, <0.018114, -0.707945, -0.706036>, <-0.120089, -0.695471, -0.708448>, <-0.280336, -0.697940, -0.659008>, 
			<-0.390569, -0.582149, -0.713133>, <-0.544016, -0.540433, -0.641856>, <-0.579435, -0.388499, -0.716466>, <-0.643846, -0.265570, -0.717590>, <-0.683040, -0.132435, -0.718274>, <-0.620414, -0.006325, -0.784249>, <-0.683040, 0.132435, -0.718274>, <-0.643846, 0.265570, -0.717590>, <-0.579435, 0.388499, -0.716466>, <-0.544016, 0.540433, -0.641856>, <-0.390569, 0.582149, -0.713133>, 
			<-0.280336, 0.697940, -0.659008>, <-0.120089, 0.695471, -0.708448>, <0.018114, 0.707945, -0.706036>, <0.144740, 0.695471, -0.703825>, <0.277855, 0.656271, -0.701502>, <0.400766, 0.591851, -0.699356>, <0.551386, 0.555134, -0.622736>, <0.594385, 0.402955, -0.695941>, <0.661802, 0.281641, -0.694764>, <0.707691, 0.132435, -0.693999>, <0.719906, 0.005677, -0.694048>, 
			<-0.695245, 0.005677, -0.718750>, <-0.805107, 0.021172, -0.592752>, <0.825303, 0.021173, -0.564293>, <0.620414, -0.006325, 0.784249>, <0.683040, -0.132435, 0.718274>, <0.643846, -0.265570, 0.717590>, <0.579435, -0.388499, 0.716466>, <0.544016, -0.540433, 0.641856>, <0.390569, -0.582149, 0.713133>, <0.280336, -0.697940, 0.659008>, <0.120089, -0.695471, 0.708448>, 
			<-0.014189, -0.582244, 0.812890>, <-0.144740, -0.695471, 0.703825>, <-0.277855, -0.656271, 0.701502>, <-0.400766, -0.591851, 0.699356>, <-0.551386, -0.555134, 0.622736>, <-0.594385, -0.402955, 0.695941>, <-0.661802, -0.281641, 0.694764>, <-0.707691, -0.132435, 0.693999>, <-0.647406, -0.006325, 0.762119>, <-0.707691, 0.132435, 0.693999>, <-0.661802, 0.281641, 0.694764>, 
			<-0.594385, 0.402955, 0.695941>, <-0.551386, 0.555134, 0.622736>, <-0.400766, 0.591851, 0.699356>, <-0.277855, 0.656271, 0.701502>, <-0.144740, 0.695471, 0.703825>, <-0.014189, 0.582244, 0.812890>, <0.120089, 0.695471, 0.708448>, <0.280336, 0.697940, 0.659008>, <0.390569, 0.582149, 0.713133>, <0.544016, 0.540433, 0.641856>, <0.579435, 0.388499, 0.716466>, 
			<0.643846, 0.265570, 0.717590>, <0.683040, 0.132435, 0.718274>, <0.695245, 0.005677, 0.718750>, <-0.719906, 0.005677, 0.694048>, <-0.825303, 0.021172, 0.564293>, <-0.721245, -0.020837, 0.692367>, <-0.604567, -0.237167, 0.760428>, <-0.489302, -0.454997, 0.744017>, <-0.294829, -0.651912, 0.698632>, <-0.000678, -0.710431, 0.703767>, <0.223678, -0.591203, 0.774885>, 
			<0.441796, -0.476243, 0.760269>, <0.639532, -0.282592, 0.714941>, <0.696642, -0.020840, 0.717116>, <0.805107, 0.021173, 0.592752>, <0.639529, 0.282598, 0.714941>, <0.441796, 0.476243, 0.760269>, <0.223678, 0.591203, 0.774885>, <-0.000678, 0.710431, 0.703767>, <-0.294829, 0.651912, 0.698632>, <-0.489302, 0.454997, 0.744017>, <-0.604569, 0.237161, 0.760428>, 
			<-0.999655, -0.000000, -0.026283>, <0.003503, 0.000000, -0.999994>, <-0.177944, 0.000000, -0.984041>, <-0.357250, -0.019791, -0.933799>, <-0.540974, -0.000000, -0.841039>, <-0.689512, 0.014138, -0.724136>, <-0.821647, -0.000000, -0.569997>, <-0.917060, 0.000000, -0.398749>, <-0.974903, -0.019791, -0.221748>, <-0.924033, 0.381657, -0.022375>, <0.006206, 0.381710, -0.924261>, 
			<-0.163902, 0.381151, -0.909868>, <-0.338259, 0.381151, -0.860410>, <-0.512072, 0.362736, -0.778591>, <-0.641775, 0.381151, -0.665469>, <-0.760246, 0.362736, -0.538933>, <-0.850194, 0.368016, -0.376477>, <-0.903594, 0.381151, -0.195556>, <-0.707928, 0.706086, -0.016742>, <0.005352, 0.706135, -0.708057>, <-0.124988, 0.705444, -0.697658>, <-0.258693, 0.705444, -0.659869>, 
			<-0.382456, 0.705444, -0.596721>, <-0.508317, 0.681572, -0.526378>, <-0.583010, 0.705444, -0.403049>, <-0.650439, 0.705444, -0.281565>, <-0.692871, 0.705444, -0.149260>, <-0.383443, 0.923523, -0.008731>, <0.003412, 0.923538, -0.383491>, <-0.066882, 0.923241, -0.378356>, <-0.139410, 0.923241, -0.358038>, <-0.206581, 0.923241, -0.323961>, <-0.288077, 0.909957, -0.298312>, 
			<-0.316554, 0.923241, -0.217761>, <-0.352955, 0.923241, -0.151821>, <-0.375792, 0.923241, -0.080045>, <0.000143, 1.000000, 0.000117>, <0.000181, 1.000000, 0.000140>, <0.001614, 0.999999, -0.000292>, <0.001526, 0.999999, -0.000601>, <0.001380, 0.999999, -0.000887>, <-0.023128, 0.999446, -0.023949>, <-0.000935, 0.999999, 0.001348>, <-0.000654, 0.999999, 0.001504>, 
			<-0.000348, 0.999999, 0.001603>, <0.383664, 0.923435, 0.008298>, <-0.004075, 0.923451, 0.383695>, <0.069857, 0.923241, 0.377818>, <0.142223, 0.923241, 0.356930>, <0.209124, 0.923241, 0.322325>, <0.245432, 0.935505, 0.254152>, <0.314831, 0.923241, 0.220246>, <0.351749, 0.923241, 0.154594>, <0.375150, 0.923241, 0.083000>, <0.708017, 0.706043, 0.014696>, 
			<-0.008498, 0.706073, 0.708088>, <0.127252, 0.705444, 0.697249>, <0.260834, 0.705444, 0.659026>, <0.384391, 0.705444, 0.595477>, <0.475843, 0.728540, 0.492750>, <0.581699, 0.705444, 0.404939>, <0.649521, 0.705444, 0.283674>, <0.692383, 0.705444, 0.151508>, <0.924058, 0.381794, 0.018700>, <-0.011863, 0.381815, 0.924162>, <0.165120, 0.381151, 0.909648>, 
			<0.339411, 0.381151, 0.859956>, <0.500658, 0.381151, 0.777216>, <0.654129, 0.362736, 0.663731>, <0.759623, 0.381151, 0.526969>, <0.853787, 0.381107, 0.354690>, <0.903331, 0.381151, 0.196766>, <0.999812, -0.000000, 0.019370>, <-0.014254, 0.000000, 0.999898>, <0.177944, -0.000000, 0.984041>, <0.366501, 0.000000, 0.930418>, <0.540974, 0.000000, 0.841039>, 
			<0.694658, -0.000000, 0.719340>, <0.817535, -0.014138, 0.575705>, <0.917060, 0.000000, 0.398749>, <0.975617, -0.014138, 0.219025>, <0.924058, -0.381794, 0.018700>, <-0.011863, -0.381815, 0.924162>, <0.165120, -0.381151, 0.909648>, <0.324678, -0.381107, 0.865645>, <0.487318, -0.381107, 0.785671>, <0.640497, -0.362736, 0.676894>, <0.759270, -0.381151, 0.527478>, 
			<0.847587, -0.381151, 0.369216>, <0.903331, -0.381151, 0.196766>, <0.708017, -0.706043, 0.014696>, <-0.008498, -0.706073, 0.708088>, <0.127252, -0.705444, 0.697249>, <0.260834, -0.705444, 0.659026>, <0.384391, -0.705444, 0.595477>, <0.475843, -0.728540, 0.492750>, <0.581699, -0.705444, 0.404939>, <0.649521, -0.705444, 0.283674>, <0.692383, -0.705444, 0.151508>, 
			<0.383664, -0.923435, 0.008298>, <-0.004075, -0.923451, 0.383695>, <0.069857, -0.923241, 0.377818>, <0.142223, -0.923241, 0.356930>, <0.209124, -0.923241, 0.322325>, <0.245432, -0.935505, 0.254152>, <0.314831, -0.923241, 0.220246>, <0.351749, -0.923241, 0.154594>, <0.375150, -0.923241, 0.083000>, <0.000143, -1.000000, 0.000117>, <0.000181, -1.000000, 0.000140>, 
			<0.001614, -0.999999, -0.000292>, <0.001526, -0.999999, -0.000601>, <0.001380, -0.999999, -0.000887>, <-0.023128, -0.999446, -0.023949>, <-0.000935, -0.999999, 0.001348>, <-0.000654, -0.999999, 0.001504>, <-0.000348, -0.999999, 0.001603>, <-0.383443, -0.923523, -0.008731>, <0.003412, -0.923538, -0.383491>, <-0.066882, -0.923241, -0.378356>, <-0.139410, -0.923241, -0.358038>, 
			<-0.206581, -0.923241, -0.323961>, <-0.288077, -0.909957, -0.298312>, <-0.316554, -0.923241, -0.217761>, <-0.352955, -0.923241, -0.151821>, <-0.375792, -0.923241, -0.080045>, <-0.707928, -0.706086, -0.016742>, <0.005352, -0.706135, -0.708057>, <-0.124988, -0.705444, -0.697658>, <-0.258693, -0.705444, -0.659869>, <-0.382456, -0.705444, -0.596721>, <-0.508317, -0.681572, -0.526378>, 
			<-0.583010, -0.705444, -0.403049>, <-0.650439, -0.705444, -0.281565>, <-0.692871, -0.705444, -0.149260>, <-0.924033, -0.381657, -0.022375>, <0.006206, -0.381710, -0.924261>, <-0.163902, -0.381151, -0.909868>, <-0.352915, -0.381107, -0.854522>, <-0.512072, -0.362736, -0.778591>, <-0.642666, -0.381151, -0.664609>, <-0.759976, -0.381151, -0.526461>, <-0.848080, -0.381151, -0.368081>, 
			<-0.903594, -0.381151, -0.195556>, <0.999384, -0.000000, -0.035087>, <0.984041, -0.000000, -0.177944>, <0.930418, 0.000000, -0.366501>, <0.841039, 0.000000, -0.540974>, <0.719340, 0.000000, -0.694658>, <0.575705, 0.014138, -0.817535>, <0.398749, -0.000000, -0.917060>, <0.196110, -0.000000, -0.980582>, <0.031398, 0.000000, -0.999507>, <0.923894, 0.381881, -0.024212>, 
			<0.909868, 0.381151, -0.163902>, <0.860410, 0.381151, -0.338259>, <0.766292, 0.399384, -0.503278>, <0.665469, 0.381151, -0.641775>, <0.538933, 0.362736, -0.760246>, <0.382522, 0.381107, -0.841685>, <0.195556, 0.381151, -0.903594>, <0.026054, 0.381710, -0.923915>, <0.707703, 0.706299, -0.017236>, <0.697658, 0.705444, -0.124988>, <0.659869, 0.705444, -0.258693>, 
			<0.596721, 0.705444, -0.382456>, <0.526378, 0.681572, -0.508317>, <0.403049, 0.705444, -0.583010>, <0.281565, 0.705444, -0.650439>, <0.149260, 0.705444, -0.692871>, <0.019362, 0.706135, -0.707813>, <0.383285, 0.923595, -0.008055>, <0.378356, 0.923241, -0.066882>, <0.358038, 0.923241, -0.139410>, <0.323961, 0.923241, -0.206581>, <0.298312, 0.909957, -0.288077>, 
			<0.217761, 0.923241, -0.316554>, <0.151821, 0.923241, -0.352955>, <0.080045, 0.923241, -0.375792>, <0.009974, 0.923538, -0.383376>, <-0.000075, 1.000000, 0.000697>, <0.000292, 0.999999, 0.001614>, <0.000601, 0.999999, 0.001526>, <0.000887, 0.999999, 0.001380>, <0.023949, 0.999446, -0.023128>, <-0.001348, 0.999999, -0.000935>, <-0.001504, 0.999999, -0.000654>, 
			<-0.001603, 0.999999, -0.000348>, <-0.000186, 1.000000, 0.000134>, <-0.383430, 0.923546, 0.006695>, <-0.377818, 0.923241, 0.069857>, <-0.356930, 0.923241, 0.142223>, <-0.322325, 0.923241, 0.209124>, <-0.254152, 0.935505, 0.245432>, <-0.220246, 0.923241, 0.314831>, <-0.154594, 0.923241, 0.351749>, <-0.083000, 0.923241, 0.375150>, <-0.009319, 0.923451, 0.383604>, 
			<-0.707864, 0.706291, 0.009043>, <-0.697249, 0.705444, 0.127252>, <-0.659026, 0.705444, 0.260834>, <-0.595477, 0.705444, 0.384391>, <-0.492750, 0.728540, 0.475843>, <-0.404939, 0.705444, 0.581699>, <-0.283674, 0.705444, 0.649521>, <-0.151508, 0.705444, 0.692383>, <-0.016219, 0.706073, 0.707953>, <-0.924126, 0.381985, 0.008880>, <-0.909648, 0.381151, 0.165120>, 
			<-0.859956, 0.381151, 0.339411>, <-0.777216, 0.381151, 0.500658>, <-0.665515, 0.399384, 0.630541>, <-0.515365, 0.399384, 0.758216>, <-0.365036, 0.368016, 0.855169>, <-0.196766, 0.381151, 0.903331>, <-0.020397, 0.381815, 0.924014>, <-0.999997, 0.000000, 0.002456>, <-0.980988, 0.000000, 0.194071>, <-0.933799, 0.019791, 0.357250>, <-0.841039, 0.000000, 0.540974>, 
			<-0.726004, 0.019791, 0.687405>, <-0.569997, 0.000000, 0.821647>, <-0.398749, -0.000000, 0.917060>, <-0.202503, -0.019791, 0.979082>, <-0.020651, -0.000000, 0.999787>, <-0.924126, -0.381985, 0.008880>, <-0.909648, -0.381151, 0.165120>, <-0.856153, -0.399384, 0.327863>, <-0.766542, -0.411471, 0.493057>, <-0.676894, -0.362736, 0.640497>, <-0.527478, -0.381151, 0.759270>, 
			<-0.369216, -0.381151, 0.847587>, <-0.196766, -0.381151, 0.903331>, <-0.020397, -0.381815, 0.924014>, <-0.707864, -0.706291, 0.009043>, <-0.697249, -0.705444, 0.127252>, <-0.659026, -0.705444, 0.260834>, <-0.595477, -0.705444, 0.384391>, <-0.492750, -0.728540, 0.475843>, <-0.404939, -0.705444, 0.581699>, <-0.283674, -0.705444, 0.649521>, <-0.151508, -0.705444, 0.692383>, 
			<-0.016219, -0.706073, 0.707953>, <-0.383430, -0.923546, 0.006695>, <-0.377818, -0.923241, 0.069857>, <-0.356930, -0.923241, 0.142223>, <-0.322325, -0.923241, 0.209124>, <-0.254152, -0.935505, 0.245432>, <-0.220246, -0.923241, 0.314831>, <-0.154594, -0.923241, 0.351749>, <-0.083000, -0.923241, 0.375150>, <-0.009319, -0.923451, 0.383604>, <-0.000075, -1.000000, 0.000697>, 
			<0.000292, -0.999999, 0.001614>, <0.000601, -0.999999, 0.001526>, <0.000887, -0.999999, 0.001380>, <0.023949, -0.999446, -0.023128>, <-0.001348, -0.999999, -0.000935>, <-0.001504, -0.999999, -0.000654>, <-0.001603, -0.999999, -0.000348>, <-0.000186, -1.000000, 0.000134>, <0.383285, -0.923595, -0.008055>, <0.378356, -0.923241, -0.066882>, <0.358038, -0.923241, -0.139410>, 
			<0.323961, -0.923241, -0.206581>, <0.298312, -0.909957, -0.288077>, <0.217761, -0.923241, -0.316554>, <0.151821, -0.923241, -0.352955>, <0.080045, -0.923241, -0.375792>, <0.009974, -0.923538, -0.383376>, <0.707703, -0.706299, -0.017236>, <0.697658, -0.705444, -0.124988>, <0.659869, -0.705444, -0.258693>, <0.596721, -0.705444, -0.382456>, <0.526378, -0.681572, -0.508317>, 
			<0.403049, -0.705444, -0.583010>, <0.281565, -0.705444, -0.650439>, <0.149260, -0.705444, -0.692871>, <0.019362, -0.706135, -0.707813>, <0.923894, -0.381881, -0.024212>, <0.909868, -0.381151, -0.163902>, <0.862815, -0.368016, -0.346576>, <0.769253, -0.381107, -0.512842>, <0.656374, -0.394193, -0.643262>, <0.526461, -0.381151, -0.759976>, <0.368081, -0.381151, -0.848080>, 
			<0.195556, -0.381151, -0.903594>, <0.026054, -0.381710, -0.923915>, <0.923739, 0.382683, 0.016124>, <0.999848, -0.000000, 0.017452>, <0.923739, -0.382683, 0.016124>, <0.706999, -0.707107, 0.012341>, <0.382625, -0.923880, 0.006679>, <0.000000, -1.000000, -0.000000>, <-0.382625, -0.923880, -0.006679>, <-0.706999, -0.707107, -0.012341>, <-0.923739, -0.382683, -0.016124>, 
			<-0.999848, 0.000000, -0.017452>, <-0.923739, 0.382683, -0.016124>, <-0.706999, 0.707107, -0.012341>, <-0.382625, 0.923880, -0.006679>, <0.000000, 1.000000, -0.000000>, <0.382625, 0.923880, 0.006679>, <0.706999, 0.707107, 0.012341>, <0.648412, 0.261149, 0.715097>, <0.571004, 0.000000, 0.820947>, <0.648412, -0.261149, 0.715097>, <0.553077, -0.534453, 0.639113>, 
			<0.283694, -0.699096, 0.656341>, <-0.014151, -0.585244, 0.810734>, <-0.273390, -0.660794, 0.699006>, <-0.545356, -0.564147, 0.619940>, <-0.710356, -0.295105, 0.638989>, <-0.722603, -0.011605, 0.691165>, <-0.710356, 0.295105, 0.638989>, <-0.545356, 0.564147, 0.619940>, <-0.273390, 0.660794, 0.699006>, <-0.014151, 0.585244, 0.810734>, <0.283694, 0.699096, 0.656341>, 
			<0.553077, 0.534453, 0.639113>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.999963, -0.000000, -0.008620>, <-0.031398, -0.000000, 0.999507>, <-0.212178, -0.000000, 0.977231>, <-0.398749, -0.000000, 0.917060>, <-0.575705, 0.014138, 0.817535>, 
			<-0.718949, 0.032975, 0.694281>, <-0.841039, 0.000000, 0.540974>, <-0.930418, -0.000000, 0.366501>, <-0.982048, 0.019791, 0.187590>, <-0.924251, 0.381657, -0.009887>, <-0.026054, 0.381710, 0.923915>, <-0.195556, 0.381151, 0.903594>, <-0.382522, 0.381107, 0.841685>, <-0.538933, 0.362736, 0.760246>, <-0.665777, 0.394193, 0.633524>, <-0.766292, 0.399384, 0.503278>, 
			<-0.862815, 0.368016, 0.346576>, <-0.909868, 0.381151, 0.163902>, <-0.708081, 0.706086, -0.007974>, <-0.019362, 0.706135, 0.707813>, <-0.149260, 0.705444, 0.692871>, <-0.281565, 0.705444, 0.650439>, <-0.403049, 0.705444, 0.583010>, <-0.526378, 0.681572, 0.508317>, <-0.596721, 0.705444, 0.382456>, <-0.659869, 0.705444, 0.258693>, <-0.697658, 0.705444, 0.124988>, 
			<-0.383514, 0.923523, -0.004656>, <-0.009974, 0.923538, 0.383376>, <-0.080045, 0.923241, 0.375792>, <-0.151821, 0.923241, 0.352955>, <-0.217761, 0.923241, 0.316554>, <-0.298312, 0.909957, 0.288077>, <-0.323961, 0.923241, 0.206581>, <-0.358038, 0.923241, 0.139410>, <-0.378356, 0.923241, 0.066882>, <0.000147, 1.000000, -0.000112>, <0.000186, 1.000000, -0.000134>, 
			<0.001603, 0.999999, 0.000348>, <0.001504, 0.999999, 0.000654>, <0.001348, 0.999999, 0.000935>, <-0.023949, 0.999446, 0.023128>, <-0.000887, 0.999999, -0.001380>, <-0.000601, 0.999999, -0.001526>, <-0.000292, 0.999999, -0.001614>, <0.383720, 0.923435, 0.005097>, <0.009319, 0.923451, -0.383604>, <0.083000, 0.923241, -0.375150>, <0.154594, 0.923241, -0.351749>, 
			<0.220246, 0.923241, -0.314831>, <0.254152, 0.935505, -0.245432>, <0.322325, 0.923241, -0.209124>, <0.356930, 0.923241, -0.142223>, <0.377818, 0.923241, -0.069857>, <0.708098, 0.706043, 0.010022>, <0.016219, 0.706073, -0.707953>, <0.151508, 0.705444, -0.692383>, <0.283674, 0.705444, -0.649521>, <0.404939, 0.705444, -0.581699>, <0.492750, 0.728540, -0.475843>, 
			<0.595477, 0.705444, -0.384391>, <0.659026, 0.705444, -0.260834>, <0.697249, 0.705444, -0.127252>, <0.924148, 0.381794, 0.013561>, <0.020397, 0.381815, -0.924014>, <0.196766, 0.381151, -0.903331>, <0.369216, 0.381151, -0.847587>, <0.518267, 0.394193, -0.758954>, <0.664609, 0.381151, -0.642666>, <0.785372, 0.368016, -0.497751>, <0.856153, 0.399384, -0.327863>, 
			<0.909648, 0.381151, -0.165120>, <0.999879, 0.000000, 0.015534>, <0.020651, -0.000000, -0.999787>, <0.202503, -0.019791, -0.979082>, <0.398749, -0.000000, -0.917060>, <0.564146, 0.014138, -0.825554>, <0.719340, -0.000000, -0.694658>, <0.846160, 0.019791, -0.532561>, <0.930418, 0.000000, -0.366501>, <0.984041, 0.000000, -0.177944>, <0.924148, -0.381794, 0.013561>, 
			<0.020397, -0.381815, -0.924014>, <0.196766, -0.381151, -0.903331>, <0.369216, -0.381151, -0.847587>, <0.524857, -0.368016, -0.767522>, <0.676894, -0.362736, -0.640497>, <0.777551, -0.381151, -0.500138>, <0.865645, -0.381107, -0.324678>, <0.909648, -0.381151, -0.165120>, <0.708098, -0.706043, 0.010022>, <0.016219, -0.706073, -0.707953>, <0.151508, -0.705444, -0.692383>, 
			<0.283674, -0.705444, -0.649521>, <0.404939, -0.705444, -0.581699>, <0.492750, -0.728540, -0.475843>, <0.595477, -0.705444, -0.384391>, <0.659026, -0.705444, -0.260834>, <0.697249, -0.705444, -0.127252>, <0.383720, -0.923435, 0.005097>, <0.009319, -0.923451, -0.383604>, <0.083000, -0.923241, -0.375150>, <0.154594, -0.923241, -0.351749>, <0.220246, -0.923241, -0.314831>, 
			<0.254152, -0.935505, -0.245432>, <0.322325, -0.923241, -0.209124>, <0.356930, -0.923241, -0.142223>, <0.377818, -0.923241, -0.069857>, <0.000147, -1.000000, -0.000112>, <0.000186, -1.000000, -0.000134>, <0.001603, -0.999999, 0.000348>, <0.001504, -0.999999, 0.000654>, <0.001348, -0.999999, 0.000935>, <-0.023949, -0.999446, 0.023128>, <-0.000887, -0.999999, -0.001380>, 
			<-0.000601, -0.999999, -0.001526>, <-0.000292, -0.999999, -0.001614>, <-0.383514, -0.923523, -0.004656>, <-0.009974, -0.923538, 0.383376>, <-0.080045, -0.923241, 0.375792>, <-0.151821, -0.923241, 0.352955>, <-0.217761, -0.923241, 0.316554>, <-0.298312, -0.909957, 0.288077>, <-0.323961, -0.923241, 0.206581>, <-0.358038, -0.923241, 0.139410>, <-0.378356, -0.923241, 0.066882>, 
			<-0.708081, -0.706086, -0.007974>, <-0.019362, -0.706135, 0.707813>, <-0.149260, -0.705444, 0.692871>, <-0.281565, -0.705444, 0.650439>, <-0.403049, -0.705444, 0.583010>, <-0.526378, -0.681572, 0.508317>, <-0.596721, -0.705444, 0.382456>, <-0.659869, -0.705444, 0.258693>, <-0.697658, -0.705444, 0.124988>, <-0.924251, -0.381657, -0.009887>, <-0.026054, -0.381710, 0.923915>, 
			<-0.195556, -0.381151, 0.903594>, <-0.368081, -0.381151, 0.848080>, <-0.529715, -0.399384, 0.748261>, <-0.665515, -0.399384, 0.630541>, <-0.777551, -0.381151, 0.500138>, <-0.854522, -0.381107, 0.352915>, <-0.909868, -0.381151, 0.163902>, <0.997551, 0.000000, 0.069944>, <0.977231, 0.000000, 0.212178>, <0.917060, 0.000000, 0.398749>, <0.821647, 0.000000, 0.569997>, 
			<0.687405, -0.019791, 0.726004>, <0.540974, -0.000000, 0.841039>, <0.357250, -0.019791, 0.933799>, <0.170999, 0.014138, 0.985170>, <-0.006331, -0.000000, 0.999980>, <0.922487, 0.381881, 0.056440>, <0.903594, 0.381151, 0.195556>, <0.841685, 0.381107, 0.382522>, <0.760246, 0.362736, 0.538933>, <0.641775, 0.381151, 0.665469>, <0.503278, 0.399384, 0.766292>, 
			<0.338259, 0.381151, 0.860410>, <0.163902, 0.381151, 0.909868>, <-0.006206, 0.381710, 0.924261>, <0.706671, 0.706299, 0.041924>, <0.692871, 0.705444, 0.149260>, <0.650439, 0.705444, 0.281565>, <0.583010, 0.705444, 0.403049>, <0.508317, 0.681572, 0.526378>, <0.382456, 0.705444, 0.596721>, <0.258693, 0.705444, 0.659869>, <0.124988, 0.705444, 0.697658>, 
			<-0.005352, 0.706135, 0.708057>, <0.382771, 0.923595, 0.021427>, <0.375792, 0.923241, 0.080045>, <0.352955, 0.923241, 0.151821>, <0.316554, 0.923241, 0.217761>, <0.288077, 0.909957, 0.298312>, <0.206581, 0.923241, 0.323961>, <0.139410, 0.923241, 0.358038>, <0.066882, 0.923241, 0.378356>, <-0.003412, 0.923538, 0.383491>, <-0.000051, 1.000000, -0.000700>, 
			<0.000348, 0.999999, -0.001603>, <0.000654, 0.999999, -0.001504>, <0.000935, 0.999999, -0.001348>, <0.023128, 0.999446, 0.023949>, <-0.001380, 0.999999, 0.000887>, <-0.001526, 0.999999, 0.000601>, <-0.001614, 0.999999, 0.000292>, <-0.000181, 1.000000, -0.000140>, <-0.382963, 0.923546, -0.020072>, <-0.375150, 0.923241, -0.083000>, <-0.351749, 0.923241, -0.154594>, 
			<-0.314831, 0.923241, -0.220246>, <-0.245432, 0.935505, -0.254152>, <-0.209124, 0.923241, -0.322325>, <-0.142223, 0.923241, -0.356930>, <-0.069857, 0.923241, -0.377818>, <0.004075, 0.923451, -0.383695>, <-0.707117, 0.706291, -0.033741>, <-0.692383, 0.705444, -0.151508>, <-0.649521, 0.705444, -0.283674>, <-0.581699, 0.705444, -0.404939>, <-0.475843, 0.728540, -0.492750>, 
			<-0.384391, 0.705444, -0.595477>, <-0.260834, 0.705444, -0.659026>, <-0.127252, 0.705444, -0.697249>, <0.008498, 0.706073, -0.708088>, <-0.923253, 0.381985, -0.041127>, <-0.903331, 0.381151, -0.196766>, <-0.853787, 0.381107, -0.354690>, <-0.758216, 0.399384, -0.515365>, <-0.642666, 0.381151, -0.664609>, <-0.500658, 0.381151, -0.777216>, <-0.339411, 0.381151, -0.859956>, 
			<-0.165120, 0.381151, -0.909648>, <0.011863, 0.381815, -0.924162>, <-0.999302, -0.000000, -0.037354>, <-0.977231, 0.000000, -0.212178>, <-0.912910, 0.019791, -0.407682>, <-0.821200, 0.032975, -0.569687>, <-0.699632, 0.014138, -0.714364>, <-0.549124, -0.019791, -0.835507>, <-0.366501, 0.000000, -0.930418>, <-0.187590, -0.019791, -0.982048>, <0.013125, 0.000000, -0.999914>, 
			<-0.923253, -0.381985, -0.041127>, <-0.903331, -0.381151, -0.196766>, <-0.847587, -0.381151, -0.369216>, <-0.759270, -0.381151, -0.527478>, <-0.641775, -0.381151, -0.665469>, <-0.491465, -0.394193, -0.776579>, <-0.324678, -0.381107, -0.865645>, <-0.165120, -0.381151, -0.909648>, <0.011863, -0.381815, -0.924162>, <-0.707117, -0.706291, -0.033741>, <-0.692383, -0.705444, -0.151508>, 
			<-0.649521, -0.705444, -0.283674>, <-0.581699, -0.705444, -0.404939>, <-0.475843, -0.728540, -0.492750>, <-0.384391, -0.705444, -0.595477>, <-0.260834, -0.705444, -0.659026>, <-0.127252, -0.705444, -0.697249>, <0.008498, -0.706073, -0.708088>, <-0.382963, -0.923546, -0.020072>, <-0.375150, -0.923241, -0.083000>, <-0.351749, -0.923241, -0.154594>, <-0.314831, -0.923241, -0.220246>, 
			<-0.245432, -0.935505, -0.254152>, <-0.209124, -0.923241, -0.322325>, <-0.142223, -0.923241, -0.356930>, <-0.069857, -0.923241, -0.377818>, <0.004075, -0.923451, -0.383695>, <-0.000051, -1.000000, -0.000700>, <0.000348, -0.999999, -0.001603>, <0.000654, -0.999999, -0.001504>, <0.000935, -0.999999, -0.001348>, <0.023128, -0.999446, 0.023949>, <-0.001380, -0.999999, 0.000887>, 
			<-0.001526, -0.999999, 0.000601>, <-0.001614, -0.999999, 0.000292>, <-0.000181, -1.000000, -0.000140>, <0.382771, -0.923595, 0.021427>, <0.375792, -0.923241, 0.080045>, <0.352955, -0.923241, 0.151821>, <0.316554, -0.923241, 0.217761>, <0.288077, -0.909957, 0.298312>, <0.206581, -0.923241, 0.323961>, <0.139410, -0.923241, 0.358038>, <0.066882, -0.923241, 0.378356>, 
			<-0.003412, -0.923538, 0.383491>, <0.706671, -0.706299, 0.041924>, <0.692871, -0.705444, 0.149260>, <0.650439, -0.705444, 0.281565>, <0.583010, -0.705444, 0.403049>, <0.508317, -0.681572, 0.526378>, <0.382456, -0.705444, 0.596721>, <0.258693, -0.705444, 0.659869>, <0.124988, -0.705444, 0.697658>, <-0.005352, -0.706135, 0.708057>, <0.922487, -0.381881, 0.056440>, 
			<0.903594, -0.381151, 0.195556>, <0.848080, -0.381151, 0.368081>, <0.771047, -0.362736, 0.523363>, <0.642666, -0.381151, 0.664609>, <0.512072, -0.362736, 0.778591>, <0.352915, -0.381107, 0.854522>, <0.163902, -0.381151, 0.909868>, <-0.006206, -0.381710, 0.924261>, <0.923739, 0.382683, 0.016124>, <0.999848, 0.000000, 0.017452>, <0.923739, -0.382683, 0.016124>, 
			<0.706999, -0.707107, 0.012341>, <0.382625, -0.923880, 0.006679>, <0.000000, -1.000000, 0.000000>, <-0.382625, -0.923880, -0.006679>, <-0.706999, -0.707107, -0.012341>, <-0.923739, -0.382683, -0.016124>, <-0.999848, -0.000000, -0.017452>, <-0.923739, 0.382683, -0.016124>, <-0.706999, 0.707107, -0.012341>, <-0.382625, 0.923880, -0.006679>, <-0.000000, 1.000000, 0.000000>, 
			<0.382625, 0.923880, 0.006679>, <0.706999, 0.707107, 0.012341>, <0.710356, 0.295105, -0.638989>, <0.650317, 0.007130, -0.759630>, <0.710356, -0.295105, -0.638989>, <0.545356, -0.564147, -0.619940>, <0.273390, -0.660794, -0.699006>, <0.023884, -0.710431, -0.703362>, <-0.283694, -0.699096, -0.656341>, <-0.553077, -0.534453, -0.639113>, <-0.648412, -0.261149, -0.715097>, 
			<-0.645254, -0.015023, -0.763821>, <-0.648412, 0.261149, -0.715097>, <-0.553077, 0.534453, -0.639113>, <-0.283694, 0.699096, -0.656341>, <0.023884, 0.710431, -0.703362>, <0.273390, 0.660794, -0.699006>, <0.545356, 0.564147, -0.619940>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.179603, -0.005787, -0.983722>, <0.708773, 0.134698, -0.692457>, <0.165724, 0.067373, -0.983868>, 
			<0.615653, 0.375453, -0.692825>, <0.109445, 0.092155, -0.989712>, <0.416413, 0.584435, -0.696445>, <0.084580, 0.148528, -0.985285>, <0.162030, 0.694627, -0.700885>, <0.017219, 0.163007, -0.986475>, <-0.137471, 0.694627, -0.706113>, <-0.050143, 0.148528, -0.987636>, <-0.363117, 0.603469, -0.709910>, <-0.074838, 0.092155, -0.992928>, <-0.572068, 0.404194, -0.713699>, 
			<-0.131287, 0.067371, -0.989052>, <-0.695320, -0.000634, -0.718700>, <-0.145162, -0.005787, -0.989391>, <-0.684177, -0.134690, -0.716771>, <-0.131287, -0.067372, -0.989052>, <-0.572067, -0.404195, -0.713699>, <-0.074838, -0.092155, -0.992928>, <-0.363117, -0.603469, -0.709910>, <-0.050143, -0.148528, -0.987636>, <-0.137471, -0.694627, -0.706113>, <0.017219, -0.163007, -0.986475>, 
			<0.162030, -0.694627, -0.700885>, <0.084580, -0.148528, -0.985285>, <0.416413, -0.584435, -0.696445>, <0.109445, -0.092155, -0.989712>, <0.615654, -0.375451, -0.692825>, <0.165724, -0.067372, -0.983868>, <0.708775, -0.134691, -0.692457>, <0.718110, -0.050130, -0.694121>, <0.668246, -0.000326, -0.743941>, <0.734491, -0.221969, -0.641290>, <0.631103, -0.343907, -0.695296>, 
			<0.552131, -0.458035, -0.696675>, <0.456922, -0.550907, -0.698372>, <0.340919, -0.627071, -0.700397>, <0.212288, -0.679137, -0.702642>, <0.071251, -0.579445, -0.811891>, <-0.051322, -0.705105, -0.707244>, <-0.187637, -0.679137, -0.709623>, <-0.331530, -0.618872, -0.712099>, <-0.445640, -0.539888, -0.714091>, <-0.538498, -0.444664, -0.715747>, <-0.614650, -0.328643, -0.717077>, 
			<-0.666708, -0.199993, -0.717985>, <-0.693448, -0.050130, -0.718760>, <-0.641876, -0.000326, -0.766809>, <-0.666708, 0.199993, -0.717985>, <-0.614650, 0.328643, -0.717077>, <-0.538498, 0.444664, -0.715747>, <-0.445640, 0.539888, -0.714091>, <-0.331530, 0.618872, -0.712099>, <-0.187637, 0.679137, -0.709623>, <-0.051322, 0.705105, -0.707244>, <0.071251, 0.579445, -0.811891>, 
			<0.212288, 0.679137, -0.702642>, <0.340919, 0.627071, -0.700397>, <0.456922, 0.550907, -0.698372>, <0.552131, 0.458035, -0.696675>, <0.631103, 0.343907, -0.695296>, <0.734491, 0.221969, -0.641290>, <0.718110, 0.050130, -0.694121>, <-0.693448, 0.050130, -0.718760>, <0.992791, 0.010200, -0.119423>, <0.986191, -0.010181, -0.165300>, <0.967580, -0.208460, -0.142594>, 
			<0.914538, -0.378175, -0.143541>, <0.823252, -0.548810, -0.145135>, <0.700435, -0.698355, -0.147278>, <0.550809, -0.821062, -0.149890>, <0.380122, -0.912216, -0.152869>, <0.194934, -0.968315, -0.156102>, <-0.013418, -0.987072, -0.159718>, <-0.205645, -0.964944, -0.163073>, <-0.386468, -0.912476, -0.134278>, <-0.545944, -0.820593, -0.169034>, <-0.695465, -0.697758, -0.171644>, 
			<-0.818154, -0.548109, -0.173785>, <-0.909294, -0.377396, -0.175376>, <-0.965384, -0.192180, -0.176355>, <-0.979821, -0.010181, -0.199617>, <-0.965384, 0.192180, -0.176355>, <-0.909294, 0.377396, -0.175376>, <-0.818154, 0.548109, -0.173785>, <-0.695465, 0.697758, -0.171644>, <-0.545944, 0.820593, -0.169034>, <-0.386468, 0.912476, -0.134278>, <-0.205645, 0.964944, -0.163073>, 
			<-0.013418, 0.987072, -0.159718>, <0.194934, 0.968315, -0.156102>, <0.380122, 0.912216, -0.152869>, <0.550809, 0.821062, -0.149890>, <0.700435, 0.698355, -0.147278>, <0.823252, 0.548810, -0.145135>, <0.914538, 0.378175, -0.143541>, <0.967580, 0.208460, -0.142594>, <-0.977971, 0.010500, -0.208475>, <0.175511, -0.028797, -0.984056>, <0.177600, -0.001073, -0.984102>, 
			<0.177600, 0.001073, -0.984102>, <0.175511, 0.028797, -0.984056>, <0.166852, 0.059129, -0.984207>, <0.152444, 0.087188, -0.984459>, <0.147117, 0.129982, -0.980541>, <0.104399, 0.135239, -0.985297>, <0.076345, 0.149650, -0.985787>, <0.046018, 0.158310, -0.986317>, <0.020291, 0.192963, -0.980996>, <-0.011568, 0.158310, -0.987322>, <-0.041895, 0.149650, -0.987851>, 
			<-0.069949, 0.135239, -0.988341>, <-0.112807, 0.129982, -0.985078>, <-0.117994, 0.087188, -0.989179>, <-0.132402, 0.059129, -0.989431>, <-0.141061, 0.028797, -0.989582>, <-0.143147, 0.001073, -0.989701>, <-0.143147, -0.001073, -0.989701>, <-0.141061, -0.028797, -0.989582>, <-0.132402, -0.059129, -0.989431>, <-0.117994, -0.087188, -0.989179>, <-0.112807, -0.129982, -0.985078>, 
			<-0.069949, -0.135239, -0.988341>, <-0.041895, -0.149650, -0.987851>, <-0.011568, -0.158310, -0.987322>, <0.020291, -0.192963, -0.980996>, <0.046018, -0.158310, -0.986317>, <0.076345, -0.149650, -0.985787>, <0.104399, -0.135239, -0.985297>, <0.147117, -0.129982, -0.980541>, <0.152444, -0.087188, -0.984459>, <0.166852, -0.059129, -0.984207>, <-0.684179, 0.134683, -0.716771>, 
			<0.719979, -0.000637, -0.693996>, <0.202048, 0.005257, -0.979362>, <-0.198409, 0.006125, -0.980100>, <-0.992075, 0.025093, -0.123118>, <-0.983972, -0.025136, -0.176540>, <-0.909163, -0.378674, -0.173289>, <-0.694857, -0.698875, -0.169549>, <-0.359929, -0.914227, -0.186120>, <0.022317, -0.991847, -0.125463>, <0.381364, -0.912048, -0.150763>, <0.701516, -0.697710, -0.145175>, 
			<0.917226, -0.363122, -0.163827>, <0.989678, -0.018695, -0.142087>, <0.989602, 0.024916, -0.141656>, <0.917222, 0.363133, -0.163827>, <0.701516, 0.697710, -0.145175>, <0.381364, 0.912048, -0.150763>, <0.022317, 0.991847, -0.125463>, <-0.359929, 0.914227, -0.186120>, <-0.694857, 0.698875, -0.169549>, <-0.909166, 0.378665, -0.173289>, <0.693448, -0.050130, 0.718760>, 
			<0.641876, -0.000326, 0.766809>, <0.666708, -0.199993, 0.717985>, <0.614650, -0.328643, 0.717077>, <0.538498, -0.444664, 0.715747>, <0.445640, -0.539888, 0.714091>, <0.331530, -0.618872, 0.712099>, <0.187637, -0.679137, 0.709623>, <0.051322, -0.705105, 0.707244>, <-0.075973, -0.705105, 0.705022>, <-0.212288, -0.679137, 0.702642>, <-0.340919, -0.627071, 0.700397>, 
			<-0.456922, -0.550907, 0.698372>, <-0.552131, -0.458035, 0.696675>, <-0.631103, -0.343907, 0.695296>, <-0.734491, -0.221969, 0.641290>, <-0.718110, -0.050130, 0.694121>, <-0.668246, -0.000326, 0.743941>, <-0.734491, 0.221969, 0.641290>, <-0.631103, 0.343907, 0.695296>, <-0.552131, 0.458035, 0.696675>, <-0.456922, 0.550907, 0.698372>, <-0.340919, 0.627071, 0.700397>, 
			<-0.212288, 0.679137, 0.702642>, <-0.075973, 0.705105, 0.705022>, <0.051322, 0.705105, 0.707244>, <0.187637, 0.679137, 0.709623>, <0.331530, 0.618872, 0.712099>, <0.445640, 0.539888, 0.714091>, <0.538498, 0.444664, 0.715747>, <0.614650, 0.328643, 0.717077>, <0.666708, 0.199993, 0.717985>, <0.693448, 0.050130, 0.718760>, <-0.718110, 0.050130, 0.694121>, 
			<0.988018, 0.010200, 0.153998>, <0.984182, -0.009183, 0.176922>, <0.965384, -0.192180, 0.176355>, <0.909294, -0.377396, 0.175376>, <0.818154, -0.548109, 0.173785>, <0.695465, -0.697758, 0.171644>, <0.545944, -0.820593, 0.169034>, <0.386468, -0.912476, 0.134278>, <0.205645, -0.964944, 0.163073>, <0.003943, -0.983234, 0.182305>, <-0.194934, -0.968315, 0.156102>, 
			<-0.380122, -0.912216, 0.152869>, <-0.550809, -0.821062, 0.149890>, <-0.700435, -0.698355, 0.147278>, <-0.823252, -0.548810, 0.145135>, <-0.914538, -0.378175, 0.143541>, <-0.967580, -0.208460, 0.142594>, <-0.986191, -0.010181, 0.165300>, <-0.967580, 0.208460, 0.142594>, <-0.914538, 0.378175, 0.143541>, <-0.823252, 0.548810, 0.145135>, <-0.700435, 0.698355, 0.147278>, 
			<-0.550809, 0.821062, 0.149890>, <-0.380122, 0.912216, 0.152869>, <-0.194934, 0.968315, 0.156102>, <0.003943, 0.983234, 0.182305>, <0.205645, 0.964944, 0.163073>, <0.386468, 0.912476, 0.134278>, <0.545944, 0.820593, 0.169034>, <0.695465, 0.697758, 0.171644>, <0.818154, 0.548109, 0.173785>, <0.909294, 0.377396, 0.175376>, <0.965384, 0.192180, 0.176355>, 
			<-0.992791, 0.010200, 0.119423>, <-0.999813, 0.008300, -0.017452>, <0.980636, 0.195090, 0.017117>, <0.923739, 0.382683, 0.016124>, <0.831343, 0.555570, 0.014511>, <0.706999, 0.707107, 0.012341>, <0.555486, 0.831470, 0.009696>, <0.382625, 0.923879, 0.006679>, <0.195061, 0.980785, 0.003405>, <-0.000000, 1.000000, -0.000000>, <-0.195061, 0.980785, -0.003405>, 
			<-0.382625, 0.923879, -0.006679>, <-0.555486, 0.831470, -0.009696>, <-0.706999, 0.707107, -0.012341>, <-0.831343, 0.555570, -0.014511>, <-0.923739, 0.382683, -0.016124>, <-0.980636, 0.195090, -0.017117>, <-0.999804, -0.009324, -0.017452>, <-0.980636, -0.195090, -0.017117>, <-0.923739, -0.382683, -0.016124>, <-0.831343, -0.555570, -0.014511>, <-0.706999, -0.707107, -0.012341>, 
			<-0.555486, -0.831470, -0.009696>, <-0.382625, -0.923879, -0.006679>, <-0.195061, -0.980785, -0.003405>, <0.000000, -1.000000, 0.000000>, <0.195061, -0.980785, 0.003405>, <0.382625, -0.923879, 0.006679>, <0.555486, -0.831470, 0.009696>, <0.706999, -0.707107, 0.012341>, <0.831343, -0.555570, 0.014511>, <0.923739, -0.382683, 0.016124>, <0.980636, -0.195090, 0.017117>, 
			<0.999794, -0.010348, 0.017451>, <0.999813, 0.008300, 0.017452>, <0.141061, -0.028797, 0.989582>, <0.143147, -0.001073, 0.989701>, <0.143147, 0.001073, 0.989701>, <0.141061, 0.028797, 0.989582>, <0.132402, 0.059129, 0.989431>, <0.117994, 0.087188, 0.989179>, <0.112807, 0.129982, 0.985078>, <0.069949, 0.135239, 0.988341>, <0.041895, 0.149650, 0.987851>, 
			<0.011568, 0.158310, 0.987322>, <-0.017225, 0.160887, 0.986823>, <-0.046018, 0.158310, 0.986317>, <-0.076345, 0.149650, 0.985787>, <-0.104399, 0.135239, 0.985297>, <-0.147117, 0.129982, 0.980541>, <-0.152444, 0.087188, 0.984459>, <-0.166852, 0.059129, 0.984207>, <-0.175511, 0.028797, 0.984056>, <-0.177600, 0.001073, 0.984102>, <-0.177600, -0.001073, 0.984102>, 
			<-0.175511, -0.028797, 0.984056>, <-0.166852, -0.059129, 0.984207>, <-0.152444, -0.087188, 0.984459>, <-0.147117, -0.129982, 0.980541>, <-0.104399, -0.135239, 0.985297>, <-0.076345, -0.149650, 0.985787>, <-0.046018, -0.158310, 0.986317>, <-0.017225, -0.160887, 0.986823>, <0.011568, -0.158310, 0.987322>, <0.041895, -0.149650, 0.987851>, <0.069949, -0.135239, 0.988341>, 
			<0.112807, -0.129982, 0.985078>, <0.117994, -0.087188, 0.989179>, <0.132402, -0.059129, 0.989431>, <-0.999529, 0.025235, -0.017447>, <-0.999529, -0.025234, -0.017447>, <-0.923739, -0.382683, -0.016124>, <-0.706999, -0.707107, -0.012341>, <-0.382625, -0.923879, -0.006679>, <-0.000000, -1.000000, 0.000000>, <0.382625, -0.923879, 0.006679>, <0.706999, -0.707107, 0.012341>, 
			<0.923739, -0.382683, 0.016124>, <0.999529, -0.025238, 0.017447>, <0.999529, 0.025237, 0.017447>, <0.923735, 0.382693, 0.016124>, <0.706999, 0.707107, 0.012341>, <0.382625, 0.923879, 0.006679>, <-0.000000, 1.000000, 0.000000>, <-0.382625, 0.923879, -0.006679>, <-0.706999, 0.707107, -0.012341>, <-0.923743, 0.382674, -0.016124>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.989602, 0.024914, 0.141656>, <-0.989678, -0.018691, 0.142087>, <-0.917226, -0.363122, 0.163827>, <-0.701516, -0.697710, 0.145175>, <-0.381364, -0.912048, 0.150763>, <-0.035462, -0.987007, 0.156717>, 
			<0.359929, -0.914227, 0.186120>, <0.694857, -0.698875, 0.169549>, <0.909163, -0.378674, 0.173289>, <0.983972, -0.025140, 0.176540>, <0.992075, 0.025095, 0.123118>, <0.909159, 0.378684, 0.173289>, <0.694857, 0.698875, 0.169549>, <0.359929, 0.914227, 0.186120>, <-0.035462, 0.987007, 0.156717>, <-0.381364, 0.912048, 0.150763>, <-0.701516, 0.697710, 0.145175>, 
			<-0.917230, 0.363112, 0.163827>, <0.145162, -0.005787, 0.989391>, <0.131286, 0.067373, 0.989052>, <0.074838, 0.092155, 0.992928>, <0.050143, 0.148528, 0.987636>, <-0.012651, 0.139674, 0.990117>, <-0.084580, 0.148528, 0.985285>, <-0.109445, 0.092155, 0.989712>, <-0.165725, 0.067371, 0.983868>, <-0.179603, -0.005787, 0.983722>, <-0.165724, -0.067372, 0.983868>, 
			<-0.109445, -0.092155, 0.989712>, <-0.084580, -0.148528, 0.985285>, <-0.012651, -0.139674, 0.990117>, <0.050143, -0.148528, 0.987636>, <0.074838, -0.092155, 0.992928>, <0.131287, -0.067372, 0.989052>, <-0.202048, 0.005256, 0.979362>, <0.198409, 0.006125, 0.980100>, <-0.169364, -0.800929, 0.574308>, <0.695320, -0.000637, 0.718700>, <0.572067, -0.404195, 0.713699>, 
			<-0.416413, -0.584435, 0.696445>, <-0.615654, -0.375451, 0.692825>, <0.137471, -0.694627, 0.706113>, <0.684177, -0.134691, 0.716771>, <-0.708777, 0.134683, 0.692456>, <-0.416413, 0.584435, 0.696445>, <0.684175, 0.134698, 0.716771>, <0.363117, -0.603469, 0.709910>, <-0.169364, 0.800929, 0.574308>, <-0.615655, 0.375449, 0.692825>, <0.572066, 0.404196, 0.713699>, 
			<0.137471, 0.694627, 0.706113>, <-0.719979, -0.000634, 0.693996>, <-0.708775, -0.134690, 0.692457>, <0.363117, 0.603469, 0.709910>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.179603, -0.005787, -0.983722>, <0.708773, 0.134698, -0.692457>, <0.165724, 0.067373, -0.983868>, <0.615653, 0.375453, -0.692825>, <0.109445, 0.092155, -0.989712>, <0.416413, 0.584435, -0.696445>, <0.084580, 0.148528, -0.985285>, <0.162030, 0.694627, -0.700885>, <0.017219, 0.163007, -0.986475>, <-0.137471, 0.694627, -0.706113>, 
			<-0.050143, 0.148528, -0.987636>, <-0.363117, 0.603469, -0.709910>, <-0.074838, 0.092155, -0.992928>, <-0.572068, 0.404194, -0.713699>, <-0.131287, 0.067371, -0.989052>, <-0.695320, -0.000634, -0.718700>, <-0.145162, -0.005787, -0.989391>, <-0.684177, -0.134690, -0.716771>, <-0.131287, -0.067372, -0.989052>, <-0.572067, -0.404195, -0.713699>, <-0.074838, -0.092155, -0.992928>, 
			<-0.363117, -0.603469, -0.709910>, <-0.050143, -0.148528, -0.987636>, <-0.137471, -0.694627, -0.706113>, <0.017219, -0.163007, -0.986475>, <0.162030, -0.694627, -0.700885>, <0.084580, -0.148528, -0.985285>, <0.416413, -0.584435, -0.696445>, <0.109445, -0.092155, -0.989712>, <0.615654, -0.375451, -0.692825>, <0.165724, -0.067372, -0.983868>, <0.708775, -0.134691, -0.692457>, 
			<0.718110, -0.050130, -0.694121>, <0.668246, -0.000326, -0.743941>, <0.734491, -0.221969, -0.641290>, <0.631103, -0.343907, -0.695296>, <0.552131, -0.458035, -0.696675>, <0.456922, -0.550907, -0.698372>, <0.340919, -0.627071, -0.700397>, <0.212288, -0.679137, -0.702642>, <0.071251, -0.579445, -0.811891>, <-0.051322, -0.705105, -0.707244>, <-0.187637, -0.679137, -0.709623>, 
			<-0.331530, -0.618872, -0.712099>, <-0.445640, -0.539888, -0.714091>, <-0.538498, -0.444664, -0.715747>, <-0.614650, -0.328643, -0.717077>, <-0.666708, -0.199993, -0.717985>, <-0.693448, -0.050130, -0.718760>, <-0.641876, -0.000326, -0.766809>, <-0.666708, 0.199993, -0.717985>, <-0.614650, 0.328643, -0.717077>, <-0.538498, 0.444664, -0.715747>, <-0.445640, 0.539888, -0.714091>, 
			<-0.331530, 0.618872, -0.712099>, <-0.187637, 0.679137, -0.709623>, <-0.051322, 0.705105, -0.707244>, <0.071251, 0.579445, -0.811891>, <0.212288, 0.679137, -0.702642>, <0.340919, 0.627071, -0.700397>, <0.456922, 0.550907, -0.698372>, <0.552131, 0.458035, -0.696675>, <0.631103, 0.343907, -0.695296>, <0.734491, 0.221969, -0.641290>, <0.718110, 0.050130, -0.694121>, 
			<-0.693448, 0.050130, -0.718760>, <0.992791, 0.010200, -0.119423>, <0.986191, -0.010181, -0.165300>, <0.967580, -0.208460, -0.142594>, <0.914538, -0.378175, -0.143541>, <0.823252, -0.548810, -0.145135>, <0.700435, -0.698355, -0.147278>, <0.550809, -0.821062, -0.149890>, <0.380122, -0.912216, -0.152869>, <0.194934, -0.968315, -0.156102>, <-0.013418, -0.987072, -0.159718>, 
			<-0.205645, -0.964944, -0.163073>, <-0.386468, -0.912476, -0.134278>, <-0.545944, -0.820593, -0.169034>, <-0.695465, -0.697758, -0.171644>, <-0.818154, -0.548109, -0.173785>, <-0.909294, -0.377396, -0.175376>, <-0.965384, -0.192180, -0.176355>, <-0.979840, -0.008106, -0.199618>, <-0.965384, 0.192180, -0.176355>, <-0.909294, 0.377396, -0.175376>, <-0.818154, 0.548109, -0.173785>, 
			<-0.695465, 0.697758, -0.171644>, <-0.545944, 0.820593, -0.169034>, <-0.386468, 0.912476, -0.134278>, <-0.205645, 0.964944, -0.163073>, <-0.013418, 0.987072, -0.159718>, <0.194934, 0.968315, -0.156102>, <0.380122, 0.912216, -0.152869>, <0.550809, 0.821062, -0.149890>, <0.700435, 0.698355, -0.147278>, <0.823252, 0.548810, -0.145135>, <0.914538, 0.378175, -0.143541>, 
			<0.967580, 0.208460, -0.142594>, <-0.988018, 0.010200, -0.153998>, <0.175511, -0.028797, -0.984056>, <0.177600, -0.001073, -0.984102>, <0.177600, 0.001073, -0.984102>, <0.175511, 0.028797, -0.984056>, <0.166852, 0.059129, -0.984207>, <0.152444, 0.087188, -0.984459>, <0.147117, 0.129982, -0.980541>, <0.104399, 0.135239, -0.985297>, <0.076345, 0.149650, -0.985787>, 
			<0.046018, 0.158310, -0.986317>, <0.020291, 0.192963, -0.980996>, <-0.011568, 0.158310, -0.987322>, <-0.041895, 0.149650, -0.987851>, <-0.069949, 0.135239, -0.988341>, <-0.112807, 0.129982, -0.985078>, <-0.117994, 0.087188, -0.989179>, <-0.132402, 0.059129, -0.989431>, <-0.141061, 0.028797, -0.989582>, <-0.143147, 0.001073, -0.989701>, <-0.143147, -0.001073, -0.989701>, 
			<-0.141061, -0.028797, -0.989582>, <-0.132402, -0.059129, -0.989431>, <-0.117994, -0.087188, -0.989179>, <-0.112807, -0.129982, -0.985078>, <-0.069949, -0.135239, -0.988341>, <-0.041895, -0.149650, -0.987851>, <-0.011568, -0.158310, -0.987322>, <0.020291, -0.192963, -0.980996>, <0.046018, -0.158310, -0.986317>, <0.076345, -0.149650, -0.985787>, <0.104399, -0.135239, -0.985297>, 
			<0.147117, -0.129982, -0.980541>, <0.152444, -0.087188, -0.984459>, <0.166852, -0.059129, -0.984207>, <-0.684179, 0.134683, -0.716771>, <0.719979, -0.000637, -0.693996>, <0.202048, 0.005257, -0.979362>, <-0.198409, 0.006125, -0.980100>, <-0.989106, 0.028894, -0.144342>, <-0.983972, -0.025136, -0.176540>, <-0.909163, -0.378674, -0.173289>, <-0.694857, -0.698875, -0.169549>, 
			<-0.359929, -0.914227, -0.186120>, <0.022317, -0.991847, -0.125463>, <0.381364, -0.912048, -0.150763>, <0.701516, -0.697710, -0.145175>, <0.917226, -0.363122, -0.163827>, <0.989678, -0.018695, -0.142087>, <0.989602, 0.024916, -0.141656>, <0.917222, 0.363133, -0.163827>, <0.701516, 0.697710, -0.145175>, <0.381364, 0.912048, -0.150763>, <0.022317, 0.991847, -0.125463>, 
			<-0.359929, 0.914227, -0.186120>, <-0.694857, 0.698875, -0.169549>, <-0.909166, 0.378665, -0.173289>, <0.693448, -0.050130, 0.718760>, <0.641876, -0.000326, 0.766809>, <0.666708, -0.199993, 0.717985>, <0.614650, -0.328643, 0.717077>, <0.538498, -0.444664, 0.715747>, <0.445640, -0.539888, 0.714091>, <0.331530, -0.618872, 0.712099>, <0.187637, -0.679137, 0.709623>, 
			<0.051322, -0.705105, 0.707244>, <-0.075973, -0.705105, 0.705022>, <-0.212288, -0.679137, 0.702642>, <-0.340919, -0.627071, 0.700397>, <-0.456922, -0.550907, 0.698372>, <-0.552131, -0.458035, 0.696675>, <-0.631103, -0.343907, 0.695296>, <-0.734491, -0.221969, 0.641290>, <-0.718110, -0.050130, 0.694121>, <-0.668246, -0.000326, 0.743941>, <-0.734491, 0.221969, 0.641290>, 
			<-0.631103, 0.343907, 0.695296>, <-0.552131, 0.458035, 0.696675>, <-0.456922, 0.550907, 0.698372>, <-0.340919, 0.627071, 0.700397>, <-0.212288, 0.679137, 0.702642>, <-0.075973, 0.705105, 0.705022>, <0.051322, 0.705105, 0.707244>, <0.187637, 0.679137, 0.709623>, <0.331530, 0.618872, 0.712099>, <0.445640, 0.539888, 0.714091>, <0.538498, 0.444664, 0.715747>, 
			<0.614650, 0.328643, 0.717077>, <0.666708, 0.199993, 0.717985>, <0.693448, 0.050130, 0.718760>, <-0.718110, 0.050130, 0.694121>, <0.988018, 0.010200, 0.153998>, <0.973226, -0.009083, 0.229669>, <0.965384, -0.192180, 0.176355>, <0.909294, -0.377396, 0.175376>, <0.818154, -0.548109, 0.173785>, <0.695465, -0.697758, 0.171644>, <0.545944, -0.820593, 0.169034>, 
			<0.386468, -0.912476, 0.134278>, <0.205645, -0.964944, 0.163073>, <0.003943, -0.983234, 0.182305>, <-0.194934, -0.968315, 0.156102>, <-0.380122, -0.912216, 0.152869>, <-0.550809, -0.821062, 0.149890>, <-0.700435, -0.698355, 0.147278>, <-0.823252, -0.548810, 0.145135>, <-0.914538, -0.378175, 0.143541>, <-0.967580, -0.208460, 0.142594>, <-0.986191, -0.010181, 0.165300>, 
			<-0.967580, 0.208460, 0.142594>, <-0.914538, 0.378175, 0.143541>, <-0.823252, 0.548810, 0.145135>, <-0.700435, 0.698355, 0.147278>, <-0.550809, 0.821062, 0.149890>, <-0.380122, 0.912216, 0.152869>, <-0.194934, 0.968315, 0.156102>, <0.003943, 0.983234, 0.182305>, <0.205645, 0.964944, 0.163073>, <0.386468, 0.912476, 0.134278>, <0.545944, 0.820593, 0.169034>, 
			<0.695465, 0.697758, 0.171644>, <0.818154, 0.548109, 0.173785>, <0.909294, 0.377396, 0.175376>, <0.965384, 0.192180, 0.176355>, <-0.989780, 0.009118, 0.142310>, <-0.999817, 0.007890, -0.017452>, <0.980636, 0.195090, 0.017117>, <0.923739, 0.382683, 0.016124>, <0.831343, 0.555570, 0.014511>, <0.706999, 0.707107, 0.012341>, <0.555486, 0.831470, 0.009696>, 
			<0.382625, 0.923879, 0.006679>, <0.195061, 0.980785, 0.003405>, <0.000000, 1.000000, 0.000000>, <-0.195061, 0.980785, -0.003405>, <-0.382625, 0.923879, -0.006679>, <-0.555486, 0.831470, -0.009696>, <-0.706999, 0.707107, -0.012341>, <-0.831343, 0.555570, -0.014511>, <-0.923739, 0.382683, -0.016124>, <-0.980636, 0.195090, -0.017117>, <-0.999794, -0.010348, -0.017451>, 
			<-0.980636, -0.195090, -0.017117>, <-0.923739, -0.382683, -0.016124>, <-0.831343, -0.555570, -0.014511>, <-0.706999, -0.707107, -0.012341>, <-0.555486, -0.831470, -0.009696>, <-0.382625, -0.923879, -0.006679>, <-0.195061, -0.980785, -0.003405>, <0.000000, -1.000000, -0.000000>, <0.195061, -0.980785, 0.003405>, <0.382625, -0.923879, 0.006679>, <0.555486, -0.831470, 0.009696>, 
			<0.706999, -0.707107, 0.012341>, <0.831343, -0.555570, 0.014511>, <0.923739, -0.382683, 0.016124>, <0.980636, -0.195090, 0.017117>, <0.999779, -0.011714, 0.017451>, <0.999813, 0.008300, 0.017452>, <0.141061, -0.028797, 0.989582>, <0.143147, -0.001073, 0.989701>, <0.143147, 0.001073, 0.989701>, <0.141061, 0.028797, 0.989582>, <0.132402, 0.059129, 0.989431>, 
			<0.117994, 0.087188, 0.989179>, <0.112807, 0.129982, 0.985078>, <0.069949, 0.135239, 0.988341>, <0.041895, 0.149650, 0.987851>, <0.011568, 0.158310, 0.987322>, <-0.017225, 0.160887, 0.986823>, <-0.046018, 0.158310, 0.986317>, <-0.076345, 0.149650, 0.985787>, <-0.104399, 0.135239, 0.985297>, <-0.147117, 0.129982, 0.980541>, <-0.152444, 0.087188, 0.984459>, 
			<-0.166852, 0.059129, 0.984207>, <-0.175511, 0.028797, 0.984056>, <-0.177600, 0.001073, 0.984102>, <-0.177600, -0.001073, 0.984102>, <-0.175511, -0.028797, 0.984056>, <-0.166852, -0.059129, 0.984207>, <-0.152444, -0.087188, 0.984459>, <-0.147117, -0.129982, 0.980541>, <-0.104399, -0.135239, 0.985297>, <-0.076345, -0.149650, 0.985787>, <-0.046018, -0.158310, 0.986317>, 
			<-0.017225, -0.160887, 0.986823>, <0.011568, -0.158310, 0.987322>, <0.041895, -0.149650, 0.987851>, <0.069949, -0.135239, 0.988341>, <0.112807, -0.129982, 0.985078>, <0.117994, -0.087188, 0.989179>, <0.132402, -0.059129, 0.989431>, <-0.999426, 0.029052, -0.017445>, <-0.999529, -0.025234, -0.017447>, <-0.923739, -0.382683, -0.016124>, <-0.706999, -0.707107, -0.012341>, 
			<-0.382625, -0.923879, -0.006679>, <-0.000000, -1.000000, 0.000000>, <0.382625, -0.923879, 0.006679>, <0.706999, -0.707107, 0.012341>, <0.923739, -0.382683, 0.016124>, <0.999529, -0.025238, 0.017447>, <0.999529, 0.025237, 0.017447>, <0.923735, 0.382693, 0.016124>, <0.706999, 0.707107, 0.012341>, <0.382625, 0.923879, 0.006679>, <0.000000, 1.000000, 0.000000>, 
			<-0.382625, 0.923879, -0.006679>, <-0.706999, 0.707107, -0.012341>, <-0.923743, 0.382674, -0.016124>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.989602, 0.024914, 0.141656>, <-0.989678, -0.018691, 0.142087>, 
			<-0.917226, -0.363122, 0.163827>, <-0.701516, -0.697710, 0.145175>, <-0.381364, -0.912048, 0.150763>, <-0.035462, -0.987007, 0.156717>, <0.359929, -0.914227, 0.186120>, <0.694857, -0.698875, 0.169549>, <0.909163, -0.378674, 0.173289>, <0.983972, -0.025140, 0.176540>, <0.992075, 0.025095, 0.123118>, <0.909159, 0.378684, 0.173289>, <0.694857, 0.698875, 0.169549>, 
			<0.359929, 0.914227, 0.186120>, <-0.035462, 0.987007, 0.156717>, <-0.381364, 0.912048, 0.150763>, <-0.701516, 0.697710, 0.145175>, <-0.917230, 0.363112, 0.163827>, <0.145162, -0.005787, 0.989391>, <0.131286, 0.067373, 0.989052>, <0.074838, 0.092155, 0.992928>, <0.050143, 0.148528, 0.987636>, <-0.012651, 0.139674, 0.990117>, <-0.084580, 0.148528, 0.985285>, 
			<-0.109445, 0.092155, 0.989712>, <-0.165725, 0.067371, 0.983868>, <-0.179603, -0.005787, 0.983722>, <-0.165724, -0.067372, 0.983868>, <-0.109445, -0.092155, 0.989712>, <-0.084580, -0.148528, 0.985285>, <-0.012651, -0.139674, 0.990117>, <0.050143, -0.148528, 0.987636>, <0.074838, -0.092155, 0.992928>, <0.131287, -0.067372, 0.989052>, <-0.202048, 0.005256, 0.979362>, 
			<0.198409, 0.006125, 0.980100>, <-0.169364, -0.800929, 0.574308>, <0.695320, -0.000637, 0.718700>, <0.572067, -0.404195, 0.713699>, <-0.416413, -0.584435, 0.696445>, <-0.615654, -0.375451, 0.692825>, <0.137471, -0.694627, 0.706113>, <0.684177, -0.134691, 0.716771>, <-0.708777, 0.134683, 0.692456>, <-0.416413, 0.584435, 0.696445>, <0.684175, 0.134698, 0.716771>, 
			<0.363117, -0.603469, 0.709910>, <-0.169364, 0.800929, 0.574308>, <-0.615655, 0.375449, 0.692825>, <0.572066, 0.404196, 0.713699>, <0.137471, 0.694627, 0.706113>, <-0.719979, -0.000634, 0.693996>, <-0.708775, -0.134690, 0.692457>, <0.363117, 0.603469, 0.709910>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.992839, 0.000000, -0.119460>, <-0.980625, 0.194430, -0.023913>, 
			<-0.980625, -0.194430, -0.023913>, <-0.078611, 0.019806, -0.996709>, <0.006337, 0.194466, -0.980889>, <0.006337, -0.194466, -0.980889>, <-0.273540, 0.000000, -0.961861>, <-0.174252, 0.194210, -0.965360>, <-0.190377, -0.194185, -0.962314>, <-0.441335, -0.000000, -0.897342>, <-0.366765, 0.180582, -0.912619>, <-0.359810, -0.194210, -0.912589>, <-0.620806, -0.000000, -0.783964>, 
			<-0.520543, 0.213209, -0.826787>, <-0.520543, -0.213209, -0.826787>, <-0.761821, -0.000000, -0.647788>, <-0.685469, 0.213209, -0.696186>, <-0.681654, -0.194210, -0.705429>, <-0.873560, 0.000000, -0.486717>, <-0.805827, 0.194210, -0.559398>, <-0.806179, -0.194210, -0.558890>, <-0.951728, 0.000000, -0.306941>, <-0.898918, 0.175119, -0.401596>, <-0.899722, -0.194210, -0.390874>, 
			<-0.959707, 0.180582, -0.215298>, <-0.958690, -0.194210, -0.207836>, <-0.920133, 0.381396, -0.088838>, <-0.831997, 0.554422, -0.019944>, <-0.059974, 0.381385, -0.922469>, <0.005890, 0.554479, -0.832177>, <-0.252299, 0.381147, -0.889422>, <-0.147299, 0.553764, -0.819541>, <-0.429452, 0.368012, -0.824705>, <-0.304354, 0.553764, -0.775057>, <-0.565818, 0.411467, -0.714525>, 
			<-0.459178, 0.542124, -0.703745>, <-0.703915, 0.381147, -0.599358>, <-0.579500, 0.537430, -0.612657>, <-0.800177, 0.381104, -0.463117>, <-0.687291, 0.542124, -0.483459>, <-0.880075, 0.381147, -0.283186>, <-0.763963, 0.553764, -0.331217>, <-0.813901, 0.553764, -0.175811>, <-0.705289, 0.705755, -0.066905>, <-0.556490, 0.830754, -0.012944>, <-0.044717, 0.705746, -0.707053>, 
			<0.004534, 0.830786, -0.556573>, <-0.192775, 0.705440, -0.682050>, <-0.097872, 0.830259, -0.548717>, <-0.322133, 0.705440, -0.631336>, <-0.203041, 0.830259, -0.519080>, <-0.439111, 0.705440, -0.556360>, <-0.300407, 0.830259, -0.469495>, <-0.540697, 0.705440, -0.458260>, <-0.405755, 0.811676, -0.420172>, <-0.619710, 0.705440, -0.343970>, <-0.458725, 0.830259, -0.316609>, 
			<-0.674907, 0.705440, -0.216461>, <-0.511678, 0.830259, -0.221033>, <-0.544967, 0.830259, -0.116962>, <-0.382313, 0.923377, -0.034804>, <-0.195465, 0.980701, -0.004314>, <-0.022731, 0.923375, -0.383226>, <0.001951, 0.980704, -0.195487>, <-0.103653, 0.923239, -0.369981>, <-0.033321, 0.980608, -0.193127>, <-0.173841, 0.923239, -0.342650>, <-0.070358, 0.980608, -0.182916>, 
			<-0.237348, 0.923239, -0.302151>, <-0.104691, 0.980608, -0.165675>, <-0.293684, 0.923239, -0.247749>, <-0.158295, 0.973691, -0.163919>, <-0.336374, 0.923239, -0.185693>, <-0.161920, 0.980608, -0.110409>, <-0.366138, 0.923239, -0.116502>, <-0.180349, 0.980608, -0.076699>, <-0.191847, 0.980608, -0.040041>, <-0.000156, 0.999997, 0.002285>, <0.195729, 0.980648, 0.004370>, 
			<0.002193, 0.999998, -0.000075>, <-0.001862, 0.980654, 0.195743>, <0.001570, 0.999999, -0.000447>, <0.036424, 0.980608, 0.192566>, <0.001453, 0.999999, -0.000744>, <0.073292, 0.980608, 0.181760>, <0.001280, 0.999999, -0.001014>, <0.107343, 0.980608, 0.163969>, <-0.001058, 0.999999, 0.001244>, <0.113832, 0.986482, 0.117876>, <-0.000795, 0.999999, 0.001426>, 
			<0.160123, 0.980608, 0.113000>, <-0.000501, 0.999999, 0.001554>, <0.179091, 0.980608, 0.079590>, <0.191177, 0.980608, 0.043122>, <0.382043, 0.923344, 0.038451>, <0.556643, 0.830668, 0.011768>, <0.025919, 0.923343, 0.383101>, <-0.006341, 0.830693, 0.556694>, <0.106547, 0.923239, 0.369157>, <0.100491, 0.830259, 0.548244>, <0.176519, 0.923239, 0.341278>, 
			<0.205517, 0.830259, 0.518105>, <0.239707, 0.923239, 0.300283>, <0.302645, 0.830259, 0.468055>, <0.291734, 0.923239, 0.250041>, <0.368208, 0.847963, 0.381290>, <0.334909, 0.923239, 0.188322>, <0.457208, 0.830259, 0.318796>, <0.365214, 0.923239, 0.119366>, <0.510617, 0.830259, 0.223473>, <0.544403, 0.830259, 0.119563>, <0.705161, 0.705762, 0.068181>, 
			<0.832038, 0.554457, 0.017017>, <0.044870, 0.705759, 0.707030>, <-0.010392, 0.554486, 0.832128>, <0.194977, 0.705440, 0.681424>, <0.149038, 0.553764, 0.819227>, <0.324170, 0.705440, 0.630293>, <0.305998, 0.553764, 0.774410>, <0.440905, 0.705440, 0.554939>, <0.451198, 0.553764, 0.699833>, <0.539214, 0.705440, 0.460004>, <0.578423, 0.553765, 0.598975>, 
			<0.618595, 0.705440, 0.345970>, <0.679529, 0.569851, 0.462072>, <0.674204, 0.705440, 0.218640>, <0.763259, 0.553764, 0.332838>, <0.813526, 0.553764, 0.177538>, <0.920247, 0.381485, 0.087267>, <0.980673, 0.194656, 0.019720>, <0.056619, 0.381483, 0.922640>, <-0.012792, 0.194665, 0.980786>, <0.253484, 0.381147, 0.889085>, <0.174859, 0.194210, 0.965250>, 
			<0.422065, 0.381147, 0.822550>, <0.359810, 0.194210, 0.912589>, <0.575804, 0.394189, 0.716285>, <0.530934, 0.194210, 0.824859>, <0.692766, 0.399380, 0.600476>, <0.681654, 0.194210, 0.705429>, <0.814877, 0.381104, 0.436733>, <0.814521, 0.175119, 0.553072>, <0.875159, 0.399380, 0.273116>, <0.899722, 0.194210, 0.390874>, <0.961917, 0.194185, 0.192377>, 
			<0.996442, 0.014156, 0.083082>, <0.980673, -0.194656, 0.019720>, <0.050023, -0.014155, 0.998648>, <-0.012792, -0.194665, 0.980786>, <0.273540, 0.000000, 0.961861>, <0.158689, -0.194185, 0.968044>, <0.455933, 0.000000, 0.890014>, <0.359236, -0.194210, 0.912816>, <0.620806, 0.000000, 0.783964>, <0.530415, -0.194210, 0.825193>, <0.755287, 0.019791, 0.655095>, 
			<0.681210, -0.194210, 0.705858>, <0.873560, 0.000000, 0.486717>, <0.808117, -0.213209, 0.549080>, <0.948489, 0.019791, 0.316193>, <0.899476, -0.194210, 0.391440>, <0.956727, -0.213209, 0.198031>, <0.920247, -0.381485, 0.087267>, <0.832038, -0.554457, 0.017017>, <0.056619, -0.381483, 0.922640>, <-0.010392, -0.554486, 0.832128>, <0.242407, -0.399380, 0.884157>, 
			<0.149038, -0.553764, 0.819227>, <0.408029, -0.381104, 0.829622>, <0.305998, -0.553764, 0.774410>, <0.565243, -0.394189, 0.724648>, <0.451198, -0.553764, 0.699833>, <0.695754, -0.394189, 0.600451>, <0.578423, -0.553765, 0.598975>, <0.807319, -0.381147, 0.450514>, <0.683660, -0.553764, 0.475347>, <0.879697, -0.381147, 0.284358>, <0.763259, -0.553764, 0.332838>, 
			<0.813526, -0.553764, 0.177538>, <0.705161, -0.705762, 0.068181>, <0.556643, -0.830668, 0.011768>, <0.044870, -0.705759, 0.707030>, <-0.006341, -0.830693, 0.556694>, <0.194977, -0.705440, 0.681424>, <0.100491, -0.830259, 0.548244>, <0.324170, -0.705440, 0.630293>, <0.205517, -0.830259, 0.518105>, <0.440905, -0.705440, 0.554939>, <0.302645, -0.830259, 0.468055>, 
			<0.539214, -0.705440, 0.460004>, <0.368208, -0.847963, 0.381290>, <0.618595, -0.705440, 0.345970>, <0.457208, -0.830259, 0.318796>, <0.674204, -0.705440, 0.218640>, <0.510617, -0.830259, 0.223473>, <0.544403, -0.830259, 0.119563>, <0.382043, -0.923344, 0.038451>, <0.195729, -0.980648, 0.004370>, <0.025919, -0.923343, 0.383101>, <-0.001862, -0.980654, 0.195743>, 
			<0.106547, -0.923239, 0.369157>, <0.036424, -0.980608, 0.192566>, <0.176519, -0.923239, 0.341278>, <0.073292, -0.980608, 0.181760>, <0.239707, -0.923239, 0.300283>, <0.107343, -0.980608, 0.163969>, <0.291734, -0.923239, 0.250041>, <0.113832, -0.986482, 0.117876>, <0.334909, -0.923239, 0.188322>, <0.160123, -0.980608, 0.113000>, <0.365214, -0.923239, 0.119366>, 
			<0.179091, -0.980608, 0.079590>, <0.191177, -0.980608, 0.043122>, <-0.000156, -0.999997, 0.002285>, <-0.195465, -0.980701, -0.004314>, <0.002193, -0.999998, -0.000075>, <0.001951, -0.980704, -0.195487>, <0.001570, -0.999999, -0.000447>, <-0.033321, -0.980608, -0.193127>, <0.001453, -0.999999, -0.000744>, <-0.070358, -0.980608, -0.182916>, <0.001280, -0.999999, -0.001014>, 
			<-0.104691, -0.980608, -0.165675>, <-0.001058, -0.999999, 0.001244>, <-0.158295, -0.973691, -0.163919>, <-0.000795, -0.999999, 0.001426>, <-0.161920, -0.980608, -0.110409>, <-0.000501, -0.999999, 0.001554>, <-0.180349, -0.980608, -0.076699>, <-0.191847, -0.980608, -0.040041>, <-0.382313, -0.923377, -0.034804>, <-0.556490, -0.830754, -0.012944>, <-0.022731, -0.923375, -0.383226>, 
			<0.004534, -0.830786, -0.556573>, <-0.103653, -0.923239, -0.369981>, <-0.097872, -0.830259, -0.548717>, <-0.173841, -0.923239, -0.342650>, <-0.203041, -0.830259, -0.519080>, <-0.237348, -0.923239, -0.302151>, <-0.300407, -0.830259, -0.469495>, <-0.293684, -0.923239, -0.247749>, <-0.405755, -0.811676, -0.420172>, <-0.336374, -0.923239, -0.185693>, <-0.458725, -0.830259, -0.316609>, 
			<-0.366138, -0.923239, -0.116502>, <-0.511678, -0.830259, -0.221033>, <-0.544967, -0.830259, -0.116962>, <-0.705289, -0.705755, -0.066905>, <-0.831997, -0.554422, -0.019944>, <-0.044717, -0.705746, -0.707053>, <0.005890, -0.554479, -0.832177>, <-0.192775, -0.705440, -0.682050>, <-0.147299, -0.553764, -0.819541>, <-0.322133, -0.705440, -0.631336>, <-0.304354, -0.553764, -0.775057>, 
			<-0.439111, -0.705440, -0.556360>, <-0.459178, -0.542124, -0.703745>, <-0.540697, -0.705440, -0.458260>, <-0.592059, -0.537430, -0.600529>, <-0.619710, -0.705440, -0.343970>, <-0.684667, -0.553764, -0.473895>, <-0.674907, -0.705440, -0.216461>, <-0.763963, -0.553764, -0.331217>, <-0.813901, -0.553764, -0.175811>, <-0.920133, -0.381396, -0.088838>, <-0.059974, -0.381385, -0.922469>, 
			<-0.260308, -0.368012, -0.892640>, <-0.434909, -0.381104, -0.815852>, <-0.574427, -0.381147, -0.724404>, <-0.704713, -0.381147, -0.598420>, <-0.807918, -0.381147, -0.449438>, <-0.880075, -0.381147, -0.283186>, <0.994973, 0.019782, -0.098168>, <0.980535, 0.194586, -0.026213>, <0.980535, -0.194586, -0.026213>, <0.961861, 0.000000, -0.273540>, <0.965360, 0.194210, -0.174252>, 
			<0.962314, -0.194185, -0.190377>, <0.890014, -0.000000, -0.455933>, <0.912816, 0.194210, -0.359236>, <0.912386, -0.175119, -0.369979>, <0.783964, -0.000000, -0.620806>, <0.826465, 0.207791, -0.523238>, <0.824859, -0.194210, -0.530934>, <0.655095, -0.019791, -0.755287>, <0.705858, 0.194210, -0.681210>, <0.705429, -0.194210, -0.681654>, <0.486717, -0.000000, -0.873560>, 
			<0.549080, 0.213209, -0.808117>, <0.558890, -0.194210, -0.806179>, <0.300241, -0.014138, -0.953759>, <0.391440, 0.194210, -0.899476>, <0.390874, -0.194210, -0.899722>, <0.100678, 0.000000, -0.994919>, <0.223845, 0.194185, -0.955084>, <0.223845, -0.194185, -0.955084>, <0.027900, 0.194466, -0.980512>, <0.027900, -0.194466, -0.980512>, <0.920763, 0.381216, -0.082886>, 
			<0.831805, 0.554665, -0.021155>, <0.889422, 0.381147, -0.252299>, <0.819541, 0.553764, -0.147299>, <0.824705, 0.368012, -0.429452>, <0.775057, 0.553764, -0.304354>, <0.725169, 0.381147, -0.573461>, <0.700788, 0.553764, -0.449712>, <0.599358, 0.381147, -0.703915>, <0.612657, 0.537430, -0.579500>, <0.463117, 0.381104, -0.800177>, <0.483459, 0.542124, -0.687291>, 
			<0.291303, 0.368012, -0.883012>, <0.331217, 0.553764, -0.763963>, <0.092131, 0.381385, -0.919814>, <0.175811, 0.553764, -0.813901>, <0.023157, 0.554479, -0.831876>, <0.705892, 0.705558, -0.062491>, <0.556272, 0.830902, -0.012774>, <0.682050, 0.705440, -0.192775>, <0.548717, 0.830259, -0.097872>, <0.631336, 0.705440, -0.322133>, <0.519080, 0.830259, -0.203041>, 
			<0.556360, 0.705440, -0.439111>, <0.469495, 0.830259, -0.300407>, <0.458260, 0.705440, -0.540697>, <0.420172, 0.811676, -0.405755>, <0.343970, 0.705440, -0.619710>, <0.316609, 0.830259, -0.458725>, <0.216461, 0.705440, -0.674907>, <0.221033, 0.830259, -0.511678>, <0.069365, 0.705746, -0.705062>, <0.116962, 0.830259, -0.544967>, <0.014893, 0.830786, -0.556392>, 
			<0.382679, 0.923305, -0.032636>, <0.195409, 0.980716, -0.003473>, <0.369981, 0.923239, -0.103653>, <0.193127, 0.980608, -0.033321>, <0.342650, 0.923239, -0.173841>, <0.182916, 0.980608, -0.070358>, <0.302151, 0.923239, -0.237348>, <0.165675, 0.980608, -0.104691>, <0.247749, 0.923239, -0.293684>, <0.163919, 0.973691, -0.158295>, <0.185693, 0.923239, -0.336374>, 
			<0.110409, 0.980608, -0.161920>, <0.116502, 0.923239, -0.366138>, <0.076699, 0.980608, -0.180349>, <0.036091, 0.923375, -0.382200>, <0.040041, 0.980608, -0.191847>, <0.004872, 0.980704, -0.195436>, <0.000068, 0.999999, 0.001415>, <-0.195555, 0.980684, 0.004129>, <0.000447, 0.999999, 0.001570>, <-0.192566, 0.980608, 0.036424>, <0.000744, 0.999999, 0.001453>, 
			<-0.181760, 0.980608, 0.073292>, <0.001014, 0.999999, 0.001280>, <-0.163969, 0.980608, 0.107343>, <-0.001244, 0.999999, -0.001058>, <-0.117876, 0.986482, 0.113832>, <-0.001426, 0.999999, -0.000795>, <-0.113000, 0.980608, 0.160123>, <-0.001554, 0.999999, -0.000501>, <-0.079590, 0.980608, 0.179091>, <-0.002189, 0.999998, -0.000151>, <-0.043122, 0.980608, 0.191177>, 
			<-0.004970, 0.980654, 0.195688>, <-0.382621, 0.923293, 0.033625>, <-0.556418, 0.830861, 0.008290>, <-0.369157, 0.923239, 0.106547>, <-0.548244, 0.830259, 0.100491>, <-0.341278, 0.923239, 0.176519>, <-0.518105, 0.830259, 0.205517>, <-0.300283, 0.923239, 0.239707>, <-0.468055, 0.830259, 0.302645>, <-0.250041, 0.923239, 0.291734>, <-0.381290, 0.847963, 0.368208>, 
			<-0.188322, 0.923239, 0.334909>, <-0.318796, 0.830259, 0.457208>, <-0.119366, 0.923239, 0.365214>, <-0.223473, 0.830259, 0.510617>, <-0.039273, 0.923343, 0.381963>, <-0.119563, 0.830259, 0.544403>, <-0.013091, 0.830693, 0.556576>, <-0.706125, 0.705647, 0.058729>, <-0.831995, 0.554708, 0.009131>, <-0.681424, 0.705440, 0.194977>, <-0.819227, 0.553764, 0.149038>, 
			<-0.630293, 0.705440, 0.324170>, <-0.774410, 0.553764, 0.305998>, <-0.554939, 0.705440, 0.440905>, <-0.699833, 0.553764, 0.451198>, <-0.460004, 0.705440, 0.539214>, <-0.589035, 0.565278, 0.577493>, <-0.345970, 0.705440, 0.618595>, <-0.475347, 0.553764, 0.683660>, <-0.218640, 0.705440, 0.674204>, <-0.332838, 0.553764, 0.763259>, <-0.069517, 0.705759, 0.705033>, 
			<-0.177538, 0.553764, 0.813526>, <-0.018655, 0.554486, 0.831984>, <-0.921471, 0.381396, 0.073681>, <-0.980817, 0.194740, 0.008575>, <-0.889085, 0.381147, 0.253484>, <-0.968044, 0.194185, 0.158689>, <-0.822550, 0.381147, 0.422065>, <-0.912589, 0.194210, 0.359810>, <-0.724404, 0.381147, 0.574427>, <-0.824859, 0.194210, 0.530934>, <-0.598889, 0.381147, 0.704314>, 
			<-0.698736, 0.207791, 0.684538>, <-0.450514, 0.381147, 0.807319>, <-0.551763, 0.207791, 0.807701>, <-0.273116, 0.399380, 0.875159>, <-0.383540, 0.175119, 0.906769>, <-0.088784, 0.381483, 0.920102>, <-0.202071, 0.180582, 0.962579>, <-0.021444, 0.194665, 0.980635>, <-0.996957, 0.000000, 0.077952>, <-0.980817, -0.194740, 0.008575>, <-0.958946, -0.019791, 0.282898>, 
			<-0.968044, -0.194185, 0.158689>, <-0.893095, -0.014138, 0.449646>, <-0.912702, -0.194210, 0.359523>, <-0.783964, 0.000000, 0.620806>, <-0.826465, -0.207791, 0.523238>, <-0.653040, -0.014138, 0.757192>, <-0.702796, -0.180582, 0.688091>, <-0.486717, -0.000000, 0.873560>, <-0.559398, -0.194210, 0.805827>, <-0.300241, 0.014138, 0.953759>, <-0.391440, -0.194210, 0.899476>, 
			<-0.084845, 0.014155, 0.996294>, <-0.208440, -0.194210, 0.958559>, <-0.021444, -0.194665, 0.980635>, <-0.921471, -0.381396, 0.073681>, <-0.831995, -0.554708, 0.009131>, <-0.889085, -0.381147, 0.253484>, <-0.819227, -0.553764, 0.149038>, <-0.830366, -0.368012, 0.418402>, <-0.774410, -0.553764, 0.305998>, <-0.725169, -0.381147, 0.573461>, <-0.695241, -0.569851, 0.438075>, 
			<-0.600451, -0.394189, 0.695754>, <-0.598975, -0.553765, 0.578423>, <-0.450514, -0.381147, 0.807319>, <-0.475347, -0.553764, 0.683660>, <-0.284358, -0.381147, 0.879697>, <-0.332838, -0.553764, 0.763259>, <-0.088784, -0.381483, 0.920102>, <-0.177538, -0.553764, 0.813526>, <-0.018655, -0.554486, 0.831984>, <-0.706125, -0.705647, 0.058729>, <-0.556418, -0.830861, 0.008290>, 
			<-0.681424, -0.705440, 0.194977>, <-0.548244, -0.830259, 0.100491>, <-0.630293, -0.705440, 0.324170>, <-0.518105, -0.830259, 0.205517>, <-0.554939, -0.705440, 0.440905>, <-0.468055, -0.830259, 0.302645>, <-0.460004, -0.705440, 0.539214>, <-0.381290, -0.847963, 0.368208>, <-0.345970, -0.705440, 0.618595>, <-0.318796, -0.830259, 0.457208>, <-0.218640, -0.705440, 0.674204>, 
			<-0.223473, -0.830259, 0.510617>, <-0.069517, -0.705759, 0.705033>, <-0.119563, -0.830259, 0.544403>, <-0.013091, -0.830693, 0.556576>, <-0.382621, -0.923293, 0.033625>, <-0.195555, -0.980684, 0.004129>, <-0.369157, -0.923239, 0.106547>, <-0.192566, -0.980608, 0.036424>, <-0.341278, -0.923239, 0.176519>, <-0.181760, -0.980608, 0.073292>, <-0.300283, -0.923239, 0.239707>, 
			<-0.163969, -0.980608, 0.107343>, <-0.250041, -0.923239, 0.291734>, <-0.117876, -0.986482, 0.113832>, <-0.188322, -0.923239, 0.334909>, <-0.113000, -0.980608, 0.160123>, <-0.119366, -0.923239, 0.365214>, <-0.079590, -0.980608, 0.179091>, <-0.039273, -0.923343, 0.381963>, <-0.043122, -0.980608, 0.191177>, <-0.004970, -0.980654, 0.195688>, <0.000068, -0.999999, 0.001415>, 
			<0.195409, -0.980716, -0.003473>, <0.000447, -0.999999, 0.001570>, <0.193127, -0.980608, -0.033321>, <0.000744, -0.999999, 0.001453>, <0.182916, -0.980608, -0.070358>, <0.001014, -0.999999, 0.001280>, <0.165675, -0.980608, -0.104691>, <-0.001244, -0.999999, -0.001058>, <0.163919, -0.973691, -0.158295>, <-0.001426, -0.999999, -0.000795>, <0.110409, -0.980608, -0.161920>, 
			<-0.001554, -0.999999, -0.000501>, <0.076699, -0.980608, -0.180349>, <-0.002189, -0.999998, -0.000151>, <0.040041, -0.980608, -0.191847>, <0.004872, -0.980704, -0.195436>, <0.382679, -0.923305, -0.032636>, <0.556272, -0.830902, -0.012774>, <0.369981, -0.923239, -0.103653>, <0.548717, -0.830259, -0.097872>, <0.342650, -0.923239, -0.173841>, <0.519080, -0.830259, -0.203041>, 
			<0.302151, -0.923239, -0.237348>, <0.469495, -0.830259, -0.300407>, <0.247749, -0.923239, -0.293684>, <0.420172, -0.811676, -0.405755>, <0.185693, -0.923239, -0.336374>, <0.316609, -0.830259, -0.458725>, <0.116502, -0.923239, -0.366138>, <0.221033, -0.830259, -0.511678>, <0.036091, -0.923375, -0.382200>, <0.116962, -0.830259, -0.544967>, <0.014893, -0.830786, -0.556392>, 
			<0.705892, -0.705558, -0.062491>, <0.831805, -0.554665, -0.021155>, <0.682050, -0.705440, -0.192775>, <0.819541, -0.553764, -0.147299>, <0.631336, -0.705440, -0.322133>, <0.775057, -0.553764, -0.304354>, <0.556360, -0.705440, -0.439111>, <0.700788, -0.553764, -0.449712>, <0.458260, -0.705440, -0.540697>, <0.598975, -0.553765, -0.578423>, <0.343970, -0.705440, -0.619710>, 
			<0.473895, -0.553764, -0.684667>, <0.216461, -0.705440, -0.674907>, <0.331217, -0.553764, -0.763963>, <0.069365, -0.705746, -0.705062>, <0.175811, -0.553764, -0.813901>, <0.023157, -0.554479, -0.831876>, <0.920763, -0.381216, -0.082886>, <0.889422, -0.381147, -0.252299>, <0.815852, -0.381104, -0.434909>, <0.724680, -0.362733, -0.585887>, <0.596455, -0.362733, -0.716008>, 
			<0.449438, -0.381147, -0.807918>, <0.283186, -0.381147, -0.880075>, <0.092131, -0.381385, -0.919814>, <0.017452, 0.000000, -0.999848>, <0.015896, 0.412789, -0.910688>, <0.011930, 0.729885, -0.683466>, <0.006144, 0.935975, -0.352012>, <-0.000580, 0.999448, 0.033207>, <-0.007215, 0.910556, 0.413322>, <-0.012747, 0.683005, 0.730302>, <-0.016338, 0.351656, 0.935987>, 
			<-0.017452, -0.000000, 0.999848>, <-0.016338, -0.351656, 0.935987>, <-0.012747, -0.683005, 0.730302>, <-0.007215, -0.910556, 0.413322>, <-0.000580, -0.999448, 0.033207>, <0.006144, -0.935975, -0.352012>, <0.011930, -0.729885, -0.683466>, <0.015896, -0.412789, -0.910688>, <0.980636, 0.195090, 0.017117>, <0.910728, 0.412948, 0.006942>, <0.980636, -0.195090, 0.017117>, 
			<0.999973, -0.000000, 0.007366>, <0.831343, -0.555570, 0.014511>, <0.910728, -0.412948, 0.006942>, <0.555486, -0.831470, 0.009696>, <0.683397, -0.730025, 0.005644>, <0.195061, -0.980785, 0.003405>, <0.351943, -0.936016, 0.003235>, <-0.195061, -0.980785, -0.003405>, <-0.033166, -0.999450, -0.000357>, <-0.555486, -0.831470, -0.009696>, <-0.413197, -0.910629, -0.004788>, 
			<-0.831343, -0.555570, -0.014511>, <-0.730215, -0.683156, -0.009196>, <-0.980636, -0.195090, -0.017117>, <-0.936006, -0.351764, -0.012408>, <-0.980636, 0.195090, -0.017117>, <-0.999909, -0.000000, -0.013455>, <-0.831343, 0.555570, -0.014511>, <-0.936006, 0.351764, -0.012408>, <-0.555486, 0.831470, -0.009696>, <-0.730215, 0.683156, -0.009196>, <-0.195061, 0.980785, -0.003405>, 
			<-0.413197, 0.910629, -0.004788>, <0.195061, 0.980785, 0.003405>, <-0.033166, 0.999450, -0.000357>, <0.555486, 0.831470, 0.009696>, <0.351943, 0.936016, 0.003235>, <0.831343, 0.555570, 0.014511>, <0.683397, 0.730025, 0.005644>, <0.686681, 0.127449, 0.715699>, <0.909793, 0.377153, 0.173300>, <0.686681, -0.127449, 0.715699>, <0.973992, -0.000000, 0.226582>, 
			<0.584711, -0.385269, 0.713920>, <0.909793, -0.377153, 0.173300>, <0.401513, -0.577809, 0.710580>, <0.696022, -0.697711, 0.169569>, <0.115150, -0.699067, 0.705723>, <0.395899, -0.908646, 0.132763>, <-0.139710, -0.699067, 0.701275>, <0.011238, -0.983596, 0.180033>, <-0.397490, -0.597081, 0.696775>, <-0.379842, -0.912679, 0.150790>, <-0.589998, -0.413853, 0.693273>, 
			<-0.700351, -0.698875, 0.145195>, <-0.588133, -0.114190, 0.800662>, <-0.910704, -0.398156, 0.109956>, <-0.711240, 0.127449, 0.691299>, <-0.992972, 0.013674, 0.117556>, <-0.589998, 0.413853, 0.693273>, <-0.910704, 0.398156, 0.109956>, <-0.397490, 0.597081, 0.696775>, <-0.700351, 0.698875, 0.145195>, <-0.139710, 0.699067, 0.701275>, <-0.379842, 0.912679, 0.150790>, 
			<0.115150, 0.699067, 0.705723>, <0.011238, 0.983596, 0.180033>, <0.401513, 0.577809, 0.710580>, <0.395899, 0.908646, 0.132763>, <0.584711, 0.385269, 0.713920>, <0.696022, 0.697711, 0.169569>, <-0.017452, 0.000000, 0.999848>, <0.135422, 0.057386, 0.989125>, <-0.017452, -0.000000, 0.999848>, <0.091131, 0.000000, 0.995839>, <-0.017452, 0.000000, 0.999848>, 
			<0.135422, -0.057386, 0.989125>, <-0.017452, 0.000000, 0.999848>, <0.136405, -0.153465, 0.978694>, <-0.017452, 0.000000, 0.999848>, <0.051704, -0.183106, 0.981733>, <-0.017452, 0.000000, 0.999848>, <-0.017219, -0.163007, 0.986475>, <-0.017452, -0.000000, 0.999848>, <-0.085934, -0.183106, 0.979330>, <-0.017452, -0.000000, 0.999848>, <-0.170478, -0.153465, 0.973337>, 
			<-0.017452, -0.000000, 0.999848>, <-0.169860, -0.057386, 0.983796>, <-0.017452, 0.000000, 0.999848>, <-0.180198, -0.005404, 0.983615>, <-0.017452, 0.000000, 0.999848>, <-0.169860, 0.057386, 0.983796>, <-0.017452, 0.000000, 0.999848>, <-0.148824, 0.131697, 0.980055>, <-0.017452, 0.000000, 0.999848>, <-0.074596, 0.152664, 0.985459>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017219, 0.163007, 0.986475>, <-0.017452, 0.000000, 0.999848>, <0.040159, 0.152664, 0.987462>, <-0.017452, -0.000000, 0.999848>, <0.114530, 0.131697, 0.984652>, <-0.996403, 0.000000, 0.084737>, <-0.980862, 0.194430, -0.010325>, <-0.980862, -0.194430, -0.010325>, <-0.113348, -0.019806, 0.993358>, <-0.027900, 0.194466, 0.980512>, <-0.027900, -0.194466, 0.980512>, 
			<-0.306941, -0.000000, 0.951728>, <-0.223845, 0.194185, 0.955084>, <-0.207836, -0.194210, 0.958690>, <-0.486717, -0.000000, 0.873560>, <-0.391440, 0.194210, 0.899476>, <-0.390874, -0.194210, 0.899722>, <-0.655095, -0.019791, 0.755287>, <-0.549080, 0.213209, 0.808117>, <-0.551763, -0.207791, 0.807701>, <-0.783538, -0.032974, 0.620468>, <-0.696186, 0.213209, 0.685469>, 
			<-0.705644, -0.194210, 0.681432>, <-0.890014, 0.000000, 0.455933>, <-0.826465, 0.207791, 0.523238>, <-0.818856, -0.207791, 0.535068>, <-0.961861, 0.000000, 0.273540>, <-0.919602, 0.175119, 0.351660>, <-0.912589, -0.194210, 0.359810>, <-0.965360, 0.194210, 0.174252>, <-0.966636, -0.180582, 0.181674>, <-0.922673, 0.381396, 0.056672>, <-0.832186, 0.554422, -0.009105>, 
			<-0.092131, 0.381385, 0.919814>, <-0.023157, 0.554479, 0.831876>, <-0.291303, 0.368012, 0.883012>, <-0.175811, 0.553764, 0.813901>, <-0.463117, 0.381104, 0.800177>, <-0.331217, 0.553764, 0.763963>, <-0.599358, 0.381147, 0.703915>, <-0.483459, 0.542124, 0.687291>, <-0.736387, 0.362733, 0.571103>, <-0.598975, 0.553765, 0.578423>, <-0.815852, 0.381104, 0.434909>, 
			<-0.700788, 0.553764, 0.449712>, <-0.889422, 0.381147, 0.252299>, <-0.775057, 0.553764, 0.304354>, <-0.819541, 0.553764, 0.147299>, <-0.707195, 0.705755, 0.042250>, <-0.556602, 0.830754, -0.006485>, <-0.069365, 0.705746, 0.705062>, <-0.014893, 0.830786, 0.556392>, <-0.216461, 0.705440, 0.674907>, <-0.116962, 0.830259, 0.544967>, <-0.343970, 0.705440, 0.619710>, 
			<-0.221033, 0.830259, 0.511678>, <-0.458260, 0.705440, 0.540697>, <-0.316609, 0.830259, 0.458725>, <-0.556360, 0.705440, 0.439111>, <-0.420172, 0.811676, 0.405755>, <-0.631336, 0.705440, 0.322133>, <-0.469495, 0.830259, 0.300407>, <-0.682050, 0.705440, 0.192775>, <-0.519080, 0.830259, 0.203041>, <-0.548717, 0.830259, 0.097872>, <-0.383294, 0.923377, 0.021441>, 
			<-0.195497, 0.980701, -0.002510>, <-0.036091, 0.923375, 0.382200>, <-0.004872, 0.980704, 0.195436>, <-0.116502, 0.923239, 0.366138>, <-0.040041, 0.980608, 0.191847>, <-0.185693, 0.923239, 0.336374>, <-0.076699, 0.980608, 0.180349>, <-0.247749, 0.923239, 0.293684>, <-0.110409, 0.980608, 0.161920>, <-0.302151, 0.923239, 0.237348>, <-0.163919, 0.973691, 0.158295>, 
			<-0.342650, 0.923239, 0.173841>, <-0.165675, 0.980608, 0.104691>, <-0.369981, 0.923239, 0.103653>, <-0.182916, 0.980608, 0.070358>, <-0.193127, 0.980608, 0.033321>, <-0.000076, 0.999997, -0.002289>, <0.195763, 0.980648, 0.002463>, <0.002189, 0.999998, 0.000151>, <0.004970, 0.980654, -0.195688>, <0.001554, 0.999999, 0.000501>, <0.043122, 0.980608, -0.191177>, 
			<0.001426, 0.999999, 0.000795>, <0.079590, 0.980608, -0.179091>, <0.001244, 0.999999, 0.001058>, <0.113000, 0.980608, -0.160123>, <-0.001014, 0.999999, -0.001280>, <0.117876, 0.986482, -0.113832>, <-0.000744, 0.999999, -0.001453>, <0.163969, 0.980608, -0.107343>, <-0.000447, 0.999999, -0.001570>, <0.181760, 0.980608, -0.073292>, <0.192566, 0.980608, -0.036424>, 
			<0.383152, 0.923344, -0.025094>, <0.556715, 0.830668, 0.007666>, <0.039273, 0.923343, -0.381963>, <0.013091, 0.830693, -0.556576>, <0.119366, 0.923239, -0.365214>, <0.119563, 0.830259, -0.544403>, <0.188322, 0.923239, -0.334909>, <0.223473, 0.830259, -0.510617>, <0.250041, 0.923239, -0.291734>, <0.318796, 0.830259, -0.457208>, <0.300283, 0.923239, -0.239707>, 
			<0.381290, 0.847963, -0.368208>, <0.341278, 0.923239, -0.176519>, <0.468055, 0.830259, -0.302645>, <0.369157, 0.923239, -0.106547>, <0.518105, 0.830259, -0.205517>, <0.548244, 0.830259, -0.100491>, <0.707111, 0.705762, -0.043530>, <0.832125, 0.554457, 0.012031>, <0.069517, 0.705759, -0.705033>, <0.018655, 0.554486, -0.831984>, <0.218640, 0.705440, -0.674204>, 
			<0.177538, 0.553764, -0.813526>, <0.345970, 0.705440, -0.618595>, <0.332838, 0.553764, -0.763259>, <0.460004, 0.705440, -0.539214>, <0.462072, 0.569851, -0.679529>, <0.554939, 0.705440, -0.440905>, <0.589035, 0.565278, -0.577493>, <0.630293, 0.705440, -0.324170>, <0.699833, 0.553764, -0.451198>, <0.681424, 0.705440, -0.194977>, <0.774410, 0.553764, -0.305998>, 
			<0.819227, 0.553764, -0.149038>, <0.922732, 0.381485, -0.055098>, <0.980764, 0.194656, 0.014517>, <0.088784, 0.381483, -0.920102>, <0.021444, 0.194665, -0.980635>, <0.284358, 0.381147, -0.879697>, <0.202071, 0.180582, -0.962579>, <0.438603, 0.399380, -0.805061>, <0.376341, 0.194185, -0.905903>, <0.598420, 0.381147, -0.704713>, <0.564649, 0.213209, -0.797317>, 
			<0.724404, 0.381147, -0.574427>, <0.705429, 0.194210, -0.681654>, <0.829622, 0.381104, -0.408029>, <0.822676, 0.175119, -0.540868>, <0.889085, 0.381147, -0.253484>, <0.907509, 0.207791, -0.365036>, <0.965250, 0.194210, -0.174859>, <0.998735, -0.014156, -0.048256>, <0.980764, -0.194656, 0.014517>, <0.084845, 0.014155, -0.996294>, <0.021444, -0.194665, -0.980635>, 
			<0.300241, 0.014138, -0.953759>, <0.208440, -0.194210, -0.958559>, <0.478038, -0.019791, -0.878116>, <0.391440, -0.194210, -0.899476>, <0.647788, -0.000000, -0.761821>, <0.569250, -0.175119, -0.803298>, <0.788213, -0.014138, -0.615241>, <0.705858, -0.194210, -0.681210>, <0.890014, -0.000000, -0.455933>, <0.829878, -0.162376, -0.533795>, <0.961861, 0.000000, -0.273540>, 
			<0.912816, -0.194210, -0.359236>, <0.968044, -0.194185, -0.158689>, <0.922732, -0.381485, -0.055098>, <0.832125, -0.554457, 0.012031>, <0.088784, -0.381483, -0.920102>, <0.018655, -0.554486, -0.831984>, <0.284358, -0.381147, -0.879697>, <0.177538, -0.553764, -0.813526>, <0.438603, -0.399380, -0.805061>, <0.332838, -0.553764, -0.763259>, <0.600451, -0.394189, -0.695754>, 
			<0.475347, -0.553764, -0.683660>, <0.713300, -0.399380, -0.575933>, <0.598975, -0.553765, -0.578423>, <0.829622, -0.381104, -0.408029>, <0.695241, -0.569851, -0.438075>, <0.884157, -0.399380, -0.242407>, <0.774410, -0.553764, -0.305998>, <0.819227, -0.553764, -0.149038>, <0.707111, -0.705762, -0.043530>, <0.556715, -0.830668, 0.007666>, <0.069517, -0.705759, -0.705033>, 
			<0.013091, -0.830693, -0.556576>, <0.218640, -0.705440, -0.674204>, <0.119563, -0.830259, -0.544403>, <0.345970, -0.705440, -0.618595>, <0.223473, -0.830259, -0.510617>, <0.460004, -0.705440, -0.539214>, <0.318796, -0.830259, -0.457208>, <0.554939, -0.705440, -0.440905>, <0.381290, -0.847963, -0.368208>, <0.630293, -0.705440, -0.324170>, <0.468055, -0.830259, -0.302645>, 
			<0.681424, -0.705440, -0.194977>, <0.518105, -0.830259, -0.205517>, <0.548244, -0.830259, -0.100491>, <0.383152, -0.923344, -0.025094>, <0.195763, -0.980648, 0.002463>, <0.039273, -0.923343, -0.381963>, <0.004970, -0.980654, -0.195688>, <0.119366, -0.923239, -0.365214>, <0.043122, -0.980608, -0.191177>, <0.188322, -0.923239, -0.334909>, <0.079590, -0.980608, -0.179091>, 
			<0.250041, -0.923239, -0.291734>, <0.113000, -0.980608, -0.160123>, <0.300283, -0.923239, -0.239707>, <0.117876, -0.986482, -0.113832>, <0.341278, -0.923239, -0.176519>, <0.163969, -0.980608, -0.107343>, <0.369157, -0.923239, -0.106547>, <0.181760, -0.980608, -0.073292>, <0.192566, -0.980608, -0.036424>, <-0.000076, -0.999997, -0.002289>, <-0.195497, -0.980701, -0.002510>, 
			<0.002189, -0.999998, 0.000151>, <-0.004872, -0.980704, 0.195436>, <0.001554, -0.999999, 0.000501>, <-0.040041, -0.980608, 0.191847>, <0.001426, -0.999999, 0.000795>, <-0.076699, -0.980608, 0.180349>, <0.001244, -0.999999, 0.001058>, <-0.110409, -0.980608, 0.161920>, <-0.001014, -0.999999, -0.001280>, <-0.163919, -0.973691, 0.158295>, <-0.000744, -0.999999, -0.001453>, 
			<-0.165675, -0.980608, 0.104691>, <-0.000447, -0.999999, -0.001570>, <-0.182916, -0.980608, 0.070358>, <-0.193127, -0.980608, 0.033321>, <-0.383294, -0.923377, 0.021441>, <-0.556602, -0.830754, -0.006485>, <-0.036091, -0.923375, 0.382200>, <-0.014893, -0.830786, 0.556392>, <-0.116502, -0.923239, 0.366138>, <-0.116962, -0.830259, 0.544967>, <-0.185693, -0.923239, 0.336374>, 
			<-0.221033, -0.830259, 0.511678>, <-0.247749, -0.923239, 0.293684>, <-0.316609, -0.830259, 0.458725>, <-0.302151, -0.923239, 0.237348>, <-0.420172, -0.811676, 0.405755>, <-0.342650, -0.923239, 0.173841>, <-0.469495, -0.830259, 0.300407>, <-0.369981, -0.923239, 0.103653>, <-0.519080, -0.830259, 0.203041>, <-0.548717, -0.830259, 0.097872>, <-0.707195, -0.705755, 0.042250>, 
			<-0.832186, -0.554422, -0.009105>, <-0.069365, -0.705746, 0.705062>, <-0.023157, -0.554479, 0.831876>, <-0.216461, -0.705440, 0.674907>, <-0.175811, -0.553764, 0.813901>, <-0.343970, -0.705440, 0.619710>, <-0.331217, -0.553764, 0.763963>, <-0.458260, -0.705440, 0.540697>, <-0.473895, -0.553764, 0.684667>, <-0.556360, -0.705440, 0.439111>, <-0.600529, -0.537430, 0.592059>, 
			<-0.631336, -0.705440, 0.322133>, <-0.703745, -0.542124, 0.459178>, <-0.682050, -0.705440, 0.192775>, <-0.775057, -0.553764, 0.304354>, <-0.819541, -0.553764, 0.147299>, <-0.922673, -0.381396, 0.056672>, <-0.092131, -0.381385, 0.919814>, <-0.283186, -0.381147, 0.880075>, <-0.457972, -0.368012, 0.809215>, <-0.607042, -0.368012, 0.704320>, <-0.732784, -0.368012, 0.572358>, 
			<-0.815852, -0.381104, 0.434909>, <-0.892640, -0.368012, 0.260308>, <-0.910690, -0.412785, -0.015896>, <-0.999848, -0.000000, -0.017452>, <-0.910690, 0.412785, -0.015896>, <-0.683469, 0.729882, -0.011930>, <-0.352014, 0.935975, -0.006144>, <0.033207, 0.999448, 0.000580>, <0.413324, 0.910555, 0.007215>, <0.730304, 0.683004, 0.012747>, <0.935987, 0.351655, 0.016338>, 
			<0.999848, -0.000000, 0.017452>, <0.935987, -0.351655, 0.016338>, <0.730304, -0.683004, 0.012747>, <0.413324, -0.910555, 0.007215>, <0.033207, -0.999448, 0.000580>, <-0.352014, -0.935975, -0.006144>, <-0.683469, -0.729882, -0.011930>, <0.990941, -0.019782, 0.132832>, <0.979023, 0.194586, 0.060417>, <0.979023, -0.194586, 0.060417>, <0.951728, -0.000000, 0.306941>, 
			<0.955084, 0.194185, 0.223845>, <0.958690, -0.194210, 0.207836>, <0.873560, -0.000000, 0.486717>, <0.899476, 0.194210, 0.391440>, <0.899722, -0.194210, 0.390874>, <0.757192, 0.014138, 0.653040>, <0.805827, 0.194210, 0.559398>, <0.806179, -0.194210, 0.558890>, <0.620806, 0.000000, 0.783964>, <0.688091, 0.180582, 0.702796>, <0.681654, -0.194210, 0.705429>, 
			<0.449646, 0.014138, 0.893095>, <0.523238, 0.207791, 0.826465>, <0.530934, -0.194210, 0.824859>, <0.273540, 0.000000, 0.961861>, <0.366765, 0.180582, 0.912619>, <0.359810, -0.194210, 0.912589>, <0.065894, 0.000000, 0.997827>, <0.183167, 0.213209, 0.959683>, <0.190377, -0.194185, 0.962314>, <-0.004644, 0.213432, 0.976947>, <-0.004644, -0.213432, 0.976947>, 
			<0.917309, 0.381216, 0.114970>, <0.830560, 0.554665, 0.050172>, <0.883012, 0.368012, 0.291303>, <0.813901, 0.553764, 0.175811>, <0.800177, 0.381104, 0.463117>, <0.763963, 0.553764, 0.331217>, <0.703915, 0.381147, 0.599358>, <0.687291, 0.542124, 0.483459>, <0.573461, 0.381147, 0.725169>, <0.579500, 0.537430, 0.612657>, <0.429452, 0.368012, 0.824705>, 
			<0.449712, 0.553764, 0.700788>, <0.252299, 0.381147, 0.889422>, <0.304354, 0.553764, 0.775057>, <0.059974, 0.381385, 0.922469>, <0.147299, 0.553764, 0.819541>, <-0.005890, 0.554479, 0.832177>, <0.703281, 0.705558, 0.087088>, <0.555488, 0.830902, 0.032180>, <0.674907, 0.705440, 0.216461>, <0.544967, 0.830259, 0.116962>, <0.619710, 0.705440, 0.343970>, 
			<0.511678, 0.830259, 0.221033>, <0.540697, 0.705440, 0.458260>, <0.458725, 0.830259, 0.316609>, <0.439111, 0.705440, 0.556360>, <0.405755, 0.811676, 0.420172>, <0.322133, 0.705440, 0.631336>, <0.300407, 0.830259, 0.469495>, <0.192775, 0.705440, 0.682050>, <0.203041, 0.830259, 0.519080>, <0.044717, 0.705746, 0.707053>, <0.097872, 0.830259, 0.548717>, 
			<-0.004534, 0.830786, 0.556573>, <0.381307, 0.923305, 0.045971>, <0.195169, 0.980716, 0.010290>, <0.366138, 0.923239, 0.116502>, <0.191847, 0.980608, 0.040041>, <0.336374, 0.923239, 0.185693>, <0.180349, 0.980608, 0.076699>, <0.293684, 0.923239, 0.247749>, <0.161920, 0.980608, 0.110409>, <0.237348, 0.923239, 0.302151>, <0.158295, 0.973691, 0.163919>, 
			<0.173841, 0.923239, 0.342650>, <0.104691, 0.980608, 0.165675>, <0.103653, 0.923239, 0.369981>, <0.070358, 0.980608, 0.182916>, <0.022731, 0.923375, 0.383226>, <0.033321, 0.980608, 0.193127>, <-0.001951, 0.980704, 0.195487>, <0.000117, 0.999999, -0.001412>, <-0.195292, 0.980684, -0.010951>, <0.000501, 0.999999, -0.001554>, <-0.191177, 0.980608, -0.043122>, 
			<0.000795, 0.999999, -0.001426>, <-0.179091, 0.980608, -0.079590>, <0.001058, 0.999999, -0.001244>, <-0.160123, 0.980608, -0.113000>, <-0.001280, 0.999999, 0.001014>, <-0.113832, 0.986482, -0.117876>, <-0.001453, 0.999999, 0.000744>, <-0.107343, 0.980608, -0.163969>, <-0.001570, 0.999999, 0.000447>, <-0.073292, 0.980608, -0.181760>, <-0.002193, 0.999998, 0.000075>, 
			<-0.036424, 0.980608, -0.192566>, <0.001862, 0.980654, -0.195743>, <-0.381214, 0.923293, -0.046958>, <-0.555790, 0.830861, -0.027704>, <-0.365214, 0.923239, -0.119366>, <-0.544403, 0.830259, -0.119563>, <-0.334909, 0.923239, -0.188322>, <-0.510617, 0.830259, -0.223473>, <-0.291734, 0.923239, -0.250041>, <-0.457208, 0.830259, -0.318796>, <-0.239707, 0.923239, -0.300283>, 
			<-0.368208, 0.847963, -0.381290>, <-0.176519, 0.923239, -0.341278>, <-0.302645, 0.830259, -0.468055>, <-0.106547, 0.923239, -0.369157>, <-0.205517, 0.830259, -0.518105>, <-0.025919, 0.923343, -0.383101>, <-0.100491, 0.830259, -0.548244>, <0.006341, 0.830693, -0.556694>, <-0.703646, 0.705647, -0.083336>, <-0.831170, 0.554708, -0.038162>, <-0.674204, 0.705440, -0.218640>, 
			<-0.813526, 0.553764, -0.177538>, <-0.618595, 0.705440, -0.345970>, <-0.763259, 0.553764, -0.332838>, <-0.539214, 0.705440, -0.460004>, <-0.683660, 0.553764, -0.475347>, <-0.440905, 0.705440, -0.554939>, <-0.577493, 0.565278, -0.589035>, <-0.324170, 0.705440, -0.630293>, <-0.451198, 0.553764, -0.699833>, <-0.194977, 0.705440, -0.681424>, <-0.305998, 0.553764, -0.774410>, 
			<-0.044870, 0.705759, -0.707030>, <-0.149038, 0.553764, -0.819227>, <0.010392, 0.554486, -0.832128>, <-0.918338, 0.381396, -0.105795>, <-0.979921, 0.194740, -0.042800>, <-0.875159, 0.399380, -0.273116>, <-0.961917, 0.194185, -0.192377>, <-0.815258, 0.368012, -0.447126>, <-0.899722, 0.194210, -0.390874>, <-0.704480, 0.394189, -0.590188>, <-0.800419, 0.225839, -0.555271>, 
			<-0.574427, 0.381147, -0.724404>, <-0.671839, 0.213209, -0.709348>, <-0.422065, 0.381147, -0.822550>, <-0.526376, 0.180582, -0.830854>, <-0.253484, 0.381147, -0.889085>, <-0.359810, 0.194210, -0.912589>, <-0.056619, 0.381483, -0.922640>, <-0.168354, 0.180582, -0.969044>, <0.013324, 0.181043, -0.983385>, <-0.994335, 0.014140, -0.105345>, <-0.979921, -0.194740, -0.042800>, 
			<-0.949461, -0.014138, -0.313566>, <-0.958559, -0.194210, -0.208440>, <-0.873085, -0.032974, -0.486452>, <-0.904661, -0.180582, -0.385978>, <-0.767983, -0.019791, -0.640164>, <-0.811978, -0.180582, -0.555052>, <-0.620806, 0.000000, -0.783964>, <-0.681210, -0.194210, -0.705858>, <-0.462107, 0.014138, -0.886712>, <-0.530415, -0.194210, -0.825193>, <-0.273540, 0.000000, -0.961861>, 
			<-0.359236, -0.194210, -0.912816>, <-0.059982, 0.000000, -0.998199>, <-0.158689, -0.194185, -0.968044>, <0.013324, -0.181043, -0.983385>, <-0.918338, -0.381396, -0.105795>, <-0.831170, -0.554708, -0.038162>, <-0.879697, -0.381147, -0.284358>, <-0.813526, -0.553764, -0.177538>, <-0.807319, -0.381147, -0.450514>, <-0.763259, -0.553764, -0.332838>, <-0.703915, -0.381147, -0.599358>, 
			<-0.683660, -0.553764, -0.475347>, <-0.573461, -0.381147, -0.725169>, <-0.568522, -0.565278, -0.597698>, <-0.408029, -0.381104, -0.829622>, <-0.438075, -0.569851, -0.695241>, <-0.242407, -0.399380, -0.884157>, <-0.305998, -0.553764, -0.774410>, <-0.056619, -0.381483, -0.922640>, <-0.149038, -0.553764, -0.819227>, <0.010392, -0.554486, -0.832128>, <-0.703646, -0.705647, -0.083336>, 
			<-0.555790, -0.830861, -0.027704>, <-0.674204, -0.705440, -0.218640>, <-0.544403, -0.830259, -0.119563>, <-0.618595, -0.705440, -0.345970>, <-0.510617, -0.830259, -0.223473>, <-0.539214, -0.705440, -0.460004>, <-0.457208, -0.830259, -0.318796>, <-0.440905, -0.705440, -0.554939>, <-0.368208, -0.847963, -0.381290>, <-0.324170, -0.705440, -0.630293>, <-0.302645, -0.830259, -0.468055>, 
			<-0.194977, -0.705440, -0.681424>, <-0.205517, -0.830259, -0.518105>, <-0.044870, -0.705759, -0.707030>, <-0.100491, -0.830259, -0.548244>, <0.006341, -0.830693, -0.556694>, <-0.381214, -0.923293, -0.046958>, <-0.195292, -0.980684, -0.010951>, <-0.365214, -0.923239, -0.119366>, <-0.191177, -0.980608, -0.043122>, <-0.334909, -0.923239, -0.188322>, <-0.179091, -0.980608, -0.079590>, 
			<-0.291734, -0.923239, -0.250041>, <-0.160123, -0.980608, -0.113000>, <-0.239707, -0.923239, -0.300283>, <-0.113832, -0.986482, -0.117876>, <-0.176519, -0.923239, -0.341278>, <-0.107343, -0.980608, -0.163969>, <-0.106547, -0.923239, -0.369157>, <-0.073292, -0.980608, -0.181760>, <-0.025919, -0.923343, -0.383101>, <-0.036424, -0.980608, -0.192566>, <0.001862, -0.980654, -0.195743>, 
			<0.000117, -0.999999, -0.001412>, <0.195169, -0.980716, 0.010290>, <0.000501, -0.999999, -0.001554>, <0.191847, -0.980608, 0.040041>, <0.000795, -0.999999, -0.001426>, <0.180349, -0.980608, 0.076699>, <0.001058, -0.999999, -0.001244>, <0.161920, -0.980608, 0.110409>, <-0.001280, -0.999999, 0.001014>, <0.158295, -0.973691, 0.163919>, <-0.001453, -0.999999, 0.000744>, 
			<0.104691, -0.980608, 0.165675>, <-0.001570, -0.999999, 0.000447>, <0.070358, -0.980608, 0.182916>, <-0.002193, -0.999998, 0.000075>, <0.033321, -0.980608, 0.193127>, <-0.001951, -0.980704, 0.195487>, <0.381307, -0.923305, 0.045971>, <0.555488, -0.830902, 0.032180>, <0.366138, -0.923239, 0.116502>, <0.544967, -0.830259, 0.116962>, <0.336374, -0.923239, 0.185693>, 
			<0.511678, -0.830259, 0.221033>, <0.293684, -0.923239, 0.247749>, <0.458725, -0.830259, 0.316609>, <0.237348, -0.923239, 0.302151>, <0.405755, -0.811676, 0.420172>, <0.173841, -0.923239, 0.342650>, <0.300407, -0.830259, 0.469495>, <0.103653, -0.923239, 0.369981>, <0.203041, -0.830259, 0.519080>, <0.022731, -0.923375, 0.383226>, <0.097872, -0.830259, 0.548717>, 
			<-0.004534, -0.830786, 0.556573>, <0.703281, -0.705558, 0.087088>, <0.830560, -0.554665, 0.050172>, <0.674907, -0.705440, 0.216461>, <0.813901, -0.553764, 0.175811>, <0.619710, -0.705440, 0.343970>, <0.763963, -0.553764, 0.331217>, <0.540697, -0.705440, 0.458260>, <0.687291, -0.542124, 0.483459>, <0.439111, -0.705440, 0.556360>, <0.592059, -0.537430, 0.600529>, 
			<0.322133, -0.705440, 0.631336>, <0.459178, -0.542124, 0.703745>, <0.192775, -0.705440, 0.682050>, <0.304354, -0.553764, 0.775057>, <0.044717, -0.705746, 0.707053>, <0.147299, -0.553764, 0.819541>, <-0.005890, -0.554479, 0.832177>, <0.917309, -0.381216, 0.114970>, <0.880075, -0.381147, 0.283186>, <0.807918, -0.381147, 0.449438>, <0.704480, -0.394189, 0.590188>, 
			<0.574427, -0.381147, 0.724404>, <0.434909, -0.381104, 0.815852>, <0.260308, -0.368012, 0.892640>, <0.059974, -0.381385, 0.922469>, <-0.018331, -0.000000, 0.999832>, <-0.015896, 0.412789, 0.910688>, <-0.011930, 0.729885, 0.683466>, <-0.006144, 0.935975, 0.352012>, <0.000580, 0.999448, -0.033207>, <0.007215, 0.910556, -0.413322>, <0.012747, 0.683005, -0.730302>, 
			<0.016338, 0.351656, -0.935987>, <0.017139, 0.000000, -0.999853>, <0.016338, -0.351656, -0.935987>, <0.012747, -0.683005, -0.730302>, <0.007215, -0.910556, -0.413322>, <0.000580, -0.999448, -0.033207>, <-0.006144, -0.935975, 0.352012>, <-0.011930, -0.729885, 0.683466>, <-0.015896, -0.412789, 0.910688>, <0.980636, 0.195090, 0.017117>, <0.923597, 0.382543, 0.025081>, 
			<0.980636, -0.195090, 0.017117>, <0.999523, -0.000000, 0.030898>, <0.831343, -0.555570, 0.014511>, <0.923597, -0.382543, 0.025081>, <0.555486, -0.831470, 0.009696>, <0.706988, -0.706980, 0.018628>, <0.195061, -0.980785, 0.003405>, <0.382658, -0.923840, 0.009589>, <-0.195061, -0.980785, -0.003405>, <-0.000030, -1.000000, -0.000222>, <-0.555486, -0.831470, -0.009696>, 
			<-0.382716, -0.923821, -0.009106>, <-0.831343, -0.555570, -0.014511>, <-0.707057, -0.706978, -0.015894>, <-0.980636, -0.195090, -0.017117>, <-0.923702, -0.382587, -0.020055>, <-0.980636, 0.195090, -0.017117>, <-0.999798, -0.000000, -0.020117>, <-0.831343, 0.555570, -0.014511>, <-0.923702, 0.382587, -0.020055>, <-0.555486, 0.831470, -0.009696>, <-0.707057, 0.706978, -0.015894>, 
			<-0.195061, 0.980785, -0.003405>, <-0.382716, 0.923821, -0.009106>, <0.195061, 0.980785, 0.003405>, <-0.000030, 1.000000, -0.000222>, <0.555486, 0.831470, 0.009696>, <0.382658, 0.923840, 0.009589>, <0.831343, 0.555570, 0.014511>, <0.706988, 0.706980, 0.018628>, <0.711240, 0.127449, -0.691299>, <0.910704, 0.398156, -0.109956>, <0.661811, -0.114028, -0.740947>, 
			<0.990132, -0.000000, -0.140137>, <0.589998, -0.413853, -0.693273>, <0.910704, -0.398156, -0.109956>, <0.397490, -0.597081, -0.696775>, <0.700351, -0.698875, -0.145195>, <0.128323, -0.574070, -0.808688>, <0.379842, -0.912679, -0.150790>, <-0.115150, -0.699067, -0.705723>, <-0.029971, -0.987007, -0.157859>, <-0.401513, -0.577809, -0.710580>, <-0.395899, -0.908646, -0.132763>, 
			<-0.584711, -0.385269, -0.713920>, <-0.696022, -0.697711, -0.169569>, <-0.609880, -0.131137, -0.781568>, <-0.909793, -0.377153, -0.173300>, <-0.686681, 0.127449, -0.715699>, <-0.978398, 0.019135, -0.205842>, <-0.584711, 0.385269, -0.713920>, <-0.909793, 0.377153, -0.173300>, <-0.401513, 0.577809, -0.710580>, <-0.696022, 0.697711, -0.169569>, <-0.115150, 0.699067, -0.705723>, 
			<-0.395899, 0.908646, -0.132763>, <0.128323, 0.574070, -0.808688>, <-0.029971, 0.987007, -0.157859>, <0.397490, 0.597081, -0.696775>, <0.379842, 0.912679, -0.150790>, <0.589998, 0.413853, -0.693273>, <0.700351, 0.698875, -0.145195>, <0.017452, 0.000000, -0.999848>, <0.169860, 0.057386, -0.983796>, <0.017452, -0.000000, -0.999848>, <0.180198, -0.005404, -0.983615>, 
			<0.017452, 0.000000, -0.999848>, <0.169860, -0.057386, -0.983796>, <0.017452, 0.000000, -0.999848>, <0.170478, -0.153465, -0.973337>, <0.017452, 0.000000, -0.999848>, <0.085934, -0.183106, -0.979330>, <0.017452, 0.000000, -0.999848>, <0.023596, -0.195507, -0.980418>, <0.017452, 0.000000, -0.999848>, <-0.051704, -0.183106, -0.981733>, <0.017452, 0.000000, -0.999848>, 
			<-0.136405, -0.153465, -0.978694>, <0.017452, -0.000000, -0.999848>, <-0.135422, -0.057386, -0.989125>, <0.017452, 0.000000, -0.999848>, <-0.113004, 0.000000, -0.993595>, <0.017452, -0.000000, -0.999848>, <-0.135422, 0.057386, -0.989125>, <0.017452, -0.000000, -0.999848>, <-0.114530, 0.131697, -0.984652>, <0.017452, -0.000000, -0.999848>, <-0.040159, 0.152664, -0.987462>, 
			<0.017452, -0.000000, -0.999848>, <0.023596, 0.195507, -0.980418>, <0.017452, 0.000000, -0.999848>, <0.074596, 0.152664, -0.985459>, <0.017452, -0.000000, -0.999848>, <0.148824, 0.131697, -0.980055>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.176549, 0.034485, -0.983688>, <0.149812, 0.094984, -0.984141>, <0.112188, 0.132613, -0.984798>, <0.054218, 0.158868, -0.985810>, <-0.019780, 0.158868, -0.987102>, <-0.077751, 0.132613, -0.988114>, <-0.115375, 0.094984, -0.988770>, <-0.143387, -0.000351, -0.989667>, 
			<-0.142111, -0.034483, -0.989250>, <-0.115375, -0.094984, -0.988770>, <-0.077751, -0.132613, -0.988114>, <-0.019780, -0.158868, -0.987102>, <0.054218, -0.158868, -0.985810>, <0.112188, -0.132613, -0.984798>, <0.149812, -0.094984, -0.984141>, <0.176549, -0.034483, -0.983688>, <-0.981004, 0.080121, -0.176666>, <0.984540, 0.102109, -0.142321>, <0.948282, 0.297396, -0.110978>, 
			<0.873087, 0.465734, -0.144263>, <0.765518, 0.626598, -0.146140>, <0.628637, 0.763383, -0.148530>, <0.467706, 0.870832, -0.151339>, <0.288907, 0.944815, -0.154460>, <0.092485, 0.979195, -0.180620>, <-0.109997, 0.980740, -0.161402>, <-0.299134, 0.939889, -0.164703>, <-0.462880, 0.870436, -0.167582>, <-0.623720, 0.762850, -0.170390>, <-0.760484, 0.625949, -0.172777>, 
			<-0.867916, 0.464993, -0.174652>, <-0.941888, 0.286168, -0.175943>, <-0.973653, -0.092739, -0.208327>, <-0.941888, -0.286168, -0.175943>, <-0.867916, -0.464993, -0.174652>, <-0.760484, -0.625949, -0.172777>, <-0.623720, -0.762850, -0.170390>, <-0.462880, -0.870436, -0.167582>, <-0.299134, -0.939889, -0.164703>, <-0.109997, -0.980740, -0.161402>, <0.092485, -0.979195, -0.180620>, 
			<0.288907, -0.944815, -0.154460>, <0.467706, -0.870832, -0.151339>, <0.628637, -0.763383, -0.148530>, <0.765518, -0.626598, -0.146140>, <0.873087, -0.465734, -0.144263>, <0.948282, -0.297396, -0.110978>, <0.984540, -0.102109, -0.142321>, <0.989749, -0.000022, -0.142814>, <-0.988004, 0.000292, -0.154429>, <0.996503, 0.081728, 0.017394>, <0.177606, -0.009600, -0.984055>, 
			<0.123969, 0.000000, -0.992286>, <0.177606, 0.009600, -0.984055>, <0.171925, 0.044188, -0.984119>, <0.160333, 0.073524, -0.984321>, <0.143241, 0.100035, -0.984619>, <0.117244, 0.126035, -0.985073>, <0.090738, 0.143129, -0.985536>, <0.061406, 0.154723, -0.986048>, <0.029914, 0.128021, -0.991320>, <0.004073, 0.160371, -0.987048>, <-0.026957, 0.154723, -0.987590>, 
			<-0.056288, 0.143129, -0.988102>, <-0.082794, 0.126035, -0.988565>, <-0.108791, 0.100035, -0.989018>, <-0.125883, 0.073524, -0.989317>, <-0.137475, 0.044188, -0.989519>, <-0.143155, 0.009600, -0.989654>, <-0.089263, -0.000000, -0.996008>, <-0.143155, -0.009600, -0.989654>, <-0.137475, -0.044188, -0.989519>, <-0.125883, -0.073524, -0.989317>, <-0.108791, -0.100035, -0.989018>, 
			<-0.082794, -0.126035, -0.988565>, <-0.056288, -0.143129, -0.988102>, <-0.026957, -0.154723, -0.987590>, <0.004073, -0.160371, -0.987048>, <0.029914, -0.128021, -0.991320>, <0.061406, -0.154723, -0.986048>, <0.090738, -0.143129, -0.985536>, <0.117244, -0.126035, -0.985073>, <0.143241, -0.100035, -0.984619>, <0.160333, -0.073524, -0.984321>, <0.171925, -0.044188, -0.984119>, 
			<0.209759, -0.000422, -0.977753>, <-0.142112, 0.034481, -0.989250>, <-0.984223, 0.000009, -0.176931>, <-0.970189, -0.167402, -0.175242>, <-0.817789, -0.549319, -0.171665>, <-0.545147, -0.821558, -0.166906>, <-0.158320, -0.974326, -0.160073>, <0.196169, -0.968407, -0.153967>, <0.551982, -0.820661, -0.147756>, <0.824179, -0.547976, -0.143005>, <0.982001, -0.125630, -0.141034>, 
			<0.989796, 0.002081, -0.142474>, <0.982000, 0.125636, -0.141034>, <0.824178, 0.547978, -0.143005>, <0.551982, 0.820661, -0.147756>, <0.196169, 0.968407, -0.153967>, <-0.158320, 0.974326, -0.160073>, <-0.545147, 0.821558, -0.166906>, <-0.817791, 0.549317, -0.171665>, <-0.970191, 0.167394, -0.175242>, <-0.984540, 0.102109, 0.142321>, <0.973653, 0.092739, 0.208327>, 
			<0.941888, 0.286168, 0.175943>, <0.867916, 0.464993, 0.174652>, <0.760484, 0.625949, 0.172777>, <0.623720, 0.762850, 0.170390>, <0.462880, 0.870436, 0.167582>, <0.299134, 0.939889, 0.164703>, <0.109997, 0.980740, 0.161402>, <-0.099113, 0.982489, 0.157773>, <-0.288907, 0.944815, 0.154460>, <-0.467706, 0.870832, 0.151339>, <-0.628637, 0.763383, 0.148530>, 
			<-0.765518, 0.626598, 0.146140>, <-0.873087, 0.465734, 0.144263>, <-0.948282, 0.297396, 0.110978>, <-0.984540, -0.102109, 0.142321>, <-0.948282, -0.297396, 0.110978>, <-0.873087, -0.465734, 0.144263>, <-0.765518, -0.626598, 0.146140>, <-0.628637, -0.763383, 0.148530>, <-0.467706, -0.870832, 0.151339>, <-0.288907, -0.944815, 0.154460>, <-0.099113, -0.982489, 0.157773>, 
			<0.109997, -0.980740, 0.161402>, <0.299134, -0.939889, 0.164703>, <0.462880, -0.870436, 0.167582>, <0.623720, -0.762850, 0.170390>, <0.760484, -0.625949, 0.172777>, <0.867916, -0.464993, 0.174652>, <0.941888, -0.286168, 0.175943>, <0.973653, -0.092739, 0.208327>, <0.977899, 0.000409, 0.209077>, <-0.989749, -0.000022, 0.142814>, <-0.996503, 0.081728, -0.017394>, 
			<0.956795, 0.290285, 0.016701>, <0.881787, 0.471397, 0.015392>, <0.772893, 0.634393, 0.013491>, <0.634297, 0.773010, 0.011072>, <0.471325, 0.881921, 0.008227>, <0.290241, 0.956940, 0.005066>, <0.098002, 0.995185, 0.001711>, <-0.098002, 0.995185, -0.001711>, <-0.290241, 0.956940, -0.005066>, <-0.471325, 0.881921, -0.008227>, <-0.634297, 0.773010, -0.011072>, 
			<-0.772893, 0.634393, -0.013491>, <-0.881787, 0.471397, -0.015392>, <-0.956795, 0.290285, -0.016701>, <-0.996503, -0.081728, -0.017394>, <-0.956795, -0.290285, -0.016701>, <-0.881787, -0.471397, -0.015392>, <-0.772893, -0.634393, -0.013491>, <-0.634297, -0.773010, -0.011072>, <-0.471325, -0.881921, -0.008227>, <-0.290241, -0.956940, -0.005066>, <-0.098002, -0.995185, -0.001711>, 
			<0.098002, -0.995185, 0.001711>, <0.290241, -0.956940, 0.005066>, <0.471325, -0.881921, 0.008227>, <0.634297, -0.773010, 0.011072>, <0.772893, -0.634393, 0.013491>, <0.881787, -0.471397, 0.015392>, <0.956795, -0.290285, 0.016701>, <0.995349, -0.094760, 0.017374>, <0.999848, -0.000431, 0.017452>, <-0.999848, -0.000431, -0.017452>, <0.143155, -0.009600, 0.989654>, 
			<0.089263, 0.000000, 0.996008>, <0.143155, 0.009600, 0.989654>, <0.137475, 0.044188, 0.989519>, <0.125883, 0.073524, 0.989317>, <0.108791, 0.100035, 0.989018>, <0.082794, 0.126035, 0.988565>, <0.056288, 0.143129, 0.988102>, <0.026957, 0.154723, 0.987590>, <-0.004073, 0.160371, 0.987048>, <-0.030377, 0.160371, 0.986589>, <-0.061406, 0.154723, 0.986048>, 
			<-0.090738, 0.143129, 0.985536>, <-0.117244, 0.126035, 0.985073>, <-0.143241, 0.100035, 0.984619>, <-0.160333, 0.073524, 0.984321>, <-0.171925, 0.044188, 0.984119>, <-0.177606, 0.009600, 0.984055>, <-0.123969, 0.000000, 0.992286>, <-0.177606, -0.009600, 0.984055>, <-0.171925, -0.044188, 0.984119>, <-0.160333, -0.073524, 0.984321>, <-0.143241, -0.100035, 0.984619>, 
			<-0.117244, -0.126035, 0.985073>, <-0.090738, -0.143129, 0.985536>, <-0.061406, -0.154723, 0.986048>, <-0.030377, -0.160371, 0.986589>, <-0.004073, -0.160371, 0.987048>, <0.026957, -0.154723, 0.987590>, <0.056288, -0.143129, 0.988102>, <0.082794, -0.126035, 0.988565>, <0.108791, -0.100035, 0.989018>, <0.125883, -0.073524, 0.989317>, <0.137475, -0.044188, 0.989519>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <0.143387, -0.000352, 0.989667>, <0.142111, -0.034483, 0.989250>, <0.115375, -0.094984, 0.988770>, <0.077751, -0.132613, 0.988114>, <0.019780, -0.158868, 0.987102>, 
			<-0.053483, -0.182703, 0.981712>, <-0.112188, -0.132613, 0.984798>, <-0.149812, -0.094984, 0.984141>, <-0.176549, -0.034483, 0.983688>, <-0.209759, -0.000421, 0.977753>, <-0.176549, 0.034481, 0.983688>, <-0.149812, 0.094984, 0.984141>, <-0.112188, 0.132613, 0.984798>, <-0.053483, 0.182703, 0.981712>, <0.019780, 0.158868, 0.987102>, <0.077751, 0.132613, 0.988114>, 
			<0.115374, 0.094984, 0.988770>, <0.142111, 0.034485, 0.989250>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <0.831343, -0.555570, 0.014511>, 
			<-0.985613, 0.168137, -0.017204>, <-0.195061, -0.980785, -0.003405>, <0.555486, -0.831470, 0.009696>, <-0.017452, -0.000000, 0.999848>, <-0.195061, 0.980785, -0.003405>, <-0.831344, 0.555568, -0.014511>, <0.999848, -0.000002, 0.017452>, <0.555486, 0.831470, 0.009696>, <-0.555486, 0.831470, -0.009696>, <0.831342, 0.555572, 0.014511>, <-0.831343, -0.555570, -0.014511>, 
			<-0.999848, 0.000002, -0.017452>, <-0.555486, -0.831470, -0.009696>, <0.985612, -0.168148, 0.017204>, <0.195061, -0.980785, 0.003405>, <0.985610, 0.168157, 0.017204>, <0.195061, 0.980785, 0.003405>, <-0.985612, -0.168146, -0.017204>, <-0.215020, -0.968950, 0.122077>, <0.984223, 0.000005, 0.176931>, <0.817789, -0.549319, 0.171665>, <-0.551982, -0.820661, 0.147756>, 
			<-0.824179, -0.547976, 0.143005>, <0.158320, -0.974326, 0.160073>, <0.970189, -0.167404, 0.175242>, <-0.982002, 0.125621, 0.141034>, <-0.551982, 0.820661, 0.147756>, <0.970187, 0.167413, 0.175242>, <0.545147, -0.821558, 0.166906>, <-0.215020, 0.968950, 0.122077>, <-0.824181, 0.547974, 0.143005>, <0.817788, 0.549321, 0.171665>, <0.158320, 0.974326, 0.160073>, 
			<-0.989796, 0.002084, 0.142474>, <-0.982002, -0.125627, 0.141034>, <0.545147, 0.821558, 0.166906>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <-0.017452, 0.000000, 0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.176549, 0.034485, -0.983688>, <0.149812, 0.094984, -0.984141>, <0.112188, 0.132613, -0.984798>, <0.054218, 0.158868, -0.985810>, <-0.019780, 0.158868, -0.987102>, <-0.077751, 0.132613, -0.988114>, <-0.115375, 0.094984, -0.988770>, <-0.143387, -0.000351, -0.989667>, <-0.142111, -0.034483, -0.989250>, 
			<-0.115375, -0.094984, -0.988770>, <-0.077751, -0.132613, -0.988114>, <-0.019780, -0.158868, -0.987102>, <0.054218, -0.158868, -0.985810>, <0.112188, -0.132613, -0.984798>, <0.149812, -0.094984, -0.984141>, <0.176549, -0.034483, -0.983688>, <-0.973653, 0.092739, -0.208327>, <0.984540, 0.102109, -0.142321>, <0.948282, 0.297396, -0.110978>, <0.873087, 0.465734, -0.144263>, 
			<0.765518, 0.626598, -0.146140>, <0.628637, 0.763383, -0.148530>, <0.467706, 0.870832, -0.151339>, <0.288907, 0.944815, -0.154460>, <0.092485, 0.979195, -0.180620>, <-0.109997, 0.980740, -0.161402>, <-0.299134, 0.939889, -0.164703>, <-0.462880, 0.870436, -0.167582>, <-0.623720, 0.762850, -0.170390>, <-0.760484, 0.625949, -0.172777>, <-0.867916, 0.464993, -0.174652>, 
			<-0.941888, 0.286168, -0.175943>, <-0.981004, -0.080121, -0.176666>, <-0.941888, -0.286168, -0.175943>, <-0.867916, -0.464993, -0.174652>, <-0.760484, -0.625949, -0.172777>, <-0.623720, -0.762850, -0.170390>, <-0.462880, -0.870436, -0.167582>, <-0.299134, -0.939889, -0.164703>, <-0.109997, -0.980740, -0.161402>, <0.092485, -0.979195, -0.180620>, <0.288907, -0.944815, -0.154460>, 
			<0.467706, -0.870832, -0.151339>, <0.628637, -0.763383, -0.148530>, <0.765518, -0.626598, -0.146140>, <0.873087, -0.465734, -0.144263>, <0.948282, -0.297396, -0.110978>, <0.984540, -0.102109, -0.142321>, <0.989749, -0.000022, -0.142814>, <-0.977899, 0.000409, -0.209077>, <0.996503, 0.081728, 0.017394>, <0.177606, -0.009600, -0.984055>, <0.123969, -0.000000, -0.992286>, 
			<0.177606, 0.009600, -0.984055>, <0.171925, 0.044188, -0.984119>, <0.160333, 0.073524, -0.984321>, <0.143241, 0.100035, -0.984619>, <0.117244, 0.126035, -0.985073>, <0.090738, 0.143129, -0.985536>, <0.061406, 0.154723, -0.986048>, <0.029914, 0.128021, -0.991320>, <0.004073, 0.160371, -0.987048>, <-0.026957, 0.154723, -0.987590>, <-0.056288, 0.143129, -0.988102>, 
			<-0.082794, 0.126035, -0.988565>, <-0.108791, 0.100035, -0.989018>, <-0.125883, 0.073524, -0.989317>, <-0.137475, 0.044188, -0.989519>, <-0.143155, 0.009600, -0.989654>, <-0.089263, -0.000000, -0.996008>, <-0.143155, -0.009600, -0.989654>, <-0.137475, -0.044188, -0.989519>, <-0.125883, -0.073524, -0.989317>, <-0.108791, -0.100035, -0.989018>, <-0.082794, -0.126035, -0.988565>, 
			<-0.056288, -0.143129, -0.988102>, <-0.026957, -0.154723, -0.987590>, <0.004073, -0.160371, -0.987048>, <0.029914, -0.128021, -0.991320>, <0.061406, -0.154723, -0.986048>, <0.090738, -0.143129, -0.985536>, <0.117244, -0.126035, -0.985073>, <0.143241, -0.100035, -0.984619>, <0.160333, -0.073524, -0.984321>, <0.171925, -0.044188, -0.984119>, <0.209759, -0.000422, -0.977753>, 
			<-0.142112, 0.034481, -0.989250>, <-0.988049, 0.000897, -0.154139>, <-0.970189, -0.167402, -0.175242>, <-0.817789, -0.549319, -0.171665>, <-0.545147, -0.821558, -0.166906>, <-0.158320, -0.974326, -0.160073>, <0.196169, -0.968407, -0.153967>, <0.551982, -0.820661, -0.147756>, <0.824179, -0.547976, -0.143005>, <0.982001, -0.125630, -0.141034>, <0.989796, 0.002081, -0.142474>, 
			<0.982000, 0.125636, -0.141034>, <0.824178, 0.547978, -0.143005>, <0.551982, 0.820661, -0.147756>, <0.196169, 0.968407, -0.153967>, <-0.158320, 0.974326, -0.160073>, <-0.545147, 0.821558, -0.166906>, <-0.817791, 0.549317, -0.171665>, <-0.970191, 0.167394, -0.175242>, <-0.988761, 0.089908, 0.119452>, <0.973653, 0.092739, 0.208327>, <0.941888, 0.286168, 0.175943>, 
			<0.867916, 0.464993, 0.174652>, <0.760484, 0.625949, 0.172777>, <0.623720, 0.762850, 0.170390>, <0.462880, 0.870436, 0.167582>, <0.299134, 0.939889, 0.164703>, <0.109997, 0.980740, 0.161402>, <-0.099113, 0.982489, 0.157773>, <-0.288907, 0.944815, 0.154460>, <-0.467706, 0.870832, 0.151339>, <-0.628637, 0.763383, 0.148530>, <-0.765518, 0.626598, 0.146140>, 
			<-0.873087, 0.465734, 0.144263>, <-0.948282, 0.297396, 0.110978>, <-0.984540, -0.102109, 0.142321>, <-0.948282, -0.297396, 0.110978>, <-0.873087, -0.465734, 0.144263>, <-0.765518, -0.626598, 0.146140>, <-0.628637, -0.763383, 0.148530>, <-0.467706, -0.870832, 0.151339>, <-0.288907, -0.944815, 0.154460>, <-0.099113, -0.982489, 0.157773>, <0.109997, -0.980740, 0.161402>, 
			<0.299134, -0.939889, 0.164703>, <0.462880, -0.870436, 0.167582>, <0.623720, -0.762850, 0.170390>, <0.760484, -0.625949, 0.172777>, <0.867916, -0.464993, 0.174652>, <0.941888, -0.286168, 0.175943>, <0.981004, -0.080121, 0.176666>, <0.984162, -0.000022, 0.177269>, <-0.989749, -0.000022, 0.142814>, <-0.997223, 0.072411, -0.017407>, <0.956795, 0.290285, 0.016701>, 
			<0.881787, 0.471397, 0.015392>, <0.772893, 0.634393, 0.013491>, <0.634297, 0.773010, 0.011072>, <0.471325, 0.881921, 0.008227>, <0.290241, 0.956940, 0.005066>, <0.098002, 0.995185, 0.001711>, <-0.098002, 0.995185, -0.001711>, <-0.290241, 0.956940, -0.005066>, <-0.471325, 0.881921, -0.008227>, <-0.634297, 0.773010, -0.011072>, <-0.772893, 0.634393, -0.013491>, 
			<-0.881787, 0.471397, -0.015392>, <-0.956795, 0.290285, -0.016701>, <-0.995349, -0.094760, -0.017374>, <-0.956795, -0.290285, -0.016701>, <-0.881787, -0.471397, -0.015392>, <-0.772893, -0.634393, -0.013491>, <-0.634297, -0.773010, -0.011072>, <-0.471325, -0.881921, -0.008227>, <-0.290241, -0.956940, -0.005066>, <-0.098002, -0.995185, -0.001711>, <0.098002, -0.995185, 0.001711>, 
			<0.290241, -0.956940, 0.005066>, <0.471325, -0.881921, 0.008227>, <0.634297, -0.773010, 0.011072>, <0.772893, -0.634393, 0.013491>, <0.881787, -0.471397, 0.015392>, <0.956795, -0.290285, 0.016701>, <0.995349, -0.094760, 0.017374>, <0.999847, -0.000718, 0.017452>, <-0.999848, 0.000000, -0.017452>, <0.143155, -0.009600, 0.989654>, <0.089263, -0.000000, 0.996008>, 
			<0.143155, 0.009600, 0.989654>, <0.137475, 0.044188, 0.989519>, <0.125883, 0.073524, 0.989317>, <0.108791, 0.100035, 0.989018>, <0.082794, 0.126035, 0.988565>, <0.056288, 0.143129, 0.988102>, <0.026957, 0.154723, 0.987590>, <-0.004073, 0.160371, 0.987048>, <-0.030377, 0.160371, 0.986589>, <-0.061406, 0.154723, 0.986048>, <-0.090738, 0.143129, 0.985536>, 
			<-0.117244, 0.126035, 0.985073>, <-0.143241, 0.100035, 0.984619>, <-0.160333, 0.073524, 0.984321>, <-0.171925, 0.044188, 0.984119>, <-0.177606, 0.009600, 0.984055>, <-0.123969, 0.000000, 0.992286>, <-0.177606, -0.009600, 0.984055>, <-0.171925, -0.044188, 0.984119>, <-0.160333, -0.073524, 0.984321>, <-0.143241, -0.100035, 0.984619>, <-0.117244, -0.126035, 0.985073>, 
			<-0.090738, -0.143129, 0.985536>, <-0.061406, -0.154723, 0.986048>, <-0.030377, -0.160371, 0.986589>, <-0.004073, -0.160371, 0.987048>, <0.026957, -0.154723, 0.987590>, <0.056288, -0.143129, 0.988102>, <0.082794, -0.126035, 0.988565>, <0.108791, -0.100035, 0.989018>, <0.125883, -0.073524, 0.989317>, <0.137475, -0.044188, 0.989519>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <0.143387, -0.000352, 0.989667>, <0.142111, -0.034483, 0.989250>, <0.115375, -0.094984, 0.988770>, <0.077751, -0.132613, 0.988114>, <0.019780, -0.158868, 0.987102>, <-0.053483, -0.182703, 0.981712>, 
			<-0.112188, -0.132613, 0.984798>, <-0.149812, -0.094984, 0.984141>, <-0.176549, -0.034483, 0.983688>, <-0.209759, -0.000421, 0.977753>, <-0.176549, 0.034481, 0.983688>, <-0.149812, 0.094984, 0.984141>, <-0.112188, 0.132613, 0.984798>, <-0.053483, 0.182703, 0.981712>, <0.019780, 0.158868, 0.987102>, <0.077751, 0.132613, 0.988114>, <0.115374, 0.094984, 0.988770>, 
			<0.142111, 0.034485, 0.989250>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <0.831343, -0.555570, 0.014511>, <-0.985613, 0.168137, -0.017204>, 
			<-0.195061, -0.980785, -0.003405>, <0.555486, -0.831470, 0.009696>, <-0.017452, 0.000000, 0.999848>, <-0.195061, 0.980785, -0.003405>, <-0.831344, 0.555568, -0.014511>, <0.999848, -0.000002, 0.017452>, <0.555486, 0.831470, 0.009696>, <-0.555486, 0.831470, -0.009696>, <0.831342, 0.555572, 0.014511>, <-0.831343, -0.555570, -0.014511>, <-0.999847, 0.000880, -0.017452>, 
			<-0.555486, -0.831470, -0.009696>, <0.985612, -0.168148, 0.017204>, <0.195061, -0.980785, 0.003405>, <0.985610, 0.168157, 0.017204>, <0.195061, 0.980785, 0.003405>, <-0.985612, -0.168146, -0.017204>, <-0.215020, -0.968950, 0.122077>, <0.984223, 0.000005, 0.176931>, <0.817789, -0.549319, 0.171665>, <-0.551982, -0.820661, 0.147756>, <-0.824179, -0.547976, 0.143005>, 
			<0.158320, -0.974326, 0.160073>, <0.970189, -0.167404, 0.175242>, <-0.982002, 0.125621, 0.141034>, <-0.551982, 0.820661, 0.147756>, <0.970187, 0.167413, 0.175242>, <0.545147, -0.821558, 0.166906>, <-0.215020, 0.968950, 0.122077>, <-0.824181, 0.547974, 0.143005>, <0.817788, 0.549321, 0.171665>, <0.158320, 0.974326, 0.160073>, <-0.989796, 0.002084, 0.142474>, 
			<-0.982002, -0.125627, 0.141034>, <0.545147, 0.821558, 0.166906>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.064205, 0.194311, -0.978837>, <-0.268036, 0.194208, -0.943631>, <-0.457585, 0.175117, -0.871751>, <-0.608986, 0.194208, -0.769038>, <-0.747117, 0.194208, -0.635688>, <-0.856778, 0.194208, -0.477718>, <-0.928570, 0.194183, -0.316308>, 
			<-0.976345, 0.194318, -0.094826>, <-0.053408, 0.554070, -0.830755>, <-0.226924, 0.553760, -0.801159>, <-0.378862, 0.553760, -0.741494>, <-0.516109, 0.569847, -0.639458>, <-0.625481, 0.553709, -0.549709>, <-0.727820, 0.553760, -0.404509>, <-0.792751, 0.553760, -0.254746>, <-0.828664, 0.554082, -0.079433>, <-0.034381, 0.830493, -0.555967>, <-0.151192, 0.830256, -0.536484>, 
			<-0.252950, 0.830256, -0.496680>, <-0.344987, 0.830256, -0.437788>, <-0.425482, 0.830256, -0.360055>, <-0.487550, 0.830256, -0.270129>, <-0.530881, 0.830256, -0.169823>, <-0.554599, 0.830499, -0.051868>, <-0.010416, 0.980651, -0.195487>, <-0.052098, 0.980607, -0.188931>, <-0.087956, 0.980607, -0.175137>, <-0.120433, 0.980607, -0.154613>, <-0.150315, 0.980607, -0.125756>, 
			<-0.171961, 0.980607, -0.094014>, <-0.186998, 0.980607, -0.058660>, <-0.195061, 0.980651, -0.016561>, <0.014410, 0.980628, 0.195347>, <0.055117, 0.980607, 0.188073>, <0.090749, 0.980607, 0.173706>, <0.122893, 0.980607, 0.152664>, <0.148282, 0.980607, 0.128146>, <0.170433, 0.980607, 0.096756>, <0.186035, 0.980607, 0.061647>, <0.194766, 0.980629, 0.020806>, 
			<0.036137, 0.830474, 0.555884>, <0.153739, 0.830256, 0.535760>, <0.255307, 0.830256, 0.495472>, <0.347063, 0.830256, 0.436144>, <0.423766, 0.830256, 0.362073>, <0.486261, 0.830256, 0.272443>, <0.530068, 0.830256, 0.172343>, <0.554392, 0.830477, 0.054384>, <0.051722, 0.554127, 0.830824>, <0.228615, 0.553760, 0.800678>, <0.380427, 0.553760, 0.740692>, 
			<0.504142, 0.569847, 0.648934>, <0.643102, 0.553709, 0.528986>, <0.726964, 0.553760, 0.406045>, <0.792212, 0.553760, 0.256419>, <0.828652, 0.554129, 0.079227>, <0.059369, 0.194433, 0.979118>, <0.268627, 0.194208, 0.943463>, <0.447526, 0.194208, 0.872928>, <0.609227, 0.194208, 0.768847>, <0.749708, 0.207789, 0.628301>, <0.857077, 0.194208, 0.477181>, 
			<0.933080, 0.207789, 0.293573>, <0.973878, 0.213439, 0.077492>, <0.045308, -0.213442, 0.975905>, <0.260831, -0.207789, 0.942757>, <0.446979, -0.194208, 0.873209>, <0.608745, -0.194208, 0.769229>, <0.753642, -0.180580, 0.631992>, <0.856778, -0.194208, 0.477718>, <0.938128, -0.180580, 0.295478>, <0.976595, -0.194433, 0.091967>, <0.051722, -0.554127, 0.830824>, 
			<0.228615, -0.553760, 0.800678>, <0.380427, -0.553760, 0.740692>, <0.504142, -0.569847, 0.648934>, <0.630944, -0.569847, 0.526483>, <0.726964, -0.553760, 0.406045>, <0.792212, -0.553760, 0.256419>, <0.828652, -0.554129, 0.079227>, <0.036137, -0.830474, 0.555884>, <0.153739, -0.830256, 0.535760>, <0.255307, -0.830256, 0.495472>, <0.347063, -0.830256, 0.436144>, 
			<0.423766, -0.830256, 0.362073>, <0.486261, -0.830256, 0.272443>, <0.530068, -0.830256, 0.172343>, <0.554392, -0.830477, 0.054384>, <0.014410, -0.980628, 0.195347>, <0.055117, -0.980607, 0.188073>, <0.090749, -0.980607, 0.173706>, <0.122893, -0.980607, 0.152664>, <0.148282, -0.980607, 0.128146>, <0.170433, -0.980607, 0.096756>, <0.186035, -0.980607, 0.061647>, 
			<0.194766, -0.980629, 0.020806>, <-0.010416, -0.980651, -0.195487>, <-0.052098, -0.980607, -0.188931>, <-0.087956, -0.980607, -0.175137>, <-0.120433, -0.980607, -0.154613>, <-0.150315, -0.980607, -0.125756>, <-0.171961, -0.980607, -0.094014>, <-0.186998, -0.980607, -0.058660>, <-0.195061, -0.980651, -0.016561>, <-0.034381, -0.830493, -0.555967>, <-0.151192, -0.830256, -0.536484>, 
			<-0.252950, -0.830256, -0.496680>, <-0.344987, -0.830256, -0.437788>, <-0.425482, -0.830256, -0.360055>, <-0.487550, -0.830256, -0.270129>, <-0.530881, -0.830256, -0.169823>, <-0.554599, -0.830499, -0.051868>, <-0.053408, -0.554070, -0.830755>, <-0.226924, -0.553760, -0.801159>, <-0.378862, -0.553760, -0.741494>, <-0.527545, -0.553709, -0.644284>, <-0.634920, -0.553760, -0.538727>, 
			<-0.727820, -0.553760, -0.404509>, <-0.792751, -0.553760, -0.254746>, <-0.828664, -0.554082, -0.079433>, <-0.073532, -0.180678, -0.980790>, <-0.278723, -0.175117, -0.944271>, <-0.447526, -0.194208, -0.872928>, <-0.605305, -0.180580, -0.775240>, <-0.747515, -0.194208, -0.635220>, <-0.857077, -0.194208, -0.477181>, <-0.933702, -0.194208, -0.300805>, <-0.976345, -0.194318, -0.094826>, 
			<-0.973830, -0.226642, -0.016998>, <-0.973830, 0.226642, -0.016998>, <-0.813081, 0.581978, -0.014192>, <-0.528461, 0.848908, -0.009224>, <-0.163172, 0.986593, -0.002848>, <0.227035, 0.973879, 0.003963>, <0.582522, 0.812752, 0.010168>, <0.849128, 0.527979, 0.014822>, <0.986469, 0.163042, 0.017219>, <0.986469, -0.163042, 0.017219>, <0.849128, -0.527979, 0.014822>, 
			<0.582522, -0.812752, 0.010168>, <0.227035, -0.973879, 0.003963>, <-0.163172, -0.986593, -0.002848>, <-0.528461, -0.848908, -0.009224>, <-0.813081, -0.581978, -0.014192>, <0.976969, 0.194221, -0.088373>, <0.943631, 0.194208, -0.268036>, <0.880685, 0.175117, -0.440146>, <0.769229, 0.194208, -0.608745>, <0.631992, 0.180580, -0.753642>, <0.477718, 0.194208, -0.856778>, 
			<0.311508, 0.175117, -0.933968>, <0.107716, 0.180678, -0.977626>, <0.829297, 0.553867, -0.074151>, <0.801159, 0.553760, -0.226924>, <0.741494, 0.553760, -0.378862>, <0.653334, 0.553760, -0.516241>, <0.549709, 0.553709, -0.625481>, <0.404509, 0.553760, -0.727820>, <0.254746, 0.553760, -0.792751>, <0.082368, 0.554070, -0.828385>, <0.555118, 0.830358, -0.048472>, 
			<0.536484, 0.830256, -0.151192>, <0.496680, 0.830256, -0.252950>, <0.437788, 0.830256, -0.344987>, <0.360055, 0.830256, -0.425482>, <0.270129, 0.830256, -0.487550>, <0.169823, 0.830256, -0.530881>, <0.053763, 0.830493, -0.554428>, <0.195220, 0.980632, -0.015785>, <0.188931, 0.980607, -0.052098>, <0.175137, 0.980607, -0.087956>, <0.154613, 0.980607, -0.120433>, 
			<0.125756, 0.980607, -0.150315>, <0.094014, 0.980607, -0.171961>, <0.058660, 0.980607, -0.186998>, <0.017232, 0.980651, -0.195005>, <-0.195105, 0.980616, 0.018090>, <-0.188073, 0.980607, 0.055117>, <-0.173706, 0.980607, 0.090749>, <-0.152664, 0.980607, 0.122893>, <-0.128146, 0.980607, 0.148282>, <-0.096756, 0.980607, 0.170433>, <-0.061647, 0.980607, 0.186035>, 
			<-0.021219, 0.980628, 0.194725>, <-0.555178, 0.830386, 0.047295>, <-0.535760, 0.830256, 0.153739>, <-0.495472, 0.830256, 0.255307>, <-0.436144, 0.830256, 0.347063>, <-0.362073, 0.830256, 0.423766>, <-0.272443, 0.830256, 0.486261>, <-0.172343, 0.830256, 0.530068>, <-0.055515, 0.830474, 0.554284>, <-0.829762, 0.554016, 0.067541>, <-0.800678, 0.553760, 0.228615>, 
			<-0.740692, 0.553760, 0.380427>, <-0.652243, 0.553760, 0.517619>, <-0.526483, 0.569847, 0.630944>, <-0.406045, 0.553760, 0.726964>, <-0.256419, 0.553760, 0.792212>, <-0.080686, 0.554127, 0.828513>, <-0.974688, 0.213416, 0.066613>, <-0.947868, 0.180580, 0.262558>, <-0.872928, 0.194208, 0.447526>, <-0.768847, 0.194208, 0.609227>, <-0.630282, 0.175117, 0.756358>, 
			<-0.463391, 0.194183, 0.864616>, <-0.299012, 0.225837, 0.927141>, <-0.079339, 0.213442, 0.973729>, <-0.974688, -0.213416, 0.066613>, <-0.947809, -0.194183, 0.252885>, <-0.873069, -0.194208, 0.447253>, <-0.769229, -0.194208, 0.608745>, <-0.625681, -0.213206, 0.750377>, <-0.477718, -0.194208, 0.856778>, <-0.301390, -0.194208, 0.933514>, <-0.093503, -0.194433, 0.976449>, 
			<-0.829762, -0.554016, 0.067541>, <-0.800678, -0.553760, 0.228615>, <-0.740692, -0.553760, 0.380427>, <-0.661172, -0.553709, 0.506219>, <-0.526483, -0.569847, 0.630944>, <-0.406045, -0.553760, 0.726964>, <-0.256419, -0.553760, 0.792212>, <-0.080686, -0.554127, 0.828513>, <-0.555178, -0.830386, 0.047295>, <-0.535760, -0.830256, 0.153739>, <-0.495472, -0.830256, 0.255307>, 
			<-0.436144, -0.830256, 0.347063>, <-0.362073, -0.830256, 0.423766>, <-0.272443, -0.830256, 0.486261>, <-0.172343, -0.830256, 0.530068>, <-0.055515, -0.830474, 0.554284>, <-0.195105, -0.980616, 0.018090>, <-0.188073, -0.980607, 0.055117>, <-0.173706, -0.980607, 0.090749>, <-0.152664, -0.980607, 0.122893>, <-0.128146, -0.980607, 0.148282>, <-0.096756, -0.980607, 0.170433>, 
			<-0.061647, -0.980607, 0.186035>, <-0.021219, -0.980628, 0.194725>, <0.195220, -0.980632, -0.015785>, <0.188931, -0.980607, -0.052098>, <0.175137, -0.980607, -0.087956>, <0.154613, -0.980607, -0.120433>, <0.125756, -0.980607, -0.150315>, <0.094014, -0.980607, -0.171961>, <0.058660, -0.980607, -0.186998>, <0.017232, -0.980651, -0.195005>, <0.555118, -0.830358, -0.048472>, 
			<0.536484, -0.830256, -0.151192>, <0.496680, -0.830256, -0.252950>, <0.437788, -0.830256, -0.344987>, <0.360055, -0.830256, -0.425482>, <0.270129, -0.830256, -0.487550>, <0.169823, -0.830256, -0.530881>, <0.053763, -0.830493, -0.554428>, <0.829297, -0.553867, -0.074151>, <0.801159, -0.553760, -0.226924>, <0.741494, -0.553760, -0.378862>, <0.655368, -0.542120, -0.525927>, 
			<0.548479, -0.542120, -0.636614>, <0.404509, -0.553760, -0.727820>, <0.254746, -0.553760, -0.792751>, <0.082368, -0.554070, -0.828385>, <0.979035, -0.180587, -0.094224>, <0.939043, -0.194183, -0.283709>, <0.872928, -0.194208, -0.447526>, <0.768847, -0.194208, -0.609227>, <0.635220, -0.194208, -0.747515>, <0.477181, -0.194208, -0.857077>, <0.308843, -0.213206, -0.926908>, 
			<0.107716, -0.180678, -0.977626>, <-0.017452, -0.000000, 0.999848>, <0.016998, 0.226644, -0.973829>, <0.014192, 0.581981, -0.813079>, <0.009224, 0.848909, -0.528458>, <0.002848, 0.986594, -0.163172>, <-0.003963, 0.973879, 0.227033>, <-0.010168, 0.812753, 0.582520>, <-0.014822, 0.527980, 0.849127>, <-0.017219, 0.163043, 0.986469>, <-0.017219, -0.163043, 0.986469>, 
			<-0.014822, -0.527980, 0.849127>, <-0.010168, -0.812753, 0.582520>, <-0.003963, -0.973879, 0.227033>, <0.002848, -0.986594, -0.163172>, <0.009224, -0.848909, -0.528458>, <0.014192, -0.581981, -0.813079>, <0.016998, -0.226644, -0.973829>, <0.973924, 0.226758, 0.007247>, <0.973924, -0.226758, 0.007247>, <0.813058, -0.582147, 0.006422>, <0.528371, -0.849001, 0.004595>, 
			<0.163150, -0.986600, 0.001584>, <-0.226939, -0.973906, -0.002503>, <-0.582397, -0.812874, -0.007059>, <-0.849093, -0.528129, -0.011020>, <-0.986524, -0.163083, -0.013230>, <-0.986524, 0.163083, -0.013230>, <-0.849093, 0.528129, -0.011020>, <-0.582397, 0.812874, -0.007059>, <-0.226939, 0.973906, -0.002503>, <0.163150, 0.986600, 0.001584>, <0.528371, 0.849001, 0.004595>, 
			<0.813058, 0.582147, 0.006422>, <0.965828, 0.191867, 0.174249>, <0.965828, -0.191867, 0.174249>, <0.818686, -0.547976, 0.171681>, <0.546489, -0.820661, 0.166930>, <0.221252, -0.961806, 0.161172>, <-0.194585, -0.968722, 0.153994>, <-0.550639, -0.821558, 0.147779>, <-0.823282, -0.549319, 0.143020>, <-0.964947, -0.205721, 0.162962>, <-0.964405, 0.224031, 0.140476>, 
			<-0.823282, 0.549319, 0.143020>, <-0.550639, 0.821558, 0.147779>, <-0.194585, 0.968722, 0.153994>, <0.221252, 0.961806, 0.161172>, <0.546489, 0.820661, 0.166930>, <0.818686, 0.547976, 0.171681>, <0.143692, 0.026608, 0.989265>, <0.143692, -0.026608, 0.989265>, <0.121263, -0.086170, 0.988873>, <0.056545, -0.118680, 0.991321>, <0.005515, -0.137902, 0.990431>, 
			<-0.040078, -0.137902, 0.989635>, <-0.091107, -0.118680, 0.988744>, <-0.155700, -0.086170, 0.984039>, <-0.123765, -0.021171, 0.992086>, <-0.178130, 0.026608, 0.983647>, <-0.155700, 0.086170, 0.984039>, <-0.103376, 0.138503, 0.984952>, <-0.043823, 0.160935, 0.985992>, <0.009385, 0.160935, 0.986920>, <0.068938, 0.138503, 0.987960>, <0.121263, 0.086170, 0.988873>, 
			<-0.107716, 0.180678, 0.977626>, <-0.311508, 0.175117, 0.933968>, <-0.477718, 0.194208, 0.856778>, <-0.631992, 0.180580, 0.753642>, <-0.766877, 0.180580, 0.615866>, <-0.880262, 0.194183, 0.432935>, <-0.943631, 0.194208, 0.268036>, <-0.979059, 0.194318, 0.060694>, <-0.082368, 0.554070, 0.828385>, <-0.254746, 0.553760, 0.792751>, <-0.404509, 0.553760, 0.727820>, 
			<-0.549709, 0.553709, 0.625481>, <-0.655368, 0.542120, 0.525927>, <-0.741494, 0.553760, 0.378862>, <-0.801159, 0.553760, 0.226924>, <-0.830931, 0.554082, 0.050464>, <-0.053763, 0.830493, 0.554428>, <-0.169823, 0.830256, 0.530881>, <-0.270129, 0.830256, 0.487550>, <-0.360055, 0.830256, 0.425482>, <-0.437788, 0.830256, 0.344987>, <-0.496680, 0.830256, 0.252950>, 
			<-0.536484, 0.830256, 0.151192>, <-0.556072, 0.830499, 0.032481>, <-0.017232, 0.980651, 0.195005>, <-0.058660, 0.980607, 0.186998>, <-0.094014, 0.980607, 0.171961>, <-0.125756, 0.980607, 0.150315>, <-0.154613, 0.980607, 0.120433>, <-0.175137, 0.980607, 0.087956>, <-0.188931, 0.980607, 0.052098>, <-0.195520, 0.980651, 0.009744>, <0.021219, 0.980628, -0.194725>, 
			<0.061647, 0.980607, -0.186035>, <0.096756, 0.980607, -0.170433>, <0.128146, 0.980607, -0.148282>, <0.152664, 0.980607, -0.122893>, <0.173706, 0.980607, -0.090749>, <0.188073, 0.980607, -0.055117>, <0.195374, 0.980629, -0.013996>, <0.055515, 0.830474, -0.554284>, <0.172343, 0.830256, -0.530068>, <0.272443, 0.830256, -0.486261>, <0.362073, 0.830256, -0.423766>, 
			<0.436144, 0.830256, -0.347063>, <0.495472, 0.830256, -0.255307>, <0.535760, 0.830256, -0.153739>, <0.555953, 0.830477, -0.035003>, <0.080686, 0.554127, -0.828513>, <0.256419, 0.553760, -0.792212>, <0.406045, 0.553760, -0.726964>, <0.528986, 0.553709, -0.643102>, <0.652243, 0.553760, -0.517619>, <0.740692, 0.553760, -0.380427>, <0.800678, 0.553760, -0.228615>, 
			<0.830912, 0.554129, -0.050259>, <0.079339, 0.213442, -0.973729>, <0.290897, 0.213206, -0.932696>, <0.477450, 0.194208, -0.856928>, <0.635220, 0.194208, -0.747515>, <0.768847, 0.194208, -0.609227>, <0.865651, 0.194183, -0.461456>, <0.943463, 0.194208, -0.268627>, <0.979210, 0.194433, -0.057828>, <0.093503, -0.194433, -0.976449>, <0.301390, -0.194208, -0.933514>, 
			<0.482195, -0.207789, -0.851065>, <0.635688, -0.194208, -0.747117>, <0.763711, -0.225837, -0.604767>, <0.873209, -0.194208, -0.446979>, <0.942757, -0.207789, -0.260831>, <0.975989, -0.213439, -0.043456>, <0.080686, -0.554127, -0.828513>, <0.256419, -0.553760, -0.792212>, <0.406045, -0.553760, -0.726964>, <0.526483, -0.569847, -0.630944>, <0.661172, -0.553709, -0.506219>, 
			<0.740692, -0.553760, -0.380427>, <0.800678, -0.553760, -0.228615>, <0.830912, -0.554129, -0.050259>, <0.055515, -0.830474, -0.554284>, <0.172343, -0.830256, -0.530068>, <0.272443, -0.830256, -0.486261>, <0.362073, -0.830256, -0.423766>, <0.436144, -0.830256, -0.347063>, <0.495472, -0.830256, -0.255307>, <0.535760, -0.830256, -0.153739>, <0.555953, -0.830477, -0.035003>, 
			<0.021219, -0.980628, -0.194725>, <0.061647, -0.980607, -0.186035>, <0.096756, -0.980607, -0.170433>, <0.128146, -0.980607, -0.148282>, <0.152664, -0.980607, -0.122893>, <0.173706, -0.980607, -0.090749>, <0.188073, -0.980607, -0.055117>, <0.195374, -0.980629, -0.013996>, <-0.017232, -0.980651, 0.195005>, <-0.058660, -0.980607, 0.186998>, <-0.094014, -0.980607, 0.171961>, 
			<-0.125756, -0.980607, 0.150315>, <-0.154613, -0.980607, 0.120433>, <-0.175137, -0.980607, 0.087956>, <-0.188931, -0.980607, 0.052098>, <-0.195520, -0.980651, 0.009744>, <-0.053763, -0.830493, 0.554428>, <-0.169823, -0.830256, 0.530881>, <-0.270129, -0.830256, 0.487550>, <-0.360055, -0.830256, 0.425482>, <-0.437788, -0.830256, 0.344987>, <-0.496680, -0.830256, 0.252950>, 
			<-0.536484, -0.830256, 0.151192>, <-0.556072, -0.830499, 0.032481>, <-0.082368, -0.554070, 0.828385>, <-0.254746, -0.553760, 0.792751>, <-0.404509, -0.553760, 0.727820>, <-0.538727, -0.553760, 0.634920>, <-0.644284, -0.553709, 0.527545>, <-0.741494, -0.553760, 0.378862>, <-0.801159, -0.553760, 0.226924>, <-0.830931, -0.554082, 0.050464>, <-0.098327, -0.194311, 0.976000>, 
			<-0.300805, -0.194208, 0.933702>, <-0.470614, -0.175117, 0.864787>, <-0.630282, -0.175117, 0.756358>, <-0.769038, -0.194208, 0.608986>, <-0.872928, -0.194208, 0.447526>, <-0.944271, -0.175117, 0.278723>, <-0.979059, -0.194318, 0.060694>, <0.975151, 0.180587, 0.128334>, <0.933968, 0.175117, 0.311508>, <0.856778, 0.194208, 0.477718>, <0.750377, 0.213206, 0.625681>, 
			<0.608745, 0.194208, 0.769229>, <0.447253, 0.194208, 0.873069>, <0.268036, 0.194208, 0.943631>, <0.073532, 0.180678, 0.980790>, <0.826204, 0.553867, 0.103048>, <0.792751, 0.553760, 0.254746>, <0.727820, 0.553760, 0.404509>, <0.625481, 0.553709, 0.549709>, <0.516241, 0.553760, 0.653334>, <0.378862, 0.553760, 0.741494>, <0.226924, 0.553760, 0.801159>, 
			<0.053408, 0.554070, 0.830755>, <0.553088, 0.830358, 0.067816>, <0.530881, 0.830256, 0.169823>, <0.487550, 0.830256, 0.270129>, <0.425482, 0.830256, 0.360055>, <0.344987, 0.830256, 0.437788>, <0.252950, 0.830256, 0.496680>, <0.151192, 0.830256, 0.536484>, <0.034381, 0.830493, 0.555967>, <0.194550, 0.980632, 0.022589>, <0.186998, 0.980607, 0.058660>, 
			<0.171961, 0.980607, 0.094014>, <0.150315, 0.980607, 0.125756>, <0.120433, 0.980607, 0.154613>, <0.087956, 0.980607, 0.175137>, <0.052098, 0.980607, 0.188931>, <0.010416, 0.980651, 0.195487>, <-0.194355, 0.980616, -0.024888>, <-0.186035, 0.980607, -0.061647>, <-0.170433, 0.980607, -0.096756>, <-0.148282, 0.980607, -0.128146>, <-0.122893, 0.980607, -0.152664>, 
			<-0.090749, 0.980607, -0.173706>, <-0.055117, 0.980607, -0.188073>, <-0.014410, 0.980628, -0.195347>, <-0.553189, 0.830386, -0.066642>, <-0.530068, 0.830256, -0.172343>, <-0.486261, 0.830256, -0.272443>, <-0.423766, 0.830256, -0.362073>, <-0.347063, 0.830256, -0.436144>, <-0.255307, 0.830256, -0.495472>, <-0.153739, 0.830256, -0.535760>, <-0.036137, 0.830474, -0.555884>, 
			<-0.826899, 0.554016, -0.096458>, <-0.792212, 0.553760, -0.256419>, <-0.726964, 0.553760, -0.406045>, <-0.630944, 0.569847, -0.526483>, <-0.517619, 0.553760, -0.652243>, <-0.380427, 0.553760, -0.740692>, <-0.228615, 0.553760, -0.800678>, <-0.051722, 0.554127, -0.830824>, <-0.971769, 0.213416, -0.100589>, <-0.933080, 0.207789, -0.293573>, <-0.861967, 0.162374, -0.480258>, 
			<-0.744916, 0.180580, -0.642254>, <-0.609227, 0.194208, -0.768847>, <-0.437038, 0.213206, -0.873808>, <-0.268627, 0.194208, -0.943463>, <-0.045308, 0.213442, -0.975905>, <-0.974604, -0.194385, -0.111184>, <-0.932696, -0.213206, -0.290897>, <-0.858023, -0.213206, -0.467267>, <-0.747117, -0.194208, -0.635688>, <-0.608745, -0.194208, -0.769229>, <-0.446979, -0.194208, -0.873209>, 
			<-0.260831, -0.207789, -0.942757>, <-0.045308, -0.213442, -0.975905>, <-0.826899, -0.554016, -0.096458>, <-0.792212, -0.553760, -0.256419>, <-0.726964, -0.553760, -0.406045>, <-0.633781, -0.553760, -0.540067>, <-0.506219, -0.553709, -0.661172>, <-0.380427, -0.553760, -0.740692>, <-0.228615, -0.553760, -0.800678>, <-0.051722, -0.554127, -0.830824>, <-0.553189, -0.830386, -0.066642>, 
			<-0.530068, -0.830256, -0.172343>, <-0.486261, -0.830256, -0.272443>, <-0.423766, -0.830256, -0.362073>, <-0.347063, -0.830256, -0.436144>, <-0.255307, -0.830256, -0.495472>, <-0.153739, -0.830256, -0.535760>, <-0.036137, -0.830474, -0.555884>, <-0.194355, -0.980616, -0.024888>, <-0.186035, -0.980607, -0.061647>, <-0.170433, -0.980607, -0.096756>, <-0.148282, -0.980607, -0.128146>, 
			<-0.122893, -0.980607, -0.152664>, <-0.090749, -0.980607, -0.173706>, <-0.055117, -0.980607, -0.188073>, <-0.014410, -0.980628, -0.195347>, <0.194550, -0.980632, 0.022589>, <0.186998, -0.980607, 0.058660>, <0.171961, -0.980607, 0.094014>, <0.150315, -0.980607, 0.125756>, <0.120433, -0.980607, 0.154613>, <0.087956, -0.980607, 0.175137>, <0.052098, -0.980607, 0.188931>, 
			<0.010416, -0.980651, 0.195487>, <0.553088, -0.830358, 0.067816>, <0.530881, -0.830256, 0.169823>, <0.487550, -0.830256, 0.270129>, <0.425482, -0.830256, 0.360055>, <0.344987, -0.830256, 0.437788>, <0.252950, -0.830256, 0.496680>, <0.151192, -0.830256, 0.536484>, <0.034381, -0.830493, 0.555967>, <0.826204, -0.553867, 0.103048>, <0.792751, -0.553760, 0.254746>, 
			<0.727820, -0.553760, 0.404509>, <0.621056, -0.569847, 0.538112>, <0.527545, -0.553709, 0.644284>, <0.378862, -0.553760, 0.741494>, <0.226924, -0.553760, 0.801159>, <0.053408, -0.554070, 0.830755>, <0.973290, -0.194221, 0.122415>, <0.933702, -0.194208, 0.300805>, <0.857077, -0.194208, 0.477181>, <0.747515, -0.194208, 0.635220>, <0.609227, -0.194208, 0.768847>, 
			<0.447526, -0.194208, 0.872928>, <0.278723, -0.175117, 0.944271>, <0.073532, -0.180678, 0.980790>, <0.017452, 0.000000, -0.999848>, <-0.016690, 0.208521, 0.977875>, <-0.014192, 0.581981, 0.813079>, <-0.009224, 0.848909, 0.528458>, <-0.002848, 0.986594, 0.163172>, <0.003963, 0.973879, -0.227033>, <0.010168, 0.812753, -0.582520>, <0.014822, 0.527980, -0.849127>, 
			<0.017365, 0.175880, -0.984258>, <0.017365, -0.175880, -0.984258>, <0.014822, -0.527980, -0.849127>, <0.010168, -0.812753, -0.582520>, <0.003963, -0.973879, -0.227033>, <-0.002848, -0.986594, 0.163172>, <-0.009224, -0.848909, 0.528458>, <-0.014192, -0.581981, 0.813079>, <-0.016690, -0.208521, 0.977875>, <0.980437, 0.194992, 0.026871>, <0.980437, -0.194992, 0.026871>, 
			<0.831271, -0.555421, 0.022284>, <0.555513, -0.831385, 0.014327>, <0.195071, -0.980778, 0.004670>, <-0.195129, -0.980766, -0.004865>, <-0.555573, -0.831369, -0.012806>, <-0.831354, -0.555441, -0.018314>, <-0.980565, -0.195054, -0.021108>, <-0.980565, 0.195054, -0.021108>, <-0.831354, 0.555441, -0.018314>, <-0.555573, 0.831369, -0.012806>, <-0.195129, 0.980766, -0.004865>, 
			<0.195071, 0.980778, 0.004670>, <0.555513, 0.831385, 0.014327>, <0.831271, 0.555421, 0.022284>, <0.964405, 0.224031, -0.140476>, <0.964405, -0.224031, -0.140476>, <0.823282, -0.549319, -0.143020>, <0.550639, -0.821558, -0.147779>, <0.181174, -0.967457, -0.176642>, <-0.221252, -0.961806, -0.161172>, <-0.546489, -0.820661, -0.166930>, <-0.818686, -0.547976, -0.171681>, 
			<-0.964172, -0.178064, -0.196635>, <-0.965828, 0.191867, -0.174249>, <-0.818686, 0.547976, -0.171681>, <-0.546489, 0.820661, -0.166930>, <-0.221252, 0.961806, -0.161172>, <0.181174, 0.967457, -0.176642>, <0.550639, 0.821558, -0.147779>, <0.823282, 0.549319, -0.143020>, <0.178130, 0.026608, -0.983647>, <0.123765, -0.021171, -0.992086>, <0.155700, -0.086170, -0.984039>, 
			<0.091107, -0.118680, -0.988744>, <0.038517, -0.106432, -0.993574>, <-0.005515, -0.137902, -0.990431>, <-0.056545, -0.118680, -0.991321>, <-0.121263, -0.086170, -0.988873>, <-0.120600, -0.022800, -0.992439>, <-0.143692, 0.026608, -0.989265>, <-0.121263, 0.086170, -0.988873>, <-0.068938, 0.138503, -0.987960>, <-0.009385, 0.160935, -0.986920>, <0.042730, 0.127847, -0.990873>, 
			<0.103376, 0.138503, -0.984952>, <0.155700, 0.086170, -0.984039>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.999824, -0.006934, 0.017452>, <0.999824, -0.006934, 0.017452>, <0.999824, -0.006934, 0.017452>, <0.999804, -0.009324, 0.017452>, 
			<0.999804, -0.009324, 0.017452>, <0.983705, -0.178966, 0.017171>, <0.983705, -0.178966, 0.017171>, <0.983705, -0.178966, 0.017171>, <0.977302, -0.211162, 0.017059>, <0.977302, -0.211162, 0.017059>, <0.977302, -0.211162, 0.017059>, <0.929894, -0.367468, 0.016231>, <0.929894, -0.367468, 0.016231>, <0.929894, -0.367468, 0.016231>, <0.917334, -0.397795, 0.016012>, 
			<0.917334, -0.397795, 0.016012>, <0.917334, -0.397795, 0.016012>, <0.840348, -0.541848, 0.014668>, <0.840348, -0.541848, 0.014668>, <0.840348, -0.541848, 0.014668>, <0.822114, -0.569142, 0.014350>, <0.822114, -0.569142, 0.014350>, <0.822114, -0.569142, 0.014350>, <0.718508, -0.695406, 0.012542>, <0.718508, -0.695406, 0.012542>, <0.718508, -0.695406, 0.012542>, 
			<0.695300, -0.718617, 0.012137>, <0.695300, -0.718617, 0.012137>, <0.695300, -0.718617, 0.012137>, <0.569056, -0.822239, 0.009933>, <0.569056, -0.822239, 0.009933>, <0.569056, -0.822239, 0.009933>, <0.541766, -0.840476, 0.009457>, <0.541766, -0.840476, 0.009457>, <0.541766, -0.840476, 0.009457>, <0.397735, -0.917474, 0.006942>, <0.397735, -0.917474, 0.006942>, 
			<0.397735, -0.917474, 0.006942>, <0.367412, -0.930036, 0.006413>, <0.367412, -0.930036, 0.006413>, <0.367412, -0.930036, 0.006413>, <0.211130, -0.977451, 0.003685>, <0.211130, -0.977451, 0.003685>, <0.211130, -0.977451, 0.003685>, <0.178939, -0.983855, 0.003123>, <0.178939, -0.983855, 0.003123>, <0.178939, -0.983855, 0.003123>, <0.016411, -0.999865, 0.000286>, 
			<0.016411, -0.999865, 0.000286>, <0.016411, -0.999865, 0.000286>, <-0.016411, -0.999865, -0.000286>, <-0.016411, -0.999865, -0.000286>, <-0.016411, -0.999865, -0.000286>, <-0.178939, -0.983855, -0.003123>, <-0.178939, -0.983855, -0.003123>, <-0.178939, -0.983855, -0.003123>, <-0.211130, -0.977451, -0.003685>, <-0.211130, -0.977451, -0.003685>, <-0.211130, -0.977451, -0.003685>, 
			<-0.367412, -0.930036, -0.006413>, <-0.367412, -0.930036, -0.006413>, <-0.367412, -0.930036, -0.006413>, <-0.397735, -0.917474, -0.006942>, <-0.397735, -0.917474, -0.006942>, <-0.397735, -0.917474, -0.006942>, <-0.541766, -0.840476, -0.009457>, <-0.541766, -0.840476, -0.009457>, <-0.541766, -0.840476, -0.009457>, <-0.569056, -0.822239, -0.009933>, <-0.569056, -0.822239, -0.009933>, 
			<-0.569056, -0.822239, -0.009933>, <-0.695300, -0.718617, -0.012137>, <-0.695300, -0.718617, -0.012137>, <-0.695300, -0.718617, -0.012137>, <-0.718508, -0.695406, -0.012542>, <-0.718508, -0.695406, -0.012542>, <-0.718508, -0.695406, -0.012542>, <-0.822114, -0.569142, -0.014350>, <-0.822114, -0.569142, -0.014350>, <-0.822114, -0.569142, -0.014350>, <-0.840348, -0.541848, -0.014668>, 
			<-0.840348, -0.541848, -0.014668>, <-0.840348, -0.541848, -0.014668>, <-0.917334, -0.397795, -0.016012>, <-0.917334, -0.397795, -0.016012>, <-0.917334, -0.397795, -0.016012>, <-0.929894, -0.367468, -0.016231>, <-0.929894, -0.367468, -0.016231>, <-0.929894, -0.367468, -0.016231>, <-0.977302, -0.211162, -0.017059>, <-0.977302, -0.211162, -0.017059>, <-0.977302, -0.211162, -0.017059>, 
			<-0.983705, -0.178966, -0.017171>, <-0.983705, -0.178966, -0.017171>, <-0.983705, -0.178966, -0.017171>, <-0.999824, -0.006934, -0.017452>, <-0.999824, -0.006934, -0.017452>, <-0.999824, -0.006934, -0.017452>, <-0.999824, -0.006934, -0.017452>, <-0.999824, -0.006934, -0.017452>, <-0.999824, -0.006934, -0.017452>, <-0.977302, 0.211162, -0.017059>, <-0.977302, 0.211162, -0.017059>, 
			<-0.977302, 0.211162, -0.017059>, <-0.983705, 0.178966, -0.017171>, <-0.983705, 0.178966, -0.017171>, <-0.983705, 0.178966, -0.017171>, <-0.917334, 0.397795, -0.016012>, <-0.917334, 0.397795, -0.016012>, <-0.917334, 0.397795, -0.016012>, <-0.929894, 0.367468, -0.016231>, <-0.929894, 0.367468, -0.016231>, <-0.929894, 0.367468, -0.016231>, <-0.822114, 0.569142, -0.014350>, 
			<-0.822114, 0.569142, -0.014350>, <-0.822114, 0.569142, -0.014350>, <-0.840348, 0.541848, -0.014668>, <-0.840348, 0.541848, -0.014668>, <-0.840348, 0.541848, -0.014668>, <-0.695300, 0.718617, -0.012137>, <-0.695300, 0.718617, -0.012137>, <-0.695300, 0.718617, -0.012137>, <-0.718508, 0.695406, -0.012542>, <-0.718508, 0.695406, -0.012542>, <-0.718508, 0.695406, -0.012542>, 
			<-0.541766, 0.840476, -0.009457>, <-0.541766, 0.840476, -0.009457>, <-0.541766, 0.840476, -0.009457>, <-0.569056, 0.822239, -0.009933>, <-0.569056, 0.822239, -0.009933>, <-0.569056, 0.822239, -0.009933>, <-0.367412, 0.930036, -0.006413>, <-0.367412, 0.930036, -0.006413>, <-0.367412, 0.930036, -0.006413>, <-0.397735, 0.917474, -0.006942>, <-0.397735, 0.917474, -0.006942>, 
			<-0.397735, 0.917474, -0.006942>, <-0.178939, 0.983855, -0.003123>, <-0.178939, 0.983855, -0.003123>, <-0.178939, 0.983855, -0.003123>, <-0.211130, 0.977451, -0.003685>, <-0.211130, 0.977451, -0.003685>, <-0.211130, 0.977451, -0.003685>, <0.016411, 0.999865, 0.000286>, <0.016411, 0.999865, 0.000286>, <0.016411, 0.999865, 0.000286>, <-0.016411, 0.999865, -0.000286>, 
			<-0.016411, 0.999865, -0.000286>, <-0.016411, 0.999865, -0.000286>, <0.211130, 0.977451, 0.003685>, <0.211130, 0.977451, 0.003685>, <0.211130, 0.977451, 0.003685>, <0.178939, 0.983855, 0.003123>, <0.178939, 0.983855, 0.003123>, <0.178939, 0.983855, 0.003123>, <0.397735, 0.917474, 0.006942>, <0.397735, 0.917474, 0.006942>, <0.397735, 0.917474, 0.006942>, 
			<0.367412, 0.930036, 0.006413>, <0.367412, 0.930036, 0.006413>, <0.367412, 0.930036, 0.006413>, <0.569056, 0.822239, 0.009933>, <0.569056, 0.822239, 0.009933>, <0.569056, 0.822239, 0.009933>, <0.541766, 0.840476, 0.009457>, <0.541766, 0.840476, 0.009457>, <0.541766, 0.840476, 0.009457>, <0.718508, 0.695406, 0.012542>, <0.718508, 0.695406, 0.012542>, 
			<0.718508, 0.695406, 0.012542>, <0.695300, 0.718617, 0.012137>, <0.695300, 0.718617, 0.012137>, <0.695300, 0.718617, 0.012137>, <0.840348, 0.541848, 0.014668>, <0.840348, 0.541848, 0.014668>, <0.840348, 0.541848, 0.014668>, <0.822114, 0.569142, 0.014350>, <0.822114, 0.569142, 0.014350>, <0.822114, 0.569142, 0.014350>, <0.929894, 0.367468, 0.016231>, 
			<0.929894, 0.367468, 0.016231>, <0.929894, 0.367468, 0.016231>, <0.917334, 0.397795, 0.016012>, <0.917334, 0.397795, 0.016012>, <0.917334, 0.397795, 0.016012>, <0.983705, 0.178966, 0.017171>, <0.983705, 0.178966, 0.017171>, <0.983705, 0.178966, 0.017171>, <0.977302, 0.211162, 0.017059>, <0.977302, 0.211162, 0.017059>, <0.977302, 0.211162, 0.017059>, 
			<-0.999804, 0.009324, -0.017452>, <-0.999804, 0.009324, -0.017452>, <-0.999804, 0.009324, -0.017452>, <-0.999804, 0.009324, -0.017452>, <-0.999779, 0.011714, -0.017451>, <-0.999779, 0.011714, -0.017451>, <-0.999779, 0.011714, -0.017451>, <0.999804, 0.009324, 0.017452>, <0.999804, 0.009324, 0.017452>, <0.999804, 0.009324, 0.017452>, <0.999804, 0.009324, 0.017452>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <-0.999529, 0.025235, -0.017447>, <-0.999529, 0.025235, -0.017447>, <-0.999529, 0.025235, -0.017447>, <-0.999529, 0.025235, -0.017447>, <-0.999529, 0.025235, -0.017447>, <-0.999529, 0.025235, -0.017447>, <-0.999670, -0.018871, -0.017449>, <-0.999670, -0.018871, -0.017449>, <-0.999670, -0.018871, -0.017449>, 
			<-0.999348, -0.031596, -0.017444>, <-0.999348, -0.031596, -0.017444>, <-0.999348, -0.031596, -0.017444>, <-0.935910, -0.351862, -0.016336>, <-0.935910, -0.351862, -0.016336>, <-0.935910, -0.351862, -0.016336>, <-0.910554, -0.413085, -0.015894>, <-0.910554, -0.413085, -0.015894>, <-0.910554, -0.413085, -0.015894>, <-0.730037, -0.683289, -0.012743>, <-0.730037, -0.683289, -0.012743>, 
			<-0.730037, -0.683289, -0.012743>, <-0.683185, -0.730148, -0.011925>, <-0.683185, -0.730148, -0.011925>, <-0.683185, -0.730148, -0.011925>, <-0.413022, -0.910692, -0.007209>, <-0.413022, -0.910692, -0.007209>, <-0.413022, -0.910692, -0.007209>, <-0.351808, -0.936052, -0.006141>, <-0.351808, -0.936052, -0.006141>, <-0.351808, -0.936052, -0.006141>, <-0.033129, -0.999451, -0.000578>, 
			<-0.033129, -0.999451, -0.000578>, <-0.033129, -0.999451, -0.000578>, <0.033129, -0.999451, 0.000578>, <0.033129, -0.999451, 0.000578>, <0.033129, -0.999451, 0.000578>, <0.351808, -0.936052, 0.006141>, <0.351808, -0.936052, 0.006141>, <0.351808, -0.936052, 0.006141>, <0.413022, -0.910692, 0.007209>, <0.413022, -0.910692, 0.007209>, <0.413022, -0.910692, 0.007209>, 
			<0.683185, -0.730148, 0.011925>, <0.683185, -0.730148, 0.011925>, <0.683185, -0.730148, 0.011925>, <0.730037, -0.683289, 0.012743>, <0.730037, -0.683289, 0.012743>, <0.730037, -0.683289, 0.012743>, <0.910554, -0.413085, 0.015894>, <0.910554, -0.413085, 0.015894>, <0.910554, -0.413085, 0.015894>, <0.935910, -0.351862, 0.016336>, <0.935910, -0.351862, 0.016336>, 
			<0.935910, -0.351862, 0.016336>, <0.999348, -0.031600, 0.017444>, <0.999348, -0.031600, 0.017444>, <0.999348, -0.031600, 0.017444>, <0.999670, -0.018875, 0.017449>, <0.999670, -0.018875, 0.017449>, <0.999670, -0.018875, 0.017449>, <0.999529, 0.025237, 0.017447>, <0.999529, 0.025237, 0.017447>, <0.999529, 0.025237, 0.017447>, <0.999529, 0.025237, 0.017447>, 
			<0.999529, 0.025237, 0.017447>, <0.999529, 0.025237, 0.017447>, <0.910550, 0.413093, 0.015894>, <0.910550, 0.413093, 0.015894>, <0.910550, 0.413093, 0.015894>, <0.935905, 0.351874, 0.016336>, <0.935905, 0.351874, 0.016336>, <0.935905, 0.351874, 0.016336>, <0.683185, 0.730148, 0.011925>, <0.683185, 0.730148, 0.011925>, <0.683185, 0.730148, 0.011925>, 
			<0.730037, 0.683289, 0.012743>, <0.730037, 0.683289, 0.012743>, <0.730037, 0.683289, 0.012743>, <0.351808, 0.936052, 0.006141>, <0.351808, 0.936052, 0.006141>, <0.351808, 0.936052, 0.006141>, <0.413022, 0.910692, 0.007209>, <0.413022, 0.910692, 0.007209>, <0.413022, 0.910692, 0.007209>, <-0.033129, 0.999451, -0.000578>, <-0.033129, 0.999451, -0.000578>, 
			<-0.033129, 0.999451, -0.000578>, <0.033129, 0.999451, 0.000578>, <0.033129, 0.999451, 0.000578>, <0.033129, 0.999451, 0.000578>, <-0.413022, 0.910692, -0.007209>, <-0.413022, 0.910692, -0.007209>, <-0.413022, 0.910692, -0.007209>, <-0.351808, 0.936052, -0.006141>, <-0.351808, 0.936052, -0.006141>, <-0.351808, 0.936052, -0.006141>, <-0.730037, 0.683289, -0.012743>, 
			<-0.730037, 0.683289, -0.012743>, <-0.730037, 0.683289, -0.012743>, <-0.683185, 0.730148, -0.011925>, <-0.683185, 0.730148, -0.011925>, <-0.683185, 0.730148, -0.011925>, <-0.935914, 0.351850, -0.016336>, <-0.935914, 0.351850, -0.016336>, <-0.935914, 0.351850, -0.016336>, <-0.910557, 0.413077, -0.015894>, <-0.910557, 0.413077, -0.015894>, <-0.910557, 0.413077, -0.015894>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <0.999804, -0.009324, 0.017452>, <0.999804, -0.009324, 0.017452>, <0.999824, -0.006934, 0.017452>, <0.999824, -0.006934, 0.017452>, <0.999824, -0.006934, 0.017452>, <0.977302, -0.211162, 0.017059>, <0.977302, -0.211162, 0.017059>, <0.977302, -0.211162, 0.017059>, 
			<0.983705, -0.178966, 0.017171>, <0.983705, -0.178966, 0.017171>, <0.983705, -0.178966, 0.017171>, <0.917334, -0.397795, 0.016012>, <0.917334, -0.397795, 0.016012>, <0.917334, -0.397795, 0.016012>, <0.929894, -0.367468, 0.016231>, <0.929894, -0.367468, 0.016231>, <0.929894, -0.367468, 0.016231>, <0.822114, -0.569142, 0.014350>, <0.822114, -0.569142, 0.014350>, 
			<0.822114, -0.569142, 0.014350>, <0.840348, -0.541848, 0.014668>, <0.840348, -0.541848, 0.014668>, <0.840348, -0.541848, 0.014668>, <0.695300, -0.718617, 0.012137>, <0.695300, -0.718617, 0.012137>, <0.695300, -0.718617, 0.012137>, <0.718508, -0.695406, 0.012542>, <0.718508, -0.695406, 0.012542>, <0.718508, -0.695406, 0.012542>, <0.541766, -0.840476, 0.009457>, 
			<0.541766, -0.840476, 0.009457>, <0.541766, -0.840476, 0.009457>, <0.569056, -0.822239, 0.009933>, <0.569056, -0.822239, 0.009933>, <0.569056, -0.822239, 0.009933>, <0.367412, -0.930036, 0.006413>, <0.367412, -0.930036, 0.006413>, <0.367412, -0.930036, 0.006413>, <0.397735, -0.917474, 0.006942>, <0.397735, -0.917474, 0.006942>, <0.397735, -0.917474, 0.006942>, 
			<0.178939, -0.983855, 0.003123>, <0.178939, -0.983855, 0.003123>, <0.178939, -0.983855, 0.003123>, <0.211130, -0.977451, 0.003685>, <0.211130, -0.977451, 0.003685>, <0.211130, -0.977451, 0.003685>, <-0.016411, -0.999865, -0.000286>, <-0.016411, -0.999865, -0.000286>, <-0.016411, -0.999865, -0.000286>, <0.016411, -0.999865, 0.000286>, <0.016411, -0.999865, 0.000286>, 
			<0.016411, -0.999865, 0.000286>, <-0.211130, -0.977451, -0.003685>, <-0.211130, -0.977451, -0.003685>, <-0.211130, -0.977451, -0.003685>, <-0.178939, -0.983855, -0.003123>, <-0.178939, -0.983855, -0.003123>, <-0.178939, -0.983855, -0.003123>, <-0.397735, -0.917474, -0.006942>, <-0.397735, -0.917474, -0.006942>, <-0.397735, -0.917474, -0.006942>, <-0.367412, -0.930036, -0.006413>, 
			<-0.367412, -0.930036, -0.006413>, <-0.367412, -0.930036, -0.006413>, <-0.569056, -0.822239, -0.009933>, <-0.569056, -0.822239, -0.009933>, <-0.569056, -0.822239, -0.009933>, <-0.541766, -0.840476, -0.009457>, <-0.541766, -0.840476, -0.009457>, <-0.541766, -0.840476, -0.009457>, <-0.718508, -0.695406, -0.012542>, <-0.718508, -0.695406, -0.012542>, <-0.718508, -0.695406, -0.012542>, 
			<-0.695300, -0.718617, -0.012137>, <-0.695300, -0.718617, -0.012137>, <-0.695300, -0.718617, -0.012137>, <-0.840348, -0.541848, -0.014668>, <-0.840348, -0.541848, -0.014668>, <-0.840348, -0.541848, -0.014668>, <-0.822114, -0.569142, -0.014350>, <-0.822114, -0.569142, -0.014350>, <-0.822114, -0.569142, -0.014350>, <-0.929894, -0.367468, -0.016231>, <-0.929894, -0.367468, -0.016231>, 
			<-0.929894, -0.367468, -0.016231>, <-0.917334, -0.397795, -0.016012>, <-0.917334, -0.397795, -0.016012>, <-0.917334, -0.397795, -0.016012>, <-0.983705, -0.178966, -0.017171>, <-0.983705, -0.178966, -0.017171>, <-0.983705, -0.178966, -0.017171>, <-0.977302, -0.211162, -0.017059>, <-0.977302, -0.211162, -0.017059>, <-0.977302, -0.211162, -0.017059>, <-0.999824, -0.006934, -0.017452>, 
			<-0.999824, -0.006934, -0.017452>, <-0.999824, -0.006934, -0.017452>, <-0.999779, -0.011714, -0.017451>, <-0.999779, -0.011714, -0.017451>, <-0.999779, -0.011714, -0.017451>, <-0.983705, 0.178966, -0.017171>, <-0.983705, 0.178966, -0.017171>, <-0.983705, 0.178966, -0.017171>, <-0.977302, 0.211162, -0.017059>, <-0.977302, 0.211162, -0.017059>, <-0.977302, 0.211162, -0.017059>, 
			<-0.929894, 0.367468, -0.016231>, <-0.929894, 0.367468, -0.016231>, <-0.929894, 0.367468, -0.016231>, <-0.917334, 0.397795, -0.016012>, <-0.917334, 0.397795, -0.016012>, <-0.917334, 0.397795, -0.016012>, <-0.840348, 0.541848, -0.014668>, <-0.840348, 0.541848, -0.014668>, <-0.840348, 0.541848, -0.014668>, <-0.822114, 0.569142, -0.014350>, <-0.822114, 0.569142, -0.014350>, 
			<-0.822114, 0.569142, -0.014350>, <-0.718508, 0.695406, -0.012542>, <-0.718508, 0.695406, -0.012542>, <-0.718508, 0.695406, -0.012542>, <-0.695300, 0.718617, -0.012137>, <-0.695300, 0.718617, -0.012137>, <-0.695300, 0.718617, -0.012137>, <-0.569056, 0.822239, -0.009933>, <-0.569056, 0.822239, -0.009933>, <-0.569056, 0.822239, -0.009933>, <-0.541766, 0.840476, -0.009457>, 
			<-0.541766, 0.840476, -0.009457>, <-0.541766, 0.840476, -0.009457>, <-0.397735, 0.917474, -0.006942>, <-0.397735, 0.917474, -0.006942>, <-0.397735, 0.917474, -0.006942>, <-0.367412, 0.930036, -0.006413>, <-0.367412, 0.930036, -0.006413>, <-0.367412, 0.930036, -0.006413>, <-0.211130, 0.977451, -0.003685>, <-0.211130, 0.977451, -0.003685>, <-0.211130, 0.977451, -0.003685>, 
			<-0.178939, 0.983855, -0.003123>, <-0.178939, 0.983855, -0.003123>, <-0.178939, 0.983855, -0.003123>, <-0.016411, 0.999865, -0.000286>, <-0.016411, 0.999865, -0.000286>, <-0.016411, 0.999865, -0.000286>, <0.016411, 0.999865, 0.000286>, <0.016411, 0.999865, 0.000286>, <0.016411, 0.999865, 0.000286>, <0.178939, 0.983855, 0.003123>, <0.178939, 0.983855, 0.003123>, 
			<0.178939, 0.983855, 0.003123>, <0.211130, 0.977451, 0.003685>, <0.211130, 0.977451, 0.003685>, <0.211130, 0.977451, 0.003685>, <0.367412, 0.930036, 0.006413>, <0.367412, 0.930036, 0.006413>, <0.367412, 0.930036, 0.006413>, <0.397735, 0.917474, 0.006942>, <0.397735, 0.917474, 0.006942>, <0.397735, 0.917474, 0.006942>, <0.541766, 0.840476, 0.009457>, 
			<0.541766, 0.840476, 0.009457>, <0.541766, 0.840476, 0.009457>, <0.569056, 0.822239, 0.009933>, <0.569056, 0.822239, 0.009933>, <0.569056, 0.822239, 0.009933>, <0.695300, 0.718617, 0.012137>, <0.695300, 0.718617, 0.012137>, <0.695300, 0.718617, 0.012137>, <0.718508, 0.695406, 0.012542>, <0.718508, 0.695406, 0.012542>, <0.718508, 0.695406, 0.012542>, 
			<0.822114, 0.569142, 0.014350>, <0.822114, 0.569142, 0.014350>, <0.822114, 0.569142, 0.014350>, <0.840348, 0.541848, 0.014668>, <0.840348, 0.541848, 0.014668>, <0.840348, 0.541848, 0.014668>, <0.917334, 0.397795, 0.016012>, <0.917334, 0.397795, 0.016012>, <0.917334, 0.397795, 0.016012>, <0.929894, 0.367468, 0.016231>, <0.929894, 0.367468, 0.016231>, 
			<0.929894, 0.367468, 0.016231>, <0.983705, 0.178966, 0.017171>, <0.983705, 0.178966, 0.017171>, <0.977302, 0.211162, 0.017059>, <0.977302, 0.211162, 0.017059>, <0.977302, 0.211162, 0.017059>, <0.983705, 0.178966, 0.017171>, <-0.999804, 0.009324, -0.017452>, <-0.999804, 0.009324, -0.017452>, <-0.999804, 0.009324, -0.017452>, <-0.999804, 0.009324, -0.017452>, 
			<0.999779, 0.011714, 0.017451>, <0.999779, 0.011714, 0.017451>, <0.999804, 0.009324, 0.017452>, <0.999804, 0.009324, 0.017452>, <0.999779, 0.011714, 0.017451>, <-0.999529, 0.025235, -0.017447>, <-0.999529, 0.025235, -0.017447>, <-0.999529, 0.025235, -0.017447>, <-0.999529, 0.025235, -0.017447>, <-0.999529, 0.025235, -0.017447>, <-0.999529, 0.025235, -0.017447>, 
			<-0.999670, -0.018871, -0.017449>, <-0.999670, -0.018871, -0.017449>, <-0.999670, -0.018871, -0.017449>, <-0.999348, -0.031596, -0.017444>, <-0.999348, -0.031596, -0.017444>, <-0.999348, -0.031596, -0.017444>, <-0.935910, -0.351862, -0.016336>, <-0.935910, -0.351862, -0.016336>, <-0.935910, -0.351862, -0.016336>, <-0.910554, -0.413085, -0.015894>, <-0.910554, -0.413085, -0.015894>, 
			<-0.910554, -0.413085, -0.015894>, <-0.730037, -0.683289, -0.012743>, <-0.730037, -0.683289, -0.012743>, <-0.730037, -0.683289, -0.012743>, <-0.683185, -0.730148, -0.011925>, <-0.683185, -0.730148, -0.011925>, <-0.683185, -0.730148, -0.011925>, <-0.413022, -0.910692, -0.007209>, <-0.413022, -0.910692, -0.007209>, <-0.413022, -0.910692, -0.007209>, <-0.351808, -0.936052, -0.006141>, 
			<-0.351808, -0.936052, -0.006141>, <-0.351808, -0.936052, -0.006141>, <-0.033129, -0.999451, -0.000578>, <-0.033129, -0.999451, -0.000578>, <-0.033129, -0.999451, -0.000578>, <0.033129, -0.999451, 0.000578>, <0.033129, -0.999451, 0.000578>, <0.033129, -0.999451, 0.000578>, <0.351808, -0.936052, 0.006141>, <0.351808, -0.936052, 0.006141>, <0.351808, -0.936052, 0.006141>, 
			<0.413022, -0.910692, 0.007209>, <0.413022, -0.910692, 0.007209>, <0.413022, -0.910692, 0.007209>, <0.683185, -0.730148, 0.011925>, <0.683185, -0.730148, 0.011925>, <0.683185, -0.730148, 0.011925>, <0.730037, -0.683289, 0.012743>, <0.730037, -0.683289, 0.012743>, <0.730037, -0.683289, 0.012743>, <0.910554, -0.413085, 0.015894>, <0.910554, -0.413085, 0.015894>, 
			<0.910554, -0.413085, 0.015894>, <0.935910, -0.351862, 0.016336>, <0.935910, -0.351862, 0.016336>, <0.935910, -0.351862, 0.016336>, <0.999348, -0.031600, 0.017444>, <0.999348, -0.031600, 0.017444>, <0.999348, -0.031600, 0.017444>, <0.999670, -0.018875, 0.017449>, <0.999670, -0.018875, 0.017449>, <0.999670, -0.018875, 0.017449>, <0.999529, 0.025237, 0.017447>, 
			<0.999529, 0.025237, 0.017447>, <0.999529, 0.025237, 0.017447>, <0.999529, 0.025237, 0.017447>, <0.999529, 0.025237, 0.017447>, <0.999529, 0.025237, 0.017447>, <0.910550, 0.413093, 0.015894>, <0.910550, 0.413093, 0.015894>, <0.910550, 0.413093, 0.015894>, <0.935905, 0.351874, 0.016336>, <0.935905, 0.351874, 0.016336>, <0.935905, 0.351874, 0.016336>, 
			<0.683185, 0.730148, 0.011925>, <0.683185, 0.730148, 0.011925>, <0.683185, 0.730148, 0.011925>, <0.730037, 0.683289, 0.012743>, <0.730037, 0.683289, 0.012743>, <0.730037, 0.683289, 0.012743>, <0.351808, 0.936052, 0.006141>, <0.351808, 0.936052, 0.006141>, <0.351808, 0.936052, 0.006141>, <0.413022, 0.910692, 0.007209>, <0.413022, 0.910692, 0.007209>, 
			<0.413022, 0.910692, 0.007209>, <-0.033129, 0.999451, -0.000578>, <-0.033129, 0.999451, -0.000578>, <-0.033129, 0.999451, -0.000578>, <0.033129, 0.999451, 0.000578>, <0.033129, 0.999451, 0.000578>, <0.033129, 0.999451, 0.000578>, <-0.413022, 0.910692, -0.007209>, <-0.413022, 0.910692, -0.007209>, <-0.413022, 0.910692, -0.007209>, <-0.351808, 0.936052, -0.006141>, 
			<-0.351808, 0.936052, -0.006141>, <-0.351808, 0.936052, -0.006141>, <-0.730037, 0.683289, -0.012743>, <-0.730037, 0.683289, -0.012743>, <-0.730037, 0.683289, -0.012743>, <-0.683185, 0.730148, -0.011925>, <-0.683185, 0.730148, -0.011925>, <-0.683185, 0.730148, -0.011925>, <-0.935914, 0.351850, -0.016336>, <-0.935914, 0.351850, -0.016336>, <-0.935914, 0.351850, -0.016336>, 
			<-0.910557, 0.413077, -0.015894>, <-0.910557, 0.413077, -0.015894>, <-0.910557, 0.413077, -0.015894>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.999824, -0.006934, 0.017452>, <0.999824, -0.006934, 0.017452>, <0.999824, -0.006934, 0.017452>, <0.999824, -0.006934, 0.017452>, <0.999824, -0.006934, 0.017452>, <0.999824, -0.006934, 0.017452>, <0.983705, -0.178966, 0.017171>, <0.983705, -0.178966, 0.017171>, <0.983705, -0.178966, 0.017171>, <0.977302, -0.211162, 0.017059>, 
			<0.977302, -0.211162, 0.017059>, <0.977302, -0.211162, 0.017059>, <0.929894, -0.367468, 0.016231>, <0.929894, -0.367468, 0.016231>, <0.929894, -0.367468, 0.016231>, <0.917334, -0.397795, 0.016012>, <0.917334, -0.397795, 0.016012>, <0.917334, -0.397795, 0.016012>, <0.840348, -0.541848, 0.014668>, <0.840348, -0.541848, 0.014668>, <0.840348, -0.541848, 0.014668>, 
			<0.822114, -0.569142, 0.014350>, <0.822114, -0.569142, 0.014350>, <0.822114, -0.569142, 0.014350>, <0.718508, -0.695406, 0.012542>, <0.718508, -0.695406, 0.012542>, <0.718508, -0.695406, 0.012542>, <0.695300, -0.718617, 0.012137>, <0.695300, -0.718617, 0.012137>, <0.695300, -0.718617, 0.012137>, <0.569056, -0.822239, 0.009933>, <0.569056, -0.822239, 0.009933>, 
			<0.569056, -0.822239, 0.009933>, <0.541766, -0.840476, 0.009457>, <0.541766, -0.840476, 0.009457>, <0.541766, -0.840476, 0.009457>, <0.397735, -0.917474, 0.006942>, <0.397735, -0.917474, 0.006942>, <0.397735, -0.917474, 0.006942>, <0.367412, -0.930036, 0.006413>, <0.367412, -0.930036, 0.006413>, <0.367412, -0.930036, 0.006413>, <0.211130, -0.977451, 0.003685>, 
			<0.211130, -0.977451, 0.003685>, <0.211130, -0.977451, 0.003685>, <0.178939, -0.983855, 0.003123>, <0.178939, -0.983855, 0.003123>, <0.178939, -0.983855, 0.003123>, <0.016411, -0.999865, 0.000286>, <0.016411, -0.999865, 0.000286>, <0.016411, -0.999865, 0.000286>, <-0.016411, -0.999865, -0.000286>, <-0.016411, -0.999865, -0.000286>, <-0.016411, -0.999865, -0.000286>, 
			<-0.178939, -0.983855, -0.003123>, <-0.178939, -0.983855, -0.003123>, <-0.178939, -0.983855, -0.003123>, <-0.211130, -0.977451, -0.003685>, <-0.211130, -0.977451, -0.003685>, <-0.211130, -0.977451, -0.003685>, <-0.367412, -0.930036, -0.006413>, <-0.367412, -0.930036, -0.006413>, <-0.367412, -0.930036, -0.006413>, <-0.397735, -0.917474, -0.006942>, <-0.397735, -0.917474, -0.006942>, 
			<-0.397735, -0.917474, -0.006942>, <-0.541766, -0.840476, -0.009457>, <-0.541766, -0.840476, -0.009457>, <-0.541766, -0.840476, -0.009457>, <-0.569056, -0.822239, -0.009933>, <-0.569056, -0.822239, -0.009933>, <-0.569056, -0.822239, -0.009933>, <-0.695300, -0.718617, -0.012137>, <-0.695300, -0.718617, -0.012137>, <-0.695300, -0.718617, -0.012137>, <-0.718508, -0.695406, -0.012542>, 
			<-0.718508, -0.695406, -0.012542>, <-0.718508, -0.695406, -0.012542>, <-0.822114, -0.569142, -0.014350>, <-0.822114, -0.569142, -0.014350>, <-0.822114, -0.569142, -0.014350>, <-0.840348, -0.541848, -0.014668>, <-0.840348, -0.541848, -0.014668>, <-0.840348, -0.541848, -0.014668>, <-0.917334, -0.397795, -0.016012>, <-0.917334, -0.397795, -0.016012>, <-0.917334, -0.397795, -0.016012>, 
			<-0.929894, -0.367468, -0.016231>, <-0.929894, -0.367468, -0.016231>, <-0.929894, -0.367468, -0.016231>, <-0.977302, -0.211162, -0.017059>, <-0.977302, -0.211162, -0.017059>, <-0.977302, -0.211162, -0.017059>, <-0.983705, -0.178966, -0.017171>, <-0.983705, -0.178966, -0.017171>, <-0.983705, -0.178966, -0.017171>, <-0.999779, -0.011714, -0.017451>, <-0.999779, -0.011714, -0.017451>, 
			<-0.999779, -0.011714, -0.017451>, <-0.999824, -0.006934, -0.017452>, <-0.999824, -0.006934, -0.017452>, <-0.999824, -0.006934, -0.017452>, <-0.977302, 0.211162, -0.017059>, <-0.977302, 0.211162, -0.017059>, <-0.977302, 0.211162, -0.017059>, <-0.983705, 0.178966, -0.017171>, <-0.983705, 0.178966, -0.017171>, <-0.983705, 0.178966, -0.017171>, <-0.917334, 0.397795, -0.016012>, 
			<-0.917334, 0.397795, -0.016012>, <-0.917334, 0.397795, -0.016012>, <-0.929894, 0.367468, -0.016231>, <-0.929894, 0.367468, -0.016231>, <-0.929894, 0.367468, -0.016231>, <-0.822114, 0.569142, -0.014350>, <-0.822114, 0.569142, -0.014350>, <-0.822114, 0.569142, -0.014350>, <-0.840348, 0.541848, -0.014668>, <-0.840348, 0.541848, -0.014668>, <-0.840348, 0.541848, -0.014668>, 
			<-0.695300, 0.718617, -0.012137>, <-0.695300, 0.718617, -0.012137>, <-0.695300, 0.718617, -0.012137>, <-0.718508, 0.695406, -0.012542>, <-0.718508, 0.695406, -0.012542>, <-0.718508, 0.695406, -0.012542>, <-0.541766, 0.840476, -0.009457>, <-0.541766, 0.840476, -0.009457>, <-0.541766, 0.840476, -0.009457>, <-0.569056, 0.822239, -0.009933>, <-0.569056, 0.822239, -0.009933>, 
			<-0.569056, 0.822239, -0.009933>, <-0.367412, 0.930036, -0.006413>, <-0.367412, 0.930036, -0.006413>, <-0.367412, 0.930036, -0.006413>, <-0.397735, 0.917474, -0.006942>, <-0.397735, 0.917474, -0.006942>, <-0.397735, 0.917474, -0.006942>, <-0.178939, 0.983855, -0.003123>, <-0.178939, 0.983855, -0.003123>, <-0.178939, 0.983855, -0.003123>, <-0.211130, 0.977451, -0.003685>, 
			<-0.211130, 0.977451, -0.003685>, <-0.211130, 0.977451, -0.003685>, <0.016411, 0.999865, 0.000286>, <0.016411, 0.999865, 0.000286>, <0.016411, 0.999865, 0.000286>, <-0.016411, 0.999865, -0.000286>, <-0.016411, 0.999865, -0.000286>, <-0.016411, 0.999865, -0.000286>, <0.211130, 0.977451, 0.003685>, <0.211130, 0.977451, 0.003685>, <0.211130, 0.977451, 0.003685>, 
			<0.178939, 0.983855, 0.003123>, <0.178939, 0.983855, 0.003123>, <0.178939, 0.983855, 0.003123>, <0.397735, 0.917474, 0.006942>, <0.397735, 0.917474, 0.006942>, <0.397735, 0.917474, 0.006942>, <0.367412, 0.930036, 0.006413>, <0.367412, 0.930036, 0.006413>, <0.367412, 0.930036, 0.006413>, <0.569056, 0.822239, 0.009933>, <0.569056, 0.822239, 0.009933>, 
			<0.569056, 0.822239, 0.009933>, <0.541766, 0.840476, 0.009457>, <0.541766, 0.840476, 0.009457>, <0.541766, 0.840476, 0.009457>, <0.718508, 0.695406, 0.012542>, <0.718508, 0.695406, 0.012542>, <0.718508, 0.695406, 0.012542>, <0.695300, 0.718617, 0.012137>, <0.695300, 0.718617, 0.012137>, <0.695300, 0.718617, 0.012137>, <0.840348, 0.541848, 0.014668>, 
			<0.840348, 0.541848, 0.014668>, <0.840348, 0.541848, 0.014668>, <0.822114, 0.569142, 0.014350>, <0.822114, 0.569142, 0.014350>, <0.822114, 0.569142, 0.014350>, <0.929894, 0.367468, 0.016231>, <0.929894, 0.367468, 0.016231>, <0.929894, 0.367468, 0.016231>, <0.917334, 0.397795, 0.016012>, <0.917334, 0.397795, 0.016012>, <0.917334, 0.397795, 0.016012>, 
			<0.983705, 0.178966, 0.017171>, <0.983705, 0.178966, 0.017171>, <0.983705, 0.178966, 0.017171>, <0.977302, 0.211162, 0.017059>, <0.977302, 0.211162, 0.017059>, <0.977302, 0.211162, 0.017059>, <-0.999804, 0.009324, -0.017452>, <-0.999804, 0.009324, -0.017452>, <-0.999779, 0.011714, -0.017451>, <-0.999779, 0.011714, -0.017451>, <-0.999779, 0.011714, -0.017451>, 
			<0.999804, 0.009324, 0.017452>, <0.999804, 0.009324, 0.017452>, <0.999804, 0.009324, 0.017452>, <0.999804, 0.009324, 0.017452>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <-0.999670, 0.018873, -0.017449>, <-0.999670, 0.018873, -0.017449>, <-0.999670, 0.018873, -0.017449>, <-0.999529, 0.025235, -0.017447>, <-0.999529, 0.025235, -0.017447>, 
			<-0.999529, 0.025235, -0.017447>, <-0.999529, 0.025235, -0.017447>, <-0.999670, -0.018871, -0.017449>, <-0.999670, -0.018871, -0.017449>, <-0.999670, -0.018871, -0.017449>, <-0.999348, -0.031596, -0.017444>, <-0.999348, -0.031596, -0.017444>, <-0.999348, -0.031596, -0.017444>, <-0.935910, -0.351862, -0.016336>, <-0.935910, -0.351862, -0.016336>, <-0.935910, -0.351862, -0.016336>, 
			<-0.910554, -0.413085, -0.015894>, <-0.910554, -0.413085, -0.015894>, <-0.910554, -0.413085, -0.015894>, <-0.730037, -0.683289, -0.012743>, <-0.730037, -0.683289, -0.012743>, <-0.730037, -0.683289, -0.012743>, <-0.683185, -0.730148, -0.011925>, <-0.683185, -0.730148, -0.011925>, <-0.683185, -0.730148, -0.011925>, <-0.413022, -0.910692, -0.007209>, <-0.413022, -0.910692, -0.007209>, 
			<-0.413022, -0.910692, -0.007209>, <-0.351808, -0.936052, -0.006141>, <-0.351808, -0.936052, -0.006141>, <-0.351808, -0.936052, -0.006141>, <-0.033129, -0.999451, -0.000578>, <-0.033129, -0.999451, -0.000578>, <-0.033129, -0.999451, -0.000578>, <0.033129, -0.999451, 0.000578>, <0.033129, -0.999451, 0.000578>, <0.033129, -0.999451, 0.000578>, <0.351808, -0.936052, 0.006141>, 
			<0.351808, -0.936052, 0.006141>, <0.351808, -0.936052, 0.006141>, <0.413022, -0.910692, 0.007209>, <0.413022, -0.910692, 0.007209>, <0.413022, -0.910692, 0.007209>, <0.683185, -0.730148, 0.011925>, <0.683185, -0.730148, 0.011925>, <0.683185, -0.730148, 0.011925>, <0.730037, -0.683289, 0.012743>, <0.730037, -0.683289, 0.012743>, <0.730037, -0.683289, 0.012743>, 
			<0.910554, -0.413085, 0.015894>, <0.910554, -0.413085, 0.015894>, <0.910554, -0.413085, 0.015894>, <0.935910, -0.351862, 0.016336>, <0.935910, -0.351862, 0.016336>, <0.935910, -0.351862, 0.016336>, <0.999348, -0.031600, 0.017444>, <0.999348, -0.031600, 0.017444>, <0.999348, -0.031600, 0.017444>, <0.999670, -0.018875, 0.017449>, <0.999670, -0.018875, 0.017449>, 
			<0.999670, -0.018875, 0.017449>, <0.999529, 0.025237, 0.017447>, <0.999529, 0.025237, 0.017447>, <0.999529, 0.025237, 0.017447>, <0.999529, 0.025237, 0.017447>, <0.999529, 0.025237, 0.017447>, <0.999529, 0.025237, 0.017447>, <0.910550, 0.413093, 0.015894>, <0.910550, 0.413093, 0.015894>, <0.910550, 0.413093, 0.015894>, <0.935905, 0.351874, 0.016336>, 
			<0.935905, 0.351874, 0.016336>, <0.935905, 0.351874, 0.016336>, <0.683185, 0.730148, 0.011925>, <0.683185, 0.730148, 0.011925>, <0.683185, 0.730148, 0.011925>, <0.730037, 0.683289, 0.012743>, <0.730037, 0.683289, 0.012743>, <0.730037, 0.683289, 0.012743>, <0.351808, 0.936052, 0.006141>, <0.351808, 0.936052, 0.006141>, <0.351808, 0.936052, 0.006141>, 
			<0.413022, 0.910692, 0.007209>, <0.413022, 0.910692, 0.007209>, <0.413022, 0.910692, 0.007209>, <-0.033129, 0.999451, -0.000578>, <-0.033129, 0.999451, -0.000578>, <-0.033129, 0.999451, -0.000578>, <0.033129, 0.999451, 0.000578>, <0.033129, 0.999451, 0.000578>, <0.033129, 0.999451, 0.000578>, <-0.413022, 0.910692, -0.007209>, <-0.413022, 0.910692, -0.007209>, 
			<-0.413022, 0.910692, -0.007209>, <-0.351808, 0.936052, -0.006141>, <-0.351808, 0.936052, -0.006141>, <-0.351808, 0.936052, -0.006141>, <-0.730037, 0.683289, -0.012743>, <-0.730037, 0.683289, -0.012743>, <-0.730037, 0.683289, -0.012743>, <-0.683185, 0.730148, -0.011925>, <-0.683185, 0.730148, -0.011925>, <-0.683185, 0.730148, -0.011925>, <-0.935914, 0.351850, -0.016336>, 
			<-0.935914, 0.351850, -0.016336>, <-0.935914, 0.351850, -0.016336>, <-0.910557, 0.413077, -0.015894>, <-0.910557, 0.413077, -0.015894>, <-0.910557, 0.413077, -0.015894>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <0.999804, -0.009324, 0.017452>, <0.999804, -0.009324, 0.017452>, <0.999804, -0.009324, 0.017452>, 
			<0.999804, -0.009324, 0.017452>, <0.999824, -0.006934, 0.017452>, <0.999824, -0.006934, 0.017452>, <0.999824, -0.006934, 0.017452>, <0.977302, -0.211162, 0.017059>, <0.977302, -0.211162, 0.017059>, <0.977302, -0.211162, 0.017059>, <0.983705, -0.178966, 0.017171>, <0.983705, -0.178966, 0.017171>, <0.983705, -0.178966, 0.017171>, <0.917334, -0.397795, 0.016012>, 
			<0.917334, -0.397795, 0.016012>, <0.917334, -0.397795, 0.016012>, <0.929894, -0.367468, 0.016231>, <0.929894, -0.367468, 0.016231>, <0.929894, -0.367468, 0.016231>, <0.822114, -0.569142, 0.014350>, <0.822114, -0.569142, 0.014350>, <0.822114, -0.569142, 0.014350>, <0.840348, -0.541848, 0.014668>, <0.840348, -0.541848, 0.014668>, <0.840348, -0.541848, 0.014668>, 
			<0.695300, -0.718617, 0.012137>, <0.695300, -0.718617, 0.012137>, <0.695300, -0.718617, 0.012137>, <0.718508, -0.695406, 0.012542>, <0.718508, -0.695406, 0.012542>, <0.718508, -0.695406, 0.012542>, <0.541766, -0.840476, 0.009457>, <0.541766, -0.840476, 0.009457>, <0.541766, -0.840476, 0.009457>, <0.569056, -0.822239, 0.009933>, <0.569056, -0.822239, 0.009933>, 
			<0.569056, -0.822239, 0.009933>, <0.367412, -0.930036, 0.006413>, <0.367412, -0.930036, 0.006413>, <0.367412, -0.930036, 0.006413>, <0.397735, -0.917474, 0.006942>, <0.397735, -0.917474, 0.006942>, <0.397735, -0.917474, 0.006942>, <0.178939, -0.983855, 0.003123>, <0.178939, -0.983855, 0.003123>, <0.178939, -0.983855, 0.003123>, <0.211130, -0.977451, 0.003685>, 
			<0.211130, -0.977451, 0.003685>, <0.211130, -0.977451, 0.003685>, <-0.016411, -0.999865, -0.000286>, <-0.016411, -0.999865, -0.000286>, <-0.016411, -0.999865, -0.000286>, <0.016411, -0.999865, 0.000286>, <0.016411, -0.999865, 0.000286>, <0.016411, -0.999865, 0.000286>, <-0.211130, -0.977451, -0.003685>, <-0.211130, -0.977451, -0.003685>, <-0.211130, -0.977451, -0.003685>, 
			<-0.178939, -0.983855, -0.003123>, <-0.178939, -0.983855, -0.003123>, <-0.178939, -0.983855, -0.003123>, <-0.397735, -0.917474, -0.006942>, <-0.397735, -0.917474, -0.006942>, <-0.397735, -0.917474, -0.006942>, <-0.367412, -0.930036, -0.006413>, <-0.367412, -0.930036, -0.006413>, <-0.367412, -0.930036, -0.006413>, <-0.569056, -0.822239, -0.009933>, <-0.569056, -0.822239, -0.009933>, 
			<-0.569056, -0.822239, -0.009933>, <-0.541766, -0.840476, -0.009457>, <-0.541766, -0.840476, -0.009457>, <-0.541766, -0.840476, -0.009457>, <-0.718508, -0.695406, -0.012542>, <-0.718508, -0.695406, -0.012542>, <-0.718508, -0.695406, -0.012542>, <-0.695300, -0.718617, -0.012137>, <-0.695300, -0.718617, -0.012137>, <-0.695300, -0.718617, -0.012137>, <-0.840348, -0.541848, -0.014668>, 
			<-0.840348, -0.541848, -0.014668>, <-0.840348, -0.541848, -0.014668>, <-0.822114, -0.569142, -0.014350>, <-0.822114, -0.569142, -0.014350>, <-0.822114, -0.569142, -0.014350>, <-0.929894, -0.367468, -0.016231>, <-0.929894, -0.367468, -0.016231>, <-0.929894, -0.367468, -0.016231>, <-0.917334, -0.397795, -0.016012>, <-0.917334, -0.397795, -0.016012>, <-0.917334, -0.397795, -0.016012>, 
			<-0.983705, -0.178966, -0.017171>, <-0.983705, -0.178966, -0.017171>, <-0.983705, -0.178966, -0.017171>, <-0.977302, -0.211162, -0.017059>, <-0.977302, -0.211162, -0.017059>, <-0.977302, -0.211162, -0.017059>, <-0.999824, -0.006934, -0.017452>, <-0.999824, -0.006934, -0.017452>, <-0.999824, -0.006934, -0.017452>, <-0.999804, -0.009324, -0.017452>, <-0.999804, -0.009324, -0.017452>, 
			<-0.983705, 0.178966, -0.017171>, <-0.983705, 0.178966, -0.017171>, <-0.983705, 0.178966, -0.017171>, <-0.977302, 0.211162, -0.017059>, <-0.977302, 0.211162, -0.017059>, <-0.977302, 0.211162, -0.017059>, <-0.929894, 0.367468, -0.016231>, <-0.929894, 0.367468, -0.016231>, <-0.929894, 0.367468, -0.016231>, <-0.917334, 0.397795, -0.016012>, <-0.917334, 0.397795, -0.016012>, 
			<-0.917334, 0.397795, -0.016012>, <-0.840348, 0.541848, -0.014668>, <-0.840348, 0.541848, -0.014668>, <-0.840348, 0.541848, -0.014668>, <-0.822114, 0.569142, -0.014350>, <-0.822114, 0.569142, -0.014350>, <-0.822114, 0.569142, -0.014350>, <-0.718508, 0.695406, -0.012542>, <-0.718508, 0.695406, -0.012542>, <-0.718508, 0.695406, -0.012542>, <-0.695300, 0.718617, -0.012137>, 
			<-0.695300, 0.718617, -0.012137>, <-0.695300, 0.718617, -0.012137>, <-0.569056, 0.822239, -0.009933>, <-0.569056, 0.822239, -0.009933>, <-0.569056, 0.822239, -0.009933>, <-0.541766, 0.840476, -0.009457>, <-0.541766, 0.840476, -0.009457>, <-0.541766, 0.840476, -0.009457>, <-0.397735, 0.917474, -0.006942>, <-0.397735, 0.917474, -0.006942>, <-0.397735, 0.917474, -0.006942>, 
			<-0.367412, 0.930036, -0.006413>, <-0.367412, 0.930036, -0.006413>, <-0.367412, 0.930036, -0.006413>, <-0.211130, 0.977451, -0.003685>, <-0.211130, 0.977451, -0.003685>, <-0.211130, 0.977451, -0.003685>, <-0.178939, 0.983855, -0.003123>, <-0.178939, 0.983855, -0.003123>, <-0.178939, 0.983855, -0.003123>, <-0.016411, 0.999865, -0.000286>, <-0.016411, 0.999865, -0.000286>, 
			<-0.016411, 0.999865, -0.000286>, <0.016411, 0.999865, 0.000286>, <0.016411, 0.999865, 0.000286>, <0.016411, 0.999865, 0.000286>, <0.178939, 0.983855, 0.003123>, <0.178939, 0.983855, 0.003123>, <0.178939, 0.983855, 0.003123>, <0.211130, 0.977451, 0.003685>, <0.211130, 0.977451, 0.003685>, <0.211130, 0.977451, 0.003685>, <0.367412, 0.930036, 0.006413>, 
			<0.367412, 0.930036, 0.006413>, <0.367412, 0.930036, 0.006413>, <0.397735, 0.917474, 0.006942>, <0.397735, 0.917474, 0.006942>, <0.397735, 0.917474, 0.006942>, <0.541766, 0.840476, 0.009457>, <0.541766, 0.840476, 0.009457>, <0.541766, 0.840476, 0.009457>, <0.569056, 0.822239, 0.009933>, <0.569056, 0.822239, 0.009933>, <0.569056, 0.822239, 0.009933>, 
			<0.695300, 0.718617, 0.012137>, <0.695300, 0.718617, 0.012137>, <0.695300, 0.718617, 0.012137>, <0.718508, 0.695406, 0.012542>, <0.718508, 0.695406, 0.012542>, <0.718508, 0.695406, 0.012542>, <0.822114, 0.569142, 0.014350>, <0.822114, 0.569142, 0.014350>, <0.822114, 0.569142, 0.014350>, <0.840348, 0.541848, 0.014668>, <0.840348, 0.541848, 0.014668>, 
			<0.840348, 0.541848, 0.014668>, <0.917334, 0.397795, 0.016012>, <0.917334, 0.397795, 0.016012>, <0.917334, 0.397795, 0.016012>, <0.929894, 0.367468, 0.016231>, <0.929894, 0.367468, 0.016231>, <0.929894, 0.367468, 0.016231>, <0.983705, 0.178966, 0.017171>, <0.983705, 0.178966, 0.017171>, <0.977302, 0.211162, 0.017059>, <0.977302, 0.211162, 0.017059>, 
			<0.977302, 0.211162, 0.017059>, <0.983705, 0.178966, 0.017171>, <-0.999779, 0.011714, -0.017451>, <-0.999779, 0.011714, -0.017451>, <-0.999779, 0.011714, -0.017451>, <-0.999804, 0.009324, -0.017452>, <-0.999804, 0.009324, -0.017452>, <-0.999804, 0.009324, -0.017452>, <-0.999804, 0.009324, -0.017452>, <0.999779, 0.011714, 0.017451>, <0.999779, 0.011714, 0.017451>, 
			<0.999804, 0.009324, 0.017452>, <0.999804, 0.009324, 0.017452>, <0.999779, 0.011714, 0.017451>, <-0.999670, 0.018873, -0.017449>, <-0.999670, 0.018873, -0.017449>, <-0.999670, 0.018873, -0.017449>, <-0.999529, 0.025235, -0.017447>, <-0.999529, 0.025235, -0.017447>, <-0.999529, 0.025235, -0.017447>, <-0.999529, 0.025235, -0.017447>, <-0.999670, -0.018871, -0.017449>, 
			<-0.999670, -0.018871, -0.017449>, <-0.999670, -0.018871, -0.017449>, <-0.999348, -0.031596, -0.017444>, <-0.999348, -0.031596, -0.017444>, <-0.999348, -0.031596, -0.017444>, <-0.935910, -0.351862, -0.016336>, <-0.935910, -0.351862, -0.016336>, <-0.935910, -0.351862, -0.016336>, <-0.910554, -0.413085, -0.015894>, <-0.910554, -0.413085, -0.015894>, <-0.910554, -0.413085, -0.015894>, 
			<-0.730037, -0.683289, -0.012743>, <-0.730037, -0.683289, -0.012743>, <-0.730037, -0.683289, -0.012743>, <-0.683185, -0.730148, -0.011925>, <-0.683185, -0.730148, -0.011925>, <-0.683185, -0.730148, -0.011925>, <-0.413022, -0.910692, -0.007209>, <-0.413022, -0.910692, -0.007209>, <-0.413022, -0.910692, -0.007209>, <-0.351808, -0.936052, -0.006141>, <-0.351808, -0.936052, -0.006141>, 
			<-0.351808, -0.936052, -0.006141>, <-0.033129, -0.999451, -0.000578>, <-0.033129, -0.999451, -0.000578>, <-0.033129, -0.999451, -0.000578>, <0.033129, -0.999451, 0.000578>, <0.033129, -0.999451, 0.000578>, <0.033129, -0.999451, 0.000578>, <0.351808, -0.936052, 0.006141>, <0.351808, -0.936052, 0.006141>, <0.351808, -0.936052, 0.006141>, <0.413022, -0.910692, 0.007209>, 
			<0.413022, -0.910692, 0.007209>, <0.413022, -0.910692, 0.007209>, <0.683185, -0.730148, 0.011925>, <0.683185, -0.730148, 0.011925>, <0.683185, -0.730148, 0.011925>, <0.730037, -0.683289, 0.012743>, <0.730037, -0.683289, 0.012743>, <0.730037, -0.683289, 0.012743>, <0.910554, -0.413085, 0.015894>, <0.910554, -0.413085, 0.015894>, <0.910554, -0.413085, 0.015894>, 
			<0.935910, -0.351862, 0.016336>, <0.935910, -0.351862, 0.016336>, <0.935910, -0.351862, 0.016336>, <0.999348, -0.031600, 0.017444>, <0.999348, -0.031600, 0.017444>, <0.999348, -0.031600, 0.017444>, <0.999670, -0.018875, 0.017449>, <0.999670, -0.018875, 0.017449>, <0.999670, -0.018875, 0.017449>, <0.999529, 0.025237, 0.017447>, <0.999529, 0.025237, 0.017447>, 
			<0.999529, 0.025237, 0.017447>, <0.999529, 0.025237, 0.017447>, <0.999529, 0.025237, 0.017447>, <0.999529, 0.025237, 0.017447>, <0.910550, 0.413093, 0.015894>, <0.910550, 0.413093, 0.015894>, <0.910550, 0.413093, 0.015894>, <0.935905, 0.351874, 0.016336>, <0.935905, 0.351874, 0.016336>, <0.935905, 0.351874, 0.016336>, <0.683185, 0.730148, 0.011925>, 
			<0.683185, 0.730148, 0.011925>, <0.683185, 0.730148, 0.011925>, <0.730037, 0.683289, 0.012743>, <0.730037, 0.683289, 0.012743>, <0.730037, 0.683289, 0.012743>, <0.351808, 0.936052, 0.006141>, <0.351808, 0.936052, 0.006141>, <0.351808, 0.936052, 0.006141>, <0.413022, 0.910692, 0.007209>, <0.413022, 0.910692, 0.007209>, <0.413022, 0.910692, 0.007209>, 
			<-0.033129, 0.999451, -0.000578>, <-0.033129, 0.999451, -0.000578>, <-0.033129, 0.999451, -0.000578>, <0.033129, 0.999451, 0.000578>, <0.033129, 0.999451, 0.000578>, <0.033129, 0.999451, 0.000578>, <-0.413022, 0.910692, -0.007209>, <-0.413022, 0.910692, -0.007209>, <-0.413022, 0.910692, -0.007209>, <-0.351808, 0.936052, -0.006141>, <-0.351808, 0.936052, -0.006141>, 
			<-0.351808, 0.936052, -0.006141>, <-0.730037, 0.683289, -0.012743>, <-0.730037, 0.683289, -0.012743>, <-0.730037, 0.683289, -0.012743>, <-0.683185, 0.730148, -0.011925>, <-0.683185, 0.730148, -0.011925>, <-0.683185, 0.730148, -0.011925>, <-0.935914, 0.351850, -0.016336>, <-0.935914, 0.351850, -0.016336>, <-0.935914, 0.351850, -0.016336>, <-0.910557, 0.413077, -0.015894>, 
			<-0.910557, 0.413077, -0.015894>, <-0.910557, 0.413077, -0.015894>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <-0.994485, 0.103436, -0.017359>, <-0.994485, 0.103436, -0.017359>, <-0.994485, 0.103436, -0.017359>, 
			<-0.996503, 0.081728, -0.017394>, <-0.996503, 0.081728, -0.017394>, <0.998048, 0.059981, 0.017421>, <0.998048, 0.059981, 0.017421>, <0.998048, 0.059981, 0.017421>, <0.996503, 0.081728, 0.017394>, <0.996503, 0.081728, 0.017394>, <0.996503, 0.081728, 0.017394>, <0.996503, 0.081728, 0.017394>, <0.961408, 0.274615, 0.016781>, <0.961408, 0.274615, 0.016781>, 
			<0.961408, 0.274615, 0.016781>, <0.951926, 0.305876, 0.016616>, <0.951926, 0.305876, 0.016616>, <0.951926, 0.305876, 0.016616>, <0.889368, 0.456929, 0.015524>, <0.889368, 0.456929, 0.015524>, <0.889368, 0.456929, 0.015524>, <0.873971, 0.485739, 0.015255>, <0.873971, 0.485739, 0.015255>, <0.873971, 0.485739, 0.015255>, <0.783150, 0.621682, 0.013670>, 
			<0.783150, 0.621682, 0.013670>, <0.783150, 0.621682, 0.013670>, <0.762429, 0.646935, 0.013308>, <0.762429, 0.646935, 0.013308>, <0.762429, 0.646935, 0.013308>, <0.646836, 0.762545, 0.011291>, <0.646836, 0.762545, 0.011291>, <0.646836, 0.762545, 0.011291>, <0.621588, 0.783269, 0.010850>, <0.621588, 0.783269, 0.010850>, <0.621588, 0.783269, 0.010850>, 
			<0.485665, 0.874104, 0.008477>, <0.485665, 0.874104, 0.008477>, <0.485665, 0.874104, 0.008477>, <0.456859, 0.889503, 0.007975>, <0.456859, 0.889503, 0.007975>, <0.456859, 0.889503, 0.007975>, <0.305830, 0.952071, 0.005338>, <0.305830, 0.952071, 0.005338>, <0.305830, 0.952071, 0.005338>, <0.274574, 0.961554, 0.004793>, <0.274574, 0.961554, 0.004793>, 
			<0.274574, 0.961554, 0.004793>, <0.114242, 0.993451, 0.001994>, <0.114242, 0.993451, 0.001994>, <0.114242, 0.993451, 0.001994>, <0.081736, 0.996653, 0.001427>, <0.081736, 0.996653, 0.001427>, <0.081736, 0.996653, 0.001427>, <-0.081736, 0.996653, -0.001427>, <-0.081736, 0.996653, -0.001427>, <-0.081736, 0.996653, -0.001427>, <-0.114242, 0.993451, -0.001994>, 
			<-0.114242, 0.993451, -0.001994>, <-0.114242, 0.993451, -0.001994>, <-0.274574, 0.961554, -0.004793>, <-0.274574, 0.961554, -0.004793>, <-0.274574, 0.961554, -0.004793>, <-0.305830, 0.952071, -0.005338>, <-0.305830, 0.952071, -0.005338>, <-0.305830, 0.952071, -0.005338>, <-0.456859, 0.889503, -0.007975>, <-0.456859, 0.889503, -0.007975>, <-0.456859, 0.889503, -0.007975>, 
			<-0.485665, 0.874104, -0.008477>, <-0.485665, 0.874104, -0.008477>, <-0.485665, 0.874104, -0.008477>, <-0.621588, 0.783269, -0.010850>, <-0.621588, 0.783269, -0.010850>, <-0.621588, 0.783269, -0.010850>, <-0.646836, 0.762545, -0.011291>, <-0.646836, 0.762545, -0.011291>, <-0.646836, 0.762545, -0.011291>, <-0.762429, 0.646935, -0.013308>, <-0.762429, 0.646935, -0.013308>, 
			<-0.762429, 0.646935, -0.013308>, <-0.783150, 0.621682, -0.013670>, <-0.783150, 0.621682, -0.013670>, <-0.783150, 0.621682, -0.013670>, <-0.873971, 0.485739, -0.015255>, <-0.873971, 0.485739, -0.015255>, <-0.873971, 0.485739, -0.015255>, <-0.889368, 0.456929, -0.015524>, <-0.889368, 0.456929, -0.015524>, <-0.889368, 0.456929, -0.015524>, <-0.951926, 0.305876, -0.016616>, 
			<-0.951926, 0.305876, -0.016616>, <-0.951926, 0.305876, -0.016616>, <-0.961408, 0.274615, -0.016781>, <-0.961408, 0.274615, -0.016781>, <-0.961408, 0.274615, -0.016781>, <-0.996503, -0.081728, -0.017394>, <-0.996503, -0.081728, -0.017394>, <-0.996503, -0.081728, -0.017394>, <-0.996503, -0.081728, -0.017394>, <-0.998048, -0.059981, -0.017421>, <-0.998048, -0.059981, -0.017421>, 
			<-0.998048, -0.059981, -0.017421>, <-0.951926, -0.305876, -0.016616>, <-0.951926, -0.305876, -0.016616>, <-0.951926, -0.305876, -0.016616>, <-0.961408, -0.274615, -0.016781>, <-0.961408, -0.274615, -0.016781>, <-0.961408, -0.274615, -0.016781>, <-0.873971, -0.485739, -0.015255>, <-0.873971, -0.485739, -0.015255>, <-0.873971, -0.485739, -0.015255>, <-0.889368, -0.456929, -0.015524>, 
			<-0.889368, -0.456929, -0.015524>, <-0.889368, -0.456929, -0.015524>, <-0.762429, -0.646935, -0.013308>, <-0.762429, -0.646935, -0.013308>, <-0.762429, -0.646935, -0.013308>, <-0.783150, -0.621682, -0.013670>, <-0.783150, -0.621682, -0.013670>, <-0.783150, -0.621682, -0.013670>, <-0.621588, -0.783269, -0.010850>, <-0.621588, -0.783269, -0.010850>, <-0.621588, -0.783269, -0.010850>, 
			<-0.646836, -0.762545, -0.011291>, <-0.646836, -0.762545, -0.011291>, <-0.646836, -0.762545, -0.011291>, <-0.456859, -0.889503, -0.007975>, <-0.456859, -0.889503, -0.007975>, <-0.456859, -0.889503, -0.007975>, <-0.485665, -0.874104, -0.008477>, <-0.485665, -0.874104, -0.008477>, <-0.485665, -0.874104, -0.008477>, <-0.274574, -0.961554, -0.004793>, <-0.274574, -0.961554, -0.004793>, 
			<-0.274574, -0.961554, -0.004793>, <-0.305830, -0.952071, -0.005338>, <-0.305830, -0.952071, -0.005338>, <-0.305830, -0.952071, -0.005338>, <-0.081736, -0.996653, -0.001427>, <-0.081736, -0.996653, -0.001427>, <-0.081736, -0.996653, -0.001427>, <-0.114242, -0.993451, -0.001994>, <-0.114242, -0.993451, -0.001994>, <-0.114242, -0.993451, -0.001994>, <0.114242, -0.993451, 0.001994>, 
			<0.114242, -0.993451, 0.001994>, <0.114242, -0.993451, 0.001994>, <0.081736, -0.996653, 0.001427>, <0.081736, -0.996653, 0.001427>, <0.081736, -0.996653, 0.001427>, <0.305830, -0.952071, 0.005338>, <0.305830, -0.952071, 0.005338>, <0.305830, -0.952071, 0.005338>, <0.274574, -0.961554, 0.004793>, <0.274574, -0.961554, 0.004793>, <0.274574, -0.961554, 0.004793>, 
			<0.485665, -0.874104, 0.008477>, <0.485665, -0.874104, 0.008477>, <0.485665, -0.874104, 0.008477>, <0.456859, -0.889503, 0.007975>, <0.456859, -0.889503, 0.007975>, <0.456859, -0.889503, 0.007975>, <0.646836, -0.762545, 0.011291>, <0.646836, -0.762545, 0.011291>, <0.646836, -0.762545, 0.011291>, <0.621588, -0.783269, 0.010850>, <0.621588, -0.783269, 0.010850>, 
			<0.621588, -0.783269, 0.010850>, <0.783150, -0.621682, 0.013670>, <0.783150, -0.621682, 0.013670>, <0.783150, -0.621682, 0.013670>, <0.762429, -0.646935, 0.013308>, <0.762429, -0.646935, 0.013308>, <0.762429, -0.646935, 0.013308>, <0.889368, -0.456929, 0.015524>, <0.889368, -0.456929, 0.015524>, <0.889368, -0.456929, 0.015524>, <0.873971, -0.485739, 0.015255>, 
			<0.873971, -0.485739, 0.015255>, <0.873971, -0.485739, 0.015255>, <0.961408, -0.274615, 0.016781>, <0.961408, -0.274615, 0.016781>, <0.961408, -0.274615, 0.016781>, <0.951926, -0.305876, 0.016616>, <0.951926, -0.305876, 0.016616>, <0.951926, -0.305876, 0.016616>, <0.998048, -0.059981, 0.017421>, <0.998048, -0.059981, 0.017421>, <0.998048, -0.059981, 0.017421>, 
			<0.996503, -0.081728, 0.017394>, <0.996503, -0.081728, 0.017394>, <0.996503, -0.081728, 0.017394>, <0.996503, -0.081728, 0.017394>, <0.999847, 0.000718, 0.017452>, <0.999847, 0.000718, 0.017452>, <0.999847, 0.000718, 0.017452>, <0.999848, 0.000000, 0.017452>, <0.999848, 0.000000, 0.017452>, <0.999848, 0.000000, 0.017452>, <0.999848, 0.000000, 0.017452>, 
			<-0.999848, -0.000000, -0.017452>, <-0.999848, -0.000000, -0.017452>, <-0.999847, 0.000718, -0.017452>, <-0.999847, 0.000718, -0.017452>, <-0.999847, 0.000718, -0.017452>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <-0.999846, 0.002051, -0.017452>, <-0.999846, 0.002051, -0.017452>, <-0.999846, 0.002051, -0.017452>, <-0.999846, -0.002047, -0.017452>, 
			<-0.999846, -0.002047, -0.017452>, <-0.999846, -0.002047, -0.017452>, <-0.991768, -0.126873, -0.017311>, <-0.991768, -0.126873, -0.017311>, <-0.991768, -0.126873, -0.017311>, <-0.977740, -0.209126, -0.017067>, <-0.977740, -0.209126, -0.017067>, <-0.977740, -0.209126, -0.017067>, <-0.848953, -0.528261, -0.014819>, <-0.848953, -0.528261, -0.014819>, <-0.848953, -0.528261, -0.014819>, 
			<-0.812855, -0.582293, -0.014188>, <-0.812855, -0.582293, -0.014188>, <-0.812855, -0.582293, -0.014188>, <-0.582204, -0.812979, -0.010162>, <-0.582204, -0.812979, -0.010162>, <-0.582204, -0.812979, -0.010162>, <-0.528181, -0.849082, -0.009219>, <-0.528181, -0.849082, -0.009219>, <-0.528181, -0.849082, -0.009219>, <-0.226820, -0.973929, -0.003959>, <-0.226820, -0.973929, -0.003959>, 
			<-0.226820, -0.973929, -0.003959>, <-0.163095, -0.986606, -0.002847>, <-0.163095, -0.986606, -0.002847>, <-0.163095, -0.986606, -0.002847>, <0.163095, -0.986606, 0.002847>, <0.163095, -0.986606, 0.002847>, <0.163095, -0.986606, 0.002847>, <0.226820, -0.973929, 0.003959>, <0.226820, -0.973929, 0.003959>, <0.226820, -0.973929, 0.003959>, <0.528181, -0.849082, 0.009219>, 
			<0.528181, -0.849082, 0.009219>, <0.528181, -0.849082, 0.009219>, <0.582204, -0.812979, 0.010162>, <0.582204, -0.812979, 0.010162>, <0.582204, -0.812979, 0.010162>, <0.812855, -0.582293, 0.014188>, <0.812855, -0.582293, 0.014188>, <0.812855, -0.582293, 0.014188>, <0.848953, -0.528261, 0.014819>, <0.848953, -0.528261, 0.014819>, <0.848953, -0.528261, 0.014819>, 
			<0.977740, -0.209127, 0.017067>, <0.977740, -0.209127, 0.017067>, <0.977740, -0.209127, 0.017067>, <0.991768, -0.126876, 0.017311>, <0.991768, -0.126876, 0.017311>, <0.991768, -0.126876, 0.017311>, <0.999846, -0.002051, 0.017452>, <0.999846, -0.002051, 0.017452>, <0.999846, -0.002051, 0.017452>, <0.999846, 0.002047, 0.017452>, <0.999846, 0.002047, 0.017452>, 
			<0.999846, 0.002047, 0.017452>, <0.977737, 0.209138, 0.017066>, <0.977737, 0.209138, 0.017066>, <0.977737, 0.209138, 0.017066>, <0.991767, 0.126882, 0.017311>, <0.991767, 0.126882, 0.017311>, <0.991767, 0.126882, 0.017311>, <0.812854, 0.582294, 0.014188>, <0.812854, 0.582294, 0.014188>, <0.812854, 0.582294, 0.014188>, <0.848951, 0.528264, 0.014818>, 
			<0.848951, 0.528264, 0.014818>, <0.848951, 0.528264, 0.014818>, <0.528181, 0.849082, 0.009219>, <0.528181, 0.849082, 0.009219>, <0.528181, 0.849082, 0.009219>, <0.582204, 0.812979, 0.010162>, <0.582204, 0.812979, 0.010162>, <0.582204, 0.812979, 0.010162>, <0.163095, 0.986606, 0.002847>, <0.163095, 0.986606, 0.002847>, <0.163095, 0.986606, 0.002847>, 
			<0.226820, 0.973929, 0.003959>, <0.226820, 0.973929, 0.003959>, <0.226820, 0.973929, 0.003959>, <-0.226820, 0.973929, -0.003959>, <-0.226820, 0.973929, -0.003959>, <-0.226820, 0.973929, -0.003959>, <-0.163095, 0.986606, -0.002847>, <-0.163095, 0.986606, -0.002847>, <-0.163095, 0.986606, -0.002847>, <-0.582204, 0.812979, -0.010162>, <-0.582204, 0.812979, -0.010162>, 
			<-0.582204, 0.812979, -0.010162>, <-0.528181, 0.849082, -0.009219>, <-0.528181, 0.849082, -0.009219>, <-0.528181, 0.849082, -0.009219>, <-0.848954, 0.528258, -0.014819>, <-0.848954, 0.528258, -0.014819>, <-0.848954, 0.528258, -0.014819>, <-0.812856, 0.582291, -0.014188>, <-0.812856, 0.582291, -0.014188>, <-0.812856, 0.582291, -0.014188>, <-0.991769, 0.126867, -0.017311>, 
			<-0.991769, 0.126867, -0.017311>, <-0.991769, 0.126867, -0.017311>, <-0.977742, 0.209115, -0.017067>, <-0.977742, 0.209115, -0.017067>, <-0.977742, 0.209115, -0.017067>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.998048, 0.059981, -0.017421>, <-0.998048, 0.059981, -0.017421>, <-0.998048, 0.059981, -0.017421>, <-0.996503, 0.081728, -0.017394>, <-0.996503, 0.081728, -0.017394>, 
			<-0.996503, 0.081728, -0.017394>, <-0.996503, 0.081728, -0.017394>, <0.996503, 0.081728, 0.017394>, <0.996503, 0.081728, 0.017394>, <0.996503, 0.081728, 0.017394>, <0.996503, 0.081728, 0.017394>, <0.996503, 0.081728, 0.017394>, <0.996503, 0.081728, 0.017394>, <0.951926, 0.305876, 0.016616>, <0.951926, 0.305876, 0.016616>, <0.951926, 0.305876, 0.016616>, 
			<0.961408, 0.274615, 0.016781>, <0.961408, 0.274615, 0.016781>, <0.961408, 0.274615, 0.016781>, <0.873971, 0.485739, 0.015255>, <0.873971, 0.485739, 0.015255>, <0.873971, 0.485739, 0.015255>, <0.889368, 0.456929, 0.015524>, <0.889368, 0.456929, 0.015524>, <0.889368, 0.456929, 0.015524>, <0.762429, 0.646935, 0.013308>, <0.762429, 0.646935, 0.013308>, 
			<0.762429, 0.646935, 0.013308>, <0.783150, 0.621682, 0.013670>, <0.783150, 0.621682, 0.013670>, <0.783150, 0.621682, 0.013670>, <0.621588, 0.783269, 0.010850>, <0.621588, 0.783269, 0.010850>, <0.621588, 0.783269, 0.010850>, <0.646836, 0.762545, 0.011291>, <0.646836, 0.762545, 0.011291>, <0.646836, 0.762545, 0.011291>, <0.456859, 0.889503, 0.007975>, 
			<0.456859, 0.889503, 0.007975>, <0.456859, 0.889503, 0.007975>, <0.485665, 0.874104, 0.008477>, <0.485665, 0.874104, 0.008477>, <0.485665, 0.874104, 0.008477>, <0.274574, 0.961554, 0.004793>, <0.274574, 0.961554, 0.004793>, <0.274574, 0.961554, 0.004793>, <0.305830, 0.952071, 0.005338>, <0.305830, 0.952071, 0.005338>, <0.305830, 0.952071, 0.005338>, 
			<0.081736, 0.996653, 0.001427>, <0.081736, 0.996653, 0.001427>, <0.081736, 0.996653, 0.001427>, <0.114242, 0.993451, 0.001994>, <0.114242, 0.993451, 0.001994>, <0.114242, 0.993451, 0.001994>, <-0.114242, 0.993451, -0.001994>, <-0.114242, 0.993451, -0.001994>, <-0.114242, 0.993451, -0.001994>, <-0.081736, 0.996653, -0.001427>, <-0.081736, 0.996653, -0.001427>, 
			<-0.081736, 0.996653, -0.001427>, <-0.305830, 0.952071, -0.005338>, <-0.305830, 0.952071, -0.005338>, <-0.305830, 0.952071, -0.005338>, <-0.274574, 0.961554, -0.004793>, <-0.274574, 0.961554, -0.004793>, <-0.274574, 0.961554, -0.004793>, <-0.485665, 0.874104, -0.008477>, <-0.485665, 0.874104, -0.008477>, <-0.485665, 0.874104, -0.008477>, <-0.456859, 0.889503, -0.007975>, 
			<-0.456859, 0.889503, -0.007975>, <-0.456859, 0.889503, -0.007975>, <-0.646836, 0.762545, -0.011291>, <-0.646836, 0.762545, -0.011291>, <-0.646836, 0.762545, -0.011291>, <-0.621588, 0.783269, -0.010850>, <-0.621588, 0.783269, -0.010850>, <-0.621588, 0.783269, -0.010850>, <-0.783150, 0.621682, -0.013670>, <-0.783150, 0.621682, -0.013670>, <-0.783150, 0.621682, -0.013670>, 
			<-0.762429, 0.646935, -0.013308>, <-0.762429, 0.646935, -0.013308>, <-0.762429, 0.646935, -0.013308>, <-0.889368, 0.456929, -0.015524>, <-0.889368, 0.456929, -0.015524>, <-0.889368, 0.456929, -0.015524>, <-0.873971, 0.485739, -0.015255>, <-0.873971, 0.485739, -0.015255>, <-0.873971, 0.485739, -0.015255>, <-0.961408, 0.274615, -0.016781>, <-0.961408, 0.274615, -0.016781>, 
			<-0.961408, 0.274615, -0.016781>, <-0.951926, 0.305876, -0.016616>, <-0.951926, 0.305876, -0.016616>, <-0.951926, 0.305876, -0.016616>, <-0.998048, -0.059981, -0.017421>, <-0.998048, -0.059981, -0.017421>, <-0.998048, -0.059981, -0.017421>, <-0.994485, -0.103436, -0.017359>, <-0.994485, -0.103436, -0.017359>, <-0.994485, -0.103436, -0.017359>, <-0.961408, -0.274615, -0.016781>, 
			<-0.961408, -0.274615, -0.016781>, <-0.961408, -0.274615, -0.016781>, <-0.951926, -0.305876, -0.016616>, <-0.951926, -0.305876, -0.016616>, <-0.951926, -0.305876, -0.016616>, <-0.889368, -0.456929, -0.015524>, <-0.889368, -0.456929, -0.015524>, <-0.889368, -0.456929, -0.015524>, <-0.873971, -0.485739, -0.015255>, <-0.873971, -0.485739, -0.015255>, <-0.873971, -0.485739, -0.015255>, 
			<-0.783150, -0.621682, -0.013670>, <-0.783150, -0.621682, -0.013670>, <-0.783150, -0.621682, -0.013670>, <-0.762429, -0.646935, -0.013308>, <-0.762429, -0.646935, -0.013308>, <-0.762429, -0.646935, -0.013308>, <-0.646836, -0.762545, -0.011291>, <-0.646836, -0.762545, -0.011291>, <-0.646836, -0.762545, -0.011291>, <-0.621588, -0.783269, -0.010850>, <-0.621588, -0.783269, -0.010850>, 
			<-0.621588, -0.783269, -0.010850>, <-0.485665, -0.874104, -0.008477>, <-0.485665, -0.874104, -0.008477>, <-0.485665, -0.874104, -0.008477>, <-0.456859, -0.889503, -0.007975>, <-0.456859, -0.889503, -0.007975>, <-0.456859, -0.889503, -0.007975>, <-0.305830, -0.952071, -0.005338>, <-0.305830, -0.952071, -0.005338>, <-0.305830, -0.952071, -0.005338>, <-0.274574, -0.961554, -0.004793>, 
			<-0.274574, -0.961554, -0.004793>, <-0.274574, -0.961554, -0.004793>, <-0.114242, -0.993451, -0.001994>, <-0.114242, -0.993451, -0.001994>, <-0.114242, -0.993451, -0.001994>, <-0.081736, -0.996653, -0.001427>, <-0.081736, -0.996653, -0.001427>, <-0.081736, -0.996653, -0.001427>, <0.081736, -0.996653, 0.001427>, <0.081736, -0.996653, 0.001427>, <0.081736, -0.996653, 0.001427>, 
			<0.114242, -0.993451, 0.001994>, <0.114242, -0.993451, 0.001994>, <0.114242, -0.993451, 0.001994>, <0.274574, -0.961554, 0.004793>, <0.274574, -0.961554, 0.004793>, <0.274574, -0.961554, 0.004793>, <0.305830, -0.952071, 0.005338>, <0.305830, -0.952071, 0.005338>, <0.305830, -0.952071, 0.005338>, <0.456859, -0.889503, 0.007975>, <0.456859, -0.889503, 0.007975>, 
			<0.456859, -0.889503, 0.007975>, <0.485665, -0.874104, 0.008477>, <0.485665, -0.874104, 0.008477>, <0.485665, -0.874104, 0.008477>, <0.621588, -0.783269, 0.010850>, <0.621588, -0.783269, 0.010850>, <0.621588, -0.783269, 0.010850>, <0.646836, -0.762545, 0.011291>, <0.646836, -0.762545, 0.011291>, <0.646836, -0.762545, 0.011291>, <0.762429, -0.646935, 0.013308>, 
			<0.762429, -0.646935, 0.013308>, <0.762429, -0.646935, 0.013308>, <0.783150, -0.621682, 0.013670>, <0.783150, -0.621682, 0.013670>, <0.783150, -0.621682, 0.013670>, <0.873971, -0.485739, 0.015255>, <0.873971, -0.485739, 0.015255>, <0.873971, -0.485739, 0.015255>, <0.889368, -0.456929, 0.015524>, <0.889368, -0.456929, 0.015524>, <0.889368, -0.456929, 0.015524>, 
			<0.951926, -0.305876, 0.016616>, <0.951926, -0.305876, 0.016616>, <0.951926, -0.305876, 0.016616>, <0.961408, -0.274615, 0.016781>, <0.961408, -0.274615, 0.016781>, <0.961408, -0.274615, 0.016781>, <0.996503, -0.081728, 0.017394>, <0.996503, -0.081728, 0.017394>, <0.996503, -0.081728, 0.017394>, <0.996503, -0.081728, 0.017394>, <0.998048, -0.059981, 0.017421>, 
			<0.998048, -0.059981, 0.017421>, <0.998048, -0.059981, 0.017421>, <0.999848, 0.000000, 0.017452>, <0.999848, 0.000000, 0.017452>, <0.999848, 0.000000, 0.017452>, <0.999848, 0.000000, 0.017452>, <0.999847, 0.000718, 0.017452>, <0.999847, 0.000718, 0.017452>, <0.999847, 0.000718, 0.017452>, <-0.999847, 0.000718, -0.017452>, <-0.999847, 0.000718, -0.017452>, 
			<-0.999847, 0.000718, -0.017452>, <-0.999848, 0.000000, -0.017452>, <-0.999848, 0.000000, -0.017452>, <-0.999848, 0.000000, -0.017452>, <-0.999848, 0.000000, -0.017452>, <0.812855, -0.582293, 0.014188>, <0.812855, -0.582293, 0.014188>, <0.812855, -0.582293, 0.014188>, <0.848953, -0.528261, 0.014819>, <0.848953, -0.528261, 0.014819>, <0.848953, -0.528261, 0.014819>, 
			<-0.991769, 0.126867, -0.017311>, <-0.991769, 0.126867, -0.017311>, <-0.991769, 0.126867, -0.017311>, <-0.977742, 0.209115, -0.017067>, <-0.977742, 0.209115, -0.017067>, <-0.977742, 0.209115, -0.017067>, <-0.226820, -0.973929, -0.003959>, <-0.226820, -0.973929, -0.003959>, <-0.226820, -0.973929, -0.003959>, <-0.163095, -0.986606, -0.002847>, <-0.163095, -0.986606, -0.002847>, 
			<-0.163095, -0.986606, -0.002847>, <0.528181, -0.849082, 0.009219>, <0.528181, -0.849082, 0.009219>, <0.528181, -0.849082, 0.009219>, <0.582204, -0.812979, 0.010162>, <0.582204, -0.812979, 0.010162>, <0.582204, -0.812979, 0.010162>, <-0.226820, 0.973929, -0.003959>, <-0.226820, 0.973929, -0.003959>, <-0.226820, 0.973929, -0.003959>, <-0.163095, 0.986606, -0.002847>, 
			<-0.163095, 0.986606, -0.002847>, <-0.163095, 0.986606, -0.002847>, <-0.848954, 0.528258, -0.014819>, <-0.848954, 0.528258, -0.014819>, <-0.848954, 0.528258, -0.014819>, <-0.812856, 0.582291, -0.014188>, <-0.812856, 0.582291, -0.014188>, <-0.812856, 0.582291, -0.014188>, <0.999846, -0.002051, 0.017452>, <0.999846, -0.002051, 0.017452>, <0.999846, -0.002051, 0.017452>, 
			<0.999846, 0.002047, 0.017452>, <0.999846, 0.002047, 0.017452>, <0.999846, 0.002047, 0.017452>, <0.528181, 0.849082, 0.009219>, <0.528181, 0.849082, 0.009219>, <0.528181, 0.849082, 0.009219>, <0.582204, 0.812979, 0.010162>, <0.582204, 0.812979, 0.010162>, <0.582204, 0.812979, 0.010162>, <-0.582204, 0.812979, -0.010162>, <-0.582204, 0.812979, -0.010162>, 
			<-0.582204, 0.812979, -0.010162>, <-0.528181, 0.849082, -0.009219>, <-0.528181, 0.849082, -0.009219>, <-0.528181, 0.849082, -0.009219>, <0.812854, 0.582294, 0.014188>, <0.812854, 0.582294, 0.014188>, <0.812854, 0.582294, 0.014188>, <0.848951, 0.528264, 0.014818>, <0.848951, 0.528264, 0.014818>, <0.848951, 0.528264, 0.014818>, <-0.848953, -0.528261, -0.014819>, 
			<-0.848953, -0.528261, -0.014819>, <-0.848953, -0.528261, -0.014819>, <-0.812855, -0.582293, -0.014188>, <-0.812855, -0.582293, -0.014188>, <-0.812855, -0.582293, -0.014188>, <-0.999846, 0.002051, -0.017452>, <-0.999846, 0.002051, -0.017452>, <-0.999846, 0.002051, -0.017452>, <-0.999846, -0.002047, -0.017452>, <-0.999846, -0.002047, -0.017452>, <-0.999846, -0.002047, -0.017452>, 
			<-0.582204, -0.812979, -0.010162>, <-0.582204, -0.812979, -0.010162>, <-0.582204, -0.812979, -0.010162>, <-0.528181, -0.849082, -0.009219>, <-0.528181, -0.849082, -0.009219>, <-0.528181, -0.849082, -0.009219>, <0.977740, -0.209127, 0.017067>, <0.977740, -0.209127, 0.017067>, <0.977740, -0.209127, 0.017067>, <0.991768, -0.126876, 0.017311>, <0.991768, -0.126876, 0.017311>, 
			<0.991768, -0.126876, 0.017311>, <0.163095, -0.986606, 0.002847>, <0.163095, -0.986606, 0.002847>, <0.163095, -0.986606, 0.002847>, <0.226820, -0.973929, 0.003959>, <0.226820, -0.973929, 0.003959>, <0.226820, -0.973929, 0.003959>, <0.977737, 0.209138, 0.017066>, <0.977737, 0.209138, 0.017066>, <0.977737, 0.209138, 0.017066>, <0.991767, 0.126882, 0.017311>, 
			<0.991767, 0.126882, 0.017311>, <0.991767, 0.126882, 0.017311>, <0.163095, 0.986606, 0.002847>, <0.163095, 0.986606, 0.002847>, <0.163095, 0.986606, 0.002847>, <0.226820, 0.973929, 0.003959>, <0.226820, 0.973929, 0.003959>, <0.226820, 0.973929, 0.003959>, <-0.991768, -0.126873, -0.017311>, <-0.991768, -0.126873, -0.017311>, <-0.991768, -0.126873, -0.017311>, 
			<-0.977740, -0.209126, -0.017067>, <-0.977740, -0.209126, -0.017067>, <-0.977740, -0.209126, -0.017067>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <0.017452, 0.000000, -0.999848>, <-0.996503, 0.081728, -0.017394>, <-0.996503, 0.081728, -0.017394>, <-0.996503, 0.081728, -0.017394>, 
			<-0.996503, 0.081728, -0.017394>, <-0.996503, 0.081728, -0.017394>, <-0.996503, 0.081728, -0.017394>, <0.998048, 0.059981, 0.017421>, <0.998048, 0.059981, 0.017421>, <0.998048, 0.059981, 0.017421>, <0.996503, 0.081728, 0.017394>, <0.996503, 0.081728, 0.017394>, <0.996503, 0.081728, 0.017394>, <0.996503, 0.081728, 0.017394>, <0.961408, 0.274615, 0.016781>, 
			<0.961408, 0.274615, 0.016781>, <0.961408, 0.274615, 0.016781>, <0.951926, 0.305876, 0.016616>, <0.951926, 0.305876, 0.016616>, <0.951926, 0.305876, 0.016616>, <0.889368, 0.456929, 0.015524>, <0.889368, 0.456929, 0.015524>, <0.889368, 0.456929, 0.015524>, <0.873971, 0.485739, 0.015255>, <0.873971, 0.485739, 0.015255>, <0.873971, 0.485739, 0.015255>, 
			<0.783150, 0.621682, 0.013670>, <0.783150, 0.621682, 0.013670>, <0.783150, 0.621682, 0.013670>, <0.762429, 0.646935, 0.013308>, <0.762429, 0.646935, 0.013308>, <0.762429, 0.646935, 0.013308>, <0.646836, 0.762545, 0.011291>, <0.646836, 0.762545, 0.011291>, <0.646836, 0.762545, 0.011291>, <0.621588, 0.783269, 0.010850>, <0.621588, 0.783269, 0.010850>, 
			<0.621588, 0.783269, 0.010850>, <0.485665, 0.874104, 0.008477>, <0.485665, 0.874104, 0.008477>, <0.485665, 0.874104, 0.008477>, <0.456859, 0.889503, 0.007975>, <0.456859, 0.889503, 0.007975>, <0.456859, 0.889503, 0.007975>, <0.305830, 0.952071, 0.005338>, <0.305830, 0.952071, 0.005338>, <0.305830, 0.952071, 0.005338>, <0.274574, 0.961554, 0.004793>, 
			<0.274574, 0.961554, 0.004793>, <0.274574, 0.961554, 0.004793>, <0.114242, 0.993451, 0.001994>, <0.114242, 0.993451, 0.001994>, <0.114242, 0.993451, 0.001994>, <0.081736, 0.996653, 0.001427>, <0.081736, 0.996653, 0.001427>, <0.081736, 0.996653, 0.001427>, <-0.081736, 0.996653, -0.001427>, <-0.081736, 0.996653, -0.001427>, <-0.081736, 0.996653, -0.001427>, 
			<-0.114242, 0.993451, -0.001994>, <-0.114242, 0.993451, -0.001994>, <-0.114242, 0.993451, -0.001994>, <-0.274574, 0.961554, -0.004793>, <-0.274574, 0.961554, -0.004793>, <-0.274574, 0.961554, -0.004793>, <-0.305830, 0.952071, -0.005338>, <-0.305830, 0.952071, -0.005338>, <-0.305830, 0.952071, -0.005338>, <-0.456859, 0.889503, -0.007975>, <-0.456859, 0.889503, -0.007975>, 
			<-0.456859, 0.889503, -0.007975>, <-0.485665, 0.874104, -0.008477>, <-0.485665, 0.874104, -0.008477>, <-0.485665, 0.874104, -0.008477>, <-0.621588, 0.783269, -0.010850>, <-0.621588, 0.783269, -0.010850>, <-0.621588, 0.783269, -0.010850>, <-0.646836, 0.762545, -0.011291>, <-0.646836, 0.762545, -0.011291>, <-0.646836, 0.762545, -0.011291>, <-0.762429, 0.646935, -0.013308>, 
			<-0.762429, 0.646935, -0.013308>, <-0.762429, 0.646935, -0.013308>, <-0.783150, 0.621682, -0.013670>, <-0.783150, 0.621682, -0.013670>, <-0.783150, 0.621682, -0.013670>, <-0.873971, 0.485739, -0.015255>, <-0.873971, 0.485739, -0.015255>, <-0.873971, 0.485739, -0.015255>, <-0.889368, 0.456929, -0.015524>, <-0.889368, 0.456929, -0.015524>, <-0.889368, 0.456929, -0.015524>, 
			<-0.951926, 0.305876, -0.016616>, <-0.951926, 0.305876, -0.016616>, <-0.951926, 0.305876, -0.016616>, <-0.961408, 0.274615, -0.016781>, <-0.961408, 0.274615, -0.016781>, <-0.961408, 0.274615, -0.016781>, <-0.994485, -0.103436, -0.017359>, <-0.994485, -0.103436, -0.017359>, <-0.994485, -0.103436, -0.017359>, <-0.998048, -0.059981, -0.017421>, <-0.998048, -0.059981, -0.017421>, 
			<-0.998048, -0.059981, -0.017421>, <-0.951926, -0.305876, -0.016616>, <-0.951926, -0.305876, -0.016616>, <-0.951926, -0.305876, -0.016616>, <-0.961408, -0.274615, -0.016781>, <-0.961408, -0.274615, -0.016781>, <-0.961408, -0.274615, -0.016781>, <-0.873971, -0.485739, -0.015255>, <-0.873971, -0.485739, -0.015255>, <-0.873971, -0.485739, -0.015255>, <-0.889368, -0.456929, -0.015524>, 
			<-0.889368, -0.456929, -0.015524>, <-0.889368, -0.456929, -0.015524>, <-0.762429, -0.646935, -0.013308>, <-0.762429, -0.646935, -0.013308>, <-0.762429, -0.646935, -0.013308>, <-0.783150, -0.621682, -0.013670>, <-0.783150, -0.621682, -0.013670>, <-0.783150, -0.621682, -0.013670>, <-0.621588, -0.783269, -0.010850>, <-0.621588, -0.783269, -0.010850>, <-0.621588, -0.783269, -0.010850>, 
			<-0.646836, -0.762545, -0.011291>, <-0.646836, -0.762545, -0.011291>, <-0.646836, -0.762545, -0.011291>, <-0.456859, -0.889503, -0.007975>, <-0.456859, -0.889503, -0.007975>, <-0.456859, -0.889503, -0.007975>, <-0.485665, -0.874104, -0.008477>, <-0.485665, -0.874104, -0.008477>, <-0.485665, -0.874104, -0.008477>, <-0.274574, -0.961554, -0.004793>, <-0.274574, -0.961554, -0.004793>, 
			<-0.274574, -0.961554, -0.004793>, <-0.305830, -0.952071, -0.005338>, <-0.305830, -0.952071, -0.005338>, <-0.305830, -0.952071, -0.005338>, <-0.081736, -0.996653, -0.001427>, <-0.081736, -0.996653, -0.001427>, <-0.081736, -0.996653, -0.001427>, <-0.114242, -0.993451, -0.001994>, <-0.114242, -0.993451, -0.001994>, <-0.114242, -0.993451, -0.001994>, <0.114242, -0.993451, 0.001994>, 
			<0.114242, -0.993451, 0.001994>, <0.114242, -0.993451, 0.001994>, <0.081736, -0.996653, 0.001427>, <0.081736, -0.996653, 0.001427>, <0.081736, -0.996653, 0.001427>, <0.305830, -0.952071, 0.005338>, <0.305830, -0.952071, 0.005338>, <0.305830, -0.952071, 0.005338>, <0.274574, -0.961554, 0.004793>, <0.274574, -0.961554, 0.004793>, <0.274574, -0.961554, 0.004793>, 
			<0.485665, -0.874104, 0.008477>, <0.485665, -0.874104, 0.008477>, <0.485665, -0.874104, 0.008477>, <0.456859, -0.889503, 0.007975>, <0.456859, -0.889503, 0.007975>, <0.456859, -0.889503, 0.007975>, <0.646836, -0.762545, 0.011291>, <0.646836, -0.762545, 0.011291>, <0.646836, -0.762545, 0.011291>, <0.621588, -0.783269, 0.010850>, <0.621588, -0.783269, 0.010850>, 
			<0.621588, -0.783269, 0.010850>, <0.783150, -0.621682, 0.013670>, <0.783150, -0.621682, 0.013670>, <0.783150, -0.621682, 0.013670>, <0.762429, -0.646935, 0.013308>, <0.762429, -0.646935, 0.013308>, <0.762429, -0.646935, 0.013308>, <0.889368, -0.456929, 0.015524>, <0.889368, -0.456929, 0.015524>, <0.889368, -0.456929, 0.015524>, <0.873971, -0.485739, 0.015255>, 
			<0.873971, -0.485739, 0.015255>, <0.873971, -0.485739, 0.015255>, <0.961408, -0.274615, 0.016781>, <0.961408, -0.274615, 0.016781>, <0.961408, -0.274615, 0.016781>, <0.951926, -0.305876, 0.016616>, <0.951926, -0.305876, 0.016616>, <0.951926, -0.305876, 0.016616>, <0.998048, -0.059981, 0.017421>, <0.998048, -0.059981, 0.017421>, <0.998048, -0.059981, 0.017421>, 
			<0.996503, -0.081728, 0.017394>, <0.996503, -0.081728, 0.017394>, <0.996503, -0.081728, 0.017394>, <0.996503, -0.081728, 0.017394>, <0.999847, 0.000718, 0.017452>, <0.999847, 0.000718, 0.017452>, <0.999847, 0.000718, 0.017452>, <0.999847, 0.000718, 0.017452>, <0.999847, 0.000718, 0.017452>, <0.999847, 0.000718, 0.017452>, <-0.999848, 0.000000, -0.017452>, 
			<-0.999848, 0.000000, -0.017452>, <-0.999848, 0.000000, -0.017452>, <-0.999848, 0.000000, -0.017452>, <-0.999847, 0.000718, -0.017452>, <-0.999847, 0.000718, -0.017452>, <-0.999847, 0.000718, -0.017452>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, 
			<0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <0.017452, -0.000000, -0.999848>, <-0.999848, 0.000002, -0.017452>, <-0.999848, 0.000002, -0.017452>, <-0.999846, -0.002047, -0.017452>, 
			<-0.999846, -0.002047, -0.017452>, <-0.999846, -0.002047, -0.017452>, <-0.991768, -0.126873, -0.017311>, <-0.991768, -0.126873, -0.017311>, <-0.991768, -0.126873, -0.017311>, <-0.977740, -0.209126, -0.017067>, <-0.977740, -0.209126, -0.017067>, <-0.977740, -0.209126, -0.017067>, <-0.848953, -0.528261, -0.014819>, <-0.848953, -0.528261, -0.014819>, <-0.848953, -0.528261, -0.014819>, 
			<-0.812855, -0.582293, -0.014188>, <-0.812855, -0.582293, -0.014188>, <-0.812855, -0.582293, -0.014188>, <-0.582204, -0.812979, -0.010162>, <-0.582204, -0.812979, -0.010162>, <-0.582204, -0.812979, -0.010162>, <-0.528181, -0.849082, -0.009219>, <-0.528181, -0.849082, -0.009219>, <-0.528181, -0.849082, -0.009219>, <-0.226820, -0.973929, -0.003959>, <-0.226820, -0.973929, -0.003959>, 
			<-0.226820, -0.973929, -0.003959>, <-0.163095, -0.986606, -0.002847>, <-0.163095, -0.986606, -0.002847>, <-0.163095, -0.986606, -0.002847>, <0.163095, -0.986606, 0.002847>, <0.163095, -0.986606, 0.002847>, <0.163095, -0.986606, 0.002847>, <0.226820, -0.973929, 0.003959>, <0.226820, -0.973929, 0.003959>, <0.226820, -0.973929, 0.003959>, <0.528181, -0.849082, 0.009219>, 
			<0.528181, -0.849082, 0.009219>, <0.528181, -0.849082, 0.009219>, <0.582204, -0.812979, 0.010162>, <0.582204, -0.812979, 0.010162>, <0.582204, -0.812979, 0.010162>, <0.812855, -0.582293, 0.014188>, <0.812855, -0.582293, 0.014188>, <0.812855, -0.582293, 0.014188>, <0.848953, -0.528261, 0.014819>, <0.848953, -0.528261, 0.014819>, <0.848953, -0.528261, 0.014819>, 
			<0.977740, -0.209127, 0.017067>, <0.977740, -0.209127, 0.017067>, <0.977740, -0.209127, 0.017067>, <0.991768, -0.126876, 0.017311>, <0.991768, -0.126876, 0.017311>, <0.991768, -0.126876, 0.017311>, <0.999846, -0.002051, 0.017452>, <0.999846, -0.002051, 0.017452>, <0.999846, -0.002051, 0.017452>, <0.999846, 0.002047, 0.017452>, <0.999846, 0.002047, 0.017452>, 
			<0.999846, 0.002047, 0.017452>, <0.977737, 0.209138, 0.017066>, <0.977737, 0.209138, 0.017066>, <0.977737, 0.209138, 0.017066>, <0.991767, 0.126882, 0.017311>, <0.991767, 0.126882, 0.017311>, <0.991767, 0.126882, 0.017311>, <0.812854, 0.582294, 0.014188>, <0.812854, 0.582294, 0.014188>, <0.812854, 0.582294, 0.014188>, <0.848951, 0.528264, 0.014818>, 
			<0.848951, 0.528264, 0.014818>, <0.848951, 0.528264, 0.014818>, <0.528181, 0.849082, 0.009219>, <0.528181, 0.849082, 0.009219>, <0.528181, 0.849082, 0.009219>, <0.582204, 0.812979, 0.010162>, <0.582204, 0.812979, 0.010162>, <0.582204, 0.812979, 0.010162>, <0.163095, 0.986606, 0.002847>, <0.163095, 0.986606, 0.002847>, <0.163095, 0.986606, 0.002847>, 
			<0.226820, 0.973929, 0.003959>, <0.226820, 0.973929, 0.003959>, <0.226820, 0.973929, 0.003959>, <-0.226820, 0.973929, -0.003959>, <-0.226820, 0.973929, -0.003959>, <-0.226820, 0.973929, -0.003959>, <-0.163095, 0.986606, -0.002847>, <-0.163095, 0.986606, -0.002847>, <-0.163095, 0.986606, -0.002847>, <-0.582204, 0.812979, -0.010162>, <-0.582204, 0.812979, -0.010162>, 
			<-0.582204, 0.812979, -0.010162>, <-0.528181, 0.849082, -0.009219>, <-0.528181, 0.849082, -0.009219>, <-0.528181, 0.849082, -0.009219>, <-0.848954, 0.528258, -0.014819>, <-0.848954, 0.528258, -0.014819>, <-0.848954, 0.528258, -0.014819>, <-0.812856, 0.582291, -0.014188>, <-0.812856, 0.582291, -0.014188>, <-0.812856, 0.582291, -0.014188>, <-0.991769, 0.126867, -0.017311>, 
			<-0.991769, 0.126867, -0.017311>, <-0.991769, 0.126867, -0.017311>, <-0.977742, 0.209115, -0.017067>, <-0.977742, 0.209115, -0.017067>, <-0.977742, 0.209115, -0.017067>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.996503, 0.081728, -0.017394>, <-0.996503, 0.081728, -0.017394>, <-0.994485, 0.103436, -0.017359>, <-0.994485, 0.103436, -0.017359>, <-0.994485, 0.103436, -0.017359>, 
			<0.996503, 0.081728, 0.017394>, <0.996503, 0.081728, 0.017394>, <0.996503, 0.081728, 0.017394>, <0.996503, 0.081728, 0.017394>, <0.996503, 0.081728, 0.017394>, <0.996503, 0.081728, 0.017394>, <0.951926, 0.305876, 0.016616>, <0.951926, 0.305876, 0.016616>, <0.951926, 0.305876, 0.016616>, <0.961408, 0.274615, 0.016781>, <0.961408, 0.274615, 0.016781>, 
			<0.961408, 0.274615, 0.016781>, <0.873971, 0.485739, 0.015255>, <0.873971, 0.485739, 0.015255>, <0.873971, 0.485739, 0.015255>, <0.889368, 0.456929, 0.015524>, <0.889368, 0.456929, 0.015524>, <0.889368, 0.456929, 0.015524>, <0.762429, 0.646935, 0.013308>, <0.762429, 0.646935, 0.013308>, <0.762429, 0.646935, 0.013308>, <0.783150, 0.621682, 0.013670>, 
			<0.783150, 0.621682, 0.013670>, <0.783150, 0.621682, 0.013670>, <0.621588, 0.783269, 0.010850>, <0.621588, 0.783269, 0.010850>, <0.621588, 0.783269, 0.010850>, <0.646836, 0.762545, 0.011291>, <0.646836, 0.762545, 0.011291>, <0.646836, 0.762545, 0.011291>, <0.456859, 0.889503, 0.007975>, <0.456859, 0.889503, 0.007975>, <0.456859, 0.889503, 0.007975>, 
			<0.485665, 0.874104, 0.008477>, <0.485665, 0.874104, 0.008477>, <0.485665, 0.874104, 0.008477>, <0.274574, 0.961554, 0.004793>, <0.274574, 0.961554, 0.004793>, <0.274574, 0.961554, 0.004793>, <0.305830, 0.952071, 0.005338>, <0.305830, 0.952071, 0.005338>, <0.305830, 0.952071, 0.005338>, <0.081736, 0.996653, 0.001427>, <0.081736, 0.996653, 0.001427>, 
			<0.081736, 0.996653, 0.001427>, <0.114242, 0.993451, 0.001994>, <0.114242, 0.993451, 0.001994>, <0.114242, 0.993451, 0.001994>, <-0.114242, 0.993451, -0.001994>, <-0.114242, 0.993451, -0.001994>, <-0.114242, 0.993451, -0.001994>, <-0.081736, 0.996653, -0.001427>, <-0.081736, 0.996653, -0.001427>, <-0.081736, 0.996653, -0.001427>, <-0.305830, 0.952071, -0.005338>, 
			<-0.305830, 0.952071, -0.005338>, <-0.305830, 0.952071, -0.005338>, <-0.274574, 0.961554, -0.004793>, <-0.274574, 0.961554, -0.004793>, <-0.274574, 0.961554, -0.004793>, <-0.485665, 0.874104, -0.008477>, <-0.485665, 0.874104, -0.008477>, <-0.485665, 0.874104, -0.008477>, <-0.456859, 0.889503, -0.007975>, <-0.456859, 0.889503, -0.007975>, <-0.456859, 0.889503, -0.007975>, 
			<-0.646836, 0.762545, -0.011291>, <-0.646836, 0.762545, -0.011291>, <-0.646836, 0.762545, -0.011291>, <-0.621588, 0.783269, -0.010850>, <-0.621588, 0.783269, -0.010850>, <-0.621588, 0.783269, -0.010850>, <-0.783150, 0.621682, -0.013670>, <-0.783150, 0.621682, -0.013670>, <-0.783150, 0.621682, -0.013670>, <-0.762429, 0.646935, -0.013308>, <-0.762429, 0.646935, -0.013308>, 
			<-0.762429, 0.646935, -0.013308>, <-0.889368, 0.456929, -0.015524>, <-0.889368, 0.456929, -0.015524>, <-0.889368, 0.456929, -0.015524>, <-0.873971, 0.485739, -0.015255>, <-0.873971, 0.485739, -0.015255>, <-0.873971, 0.485739, -0.015255>, <-0.961408, 0.274615, -0.016781>, <-0.961408, 0.274615, -0.016781>, <-0.961408, 0.274615, -0.016781>, <-0.951926, 0.305876, -0.016616>, 
			<-0.951926, 0.305876, -0.016616>, <-0.951926, 0.305876, -0.016616>, <-0.998048, -0.059981, -0.017421>, <-0.998048, -0.059981, -0.017421>, <-0.998048, -0.059981, -0.017421>, <-0.996503, -0.081728, -0.017394>, <-0.996503, -0.081728, -0.017394>, <-0.996503, -0.081728, -0.017394>, <-0.996503, -0.081728, -0.017394>, <-0.961408, -0.274615, -0.016781>, <-0.961408, -0.274615, -0.016781>, 
			<-0.961408, -0.274615, -0.016781>, <-0.951926, -0.305876, -0.016616>, <-0.951926, -0.305876, -0.016616>, <-0.951926, -0.305876, -0.016616>, <-0.889368, -0.456929, -0.015524>, <-0.889368, -0.456929, -0.015524>, <-0.889368, -0.456929, -0.015524>, <-0.873971, -0.485739, -0.015255>, <-0.873971, -0.485739, -0.015255>, <-0.873971, -0.485739, -0.015255>, <-0.783150, -0.621682, -0.013670>, 
			<-0.783150, -0.621682, -0.013670>, <-0.783150, -0.621682, -0.013670>, <-0.762429, -0.646935, -0.013308>, <-0.762429, -0.646935, -0.013308>, <-0.762429, -0.646935, -0.013308>, <-0.646836, -0.762545, -0.011291>, <-0.646836, -0.762545, -0.011291>, <-0.646836, -0.762545, -0.011291>, <-0.621588, -0.783269, -0.010850>, <-0.621588, -0.783269, -0.010850>, <-0.621588, -0.783269, -0.010850>, 
			<-0.485665, -0.874104, -0.008477>, <-0.485665, -0.874104, -0.008477>, <-0.485665, -0.874104, -0.008477>, <-0.456859, -0.889503, -0.007975>, <-0.456859, -0.889503, -0.007975>, <-0.456859, -0.889503, -0.007975>, <-0.305830, -0.952071, -0.005338>, <-0.305830, -0.952071, -0.005338>, <-0.305830, -0.952071, -0.005338>, <-0.274574, -0.961554, -0.004793>, <-0.274574, -0.961554, -0.004793>, 
			<-0.274574, -0.961554, -0.004793>, <-0.114242, -0.993451, -0.001994>, <-0.114242, -0.993451, -0.001994>, <-0.114242, -0.993451, -0.001994>, <-0.081736, -0.996653, -0.001427>, <-0.081736, -0.996653, -0.001427>, <-0.081736, -0.996653, -0.001427>, <0.081736, -0.996653, 0.001427>, <0.081736, -0.996653, 0.001427>, <0.081736, -0.996653, 0.001427>, <0.114242, -0.993451, 0.001994>, 
			<0.114242, -0.993451, 0.001994>, <0.114242, -0.993451, 0.001994>, <0.274574, -0.961554, 0.004793>, <0.274574, -0.961554, 0.004793>, <0.274574, -0.961554, 0.004793>, <0.305830, -0.952071, 0.005338>, <0.305830, -0.952071, 0.005338>, <0.305830, -0.952071, 0.005338>, <0.456859, -0.889503, 0.007975>, <0.456859, -0.889503, 0.007975>, <0.456859, -0.889503, 0.007975>, 
			<0.485665, -0.874104, 0.008477>, <0.485665, -0.874104, 0.008477>, <0.485665, -0.874104, 0.008477>, <0.621588, -0.783269, 0.010850>, <0.621588, -0.783269, 0.010850>, <0.621588, -0.783269, 0.010850>, <0.646836, -0.762545, 0.011291>, <0.646836, -0.762545, 0.011291>, <0.646836, -0.762545, 0.011291>, <0.762429, -0.646935, 0.013308>, <0.762429, -0.646935, 0.013308>, 
			<0.762429, -0.646935, 0.013308>, <0.783150, -0.621682, 0.013670>, <0.783150, -0.621682, 0.013670>, <0.783150, -0.621682, 0.013670>, <0.873971, -0.485739, 0.015255>, <0.873971, -0.485739, 0.015255>, <0.873971, -0.485739, 0.015255>, <0.889368, -0.456929, 0.015524>, <0.889368, -0.456929, 0.015524>, <0.889368, -0.456929, 0.015524>, <0.951926, -0.305876, 0.016616>, 
			<0.951926, -0.305876, 0.016616>, <0.951926, -0.305876, 0.016616>, <0.961408, -0.274615, 0.016781>, <0.961408, -0.274615, 0.016781>, <0.961408, -0.274615, 0.016781>, <0.994485, -0.103436, 0.017359>, <0.994485, -0.103436, 0.017359>, <0.994485, -0.103436, 0.017359>, <0.998048, -0.059981, 0.017421>, <0.998048, -0.059981, 0.017421>, <0.998048, -0.059981, 0.017421>, 
			<0.999847, 0.000718, 0.017452>, <0.999847, 0.000718, 0.017452>, <0.999847, 0.000718, 0.017452>, <0.999847, 0.000718, 0.017452>, <0.999847, 0.000718, 0.017452>, <0.999847, 0.000718, 0.017452>, <-0.999847, 0.000718, -0.017452>, <-0.999847, 0.000718, -0.017452>, <-0.999847, 0.000718, -0.017452>, <-0.999847, -0.000718, -0.017452>, <-0.999847, -0.000718, -0.017452>, 
			<-0.999847, -0.000718, -0.017452>, <0.812855, -0.582293, 0.014188>, <0.812855, -0.582293, 0.014188>, <0.812855, -0.582293, 0.014188>, <0.848953, -0.528261, 0.014819>, <0.848953, -0.528261, 0.014819>, <0.848953, -0.528261, 0.014819>, <-0.991769, 0.126867, -0.017311>, <-0.991769, 0.126867, -0.017311>, <-0.991769, 0.126867, -0.017311>, <-0.977742, 0.209115, -0.017067>, 
			<-0.977742, 0.209115, -0.017067>, <-0.977742, 0.209115, -0.017067>, <-0.226820, -0.973929, -0.003959>, <-0.226820, -0.973929, -0.003959>, <-0.226820, -0.973929, -0.003959>, <-0.163095, -0.986606, -0.002847>, <-0.163095, -0.986606, -0.002847>, <-0.163095, -0.986606, -0.002847>, <0.528181, -0.849082, 0.009219>, <0.528181, -0.849082, 0.009219>, <0.528181, -0.849082, 0.009219>, 
			<0.582204, -0.812979, 0.010162>, <0.582204, -0.812979, 0.010162>, <0.582204, -0.812979, 0.010162>, <-0.226820, 0.973929, -0.003959>, <-0.226820, 0.973929, -0.003959>, <-0.226820, 0.973929, -0.003959>, <-0.163095, 0.986606, -0.002847>, <-0.163095, 0.986606, -0.002847>, <-0.163095, 0.986606, -0.002847>, <-0.848954, 0.528258, -0.014819>, <-0.848954, 0.528258, -0.014819>, 
			<-0.848954, 0.528258, -0.014819>, <-0.812856, 0.582291, -0.014188>, <-0.812856, 0.582291, -0.014188>, <-0.812856, 0.582291, -0.014188>, <0.999846, -0.002051, 0.017452>, <0.999846, -0.002051, 0.017452>, <0.999846, -0.002051, 0.017452>, <0.999846, 0.002047, 0.017452>, <0.999846, 0.002047, 0.017452>, <0.999846, 0.002047, 0.017452>, <0.528181, 0.849082, 0.009219>, 
			<0.528181, 0.849082, 0.009219>, <0.528181, 0.849082, 0.009219>, <0.582204, 0.812979, 0.010162>, <0.582204, 0.812979, 0.010162>, <0.582204, 0.812979, 0.010162>, <-0.582204, 0.812979, -0.010162>, <-0.582204, 0.812979, -0.010162>, <-0.582204, 0.812979, -0.010162>, <-0.528181, 0.849082, -0.009219>, <-0.528181, 0.849082, -0.009219>, <-0.528181, 0.849082, -0.009219>, 
			<0.812854, 0.582294, 0.014188>, <0.812854, 0.582294, 0.014188>, <0.812854, 0.582294, 0.014188>, <0.848951, 0.528264, 0.014818>, <0.848951, 0.528264, 0.014818>, <0.848951, 0.528264, 0.014818>, <-0.848953, -0.528261, -0.014819>, <-0.848953, -0.528261, -0.014819>, <-0.848953, -0.528261, -0.014819>, <-0.812855, -0.582293, -0.014188>, <-0.812855, -0.582293, -0.014188>, 
			<-0.812855, -0.582293, -0.014188>, <-0.999848, 0.000002, -0.017452>, <-0.999848, 0.000002, -0.017452>, <-0.999846, -0.002047, -0.017452>, <-0.999846, -0.002047, -0.017452>, <-0.999846, -0.002047, -0.017452>, <-0.582204, -0.812979, -0.010162>, <-0.582204, -0.812979, -0.010162>, <-0.582204, -0.812979, -0.010162>, <-0.528181, -0.849082, -0.009219>, <-0.528181, -0.849082, -0.009219>, 
			<-0.528181, -0.849082, -0.009219>, <0.977740, -0.209127, 0.017067>, <0.977740, -0.209127, 0.017067>, <0.977740, -0.209127, 0.017067>, <0.991768, -0.126876, 0.017311>, <0.991768, -0.126876, 0.017311>, <0.991768, -0.126876, 0.017311>, <0.163095, -0.986606, 0.002847>, <0.163095, -0.986606, 0.002847>, <0.163095, -0.986606, 0.002847>, <0.226820, -0.973929, 0.003959>, 
			<0.226820, -0.973929, 0.003959>, <0.226820, -0.973929, 0.003959>, <0.977737, 0.209138, 0.017066>, <0.977737, 0.209138, 0.017066>, <0.977737, 0.209138, 0.017066>, <0.991767, 0.126882, 0.017311>, <0.991767, 0.126882, 0.017311>, <0.991767, 0.126882, 0.017311>, <0.163095, 0.986606, 0.002847>, <0.163095, 0.986606, 0.002847>, <0.163095, 0.986606, 0.002847>, 
			<0.226820, 0.973929, 0.003959>, <0.226820, 0.973929, 0.003959>, <0.226820, 0.973929, 0.003959>, <-0.991768, -0.126873, -0.017311>, <-0.991768, -0.126873, -0.017311>, <-0.991768, -0.126873, -0.017311>, <-0.977740, -0.209126, -0.017067>, <-0.977740, -0.209126, -0.017067>, <-0.977740, -0.209126, -0.017067>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, 
			<-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, -0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, <-0.017452, 0.000000, 0.999848>, 
			<-0.017452, 0.000000, 0.999848>}
	 texture_list { 1, texture{wm_Handle}}
	 face_indices { 10176, <1884, 3840, 1312>, 0, <1312, 17, 1884>, 0, <3840, 1313, 18>, 0, <18, 1312, 3840>, 0, <3840, 1329, 19>, 0, <19, 1313, 3840>, 0, <1329, 3840, 1328>, 0, <1329, 1328, 35>, 0, <1328, 3840, 137>, 0, <3840, 1884, 137>, 0, 
			<1329, 3841, 1314>, 0, <1314, 19, 1329>, 0, <3841, 1315, 20>, 0, <20, 1314, 3841>, 0, <21, 1315, 3841>, 0, <21, 3841, 1331>, 0, <1331, 3841, 1330>, 0, <1331, 1330, 36>, 0, <35, 1330, 3841>, 0, <3841, 1329, 35>, 0, <1316, 21, 1331>, 0, 
			<1316, 1331, 3842>, 0, <22, 1316, 3842>, 0, <22, 3842, 1317>, 0, <23, 1317, 3842>, 0, <23, 3842, 1333>, 0, <1333, 3842, 1332>, 0, <1333, 1332, 37>, 0, <36, 1332, 3842>, 0, <36, 3842, 1331>, 0, <1318, 23, 1333>, 0, <1318, 1333, 3843>, 0, 
			<24, 1318, 3843>, 0, <24, 3843, 1319>, 0, <1319, 3843, 1335>, 0, <1319, 1335, 25>, 0, <1335, 3843, 1334>, 0, <1335, 1334, 38>, 0, <37, 1334, 3843>, 0, <37, 3843, 1333>, 0, <1320, 25, 1335>, 0, <1320, 1335, 3844>, 0, <26, 1320, 3844>, 0, 
			<26, 3844, 1321>, 0, <1321, 3844, 1337>, 0, <1321, 1337, 27>, 0, <39, 1337, 3844>, 0, <39, 3844, 1336>, 0, <1335, 38, 1336>, 0, <1335, 1336, 3844>, 0, <27, 1337, 3845>, 0, <27, 3845, 1322>, 0, <28, 1322, 3845>, 0, <28, 3845, 1323>, 0, 
			<1323, 3845, 1339>, 0, <1323, 1339, 29>, 0, <40, 1339, 3845>, 0, <40, 3845, 1338>, 0, <1337, 39, 1338>, 0, <1337, 1338, 3845>, 0, <29, 1339, 3846>, 0, <29, 3846, 1324>, 0, <1324, 3846, 30>, 0, <3846, 1325, 30>, 0, <1325, 3846, 1341>, 0, 
			<1341, 31, 1325>, 0, <3846, 1340, 41>, 0, <41, 1341, 3846>, 0, <40, 1340, 1339>, 0, <1340, 3846, 1339>, 0, <31, 1341, 3847>, 0, <3847, 1326, 31>, 0, <1326, 3847, 32>, 0, <3847, 1327, 32>, 0, <1327, 3847, 1885>, 0, <1885, 33, 1327>, 0, 
			<136, 1885, 3847>, 0, <136, 3847, 1523>, 0, <41, 1523, 1341>, 0, <1523, 3847, 1341>, 0, <137, 1525, 3848>, 0, <137, 3848, 1328>, 0, <1328, 3848, 1353>, 0, <1328, 1353, 35>, 0, <1353, 3848, 51>, 0, <3848, 1352, 51>, 0, <1352, 3848, 1525>, 0, 
			<1525, 135, 1352>, 0, <35, 1353, 3849>, 0, <35, 3849, 1330>, 0, <1330, 3849, 1355>, 0, <1330, 1355, 36>, 0, <1355, 3849, 52>, 0, <3849, 1354, 52>, 0, <1354, 3849, 1353>, 0, <1353, 51, 1354>, 0, <36, 1355, 3850>, 0, <36, 3850, 1332>, 0, 
			<1332, 3850, 1357>, 0, <1332, 1357, 37>, 0, <1357, 3850, 1356>, 0, <1357, 1356, 53>, 0, <52, 1356, 3850>, 0, <3850, 1355, 52>, 0, <37, 1357, 3851>, 0, <37, 3851, 1334>, 0, <1334, 3851, 1359>, 0, <1334, 1359, 38>, 0, <1359, 3851, 1358>, 0, 
			<1359, 1358, 54>, 0, <53, 1358, 3851>, 0, <3851, 1357, 53>, 0, <38, 1359, 1336>, 0, <1359, 3852, 1336>, 0, <1336, 3852, 39>, 0, <3852, 1361, 39>, 0, <1361, 3852, 55>, 0, <3852, 1360, 55>, 0, <1360, 3852, 1359>, 0, <1359, 54, 1360>, 0, 
			<39, 1361, 1338>, 0, <1361, 3853, 1338>, 0, <1338, 3853, 40>, 0, <3853, 1363, 40>, 0, <1363, 3853, 56>, 0, <3853, 1362, 56>, 0, <1362, 3853, 1361>, 0, <1361, 55, 1362>, 0, <40, 1363, 1340>, 0, <1363, 3854, 1340>, 0, <1340, 3854, 41>, 0, 
			<3854, 1365, 41>, 0, <1365, 3854, 1364>, 0, <1364, 57, 1365>, 0, <56, 1364, 3854>, 0, <56, 3854, 1363>, 0, <136, 1526, 3855>, 0, <3855, 1342, 136>, 0, <1342, 3855, 1367>, 0, <1367, 42, 1342>, 0, <3855, 1366, 58>, 0, <58, 1367, 3855>, 0, 
			<1366, 3855, 1526>, 0, <1366, 1526, 134>, 0, <42, 1367, 3856>, 0, <3856, 1343, 42>, 0, <1343, 3856, 1369>, 0, <1369, 43, 1343>, 0, <3856, 1368, 59>, 0, <59, 1369, 3856>, 0, <58, 1368, 1367>, 0, <1368, 3856, 1367>, 0, <43, 1369, 3857>, 0, 
			<3857, 1344, 43>, 0, <1344, 3857, 1371>, 0, <1371, 44, 1344>, 0, <3857, 1370, 60>, 0, <60, 1371, 3857>, 0, <59, 1370, 1369>, 0, <1370, 3857, 1369>, 0, <44, 1371, 3858>, 0, <3858, 1345, 44>, 0, <1345, 3858, 1373>, 0, <1373, 45, 1345>, 0, 
			<1373, 3858, 1372>, 0, <1372, 61, 1373>, 0, <60, 1372, 3858>, 0, <60, 3858, 1371>, 0, <45, 1373, 3859>, 0, <3859, 1346, 45>, 0, <1346, 3859, 1375>, 0, <1375, 46, 1346>, 0, <1375, 3859, 1374>, 0, <1374, 62, 1375>, 0, <61, 1374, 3859>, 0, 
			<61, 3859, 1373>, 0, <1375, 3860, 1347>, 0, <1347, 46, 1375>, 0, <3860, 1377, 47>, 0, <47, 1347, 3860>, 0, <3860, 1376, 63>, 0, <63, 1377, 3860>, 0, <62, 1376, 1375>, 0, <1376, 3860, 1375>, 0, <1377, 3861, 1348>, 0, <1348, 47, 1377>, 0, 
			<3861, 1379, 48>, 0, <48, 1348, 3861>, 0, <3861, 1378, 64>, 0, <64, 1379, 3861>, 0, <63, 1378, 1377>, 0, <1378, 3861, 1377>, 0, <1379, 3862, 1349>, 0, <1349, 48, 1379>, 0, <3862, 1381, 49>, 0, <49, 1349, 3862>, 0, <1381, 3862, 1380>, 0, 
			<1381, 1380, 65>, 0, <64, 1380, 3862>, 0, <3862, 1379, 64>, 0, <1381, 3863, 1350>, 0, <1350, 49, 1381>, 0, <3863, 1351, 34>, 0, <34, 1350, 3863>, 0, <1351, 3863, 1382>, 0, <1351, 1382, 50>, 0, <65, 1382, 3863>, 0, <3863, 1381, 65>, 0, 
			<99, 1452, 1418>, 0, <1452, 3864, 1418>, 0, <1418, 3864, 83>, 0, <3864, 1437, 83>, 0, <1437, 3864, 1453>, 0, <1437, 1453, 117>, 0, <132, 1453, 3864>, 0, <132, 3864, 1452>, 0, <97, 1451, 3865>, 0, <97, 3865, 1417>, 0, <1417, 3865, 1419>, 0, 
			<1417, 1419, 98>, 0, <1419, 3865, 1454>, 0, <1419, 1454, 133>, 0, <131, 1454, 3865>, 0, <3865, 1451, 131>, 0, <1450, 3866, 1416>, 0, <1416, 96, 1450>, 0, <1416, 3866, 1451>, 0, <1416, 1451, 97>, 0, <1451, 3866, 1455>, 0, <1451, 1455, 131>, 0, 
			<130, 1455, 3866>, 0, <3866, 1450, 130>, 0, <1449, 3867, 1415>, 0, <1415, 95, 1449>, 0, <3867, 1450, 96>, 0, <96, 1415, 3867>, 0, <1450, 3867, 1456>, 0, <1450, 1456, 130>, 0, <129, 1456, 3867>, 0, <3867, 1449, 129>, 0, <1448, 3868, 1414>, 0, 
			<1414, 94, 1448>, 0, <3868, 1449, 95>, 0, <95, 1414, 3868>, 0, <1449, 3868, 1457>, 0, <1449, 1457, 129>, 0, <128, 1457, 3868>, 0, <3868, 1448, 128>, 0, <1447, 3869, 1413>, 0, <1413, 93, 1447>, 0, <3869, 1448, 94>, 0, <94, 1413, 3869>, 0, 
			<1448, 3869, 1458>, 0, <1448, 1458, 128>, 0, <127, 1458, 3869>, 0, <3869, 1447, 127>, 0, <1446, 3870, 1412>, 0, <1412, 92, 1446>, 0, <3870, 1447, 93>, 0, <93, 1412, 3870>, 0, <1447, 3870, 1459>, 0, <1447, 1459, 127>, 0, <126, 1459, 3870>, 0, 
			<3870, 1446, 126>, 0, <1445, 3871, 1411>, 0, <1411, 91, 1445>, 0, <3871, 1446, 92>, 0, <92, 1411, 3871>, 0, <1446, 3871, 1460>, 0, <1446, 1460, 126>, 0, <125, 1460, 3871>, 0, <3871, 1445, 125>, 0, <90, 1444, 3872>, 0, <90, 3872, 1410>, 0, 
			<3872, 1445, 91>, 0, <91, 1410, 3872>, 0, <1445, 3872, 1461>, 0, <1445, 1461, 125>, 0, <124, 1461, 3872>, 0, <3872, 1444, 124>, 0, <89, 1443, 3873>, 0, <89, 3873, 1409>, 0, <1409, 3873, 1444>, 0, <1409, 1444, 90>, 0, <1444, 3873, 1462>, 0, 
			<1444, 1462, 124>, 0, <123, 1462, 3873>, 0, <3873, 1443, 123>, 0, <88, 1442, 3874>, 0, <88, 3874, 1408>, 0, <1408, 3874, 1443>, 0, <1408, 1443, 89>, 0, <1443, 3874, 1463>, 0, <1443, 1463, 123>, 0, <122, 1463, 3874>, 0, <3874, 1442, 122>, 0, 
			<1441, 3875, 1407>, 0, <1407, 87, 1441>, 0, <3875, 1442, 88>, 0, <88, 1407, 3875>, 0, <1442, 3875, 1464>, 0, <1442, 1464, 122>, 0, <121, 1464, 3875>, 0, <3875, 1441, 121>, 0, <1440, 3876, 1406>, 0, <1406, 86, 1440>, 0, <3876, 1441, 87>, 0, 
			<87, 1406, 3876>, 0, <1441, 3876, 1465>, 0, <1441, 1465, 121>, 0, <120, 1465, 3876>, 0, <3876, 1440, 120>, 0, <1439, 3877, 1405>, 0, <1405, 85, 1439>, 0, <3877, 1440, 86>, 0, <86, 1405, 3877>, 0, <1440, 3877, 1466>, 0, <1440, 1466, 120>, 0, 
			<119, 1466, 3877>, 0, <3877, 1439, 119>, 0, <1438, 3878, 1404>, 0, <1404, 84, 1438>, 0, <3878, 1439, 85>, 0, <85, 1404, 3878>, 0, <1439, 3878, 1467>, 0, <1439, 1467, 119>, 0, <118, 1467, 3878>, 0, <3878, 1438, 118>, 0, <83, 1437, 1403>, 0, 
			<1437, 3879, 1403>, 0, <1403, 3879, 84>, 0, <3879, 1438, 84>, 0, <1438, 3879, 1468>, 0, <1438, 1468, 118>, 0, <117, 1468, 3879>, 0, <3879, 1437, 117>, 0, <81, 1435, 3880>, 0, <3880, 1401, 81>, 0, <1401, 3880, 1436>, 0, <1436, 82, 1401>, 0, 
			<1436, 3880, 1469>, 0, <1469, 116, 1436>, 0, <115, 1469, 1435>, 0, <1469, 3880, 1435>, 0, <80, 1434, 3881>, 0, <3881, 1400, 80>, 0, <1400, 3881, 1435>, 0, <1435, 81, 1400>, 0, <3881, 1470, 115>, 0, <115, 1435, 3881>, 0, <114, 1470, 1434>, 0, 
			<1470, 3881, 1434>, 0, <79, 1433, 3882>, 0, <3882, 1399, 79>, 0, <1399, 3882, 1434>, 0, <1434, 80, 1399>, 0, <3882, 1471, 114>, 0, <114, 1434, 3882>, 0, <113, 1471, 1433>, 0, <1471, 3882, 1433>, 0, <78, 1432, 3883>, 0, <3883, 1398, 78>, 0, 
			<1398, 3883, 1433>, 0, <1433, 79, 1398>, 0, <3883, 1472, 113>, 0, <113, 1433, 3883>, 0, <112, 1472, 1432>, 0, <1472, 3883, 1432>, 0, <77, 1431, 3884>, 0, <3884, 1397, 77>, 0, <1397, 3884, 1432>, 0, <1432, 78, 1397>, 0, <3884, 1473, 112>, 0, 
			<112, 1432, 3884>, 0, <111, 1473, 1431>, 0, <1473, 3884, 1431>, 0, <76, 1430, 3885>, 0, <3885, 1396, 76>, 0, <1396, 3885, 1431>, 0, <1431, 77, 1396>, 0, <3885, 1474, 111>, 0, <111, 1431, 3885>, 0, <110, 1474, 1430>, 0, <1474, 3885, 1430>, 0, 
			<75, 1429, 1395>, 0, <1429, 3886, 1395>, 0, <1395, 3886, 76>, 0, <3886, 1430, 76>, 0, <3886, 1475, 110>, 0, <110, 1430, 3886>, 0, <109, 1475, 1429>, 0, <1475, 3886, 1429>, 0, <74, 1428, 1394>, 0, <1428, 3887, 1394>, 0, <1394, 3887, 75>, 0, 
			<3887, 1429, 75>, 0, <3887, 1476, 109>, 0, <109, 1429, 3887>, 0, <108, 1476, 1428>, 0, <1476, 3887, 1428>, 0, <73, 1427, 3888>, 0, <3888, 1393, 73>, 0, <1393, 3888, 74>, 0, <3888, 1428, 74>, 0, <3888, 1477, 108>, 0, <108, 1428, 3888>, 0, 
			<107, 1477, 1427>, 0, <1477, 3888, 1427>, 0, <72, 1426, 3889>, 0, <3889, 1392, 72>, 0, <1392, 3889, 1427>, 0, <1427, 73, 1392>, 0, <3889, 1478, 107>, 0, <107, 1427, 3889>, 0, <106, 1478, 1426>, 0, <1478, 3889, 1426>, 0, <71, 1425, 3890>, 0, 
			<3890, 1391, 71>, 0, <1391, 3890, 1426>, 0, <1426, 72, 1391>, 0, <3890, 1479, 106>, 0, <106, 1426, 3890>, 0, <105, 1479, 1425>, 0, <1479, 3890, 1425>, 0, <70, 1424, 3891>, 0, <3891, 1390, 70>, 0, <1390, 3891, 1425>, 0, <1425, 71, 1390>, 0, 
			<3891, 1480, 105>, 0, <105, 1425, 3891>, 0, <104, 1480, 1424>, 0, <1480, 3891, 1424>, 0, <69, 1423, 3892>, 0, <3892, 1389, 69>, 0, <1389, 3892, 1424>, 0, <1424, 70, 1389>, 0, <3892, 1481, 104>, 0, <104, 1424, 3892>, 0, <103, 1481, 1423>, 0, 
			<1481, 3892, 1423>, 0, <68, 1422, 3893>, 0, <3893, 1388, 68>, 0, <1388, 3893, 1423>, 0, <1423, 69, 1388>, 0, <3893, 1482, 103>, 0, <103, 1423, 3893>, 0, <102, 1482, 1422>, 0, <1482, 3893, 1422>, 0, <1421, 3894, 1387>, 0, <1387, 67, 1421>, 0, 
			<1387, 3894, 1422>, 0, <1422, 68, 1387>, 0, <3894, 1483, 102>, 0, <102, 1422, 3894>, 0, <101, 1483, 1421>, 0, <1483, 3894, 1421>, 0, <1420, 3895, 1385>, 0, <1385, 66, 1420>, 0, <3895, 1421, 67>, 0, <67, 1385, 3895>, 0, <3895, 1484, 101>, 0, 
			<101, 1421, 3895>, 0, <1484, 3895, 1420>, 0, <1420, 100, 1484>, 0, <3896, 1386, 98>, 0, <98, 1419, 3896>, 0, <1386, 3896, 1420>, 0, <1386, 1420, 66>, 0, <1420, 3896, 100>, 0, <3896, 1485, 100>, 0, <1485, 3896, 1419>, 0, <1419, 133, 1485>, 0, 
			<82, 1436, 1402>, 0, <1436, 3897, 1402>, 0, <1402, 3897, 99>, 0, <3897, 1452, 99>, 0, <3897, 1486, 132>, 0, <132, 1452, 3897>, 0, <116, 1486, 3897>, 0, <116, 3897, 1436>, 0, <1700, 3898, 1454>, 0, <1454, 131, 1700>, 0, <133, 1454, 1732>, 0, 
			<1454, 3898, 1732>, 0, <257, 1732, 3898>, 0, <3898, 1666, 257>, 0, <255, 1666, 3898>, 0, <3898, 1700, 255>, 0, <1488, 3899, 1327>, 0, <1327, 33, 1488>, 0, <32, 1327, 3899>, 0, <32, 3899, 1487>, 0, <67, 1487, 1385>, 0, <1487, 3899, 1385>, 0, 
			<1385, 3899, 66>, 0, <3899, 1488, 66>, 0, <1, 1489, 3900>, 0, <1, 3900, 1384>, 0, <33, 1384, 3900>, 0, <33, 3900, 1488>, 0, <1386, 66, 1488>, 0, <1386, 1488, 3900>, 0, <1386, 3900, 1489>, 0, <1489, 98, 1386>, 0, <2, 1490, 3901>, 0, 
			<2, 3901, 1297>, 0, <1, 1297, 1489>, 0, <1297, 3901, 1489>, 0, <98, 1489, 3901>, 0, <3901, 1417, 98>, 0, <1417, 3901, 1490>, 0, <1490, 97, 1417>, 0, <3, 1491, 3902>, 0, <3, 3902, 1298>, 0, <2, 1298, 1490>, 0, <1298, 3902, 1490>, 0, 
			<97, 1490, 3902>, 0, <3902, 1416, 97>, 0, <1416, 3902, 1491>, 0, <1491, 96, 1416>, 0, <4, 1492, 3903>, 0, <4, 3903, 1299>, 0, <3, 1299, 1491>, 0, <1299, 3903, 1491>, 0, <96, 1491, 3903>, 0, <3903, 1415, 96>, 0, <1415, 3903, 1492>, 0, 
			<1492, 95, 1415>, 0, <5, 1493, 3904>, 0, <5, 3904, 1300>, 0, <4, 1300, 1492>, 0, <1300, 3904, 1492>, 0, <95, 1492, 3904>, 0, <3904, 1414, 95>, 0, <1414, 3904, 1493>, 0, <1493, 94, 1414>, 0, <6, 1494, 3905>, 0, <6, 3905, 1301>, 0, 
			<5, 1301, 1493>, 0, <1301, 3905, 1493>, 0, <94, 1493, 1413>, 0, <1493, 3905, 1413>, 0, <1413, 3905, 93>, 0, <3905, 1494, 93>, 0, <7, 1495, 3906>, 0, <7, 3906, 1302>, 0, <6, 1302, 1494>, 0, <1302, 3906, 1494>, 0, <93, 1494, 1412>, 0, 
			<1494, 3906, 1412>, 0, <1412, 3906, 92>, 0, <3906, 1495, 92>, 0, <8, 1496, 3907>, 0, <8, 3907, 1303>, 0, <7, 1303, 1495>, 0, <1303, 3907, 1495>, 0, <92, 1495, 1411>, 0, <1495, 3907, 1411>, 0, <1411, 3907, 91>, 0, <3907, 1496, 91>, 0, 
			<9, 1497, 3908>, 0, <9, 3908, 1304>, 0, <8, 1304, 1496>, 0, <1304, 3908, 1496>, 0, <91, 1496, 1410>, 0, <1496, 3908, 1410>, 0, <1410, 3908, 1497>, 0, <1497, 90, 1410>, 0, <10, 1498, 1305>, 0, <1498, 3909, 1305>, 0, <9, 1305, 3909>, 0, 
			<3909, 1497, 9>, 0, <90, 1497, 3909>, 0, <3909, 1409, 90>, 0, <1409, 3909, 1498>, 0, <1498, 89, 1409>, 0, <11, 1499, 1306>, 0, <1499, 3910, 1306>, 0, <10, 1306, 3910>, 0, <3910, 1498, 10>, 0, <89, 1498, 3910>, 0, <3910, 1408, 89>, 0, 
			<1408, 3910, 1499>, 0, <1499, 88, 1408>, 0, <12, 1500, 1307>, 0, <1500, 3911, 1307>, 0, <11, 1307, 3911>, 0, <3911, 1499, 11>, 0, <88, 1499, 3911>, 0, <3911, 1407, 88>, 0, <1407, 3911, 1500>, 0, <1500, 87, 1407>, 0, <13, 1501, 1308>, 0, 
			<1501, 3912, 1308>, 0, <12, 1308, 3912>, 0, <3912, 1500, 12>, 0, <87, 1500, 3912>, 0, <3912, 1406, 87>, 0, <1406, 3912, 1501>, 0, <1501, 86, 1406>, 0, <14, 1502, 1309>, 0, <1502, 3913, 1309>, 0, <13, 1309, 3913>, 0, <3913, 1501, 13>, 0, 
			<1501, 3913, 1405>, 0, <1405, 86, 1501>, 0, <3913, 1502, 85>, 0, <85, 1405, 3913>, 0, <15, 1503, 1310>, 0, <1503, 3914, 1310>, 0, <14, 1310, 3914>, 0, <3914, 1502, 14>, 0, <1502, 3914, 1404>, 0, <1404, 85, 1502>, 0, <3914, 1503, 84>, 0, 
			<84, 1404, 3914>, 0, <16, 1504, 1311>, 0, <1504, 3915, 1311>, 0, <15, 1311, 3915>, 0, <3915, 1503, 15>, 0, <1503, 3915, 1403>, 0, <1403, 84, 1503>, 0, <3915, 1504, 83>, 0, <83, 1403, 3915>, 0, <1505, 3916, 1296>, 0, <1505, 1296, 0>, 0, 
			<1296, 3916, 16>, 0, <3916, 1504, 16>, 0, <1504, 3916, 1418>, 0, <1418, 83, 1504>, 0, <3916, 1505, 99>, 0, <99, 1418, 3916>, 0, <1506, 3917, 17>, 0, <3917, 1383, 17>, 0, <1383, 3917, 0>, 0, <3917, 1505, 0>, 0, <1505, 3917, 1402>, 0, 
			<1402, 99, 1505>, 0, <1402, 3917, 1506>, 0, <1402, 1506, 82>, 0, <18, 1507, 3918>, 0, <3918, 1312, 18>, 0, <1312, 3918, 1506>, 0, <1506, 17, 1312>, 0, <82, 1506, 3918>, 0, <82, 3918, 1401>, 0, <1401, 3918, 1507>, 0, <1401, 1507, 81>, 0, 
			<19, 1508, 3919>, 0, <3919, 1313, 19>, 0, <1313, 3919, 1507>, 0, <1507, 18, 1313>, 0, <81, 1507, 3919>, 0, <81, 3919, 1400>, 0, <1400, 3919, 1508>, 0, <1400, 1508, 80>, 0, <20, 1509, 3920>, 0, <3920, 1314, 20>, 0, <1314, 3920, 1508>, 0, 
			<1508, 19, 1314>, 0, <80, 1508, 3920>, 0, <80, 3920, 1399>, 0, <1399, 3920, 1509>, 0, <1399, 1509, 79>, 0, <21, 1510, 3921>, 0, <3921, 1315, 21>, 0, <1315, 3921, 1509>, 0, <1509, 20, 1315>, 0, <79, 1509, 3921>, 0, <79, 3921, 1398>, 0, 
			<1398, 3921, 1510>, 0, <1398, 1510, 78>, 0, <22, 1511, 3922>, 0, <3922, 1316, 22>, 0, <1316, 3922, 1510>, 0, <1510, 21, 1316>, 0, <1510, 3922, 1397>, 0, <1397, 78, 1510>, 0, <3922, 1511, 77>, 0, <77, 1397, 3922>, 0, <23, 1512, 3923>, 0, 
			<3923, 1317, 23>, 0, <1317, 3923, 1511>, 0, <1511, 22, 1317>, 0, <1511, 3923, 1396>, 0, <1396, 77, 1511>, 0, <3923, 1512, 76>, 0, <76, 1396, 3923>, 0, <24, 1513, 3924>, 0, <3924, 1318, 24>, 0, <1318, 3924, 1512>, 0, <1512, 23, 1318>, 0, 
			<1512, 3924, 1395>, 0, <1395, 76, 1512>, 0, <3924, 1513, 75>, 0, <75, 1395, 3924>, 0, <25, 1514, 3925>, 0, <3925, 1319, 25>, 0, <1319, 3925, 1513>, 0, <1513, 24, 1319>, 0, <1513, 3925, 1394>, 0, <1394, 75, 1513>, 0, <3925, 1514, 74>, 0, 
			<74, 1394, 3925>, 0, <1515, 3926, 1320>, 0, <1320, 26, 1515>, 0, <25, 1320, 3926>, 0, <25, 3926, 1514>, 0, <1514, 3926, 1393>, 0, <1393, 74, 1514>, 0, <1393, 3926, 1515>, 0, <1393, 1515, 73>, 0, <1516, 3927, 1321>, 0, <1321, 27, 1516>, 0, 
			<26, 1321, 3927>, 0, <26, 3927, 1515>, 0, <73, 1515, 3927>, 0, <73, 3927, 1392>, 0, <1392, 3927, 1516>, 0, <1392, 1516, 72>, 0, <1517, 3928, 1322>, 0, <1322, 28, 1517>, 0, <27, 1322, 3928>, 0, <27, 3928, 1516>, 0, <72, 1516, 3928>, 0, 
			<72, 3928, 1391>, 0, <1391, 3928, 1517>, 0, <1391, 1517, 71>, 0, <1518, 3929, 1323>, 0, <1323, 29, 1518>, 0, <28, 1323, 3929>, 0, <28, 3929, 1517>, 0, <71, 1517, 3929>, 0, <71, 3929, 1390>, 0, <1390, 3929, 1518>, 0, <1390, 1518, 70>, 0, 
			<1519, 3930, 1324>, 0, <1324, 30, 1519>, 0, <29, 1324, 3930>, 0, <29, 3930, 1518>, 0, <70, 1518, 1389>, 0, <1518, 3930, 1389>, 0, <1389, 3930, 69>, 0, <3930, 1519, 69>, 0, <1520, 3931, 1325>, 0, <1325, 31, 1520>, 0, <30, 1325, 3931>, 0, 
			<30, 3931, 1519>, 0, <69, 1519, 1388>, 0, <1519, 3931, 1388>, 0, <1388, 3931, 68>, 0, <3931, 1520, 68>, 0, <1487, 3932, 1326>, 0, <1326, 32, 1487>, 0, <31, 1326, 3932>, 0, <31, 3932, 1520>, 0, <68, 1520, 1387>, 0, <1520, 3932, 1387>, 0, 
			<1387, 3932, 67>, 0, <3932, 1487, 67>, 0, <50, 1522, 3933>, 0, <3933, 1351, 50>, 0, <1351, 3933, 1524>, 0, <1524, 34, 1351>, 0, <1524, 3933, 1525>, 0, <1524, 1525, 137>, 0, <1525, 3933, 1522>, 0, <1525, 1522, 135>, 0, <57, 1521, 3934>, 0, 
			<57, 3934, 1365>, 0, <41, 1365, 1523>, 0, <1365, 3934, 1523>, 0, <1523, 3934, 136>, 0, <3934, 1526, 136>, 0, <1526, 3934, 1521>, 0, <1521, 134, 1526>, 0, <134, 1528, 3935>, 0, <3935, 1366, 134>, 0, <1366, 3935, 1530>, 0, <1530, 58, 1366>, 0, 
			<3935, 1527, 139>, 0, <139, 1530, 3935>, 0, <1527, 3935, 1528>, 0, <1527, 1528, 138>, 0, <58, 1530, 3936>, 0, <3936, 1368, 58>, 0, <1368, 3936, 1532>, 0, <1532, 59, 1368>, 0, <3936, 1529, 140>, 0, <140, 1532, 3936>, 0, <1529, 3936, 1530>, 0, 
			<1529, 1530, 139>, 0, <59, 1532, 3937>, 0, <3937, 1370, 59>, 0, <1370, 3937, 1534>, 0, <1534, 60, 1370>, 0, <3937, 1531, 141>, 0, <141, 1534, 3937>, 0, <1531, 3937, 1532>, 0, <1531, 1532, 140>, 0, <60, 1534, 3938>, 0, <3938, 1372, 60>, 0, 
			<1372, 3938, 1536>, 0, <1536, 61, 1372>, 0, <3938, 1533, 142>, 0, <142, 1536, 3938>, 0, <1533, 3938, 1534>, 0, <1533, 1534, 141>, 0, <61, 1536, 1374>, 0, <1536, 3939, 1374>, 0, <1374, 3939, 62>, 0, <3939, 1538, 62>, 0, <3939, 1535, 143>, 0, 
			<143, 1538, 3939>, 0, <1535, 3939, 1536>, 0, <1535, 1536, 142>, 0, <62, 1538, 3940>, 0, <3940, 1376, 62>, 0, <1376, 3940, 1540>, 0, <1540, 63, 1376>, 0, <3940, 1537, 144>, 0, <144, 1540, 3940>, 0, <1537, 3940, 1538>, 0, <1537, 1538, 143>, 0, 
			<63, 1540, 3941>, 0, <3941, 1378, 63>, 0, <1378, 3941, 1542>, 0, <1542, 64, 1378>, 0, <3941, 1539, 145>, 0, <145, 1542, 3941>, 0, <1539, 3941, 1540>, 0, <1539, 1540, 144>, 0, <64, 1542, 3942>, 0, <3942, 1380, 64>, 0, <1380, 3942, 1544>, 0, 
			<1544, 65, 1380>, 0, <3942, 1541, 146>, 0, <146, 1544, 3942>, 0, <1541, 3942, 1542>, 0, <1541, 1542, 145>, 0, <1544, 3943, 1382>, 0, <1382, 65, 1544>, 0, <3943, 1546, 50>, 0, <50, 1382, 3943>, 0, <3943, 1543, 147>, 0, <147, 1546, 3943>, 0, 
			<1543, 3943, 1544>, 0, <1543, 1544, 146>, 0, <1546, 3944, 1522>, 0, <1522, 50, 1546>, 0, <3944, 1548, 135>, 0, <135, 1522, 3944>, 0, <1548, 3944, 148>, 0, <3944, 1545, 148>, 0, <1545, 3944, 1546>, 0, <1546, 147, 1545>, 0, <135, 1548, 3945>, 0, 
			<135, 3945, 1352>, 0, <1352, 3945, 1550>, 0, <1352, 1550, 51>, 0, <1550, 3945, 1547>, 0, <1550, 1547, 149>, 0, <1547, 3945, 148>, 0, <3945, 1548, 148>, 0, <1550, 3946, 1354>, 0, <1354, 51, 1550>, 0, <3946, 1552, 52>, 0, <52, 1354, 3946>, 0, 
			<1552, 3946, 1549>, 0, <1552, 1549, 150>, 0, <1549, 3946, 149>, 0, <3946, 1550, 149>, 0, <1552, 3947, 1356>, 0, <1356, 52, 1552>, 0, <3947, 1554, 53>, 0, <53, 1356, 3947>, 0, <1554, 3947, 1551>, 0, <1554, 1551, 151>, 0, <1551, 3947, 150>, 0, 
			<3947, 1552, 150>, 0, <1554, 3948, 1358>, 0, <1358, 53, 1554>, 0, <3948, 1556, 54>, 0, <54, 1358, 3948>, 0, <1556, 3948, 1553>, 0, <1556, 1553, 152>, 0, <1553, 3948, 151>, 0, <3948, 1554, 151>, 0, <54, 1556, 3949>, 0, <54, 3949, 1360>, 0, 
			<1360, 3949, 1558>, 0, <1360, 1558, 55>, 0, <1558, 3949, 1555>, 0, <1558, 1555, 153>, 0, <1555, 3949, 152>, 0, <3949, 1556, 152>, 0, <1558, 3950, 1362>, 0, <1362, 55, 1558>, 0, <3950, 1560, 56>, 0, <56, 1362, 3950>, 0, <1560, 3950, 1557>, 0, 
			<1560, 1557, 154>, 0, <1557, 3950, 153>, 0, <3950, 1558, 153>, 0, <1560, 3951, 1364>, 0, <1364, 56, 1560>, 0, <3951, 1562, 57>, 0, <57, 1364, 3951>, 0, <1562, 3951, 1559>, 0, <1562, 1559, 155>, 0, <1559, 3951, 154>, 0, <3951, 1560, 154>, 0, 
			<57, 1562, 1521>, 0, <1562, 3952, 1521>, 0, <1521, 3952, 134>, 0, <3952, 1528, 134>, 0, <1528, 3952, 1561>, 0, <1528, 1561, 138>, 0, <1561, 3952, 155>, 0, <3952, 1562, 155>, 0, <207, 1649, 3953>, 0, <207, 3953, 1630>, 0, <223, 1630, 1664>, 0, 
			<1630, 3953, 1664>, 0, <1664, 3953, 1665>, 0, <1664, 1665, 256>, 0, <3953, 1649, 241>, 0, <241, 1665, 3953>, 0, <222, 1631, 1629>, 0, <1631, 3954, 1629>, 0, <1629, 3954, 221>, 0, <3954, 1663, 221>, 0, <1663, 3954, 1666>, 0, <1666, 255, 1663>, 0, 
			<257, 1666, 1631>, 0, <1666, 3954, 1631>, 0, <221, 1663, 1628>, 0, <1663, 3955, 1628>, 0, <220, 1628, 3955>, 0, <3955, 1662, 220>, 0, <1662, 3955, 1667>, 0, <1667, 254, 1662>, 0, <3955, 1663, 255>, 0, <255, 1667, 3955>, 0, <220, 1662, 1627>, 0, 
			<1662, 3956, 1627>, 0, <219, 1627, 3956>, 0, <3956, 1661, 219>, 0, <1661, 3956, 1668>, 0, <1668, 253, 1661>, 0, <3956, 1662, 254>, 0, <254, 1668, 3956>, 0, <219, 1661, 1626>, 0, <1661, 3957, 1626>, 0, <218, 1626, 3957>, 0, <3957, 1660, 218>, 0, 
			<1660, 3957, 1669>, 0, <1669, 252, 1660>, 0, <3957, 1661, 253>, 0, <253, 1669, 3957>, 0, <218, 1660, 1625>, 0, <1660, 3958, 1625>, 0, <217, 1625, 3958>, 0, <3958, 1659, 217>, 0, <1659, 3958, 1670>, 0, <1670, 251, 1659>, 0, <3958, 1660, 252>, 0, 
			<252, 1670, 3958>, 0, <217, 1659, 1624>, 0, <1659, 3959, 1624>, 0, <216, 1624, 3959>, 0, <3959, 1658, 216>, 0, <1658, 3959, 1671>, 0, <1671, 250, 1658>, 0, <3959, 1659, 251>, 0, <251, 1671, 3959>, 0, <216, 1658, 3960>, 0, <3960, 1623, 216>, 0, 
			<1623, 3960, 1657>, 0, <1657, 215, 1623>, 0, <1657, 3960, 1672>, 0, <1672, 249, 1657>, 0, <3960, 1658, 250>, 0, <250, 1672, 3960>, 0, <215, 1657, 3961>, 0, <3961, 1622, 215>, 0, <1622, 3961, 1656>, 0, <1656, 214, 1622>, 0, <1656, 3961, 1673>, 0, 
			<1673, 248, 1656>, 0, <3961, 1657, 249>, 0, <249, 1673, 3961>, 0, <214, 1656, 1621>, 0, <1656, 3962, 1621>, 0, <213, 1621, 3962>, 0, <3962, 1655, 213>, 0, <1655, 3962, 1674>, 0, <1674, 247, 1655>, 0, <3962, 1656, 248>, 0, <248, 1674, 3962>, 0, 
			<213, 1655, 1620>, 0, <1655, 3963, 1620>, 0, <212, 1620, 3963>, 0, <3963, 1654, 212>, 0, <1654, 3963, 1675>, 0, <1675, 246, 1654>, 0, <3963, 1655, 247>, 0, <247, 1675, 3963>, 0, <212, 1654, 1619>, 0, <1654, 3964, 1619>, 0, <211, 1619, 3964>, 0, 
			<3964, 1653, 211>, 0, <1653, 3964, 1676>, 0, <1676, 245, 1653>, 0, <3964, 1654, 246>, 0, <246, 1676, 3964>, 0, <211, 1653, 1618>, 0, <1653, 3965, 1618>, 0, <210, 1618, 3965>, 0, <3965, 1652, 210>, 0, <1652, 3965, 1677>, 0, <1677, 244, 1652>, 0, 
			<3965, 1653, 245>, 0, <245, 1677, 3965>, 0, <210, 1652, 1617>, 0, <1652, 3966, 1617>, 0, <209, 1617, 3966>, 0, <3966, 1651, 209>, 0, <1651, 3966, 1678>, 0, <1678, 243, 1651>, 0, <3966, 1652, 244>, 0, <244, 1678, 3966>, 0, <209, 1651, 1616>, 0, 
			<1651, 3967, 1616>, 0, <208, 1616, 3967>, 0, <3967, 1650, 208>, 0, <1650, 3967, 1679>, 0, <1679, 242, 1650>, 0, <3967, 1651, 243>, 0, <243, 1679, 3967>, 0, <208, 1650, 1615>, 0, <1650, 3968, 1615>, 0, <207, 1615, 1649>, 0, <1615, 3968, 1649>, 0, 
			<1649, 3968, 1680>, 0, <1680, 241, 1649>, 0, <3968, 1650, 242>, 0, <242, 1680, 3968>, 0, <1648, 3969, 1613>, 0, <1613, 206, 1648>, 0, <205, 1613, 3969>, 0, <205, 3969, 1647>, 0, <1647, 3969, 239>, 0, <3969, 1681, 239>, 0, <1681, 3969, 1648>, 0, 
			<1648, 240, 1681>, 0, <1647, 3970, 1612>, 0, <1612, 205, 1647>, 0, <204, 1612, 1646>, 0, <1612, 3970, 1646>, 0, <1646, 3970, 238>, 0, <3970, 1682, 238>, 0, <1682, 3970, 1647>, 0, <1647, 239, 1682>, 0, <204, 1646, 3971>, 0, <204, 3971, 1611>, 0, 
			<203, 1611, 1645>, 0, <1611, 3971, 1645>, 0, <1645, 3971, 237>, 0, <3971, 1683, 237>, 0, <1683, 3971, 1646>, 0, <1646, 238, 1683>, 0, <203, 1645, 3972>, 0, <203, 3972, 1610>, 0, <202, 1610, 1644>, 0, <1610, 3972, 1644>, 0, <1644, 3972, 236>, 0, 
			<3972, 1684, 236>, 0, <1684, 3972, 1645>, 0, <1645, 237, 1684>, 0, <202, 1644, 3973>, 0, <202, 3973, 1609>, 0, <201, 1609, 1643>, 0, <1609, 3973, 1643>, 0, <1643, 3973, 235>, 0, <3973, 1685, 235>, 0, <1685, 3973, 1644>, 0, <1644, 236, 1685>, 0, 
			<201, 1643, 3974>, 0, <201, 3974, 1608>, 0, <200, 1608, 1642>, 0, <1608, 3974, 1642>, 0, <1642, 3974, 234>, 0, <3974, 1686, 234>, 0, <1686, 3974, 1643>, 0, <1643, 235, 1686>, 0, <200, 1642, 3975>, 0, <200, 3975, 1607>, 0, <199, 1607, 1641>, 0, 
			<1607, 3975, 1641>, 0, <1641, 3975, 233>, 0, <3975, 1687, 233>, 0, <1687, 3975, 1642>, 0, <1642, 234, 1687>, 0, <199, 1641, 3976>, 0, <199, 3976, 1606>, 0, <198, 1606, 1640>, 0, <1606, 3976, 1640>, 0, <1640, 3976, 232>, 0, <3976, 1688, 232>, 0, 
			<1688, 3976, 1641>, 0, <1641, 233, 1688>, 0, <1640, 3977, 1605>, 0, <1605, 198, 1640>, 0, <197, 1605, 3977>, 0, <197, 3977, 1639>, 0, <1639, 3977, 231>, 0, <3977, 1689, 231>, 0, <1689, 3977, 1640>, 0, <1640, 232, 1689>, 0, <1639, 3978, 1604>, 0, 
			<1604, 197, 1639>, 0, <196, 1604, 3978>, 0, <196, 3978, 1638>, 0, <1638, 3978, 230>, 0, <3978, 1690, 230>, 0, <1690, 3978, 1639>, 0, <1639, 231, 1690>, 0, <196, 1638, 3979>, 0, <196, 3979, 1603>, 0, <195, 1603, 1637>, 0, <1603, 3979, 1637>, 0, 
			<1637, 3979, 229>, 0, <3979, 1691, 229>, 0, <1691, 3979, 1638>, 0, <1638, 230, 1691>, 0, <195, 1637, 3980>, 0, <195, 3980, 1602>, 0, <194, 1602, 1636>, 0, <1602, 3980, 1636>, 0, <1636, 3980, 228>, 0, <3980, 1692, 228>, 0, <1692, 3980, 1637>, 0, 
			<1637, 229, 1692>, 0, <194, 1636, 3981>, 0, <194, 3981, 1601>, 0, <193, 1601, 1635>, 0, <1601, 3981, 1635>, 0, <1635, 3981, 227>, 0, <3981, 1693, 227>, 0, <1693, 3981, 1636>, 0, <1636, 228, 1693>, 0, <193, 1635, 3982>, 0, <193, 3982, 1600>, 0, 
			<192, 1600, 1634>, 0, <1600, 3982, 1634>, 0, <1634, 3982, 226>, 0, <3982, 1694, 226>, 0, <1694, 3982, 1635>, 0, <1635, 227, 1694>, 0, <192, 1634, 3983>, 0, <3983, 1599, 192>, 0, <1599, 3983, 1633>, 0, <1633, 191, 1599>, 0, <1633, 3983, 225>, 0, 
			<3983, 1695, 225>, 0, <1695, 3983, 1634>, 0, <1634, 226, 1695>, 0, <191, 1633, 3984>, 0, <3984, 1597, 191>, 0, <1597, 3984, 1632>, 0, <1632, 190, 1597>, 0, <1632, 3984, 1696>, 0, <1696, 224, 1632>, 0, <1696, 3984, 1633>, 0, <1633, 225, 1696>, 0, 
			<1632, 3985, 1598>, 0, <1632, 1598, 190>, 0, <1598, 3985, 222>, 0, <3985, 1631, 222>, 0, <1631, 3985, 1697>, 0, <1697, 257, 1631>, 0, <1697, 3985, 1632>, 0, <1697, 1632, 224>, 0, <223, 1664, 3986>, 0, <223, 3986, 1614>, 0, <206, 1614, 1648>, 0, 
			<1614, 3986, 1648>, 0, <1648, 3986, 240>, 0, <3986, 1698, 240>, 0, <1698, 3986, 1664>, 0, <1664, 256, 1698>, 0, <132, 1699, 3987>, 0, <3987, 1453, 132>, 0, <3987, 1714, 117>, 0, <117, 1453, 3987>, 0, <241, 1714, 1665>, 0, <1714, 3987, 1665>, 0, 
			<256, 1665, 1699>, 0, <1665, 3987, 1699>, 0, <1701, 3988, 1455>, 0, <1455, 130, 1701>, 0, <3988, 1700, 131>, 0, <131, 1455, 3988>, 0, <255, 1700, 1667>, 0, <1700, 3988, 1667>, 0, <254, 1667, 3988>, 0, <3988, 1701, 254>, 0, <1702, 3989, 1456>, 0, 
			<1456, 129, 1702>, 0, <3989, 1701, 130>, 0, <130, 1456, 3989>, 0, <254, 1701, 1668>, 0, <1701, 3989, 1668>, 0, <253, 1668, 3989>, 0, <3989, 1702, 253>, 0, <1703, 3990, 1457>, 0, <1457, 128, 1703>, 0, <3990, 1702, 129>, 0, <129, 1457, 3990>, 0, 
			<253, 1702, 1669>, 0, <1702, 3990, 1669>, 0, <252, 1669, 3990>, 0, <3990, 1703, 252>, 0, <1704, 3991, 1458>, 0, <1458, 127, 1704>, 0, <3991, 1703, 128>, 0, <128, 1458, 3991>, 0, <252, 1703, 1670>, 0, <1703, 3991, 1670>, 0, <251, 1670, 3991>, 0, 
			<3991, 1704, 251>, 0, <1705, 3992, 1459>, 0, <1459, 126, 1705>, 0, <3992, 1704, 127>, 0, <127, 1459, 3992>, 0, <251, 1704, 1671>, 0, <1704, 3992, 1671>, 0, <250, 1671, 3992>, 0, <3992, 1705, 250>, 0, <1706, 3993, 1460>, 0, <1460, 125, 1706>, 0, 
			<3993, 1705, 126>, 0, <126, 1460, 3993>, 0, <250, 1705, 1672>, 0, <1705, 3993, 1672>, 0, <249, 1672, 3993>, 0, <3993, 1706, 249>, 0, <1707, 3994, 1461>, 0, <1461, 124, 1707>, 0, <3994, 1706, 125>, 0, <125, 1461, 3994>, 0, <249, 1706, 1673>, 0, 
			<1706, 3994, 1673>, 0, <248, 1673, 3994>, 0, <3994, 1707, 248>, 0, <1708, 3995, 1462>, 0, <1462, 123, 1708>, 0, <3995, 1707, 124>, 0, <124, 1462, 3995>, 0, <248, 1707, 1674>, 0, <1707, 3995, 1674>, 0, <247, 1674, 3995>, 0, <3995, 1708, 247>, 0, 
			<1709, 3996, 1463>, 0, <1463, 122, 1709>, 0, <3996, 1708, 123>, 0, <123, 1463, 3996>, 0, <247, 1708, 1675>, 0, <1708, 3996, 1675>, 0, <246, 1675, 3996>, 0, <3996, 1709, 246>, 0, <1710, 3997, 1464>, 0, <1464, 121, 1710>, 0, <3997, 1709, 122>, 0, 
			<122, 1464, 3997>, 0, <246, 1709, 1676>, 0, <1709, 3997, 1676>, 0, <245, 1676, 3997>, 0, <3997, 1710, 245>, 0, <1711, 3998, 1465>, 0, <1465, 120, 1711>, 0, <3998, 1710, 121>, 0, <121, 1465, 3998>, 0, <245, 1710, 1677>, 0, <1710, 3998, 1677>, 0, 
			<244, 1677, 3998>, 0, <3998, 1711, 244>, 0, <1712, 3999, 1466>, 0, <1466, 119, 1712>, 0, <3999, 1711, 120>, 0, <120, 1466, 3999>, 0, <244, 1711, 1678>, 0, <1711, 3999, 1678>, 0, <243, 1678, 3999>, 0, <3999, 1712, 243>, 0, <1713, 4000, 1467>, 0, 
			<1467, 118, 1713>, 0, <4000, 1712, 119>, 0, <119, 1467, 4000>, 0, <243, 1712, 1679>, 0, <1712, 4000, 1679>, 0, <242, 1679, 4000>, 0, <4000, 1713, 242>, 0, <1714, 4001, 1468>, 0, <1468, 117, 1714>, 0, <4001, 1713, 118>, 0, <118, 1468, 4001>, 0, 
			<242, 1713, 1680>, 0, <1713, 4001, 1680>, 0, <241, 1680, 4001>, 0, <4001, 1714, 241>, 0, <115, 1716, 4002>, 0, <4002, 1469, 115>, 0, <1469, 4002, 1715>, 0, <1715, 116, 1469>, 0, <240, 1715, 4002>, 0, <240, 4002, 1681>, 0, <239, 1681, 1716>, 0, 
			<1681, 4002, 1716>, 0, <114, 1717, 4003>, 0, <4003, 1470, 114>, 0, <1470, 4003, 1716>, 0, <1716, 115, 1470>, 0, <239, 1716, 4003>, 0, <239, 4003, 1682>, 0, <238, 1682, 1717>, 0, <1682, 4003, 1717>, 0, <113, 1718, 4004>, 0, <4004, 1471, 113>, 0, 
			<1471, 4004, 1717>, 0, <1717, 114, 1471>, 0, <238, 1717, 4004>, 0, <238, 4004, 1683>, 0, <237, 1683, 1718>, 0, <1683, 4004, 1718>, 0, <112, 1719, 4005>, 0, <4005, 1472, 112>, 0, <1472, 4005, 1718>, 0, <1718, 113, 1472>, 0, <237, 1718, 4005>, 0, 
			<237, 4005, 1684>, 0, <236, 1684, 1719>, 0, <1684, 4005, 1719>, 0, <111, 1720, 4006>, 0, <4006, 1473, 111>, 0, <1473, 4006, 1719>, 0, <1719, 112, 1473>, 0, <236, 1719, 4006>, 0, <236, 4006, 1685>, 0, <235, 1685, 1720>, 0, <1685, 4006, 1720>, 0, 
			<110, 1721, 4007>, 0, <4007, 1474, 110>, 0, <1474, 4007, 1720>, 0, <1720, 111, 1474>, 0, <235, 1720, 4007>, 0, <235, 4007, 1686>, 0, <234, 1686, 1721>, 0, <1686, 4007, 1721>, 0, <109, 1722, 4008>, 0, <4008, 1475, 109>, 0, <1475, 4008, 1721>, 0, 
			<1721, 110, 1475>, 0, <234, 1721, 4008>, 0, <234, 4008, 1687>, 0, <233, 1687, 1722>, 0, <1687, 4008, 1722>, 0, <108, 1723, 4009>, 0, <4009, 1476, 108>, 0, <1476, 4009, 1722>, 0, <1722, 109, 1476>, 0, <233, 1722, 4009>, 0, <233, 4009, 1688>, 0, 
			<232, 1688, 1723>, 0, <1688, 4009, 1723>, 0, <107, 1724, 4010>, 0, <4010, 1477, 107>, 0, <1477, 4010, 1723>, 0, <1723, 108, 1477>, 0, <232, 1723, 4010>, 0, <232, 4010, 1689>, 0, <231, 1689, 1724>, 0, <1689, 4010, 1724>, 0, <106, 1725, 4011>, 0, 
			<4011, 1478, 106>, 0, <1478, 4011, 1724>, 0, <1724, 107, 1478>, 0, <231, 1724, 4011>, 0, <231, 4011, 1690>, 0, <230, 1690, 1725>, 0, <1690, 4011, 1725>, 0, <105, 1726, 4012>, 0, <4012, 1479, 105>, 0, <1479, 4012, 1725>, 0, <1725, 106, 1479>, 0, 
			<230, 1725, 4012>, 0, <230, 4012, 1691>, 0, <229, 1691, 1726>, 0, <1691, 4012, 1726>, 0, <104, 1727, 4013>, 0, <4013, 1480, 104>, 0, <1480, 4013, 1726>, 0, <1726, 105, 1480>, 0, <229, 1726, 4013>, 0, <229, 4013, 1692>, 0, <228, 1692, 1727>, 0, 
			<1692, 4013, 1727>, 0, <103, 1728, 4014>, 0, <4014, 1481, 103>, 0, <1481, 4014, 1727>, 0, <1727, 104, 1481>, 0, <228, 1727, 4014>, 0, <228, 4014, 1693>, 0, <227, 1693, 1728>, 0, <1693, 4014, 1728>, 0, <102, 1729, 4015>, 0, <4015, 1482, 102>, 0, 
			<1482, 4015, 1728>, 0, <1728, 103, 1482>, 0, <227, 1728, 4015>, 0, <227, 4015, 1694>, 0, <226, 1694, 1729>, 0, <1694, 4015, 1729>, 0, <101, 1730, 4016>, 0, <4016, 1483, 101>, 0, <1483, 4016, 1729>, 0, <1729, 102, 1483>, 0, <226, 1729, 4016>, 0, 
			<226, 4016, 1695>, 0, <225, 1695, 1730>, 0, <1695, 4016, 1730>, 0, <1731, 4017, 1484>, 0, <1484, 100, 1731>, 0, <1484, 4017, 1730>, 0, <1730, 101, 1484>, 0, <225, 1730, 4017>, 0, <225, 4017, 1696>, 0, <1696, 4017, 1731>, 0, <1731, 224, 1696>, 0, 
			<1732, 4018, 1485>, 0, <1485, 133, 1732>, 0, <1485, 4018, 1731>, 0, <1485, 1731, 100>, 0, <224, 1731, 4018>, 0, <4018, 1697, 224>, 0, <1697, 4018, 1732>, 0, <1732, 257, 1697>, 0, <116, 1715, 4019>, 0, <4019, 1486, 116>, 0, <1486, 4019, 1699>, 0, 
			<1699, 132, 1486>, 0, <1699, 4019, 1698>, 0, <1698, 256, 1699>, 0, <240, 1698, 1715>, 0, <1698, 4019, 1715>, 0, <188, 1733, 4020>, 0, <4020, 1594, 188>, 0, <1594, 4020, 1734>, 0, <1734, 189, 1594>, 0, <4020, 1597, 190>, 0, <190, 1734, 4020>, 0, 
			<1597, 4020, 1733>, 0, <1597, 1733, 191>, 0, <189, 1734, 4021>, 0, <4021, 1596, 189>, 0, <1596, 4021, 157>, 0, <4021, 1735, 157>, 0, <1735, 4021, 1598>, 0, <1598, 222, 1735>, 0, <1734, 190, 1598>, 0, <1734, 1598, 4021>, 0, <157, 1735, 1564>, 0, 
			<1735, 4022, 1564>, 0, <1564, 4022, 158>, 0, <4022, 1736, 158>, 0, <1736, 4022, 1629>, 0, <1629, 221, 1736>, 0, <222, 1629, 4022>, 0, <222, 4022, 1735>, 0, <158, 1736, 1565>, 0, <1736, 4023, 1565>, 0, <1565, 4023, 159>, 0, <4023, 1737, 159>, 0, 
			<1737, 4023, 1628>, 0, <1628, 220, 1737>, 0, <4023, 1736, 221>, 0, <221, 1628, 4023>, 0, <159, 1737, 1566>, 0, <1737, 4024, 1566>, 0, <1566, 4024, 160>, 0, <4024, 1738, 160>, 0, <1738, 4024, 1627>, 0, <1627, 219, 1738>, 0, <4024, 1737, 220>, 0, 
			<220, 1627, 4024>, 0, <160, 1738, 1567>, 0, <1738, 4025, 1567>, 0, <1567, 4025, 161>, 0, <4025, 1739, 161>, 0, <1739, 4025, 1626>, 0, <1626, 218, 1739>, 0, <4025, 1738, 219>, 0, <219, 1626, 4025>, 0, <161, 1739, 1568>, 0, <1739, 4026, 1568>, 0, 
			<1568, 4026, 162>, 0, <4026, 1740, 162>, 0, <4026, 1625, 217>, 0, <217, 1740, 4026>, 0, <1625, 4026, 1739>, 0, <1625, 1739, 218>, 0, <162, 1740, 1569>, 0, <1740, 4027, 1569>, 0, <1569, 4027, 163>, 0, <4027, 1741, 163>, 0, <4027, 1624, 216>, 0, 
			<216, 1741, 4027>, 0, <1624, 4027, 1740>, 0, <1624, 1740, 217>, 0, <163, 1741, 1570>, 0, <1741, 4028, 1570>, 0, <1570, 4028, 164>, 0, <4028, 1742, 164>, 0, <4028, 1623, 215>, 0, <215, 1742, 4028>, 0, <1623, 4028, 1741>, 0, <1623, 1741, 216>, 0, 
			<164, 1742, 1571>, 0, <1742, 4029, 1571>, 0, <1571, 4029, 165>, 0, <4029, 1743, 165>, 0, <4029, 1622, 214>, 0, <214, 1743, 4029>, 0, <1622, 4029, 1742>, 0, <1622, 1742, 215>, 0, <165, 1743, 4030>, 0, <165, 4030, 1572>, 0, <1572, 4030, 1744>, 0, 
			<1572, 1744, 166>, 0, <1744, 4030, 1621>, 0, <1621, 213, 1744>, 0, <4030, 1743, 214>, 0, <214, 1621, 4030>, 0, <166, 1744, 4031>, 0, <166, 4031, 1573>, 0, <1573, 4031, 1745>, 0, <1573, 1745, 167>, 0, <1745, 4031, 1620>, 0, <1620, 212, 1745>, 0, 
			<4031, 1744, 213>, 0, <213, 1620, 4031>, 0, <167, 1745, 4032>, 0, <167, 4032, 1574>, 0, <1574, 4032, 1746>, 0, <1574, 1746, 168>, 0, <1746, 4032, 1619>, 0, <1619, 211, 1746>, 0, <4032, 1745, 212>, 0, <212, 1619, 4032>, 0, <168, 1746, 4033>, 0, 
			<168, 4033, 1575>, 0, <1575, 4033, 1747>, 0, <1575, 1747, 169>, 0, <1747, 4033, 1618>, 0, <1618, 210, 1747>, 0, <4033, 1746, 211>, 0, <211, 1618, 4033>, 0, <169, 1747, 4034>, 0, <169, 4034, 1576>, 0, <1576, 4034, 1748>, 0, <1576, 1748, 170>, 0, 
			<1748, 4034, 209>, 0, <4034, 1617, 209>, 0, <1617, 4034, 1747>, 0, <1747, 210, 1617>, 0, <170, 1748, 4035>, 0, <170, 4035, 1577>, 0, <1577, 4035, 1749>, 0, <1577, 1749, 171>, 0, <1749, 4035, 208>, 0, <4035, 1616, 208>, 0, <1616, 4035, 1748>, 0, 
			<1748, 209, 1616>, 0, <171, 1749, 4036>, 0, <171, 4036, 1578>, 0, <1578, 4036, 1750>, 0, <1578, 1750, 172>, 0, <1750, 4036, 207>, 0, <4036, 1615, 207>, 0, <1615, 4036, 1749>, 0, <1749, 208, 1615>, 0, <172, 1750, 4037>, 0, <172, 4037, 1563>, 0, 
			<1563, 4037, 1751>, 0, <1563, 1751, 156>, 0, <1751, 4037, 223>, 0, <4037, 1630, 223>, 0, <1630, 4037, 1750>, 0, <1750, 207, 1630>, 0, <156, 1751, 4038>, 0, <156, 4038, 1595>, 0, <173, 1595, 4038>, 0, <173, 4038, 1752>, 0, <1752, 4038, 1614>, 0, 
			<1752, 1614, 206>, 0, <1614, 4038, 1751>, 0, <1751, 223, 1614>, 0, <1752, 4039, 1579>, 0, <1579, 173, 1752>, 0, <4039, 1753, 174>, 0, <174, 1579, 4039>, 0, <1753, 4039, 1613>, 0, <1753, 1613, 205>, 0, <1613, 4039, 206>, 0, <4039, 1752, 206>, 0, 
			<1753, 4040, 1580>, 0, <1580, 174, 1753>, 0, <4040, 1754, 175>, 0, <175, 1580, 4040>, 0, <1754, 4040, 1612>, 0, <1754, 1612, 204>, 0, <1612, 4040, 205>, 0, <4040, 1753, 205>, 0, <1754, 4041, 1581>, 0, <1581, 175, 1754>, 0, <4041, 1755, 176>, 0, 
			<176, 1581, 4041>, 0, <1755, 4041, 1611>, 0, <1755, 1611, 203>, 0, <1611, 4041, 204>, 0, <4041, 1754, 204>, 0, <1755, 4042, 1582>, 0, <1582, 176, 1755>, 0, <4042, 1756, 177>, 0, <177, 1582, 4042>, 0, <1756, 4042, 1610>, 0, <1756, 1610, 202>, 0, 
			<1610, 4042, 203>, 0, <4042, 1755, 203>, 0, <1756, 4043, 1583>, 0, <1583, 177, 1756>, 0, <4043, 1757, 178>, 0, <178, 1583, 4043>, 0, <1757, 4043, 201>, 0, <4043, 1609, 201>, 0, <1609, 4043, 1756>, 0, <1756, 202, 1609>, 0, <1757, 4044, 1584>, 0, 
			<1584, 178, 1757>, 0, <4044, 1758, 179>, 0, <179, 1584, 4044>, 0, <1758, 4044, 200>, 0, <4044, 1608, 200>, 0, <1608, 4044, 1757>, 0, <1757, 201, 1608>, 0, <1758, 4045, 1585>, 0, <1585, 179, 1758>, 0, <4045, 1759, 180>, 0, <180, 1585, 4045>, 0, 
			<1759, 4045, 199>, 0, <4045, 1607, 199>, 0, <1607, 4045, 1758>, 0, <1758, 200, 1607>, 0, <1759, 4046, 1586>, 0, <1586, 180, 1759>, 0, <4046, 1760, 181>, 0, <181, 1586, 4046>, 0, <1760, 4046, 198>, 0, <4046, 1606, 198>, 0, <1606, 4046, 1759>, 0, 
			<1759, 199, 1606>, 0, <181, 1760, 4047>, 0, <4047, 1587, 181>, 0, <1587, 4047, 1761>, 0, <1761, 182, 1587>, 0, <1761, 4047, 1605>, 0, <1761, 1605, 197>, 0, <1605, 4047, 198>, 0, <4047, 1760, 198>, 0, <182, 1761, 4048>, 0, <4048, 1588, 182>, 0, 
			<1588, 4048, 1762>, 0, <1762, 183, 1588>, 0, <1762, 4048, 1604>, 0, <1762, 1604, 196>, 0, <1604, 4048, 197>, 0, <4048, 1761, 197>, 0, <183, 1762, 4049>, 0, <4049, 1589, 183>, 0, <1589, 4049, 1763>, 0, <1763, 184, 1589>, 0, <1763, 4049, 1603>, 0, 
			<1763, 1603, 195>, 0, <1603, 4049, 196>, 0, <4049, 1762, 196>, 0, <184, 1763, 4050>, 0, <4050, 1590, 184>, 0, <1590, 4050, 1764>, 0, <1764, 185, 1590>, 0, <1764, 4050, 1602>, 0, <1764, 1602, 194>, 0, <1602, 4050, 195>, 0, <4050, 1763, 195>, 0, 
			<185, 1764, 4051>, 0, <4051, 1591, 185>, 0, <1591, 4051, 1765>, 0, <1765, 186, 1591>, 0, <4051, 1601, 193>, 0, <193, 1765, 4051>, 0, <1601, 4051, 1764>, 0, <1601, 1764, 194>, 0, <186, 1765, 4052>, 0, <4052, 1592, 186>, 0, <1592, 4052, 1766>, 0, 
			<1766, 187, 1592>, 0, <4052, 1600, 192>, 0, <192, 1766, 4052>, 0, <1600, 4052, 1765>, 0, <1600, 1765, 193>, 0, <187, 1766, 4053>, 0, <4053, 1593, 187>, 0, <1593, 4053, 1733>, 0, <1733, 188, 1593>, 0, <4053, 1599, 191>, 0, <191, 1733, 4053>, 0, 
			<1599, 4053, 1766>, 0, <1599, 1766, 192>, 0, <178, 1584, 4054>, 0, <178, 4054, 1583>, 0, <1583, 4054, 1786>, 0, <1583, 1786, 177>, 0, <296, 1786, 4054>, 0, <296, 4054, 1860>, 0, <1787, 297, 1860>, 0, <1787, 1860, 4054>, 0, <179, 1787, 4054>, 0, 
			<179, 4054, 1584>, 0, <180, 1586, 4055>, 0, <180, 4055, 1585>, 0, <1585, 4055, 1787>, 0, <1585, 1787, 179>, 0, <297, 1787, 4055>, 0, <297, 4055, 1869>, 0, <1788, 298, 1869>, 0, <1788, 1869, 4055>, 0, <1586, 181, 1788>, 0, <1586, 1788, 4055>, 0, 
			<182, 1588, 4056>, 0, <182, 4056, 1587>, 0, <1587, 4056, 1788>, 0, <1587, 1788, 181>, 0, <1788, 4056, 1862>, 0, <1788, 1862, 298>, 0, <299, 1862, 4056>, 0, <299, 4056, 1789>, 0, <1588, 183, 1789>, 0, <1588, 1789, 4056>, 0, <4057, 1593, 188>, 0, 
			<188, 1594, 4057>, 0, <4057, 1883, 187>, 0, <187, 1593, 4057>, 0, <301, 1883, 1873>, 0, <1883, 4057, 1873>, 0, <1873, 4057, 310>, 0, <4057, 1882, 310>, 0, <1882, 4057, 1594>, 0, <1594, 189, 1882>, 0, <184, 1590, 4058>, 0, <184, 4058, 1589>, 0, 
			<183, 1589, 4058>, 0, <183, 4058, 1789>, 0, <1789, 4058, 1872>, 0, <1789, 1872, 299>, 0, <300, 1872, 4058>, 0, <300, 4058, 1790>, 0, <1590, 185, 1790>, 0, <1590, 1790, 4058>, 0, <1582, 4059, 176>, 0, <4059, 1581, 176>, 0, <1581, 4059, 1785>, 0, 
			<1785, 175, 1581>, 0, <4059, 1849, 295>, 0, <295, 1785, 4059>, 0, <296, 1849, 1786>, 0, <1849, 4059, 1786>, 0, <177, 1786, 4059>, 0, <177, 4059, 1582>, 0, <1846, 4060, 1827>, 0, <1827, 294, 1846>, 0, <4060, 1847, 285>, 0, <285, 1827, 4060>, 0, 
			<286, 1847, 1844>, 0, <1847, 4060, 1844>, 0, <311, 1844, 4060>, 0, <4060, 1846, 311>, 0, <285, 1856, 1827>, 0, <1856, 4061, 1827>, 0, <294, 1827, 4061>, 0, <4061, 1861, 294>, 0, <1861, 4061, 1842>, 0, <1842, 309, 1861>, 0, <4061, 1856, 284>, 0, 
			<284, 1842, 4061>, 0, <1859, 4062, 1841>, 0, <1841, 308, 1859>, 0, <4062, 1848, 283>, 0, <283, 1841, 4062>, 0, <284, 1848, 1842>, 0, <1848, 4062, 1842>, 0, <309, 1842, 4062>, 0, <4062, 1859, 309>, 0, <1864, 4063, 1840>, 0, <1840, 307, 1864>, 0, 
			<1840, 4063, 1866>, 0, <1840, 1866, 282>, 0, <283, 1866, 4063>, 0, <4063, 1841, 283>, 0, <308, 1841, 4063>, 0, <4063, 1864, 308>, 0, <1874, 4064, 1839>, 0, <1839, 306, 1874>, 0, <1839, 4064, 1855>, 0, <1839, 1855, 281>, 0, <282, 1855, 4064>, 0, 
			<4064, 1840, 282>, 0, <307, 1840, 4064>, 0, <4064, 1874, 307>, 0, <305, 1876, 4065>, 0, <305, 4065, 1838>, 0, <1838, 4065, 280>, 0, <4065, 1845, 280>, 0, <281, 1845, 4065>, 0, <4065, 1839, 281>, 0, <1839, 4065, 1876>, 0, <1876, 306, 1839>, 0, 
			<304, 1851, 4066>, 0, <304, 4066, 1837>, 0, <1837, 4066, 279>, 0, <4066, 1852, 279>, 0, <1852, 4066, 1838>, 0, <1838, 280, 1852>, 0, <1838, 4066, 1851>, 0, <1851, 305, 1838>, 0, <303, 1868, 4067>, 0, <303, 4067, 1836>, 0, <1836, 4067, 1853>, 0, 
			<1836, 1853, 278>, 0, <279, 1853, 4067>, 0, <4067, 1837, 279>, 0, <1837, 4067, 1868>, 0, <1868, 304, 1837>, 0, <302, 1877, 4068>, 0, <302, 4068, 1835>, 0, <1835, 4068, 1879>, 0, <1835, 1879, 277>, 0, <278, 1879, 4068>, 0, <4068, 1836, 278>, 0, 
			<1836, 4068, 1877>, 0, <1877, 303, 1836>, 0, <277, 1878, 4069>, 0, <4069, 1835, 277>, 0, <1835, 4069, 1854>, 0, <1854, 302, 1835>, 0, <310, 1854, 1843>, 0, <1854, 4069, 1843>, 0, <1843, 4069, 1878>, 0, <1843, 1878, 276>, 0, <301, 1873, 1834>, 0, 
			<1873, 4070, 1834>, 0, <1834, 4070, 293>, 0, <4070, 1858, 293>, 0, <1858, 4070, 1843>, 0, <1843, 276, 1858>, 0, <310, 1843, 4070>, 0, <310, 4070, 1873>, 0, <300, 1857, 1833>, 0, <1857, 4071, 1833>, 0, <1833, 4071, 292>, 0, <4071, 1870, 292>, 0, 
			<1870, 4071, 1834>, 0, <1834, 293, 1870>, 0, <301, 1834, 4071>, 0, <301, 4071, 1857>, 0, <299, 1872, 1832>, 0, <1872, 4072, 1832>, 0, <1832, 4072, 1863>, 0, <1863, 291, 1832>, 0, <292, 1863, 4072>, 0, <292, 4072, 1833>, 0, <300, 1833, 4072>, 0, 
			<300, 4072, 1872>, 0, <298, 1862, 1831>, 0, <1862, 4073, 1831>, 0, <4073, 1867, 290>, 0, <290, 1831, 4073>, 0, <291, 1867, 4073>, 0, <291, 4073, 1832>, 0, <299, 1832, 4073>, 0, <299, 4073, 1862>, 0, <297, 1869, 4074>, 0, <4074, 1830, 297>, 0, 
			<4074, 1875, 289>, 0, <289, 1830, 4074>, 0, <290, 1875, 1831>, 0, <1875, 4074, 1831>, 0, <298, 1831, 1869>, 0, <1831, 4074, 1869>, 0, <296, 1860, 4075>, 0, <4075, 1829, 296>, 0, <4075, 1880, 288>, 0, <288, 1829, 4075>, 0, <289, 1880, 1830>, 0, 
			<1880, 4075, 1830>, 0, <297, 1830, 1860>, 0, <1830, 4075, 1860>, 0, <295, 1849, 4076>, 0, <4076, 1828, 295>, 0, <1828, 4076, 1871>, 0, <1871, 287, 1828>, 0, <288, 1871, 4076>, 0, <288, 4076, 1829>, 0, <296, 1829, 1849>, 0, <1829, 4076, 1849>, 0, 
			<287, 1865, 4077>, 0, <287, 4077, 1828>, 0, <295, 1828, 1850>, 0, <1828, 4077, 1850>, 0, <311, 1850, 4077>, 0, <4077, 1844, 311>, 0, <1844, 4077, 1865>, 0, <1865, 286, 1844>, 0, <1577, 4078, 170>, 0, <4078, 1576, 170>, 0, <1576, 4078, 1897>, 0, 
			<1897, 169, 1576>, 0, <308, 1897, 4078>, 0, <308, 4078, 1859>, 0, <1859, 4078, 1898>, 0, <1859, 1898, 309>, 0, <171, 1898, 4078>, 0, <4078, 1577, 171>, 0, <4079, 1570, 164>, 0, <164, 1571, 4079>, 0, <4079, 1901, 163>, 0, <163, 1570, 4079>, 0, 
			<1901, 4079, 1876>, 0, <1901, 1876, 305>, 0, <1876, 4079, 1895>, 0, <1876, 1895, 306>, 0, <165, 1895, 4079>, 0, <165, 4079, 1571>, 0, <4080, 1568, 162>, 0, <162, 1569, 4080>, 0, <4080, 1900, 161>, 0, <161, 1568, 4080>, 0, <1900, 4080, 1851>, 0, 
			<1900, 1851, 304>, 0, <1851, 4080, 1901>, 0, <1851, 1901, 305>, 0, <163, 1901, 4080>, 0, <163, 4080, 1569>, 0, <1575, 4081, 168>, 0, <4081, 1574, 168>, 0, <167, 1574, 4081>, 0, <167, 4081, 1896>, 0, <1896, 4081, 1864>, 0, <1896, 1864, 307>, 0, 
			<1864, 4081, 1897>, 0, <1864, 1897, 308>, 0, <169, 1897, 4081>, 0, <4081, 1575, 169>, 0, <156, 1902, 4082>, 0, <4082, 1563, 156>, 0, <1563, 4082, 1578>, 0, <1563, 1578, 172>, 0, <1578, 4082, 1898>, 0, <1898, 171, 1578>, 0, <309, 1898, 4082>, 0, 
			<309, 4082, 1861>, 0, <1861, 4082, 1902>, 0, <1861, 1902, 294>, 0, <1573, 4083, 166>, 0, <4083, 1572, 166>, 0, <165, 1572, 4083>, 0, <165, 4083, 1895>, 0, <306, 1895, 1874>, 0, <1895, 4083, 1874>, 0, <1874, 4083, 1896>, 0, <1874, 1896, 307>, 0, 
			<167, 1896, 4083>, 0, <4083, 1573, 167>, 0, <4084, 1566, 160>, 0, <160, 1567, 4084>, 0, <4084, 1899, 159>, 0, <159, 1566, 4084>, 0, <303, 1899, 1868>, 0, <1899, 4084, 1868>, 0, <304, 1868, 4084>, 0, <304, 4084, 1900>, 0, <1900, 4084, 1567>, 0, 
			<1567, 161, 1900>, 0, <1565, 4085, 1564>, 0, <1565, 1564, 158>, 0, <4085, 1903, 157>, 0, <157, 1564, 4085>, 0, <302, 1903, 1877>, 0, <1903, 4085, 1877>, 0, <303, 1877, 4085>, 0, <303, 4085, 1899>, 0, <1899, 4085, 1565>, 0, <1565, 159, 1899>, 0, 
			<145, 1774, 4086>, 0, <4086, 1541, 145>, 0, <1541, 4086, 1775>, 0, <1775, 146, 1541>, 0, <4086, 1791, 266>, 0, <266, 1775, 4086>, 0, <1791, 4086, 1774>, 0, <1791, 1774, 265>, 0, <1784, 4087, 1561>, 0, <1561, 155, 1784>, 0, <138, 1561, 4087>, 0, 
			<138, 4087, 1767>, 0, <1767, 4087, 1792>, 0, <1767, 1792, 258>, 0, <1792, 4087, 275>, 0, <4087, 1784, 275>, 0, <142, 1771, 4088>, 0, <4088, 1535, 142>, 0, <1535, 4088, 1772>, 0, <1772, 143, 1535>, 0, <4088, 1793, 263>, 0, <263, 1772, 4088>, 0, 
			<1793, 4088, 1771>, 0, <1793, 1771, 262>, 0, <144, 1773, 4089>, 0, <4089, 1539, 144>, 0, <1539, 4089, 1774>, 0, <1774, 145, 1539>, 0, <4089, 1794, 265>, 0, <265, 1774, 4089>, 0, <1794, 4089, 1773>, 0, <1794, 1773, 264>, 0, <173, 1881, 4090>, 0, 
			<4090, 1595, 173>, 0, <1595, 4090, 1902>, 0, <1902, 156, 1595>, 0, <4090, 1846, 294>, 0, <294, 1902, 4090>, 0, <1846, 4090, 1881>, 0, <1846, 1881, 311>, 0, <1781, 4091, 1555>, 0, <1555, 152, 1781>, 0, <153, 1555, 4091>, 0, <153, 4091, 1782>, 0, 
			<1782, 4091, 1795>, 0, <1782, 1795, 273>, 0, <1795, 4091, 272>, 0, <4091, 1781, 272>, 0, <1783, 4092, 1559>, 0, <1559, 154, 1783>, 0, <155, 1559, 4092>, 0, <155, 4092, 1784>, 0, <1784, 4092, 1796>, 0, <1784, 1796, 275>, 0, <1796, 4092, 274>, 0, 
			<4092, 1783, 274>, 0, <147, 1776, 4093>, 0, <147, 4093, 1545>, 0, <148, 1545, 1777>, 0, <1545, 4093, 1777>, 0, <1777, 4093, 268>, 0, <4093, 1797, 268>, 0, <1797, 4093, 1776>, 0, <1776, 267, 1797>, 0, <1779, 4094, 1551>, 0, <1551, 150, 1779>, 0, 
			<151, 1551, 4094>, 0, <151, 4094, 1780>, 0, <1780, 4094, 1798>, 0, <1780, 1798, 271>, 0, <1798, 4094, 270>, 0, <4094, 1779, 270>, 0, <1782, 4095, 1557>, 0, <1557, 153, 1782>, 0, <154, 1557, 4095>, 0, <154, 4095, 1783>, 0, <1783, 4095, 1799>, 0, 
			<1783, 1799, 274>, 0, <1799, 4095, 273>, 0, <4095, 1782, 273>, 0, <1778, 4096, 1549>, 0, <1549, 149, 1778>, 0, <150, 1549, 4096>, 0, <150, 4096, 1779>, 0, <1779, 4096, 1800>, 0, <1779, 1800, 270>, 0, <1800, 4096, 269>, 0, <4096, 1778, 269>, 0, 
			<140, 1769, 4097>, 0, <4097, 1531, 140>, 0, <1531, 4097, 1770>, 0, <1770, 141, 1531>, 0, <4097, 1801, 261>, 0, <261, 1770, 4097>, 0, <1801, 4097, 1769>, 0, <1801, 1769, 260>, 0, <138, 1767, 4098>, 0, <4098, 1527, 138>, 0, <1527, 4098, 1768>, 0, 
			<1768, 139, 1527>, 0, <4098, 1802, 259>, 0, <259, 1768, 4098>, 0, <1802, 4098, 1767>, 0, <1802, 1767, 258>, 0, <141, 1770, 4099>, 0, <4099, 1533, 141>, 0, <1533, 4099, 1771>, 0, <1771, 142, 1533>, 0, <4099, 1803, 262>, 0, <262, 1771, 4099>, 0, 
			<1803, 4099, 1770>, 0, <1803, 1770, 261>, 0, <146, 1775, 4100>, 0, <4100, 1543, 146>, 0, <1543, 4100, 1776>, 0, <1776, 147, 1543>, 0, <4100, 1804, 267>, 0, <267, 1776, 4100>, 0, <1804, 4100, 1775>, 0, <1804, 1775, 266>, 0, <143, 1772, 4101>, 0, 
			<4101, 1537, 143>, 0, <1537, 4101, 1773>, 0, <1773, 144, 1537>, 0, <4101, 1805, 264>, 0, <264, 1773, 4101>, 0, <1805, 4101, 1772>, 0, <1805, 1772, 263>, 0, <1777, 4102, 1547>, 0, <1547, 148, 1777>, 0, <149, 1547, 4102>, 0, <149, 4102, 1778>, 0, 
			<1778, 4102, 1806>, 0, <1778, 1806, 269>, 0, <1806, 4102, 268>, 0, <4102, 1777, 268>, 0, <1780, 4103, 1553>, 0, <1553, 151, 1780>, 0, <152, 1553, 4103>, 0, <152, 4103, 1781>, 0, <1781, 4103, 1807>, 0, <1781, 1807, 272>, 0, <1807, 4103, 271>, 0, 
			<4103, 1780, 271>, 0, <139, 1768, 4104>, 0, <4104, 1529, 139>, 0, <1529, 4104, 1769>, 0, <1769, 140, 1529>, 0, <4104, 1808, 260>, 0, <260, 1769, 4104>, 0, <1808, 4104, 1768>, 0, <1808, 1768, 259>, 0, <262, 1813, 4105>, 0, <4105, 1793, 262>, 0, 
			<1793, 4105, 1814>, 0, <1814, 263, 1793>, 0, <1814, 4105, 1845>, 0, <1845, 281, 1814>, 0, <1845, 4105, 1813>, 0, <1845, 1813, 280>, 0, <267, 1818, 4106>, 0, <267, 4106, 1797>, 0, <268, 1797, 1819>, 0, <1797, 4106, 1819>, 0, <1819, 4106, 286>, 0, 
			<4106, 1847, 286>, 0, <1847, 4106, 1818>, 0, <1818, 285, 1847>, 0, <265, 1816, 4107>, 0, <4107, 1791, 265>, 0, <1791, 4107, 1817>, 0, <1817, 266, 1791>, 0, <4107, 1848, 284>, 0, <284, 1817, 4107>, 0, <1848, 4107, 1816>, 0, <1848, 1816, 283>, 0, 
			<261, 1812, 4108>, 0, <4108, 1803, 261>, 0, <1803, 4108, 1813>, 0, <1813, 262, 1803>, 0, <4108, 1852, 280>, 0, <280, 1813, 4108>, 0, <1852, 4108, 1812>, 0, <1852, 1812, 279>, 0, <260, 1811, 4109>, 0, <4109, 1801, 260>, 0, <1801, 4109, 1812>, 0, 
			<1812, 261, 1801>, 0, <4109, 1853, 279>, 0, <279, 1812, 4109>, 0, <1853, 4109, 1811>, 0, <1853, 1811, 278>, 0, <263, 1814, 4110>, 0, <4110, 1805, 263>, 0, <1805, 4110, 1815>, 0, <1815, 264, 1805>, 0, <1815, 4110, 1855>, 0, <1855, 282, 1815>, 0, 
			<4110, 1814, 281>, 0, <281, 1855, 4110>, 0, <266, 1817, 4111>, 0, <4111, 1804, 266>, 0, <1804, 4111, 1818>, 0, <1818, 267, 1804>, 0, <1818, 4111, 285>, 0, <4111, 1856, 285>, 0, <1856, 4111, 1817>, 0, <1817, 284, 1856>, 0, <1826, 4112, 1792>, 0, 
			<1792, 275, 1826>, 0, <258, 1792, 4112>, 0, <258, 4112, 1809>, 0, <4112, 1858, 276>, 0, <276, 1809, 4112>, 0, <1858, 4112, 1826>, 0, <1858, 1826, 293>, 0, <1824, 4113, 1799>, 0, <1799, 273, 1824>, 0, <274, 1799, 4113>, 0, <274, 4113, 1825>, 0, 
			<1825, 4113, 1863>, 0, <1825, 1863, 292>, 0, <1863, 4113, 291>, 0, <4113, 1824, 291>, 0, <1819, 4114, 1806>, 0, <1806, 268, 1819>, 0, <269, 1806, 4114>, 0, <269, 4114, 1820>, 0, <1820, 4114, 1865>, 0, <1820, 1865, 287>, 0, <1865, 4114, 286>, 0, 
			<4114, 1819, 286>, 0, <264, 1815, 4115>, 0, <4115, 1794, 264>, 0, <1794, 4115, 1816>, 0, <1816, 265, 1794>, 0, <4115, 1866, 283>, 0, <283, 1816, 4115>, 0, <1866, 4115, 1815>, 0, <1866, 1815, 282>, 0, <1823, 4116, 1795>, 0, <1795, 272, 1823>, 0, 
			<273, 1795, 4116>, 0, <273, 4116, 1824>, 0, <1824, 4116, 1867>, 0, <1824, 1867, 291>, 0, <1867, 4116, 1823>, 0, <1823, 290, 1867>, 0, <1825, 4117, 1796>, 0, <1796, 274, 1825>, 0, <275, 1796, 4117>, 0, <275, 4117, 1826>, 0, <1826, 4117, 1870>, 0, 
			<1826, 1870, 293>, 0, <1870, 4117, 292>, 0, <4117, 1825, 292>, 0, <1820, 4118, 1800>, 0, <1800, 269, 1820>, 0, <270, 1800, 4118>, 0, <270, 4118, 1821>, 0, <1821, 4118, 1871>, 0, <1821, 1871, 288>, 0, <1871, 4118, 287>, 0, <4118, 1820, 287>, 0, 
			<1822, 4119, 1807>, 0, <1807, 271, 1822>, 0, <272, 1807, 4119>, 0, <272, 4119, 1823>, 0, <1823, 4119, 290>, 0, <4119, 1875, 290>, 0, <1875, 4119, 1822>, 0, <1822, 289, 1875>, 0, <258, 1809, 4120>, 0, <4120, 1802, 258>, 0, <1802, 4120, 1810>, 0, 
			<1810, 259, 1802>, 0, <1810, 4120, 1878>, 0, <1878, 277, 1810>, 0, <4120, 1809, 276>, 0, <276, 1878, 4120>, 0, <259, 1810, 4121>, 0, <4121, 1808, 259>, 0, <1808, 4121, 1811>, 0, <1811, 260, 1808>, 0, <1811, 4121, 1879>, 0, <1879, 278, 1811>, 0, 
			<4121, 1810, 277>, 0, <277, 1879, 4121>, 0, <1821, 4122, 1798>, 0, <1798, 270, 1821>, 0, <271, 1798, 4122>, 0, <271, 4122, 1822>, 0, <1822, 4122, 1880>, 0, <1822, 1880, 289>, 0, <1880, 4122, 288>, 0, <4122, 1821, 288>, 0, <1580, 4123, 174>, 0, 
			<4123, 1579, 174>, 0, <1579, 4123, 1881>, 0, <1881, 173, 1579>, 0, <4123, 1850, 311>, 0, <311, 1881, 4123>, 0, <295, 1850, 1785>, 0, <1850, 4123, 1785>, 0, <175, 1785, 4123>, 0, <4123, 1580, 175>, 0, <4124, 1591, 186>, 0, <186, 1592, 4124>, 0, 
			<185, 1591, 4124>, 0, <185, 4124, 1790>, 0, <1790, 4124, 1857>, 0, <1790, 1857, 300>, 0, <1857, 4124, 301>, 0, <4124, 1883, 301>, 0, <1883, 4124, 1592>, 0, <1592, 187, 1883>, 0, <4125, 1342, 42>, 0, <42, 1890, 4125>, 0, <1342, 4125, 1885>, 0, 
			<1342, 1885, 136>, 0, <1885, 4125, 33>, 0, <4125, 1384, 33>, 0, <1384, 4125, 1890>, 0, <1890, 1, 1384>, 0, <1296, 16, 1311>, 0, <1296, 1311, 4126>, 0, <0, 1296, 4126>, 0, <0, 4126, 1891>, 0, <34, 1891, 1350>, 0, <1891, 4126, 1350>, 0, 
			<49, 1350, 4126>, 0, <49, 4126, 1892>, 0, <1892, 4126, 1311>, 0, <1311, 15, 1892>, 0, <7, 1887, 4127>, 0, <4127, 1303, 7>, 0, <1303, 4127, 8>, 0, <4127, 1304, 8>, 0, <9, 1304, 4127>, 0, <9, 4127, 1886>, 0, <1886, 4127, 1346>, 0, 
			<1886, 1346, 46>, 0, <1346, 4127, 1887>, 0, <1346, 1887, 45>, 0, <5, 1888, 4128>, 0, <4128, 1301, 5>, 0, <1301, 4128, 6>, 0, <4128, 1302, 6>, 0, <7, 1302, 4128>, 0, <7, 4128, 1887>, 0, <1887, 4128, 1345>, 0, <1887, 1345, 45>, 0, 
			<1345, 4128, 1888>, 0, <1345, 1888, 44>, 0, <3, 1889, 4129>, 0, <4129, 1299, 3>, 0, <1299, 4129, 4>, 0, <4129, 1300, 4>, 0, <1300, 4129, 1888>, 0, <1888, 5, 1300>, 0, <44, 1888, 4129>, 0, <44, 4129, 1344>, 0, <1344, 4129, 1889>, 0, 
			<1344, 1889, 43>, 0, <1, 1890, 4130>, 0, <4130, 1297, 1>, 0, <1297, 4130, 1298>, 0, <1297, 1298, 2>, 0, <1298, 4130, 1889>, 0, <1889, 3, 1298>, 0, <43, 1889, 4130>, 0, <43, 4130, 1343>, 0, <1343, 4130, 1890>, 0, <1343, 1890, 42>, 0, 
			<1891, 4131, 1383>, 0, <1383, 0, 1891>, 0, <4131, 1884, 17>, 0, <17, 1383, 4131>, 0, <1884, 4131, 1524>, 0, <1884, 1524, 137>, 0, <1524, 4131, 34>, 0, <4131, 1891, 34>, 0, <1893, 4132, 1309>, 0, <1309, 13, 1893>, 0, <4132, 1310, 14>, 0, 
			<14, 1309, 4132>, 0, <4132, 1892, 15>, 0, <15, 1310, 4132>, 0, <1892, 4132, 1349>, 0, <1892, 1349, 49>, 0, <48, 1349, 4132>, 0, <48, 4132, 1893>, 0, <11, 1894, 4133>, 0, <11, 4133, 1307>, 0, <4133, 1308, 12>, 0, <12, 1307, 4133>, 0, 
			<4133, 1893, 13>, 0, <13, 1308, 4133>, 0, <1893, 4133, 1348>, 0, <1893, 1348, 48>, 0, <1348, 4133, 1894>, 0, <1348, 1894, 47>, 0, <9, 1886, 4134>, 0, <9, 4134, 1305>, 0, <4134, 1306, 10>, 0, <10, 1305, 4134>, 0, <4134, 1894, 11>, 0, 
			<11, 1306, 4134>, 0, <1894, 4134, 1347>, 0, <1894, 1347, 47>, 0, <1347, 4134, 1886>, 0, <1347, 1886, 46>, 0, <1903, 4135, 1596>, 0, <1596, 157, 1903>, 0, <4135, 1882, 189>, 0, <189, 1596, 4135>, 0, <1882, 4135, 1854>, 0, <1882, 1854, 310>, 0, 
			<1854, 4135, 302>, 0, <4135, 1903, 302>, 0, <2492, 4136, 1920>, 0, <1920, 329, 2492>, 0, <4136, 1921, 330>, 0, <330, 1920, 4136>, 0, <4136, 1937, 331>, 0, <331, 1921, 4136>, 0, <1937, 4136, 1936>, 0, <1937, 1936, 347>, 0, <1936, 4136, 449>, 0, 
			<4136, 2492, 449>, 0, <1937, 4137, 1922>, 0, <1922, 331, 1937>, 0, <4137, 1923, 332>, 0, <332, 1922, 4137>, 0, <333, 1923, 4137>, 0, <333, 4137, 1939>, 0, <1939, 4137, 1938>, 0, <1939, 1938, 348>, 0, <347, 1938, 4137>, 0, <4137, 1937, 347>, 0, 
			<1924, 333, 1939>, 0, <1924, 1939, 4138>, 0, <334, 1924, 4138>, 0, <334, 4138, 1925>, 0, <335, 1925, 4138>, 0, <335, 4138, 1941>, 0, <1941, 4138, 1940>, 0, <1941, 1940, 349>, 0, <348, 1940, 4138>, 0, <348, 4138, 1939>, 0, <1926, 335, 1941>, 0, 
			<1926, 1941, 4139>, 0, <336, 1926, 4139>, 0, <336, 4139, 1927>, 0, <1927, 4139, 1943>, 0, <1927, 1943, 337>, 0, <1943, 4139, 1942>, 0, <1943, 1942, 350>, 0, <349, 1942, 4139>, 0, <349, 4139, 1941>, 0, <1928, 337, 1943>, 0, <1928, 1943, 4140>, 0, 
			<338, 1928, 4140>, 0, <338, 4140, 1929>, 0, <1929, 4140, 1945>, 0, <1929, 1945, 339>, 0, <351, 1945, 4140>, 0, <351, 4140, 1944>, 0, <1943, 350, 1944>, 0, <1943, 1944, 4140>, 0, <339, 1945, 4141>, 0, <339, 4141, 1930>, 0, <340, 1930, 4141>, 0, 
			<340, 4141, 1931>, 0, <1931, 4141, 1947>, 0, <1931, 1947, 341>, 0, <352, 1947, 4141>, 0, <352, 4141, 1946>, 0, <1945, 351, 1946>, 0, <1945, 1946, 4141>, 0, <341, 1947, 4142>, 0, <341, 4142, 1932>, 0, <1932, 4142, 342>, 0, <4142, 1933, 342>, 0, 
			<1933, 4142, 1949>, 0, <1949, 343, 1933>, 0, <4142, 1948, 353>, 0, <353, 1949, 4142>, 0, <352, 1948, 1947>, 0, <1948, 4142, 1947>, 0, <343, 1949, 4143>, 0, <4143, 1934, 343>, 0, <1934, 4143, 344>, 0, <4143, 1935, 344>, 0, <1935, 4143, 2493>, 0, 
			<2493, 345, 1935>, 0, <448, 2493, 4143>, 0, <448, 4143, 2131>, 0, <353, 2131, 1949>, 0, <2131, 4143, 1949>, 0, <449, 2133, 4144>, 0, <449, 4144, 1936>, 0, <1936, 4144, 1961>, 0, <1936, 1961, 347>, 0, <1961, 4144, 363>, 0, <4144, 1960, 363>, 0, 
			<1960, 4144, 2133>, 0, <2133, 447, 1960>, 0, <347, 1961, 4145>, 0, <347, 4145, 1938>, 0, <1938, 4145, 1963>, 0, <1938, 1963, 348>, 0, <1963, 4145, 364>, 0, <4145, 1962, 364>, 0, <1962, 4145, 1961>, 0, <1961, 363, 1962>, 0, <348, 1963, 4146>, 0, 
			<348, 4146, 1940>, 0, <1940, 4146, 1965>, 0, <1940, 1965, 349>, 0, <1965, 4146, 1964>, 0, <1965, 1964, 365>, 0, <364, 1964, 4146>, 0, <4146, 1963, 364>, 0, <349, 1965, 4147>, 0, <349, 4147, 1942>, 0, <1942, 4147, 1967>, 0, <1942, 1967, 350>, 0, 
			<1967, 4147, 1966>, 0, <1967, 1966, 366>, 0, <365, 1966, 4147>, 0, <4147, 1965, 365>, 0, <350, 1967, 1944>, 0, <1967, 4148, 1944>, 0, <1944, 4148, 351>, 0, <4148, 1969, 351>, 0, <1969, 4148, 367>, 0, <4148, 1968, 367>, 0, <1968, 4148, 1967>, 0, 
			<1967, 366, 1968>, 0, <351, 1969, 1946>, 0, <1969, 4149, 1946>, 0, <1946, 4149, 352>, 0, <4149, 1971, 352>, 0, <1971, 4149, 368>, 0, <4149, 1970, 368>, 0, <1970, 4149, 1969>, 0, <1969, 367, 1970>, 0, <352, 1971, 1948>, 0, <1971, 4150, 1948>, 0, 
			<1948, 4150, 353>, 0, <4150, 1973, 353>, 0, <1973, 4150, 1972>, 0, <1972, 369, 1973>, 0, <368, 1972, 4150>, 0, <368, 4150, 1971>, 0, <448, 2134, 4151>, 0, <4151, 1950, 448>, 0, <1950, 4151, 1975>, 0, <1975, 354, 1950>, 0, <4151, 1974, 370>, 0, 
			<370, 1975, 4151>, 0, <1974, 4151, 2134>, 0, <1974, 2134, 446>, 0, <354, 1975, 4152>, 0, <4152, 1951, 354>, 0, <1951, 4152, 1977>, 0, <1977, 355, 1951>, 0, <4152, 1976, 371>, 0, <371, 1977, 4152>, 0, <370, 1976, 1975>, 0, <1976, 4152, 1975>, 0, 
			<355, 1977, 4153>, 0, <4153, 1952, 355>, 0, <1952, 4153, 1979>, 0, <1979, 356, 1952>, 0, <4153, 1978, 372>, 0, <372, 1979, 4153>, 0, <371, 1978, 1977>, 0, <1978, 4153, 1977>, 0, <356, 1979, 4154>, 0, <4154, 1953, 356>, 0, <1953, 4154, 1981>, 0, 
			<1981, 357, 1953>, 0, <1981, 4154, 1980>, 0, <1980, 373, 1981>, 0, <372, 1980, 4154>, 0, <372, 4154, 1979>, 0, <357, 1981, 4155>, 0, <4155, 1954, 357>, 0, <1954, 4155, 1983>, 0, <1983, 358, 1954>, 0, <1983, 4155, 1982>, 0, <1982, 374, 1983>, 0, 
			<373, 1982, 4155>, 0, <373, 4155, 1981>, 0, <1983, 4156, 1955>, 0, <1955, 358, 1983>, 0, <4156, 1985, 359>, 0, <359, 1955, 4156>, 0, <4156, 1984, 375>, 0, <375, 1985, 4156>, 0, <374, 1984, 1983>, 0, <1984, 4156, 1983>, 0, <1985, 4157, 1956>, 0, 
			<1956, 359, 1985>, 0, <4157, 1987, 360>, 0, <360, 1956, 4157>, 0, <4157, 1986, 376>, 0, <376, 1987, 4157>, 0, <375, 1986, 1985>, 0, <1986, 4157, 1985>, 0, <1987, 4158, 1957>, 0, <1957, 360, 1987>, 0, <4158, 1989, 361>, 0, <361, 1957, 4158>, 0, 
			<1989, 4158, 1988>, 0, <1989, 1988, 377>, 0, <376, 1988, 4158>, 0, <4158, 1987, 376>, 0, <1989, 4159, 1958>, 0, <1958, 361, 1989>, 0, <4159, 1959, 346>, 0, <346, 1958, 4159>, 0, <1959, 4159, 1990>, 0, <1959, 1990, 362>, 0, <377, 1990, 4159>, 0, 
			<4159, 1989, 377>, 0, <411, 2060, 2026>, 0, <2060, 4160, 2026>, 0, <2026, 4160, 395>, 0, <4160, 2045, 395>, 0, <2045, 4160, 2061>, 0, <2045, 2061, 429>, 0, <444, 2061, 2060>, 0, <2061, 4160, 2060>, 0, <409, 2059, 4161>, 0, <409, 4161, 2025>, 0, 
			<2025, 4161, 2027>, 0, <2025, 2027, 410>, 0, <2027, 4161, 2062>, 0, <2027, 2062, 445>, 0, <443, 2062, 4161>, 0, <4161, 2059, 443>, 0, <2058, 4162, 2024>, 0, <2024, 408, 2058>, 0, <2024, 4162, 2059>, 0, <2024, 2059, 409>, 0, <2059, 4162, 2063>, 0, 
			<2059, 2063, 443>, 0, <442, 2063, 4162>, 0, <4162, 2058, 442>, 0, <2057, 4163, 2023>, 0, <2023, 407, 2057>, 0, <4163, 2058, 408>, 0, <408, 2023, 4163>, 0, <2058, 4163, 2064>, 0, <2058, 2064, 442>, 0, <441, 2064, 4163>, 0, <4163, 2057, 441>, 0, 
			<2056, 4164, 2022>, 0, <2022, 406, 2056>, 0, <4164, 2057, 407>, 0, <407, 2022, 4164>, 0, <2057, 4164, 2065>, 0, <2057, 2065, 441>, 0, <440, 2065, 4164>, 0, <4164, 2056, 440>, 0, <2055, 4165, 2021>, 0, <2021, 405, 2055>, 0, <4165, 2056, 406>, 0, 
			<406, 2021, 4165>, 0, <2056, 4165, 2066>, 0, <2056, 2066, 440>, 0, <439, 2066, 4165>, 0, <4165, 2055, 439>, 0, <2054, 4166, 2020>, 0, <2020, 404, 2054>, 0, <4166, 2055, 405>, 0, <405, 2020, 4166>, 0, <2055, 4166, 2067>, 0, <2055, 2067, 439>, 0, 
			<438, 2067, 4166>, 0, <4166, 2054, 438>, 0, <2053, 4167, 2019>, 0, <2019, 403, 2053>, 0, <4167, 2054, 404>, 0, <404, 2019, 4167>, 0, <2054, 4167, 2068>, 0, <2054, 2068, 438>, 0, <437, 2068, 4167>, 0, <4167, 2053, 437>, 0, <402, 2052, 4168>, 0, 
			<402, 4168, 2018>, 0, <4168, 2053, 403>, 0, <403, 2018, 4168>, 0, <2053, 4168, 2069>, 0, <2053, 2069, 437>, 0, <436, 2069, 4168>, 0, <4168, 2052, 436>, 0, <401, 2051, 4169>, 0, <401, 4169, 2017>, 0, <2017, 4169, 2052>, 0, <2017, 2052, 402>, 0, 
			<2052, 4169, 2070>, 0, <2052, 2070, 436>, 0, <435, 2070, 4169>, 0, <4169, 2051, 435>, 0, <400, 2050, 4170>, 0, <400, 4170, 2016>, 0, <2016, 4170, 2051>, 0, <2016, 2051, 401>, 0, <2051, 4170, 2071>, 0, <2051, 2071, 435>, 0, <434, 2071, 4170>, 0, 
			<4170, 2050, 434>, 0, <2049, 4171, 2015>, 0, <2015, 399, 2049>, 0, <4171, 2050, 400>, 0, <400, 2015, 4171>, 0, <2050, 4171, 2072>, 0, <2050, 2072, 434>, 0, <433, 2072, 4171>, 0, <4171, 2049, 433>, 0, <2048, 4172, 2014>, 0, <2014, 398, 2048>, 0, 
			<4172, 2049, 399>, 0, <399, 2014, 4172>, 0, <2049, 4172, 2073>, 0, <2049, 2073, 433>, 0, <432, 2073, 4172>, 0, <4172, 2048, 432>, 0, <2047, 4173, 2013>, 0, <2013, 397, 2047>, 0, <4173, 2048, 398>, 0, <398, 2013, 4173>, 0, <2048, 4173, 2074>, 0, 
			<2048, 2074, 432>, 0, <431, 2074, 4173>, 0, <4173, 2047, 431>, 0, <2046, 4174, 2012>, 0, <2012, 396, 2046>, 0, <4174, 2047, 397>, 0, <397, 2012, 4174>, 0, <2047, 4174, 2075>, 0, <2047, 2075, 431>, 0, <430, 2075, 4174>, 0, <4174, 2046, 430>, 0, 
			<395, 2045, 2011>, 0, <2045, 4175, 2011>, 0, <2011, 4175, 396>, 0, <4175, 2046, 396>, 0, <2046, 4175, 2076>, 0, <2046, 2076, 430>, 0, <429, 2076, 4175>, 0, <4175, 2045, 429>, 0, <393, 2043, 4176>, 0, <4176, 2009, 393>, 0, <2009, 4176, 2044>, 0, 
			<2044, 394, 2009>, 0, <4176, 2077, 428>, 0, <428, 2044, 4176>, 0, <427, 2077, 2043>, 0, <2077, 4176, 2043>, 0, <392, 2042, 4177>, 0, <4177, 2008, 392>, 0, <2008, 4177, 2043>, 0, <2043, 393, 2008>, 0, <4177, 2078, 427>, 0, <427, 2043, 4177>, 0, 
			<426, 2078, 2042>, 0, <2078, 4177, 2042>, 0, <391, 2041, 4178>, 0, <4178, 2007, 391>, 0, <2007, 4178, 2042>, 0, <2042, 392, 2007>, 0, <4178, 2079, 426>, 0, <426, 2042, 4178>, 0, <425, 2079, 2041>, 0, <2079, 4178, 2041>, 0, <390, 2040, 4179>, 0, 
			<4179, 2006, 390>, 0, <2006, 4179, 2041>, 0, <2041, 391, 2006>, 0, <4179, 2080, 425>, 0, <425, 2041, 4179>, 0, <424, 2080, 2040>, 0, <2080, 4179, 2040>, 0, <389, 2039, 4180>, 0, <4180, 2005, 389>, 0, <2005, 4180, 2040>, 0, <2040, 390, 2005>, 0, 
			<4180, 2081, 424>, 0, <424, 2040, 4180>, 0, <423, 2081, 2039>, 0, <2081, 4180, 2039>, 0, <388, 2038, 4181>, 0, <4181, 2004, 388>, 0, <2004, 4181, 2039>, 0, <2039, 389, 2004>, 0, <4181, 2082, 423>, 0, <423, 2039, 4181>, 0, <422, 2082, 2038>, 0, 
			<2082, 4181, 2038>, 0, <387, 2037, 2003>, 0, <2037, 4182, 2003>, 0, <2003, 4182, 388>, 0, <4182, 2038, 388>, 0, <4182, 2083, 422>, 0, <422, 2038, 4182>, 0, <421, 2083, 2037>, 0, <2083, 4182, 2037>, 0, <386, 2036, 2002>, 0, <2036, 4183, 2002>, 0, 
			<2002, 4183, 387>, 0, <4183, 2037, 387>, 0, <4183, 2084, 421>, 0, <421, 2037, 4183>, 0, <420, 2084, 2036>, 0, <2084, 4183, 2036>, 0, <385, 2035, 4184>, 0, <4184, 2001, 385>, 0, <2001, 4184, 386>, 0, <4184, 2036, 386>, 0, <4184, 2085, 420>, 0, 
			<420, 2036, 4184>, 0, <419, 2085, 2035>, 0, <2085, 4184, 2035>, 0, <384, 2034, 4185>, 0, <4185, 2000, 384>, 0, <2000, 4185, 2035>, 0, <2035, 385, 2000>, 0, <4185, 2086, 419>, 0, <419, 2035, 4185>, 0, <418, 2086, 2034>, 0, <2086, 4185, 2034>, 0, 
			<383, 2033, 4186>, 0, <4186, 1999, 383>, 0, <1999, 4186, 2034>, 0, <2034, 384, 1999>, 0, <4186, 2087, 418>, 0, <418, 2034, 4186>, 0, <417, 2087, 2033>, 0, <2087, 4186, 2033>, 0, <382, 2032, 4187>, 0, <4187, 1998, 382>, 0, <1998, 4187, 2033>, 0, 
			<2033, 383, 1998>, 0, <4187, 2088, 417>, 0, <417, 2033, 4187>, 0, <416, 2088, 2032>, 0, <2088, 4187, 2032>, 0, <381, 2031, 4188>, 0, <4188, 1997, 381>, 0, <1997, 4188, 2032>, 0, <2032, 382, 1997>, 0, <4188, 2089, 416>, 0, <416, 2032, 4188>, 0, 
			<415, 2089, 2031>, 0, <2089, 4188, 2031>, 0, <380, 2030, 4189>, 0, <4189, 1996, 380>, 0, <1996, 4189, 2031>, 0, <2031, 381, 1996>, 0, <4189, 2090, 415>, 0, <415, 2031, 4189>, 0, <414, 2090, 2030>, 0, <2090, 4189, 2030>, 0, <2029, 4190, 1995>, 0, 
			<1995, 379, 2029>, 0, <1995, 4190, 2030>, 0, <2030, 380, 1995>, 0, <4190, 2091, 414>, 0, <414, 2030, 4190>, 0, <413, 2091, 2029>, 0, <2091, 4190, 2029>, 0, <2028, 4191, 1993>, 0, <1993, 378, 2028>, 0, <4191, 2029, 379>, 0, <379, 1993, 4191>, 0, 
			<4191, 2092, 413>, 0, <413, 2029, 4191>, 0, <2092, 4191, 2028>, 0, <2028, 412, 2092>, 0, <4192, 1994, 410>, 0, <410, 2027, 4192>, 0, <1994, 4192, 2028>, 0, <1994, 2028, 378>, 0, <2028, 4192, 412>, 0, <4192, 2093, 412>, 0, <2093, 4192, 2027>, 0, 
			<2027, 445, 2093>, 0, <394, 2044, 2010>, 0, <2044, 4193, 2010>, 0, <2010, 4193, 411>, 0, <4193, 2060, 411>, 0, <2060, 4193, 2094>, 0, <2094, 444, 2060>, 0, <428, 2094, 2044>, 0, <2094, 4193, 2044>, 0, <2308, 4194, 2062>, 0, <2062, 443, 2308>, 0, 
			<445, 2062, 2340>, 0, <2062, 4194, 2340>, 0, <569, 2340, 4194>, 0, <4194, 2274, 569>, 0, <567, 2274, 4194>, 0, <4194, 2308, 567>, 0, <2096, 4195, 1935>, 0, <1935, 345, 2096>, 0, <344, 1935, 4195>, 0, <344, 4195, 2095>, 0, <379, 2095, 1993>, 0, 
			<2095, 4195, 1993>, 0, <1993, 4195, 378>, 0, <4195, 2096, 378>, 0, <313, 2097, 4196>, 0, <313, 4196, 1992>, 0, <345, 1992, 4196>, 0, <345, 4196, 2096>, 0, <1994, 378, 2096>, 0, <1994, 2096, 4196>, 0, <1994, 4196, 2097>, 0, <2097, 410, 1994>, 0, 
			<314, 2098, 4197>, 0, <314, 4197, 1905>, 0, <313, 1905, 2097>, 0, <1905, 4197, 2097>, 0, <410, 2097, 4197>, 0, <4197, 2025, 410>, 0, <2025, 4197, 2098>, 0, <2098, 409, 2025>, 0, <315, 2099, 4198>, 0, <315, 4198, 1906>, 0, <314, 1906, 2098>, 0, 
			<1906, 4198, 2098>, 0, <409, 2098, 4198>, 0, <4198, 2024, 409>, 0, <2024, 4198, 2099>, 0, <2099, 408, 2024>, 0, <316, 2100, 4199>, 0, <316, 4199, 1907>, 0, <315, 1907, 2099>, 0, <1907, 4199, 2099>, 0, <408, 2099, 4199>, 0, <4199, 2023, 408>, 0, 
			<2023, 4199, 2100>, 0, <2100, 407, 2023>, 0, <317, 2101, 4200>, 0, <317, 4200, 1908>, 0, <316, 1908, 2100>, 0, <1908, 4200, 2100>, 0, <407, 2100, 4200>, 0, <4200, 2022, 407>, 0, <2022, 4200, 2101>, 0, <2101, 406, 2022>, 0, <318, 2102, 4201>, 0, 
			<318, 4201, 1909>, 0, <317, 1909, 2101>, 0, <1909, 4201, 2101>, 0, <406, 2101, 2021>, 0, <2101, 4201, 2021>, 0, <2021, 4201, 405>, 0, <4201, 2102, 405>, 0, <319, 2103, 4202>, 0, <319, 4202, 1910>, 0, <318, 1910, 2102>, 0, <1910, 4202, 2102>, 0, 
			<405, 2102, 2020>, 0, <2102, 4202, 2020>, 0, <2020, 4202, 404>, 0, <4202, 2103, 404>, 0, <320, 2104, 4203>, 0, <320, 4203, 1911>, 0, <319, 1911, 2103>, 0, <1911, 4203, 2103>, 0, <404, 2103, 2019>, 0, <2103, 4203, 2019>, 0, <2019, 4203, 403>, 0, 
			<4203, 2104, 403>, 0, <321, 2105, 4204>, 0, <321, 4204, 1912>, 0, <320, 1912, 2104>, 0, <1912, 4204, 2104>, 0, <403, 2104, 2018>, 0, <2104, 4204, 2018>, 0, <2018, 4204, 2105>, 0, <2105, 402, 2018>, 0, <322, 2106, 1913>, 0, <2106, 4205, 1913>, 0, 
			<321, 1913, 4205>, 0, <4205, 2105, 321>, 0, <402, 2105, 4205>, 0, <4205, 2017, 402>, 0, <2017, 4205, 2106>, 0, <2106, 401, 2017>, 0, <323, 2107, 1914>, 0, <2107, 4206, 1914>, 0, <322, 1914, 4206>, 0, <4206, 2106, 322>, 0, <401, 2106, 4206>, 0, 
			<4206, 2016, 401>, 0, <2016, 4206, 2107>, 0, <2107, 400, 2016>, 0, <324, 2108, 1915>, 0, <2108, 4207, 1915>, 0, <323, 1915, 4207>, 0, <4207, 2107, 323>, 0, <400, 2107, 4207>, 0, <4207, 2015, 400>, 0, <2015, 4207, 2108>, 0, <2108, 399, 2015>, 0, 
			<325, 2109, 1916>, 0, <2109, 4208, 1916>, 0, <324, 1916, 4208>, 0, <4208, 2108, 324>, 0, <399, 2108, 4208>, 0, <4208, 2014, 399>, 0, <2014, 4208, 2109>, 0, <2109, 398, 2014>, 0, <326, 2110, 1917>, 0, <2110, 4209, 1917>, 0, <325, 1917, 4209>, 0, 
			<4209, 2109, 325>, 0, <2109, 4209, 2013>, 0, <2013, 398, 2109>, 0, <4209, 2110, 397>, 0, <397, 2013, 4209>, 0, <327, 2111, 1918>, 0, <2111, 4210, 1918>, 0, <326, 1918, 4210>, 0, <4210, 2110, 326>, 0, <2110, 4210, 2012>, 0, <2012, 397, 2110>, 0, 
			<4210, 2111, 396>, 0, <396, 2012, 4210>, 0, <328, 2112, 1919>, 0, <2112, 4211, 1919>, 0, <327, 1919, 4211>, 0, <4211, 2111, 327>, 0, <2111, 4211, 2011>, 0, <2011, 396, 2111>, 0, <4211, 2112, 395>, 0, <395, 2011, 4211>, 0, <2113, 4212, 1904>, 0, 
			<2113, 1904, 312>, 0, <1904, 4212, 328>, 0, <4212, 2112, 328>, 0, <2112, 4212, 2026>, 0, <2026, 395, 2112>, 0, <4212, 2113, 411>, 0, <411, 2026, 4212>, 0, <2114, 4213, 329>, 0, <4213, 1991, 329>, 0, <1991, 4213, 312>, 0, <4213, 2113, 312>, 0, 
			<2113, 4213, 2010>, 0, <2010, 411, 2113>, 0, <2010, 4213, 2114>, 0, <2010, 2114, 394>, 0, <330, 2115, 4214>, 0, <4214, 1920, 330>, 0, <1920, 4214, 2114>, 0, <2114, 329, 1920>, 0, <394, 2114, 4214>, 0, <394, 4214, 2009>, 0, <2009, 4214, 2115>, 0, 
			<2009, 2115, 393>, 0, <331, 2116, 4215>, 0, <4215, 1921, 331>, 0, <1921, 4215, 2115>, 0, <2115, 330, 1921>, 0, <393, 2115, 4215>, 0, <393, 4215, 2008>, 0, <2008, 4215, 2116>, 0, <2008, 2116, 392>, 0, <332, 2117, 4216>, 0, <4216, 1922, 332>, 0, 
			<1922, 4216, 2116>, 0, <2116, 331, 1922>, 0, <392, 2116, 4216>, 0, <392, 4216, 2007>, 0, <2007, 4216, 2117>, 0, <2007, 2117, 391>, 0, <333, 2118, 4217>, 0, <4217, 1923, 333>, 0, <1923, 4217, 2117>, 0, <2117, 332, 1923>, 0, <391, 2117, 4217>, 0, 
			<391, 4217, 2006>, 0, <2006, 4217, 2118>, 0, <2006, 2118, 390>, 0, <334, 2119, 4218>, 0, <4218, 1924, 334>, 0, <1924, 4218, 2118>, 0, <2118, 333, 1924>, 0, <2118, 4218, 2005>, 0, <2005, 390, 2118>, 0, <4218, 2119, 389>, 0, <389, 2005, 4218>, 0, 
			<335, 2120, 4219>, 0, <4219, 1925, 335>, 0, <1925, 4219, 2119>, 0, <2119, 334, 1925>, 0, <2119, 4219, 2004>, 0, <2004, 389, 2119>, 0, <4219, 2120, 388>, 0, <388, 2004, 4219>, 0, <336, 2121, 4220>, 0, <4220, 1926, 336>, 0, <1926, 4220, 2120>, 0, 
			<2120, 335, 1926>, 0, <2120, 4220, 2003>, 0, <2003, 388, 2120>, 0, <4220, 2121, 387>, 0, <387, 2003, 4220>, 0, <337, 2122, 4221>, 0, <4221, 1927, 337>, 0, <1927, 4221, 2121>, 0, <2121, 336, 1927>, 0, <2121, 4221, 2002>, 0, <2002, 387, 2121>, 0, 
			<4221, 2122, 386>, 0, <386, 2002, 4221>, 0, <2123, 4222, 1928>, 0, <1928, 338, 2123>, 0, <337, 1928, 4222>, 0, <337, 4222, 2122>, 0, <2122, 4222, 2001>, 0, <2001, 386, 2122>, 0, <2001, 4222, 2123>, 0, <2001, 2123, 385>, 0, <2124, 4223, 1929>, 0, 
			<1929, 339, 2124>, 0, <338, 1929, 4223>, 0, <338, 4223, 2123>, 0, <385, 2123, 4223>, 0, <385, 4223, 2000>, 0, <2000, 4223, 2124>, 0, <2000, 2124, 384>, 0, <2125, 4224, 1930>, 0, <1930, 340, 2125>, 0, <339, 1930, 4224>, 0, <339, 4224, 2124>, 0, 
			<384, 2124, 4224>, 0, <384, 4224, 1999>, 0, <1999, 4224, 2125>, 0, <1999, 2125, 383>, 0, <2126, 4225, 1931>, 0, <1931, 341, 2126>, 0, <340, 1931, 4225>, 0, <340, 4225, 2125>, 0, <383, 2125, 4225>, 0, <383, 4225, 1998>, 0, <1998, 4225, 2126>, 0, 
			<1998, 2126, 382>, 0, <2127, 4226, 1932>, 0, <1932, 342, 2127>, 0, <341, 1932, 4226>, 0, <341, 4226, 2126>, 0, <382, 2126, 1997>, 0, <2126, 4226, 1997>, 0, <1997, 4226, 381>, 0, <4226, 2127, 381>, 0, <2128, 4227, 1933>, 0, <1933, 343, 2128>, 0, 
			<342, 1933, 4227>, 0, <342, 4227, 2127>, 0, <381, 2127, 1996>, 0, <2127, 4227, 1996>, 0, <1996, 4227, 380>, 0, <4227, 2128, 380>, 0, <2095, 4228, 1934>, 0, <1934, 344, 2095>, 0, <343, 1934, 4228>, 0, <343, 4228, 2128>, 0, <380, 2128, 1995>, 0, 
			<2128, 4228, 1995>, 0, <1995, 4228, 379>, 0, <4228, 2095, 379>, 0, <362, 2130, 4229>, 0, <4229, 1959, 362>, 0, <1959, 4229, 2132>, 0, <2132, 346, 1959>, 0, <2132, 4229, 2133>, 0, <2132, 2133, 449>, 0, <2133, 4229, 2130>, 0, <2133, 2130, 447>, 0, 
			<369, 2129, 4230>, 0, <369, 4230, 1973>, 0, <353, 1973, 2131>, 0, <1973, 4230, 2131>, 0, <2131, 4230, 448>, 0, <4230, 2134, 448>, 0, <2134, 4230, 2129>, 0, <2129, 446, 2134>, 0, <446, 2136, 4231>, 0, <4231, 1974, 446>, 0, <1974, 4231, 2138>, 0, 
			<2138, 370, 1974>, 0, <4231, 2135, 451>, 0, <451, 2138, 4231>, 0, <4231, 2136, 450>, 0, <450, 2135, 4231>, 0, <370, 2138, 4232>, 0, <4232, 1976, 370>, 0, <1976, 4232, 2140>, 0, <2140, 371, 1976>, 0, <4232, 2137, 452>, 0, <452, 2140, 4232>, 0, 
			<2137, 4232, 2138>, 0, <2137, 2138, 451>, 0, <371, 2140, 4233>, 0, <4233, 1978, 371>, 0, <1978, 4233, 2142>, 0, <2142, 372, 1978>, 0, <4233, 2139, 453>, 0, <453, 2142, 4233>, 0, <2139, 4233, 2140>, 0, <2139, 2140, 452>, 0, <372, 2142, 4234>, 0, 
			<4234, 1980, 372>, 0, <1980, 4234, 2144>, 0, <2144, 373, 1980>, 0, <4234, 2141, 454>, 0, <454, 2144, 4234>, 0, <2141, 4234, 2142>, 0, <2141, 2142, 453>, 0, <373, 2144, 1982>, 0, <2144, 4235, 1982>, 0, <1982, 4235, 374>, 0, <4235, 2146, 374>, 0, 
			<4235, 2143, 455>, 0, <455, 2146, 4235>, 0, <2143, 4235, 2144>, 0, <2143, 2144, 454>, 0, <374, 2146, 4236>, 0, <4236, 1984, 374>, 0, <1984, 4236, 2148>, 0, <2148, 375, 1984>, 0, <4236, 2145, 456>, 0, <456, 2148, 4236>, 0, <2145, 4236, 2146>, 0, 
			<2145, 2146, 455>, 0, <375, 2148, 4237>, 0, <4237, 1986, 375>, 0, <1986, 4237, 2150>, 0, <2150, 376, 1986>, 0, <4237, 2147, 457>, 0, <457, 2150, 4237>, 0, <2147, 4237, 2148>, 0, <2147, 2148, 456>, 0, <376, 2150, 4238>, 0, <4238, 1988, 376>, 0, 
			<1988, 4238, 2152>, 0, <2152, 377, 1988>, 0, <4238, 2149, 458>, 0, <458, 2152, 4238>, 0, <2149, 4238, 2150>, 0, <2149, 2150, 457>, 0, <2152, 4239, 1990>, 0, <1990, 377, 2152>, 0, <4239, 2154, 362>, 0, <362, 1990, 4239>, 0, <4239, 2151, 459>, 0, 
			<459, 2154, 4239>, 0, <2151, 4239, 2152>, 0, <2151, 2152, 458>, 0, <2154, 4240, 2130>, 0, <2130, 362, 2154>, 0, <4240, 2156, 447>, 0, <447, 2130, 4240>, 0, <2156, 4240, 460>, 0, <4240, 2153, 460>, 0, <2153, 4240, 2154>, 0, <2154, 459, 2153>, 0, 
			<447, 2156, 4241>, 0, <447, 4241, 1960>, 0, <1960, 4241, 2158>, 0, <1960, 2158, 363>, 0, <2158, 4241, 2155>, 0, <2158, 2155, 461>, 0, <2155, 4241, 460>, 0, <4241, 2156, 460>, 0, <2158, 4242, 1962>, 0, <1962, 363, 2158>, 0, <4242, 2160, 364>, 0, 
			<364, 1962, 4242>, 0, <2160, 4242, 2157>, 0, <2160, 2157, 462>, 0, <2157, 4242, 461>, 0, <4242, 2158, 461>, 0, <2160, 4243, 1964>, 0, <1964, 364, 2160>, 0, <4243, 2162, 365>, 0, <365, 1964, 4243>, 0, <2162, 4243, 2159>, 0, <2162, 2159, 463>, 0, 
			<2159, 4243, 462>, 0, <4243, 2160, 462>, 0, <2162, 4244, 1966>, 0, <1966, 365, 2162>, 0, <4244, 2164, 366>, 0, <366, 1966, 4244>, 0, <2164, 4244, 2161>, 0, <2164, 2161, 464>, 0, <2161, 4244, 463>, 0, <4244, 2162, 463>, 0, <366, 2164, 4245>, 0, 
			<366, 4245, 1968>, 0, <1968, 4245, 2166>, 0, <1968, 2166, 367>, 0, <2166, 4245, 2163>, 0, <2166, 2163, 465>, 0, <2163, 4245, 464>, 0, <4245, 2164, 464>, 0, <2166, 4246, 1970>, 0, <1970, 367, 2166>, 0, <4246, 2168, 368>, 0, <368, 1970, 4246>, 0, 
			<2168, 4246, 2165>, 0, <2168, 2165, 466>, 0, <2165, 4246, 465>, 0, <4246, 2166, 465>, 0, <2168, 4247, 1972>, 0, <1972, 368, 2168>, 0, <4247, 2170, 369>, 0, <369, 1972, 4247>, 0, <2170, 4247, 2167>, 0, <2170, 2167, 467>, 0, <2167, 4247, 466>, 0, 
			<4247, 2168, 466>, 0, <369, 2170, 2129>, 0, <2170, 4248, 2129>, 0, <2129, 4248, 446>, 0, <4248, 2136, 446>, 0, <2136, 4248, 2169>, 0, <2136, 2169, 450>, 0, <2169, 4248, 467>, 0, <4248, 2170, 467>, 0, <519, 2257, 4249>, 0, <519, 4249, 2238>, 0, 
			<535, 2238, 2272>, 0, <2238, 4249, 2272>, 0, <2272, 4249, 568>, 0, <4249, 2273, 568>, 0, <4249, 2257, 553>, 0, <553, 2273, 4249>, 0, <534, 2239, 2237>, 0, <2239, 4250, 2237>, 0, <2237, 4250, 533>, 0, <4250, 2271, 533>, 0, <2271, 4250, 2274>, 0, 
			<2274, 567, 2271>, 0, <569, 2274, 2239>, 0, <2274, 4250, 2239>, 0, <533, 2271, 2236>, 0, <2271, 4251, 2236>, 0, <532, 2236, 4251>, 0, <4251, 2270, 532>, 0, <2270, 4251, 2275>, 0, <2275, 566, 2270>, 0, <4251, 2271, 567>, 0, <567, 2275, 4251>, 0, 
			<532, 2270, 2235>, 0, <2270, 4252, 2235>, 0, <531, 2235, 4252>, 0, <4252, 2269, 531>, 0, <2269, 4252, 2276>, 0, <2276, 565, 2269>, 0, <4252, 2270, 566>, 0, <566, 2276, 4252>, 0, <531, 2269, 2234>, 0, <2269, 4253, 2234>, 0, <530, 2234, 4253>, 0, 
			<4253, 2268, 530>, 0, <2268, 4253, 2277>, 0, <2277, 564, 2268>, 0, <4253, 2269, 565>, 0, <565, 2277, 4253>, 0, <530, 2268, 2233>, 0, <2268, 4254, 2233>, 0, <529, 2233, 4254>, 0, <4254, 2267, 529>, 0, <2267, 4254, 2278>, 0, <2278, 563, 2267>, 0, 
			<4254, 2268, 564>, 0, <564, 2278, 4254>, 0, <529, 2267, 2232>, 0, <2267, 4255, 2232>, 0, <528, 2232, 4255>, 0, <4255, 2266, 528>, 0, <2266, 4255, 2279>, 0, <2279, 562, 2266>, 0, <4255, 2267, 563>, 0, <563, 2279, 4255>, 0, <528, 2266, 4256>, 0, 
			<4256, 2231, 528>, 0, <2231, 4256, 2265>, 0, <2265, 527, 2231>, 0, <2265, 4256, 2280>, 0, <2280, 561, 2265>, 0, <4256, 2266, 562>, 0, <562, 2280, 4256>, 0, <527, 2265, 4257>, 0, <4257, 2230, 527>, 0, <2230, 4257, 2264>, 0, <2264, 526, 2230>, 0, 
			<2264, 4257, 2281>, 0, <2281, 560, 2264>, 0, <4257, 2265, 561>, 0, <561, 2281, 4257>, 0, <526, 2264, 2229>, 0, <2264, 4258, 2229>, 0, <525, 2229, 4258>, 0, <4258, 2263, 525>, 0, <2263, 4258, 2282>, 0, <2282, 559, 2263>, 0, <4258, 2264, 560>, 0, 
			<560, 2282, 4258>, 0, <525, 2263, 2228>, 0, <2263, 4259, 2228>, 0, <524, 2228, 4259>, 0, <4259, 2262, 524>, 0, <2262, 4259, 2283>, 0, <2283, 558, 2262>, 0, <4259, 2263, 559>, 0, <559, 2283, 4259>, 0, <524, 2262, 2227>, 0, <2262, 4260, 2227>, 0, 
			<523, 2227, 4260>, 0, <4260, 2261, 523>, 0, <2261, 4260, 2284>, 0, <2284, 557, 2261>, 0, <4260, 2262, 558>, 0, <558, 2284, 4260>, 0, <523, 2261, 2226>, 0, <2261, 4261, 2226>, 0, <522, 2226, 4261>, 0, <4261, 2260, 522>, 0, <2260, 4261, 2285>, 0, 
			<2285, 556, 2260>, 0, <4261, 2261, 557>, 0, <557, 2285, 4261>, 0, <522, 2260, 2225>, 0, <2260, 4262, 2225>, 0, <521, 2225, 4262>, 0, <4262, 2259, 521>, 0, <2259, 4262, 2286>, 0, <2286, 555, 2259>, 0, <4262, 2260, 556>, 0, <556, 2286, 4262>, 0, 
			<521, 2259, 2224>, 0, <2259, 4263, 2224>, 0, <520, 2224, 4263>, 0, <4263, 2258, 520>, 0, <2258, 4263, 2287>, 0, <2287, 554, 2258>, 0, <4263, 2259, 555>, 0, <555, 2287, 4263>, 0, <520, 2258, 2223>, 0, <2258, 4264, 2223>, 0, <519, 2223, 2257>, 0, 
			<2223, 4264, 2257>, 0, <2257, 4264, 2288>, 0, <2288, 553, 2257>, 0, <4264, 2258, 554>, 0, <554, 2288, 4264>, 0, <2256, 4265, 2221>, 0, <2221, 518, 2256>, 0, <517, 2221, 4265>, 0, <517, 4265, 2255>, 0, <2255, 4265, 551>, 0, <4265, 2289, 551>, 0, 
			<2289, 4265, 2256>, 0, <2256, 552, 2289>, 0, <2255, 4266, 2220>, 0, <2220, 517, 2255>, 0, <516, 2220, 2254>, 0, <2220, 4266, 2254>, 0, <2254, 4266, 550>, 0, <4266, 2290, 550>, 0, <2290, 4266, 2255>, 0, <2255, 551, 2290>, 0, <516, 2254, 4267>, 0, 
			<516, 4267, 2219>, 0, <515, 2219, 2253>, 0, <2219, 4267, 2253>, 0, <2253, 4267, 549>, 0, <4267, 2291, 549>, 0, <2291, 4267, 2254>, 0, <2254, 550, 2291>, 0, <515, 2253, 4268>, 0, <515, 4268, 2218>, 0, <514, 2218, 2252>, 0, <2218, 4268, 2252>, 0, 
			<2252, 4268, 548>, 0, <4268, 2292, 548>, 0, <2292, 4268, 2253>, 0, <2253, 549, 2292>, 0, <514, 2252, 4269>, 0, <514, 4269, 2217>, 0, <513, 2217, 2251>, 0, <2217, 4269, 2251>, 0, <2251, 4269, 547>, 0, <4269, 2293, 547>, 0, <2293, 4269, 2252>, 0, 
			<2252, 548, 2293>, 0, <513, 2251, 4270>, 0, <513, 4270, 2216>, 0, <512, 2216, 2250>, 0, <2216, 4270, 2250>, 0, <2250, 4270, 546>, 0, <4270, 2294, 546>, 0, <2294, 4270, 2251>, 0, <2251, 547, 2294>, 0, <512, 2250, 4271>, 0, <512, 4271, 2215>, 0, 
			<511, 2215, 2249>, 0, <2215, 4271, 2249>, 0, <2249, 4271, 545>, 0, <4271, 2295, 545>, 0, <2295, 4271, 2250>, 0, <2250, 546, 2295>, 0, <511, 2249, 4272>, 0, <511, 4272, 2214>, 0, <510, 2214, 2248>, 0, <2214, 4272, 2248>, 0, <2248, 4272, 544>, 0, 
			<4272, 2296, 544>, 0, <2296, 4272, 2249>, 0, <2249, 545, 2296>, 0, <2248, 4273, 2213>, 0, <2213, 510, 2248>, 0, <509, 2213, 4273>, 0, <509, 4273, 2247>, 0, <2247, 4273, 543>, 0, <4273, 2297, 543>, 0, <2297, 4273, 2248>, 0, <2248, 544, 2297>, 0, 
			<2247, 4274, 2212>, 0, <2212, 509, 2247>, 0, <508, 2212, 4274>, 0, <508, 4274, 2246>, 0, <2246, 4274, 542>, 0, <4274, 2298, 542>, 0, <2298, 4274, 2247>, 0, <2247, 543, 2298>, 0, <508, 2246, 4275>, 0, <508, 4275, 2211>, 0, <507, 2211, 2245>, 0, 
			<2211, 4275, 2245>, 0, <2245, 4275, 541>, 0, <4275, 2299, 541>, 0, <2299, 4275, 2246>, 0, <2246, 542, 2299>, 0, <507, 2245, 4276>, 0, <507, 4276, 2210>, 0, <506, 2210, 2244>, 0, <2210, 4276, 2244>, 0, <2244, 4276, 540>, 0, <4276, 2300, 540>, 0, 
			<2300, 4276, 2245>, 0, <2245, 541, 2300>, 0, <506, 2244, 4277>, 0, <506, 4277, 2209>, 0, <505, 2209, 2243>, 0, <2209, 4277, 2243>, 0, <2243, 4277, 539>, 0, <4277, 2301, 539>, 0, <2301, 4277, 2244>, 0, <2244, 540, 2301>, 0, <505, 2243, 4278>, 0, 
			<505, 4278, 2208>, 0, <504, 2208, 2242>, 0, <2208, 4278, 2242>, 0, <2242, 4278, 538>, 0, <4278, 2302, 538>, 0, <2302, 4278, 2243>, 0, <2243, 539, 2302>, 0, <504, 2242, 4279>, 0, <4279, 2207, 504>, 0, <2207, 4279, 2241>, 0, <2241, 503, 2207>, 0, 
			<2241, 4279, 537>, 0, <4279, 2303, 537>, 0, <2303, 4279, 2242>, 0, <2242, 538, 2303>, 0, <503, 2241, 4280>, 0, <4280, 2205, 503>, 0, <2205, 4280, 2240>, 0, <2240, 502, 2205>, 0, <4280, 2304, 536>, 0, <536, 2240, 4280>, 0, <2304, 4280, 2241>, 0, 
			<2241, 537, 2304>, 0, <2240, 4281, 2206>, 0, <2240, 2206, 502>, 0, <2206, 4281, 534>, 0, <4281, 2239, 534>, 0, <2239, 4281, 2305>, 0, <2305, 569, 2239>, 0, <4281, 2240, 536>, 0, <536, 2305, 4281>, 0, <535, 2272, 4282>, 0, <535, 4282, 2222>, 0, 
			<518, 2222, 2256>, 0, <2222, 4282, 2256>, 0, <2256, 4282, 552>, 0, <4282, 2306, 552>, 0, <2306, 4282, 2272>, 0, <2272, 568, 2306>, 0, <444, 2307, 4283>, 0, <4283, 2061, 444>, 0, <4283, 2322, 429>, 0, <429, 2061, 4283>, 0, <553, 2322, 2273>, 0, 
			<2322, 4283, 2273>, 0, <568, 2273, 4283>, 0, <568, 4283, 2307>, 0, <2309, 4284, 2063>, 0, <2063, 442, 2309>, 0, <4284, 2308, 443>, 0, <443, 2063, 4284>, 0, <567, 2308, 2275>, 0, <2308, 4284, 2275>, 0, <566, 2275, 4284>, 0, <4284, 2309, 566>, 0, 
			<2310, 4285, 2064>, 0, <2064, 441, 2310>, 0, <4285, 2309, 442>, 0, <442, 2064, 4285>, 0, <566, 2309, 2276>, 0, <2309, 4285, 2276>, 0, <565, 2276, 4285>, 0, <4285, 2310, 565>, 0, <2311, 4286, 2065>, 0, <2065, 440, 2311>, 0, <4286, 2310, 441>, 0, 
			<441, 2065, 4286>, 0, <565, 2310, 2277>, 0, <2310, 4286, 2277>, 0, <564, 2277, 4286>, 0, <4286, 2311, 564>, 0, <2312, 4287, 2066>, 0, <2066, 439, 2312>, 0, <4287, 2311, 440>, 0, <440, 2066, 4287>, 0, <564, 2311, 2278>, 0, <2311, 4287, 2278>, 0, 
			<563, 2278, 4287>, 0, <4287, 2312, 563>, 0, <2313, 4288, 2067>, 0, <2067, 438, 2313>, 0, <4288, 2312, 439>, 0, <439, 2067, 4288>, 0, <563, 2312, 2279>, 0, <2312, 4288, 2279>, 0, <562, 2279, 4288>, 0, <4288, 2313, 562>, 0, <2314, 4289, 2068>, 0, 
			<2068, 437, 2314>, 0, <4289, 2313, 438>, 0, <438, 2068, 4289>, 0, <562, 2313, 2280>, 0, <2313, 4289, 2280>, 0, <561, 2280, 4289>, 0, <4289, 2314, 561>, 0, <2315, 4290, 2069>, 0, <2069, 436, 2315>, 0, <4290, 2314, 437>, 0, <437, 2069, 4290>, 0, 
			<561, 2314, 2281>, 0, <2314, 4290, 2281>, 0, <560, 2281, 4290>, 0, <4290, 2315, 560>, 0, <2316, 4291, 2070>, 0, <2070, 435, 2316>, 0, <4291, 2315, 436>, 0, <436, 2070, 4291>, 0, <560, 2315, 2282>, 0, <2315, 4291, 2282>, 0, <559, 2282, 4291>, 0, 
			<4291, 2316, 559>, 0, <2317, 4292, 2071>, 0, <2071, 434, 2317>, 0, <4292, 2316, 435>, 0, <435, 2071, 4292>, 0, <559, 2316, 2283>, 0, <2316, 4292, 2283>, 0, <558, 2283, 4292>, 0, <4292, 2317, 558>, 0, <2318, 4293, 2072>, 0, <2072, 433, 2318>, 0, 
			<4293, 2317, 434>, 0, <434, 2072, 4293>, 0, <558, 2317, 2284>, 0, <2317, 4293, 2284>, 0, <557, 2284, 4293>, 0, <4293, 2318, 557>, 0, <2319, 4294, 2073>, 0, <2073, 432, 2319>, 0, <4294, 2318, 433>, 0, <433, 2073, 4294>, 0, <557, 2318, 2285>, 0, 
			<2318, 4294, 2285>, 0, <556, 2285, 4294>, 0, <4294, 2319, 556>, 0, <2320, 4295, 2074>, 0, <2074, 431, 2320>, 0, <4295, 2319, 432>, 0, <432, 2074, 4295>, 0, <556, 2319, 2286>, 0, <2319, 4295, 2286>, 0, <555, 2286, 4295>, 0, <4295, 2320, 555>, 0, 
			<2321, 4296, 2075>, 0, <2075, 430, 2321>, 0, <4296, 2320, 431>, 0, <431, 2075, 4296>, 0, <555, 2320, 2287>, 0, <2320, 4296, 2287>, 0, <554, 2287, 4296>, 0, <4296, 2321, 554>, 0, <2322, 4297, 2076>, 0, <2076, 429, 2322>, 0, <4297, 2321, 430>, 0, 
			<430, 2076, 4297>, 0, <554, 2321, 2288>, 0, <2321, 4297, 2288>, 0, <553, 2288, 4297>, 0, <4297, 2322, 553>, 0, <427, 2324, 4298>, 0, <4298, 2077, 427>, 0, <2077, 4298, 2323>, 0, <2323, 428, 2077>, 0, <2323, 4298, 2289>, 0, <2289, 552, 2323>, 0, 
			<551, 2289, 2324>, 0, <2289, 4298, 2324>, 0, <426, 2325, 4299>, 0, <4299, 2078, 426>, 0, <2078, 4299, 2324>, 0, <2324, 427, 2078>, 0, <551, 2324, 4299>, 0, <551, 4299, 2290>, 0, <550, 2290, 2325>, 0, <2290, 4299, 2325>, 0, <425, 2326, 4300>, 0, 
			<4300, 2079, 425>, 0, <2079, 4300, 2325>, 0, <2325, 426, 2079>, 0, <550, 2325, 4300>, 0, <550, 4300, 2291>, 0, <549, 2291, 2326>, 0, <2291, 4300, 2326>, 0, <424, 2327, 4301>, 0, <4301, 2080, 424>, 0, <2080, 4301, 2326>, 0, <2326, 425, 2080>, 0, 
			<549, 2326, 4301>, 0, <549, 4301, 2292>, 0, <548, 2292, 2327>, 0, <2292, 4301, 2327>, 0, <423, 2328, 4302>, 0, <4302, 2081, 423>, 0, <2081, 4302, 2327>, 0, <2327, 424, 2081>, 0, <548, 2327, 4302>, 0, <548, 4302, 2293>, 0, <547, 2293, 2328>, 0, 
			<2293, 4302, 2328>, 0, <422, 2329, 4303>, 0, <4303, 2082, 422>, 0, <2082, 4303, 2328>, 0, <2328, 423, 2082>, 0, <547, 2328, 4303>, 0, <547, 4303, 2294>, 0, <546, 2294, 2329>, 0, <2294, 4303, 2329>, 0, <421, 2330, 4304>, 0, <4304, 2083, 421>, 0, 
			<2083, 4304, 2329>, 0, <2329, 422, 2083>, 0, <546, 2329, 4304>, 0, <546, 4304, 2295>, 0, <545, 2295, 2330>, 0, <2295, 4304, 2330>, 0, <420, 2331, 4305>, 0, <4305, 2084, 420>, 0, <2084, 4305, 2330>, 0, <2330, 421, 2084>, 0, <545, 2330, 4305>, 0, 
			<545, 4305, 2296>, 0, <544, 2296, 2331>, 0, <2296, 4305, 2331>, 0, <419, 2332, 4306>, 0, <4306, 2085, 419>, 0, <2085, 4306, 2331>, 0, <2331, 420, 2085>, 0, <544, 2331, 4306>, 0, <544, 4306, 2297>, 0, <543, 2297, 2332>, 0, <2297, 4306, 2332>, 0, 
			<418, 2333, 4307>, 0, <4307, 2086, 418>, 0, <2086, 4307, 2332>, 0, <2332, 419, 2086>, 0, <543, 2332, 4307>, 0, <543, 4307, 2298>, 0, <542, 2298, 2333>, 0, <2298, 4307, 2333>, 0, <417, 2334, 4308>, 0, <4308, 2087, 417>, 0, <2087, 4308, 2333>, 0, 
			<2333, 418, 2087>, 0, <542, 2333, 4308>, 0, <542, 4308, 2299>, 0, <541, 2299, 2334>, 0, <2299, 4308, 2334>, 0, <416, 2335, 4309>, 0, <4309, 2088, 416>, 0, <2088, 4309, 2334>, 0, <2334, 417, 2088>, 0, <541, 2334, 4309>, 0, <541, 4309, 2300>, 0, 
			<540, 2300, 2335>, 0, <2300, 4309, 2335>, 0, <415, 2336, 4310>, 0, <4310, 2089, 415>, 0, <2089, 4310, 2335>, 0, <2335, 416, 2089>, 0, <540, 2335, 4310>, 0, <540, 4310, 2301>, 0, <539, 2301, 2336>, 0, <2301, 4310, 2336>, 0, <414, 2337, 4311>, 0, 
			<4311, 2090, 414>, 0, <2090, 4311, 2336>, 0, <2336, 415, 2090>, 0, <539, 2336, 4311>, 0, <539, 4311, 2302>, 0, <538, 2302, 2337>, 0, <2302, 4311, 2337>, 0, <413, 2338, 4312>, 0, <4312, 2091, 413>, 0, <2091, 4312, 2337>, 0, <2337, 414, 2091>, 0, 
			<538, 2337, 4312>, 0, <538, 4312, 2303>, 0, <537, 2303, 2338>, 0, <2303, 4312, 2338>, 0, <2339, 4313, 2092>, 0, <2092, 412, 2339>, 0, <2092, 4313, 2338>, 0, <2338, 413, 2092>, 0, <537, 2338, 4313>, 0, <537, 4313, 2304>, 0, <2304, 4313, 2339>, 0, 
			<2339, 536, 2304>, 0, <2340, 4314, 2093>, 0, <2093, 445, 2340>, 0, <4314, 2339, 412>, 0, <412, 2093, 4314>, 0, <536, 2339, 4314>, 0, <4314, 2305, 536>, 0, <2305, 4314, 2340>, 0, <2340, 569, 2305>, 0, <428, 2323, 4315>, 0, <4315, 2094, 428>, 0, 
			<2094, 4315, 2307>, 0, <2307, 444, 2094>, 0, <568, 2307, 4315>, 0, <568, 4315, 2306>, 0, <552, 2306, 2323>, 0, <2306, 4315, 2323>, 0, <500, 2341, 4316>, 0, <4316, 2202, 500>, 0, <2202, 4316, 2342>, 0, <2342, 501, 2202>, 0, <4316, 2205, 502>, 0, 
			<502, 2342, 4316>, 0, <2205, 4316, 2341>, 0, <2205, 2341, 503>, 0, <501, 2342, 4317>, 0, <4317, 2204, 501>, 0, <2204, 4317, 469>, 0, <4317, 2343, 469>, 0, <2343, 4317, 2206>, 0, <2206, 534, 2343>, 0, <2342, 502, 2206>, 0, <2342, 2206, 4317>, 0, 
			<469, 2343, 2172>, 0, <2343, 4318, 2172>, 0, <2172, 4318, 470>, 0, <4318, 2344, 470>, 0, <2344, 4318, 2237>, 0, <2237, 533, 2344>, 0, <534, 2237, 4318>, 0, <534, 4318, 2343>, 0, <470, 2344, 2173>, 0, <2344, 4319, 2173>, 0, <2173, 4319, 471>, 0, 
			<4319, 2345, 471>, 0, <2345, 4319, 2236>, 0, <2236, 532, 2345>, 0, <4319, 2344, 533>, 0, <533, 2236, 4319>, 0, <471, 2345, 2174>, 0, <2345, 4320, 2174>, 0, <2174, 4320, 472>, 0, <4320, 2346, 472>, 0, <2346, 4320, 2235>, 0, <2235, 531, 2346>, 0, 
			<4320, 2345, 532>, 0, <532, 2235, 4320>, 0, <472, 2346, 2175>, 0, <2346, 4321, 2175>, 0, <2175, 4321, 473>, 0, <4321, 2347, 473>, 0, <2347, 4321, 2234>, 0, <2234, 530, 2347>, 0, <4321, 2346, 531>, 0, <531, 2234, 4321>, 0, <473, 2347, 2176>, 0, 
			<2347, 4322, 2176>, 0, <2176, 4322, 474>, 0, <4322, 2348, 474>, 0, <4322, 2233, 529>, 0, <529, 2348, 4322>, 0, <2233, 4322, 2347>, 0, <2233, 2347, 530>, 0, <474, 2348, 2177>, 0, <2348, 4323, 2177>, 0, <2177, 4323, 475>, 0, <4323, 2349, 475>, 0, 
			<4323, 2232, 528>, 0, <528, 2349, 4323>, 0, <2232, 4323, 2348>, 0, <2232, 2348, 529>, 0, <475, 2349, 2178>, 0, <2349, 4324, 2178>, 0, <2178, 4324, 476>, 0, <4324, 2350, 476>, 0, <4324, 2231, 527>, 0, <527, 2350, 4324>, 0, <2231, 4324, 2349>, 0, 
			<2231, 2349, 528>, 0, <476, 2350, 2179>, 0, <2350, 4325, 2179>, 0, <2179, 4325, 477>, 0, <4325, 2351, 477>, 0, <4325, 2230, 526>, 0, <526, 2351, 4325>, 0, <2230, 4325, 2350>, 0, <2230, 2350, 527>, 0, <477, 2351, 4326>, 0, <477, 4326, 2180>, 0, 
			<2180, 4326, 2352>, 0, <2180, 2352, 478>, 0, <2352, 4326, 2229>, 0, <2229, 525, 2352>, 0, <4326, 2351, 526>, 0, <526, 2229, 4326>, 0, <478, 2352, 4327>, 0, <478, 4327, 2181>, 0, <2181, 4327, 2353>, 0, <2181, 2353, 479>, 0, <2353, 4327, 2228>, 0, 
			<2228, 524, 2353>, 0, <4327, 2352, 525>, 0, <525, 2228, 4327>, 0, <479, 2353, 4328>, 0, <479, 4328, 2182>, 0, <2182, 4328, 2354>, 0, <2182, 2354, 480>, 0, <2354, 4328, 2227>, 0, <2227, 523, 2354>, 0, <4328, 2353, 524>, 0, <524, 2227, 4328>, 0, 
			<480, 2354, 4329>, 0, <480, 4329, 2183>, 0, <2183, 4329, 2355>, 0, <2183, 2355, 481>, 0, <2355, 4329, 2226>, 0, <2226, 522, 2355>, 0, <4329, 2354, 523>, 0, <523, 2226, 4329>, 0, <481, 2355, 4330>, 0, <481, 4330, 2184>, 0, <2184, 4330, 2356>, 0, 
			<2184, 2356, 482>, 0, <2356, 4330, 521>, 0, <4330, 2225, 521>, 0, <2225, 4330, 2355>, 0, <2355, 522, 2225>, 0, <482, 2356, 4331>, 0, <482, 4331, 2185>, 0, <2185, 4331, 2357>, 0, <2185, 2357, 483>, 0, <2357, 4331, 520>, 0, <4331, 2224, 520>, 0, 
			<2224, 4331, 2356>, 0, <2356, 521, 2224>, 0, <483, 2357, 4332>, 0, <483, 4332, 2186>, 0, <2186, 4332, 2358>, 0, <2186, 2358, 484>, 0, <2358, 4332, 519>, 0, <4332, 2223, 519>, 0, <2223, 4332, 2357>, 0, <2357, 520, 2223>, 0, <484, 2358, 4333>, 0, 
			<484, 4333, 2171>, 0, <2171, 4333, 2359>, 0, <2171, 2359, 468>, 0, <2359, 4333, 535>, 0, <4333, 2238, 535>, 0, <2238, 4333, 2358>, 0, <2358, 519, 2238>, 0, <468, 2359, 4334>, 0, <468, 4334, 2203>, 0, <485, 2203, 4334>, 0, <485, 4334, 2360>, 0, 
			<2360, 4334, 2222>, 0, <2360, 2222, 518>, 0, <2222, 4334, 2359>, 0, <2359, 535, 2222>, 0, <2360, 4335, 2187>, 0, <2187, 485, 2360>, 0, <4335, 2361, 486>, 0, <486, 2187, 4335>, 0, <2361, 4335, 2221>, 0, <2361, 2221, 517>, 0, <2221, 4335, 518>, 0, 
			<4335, 2360, 518>, 0, <2361, 4336, 2188>, 0, <2188, 486, 2361>, 0, <4336, 2362, 487>, 0, <487, 2188, 4336>, 0, <2362, 4336, 2220>, 0, <2362, 2220, 516>, 0, <2220, 4336, 517>, 0, <4336, 2361, 517>, 0, <2362, 4337, 2189>, 0, <2189, 487, 2362>, 0, 
			<4337, 2363, 488>, 0, <488, 2189, 4337>, 0, <2363, 4337, 2219>, 0, <2363, 2219, 515>, 0, <2219, 4337, 516>, 0, <4337, 2362, 516>, 0, <2363, 4338, 2190>, 0, <2190, 488, 2363>, 0, <4338, 2364, 489>, 0, <489, 2190, 4338>, 0, <2364, 4338, 2218>, 0, 
			<2364, 2218, 514>, 0, <2218, 4338, 515>, 0, <4338, 2363, 515>, 0, <2364, 4339, 2191>, 0, <2191, 489, 2364>, 0, <4339, 2365, 490>, 0, <490, 2191, 4339>, 0, <2365, 4339, 513>, 0, <4339, 2217, 513>, 0, <2217, 4339, 2364>, 0, <2364, 514, 2217>, 0, 
			<2365, 4340, 2192>, 0, <2192, 490, 2365>, 0, <4340, 2366, 491>, 0, <491, 2192, 4340>, 0, <2366, 4340, 512>, 0, <4340, 2216, 512>, 0, <2216, 4340, 2365>, 0, <2365, 513, 2216>, 0, <2366, 4341, 2193>, 0, <2193, 491, 2366>, 0, <4341, 2367, 492>, 0, 
			<492, 2193, 4341>, 0, <2367, 4341, 511>, 0, <4341, 2215, 511>, 0, <2215, 4341, 2366>, 0, <2366, 512, 2215>, 0, <2367, 4342, 2194>, 0, <2194, 492, 2367>, 0, <4342, 2368, 493>, 0, <493, 2194, 4342>, 0, <2368, 4342, 510>, 0, <4342, 2214, 510>, 0, 
			<2214, 4342, 2367>, 0, <2367, 511, 2214>, 0, <493, 2368, 4343>, 0, <4343, 2195, 493>, 0, <2195, 4343, 2369>, 0, <2369, 494, 2195>, 0, <2369, 4343, 2213>, 0, <2369, 2213, 509>, 0, <2213, 4343, 510>, 0, <4343, 2368, 510>, 0, <494, 2369, 4344>, 0, 
			<4344, 2196, 494>, 0, <2196, 4344, 2370>, 0, <2370, 495, 2196>, 0, <2370, 4344, 2212>, 0, <2370, 2212, 508>, 0, <2212, 4344, 509>, 0, <4344, 2369, 509>, 0, <495, 2370, 4345>, 0, <4345, 2197, 495>, 0, <2197, 4345, 2371>, 0, <2371, 496, 2197>, 0, 
			<2371, 4345, 2211>, 0, <2371, 2211, 507>, 0, <2211, 4345, 508>, 0, <4345, 2370, 508>, 0, <496, 2371, 4346>, 0, <4346, 2198, 496>, 0, <2198, 4346, 2372>, 0, <2372, 497, 2198>, 0, <2372, 4346, 2210>, 0, <2372, 2210, 506>, 0, <2210, 4346, 507>, 0, 
			<4346, 2371, 507>, 0, <497, 2372, 4347>, 0, <4347, 2199, 497>, 0, <2199, 4347, 2373>, 0, <2373, 498, 2199>, 0, <4347, 2209, 505>, 0, <505, 2373, 4347>, 0, <2209, 4347, 2372>, 0, <2209, 2372, 506>, 0, <498, 2373, 4348>, 0, <4348, 2200, 498>, 0, 
			<2200, 4348, 2374>, 0, <2374, 499, 2200>, 0, <4348, 2208, 504>, 0, <504, 2374, 4348>, 0, <2208, 4348, 2373>, 0, <2208, 2373, 505>, 0, <499, 2374, 4349>, 0, <4349, 2201, 499>, 0, <2201, 4349, 2341>, 0, <2341, 500, 2201>, 0, <4349, 2207, 503>, 0, 
			<503, 2341, 4349>, 0, <2207, 4349, 2374>, 0, <2207, 2374, 504>, 0, <490, 2192, 4350>, 0, <490, 4350, 2191>, 0, <2191, 4350, 2394>, 0, <2191, 2394, 489>, 0, <608, 2394, 4350>, 0, <608, 4350, 2468>, 0, <2395, 609, 2468>, 0, <2395, 2468, 4350>, 0, 
			<491, 2395, 4350>, 0, <491, 4350, 2192>, 0, <492, 2194, 4351>, 0, <492, 4351, 2193>, 0, <2193, 4351, 2395>, 0, <2193, 2395, 491>, 0, <609, 2395, 4351>, 0, <609, 4351, 2477>, 0, <2396, 610, 2477>, 0, <2396, 2477, 4351>, 0, <2194, 493, 2396>, 0, 
			<2194, 2396, 4351>, 0, <494, 2196, 4352>, 0, <494, 4352, 2195>, 0, <2195, 4352, 2396>, 0, <2195, 2396, 493>, 0, <2396, 4352, 2470>, 0, <2396, 2470, 610>, 0, <611, 2470, 4352>, 0, <611, 4352, 2397>, 0, <2196, 495, 2397>, 0, <2196, 2397, 4352>, 0, 
			<4353, 2201, 500>, 0, <500, 2202, 4353>, 0, <4353, 2491, 499>, 0, <499, 2201, 4353>, 0, <613, 2491, 2481>, 0, <2491, 4353, 2481>, 0, <2481, 4353, 622>, 0, <4353, 2490, 622>, 0, <2490, 4353, 2202>, 0, <2202, 501, 2490>, 0, <496, 2198, 4354>, 0, 
			<496, 4354, 2197>, 0, <495, 2197, 4354>, 0, <495, 4354, 2397>, 0, <2397, 4354, 2480>, 0, <2397, 2480, 611>, 0, <612, 2480, 4354>, 0, <612, 4354, 2398>, 0, <2198, 497, 2398>, 0, <2198, 2398, 4354>, 0, <2190, 4355, 488>, 0, <4355, 2189, 488>, 0, 
			<2189, 4355, 2393>, 0, <2393, 487, 2189>, 0, <4355, 2457, 607>, 0, <607, 2393, 4355>, 0, <608, 2457, 2394>, 0, <2457, 4355, 2394>, 0, <489, 2394, 4355>, 0, <489, 4355, 2190>, 0, <2454, 4356, 2435>, 0, <2435, 606, 2454>, 0, <4356, 2455, 597>, 0, 
			<597, 2435, 4356>, 0, <598, 2455, 2452>, 0, <2455, 4356, 2452>, 0, <623, 2452, 4356>, 0, <4356, 2454, 623>, 0, <597, 2464, 2435>, 0, <2464, 4357, 2435>, 0, <606, 2435, 4357>, 0, <4357, 2469, 606>, 0, <2469, 4357, 2450>, 0, <2450, 621, 2469>, 0, 
			<4357, 2464, 596>, 0, <596, 2450, 4357>, 0, <2467, 4358, 2449>, 0, <2449, 620, 2467>, 0, <4358, 2456, 595>, 0, <595, 2449, 4358>, 0, <596, 2456, 2450>, 0, <2456, 4358, 2450>, 0, <621, 2450, 4358>, 0, <4358, 2467, 621>, 0, <2472, 4359, 2448>, 0, 
			<2448, 619, 2472>, 0, <2448, 4359, 2474>, 0, <2448, 2474, 594>, 0, <595, 2474, 4359>, 0, <4359, 2449, 595>, 0, <620, 2449, 4359>, 0, <4359, 2472, 620>, 0, <2482, 4360, 2447>, 0, <2447, 618, 2482>, 0, <2447, 4360, 2463>, 0, <2447, 2463, 593>, 0, 
			<594, 2463, 4360>, 0, <4360, 2448, 594>, 0, <619, 2448, 4360>, 0, <4360, 2482, 619>, 0, <617, 2484, 4361>, 0, <617, 4361, 2446>, 0, <2446, 4361, 592>, 0, <4361, 2453, 592>, 0, <593, 2453, 4361>, 0, <4361, 2447, 593>, 0, <2447, 4361, 2484>, 0, 
			<2484, 618, 2447>, 0, <616, 2459, 4362>, 0, <616, 4362, 2445>, 0, <2445, 4362, 591>, 0, <4362, 2460, 591>, 0, <2460, 4362, 2446>, 0, <2446, 592, 2460>, 0, <2446, 4362, 2459>, 0, <2459, 617, 2446>, 0, <615, 2476, 4363>, 0, <615, 4363, 2444>, 0, 
			<2444, 4363, 2461>, 0, <2444, 2461, 590>, 0, <591, 2461, 4363>, 0, <4363, 2445, 591>, 0, <2445, 4363, 2476>, 0, <2476, 616, 2445>, 0, <614, 2485, 4364>, 0, <614, 4364, 2443>, 0, <2443, 4364, 2487>, 0, <2443, 2487, 589>, 0, <590, 2487, 4364>, 0, 
			<4364, 2444, 590>, 0, <2444, 4364, 2485>, 0, <2485, 615, 2444>, 0, <589, 2486, 4365>, 0, <4365, 2443, 589>, 0, <2443, 4365, 2462>, 0, <2462, 614, 2443>, 0, <622, 2462, 2451>, 0, <2462, 4365, 2451>, 0, <2451, 4365, 2486>, 0, <2451, 2486, 588>, 0, 
			<613, 2481, 2442>, 0, <2481, 4366, 2442>, 0, <2442, 4366, 605>, 0, <4366, 2466, 605>, 0, <2466, 4366, 2451>, 0, <2451, 588, 2466>, 0, <622, 2451, 4366>, 0, <622, 4366, 2481>, 0, <612, 2465, 2441>, 0, <2465, 4367, 2441>, 0, <2441, 4367, 604>, 0, 
			<4367, 2478, 604>, 0, <2478, 4367, 2442>, 0, <2442, 605, 2478>, 0, <613, 2442, 4367>, 0, <613, 4367, 2465>, 0, <611, 2480, 2440>, 0, <2480, 4368, 2440>, 0, <2440, 4368, 2471>, 0, <2471, 603, 2440>, 0, <604, 2471, 4368>, 0, <604, 4368, 2441>, 0, 
			<612, 2441, 4368>, 0, <612, 4368, 2480>, 0, <610, 2470, 2439>, 0, <2470, 4369, 2439>, 0, <4369, 2475, 602>, 0, <602, 2439, 4369>, 0, <603, 2475, 4369>, 0, <603, 4369, 2440>, 0, <611, 2440, 4369>, 0, <611, 4369, 2470>, 0, <609, 2477, 4370>, 0, 
			<4370, 2438, 609>, 0, <4370, 2483, 601>, 0, <601, 2438, 4370>, 0, <602, 2483, 2439>, 0, <2483, 4370, 2439>, 0, <610, 2439, 2477>, 0, <2439, 4370, 2477>, 0, <608, 2468, 4371>, 0, <4371, 2437, 608>, 0, <4371, 2488, 600>, 0, <600, 2437, 4371>, 0, 
			<601, 2488, 2438>, 0, <2488, 4371, 2438>, 0, <609, 2438, 2468>, 0, <2438, 4371, 2468>, 0, <607, 2457, 4372>, 0, <4372, 2436, 607>, 0, <2436, 4372, 2479>, 0, <2479, 599, 2436>, 0, <600, 2479, 4372>, 0, <600, 4372, 2437>, 0, <608, 2437, 2457>, 0, 
			<2437, 4372, 2457>, 0, <599, 2473, 4373>, 0, <599, 4373, 2436>, 0, <607, 2436, 2458>, 0, <2436, 4373, 2458>, 0, <623, 2458, 4373>, 0, <4373, 2452, 623>, 0, <2452, 4373, 2473>, 0, <2473, 598, 2452>, 0, <2185, 4374, 482>, 0, <4374, 2184, 482>, 0, 
			<2184, 4374, 2505>, 0, <2505, 481, 2184>, 0, <620, 2505, 4374>, 0, <620, 4374, 2467>, 0, <2467, 4374, 2506>, 0, <2467, 2506, 621>, 0, <483, 2506, 4374>, 0, <4374, 2185, 483>, 0, <4375, 2178, 476>, 0, <476, 2179, 4375>, 0, <4375, 2509, 475>, 0, 
			<475, 2178, 4375>, 0, <2509, 4375, 2484>, 0, <2509, 2484, 617>, 0, <2484, 4375, 2503>, 0, <2484, 2503, 618>, 0, <477, 2503, 4375>, 0, <477, 4375, 2179>, 0, <4376, 2176, 474>, 0, <474, 2177, 4376>, 0, <4376, 2508, 473>, 0, <473, 2176, 4376>, 0, 
			<2508, 4376, 2459>, 0, <2508, 2459, 616>, 0, <2459, 4376, 2509>, 0, <2459, 2509, 617>, 0, <475, 2509, 4376>, 0, <475, 4376, 2177>, 0, <2183, 4377, 480>, 0, <4377, 2182, 480>, 0, <479, 2182, 4377>, 0, <479, 4377, 2504>, 0, <2504, 4377, 2472>, 0, 
			<2504, 2472, 619>, 0, <2472, 4377, 2505>, 0, <2472, 2505, 620>, 0, <481, 2505, 4377>, 0, <4377, 2183, 481>, 0, <468, 2510, 4378>, 0, <4378, 2171, 468>, 0, <2171, 4378, 2186>, 0, <2171, 2186, 484>, 0, <2186, 4378, 2506>, 0, <2506, 483, 2186>, 0, 
			<621, 2506, 4378>, 0, <621, 4378, 2469>, 0, <2469, 4378, 2510>, 0, <2469, 2510, 606>, 0, <2181, 4379, 478>, 0, <4379, 2180, 478>, 0, <477, 2180, 4379>, 0, <477, 4379, 2503>, 0, <618, 2503, 2482>, 0, <2503, 4379, 2482>, 0, <2482, 4379, 2504>, 0, 
			<2482, 2504, 619>, 0, <479, 2504, 4379>, 0, <4379, 2181, 479>, 0, <4380, 2174, 472>, 0, <472, 2175, 4380>, 0, <4380, 2507, 471>, 0, <471, 2174, 4380>, 0, <615, 2507, 2476>, 0, <2507, 4380, 2476>, 0, <616, 2476, 4380>, 0, <616, 4380, 2508>, 0, 
			<2508, 4380, 2175>, 0, <2175, 473, 2508>, 0, <2173, 4381, 2172>, 0, <2173, 2172, 470>, 0, <4381, 2511, 469>, 0, <469, 2172, 4381>, 0, <614, 2511, 2485>, 0, <2511, 4381, 2485>, 0, <615, 2485, 4381>, 0, <615, 4381, 2507>, 0, <2507, 4381, 2173>, 0, 
			<2173, 471, 2507>, 0, <457, 2382, 4382>, 0, <4382, 2149, 457>, 0, <2149, 4382, 2383>, 0, <2383, 458, 2149>, 0, <4382, 2399, 578>, 0, <578, 2383, 4382>, 0, <2399, 4382, 2382>, 0, <2399, 2382, 577>, 0, <2392, 4383, 2169>, 0, <2169, 467, 2392>, 0, 
			<450, 2169, 4383>, 0, <450, 4383, 2375>, 0, <2375, 4383, 2400>, 0, <2375, 2400, 570>, 0, <2400, 4383, 587>, 0, <4383, 2392, 587>, 0, <454, 2379, 4384>, 0, <4384, 2143, 454>, 0, <2143, 4384, 2380>, 0, <2380, 455, 2143>, 0, <4384, 2401, 575>, 0, 
			<575, 2380, 4384>, 0, <2401, 4384, 2379>, 0, <2401, 2379, 574>, 0, <456, 2381, 4385>, 0, <4385, 2147, 456>, 0, <2147, 4385, 2382>, 0, <2382, 457, 2147>, 0, <4385, 2402, 577>, 0, <577, 2382, 4385>, 0, <2402, 4385, 2381>, 0, <2402, 2381, 576>, 0, 
			<485, 2489, 4386>, 0, <4386, 2203, 485>, 0, <2203, 4386, 2510>, 0, <2510, 468, 2203>, 0, <4386, 2454, 606>, 0, <606, 2510, 4386>, 0, <2454, 4386, 2489>, 0, <2454, 2489, 623>, 0, <2389, 4387, 2163>, 0, <2163, 464, 2389>, 0, <465, 2163, 4387>, 0, 
			<465, 4387, 2390>, 0, <2390, 4387, 2403>, 0, <2390, 2403, 585>, 0, <2403, 4387, 584>, 0, <4387, 2389, 584>, 0, <2391, 4388, 2167>, 0, <2167, 466, 2391>, 0, <467, 2167, 4388>, 0, <467, 4388, 2392>, 0, <2392, 4388, 2404>, 0, <2392, 2404, 587>, 0, 
			<2404, 4388, 586>, 0, <4388, 2391, 586>, 0, <459, 2384, 4389>, 0, <459, 4389, 2153>, 0, <460, 2153, 2385>, 0, <2153, 4389, 2385>, 0, <2385, 4389, 580>, 0, <4389, 2405, 580>, 0, <2405, 4389, 2384>, 0, <2384, 579, 2405>, 0, <2387, 4390, 2159>, 0, 
			<2159, 462, 2387>, 0, <463, 2159, 4390>, 0, <463, 4390, 2388>, 0, <2388, 4390, 2406>, 0, <2388, 2406, 583>, 0, <2406, 4390, 582>, 0, <4390, 2387, 582>, 0, <2390, 4391, 2165>, 0, <2165, 465, 2390>, 0, <466, 2165, 4391>, 0, <466, 4391, 2391>, 0, 
			<2391, 4391, 2407>, 0, <2391, 2407, 586>, 0, <2407, 4391, 585>, 0, <4391, 2390, 585>, 0, <2386, 4392, 2157>, 0, <2157, 461, 2386>, 0, <462, 2157, 4392>, 0, <462, 4392, 2387>, 0, <2387, 4392, 2408>, 0, <2387, 2408, 582>, 0, <2408, 4392, 581>, 0, 
			<4392, 2386, 581>, 0, <452, 2377, 4393>, 0, <4393, 2139, 452>, 0, <2139, 4393, 2378>, 0, <2378, 453, 2139>, 0, <4393, 2409, 573>, 0, <573, 2378, 4393>, 0, <2409, 4393, 2377>, 0, <2409, 2377, 572>, 0, <450, 2375, 4394>, 0, <4394, 2135, 450>, 0, 
			<2135, 4394, 2376>, 0, <2376, 451, 2135>, 0, <4394, 2410, 571>, 0, <571, 2376, 4394>, 0, <4394, 2375, 570>, 0, <570, 2410, 4394>, 0, <453, 2378, 4395>, 0, <4395, 2141, 453>, 0, <2141, 4395, 2379>, 0, <2379, 454, 2141>, 0, <4395, 2411, 574>, 0, 
			<574, 2379, 4395>, 0, <2411, 4395, 2378>, 0, <2411, 2378, 573>, 0, <458, 2383, 4396>, 0, <4396, 2151, 458>, 0, <2151, 4396, 2384>, 0, <2384, 459, 2151>, 0, <4396, 2412, 579>, 0, <579, 2384, 4396>, 0, <2412, 4396, 2383>, 0, <2412, 2383, 578>, 0, 
			<455, 2380, 4397>, 0, <4397, 2145, 455>, 0, <2145, 4397, 2381>, 0, <2381, 456, 2145>, 0, <4397, 2413, 576>, 0, <576, 2381, 4397>, 0, <2413, 4397, 2380>, 0, <2413, 2380, 575>, 0, <2385, 4398, 2155>, 0, <2155, 460, 2385>, 0, <461, 2155, 4398>, 0, 
			<461, 4398, 2386>, 0, <2386, 4398, 2414>, 0, <2386, 2414, 581>, 0, <2414, 4398, 580>, 0, <4398, 2385, 580>, 0, <2388, 4399, 2161>, 0, <2161, 463, 2388>, 0, <464, 2161, 4399>, 0, <464, 4399, 2389>, 0, <2389, 4399, 2415>, 0, <2389, 2415, 584>, 0, 
			<2415, 4399, 583>, 0, <4399, 2388, 583>, 0, <451, 2376, 4400>, 0, <4400, 2137, 451>, 0, <2137, 4400, 2377>, 0, <2377, 452, 2137>, 0, <4400, 2416, 572>, 0, <572, 2377, 4400>, 0, <2416, 4400, 2376>, 0, <2416, 2376, 571>, 0, <574, 2421, 4401>, 0, 
			<4401, 2401, 574>, 0, <2401, 4401, 2422>, 0, <2422, 575, 2401>, 0, <2422, 4401, 2453>, 0, <2453, 593, 2422>, 0, <2453, 4401, 2421>, 0, <2453, 2421, 592>, 0, <579, 2426, 4402>, 0, <579, 4402, 2405>, 0, <580, 2405, 2427>, 0, <2405, 4402, 2427>, 0, 
			<2427, 4402, 598>, 0, <4402, 2455, 598>, 0, <2455, 4402, 2426>, 0, <2426, 597, 2455>, 0, <577, 2424, 4403>, 0, <4403, 2399, 577>, 0, <2399, 4403, 2425>, 0, <2425, 578, 2399>, 0, <4403, 2456, 596>, 0, <596, 2425, 4403>, 0, <2456, 4403, 2424>, 0, 
			<2456, 2424, 595>, 0, <573, 2420, 4404>, 0, <4404, 2411, 573>, 0, <2411, 4404, 2421>, 0, <2421, 574, 2411>, 0, <4404, 2460, 592>, 0, <592, 2421, 4404>, 0, <2460, 4404, 2420>, 0, <2460, 2420, 591>, 0, <572, 2419, 4405>, 0, <4405, 2409, 572>, 0, 
			<2409, 4405, 2420>, 0, <2420, 573, 2409>, 0, <4405, 2461, 591>, 0, <591, 2420, 4405>, 0, <2461, 4405, 2419>, 0, <2461, 2419, 590>, 0, <575, 2422, 4406>, 0, <4406, 2413, 575>, 0, <2413, 4406, 2423>, 0, <2423, 576, 2413>, 0, <2423, 4406, 2463>, 0, 
			<2463, 594, 2423>, 0, <4406, 2422, 593>, 0, <593, 2463, 4406>, 0, <578, 2425, 4407>, 0, <4407, 2412, 578>, 0, <2412, 4407, 2426>, 0, <2426, 579, 2412>, 0, <2426, 4407, 597>, 0, <4407, 2464, 597>, 0, <2464, 4407, 2425>, 0, <2425, 596, 2464>, 0, 
			<2434, 4408, 2400>, 0, <2400, 587, 2434>, 0, <570, 2400, 4408>, 0, <570, 4408, 2417>, 0, <4408, 2466, 588>, 0, <588, 2417, 4408>, 0, <2466, 4408, 2434>, 0, <2466, 2434, 605>, 0, <2432, 4409, 2407>, 0, <2407, 585, 2432>, 0, <586, 2407, 4409>, 0, 
			<586, 4409, 2433>, 0, <2433, 4409, 2471>, 0, <2433, 2471, 604>, 0, <2471, 4409, 603>, 0, <4409, 2432, 603>, 0, <2427, 4410, 2414>, 0, <2414, 580, 2427>, 0, <581, 2414, 4410>, 0, <581, 4410, 2428>, 0, <2428, 4410, 2473>, 0, <2428, 2473, 599>, 0, 
			<2473, 4410, 598>, 0, <4410, 2427, 598>, 0, <576, 2423, 4411>, 0, <4411, 2402, 576>, 0, <2402, 4411, 2424>, 0, <2424, 577, 2402>, 0, <4411, 2474, 595>, 0, <595, 2424, 4411>, 0, <2474, 4411, 2423>, 0, <2474, 2423, 594>, 0, <2431, 4412, 2403>, 0, 
			<2403, 584, 2431>, 0, <585, 2403, 4412>, 0, <585, 4412, 2432>, 0, <2432, 4412, 2475>, 0, <2432, 2475, 603>, 0, <2475, 4412, 2431>, 0, <2431, 602, 2475>, 0, <2433, 4413, 2404>, 0, <2404, 586, 2433>, 0, <587, 2404, 4413>, 0, <587, 4413, 2434>, 0, 
			<2434, 4413, 2478>, 0, <2434, 2478, 605>, 0, <2478, 4413, 604>, 0, <4413, 2433, 604>, 0, <2428, 4414, 2408>, 0, <2408, 581, 2428>, 0, <582, 2408, 4414>, 0, <582, 4414, 2429>, 0, <2429, 4414, 2479>, 0, <2429, 2479, 600>, 0, <2479, 4414, 599>, 0, 
			<4414, 2428, 599>, 0, <2430, 4415, 2415>, 0, <2415, 583, 2430>, 0, <584, 2415, 4415>, 0, <584, 4415, 2431>, 0, <2431, 4415, 602>, 0, <4415, 2483, 602>, 0, <2483, 4415, 2430>, 0, <2430, 601, 2483>, 0, <570, 2417, 4416>, 0, <4416, 2410, 570>, 0, 
			<2410, 4416, 2418>, 0, <2418, 571, 2410>, 0, <2418, 4416, 2486>, 0, <2486, 589, 2418>, 0, <4416, 2417, 588>, 0, <588, 2486, 4416>, 0, <571, 2418, 4417>, 0, <4417, 2416, 571>, 0, <2416, 4417, 2419>, 0, <2419, 572, 2416>, 0, <2419, 4417, 2487>, 0, 
			<2487, 590, 2419>, 0, <4417, 2418, 589>, 0, <589, 2487, 4417>, 0, <2429, 4418, 2406>, 0, <2406, 582, 2429>, 0, <583, 2406, 4418>, 0, <583, 4418, 2430>, 0, <2430, 4418, 2488>, 0, <2430, 2488, 601>, 0, <2488, 4418, 600>, 0, <4418, 2429, 600>, 0, 
			<2188, 4419, 486>, 0, <4419, 2187, 486>, 0, <2187, 4419, 2489>, 0, <2489, 485, 2187>, 0, <4419, 2458, 623>, 0, <623, 2489, 4419>, 0, <607, 2458, 2393>, 0, <2458, 4419, 2393>, 0, <487, 2393, 4419>, 0, <4419, 2188, 487>, 0, <4420, 2199, 498>, 0, 
			<498, 2200, 4420>, 0, <497, 2199, 4420>, 0, <497, 4420, 2398>, 0, <2398, 4420, 2465>, 0, <2398, 2465, 612>, 0, <2465, 4420, 613>, 0, <4420, 2491, 613>, 0, <2491, 4420, 2200>, 0, <2200, 499, 2491>, 0, <4421, 1950, 354>, 0, <354, 2498, 4421>, 0, 
			<1950, 4421, 2493>, 0, <1950, 2493, 448>, 0, <2493, 4421, 345>, 0, <4421, 1992, 345>, 0, <1992, 4421, 2498>, 0, <2498, 313, 1992>, 0, <1904, 328, 1919>, 0, <1904, 1919, 4422>, 0, <312, 1904, 4422>, 0, <312, 4422, 2499>, 0, <346, 2499, 1958>, 0, 
			<2499, 4422, 1958>, 0, <361, 1958, 4422>, 0, <361, 4422, 2500>, 0, <2500, 4422, 1919>, 0, <1919, 327, 2500>, 0, <319, 2495, 4423>, 0, <4423, 1911, 319>, 0, <1911, 4423, 320>, 0, <4423, 1912, 320>, 0, <321, 1912, 4423>, 0, <321, 4423, 2494>, 0, 
			<2494, 4423, 1954>, 0, <2494, 1954, 358>, 0, <1954, 4423, 2495>, 0, <1954, 2495, 357>, 0, <317, 2496, 4424>, 0, <4424, 1909, 317>, 0, <1909, 4424, 318>, 0, <4424, 1910, 318>, 0, <319, 1910, 4424>, 0, <319, 4424, 2495>, 0, <2495, 4424, 1953>, 0, 
			<2495, 1953, 357>, 0, <1953, 4424, 2496>, 0, <1953, 2496, 356>, 0, <315, 2497, 4425>, 0, <4425, 1907, 315>, 0, <1907, 4425, 316>, 0, <4425, 1908, 316>, 0, <1908, 4425, 2496>, 0, <2496, 317, 1908>, 0, <356, 2496, 4425>, 0, <356, 4425, 1952>, 0, 
			<1952, 4425, 2497>, 0, <1952, 2497, 355>, 0, <313, 2498, 4426>, 0, <4426, 1905, 313>, 0, <1905, 4426, 1906>, 0, <1905, 1906, 314>, 0, <1906, 4426, 2497>, 0, <2497, 315, 1906>, 0, <355, 2497, 4426>, 0, <355, 4426, 1951>, 0, <1951, 4426, 2498>, 0, 
			<1951, 2498, 354>, 0, <2499, 4427, 1991>, 0, <1991, 312, 2499>, 0, <4427, 2492, 329>, 0, <329, 1991, 4427>, 0, <2492, 4427, 2132>, 0, <2492, 2132, 449>, 0, <2132, 4427, 346>, 0, <4427, 2499, 346>, 0, <2501, 4428, 1917>, 0, <1917, 325, 2501>, 0, 
			<4428, 1918, 326>, 0, <326, 1917, 4428>, 0, <4428, 2500, 327>, 0, <327, 1918, 4428>, 0, <2500, 4428, 1957>, 0, <2500, 1957, 361>, 0, <360, 1957, 4428>, 0, <360, 4428, 2501>, 0, <323, 2502, 4429>, 0, <323, 4429, 1915>, 0, <4429, 1916, 324>, 0, 
			<324, 1915, 4429>, 0, <4429, 2501, 325>, 0, <325, 1916, 4429>, 0, <2501, 4429, 1956>, 0, <2501, 1956, 360>, 0, <1956, 4429, 2502>, 0, <1956, 2502, 359>, 0, <321, 2494, 4430>, 0, <321, 4430, 1913>, 0, <4430, 1914, 322>, 0, <322, 1913, 4430>, 0, 
			<4430, 2502, 323>, 0, <323, 1914, 4430>, 0, <2502, 4430, 1955>, 0, <2502, 1955, 359>, 0, <1955, 4430, 2494>, 0, <1955, 2494, 358>, 0, <2511, 4431, 2204>, 0, <2204, 469, 2511>, 0, <4431, 2490, 501>, 0, <501, 2204, 4431>, 0, <2490, 4431, 2462>, 0, 
			<2490, 2462, 622>, 0, <2462, 4431, 614>, 0, <4431, 2511, 614>, 0, <626, 2519, 2515>, 0, <2519, 4432, 2515>, 0, <4432, 2516, 625>, 0, <625, 2515, 4432>, 0, <2516, 4432, 2540>, 0, <2516, 2540, 634>, 0, <635, 2540, 4432>, 0, <4432, 2519, 635>, 0, 
			<627, 2522, 2518>, 0, <2522, 4433, 2518>, 0, <2518, 4433, 626>, 0, <4433, 2519, 626>, 0, <2519, 4433, 2542>, 0, <2519, 2542, 635>, 0, <636, 2542, 4433>, 0, <636, 4433, 2522>, 0, <628, 2525, 4434>, 0, <628, 4434, 2521>, 0, <2521, 4434, 2522>, 0, 
			<2521, 2522, 627>, 0, <2522, 4434, 2544>, 0, <2544, 636, 2522>, 0, <2544, 4434, 2525>, 0, <2525, 637, 2544>, 0, <629, 2528, 4435>, 0, <629, 4435, 2524>, 0, <2524, 4435, 628>, 0, <4435, 2525, 628>, 0, <2525, 4435, 637>, 0, <4435, 2546, 637>, 0, 
			<638, 2546, 4435>, 0, <638, 4435, 2528>, 0, <630, 2531, 2527>, 0, <2531, 4436, 2527>, 0, <2527, 4436, 629>, 0, <4436, 2528, 629>, 0, <2528, 4436, 2548>, 0, <2548, 638, 2528>, 0, <639, 2548, 4436>, 0, <639, 4436, 2531>, 0, <631, 2534, 2530>, 0, 
			<2534, 4437, 2530>, 0, <2530, 4437, 630>, 0, <4437, 2531, 630>, 0, <2531, 4437, 2550>, 0, <2550, 639, 2531>, 0, <640, 2550, 4437>, 0, <640, 4437, 2534>, 0, <632, 2536, 2533>, 0, <2536, 4438, 2533>, 0, <2533, 4438, 631>, 0, <4438, 2534, 631>, 0, 
			<2534, 4438, 640>, 0, <4438, 2552, 640>, 0, <641, 2552, 2536>, 0, <2552, 4438, 2536>, 0, <624, 2513, 4439>, 0, <4439, 2512, 624>, 0, <2512, 4439, 2536>, 0, <2512, 2536, 632>, 0, <4439, 2538, 641>, 0, <641, 2536, 4439>, 0, <633, 2538, 2513>, 0, 
			<2538, 4439, 2513>, 0, <2543, 4440, 2540>, 0, <2540, 635, 2543>, 0, <4440, 2541, 634>, 0, <634, 2540, 4440>, 0, <2541, 4440, 2557>, 0, <2541, 2557, 643>, 0, <644, 2557, 4440>, 0, <4440, 2543, 644>, 0, <2545, 4441, 2542>, 0, <2542, 636, 2545>, 0, 
			<4441, 2543, 635>, 0, <635, 2542, 4441>, 0, <2543, 4441, 2559>, 0, <2543, 2559, 644>, 0, <645, 2559, 4441>, 0, <4441, 2545, 645>, 0, <2547, 4442, 2544>, 0, <2544, 637, 2547>, 0, <4442, 2545, 636>, 0, <636, 2544, 4442>, 0, <2545, 4442, 2561>, 0, 
			<2545, 2561, 645>, 0, <646, 2561, 4442>, 0, <4442, 2547, 646>, 0, <638, 2549, 2546>, 0, <2549, 4443, 2546>, 0, <2546, 4443, 2547>, 0, <2546, 2547, 637>, 0, <2547, 4443, 2563>, 0, <2547, 2563, 646>, 0, <647, 2563, 4443>, 0, <4443, 2549, 647>, 0, 
			<639, 2551, 2548>, 0, <2551, 4444, 2548>, 0, <2548, 4444, 638>, 0, <4444, 2549, 638>, 0, <4444, 2565, 647>, 0, <647, 2549, 4444>, 0, <648, 2565, 2551>, 0, <2565, 4444, 2551>, 0, <640, 2553, 4445>, 0, <4445, 2550, 640>, 0, <2550, 4445, 2551>, 0, 
			<2551, 639, 2550>, 0, <4445, 2567, 648>, 0, <648, 2551, 4445>, 0, <649, 2567, 2553>, 0, <2567, 4445, 2553>, 0, <641, 2554, 4446>, 0, <4446, 2552, 641>, 0, <2552, 4446, 2553>, 0, <2553, 640, 2552>, 0, <4446, 2569, 649>, 0, <649, 2553, 4446>, 0, 
			<650, 2569, 2554>, 0, <2569, 4446, 2554>, 0, <633, 2539, 4447>, 0, <4447, 2538, 633>, 0, <2538, 4447, 2554>, 0, <2554, 641, 2538>, 0, <4447, 2555, 650>, 0, <650, 2554, 4447>, 0, <642, 2555, 2539>, 0, <2555, 4447, 2539>, 0, <2560, 4448, 2557>, 0, 
			<2557, 644, 2560>, 0, <4448, 2558, 643>, 0, <643, 2557, 4448>, 0, <2558, 4448, 2574>, 0, <2558, 2574, 652>, 0, <653, 2574, 4448>, 0, <4448, 2560, 653>, 0, <2562, 4449, 2559>, 0, <2559, 645, 2562>, 0, <4449, 2560, 644>, 0, <644, 2559, 4449>, 0, 
			<2560, 4449, 2576>, 0, <2560, 2576, 653>, 0, <654, 2576, 4449>, 0, <4449, 2562, 654>, 0, <2564, 4450, 2561>, 0, <2561, 646, 2564>, 0, <4450, 2562, 645>, 0, <645, 2561, 4450>, 0, <2562, 4450, 2578>, 0, <2562, 2578, 654>, 0, <655, 2578, 4450>, 0, 
			<4450, 2564, 655>, 0, <2566, 4451, 2563>, 0, <2563, 647, 2566>, 0, <4451, 2564, 646>, 0, <646, 2563, 4451>, 0, <2564, 4451, 2580>, 0, <2564, 2580, 655>, 0, <656, 2580, 4451>, 0, <4451, 2566, 656>, 0, <648, 2568, 4452>, 0, <4452, 2565, 648>, 0, 
			<2565, 4452, 2566>, 0, <2566, 647, 2565>, 0, <4452, 2582, 656>, 0, <656, 2566, 4452>, 0, <657, 2582, 2568>, 0, <2582, 4452, 2568>, 0, <649, 2570, 4453>, 0, <4453, 2567, 649>, 0, <2567, 4453, 2568>, 0, <2568, 648, 2567>, 0, <4453, 2584, 657>, 0, 
			<657, 2568, 4453>, 0, <658, 2584, 2570>, 0, <2584, 4453, 2570>, 0, <650, 2571, 4454>, 0, <4454, 2569, 650>, 0, <2569, 4454, 2570>, 0, <2570, 649, 2569>, 0, <4454, 2586, 658>, 0, <658, 2570, 4454>, 0, <659, 2586, 2571>, 0, <2586, 4454, 2571>, 0, 
			<642, 2556, 4455>, 0, <4455, 2555, 642>, 0, <2555, 4455, 2571>, 0, <2571, 650, 2555>, 0, <4455, 2572, 659>, 0, <659, 2571, 4455>, 0, <651, 2572, 2556>, 0, <2572, 4455, 2556>, 0, <2577, 4456, 2574>, 0, <2574, 653, 2577>, 0, <4456, 2575, 652>, 0, 
			<652, 2574, 4456>, 0, <2575, 4456, 2591>, 0, <2575, 2591, 661>, 0, <662, 2591, 4456>, 0, <4456, 2577, 662>, 0, <2579, 4457, 2576>, 0, <2576, 654, 2579>, 0, <4457, 2577, 653>, 0, <653, 2576, 4457>, 0, <2577, 4457, 2593>, 0, <2577, 2593, 662>, 0, 
			<663, 2593, 4457>, 0, <4457, 2579, 663>, 0, <2581, 4458, 2578>, 0, <2578, 655, 2581>, 0, <4458, 2579, 654>, 0, <654, 2578, 4458>, 0, <2579, 4458, 2595>, 0, <2579, 2595, 663>, 0, <664, 2595, 4458>, 0, <4458, 2581, 664>, 0, <2583, 4459, 2580>, 0, 
			<2580, 656, 2583>, 0, <4459, 2581, 655>, 0, <655, 2580, 4459>, 0, <2581, 4459, 2597>, 0, <2581, 2597, 664>, 0, <665, 2597, 4459>, 0, <4459, 2583, 665>, 0, <657, 2585, 4460>, 0, <4460, 2582, 657>, 0, <2582, 4460, 2583>, 0, <2583, 656, 2582>, 0, 
			<4460, 2599, 665>, 0, <665, 2583, 4460>, 0, <666, 2599, 2585>, 0, <2599, 4460, 2585>, 0, <658, 2587, 4461>, 0, <4461, 2584, 658>, 0, <2584, 4461, 2585>, 0, <2585, 657, 2584>, 0, <4461, 2601, 666>, 0, <666, 2585, 4461>, 0, <667, 2601, 2587>, 0, 
			<2601, 4461, 2587>, 0, <659, 2588, 4462>, 0, <4462, 2586, 659>, 0, <2586, 4462, 2587>, 0, <2587, 658, 2586>, 0, <4462, 2603, 667>, 0, <667, 2587, 4462>, 0, <668, 2603, 2588>, 0, <2603, 4462, 2588>, 0, <651, 2573, 4463>, 0, <4463, 2572, 651>, 0, 
			<2572, 4463, 2588>, 0, <2588, 659, 2572>, 0, <4463, 2589, 668>, 0, <668, 2588, 4463>, 0, <660, 2589, 2573>, 0, <2589, 4463, 2573>, 0, <2594, 4464, 2591>, 0, <2591, 662, 2594>, 0, <4464, 2592, 661>, 0, <661, 2591, 4464>, 0, <2592, 4464, 2608>, 0, 
			<2592, 2608, 670>, 0, <671, 2608, 4464>, 0, <4464, 2594, 671>, 0, <2596, 4465, 2593>, 0, <2593, 663, 2596>, 0, <4465, 2594, 662>, 0, <662, 2593, 4465>, 0, <2594, 4465, 2610>, 0, <2594, 2610, 671>, 0, <672, 2610, 4465>, 0, <4465, 2596, 672>, 0, 
			<2598, 4466, 2595>, 0, <2595, 664, 2598>, 0, <4466, 2596, 663>, 0, <663, 2595, 4466>, 0, <2596, 4466, 2612>, 0, <2596, 2612, 672>, 0, <673, 2612, 4466>, 0, <4466, 2598, 673>, 0, <2600, 4467, 2597>, 0, <2597, 665, 2600>, 0, <4467, 2598, 664>, 0, 
			<664, 2597, 4467>, 0, <2598, 4467, 2614>, 0, <2598, 2614, 673>, 0, <674, 2614, 4467>, 0, <4467, 2600, 674>, 0, <666, 2602, 4468>, 0, <4468, 2599, 666>, 0, <2599, 4468, 2600>, 0, <2600, 665, 2599>, 0, <4468, 2616, 674>, 0, <674, 2600, 4468>, 0, 
			<675, 2616, 2602>, 0, <2616, 4468, 2602>, 0, <667, 2604, 4469>, 0, <4469, 2601, 667>, 0, <2601, 4469, 2602>, 0, <2602, 666, 2601>, 0, <4469, 2618, 675>, 0, <675, 2602, 4469>, 0, <676, 2618, 2604>, 0, <2618, 4469, 2604>, 0, <668, 2605, 4470>, 0, 
			<4470, 2603, 668>, 0, <2603, 4470, 2604>, 0, <2604, 667, 2603>, 0, <4470, 2620, 676>, 0, <676, 2604, 4470>, 0, <677, 2620, 2605>, 0, <2620, 4470, 2605>, 0, <660, 2590, 4471>, 0, <4471, 2589, 660>, 0, <2589, 4471, 2605>, 0, <2605, 668, 2589>, 0, 
			<4471, 2606, 677>, 0, <677, 2605, 4471>, 0, <669, 2606, 2590>, 0, <2606, 4471, 2590>, 0, <2611, 4472, 2608>, 0, <2608, 671, 2611>, 0, <4472, 2609, 670>, 0, <670, 2608, 4472>, 0, <2609, 4472, 2625>, 0, <2609, 2625, 679>, 0, <680, 2625, 4472>, 0, 
			<4472, 2611, 680>, 0, <2613, 4473, 2610>, 0, <2610, 672, 2613>, 0, <4473, 2611, 671>, 0, <671, 2610, 4473>, 0, <2611, 4473, 2627>, 0, <2611, 2627, 680>, 0, <681, 2627, 4473>, 0, <4473, 2613, 681>, 0, <2615, 4474, 2612>, 0, <2612, 673, 2615>, 0, 
			<4474, 2613, 672>, 0, <672, 2612, 4474>, 0, <2613, 4474, 2629>, 0, <2613, 2629, 681>, 0, <682, 2629, 4474>, 0, <4474, 2615, 682>, 0, <2617, 4475, 2614>, 0, <2614, 674, 2617>, 0, <4475, 2615, 673>, 0, <673, 2614, 4475>, 0, <2615, 4475, 2631>, 0, 
			<2615, 2631, 682>, 0, <683, 2631, 4475>, 0, <4475, 2617, 683>, 0, <675, 2619, 4476>, 0, <4476, 2616, 675>, 0, <2616, 4476, 2617>, 0, <2617, 674, 2616>, 0, <4476, 2633, 683>, 0, <683, 2617, 4476>, 0, <684, 2633, 2619>, 0, <2633, 4476, 2619>, 0, 
			<676, 2621, 4477>, 0, <4477, 2618, 676>, 0, <2618, 4477, 2619>, 0, <2619, 675, 2618>, 0, <4477, 2635, 684>, 0, <684, 2619, 4477>, 0, <685, 2635, 2621>, 0, <2635, 4477, 2621>, 0, <677, 2622, 4478>, 0, <4478, 2620, 677>, 0, <2620, 4478, 2621>, 0, 
			<2621, 676, 2620>, 0, <4478, 2637, 685>, 0, <685, 2621, 4478>, 0, <686, 2637, 2622>, 0, <2637, 4478, 2622>, 0, <669, 2607, 4479>, 0, <4479, 2606, 669>, 0, <2606, 4479, 2622>, 0, <2622, 677, 2606>, 0, <4479, 2623, 686>, 0, <686, 2622, 4479>, 0, 
			<678, 2623, 2607>, 0, <2623, 4479, 2607>, 0, <2628, 4480, 2625>, 0, <2625, 680, 2628>, 0, <4480, 2626, 679>, 0, <679, 2625, 4480>, 0, <2626, 4480, 2642>, 0, <2626, 2642, 688>, 0, <689, 2642, 4480>, 0, <4480, 2628, 689>, 0, <2630, 4481, 2627>, 0, 
			<2627, 681, 2630>, 0, <4481, 2628, 680>, 0, <680, 2627, 4481>, 0, <2628, 4481, 2644>, 0, <2628, 2644, 689>, 0, <690, 2644, 4481>, 0, <4481, 2630, 690>, 0, <2632, 4482, 2629>, 0, <2629, 682, 2632>, 0, <4482, 2630, 681>, 0, <681, 2629, 4482>, 0, 
			<2630, 4482, 2646>, 0, <2630, 2646, 690>, 0, <691, 2646, 4482>, 0, <4482, 2632, 691>, 0, <2634, 4483, 2631>, 0, <2631, 683, 2634>, 0, <4483, 2632, 682>, 0, <682, 2631, 4483>, 0, <2632, 4483, 2648>, 0, <2632, 2648, 691>, 0, <692, 2648, 2634>, 0, 
			<2648, 4483, 2634>, 0, <684, 2636, 4484>, 0, <4484, 2633, 684>, 0, <2633, 4484, 2634>, 0, <2634, 683, 2633>, 0, <2634, 4484, 2650>, 0, <2634, 2650, 692>, 0, <693, 2650, 4484>, 0, <4484, 2636, 693>, 0, <685, 2638, 4485>, 0, <4485, 2635, 685>, 0, 
			<2635, 4485, 2636>, 0, <2636, 684, 2635>, 0, <4485, 2652, 693>, 0, <693, 2636, 4485>, 0, <694, 2652, 2638>, 0, <2652, 4485, 2638>, 0, <686, 2639, 4486>, 0, <4486, 2637, 686>, 0, <2637, 4486, 2638>, 0, <2638, 685, 2637>, 0, <4486, 2654, 694>, 0, 
			<694, 2638, 4486>, 0, <695, 2654, 2639>, 0, <2654, 4486, 2639>, 0, <678, 2624, 4487>, 0, <4487, 2623, 678>, 0, <2623, 4487, 2639>, 0, <2639, 686, 2623>, 0, <4487, 2640, 695>, 0, <695, 2639, 4487>, 0, <687, 2640, 2624>, 0, <2640, 4487, 2624>, 0, 
			<2645, 4488, 2642>, 0, <2642, 689, 2645>, 0, <4488, 2643, 688>, 0, <688, 2642, 4488>, 0, <2643, 4488, 2659>, 0, <2643, 2659, 697>, 0, <698, 2659, 4488>, 0, <4488, 2645, 698>, 0, <2647, 4489, 2644>, 0, <2644, 690, 2647>, 0, <4489, 2645, 689>, 0, 
			<689, 2644, 4489>, 0, <2645, 4489, 2661>, 0, <2645, 2661, 698>, 0, <699, 2661, 4489>, 0, <4489, 2647, 699>, 0, <2649, 4490, 2646>, 0, <2646, 691, 2649>, 0, <4490, 2647, 690>, 0, <690, 2646, 4490>, 0, <2647, 4490, 2663>, 0, <2647, 2663, 699>, 0, 
			<700, 2663, 4490>, 0, <4490, 2649, 700>, 0, <2651, 4491, 2648>, 0, <2648, 692, 2651>, 0, <4491, 2649, 691>, 0, <691, 2648, 4491>, 0, <2649, 4491, 2665>, 0, <2649, 2665, 700>, 0, <701, 2665, 4491>, 0, <4491, 2651, 701>, 0, <693, 2653, 4492>, 0, 
			<4492, 2650, 693>, 0, <4492, 2651, 692>, 0, <692, 2650, 4492>, 0, <2651, 4492, 2667>, 0, <2651, 2667, 701>, 0, <702, 2667, 4492>, 0, <4492, 2653, 702>, 0, <2655, 4493, 2652>, 0, <2652, 694, 2655>, 0, <4493, 2653, 693>, 0, <693, 2652, 4493>, 0, 
			<2653, 4493, 2669>, 0, <2653, 2669, 702>, 0, <703, 2669, 4493>, 0, <4493, 2655, 703>, 0, <695, 2656, 4494>, 0, <4494, 2654, 695>, 0, <4494, 2655, 694>, 0, <694, 2654, 4494>, 0, <2655, 4494, 2671>, 0, <2655, 2671, 703>, 0, <704, 2671, 4494>, 0, 
			<4494, 2656, 704>, 0, <687, 2641, 4495>, 0, <4495, 2640, 687>, 0, <2640, 4495, 2656>, 0, <2656, 695, 2640>, 0, <2656, 4495, 2657>, 0, <2656, 2657, 704>, 0, <696, 2657, 2641>, 0, <2657, 4495, 2641>, 0, <2662, 4496, 2659>, 0, <2659, 698, 2662>, 0, 
			<2659, 4496, 2660>, 0, <2659, 2660, 697>, 0, <2660, 4496, 706>, 0, <4496, 2676, 706>, 0, <2676, 4496, 2662>, 0, <2662, 707, 2676>, 0, <2664, 4497, 2661>, 0, <2661, 699, 2664>, 0, <4497, 2662, 698>, 0, <698, 2661, 4497>, 0, <2662, 4497, 707>, 0, 
			<4497, 2678, 707>, 0, <708, 2678, 4497>, 0, <4497, 2664, 708>, 0, <2666, 4498, 2663>, 0, <2663, 700, 2666>, 0, <4498, 2664, 699>, 0, <699, 2663, 4498>, 0, <2664, 4498, 2680>, 0, <2664, 2680, 708>, 0, <709, 2680, 4498>, 0, <4498, 2666, 709>, 0, 
			<2668, 4499, 2665>, 0, <2665, 701, 2668>, 0, <4499, 2666, 700>, 0, <700, 2665, 4499>, 0, <2666, 4499, 2682>, 0, <2666, 2682, 709>, 0, <710, 2682, 4499>, 0, <4499, 2668, 710>, 0, <702, 2670, 4500>, 0, <4500, 2667, 702>, 0, <4500, 2668, 701>, 0, 
			<701, 2667, 4500>, 0, <2668, 4500, 2684>, 0, <2668, 2684, 710>, 0, <711, 2684, 4500>, 0, <4500, 2670, 711>, 0, <2672, 4501, 2669>, 0, <2669, 703, 2672>, 0, <4501, 2670, 702>, 0, <702, 2669, 4501>, 0, <2670, 4501, 2686>, 0, <2670, 2686, 711>, 0, 
			<712, 2686, 4501>, 0, <4501, 2672, 712>, 0, <704, 2673, 4502>, 0, <4502, 2671, 704>, 0, <4502, 2672, 703>, 0, <703, 2671, 4502>, 0, <2672, 4502, 2688>, 0, <2672, 2688, 712>, 0, <713, 2688, 4502>, 0, <713, 4502, 2673>, 0, <696, 2658, 2657>, 0, 
			<2658, 4503, 2657>, 0, <4503, 2673, 704>, 0, <704, 2657, 4503>, 0, <2673, 4503, 2674>, 0, <2674, 713, 2673>, 0, <705, 2674, 4503>, 0, <705, 4503, 2658>, 0, <707, 2679, 4504>, 0, <707, 4504, 2676>, 0, <2676, 4504, 2677>, 0, <2676, 2677, 706>, 0, 
			<2677, 4504, 715>, 0, <4504, 2693, 715>, 0, <2693, 4504, 2679>, 0, <2679, 716, 2693>, 0, <708, 2681, 4505>, 0, <708, 4505, 2678>, 0, <2678, 4505, 2679>, 0, <2678, 2679, 707>, 0, <2679, 4505, 716>, 0, <4505, 2695, 716>, 0, <2695, 4505, 2681>, 0, 
			<2681, 717, 2695>, 0, <709, 2683, 4506>, 0, <709, 4506, 2680>, 0, <2680, 4506, 2681>, 0, <2680, 2681, 708>, 0, <2681, 4506, 717>, 0, <4506, 2697, 717>, 0, <2697, 4506, 2683>, 0, <2683, 718, 2697>, 0, <2685, 4507, 2682>, 0, <2682, 710, 2685>, 0, 
			<2682, 4507, 2683>, 0, <2683, 709, 2682>, 0, <2683, 4507, 718>, 0, <4507, 2699, 718>, 0, <2699, 4507, 2685>, 0, <2685, 719, 2699>, 0, <2687, 4508, 2684>, 0, <2684, 711, 2687>, 0, <2684, 4508, 2685>, 0, <2685, 710, 2684>, 0, <2685, 4508, 2701>, 0, 
			<2701, 719, 2685>, 0, <720, 2701, 4508>, 0, <720, 4508, 2687>, 0, <712, 2689, 2686>, 0, <2689, 4509, 2686>, 0, <2686, 4509, 711>, 0, <4509, 2687, 711>, 0, <2687, 4509, 2703>, 0, <2703, 720, 2687>, 0, <721, 2703, 4509>, 0, <721, 4509, 2689>, 0, 
			<713, 2690, 2688>, 0, <2690, 4510, 2688>, 0, <2688, 4510, 712>, 0, <4510, 2689, 712>, 0, <2689, 4510, 2705>, 0, <2705, 721, 2689>, 0, <722, 2705, 4510>, 0, <722, 4510, 2690>, 0, <705, 2675, 2674>, 0, <2675, 4511, 2674>, 0, <2674, 4511, 713>, 0, 
			<4511, 2690, 713>, 0, <2690, 4511, 2691>, 0, <2691, 722, 2690>, 0, <714, 2691, 4511>, 0, <714, 4511, 2675>, 0, <716, 2696, 4512>, 0, <716, 4512, 2693>, 0, <2693, 4512, 2694>, 0, <2693, 2694, 715>, 0, <2694, 4512, 724>, 0, <4512, 2710, 724>, 0, 
			<2710, 4512, 2696>, 0, <2696, 725, 2710>, 0, <717, 2698, 4513>, 0, <717, 4513, 2695>, 0, <2695, 4513, 2696>, 0, <2695, 2696, 716>, 0, <2696, 4513, 725>, 0, <4513, 2712, 725>, 0, <2712, 4513, 2698>, 0, <2698, 726, 2712>, 0, <718, 2700, 4514>, 0, 
			<718, 4514, 2697>, 0, <2697, 4514, 2698>, 0, <2697, 2698, 717>, 0, <2698, 4514, 726>, 0, <4514, 2714, 726>, 0, <2714, 4514, 2700>, 0, <2700, 727, 2714>, 0, <719, 2702, 4515>, 0, <719, 4515, 2699>, 0, <2699, 4515, 2700>, 0, <2699, 2700, 718>, 0, 
			<2700, 4515, 727>, 0, <4515, 2716, 727>, 0, <2716, 4515, 2702>, 0, <2702, 728, 2716>, 0, <720, 2704, 2701>, 0, <2704, 4516, 2701>, 0, <2701, 4516, 719>, 0, <4516, 2702, 719>, 0, <2702, 4516, 2718>, 0, <2718, 728, 2702>, 0, <729, 2718, 4516>, 0, 
			<729, 4516, 2704>, 0, <721, 2706, 2703>, 0, <2706, 4517, 2703>, 0, <2703, 4517, 720>, 0, <4517, 2704, 720>, 0, <2704, 4517, 2720>, 0, <2720, 729, 2704>, 0, <730, 2720, 4517>, 0, <730, 4517, 2706>, 0, <722, 2707, 2705>, 0, <2707, 4518, 2705>, 0, 
			<2705, 4518, 721>, 0, <4518, 2706, 721>, 0, <2706, 4518, 2722>, 0, <2722, 730, 2706>, 0, <731, 2722, 4518>, 0, <731, 4518, 2707>, 0, <714, 2692, 2691>, 0, <2692, 4519, 2691>, 0, <2691, 4519, 722>, 0, <4519, 2707, 722>, 0, <2707, 4519, 2708>, 0, 
			<2708, 731, 2707>, 0, <723, 2708, 4519>, 0, <723, 4519, 2692>, 0, <725, 2713, 4520>, 0, <725, 4520, 2710>, 0, <2710, 4520, 2711>, 0, <2710, 2711, 724>, 0, <2711, 4520, 733>, 0, <4520, 2727, 733>, 0, <2727, 4520, 2713>, 0, <2713, 734, 2727>, 0, 
			<726, 2715, 4521>, 0, <726, 4521, 2712>, 0, <2712, 4521, 2713>, 0, <2712, 2713, 725>, 0, <2713, 4521, 734>, 0, <4521, 2729, 734>, 0, <2729, 4521, 2715>, 0, <2715, 735, 2729>, 0, <727, 2717, 4522>, 0, <727, 4522, 2714>, 0, <2714, 4522, 2715>, 0, 
			<2714, 2715, 726>, 0, <2715, 4522, 735>, 0, <4522, 2731, 735>, 0, <2731, 4522, 2717>, 0, <2717, 736, 2731>, 0, <728, 2719, 4523>, 0, <728, 4523, 2716>, 0, <2716, 4523, 2717>, 0, <2716, 2717, 727>, 0, <2717, 4523, 736>, 0, <4523, 2733, 736>, 0, 
			<2733, 4523, 2719>, 0, <2719, 737, 2733>, 0, <729, 2721, 2718>, 0, <2721, 4524, 2718>, 0, <2718, 4524, 728>, 0, <4524, 2719, 728>, 0, <2719, 4524, 2735>, 0, <2735, 737, 2719>, 0, <738, 2735, 4524>, 0, <738, 4524, 2721>, 0, <730, 2723, 2720>, 0, 
			<2723, 4525, 2720>, 0, <2720, 4525, 729>, 0, <4525, 2721, 729>, 0, <2721, 4525, 2737>, 0, <2737, 738, 2721>, 0, <739, 2737, 4525>, 0, <739, 4525, 2723>, 0, <731, 2724, 2722>, 0, <2724, 4526, 2722>, 0, <2722, 4526, 730>, 0, <4526, 2723, 730>, 0, 
			<2723, 4526, 2739>, 0, <2739, 739, 2723>, 0, <740, 2739, 4526>, 0, <740, 4526, 2724>, 0, <723, 2709, 2708>, 0, <2709, 4527, 2708>, 0, <2708, 4527, 731>, 0, <4527, 2724, 731>, 0, <2724, 4527, 2725>, 0, <2725, 740, 2724>, 0, <732, 2725, 4527>, 0, 
			<732, 4527, 2709>, 0, <734, 2730, 4528>, 0, <734, 4528, 2727>, 0, <2727, 4528, 2728>, 0, <2727, 2728, 733>, 0, <2728, 4528, 742>, 0, <4528, 2744, 742>, 0, <2744, 4528, 2730>, 0, <2730, 743, 2744>, 0, <735, 2732, 4529>, 0, <735, 4529, 2729>, 0, 
			<2729, 4529, 2730>, 0, <2729, 2730, 734>, 0, <2730, 4529, 743>, 0, <4529, 2746, 743>, 0, <2746, 4529, 2732>, 0, <2732, 744, 2746>, 0, <736, 2734, 4530>, 0, <736, 4530, 2731>, 0, <2731, 4530, 2732>, 0, <2731, 2732, 735>, 0, <2732, 4530, 744>, 0, 
			<4530, 2748, 744>, 0, <2748, 4530, 2734>, 0, <2734, 745, 2748>, 0, <737, 2736, 4531>, 0, <737, 4531, 2733>, 0, <2733, 4531, 2734>, 0, <2733, 2734, 736>, 0, <2734, 4531, 745>, 0, <4531, 2750, 745>, 0, <2750, 4531, 2736>, 0, <2736, 746, 2750>, 0, 
			<738, 2738, 2735>, 0, <2738, 4532, 2735>, 0, <2735, 4532, 737>, 0, <4532, 2736, 737>, 0, <2736, 4532, 2752>, 0, <2752, 746, 2736>, 0, <747, 2752, 4532>, 0, <747, 4532, 2738>, 0, <739, 2740, 2737>, 0, <2740, 4533, 2737>, 0, <2737, 4533, 738>, 0, 
			<4533, 2738, 738>, 0, <2738, 4533, 2754>, 0, <2754, 747, 2738>, 0, <748, 2754, 4533>, 0, <748, 4533, 2740>, 0, <740, 2741, 2739>, 0, <2741, 4534, 2739>, 0, <2739, 4534, 739>, 0, <4534, 2740, 739>, 0, <2740, 4534, 2756>, 0, <2756, 748, 2740>, 0, 
			<749, 2756, 4534>, 0, <749, 4534, 2741>, 0, <732, 2726, 2725>, 0, <2726, 4535, 2725>, 0, <2725, 4535, 740>, 0, <4535, 2741, 740>, 0, <2741, 4535, 2742>, 0, <2742, 749, 2741>, 0, <741, 2742, 4535>, 0, <741, 4535, 2726>, 0, <743, 2747, 4536>, 0, 
			<743, 4536, 2744>, 0, <2744, 4536, 2745>, 0, <2744, 2745, 742>, 0, <2745, 4536, 751>, 0, <4536, 2761, 751>, 0, <2761, 4536, 2747>, 0, <2747, 752, 2761>, 0, <744, 2749, 4537>, 0, <744, 4537, 2746>, 0, <2746, 4537, 2747>, 0, <2746, 2747, 743>, 0, 
			<2747, 4537, 752>, 0, <4537, 2763, 752>, 0, <2763, 4537, 2749>, 0, <2749, 753, 2763>, 0, <745, 2751, 4538>, 0, <745, 4538, 2748>, 0, <2748, 4538, 2749>, 0, <2748, 2749, 744>, 0, <2749, 4538, 753>, 0, <4538, 2765, 753>, 0, <2765, 4538, 2751>, 0, 
			<2751, 754, 2765>, 0, <746, 2753, 4539>, 0, <746, 4539, 2750>, 0, <2750, 4539, 2751>, 0, <2750, 2751, 745>, 0, <2751, 4539, 754>, 0, <4539, 2767, 754>, 0, <2767, 4539, 2753>, 0, <2753, 755, 2767>, 0, <747, 2755, 2752>, 0, <2755, 4540, 2752>, 0, 
			<2752, 4540, 746>, 0, <4540, 2753, 746>, 0, <2753, 4540, 2769>, 0, <2769, 755, 2753>, 0, <756, 2769, 4540>, 0, <756, 4540, 2755>, 0, <748, 2757, 2754>, 0, <2757, 4541, 2754>, 0, <2754, 4541, 747>, 0, <4541, 2755, 747>, 0, <2755, 4541, 2771>, 0, 
			<2771, 756, 2755>, 0, <757, 2771, 4541>, 0, <757, 4541, 2757>, 0, <749, 2758, 2756>, 0, <2758, 4542, 2756>, 0, <2756, 4542, 748>, 0, <4542, 2757, 748>, 0, <2757, 4542, 2773>, 0, <2773, 757, 2757>, 0, <758, 2773, 4542>, 0, <758, 4542, 2758>, 0, 
			<741, 2743, 2742>, 0, <2743, 4543, 2742>, 0, <2742, 4543, 749>, 0, <4543, 2758, 749>, 0, <2758, 4543, 2759>, 0, <2759, 758, 2758>, 0, <750, 2759, 4543>, 0, <750, 4543, 2743>, 0, <752, 2764, 4544>, 0, <752, 4544, 2761>, 0, <2761, 4544, 2762>, 0, 
			<2761, 2762, 751>, 0, <2762, 4544, 760>, 0, <4544, 2777, 760>, 0, <2777, 4544, 2764>, 0, <2764, 761, 2777>, 0, <753, 2766, 4545>, 0, <753, 4545, 2763>, 0, <2763, 4545, 2764>, 0, <2763, 2764, 752>, 0, <2764, 4545, 761>, 0, <4545, 2778, 761>, 0, 
			<2778, 4545, 2766>, 0, <2766, 762, 2778>, 0, <754, 2768, 4546>, 0, <754, 4546, 2765>, 0, <2765, 4546, 2766>, 0, <2765, 2766, 753>, 0, <2766, 4546, 762>, 0, <4546, 2779, 762>, 0, <2779, 4546, 2768>, 0, <2768, 763, 2779>, 0, <755, 2770, 4547>, 0, 
			<755, 4547, 2767>, 0, <2767, 4547, 2768>, 0, <2767, 2768, 754>, 0, <2768, 4547, 2780>, 0, <2780, 763, 2768>, 0, <764, 2780, 4547>, 0, <764, 4547, 2770>, 0, <756, 2772, 2769>, 0, <2772, 4548, 2769>, 0, <2769, 4548, 755>, 0, <4548, 2770, 755>, 0, 
			<2770, 4548, 2781>, 0, <2781, 764, 2770>, 0, <765, 2781, 4548>, 0, <765, 4548, 2772>, 0, <757, 2774, 2771>, 0, <2774, 4549, 2771>, 0, <2771, 4549, 756>, 0, <4549, 2772, 756>, 0, <2772, 4549, 2782>, 0, <2782, 765, 2772>, 0, <766, 2782, 4549>, 0, 
			<766, 4549, 2774>, 0, <758, 2775, 2773>, 0, <2775, 4550, 2773>, 0, <2773, 4550, 757>, 0, <4550, 2774, 757>, 0, <2774, 4550, 2783>, 0, <2783, 766, 2774>, 0, <767, 2783, 4550>, 0, <767, 4550, 2775>, 0, <750, 2760, 2759>, 0, <2760, 4551, 2759>, 0, 
			<2759, 4551, 758>, 0, <4551, 2775, 758>, 0, <2775, 4551, 2776>, 0, <2776, 767, 2775>, 0, <759, 2776, 4551>, 0, <759, 4551, 2760>, 0, <625, 2517, 4552>, 0, <4552, 2515, 625>, 0, <4552, 2520, 626>, 0, <626, 2515, 4552>, 0, <4552, 2777, 761>, 0, 
			<761, 2520, 4552>, 0, <760, 2777, 2517>, 0, <2777, 4552, 2517>, 0, <2520, 4553, 2518>, 0, <2518, 626, 2520>, 0, <4553, 2523, 627>, 0, <627, 2518, 4553>, 0, <2523, 4553, 2778>, 0, <2523, 2778, 762>, 0, <761, 2778, 2520>, 0, <2778, 4553, 2520>, 0, 
			<2523, 4554, 2521>, 0, <2521, 627, 2523>, 0, <4554, 2526, 628>, 0, <628, 2521, 4554>, 0, <2526, 4554, 2779>, 0, <2526, 2779, 763>, 0, <762, 2779, 4554>, 0, <4554, 2523, 762>, 0, <628, 2526, 4555>, 0, <4555, 2524, 628>, 0, <4555, 2529, 629>, 0, 
			<629, 2524, 4555>, 0, <2529, 4555, 2780>, 0, <2529, 2780, 764>, 0, <763, 2780, 4555>, 0, <4555, 2526, 763>, 0, <2529, 4556, 2527>, 0, <2527, 629, 2529>, 0, <4556, 2532, 630>, 0, <630, 2527, 4556>, 0, <2532, 4556, 2781>, 0, <2532, 2781, 765>, 0, 
			<764, 2781, 4556>, 0, <4556, 2529, 764>, 0, <2532, 4557, 2530>, 0, <2530, 630, 2532>, 0, <4557, 2535, 631>, 0, <631, 2530, 4557>, 0, <2535, 4557, 2782>, 0, <2535, 2782, 766>, 0, <765, 2782, 4557>, 0, <4557, 2532, 765>, 0, <2535, 4558, 2533>, 0, 
			<2533, 631, 2535>, 0, <4558, 2537, 632>, 0, <632, 2533, 4558>, 0, <2537, 4558, 2783>, 0, <2537, 2783, 767>, 0, <766, 2783, 4558>, 0, <4558, 2535, 766>, 0, <2537, 4559, 2512>, 0, <2512, 632, 2537>, 0, <4559, 2514, 624>, 0, <624, 2512, 4559>, 0, 
			<2514, 4559, 2776>, 0, <2514, 2776, 759>, 0, <767, 2776, 4559>, 0, <4559, 2537, 767>, 0, <759, 3440, 4560>, 0, <4560, 2514, 759>, 0, <2514, 4560, 3441>, 0, <3441, 624, 2514>, 0, <3170, 960, 3441>, 0, <3170, 3441, 4560>, 0, <1095, 3170, 4560>, 0, 
			<1095, 4560, 3440>, 0, <3441, 4561, 2513>, 0, <2513, 624, 3441>, 0, <4561, 3442, 633>, 0, <633, 2513, 4561>, 0, <969, 3442, 4561>, 0, <969, 4561, 3169>, 0, <3169, 4561, 3441>, 0, <3169, 3441, 960>, 0, <3442, 4562, 2539>, 0, <2539, 633, 3442>, 0, 
			<4562, 3443, 642>, 0, <642, 2539, 4562>, 0, <978, 3443, 4562>, 0, <978, 4562, 3195>, 0, <3195, 4562, 3442>, 0, <3195, 3442, 969>, 0, <3443, 4563, 2556>, 0, <2556, 642, 3443>, 0, <4563, 3444, 651>, 0, <651, 2556, 4563>, 0, <987, 3444, 4563>, 0, 
			<987, 4563, 3212>, 0, <3212, 4563, 3443>, 0, <3212, 3443, 978>, 0, <3444, 4564, 2573>, 0, <2573, 651, 3444>, 0, <4564, 3445, 660>, 0, <660, 2573, 4564>, 0, <996, 3445, 4564>, 0, <996, 4564, 3229>, 0, <3229, 4564, 3444>, 0, <3229, 3444, 987>, 0, 
			<3445, 4565, 2590>, 0, <2590, 660, 3445>, 0, <4565, 3446, 669>, 0, <669, 2590, 4565>, 0, <1005, 3446, 4565>, 0, <1005, 4565, 3246>, 0, <3246, 4565, 3445>, 0, <3246, 3445, 996>, 0, <3446, 4566, 2607>, 0, <2607, 669, 3446>, 0, <4566, 3447, 678>, 0, 
			<678, 2607, 4566>, 0, <1014, 3447, 4566>, 0, <1014, 4566, 3263>, 0, <3263, 4566, 3446>, 0, <3263, 3446, 1005>, 0, <3447, 4567, 2624>, 0, <2624, 678, 3447>, 0, <4567, 3448, 687>, 0, <687, 2624, 4567>, 0, <1023, 3448, 4567>, 0, <1023, 4567, 3280>, 0, 
			<3280, 4567, 3447>, 0, <3280, 3447, 1014>, 0, <3448, 4568, 2641>, 0, <2641, 687, 3448>, 0, <4568, 3449, 696>, 0, <696, 2641, 4568>, 0, <1032, 3449, 4568>, 0, <1032, 4568, 3297>, 0, <3297, 4568, 3448>, 0, <3297, 3448, 1023>, 0, <696, 3449, 4569>, 0, 
			<4569, 2658, 696>, 0, <2658, 4569, 3450>, 0, <3450, 705, 2658>, 0, <3450, 4569, 3314>, 0, <3450, 3314, 1041>, 0, <1032, 3314, 4569>, 0, <1032, 4569, 3449>, 0, <705, 3450, 4570>, 0, <4570, 2675, 705>, 0, <2675, 4570, 3451>, 0, <3451, 714, 2675>, 0, 
			<3451, 4570, 3331>, 0, <3451, 3331, 1050>, 0, <1041, 3331, 4570>, 0, <1041, 4570, 3450>, 0, <714, 3451, 4571>, 0, <4571, 2692, 714>, 0, <2692, 4571, 3452>, 0, <3452, 723, 2692>, 0, <3452, 4571, 3348>, 0, <3452, 3348, 1059>, 0, <1050, 3348, 4571>, 0, 
			<1050, 4571, 3451>, 0, <723, 3452, 4572>, 0, <4572, 2709, 723>, 0, <2709, 4572, 3453>, 0, <3453, 732, 2709>, 0, <3453, 4572, 3365>, 0, <3453, 3365, 1068>, 0, <1059, 3365, 4572>, 0, <1059, 4572, 3452>, 0, <732, 3453, 4573>, 0, <4573, 2726, 732>, 0, 
			<2726, 4573, 3454>, 0, <3454, 741, 2726>, 0, <3454, 4573, 3382>, 0, <3454, 3382, 1077>, 0, <1068, 3382, 4573>, 0, <1068, 4573, 3453>, 0, <741, 3454, 4574>, 0, <4574, 2743, 741>, 0, <2743, 4574, 3455>, 0, <3455, 750, 2743>, 0, <3455, 4574, 3399>, 0, 
			<3455, 3399, 1086>, 0, <1077, 3399, 4574>, 0, <1077, 4574, 3454>, 0, <750, 3455, 4575>, 0, <4575, 2760, 750>, 0, <2760, 4575, 3440>, 0, <3440, 759, 2760>, 0, <3440, 4575, 3416>, 0, <3440, 3416, 1095>, 0, <1086, 3416, 4575>, 0, <1086, 4575, 3455>, 0, 
			<769, 2788, 2784>, 0, <2788, 4576, 2784>, 0, <4576, 2785, 768>, 0, <768, 2784, 4576>, 0, <2785, 4576, 2810>, 0, <2785, 2810, 777>, 0, <778, 2810, 4576>, 0, <4576, 2788, 778>, 0, <770, 2791, 2787>, 0, <2791, 4577, 2787>, 0, <2787, 4577, 769>, 0, 
			<4577, 2788, 769>, 0, <2788, 4577, 2812>, 0, <2788, 2812, 778>, 0, <779, 2812, 4577>, 0, <779, 4577, 2791>, 0, <771, 2794, 2790>, 0, <2794, 4578, 2790>, 0, <2790, 4578, 770>, 0, <4578, 2791, 770>, 0, <2791, 4578, 2814>, 0, <2814, 779, 2791>, 0, 
			<2814, 4578, 2794>, 0, <2794, 780, 2814>, 0, <772, 2797, 2793>, 0, <2797, 4579, 2793>, 0, <2793, 4579, 771>, 0, <4579, 2794, 771>, 0, <2794, 4579, 2816>, 0, <2816, 780, 2794>, 0, <781, 2816, 4579>, 0, <781, 4579, 2797>, 0, <773, 2800, 4580>, 0, 
			<773, 4580, 2796>, 0, <2796, 4580, 772>, 0, <4580, 2797, 772>, 0, <2797, 4580, 2818>, 0, <2818, 781, 2797>, 0, <782, 2818, 4580>, 0, <782, 4580, 2800>, 0, <774, 2803, 2799>, 0, <2803, 4581, 2799>, 0, <2799, 4581, 773>, 0, <4581, 2800, 773>, 0, 
			<2800, 4581, 2820>, 0, <2820, 782, 2800>, 0, <783, 2820, 4581>, 0, <783, 4581, 2803>, 0, <775, 2806, 2802>, 0, <2806, 4582, 2802>, 0, <2802, 4582, 774>, 0, <4582, 2803, 774>, 0, <2803, 4582, 2822>, 0, <2822, 783, 2803>, 0, <2822, 4582, 2806>, 0, 
			<2806, 784, 2822>, 0, <776, 2808, 4583>, 0, <776, 4583, 2805>, 0, <2805, 4583, 775>, 0, <4583, 2806, 775>, 0, <2806, 4583, 784>, 0, <4583, 2824, 784>, 0, <2824, 4583, 2808>, 0, <2808, 785, 2824>, 0, <2813, 4584, 2810>, 0, <2810, 778, 2813>, 0, 
			<4584, 2811, 777>, 0, <777, 2810, 4584>, 0, <2811, 4584, 2827>, 0, <2811, 2827, 786>, 0, <787, 2827, 4584>, 0, <4584, 2813, 787>, 0, <2815, 4585, 2812>, 0, <2812, 779, 2815>, 0, <4585, 2813, 778>, 0, <778, 2812, 4585>, 0, <2813, 4585, 2829>, 0, 
			<2813, 2829, 787>, 0, <788, 2829, 4585>, 0, <4585, 2815, 788>, 0, <2817, 4586, 2814>, 0, <2814, 780, 2817>, 0, <4586, 2815, 779>, 0, <779, 2814, 4586>, 0, <2815, 4586, 2831>, 0, <2815, 2831, 788>, 0, <789, 2831, 4586>, 0, <4586, 2817, 789>, 0, 
			<781, 2819, 2816>, 0, <2819, 4587, 2816>, 0, <2816, 4587, 780>, 0, <4587, 2817, 780>, 0, <2817, 4587, 2833>, 0, <2817, 2833, 789>, 0, <790, 2833, 4587>, 0, <4587, 2819, 790>, 0, <782, 2821, 2818>, 0, <2821, 4588, 2818>, 0, <2818, 4588, 781>, 0, 
			<4588, 2819, 781>, 0, <2819, 4588, 790>, 0, <4588, 2835, 790>, 0, <2835, 4588, 2821>, 0, <2821, 791, 2835>, 0, <783, 2823, 4589>, 0, <783, 4589, 2820>, 0, <2820, 4589, 2821>, 0, <2820, 2821, 782>, 0, <2821, 4589, 791>, 0, <4589, 2837, 791>, 0, 
			<2837, 4589, 2823>, 0, <2823, 792, 2837>, 0, <784, 2825, 4590>, 0, <784, 4590, 2822>, 0, <2822, 4590, 2823>, 0, <2822, 2823, 783>, 0, <2823, 4590, 792>, 0, <4590, 2839, 792>, 0, <2839, 4590, 2825>, 0, <2825, 793, 2839>, 0, <785, 2826, 4591>, 0, 
			<785, 4591, 2824>, 0, <2824, 4591, 2825>, 0, <2824, 2825, 784>, 0, <2825, 4591, 793>, 0, <4591, 2841, 793>, 0, <2841, 4591, 2826>, 0, <2826, 794, 2841>, 0, <2830, 4592, 2827>, 0, <2827, 787, 2830>, 0, <4592, 2828, 786>, 0, <786, 2827, 4592>, 0, 
			<2828, 4592, 2844>, 0, <2828, 2844, 795>, 0, <796, 2844, 4592>, 0, <4592, 2830, 796>, 0, <2832, 4593, 2829>, 0, <2829, 788, 2832>, 0, <4593, 2830, 787>, 0, <787, 2829, 4593>, 0, <2830, 4593, 2846>, 0, <2830, 2846, 796>, 0, <797, 2846, 4593>, 0, 
			<4593, 2832, 797>, 0, <2834, 4594, 2831>, 0, <2831, 789, 2834>, 0, <4594, 2832, 788>, 0, <788, 2831, 4594>, 0, <2832, 4594, 2848>, 0, <2832, 2848, 797>, 0, <798, 2848, 4594>, 0, <4594, 2834, 798>, 0, <2836, 4595, 2833>, 0, <2833, 790, 2836>, 0, 
			<4595, 2834, 789>, 0, <789, 2833, 4595>, 0, <2834, 4595, 2850>, 0, <2834, 2850, 798>, 0, <799, 2850, 4595>, 0, <4595, 2836, 799>, 0, <791, 2838, 4596>, 0, <791, 4596, 2835>, 0, <2835, 4596, 2836>, 0, <2835, 2836, 790>, 0, <2836, 4596, 799>, 0, 
			<4596, 2852, 799>, 0, <2852, 4596, 2838>, 0, <2838, 800, 2852>, 0, <792, 2840, 4597>, 0, <792, 4597, 2837>, 0, <2837, 4597, 2838>, 0, <2837, 2838, 791>, 0, <2838, 4597, 800>, 0, <4597, 2854, 800>, 0, <2854, 4597, 2840>, 0, <2840, 801, 2854>, 0, 
			<793, 2842, 4598>, 0, <793, 4598, 2839>, 0, <2839, 4598, 2840>, 0, <2839, 2840, 792>, 0, <2840, 4598, 801>, 0, <4598, 2856, 801>, 0, <2856, 4598, 2842>, 0, <2842, 802, 2856>, 0, <794, 2843, 4599>, 0, <794, 4599, 2841>, 0, <2841, 4599, 2842>, 0, 
			<2841, 2842, 793>, 0, <2842, 4599, 802>, 0, <4599, 2858, 802>, 0, <2858, 4599, 2843>, 0, <2843, 803, 2858>, 0, <2847, 4600, 2844>, 0, <2844, 796, 2847>, 0, <4600, 2845, 795>, 0, <795, 2844, 4600>, 0, <2845, 4600, 2861>, 0, <2845, 2861, 804>, 0, 
			<805, 2861, 4600>, 0, <4600, 2847, 805>, 0, <2849, 4601, 2846>, 0, <2846, 797, 2849>, 0, <4601, 2847, 796>, 0, <796, 2846, 4601>, 0, <2847, 4601, 2863>, 0, <2847, 2863, 805>, 0, <806, 2863, 4601>, 0, <4601, 2849, 806>, 0, <2851, 4602, 2848>, 0, 
			<2848, 798, 2851>, 0, <4602, 2849, 797>, 0, <797, 2848, 4602>, 0, <2849, 4602, 2865>, 0, <2849, 2865, 806>, 0, <807, 2865, 4602>, 0, <4602, 2851, 807>, 0, <2853, 4603, 2850>, 0, <2850, 799, 2853>, 0, <4603, 2851, 798>, 0, <798, 2850, 4603>, 0, 
			<2851, 4603, 2867>, 0, <2851, 2867, 807>, 0, <808, 2867, 4603>, 0, <4603, 2853, 808>, 0, <800, 2855, 4604>, 0, <800, 4604, 2852>, 0, <2852, 4604, 2853>, 0, <2852, 2853, 799>, 0, <2853, 4604, 808>, 0, <4604, 2869, 808>, 0, <2869, 4604, 2855>, 0, 
			<2855, 809, 2869>, 0, <801, 2857, 4605>, 0, <801, 4605, 2854>, 0, <2854, 4605, 2855>, 0, <2854, 2855, 800>, 0, <2855, 4605, 809>, 0, <4605, 2871, 809>, 0, <2871, 4605, 2857>, 0, <2857, 810, 2871>, 0, <802, 2859, 4606>, 0, <802, 4606, 2856>, 0, 
			<2856, 4606, 2857>, 0, <2856, 2857, 801>, 0, <2857, 4606, 810>, 0, <4606, 2873, 810>, 0, <2873, 4606, 2859>, 0, <2859, 811, 2873>, 0, <803, 2860, 4607>, 0, <803, 4607, 2858>, 0, <2858, 4607, 2859>, 0, <2858, 2859, 802>, 0, <2859, 4607, 811>, 0, 
			<4607, 2875, 811>, 0, <2875, 4607, 2860>, 0, <2860, 812, 2875>, 0, <2864, 4608, 2861>, 0, <2861, 805, 2864>, 0, <4608, 2862, 804>, 0, <804, 2861, 4608>, 0, <2862, 4608, 2878>, 0, <2862, 2878, 813>, 0, <814, 2878, 4608>, 0, <4608, 2864, 814>, 0, 
			<2866, 4609, 2863>, 0, <2863, 806, 2866>, 0, <4609, 2864, 805>, 0, <805, 2863, 4609>, 0, <2864, 4609, 2880>, 0, <2864, 2880, 814>, 0, <815, 2880, 4609>, 0, <4609, 2866, 815>, 0, <2868, 4610, 2865>, 0, <2865, 807, 2868>, 0, <4610, 2866, 806>, 0, 
			<806, 2865, 4610>, 0, <2866, 4610, 2882>, 0, <2866, 2882, 815>, 0, <816, 2882, 4610>, 0, <4610, 2868, 816>, 0, <2870, 4611, 2867>, 0, <2867, 808, 2870>, 0, <4611, 2868, 807>, 0, <807, 2867, 4611>, 0, <2868, 4611, 2884>, 0, <2868, 2884, 816>, 0, 
			<817, 2884, 4611>, 0, <4611, 2870, 817>, 0, <809, 2872, 4612>, 0, <809, 4612, 2869>, 0, <2869, 4612, 2870>, 0, <2869, 2870, 808>, 0, <2870, 4612, 817>, 0, <4612, 2886, 817>, 0, <2886, 4612, 2872>, 0, <2872, 818, 2886>, 0, <810, 2874, 4613>, 0, 
			<810, 4613, 2871>, 0, <2871, 4613, 2872>, 0, <2871, 2872, 809>, 0, <2872, 4613, 818>, 0, <4613, 2888, 818>, 0, <2888, 4613, 2874>, 0, <2874, 819, 2888>, 0, <811, 2876, 4614>, 0, <811, 4614, 2873>, 0, <2873, 4614, 2874>, 0, <2873, 2874, 810>, 0, 
			<2874, 4614, 819>, 0, <4614, 2890, 819>, 0, <2890, 4614, 2876>, 0, <2876, 820, 2890>, 0, <812, 2877, 4615>, 0, <812, 4615, 2875>, 0, <2875, 4615, 2876>, 0, <2875, 2876, 811>, 0, <2876, 4615, 820>, 0, <4615, 2892, 820>, 0, <2892, 4615, 2877>, 0, 
			<2877, 821, 2892>, 0, <2881, 4616, 2878>, 0, <2878, 814, 2881>, 0, <4616, 2879, 813>, 0, <813, 2878, 4616>, 0, <2879, 4616, 2895>, 0, <2879, 2895, 822>, 0, <823, 2895, 4616>, 0, <4616, 2881, 823>, 0, <2883, 4617, 2880>, 0, <2880, 815, 2883>, 0, 
			<4617, 2881, 814>, 0, <814, 2880, 4617>, 0, <2881, 4617, 2897>, 0, <2881, 2897, 823>, 0, <824, 2897, 4617>, 0, <4617, 2883, 824>, 0, <2885, 4618, 2882>, 0, <2882, 816, 2885>, 0, <4618, 2883, 815>, 0, <815, 2882, 4618>, 0, <2883, 4618, 2899>, 0, 
			<2883, 2899, 824>, 0, <825, 2899, 4618>, 0, <4618, 2885, 825>, 0, <2887, 4619, 2884>, 0, <2884, 817, 2887>, 0, <4619, 2885, 816>, 0, <816, 2884, 4619>, 0, <2885, 4619, 2901>, 0, <2885, 2901, 825>, 0, <826, 2901, 4619>, 0, <4619, 2887, 826>, 0, 
			<818, 2889, 4620>, 0, <818, 4620, 2886>, 0, <2886, 4620, 2887>, 0, <2886, 2887, 817>, 0, <2887, 4620, 826>, 0, <4620, 2903, 826>, 0, <2903, 4620, 2889>, 0, <2889, 827, 2903>, 0, <819, 2891, 4621>, 0, <819, 4621, 2888>, 0, <2888, 4621, 2889>, 0, 
			<2888, 2889, 818>, 0, <2889, 4621, 827>, 0, <4621, 2905, 827>, 0, <2905, 4621, 2891>, 0, <2891, 828, 2905>, 0, <820, 2893, 4622>, 0, <820, 4622, 2890>, 0, <2890, 4622, 2891>, 0, <2890, 2891, 819>, 0, <2891, 4622, 828>, 0, <4622, 2907, 828>, 0, 
			<2907, 4622, 2893>, 0, <2893, 829, 2907>, 0, <821, 2894, 4623>, 0, <821, 4623, 2892>, 0, <2892, 4623, 2893>, 0, <2892, 2893, 820>, 0, <2893, 4623, 829>, 0, <4623, 2909, 829>, 0, <2909, 4623, 2894>, 0, <2894, 830, 2909>, 0, <2898, 4624, 2895>, 0, 
			<2895, 823, 2898>, 0, <4624, 2896, 822>, 0, <822, 2895, 4624>, 0, <2896, 4624, 2912>, 0, <2896, 2912, 831>, 0, <832, 2912, 4624>, 0, <4624, 2898, 832>, 0, <2900, 4625, 2897>, 0, <2897, 824, 2900>, 0, <4625, 2898, 823>, 0, <823, 2897, 4625>, 0, 
			<2898, 4625, 2914>, 0, <2898, 2914, 832>, 0, <833, 2914, 4625>, 0, <4625, 2900, 833>, 0, <2902, 4626, 2899>, 0, <2899, 825, 2902>, 0, <4626, 2900, 824>, 0, <824, 2899, 4626>, 0, <2900, 4626, 2916>, 0, <2900, 2916, 833>, 0, <834, 2916, 4626>, 0, 
			<4626, 2902, 834>, 0, <2904, 4627, 2901>, 0, <2901, 826, 2904>, 0, <4627, 2902, 825>, 0, <825, 2901, 4627>, 0, <2902, 4627, 2918>, 0, <2902, 2918, 834>, 0, <835, 2918, 4627>, 0, <4627, 2904, 835>, 0, <827, 2906, 4628>, 0, <827, 4628, 2903>, 0, 
			<2903, 4628, 2904>, 0, <2903, 2904, 826>, 0, <2904, 4628, 2920>, 0, <2904, 2920, 835>, 0, <836, 2920, 2906>, 0, <2920, 4628, 2906>, 0, <828, 2908, 4629>, 0, <828, 4629, 2905>, 0, <2905, 4629, 2906>, 0, <2905, 2906, 827>, 0, <2906, 4629, 836>, 0, 
			<4629, 2922, 836>, 0, <2922, 4629, 2908>, 0, <2908, 837, 2922>, 0, <829, 2910, 4630>, 0, <829, 4630, 2907>, 0, <2907, 4630, 2908>, 0, <2907, 2908, 828>, 0, <2908, 4630, 837>, 0, <4630, 2924, 837>, 0, <2924, 4630, 2910>, 0, <2910, 838, 2924>, 0, 
			<830, 2911, 4631>, 0, <830, 4631, 2909>, 0, <2909, 4631, 2910>, 0, <2909, 2910, 829>, 0, <2910, 4631, 838>, 0, <4631, 2926, 838>, 0, <2926, 4631, 2911>, 0, <2911, 839, 2926>, 0, <2915, 4632, 2912>, 0, <2912, 832, 2915>, 0, <4632, 2913, 831>, 0, 
			<831, 2912, 4632>, 0, <2913, 4632, 2929>, 0, <2913, 2929, 840>, 0, <841, 2929, 2915>, 0, <2929, 4632, 2915>, 0, <2917, 4633, 2914>, 0, <2914, 833, 2917>, 0, <4633, 2915, 832>, 0, <832, 2914, 4633>, 0, <4633, 2931, 841>, 0, <841, 2915, 4633>, 0, 
			<842, 2931, 4633>, 0, <4633, 2917, 842>, 0, <2919, 4634, 2916>, 0, <2916, 834, 2919>, 0, <4634, 2917, 833>, 0, <833, 2916, 4634>, 0, <2917, 4634, 2933>, 0, <2917, 2933, 842>, 0, <843, 2933, 4634>, 0, <4634, 2919, 843>, 0, <2921, 4635, 2918>, 0, 
			<2918, 835, 2921>, 0, <4635, 2919, 834>, 0, <834, 2918, 4635>, 0, <2919, 4635, 2935>, 0, <2919, 2935, 843>, 0, <844, 2935, 4635>, 0, <4635, 2921, 844>, 0, <2923, 4636, 2920>, 0, <2920, 836, 2923>, 0, <2920, 4636, 2921>, 0, <2921, 835, 2920>, 0, 
			<2921, 4636, 2937>, 0, <2921, 2937, 844>, 0, <845, 2937, 4636>, 0, <4636, 2923, 845>, 0, <837, 2925, 4637>, 0, <4637, 2922, 837>, 0, <2922, 4637, 2923>, 0, <2923, 836, 2922>, 0, <2923, 4637, 2939>, 0, <2923, 2939, 845>, 0, <846, 2939, 4637>, 0, 
			<4637, 2925, 846>, 0, <838, 2927, 4638>, 0, <838, 4638, 2924>, 0, <4638, 2925, 837>, 0, <837, 2924, 4638>, 0, <2925, 4638, 2941>, 0, <2925, 2941, 846>, 0, <847, 2941, 2927>, 0, <2941, 4638, 2927>, 0, <839, 2928, 4639>, 0, <839, 4639, 2926>, 0, 
			<2926, 4639, 2927>, 0, <2926, 2927, 838>, 0, <2927, 4639, 2943>, 0, <2927, 2943, 847>, 0, <2943, 4639, 2928>, 0, <2928, 848, 2943>, 0, <2932, 4640, 2929>, 0, <2929, 841, 2932>, 0, <2929, 4640, 2930>, 0, <2929, 2930, 840>, 0, <2930, 4640, 849>, 0, 
			<4640, 2946, 849>, 0, <2946, 4640, 2932>, 0, <2932, 850, 2946>, 0, <2934, 4641, 2931>, 0, <2931, 842, 2934>, 0, <4641, 2932, 841>, 0, <841, 2931, 4641>, 0, <2932, 4641, 850>, 0, <4641, 2948, 850>, 0, <851, 2948, 2934>, 0, <2948, 4641, 2934>, 0, 
			<2936, 4642, 2933>, 0, <2933, 843, 2936>, 0, <2933, 4642, 2934>, 0, <2934, 842, 2933>, 0, <2934, 4642, 2950>, 0, <2934, 2950, 851>, 0, <852, 2950, 2936>, 0, <2950, 4642, 2936>, 0, <2938, 4643, 2935>, 0, <2935, 844, 2938>, 0, <4643, 2936, 843>, 0, 
			<843, 2935, 4643>, 0, <2936, 4643, 2952>, 0, <2936, 2952, 852>, 0, <853, 2952, 4643>, 0, <4643, 2938, 853>, 0, <2940, 4644, 2937>, 0, <2937, 845, 2940>, 0, <2937, 4644, 2938>, 0, <2938, 844, 2937>, 0, <2938, 4644, 2954>, 0, <2938, 2954, 853>, 0, 
			<854, 2954, 4644>, 0, <4644, 2940, 854>, 0, <2942, 4645, 2939>, 0, <2939, 846, 2942>, 0, <4645, 2940, 845>, 0, <845, 2939, 4645>, 0, <2940, 4645, 2956>, 0, <2940, 2956, 854>, 0, <855, 2956, 4645>, 0, <4645, 2942, 855>, 0, <2944, 4646, 2941>, 0, 
			<2941, 847, 2944>, 0, <4646, 2942, 846>, 0, <846, 2941, 4646>, 0, <2942, 4646, 2958>, 0, <2942, 2958, 855>, 0, <856, 2958, 4646>, 0, <4646, 2944, 856>, 0, <2945, 4647, 2943>, 0, <2943, 848, 2945>, 0, <4647, 2944, 847>, 0, <847, 2943, 4647>, 0, 
			<2944, 4647, 2960>, 0, <2944, 2960, 856>, 0, <857, 2960, 4647>, 0, <4647, 2945, 857>, 0, <850, 2949, 4648>, 0, <850, 4648, 2946>, 0, <2946, 4648, 2947>, 0, <2946, 2947, 849>, 0, <2947, 4648, 858>, 0, <4648, 2963, 858>, 0, <2963, 4648, 2949>, 0, 
			<2949, 859, 2963>, 0, <851, 2951, 4649>, 0, <851, 4649, 2948>, 0, <2948, 4649, 2949>, 0, <2948, 2949, 850>, 0, <2949, 4649, 859>, 0, <4649, 2965, 859>, 0, <2965, 4649, 2951>, 0, <2951, 860, 2965>, 0, <852, 2953, 4650>, 0, <852, 4650, 2950>, 0, 
			<2950, 4650, 2951>, 0, <2950, 2951, 851>, 0, <2951, 4650, 860>, 0, <4650, 2967, 860>, 0, <2967, 4650, 2953>, 0, <2953, 861, 2967>, 0, <2955, 4651, 2952>, 0, <2952, 853, 2955>, 0, <4651, 2953, 852>, 0, <852, 2952, 4651>, 0, <2953, 4651, 861>, 0, 
			<4651, 2969, 861>, 0, <2969, 4651, 2955>, 0, <2955, 862, 2969>, 0, <2957, 4652, 2954>, 0, <2954, 854, 2957>, 0, <2954, 4652, 2955>, 0, <2955, 853, 2954>, 0, <2955, 4652, 2971>, 0, <2955, 2971, 862>, 0, <863, 2971, 4652>, 0, <4652, 2957, 863>, 0, 
			<2959, 4653, 2956>, 0, <2956, 855, 2959>, 0, <4653, 2957, 854>, 0, <854, 2956, 4653>, 0, <2957, 4653, 2973>, 0, <2957, 2973, 863>, 0, <864, 2973, 4653>, 0, <4653, 2959, 864>, 0, <2961, 4654, 2958>, 0, <2958, 856, 2961>, 0, <4654, 2959, 855>, 0, 
			<855, 2958, 4654>, 0, <2959, 4654, 2975>, 0, <2959, 2975, 864>, 0, <865, 2975, 4654>, 0, <4654, 2961, 865>, 0, <2962, 4655, 2960>, 0, <2960, 857, 2962>, 0, <4655, 2961, 856>, 0, <856, 2960, 4655>, 0, <2961, 4655, 2977>, 0, <2961, 2977, 865>, 0, 
			<866, 2977, 4655>, 0, <4655, 2962, 866>, 0, <859, 2966, 4656>, 0, <859, 4656, 2963>, 0, <2963, 4656, 2964>, 0, <2963, 2964, 858>, 0, <2964, 4656, 867>, 0, <4656, 2980, 867>, 0, <2980, 4656, 2966>, 0, <2966, 868, 2980>, 0, <860, 2968, 4657>, 0, 
			<860, 4657, 2965>, 0, <2965, 4657, 2966>, 0, <2965, 2966, 859>, 0, <2966, 4657, 868>, 0, <4657, 2982, 868>, 0, <2982, 4657, 2968>, 0, <2968, 869, 2982>, 0, <861, 2970, 4658>, 0, <861, 4658, 2967>, 0, <2967, 4658, 2968>, 0, <2967, 2968, 860>, 0, 
			<2968, 4658, 869>, 0, <4658, 2984, 869>, 0, <2984, 4658, 2970>, 0, <2970, 870, 2984>, 0, <862, 2972, 4659>, 0, <862, 4659, 2969>, 0, <2969, 4659, 2970>, 0, <2969, 2970, 861>, 0, <2970, 4659, 870>, 0, <4659, 2986, 870>, 0, <2986, 4659, 2972>, 0, 
			<2972, 871, 2986>, 0, <2974, 4660, 2971>, 0, <2971, 863, 2974>, 0, <4660, 2972, 862>, 0, <862, 2971, 4660>, 0, <2972, 4660, 2988>, 0, <2972, 2988, 871>, 0, <872, 2988, 4660>, 0, <4660, 2974, 872>, 0, <2976, 4661, 2973>, 0, <2973, 864, 2976>, 0, 
			<4661, 2974, 863>, 0, <863, 2973, 4661>, 0, <2974, 4661, 2990>, 0, <2974, 2990, 872>, 0, <873, 2990, 4661>, 0, <4661, 2976, 873>, 0, <2978, 4662, 2975>, 0, <2975, 865, 2978>, 0, <4662, 2976, 864>, 0, <864, 2975, 4662>, 0, <2976, 4662, 2992>, 0, 
			<2976, 2992, 873>, 0, <874, 2992, 4662>, 0, <4662, 2978, 874>, 0, <2979, 4663, 2977>, 0, <2977, 866, 2979>, 0, <4663, 2978, 865>, 0, <865, 2977, 4663>, 0, <2978, 4663, 2994>, 0, <2978, 2994, 874>, 0, <875, 2994, 4663>, 0, <4663, 2979, 875>, 0, 
			<868, 2983, 4664>, 0, <868, 4664, 2980>, 0, <2980, 4664, 2981>, 0, <2980, 2981, 867>, 0, <2981, 4664, 876>, 0, <4664, 2997, 876>, 0, <2997, 4664, 2983>, 0, <2983, 877, 2997>, 0, <869, 2985, 4665>, 0, <869, 4665, 2982>, 0, <2982, 4665, 2983>, 0, 
			<2982, 2983, 868>, 0, <2983, 4665, 877>, 0, <4665, 2999, 877>, 0, <2999, 4665, 2985>, 0, <2985, 878, 2999>, 0, <870, 2987, 4666>, 0, <870, 4666, 2984>, 0, <2984, 4666, 2985>, 0, <2984, 2985, 869>, 0, <2985, 4666, 878>, 0, <4666, 3001, 878>, 0, 
			<3001, 4666, 2987>, 0, <2987, 879, 3001>, 0, <871, 2989, 4667>, 0, <871, 4667, 2986>, 0, <2986, 4667, 2987>, 0, <2986, 2987, 870>, 0, <2987, 4667, 879>, 0, <4667, 3003, 879>, 0, <3003, 4667, 2989>, 0, <2989, 880, 3003>, 0, <2991, 4668, 2988>, 0, 
			<2988, 872, 2991>, 0, <4668, 2989, 871>, 0, <871, 2988, 4668>, 0, <2989, 4668, 3005>, 0, <2989, 3005, 880>, 0, <881, 3005, 4668>, 0, <4668, 2991, 881>, 0, <2993, 4669, 2990>, 0, <2990, 873, 2993>, 0, <4669, 2991, 872>, 0, <872, 2990, 4669>, 0, 
			<2991, 4669, 3007>, 0, <2991, 3007, 881>, 0, <882, 3007, 4669>, 0, <4669, 2993, 882>, 0, <2995, 4670, 2992>, 0, <2992, 874, 2995>, 0, <4670, 2993, 873>, 0, <873, 2992, 4670>, 0, <2993, 4670, 3009>, 0, <2993, 3009, 882>, 0, <883, 3009, 4670>, 0, 
			<4670, 2995, 883>, 0, <2996, 4671, 2994>, 0, <2994, 875, 2996>, 0, <4671, 2995, 874>, 0, <874, 2994, 4671>, 0, <2995, 4671, 3011>, 0, <2995, 3011, 883>, 0, <884, 3011, 4671>, 0, <4671, 2996, 884>, 0, <877, 3000, 4672>, 0, <877, 4672, 2997>, 0, 
			<2997, 4672, 2998>, 0, <2997, 2998, 876>, 0, <2998, 4672, 885>, 0, <4672, 3014, 885>, 0, <3014, 4672, 3000>, 0, <3000, 886, 3014>, 0, <878, 3002, 4673>, 0, <878, 4673, 2999>, 0, <2999, 4673, 3000>, 0, <2999, 3000, 877>, 0, <3000, 4673, 886>, 0, 
			<4673, 3016, 886>, 0, <3016, 4673, 3002>, 0, <3002, 887, 3016>, 0, <879, 3004, 4674>, 0, <879, 4674, 3001>, 0, <3001, 4674, 3002>, 0, <3001, 3002, 878>, 0, <3002, 4674, 887>, 0, <4674, 3018, 887>, 0, <3018, 4674, 3004>, 0, <3004, 888, 3018>, 0, 
			<880, 3006, 4675>, 0, <880, 4675, 3003>, 0, <3003, 4675, 3004>, 0, <3003, 3004, 879>, 0, <3004, 4675, 888>, 0, <4675, 3020, 888>, 0, <3020, 4675, 3006>, 0, <3006, 889, 3020>, 0, <3008, 4676, 3005>, 0, <3005, 881, 3008>, 0, <4676, 3006, 880>, 0, 
			<880, 3005, 4676>, 0, <3006, 4676, 3022>, 0, <3006, 3022, 889>, 0, <890, 3022, 4676>, 0, <4676, 3008, 890>, 0, <3010, 4677, 3007>, 0, <3007, 882, 3010>, 0, <4677, 3008, 881>, 0, <881, 3007, 4677>, 0, <3008, 4677, 3024>, 0, <3008, 3024, 890>, 0, 
			<891, 3024, 4677>, 0, <4677, 3010, 891>, 0, <3012, 4678, 3009>, 0, <3009, 883, 3012>, 0, <4678, 3010, 882>, 0, <882, 3009, 4678>, 0, <3010, 4678, 3026>, 0, <3010, 3026, 891>, 0, <892, 3026, 4678>, 0, <4678, 3012, 892>, 0, <3013, 4679, 3011>, 0, 
			<3011, 884, 3013>, 0, <4679, 3012, 883>, 0, <883, 3011, 4679>, 0, <3012, 4679, 3028>, 0, <3012, 3028, 892>, 0, <893, 3028, 4679>, 0, <4679, 3013, 893>, 0, <886, 3017, 4680>, 0, <886, 4680, 3014>, 0, <3014, 4680, 3015>, 0, <3014, 3015, 885>, 0, 
			<3015, 4680, 894>, 0, <4680, 3031, 894>, 0, <3031, 4680, 3017>, 0, <3017, 895, 3031>, 0, <887, 3019, 4681>, 0, <887, 4681, 3016>, 0, <3016, 4681, 3017>, 0, <3016, 3017, 886>, 0, <3017, 4681, 895>, 0, <4681, 3033, 895>, 0, <3033, 4681, 3019>, 0, 
			<3019, 896, 3033>, 0, <888, 3021, 4682>, 0, <888, 4682, 3018>, 0, <3018, 4682, 3019>, 0, <3018, 3019, 887>, 0, <3019, 4682, 896>, 0, <4682, 3035, 896>, 0, <3035, 4682, 3021>, 0, <3021, 897, 3035>, 0, <889, 3023, 4683>, 0, <889, 4683, 3020>, 0, 
			<3020, 4683, 3021>, 0, <3020, 3021, 888>, 0, <3021, 4683, 897>, 0, <4683, 3037, 897>, 0, <3037, 4683, 3023>, 0, <3023, 898, 3037>, 0, <3025, 4684, 3022>, 0, <3022, 890, 3025>, 0, <4684, 3023, 889>, 0, <889, 3022, 4684>, 0, <3023, 4684, 3039>, 0, 
			<3023, 3039, 898>, 0, <899, 3039, 4684>, 0, <4684, 3025, 899>, 0, <3027, 4685, 3024>, 0, <3024, 891, 3027>, 0, <4685, 3025, 890>, 0, <890, 3024, 4685>, 0, <3025, 4685, 3041>, 0, <3025, 3041, 899>, 0, <900, 3041, 4685>, 0, <4685, 3027, 900>, 0, 
			<3029, 4686, 3026>, 0, <3026, 892, 3029>, 0, <4686, 3027, 891>, 0, <891, 3026, 4686>, 0, <3027, 4686, 3043>, 0, <3027, 3043, 900>, 0, <901, 3043, 4686>, 0, <4686, 3029, 901>, 0, <3030, 4687, 3028>, 0, <3028, 893, 3030>, 0, <4687, 3029, 892>, 0, 
			<892, 3028, 4687>, 0, <3029, 4687, 3045>, 0, <3029, 3045, 901>, 0, <902, 3045, 4687>, 0, <4687, 3030, 902>, 0, <895, 3034, 4688>, 0, <895, 4688, 3031>, 0, <3031, 4688, 3032>, 0, <3031, 3032, 894>, 0, <3032, 4688, 903>, 0, <4688, 3048, 903>, 0, 
			<3048, 4688, 3034>, 0, <3034, 904, 3048>, 0, <896, 3036, 4689>, 0, <896, 4689, 3033>, 0, <3033, 4689, 3034>, 0, <3033, 3034, 895>, 0, <3034, 4689, 904>, 0, <4689, 3049, 904>, 0, <3049, 4689, 3036>, 0, <3036, 905, 3049>, 0, <897, 3038, 4690>, 0, 
			<897, 4690, 3035>, 0, <3035, 4690, 3036>, 0, <3035, 3036, 896>, 0, <3036, 4690, 905>, 0, <4690, 3050, 905>, 0, <3050, 4690, 3038>, 0, <3038, 906, 3050>, 0, <898, 3040, 4691>, 0, <898, 4691, 3037>, 0, <3037, 4691, 3038>, 0, <3037, 3038, 897>, 0, 
			<3038, 4691, 906>, 0, <4691, 3051, 906>, 0, <907, 3051, 4691>, 0, <907, 4691, 3040>, 0, <3042, 4692, 3039>, 0, <3039, 899, 3042>, 0, <4692, 3040, 898>, 0, <898, 3039, 4692>, 0, <3040, 4692, 907>, 0, <4692, 3052, 907>, 0, <908, 3052, 4692>, 0, 
			<908, 4692, 3042>, 0, <3044, 4693, 3041>, 0, <3041, 900, 3044>, 0, <4693, 3042, 899>, 0, <899, 3041, 4693>, 0, <3042, 4693, 3053>, 0, <3042, 3053, 908>, 0, <909, 3053, 4693>, 0, <4693, 3044, 909>, 0, <3046, 4694, 3043>, 0, <3043, 901, 3046>, 0, 
			<4694, 3044, 900>, 0, <900, 3043, 4694>, 0, <3044, 4694, 3054>, 0, <3044, 3054, 909>, 0, <910, 3054, 4694>, 0, <4694, 3046, 910>, 0, <3047, 4695, 3045>, 0, <3045, 902, 3047>, 0, <4695, 3046, 901>, 0, <901, 3045, 4695>, 0, <3046, 4695, 3055>, 0, 
			<3046, 3055, 910>, 0, <911, 3055, 4695>, 0, <4695, 3047, 911>, 0, <768, 2786, 4696>, 0, <4696, 2784, 768>, 0, <4696, 2789, 769>, 0, <769, 2784, 4696>, 0, <4696, 3048, 904>, 0, <904, 2789, 4696>, 0, <903, 3048, 2786>, 0, <3048, 4696, 2786>, 0, 
			<2789, 4697, 2787>, 0, <2787, 769, 2789>, 0, <4697, 2792, 770>, 0, <770, 2787, 4697>, 0, <4697, 3049, 905>, 0, <905, 2792, 4697>, 0, <904, 3049, 2789>, 0, <3049, 4697, 2789>, 0, <2792, 4698, 2790>, 0, <2790, 770, 2792>, 0, <4698, 2795, 771>, 0, 
			<771, 2790, 4698>, 0, <2795, 4698, 3050>, 0, <2795, 3050, 906>, 0, <905, 3050, 4698>, 0, <4698, 2792, 905>, 0, <2795, 4699, 2793>, 0, <2793, 771, 2795>, 0, <4699, 2798, 772>, 0, <772, 2793, 4699>, 0, <2798, 4699, 3051>, 0, <2798, 3051, 907>, 0, 
			<906, 3051, 4699>, 0, <4699, 2795, 906>, 0, <2798, 4700, 2796>, 0, <2796, 772, 2798>, 0, <4700, 2801, 773>, 0, <773, 2796, 4700>, 0, <2801, 4700, 3052>, 0, <2801, 3052, 908>, 0, <907, 3052, 4700>, 0, <4700, 2798, 907>, 0, <2801, 4701, 2799>, 0, 
			<2799, 773, 2801>, 0, <4701, 2804, 774>, 0, <774, 2799, 4701>, 0, <2804, 4701, 3053>, 0, <2804, 3053, 909>, 0, <908, 3053, 4701>, 0, <4701, 2801, 908>, 0, <2804, 4702, 2802>, 0, <2802, 774, 2804>, 0, <2802, 4702, 2807>, 0, <2807, 775, 2802>, 0, 
			<2807, 4702, 3054>, 0, <3054, 910, 2807>, 0, <909, 3054, 4702>, 0, <4702, 2804, 909>, 0, <775, 2807, 4703>, 0, <4703, 2805, 775>, 0, <2805, 4703, 776>, 0, <4703, 2809, 776>, 0, <2809, 4703, 3055>, 0, <3055, 911, 2809>, 0, <910, 3055, 4703>, 0, 
			<910, 4703, 2807>, 0, <3136, 944, 3166>, 0, <3136, 3166, 4704>, 0, <3138, 945, 3136>, 0, <3138, 3136, 4704>, 0, <946, 3138, 3140>, 0, <3138, 4704, 3140>, 0, <947, 3140, 3142>, 0, <3140, 4704, 3142>, 0, <948, 3142, 3144>, 0, <3142, 4704, 3144>, 0, 
			<949, 3144, 3146>, 0, <3144, 4704, 3146>, 0, <950, 3146, 3148>, 0, <3146, 4704, 3148>, 0, <951, 3148, 3150>, 0, <3148, 4704, 3150>, 0, <952, 3150, 3152>, 0, <3150, 4704, 3152>, 0, <3154, 953, 3152>, 0, <3154, 3152, 4704>, 0, <3156, 954, 3154>, 0, 
			<3156, 3154, 4704>, 0, <3156, 4704, 3158>, 0, <3158, 955, 3156>, 0, <3158, 4704, 3160>, 0, <3160, 956, 3158>, 0, <3160, 4704, 3162>, 0, <3162, 957, 3160>, 0, <3162, 4704, 3164>, 0, <3164, 958, 3162>, 0, <3164, 4704, 3166>, 0, <3166, 959, 3164>, 0, 
			<634, 3057, 4705>, 0, <4705, 2516, 634>, 0, <2516, 4705, 3056>, 0, <3056, 625, 2516>, 0, <776, 3056, 2808>, 0, <3056, 4705, 2808>, 0, <2808, 4705, 785>, 0, <4705, 3057, 785>, 0, <643, 3058, 4706>, 0, <4706, 2541, 643>, 0, <2541, 4706, 3057>, 0, 
			<3057, 634, 2541>, 0, <785, 3057, 2826>, 0, <3057, 4706, 2826>, 0, <2826, 4706, 794>, 0, <4706, 3058, 794>, 0, <652, 3059, 4707>, 0, <4707, 2558, 652>, 0, <2558, 4707, 3058>, 0, <3058, 643, 2558>, 0, <794, 3058, 2843>, 0, <3058, 4707, 2843>, 0, 
			<2843, 4707, 803>, 0, <4707, 3059, 803>, 0, <661, 3060, 4708>, 0, <4708, 2575, 661>, 0, <2575, 4708, 3059>, 0, <3059, 652, 2575>, 0, <803, 3059, 2860>, 0, <3059, 4708, 2860>, 0, <2860, 4708, 812>, 0, <4708, 3060, 812>, 0, <670, 3061, 4709>, 0, 
			<4709, 2592, 670>, 0, <2592, 4709, 3060>, 0, <3060, 661, 2592>, 0, <812, 3060, 2877>, 0, <3060, 4709, 2877>, 0, <2877, 4709, 821>, 0, <4709, 3061, 821>, 0, <679, 3062, 4710>, 0, <4710, 2609, 679>, 0, <2609, 4710, 3061>, 0, <3061, 670, 2609>, 0, 
			<821, 3061, 2894>, 0, <3061, 4710, 2894>, 0, <2894, 4710, 830>, 0, <4710, 3062, 830>, 0, <688, 3063, 4711>, 0, <4711, 2626, 688>, 0, <2626, 4711, 3062>, 0, <3062, 679, 2626>, 0, <830, 3062, 2911>, 0, <3062, 4711, 2911>, 0, <2911, 4711, 839>, 0, 
			<4711, 3063, 839>, 0, <697, 3064, 4712>, 0, <4712, 2643, 697>, 0, <2643, 4712, 3063>, 0, <3063, 688, 2643>, 0, <839, 3063, 2928>, 0, <3063, 4712, 2928>, 0, <2928, 4712, 848>, 0, <4712, 3064, 848>, 0, <3065, 4713, 2660>, 0, <2660, 706, 3065>, 0, 
			<697, 2660, 4713>, 0, <697, 4713, 3064>, 0, <848, 3064, 4713>, 0, <848, 4713, 2945>, 0, <2945, 4713, 3065>, 0, <2945, 3065, 857>, 0, <3066, 4714, 2677>, 0, <2677, 715, 3066>, 0, <706, 2677, 4714>, 0, <706, 4714, 3065>, 0, <857, 3065, 4714>, 0, 
			<857, 4714, 2962>, 0, <2962, 4714, 3066>, 0, <2962, 3066, 866>, 0, <3067, 4715, 2694>, 0, <2694, 724, 3067>, 0, <715, 2694, 4715>, 0, <715, 4715, 3066>, 0, <866, 3066, 4715>, 0, <866, 4715, 2979>, 0, <2979, 4715, 3067>, 0, <2979, 3067, 875>, 0, 
			<3068, 4716, 2711>, 0, <2711, 733, 3068>, 0, <724, 2711, 4716>, 0, <724, 4716, 3067>, 0, <875, 3067, 4716>, 0, <875, 4716, 2996>, 0, <2996, 4716, 3068>, 0, <2996, 3068, 884>, 0, <3069, 4717, 2728>, 0, <2728, 742, 3069>, 0, <733, 2728, 4717>, 0, 
			<733, 4717, 3068>, 0, <884, 3068, 4717>, 0, <884, 4717, 3013>, 0, <3013, 4717, 3069>, 0, <3013, 3069, 893>, 0, <3070, 4718, 2745>, 0, <2745, 751, 3070>, 0, <742, 2745, 4718>, 0, <742, 4718, 3069>, 0, <893, 3069, 4718>, 0, <893, 4718, 3030>, 0, 
			<3030, 4718, 3070>, 0, <3030, 3070, 902>, 0, <3071, 4719, 2762>, 0, <2762, 760, 3071>, 0, <751, 2762, 4719>, 0, <751, 4719, 3070>, 0, <902, 3070, 4719>, 0, <902, 4719, 3047>, 0, <3047, 4719, 3071>, 0, <3047, 3071, 911>, 0, <3056, 4720, 2517>, 0, 
			<2517, 625, 3056>, 0, <4720, 3071, 760>, 0, <760, 2517, 4720>, 0, <911, 3071, 4720>, 0, <911, 4720, 2809>, 0, <2809, 4720, 3056>, 0, <2809, 3056, 776>, 0, <777, 3073, 4721>, 0, <4721, 2785, 777>, 0, <2785, 4721, 3075>, 0, <3075, 768, 2785>, 0, 
			<3075, 4721, 3072>, 0, <3075, 3072, 913>, 0, <3072, 4721, 912>, 0, <4721, 3073, 912>, 0, <3075, 4722, 2786>, 0, <2786, 768, 3075>, 0, <4722, 3077, 903>, 0, <903, 2786, 4722>, 0, <4722, 3074, 914>, 0, <914, 3077, 4722>, 0, <3074, 4722, 3075>, 0, 
			<3074, 3075, 913>, 0, <3077, 4723, 3032>, 0, <3032, 903, 3077>, 0, <4723, 3079, 894>, 0, <894, 3032, 4723>, 0, <4723, 3076, 915>, 0, <915, 3079, 4723>, 0, <3076, 4723, 3077>, 0, <3076, 3077, 914>, 0, <3079, 4724, 3015>, 0, <3015, 894, 3079>, 0, 
			<4724, 3081, 885>, 0, <885, 3015, 4724>, 0, <4724, 3078, 916>, 0, <916, 3081, 4724>, 0, <3078, 4724, 3079>, 0, <3078, 3079, 915>, 0, <3081, 4725, 2998>, 0, <2998, 885, 3081>, 0, <4725, 3083, 876>, 0, <876, 2998, 4725>, 0, <4725, 3080, 917>, 0, 
			<917, 3083, 4725>, 0, <3080, 4725, 3081>, 0, <3080, 3081, 916>, 0, <3083, 4726, 2981>, 0, <2981, 876, 3083>, 0, <4726, 3085, 867>, 0, <867, 2981, 4726>, 0, <4726, 3082, 918>, 0, <918, 3085, 4726>, 0, <3082, 4726, 3083>, 0, <3082, 3083, 917>, 0, 
			<3085, 4727, 2964>, 0, <2964, 867, 3085>, 0, <4727, 3087, 858>, 0, <858, 2964, 4727>, 0, <4727, 3084, 919>, 0, <919, 3087, 4727>, 0, <3084, 4727, 3085>, 0, <3084, 3085, 918>, 0, <3087, 4728, 2947>, 0, <2947, 858, 3087>, 0, <4728, 3089, 849>, 0, 
			<849, 2947, 4728>, 0, <4728, 3086, 920>, 0, <920, 3089, 4728>, 0, <3086, 4728, 3087>, 0, <3086, 3087, 919>, 0, <3089, 4729, 2930>, 0, <2930, 849, 3089>, 0, <4729, 3091, 840>, 0, <840, 2930, 4729>, 0, <4729, 3088, 921>, 0, <921, 3091, 4729>, 0, 
			<3088, 4729, 3089>, 0, <3088, 3089, 920>, 0, <840, 3091, 4730>, 0, <4730, 2913, 840>, 0, <2913, 4730, 3093>, 0, <3093, 831, 2913>, 0, <3093, 4730, 3090>, 0, <3093, 3090, 922>, 0, <3090, 4730, 921>, 0, <4730, 3091, 921>, 0, <831, 3093, 4731>, 0, 
			<4731, 2896, 831>, 0, <2896, 4731, 3095>, 0, <3095, 822, 2896>, 0, <3095, 4731, 3092>, 0, <3095, 3092, 923>, 0, <3092, 4731, 922>, 0, <4731, 3093, 922>, 0, <822, 3095, 4732>, 0, <4732, 2879, 822>, 0, <2879, 4732, 3097>, 0, <3097, 813, 2879>, 0, 
			<3097, 4732, 3094>, 0, <3097, 3094, 924>, 0, <3094, 4732, 923>, 0, <4732, 3095, 923>, 0, <813, 3097, 4733>, 0, <4733, 2862, 813>, 0, <2862, 4733, 3099>, 0, <3099, 804, 2862>, 0, <3099, 4733, 3096>, 0, <3099, 3096, 925>, 0, <3096, 4733, 924>, 0, 
			<4733, 3097, 924>, 0, <804, 3099, 4734>, 0, <4734, 2845, 804>, 0, <2845, 4734, 3101>, 0, <3101, 795, 2845>, 0, <3101, 4734, 3098>, 0, <3101, 3098, 926>, 0, <3098, 4734, 925>, 0, <4734, 3099, 925>, 0, <795, 3101, 4735>, 0, <4735, 2828, 795>, 0, 
			<2828, 4735, 3103>, 0, <3103, 786, 2828>, 0, <3103, 4735, 3100>, 0, <3103, 3100, 927>, 0, <3100, 4735, 926>, 0, <4735, 3101, 926>, 0, <786, 3103, 4736>, 0, <4736, 2811, 786>, 0, <2811, 4736, 3073>, 0, <3073, 777, 2811>, 0, <3073, 4736, 3102>, 0, 
			<3073, 3102, 912>, 0, <3102, 4736, 927>, 0, <4736, 3103, 927>, 0, <3105, 4737, 3072>, 0, <3072, 912, 3105>, 0, <4737, 3107, 913>, 0, <913, 3072, 4737>, 0, <3107, 4737, 3104>, 0, <3107, 3104, 929>, 0, <3104, 4737, 928>, 0, <4737, 3105, 928>, 0, 
			<913, 3107, 4738>, 0, <4738, 3074, 913>, 0, <3074, 4738, 3109>, 0, <3109, 914, 3074>, 0, <3109, 4738, 930>, 0, <4738, 3106, 930>, 0, <3106, 4738, 3107>, 0, <3107, 929, 3106>, 0, <914, 3109, 4739>, 0, <4739, 3076, 914>, 0, <3076, 4739, 3111>, 0, 
			<3111, 915, 3076>, 0, <4739, 3108, 931>, 0, <931, 3111, 4739>, 0, <3108, 4739, 3109>, 0, <3108, 3109, 930>, 0, <915, 3111, 4740>, 0, <4740, 3078, 915>, 0, <3078, 4740, 3113>, 0, <3113, 916, 3078>, 0, <4740, 3110, 932>, 0, <932, 3113, 4740>, 0, 
			<3110, 4740, 3111>, 0, <3110, 3111, 931>, 0, <916, 3113, 4741>, 0, <4741, 3080, 916>, 0, <3080, 4741, 3115>, 0, <3115, 917, 3080>, 0, <3115, 4741, 3112>, 0, <3112, 933, 3115>, 0, <4741, 3113, 932>, 0, <932, 3112, 4741>, 0, <917, 3115, 4742>, 0, 
			<4742, 3082, 917>, 0, <3082, 4742, 3117>, 0, <3117, 918, 3082>, 0, <4742, 3114, 934>, 0, <934, 3117, 4742>, 0, <3114, 4742, 3115>, 0, <3114, 3115, 933>, 0, <918, 3117, 4743>, 0, <4743, 3084, 918>, 0, <3084, 4743, 3119>, 0, <3119, 919, 3084>, 0, 
			<4743, 3116, 935>, 0, <935, 3119, 4743>, 0, <3116, 4743, 3117>, 0, <3116, 3117, 934>, 0, <919, 3119, 4744>, 0, <4744, 3086, 919>, 0, <3086, 4744, 3121>, 0, <3121, 920, 3086>, 0, <4744, 3118, 936>, 0, <936, 3121, 4744>, 0, <3118, 4744, 3119>, 0, 
			<3118, 3119, 935>, 0, <920, 3121, 4745>, 0, <4745, 3088, 920>, 0, <3088, 4745, 3123>, 0, <3123, 921, 3088>, 0, <4745, 3120, 937>, 0, <937, 3123, 4745>, 0, <4745, 3121, 936>, 0, <936, 3120, 4745>, 0, <3123, 4746, 3090>, 0, <3090, 921, 3123>, 0, 
			<4746, 3125, 922>, 0, <922, 3090, 4746>, 0, <4746, 3122, 938>, 0, <938, 3125, 4746>, 0, <3122, 4746, 3123>, 0, <3122, 3123, 937>, 0, <3125, 4747, 3092>, 0, <3092, 922, 3125>, 0, <4747, 3127, 923>, 0, <923, 3092, 4747>, 0, <3127, 4747, 3124>, 0, 
			<3127, 3124, 939>, 0, <3124, 4747, 938>, 0, <4747, 3125, 938>, 0, <3127, 4748, 3094>, 0, <3094, 923, 3127>, 0, <4748, 3129, 924>, 0, <924, 3094, 4748>, 0, <3129, 4748, 3126>, 0, <3129, 3126, 940>, 0, <3126, 4748, 939>, 0, <4748, 3127, 939>, 0, 
			<3129, 4749, 3096>, 0, <3096, 924, 3129>, 0, <4749, 3131, 925>, 0, <925, 3096, 4749>, 0, <3131, 4749, 3128>, 0, <3131, 3128, 941>, 0, <3128, 4749, 940>, 0, <4749, 3129, 940>, 0, <3131, 4750, 3098>, 0, <3098, 925, 3131>, 0, <4750, 3133, 926>, 0, 
			<926, 3098, 4750>, 0, <3133, 4750, 942>, 0, <4750, 3130, 942>, 0, <3130, 4750, 3131>, 0, <3131, 941, 3130>, 0, <3133, 4751, 3100>, 0, <3100, 926, 3133>, 0, <4751, 3135, 927>, 0, <927, 3100, 4751>, 0, <3135, 4751, 3132>, 0, <3135, 3132, 943>, 0, 
			<3132, 4751, 942>, 0, <4751, 3133, 942>, 0, <3135, 4752, 3102>, 0, <3102, 927, 3135>, 0, <4752, 3105, 912>, 0, <912, 3102, 4752>, 0, <3105, 4752, 3134>, 0, <3105, 3134, 928>, 0, <3134, 4752, 943>, 0, <4752, 3135, 943>, 0, <3137, 4753, 3104>, 0, 
			<3104, 928, 3137>, 0, <4753, 3139, 929>, 0, <929, 3104, 4753>, 0, <3139, 4753, 3136>, 0, <3139, 3136, 945>, 0, <3136, 4753, 944>, 0, <4753, 3137, 944>, 0, <929, 3139, 4754>, 0, <929, 4754, 3106>, 0, <3106, 4754, 3141>, 0, <3106, 3141, 930>, 0, 
			<3141, 4754, 946>, 0, <4754, 3138, 946>, 0, <3138, 4754, 3139>, 0, <3139, 945, 3138>, 0, <930, 3141, 4755>, 0, <930, 4755, 3108>, 0, <3108, 4755, 3143>, 0, <3108, 3143, 931>, 0, <3143, 4755, 947>, 0, <4755, 3140, 947>, 0, <3140, 4755, 3141>, 0, 
			<3141, 946, 3140>, 0, <931, 3143, 3110>, 0, <3143, 4756, 3110>, 0, <3110, 4756, 932>, 0, <4756, 3145, 932>, 0, <3145, 4756, 948>, 0, <4756, 3142, 948>, 0, <4756, 3143, 947>, 0, <947, 3142, 4756>, 0, <932, 3145, 3112>, 0, <3145, 4757, 3112>, 0, 
			<3112, 4757, 933>, 0, <4757, 3147, 933>, 0, <3147, 4757, 949>, 0, <4757, 3144, 949>, 0, <4757, 3145, 948>, 0, <948, 3144, 4757>, 0, <933, 3147, 4758>, 0, <4758, 3114, 933>, 0, <3114, 4758, 3149>, 0, <3149, 934, 3114>, 0, <3149, 4758, 950>, 0, 
			<4758, 3146, 950>, 0, <4758, 3147, 949>, 0, <949, 3146, 4758>, 0, <934, 3149, 4759>, 0, <4759, 3116, 934>, 0, <3116, 4759, 3151>, 0, <3151, 935, 3116>, 0, <3151, 4759, 951>, 0, <4759, 3148, 951>, 0, <4759, 3149, 950>, 0, <950, 3148, 4759>, 0, 
			<935, 3151, 3118>, 0, <3151, 4760, 3118>, 0, <3118, 4760, 936>, 0, <4760, 3153, 936>, 0, <3153, 4760, 3150>, 0, <3150, 952, 3153>, 0, <4760, 3151, 951>, 0, <951, 3150, 4760>, 0, <936, 3153, 3120>, 0, <3153, 4761, 3120>, 0, <3120, 4761, 3155>, 0, 
			<3155, 937, 3120>, 0, <4761, 3152, 953>, 0, <953, 3155, 4761>, 0, <4761, 3153, 952>, 0, <952, 3152, 4761>, 0, <937, 3155, 4762>, 0, <4762, 3122, 937>, 0, <3122, 4762, 3157>, 0, <3157, 938, 3122>, 0, <4762, 3154, 954>, 0, <954, 3157, 4762>, 0, 
			<3154, 4762, 3155>, 0, <3154, 3155, 953>, 0, <938, 3157, 4763>, 0, <4763, 3124, 938>, 0, <3124, 4763, 3159>, 0, <3159, 939, 3124>, 0, <4763, 3156, 955>, 0, <955, 3159, 4763>, 0, <3156, 4763, 3157>, 0, <3156, 3157, 954>, 0, <3159, 4764, 3126>, 0, 
			<3126, 939, 3159>, 0, <4764, 3161, 940>, 0, <940, 3126, 4764>, 0, <4764, 3158, 956>, 0, <956, 3161, 4764>, 0, <3158, 4764, 3159>, 0, <3158, 3159, 955>, 0, <3161, 4765, 3128>, 0, <3128, 940, 3161>, 0, <4765, 3163, 941>, 0, <941, 3128, 4765>, 0, 
			<4765, 3160, 957>, 0, <957, 3163, 4765>, 0, <3160, 4765, 3161>, 0, <3160, 3161, 956>, 0, <941, 3163, 4766>, 0, <941, 4766, 3130>, 0, <3130, 4766, 3165>, 0, <3130, 3165, 942>, 0, <3165, 4766, 3162>, 0, <3165, 3162, 958>, 0, <3162, 4766, 957>, 0, 
			<4766, 3163, 957>, 0, <942, 3165, 4767>, 0, <942, 4767, 3132>, 0, <3132, 4767, 3167>, 0, <3132, 3167, 943>, 0, <3167, 4767, 3164>, 0, <3167, 3164, 959>, 0, <3164, 4767, 958>, 0, <4767, 3165, 958>, 0, <3167, 4768, 3134>, 0, <3134, 943, 3167>, 0, 
			<4768, 3137, 928>, 0, <928, 3134, 4768>, 0, <3137, 4768, 3166>, 0, <3137, 3166, 944>, 0, <3166, 4768, 959>, 0, <4768, 3167, 959>, 0, <961, 3172, 4769>, 0, <4769, 3171, 961>, 0, <962, 3171, 4769>, 0, <4769, 3175, 962>, 0, <4769, 3196, 971>, 0, 
			<971, 3175, 4769>, 0, <3196, 4769, 3172>, 0, <3196, 3172, 970>, 0, <962, 3175, 3174>, 0, <3175, 4770, 3174>, 0, <963, 3174, 4770>, 0, <4770, 3178, 963>, 0, <3178, 4770, 3198>, 0, <3198, 972, 3178>, 0, <3198, 4770, 3175>, 0, <3198, 3175, 971>, 0, 
			<963, 3178, 3177>, 0, <3178, 4771, 3177>, 0, <964, 3177, 4771>, 0, <4771, 3181, 964>, 0, <3181, 4771, 3200>, 0, <3200, 973, 3181>, 0, <4771, 3178, 972>, 0, <972, 3200, 4771>, 0, <964, 3181, 4772>, 0, <964, 4772, 3180>, 0, <965, 3180, 4772>, 0, 
			<4772, 3184, 965>, 0, <3184, 4772, 3202>, 0, <3202, 974, 3184>, 0, <4772, 3181, 973>, 0, <973, 3202, 4772>, 0, <965, 3184, 4773>, 0, <965, 4773, 3183>, 0, <966, 3183, 4773>, 0, <4773, 3187, 966>, 0, <3187, 4773, 3204>, 0, <3204, 975, 3187>, 0, 
			<4773, 3184, 974>, 0, <974, 3204, 4773>, 0, <966, 3187, 3186>, 0, <3187, 4774, 3186>, 0, <967, 3186, 4774>, 0, <4774, 3190, 967>, 0, <3190, 4774, 976>, 0, <4774, 3206, 976>, 0, <3206, 4774, 3187>, 0, <3187, 975, 3206>, 0, <967, 3190, 3189>, 0, 
			<3190, 4775, 3189>, 0, <968, 3189, 4775>, 0, <4775, 3192, 968>, 0, <3192, 4775, 3208>, 0, <3208, 977, 3192>, 0, <4775, 3190, 976>, 0, <976, 3208, 4775>, 0, <3192, 4776, 3168>, 0, <3192, 3168, 968>, 0, <3168, 4776, 960>, 0, <4776, 3169, 960>, 0, 
			<3169, 4776, 3194>, 0, <3194, 969, 3169>, 0, <977, 3194, 4776>, 0, <977, 4776, 3192>, 0, <970, 3197, 4777>, 0, <4777, 3196, 970>, 0, <3196, 4777, 3199>, 0, <3199, 971, 3196>, 0, <4777, 3213, 980>, 0, <980, 3199, 4777>, 0, <3213, 4777, 3197>, 0, 
			<3213, 3197, 979>, 0, <971, 3199, 4778>, 0, <4778, 3198, 971>, 0, <3198, 4778, 3201>, 0, <3201, 972, 3198>, 0, <4778, 3215, 981>, 0, <981, 3201, 4778>, 0, <3215, 4778, 3199>, 0, <3215, 3199, 980>, 0, <972, 3201, 4779>, 0, <4779, 3200, 972>, 0, 
			<3200, 4779, 3203>, 0, <3203, 973, 3200>, 0, <4779, 3217, 982>, 0, <982, 3203, 4779>, 0, <3217, 4779, 3201>, 0, <3217, 3201, 981>, 0, <973, 3203, 3202>, 0, <3203, 4780, 3202>, 0, <974, 3202, 4780>, 0, <4780, 3205, 974>, 0, <4780, 3219, 983>, 0, 
			<983, 3205, 4780>, 0, <3219, 4780, 3203>, 0, <3219, 3203, 982>, 0, <974, 3205, 4781>, 0, <974, 4781, 3204>, 0, <975, 3204, 4781>, 0, <4781, 3207, 975>, 0, <3207, 4781, 3221>, 0, <3221, 984, 3207>, 0, <4781, 3205, 983>, 0, <983, 3221, 4781>, 0, 
			<975, 3207, 3206>, 0, <3207, 4782, 3206>, 0, <976, 3206, 4782>, 0, <4782, 3209, 976>, 0, <3209, 4782, 3223>, 0, <3223, 985, 3209>, 0, <4782, 3207, 984>, 0, <984, 3223, 4782>, 0, <976, 3209, 3208>, 0, <3209, 4783, 3208>, 0, <977, 3208, 4783>, 0, 
			<4783, 3210, 977>, 0, <3210, 4783, 3225>, 0, <3225, 986, 3210>, 0, <4783, 3209, 985>, 0, <985, 3225, 4783>, 0, <3210, 4784, 3194>, 0, <3210, 3194, 977>, 0, <3194, 4784, 969>, 0, <4784, 3195, 969>, 0, <3195, 4784, 3211>, 0, <3211, 978, 3195>, 0, 
			<986, 3211, 4784>, 0, <986, 4784, 3210>, 0, <979, 3214, 4785>, 0, <4785, 3213, 979>, 0, <3213, 4785, 3216>, 0, <3216, 980, 3213>, 0, <4785, 3230, 989>, 0, <989, 3216, 4785>, 0, <3230, 4785, 3214>, 0, <3230, 3214, 988>, 0, <980, 3216, 4786>, 0, 
			<4786, 3215, 980>, 0, <3215, 4786, 3218>, 0, <3218, 981, 3215>, 0, <4786, 3232, 990>, 0, <990, 3218, 4786>, 0, <3232, 4786, 3216>, 0, <3232, 3216, 989>, 0, <981, 3218, 4787>, 0, <4787, 3217, 981>, 0, <3217, 4787, 3220>, 0, <3220, 982, 3217>, 0, 
			<4787, 3234, 991>, 0, <991, 3220, 4787>, 0, <3234, 4787, 3218>, 0, <3234, 3218, 990>, 0, <982, 3220, 4788>, 0, <4788, 3219, 982>, 0, <3219, 4788, 3222>, 0, <3222, 983, 3219>, 0, <4788, 3236, 992>, 0, <992, 3222, 4788>, 0, <3236, 4788, 3220>, 0, 
			<3236, 3220, 991>, 0, <983, 3222, 3221