alias invt return $trans4to3($inv_matrix($trans3to4($1-)))
alias trans3to4 {
  tokenize 32 $1-
  return $1 $2 $3 0.0 $4 $5 $6 0.0 $7 $8 $9 0.0 0.0 0.0 0.0 1.0
}
alias trans4to3 {
  tokenize 32 $1-
  return $1 $2 $3 $5 $6 $7 $9 $10 $11
}
alias inv_matrix {
  var %m = $dll(meshview.dll,invmatrix,$1)
  if (%m) return %m
  echo -s %m . 0 means failure
  return $1
}
alias lunar-pos {
  ; (jd)
  return $dll(meshview.dll,lunarpos,$1)
}
alias bitwise return $dll(meshview.dll,bitwise,$1-)
alias bitshiftl return $dll(meshview.dll,bitshiftl,$1-)
alias bitshiftr return $dll(meshview.dll,bitshiftr,$1-)
alias bitequals return $dll(meshview.dll,bitequals,$1-)
alias ediv return $dll(meshview.dll,fdiv,$1-)
alias emult return $dll(meshview.dll,fmult,$1-)
alias lacos return $dll(meshview.dll,dacos,$1)
alias lsin return $dll(meshview.dll,dsin,$1)
alias lasin return $dll(meshview.dll,dasin,$1)
alias lcos return $dll(meshview.dll,dcos,$1)
alias lsub return $dll(meshview.dll,dsub,$1-)
alias ladd return $dll(meshview.dll,dadd,$1-)
alias ldiv return $dll(meshview.dll,ddiv,$1-)
alias lmult return $dll(meshview.dll,dmult,$1-)
alias lsqrt return $dll(meshview.dll,dsqrt,$1)
alias lpow return $dll(meshview.dll,dpow,$1-)
alias lround return $dll(meshview.dll,drnd,$1-)
alias lmod return $dll(meshview.dll,dmod,$1-)
alias atan2r return $dll(meshview.dll,datan2,$2 $1)
alias atan2 return $dll(meshview.dll,datan2,$1-)
alias latan return $dll(meshview.dll,datan,$1)
alias logd return $dll(meshview.dll,dlog,$1)
alias log_E return $ldiv($logd($1), $logd(2.7182818284590452353602874713526))
alias log10 return $calc($logd($1) / $logd(10))
alias log2 return $ldiv($logd($1), $logd(2))
alias logbase return $calc($logd($2) / $logd($1))
; lg = logarithm of exponential | $logbase(2,0.125)  |<>| 2 ^ -3 |
; N bits for a binary representation of a positive integer n is the integral part of 1 + lg n, [log2(n)]
alias posintbits return $int($calc($logbase(2,$1) + 1))
alias cuberoot return $lpow($1, 0.3333333333333333)
alias lrotate return $dll(meshview.dll,drotate,$1-)
alias lrotation return $dll(meshview.dll,drotation,$1-)
alias unloadll {
  if ($dll($_dllfile,isloaded,1)) dll $_dllfile unload
}
alias _loadll {
  if ($dll($_dllfile,isloaded,1) == 0) dll $_dllfile load
}
alias _dllfile {
  if ($findfile($mircdir,meshview.dll,1,4)) return $ifmatch
  if ($findfile($scriptdir,meshview.dll,1,0)) return $ifmatch
}
alias multv {
  tokenize 32 $1-
  return $lmult($1, $4) $lmult($2, $4) $lmult($3, $4)
  return $calc($1 * $4) $calc($2 * $4) $calc($3 * $4)
}
alias multvv {
  tokenize 32 $1-
  return $calc($1 * $4) $calc($2 * $5) $calc($3 * $6)
}
alias divv {
  tokenize 32 $1-
  return $calc($1 / $4) $calc($2 / $4) $calc($3 / $4)
}
alias compass {
  var %b = $round($rad2deg($1),1)
  %b = $abs(%b) % 360
  if (%b) return %b
  return 360
}
alias deg2rad {
  return $calc($1 / 57.295779513082323)
}
alias rad2deg {
  return $calc($1 * 57.295779513082323)
}
alias subv {
  tokenize 32 $1-
  ; return $lsub($1,$4) $lsub($2,$5) $lsub($3,$6)
  return $calc($1 - $4) $calc($2 - $5) $calc($3 - $6)
}
alias addv {
  tokenize 32 $1-
  return $ladd($1,$4) $ladd($2,$5) $ladd($3,$6)
}
alias addvi {
  tokenize 32 $1-
  return $int($calc($1 + $4)) $int($calc($2 + $5)) $int($calc($3 + $6))
}
alias addv3 {
  tokenize 32 $1-
  return $ladd($1,$ladd($4, $7)) $ladd($2, $ladd($5, $8)) $ladd($3, $ladd($6, $9))
  return $calc($1 + $4 + $7) $calc($2 + $5 + $8) $calc($3 + $6 + $9)
}
alias vlen {
  tokenize 32 $1-
  ; return $lsqrt($ladd($lmult($1,$1), $ladd($lmult($2,$2), $lmult($3,$3))))
  return $sqrt($calc(($1 ^ 2) + ($2 ^ 2) + ($3 ^ 2)))
}
alias normalize {
  var %d = $vlen($1-)
  if (%d == 0) { _e divide by 0 = %d | return $1- }
  tokenize 32 $1-
  return $ldiv($1,%d) $ldiv($2,%d) $ldiv($3,%d)
  return $calc($1 / %d) $calc($2 / %d) $calc($3 / %d)
}
alias dotprod {
  tokenize 32 $1-
  ;  return $ladd($lmult($1,$4), $ladd($lmult($2,$5), $lmult($3,$6)))
  return $calc(($1 * $4) + ($2 * $5) + ($3 * $6))
}
alias radian {
  ; (3 pts 3D) - angle always positive PI
  return $lacos($clamp($dotprod($normalize($subv($2,$1)),$normalize($subv($3,$1))), -1.0, 1.0))
}
alias radian-seq {
  ; (3 pts 3D) - angle always positive PI
  return $lacos($clamp($dotprod($normalize($subv($1,$2)),$normalize($subv($3,$2))), -1.0, 1.0))
}

alias radian-nosub {
  ; (2 pts 3D)
  return $lacos($clamp($dotprod($normalize($1),$normalize($2)), -1.0, 1.0))
}
alias clamp {
  if ($1 < $2) return $2
  if ($1 > $3) return $3
  return $1
}
alias angle2 {
  return $rad2deg($radian-nosub($1,$2))
}
alias radang {
  return $radian($1,$2,$3)
}
alias angle {
  return $rad2deg($radian($1,$2,$3))
}
alias crossprod {
  tokenize 32 $1-
  return $lsub($lmult($2,$6),$lmult($3,$5)) $lsub($lmult($3,$4),$lmult($1,$6)) $lsub($lmult($1,$5),$lmult($2,$4))
  return $calc(($2 * $6) - ($3 * $5)) $calc(($3 * $4) - ($1 * $6)) $calc(($1 * $5) - ($2 * $4))
}
alias cross {
  tokenize 32 $1-
  return $lsub($lmult($2,$6),$lmult($3,$5)) $lsub($lmult($3,$4),$lmult($1,$6)) $lsub($lmult($1,$5),$lmult($2,$4))
  return $calc(($2 * $6) - ($3 * $5)) $calc(($3 * $4) - ($1 * $6)) $calc(($1 * $5) - ($2 * $4))
}
alias nnormalvector {
  return $normalize($crossprod($subv($3,$2),$subv($1,$2)))
}
alias normalvector {
  return $crossprod($subv($3,$2),$subv($1,$2))
  1
  |
  2__ 3
}
alias midpoint {
  tokenize 32 $1-
  return $calc(($1 + $4) / 2) $calc(($2 + $5) / 2) $calc(($3 + $6) / 2)
}
alias rotate {
  if ($1 == 0 1) return $3
  ; (sin(r) cos(r), axis[3], point[3]) - constant radian performance - no trig
  var %x, %y, %z, %xx, %yy, %zz, %xy, %yz, %zx, %xs, %ys, %zs, %o_c
  var %s, %c, %m
  if ($gettok($1,2,32)) {
    %c = $ifmatch
    %s = $gettok($1,1,32)
  }
  else {
    %s = $sin($1)
    %c = $cos($1)
  }
  ; Normalize axis
  %m = $vlen($2)
  if (%m == 0) return $3
  %x = $gettok($2,1,32) / %m
  %y = $gettok($2,2,32) / %m
  %z = $gettok($2,3,32) / %m
  %xx = %x ^ 2 | %yy = %y ^ 2 | %zz = %z ^ 2
  %xy = %x * %y | %yz = %y * %z | %zx = %z * %x
  %xs = %x * %s | %ys = %y * %s | %zs = %z * %s
  %o_c = 1.0 - %c
  tokenize 32 $3
  %x = $calc($1 * ((%o_c * %xx) + %c))
  %y = $calc($1 * ((%o_c * %xy) - %zs))
  %z = $calc($1 * ((%o_c * %zx) + %ys))
  inc %x $calc($2 * ((%o_c * %xy) + %zs))
  inc %y $calc($2 * ((%o_c * %yy) + %c))
  inc %z $calc($2 * ((%o_c * %yz) - %xs))
  inc %x $calc($3 * ((%o_c * %zx) - %ys))
  inc %y $calc($3 * ((%o_c * %yz) + %xs))
  inc %z $calc($3 * ((%o_c * %zz) + %c))
  return %x %y %z
}
alias rotation {
  ; (radian, axis[3], point[3]) with trig
  var %x, %y, %z, %xx, %yy, %zz, %xy, %yz, %zx, %xs, %ys, %zs, %o_c
  var %s, %c, %m
  %s = $sin($1)
  %c = $cos($1)
  ; Normalize axis
  %m = $vlen($2)
  if (%m == 0) return $3
  %x = $gettok($2,1,32) / %m
  %y = $gettok($2,2,32) / %m
  %z = $gettok($2,3,32) / %m
  %xx = %x ^ 2 | %yy = %y ^ 2 | %zz = %z ^ 2
  %xy = %x * %y | %yz = %y * %z | %zx = %z * %x
  %xs = %x * %s | %ys = %y * %s | %zs = %z * %s
  %o_c = 1.0 - %c
  tokenize 32 $3
  %x = $calc($1 * ((%o_c * %xx) + %c))
  %y = $calc($1 * ((%o_c * %xy) - %zs))
  %z = $calc($1 * ((%o_c * %zx) + %ys))
  inc %x $calc($2 * ((%o_c * %xy) + %zs))
  inc %y $calc($2 * ((%o_c * %yy) + %c))
  inc %z $calc($2 * ((%o_c * %yz) - %xs))
  inc %x $calc($3 * ((%o_c * %zx) - %ys))
  inc %y $calc($3 * ((%o_c * %yz) + %xs))
  inc %z $calc($3 * ((%o_c * %zz) + %c))
  return %x %y %z
}
alias rotxx {
  ; tokenize 32 $1-
  var %y = $2, %z
  var %c = $cos($4), %s = $sin($4)
  %z = $calc((%y * %s) + (%c * $3))
  %y = $calc((%y * %c) - (%s * $3))
  return $1 %y %z
}
; *******2d triangulation using 3dpoints*******
alias normlen3 {
  ; (normal,face)
  tokenize 32 $1-
  var %normal = $1 $2 $3
  var %a = 0 0 0, %b = $4 $5 $6, %c = %normal
  var %ang = $radian-nosub(%b,%c), %l = $vlen(%b), %n, %s
  %s = $calc($cos(%ang) * %l)
  %n = $normalize(%normal)
  return $multv(%n, %s)
}
alias normlen {
  ; (normal,face)
  tokenize 32 $1-
  var %normal = $1 $2 $3
  var %a = 0, %b = $4 $5 $6, %c = %normal
  var %ang = $radian-nosub(%b,%c), %l = $vlen(%b), %n, %s
  %a = %PI.5 - %ang
  ; sin of third ang or cos of known ang for right triangle AHA - angle hyponteneus angle
  ; otherwise its $calc($sin(%a) * %l : $sin(angle opposite to l)) or aas-sin(a,a,s)
  ; $sin(%PI.5) = 1
  %s = $calc($sin(%a) * %l)
  %n = $normalize(%normal)
  return $multv(%n, %s)
}
alias normlen2 {
  ; (normal,face)
  tokenize 32 $1-
  var %n = $1 $2 $3, %a = $normalize(%n), %ang
  var %b = $4 $5 $6, %c = 0 0 0, %l = $vlen(%b)
  :loop | dec %l 2
  %n = $multv(%a,%l)
  %ang = $angle(%n,%b,%c)
  if (%ang < 90) goto loop
  return %n
}
alias samel {
  return $multv($normalize($1),$2)
  var %l = $vlen($1)
  return $multv($1,$calc($2 / %l))
}
; *******2D*******
alias samel2 {
  return $multv2($normalize2($1),$2)
  var %l = $vlen2($1)
  return $multv2($1,$calc($2 / %l))
}
alias vlen2 {
  tokenize 32 $1-
  ; return $lsqrt($ladd($lmult($1, $1),$lmult($2, $2))))
  ; return $lsqrt($ladd($lpow($1, 2),$lpow($2,2))))
  return $sqrt($calc(($1 ^ 2) + ($2 ^ 2)))
}
alias subv2 {
  tokenize 32 $1-
  return $calc($1 - $3) $calc($2 - $4)
}
alias subv2i {
  tokenize 32 $1-
  return $int($calc($1 - $3)) $int($calc($2 - $4))
}
alias addv2 {
  tokenize 32 $1-
  return $calc($1 + $3) $calc($2 + $4)
}
alias addv2i {
  tokenize 32 $1-
  return $int($calc($1 + $3)) $int($calc($2 + $4))
  )
}
alias radang2 {
  ; (2 2d pts) ,,s not required
  tokenize 32 $1-
  var %v = $1 $2, %v2 = $3 $4, %r
  %r = $dotprod2($normalize2(%v),$normalize2(%v2))
  %r = $clamp(%r, -1.0, 1.0)
  return $lacos(%r)
}
alias radang32d {
  ; (p,p,p)3 2d pts
  var %r = $dotprod2($normalize2($subv2($2,$1)),$normalize2($subv2($3,$1))))
  %r = $clamp(%r, -1.0, 1.0)
  return $acos(%r)
}
alias dotprod2 {
  tokenize 32 $1-
  return $calc(($1 * $3) + ($2 * $4))
}
alias multv26 {
  var %m = $2
  tokenize 160 $1
  return $+($calc($remove($1,$chr(160)) * %m), $chr(160), $calc($remove($2,$chr(160)) * %m))
}
alias multv2 {
  tokenize 32 $1-
  return $calc($1 * $3) $calc($2 * $3)
}
alias multv2i {
  tokenize 32 $1-
  return $int($calc($1 * $3)) $int( $calc($2 * $3))
}
alias multvv2 {
  tokenize 32 $1-
  return $calc($1 * $3) $calc($2 * $4)
}
alias divvv2 {
  tokenize 32 $1-
  return $calc($1 / $3) $calc($2 / $4)
}
alias divv2 {
  tokenize 32 $1-
  return $calc($1 / $3) $calc($2 / $3)
}
alias divv2i {
  tokenize 32 $1-
  return $int($calc($1 / $3)) $int($calc($2 / $3))
}
alias normalize2 {
  var %d = $vlen2($1-)
  if (%d == 0) return $1-
  tokenize 32 $1-
  return $calc($1 / %d) $calc($2 / %d)
}
alias midpoint2 {
  tokenize 32 $1-
  return $calc(($1 + $3) / 2) $calc(($2 + $4) / 2)
}
alias Semi-major_axis {
  ; (mean motion @epoch in revolutions per day)
  return $calc((8681663.653 / $1) ^ (2 / 3))
  return km
}
; ********YEARS of Earth In Degrees Per Day******
alias Sidereal_rotation_period return 360.98983412517123
alias Tropical_year {
  if ($prop == days) return 365.24218967
  return 0.985647359975756
}
alias Vernal_equinox_year {
  if ($prop == days) return 365.2424
  return $ldiv(360.0, 365.2424)
}
alias Calendar_year {
  if ($prop == days) return 365.2425
  return $ldiv(360.0, 365.2425)
  ; 0.985646522515863
}
alias Julian_year {
  if ($prop == days) return 365.25
  return $ldiv(360.0, 365.25)
  ; 0.985626283367556
}
alias Sidereal_year {
  ; if ($prop == days) return 365.25636042 
  if ($prop == days) return 365.256363051 
  return 0.985609112988222
}
alias Anomalistic_year {
  if ($prop == days) return 365.259635864
  return 0.985600281696721
}
alias Draconic {
  ; Draconic or Draconitic year, eclipse year
  if ($prop == days) return 346.620075883
  return $ldiv(360.0, 346.620075883)
}
alias yearsoflight {
  ; onlineconversion.com
  1 light year [Julian] = 5878625373183.607 mile
  1 light year [tropical] = 5878499814135.05 mile
  1 light year [traditional] = 5874601673407.301 mile

  1 light year [Julian] = 9460730472580.8 kilometer
  1 light year [tropical] = 9460528404879.357 kilometer
  1 light year [traditional] = 9454254955488.0 kilometer
}
alias ausinaparsec {
  return 206264.80624709636
  return 206264.80624872944
  ; height of right triangle L\ = $aas-sin($arcsec2rad(1),$lsub(%PI.5, $arcsec2rad(1)),1)
  ; hypot = $aas-sin($arcsec2rad(1),%PI.5,1) = 206264.80625115347 = $ldiv(1,$arcsec2rad(1))
  ; 30856775813057.293
  ; $ldiv(30856775813301.598, 149597870.691) km ... pc/au
  ; 3600 * 180 ISOSCELES height
  ; $ldiv(648000,%PI) = 206264.80624709636

  ; 149597870.691 km, $ausinaparsec, 299792.458 km,
  ; and mi/km ratio of 1.609344 are 4 constants for distance
}
alias pc2ly return $lmult($1, $km2ly($pc2km(1)))
alias pc2au return $lmult($1, $ausinaparsec)
alias pc2km return $lmult($1, $lmult($au2km(1), $ausinaparsec))
alias pc2mi return $lmult($1, $km2mi($pc2km(1)))

alias ly2pc return $lmult($1, $km2pc($ly2km(1)))
alias ly2au return $lmult($1, $km2au($ly2km(1)))
alias ly2mi return $lmult($1, $lightyearmi)
alias kly2mi return $lmult($1, 5878625373183607.4)
alias ly2km return $lmult($1, $lightyearkm)

alias lightspeed {
  if ($prop == km) return 299792.458
  return $km2mi(299792.458)
  ; per sec
}
alias lightyearkm return $calc($lightspeed(0).km * $jsecyear)
alias lightyearmi return $lmult($lightspeed, $jsecyear)
alias jsecyear return $calc($secday * 365.25)
alias gsecyear return $calc($secday * 365.2425)
alias secday {
  return 86400
}
alias minday {
  return 1440
}
alias au2pc return $ldiv($1, $ausinaparsec)
alias au2ly return $ldiv($1, $km2au($lightyearkm))
alias au2mi return $lmult($1, $km2mi($au2km(1)))
alias au2km return $lmult($1, 149597870.691)

alias mi2ly return $ldiv($1, $lightyearmi)
alias mi2pc return $ldiv($1, $km2mi($pc2km(1)))
alias mi2au return $ldiv($1, $km2mi($au2km(1)))
alias mi2km return $lmult($1,1.609344)

alias km2pc-2 return $au2pc($km2au($1))

alias km2mi return $ldiv($1, 1.609344)
alias km2ly return $ldiv($1, $lightyearkm)
alias km2pc return $ldiv($1, $calc($au2km(1) * $ausinaparsec))
alias km2au return $ldiv($1, 149597870.691)
alias km2earth return $calc($1 / 6378.003888)

; *********2d triangulation**********
alias arcmin2rad return $ldiv($1,$ldiv(10800,%PI))
alias arcsec2rad return $ldiv($1,$ausinaparsec)
alias marcsec2rad return $ldiv($1,$ldiv(648000000,%PI))
alias  rad2arcmin return $lmult($1,$ldiv(10800,%PI))
alias rad2arcsec return $lmult($1,$ausinaparsec)
alias rad2marcsec return $lmult($1,$ldiv(648000000,%PI))

alias arcmin2rad-1 return $deg2rad($ldiv($1, 60))
alias marcsec2rad-1 return $deg2rad($ldiv($1, 3600000))
alias arcsec2rad-1 {
  return $deg2rad($ldiv($1, 3600))
  return $lmult($1,$au2pc(1))
  $ldiv(%PI, $lmult(3600, 180))
}
alias parallax2parsec {
  ; (parallax-mas)
  var %r = $marcsec2rad($1)
  return $lmult($ldiv($au2pc(1), $lsin(%r)), $lsin($lsub(%PI.5, %r)))
  return $asa-sin(%PI.5,0.000004848136811,$lsub(%PI.5, $marcsec2rad($1)))
  _e $parallax2parsec(379.21) parsecs to Sirius
}
alias centroid {
  ; (3 2d points)
  tokenize 32 $1-
  var %x = $calc($1 + $3 + $5)
  var %y = $calc($2 + $4 + $6)
  return $calc(%x / 3) $calc(%y / 3)
}
alias ccenter {
  return $circumcenter($1-)
}
alias circumcenter {
  ; (3 pts 2d or 3d) returns x y z
  tokenize 32 $1-
  var %6 = 0
  if ($0 == 6) { tokenize 32 $1 $2 0 $3 $4 0 $5 $6 0 | %6 = 1 }
  var %a = $vlen($subv($1-)), %b = $vlen($subv($4-)), %c = $vlen($subv($1 $2 $3, $7-))
  var %lc = $calc((((%b ^ 2) + (%c ^ 2) - (%a ^ 2)) / (2 * %b * %c)) * $circumradius(%a,%b,%c))
  var %mp = $midpoint($1-), %v = $normalize($subv($1 $2 $3,%mp))
  tokenize 32 $addv(%mp,$multv($normalize($crossprod(%v,$normalvector( $&
    $1 $2 $3, $4 $5 $6, $7 $8 $9))),%lc))
  if (%6) return $1 $2
  return $1-
}
alias orthocenter {
  ; (3 pts 2d or 3d)
  tokenize 32 $1-
  var %6 = 0
  if ($0 == 6) { tokenize 32 $1 $2 0 $3 $4 0 $5 $6 0 | %6 = 1 }
  var %cc = $ccenter($1-)
  tokenize 32 $addv(%cc,$addv3($subv($1 $2 $3,%cc), $subv($4 $5 $6,%cc), $subv($7 $8 $9,%cc)))
  if (%6) return $1 $2
  return $1-
}
alias orthocenter_2d {
  ; (3 pts 2d)
  tokenize 32 $1-
  var %x = $calc($1 * $3 * ($2 - $4) + $3 * $5 * ($4 - $6) + $5 * $1 * ($6 - $2) - ($2 - $4) * ($4 - $6) * ($6 - $2))
  %x = $calc(%x / ($5 * $4 - $3 * $6 + $1 * $6 - $5 * $2 + $3 * $2 - $1 * $4))
  var %y = $calc($2 * $4 * ($1 - $3) + $4 * $6 * ($3 - $5) + $6 * $2 * ($5 - $1) - ($1 - $3) * ($3 - $5) * ($5 - $1))
  %y = $calc(%y / ($6 * $3 - $4 * $5 + $2 * $5 - $6 * $1 + $4 * $1 - $2 * $3))
  return %x %y
  if (circumcenter == 0 0) return $calc($1 + $3 + $5) $calc($2 + $4 + $6)
}
alias circumradius {
  ; (3 lens)
  return $calc(($1 * $2 * $3) / (4 * $sss-area($1,$2,$3)))
  1. R = a/(2 sin A) = b/(2 sin B) = c/(2 sin C), and
  2. R = abc/4area
}
alias inneradius {
  ; (3 lens)
  var %i = $calc((($2 + $3 - $1) * ($3 + $1 - $2) * ($1 + $2 - $3)) / ($1 + $2 + $3))
  return $calc($sqrt(%i) / 2)
  2*area/(a+b+c) where side lens are abc
  distance(D) of o(circumcenter) and i(incenter) = D = sqrt(R(R-2r)) R=outer
  if circumcenter O has coordinates (0,0)
  then orthocenter H has coordinates ( x1+x2+x3 , y1+y2+y3 )
  if ABC lie on the unit circle, we have: (a1)^2 + (b1)^2 = (a2)^2 + (b2)^2 = (a3)^2 + (b3)^2 = 1
}
alias incenter2 {
  ; (string of 2d points any length) - uses first 3 (triangle)
  var %v = $gettok($1-,1-6,32)
  tokenize 32 $1-
  ; opposing side lens
  return $incenter(%v,$vlen2($subv2($3-)), $vlen2($subv2($1 $2 $5 $6)), $vlen2($subv2($1-)))
}
alias incenter {
  ; (3 pts 2d, 3 lens) - incenter2 does the lengths for you
  tokenize 32 $1-
  var %x = $calc($7 * $1 + $8 * $3 + $9 * $5)
  var %y = $calc($7 * $2 + $8 * $4 + $9 * $6)
  var %d = $calc($7 + $8 + $9)
  ; var %i = $inneradius($7,$8,$9)
  return $calc(%x / %d) $calc(%y / %d)
}
alias incenter3 {
  ; (3 pts 3d)
  tokenize 32 $1-
  var %a = $vlen($subv($1-)
  var %b = $vlen($subv($4-)
  var %c = $vlen($subv($1 $2 $3, $7-)

  var %d = $calc(%b + %c + %a)
  var %x = $calc(%b * $1 + %c * $4 + %a * $7)
  var %y = $calc(%b * $2 + %c * $5 + %a * $8)
  var %z = $calc(%b * $3 + %c * $6 + %a * $9)
  ; var %i = $inneradius($7,$8,$9)
  return $calc(%x / %d) $calc(%y / %d) $calc(%z / %d)
}
alias incenter3d {
  ; (3 pts 3d, 3 lens)
  tokenize 32 $1-
  var %d = $calc($10 + $11 + $12)
  var %x = $calc($10 * $1 + $11 * $4 + $12 * $7)
  var %y = $calc($10 * $2 + $11 * $5 + $12 * $8)
  var %z = $calc($10 * $3 + $11 * $6 + $12 * $9)
  ; var %i = $inneradius($7,$8,$9)
  return $calc(%x / %d) $calc(%y / %d) $calc(%z / %d)
}
alias test1 {
  iso-ab-height 0.2 110
  ; error 10th decimal
  echo -s 4******************************
  iso-abh-sin $arcsec2rad(1) 1
  ; error 5th decimal place
}
alias iso-ab-height {
  ; (angle,base) height of isosceles triangle
  var %s = $ldiv($2,2.0)
  var %a = $ldiv($lsub(%PI,$1),2.0)
  e $aas-sin($ldiv($1,2.0),%a,%s)
  e $asa-sin(%PI.5,%s,%a)
  ; only proves trig inaccuracy
  ; right triangle
  e $aas-sin($arcsec2rad(1),$lsub(%PI.5, $arcsec2rad(1)),1)
  e $aas-sin($arcsec2rad(1),%PI.5,1) = 206264.80625115347 = $ldiv(1,$arcsec2rad(1))
}
alias sss-height {
  ; height to side2
  return $calc($sss-area($1,$2,$3) / ($2 * 0.5))
}
alias sa-height {
  ; (side,angle) unkbase
  if ($2 < %PI) {
    var %h = $lsin($2) * $1
    if (%h == $1) { _e given right angle doh! | return $1 }
    return %h
  }
  return not a possible triangle
}
alias sas-height {
  ; height to missing side
  return $calc($sas-area($1,$2,$3) / ($sas-cos($1,$2,$3) * 0.5))
}
alias bh-area {
  ; (base,height)
  return $calc(0.5 * $1 * $2)
}
alias sss-area2 {
  ; (3 lens)
  return $calc(0.5 * ($1 + $2 + $3) * $inneradius($1,$2,$3))
}
alias sss-area3 {
  ; (3 lens)
  return $calc(($1 * $2 * $3) / (4 * $circumradius($1,$2,$3)))
}
alias sss-area {
  ; (3 lens)
  ; semi perimeter
  var %s = $calc(0.5 * ($1 + $2 + $3))
  return $sqrt($calc(%s * (%s - $1) * (%s - $2) * (%s - $3)))
}
alias sas-area {
  return $calc(0.5 * $1 * $lsin($2) * $3)
}
alias aas-sin {
  ; AAS solve opposing side of angle2 ($2)
  return $lmult($lsin($2), $ldiv($3, $lsin($1)))
}
alias asa-sin {
  ; ASA solve opposing side of angle2 ($3)
  var %a3 = $lsub(%PI, $ladd($1 $3))
  ; return $calc($lsin($3) * ($2 / $lsin(%a3)))
  return $lmult($lsin($3), $ldiv($2, $lsin(%a3)))
}
alias sss-cos {
  ; SSS solve angle opposite center side ($2)
  ;  var %c = $calc((($1 ^ 2) + ($3 ^ 2) - ($2 ^ 2)) / (2 * $1 * $3))
  var %c = $ldiv($lsub($ladd($lpow($1,2),$lpow($3,2)),$lpow($2,2)), $&
    $lmult($lmult(2,$1),$3)))
  ; if (%c < 0) _e obtuse
  ; else _e acute
  return $lacos(%c)
}
alias sas-cos {
  ; Side Angle Side - solve length of missing side
  var %c = $calc((($1 ^ 2) + ($3 ^ 2)) - (2 * $1 * $3 * $cos($2)))
  return $sqrt(%c)
}
alias ssa-acute {
  ; SSA solve ang opposing side2
  return $lasin($calc($2 * $lsin($3) / $1))
}
alias ssa-obtuse {
  ; SSA solve ang opposing side2
  var %a, %b, %c, %s, %h = $sin($3) * $2
  if (%h == $2) { _e given right angle | return $asin($calc(%h / $1)) }
  if (%h == $1) { _e right triangle solved | return %PI.5 }
  if ($1 == $2) { _e isosceles triangle | return $3 }
  if ($1 < %h) { _e no solution | return no solution }
  ; if ((%h < $1) && ($1 < $2)) _e two distinct solutions
  ; obtuse
  %b = %h / $1
  %b = $calc(%PI - $asin(%b))
  if (0) {
    ; %a = $calc(%PI - ($3 + %b))
    %a = $calc(%PI - ($3 + $asin($calc(%h / $1))))
    %s = $sas-cos($1, %a, $2)
    %c = $calc((($1 ^ 2) + (%s ^ 2) - ($2 ^ 2)) / (2 * $1 * %s))
    _e %c > 0?
    if (%c > 0) return $ssa-acute($1,$2,$3)
  }
  return %b
}
alias _e { echo -s $1- }
alias wikiq {
  var %q = $_?(wiki, Wikipedia)
}
alias wnetq {
  var %q = $_?(wnet, Word Net)
}
alias spellq {
  var %q = $_?(spell,Spell What?)
}
alias spell {
  ; not found Schadenfreude
  %origword = $1
  %getstr = /cgi-bin/spell.exe?action=CHECKWORD&string= $+ $1
  if ($sock(spell).name) {
    sockclose spell
    .timer 1 1 sockopen spell www.spellcheck.net 80
  }
  else sockopen spell www.spellcheck.net 80
}
on *:sockclose:spell: {
  ; _e  Spell socket closed by host
  unset %words %string
}
on *:sockopen:spell: {
  unset %words %string
  if ($sock(spell).name) sockwrite -n spell GET %getstr
  unset %getstr
}
on *:sockread:spell: {
  var %temp
  sockread %temp
  if (*correctly* iswm %temp) {
    echo -s %origword is spelled correctly
    unset %origword
  }
  if (*</BLOCKQUOTE>* iswm %temp) {
    ; sockclose dnar | echo -s spell socket closed by script
    echo -s Suggestions for %origword
    echo -s %string
    unset %words %string %origword
  }
  if (%words) {
    if (%temp) %string = %string $remove(%temp,<br>)
  }
  if (*suggestions* iswm %temp) %words = 1
}
alias wiki {
  var %f = http://en.wikipedia.org/wiki/ $+ $1
  _browser %f
}
menu menubar {
  -
  Wiki...: wikiq
  Spell...: spellq
  Buffer
  .Wiki $left($cb(1),25) : wiki $left($cb(1),25)
  .Spell $left($cb(1),25) : spell $left($cb(1),25)
  -
  DLL
  .Load DLL: _loadll
  .unLoad DLL: unloadll
  .isLoaded: _e  $dll(meshview.dll,isloaded,1)
  .Verify DLL Exports: verify
}
alias Verify {
  var %vf = $scriptdir $+ Borland_impdef.exe
  if ($file(%vf).size == 73728) { 
    if ($?!="I have verified Borland's dll export reader  to be 73728 bytes, Continue? Results in 5 secs.") verifydll %vf
  }
}
alias verifydll {
  var %vt = $scriptdir $+ verify.txt
  var %vd = $mircdir $+ mircdll.def
  ; can only read dll from mircdir- being working dir of dos and def reader
  var %s = $1 mircdll mircdll
  run -n command.com /c %s > %vt
  .timer.display 1 5 displayresults %vd
}
alias displayresults {
  if ($1) var %vd = $1
  else var %vd = $mircdir $+ mircdll.def
  var %l = $lines(%vd), %i = 0, %s = 0, %tot = 0, %t = 0
  var %str = none
  :loop
  inc %i
  if ($version < 5.61) %s = $read -l %i %vd
  else %s = $read(%vd,n,%i)
  if ((%s) && (@ isin %s)) { %str = $remove(%str,none) | %str = %str $gettok(%s,1,32) | inc %tot }
  if (%i <= %l) goto loop
  echo -s Exports in mircdll :
  if (%str) echo -s %str %tot
  var %myslf = $script
  var %n = $numtok(%str,32), %j = 0, %tok
  %tot = 0
  %l = $lines(%myslf)
  echo -s Examining my logic in file %myslf
  :loop2 | inc %j | %tot = 0
  %tok = $gettok(%str,%j,32)
  %i = 0
  :loop3
  inc %i
  %s = $read -nl %i %myslf
  if ((%tok) && (%tok isin %s)) { inc %tot |  inc %t }
  if (%i <= %l) goto loop3
  if (%tot) echo -s %tok found 3 %tot time(s)
  if (%j <= %n) goto loop2
  if (%t = 0) echo -s Exports not used in this script
  .remove %vd
}
alias edprint {
  ; send file to printer, open printer dialog - we could also design it to print from buf
  var %f 
  if ($1) %f = $1-
  if ($exists(%f)) {
    %f = $replace(%f,\,/)
    echo -s $dll(meshview.dll, printerd, %f)
    ; echo -s $dll(meshview.dll, wparms,0) returns mwnd & awnd (mirc$active)
    ; also by name - //e $window(%br.wn).hwnd
    ; dll meshview.dll printerd %f
  }
  else echo -s File not found
}
alias edprintf {
  ; $sfile(dir,title,oktext)
  edprint $$sfile($mircdir,Select File, Print File)
}
alias off_on_*:load: {
  if ($scriptdir != $mircdir) {
    var %f = $mircdir $+ meshview.dll
    var %f2 = $scriptdir $+ meshview.dll
    if ($exists(%f2)) {
      if ($exists(%f)) {
        if ($file(%f).mtime != $file(%f2).mtime) {
          .rename %f $mircdir $+ mircdll.old
        }
      }
      if (!$exists(%f)) copy %f2 %f
    }
  }
}
alias stick {
  return $dll(meshview.dll,stick,1)
}
alias calib {
  ;  dll meshview.dll sendtest //echo -s hello
  dll meshview.dll calibrate
}
alias notes {
  range = 0 to 65535 x y z
  $stick returns <x> <y> <z> <buttons>
  1 = trigger
  2 = thumb
  4 = thumb1
  8 = thumb2
  3 7 11 15 = pov hat
  ~15
  3-|-11
  ~7
}
; ************
alias lunarzodiac {
  ; jan 14 1970 12:00:00 pisces 15aries
  ; jan 1 1986 23:58:58 = leo. wiki = ldiv(27.32166155,12)
  ; 9.5 - 11
  var %z = $julian(%br.time) - 9.5
  %z = $ldiv(%z, 2.2768051291666)
  %z = $int(%z) % 12
  %z = $zodc(%z) Moon in $zodiacsign(%z)
  if ($isid) return %z
  _e  %z
}
alias zodiacsign {
  if ($1 == 0) return Pisces - 11,12 WaterSign
  if ($1 == 1) return Aries - 8,4 FireSign
  if ($1 == 2) return Taurus - 9,3 EarthSign
  if ($1 == 3) return Gemini - 15,1 AirSign
  if ($1 == 4) return Cancer - 11,12 WaterSign
  if ($1 == 5) return Leo - 8,4 FireSign
  if ($1 == 6) return Virgo - 9,3 EarthSign
  if ($1 == 7) return Libra - 15,1 AirSign
  if ($1 == 8) return Scorpio - 11,12 WaterSign
  if ($1 == 9) return Sagittarius - 8,4 FireSign
  if ($1 == 10) return Capricorn - 9,3 EarthSign
  if ($1 == 11) return Aquarius - 15,1 AirSign
  if ($1 == 12) return Pisces - 11,12 WaterSign
  _e  zodiacsign error $1
  return 0
}
alias zodc {
  var %z = $1
  if (%z == 9) %z = 14
  if (%z == 11) %z = 13
  if (%z == 0) %z = 12
  %z =  $+ %z
  return %z
}
alias function-quad-curve {
  ; Fx: X + (Y*R/B) = R
  ; r=xwidthradius b=yheightofarc and r==b for circle
}
alias quadx {
  ; (wrad,hrad,yinput)
  ; (r,b,y)
  return $sqrt($calc(($1 ^ 2) - (($3 * $1 / $2) ^ 2)))
  ; x = sqrt(r - (y*r/b))
}
alias quady {
  ; (wrad,hrad,xinput)
  ; (r,b,x)
  var %d = $sqrt($calc($1 * $1 - $3 * $3))
  %d = $calc(%d * ($2 / $1))
  return %d
  return $calc($sqrt($calc(($1 ^ 2) - ($3 ^ 2))) * ($2 / $1))
  ; y = sqrt(r - x) * (b/r)
}
alias dw2deg {
  ; (dist,width)
  var %side = $vlen2($1,$ldiv($2, 2))
  return $rad2deg($sss-cos(%side,$2,%side))
}
alias dw2arcmin {
  ; (dist,width)
  var %side = $vlen2($1,$ldiv($2, 2))
  return $rad2arcmin($sss-cos(%side,$2,%side))
}
alias darcmin2w {
  ; (dist,arcmin)
  return $lmult($asa-sin(%PI.5,$1,$arcmin2rad($ldiv($2,2))),2)
}
alias width-arcmin2dist {
  ; (width,arcmin)(base,arcmin)
  var %a = $lsub(%PI.5,$arcmin2rad($ldiv($2,2)))
  return $&
    $lmult($ldiv($ldiv($1,2),$lsin($arcmin2rad($ldiv($2,2)))),$lsin(%a))
  ; var %hypot = $aas-sin($arcmin2rad($ldiv($2,2),%PI.5,$ldiv($1,2))
  return $asa-sin(%PI.5,$ldiv($1,2),%a)
}
alias base-arcmin2ht {
  ; (base,arcmin)
  var %a = $lsub(%PI.5,$arcmin2rad($ldiv($2,2)))
  return $aas-sin($arcmin2rad($ldiv($2,2)),%a,$ldiv($1,2))
  ; use AAS but get 3rd angle first
  ; var %hypot = $aas-sin($arcmin2rad($ldiv($2,2),%PI.5,$ldiv($1,2))
  ; return $asa-sin(%PI.5,$ldiv($1,2),%a)
  return $&
    $lmult($ldiv($ldiv($1,2),$lsin($arcmin2rad($ldiv($2,2)))),$lsin(%a))
}
alias _xor {
  ; "binary" $xor(2,3) returns true if both are true except: a==b returns 0
  ; $_xor does not, "either true or false", not both
  if (($1) && ($2)) return 0
  if (($1) || ($2)) return 1
  ; unknown
  return 0
}
alias _xor_ {
  ; if both false were needed
  if ((!$1) && (!$2)) return -1
  if (($1) && ($2)) return 0
  if (($1) || ($2)) return 1
}
alias excluded_middle {
  (x) means "for all" or "for every", thus an example of the expression would look like this:
  * (For all Q): (P ? ~P)
  * (For all instances of "pig" seen and unseen): ("Pig does fly" or "Pig does not fly" but not both simultaneously)
  What Aristotle and Russell believed is characteristic of traditional logic,
  but this view implicitly depends on a particular notion of truth in which 
  every statement is either true or false. Logic that contradicts this idea include:
  Ternary logic, False, Unknown, True.
  Fuzzy logic, True, False, or somewhere in between.
  And intuitionist logic,   in which the notion of truth is dispensed with entirely, and provability considered in its place.

}
alias _rgb {
  if ($numtok($1,44) == 3) tokenize 44 $1
  else if ($numtok($1,32) == 3) tokenize 32 $1
  if ($0 == 3) return $calc($1 + $2 * 256 + $3 * 65536)
  var %r = $calc($1 % 256), %g, %b = $int($calc($1 / 65536))
  %g = $calc((($1 % 65536) - %r) / 256)
  if ($prop == 44) {
    %r = %r $+ , $+ %g $+ , $+ %b
    return %r
  }
  return %r %g %b
}
alias multm3 {
  ; (a,b)3x3
  var %a = $1, %b = $2, %j, %c
  var %i = -1
  while (%i < 2) {
    inc %i
    %j = -1
    while (%j < 2) {
      inc %j
      %c = %c $calc($gettok(%a,$calc(%i * 3 + 1),32) * $gettok(%b,$calc(1 + %j),32) + $gettok(%a,$calc(%i * 3 + 2),32) $&
        * $gettok(%b,$calc(4 + %j),32) + $gettok(%a,$calc(%i * 3 + 3),32) * $gettok(%b,$calc(7 + %j),32))
    }
  }
  return $normalize($gettok(%c,1-3,32)) $normalize($gettok(%c,4-6,32)) $normalize($gettok(%c,7-9,32))
}
alias tetrahedron_volume {
  ; (4 pnts)
  return $calc($abs($dotprod($subv($4,$1),$cross($subv($4,$2), $subv($4,$3)))) / 6)
}
alias pyramid_volume {
  ; (5 pnts 3D) 1st 4 in perimeter order
  return $calc($tetrahedron_volume($1,$2,$3,$5) + $tetrahedron_volume($1,$3,$4,$5))
  ; //e $tetrahedron_volume(383 156 0, 645 254 0, 465 289 0,400 200 200) = 893666.666667
  ; //e $pyramid_volume(276 308 0, 383 123 0, 666 324 0, 276 308 0, 400 300 200) = 2462066.666667
}
alias notes_ {
  if (0) {
    The gods =:
    fire, sun warmth salamander
    water, electrochemical and all that is fluid undine emotion
    earth, life gravity gnome
    air, light sylph
  }
  ; now you might think the strong and weak forces belong to fire and air, you'd be half right
  ; fire = strong/weak forces
  ; air = weak/strong forces
  ; if a tree falls and no one can hear it, does it make a sound? No it does NOT.
  ; reality is not reality until observed

}
alias ascii {
  var %i = 33
  while (%i < 220) {
    inc %i
    e $chr(%i) < %i
  }
}
