; //e $focal_len(-4,4,1.5,0.2)
; concave
; //e $focal_len(4,-4,1.5,1.6)
; convex

alias focal_len {
  ; (r1,r2,ior,lensthickness
  var %ior = $3, %d = $4
  %d = $calc((%ior - 1) * (((1 / $1) - (1 / $2)) +        (((%ior - 1) * %d) / (%ior * $1 * $2))      )))
  ; Thin lens equation
  ; %d = $calc((%ior - 1) * ((1 / $1) - (1 / $2)))
  return $calc(1 / %d)
  return %d
}
; The signs of the lens' radii of curvature indicate whether the corresponding surfaces are convex or concave. The sign convention used to represent this varies, but in this article if R1 is positive the first surface is convex, and if R1 is negative the surface is concave. The signs are reversed for the back surface of the lens: if R2 is positive the surface is concave, and if R2 is negative the surface is convex. If either radius is infinite, the corresponding surface is flat.
alias svgsearch {
  if (!%svg.dir) %svg.dir = $mircdir
  var %q = $$sfile($+(%svg.dir,*.svg),Import SVG,Import)
  if ($exists(%q)) {
    %svg.dir = $nofile(%q)
    if ($1) _fRead_svg_spline_split %q
    else _fRead_svg_spline_ %q
  }
}
alias bezsearch {
  if (!%svg.dir) %svg.dir = $mircdir
  dialog -ma beziersearch beziersearch
}
on *:dialog:beziersearch:sclick:113: _file_search
on *:dialog:beziersearch:sclick:114: _get_dir
on *:dialog:beziersearch:sclick:115: run wordpad $did(beziersearch,4).seltext
on *:dialog:beziersearch:dclick:4: _read_lathe_bez_spline_ $did(beziersearch,4).seltext
alias _file_search {
  %svg.dir = $did(beziersearch,3)
  var %i = 0, %n = $numtok($did(beziersearch,2),44), %dir
  did -r beziersearch 4
  while (%i < %n) {
    inc %i
    %dir = $gettok($did(beziersearch,2),%i,44)
    %dir = $findfile($did(beziersearch,3),%dir,0,0, string_search $1)
    ; $did(beziersearch,1)
    ; $did(beziersearch,2)
    ;   e $did(beziersearch,3)
  }
}
alias _get_dir {
  var %q = $lower($sdir(%svg.dir,Select Folder))
  if (%q) did -o beziersearch 3 1 %q
}
alias string_search {
  var %w = $+(*,$did(beziersearch,1),*)
  var %r = $read($1,nw,%w)
  ; e %r <
  if (%r) {
    if ($exists($1)) did -a beziersearch 4 $1
  }
}
alias schwinpos {
  var %x = $window(@bezier).x - 445
  if (%x < 0) %x = 0
  return %x $window(@bezier).y 440 480
}
dialog beziersearch {
  option pixels
  title "File Search"
  size $schwinpos
  icon eye.ico,-1
  tab "Search", 101, 0 0 440 480
  tab "Something else", 102


  edit "bezier_spline",1,12 35 160 24, tab 101
  edit "*.pov,*.inc",2,180 35 160 24, tab 101
  edit [ $lower(%svg.dir) ] ,3,180 65 250 24, tab 101
  combo 4, 12 95 418 373, size, tab 101
  button "Search",113,12 65 80 24, tab 101
  button "View File",115,92 65 80 24, tab 101
  button "New Path",114,348 35 80 24, tab 101

  ;  icon 1,185 35 240 240, c.png, -2, tab 101

  ; text "File Iteration",403,185 300 80 20, left, tab 101
  ; edit "1",404,250 294 30 20,right, tab 101

  ; text "X Offset",405,185 325 80 20, left, tab 101
  ; edit "0",406,230 319 50 20,right, tab 101

  ; text "Y Offset",410,185 350 80 20, left, tab 101
  ; edit "0",407,230 344 50 20,right, tab 101

  ; text "W Scale",411,185 375 80 20, left, tab 101
  ; edit "0",408,230 369 50 20,right, tab 101
  ; text "H Scale",412,185 400 80 20, left, tab 101
  ; edit "0",409,230 394 50 20,right, tab 101

  ; check "Auto Size",413,290 325 80 16, left, tab 101
  ; check "Drag Img",414,290 350 80 16, left, tab 101
  ; check "Use Scale",416,290 375 80 16, left, tab 101
  ; check "Aspect Ratio",415,290 400 80 16, left, tab 101

  box "Pov Mesh",701,10 26 419 64, tab 102
  ; text "WildCard",711,78 45 45 20, left, tab 102
  edit "*.inc",712,20 40 50 20, right, tab 102
  button "View",713, 195 40 54 18, tab 102
  combo 714,20 63 170 200, drop, tab 102
  button "Find",715, 135 40 54 18, tab 102
  button "Import",716, 195 63 54 20, tab 102


}
alias bz.toolbar {
  %bz.nbuttons = 8
  var %wh 60 45, %pos = 1 1, %v, %i = 0
  if (%bz.tb.top) %v = $calc($gettok(%wh,1,32) + 1) 0
  else %v = 0 $calc($gettok(%wh,2,32) + 1)
  while (%i < %bz.nbuttons) {
    toolbar_button %i $addv2(%pos,$multv2(%v,%i)) %wh 2
    inc %i
  }
  var %w = $gettok(%wh,1,32), %h = $gettok(%wh,2,32)
  if (%bz.tb.top) %w = $gettok(%wh,1,32) * %bz.nbuttons
  else %h = $gettok(%wh,2,32) * %bz.nbuttons
  %bz.tb.xywh = %pos %w %h
  %bz.button.wh = %wh
  button_down %editnode
  drawdot @bezier
}

alias toolbar_button {

  3drect -nr @bezier $rgb(216,213,236) $rgb(90,78,177) $2-
  drawrect -fr @bezier $rgb(174,168,217) 1 $addv2($gettok($2-,1-2,32),1 1) $subv2($gettok($2-,3-4,32),3 3)

  $+(buttgraph,$1) $2-
}
alias buttgraph0 {
  drawrect -fr @bezier $rgb(174,168,217) 1 $addv2($gettok($1-,1-2,32),1 1) $subv2($gettok($1-,3-4,32),3 3)
  drawtext -rob @bezier 0 $rgb(174,168,217) Arial 10 $addv2($1 $2,16 4) Mode
  drawtext -rob @bezier 0 $rgb(174,168,217) Arial 10 $addv2($1 $2,4 20) %bz.mode
}
alias buttgraph1 {
  drawtext -ro @bezier $coloractive Arial 10 $addv2($1 $2,6 4) Move
  drawtext -ro @bezier $coloractive Arial 10 $addv2($1 $2,6 16) Node
}
alias buttgraph2 {
  drawtext -ro @bezier $coloractive Arial 10 $addv2($1 $2,6 4) Move
  drawtext -ro @bezier $coloractive Arial 10 $addv2($1 $2,6 16) Handle
}
alias buttgraph3 {
  drawtext -ro @bezier $coloractive Arial 10 $addv2($1 $2,6 4) Insert
  drawtext -ro @bezier $coloractive Arial 10 $addv2($1 $2,6 16) Node
}
alias buttgraph4 {
  drawtext -ro @bezier $coloractive Arial 10 $addv2($1 $2,6 4) Delete
  drawtext -ro @bezier $coloractive Arial 10 $addv2($1 $2,6 16) Node
}
alias buttgraph5 {
  drawtext -ro @bezier $coloractive Arial 10 $addv2($1 $2,6 4) Align
  drawtext -ro @bezier $coloractive Arial 10 $addv2($1 $2,6 16) Handle
}
alias buttgraph6 {
  drawtext -ro @bezier $coloractive Arial 10 $addv2($1 $2,6 4) New
  drawtext -ro @bezier $coloractive Arial 10 $addv2($1 $2,6 16) Spline
}
alias buttgraph7 {
  drawtext -ro @bezier $coloractive Arial 10 $addv2($1 $2,6 4) Add
  drawtext -ro @bezier $coloractive Arial 10 $addv2($1 $2,6 16) Node
}
alias coloractive {
  if (%bz.mode == scaleview) return $rgb(140,140,140)
  return 0
}
alias 3drect {
  ;                                                                 $1             $2              $3                      $4                5 6 7 8     $9
  if ($9 == $null) { echo -a /3drect <switch><window><color-top><color-bottom><x y w h><size> }
  else {
    var %w = $calc($7 - 1), %h = $calc($8 - 1)
    drawline $1 $2 $3 $9 $5 $calc($6 + %h) $5 $6 $calc($5 + $7) $6
    drawline $1 $2 $4 $9 $5 $calc($6 + %h) $calc($5 + %w) $calc($6 + %h) $calc($5 + %w) $6
  }
}
alias toolbar_func_down {
  button_down
  if ((%bz.button.id > 0) && (%bz.mode == EditSpline)) {
    var %i = 1
    while (%i < %bz.nbuttons) {
      if (%i != %bz.button.id) button_up %i
      inc %i
    }

    if (%bz.button.id == 6) {
      var %q = $$?!=" Delete Current Spline?"
      if (!%q) halt
      %bz.nsegs = 0
      unset %bz.firstpoint
      %editnode = 6
      bezier_graph
      if (%bz.toolbar) bz.toolbar
    }
  }
}
alias toolbar_func_up {
  %editnode = %bz.button.id

}
alias button_down {
  var %id = $1, %bpos, 
  tokenize 32 %bz.tb.xywh %bz.button.wh
  if (%id == $null)  {
    if (%bz.tb.top) %id = $int($calc($mouse.x / $5))
    else %id = $int($calc($mouse.y / $6))
    %bz.button.id = %id
  }
  if (%bz.tb.top) %bpos = $calc(%id * $5 + $1 + %id * 1) $2
  else %bpos = $1 $calc(%id * $6 + $2 + %id * 1)
  3drect -r @bezier $rgb(90,78,177) $rgb(216,213,236) %bpos %bz.button.wh 2

}
alias button_up {
  var %id = $1, %bpos
  tokenize 32 %bz.tb.xywh %bz.button.wh

  if (%bz.tb.top) %bpos = $calc(%id * $5 + $1 + %id * 1) $2
  else %bpos = $1 $calc(%id * $6 + $2 + %id * 1)

  3drect -r @bezier $rgb(216,213,236) $rgb(90,78,177) %bpos %bz.button.wh 2
  if (!%id) {

    if (%bz.mode == EditSpline) %bz.mode = ScaleView
    else %bz.mode = EditSpline
    ; buttgraph0 %bpos %bz.button.wh
    bz.toolbar %bz.tb.top
  }
}
alias new_spline_down {
  ; see toolbar_func_down
}
alias new_spline_up {
  var %hlen = 1
  var %thispnt = $divv2($subv2($mouse.x $mouse.y,%bz.cen),%bz.scale)
  var %cs1, %cs2, %seg
  drawrect @bezier 14 1 $subv2($mouse.x $mouse.y, 3 3) 6 6
  if (%bz.firstpoint) {
    inc %bz.nsegs
    %cs1 = $subv2(%bz.firstpoint,%thispnt) 0
    %cs2 = $subv2(%thispnt,%bz.firstpoint) 0
    if (%bz.perphandles) {
      ; handles perp
      %seg = %bz.firstpoint $&
        $addv2(%bz.firstpoint,$gettok($multv($normalize($cross(%cs1,0 0 1)),%hlen),1-2,32)) $&
        $addv2(%thispnt,$gettok($multv($normalize($cross(%cs2,0 0 1)),%hlen),1-2,32)) $&
        %thispnt
    }
    else {
      if (%bz.verthandles) {
        ; %bz.verthandles
        ; handles inline
        %seg = %bz.firstpoint $&
          $addv2(%bz.firstpoint,$gettok($multv(0 1,%hlen),1-2,32)) $&
          $addv2(%thispnt,$gettok($multv(0 -1),%hlen),1-2,32)) $&
          %thispnt
      }
      else {
        ; handles inline
        %seg = %bz.firstpoint $&
          $addv2(%bz.firstpoint,$gettok($multv($normalize(%cs2),%hlen),1-2,32)) $&
          $addv2(%thispnt,$gettok($multv($normalize(%cs1),%hlen),1-2,32)) $&
          %thispnt
      }
    }
    %seg [ $+ [ %bz.nsegs ] ] = %seg
    draw_bezier_ $cen_scale(%seg) 1
  }
  %bz.firstpoint = %thispnt
}
alias close_spline {
  ; working on single splines only
  var %hlen = 1
  if (%bz.mode != EditSpline) { _e You should Set Mode to EditSpline before editing. My programming will allow me to do it for you... | %bz.mode = EditSpline }
  if ($is_closed_spline) { _e Spline is Closed | halt }
  var %thispnt = $gettok(%seg1,1-2,32)
  var %cs1, %cs2, %seg = %seg [ $+ [ %bz.nsegs ] ]
  %bz.firstpoint = $gettok(%seg,7-8,32)
  if (%bz.firstpoint) {
    inc %bz.nsegs
    %cs1 = $subv2(%bz.firstpoint,%thispnt) 0
    %cs2 = $subv2(%thispnt,%bz.firstpoint) 0
    if (%bz.perphandles) {
      ; handles perp
      %seg = %bz.firstpoint $&
        $addv2(%bz.firstpoint,$gettok($multv($normalize($cross(%cs1,0 0 1)),%hlen),1-2,32)) $&
        $addv2(%thispnt,$gettok($multv($normalize($cross(%cs2,0 0 1)),%hlen),1-2,32)) $&
        %thispnt
    }
    else {
      ; handles inline
      %seg = %bz.firstpoint $&
        $addv2(%bz.firstpoint,$gettok($multv($normalize(%cs2),%hlen),1-2,32)) $&
        $addv2(%thispnt,$gettok($multv($normalize(%cs1),%hlen),1-2,32)) $&
        %thispnt
    }
    %seg [ $+ [ %bz.nsegs ] ] = %seg
    draw_bezier_ $cen_scale(%seg) 1
    if (%bz.toolbar) bz.toolbar
  }
  unset %bz.firstpoint
}

alias is_open_spline {
  var %p = %seg [ $+ [ %bz.nsegs ] ]
  %p = $replace($gettok(%p,7-8,32),$chr(32),_)
  if (%p == $replace($gettok(%seg1,1-2,32),$chr(32),_)) return 0
  return 1
}
alias is_closed_spline {
  var %p = %seg [ $+ [ %bz.nsegs ] ]
  %p = $replace($gettok(%p,7-8,32),$chr(32),_)
  if (%p == $replace($gettok(%seg1,1-2,32),$chr(32),_)) return 1
  return 0
}
alias open_spline {
  if (%bz.mode != EditSpline) { _e You should Set Mode to EditSpline before editing. My programming will allow me to do it for you... | %bz.mode = EditSpline }
  if ($is_open_spline) { _e Spline is Open | halt }
  dec %bz.nsegs | draw_path
  var %p = %seg [ $+ [ %bz.nsegs ] ]
  %p = $gettok(%p,7-8,32)
  %bz.firstpoint = %p
}
alias next_feature_down {
}
alias next_feature_up {
}

alias add_node_down {
  var %seg = %seg [ $+ [ %bz.nsegs ] ]
  %bz.firstpoint = $gettok(%seg,7-8,32)
}
alias add_node_up {
  if ($is_open_spline) {
    new_spline_up
  }
  else _e You might want to open spline first
}
alias mirror_ {

  var %i = 0, %n = %bz.nsegs, %seg, %p, %v = -1 1, %vlen = $calc(306 * 2) 0
  var %j = 0
  while (%i < %n) {
    inc %i
    %seg = %seg [ $+ [ %i ] ]
    %seg = $_addv2multi(%seg,%v,%vlen)
    %seg [ $+ [ %i ] ] = %seg
  }
}
alias _addv2multi {
  var %v = $2
  var %i = 0, %n = $numtok($1,32), %s
  while (%i < %n) {
    inc %i
    if (%s) %s = $+(%s,$chr(32),$addv2($multvv2($gettok($1,%i,32) $gettok($1,$calc(%i + 1),32),%v),$3))
    else %s = $addv2($multvv2($gettok($1,%i,32) $gettok($1,$calc(%i + 1),32),%v),$3)
    inc %i
  }
  return %s
}












%%%%%%%%%%%%%% NEW Binary Reader - pov bezier_spline %%%%%%%%%%%%%
alias _read_lathe_bez_spline_1 {

  unset %seg*
  var %f = glasses13rad.pov, %bz = 0, %np = 0, %asc, %r

  if ($1) %f = $1
  if (!$exists(%f)) { _e File not found | halt }
  var %n = $lines(%f), %i = 0, %seg

  if ($fopen(povfile)) fclose povfile
  .fopen povfile %f

  fseek -w povfile *bezier_spline*
  %r = $fread(povfile)
  if ($chr(44) isin %r) e $gettok(%r,1,44)
  else {
    %r = $fread(povfile)
    if ($chr(44) isin %r) e $gettok(%r,1,44)
  }
  %r = $gettok(%r,1,44)
  if ($gettok(%r,2,32)) %r = $ifmatch
  %r = $remove(%r,$chr(32))
  %r = $calc(%r * 1)
  if ((%r isnum) && ($calc(%r % 4) == 0)) %np = %r / 4
  if (%np) { %bz = 1 | bezier_graph }
  else { e %np num segs - not continuing | halt }
  %bz.nsegs = %np

  var %j = 0
  while (%j < %np) {
    inc %j
    %seg = $null
    %i = 0
    while (%i < 4) {
      inc %i
      .fseek -w povfile *<*
      ; e $chr($fgetc(povfile)) <<<<<<<<<<<<<<<<<< next char == NULL ?!?
      ; fseek seems to set 2 chars previous but getting more if w on next line ?!?
      %r = $null
      while ($fgetc(povfile) != 62) {
        %asc = $ifmatch
        ; patch this
        if (%asc == $asc(/)) %r = $null
        if ((%asc isnum 48-57) || (%asc == 46) || (%asc == 44) || ($chr(%asc) == E) || ($chr(%asc) == -)) {

          %r = %r $+ $chr(%asc)
        }
      }
      %seg = $+(%seg,%r,$chr(44))

    }
    %r = $remove(%seg,<,>)
    ; gettin double commas with previous code
    %r = $replace(%r,$+($chr(44),$chr(44)),$chr(44))
    ; e %seg
    tokenize 44 %r
    if ($0 == 8) {
      %r = $fixint2($1-)
      %seg [ $+ [ %j ] ] = %r
      draw_bezier_ $cen_scale(%r) %bezier.dl
    }
  }
  .fclose povfile
  %bz.filename = $upper($nopath($left(%f,-4)))
  titlebar @bezier - %bz.filename %bz.nsegs  Segments
  if (%bz.toolbar) bz.toolbar
}
alias _? {
  if ($1) %exec = $1
  else { echo -s invalid paramter | halt }
  if ($2) %text = $2
  else %text = Enter Reply:
  if ($3) %fillp = $3
  else %fillp = 0
  .dialog -ma replyrequest replyrequest
  did -o replyrequest 2 1 %fillp
  did -c replyrequest 2 1
  return 0
}
dialog replyrequest {
  option pixels
  title "Input Request"
  size -1 -1 300 150
  icon eye.ico,-1
  text %text, 1, 12 15 276 20, center
  combo 2, 12 50 276 46, size
  ; edit %fillp, 2, 12 50 276 20
  ; (right, center, multi, pass, read, return, hsbar, vsbar, autohs, autovs, limit N)
  button "OK", 13, 80 110 62 26, ok
  button "Cancel", 14, 150 110 62 26
}
on *:dialog:replyrequest:sclick:14: {
  dialog -x replyrequest replyrequest
  unset %exec %text %fillp
}
on *:dialog:replyrequest:sclick:13: {
  var %r = $did(replyrequest,2)
  if (%r) .timer.exe -m 1 5 %exec %r
  unset %exec %text %fillp
}