
on *:load: {
  .load -rs $scriptdir $+ meshdll.mrc
  .load -rs $scriptdir $+ beziersearch.mrc
  .load -rs $scriptdir $+ svgreader.mrc
}
menu menubar {
  -
  Be&zier: bezier
}
alias bezier {
  ; _loadll
  %bz.grid = 1
  ; for faster math funcs if called ?
  %bz.w = 500 | %bz.h = 600
  %bz.cen = $calc(%bz.w / 2 - 100) $calc(%bz.h / 2 + 200)
  %bz.mode = scaleview
  %bz.scale = .1
  window -fpekd @Bezier 650 300 %bz.w %bz.h
  set %bezier.detail .085 
  titlebar @Bezier - Right click to find bezier_spline
  bezier_graph
  if (%bz.toolbar) bz.toolbar %bz.tb.top
}
alias bezupclk {
  tokenize 32 %bz.tb.xywh
  if ((%bz.toolbar) && ($inrect($mouse.x,$mouse.y,$1,$2,$3,$4))) {
    if (!%bz.button.id) button_up 0
    else toolbar_func_up
  }
  else %bz.mode
}
; e $mouse.x $mouse.y }

menu @Bezier {
  uclick: bezupclk
  sclick: bezclk
  mouse: { mouseroll }
  Mode. %bz.mode 
  .Edit Spline: %bz.mode = EditSpline
  .Scale View: %bz.mode = ScaleView
  Edit $editmode : modeswitch
  Handle Lock %bz.handlelock : { if (%bz.handlelock) %bz.handlelock = 0 | else %bz.handlelock = 1 }
  Zoom Out: zoomout
  -
  Draw Spline: draw_path
  -
  Find Spline...: bezsearch
  Import SVG...: svgsearch
  Import SVG z...: svgsearch 1
  Save POV Lathe...: Save_POV_Spline
  Save POV Prism...: Save_POV_Spline 1
  -
  Close Spline: close_spline
  Open Spline: open_spline
  Create Perp handles %bz.perphandles : { if (%bz.perphandles) %bz.perphandles = 0 | else %bz.perphandles = 1 }
  Create Vert handles %bz.verthandles : { if (%bz.verthandles) %bz.verthandles = 0 | else %bz.verthandles = 1 }
  -
  Scale %bz.scale
  .55%: %bz.scale = .55
  .100%: %bz.scale = 1
  .140%: %bz.scale = 1.4
  .180%: %bz.scale = 1.8
  Grid Size %bz.grid
  .1: bzgrid 1
  .2: bzgrid 2
  .5: bzgrid 5
  .10: bzgrid 10
  .15: bzgrid 15
  .20: bzgrid 20
  $iif(%bezier.dl, Turn Handles Off, Turn Handles On): { 
    if (%bezier.dl == $null) { 
      set %bezier.dl 1 
    }
    else unset %bezier.dl
    draw_path
  }
  Detail Level [ %bezier.detail ]
  .0.01 Maximum: set %bezier.detail .01
  .$chr(46): set %bezier.detail .025
  .$chr(46): set %bezier.detail .045
  .$chr(46): set %bezier.detail .065
  .0.085 Fair: set %bezier.detail .085
  .$chr(46): set %bezier.detail .1
  .$chr(46): set %bezier.detail .115
  .$chr(46): set %bezier.detail .135
  .0.15 Poor: set %bezier.detail .15
  -
  ToolBar %bz.toolbar : { if (%bz.toolbar) %bz.toolbar = 0 | else %bz.toolbar = 1  | draw_path }
  ToolBar on the $tooltop: { if (%bz.tb.top) %bz.tb.top = 0 | else %bz.tb.top = 1 | bz.toolbar %bz.tb.top }
  -
  Clear: { bezier_graph | if (%bz.toolbar) bz.toolbar %bz.tb.top }
  Exit: { window -c @Bezier | unset %bezier* %bz.* }
}
alias tooltop {
  if (%bz.tb.top) return Side
  return Top
}
alias bzgrid  {
  %bz.grid  = $1
  draw_path
}
alias bezclk  {
  %bz.copy.w =  0
  %bz.copy.h = 0
  %bz.mclk = $mouse.x $mouse.y
  if ($window(@bezbuff)) {
    if ((!$window(@bezbuff).h != $window(@bezier).h) || (!$window(@bezbuff).w != $window(@bezier).w)) $&
      close -@ @bezbuff
  }
  chk_window_size
  if (!$window(@bezbuff)) window -fpehknd @bezbuff 650 300 $window(@bezier).w $window(@bezier).h
  chk_window_size
  drawcopy @bezier 0 0 %bz.w %bz.h @bezbuff 0 0 %bz.w %bz.hv

  tokenize 32 %bz.tb.xywh
  if ((%bz.toolbar) && ($inrect($mouse.x,$mouse.y,$1,$2,$3,$4))) {
    toolbar_func_down
  }
  else if (%bz.mode == EditSpline) {
    if (%editnode == 1) click_find_node
    else if (%editnode == 2) click_find_handle
    else if (%editnode == 3) insert_node
    else if (%editnode == 4) delete_node
    else if (%editnode == 5) align_other_handle
    else if (%editnode == 6) new_spline_down
    else if (%editnode == 7) add_node_down
    else if (%editnode == 8) next_feature_down
  }
  else if (%bz.mode == ScaleView) {

  }
  else {
    %bezier = %bezier $mouse.x $mouse.y
    drawdot -r @Bezier $rgb(0,100,0) 2 $mouse.x $mouse.y
    if ($gettok(%bezier,0,32) == 2) { titlebar @Bezier - Select ending point }
    else if ($gettok(%bezier,0,32) == 4) { titlebar @Bezier - Select start of bend line }
    else if ($gettok(%bezier,0,32) == 6) { titlebar @Bezier - Select end of bend line }
    else if ($gettok(%bezier, 0, 32) == 8) { draw.bezier %bezier %bezier.dl }
    else if ($gettok(%bezier,0,32) > 8) { unset %bezier | titlebar @Bezier - Select start point }
  }
}
alias editmode {
  if (%bz.mode == EditSpline) {
    if (%editnode == 1) return Move :Node:
    if (%editnode == 2) return Move >Handle<
    if (%editnode == 3) return Insert Node
    if (%editnode == 4) return Delete Node
    if (%editnode == 5) return Align Handles
  }
  return Zoom Scale
}
alias modeswitch {
  if (%editnode == 5) %editnode = 1
  else inc %editnode
}
alias draw.bezier {
  ; (old routine)
  chk_window_size 
  unset %bezier
  set %bz.x0 $1 | set %bz.x1 $5 | set %bz.x2 $7 | set %bz.x3 $3
  set %bz.y0 $2 | set %bz.y1 $6 | set %bz.y2 $8 | set %bz.y3 $4
  set %bz.cx $calc(3 * (%bz.x1 - %bz.x0))
  set %bz.bx $calc(3 * (%bz.x2 - %bz.x1) - %bz.cx)
  set %bz.ax $calc(%bz.x3 - %bz.x0 - %bz.cx - %bz.bx)
  set %bz.cy $calc(3 * (%bz.y1 - %bz.y0))
  set %bz.by $calc(3 * (%bz.y2 - %bz.y1) - %bz.cy)
  set %bz.ay $calc(%bz.y3 - %bz.y0 - %bz.cy - %bz.by)
  if ($9 != $null) { 
    drawline -r @Bezier $rgb(255,0,0) 1 %bz.x1 %bz.y1 %bz.x2 %bz.y2 
    drawdot -r @Bezier $rgb(0,0,255) 2 %bz.x0 %bz.y0 %bz.x3 %bz.y3
  }
  unset %bz.old.xx %bz.old.yy
  set %bz.u $iif(%bezier.detail == $null, 0.15, %bezier.detail)
  %bz.u = %bz.u * -1
  while (%bz.u < 1) {
    inc %bz.u $iif(%bezier.detail == $null, .01, %bezier.detail)
    set %bz.xx $calc((%bz.ax * (%bz.u)^3) + (%bz.bx * (%bz.u)^2) + (%bz.cx * %bz.u) + %bz.x0)
    set %bz.yy $calc((%bz.ay * (%bz.u)^3) + (%bz.by * (%bz.u)^2) + (%bz.cy * %bz.u) + %bz.y0)
    if (%bz.old.xx == $null) { set %bz.old.xx %bz.xx | set %bz.old.yy %bz.yy }
    drawline -r @Bezier $rgb(0,0,0) 1 %bz.old.xx %bz.old.yy %bz.xx %bz.yy
    set %bz.old.xx %bz.xx
    set %bz.old.yy %bz.yy
  }  
  unset %bz.*
  %bz.w = 500 | %bz.h = 600
}


alias _fRead_svg_spline {
  var %f = cup2.svg, %np = 0
  ; %f = StargateGlyphs2.svg
  var %n = $lines(%f), %i = 0, %r, %j = 0, %M, %r2, %ln, %POS, %nbytes, %tok, %asc, %space = 0
  var %lastpnt, %v1, %v2, %v3
  if ($fopen(svgfile)) fclose svgfile
  .fopen svgfile %f
  var %r = $fread(svgfile)
  while (%i < %n) {
    inc %i
    %r = $read(%f,n,%i)
    %ln = $readn
    if (<path isin %r) {
      ; %%%%%%%%%%%% BINARY TOKENIZE LONG PATH %%%%%%%%%%%
      ; assuming path is 2 lines below "<path"
      .fseek -l svgfile $calc(%ln + 2)
      %POS = $fopen(1).pos
      ;  POS 
      .fseek -l svgfile $calc(%ln + 3)

      %nbytes = $calc($fopen(1).pos - %POS)
      ; bytes to READ Assuming inkscape will crap all pnts to one line ARGH!

      %j = 0
      fseek -l svgfile $calc(%ln + 2)
      e C TOKENS ::::::::
      %i = 0

      while (%j < %nbytes) {
        inc %j
        %asc = $fgetc(1)

        ; if a space, add a space;  see _read_lathe_bez_spline_ for better code
        if (%space) { %tok = $+(%tok,$chr(32),$chr(%asc)) | %space = 0 }
        else %tok = $+(%tok,$chr(%asc))
        if (%asc == 32) %space = 1

        if (%asc == $asc(C)) { inc %i | %tok [ $+ [ %i ] ] = $gettok(%tok,1,$asc(C)) | %tok = $null }
        else if (%j == %nbytes) { inc %i | %tok [ $+ [ %i ] ] = $gettok(%tok,1,$asc(C)) | %tok = $null }
        ;  e %tok |
      }
      ; tokens done
      %n = -1

      %r2 = %tok1
      %M = $gettok(%r2,2,$asc(M))
      %M = $replace(%M,$chr(44),$chr(32))

      %np = %i
      %j = 0
      while (%j < %np) {
        inc %j
        if (%j < %np) {
          %r2 = %tok [ $+ [ $calc(%j + 1) ] ]

          %v1 = $gettok(%r2,1,32)
          %v2 = $gettok(%r2,2,32)
          %v3 = $gettok(%r2,3,32)
          %v1 = $replace(%v1,$chr(44),$chr(32))
          %v2 = $replace(%v2,$chr(44),$chr(32))
          %v3 = $replace(%v3,$chr(44),$chr(32))
        }
        else {
          %r2 = %tok [ $+ [ %np ] ]
          %r2 = $gettok($gettok(%r2,2,$asc(L)),1,$asc(z))
          %v1 = $gettok(%r2,1,32)
          ; %v2 = $gettok(%r2,2,32)
          ; %v3 = $gettok(%r2,3,32)
          %v1 = $replace(%v1,$chr(44),$chr(32))
          ; %v2 = $replace(%v2,$chr(44),$chr(32))
          ; %v3 = $replace(%v3,$chr(44),$chr(32))
        }
        if (%j == 1) {
          %seg [ $+ [ %j ] ] = $subv2(%M,%M) $subv2(%v1,%M) $subv2(%v2,%M) $subv2(%v3,%M)
          %lastpnt = $subv2(%v3,%M)
        }
        else if (%j < %np) {
          %seg [ $+ [ %j ] ] = %lastpnt $subv2(%v1,%M) $subv2(%v2,%M) $subv2(%v3,%M)
          %lastpnt = $subv2(%v3,%M)
        }
        else {
          %seg [ $+ [ %j ] ] = %lastpnt %lastpnt $subv2(%v1,%M) $subv2(%v1,%M)
        }
      }
    }
  }
  %bz.nsegs = %np
  .fclose svgfile
  unset %tok*
}
alias bezier_graph {
  drawrect -f @bezier 15 1 0 0 %bz.w %bz.h
  var %sz = %bz.grid * $cen_scale(0).sc
  var %i = $calc($cen_scale(0).x % %sz)
  while (%i < %bz.w) {
    drawline -r @bezier $rgb(150,150,225) 1 %i 0 %i %bz.h
    inc %i %sz
  }
  %i = $calc($cen_scale(0).y % %sz)
  while (%i < %bz.h) {
    drawline -r @bezier $rgb(150,150,225) 1 0 %i %bz.w %i
    inc %i %sz
  }
  drawline @bezier 0 1 $cen_scale(0).x 0 $cen_scale(0).x %bz.h
  drawline @bezier 0 1 0 $cen_scale(0).y %bz.w $cen_scale(0).y
}

alias draw_path {
  chk_window_size
  bezier_graph
  ;  thepic
  var %i = 0, %n = %bz.nsegs, %seg, %p
  while (%i < %n) {
    inc %i
    %seg = %seg [ $+ [ %i ] ]
    tokenize 32 $cen_scale(%seg)
    draw_bezier_ $cen_scale(%seg) %bezier.dl
  }
  titlebar @bezier %bz.filename %n Segments
  if (%bz.toolbar) bz.toolbar
}
alias cen_scale {
  var %sc = %bz.scale
  if ($prop == sc) return %sc
  if ($prop == x) return $gettok(%bz.cen,1,32)
  if ($prop == y) return $gettok(%bz.cen,2,32)
  tokenize 32 $1

  return $addv2i(%bz.cen,$multv2($1 $2,%sc)) $addv2i(%bz.cen,$multv2($3 $4,%sc)) $&
    $addv2i(%bz.cen,$multv2($5 $6,%sc)) $addv2i(%bz.cen,$multv2($7 $8,%sc))
}

alias draw_bezier_ {
  ; (node, ctrlh, ctrlh, node)
  ; one segment
  var %x0 = $1, %x1 = $3 , %x2 = $5, %x3 = $7
  var %y0 = $2, %y1 = $4, %y2 = $6, %y3 = $8
  var %cx = $calc(3 * (%x1 - %x0))
  var %bx = $calc(3 * (%x2 - %x1) - %cx)
  var %ax = $calc(%x3 - %x0 - %cx - %bx)
  var %cy = $calc(3 * (%y1 - %y0))
  var %by = $calc(3 * (%y2 - %y1) - %cy)
  var %ay = $calc(%y3 - %y0 - %cy - %by)
  if ($9) { 
    ; draw nodes
    drawrect @bezier 14 1 $subv2($1 $2, 3 3) 6 6
    drawrect @bezier 14 1 $subv2($7 $8, 3 3) 6 6
    ; handles
    drawline @bezier 11 1 $1 $2 $3 $4
    drawline @bezier 11 1 $5 $6 $7 $8
    drawdot @bezier 4 2 $addv2($3 $4, 2 2) $addv2($5 $6, 2 2)
  }
  var %old.xx, %old.yy
  var %detail = $iif(%bezier.detail == $null, .01, %bezier.detail)
  var %u = %detail, %xx, %yy
  %u = %u * -1
  while (%u < 1) {
    inc %u %detail
    %xx = $calc((%ax * %u ^ 3) + (%bx * %u ^ 2) + (%cx * %u) + %x0)
    %yy = $calc((%ay * %u ^ 3) + (%by * %u ^ 2) + (%cy * %u) + %y0)
    if (!%old.xx) { %old.xx = %xx | %old.yy = %yy }
    ; if (%u == 0.5) drawdot @bezier 9 4 %xx %yy
    ; if (%u == 0.75) drawdot @bezier 3 4 %xx %yy
    drawline -r @Bezier $rgb(0,0,0) 1 %old.xx %old.yy %xx %yy
    %old.xx = %xx
    %old.yy = %yy
  }
}
alias click_find_handle {
  var %m = $mouse.x $mouse.y
  var %i = 0, %n = %bz.nsegs, %seg, %p, %ln, %mn = 999999999999, %ctrlh
  var %j = 0
  while (%i < %n) {
    inc %i
    %j = 3
    %seg = %seg [ $+ [ %i ] ]
    tokenize 32 $cen_scale(%seg)
    %ln = $vlen2($subv2($3 $4,%m))
    if (%ln < %mn) { %mn = %ln | %ctrlh = %i %j }
    %ln = $vlen2($subv2($5 $6,%m))

    inc %j 2
    if (%ln < %mn) { %mn = %ln | %ctrlh = %i %j }
    drawdot @bezier 4 2 $addv2($3 $4, 2 2)
    drawdot @bezier 4 2 $addv2($5 $6, 2 2)
  }
  %bz.hndldata = %ctrlh
  tokenize 32 %ctrlh
  %seg = %seg [ $+ [ $1 ] ]
  %seg = $cen_scale(%seg)
  %ctrlh = $gettok(%seg,$2,32) $gettok(%seg,$calc($2 + 1),32)
  drawdot @bezier 9 2 $addv2(%ctrlh, 2 2)
  %bz.dragpnt = %ctrlh
}


alias fixint2 {
  tokenize 32 $1-
  var %i = 0, %str
  while (%i < $0) {
    inc %i
    if ($calc(%i % 2)) %str = %str $calc($gettok($1-,%i,32) * 1)
    else %str = %str $calc($gettok($1-,%i,32) * -1)
  }
  if (%str) return %str
  return $1-
}
alias Save_POV_Spline {
  if ($1) %prism = 1
  else unset %prism
  var %f = $$_?(Save_POV_Spline_,Save to $did(beziersearch,3) .pov,$lower(%bz.filename))
}
alias Save_POV_Spline_ {
  var %f = $$1
  %bz.filename = %f
  var %i = 0, %n = %bz.nsegs, %seg
  var %q = 1
  %f = $+(%f,.pov)
  %f = $+($did(beziersearch,3),%f)
  if ($exists(%f)) %q = $?!"Overwrite %f "
  if (%q) {
    write -c %f
    if (%prism) {
      unset %prism
      write %f #declare $left($nopath(%f),-4) = prism $chr(123)
      write %f linear_sweep
      write %f bezier_spline
      write %f 1.0, //top
      write %f 0.0, //bottom
    }
    else write %f #declare $left($nopath(%f),-4) = lathe $chr(123) bezier_spline

    write %f $calc(%n * 4) $+ $chr(44)
    while (%i < %n) {
      inc %i
      %seg = %seg [ $+ [ %i ] ]
      tokenize 32 %seg
      if (%i < %n) {
        %seg = $+(<,$1,$chr(44),$calc($2 * -1),>,$chr(44), $&
          <,$3,$chr(44),$calc($4 * -1),>,$chr(44), $&
          <,$5,$chr(44),$calc($6 * -1),>,$chr(44), $&
          <,$7,$chr(44),$calc($8 * -1),>,$chr(44))
      }
      else {
        %seg = $+(<,$1,$chr(44),$calc($2 * -1),>,$chr(44), $&
          <,$3,$chr(44),$calc($4 * -1),>,$chr(44), $&
          <,$5,$chr(44),$calc($6 * -1),>,$chr(44), $&
          <,$7,$chr(44),$calc($8 * -1),>)
      }
      ; e %seg
      write %f %seg
    }
    write %f $chr(125)
    ; titlebar @bezier - $upper($left(%f,-4))
  }
}


alias click_find_node {
  var %m = $mouse.x $mouse.y
  var %i = 0, %n = %bz.nsegs, %seg, %p, %ln, %mn = 999999999999, %ctrlh
  var %j = 0
  while (%i < %n) {
    inc %i
    %j = 1
    %seg = %seg [ $+ [ %i ] ]
    tokenize 32 $cen_scale(%seg)
    %ln = $vlen2($subv2($1 $2,%m))
    if (%ln < %mn) { %mn = %ln | %ctrlh = %i %j }
    %ln = $vlen2($subv2($7 $8,%m))

    inc %j 6
    if (%ln < %mn) { %mn = %ln | %ctrlh = %i %j }
    drawrect @bezier 14 1 $subv2($1 $2, 3 3) 6 6
    drawrect @bezier 14 1 $subv2($7 $8, 3 3) 6 6
  }
  %bz.hndldata = %ctrlh
  tokenize 32 %ctrlh
  %seg = %seg [ $+ [ $1 ] ]
  %seg = $cen_scale(%seg)
  %ctrlh = $gettok(%seg,$2,32) $gettok(%seg,$calc($2 + 1),32)
  drawrect -f @bezier 9 1 $subv2(%ctrlh, 3 3) 6 6
  %bz.dragpnt = %ctrlh
  %setnode = 1
}
alias EditSpline {
  if (%editnode == 8) next_feature_up
  if (%editnode == 7) add_node_up
  if (%editnode == 6) new_spline_up
  if ((%editnode > 2) || ($vlen2($subv2(%bz.mclk,$mouse.x $mouse.y)) < 1)) halt
  var %seg, %ctrlh, %ctrlho, %x, %y, %n

  tokenize 32 %bz.hndldata

  %x = $divv2($subv2($mouse.x $mouse.y,%bz.cen),$cen_scale(0).sc)
  %y = $gettok(%x,2,32)
  %x = $gettok(%x,1,32)
  if (%setnode) {  %bz.handlelock = 0 | setnode2 %x %y }

  %seg = %seg [ $+ [ $1 ] ]

  %ctrlho = $gettok(%seg,$2,32) $gettok(%seg,$calc($2 + 1),32)
  %x = $divv2($subv2($mouse.x $mouse.y,%bz.cen),$cen_scale(0).sc)
  %y = $gettok(%x,2,32)
  %x = $gettok(%x,1,32)

  %seg = $puttok(%seg,%x,$2,32)
  %seg = $puttok(%seg,%y,$calc($2 + 1),32)
  %seg [ $+ [ $1 ] ] = %seg

  if (%bz.handlelock) move_other_handle $handle_degrees($1,$2,$mouse.x $mouse.y,%ctrlho)

  %seg = %seg [ $+ [ $1 ] ]
  draw_bezier_ $cen_scale(%seg) 1
  if (1) {
    ; draw adjacent curve
    %n = $ntok
    %n = $gettok(%n,1,32)
    if (%n) %seg = %seg [ $+ [ %n ] ]
    draw_bezier_ $cen_scale(%seg) 1
  }
  ; draw_path
  ; draw whole path
  if (%bz.toolbar) bz.toolbar
}
alias handle_degrees {
  var  %seg = %seg [ $+ [ $1 ] ]
  var %pnt, %v1, %v2
  if ($2 == 3) %pnt = $gettok(%seg,1-2,32) 0
  else %pnt = $gettok(%seg,7-8,32) 0
  %v1 = $divv2($subv2($3,%bz.cen),$cen_scale(0).sc) 0
  %v1 = $subv(%v1,%pnt)
  %v2 = $4 0
  %v2 = $subv(%v2,%pnt)
  var %r = $angle2(%v1,%v2)
  ; cross gives + or - z. = direction of rotation
  return $calc(%r * $gettok($normalize($cross(%v2,%v1)),3,32))
}
alias ntok {
  tokenize 32 %bz.hndldata
  if (($2 == 3) || ($2 == 5)) return $ntok_find_other_handle
  var %seg = %seg [ $+ [ $1 ] ]
  var %i = 0, %m = %bz.nsegs
  var %n = 0, %t, %tt
  if ($2 == 1) %tt = 7
  else if ($2 == 7) %tt = 1
  var %pnt = $gettok(%seg,$2,32) $gettok(%seg,$calc($2 + 1),32)
  var %pnt2
  while (%i < %m) {
    inc %i
    %seg = %seg [ $+ [ %i ] ]
    %pnt2 = $gettok(%seg,%tt,32) $gettok(%seg,$calc(%tt + 1),32)
    if (%pnt == %pnt2) { %n = %i | %t = %tt }
    ; e %pnt == %pnt2 $1 $2
  }
  return %n %t
}
alias setnode2 {
  var %x = $1, %y = $2, %seg
  tokenize 32 %bz.hndldata
  var %n = $1, %t = $2
  ; ok set n and t - find it!
  %n = $ntok
  if ($gettok(%n,2,32)) %t = $gettok(%n,2,32)
  %n = $gettok(%n,1,32)

  ; n == 0 if not found
  %seg = %seg [ $+ [ %n ] ]
  if (%n) {
    %seg = $puttok(%seg,%x,%t,32)
    %seg = $puttok(%seg,%y,$calc(%t + 1),32)
  }

  ; this handle
  var %v = $divv2($subv2($mouse.x $mouse.y,%bz.dragpnt),$cen_scale(0).sc)
  if (%t == 1) %t = 3
  else if (%t == 7) %t = 5
  if (%n) {
    if (10) {
      %x = $gettok(%seg,%t,32)
      %y = $gettok(%seg,$calc(%t + 1),32)
      %x = $addv2(%v,%x %y)
      %y = $gettok(%x,2,32)
      %x = $gettok(%x,1,32)
    }
    %seg = $puttok(%seg,%x,%t,32)
    %seg = $puttok(%seg,%y,$calc(%t + 1),32)
    %seg [ $+ [ %n ] ] = %seg
  }

  ; the first handle
  if (%t == 3) %t = 5
  else if (%t == 5) %t = 3
  %n = $1
  %seg = %seg [ $+ [ %n ] ]
  if (10) {
    %x = $gettok(%seg,%t,32)
    %y = $gettok(%seg,$calc(%t + 1),32)
    %x = $addv2(%v,%x %y)
    %y = $gettok(%x,2,32)
    %x = $gettok(%x,1,32)
  }
  %seg = $puttok(%seg,%x,%t,32)
  %seg = $puttok(%seg,%y,$calc(%t + 1),32)
  %seg [ $+ [ %n ] ] = %seg
  unset %setnode
}
alias mouseroll {
  titlebar @bezier %bz.filename %bz.nsegs Segments $&
    $vrnd2($addv2($divv2($multvv2($subv2($mouse.x $mouse.y,%bz.cen),1 -1),%bz.scale), 0 0))
  if (%bz.mode == scaleview) {
    if ($mouse.key & 1) {
      var %wh = $copywh($subv2i($mouse.x $mouse.y,%bz.mclk))
      drawcopy -n @bezbuff %bz.mclk %wh @bezier %bz.mclk %wh
      drawrect -n @bezier 1 1 %bz.mclk $subv2i($mouse.x $mouse.y,%bz.mclk)
      drawdot @bezier
    }
  }
}
alias copywh {
  return $addv2($1,30 30)
  tokenize 32 $1
  var %w = %bz.copy.w, %h = %bz.copy.h
  if ($1 > %bz.copy.w) %w = $1
  if ($2 > %bz.copy.h) %h = $2
  %bz.copy.w = %w
  %bz.copy.h = %h
  return %w %h
}
alias scaleview {
  if (($mouse.y > 50) && (!$vlen2($subv2(%bz.mclk,$mouse.x $mouse.y)))) halt
  ; upclick scale
  var %oldscale = %bz.scale, %v, %sc
  var %wh = $subv2i($mouse.x $mouse.y,%bz.mclk)
  if ($vlen2(%wh) < 2) halt
  if ($gettok(%wh,1,32) < $gettok(%wh,2,32)) %sc = $calc(%bz.h / $gettok(%wh,2,32))
  else %sc = $calc(%bz.w / $gettok(%wh,1,32))
  %bz.scale = %bz.scale * %sc

  %v = $divv2($subv2(%bz.cen,$addv2($divv2(%wh,2), %bz.mclk)),%oldscale)
  %v = $multv2(%v,%bz.scale)
  %bz.cen = $addv2i($calc(%bz.w / 2) $calc(%bz.h / 2),%v)
  draw_path
}
alias mode_switch {
  %bz.scale = .55
  %bz.mode = scaleview
  %bz.cen = $calc(%bz.w / 2 - 100) $calc(%bz.h / 2 + 200)
}
alias zoomout {
  %bz.mode = scaleview
  %bz.scale = .1
  %bz.cen = $calc(%bz.w / 2) $calc(%bz.h / 2)
  chk_window_size
  draw_path
}
alias chk_window_size {
  %bz.w = $window(@bezier).w - 10
  %bz.h = $window(@bezier).h - 55
}
alias insert_node {
  var %i = 0, %seg, %segn, %seg_2, %new, %hlen = 1, %y = 0 1
  if ($mouse.key & 2) {
    find_node
    %bz.selection = %bz.selection $replace(%bz.dragpnt,$chr(32),_)
  }
  else {
    ; find segment selection : make node @ $divv2($subv2(%bz.mclk,%bz.cen),%bz.scale)
    if ($numtok(%bz.selection,32) > 1) {
      while (%i < %bz.nsegs) {
        inc %i
        %seg = %seg [ $+ [ %i ] ]
        ; 8 tokens
        tokenize 32 %seg
        if (($+($1,_,$2) == $gettok(%bz.selection,1,32)) || ($+($1,_,$2) == $gettok(%bz.selection,2,32))) && $&
          (($+($7,_,$8) == $gettok(%bz.selection,2,32)) || ($+($7,_,$8) == $gettok(%bz.selection,1,32))) %segn = %i
        ; select in forward/back order, ok
      }

      %i = %bz.nsegs
      while (%i >= %segn) {
        %seg = %seg [ $+ [ %i ] ]
        %seg [ $+ [ $calc(%i + 1) ] ] = %seg
        dec %i
      }
      %new = $divv2($subv2(%bz.mclk,%bz.cen),%bz.scale)
      if (%bz.verthandles) {
        ; %bz.verthandles
        %seg_2 = %seg [ $+ [ $calc(%segn + 1) ] ]
        %seg = %seg [ $+ [ %segn ] ]

        drawdot @bezier
        if ($gettok(%seg,2,32) < $gettok(%seg_2,8,32)) %y = $multv2(%y,-1)

        %seg [ $+ [ %segn ] ] = $deltok(%seg,5-8,32) $&
          $addv2(%new,$multv2(%y,%hlen)) %new

        %seg = %seg [ $+ [ $calc(%segn + 1) ] ]
        %seg [ $+ [ $calc(%segn + 1) ] ] = %new $&
          $addv2(%new,$multv2($multv2(%y,-1),%hlen)) $deltok(%seg,1-4,32)
        draw_bezier_ $cen_scale( %seg [ $+ [ %segn ] ] ) 1
        draw_bezier_ $cen_scale( %seg [ $+ [ $calc(%segn + 1) ] ] ) 1
      }
      else {
        %seg = %seg [ $+ [ %segn ] ]
        %seg [ $+ [ %segn ] ] = $deltok(%seg,5-8,32) $&
          $addv2(%new,$multv2($normalize2($subv2($gettok(%seg,1-2,32),%new)),%hlen)) %new

        %seg = %seg [ $+ [ $calc(%segn + 1) ] ]
        %seg [ $+ [ $calc(%segn + 1) ] ] = %new $&
          $addv2(%new,$multv2($normalize2($subv2($gettok(%seg,7-8,32),%new)),%hlen)) $deltok(%seg,1-4,32)
      }
      inc %bz.nsegs
      ; draw_path
      unset %bz.selection
    }
    else _e First select 2 nodes of a segment with ctrl key.
  }
}
alias delete_node {
  find_node
  var %i = 0, %seg, %xy, %pnt, %segn, %segg, %n
  tokenize 32 %bz.hndldata
  if (($1 == 1) && ($2 == 1)) { _e Cannot delete home point | halt }
  if (($1 == %bz.nsegs) && ($2 == 7)) {
    if ($is_open_spline) {
      dec %bz.nsegs | draw_path
      var %p = %seg [ $+ [ %bz.nsegs ] ]
      %p = $gettok(%p,7-8,32)
      %bz.firstpoint = %p
    }
    else _e Cannot delete home point 
    halt
  }
  %segn = $1 + 1
  %n = 1 
  ; join 2 segs: $1 %segn
  if ((%segn) && (%segn != $1)) {
    %seg = %seg [ $+ [ $1 ] ]
    %segg = %seg [ $+ [ %segn ] ]
    %seg [ $+ [ $1 ] ] = $deltok(%seg,5-8,32) $deltok(%segg,1-4,32)
    %i = $1
    dec %bz.nsegs
    while (%i < %bz.nsegs) {
      inc %i
      %seg = %seg [ $+ [ $calc(%i + 1) ] ]
      %seg [ $+ [ %i ] ] = %seg
    }
    draw_path
    unset %seg [ $+ [ $calc(%bz.nsegs + 1) ] ]
  }
  else _e Some error delete_node %segn != $1
}
alias align_handles {
  find_node
  var %i = 0, %seg, %hndl, %hndl2, %pnt, %segn, %segg, %n
  tokenize 32 %bz.hndldata
  if (($1 == 1) && ($2 == 1)) { %segn = %bz.nsegs | %n = 5 }
  else {
    %segn = $1 + 1
    %n = 3 
  }
  %seg = %seg [ $+ [ $1 ] ]
  %pnt = $gettok(%seg,$2,32)
  %pnt = %pnt $gettok(%seg,$calc($2 + 1),32)

  var %ln, %handle_location
  if ($2 == 1) %handle_location = 3
  else %handle_location = 5
  %hndl = $gettok(%seg,%handle_location,32)
  %hndl = %hndl $gettok(%seg,$calc(%handle_location + 1),32)

  %segg = %seg [ $+ [ %segn ] ]
  %hndl2 = $gettok(%segg,%n,32)
  %hndl2 = %hndl2 $gettok(%segg,$calc(%n + 1),32)

  %ln = $vlen2($subv2(%hndl,%pnt))
  %hndl = $multv2($normalize2($subv2(%hndl2,%pnt)),$calc(-1 * %ln))
  %hndl = $addv2(%pnt,%hndl)
  %seg = $puttok(%seg,$gettok(%hndl,1,32),%handle_location,32)
  %seg [ $+ [ $1 ] ] = $puttok(%seg,$gettok(%hndl,2,32),$calc(%handle_location + 1),32)

  draw_path
}

alias find_node {
  var %m = $mouse.x $mouse.y
  var %i = 0, %n = %bz.nsegs, %seg, %p, %ln, %mn = 999999999999, %ctrlh
  var %j = 0
  while (%i < %n) {
    inc %i
    %j = 1
    %seg = %seg [ $+ [ %i ] ]
    tokenize 32 $cen_scale(%seg)
    %ln = $vlen2($subv2($1 $2,%m))
    if (%ln < %mn) { %mn = %ln | %ctrlh = %i %j }
    %ln = $vlen2($subv2($7 $8,%m))

    inc %j 6
    if (%ln < %mn) { %mn = %ln | %ctrlh = %i %j }
    drawrect @bezier 14 1 $subv2($1 $2, 3 3) 6 6
    drawrect @bezier 14 1 $subv2($7 $8, 3 3) 6 6
  }
  %bz.hndldata = %ctrlh
  tokenize 32 %ctrlh
  %seg = %seg [ $+ [ $1 ] ]
  %bz.dragpnt = $gettok(%seg,$2,32) $gettok(%seg,$calc($2 + 1),32)
  %seg = $cen_scale(%seg)
  %ctrlh = $gettok(%seg,$2,32) $gettok(%seg,$calc($2 + 1),32)
  drawrect -f @bezier 9 1 $subv2i(%ctrlh, 3 3) 6 6
}
alias align_other_handle {
  find_handle
  var %i = 0, %seg, %hndl, %hndl2, %pnt, %segn, %segg, %n, %x
  tokenize 32 %bz.hndldata
  %n = $ntok_find_other_handle
  %segn = $gettok(%n,1,32)
  %n = $gettok(%n,2,32)
  var %nn
  if ($2 == 3) %nn = 1
  else %nn = 7
  %seg = %seg [ $+ [ $1 ] ]
  %pnt = $gettok(%seg,%nn,32)
  %pnt = %pnt $gettok(%seg,$calc(%nn + 1),32)
  ; was that a first or last node handle?

  var %ln
  %hndl = $gettok(%seg,$2,32)
  %hndl = %hndl $gettok(%seg,$calc($2 + 1),32)

  %segg = %seg [ $+ [ %segn ] ]
  %hndl2 = $gettok(%segg,%n,32)
  %hndl2 = %hndl2 $gettok(%segg,$calc(%n + 1),32)

  %ln = $vlen2($subv2(%hndl2,%pnt))
  %hndl2 = $multv2($normalize2($subv2(%hndl,%pnt)),$calc(-1 * %ln))
  %hndl2 = $addv2(%pnt,%hndl2)
  %segg = $puttok(%segg,$gettok(%hndl2,1,32),%n,32)
  %seg [ $+ [ %segn ] ] = $puttok(%segg,$gettok(%hndl2,2,32),$calc(%n + 1),32)

  %seg = %seg [ $+ [ $1 ] ]
  draw_bezier_ $cen_scale(%seg) 1
  if (1) {
    ; draw adjacent curve
    %n = $ntok_find_other_handle
    %n = $gettok(%n,1,32)
    if (%n) { %seg = %seg [ $+ [ %n ] ]
      draw_bezier_ $cen_scale(%seg) 1
    }
  }
  if (%bz.toolbar) bz.toolbar
}
alias ntok_find_other_handle {
  tokenize 32 %bz.hndldata
  var %seg = %seg [ $+ [ $1 ] ]
  var %i = 0, %m = %bz.nsegs
  var %n = 0, %t, %tt
  if ($2 == 3) %tt = 1
  else if ($2 == 5) %tt = 7
  var %pnt = $gettok(%seg,%tt,32) $gettok(%seg,$calc(%tt + 1),32)

  if ($2 == 3) %tt = 7
  else if ($2 == 5) %tt = 1
  var %pnt2
  while (%i < %m) {
    inc %i
    %seg = %seg [ $+ [ %i ] ]
    %pnt2 = $gettok(%seg,%tt,32) $gettok(%seg,$calc(%tt + 1),32)
    if (%pnt == %pnt2) { %n = %i | %t = %tt }
    ; e %pnt == %pnt2 $1 $2
  }
  if (%tt == 7) %t = 5
  else if (%tt == 1) %t = 3
  return %n %t
}
alias move_other_handle {
  var %i = 0, %seg, %hndl, %hndl2, %pnt, %segn, %segg, %n
  var %degrees = $1 * -1
  tokenize 32 %bz.hndldata

  %n = $ntok_find_other_handle
  %segn = $gettok(%n,1,32)
  %n = $gettok(%n,2,32)
  var %nn

  if ($2 == 3) %nn = 1
  else %nn = 7
  %seg = %seg [ $+ [ $1 ] ]
  %pnt = $gettok(%seg,%nn,32)
  %pnt = %pnt $gettok(%seg,$calc(%nn + 1),32)
  ; was that a first or last node handle?

  %hndl = $gettok(%seg,$2,32)
  %hndl = %hndl $gettok(%seg,$calc($2 + 1),32)

  %segg = %seg [ $+ [ %segn ] ]
  %hndl2 = $gettok(%segg,%n,32)
  %hndl2 = %hndl2 $gettok(%segg,$calc(%n + 1),32)
  ; e %degrees degrees
  %hndl2 = $rotation($deg2rad(%degrees),0 0 1, [ $subv2(%hndl2,%pnt) ] 0 )
  %hndl2 = $addv2(%pnt,%hndl2)
  %segg = $puttok(%segg,$gettok(%hndl2,1,32),%n,32)
  %seg [ $+ [ %segn ] ] = $puttok(%segg,$gettok(%hndl2,2,32),$calc(%n + 1),32)
  if (0) {
    ; draw adjacent curve
    %n = $ntok
    %n = $gettok(%n,1,32)
    if (%n)  {
      e %n n $1
      %seg = %seg [ $+ [ $1 ] ]
      draw_bezier_ $cen_scale(%seg) 1
    }
  }
}
alias find_handle {
  var %m = $mouse.x $mouse.y
  var %i = 0, %n = %bz.nsegs, %seg, %p, %ln, %mn = 999999999999, %ctrlh
  var %j = 0
  while (%i < %n) {
    inc %i
    %j = 3
    %seg = %seg [ $+ [ %i ] ]
    tokenize 32 $cen_scale(%seg)
    %ln = $vlen2($subv2($3 $4,%m))
    if (%ln < %mn) { %mn = %ln | %ctrlh = %i %j }
    %ln = $vlen2($subv2($5 $6,%m))

    inc %j 2
    if (%ln < %mn) { %mn = %ln | %ctrlh = %i %j }
    drawdot @bezier 4 2 $addv2($3 $4, 2 2)
    drawdot @bezier 4 2 $addv2($5 $6, 2 2)
  }
  %bz.hndldata = %ctrlh
  tokenize 32 %ctrlh
  %seg = %seg [ $+ [ $1 ] ]
  %seg = $cen_scale(%seg)
  %ctrlh = $gettok(%seg,$2,32) $gettok(%seg,$calc($2 + 1),32)
  drawdot @bezier 9 2 $addv2(%ctrlh, 2 2)
  %bz.dragpnt = %ctrlh
}
alias _e { echo -s $1- }
alias e { echo -s $1- }
