

  
// EarthRad =  6378.137 km /////// Earth, Radius, Equatorial. 3963.19245606
// Internal Distance Scale = km div scale  X=238300.677176 & stars= 320000

#declare EarthRad = 6378.137;
#declare IDS = function(km) { (km/(EarthRad*10)) } //where prad must = 1/10



#include "megatime.inc"
// declares JulianDate, ctime
echof(JulianDate) echo(" JulianDate\n")
echo(str(j2ctime(JulianDate),0,0)     ) echo(" Ctime\n")

#declare obliquity_f = function(J) {
    23.496932-(0.86*sin(0.01532*((JulianDate-2451545.0)/36525+4.4)))
}


//////////////////////////****************************** time date input ********
//Dec 22 2007 23:42:20
//#declare ctime = 1198366940;
//#declare JulianDate = 2454457.48773;

//Mar 28 2008 17:37:44
//#declare JulianDate = 2454554.23453;
//#declare ctime = 1206725863;

//#declare ctime = 1198366940;
//#declare JulianDate = 2454457.48773;      */   ////////////////////////////////




#declare days = ctime / 3600.0 / 24.0 - 10092.0 ;
//$epoch2day(Epoch 1997 aug. 20 TT) earth long 328.40353 ? 327.52 = within 2.92 vernal07-autumnal06. 327.65 aligns ra 0.23-180.01

#macro radec2pos(h,m,dec)
  #local ra=h*15+m*0.25;
  <cos(radians(ra))*cos(radians(dec)), sin(radians(dec)), sin(radians(ra))*cos(radians(dec))>
#end

// galatic pole @ 12 51.4 27.116667
//#declare b = vnormalize(radec2pos(12, 51.4, 27.116667));
//#declare a = vnormalize(vcross(<0,1,0>,b));
//#declare c = vnormalize(vcross(b,a));
//#declare galacticmatrix=array[16] { a.x,a.y,a.z,0,b.x,b.y,b.z,0,c.x,c.y,c.z,0,0,0,0,1 }


////////////////////////////////////////////////////////////////// ORBITAL PLANE
#declare b = rotation(radians(obliquity_f(0)),<1,0,0>,<0,1,0>);
#declare c = rotation(radians(obliquity_f(0)),<1,0,0>,<0,0,1>);
#declare orbitmatrix=array[16] { 1,0,0,0,b.x,b.y,b.z,0,c.x,c.y,c.z,0,0,0,0,1 }


#macro pig(i)
  image_map {
    jpeg map[i]
    map_type 1
    interpolate 2
  }
#end

#declare elements=array[11][10] {
 { ".",".",".",".",".",".",".","109.75","Sun","0" }
 { "7.00487","48.333899","77.453997","0.387098","4.0923349","0.205632","314.423688","0.382518","Mercury","0" }
 { "3.39472","76.6889","131.761002","0.723324","1.602158","0.006793","236.2","0.948863","Venus","0" }
 { "0.000295","348.73936","114.20783","1.000000112361225","0.98564736","0.016710219","327.65","1.0","Earth","0" }
 { "1.85061","49.57854","290.4623","1.523662","0.524048","0.09341233","262.427834","0.533466","Mars","0" }
 { "1.3053","100.471297","15.6978","5.202597","0.083078","0.048465","322.559836","11.20915","Jupiter","0" }
 { "2.48446","113.635797","88.863","9.5719","0.03346","0.053165","20.95759","9.45123","Saturn","0" }
 { "0.76986","74.22988","175.680703","19.30181","0.011623","0.042896","303.1896","4.007367","Uranus","0" }
 { "1.76917","131.792503","7.206","30.26664","0.005919","0.010298","299.864101","3.882719","Neptune","0" }
 { "17.14175","110.383302","224.802494","39.481686","0.003958072","0.250127","235.76559","0.180778","Pluto","0" }
 { "32.4","275.4","208.5","101.6","0.0009672","0.411","217.0","4.95","Planet-X","0" }
} 
//       0             1             2        3           4          5            6
//inclination, ascending node, perihelion, axis au, daily motion,eccentricity, longitude,
// size-earthrads, name, host-id
#declare rot_rate=array[11] { 0,-6.138505,1.481369,-360.98564736,-350.891899,-870.536642,
-801.1126565,501.16242,-536.312849,56.36246,-187.0 }
#declare map=array[12] { "sun","mercury","venus","earth","mars","jupiter",
"saturn","uranus","neptune","pluto","neptune","moon" }
#declare plabels=array[12] { "Sun","Mercury","Venus","Earth","Mars","Jupiter",
"Saturn","Uranus","Neptune","Pluto","Planet-X","Moon" }
//#declare plabelcol=array[12] {  }

#declare planet_rot=array[12] { 0,0,0,-10,-40,0,0,0,0,0,0,0  }

#macro Planets(n)
  #local i=1;
  #while (i < 11)
    #local o = orbital(i);

    sphere { <0,0,0>, (val(elements[i][7])/10) pigment { pig(i) } finish { ambient .005 diffuse 0.7 }    // planets
      rotate <0,(rot_rate[i]*days-90)+planet_rot[i],0>
      matrix <Xp[i].x,Xp[i].y,Xp[i].z,Yp[i].x,Yp[i].y,Yp[i].z,Zp[i].x,Zp[i].y,Zp[i].z,o.x,o.y,o.z>
    }
    #if (i = 3)
        #if (DrawAtmo) atmo(1.03*(val(elements[i][7])/10)) #end #end

    #if (PlanetLabels)
      #local vl = vlength(o-campos)/100;
      text {
        ttf "Arial.ttf" plabels[i] 1 0 scale <vl*FontSize,vl*FontSize, .000001>
        texture {
          pigment { rgb 1 } 
          finish { ambient 1 diffuse 0 }
        }
        #local camup = <cameramatrix[4],cameramatrix[5],cameramatrix[6]>;
        //#local E = vnormalize(o-campos); 
        //#local R = vnormalize(vcross(camup,E)); //<0,1,0>
        //#local U = vnormalize(vcross(E,R));
        //popmatrix(R,U,E,o+U*(val(elements[i][7])/10))
        
        popTmatrix4(cameramatrix,-camup*(val(elements[i][7])/9)+o)
      }
    #end
    #local i=i+1;
  #end
#end

#macro SolveKepler(M,ec)
  #local E = M;
  #local d = E - ec * sin(E) - M;
  #while (abs(d) > 0.00000001)
    #local delta = d / (1.0 - ec * cos(E));
    #local E = E - delta;
    #local d = E - ec * sin(E) - M;
  #end
E
#end

#macro orbital(id)
  #local M = days * radians(val(elements[id][4]));
  #local p = radians(val(elements[id][2]));
  #local M = M + radians(val(elements[id][6])) - p;
  #local e = val(elements[id][5]);
  #local E = SolveKepler(M, e);
  //#local r = pScale * val(elements[id][3]) * (1.0 - e * cos(E));
  #local r = IDS(au2km(val(elements[id][3]))) * (1.0 - e * cos(E));
  #local vv = 2.0 * atan(sqrt((1.0 + e) / (1.0 - e)) * tan(E / 2.0));
  #local o = radians(val(elements[id][1]));
  #local i = radians(val(elements[id][0]));

  #local vv = vv + p - o;
 #local e = sin(vv);
 #local p = sin(o);
 #local o = cos(o);
 #local vv = cos(vv);
 #local M = cos(i);
 #local _v = <r * (o * vv - p * e * M), r * e * sin(i), r * (p * vv + o * e * M)>;
                 /*
  #local result = <
     r * (cos(o) * cos(vv + p - o) - sin(o) * sin(vv + p - o) * cos(i)),
     r * (sin(vv + p - o) * sin(i)),
     r * (sin(o) * cos(vv + p - o) + cos(o) * sin(vv + p - o) * cos(i))>;
                   */
 
#local result = pop_matrix4(orbitmatrix,_v);
    //#local result = rotation(radians(obliquity),<1,0,0>,_v);
    
result
#end
//       0             1             2        3           4          5            6
//inclination, ascending node, perihelion, axis au, daily motion,eccentricity, longitude
              



/* VENUS
echov(radec2pos(18,11,67.16))
*/
// NorthPoles from RaDec Wiki

#declare Yp = array[11] {
  <0.122353441903628, 0.897797192115935, -0.423071905334163>
  <0.091274333318625, 0.87840046198445, -0.469128579882686>
  <0.018690819744392, 0.921592341274493, -0.387708924015789>
  <0.0, 1.0, 0.0>
  <0.446158464461141, 0.797442047751279, -0.406237375272049>
  <-0.014654507041372, 0.902510203469804, -0.430419072598169> 
  <0.085438088017201, 0.993650637868801, 0.073203435567528> 
  <0.212015998366143, 0.261768361853467, 0.941555384015917> 
  <0.358536930454372, 0.681359937097356, -0.638122171389651>
  <-0.673685502106019, -0.15798530500782, 0.72193385268579>
  <0.0,1.0,0.0>
}

#macro radec2pos_(h,m,dec)
  #local ra=h*15+m*0.25;
  <sin(radians(ra))*cos(radians(dec)), sin(radians(dec)), cos(radians(ra))*cos(radians(dec))>
#end
//echov(radec2pos(21, 10.74, 52.8865)) echo(" radec \n")
//echov(radec2pos_(21, 10.74, 52.8865)) echo(" radec \n")



 /*
#declare Xp = array[11] {
  vnormalize(vcross(<0,1,0>,Yp[0]))
  vnormalize(vcross(<0,1,0>,Yp[1]))
  vnormalize(vcross(<0,1,0>,Yp[2]))
  <1.0, 0.0, 0.0>
  vnormalize(vcross(<0,-1,0>,Yp[4]))
  vnormalize(vcross(<0,1,0>,Yp[5]))
  vnormalize(vcross(<0,1,0>,Yp[6]))
  vnormalize(vcross(<0,1,0>,Yp[7]))
  vnormalize(vcross(<0,1,0>,Yp[8]))
  vnormalize(vcross(<0,1,0>,Yp[9]))
  <1.0,0.0,0.0>
} 

#declare Zp = array[11] {
  vnormalize(vcross(Yp[0],Xp[0]))
  vnormalize(vcross(Yp[1],Xp[1]))
  vnormalize(vcross(Yp[2],Xp[2]))
  <0.0, 0.0, 1.0>
  vnormalize(vcross(Yp[4],Xp[4]))
  vnormalize(vcross(Yp[5],Xp[5]))
  vnormalize(vcross(Yp[6],Xp[6]))
  vnormalize(vcross(Yp[7],Xp[7]))
  vnormalize(vcross(Yp[8],Xp[8]))
  vnormalize(vcross(Yp[9],Xp[9]))
  <0.0, 0.0, 1.0>
} */

 
#declare Xp = array[11] {
  vnormalize(vcross(Yp[0],<0,-1,0>))
  vnormalize(vcross(Yp[1],<0,-1,0>))
  vnormalize(vcross(Yp[2],<0,-1,0>))
  <1.0, 0.0, 0.0>
  vnormalize(vcross(Yp[4],<0,-1,0>))
  vnormalize(vcross(Yp[5],<0,-1,0>))
  vnormalize(vcross(Yp[6],<0,-1,0>))
  vnormalize(vcross(Yp[7],<0,-1,0>))
  vnormalize(vcross(Yp[8],<0,-1,0>))
  vnormalize(vcross(Yp[9],<0,-1,0>))
  <1.0,0.0,0.0>
}

#declare Zp = array[11] {
  vnormalize(vcross(Xp[0],Yp[0]))
  vnormalize(vcross(Xp[1],Yp[1]))
  vnormalize(vcross(Xp[2],Yp[2]))
  <0.0, 0.0, 1.0>
  vnormalize(vcross(Xp[4],Yp[4]))
  vnormalize(vcross(Xp[5],Yp[5]))
  vnormalize(vcross(Xp[6],Yp[6]))
  vnormalize(vcross(Xp[7],Yp[7]))
  vnormalize(vcross(Xp[8],Yp[8]))
  vnormalize(vcross(Xp[9],Yp[9]))
  <0.0, 0.0, 1.0>
}


// ********************************** Atmo *************************************yet to do


/*#declare PlanetE=
union {
sphere {
 0,1
 texture { pigment { pig(3) } finish {
    ambient 0 diffuse .5 //brilliance 1
    specular .1
    roughness .02
    metallic .2
    //reflection { .2,.9 metallic .1 fresnel on exponent 1 }
    conserve_energy
  } }
 }*/
#macro atmo(scal) 

  sphere{0,1 // Atmosphere
    pigment{colour rgbt 1}
    interior{
      media {
        // (---general values---)
        intervals 10 // number of intervals used for sampling [10]
        samples 1,1  // minimum and maximum number of samples taken per interval [1,1]
        confidence 0.9  // statistic parameter higher->better quality [0.9]
        variance 1.0/128   // statistic parameter lower->better quality [1.0/128]
        ratio 0.9              // distribution between lit and unlit areas [0.9]
        // (---media types---)
        //absorption rgb<.1,.05,0>*.001 
        // absorbing media, block light of specified color
        scattering {2, rgb 10 }
        //method 3               // adaptive sampling
        density {onion
          color_map{
            [.89 rgb .5] // earth
            [.93 rgb <0,.5,.6>*.5]
            [.98 rgb <0,0,.1>]
            [1 rgb 0 ]
            }
         }
        }
      }
    rotate y*90
    scale scal
    hollow
    //double_illuminate
    translate Earth_v 
    }
    #end
//#if (DrawAtmo) object { atmo(1.03 translate Earth-V } #end
//}

////object{ PlanetE scale .3 rotate <0,180,0> }    it was working fine as is, now, too long and brunt White