//milkyway.inc

#declare RangeMM=function(Val,Rmin,Rmax,Min,Max){
   (((Val-Rmin)/(Rmax-Rmin))*(Max-Min)+Min)
}

#declare Scale = 400;
//MilkyWay Radius = 810*Scale(400);
// 800*starScale(400)

#macro Milkyway()
  #local numpoints = 60;
  #declare NumVertices = 60*2+2;

  #declare V_vec_Arr=array[NumVertices] 
  #declare N_vec_Arr=array[NumVertices] 
  #declare UV_vec_Arr=array[NumVertices]
  #declare NumEdges = 0;
  #declare Edge_Arr=array[NumVertices*3]
  #declare NumFaces = 0;
  #declare Face_Arr=array[NumVertices*2]

  #local gp = radians2pos(3.365867462471059, 0.473275115499129);
  //echov(gp)
  //echo("gp")
  #local Width = 800*Scale;
  #local Radius = 810*Scale;
  
  #local NumVertices = 0;
  #local i=0;
  #local start = radians2pos(1.968731396249604, 0) * Radius;
 // -0.294960643587042) * Radius;
//#local start = <-135630.45526,0.00000,322652.10306>,<0,1,0>);
#local start = <1,0,0>* Radius;;
  #local k = 0;
  #local s1 = 1; #local s2 = 1; #local e1 = 1; #local e2 = 1;
  #local rads = pi*2/numpoints;
  #local rads2 = 0;
  #while (i<2)
    #local V=RangeMM(i,0,2,pi,pi*2);
    #local j=0;
  
    #local s1 = s2;
    #local s2 = k + 1;
    #while (j<=numpoints)
      #local rads2 = rads+rads2;
      #local U=RangeMM(j,0,numpoints,pi,pi*2);
      #declare UV_vec_Arr[k]=<U,V>;
      
      #if (i) #local _v_ = (<0,-1,0>*(Width/2));         // bottom
      #else #local _v_ = (y*(Width/2)); #end       // top
      #local _v = rotation(rads2,<0,1,0>,start+_v_);
      #local NumVertices=NumVertices+1;
      
      #declare N_vec_Arr[k] = vnormalize(_v);
      #declare V_vec_Arr[k] = _v;
      
      #local j=j+1;
      #local k=k+1;
   #end
   #local e1 = e2; 
   #local e2 = k;
   #if (i) stripedges(s1-1, e1-1, s2-1, e2-1) #end
   #if (i) stripfaces(s1-1, e1-1, s2-1, e2-1) #end   
   #local i=i+1;
  #end

#end


#macro WriteMesh(WriteReadMesh)
   #debug concat("\n\n Writing : '",WriteReadMesh,"'\n   vertex_vectors\n")
   #fopen MeshFile WriteReadMesh write
   #write(MeshFile, "#debug concat(\"\\n uv mapping area: <",str(Umin,0,-1),", ",str(Vmin,0,-1),">, <",str(Umax,0,-1),", ",str(Vmax,0,-1),">\\n\")\n\n")
   #write(
      MeshFile,
      "#declare Surface = mesh2 {\n",
      "  vertex_vectors {\n",
      "    ", NumVertices,"\n    "
   )
   #local i=0;
   #while (i<NumVertices)
      #write(MeshFile, V_vec_Arr[i])
      #local i=i+1;
      #if(mod(i,5)=0)
         #write(MeshFile,"\n    ")
      #end 
   #end 
   #write(MeshFile,"\n  }\n")
   #write(
      MeshFile,
      "  normal_vectors {\n",
      "    ", NumVertices,"\n    "
   )
   #debug concat("   normal_vectors\n")   
   #local i=0;
   #while (i<NumVertices)
      #write(MeshFile N_vec_Arr[i])
      #local i=i+1; 
      #if(mod(i,5)=0)
         #write(MeshFile,"\n    ")
      #end 
   #end
   #write(MeshFile,"\n  }\n")
   #write(
      MeshFile, 
      "  uv_vectors {\n",
      "    ", NumVertices,"\n    "
   )
   #debug concat("   uv_vectors\n")   
   #local i=0;
   #while (i<NumVertices)
      #write(MeshFile UV_vec_Arr[i])
      #local i=i+1; 
      #if(mod(i,5)=0)
         #write(MeshFile,"\n    ")
      #end 
   #end
   #write(MeshFile,"\n  }\n")
   #write(
      MeshFile,
      "  face_indices {\n"
      "    ",NumFaces,"\n    "
   )
   #debug concat("   face_indices\n")
      #local H=0;
      #local i = 0;
       #while (i<NumFaces)
           #write(MeshFile,Face_Arr[i])
           #local H=H+1;
           #if(mod(H,5)=0) #write(MeshFile,"\n    ") #end
           #local i=i+1;
      #end
   #write(MeshFile, "\n  }\n}")
   #fclose MeshFile
   #debug concat(" Done writing\n")   
#end






#macro stripfaces(s1, e1, s2, e2)
//(range1 range2)
  #local n1 = (e1-s1) + 1;
  #local n2 = (e2-s2) + 1;


  #local j = s2;
  #local i = s1;
     
   #if (n1 <= n2)  
     #local i = s1;
     #local j = s2;
     #local k = i;
     #local aratio = n1 / n2; 
     #local h = 0;

     #while (h < n1+n2-1)
       
       #if (h)
         #declare Face_Arr[NumFaces] = <last.x,last.y,switc>;
         #declare NumFaces = NumFaces+1;
       #end
       #local last = <i,j>;
       #if (floor(k+aratio) = i)
         #if (j < e2) #local j=j+1; #local switc = j; #local k = k+aratio;  #end
       #else 
         #if (i < e1) #local i = i+1; #local switc = i; #end
       #end
       
       #local h = h+1;
     #end // while

     #if (n1 > 1)
      #declare Face_Arr[NumFaces] = <s1,e1,e2>;
      #declare NumFaces = NumFaces+1;
      #declare Face_Arr[NumFaces] = <s1,e2,s2>;
      #declare NumFaces = NumFaces+1;
    #else
      #declare Face_Arr[NumFaces] = <s1,e2,s2>;
      #declare NumFaces = NumFaces+1;
     #end


   #else

     #local i = s2;
     #local j = s1;
     #local k = i;
     #local aratio = n2 / n1; 
     #local h = 0;
     
     #while (h < n1+n2-1)
       
       #if (h)
         #declare Face_Arr[NumFaces] = <last.x,last.y,switc>;
         #declare NumFaces = NumFaces+1;
       #end
       #local last = <j,i>;
       #if (floor(k+aratio) = i)
         #if (j < e1) #local j=j+1; #local switc = j; #local k = k+aratio;  #end
       #else 
         #if (i < e2) #local i = i+1; #local switc = i; #end
       #end
       
       #local h = h+1;
     #end // while

     #if (n2 > 1)
      #declare Face_Arr[NumFaces] = <s2,e1,e2>;
      #declare NumFaces = NumFaces+1;
      #declare Face_Arr[NumFaces] = <s2,s1,e1>;
      #declare NumFaces = NumFaces+1;
     #else
      #declare Face_Arr[NumFaces] = <s2,s1,e1>;
      #declare NumFaces = NumFaces+1;      
     #end

     
   #end
#end
#macro stripedges(s1, e1, s2, e2)
//(range1 range2)
  #local n1 = (e1-s1) + 1;
  #local n2 = (e2-s2) + 1;

  #local j = s2;
  #local i = s1;

   #while (j < e2)
   
     #declare Edge_Arr[NumEdges] = <j,j+1>;
     #declare NumEdges = NumEdges+1;
     #local j = j+1;
   #end
   #if (e2 != s2)
     #declare Edge_Arr[NumEdges] = <e2,s2>;
     #declare NumEdges = NumEdges+1;
   #end
     
   #if (n1 <= n2)  
     #local i = s1;
     #local j = s2;
     #local k = i;
     #local aratio = n1 / n2; 
     #local h = 0;

     #while (h < n1+n2-1)
    
       #if (NumEdges < NumVertices*3)
         #declare Edge_Arr[NumEdges] = <i,j>;
         #declare NumEdges = NumEdges+1;
       #end
     
       #if (floor(k+aratio) = i)
         #if (j < e2) #local j=j+1; #local k = k+aratio;  #end
       #else 
         #if (i < e1) #local i=i+1; #end
       #end
    
       #local h = h+1;
     #end // while

     #if (n1 > 1)
      #declare Edge_Arr[NumEdges] = <s1,e2>;
      #declare NumEdges = NumEdges+1;
     #end


   #else

     #local i = s2;
     #local j = s1;
     #local k = i;
     #local aratio = n2 / n1; 
     #local h = 0;
     
     #while (h < n1+n2-1)
    
       #if (NumEdges < NumVertices*3)
         #declare Edge_Arr[NumEdges] = <i,j>;
         #declare NumEdges = NumEdges+1;
       #end
     
       #if (floor(k+aratio) = i)
         #if (j < e1) #local j=j+1; #local k = k+aratio;  #end
       #else 
         #if (i < e2) #local i=i+1; #end
       #end
    
       #local h = h+1;
     #end // while

     #if (n2 > 1)
      #declare Edge_Arr[NumEdges] = <s2,e1>;
      #declare NumEdges = NumEdges+1;
     #end

     
   #end
#end

#if (DrawMilkyway)
Milkyway()
#declare mwm=
mesh2 {
      #local i = 0;
      vertex_vectors {
         NumVertices
         #while (i<NumVertices)
            V_vec_Arr[i]
            #local i = i+1; 
         #end
      }
      #local i = 0;
      normal_vectors {
         NumVertices
         #while (i<NumVertices)
            N_vec_Arr[i]
            #local i = i+1;
         #end
      }
      #local i = 0;
      uv_vectors {
         NumVertices
         #while (i<NumVertices)
            UV_vec_Arr[i]
            #local i = i+1;
         #end
      }
      #local i = 0;
      face_indices {
         NumFaces
         #local i = 0;
         #while (i<NumFaces)
            Face_Arr[i]
            #local i = i+1;
         #end
      }
}
   /*
   #declare SurfMin=min_extent(mwm);
   #declare SurfMax=max_extent(mwm);     
   #debug concat("\n SurfMin: <",vstr(3,SurfMin,", ",0,-1),">\n")
   #debug concat(" SurfMax: <",vstr(3,SurfMax,", ",0,-1),">\n")
     */
   
#declare P_IM_MW = pigment {
  image_map {
    jpeg "mw"
    map_type 1
    //filter all .1 transmit all .9 gone
    //filter all .9 transmit all .1 goofy
    filter all .5 transmit all 0 // acceptable
  }
}

object{ mwm
 texture { pigment { 
 P_IM_MW
 //rgb .5
  } finish { ambient 0.35 diffuse 0 }
 }
 
 //rotate <0,158.6,0> 
 rotate <0,201.4,0> //mapstart
 
 #local gp = radians2pos(3.365867462471059, 0.473275115499129);
 //#local _x = vnormalize(vcross(gp,<0,1,0>));
 //#local _z = vnormalize(vcross(_x,gp));
 
 // for map not mirrored
 #local _x = vnormalize(vcross(<0,-1,0>,gp));
 #local _z = vnormalize(vcross(gp,_x));
 
 matrix <_x.x,_x.y,_x.z,gp.x,gp.y,gp.z,_z.x,_z.y,_z.z,0,0,0>
}
#end


///////////////////////////////////////////////////////////////////The RuleZ!!!
/*

Standard and right vector.  Moon:
vcross(<0,1,0>,E)      up->eye    return a L/R vector

Moon's Label:
popTmatrix4(cameramatrix

Planet ups:
vcross(planetNothPole,<0,-1,0>)

Planet Labels:
popTmatrix4(cameramatrix

MilkyWay:
vcross(<0,-1,0>,gp)

no need to mirror maps

*/