/*

******************************************************************************
Triangulation.inc

3D Macros:
  incenter(v1,v2,v3)
  centroid(v1,v2,v3)
  ccenter(v1,v2,v3)      circumcenter
  orthocenter(v1,v2,v3)
  normal_vector(v1,v2,v3)
  midpoint(v1,v2)


Functions:
  inneradius(a,b,c)
  circumradius(a,b,c)
  
  sss_area(a,b,c)
  sas_area(s,a,s2)
  bh_area(b,h)           Base Height

  sss_height(a,b,c)      height to side2
  sas_cos(s,a,s2)        Side Angle Side - solve length of missing side

  aas_sin(a,b,s)         AAS solve opposing side of angle2 (b)
  asa_sin(a,s,b)         ASA solve opposing side of angle2 (b)
  sss_cos(a,b,c)         SSS solve angle opposite side2    (b)
  ssa_acute(s,s2,a)      SSA solve angle opposite side2 
  
Float Macros:
  ssa_obtuse(s,s2,a)
  sa_height(s,a)         Side Angle unknown base
  _clamp(a,n,m)
       
    alphaQuad 10-2007
*******************************************************************************

*/
#version 3.5;
//#include "math.inc"

#macro incenter(v1,v2,v3)
      #local a = vlength(v1-v2);
      #local b = vlength(v2-v3);
      #local c = vlength(v3-v1);
      #local d = (a+b+c);
  #local result = 
      <(a*v1.x + b*v2.x + c*v3.x)/d,
       (a*v1.y + b*v2.y + c*v3.y)/d,
       (a*v1.z + b*v2.z + c*v3.z)/d>;
  result
#end
#macro centroid(v1,v2,v3)
  #local result = (v1+v2+v3)/3;
  result
#end

#macro circumcenter(v1,v2,v3)
      #local a = vlength(v1-v2);
      #local b = vlength(v2-v3);
      #local c = vlength(v3-v1);
      #local sp = (a+b+c)*0.5;

   #local cosineR = ((b*b + c*c - a*a)/(2*b*c))*
      a*b*c/(4*sqrt(sp*(sp-a)*(sp-b)*(sp-c))); //circumradius(a,b,c);
   #local mp = (v1+v2)/2; //midpoint(v1,v2)
   #local result = mp+(vnormalize(vcross(v1-mp,vcross(v3-v2,v1-v2)))*cosineR);
   result
   /* "walks" to cCenter in 3D.
      Algebra core step=cos(angle)*R.
      Input order irrelevant since both (v1-mp)
      and norm vectors reverse in sync */
#end

#macro outcenter(v1,v2,v3)
   circumcenter(v1,v2,v3)
#end 
#macro ccenter(v1,v2,v3)
   circumcenter(v1,v2,v3)
#end 

#macro orthocenter(v1,v2,v3)
      #local a = vlength(v1-v2);
      #local b = vlength(v2-v3);
      #local c = vlength(v3-v1);
      #local sp = (a+b+c)*0.5;

   #local cosineR = ((b*b + c*c - a*a)/(2*b*c))*
      a*b*c/(4*sqrt(sp*(sp-a)*(sp-b)*(sp-c))); //circumradius(a,b,c);
   #local mp = (v1+v2)/2; //midpoint(v1,v2)
   #local cc = mp+(vnormalize(vcross(v1-mp,vcross(v3-v2,v1-v2)))*cosineR);
   
   #local result = ((v1-cc)+(v2-cc)+(v3-cc)) + cc;
   result
#end

#declare inneradius = function(a,b,c) {
   //(3 lens)
   0.5*sqrt(((b+c-a)*(c+a-b)*(a+b-c)) / (a+b+c))
}

#declare circumradius = function(a,b,c) {
  //(3 lens)
  a*b*c/(4*sqrt(((a+b+c)/2)*(((a+b+c)/2)-a)*(((a+b+c)/2)-b)*(((a+b+c)/2)-c)))
  //(a*b*c) / (4*sss_area(a,b,c))  
}

#declare sas_area = function(s,a,s2) {
   0.5 * s * sin(a) * s2
}

#declare sas_cos = function(s,a,s2) {
   sqrt((pow(s,2)+pow(s2,2))-2*s*s2*cos(a))
} // Side Angle Side - solve length of missing side


#declare sas_height = function(s,a,s2) {
    0.5*s*sin(a)*s2/(sqrt((pow(s,2)+pow(s2,2))-2*s*s2*cos(a))*0.5)
   //sas_area(s,a,s2) / (sas_cos(s,a,s2) * 0.5)
} // SAS height to missing side


#declare bh_area = function(b,h) {
   //(base,height)
   0.5 * b * h
}

#declare sss_height = function(a,b,c) {
  sqrt(((a+b+c)/2)*(((a+b+c)/2)-a)*(((a+b+c)/2)-b)*(((a+b+c)/2)-c))/(b*0.5)
  //sss_area(a,b,c) / (b * 0.5)
} // height to side2

#declare sss_area = function(a,b,c) {
   //semi perimeter
   sqrt(((a+b+c)/2)*(((a+b+c)/2)-a)*(((a+b+c)/2)-b)*(((a+b+c)/2)-c))
}

#declare vmyv = function {
   transform {
     rotate <0, 0, 0>
     scale 1
   }
}

#declare aas_sin = function(a,b,s) {
   sin(b) * (s / sin(a))
} // AAS solve opposing side of angle2 (b)

#declare asa_sin = function(a,s,b) {
   sin(b) * (s / sin(pi-(a+b)))
} // ASA solve opposing side of angle2 (b)

#declare sss_cos = function(a,b,c) {
   acos((pow(a,2)+pow(c,2)-pow(b,2))/(2*a*c))
} // SSS solve angle opposite side2 (b)
  // if (pow(a,2)+pow(c,2)-pow(b,2))/(2*a*c) < 0 obtuse

#declare ssa_acute = function(s,s2,a) {
   asin(s2*sin(a)/s)
} // SSA solve angle opposite side2

/*
alias sss_area2 {
  ; (3 lens)
  return $calc(0.5 * ($1 + $2 + $3) * $inneradius($1,$2,$3))
}
alias sss_area3 {
  ; (3 lens)
  return $calc(($1 * $2 * $3) / (4 * $circumradius($1,$2,$3)))
}*/

/* help file stuff
#declare Count=0;
 #while (Count < 5)
  object { MyObject translate x*3*Count }
  #declare Count=Count+1;
 #end
*/
/*
  2*area/(a+b+c) where side lens are abc
  distance(D) of o(circumcenter) and i(incenter) = D = sqrt(R(R-2r)) R=outer or circumrad
  if circumcenter O has coordinates (0,0)
  then orthocenter H has coordinates ( x1+x2+x3 , y1+y2+y3 )
  if ABC lie on the unit circle, we have: (a1)^2 + (b1)^2 = (a2)^2 + (b2)^2 = (a3)^2 + (b3)^2 = 1 */


/*
%tri.a 383 156
%tri.b 645 254
%tri.c 465 289
%tri.ab 279.72843974111748
%tri.bc 183.3712082089225
%tri.ca 156.24659996300718
%tri.ang.a 0.660369
%tri.ang.b 0.549982
%tri.ang.c 1.931241
  //e $ssa-obtuse(156.24659,279.728439,0.549982) == 1.931241 */
#macro ssa_obtuse(s,s2,a)
  // SSA solve ang opposite side2
  #local h = sin(a) * s2;
  #if (h = s2) // given right angle
     #local result = asin(h/s);
  #else
     #if (h = s) // right triangle solved
        #local result = pi/2;
     #else
        #if (s = s2) // isosceles triangle
           #local result = a;
        #else
  // if (s < h) // no solution return no solution
  // if ((%h < $1) && ($1 < $2)) _e two distinct solutions
  // if 3 sides known:
  // if (pow(a,2)+pow(c,2)-pow(b,2))/(2*a*c) < 0 obtuse sss_cos
  //obtuse
  #local result = pi - asin(h/s);
  #end
  #end
  #end
  result
#end

#macro sa_height(s,a)
// (side,angle) unknown base
  #local h = sin(a) * s;
  #if (a < pi)
     #local result = h;
  #else
     #local result = 0;
  #end
  result
#end
#macro _clamp(a,n,m)
   #local result = a;
   #if (a < n) #local result = n;
   #end
   #if (a > m) #local result = m;
   #end
   result
#end

#macro normal_vector(v1,v2,v3)
  vcross(v3-v2,v1-v2)
 // 1
 // |
 // 2__ 3 vz points at you (neg) unless reverse y like pov, then
 //
 // 2__ 3
 // |
 // 1
#end


// functions must appear first, but not macros
// no function dependency, order irrelevant
// no operation redundancy
// no unnecessary stack set
// if result not set, available to macros but failed to echo to message tab
#macro midpoint(v1,v2)
  #local result = (v1+v2)/2;
  result
#end

/*

******************************************************************************
Triangulation.inc

3D Macros:
  incenter(v1,v2,v3)
  centroid(v1,v2,v3)
  ccenter(v1,v2,v3)      circumcenter
  orthocenter(v1,v2,v3)
  normal_vector(v1,v2,v3)
  midpoint(v1,v2)


Functions:
  inneradius(a,b,c)
  circumradius(a,b,c)
  
  sss_area(a,b,c)
  sas_area(s,a,s2)
  bh_area(b,h)           Base Height

  sss_height(a,b,c)      height to side2
  sas_cos(s,a,s2)        Side Angle Side - solve length of missing side

  aas_sin(a,b,s)         AAS solve opposing side of angle2 (b)
  asa_sin(a,s,b)         ASA solve opposing side of angle2 (b)
  sss_cos(a,b,c)         SSS solve angle opposite side2    (b)
  ssa_acute(s,s2,a)      SSA solve angle opposite side2 
  
Float Macros:
  ssa_obtuse(s,s2,a)
  sa_height(s,a)         Side Angle unknown base
  _clamp(a,n,m)
     

*******************************************************************************

*/