#include "colors.inc"
#include "shapes.inc"
#include "shapesq.inc"
#include "debug.inc"
#include "transforms.inc"
Set_Debug(on)

#declare tclock = clock;
#declare orbit_radius = 4.0;
#declare torus_radius = 2.2;
//((orbit_radius*2*pi) / (1*2*pi)) rolls = 4.0
#declare rolls = 4.0;
//dist to travel / circumference of the sphere
//((orbit_radius*2*pi) / (sphere_radius*2*pi)) rolls = 4.0 as long as sphere_radius=1
#declare deg2rad = function(d) {
 d / 57.295779513082323
 //radians()
}
#declare rad2deg = function(r) {
 r * 57.295779513082323
 //degrees()
}
#include "triangulation.inc"
#declare mz = vaxis_rotate(vaxis_rotate(vaxis_rotate(z,x,60),
   x,abs(cos(_clamp(tclock - 0.5,0.0,0.5)*pi)-1)*-60),
   y,360*tclock);
#declare my = vaxis_rotate(vaxis_rotate(vaxis_rotate(y,x,60),
   x,abs(cos(_clamp(tclock - 0.5,0.0,0.5)*pi)-1)*-60),
   y,360*tclock);  
#declare mx = vnormalize(vcross(my,mz));  //x_axis = |_ up_eye
Debug_Message(concat("\n**************** ",str(mx.x,2,3)," ",str(mx.y,2,3)," ",str(mx.z,2,3)," **************** "))
// or print to render window for which example in vect2.pov

#declare point_len = function(d,or,tr) {
 aas_sin(deg2rad(d),pi/2,or)
  - (sin(_clamp(tclock - .5,0,.5)*pi) * (tr+1)) +
  (
  50*_clamp(tclock - 0.9,0,0.1) *
  abs(cos(_clamp(tclock - 0.9,0,0.1)*5*pi)-1)
  )
/* follow torus radius last 1/2 clock, quickly at first then more slowly (curve 1:1)
   1=earth radius.
   
   If eliptical curve:
   Input known x or y and radii into quad curve func:
   Fx: X + (Y*R/B) = R  r=xwidthradius b=yheightofarc and r==b for circle
   x=sqrt(r - (y*r/b)) y=sqrt(r - x) * (b/r) */
}
#declare pl = point_len(60,orbit_radius,torus_radius);
#declare A_point = vrotate(vaxis_rotate(vaxis_rotate(z,x,-30)
   // sink into torus last half on a curve
   x,abs(cos(_clamp(tclock - 0.5,0,0.5)*pi)-1)*30 + 
   
  // drop off 90 degrees last 10 frames on a curve, slow then fast
  90*10*_clamp(tclock - 0.9,0,0.1)*
   abs(cos(_clamp(tclock - 0.9,0,0.1)*5*pi)-1)
   
   ) 
   ,360*tclock*y)*pl;
   // rot y-axis

// 0-1  
// abs(cos(_clamp(tclock - 0.75,0,0.25)*2*pi)-1)
/*
#declare Vector_Arrow=
 union{
   cylinder{<0,0,0>,3.1*z,.15}
   cone{3.1*z,.4,3.6*z,0}
 }*/


object {
   Witch_Hat
   /*texture {
    pigment{ CadetBlue }
    finish { ambient .4 }
    }*/
   texture {
   pigment {
       radial
       color_map {
          [0 Green]
          [0.025 White]
          [0.05 Green]
          [0.05 Clear]
          [1 Clear]
       }
       frequency 24
       //scale 0.0005
   }
   finish { ambient .4 }
   }
   texture {
   pigment {
       uv_mapping 
       gradient y
       color_map {
          [0 Green]
          [0.025 White]
          [0.05 Green]
          [0.05 Clear]
          [1 Clear]
       }
       scale 0.25
   }
   finish { ambient .4 }
   }         /*
   texture { 
   pigment {
       onion 
       color_map {
          [0 Green]
          [0.025 White]
          [0.05 Green]
          [0.05 Clear]
          [1 Clear]
       }
       scale .01
   }
   }       */
   scale 9.6
   translate <0,2.96,0>   
}


#declare P_IM_Earth = pigment {
  image_map {
    png "earth"
    map_type 1
    interpolate 2
  }
}
sphere {
    <0, 0, 0>, 1
    //pigment {checker color CadetBlue, color White scale 0.5}
    pigment {P_IM_Earth}
    finish {  ambient .5 }
    Shear_Trans(mx,my,mz)

    Axis_Rotate_Trans(my,-360* rolls *tclock)

    translate A_point
}
camera {
    location <0, 3, -20>
    look_at <0, 0, 0>
    rotate <13,0,0>
    angle 33
}
light_source { <20, 20, -20> color White*1.5 }
//light_source { <-20, 20, -20> color White*1 }