//*PMRawBegin
#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "skies.inc"

background { rgb <0.1, 0.3, 0.8> }
//*PMRawEnd

#declare spsw1 = sphere_sweep {
   b_spline,
   5,
   <-0.40968, 1.7476, 0>,0.3
   <-0.99657, 0.76459, 0>,0.0379071
   <0.8977, -0.29003, 0>,0.33126
   <-0.63688, -2.1113, 0>,0.40355
   <0.93487, -2.4318, 0>,0.30576
   tolerance 0.1
   rotate y*90
   translate y*3.5
}

global_settings {
   adc_bailout 0.0039216
   assumed_gamma 1.5
   max_trace_level 256
   noise_generator 2
}

union {
   //*PMName Tisch
   
   union {
      //*PMName Fuss rechts/vorn
      //*PMRawBegin
      Round_Cylinder(0,<0,1,0>,0.5,0.0155,1)
      Round_Cylinder(0,<0,0.8,0>,0.83,0.0155,1)
      Round_Cylinder(0,<0,0.6,0>,1.16,0.0155,1)
      Round_Cylinder(0,<0,0.4,0>,1.49,0.0155,1)
      Round_Cylinder(0,<0,0.2,0>,1.82,0.0155,1)
      Round_Cylinder(<0,-0.1,0>,<0,0.01,0>,2.48,0.0155,1)
      //*PMRawEnd
      translate <5, 0, -8>
   }
   
   union {
      //*PMName Fuss links/vorn
      //*PMRawBegin
      Round_Cylinder(0,<0,1,0>,0.5,0.0155,1)
      Round_Cylinder(0,<0,0.8,0>,0.83,0.0155,1)
      Round_Cylinder(0,<0,0.6,0>,1.16,0.0155,1)
      Round_Cylinder(0,<0,0.4,0>,1.49,0.0155,1)
      Round_Cylinder(0,<0,0.2,0>,1.82,0.0155,1)
      Round_Cylinder(<0,-0.1,0>,<0,0.01,0>,2.48,0.0155,1)
      //*PMRawEnd
      translate <-5, 0, -8>
   }
   
   union {
      //*PMName Fuss rechts/hinten
      //*PMRawBegin
      Round_Cylinder(0,<0,1,0>,0.5,0.0155,1)
      Round_Cylinder(0,<0,0.8,0>,0.83,0.0155,1)
      Round_Cylinder(0,<0,0.6,0>,1.16,0.0155,1)
      Round_Cylinder(0,<0,0.4,0>,1.49,0.0155,1)
      Round_Cylinder(0,<0,0.2,0>,1.82,0.0155,1)
      Round_Cylinder(<0,-0.1,0>,<0,0.01,0>,2.48,0.0155,1)
      //*PMRawEnd
      translate <5, 0, 8>
   }
   
   union {
      //*PMName Fuss links/hinten
      //*PMRawBegin
      Round_Cylinder(0,<0,1,0>,0.5,0.0155,1)
      Round_Cylinder(0,<0,0.8,0>,0.83,0.0155,1)
      Round_Cylinder(0,<0,0.6,0>,1.16,0.0155,1)
      Round_Cylinder(0,<0,0.4,0>,1.49,0.0155,1)
      Round_Cylinder(0,<0,0.2,0>,1.82,0.0155,1)
      Round_Cylinder(<0,-0.1,0>,<0,0.01,0>,2.48,0.0155,1)
      //*PMRawEnd
      translate <-5, 0, 8>
   }
   
   difference {
      //*PMName Bogen rechts
      
      cylinder {
         <0, 0.25, 0>, <0, -0.25, 0>, 8.75
         scale 1
         rotate <90, 90, 0>
         translate x*5
      }
      
      cylinder {
         <0, 0.251, 0>, <0, -0.251, 0>, 8.4
         open
         scale 1
         rotate <90, 90, 0>
         translate x*5
      }
      scale <1, 0.33, 1>
   }
   
   difference {
      //*PMName Bogen links
      
      cylinder {
         <0, 0.25, 0>, <0, -0.25, 0>, 8.75
         scale 1
         rotate <90, 90, 0>
         translate x*(-5)
      }
      
      cylinder {
         <0, 0.251, 0>, <0, -0.251, 0>, 8.4
         open
         scale 1
         rotate <90, 90, 0>
         translate x*(-5)
      }
      scale <1, 0.33, 1>
   }
   
   box {
      //*PMName Halter rechts
      <-0.255, 0, -5>, <0.255, 0.075, 5>
      scale 1
      rotate <0, 0, 0>
      translate <5, 2.825, 0>
   }
   
   box {
      //*PMName Halter links
      <-0.255, 0, -5>, <0.255, 0.075, 5>
      scale 1
      rotate <0, 0, 0>
      translate <-5, 2.825, 0>
   }
   
   difference {
      //*PMName Glasplatte
      
      box {
         <-6, -6, -0.125>, <6, 6, 0>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
         hollow
      }
      
      material {
         //*PMRawBegin
         M_Glass3
         //*PMRawEnd
      }
      
      finish {
         ambient rgb <1, 1, 1.1>
      }
      scale <1, 1.5, 1>
      rotate x*90
      translate y*2.88
      hollow
   }
   
   texture {
      //*PMRawBegin
      Polished_Chrome
      //*PMRawEnd
   }
}

union {
   //*PMName prisma rechts
   
   prism {
      linear_spline
      linear_sweep
      0, 1,
      14,
      <0.5, 1>, <1, 0>, <1, -1.05>, <-1, -1.05>, <-1, 0>, <-0.5, 1>, <0.5, 1>,
      <0.5, 1>, <1, 0>, <0.5, -1>, <-0.5, -1>, <-1, 0>, <-0.5, 1>, <0.5, 1>
      
      texture {
         //*PMRawBegin
         Gold_Metal
         //*PMRawEnd
         
         finish {
            roughness 0.05
            crand 0.025
         }
      }
      rotate x*(-90)
      no_shadow
   }
   
   prism {
      linear_spline
      linear_sweep
      0.1, 0.8,
      7,
      <0.485, 0.95>, <0.95, 0>, <0.485, -0.95>, <-0.485, -0.95>, <-0.95, 0>, <-0.485, 0.95>, <0.485, 0.95>
      
      material {
         //*PMRawBegin
         M_NB_Glass
         //*PMRawEnd
      }
      
      finish {
         ambient rgb <0, 0, 1>
      }
      scale 1
      rotate x*(-90)
      translate <0, 0, 0>
      no_shadow
   }
   translate <0, 4.055, 8.5>
}

union {
   //*PMName prisma links
   
   prism {
      linear_spline
      linear_sweep
      0, 1,
      14,
      <0.5, 1>, <1, 0>, <1, -1.05>, <-1, -1.05>, <-1, 0>, <-0.5, 1>, <0.5, 1>,
      <0.5, 1>, <1, 0>, <0.5, -1>, <-0.5, -1>, <-1, 0>, <-0.5, 1>, <0.5, 1>
      
      texture {
         //*PMRawBegin
         Gold_Metal
         //*PMRawEnd
         
         finish {
            roughness 0.05
            crand 0.025
         }
      }
      rotate x*(-90)
      no_shadow
   }
   
   prism {
      linear_spline
      linear_sweep
      0.1, 0.8,
      7,
      <0.485, 0.95>, <0.95, 0>, <0.485, -0.95>, <-0.485, -0.95>, <-0.95, 0>, <-0.485, 0.95>, <0.485, 0.95>
      
      material {
         //*PMRawBegin
         M_NB_Glass
         //*PMRawEnd
      }
      
      finish {
         ambient rgb <0, 0, 1>
      }
      scale 1
      rotate x*(-90)
      translate <0, 0, 0>
      no_shadow
   }
   rotate y*180
   translate <0, 4.055, -8.5>
}

union {
   //*PMName spheresweep-object
   
   merge {
      cone {
         <0, 7, 0>, 0.2,
         <0, -3.5, 0>, 0.05
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
         no_shadow
         hollow
      }
      
      sphere {
         <0, 0, 0>, 1
         scale 1
         rotate <0, 0, 0>
         translate y*0.5
      }
      
      pigment {
         color rgbt <0, 0, 0, 1>
      }
      
      interior {
         media {
            samples 1,10
            emission rgb <1, 1, 0>
         }
      }
   }
   
   union {
      //*PMRawBegin
      #declare ticker =1;
      #while (ticker<21)
        object {spsw1 translate -1.6*z 
        translate -0.25*ticker*y
        rotate 18*ticker*y}
        #declare ticker= ticker+1;
      #end
      //*PMRawEnd
      
      texture {
         //*PMRawBegin
         Silver_Metal
         //*PMRawEnd
         
         normal {
            agate
            agate_turb 0.5
            scale <0.2, 1.2, 0.2>
         }
         
         finish {
            roughness 0.05
            crand 0.025
            conserve_energy
            
            reflection {
               rgb <0.03, 0.03, 0.03>, rgb <1, 1, 1>
            }
         }
      }
      rotate y*(-27)
      //*PMRawBegin
      rotate -y*360*clock
      //*PMRawEnd
      translate y*0.5
      no_shadow
      hollow
   }
   scale 0.75
   translate y*6.75
}

cone {
   //*PMName Beam
   <-7.7, 0.25, 0>, 0.2,
   <0, 0.25, 0>, 0.01
   
   pigment {
      color rgbt <0, 0, 0, 1>
   }
   
   interior {
      media {
         intervals 1
         samples 1,10
         emission rgb <2, 2, 0>
      }
   }
   scale <1, 1, 0.5>
   rotate y*90
   translate y*3.8667
   hollow
}

cone {
   //*PMName Beam
   <7.7, 0.25, 0>, 0.2,
   <0, 0.25, 0>, 0.01
   
   pigment {
      color rgbt <0, 0, 0, 1>
   }
   
   interior {
      media {
         intervals 1
         samples 1,10
         emission rgb <2, 2, 0>
      }
   }
   scale <1, 1, 0.5>
   rotate y*90
   translate y*3.8667
   hollow
}

intersection {
   //*PMName Pyramide
   
   plane {
      //*PMName Seite 1
      <1, 0, 0>, 1
      rotate z*40
   }
   
   plane {
      //*PMName Seite 2
      <-1, 0, 0>, 1
      rotate z*(-40)
   }
   
   plane {
      //*PMName Seite 3
      <0, 0, 1>, 1
      rotate x*(-40)
   }
   
   plane {
      //*PMName Seite 4
      <0, 0, -1>, 1
      rotate x*40
   }
   
   plane {
      //*PMName Bodenplatte
      <0, -1, 0>, 0.25
      rotate <0, 0, 0>
   }
   
   texture {
      //*PMRawBegin
      Starfield
      scale 2
      //*PMRawEnd
      
      normal {
         brick 
         5
         brick_size <8, 6, 4.5>
         mortar 0.5
         scale 0.05
      }
      
      finish {
         //*PMRawBegin
         Dull
         reflection 0.02
         //*PMRawEnd
      }
   }
   rotate y*45
   scale <0.5, 0.625, 0.5>
   translate y*3.2
}

plane {
   //*PMName Himmel
   <0, 1, 0>, 0
   
   texture {
      uv_mapping
      //*PMRawBegin
      Chrome_Metal
      P_Cloud3 scale 5
      //*PMRawEnd
      
      finish {
         roughness 0.05
         crand 0.02
      }
   }
   rotate <90, -7.5, 0>
   translate z*50
   inverse
}

fog {
   fog_type 2
   distance 60
    rgb <0.811765, 0.811765, 0.811765> 
   turbulence <0.3, 0.3, 0.3>
   omega 0.3
   lambda 0
   fog_offset 0.2
   fog_alt 2
   up <0, 1, 0>
}

plane {
   <0, 1, 0>, 0
   
   texture {
      //*PMRawBegin
      Polished_Chrome
      //*PMRawEnd
      
      normal {
         bozo
         4
         turbulence <0.3, 0.25, 0.25>
         omega 0.3
         scale <0.5, 0.25, 0.5>
      }
   }
   
   finish {
      crand 0.025
      
      reflection {
         rgb <0.03, 0.03, 0.03>, rgb <1, 1, 1>
      }
   }
   scale 1
   rotate <0, 0, 0>
   translate y*(-0.1)
}

light_source {
   <0, 8, -15>, rgb <1, 1, 1>
}

camera {
   perspective
   location <16.0302, 5, -13.6868>
   sky <0, 1, 0>
   direction <0, 0, 1>
   right <1.3333, 0, 0>
   up <0, 1, 0>
   look_at <-4, 0, 1.25>
}