// Cassidy.inc  by Neil Alexander  1998  

//Cassidy the cat for House.inc

// Cassidy is a macro which takes a vector argument
// x-value is head nod; positive=down, negative=up
// y-value is head turn; positive=right, negative=left
// z-value should be zero.

#declare Catbrown = color rgb < 0.4,0.35,0.3>;

/*
difference {
  plane { z,-5
    texture {
      pigment { checker color rgb 0.3, color rgb 0.7 }
      }
    }
  plane {y,0 }
  }

//cylinder { <-8.5,18,-4>,<-8.5,18,4>,1 }

#declare Cam1 = camera {  // side
  angle 40
  location <0, 14, 55>
  look_at <0, 14, 0>
  //orthographic
      }

#declare Cam2 = camera {  // angle
    angle 30
    location <-20, 30, 40>
      look_at <0, 22, 0>
      }

#declare Cam3 = camera {  // back
  location <42,13,0>
  look_at <12,13,0>
  }
  
camera { Cam2 }

light_source {
     <-40, 40, 40> color rgb 1
     shadowless
      }

light_source {
     <-60, 10, 0> color rgb 1
     shadowless
      }
 
*/
#declare Eye = union {
  sphere {  // right eye
      <0, 0, 0>, 0.5
      texture {
        pigment { color rgbf 1 }
        finish { phong 1 phong_size 80 }
        }
      interior { ior 1.5 }
      }
  difference {
    intersection {
      sphere {
        <0, 0, 0>, 0.5
        }
      sphere {
        <0, 0, 0>, 0.5
        scale <1.5,1.5,0.75>
        texture {
          pigment { color rgb <0.5,0.65,0.35>}
          finish { ambient 0.2 }
          }
        }
      }
    cylinder {
      <0,0,0>, <0,0,1>,1
      scale<.1,.2,1>
      texture { pigment { color rgb 0 }}
      }
    }
  }  // end Eye



#macro Cassidy (Pose) // head pose <down, right, 0>
union {
union {  // head
  blob {
    threshold 0.56  
    sphere { <0, 0, 0>, 1, 1 // main
      scale <3.75, 3, 3>
      }
    sphere { <0, 0, 0>, 1, -0.5  // right side
      scale 1.5
      translate <3,0,0>
      }
    sphere { <0, 0, 0>, 1, -0.5  // left side
      scale 1.5
      translate <-3,0,0>
      }
    sphere { <0, 0, 0>, 1, 1  // nape
      scale <2, 1.5, 1>
      rotate <15, 0, 0>
      translate <0, -0.5, -1>
      texture { pigment { color rgb 0 }}
      }
    sphere { <0, 0, 0>, 1, 1  // right cheek
      scale 0.6
      translate <0.25,-0.4,1.6>
      texture {
        pigment { color rgb 1 }
        }
      }
    sphere { <0, 0, 0>, 1, -0.25  // right cheek
      scale 1.5
      translate <1.5,-1.25,1.5>
      }
    sphere { <0, 0, 0>, 1, 1  // left cheek
      scale 0.6
      translate <-0.25,-0.4,1.6>
      texture {
        pigment { color rgb 1 }
        }
      }
    sphere { <0, 0, 0>, 1, -0.25  // left cheek
      scale 1.5
      translate <-1.5,-1.25,1.5>
      }
    cylinder { <0, -0.7, 0.8>, <0, -0.8, 1.6> 0.4, 1  // chin
      texture {
        pigment { color rgb 1 }
        }
      }
    cylinder { <0,0.375,1>,<0,-0.1,1.875>,.375,1  // nose
      texture {
        pigment { gradient z
          color_map {
            [  0.6  color rgb 1]
            [  0.7  color rgb <1,0.5,0.3>]
            } // color_map
          }
        rotate <30,0,0>
        }
      }
    cylinder { <-.7,0.65,.8>,<.7,0.65,.8>,.65,1}  // brow
    sphere { <0, 0, 0>, 0.65, -1  // left eye socket
      scale <1,0.9,1>
      translate <-0.65, 0.45 0.85>
      texture {
        pigment { color rgb 0 }
        }
      }
    sphere { <0, 0, 0>, 0.65, -1   // right eye socket
      scale <1,0.9,1>
      translate <0.65, 0.45, 0.85>
      texture {
        pigment { color rgb 0 }
        }
      }
    sphere { <0,0,0>,1,1  // right ear
      scale <.8,3.75,0.5>
      rotate <20,10,-35>
      translate<.9,.8,-.3>
      }
    sphere { <0,0,0>,0.77,-2  // right ear
      translate <0,-3.25,0>
      rotate <20,10,-35>
      translate<.9,.8,-.3>
      }
    sphere { <0,0,0>,1,1  // right ear
      scale .6
      translate<.9,.9,.3>
      }

     sphere { <0,0,0>,1,-1 // right ear hollow
       scale <.5,2.2,.5>
       rotate <28,20,-25>
       translate<1.1,.9,-.1>
       texture {
        pigment { color rgb 1 }
        }
       }

    sphere { <0,0,0>,1,1  // left ear
      scale <.8,3.75,0.5>
      rotate <20,-10,35>
      translate<-.9,.8,-.3>
      }
    sphere { <0,0,0>,0.77,-2  // left ear
      translate <0,-3.25,0>
      rotate <20,-10,35>
      translate<-.9,.8,-.3>
      }
    sphere { <0,0,0>,1,1  // left ear
      scale .6
      translate<-.9,.9,.3>
      }

     sphere { <0,0,0>,1,-1 // left ear hollow
       scale <.5,2.2,.5>
       rotate <28,-20,25>
       translate<-1.1,.9,-.1>
       texture {
        pigment { color rgb 1 }
        }
       }
    texture {
      pigment {
        radial
        color_map{
          [0 color rgb 0]
          [0.5 color Catbrown]
          [1 color rgb 0]
          }
        frequency 15
        turbulence 0.4
        rotate<80,0,0>
        warp {  // left ear
          black_hole <-1,1,.25>, 2.5
          strength 2
          inverse
          }
        warp {  // right ear
          black_hole <1,1,.25>, 2.5
          strength 2
          inverse
          }
        warp { // left eye
          black_hole <-.7,0,0.8>, 1
          strength 2
          inverse
          }
        warp {  // right eye
          black_hole <.7,0,0.8>, 1
          strength 2
          inverse
          }
        }
      }
    texture {
      pigment {
        radial
        color_map{
          [0.078 color rgb 1]
          [0.109 color rgbf 1]
          [0.891 color rgbf 1]
          [0.922 color rgb 1]
          }
        turbulence 0.2
        rotate<0,-90,0>
        rotate<65,0,0>
        }
      }
    texture {
      pigment {
        gradient z
        color_map {
          [0.078 color rgb 0]
          [0.156 color rgbf <0,0,0,1>]
          }
        turbulence 0.1
        scale 6
        rotate <20,0,0>
        translate <0,0,-2>
        }
      }
    texture {
      pigment {
        gradient y
        color_map {
          [0.125 color rgb 1]
          [0.156 color rgbf 1]
          }
        turbulence 0.2
        scale 6
        rotate <-15,0,0>
        translate <0,-1.75,0>
        }
      }
    }  // end blob

  object { Eye  // right
    rotate <0,0,0>
    translate <0.7,0.4,0.8>
    }
  object { Eye  // left
    rotate <0,0,0>
    translate <-0.7,0.4,0.8>
    }
  scale 1.5
  translate z
  rotate Pose
  rotate <0,-90,0>
  translate<0,25,0>
  }  // end head
  
cylinder { <0,0,0>,<0,0.375,0>,1.781  // collar
    scale <1.125,1,1>
    rotate <15,0,0>
    translate <0,-1.875,-1.125>
    rotate y*-90
    translate<-1,25,0>
    texture { pigment { color rgb <1,0,0> }}
    }
 
blob {  // torso
  threshold 0.56
  sphere { < 0, 0, 0>, 1, 1 // upper body
    scale<6,9,7>
    rotate<0,0,-5>
    translate<0,19,0>
    }  // end upperbody
  sphere { <0, 0, 0>, 1, 1  // hips
    scale<6,8,7>
    texture {
      pigment { 
        gradient y
        color_map {
          [0 color rgb 0]
          [0.25 Catbrown]
          [0.75 color rgb 0]
          }
        turbulence 0.4
        }
      translate <0,-50,0>
      rotate <0,0,-20> // i don't know why - blob pulls textures funny way?
      }
    texture {
      pigment {
        radial
      color_map {
        [0.125 color rgb 0]
        [0.188 color rgbf <0,0,0,1>]
        [0.344 color rgbf 1]
        [0.375 color rgb 1]
        [0.625 color rgb 1]
        [0.656 color rgbf 1]
        [0.812 color rgbf <0,0,0,1>]
        [0.875 color rgb 0]
        }
      turbulence 0.2
      rotate <0,0,-10>
      translate <-6,0,0>
      }
      }
    rotate<0,0,20>
    translate<1.5,10.5,0>
    }  // end hips
  cylinder{<0.25,22.5,0>,<0,25.5,0>,2,1} // neck
  sphere { < 0, 0, 0>, 1, 1 // right shoulder
    scale<1.75,5,1>
    texture {
    pigment { 
      gradient x
      color_map {
        [0 color rgb 0]
        [0.25 Catbrown]
        [0.75 color rgb 0]
        }
      turbulence 0.4
      }
    }
    rotate<-5,0,-55>
    translate<-2,19.5,3>
    }
  cylinder { <-4,18,3>,<-7.75,19,3.5>,1.125,1  // right arm
    texture {
      pigment { 
        gradient x
        color_map {
          [0 color rgb 0]
          [0.25 Catbrown]
          [0.75 color rgb 0]
          }
        turbulence 0.4
        }
      }
    texture {
      pigment {
        gradient x
        color_map {
          [0.125 color rgb 1]
          [0.25 color rgbf 1]
          }
        turbulence 0.4
        scale 8
        translate <-8,0,0>
        }
      }
    }
  sphere { <0,0,0>,1,0.5  // right paw
    scale <2,1,1.125>
    translate <-8.875,19,3.5>
    texture {
      pigment { color rgb 1 }
      }
    }
  sphere { < 0, 0, 0>, 1, 1 // left shoulder
    scale<1.75,5,1>
    texture {
    pigment { 
      gradient x
      color_map {
        [0 color rgb 0]
        [0.25 Catbrown]
        [0.75 color rgb 0]
        }
      turbulence 0.4
      }
    }
    rotate<5,0,-55>
    translate<-2,19.5,-3>
    }
  cylinder { <-4,18,-3>,<-7.75,19,-3.5>,1.125,1  // left arm
    texture {
      pigment { 
        gradient x
        color_map {
          [0 color rgb 0]
          [0.25 Catbrown]
          [0.75 color rgb 0]
          }
        turbulence 0.4
        }
      }
    texture {
      pigment {
        gradient x
        color_map {
          [0.125 color rgb 1]
          [0.25 color rgbf 1]
          }
        turbulence 0.4
        scale 8
        translate <-8,0,0>
        }
      }
    }
  sphere { <0,0,0>,1,0.5  // left paw
    scale <2,1,1.125>
    translate <-8.875,19,-3.5>
    texture {
      pigment { color rgb 1 }
      }
    }
  cylinder { <3,10,0>,<7,7,0>,1.25,1 // tail
    texture {
      pigment { 
        gradient x
        color_map {
          [0 color rgb 0]
          [0.25 Catbrown]
          [0.75 color rgb 0]
          }
        turbulence 0.4
        rotate <0,0,-45>
        }
      }
    }
  sphere { <4,8.5,0>,1.5,1 }
  sphere { <7,7.5,0>,1,1
    texture {
      pigment { color rgb 1 }
      }
    }
  sphere { <0,0,0>,1,-1
    scale <2,1,0.5>
    translate <2.5,7,0>
    }
  sphere { < 0, 0, 0>, 1, 1 // right thigh
    scale<2.75,6,2>
    texture {
      pigment { 
        gradient y
        color_map {
          [0 color rgb 0]
          [0.25 Catbrown]
          [0.75 color rgb 0]
          }
        turbulence 0.4
        }
      }
    texture {
      pigment {
        gradient y
        color_map {
          [0 color rgb 1]
          [0.25 color rgbf 1]
          }
        turbulence 0.4
        scale 10
        translate <0,-6,0>
        }
      }
    rotate<-5,0,0>
    translate<2.5,6,2.875>
    }
  cylinder { <3.5,3,3>,<2,0.5,3.5>,1.25,1 } // right leg
  sphere { <0,0,0>,1,1  // right foot
    scale <1.5,.75,1>
    translate <1.25,0.125,3.5>
    texture {
      pigment { color rgb 1 }
      }
    }
  sphere { <0,0,0>,.75,-.75  // right foot
    translate <1.75,0.25,3.5>
    }
  sphere { < 0, 0, 0>, 1, 1 // left thigh
    scale<2.75,6,2>
    texture {
      pigment { 
        gradient y
        color_map {
          [0 color rgb 0]
          [0.25 Catbrown]
          [0.75 color rgb 0]
          }
        turbulence 0.4
        }
      }
    texture {
      pigment {
        gradient y
        color_map {
          [0 color rgb 1]
          [0.25 color rgbf 1]
          }
        turbulence 0.4
        scale 8
        translate <0,-6,0>
        }
      }
    rotate<5,0,0>
    translate<2.5,6,-2.875>
    }
  cylinder { <3.5,3,-3>,<2,0.5,-3.5>,1.25,1 } // left leg
  sphere { <0,0,0>,1,1  // left foot
    scale <1.5,.75,1>
    translate <1.25,0.125,-3.5>
    texture {
      pigment { color rgb 1 }
      }
    }
  sphere { <0,0,0>,.75,-.75  // left foot
    translate <1.75,0.25,-3.5>
    }
  texture {
    pigment { 
      gradient y
      color_map {
        [0 color rgb 0]
        [0.25 Catbrown]
        [0.75 color rgb 0]
        }
      turbulence 0.4
      translate <0,-30,0>
      }
    }
  texture {
    pigment {
      radial
      color_map {
        [0.125 color rgb 0]
        [0.188 color rgbf <0,0,0,1>]
        [0.375 color rgbf 1]
        [0.406 color rgb 1]
        [0.594 color rgb 1]
        [0.625 color rgbf 1]
        [0.812 color rgbf <0,0,0,1>]
        [0.875 color rgb 0]
        }
      turbulence 0.2
      //rotate <0,0,-3>
      translate <1,0,0>
      }
    }
 
  }
}  // end Cassidy
#end  // end macro

/*
object { Cassidy (<-50,60,0>)
  rotate <0,60,0>
  } 
*/