// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.6
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3.6;

#include "colors.inc"

global_settings {
  assumed_gamma 1.0
}

// ----------------------------------------

camera {
  location  <0.0, 0.5, -4.0>
  direction 1.4*z
  right     x*image_width/image_height
  look_at   <0.0, 0.0,  0.0>
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
  }
}

light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>  // light's color
  translate <-30, 30, -30>
}

// ----------------------------------------

plane {
  y, -1
  pigment { color rgb <0.7,0.5,0.3> }
}


// not stretched, left ball
sphere {
  0.0, 0.5
  translate 0.5 * y
  texture {
    pigment {
        color White
    }
    finish{
      specular 0.6
      roughness 0.005
    }
  }
  
  
  texture {
        pigment {
                image_map {
                        gif "Nine_band.gif"
//                          ===============

                     
                        map_type 2        //  2=cylindrical
                        interpolate 2  
                        once
                }
                scale 0.35                  // cylindrical projection scales ONLY HEIGHT
                translate (1-0.35) / 2 *y   // to center
        }
        finish{
                specular 0.6
                roughness 0.005
        }
  }

  translate -0.5 *x // back to origin
  rotate -90 * y    // to show the middle
  translate -x
}


// STRETCHED, ball to the right
sphere {
  0.0, 0.5
  translate 0.5 * y
  texture {
    pigment {
        color White
    }
    finish{
      specular 0.6
      roughness 0.005
    }
  }
  
  
  texture {
        pigment {
                image_map {
                        gif "Nine_band_shrunk.gif" 
//                           ====================
                        map_type 2        //  2=cylindrical
                        interpolate 2  
                        once
                }
                scale 0.35                  // cylindrical projection scales ONLY HEIGHT
                translate (1-0.35) / 2 *y   // to center
        }
        finish{
                specular 0.6
                roughness 0.005
        }
  }

  translate -0.5 *x // back to origin
  rotate -90 * y    // to show the middle
  translate +x
}


