// -----------------------------------------------------------------------------
// 2024-12-24, lb
// -----------------------------------------------------------------------------
#version 3.8;



// -----------------------------------------------------------------------------
// --- INCLUDES ----------------------------------------------------------------
// -----------------------------------------------------------------------------
#include "colors"
#include "math"
//#include "myMacros"
//#include "stones"



#declare displayAxis = false;
#declare areaLights = false;




// -----------------------------------------------------------------------------
// --- SETTINGS ----------------------------------------------------------------
// -----------------------------------------------------------------------------
global_settings {
	assumed_gamma 1.80
	max_trace_level 5 
	}

#default {
	finish {
		ambient 0.00
		emission 0.40
		diffuse 0.60
		}
	} 


// -----------------------------------------------------------------------------
// --- SCENE -------------------------------------------------------------------
// -----------------------------------------------------------------------------
#declare CameraDistance = 40;
camera {
//	location p2r(40, 20, CameraDistance, true)
	location <29, 14, 24>
	up y
	right x*image_width/image_height
	look_at <0, 0, 0>
	angle 36
	}


// --------------------------------------------------------------------------
// --- area_light size is power of 2 plus 1
// --- 2^2+1 = 5, 2^3+1 = 9, 2^4+1 = 17, 2^5+1=33, 2^6+1=65...
// --------------------------------------------------------------------------
#macro alPower (number) 1+pow(2,number) #end

#declare areaSize = CameraDistance*2;
#declare areaPower = alPower(1);
light_source {
//	p2r(30, 30, 100,true)
	<75, 50, 44>
	color White
	#if (areaLights)
		#debug "\n--- Using area lights\n"
		area_light -<areaSize, 0, areaSize>, +<areaSize, 0, areaSize>, areaPower, areaPower
		adaptive 1
		jitter 
		orient 
		circular 
	#end
	}


sky_sphere {
	pigment {
		function { abs(y) }
		color_map {
			[0.0 color SlateBlue*0.50 ]
			[1.0 color White*1.25 ]
			}
		}
	}

//
//#if (displayAxis)
//	drawAxis(12, 0.03)
//#end



// -----------------------------------------------------------------------------
// --- MATMOD ------------------------------------------------------------------
// -----------------------------------------------------------------------------


// "Mesh Torus ( reference : http://www.povray.org/ ) by Abderrahman Taha 02/11/2019 "



// --- Const -------------------------------------------------------------------
#declare A = 1/2;
#declare B = 7/20;
#declare C = 7/10;
#declare D = 1/5;
#declare E = 1/2;
#declare th = pi/A;
#declare ph = pi/B;



// --- Part 1 ------------------------------------------------------------------
// "r = (x % (A * 2))",
#declare r0 = function(x,y,z,p) { mod(x,A*2) }

// "r = abs( if (r(x,y,z,p) < (0), r(x,y,z,p) + A, r(x,y,z,p) - A)) * C",
#declare r1 = function(x,y,z,p) {
	abs (
		select (
			r0(x,y,z,p),
			r0(x,y,z,p) + A,
			r0(x,y,z,p) - A
			)
		)
	*C
	}

// "r2 = (y - cos(z * ph) * D) * E",
#declare r2 = function(x,y,z,p) { (y - cos(z*ph)*D)*E }

// "temp = -sqrt(r2(x,y,z,p) * r2(x,y,z,p) + r(x,y,z,p) * r(x,y,z,p))",
#declare temp0 = function(x,y,z,p) {
	- sqrt( r2(x,y,z,p)*r2(x,y,z,p) + r1(x,y,z,p)*r1(x,y,z,p) )
	}



// --- Part 2 ------------------------------------------------------------------
//"r = ((x - A) % (A * 2))",
#declare r3 = function(x,y,z,p) { mod(x-A,A*2) }

// "r = abs(if (r(x,y,z,p) < (0), r(x,y,z,p) + A, r(x,y,z,p) - A)) * C",
#declare r4 = function(x,y,z,p) {
	abs (
		select (
			r3(x,y,z,p),
			r3(x,y,z,p) + A,
			r3(x,y,z,p) - A
			)
		)
	*C
	}

// r2 = (y + cos(z * ph) * D) * E",
#declare r5 = function(x,y,z,p) { (y + cos(z*ph)*D)*E }

// temp = max(-sqrt(r2(x,y,z,p) * r2(x,y,z,p) + r(x,y,z,p) * r(x,y,z,p)), temp(x,y,z,p))",
#declare temp1 = function(x,y,z,p) {
	max (
		-sqrt(r5(x,y,z,p)*r5(x,y,z,p) + r4(x,y,z,p)*r4(x,y,z,p)),
		temp0(x,y,z,p)
		)
	}



// --- Part 2 ------------------------------------------------------------------
// "r = (z % (B * 2))",
#declare r6 = function(x,y,z,p) { mod(z,B*2) }

// "r = abs(if (r(x,y,z,p) < (0), r(x,y,z,p) + B, r(x,y,z,p) - B)) * C",
#declare r7 = function(x,y,z,p) {
	abs (
		select (
			r6(x,y,z,p),
			r6(x,y,z,p) + B,
			r6(x,y,z,p) - B
			)
		)
	*C
	}

// "r2 = (y + cos(x * th) * D) * E",
#declare r8 = function(x,y,z,p) { (y + cos(x*th)*D)*E }

// "temp = max(-sqrt(r2(x,y,z,p) * r2(x,y,z,p) + r(x,y,z,p) * r(x,y,z,p)), temp(x,y,z,p))",
#declare temp2 = function(x,y,z,p) {
	max (
		-sqrt(r8(x,y,z,p)*r8(x,y,z,p) + r7(x,y,z,p)*r7(x,y,z,p)),
		temp1(x,y,z,p)
		)
	}



// --- Part 3 ------------------------------------------------------------------
// "r = ((z- B) % (B * 2))",
#declare r9 = function(x,y,z,p) { mod(z-B,B*2) }

// "r = abs(if (r(x,y,z,p) < (0), r(x,y,z,p) + B, r(x,y,z,p) - B)) * C",
#declare r10 = function(x,y,z,p) {
	abs (
		select (
			r9(x,y,z,p),
			r9(x,y,z,p) + B,
			r9(x,y,z,p) - B
			)
		)
	*C
	}

// "r2 = (y - cos(x * th) * D) * E",
#declare r11 = function(x,y,z,p) { (y - cos(x*th)*D)*E }



// --- Part 4 ------------------------------------------------------------------
// fmesh0 = (-max(-sqrt(r2(x,y,z,p) * r2(x,y,z,p) + r(x,y,z,p) * r(x,y,z,p)), temp(x,y,z,p)))",
#declare fmesh0 = function(x,y,z,p) {
	- max (
		-sqrt ( r11(x,y,z,p)*r11(x,y,z,p) + r10(x,y,z,p)*r10(x,y,z,p)),
		temp2 (x,y,z,p)
		)
	}

// fmesh1= -fmesh0(atan2(y,x),sqrt(x*x+y*y)-(4),z,p) +2/25",
#declare fmesh1 = function(x,y,z,p) {
	-fmesh0 (
		atan2(y,x),
		sqrt(x*x+y*y)-4,
		z,
		p
		)
	+ 2/25
	}

// "fmesh2= fmesh1(sqrt(x*x+z*z)-(7),y,2*atan2(z,x),p)"
#declare fmesh2 = function(x,y,z,p) {
	fmesh1 (
		sqrt(x*x+z*z)-7,
		y,
		2*atan2(z,x),
		p
		)
	}

// "Fxyz": fmesh2(x,y,z,p)"
// #declare Fxyz = function(x,y,z,p) { fmesh2(x,y,z,p) }



// --- Domain ------------------------------------------------------------------
#declare Xmax =  12;
#declare Xmin = -12;
#declare Ymax =   5;
#declare Ymin =  -5;
#declare Zmax =  12;
#declare Zmin = -12;



// -----------------------------------------------------------------------------
// --- OBEJCT ------------------------------------------------------------------
// -----------------------------------------------------------------------------

// --- Colors ------------------------------------------------------------------
#declare Paille = rgb <0.923453, 0.913935, 0.801412>;
#declare Paille = rgb <0.971878, 0.967498, 0.788232>;


#declare Texture = texture {
	pigment {
		Paille
		}
	finish {
//		specular 1
//		roughness 0.0005
		metallic 1.0
		brilliance 2
		}
	}

isosurface {
	function { fmesh2(x,y,z,0) }
	max_gradient 2
	contained_by { box { <Xmin, Ymin, Zmin>, <Xmax, Ymax, Zmax> } }
	open
		
	texture { Texture }
	rotate -50*z
	rotate -10*y
	}


// --- eof ---------------------------------------------------------------------
