#default {finish {ambient 0}}

#declare rnd = seed(0);

global_settings {
	radiosity {
		count 250
	}
}

// Units are in feet.
#declare inch=1/12;
#declare inches=inch;


#declare detail_water = 1; // Max 1
#declare detail_garden_lights = 1; // Area light resolution, 15 is good for final
#declare detail_lawn = 1; // Max 1
#declare detail_fence = 1; // Max 1

#include "textures.inc"

#include "pool.inc"
#include "garden_lights.inc"
#include "lawn.inc"
#include "fence.inc"
#include "sky.inc"
#include "fence.inc"

camera {
	location <25,6,-10>
	look_at 0
}

// The grounds
difference {
	plane {y, 0}
	box {<-14,-16,-20>,<14,1,20>}
	pigment {color rgb 1}
}

// water
plane {
	y, -6*inches
	#if (detail_water = 0)
		pigment {color rgb z/3}
	#else
		texture {
			pigment {color transmit 1}
			finish {specular 1/2 reflection 1/4}
			normal {ripples 1/16 scale 2.5}
		}
		interior {ior 4/3}
	#end
}
