#declare garden_light = union {
	cylinder {0, y*4*inches, 1/2*inches}
	torus {4*inches, inch/4 translate y*4*inches}
	torus {4*inches, inch/4 translate y*6*inches}
	torus {4*inches, inch/4 translate y*8*inches}
	cone {y*8.25*inches, 4*inches, y*9*inches, 2*inches}
	cylinder {y*4*inches, y*8*inches, inch/4 translate z*4*inches rotate y*045}
	cylinder {y*4*inches, y*8*inches, inch/4 translate z*4*inches rotate y*135}
	cylinder {y*4*inches, y*8*inches, inch/4 translate z*4*inches rotate y*225}
	cylinder {y*4*inches, y*8*inches, inch/4 translate z*4*inches rotate y*315}
	cylinder {-z*4*inches,z*4*inches, inch/4 translate y*4*inches rotate y*045}
	cylinder {-z*4*inches,z*4*inches, inch/4 translate y*4*inches rotate y*-45}
	light_source {
		y*6*inches color rgb <6,5,4>/15
		#if (detail_garden_lights > 1)
			area_light x*inch,y*inch,detail_garden_lights,detail_garden_lights
			adaptive 1
			circular orient
		#end
		fade_distance 2
		fade_power 2
		looks_like {
			sphere{
				0, inch
				pigment {color rgb <6,5,4>/5}
				finish {ambient 1}
			}
		}
	}
	texture {
		pigment {color rgb 0}
		finish {specular 1}
	}
}

#declare c = -22;
#while (c <= 22)
	object {garden_light translate <-16,0,c>}
	object {garden_light translate < 16,0,c>}
#declare c = c + 11;
#end

#declare c = -7;
#while (c <= 7)
	object {garden_light translate <c,0,-22>}
	object {garden_light translate <c,0, 22>}
#declare c = c + 7;
#end
