#include "HEAD2_POV_geom.inc"

global_settings {
  ambient_light 0
  photons {
    count 50000
    max_trace_level 10
    autostop 0
    jitter 0
  }
}

//Aero's textures

#declare eyemirror = texture {
  pigment {color rgbt 1}
  finish {reflection 1}
}

#declare eyeglow = texture {
  pigment { color rgbt <0.9,0.1,0.1,0.8> }
  finish {
    reflection 0.1
    ambient 0
    diffuse 0.9
  }
}


camera {
  location <0, 05, -10>
  look_at <0, 1, 0>
}


light_source {
  <30, 10, 20>
  color rgb <1.5, 1.5, 1.5>
  
  parallel
  point_at 0
  
  photons {
    reflection on
    refraction on
  }
}

light_source {
  <-50, 10, 0>
  color rgb <0.5, 0.5, 01.>
  
  parallel
  point_at 0
  
  photons {
    reflection off
    refraction off
  }
}

light_source {
  <20, 10, -30>
  color rgb <1, 0.75, 0.75>
  
  parallel
  point_at 0
  
  photons {
    reflection off
    refraction off
  }
}

plane {
  <0, 01, 0>, 0
  texture {
    pigment {checker color rgb 3 color rgb 0.5 scale 2}
    finish {
      brilliance 0.5
      diffuse 0.1
      reflection 0.1
      specular 0.75
      roughness 0.001
    }
  }
}


superellipsoid {
  <0.05, 0.05>
  translate y * 1.00001
  scale 2
  rotate y * 30
  texture{
    pigment { color rgbt 0.75 }
    normal {bumps 0.1 scale 0.2}
    finish {
       brilliance 0.5
       diffuse 0.1
       reflection 0.25
       specular 0.75
       roughness 0.001
    }
  }

  interior {
    ior 1.4
    dispersion 1.1
  }
  
  photons {
     target
     refraction on
     reflection on
     collect off
   }
}



union {
  // Sam's head in a ball
  
  difference {
      object{
        HEAD2_  rotate 155*y rotate 30*x scale .0625 translate <0, 3, -.5>
      }
      sphere {
        <0,3.5,-1>
        0.21
        texture { eyemirror }
      }
      sphere {
        <0.68,3.35,-0.74>
        0.21
        texture { eyemirror }
      }
    photons {
      target
      refraction on
      reflection on
      collect off
    }
  }
  
  
  // End of Sam's Head
  
  // Aero's eyes
  sphere {
    <0,3.5,-1>
    0.20
    texture { eyeglow }
    photons {
      target
      reflection on
      refraction on
      collect off
    }
  }
  
  sphere {
    <0.68,3.35,-0.74>
    0.20
    texture { eyeglow }
    photons {
      target
      reflection on
      refraction on
      collect off
    }
  }
  
  difference {
    sphere {
      <0,3.5,-1>
      0.22
    }
    sphere {
      <0,3.5,-1.02>
      0.23
    }
    texture { eyemirror }
  }
  
  difference {
    sphere {
      <0.68,3.35,-0.74>
      0.22
    }
    sphere {
      <0.68,3.35,-0.76>
      0.23
    }
    texture { eyemirror }
  }
  
  translate y * -1.
}

/* Connects the straight and curved parts of the earpiece. */
#declare connector = 
intersection {
  prism {
    conic_sweep
    linear_spline
    0,
    01,
    5,
    <0.375, 0.375>
    <-.375, 0.375>
    <-.375, -.375>
    <0.375, -.375>
    <0.375, 0.375>
    rotate x * 180
    translate y
  }
  
  box {
    <0.125, 0, 0.125>
    <-.125, 1, -.375>
  }
  
  translate <0.125, 0, -0.125>
};


/*
Each lens_frame constitutes one lens rim, and the hinge that the earpiece
connects to.
*/
#declare lens_frame =
union {
  union {
    difference {
      /* Rim. */
      prism {
        cubic_spline
        0,
        0.25,
        10,
        <0.,-05>
        <0,0> <-5, 01>, <-7, 0>, <-6.25, -0.5>, <-4.5, -2.3>, <-3, -2.75>, <-1.4, -2.3>, <0, 0>, <-5, 0.1>
      }
      
      /* Cut out the hole for the lens. */
      union {
        difference {
          /* Top half of the lens. */
          cylinder {
            <0, -1, 0>,
            <0, 2, 0>,
            2
          }
          
          /* Not part of the top half of the lens (subtracted out). */
          box {
            <-3, -1, 00>
            <03, 03, 03>
          }
          
  
          scale x * 1.1
          translate <-2.9, 0, -0.6>
        }
        
        difference {
          /* Bottom half of the lens. */
          cylinder {
            <0, -1, 0>,
            <0, 2, 0>,
            2
          }
          
          /* Not part of the bottom half of the lens (subtracted out). */
          box {
            <-3, -1, 00>
            <03, 03, -3>
          }
          scale <1.1, 1, 0.7>
          translate <-2.9, 0, -0.65>
        }
      }
    }
    sphere_sweep {
      cubic_spline
      10
      <00.00, 0.125, -05.0>, 0.125,
      <00.00, 0.125, 000.0>, 0.125,
      <-5.00, 0.125, 001.0>, 0.125,
      <-7.00, 0.125, 000.0>, 0.125,
      <-6.25, 0.125, -0.50>, 0.125,
      <-4.50, 0.125, -2.30>, 0.125,
      <-3.00, 0.125, -2.75>, 0.125,
      <-1.40, 0.125, -2.30>, 0.125,
      <00.00, 0.125, 00000>, 0.125,
      <-5.00, 0.125, 0.100>, 0.125
    }
    /* Hinge for the earpiece. */
    box {
      <-5.25, 0, 0.5>
      <-5.5, -1.25, 1>
    }
    
    
    
    /* Rinestones. */
    union {
      sphere {
        <-5.5, 0.25, 0.5>, 0.125
      }
  
      sphere {
        <-5.5, 0.25, 0>, 0.125
      }
  
      sphere {
        <-5.5, 0.25, -0.5>, 0.125
      }
      
      sphere {
        <-6., 0.25, 0.25>, 0.125
      }
      
      sphere {
        <-6., 0.25, -0.25>, 0.125
      }
      
      sphere {
        <-6.5, 0.25, 0>, 0.125
      }
      
      /*
      The texture looks real nice when it's reflecting something other than solid
      white. :-P
      */
      texture {
        pigment {color rgbt <.5, .5, 0.5, 0.75>}
        normal {
          facets 0.2
          size 0.75
        }
        finish {
          phong 2
          specular 0.5
          reflection {1}
        }
      }
      interior {ior 1.5}
    }
    
    /* Make the lenses be upright. */
    rotate x * -90
  }
  
  /* Earpiece. */
  box {
    <-5.25, 01, 1.25>
    <-5.5,  0.5, 8.5>
  }
  object {
    connector
    rotate x * 90
    rotate z * 180
    translate <-5.25, 01, 8.5>
  }
  difference {
    torus {
      3, 0.125
      rotate x * 90
    }
    box {
      <-10, 010, 1>
      <000, -10, -1>
    }
    box {
      <-1, 00, .2>
      <04, -4, -1>
    }
    rotate y * -90
    translate <-5.375, -02.125, 9>
  }
  sphere {
    0, 0.25
    scale <0.5, 1, 0.75>
    translate <-5.375, -2.125, 12>
  }
  /* End earpiece. */
};


/* The glasses! */
union {
  union {
    /* Right lens. */
    object {
      lens_frame
    }
    
    translate -0.5 * x
    rotate y * 7
  }
  /* Nose piece. */
  difference {
    cylinder {
      <0, .75, 0.6>,
      <0, -1.75, 0.6>,
      1
    }
    cylinder {
      <0, 1.5, 0.6>
      <0, -02, 0.6>
      0.75
    }
    box {
      <-1, 1.5, 0.15>
      <01, -02, 1.6>
    }
    cylinder {
      <0, -01.75, -2>,
      <0, -01.75, 02>,
      1
    }
    cylinder {
      <0, 0.75, -2>
      <0, 0.75, 02>
      0.5
      scale <2, 1, 1>
    }
  }
  /* End nose piece. */
  /* Left lens. */
  union {
    object {
      lens_frame
    }

    /* Mirror it so that its right to be the left side. */
    translate -0.5 * x
    rotate y * 7
    scale -x
  }
  
  translate y * 2.85
  scale 0.9
  rotate <15, -30, -15>
  translate <01.5, 9.5, -07>
  scale 0.2
  texture {
    pigment {color rgb <2, 0.1, 0.2>}
    finish {
      phong 0.5
      specular 0.1
    }
  }
}
