// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
// set viewer's position in the scene
camera
{
// (camera types)
//  perspective (default) | orthographic | fisheye |
//  ultra_wide_angle | omnimax | panoramic | cylinder 1
  location  <0.0, 4.0, -6.0> // position of camera <X Y Z>
  direction 2.0*z            // which way are we looking <X Y Z> & zoom
//  sky       y                // rarely used
  up        y                // which way is +up <X Y Z>
  right     4/3*x            // which way is +right <X Y Z> and aspect ratio
  look_at   <0.0, 0.0,  0.0> // point center of view at this point <X Y Z>
//  angle FLOAT                // overrides "direction" with specific angle
//  normal { ripples 0.2 }     // perturb the camera lens with a pattern
// (focal blur extras)
//  aperture 0.2               // 0...N (bigger is narrower depth of field)
//  blur_samples 4             // # of rays per pixel
//  focal_point <VECTOR>       // x,y,z point that is in focus
}
// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-20, 40, -20>
}
   
 
   // An infinite planar surface
// plane {<A, B, C>, D } where: A*x + B*y + C*z = D
plane
{
  y, // <X Y Z> unit surface normal, vector points "away from surface"
  0.0 // distance from the origin in the direction of the surface normal
pigment {White}}

#declare BALL_RADIUS=0.4;
#declare BALL_INSERTION=1;
#declare BALL_TRANSLATION=<-2,0,0>;
#declare BALL_NO=9;
#include "poolball2.inc"

#declare BALL_RADIUS=0.4;
#declare BALL_INSERTION=1;
#declare BALL_TRANSLATION=<-1,0,0>;
#declare BALL_NO=10;
#include "poolball2.inc"

#declare BALL_RADIUS=0.4;
#declare BALL_INSERTION=1;
#declare BALL_TRANSLATION=<0,0,0>;
#declare BALL_NO=11;
#include "poolball2.inc"

#declare BALL_RADIUS=0.4;
#declare BALL_INSERTION=1;
#declare BALL_TRANSLATION=<1,0,0>;
#declare BALL_NO=12;
#include "poolball2.inc"

#declare BALL_RADIUS=0.4;
#declare BALL_INSERTION=1;
#declare BALL_TRANSLATION=<-2,0,1>;
#declare BALL_NO=13;
#include "poolball2.inc"

#declare BALL_RADIUS=0.4;
#declare BALL_INSERTION=1;
#declare BALL_TRANSLATION=<-1,0,1>;
#declare BALL_NO=14;
#include "poolball2.inc"

#declare BALL_RADIUS=0.4;
#declare BALL_INSERTION=1;
#declare BALL_TRANSLATION=<0,0,1>;
#declare BALL_NO=15;
#include "poolball2.inc"

#declare BALL_RADIUS=0.4;
#declare BALL_INSERTION=1;
#declare BALL_TRANSLATION=<1,0,1>;
#declare BALL_NO=0;
#include "poolball2.inc"
  

#declare BALL_RADIUS=0.4;
#declare BALL_INSERTION=1;
#declare BALL_TRANSLATION=<-2,0,-2>;
#declare BALL_NO=1;
#include "poolball2.inc"

#declare BALL_RADIUS=0.4;
#declare BALL_INSERTION=1;
#declare BALL_TRANSLATION=<-1,0,-2>;
#declare BALL_NO=2;
#include "poolball2.inc"

#declare BALL_RADIUS=0.4;
#declare BALL_INSERTION=1;
#declare BALL_TRANSLATION=<0,0,-2>;
#declare BALL_NO=3;
#include "poolball2.inc"

#declare BALL_RADIUS=0.4;
#declare BALL_INSERTION=1;
#declare BALL_TRANSLATION=<1,0,-2>;
#declare BALL_NO=4;
#include "poolball2.inc"

#declare BALL_RADIUS=0.4;
#declare BALL_INSERTION=1;
#declare BALL_TRANSLATION=<-2,0,-1>;
#declare BALL_NO=5;
#include "poolball2.inc"

#declare BALL_RADIUS=0.4;
#declare BALL_INSERTION=1;
#declare BALL_TRANSLATION=<-1,0,-1>;
#declare BALL_NO=6;
#include "poolball2.inc"

#declare BALL_RADIUS=0.4;
#declare BALL_INSERTION=1;
#declare BALL_TRANSLATION=<0,0,-1>;
#declare BALL_NO=7;
#include "poolball2.inc"

#declare BALL_RADIUS=0.4;
#declare BALL_INSERTION=1;
#declare BALL_TRANSLATION=<1,0,-1>;
#declare BALL_NO=8;
#include "poolball2.inc"
  