//------------------------------------------------------------------------
//
// Persistence of Vision Ray Tracer version 3.8
// Scene Description Language (SDL)
// 
// Colormaps declarations
//
// Number of colormaps: 10
// Number of colors in each: 256
//
// File: colormaps.inc
// Version: 1.0
// Last updated: 13-Feb-2023
//
// Author: Sergey Yanenko "Yesbird", 2023
// e-mail: See posts in news.povray.org
//
//------------------------------------------------------------------------

//
// Make colormap
//
#macro make_colormap (_arr, _f, _t)

	#local len = dimension_size (_arr, 1)-1;
	#local _color_map = 
	color_map {
		#for (I, 0, len)
  		#local _color = <_arr[I][1].x, _arr[I][1].y, _arr[I][1].z, _f, _t>;
  		[_arr [I][0], rgbft _color]
		#end
	}
	
	_color_map
#end

//
// Spring
//
#declare spring = array mixed [256][2] {

{0.0000, <1.00,0.00,1.00>}
{0.0039, <1.00,0.00,1.00>}
{0.0078, <1.00,0.01,0.99>}
{0.0118, <1.00,0.01,0.99>}
{0.0157, <1.00,0.02,0.98>}
{0.0196, <1.00,0.02,0.98>}
{0.0235, <1.00,0.02,0.98>}
{0.0275, <1.00,0.03,0.97>}
{0.0314, <1.00,0.03,0.97>}
{0.0353, <1.00,0.04,0.96>}
{0.0392, <1.00,0.04,0.96>}
{0.0431, <1.00,0.04,0.96>}
{0.0471, <1.00,0.05,0.95>}
{0.0510, <1.00,0.05,0.95>}
{0.0549, <1.00,0.05,0.95>}
{0.0588, <1.00,0.06,0.94>}
{0.0627, <1.00,0.06,0.94>}
{0.0667, <1.00,0.07,0.93>}
{0.0706, <1.00,0.07,0.93>}
{0.0745, <1.00,0.07,0.93>}
{0.0784, <1.00,0.08,0.92>}
{0.0824, <1.00,0.08,0.92>}
{0.0863, <1.00,0.09,0.91>}
{0.0902, <1.00,0.09,0.91>}
{0.0941, <1.00,0.09,0.91>}
{0.0980, <1.00,0.10,0.90>}
{0.1020, <1.00,0.10,0.90>}
{0.1059, <1.00,0.11,0.89>}
{0.1098, <1.00,0.11,0.89>}
{0.1137, <1.00,0.11,0.89>}
{0.1176, <1.00,0.12,0.88>}
{0.1216, <1.00,0.12,0.88>}
{0.1255, <1.00,0.13,0.87>}
{0.1294, <1.00,0.13,0.87>}
{0.1333, <1.00,0.13,0.87>}
{0.1373, <1.00,0.14,0.86>}
{0.1412, <1.00,0.14,0.86>}
{0.1451, <1.00,0.15,0.85>}
{0.1490, <1.00,0.15,0.85>}
{0.1529, <1.00,0.15,0.85>}
{0.1569, <1.00,0.16,0.84>}
{0.1608, <1.00,0.16,0.84>}
{0.1647, <1.00,0.16,0.84>}
{0.1686, <1.00,0.17,0.83>}
{0.1725, <1.00,0.17,0.83>}
{0.1765, <1.00,0.18,0.82>}
{0.1804, <1.00,0.18,0.82>}
{0.1843, <1.00,0.18,0.82>}
{0.1882, <1.00,0.19,0.81>}
{0.1922, <1.00,0.19,0.81>}
{0.1961, <1.00,0.20,0.80>}
{0.2000, <1.00,0.20,0.80>}
{0.2039, <1.00,0.20,0.80>}
{0.2078, <1.00,0.21,0.79>}
{0.2118, <1.00,0.21,0.79>}
{0.2157, <1.00,0.22,0.78>}
{0.2196, <1.00,0.22,0.78>}
{0.2235, <1.00,0.22,0.78>}
{0.2275, <1.00,0.23,0.77>}
{0.2314, <1.00,0.23,0.77>}
{0.2353, <1.00,0.24,0.76>}
{0.2392, <1.00,0.24,0.76>}
{0.2431, <1.00,0.24,0.76>}
{0.2471, <1.00,0.25,0.75>}
{0.2510, <1.00,0.25,0.75>}
{0.2549, <1.00,0.25,0.75>}
{0.2588, <1.00,0.26,0.74>}
{0.2627, <1.00,0.26,0.74>}
{0.2667, <1.00,0.27,0.73>}
{0.2706, <1.00,0.27,0.73>}
{0.2745, <1.00,0.27,0.73>}
{0.2784, <1.00,0.28,0.72>}
{0.2824, <1.00,0.28,0.72>}
{0.2863, <1.00,0.29,0.71>}
{0.2902, <1.00,0.29,0.71>}
{0.2941, <1.00,0.29,0.71>}
{0.2980, <1.00,0.30,0.70>}
{0.3020, <1.00,0.30,0.70>}
{0.3059, <1.00,0.31,0.69>}
{0.3098, <1.00,0.31,0.69>}
{0.3137, <1.00,0.31,0.69>}
{0.3176, <1.00,0.32,0.68>}
{0.3216, <1.00,0.32,0.68>}
{0.3255, <1.00,0.33,0.67>}
{0.3294, <1.00,0.33,0.67>}
{0.3333, <1.00,0.33,0.67>}
{0.3373, <1.00,0.34,0.66>}
{0.3412, <1.00,0.34,0.66>}
{0.3451, <1.00,0.35,0.65>}
{0.3490, <1.00,0.35,0.65>}
{0.3529, <1.00,0.35,0.65>}
{0.3569, <1.00,0.36,0.64>}
{0.3608, <1.00,0.36,0.64>}
{0.3647, <1.00,0.36,0.64>}
{0.3686, <1.00,0.37,0.63>}
{0.3725, <1.00,0.37,0.63>}
{0.3765, <1.00,0.38,0.62>}
{0.3804, <1.00,0.38,0.62>}
{0.3843, <1.00,0.38,0.62>}
{0.3882, <1.00,0.39,0.61>}
{0.3922, <1.00,0.39,0.61>}
{0.3961, <1.00,0.40,0.60>}
{0.4000, <1.00,0.40,0.60>}
{0.4039, <1.00,0.40,0.60>}
{0.4078, <1.00,0.41,0.59>}
{0.4118, <1.00,0.41,0.59>}
{0.4157, <1.00,0.42,0.58>}
{0.4196, <1.00,0.42,0.58>}
{0.4235, <1.00,0.42,0.58>}
{0.4275, <1.00,0.43,0.57>}
{0.4314, <1.00,0.43,0.57>}
{0.4353, <1.00,0.44,0.56>}
{0.4392, <1.00,0.44,0.56>}
{0.4431, <1.00,0.44,0.56>}
{0.4471, <1.00,0.45,0.55>}
{0.4510, <1.00,0.45,0.55>}
{0.4549, <1.00,0.45,0.55>}
{0.4588, <1.00,0.46,0.54>}
{0.4627, <1.00,0.46,0.54>}
{0.4667, <1.00,0.47,0.53>}
{0.4706, <1.00,0.47,0.53>}
{0.4745, <1.00,0.47,0.53>}
{0.4784, <1.00,0.48,0.52>}
{0.4824, <1.00,0.48,0.52>}
{0.4863, <1.00,0.49,0.51>}
{0.4902, <1.00,0.49,0.51>}
{0.4941, <1.00,0.49,0.51>}
{0.4980, <1.00,0.50,0.50>}
{0.5020, <1.00,0.50,0.50>}
{0.5059, <1.00,0.51,0.49>}
{0.5098, <1.00,0.51,0.49>}
{0.5137, <1.00,0.51,0.49>}
{0.5176, <1.00,0.52,0.48>}
{0.5216, <1.00,0.52,0.48>}
{0.5255, <1.00,0.53,0.47>}
{0.5294, <1.00,0.53,0.47>}
{0.5333, <1.00,0.53,0.47>}
{0.5373, <1.00,0.54,0.46>}
{0.5412, <1.00,0.54,0.46>}
{0.5451, <1.00,0.55,0.45>}
{0.5490, <1.00,0.55,0.45>}
{0.5529, <1.00,0.55,0.45>}
{0.5569, <1.00,0.56,0.44>}
{0.5608, <1.00,0.56,0.44>}
{0.5647, <1.00,0.56,0.44>}
{0.5686, <1.00,0.57,0.43>}
{0.5725, <1.00,0.57,0.43>}
{0.5765, <1.00,0.58,0.42>}
{0.5804, <1.00,0.58,0.42>}
{0.5843, <1.00,0.58,0.42>}
{0.5882, <1.00,0.59,0.41>}
{0.5922, <1.00,0.59,0.41>}
{0.5961, <1.00,0.60,0.40>}
{0.6000, <1.00,0.60,0.40>}
{0.6039, <1.00,0.60,0.40>}
{0.6078, <1.00,0.61,0.39>}
{0.6118, <1.00,0.61,0.39>}
{0.6157, <1.00,0.62,0.38>}
{0.6196, <1.00,0.62,0.38>}
{0.6235, <1.00,0.62,0.38>}
{0.6275, <1.00,0.63,0.37>}
{0.6314, <1.00,0.63,0.37>}
{0.6353, <1.00,0.64,0.36>}
{0.6392, <1.00,0.64,0.36>}
{0.6431, <1.00,0.64,0.36>}
{0.6471, <1.00,0.65,0.35>}
{0.6510, <1.00,0.65,0.35>}
{0.6549, <1.00,0.65,0.35>}
{0.6588, <1.00,0.66,0.34>}
{0.6627, <1.00,0.66,0.34>}
{0.6667, <1.00,0.67,0.33>}
{0.6706, <1.00,0.67,0.33>}
{0.6745, <1.00,0.67,0.33>}
{0.6784, <1.00,0.68,0.32>}
{0.6824, <1.00,0.68,0.32>}
{0.6863, <1.00,0.69,0.31>}
{0.6902, <1.00,0.69,0.31>}
{0.6941, <1.00,0.69,0.31>}
{0.6980, <1.00,0.70,0.30>}
{0.7020, <1.00,0.70,0.30>}
{0.7059, <1.00,0.71,0.29>}
{0.7098, <1.00,0.71,0.29>}
{0.7137, <1.00,0.71,0.29>}
{0.7176, <1.00,0.72,0.28>}
{0.7216, <1.00,0.72,0.28>}
{0.7255, <1.00,0.73,0.27>}
{0.7294, <1.00,0.73,0.27>}
{0.7333, <1.00,0.73,0.27>}
{0.7373, <1.00,0.74,0.26>}
{0.7412, <1.00,0.74,0.26>}
{0.7451, <1.00,0.75,0.25>}
{0.7490, <1.00,0.75,0.25>}
{0.7529, <1.00,0.75,0.25>}
{0.7569, <1.00,0.76,0.24>}
{0.7608, <1.00,0.76,0.24>}
{0.7647, <1.00,0.76,0.24>}
{0.7686, <1.00,0.77,0.23>}
{0.7725, <1.00,0.77,0.23>}
{0.7765, <1.00,0.78,0.22>}
{0.7804, <1.00,0.78,0.22>}
{0.7843, <1.00,0.78,0.22>}
{0.7882, <1.00,0.79,0.21>}
{0.7922, <1.00,0.79,0.21>}
{0.7961, <1.00,0.80,0.20>}
{0.8000, <1.00,0.80,0.20>}
{0.8039, <1.00,0.80,0.20>}
{0.8078, <1.00,0.81,0.19>}
{0.8118, <1.00,0.81,0.19>}
{0.8157, <1.00,0.82,0.18>}
{0.8196, <1.00,0.82,0.18>}
{0.8235, <1.00,0.82,0.18>}
{0.8275, <1.00,0.83,0.17>}
{0.8314, <1.00,0.83,0.17>}
{0.8353, <1.00,0.84,0.16>}
{0.8392, <1.00,0.84,0.16>}
{0.8431, <1.00,0.84,0.16>}
{0.8471, <1.00,0.85,0.15>}
{0.8510, <1.00,0.85,0.15>}
{0.8549, <1.00,0.85,0.15>}
{0.8588, <1.00,0.86,0.14>}
{0.8627, <1.00,0.86,0.14>}
{0.8667, <1.00,0.87,0.13>}
{0.8706, <1.00,0.87,0.13>}
{0.8745, <1.00,0.87,0.13>}
{0.8784, <1.00,0.88,0.12>}
{0.8824, <1.00,0.88,0.12>}
{0.8863, <1.00,0.89,0.11>}
{0.8902, <1.00,0.89,0.11>}
{0.8941, <1.00,0.89,0.11>}
{0.8980, <1.00,0.90,0.10>}
{0.9020, <1.00,0.90,0.10>}
{0.9059, <1.00,0.91,0.09>}
{0.9098, <1.00,0.91,0.09>}
{0.9137, <1.00,0.91,0.09>}
{0.9176, <1.00,0.92,0.08>}
{0.9216, <1.00,0.92,0.08>}
{0.9255, <1.00,0.93,0.07>}
{0.9294, <1.00,0.93,0.07>}
{0.9333, <1.00,0.93,0.07>}
{0.9373, <1.00,0.94,0.06>}
{0.9412, <1.00,0.94,0.06>}
{0.9451, <1.00,0.95,0.05>}
{0.9490, <1.00,0.95,0.05>}
{0.9529, <1.00,0.95,0.05>}
{0.9569, <1.00,0.96,0.04>}
{0.9608, <1.00,0.96,0.04>}
{0.9647, <1.00,0.96,0.04>}
{0.9686, <1.00,0.97,0.03>}
{0.9725, <1.00,0.97,0.03>}
{0.9765, <1.00,0.98,0.02>}
{0.9804, <1.00,0.98,0.02>}
{0.9843, <1.00,0.98,0.02>}
{0.9882, <1.00,0.99,0.01>}
{0.9922, <1.00,0.99,0.01>}
{0.9961, <1.00,1.00,0.00>}
{1.0000, <1.00,1.00,0.00>}
}

//
// Jet
//

#declare jet = array mixed [256][2] {

{0.0000, <0.00,0.00,0.52>}
{0.0039, <0.00,0.00,0.53>}
{0.0078, <0.00,0.00,0.55>}
{0.0118, <0.00,0.00,0.56>}
{0.0157, <0.00,0.00,0.58>}
{0.0196, <0.00,0.00,0.59>}
{0.0235, <0.00,0.00,0.61>}
{0.0275, <0.00,0.00,0.63>}
{0.0314, <0.00,0.00,0.64>}
{0.0353, <0.00,0.00,0.66>}
{0.0392, <0.00,0.00,0.67>}
{0.0431, <0.00,0.00,0.69>}
{0.0471, <0.00,0.00,0.70>}
{0.0510, <0.00,0.00,0.72>}
{0.0549, <0.00,0.00,0.73>}
{0.0588, <0.00,0.00,0.75>}
{0.0627, <0.00,0.00,0.77>}
{0.0667, <0.00,0.00,0.78>}
{0.0706, <0.00,0.00,0.80>}
{0.0745, <0.00,0.00,0.81>}
{0.0784, <0.00,0.00,0.83>}
{0.0824, <0.00,0.00,0.84>}
{0.0863, <0.00,0.00,0.86>}
{0.0902, <0.00,0.00,0.88>}
{0.0941, <0.00,0.00,0.89>}
{0.0980, <0.00,0.00,0.91>}
{0.1020, <0.00,0.00,0.92>}
{0.1059, <0.00,0.00,0.94>}
{0.1098, <0.00,0.00,0.95>}
{0.1137, <0.00,0.00,0.97>}
{0.1176, <0.00,0.00,0.98>}
{0.1216, <0.00,0.00,1.00>}
{0.1255, <0.00,0.02,1.00>}
{0.1294, <0.00,0.03,1.00>}
{0.1333, <0.00,0.05,1.00>}
{0.1373, <0.00,0.06,1.00>}
{0.1412, <0.00,0.08,1.00>}
{0.1451, <0.00,0.09,1.00>}
{0.1490, <0.00,0.11,1.00>}
{0.1529, <0.00,0.13,1.00>}
{0.1569, <0.00,0.14,1.00>}
{0.1608, <0.00,0.16,1.00>}
{0.1647, <0.00,0.17,1.00>}
{0.1686, <0.00,0.19,1.00>}
{0.1725, <0.00,0.20,1.00>}
{0.1765, <0.00,0.22,1.00>}
{0.1804, <0.00,0.23,1.00>}
{0.1843, <0.00,0.25,1.00>}
{0.1882, <0.00,0.27,1.00>}
{0.1922, <0.00,0.28,1.00>}
{0.1961, <0.00,0.30,1.00>}
{0.2000, <0.00,0.31,1.00>}
{0.2039, <0.00,0.33,1.00>}
{0.2078, <0.00,0.34,1.00>}
{0.2118, <0.00,0.36,1.00>}
{0.2157, <0.00,0.38,1.00>}
{0.2196, <0.00,0.39,1.00>}
{0.2235, <0.00,0.41,1.00>}
{0.2275, <0.00,0.42,1.00>}
{0.2314, <0.00,0.44,1.00>}
{0.2353, <0.00,0.45,1.00>}
{0.2392, <0.00,0.47,1.00>}
{0.2431, <0.00,0.48,1.00>}
{0.2471, <0.00,0.50,1.00>}
{0.2510, <0.00,0.52,1.00>}
{0.2549, <0.00,0.53,1.00>}
{0.2588, <0.00,0.55,1.00>}
{0.2627, <0.00,0.56,1.00>}
{0.2667, <0.00,0.58,1.00>}
{0.2706, <0.00,0.59,1.00>}
{0.2745, <0.00,0.61,1.00>}
{0.2784, <0.00,0.63,1.00>}
{0.2824, <0.00,0.64,1.00>}
{0.2863, <0.00,0.66,1.00>}
{0.2902, <0.00,0.67,1.00>}
{0.2941, <0.00,0.69,1.00>}
{0.2980, <0.00,0.70,1.00>}
{0.3020, <0.00,0.72,1.00>}
{0.3059, <0.00,0.73,1.00>}
{0.3098, <0.00,0.75,1.00>}
{0.3137, <0.00,0.77,1.00>}
{0.3176, <0.00,0.78,1.00>}
{0.3216, <0.00,0.80,1.00>}
{0.3255, <0.00,0.81,1.00>}
{0.3294, <0.00,0.83,1.00>}
{0.3333, <0.00,0.84,1.00>}
{0.3373, <0.00,0.86,1.00>}
{0.3412, <0.00,0.88,1.00>}
{0.3451, <0.00,0.89,1.00>}
{0.3490, <0.00,0.91,1.00>}
{0.3529, <0.00,0.92,1.00>}
{0.3569, <0.00,0.94,1.00>}
{0.3608, <0.00,0.95,1.00>}
{0.3647, <0.00,0.97,1.00>}
{0.3686, <0.00,0.98,1.00>}
{0.3725, <0.00,1.00,1.00>}
{0.3765, <0.02,1.00,0.98>}
{0.3804, <0.03,1.00,0.97>}
{0.3843, <0.05,1.00,0.95>}
{0.3882, <0.06,1.00,0.94>}
{0.3922, <0.08,1.00,0.92>}
{0.3961, <0.09,1.00,0.91>}
{0.4000, <0.11,1.00,0.89>}
{0.4039, <0.13,1.00,0.88>}
{0.4078, <0.14,1.00,0.86>}
{0.4118, <0.16,1.00,0.84>}
{0.4157, <0.17,1.00,0.83>}
{0.4196, <0.19,1.00,0.81>}
{0.4235, <0.20,1.00,0.80>}
{0.4275, <0.22,1.00,0.78>}
{0.4314, <0.23,1.00,0.77>}
{0.4353, <0.25,1.00,0.75>}
{0.4392, <0.27,1.00,0.73>}
{0.4431, <0.28,1.00,0.72>}
{0.4471, <0.30,1.00,0.70>}
{0.4510, <0.31,1.00,0.69>}
{0.4549, <0.33,1.00,0.67>}
{0.4588, <0.34,1.00,0.66>}
{0.4627, <0.36,1.00,0.64>}
{0.4667, <0.38,1.00,0.63>}
{0.4706, <0.39,1.00,0.61>}
{0.4745, <0.41,1.00,0.59>}
{0.4784, <0.42,1.00,0.58>}
{0.4824, <0.44,1.00,0.56>}
{0.4863, <0.45,1.00,0.55>}
{0.4902, <0.47,1.00,0.53>}
{0.4941, <0.48,1.00,0.52>}
{0.4980, <0.50,1.00,0.50>}
{0.5020, <0.52,1.00,0.48>}
{0.5059, <0.53,1.00,0.47>}
{0.5098, <0.55,1.00,0.45>}
{0.5137, <0.56,1.00,0.44>}
{0.5176, <0.58,1.00,0.42>}
{0.5216, <0.59,1.00,0.41>}
{0.5255, <0.61,1.00,0.39>}
{0.5294, <0.63,1.00,0.38>}
{0.5333, <0.64,1.00,0.36>}
{0.5373, <0.66,1.00,0.34>}
{0.5412, <0.67,1.00,0.33>}
{0.5451, <0.69,1.00,0.31>}
{0.5490, <0.70,1.00,0.30>}
{0.5529, <0.72,1.00,0.28>}
{0.5569, <0.73,1.00,0.27>}
{0.5608, <0.75,1.00,0.25>}
{0.5647, <0.77,1.00,0.23>}
{0.5686, <0.78,1.00,0.22>}
{0.5725, <0.80,1.00,0.20>}
{0.5765, <0.81,1.00,0.19>}
{0.5804, <0.83,1.00,0.17>}
{0.5843, <0.84,1.00,0.16>}
{0.5882, <0.86,1.00,0.14>}
{0.5922, <0.88,1.00,0.13>}
{0.5961, <0.89,1.00,0.11>}
{0.6000, <0.91,1.00,0.09>}
{0.6039, <0.92,1.00,0.08>}
{0.6078, <0.94,1.00,0.06>}
{0.6118, <0.95,1.00,0.05>}
{0.6157, <0.97,1.00,0.03>}
{0.6196, <0.98,1.00,0.02>}
{0.6235, <1.00,1.00,0.00>}
{0.6275, <1.00,0.98,0.00>}
{0.6314, <1.00,0.97,0.00>}
{0.6353, <1.00,0.95,0.00>}
{0.6392, <1.00,0.94,0.00>}
{0.6431, <1.00,0.92,0.00>}
{0.6471, <1.00,0.91,0.00>}
{0.6510, <1.00,0.89,0.00>}
{0.6549, <1.00,0.88,0.00>}
{0.6588, <1.00,0.86,0.00>}
{0.6627, <1.00,0.84,0.00>}
{0.6667, <1.00,0.83,0.00>}
{0.6706, <1.00,0.81,0.00>}
{0.6745, <1.00,0.80,0.00>}
{0.6784, <1.00,0.78,0.00>}
{0.6824, <1.00,0.77,0.00>}
{0.6863, <1.00,0.75,0.00>}
{0.6902, <1.00,0.73,0.00>}
{0.6941, <1.00,0.72,0.00>}
{0.6980, <1.00,0.70,0.00>}
{0.7020, <1.00,0.69,0.00>}
{0.7059, <1.00,0.67,0.00>}
{0.7098, <1.00,0.66,0.00>}
{0.7137, <1.00,0.64,0.00>}
{0.7176, <1.00,0.63,0.00>}
{0.7216, <1.00,0.61,0.00>}
{0.7255, <1.00,0.59,0.00>}
{0.7294, <1.00,0.58,0.00>}
{0.7333, <1.00,0.56,0.00>}
{0.7373, <1.00,0.55,0.00>}
{0.7412, <1.00,0.53,0.00>}
{0.7451, <1.00,0.52,0.00>}
{0.7490, <1.00,0.50,0.00>}
{0.7529, <1.00,0.48,0.00>}
{0.7569, <1.00,0.47,0.00>}
{0.7608, <1.00,0.45,0.00>}
{0.7647, <1.00,0.44,0.00>}
{0.7686, <1.00,0.42,0.00>}
{0.7725, <1.00,0.41,0.00>}
{0.7765, <1.00,0.39,0.00>}
{0.7804, <1.00,0.38,0.00>}
{0.7843, <1.00,0.36,0.00>}
{0.7882, <1.00,0.34,0.00>}
{0.7922, <1.00,0.33,0.00>}
{0.7961, <1.00,0.31,0.00>}
{0.8000, <1.00,0.30,0.00>}
{0.8039, <1.00,0.28,0.00>}
{0.8078, <1.00,0.27,0.00>}
{0.8118, <1.00,0.25,0.00>}
{0.8157, <1.00,0.23,0.00>}
{0.8196, <1.00,0.22,0.00>}
{0.8235, <1.00,0.20,0.00>}
{0.8275, <1.00,0.19,0.00>}
{0.8314, <1.00,0.17,0.00>}
{0.8353, <1.00,0.16,0.00>}
{0.8392, <1.00,0.14,0.00>}
{0.8431, <1.00,0.13,0.00>}
{0.8471, <1.00,0.11,0.00>}
{0.8510, <1.00,0.09,0.00>}
{0.8549, <1.00,0.08,0.00>}
{0.8588, <1.00,0.06,0.00>}
{0.8627, <1.00,0.05,0.00>}
{0.8667, <1.00,0.03,0.00>}
{0.8706, <1.00,0.02,0.00>}
{0.8745, <1.00,0.00,0.00>}
{0.8784, <0.98,0.00,0.00>}
{0.8824, <0.97,0.00,0.00>}
{0.8863, <0.95,0.00,0.00>}
{0.8902, <0.94,0.00,0.00>}
{0.8941, <0.92,0.00,0.00>}
{0.8980, <0.91,0.00,0.00>}
{0.9020, <0.89,0.00,0.00>}
{0.9059, <0.88,0.00,0.00>}
{0.9098, <0.86,0.00,0.00>}
{0.9137, <0.84,0.00,0.00>}
{0.9176, <0.83,0.00,0.00>}
{0.9216, <0.81,0.00,0.00>}
{0.9255, <0.80,0.00,0.00>}
{0.9294, <0.78,0.00,0.00>}
{0.9333, <0.77,0.00,0.00>}
{0.9373, <0.75,0.00,0.00>}
{0.9412, <0.73,0.00,0.00>}
{0.9451, <0.72,0.00,0.00>}
{0.9490, <0.70,0.00,0.00>}
{0.9529, <0.69,0.00,0.00>}
{0.9569, <0.67,0.00,0.00>}
{0.9608, <0.66,0.00,0.00>}
{0.9647, <0.64,0.00,0.00>}
{0.9686, <0.63,0.00,0.00>}
{0.9725, <0.61,0.00,0.00>}
{0.9765, <0.59,0.00,0.00>}
{0.9804, <0.58,0.00,0.00>}
{0.9843, <0.56,0.00,0.00>}
{0.9882, <0.55,0.00,0.00>}
{0.9922, <0.53,0.00,0.00>}
{0.9961, <0.52,0.00,0.00>}
{1.0000, <0.50,0.00,0.00>}
}

//
// Hot
//
#declare hot = array mixed [256][2] {

{0.0000, <0.01,0.00,0.00>}
{0.0039, <0.02,0.00,0.00>}
{0.0078, <0.03,0.00,0.00>}
{0.0118, <0.04,0.00,0.00>}
{0.0157, <0.05,0.00,0.00>}
{0.0196, <0.06,0.00,0.00>}
{0.0235, <0.07,0.00,0.00>}
{0.0275, <0.08,0.00,0.00>}
{0.0314, <0.09,0.00,0.00>}
{0.0353, <0.10,0.00,0.00>}
{0.0392, <0.11,0.00,0.00>}
{0.0431, <0.13,0.00,0.00>}
{0.0471, <0.14,0.00,0.00>}
{0.0510, <0.15,0.00,0.00>}
{0.0549, <0.16,0.00,0.00>}
{0.0588, <0.17,0.00,0.00>}
{0.0627, <0.18,0.00,0.00>}
{0.0667, <0.19,0.00,0.00>}
{0.0706, <0.20,0.00,0.00>}
{0.0745, <0.21,0.00,0.00>}
{0.0784, <0.22,0.00,0.00>}
{0.0824, <0.23,0.00,0.00>}
{0.0863, <0.24,0.00,0.00>}
{0.0902, <0.25,0.00,0.00>}
{0.0941, <0.26,0.00,0.00>}
{0.0980, <0.27,0.00,0.00>}
{0.1020, <0.28,0.00,0.00>}
{0.1059, <0.29,0.00,0.00>}
{0.1098, <0.30,0.00,0.00>}
{0.1137, <0.31,0.00,0.00>}
{0.1176, <0.32,0.00,0.00>}
{0.1216, <0.33,0.00,0.00>}
{0.1255, <0.34,0.00,0.00>}
{0.1294, <0.35,0.00,0.00>}
{0.1333, <0.36,0.00,0.00>}
{0.1373, <0.38,0.00,0.00>}
{0.1412, <0.39,0.00,0.00>}
{0.1451, <0.40,0.00,0.00>}
{0.1490, <0.41,0.00,0.00>}
{0.1529, <0.42,0.00,0.00>}
{0.1569, <0.43,0.00,0.00>}
{0.1608, <0.44,0.00,0.00>}
{0.1647, <0.45,0.00,0.00>}
{0.1686, <0.46,0.00,0.00>}
{0.1725, <0.47,0.00,0.00>}
{0.1765, <0.48,0.00,0.00>}
{0.1804, <0.49,0.00,0.00>}
{0.1843, <0.50,0.00,0.00>}
{0.1882, <0.51,0.00,0.00>}
{0.1922, <0.52,0.00,0.00>}
{0.1961, <0.53,0.00,0.00>}
{0.2000, <0.54,0.00,0.00>}
{0.2039, <0.55,0.00,0.00>}
{0.2078, <0.56,0.00,0.00>}
{0.2118, <0.57,0.00,0.00>}
{0.2157, <0.58,0.00,0.00>}
{0.2196, <0.59,0.00,0.00>}
{0.2235, <0.60,0.00,0.00>}
{0.2275, <0.61,0.00,0.00>}
{0.2314, <0.63,0.00,0.00>}
{0.2353, <0.64,0.00,0.00>}
{0.2392, <0.65,0.00,0.00>}
{0.2431, <0.66,0.00,0.00>}
{0.2471, <0.67,0.00,0.00>}
{0.2510, <0.68,0.00,0.00>}
{0.2549, <0.69,0.00,0.00>}
{0.2588, <0.70,0.00,0.00>}
{0.2627, <0.71,0.00,0.00>}
{0.2667, <0.72,0.00,0.00>}
{0.2706, <0.73,0.00,0.00>}
{0.2745, <0.74,0.00,0.00>}
{0.2784, <0.75,0.00,0.00>}
{0.2824, <0.76,0.00,0.00>}
{0.2863, <0.77,0.00,0.00>}
{0.2902, <0.78,0.00,0.00>}
{0.2941, <0.79,0.00,0.00>}
{0.2980, <0.80,0.00,0.00>}
{0.3020, <0.81,0.00,0.00>}
{0.3059, <0.82,0.00,0.00>}
{0.3098, <0.83,0.00,0.00>}
{0.3137, <0.84,0.00,0.00>}
{0.3176, <0.85,0.00,0.00>}
{0.3216, <0.86,0.00,0.00>}
{0.3255, <0.88,0.00,0.00>}
{0.3294, <0.89,0.00,0.00>}
{0.3333, <0.90,0.00,0.00>}
{0.3373, <0.91,0.00,0.00>}
{0.3412, <0.92,0.00,0.00>}
{0.3451, <0.93,0.00,0.00>}
{0.3490, <0.94,0.00,0.00>}
{0.3529, <0.95,0.00,0.00>}
{0.3569, <0.96,0.00,0.00>}
{0.3608, <0.97,0.00,0.00>}
{0.3647, <0.98,0.00,0.00>}
{0.3686, <0.99,0.00,0.00>}
{0.3725, <1.00,0.00,0.00>}
{0.3765, <1.00,0.01,0.00>}
{0.3804, <1.00,0.02,0.00>}
{0.3843, <1.00,0.03,0.00>}
{0.3882, <1.00,0.04,0.00>}
{0.3922, <1.00,0.05,0.00>}
{0.3961, <1.00,0.06,0.00>}
{0.4000, <1.00,0.07,0.00>}
{0.4039, <1.00,0.08,0.00>}
{0.4078, <1.00,0.09,0.00>}
{0.4118, <1.00,0.10,0.00>}
{0.4157, <1.00,0.11,0.00>}
{0.4196, <1.00,0.13,0.00>}
{0.4235, <1.00,0.14,0.00>}
{0.4275, <1.00,0.15,0.00>}
{0.4314, <1.00,0.16,0.00>}
{0.4353, <1.00,0.17,0.00>}
{0.4392, <1.00,0.18,0.00>}
{0.4431, <1.00,0.19,0.00>}
{0.4471, <1.00,0.20,0.00>}
{0.4510, <1.00,0.21,0.00>}
{0.4549, <1.00,0.22,0.00>}
{0.4588, <1.00,0.23,0.00>}
{0.4627, <1.00,0.24,0.00>}
{0.4667, <1.00,0.25,0.00>}
{0.4706, <1.00,0.26,0.00>}
{0.4745, <1.00,0.27,0.00>}
{0.4784, <1.00,0.28,0.00>}
{0.4824, <1.00,0.29,0.00>}
{0.4863, <1.00,0.30,0.00>}
{0.4902, <1.00,0.31,0.00>}
{0.4941, <1.00,0.32,0.00>}
{0.4980, <1.00,0.33,0.00>}
{0.5020, <1.00,0.34,0.00>}
{0.5059, <1.00,0.35,0.00>}
{0.5098, <1.00,0.36,0.00>}
{0.5137, <1.00,0.38,0.00>}
{0.5176, <1.00,0.39,0.00>}
{0.5216, <1.00,0.40,0.00>}
{0.5255, <1.00,0.41,0.00>}
{0.5294, <1.00,0.42,0.00>}
{0.5333, <1.00,0.43,0.00>}
{0.5373, <1.00,0.44,0.00>}
{0.5412, <1.00,0.45,0.00>}
{0.5451, <1.00,0.46,0.00>}
{0.5490, <1.00,0.47,0.00>}
{0.5529, <1.00,0.48,0.00>}
{0.5569, <1.00,0.49,0.00>}
{0.5608, <1.00,0.50,0.00>}
{0.5647, <1.00,0.51,0.00>}
{0.5686, <1.00,0.52,0.00>}
{0.5725, <1.00,0.53,0.00>}
{0.5765, <1.00,0.54,0.00>}
{0.5804, <1.00,0.55,0.00>}
{0.5843, <1.00,0.56,0.00>}
{0.5882, <1.00,0.57,0.00>}
{0.5922, <1.00,0.58,0.00>}
{0.5961, <1.00,0.59,0.00>}
{0.6000, <1.00,0.60,0.00>}
{0.6039, <1.00,0.61,0.00>}
{0.6078, <1.00,0.63,0.00>}
{0.6118, <1.00,0.64,0.00>}
{0.6157, <1.00,0.65,0.00>}
{0.6196, <1.00,0.66,0.00>}
{0.6235, <1.00,0.67,0.00>}
{0.6275, <1.00,0.68,0.00>}
{0.6314, <1.00,0.69,0.00>}
{0.6353, <1.00,0.70,0.00>}
{0.6392, <1.00,0.71,0.00>}
{0.6431, <1.00,0.72,0.00>}
{0.6471, <1.00,0.73,0.00>}
{0.6510, <1.00,0.74,0.00>}
{0.6549, <1.00,0.75,0.00>}
{0.6588, <1.00,0.76,0.00>}
{0.6627, <1.00,0.77,0.00>}
{0.6667, <1.00,0.78,0.00>}
{0.6706, <1.00,0.79,0.00>}
{0.6745, <1.00,0.80,0.00>}
{0.6784, <1.00,0.81,0.00>}
{0.6824, <1.00,0.82,0.00>}
{0.6863, <1.00,0.83,0.00>}
{0.6902, <1.00,0.84,0.00>}
{0.6941, <1.00,0.85,0.00>}
{0.6980, <1.00,0.86,0.00>}
{0.7020, <1.00,0.88,0.00>}
{0.7059, <1.00,0.89,0.00>}
{0.7098, <1.00,0.90,0.00>}
{0.7137, <1.00,0.91,0.00>}
{0.7176, <1.00,0.92,0.00>}
{0.7216, <1.00,0.93,0.00>}
{0.7255, <1.00,0.94,0.00>}
{0.7294, <1.00,0.95,0.00>}
{0.7333, <1.00,0.96,0.00>}
{0.7373, <1.00,0.97,0.00>}
{0.7412, <1.00,0.98,0.00>}
{0.7451, <1.00,0.99,0.00>}
{0.7490, <1.00,1.00,0.00>}
{0.7529, <1.00,1.00,0.02>}
{0.7569, <1.00,1.00,0.03>}
{0.7608, <1.00,1.00,0.05>}
{0.7647, <1.00,1.00,0.06>}
{0.7686, <1.00,1.00,0.08>}
{0.7725, <1.00,1.00,0.09>}
{0.7765, <1.00,1.00,0.11>}
{0.7804, <1.00,1.00,0.13>}
{0.7843, <1.00,1.00,0.14>}
{0.7882, <1.00,1.00,0.16>}
{0.7922, <1.00,1.00,0.17>}
{0.7961, <1.00,1.00,0.19>}
{0.8000, <1.00,1.00,0.20>}
{0.8039, <1.00,1.00,0.22>}
{0.8078, <1.00,1.00,0.23>}
{0.8118, <1.00,1.00,0.25>}
{0.8157, <1.00,1.00,0.27>}
{0.8196, <1.00,1.00,0.28>}
{0.8235, <1.00,1.00,0.30>}
{0.8275, <1.00,1.00,0.31>}
{0.8314, <1.00,1.00,0.33>}
{0.8353, <1.00,1.00,0.34>}
{0.8392, <1.00,1.00,0.36>}
{0.8431, <1.00,1.00,0.38>}
{0.8471, <1.00,1.00,0.39>}
{0.8510, <1.00,1.00,0.41>}
{0.8549, <1.00,1.00,0.42>}
{0.8588, <1.00,1.00,0.44>}
{0.8627, <1.00,1.00,0.45>}
{0.8667, <1.00,1.00,0.47>}
{0.8706, <1.00,1.00,0.48>}
{0.8745, <1.00,1.00,0.50>}
{0.8784, <1.00,1.00,0.52>}
{0.8824, <1.00,1.00,0.53>}
{0.8863, <1.00,1.00,0.55>}
{0.8902, <1.00,1.00,0.56>}
{0.8941, <1.00,1.00,0.58>}
{0.8980, <1.00,1.00,0.59>}
{0.9020, <1.00,1.00,0.61>}
{0.9059, <1.00,1.00,0.63>}
{0.9098, <1.00,1.00,0.64>}
{0.9137, <1.00,1.00,0.66>}
{0.9176, <1.00,1.00,0.67>}
{0.9216, <1.00,1.00,0.69>}
{0.9255, <1.00,1.00,0.70>}
{0.9294, <1.00,1.00,0.72>}
{0.9333, <1.00,1.00,0.73>}
{0.9373, <1.00,1.00,0.75>}
{0.9412, <1.00,1.00,0.77>}
{0.9451, <1.00,1.00,0.78>}
{0.9490, <1.00,1.00,0.80>}
{0.9529, <1.00,1.00,0.81>}
{0.9569, <1.00,1.00,0.83>}
{0.9608, <1.00,1.00,0.84>}
{0.9647, <1.00,1.00,0.86>}
{0.9686, <1.00,1.00,0.88>}
{0.9725, <1.00,1.00,0.89>}
{0.9765, <1.00,1.00,0.91>}
{0.9804, <1.00,1.00,0.92>}
{0.9843, <1.00,1.00,0.94>}
{0.9882, <1.00,1.00,0.95>}
{0.9922, <1.00,1.00,0.97>}
{0.9961, <1.00,1.00,0.98>}
{1.0000, <1.00,1.00,1.00>}
}

#declare winter = array mixed [256][2] {
                
{0.0000, <0.00,0.00,1.00>}
{0.0039, <0.00,0.00,1.00>}
{0.0078, <0.00,0.01,1.00>}
{0.0118, <0.00,0.01,0.99>}
{0.0157, <0.00,0.02,0.99>}
{0.0196, <0.00,0.02,0.99>}
{0.0235, <0.00,0.02,0.99>}
{0.0275, <0.00,0.03,0.99>}
{0.0314, <0.00,0.03,0.98>}
{0.0353, <0.00,0.04,0.98>}
{0.0392, <0.00,0.04,0.98>}
{0.0431, <0.00,0.04,0.98>}
{0.0471, <0.00,0.05,0.98>}
{0.0510, <0.00,0.05,0.97>}
{0.0549, <0.00,0.05,0.97>}
{0.0588, <0.00,0.06,0.97>}
{0.0627, <0.00,0.06,0.97>}
{0.0667, <0.00,0.07,0.97>}
{0.0706, <0.00,0.07,0.96>}
{0.0745, <0.00,0.07,0.96>}
{0.0784, <0.00,0.08,0.96>}
{0.0824, <0.00,0.08,0.96>}
{0.0863, <0.00,0.09,0.96>}
{0.0902, <0.00,0.09,0.95>}
{0.0941, <0.00,0.09,0.95>}
{0.0980, <0.00,0.10,0.95>}
{0.1020, <0.00,0.10,0.95>}
{0.1059, <0.00,0.11,0.95>}
{0.1098, <0.00,0.11,0.95>}
{0.1137, <0.00,0.11,0.94>}
{0.1176, <0.00,0.12,0.94>}
{0.1216, <0.00,0.12,0.94>}
{0.1255, <0.00,0.13,0.94>}
{0.1294, <0.00,0.13,0.94>}
{0.1333, <0.00,0.13,0.93>}
{0.1373, <0.00,0.14,0.93>}
{0.1412, <0.00,0.14,0.93>}
{0.1451, <0.00,0.15,0.93>}
{0.1490, <0.00,0.15,0.93>}
{0.1529, <0.00,0.15,0.92>}
{0.1569, <0.00,0.16,0.92>}
{0.1608, <0.00,0.16,0.92>}
{0.1647, <0.00,0.16,0.92>}
{0.1686, <0.00,0.17,0.92>}
{0.1725, <0.00,0.17,0.91>}
{0.1765, <0.00,0.18,0.91>}
{0.1804, <0.00,0.18,0.91>}
{0.1843, <0.00,0.18,0.91>}
{0.1882, <0.00,0.19,0.91>}
{0.1922, <0.00,0.19,0.90>}
{0.1961, <0.00,0.20,0.90>}
{0.2000, <0.00,0.20,0.90>}
{0.2039, <0.00,0.20,0.90>}
{0.2078, <0.00,0.21,0.90>}
{0.2118, <0.00,0.21,0.89>}
{0.2157, <0.00,0.22,0.89>}
{0.2196, <0.00,0.22,0.89>}
{0.2235, <0.00,0.22,0.89>}
{0.2275, <0.00,0.23,0.89>}
{0.2314, <0.00,0.23,0.88>}
{0.2353, <0.00,0.24,0.88>}
{0.2392, <0.00,0.24,0.88>}
{0.2431, <0.00,0.24,0.88>}
{0.2471, <0.00,0.25,0.88>}
{0.2510, <0.00,0.25,0.87>}
{0.2549, <0.00,0.25,0.87>}
{0.2588, <0.00,0.26,0.87>}
{0.2627, <0.00,0.26,0.87>}
{0.2667, <0.00,0.27,0.87>}
{0.2706, <0.00,0.27,0.86>}
{0.2745, <0.00,0.27,0.86>}
{0.2784, <0.00,0.28,0.86>}
{0.2824, <0.00,0.28,0.86>}
{0.2863, <0.00,0.29,0.86>}
{0.2902, <0.00,0.29,0.85>}
{0.2941, <0.00,0.29,0.85>}
{0.2980, <0.00,0.30,0.85>}
{0.3020, <0.00,0.30,0.85>}
{0.3059, <0.00,0.31,0.85>}
{0.3098, <0.00,0.31,0.85>}
{0.3137, <0.00,0.31,0.84>}
{0.3176, <0.00,0.32,0.84>}
{0.3216, <0.00,0.32,0.84>}
{0.3255, <0.00,0.33,0.84>}
{0.3294, <0.00,0.33,0.84>}
{0.3333, <0.00,0.33,0.83>}
{0.3373, <0.00,0.34,0.83>}
{0.3412, <0.00,0.34,0.83>}
{0.3451, <0.00,0.35,0.83>}
{0.3490, <0.00,0.35,0.83>}
{0.3529, <0.00,0.35,0.82>}
{0.3569, <0.00,0.36,0.82>}
{0.3608, <0.00,0.36,0.82>}
{0.3647, <0.00,0.36,0.82>}
{0.3686, <0.00,0.37,0.82>}
{0.3725, <0.00,0.37,0.81>}
{0.3765, <0.00,0.38,0.81>}
{0.3804, <0.00,0.38,0.81>}
{0.3843, <0.00,0.38,0.81>}
{0.3882, <0.00,0.39,0.81>}
{0.3922, <0.00,0.39,0.80>}
{0.3961, <0.00,0.40,0.80>}
{0.4000, <0.00,0.40,0.80>}
{0.4039, <0.00,0.40,0.80>}
{0.4078, <0.00,0.41,0.80>}
{0.4118, <0.00,0.41,0.79>}
{0.4157, <0.00,0.42,0.79>}
{0.4196, <0.00,0.42,0.79>}
{0.4235, <0.00,0.42,0.79>}
{0.4275, <0.00,0.43,0.79>}
{0.4314, <0.00,0.43,0.78>}
{0.4353, <0.00,0.44,0.78>}
{0.4392, <0.00,0.44,0.78>}
{0.4431, <0.00,0.44,0.78>}
{0.4471, <0.00,0.45,0.78>}
{0.4510, <0.00,0.45,0.77>}
{0.4549, <0.00,0.45,0.77>}
{0.4588, <0.00,0.46,0.77>}
{0.4627, <0.00,0.46,0.77>}
{0.4667, <0.00,0.47,0.77>}
{0.4706, <0.00,0.47,0.76>}
{0.4745, <0.00,0.47,0.76>}
{0.4784, <0.00,0.48,0.76>}
{0.4824, <0.00,0.48,0.76>}
{0.4863, <0.00,0.49,0.76>}
{0.4902, <0.00,0.49,0.75>}
{0.4941, <0.00,0.49,0.75>}
{0.4980, <0.00,0.50,0.75>}
{0.5020, <0.00,0.50,0.75>}
{0.5059, <0.00,0.51,0.75>}
{0.5098, <0.00,0.51,0.75>}
{0.5137, <0.00,0.51,0.74>}
{0.5176, <0.00,0.52,0.74>}
{0.5216, <0.00,0.52,0.74>}
{0.5255, <0.00,0.53,0.74>}
{0.5294, <0.00,0.53,0.74>}
{0.5333, <0.00,0.53,0.73>}
{0.5373, <0.00,0.54,0.73>}
{0.5412, <0.00,0.54,0.73>}
{0.5451, <0.00,0.55,0.73>}
{0.5490, <0.00,0.55,0.73>}
{0.5529, <0.00,0.55,0.72>}
{0.5569, <0.00,0.56,0.72>}
{0.5608, <0.00,0.56,0.72>}
{0.5647, <0.00,0.56,0.72>}
{0.5686, <0.00,0.57,0.72>}
{0.5725, <0.00,0.57,0.71>}
{0.5765, <0.00,0.58,0.71>}
{0.5804, <0.00,0.58,0.71>}
{0.5843, <0.00,0.58,0.71>}
{0.5882, <0.00,0.59,0.71>}
{0.5922, <0.00,0.59,0.70>}
{0.5961, <0.00,0.60,0.70>}
{0.6000, <0.00,0.60,0.70>}
{0.6039, <0.00,0.60,0.70>}
{0.6078, <0.00,0.61,0.70>}
{0.6118, <0.00,0.61,0.69>}
{0.6157, <0.00,0.62,0.69>}
{0.6196, <0.00,0.62,0.69>}
{0.6235, <0.00,0.62,0.69>}
{0.6275, <0.00,0.63,0.69>}
{0.6314, <0.00,0.63,0.68>}
{0.6353, <0.00,0.64,0.68>}
{0.6392, <0.00,0.64,0.68>}
{0.6431, <0.00,0.64,0.68>}
{0.6471, <0.00,0.65,0.68>}
{0.6510, <0.00,0.65,0.67>}
{0.6549, <0.00,0.65,0.67>}
{0.6588, <0.00,0.66,0.67>}
{0.6627, <0.00,0.66,0.67>}
{0.6667, <0.00,0.67,0.67>}
{0.6706, <0.00,0.67,0.66>}
{0.6745, <0.00,0.67,0.66>}
{0.6784, <0.00,0.68,0.66>}
{0.6824, <0.00,0.68,0.66>}
{0.6863, <0.00,0.69,0.66>}
{0.6902, <0.00,0.69,0.65>}
{0.6941, <0.00,0.69,0.65>}
{0.6980, <0.00,0.70,0.65>}
{0.7020, <0.00,0.70,0.65>}
{0.7059, <0.00,0.71,0.65>}
{0.7098, <0.00,0.71,0.65>}
{0.7137, <0.00,0.71,0.64>}
{0.7176, <0.00,0.72,0.64>}
{0.7216, <0.00,0.72,0.64>}
{0.7255, <0.00,0.73,0.64>}
{0.7294, <0.00,0.73,0.64>}
{0.7333, <0.00,0.73,0.63>}
{0.7373, <0.00,0.74,0.63>}
{0.7412, <0.00,0.74,0.63>}
{0.7451, <0.00,0.75,0.63>}
{0.7490, <0.00,0.75,0.63>}
{0.7529, <0.00,0.75,0.62>}
{0.7569, <0.00,0.76,0.62>}
{0.7608, <0.00,0.76,0.62>}
{0.7647, <0.00,0.76,0.62>}
{0.7686, <0.00,0.77,0.62>}
{0.7725, <0.00,0.77,0.61>}
{0.7765, <0.00,0.78,0.61>}
{0.7804, <0.00,0.78,0.61>}
{0.7843, <0.00,0.78,0.61>}
{0.7882, <0.00,0.79,0.61>}
{0.7922, <0.00,0.79,0.60>}
{0.7961, <0.00,0.80,0.60>}
{0.8000, <0.00,0.80,0.60>}
{0.8039, <0.00,0.80,0.60>}
{0.8078, <0.00,0.81,0.60>}
{0.8118, <0.00,0.81,0.59>}
{0.8157, <0.00,0.82,0.59>}
{0.8196, <0.00,0.82,0.59>}
{0.8235, <0.00,0.82,0.59>}
{0.8275, <0.00,0.83,0.59>}
{0.8314, <0.00,0.83,0.58>}
{0.8353, <0.00,0.84,0.58>}
{0.8392, <0.00,0.84,0.58>}
{0.8431, <0.00,0.84,0.58>}
{0.8471, <0.00,0.85,0.58>}
{0.8510, <0.00,0.85,0.57>}
{0.8549, <0.00,0.85,0.57>}
{0.8588, <0.00,0.86,0.57>}
{0.8627, <0.00,0.86,0.57>}
{0.8667, <0.00,0.87,0.57>}
{0.8706, <0.00,0.87,0.56>}
{0.8745, <0.00,0.87,0.56>}
{0.8784, <0.00,0.88,0.56>}
{0.8824, <0.00,0.88,0.56>}
{0.8863, <0.00,0.89,0.56>}
{0.8902, <0.00,0.89,0.55>}
{0.8941, <0.00,0.89,0.55>}
{0.8980, <0.00,0.90,0.55>}
{0.9020, <0.00,0.90,0.55>}
{0.9059, <0.00,0.91,0.55>}
{0.9098, <0.00,0.91,0.55>}
{0.9137, <0.00,0.91,0.54>}
{0.9176, <0.00,0.92,0.54>}
{0.9216, <0.00,0.92,0.54>}
{0.9255, <0.00,0.93,0.54>}
{0.9294, <0.00,0.93,0.54>}
{0.9333, <0.00,0.93,0.53>}
{0.9373, <0.00,0.94,0.53>}
{0.9412, <0.00,0.94,0.53>}
{0.9451, <0.00,0.95,0.53>}
{0.9490, <0.00,0.95,0.53>}
{0.9529, <0.00,0.95,0.52>}
{0.9569, <0.00,0.96,0.52>}
{0.9608, <0.00,0.96,0.52>}
{0.9647, <0.00,0.96,0.52>}
{0.9686, <0.00,0.97,0.52>}
{0.9725, <0.00,0.97,0.51>}
{0.9765, <0.00,0.98,0.51>}
{0.9804, <0.00,0.98,0.51>}
{0.9843, <0.00,0.98,0.51>}
{0.9882, <0.00,0.99,0.51>}
{0.9922, <0.00,0.99,0.50>}
{0.9961, <0.00,1.00,0.50>}
{1.0000, <0.00,1.00,0.50>}
}

#declare hsv = array mixed [256][2] {
{0.0000, <1.00,0.00,0.00>}
{0.0039, <1.00,0.02,0.00>}
{0.0078, <1.00,0.05,0.00>}
{0.0118, <1.00,0.07,0.00>}
{0.0157, <1.00,0.09,0.00>}
{0.0196, <1.00,0.12,0.00>}
{0.0235, <1.00,0.14,0.00>}
{0.0275, <1.00,0.16,0.00>}
{0.0314, <1.00,0.19,0.00>}
{0.0353, <1.00,0.21,0.00>}
{0.0392, <1.00,0.23,0.00>}
{0.0431, <1.00,0.26,0.00>}
{0.0471, <1.00,0.28,0.00>}
{0.0510, <1.00,0.30,0.00>}
{0.0549, <1.00,0.33,0.00>}
{0.0588, <1.00,0.35,0.00>}
{0.0627, <1.00,0.38,0.00>}
{0.0667, <1.00,0.40,0.00>}
{0.0706, <1.00,0.42,0.00>}
{0.0745, <1.00,0.45,0.00>}
{0.0784, <1.00,0.47,0.00>}
{0.0824, <1.00,0.49,0.00>}
{0.0863, <1.00,0.52,0.00>}
{0.0902, <1.00,0.54,0.00>}
{0.0941, <1.00,0.56,0.00>}
{0.0980, <1.00,0.59,0.00>}
{0.1020, <1.00,0.61,0.00>}
{0.1059, <1.00,0.63,0.00>}
{0.1098, <1.00,0.66,0.00>}
{0.1137, <1.00,0.68,0.00>}
{0.1176, <1.00,0.70,0.00>}
{0.1216, <1.00,0.73,0.00>}
{0.1255, <1.00,0.75,0.00>}
{0.1294, <1.00,0.77,0.00>}
{0.1333, <1.00,0.80,0.00>}
{0.1373, <1.00,0.82,0.00>}
{0.1412, <1.00,0.84,0.00>}
{0.1451, <1.00,0.87,0.00>}
{0.1490, <1.00,0.89,0.00>}
{0.1529, <1.00,0.91,0.00>}
{0.1569, <1.00,0.94,0.00>}
{0.1608, <1.00,0.96,0.00>}
{0.1647, <1.00,0.98,0.00>}
{0.1686, <0.99,1.00,0.00>}
{0.1725, <0.97,1.00,0.00>}
{0.1765, <0.95,1.00,0.00>}
{0.1804, <0.92,1.00,0.00>}
{0.1843, <0.90,1.00,0.00>}
{0.1882, <0.88,1.00,0.00>}
{0.1922, <0.85,1.00,0.00>}
{0.1961, <0.83,1.00,0.00>}
{0.2000, <0.80,1.00,0.00>}
{0.2039, <0.78,1.00,0.00>}
{0.2078, <0.76,1.00,0.00>}
{0.2118, <0.73,1.00,0.00>}
{0.2157, <0.71,1.00,0.00>}
{0.2196, <0.69,1.00,0.00>}
{0.2235, <0.66,1.00,0.00>}
{0.2275, <0.64,1.00,0.00>}
{0.2314, <0.62,1.00,0.00>}
{0.2353, <0.59,1.00,0.00>}
{0.2392, <0.57,1.00,0.00>}
{0.2431, <0.55,1.00,0.00>}
{0.2471, <0.52,1.00,0.00>}
{0.2510, <0.50,1.00,0.00>}
{0.2549, <0.48,1.00,0.00>}
{0.2588, <0.45,1.00,0.00>}
{0.2627, <0.43,1.00,0.00>}
{0.2667, <0.41,1.00,0.00>}
{0.2706, <0.38,1.00,0.00>}
{0.2745, <0.36,1.00,0.00>}
{0.2784, <0.34,1.00,0.00>}
{0.2824, <0.31,1.00,0.00>}
{0.2863, <0.29,1.00,0.00>}
{0.2902, <0.27,1.00,0.00>}
{0.2941, <0.24,1.00,0.00>}
{0.2980, <0.22,1.00,0.00>}
{0.3020, <0.20,1.00,0.00>}
{0.3059, <0.17,1.00,0.00>}
{0.3098, <0.15,1.00,0.00>}
{0.3137, <0.13,1.00,0.00>}
{0.3176, <0.10,1.00,0.00>}
{0.3216, <0.08,1.00,0.00>}
{0.3255, <0.05,1.00,0.00>}
{0.3294, <0.03,1.00,0.00>}
{0.3333, <0.01,1.00,0.00>}
{0.3373, <0.00,1.00,0.02>}
{0.3412, <0.00,1.00,0.04>}
{0.3451, <0.00,1.00,0.06>}
{0.3490, <0.00,1.00,0.09>}
{0.3529, <0.00,1.00,0.11>}
{0.3569, <0.00,1.00,0.13>}
{0.3608, <0.00,1.00,0.16>}
{0.3647, <0.00,1.00,0.18>}
{0.3686, <0.00,1.00,0.20>}
{0.3725, <0.00,1.00,0.23>}
{0.3765, <0.00,1.00,0.25>}
{0.3804, <0.00,1.00,0.27>}
{0.3843, <0.00,1.00,0.30>}
{0.3882, <0.00,1.00,0.32>}
{0.3922, <0.00,1.00,0.34>}
{0.3961, <0.00,1.00,0.37>}
{0.4000, <0.00,1.00,0.39>}
{0.4039, <0.00,1.00,0.41>}
{0.4078, <0.00,1.00,0.44>}
{0.4118, <0.00,1.00,0.46>}
{0.4157, <0.00,1.00,0.48>}
{0.4196, <0.00,1.00,0.51>}
{0.4235, <0.00,1.00,0.53>}
{0.4275, <0.00,1.00,0.55>}
{0.4314, <0.00,1.00,0.58>}
{0.4353, <0.00,1.00,0.60>}
{0.4392, <0.00,1.00,0.63>}
{0.4431, <0.00,1.00,0.65>}
{0.4471, <0.00,1.00,0.67>}
{0.4510, <0.00,1.00,0.70>}
{0.4549, <0.00,1.00,0.72>}
{0.4588, <0.00,1.00,0.74>}
{0.4627, <0.00,1.00,0.77>}
{0.4667, <0.00,1.00,0.79>}
{0.4706, <0.00,1.00,0.81>}
{0.4745, <0.00,1.00,0.84>}
{0.4784, <0.00,1.00,0.86>}
{0.4824, <0.00,1.00,0.88>}
{0.4863, <0.00,1.00,0.91>}
{0.4902, <0.00,1.00,0.93>}
{0.4941, <0.00,1.00,0.95>}
{0.4980, <0.00,1.00,0.98>}
{0.5020, <0.00,1.00,1.00>}
{0.5059, <0.00,0.98,1.00>}
{0.5098, <0.00,0.95,1.00>}
{0.5137, <0.00,0.93,1.00>}
{0.5176, <0.00,0.91,1.00>}
{0.5216, <0.00,0.88,1.00>}
{0.5255, <0.00,0.86,1.00>}
{0.5294, <0.00,0.84,1.00>}
{0.5333, <0.00,0.81,1.00>}
{0.5373, <0.00,0.79,1.00>}
{0.5412, <0.00,0.77,1.00>}
{0.5451, <0.00,0.74,1.00>}
{0.5490, <0.00,0.72,1.00>}
{0.5529, <0.00,0.70,1.00>}
{0.5569, <0.00,0.67,1.00>}
{0.5608, <0.00,0.65,1.00>}
{0.5647, <0.00,0.63,1.00>}
{0.5686, <0.00,0.60,1.00>}
{0.5725, <0.00,0.58,1.00>}
{0.5765, <0.00,0.55,1.00>}
{0.5804, <0.00,0.53,1.00>}
{0.5843, <0.00,0.51,1.00>}
{0.5882, <0.00,0.48,1.00>}
{0.5922, <0.00,0.46,1.00>}
{0.5961, <0.00,0.44,1.00>}
{0.6000, <0.00,0.41,1.00>}
{0.6039, <0.00,0.39,1.00>}
{0.6078, <0.00,0.37,1.00>}
{0.6118, <0.00,0.34,1.00>}
{0.6157, <0.00,0.32,1.00>}
{0.6196, <0.00,0.30,1.00>}
{0.6235, <0.00,0.27,1.00>}
{0.6275, <0.00,0.25,1.00>}
{0.6314, <0.00,0.23,1.00>}
{0.6353, <0.00,0.20,1.00>}
{0.6392, <0.00,0.18,1.00>}
{0.6431, <0.00,0.16,1.00>}
{0.6471, <0.00,0.13,1.00>}
{0.6510, <0.00,0.11,1.00>}
{0.6549, <0.00,0.09,1.00>}
{0.6588, <0.00,0.06,1.00>}
{0.6627, <0.00,0.04,1.00>}
{0.6667, <0.00,0.02,1.00>}
{0.6706, <0.01,0.00,1.00>}
{0.6745, <0.03,0.00,1.00>}
{0.6784, <0.05,0.00,1.00>}
{0.6824, <0.08,0.00,1.00>}
{0.6863, <0.10,0.00,1.00>}
{0.6902, <0.13,0.00,1.00>}
{0.6941, <0.15,0.00,1.00>}
{0.6980, <0.17,0.00,1.00>}
{0.7020, <0.20,0.00,1.00>}
{0.7059, <0.22,0.00,1.00>}
{0.7098, <0.24,0.00,1.00>}
{0.7137, <0.27,0.00,1.00>}
{0.7176, <0.29,0.00,1.00>}
{0.7216, <0.31,0.00,1.00>}
{0.7255, <0.34,0.00,1.00>}
{0.7294, <0.36,0.00,1.00>}
{0.7333, <0.38,0.00,1.00>}
{0.7373, <0.41,0.00,1.00>}
{0.7412, <0.43,0.00,1.00>}
{0.7451, <0.45,0.00,1.00>}
{0.7490, <0.48,0.00,1.00>}
{0.7529, <0.50,0.00,1.00>}
{0.7569, <0.52,0.00,1.00>}
{0.7608, <0.55,0.00,1.00>}
{0.7647, <0.57,0.00,1.00>}
{0.7686, <0.59,0.00,1.00>}
{0.7725, <0.62,0.00,1.00>}
{0.7765, <0.64,0.00,1.00>}
{0.7804, <0.66,0.00,1.00>}
{0.7843, <0.69,0.00,1.00>}
{0.7882, <0.71,0.00,1.00>}
{0.7922, <0.73,0.00,1.00>}
{0.7961, <0.76,0.00,1.00>}
{0.8000, <0.78,0.00,1.00>}
{0.8039, <0.80,0.00,1.00>}
{0.8078, <0.83,0.00,1.00>}
{0.8118, <0.85,0.00,1.00>}
{0.8157, <0.88,0.00,1.00>}
{0.8196, <0.90,0.00,1.00>}
{0.8235, <0.92,0.00,1.00>}
{0.8275, <0.95,0.00,1.00>}
{0.8314, <0.97,0.00,1.00>}
{0.8353, <0.99,0.00,1.00>}
{0.8392, <1.00,0.00,0.98>}
{0.8431, <1.00,0.00,0.96>}
{0.8471, <1.00,0.00,0.94>}
{0.8510, <1.00,0.00,0.91>}
{0.8549, <1.00,0.00,0.89>}
{0.8588, <1.00,0.00,0.87>}
{0.8627, <1.00,0.00,0.84>}
{0.8667, <1.00,0.00,0.82>}
{0.8706, <1.00,0.00,0.80>}
{0.8745, <1.00,0.00,0.77>}
{0.8784, <1.00,0.00,0.75>}
{0.8824, <1.00,0.00,0.73>}
{0.8863, <1.00,0.00,0.70>}
{0.8902, <1.00,0.00,0.68>}
{0.8941, <1.00,0.00,0.66>}
{0.8980, <1.00,0.00,0.63>}
{0.9020, <1.00,0.00,0.61>}
{0.9059, <1.00,0.00,0.59>}
{0.9098, <1.00,0.00,0.56>}
{0.9137, <1.00,0.00,0.54>}
{0.9176, <1.00,0.00,0.52>}
{0.9216, <1.00,0.00,0.49>}
{0.9255, <1.00,0.00,0.47>}
{0.9294, <1.00,0.00,0.45>}
{0.9333, <1.00,0.00,0.42>}
{0.9373, <1.00,0.00,0.40>}
{0.9412, <1.00,0.00,0.38>}
{0.9451, <1.00,0.00,0.35>}
{0.9490, <1.00,0.00,0.33>}
{0.9529, <1.00,0.00,0.30>}
{0.9569, <1.00,0.00,0.28>}
{0.9608, <1.00,0.00,0.26>}
{0.9647, <1.00,0.00,0.23>}
{0.9686, <1.00,0.00,0.21>}
{0.9725, <1.00,0.00,0.19>}
{0.9765, <1.00,0.00,0.16>}
{0.9804, <1.00,0.00,0.14>}
{0.9843, <1.00,0.00,0.12>}
{0.9882, <1.00,0.00,0.09>}
{0.9922, <1.00,0.00,0.07>}
{0.9961, <1.00,0.00,0.05>}
{1.0000, <1.00,0.00,0.02>}
}

#declare autumn = array mixed [256][2] {
{0.0000, <1.00,0.00,0.00>}
{0.0039, <1.00,0.00,0.00>}
{0.0078, <1.00,0.01,0.00>}
{0.0118, <1.00,0.01,0.00>}
{0.0157, <1.00,0.02,0.00>}
{0.0196, <1.00,0.02,0.00>}
{0.0235, <1.00,0.02,0.00>}
{0.0275, <1.00,0.03,0.00>}
{0.0314, <1.00,0.03,0.00>}
{0.0353, <1.00,0.04,0.00>}
{0.0392, <1.00,0.04,0.00>}
{0.0431, <1.00,0.04,0.00>}
{0.0471, <1.00,0.05,0.00>}
{0.0510, <1.00,0.05,0.00>}
{0.0549, <1.00,0.05,0.00>}
{0.0588, <1.00,0.06,0.00>}
{0.0627, <1.00,0.06,0.00>}
{0.0667, <1.00,0.07,0.00>}
{0.0706, <1.00,0.07,0.00>}
{0.0745, <1.00,0.07,0.00>}
{0.0784, <1.00,0.08,0.00>}
{0.0824, <1.00,0.08,0.00>}
{0.0863, <1.00,0.09,0.00>}
{0.0902, <1.00,0.09,0.00>}
{0.0941, <1.00,0.09,0.00>}
{0.0980, <1.00,0.10,0.00>}
{0.1020, <1.00,0.10,0.00>}
{0.1059, <1.00,0.11,0.00>}
{0.1098, <1.00,0.11,0.00>}
{0.1137, <1.00,0.11,0.00>}
{0.1176, <1.00,0.12,0.00>}
{0.1216, <1.00,0.12,0.00>}
{0.1255, <1.00,0.13,0.00>}
{0.1294, <1.00,0.13,0.00>}
{0.1333, <1.00,0.13,0.00>}
{0.1373, <1.00,0.14,0.00>}
{0.1412, <1.00,0.14,0.00>}
{0.1451, <1.00,0.15,0.00>}
{0.1490, <1.00,0.15,0.00>}
{0.1529, <1.00,0.15,0.00>}
{0.1569, <1.00,0.16,0.00>}
{0.1608, <1.00,0.16,0.00>}
{0.1647, <1.00,0.16,0.00>}
{0.1686, <1.00,0.17,0.00>}
{0.1725, <1.00,0.17,0.00>}
{0.1765, <1.00,0.18,0.00>}
{0.1804, <1.00,0.18,0.00>}
{0.1843, <1.00,0.18,0.00>}
{0.1882, <1.00,0.19,0.00>}
{0.1922, <1.00,0.19,0.00>}
{0.1961, <1.00,0.20,0.00>}
{0.2000, <1.00,0.20,0.00>}
{0.2039, <1.00,0.20,0.00>}
{0.2078, <1.00,0.21,0.00>}
{0.2118, <1.00,0.21,0.00>}
{0.2157, <1.00,0.22,0.00>}
{0.2196, <1.00,0.22,0.00>}
{0.2235, <1.00,0.22,0.00>}
{0.2275, <1.00,0.23,0.00>}
{0.2314, <1.00,0.23,0.00>}
{0.2353, <1.00,0.24,0.00>}
{0.2392, <1.00,0.24,0.00>}
{0.2431, <1.00,0.24,0.00>}
{0.2471, <1.00,0.25,0.00>}
{0.2510, <1.00,0.25,0.00>}
{0.2549, <1.00,0.25,0.00>}
{0.2588, <1.00,0.26,0.00>}
{0.2627, <1.00,0.26,0.00>}
{0.2667, <1.00,0.27,0.00>}
{0.2706, <1.00,0.27,0.00>}
{0.2745, <1.00,0.27,0.00>}
{0.2784, <1.00,0.28,0.00>}
{0.2824, <1.00,0.28,0.00>}
{0.2863, <1.00,0.29,0.00>}
{0.2902, <1.00,0.29,0.00>}
{0.2941, <1.00,0.29,0.00>}
{0.2980, <1.00,0.30,0.00>}
{0.3020, <1.00,0.30,0.00>}
{0.3059, <1.00,0.31,0.00>}
{0.3098, <1.00,0.31,0.00>}
{0.3137, <1.00,0.31,0.00>}
{0.3176, <1.00,0.32,0.00>}
{0.3216, <1.00,0.32,0.00>}
{0.3255, <1.00,0.33,0.00>}
{0.3294, <1.00,0.33,0.00>}
{0.3333, <1.00,0.33,0.00>}
{0.3373, <1.00,0.34,0.00>}
{0.3412, <1.00,0.34,0.00>}
{0.3451, <1.00,0.35,0.00>}
{0.3490, <1.00,0.35,0.00>}
{0.3529, <1.00,0.35,0.00>}
{0.3569, <1.00,0.36,0.00>}
{0.3608, <1.00,0.36,0.00>}
{0.3647, <1.00,0.36,0.00>}
{0.3686, <1.00,0.37,0.00>}
{0.3725, <1.00,0.37,0.00>}
{0.3765, <1.00,0.38,0.00>}
{0.3804, <1.00,0.38,0.00>}
{0.3843, <1.00,0.38,0.00>}
{0.3882, <1.00,0.39,0.00>}
{0.3922, <1.00,0.39,0.00>}
{0.3961, <1.00,0.40,0.00>}
{0.4000, <1.00,0.40,0.00>}
{0.4039, <1.00,0.40,0.00>}
{0.4078, <1.00,0.41,0.00>}
{0.4118, <1.00,0.41,0.00>}
{0.4157, <1.00,0.42,0.00>}
{0.4196, <1.00,0.42,0.00>}
{0.4235, <1.00,0.42,0.00>}
{0.4275, <1.00,0.43,0.00>}
{0.4314, <1.00,0.43,0.00>}
{0.4353, <1.00,0.44,0.00>}
{0.4392, <1.00,0.44,0.00>}
{0.4431, <1.00,0.44,0.00>}
{0.4471, <1.00,0.45,0.00>}
{0.4510, <1.00,0.45,0.00>}
{0.4549, <1.00,0.45,0.00>}
{0.4588, <1.00,0.46,0.00>}
{0.4627, <1.00,0.46,0.00>}
{0.4667, <1.00,0.47,0.00>}
{0.4706, <1.00,0.47,0.00>}
{0.4745, <1.00,0.47,0.00>}
{0.4784, <1.00,0.48,0.00>}
{0.4824, <1.00,0.48,0.00>}
{0.4863, <1.00,0.49,0.00>}
{0.4902, <1.00,0.49,0.00>}
{0.4941, <1.00,0.49,0.00>}
{0.4980, <1.00,0.50,0.00>}
{0.5020, <1.00,0.50,0.00>}
{0.5059, <1.00,0.51,0.00>}
{0.5098, <1.00,0.51,0.00>}
{0.5137, <1.00,0.51,0.00>}
{0.5176, <1.00,0.52,0.00>}
{0.5216, <1.00,0.52,0.00>}
{0.5255, <1.00,0.53,0.00>}
{0.5294, <1.00,0.53,0.00>}
{0.5333, <1.00,0.53,0.00>}
{0.5373, <1.00,0.54,0.00>}
{0.5412, <1.00,0.54,0.00>}
{0.5451, <1.00,0.55,0.00>}
{0.5490, <1.00,0.55,0.00>}
{0.5529, <1.00,0.55,0.00>}
{0.5569, <1.00,0.56,0.00>}
{0.5608, <1.00,0.56,0.00>}
{0.5647, <1.00,0.56,0.00>}
{0.5686, <1.00,0.57,0.00>}
{0.5725, <1.00,0.57,0.00>}
{0.5765, <1.00,0.58,0.00>}
{0.5804, <1.00,0.58,0.00>}
{0.5843, <1.00,0.58,0.00>}
{0.5882, <1.00,0.59,0.00>}
{0.5922, <1.00,0.59,0.00>}
{0.5961, <1.00,0.60,0.00>}
{0.6000, <1.00,0.60,0.00>}
{0.6039, <1.00,0.60,0.00>}
{0.6078, <1.00,0.61,0.00>}
{0.6118, <1.00,0.61,0.00>}
{0.6157, <1.00,0.62,0.00>}
{0.6196, <1.00,0.62,0.00>}
{0.6235, <1.00,0.62,0.00>}
{0.6275, <1.00,0.63,0.00>}
{0.6314, <1.00,0.63,0.00>}
{0.6353, <1.00,0.64,0.00>}
{0.6392, <1.00,0.64,0.00>}
{0.6431, <1.00,0.64,0.00>}
{0.6471, <1.00,0.65,0.00>}
{0.6510, <1.00,0.65,0.00>}
{0.6549, <1.00,0.65,0.00>}
{0.6588, <1.00,0.66,0.00>}
{0.6627, <1.00,0.66,0.00>}
{0.6667, <1.00,0.67,0.00>}
{0.6706, <1.00,0.67,0.00>}
{0.6745, <1.00,0.67,0.00>}
{0.6784, <1.00,0.68,0.00>}
{0.6824, <1.00,0.68,0.00>}
{0.6863, <1.00,0.69,0.00>}
{0.6902, <1.00,0.69,0.00>}
{0.6941, <1.00,0.69,0.00>}
{0.6980, <1.00,0.70,0.00>}
{0.7020, <1.00,0.70,0.00>}
{0.7059, <1.00,0.71,0.00>}
{0.7098, <1.00,0.71,0.00>}
{0.7137, <1.00,0.71,0.00>}
{0.7176, <1.00,0.72,0.00>}
{0.7216, <1.00,0.72,0.00>}
{0.7255, <1.00,0.73,0.00>}
{0.7294, <1.00,0.73,0.00>}
{0.7333, <1.00,0.73,0.00>}
{0.7373, <1.00,0.74,0.00>}
{0.7412, <1.00,0.74,0.00>}
{0.7451, <1.00,0.75,0.00>}
{0.7490, <1.00,0.75,0.00>}
{0.7529, <1.00,0.75,0.00>}
{0.7569, <1.00,0.76,0.00>}
{0.7608, <1.00,0.76,0.00>}
{0.7647, <1.00,0.76,0.00>}
{0.7686, <1.00,0.77,0.00>}
{0.7725, <1.00,0.77,0.00>}
{0.7765, <1.00,0.78,0.00>}
{0.7804, <1.00,0.78,0.00>}
{0.7843, <1.00,0.78,0.00>}
{0.7882, <1.00,0.79,0.00>}
{0.7922, <1.00,0.79,0.00>}
{0.7961, <1.00,0.80,0.00>}
{0.8000, <1.00,0.80,0.00>}
{0.8039, <1.00,0.80,0.00>}
{0.8078, <1.00,0.81,0.00>}
{0.8118, <1.00,0.81,0.00>}
{0.8157, <1.00,0.82,0.00>}
{0.8196, <1.00,0.82,0.00>}
{0.8235, <1.00,0.82,0.00>}
{0.8275, <1.00,0.83,0.00>}
{0.8314, <1.00,0.83,0.00>}
{0.8353, <1.00,0.84,0.00>}
{0.8392, <1.00,0.84,0.00>}
{0.8431, <1.00,0.84,0.00>}
{0.8471, <1.00,0.85,0.00>}
{0.8510, <1.00,0.85,0.00>}
{0.8549, <1.00,0.85,0.00>}
{0.8588, <1.00,0.86,0.00>}
{0.8627, <1.00,0.86,0.00>}
{0.8667, <1.00,0.87,0.00>}
{0.8706, <1.00,0.87,0.00>}
{0.8745, <1.00,0.87,0.00>}
{0.8784, <1.00,0.88,0.00>}
{0.8824, <1.00,0.88,0.00>}
{0.8863, <1.00,0.89,0.00>}
{0.8902, <1.00,0.89,0.00>}
{0.8941, <1.00,0.89,0.00>}
{0.8980, <1.00,0.90,0.00>}
{0.9020, <1.00,0.90,0.00>}
{0.9059, <1.00,0.91,0.00>}
{0.9098, <1.00,0.91,0.00>}
{0.9137, <1.00,0.91,0.00>}
{0.9176, <1.00,0.92,0.00>}
{0.9216, <1.00,0.92,0.00>}
{0.9255, <1.00,0.93,0.00>}
{0.9294, <1.00,0.93,0.00>}
{0.9333, <1.00,0.93,0.00>}
{0.9373, <1.00,0.94,0.00>}
{0.9412, <1.00,0.94,0.00>}
{0.9451, <1.00,0.95,0.00>}
{0.9490, <1.00,0.95,0.00>}
{0.9529, <1.00,0.95,0.00>}
{0.9569, <1.00,0.96,0.00>}
{0.9608, <1.00,0.96,0.00>}
{0.9647, <1.00,0.96,0.00>}
{0.9686, <1.00,0.97,0.00>}
{0.9725, <1.00,0.97,0.00>}
{0.9765, <1.00,0.98,0.00>}
{0.9804, <1.00,0.98,0.00>}
{0.9843, <1.00,0.98,0.00>}
{0.9882, <1.00,0.99,0.00>}
{0.9922, <1.00,0.99,0.00>}
{0.9961, <1.00,1.00,0.00>}
{1.0000, <1.00,1.00,0.00>}
}

#declare parula =array mixed [256][2] {
{0.0000, <0.24,0.15,0.66>}
{0.0039, <0.24,0.15,0.67>}
{0.0078, <0.25,0.16,0.68>}
{0.0118, <0.25,0.16,0.70>}
{0.0157, <0.25,0.16,0.71>}
{0.0196, <0.25,0.17,0.72>}
{0.0235, <0.25,0.17,0.73>}
{0.0275, <0.26,0.18,0.74>}
{0.0314, <0.26,0.18,0.75>}
{0.0353, <0.26,0.19,0.76>}
{0.0392, <0.26,0.19,0.77>}
{0.0431, <0.26,0.19,0.78>}
{0.0471, <0.26,0.20,0.79>}
{0.0510, <0.27,0.20,0.80>}
{0.0549, <0.27,0.21,0.81>}
{0.0588, <0.27,0.21,0.82>}
{0.0627, <0.27,0.21,0.83>}
{0.0667, <0.27,0.22,0.84>}
{0.0706, <0.27,0.22,0.85>}
{0.0745, <0.27,0.23,0.86>}
{0.0784, <0.27,0.23,0.87>}
{0.0824, <0.28,0.24,0.88>}
{0.0863, <0.28,0.24,0.88>}
{0.0902, <0.28,0.25,0.89>}
{0.0941, <0.28,0.25,0.90>}
{0.0980, <0.28,0.26,0.90>}
{0.1020, <0.28,0.27,0.91>}
{0.1059, <0.28,0.27,0.92>}
{0.1098, <0.28,0.28,0.92>}
{0.1137, <0.28,0.28,0.93>}
{0.1176, <0.28,0.29,0.93>}
{0.1216, <0.28,0.29,0.94>}
{0.1255, <0.28,0.30,0.94>}
{0.1294, <0.28,0.30,0.94>}
{0.1333, <0.28,0.31,0.95>}
{0.1373, <0.28,0.32,0.95>}
{0.1412, <0.28,0.32,0.96>}
{0.1451, <0.28,0.33,0.96>}
{0.1490, <0.28,0.33,0.96>}
{0.1529, <0.28,0.34,0.97>}
{0.1569, <0.28,0.34,0.97>}
{0.1608, <0.28,0.35,0.97>}
{0.1647, <0.28,0.35,0.98>}
{0.1686, <0.28,0.36,0.98>}
{0.1725, <0.28,0.36,0.98>}
{0.1765, <0.28,0.37,0.98>}
{0.1804, <0.27,0.37,0.99>}
{0.1843, <0.27,0.38,0.99>}
{0.1882, <0.27,0.39,0.99>}
{0.1922, <0.27,0.39,0.99>}
{0.1961, <0.27,0.40,0.99>}
{0.2000, <0.26,0.40,0.99>}
{0.2039, <0.26,0.41,0.99>}
{0.2078, <0.26,0.41,1.00>}
{0.2118, <0.26,0.42,1.00>}
{0.2157, <0.25,0.43,1.00>}
{0.2196, <0.25,0.43,1.00>}
{0.2235, <0.24,0.44,1.00>}
{0.2275, <0.24,0.44,1.00>}
{0.2314, <0.23,0.45,1.00>}
{0.2353, <0.23,0.46,1.00>}
{0.2392, <0.22,0.46,1.00>}
{0.2431, <0.21,0.47,0.99>}
{0.2471, <0.21,0.47,0.99>}
{0.2510, <0.20,0.48,0.99>}
{0.2549, <0.20,0.49,0.99>}
{0.2588, <0.19,0.49,0.99>}
{0.2627, <0.19,0.50,0.98>}
{0.2667, <0.18,0.50,0.98>}
{0.2706, <0.18,0.51,0.98>}
{0.2745, <0.18,0.51,0.98>}
{0.2784, <0.18,0.52,0.97>}
{0.2824, <0.18,0.52,0.97>}
{0.2863, <0.18,0.53,0.97>}
{0.2902, <0.18,0.53,0.96>}
{0.2941, <0.18,0.54,0.96>}
{0.2980, <0.18,0.55,0.96>}
{0.3020, <0.18,0.55,0.95>}
{0.3059, <0.18,0.56,0.95>}
{0.3098, <0.17,0.56,0.94>}
{0.3137, <0.17,0.57,0.94>}
{0.3176, <0.17,0.57,0.94>}
{0.3216, <0.16,0.58,0.93>}
{0.3255, <0.16,0.58,0.93>}
{0.3294, <0.16,0.59,0.93>}
{0.3333, <0.15,0.59,0.92>}
{0.3373, <0.15,0.59,0.92>}
{0.3412, <0.15,0.60,0.91>}
{0.3451, <0.15,0.60,0.91>}
{0.3490, <0.15,0.61,0.91>}
{0.3529, <0.14,0.61,0.91>}
{0.3569, <0.14,0.62,0.90>}
{0.3608, <0.14,0.62,0.90>}
{0.3647, <0.14,0.63,0.90>}
{0.3686, <0.14,0.63,0.90>}
{0.3725, <0.13,0.64,0.89>}
{0.3765, <0.13,0.64,0.89>}
{0.3804, <0.13,0.65,0.89>}
{0.3843, <0.12,0.65,0.89>}
{0.3882, <0.12,0.65,0.88>}
{0.3922, <0.12,0.66,0.88>}
{0.3961, <0.11,0.66,0.88>}
{0.4000, <0.11,0.67,0.87>}
{0.4039, <0.10,0.67,0.87>}
{0.4078, <0.10,0.68,0.87>}
{0.4118, <0.10,0.68,0.86>}
{0.4157, <0.09,0.68,0.86>}
{0.4196, <0.09,0.69,0.85>}
{0.4235, <0.08,0.69,0.85>}
{0.4275, <0.07,0.69,0.84>}
{0.4314, <0.06,0.70,0.84>}
{0.4353, <0.05,0.70,0.83>}
{0.4392, <0.04,0.70,0.82>}
{0.4431, <0.03,0.71,0.82>}
{0.4471, <0.02,0.71,0.81>}
{0.4510, <0.02,0.71,0.81>}
{0.4549, <0.01,0.72,0.80>}
{0.4588, <0.00,0.72,0.79>}
{0.4627, <0.00,0.72,0.79>}
{0.4667, <0.00,0.72,0.78>}
{0.4706, <0.00,0.73,0.78>}
{0.4745, <0.00,0.73,0.77>}
{0.4784, <0.01,0.73,0.76>}
{0.4824, <0.02,0.74,0.76>}
{0.4863, <0.03,0.74,0.75>}
{0.4902, <0.04,0.74,0.74>}
{0.4941, <0.05,0.74,0.74>}
{0.4980, <0.06,0.74,0.73>}
{0.5020, <0.08,0.75,0.72>}
{0.5059, <0.09,0.75,0.72>}
{0.5098, <0.10,0.75,0.71>}
{0.5137, <0.11,0.75,0.70>}
{0.5176, <0.13,0.76,0.69>}
{0.5216, <0.14,0.76,0.69>}
{0.5255, <0.14,0.76,0.68>}
{0.5294, <0.15,0.76,0.67>}
{0.5333, <0.16,0.76,0.67>}
{0.5373, <0.17,0.77,0.66>}
{0.5412, <0.17,0.77,0.65>}
{0.5451, <0.18,0.77,0.65>}
{0.5490, <0.19,0.77,0.64>}
{0.5529, <0.19,0.77,0.63>}
{0.5569, <0.20,0.78,0.62>}
{0.5608, <0.20,0.78,0.61>}
{0.5647, <0.21,0.78,0.61>}
{0.5686, <0.21,0.78,0.60>}
{0.5725, <0.22,0.78,0.59>}
{0.5765, <0.22,0.79,0.58>}
{0.5804, <0.23,0.79,0.57>}
{0.5843, <0.24,0.79,0.56>}
{0.5882, <0.25,0.79,0.55>}
{0.5922, <0.26,0.79,0.55>}
{0.5961, <0.27,0.80,0.54>}
{0.6000, <0.28,0.80,0.53>}
{0.6039, <0.29,0.80,0.52>}
{0.6078, <0.31,0.80,0.51>}
{0.6118, <0.32,0.80,0.50>}
{0.6157, <0.33,0.80,0.49>}
{0.6196, <0.34,0.80,0.48>}
{0.6235, <0.35,0.80,0.47>}
{0.6275, <0.37,0.80,0.46>}
{0.6314, <0.38,0.80,0.45>}
{0.6353, <0.39,0.80,0.43>}
{0.6392, <0.41,0.80,0.42>}
{0.6431, <0.42,0.80,0.41>}
{0.6471, <0.43,0.80,0.40>}
{0.6510, <0.45,0.80,0.39>}
{0.6549, <0.46,0.80,0.38>}
{0.6588, <0.48,0.80,0.37>}
{0.6627, <0.49,0.80,0.36>}
{0.6667, <0.50,0.80,0.35>}
{0.6706, <0.52,0.80,0.34>}
{0.6745, <0.53,0.80,0.33>}
{0.6784, <0.55,0.80,0.32>}
{0.6824, <0.56,0.79,0.30>}
{0.6863, <0.57,0.79,0.29>}
{0.6902, <0.59,0.79,0.28>}
{0.6941, <0.60,0.79,0.27>}
{0.6980, <0.62,0.79,0.26>}
{0.7020, <0.63,0.79,0.25>}
{0.7059, <0.64,0.78,0.24>}
{0.7098, <0.66,0.78,0.23>}
{0.7137, <0.67,0.78,0.22>}
{0.7176, <0.68,0.78,0.22>}
{0.7216, <0.70,0.78,0.21>}
{0.7255, <0.71,0.77,0.20>}
{0.7294, <0.72,0.77,0.19>}
{0.7333, <0.73,0.77,0.19>}
{0.7373, <0.75,0.77,0.18>}
{0.7412, <0.76,0.76,0.17>}
{0.7451, <0.77,0.76,0.17>}
{0.7490, <0.78,0.76,0.16>}
{0.7529, <0.79,0.76,0.16>}
{0.7569, <0.81,0.75,0.15>}
{0.7608, <0.82,0.75,0.15>}
{0.7647, <0.83,0.75,0.15>}
{0.7686, <0.84,0.75,0.15>}
{0.7725, <0.85,0.74,0.16>}
{0.7765, <0.86,0.74,0.16>}
{0.7804, <0.87,0.74,0.16>}
{0.7843, <0.88,0.74,0.17>}
{0.7882, <0.89,0.74,0.17>}
{0.7922, <0.90,0.73,0.17>}
{0.7961, <0.91,0.73,0.18>}
{0.8000, <0.92,0.73,0.19>}
{0.8039, <0.93,0.73,0.20>}
{0.8078, <0.94,0.73,0.21>}
{0.8118, <0.94,0.73,0.22>}
{0.8157, <0.95,0.73,0.22>}
{0.8196, <0.96,0.73,0.23>}
{0.8235, <0.97,0.73,0.24>}
{0.8275, <0.98,0.73,0.24>}
{0.8314, <0.98,0.73,0.24>}
{0.8353, <0.99,0.74,0.24>}
{0.8392, <0.99,0.74,0.24>}
{0.8431, <1.00,0.75,0.24>}
{0.8471, <1.00,0.75,0.23>}
{0.8510, <1.00,0.76,0.23>}
{0.8549, <1.00,0.76,0.22>}
{0.8588, <1.00,0.77,0.22>}
{0.8627, <1.00,0.77,0.21>}
{0.8667, <1.00,0.78,0.21>}
{0.8706, <1.00,0.79,0.21>}
{0.8745, <0.99,0.79,0.20>}
{0.8784, <0.99,0.80,0.20>}
{0.8824, <0.99,0.80,0.19>}
{0.8863, <0.99,0.81,0.19>}
{0.8902, <0.99,0.82,0.19>}
{0.8941, <0.99,0.82,0.18>}
{0.8980, <0.98,0.83,0.18>}
{0.9020, <0.98,0.83,0.18>}
{0.9059, <0.98,0.84,0.18>}
{0.9098, <0.97,0.85,0.17>}
{0.9137, <0.97,0.85,0.17>}
{0.9176, <0.97,0.86,0.17>}
{0.9216, <0.97,0.87,0.16>}
{0.9255, <0.97,0.87,0.16>}
{0.9294, <0.96,0.88,0.16>}
{0.9333, <0.96,0.88,0.16>}
{0.9373, <0.96,0.89,0.15>}
{0.9412, <0.96,0.90,0.15>}
{0.9451, <0.96,0.90,0.15>}
{0.9490, <0.96,0.91,0.14>}
{0.9529, <0.96,0.91,0.14>}
{0.9569, <0.96,0.92,0.14>}
{0.9608, <0.96,0.93,0.13>}
{0.9647, <0.96,0.93,0.13>}
{0.9686, <0.96,0.94,0.13>}
{0.9725, <0.96,0.94,0.12>}
{0.9765, <0.97,0.95,0.12>}
{0.9804, <0.97,0.96,0.11>}
{0.9843, <0.97,0.96,0.11>}
{0.9882, <0.97,0.97,0.10>}
{0.9922, <0.97,0.97,0.09>}
{0.9961, <0.97,0.98,0.09>}
{1.0000, <0.98,0.98,0.08>}
}

#declare turbo =array mixed [256][2] {

{0.0000, <0.19,0.07,0.23>}
{0.0039, <0.19,0.08,0.26>}
{0.0078, <0.20,0.09,0.29>}
{0.0118, <0.20,0.11,0.32>}
{0.0157, <0.21,0.12,0.35>}
{0.0196, <0.21,0.13,0.37>}
{0.0235, <0.22,0.14,0.40>}
{0.0275, <0.22,0.15,0.43>}
{0.0314, <0.23,0.16,0.45>}
{0.0353, <0.23,0.17,0.48>}
{0.0392, <0.23,0.19,0.50>}
{0.0431, <0.24,0.20,0.52>}
{0.0471, <0.24,0.21,0.55>}
{0.0510, <0.24,0.22,0.57>}
{0.0549, <0.25,0.23,0.59>}
{0.0588, <0.25,0.24,0.61>}
{0.0627, <0.25,0.25,0.63>}
{0.0667, <0.25,0.26,0.65>}
{0.0706, <0.26,0.27,0.67>}
{0.0745, <0.26,0.28,0.69>}
{0.0784, <0.26,0.30,0.71>}
{0.0824, <0.26,0.31,0.73>}
{0.0863, <0.26,0.32,0.75>}
{0.0902, <0.27,0.33,0.76>}
{0.0941, <0.27,0.34,0.78>}
{0.0980, <0.27,0.35,0.80>}
{0.1020, <0.27,0.36,0.81>}
{0.1059, <0.27,0.37,0.83>}
{0.1098, <0.27,0.38,0.84>}
{0.1137, <0.27,0.39,0.85>}
{0.1176, <0.28,0.40,0.87>}
{0.1216, <0.28,0.41,0.88>}
{0.1255, <0.28,0.42,0.89>}
{0.1294, <0.28,0.43,0.90>}
{0.1333, <0.28,0.44,0.91>}
{0.1373, <0.28,0.45,0.92>}
{0.1412, <0.28,0.46,0.93>}
{0.1451, <0.28,0.47,0.94>}
{0.1490, <0.28,0.48,0.95>}
{0.1529, <0.28,0.49,0.96>}
{0.1569, <0.28,0.50,0.97>}
{0.1608, <0.27,0.51,0.97>}
{0.1647, <0.27,0.52,0.98>}
{0.1686, <0.27,0.53,0.98>}
{0.1725, <0.27,0.54,0.99>}
{0.1765, <0.27,0.55,0.99>}
{0.1804, <0.27,0.56,1.00>}
{0.1843, <0.26,0.57,1.00>}
{0.1882, <0.26,0.58,1.00>}
{0.1922, <0.25,0.59,1.00>}
{0.1961, <0.25,0.60,1.00>}
{0.2000, <0.24,0.61,1.00>}
{0.2039, <0.24,0.62,0.99>}
{0.2078, <0.23,0.63,0.99>}
{0.2118, <0.23,0.64,0.99>}
{0.2157, <0.22,0.65,0.98>}
{0.2196, <0.21,0.66,0.98>}
{0.2235, <0.21,0.67,0.97>}
{0.2275, <0.20,0.68,0.97>}
{0.2314, <0.19,0.69,0.96>}
{0.2353, <0.19,0.70,0.95>}
{0.2392, <0.18,0.71,0.95>}
{0.2431, <0.17,0.72,0.94>}
{0.2471, <0.17,0.73,0.93>}
{0.2510, <0.16,0.74,0.92>}
{0.2549, <0.15,0.74,0.91>}
{0.2588, <0.15,0.75,0.90>}
{0.2627, <0.14,0.76,0.90>}
{0.2667, <0.13,0.77,0.89>}
{0.2706, <0.13,0.78,0.88>}
{0.2745, <0.12,0.79,0.87>}
{0.2784, <0.12,0.80,0.86>}
{0.2824, <0.11,0.81,0.85>}
{0.2863, <0.11,0.81,0.83>}
{0.2902, <0.10,0.82,0.82>}
{0.2941, <0.10,0.83,0.81>}
{0.2980, <0.10,0.84,0.80>}
{0.3020, <0.10,0.84,0.79>}
{0.3059, <0.09,0.85,0.78>}
{0.3098, <0.09,0.86,0.77>}
{0.3137, <0.09,0.87,0.76>}
{0.3176, <0.09,0.87,0.75>}
{0.3216, <0.09,0.88,0.74>}
{0.3255, <0.10,0.88,0.73>}
{0.3294, <0.10,0.89,0.72>}
{0.3333, <0.10,0.90,0.71>}
{0.3373, <0.11,0.90,0.71>}
{0.3412, <0.11,0.91,0.70>}
{0.3451, <0.12,0.91,0.69>}
{0.3490, <0.13,0.92,0.68>}
{0.3529, <0.14,0.92,0.67>}
{0.3569, <0.14,0.93,0.65>}
{0.3608, <0.15,0.93,0.64>}
{0.3647, <0.16,0.94,0.63>}
{0.3686, <0.17,0.94,0.62>}
{0.3725, <0.18,0.94,0.61>}
{0.3765, <0.20,0.95,0.59>}
{0.3804, <0.21,0.95,0.58>}
{0.3843, <0.22,0.96,0.57>}
{0.3882, <0.23,0.96,0.56>}
{0.3922, <0.25,0.96,0.54>}
{0.3961, <0.26,0.97,0.53>}
{0.4000, <0.28,0.97,0.52>}
{0.4039, <0.29,0.97,0.50>}
{0.4078, <0.31,0.98,0.49>}
{0.4118, <0.32,0.98,0.48>}
{0.4157, <0.34,0.98,0.46>}
{0.4196, <0.35,0.98,0.45>}
{0.4235, <0.37,0.99,0.44>}
{0.4275, <0.38,0.99,0.42>}
{0.4314, <0.40,0.99,0.41>}
{0.4353, <0.41,0.99,0.40>}
{0.4392, <0.43,0.99,0.39>}
{0.4431, <0.44,1.00,0.37>}
{0.4471, <0.46,1.00,0.36>}
{0.4510, <0.47,1.00,0.35>}
{0.4549, <0.49,1.00,0.34>}
{0.4588, <0.50,1.00,0.33>}
{0.4627, <0.52,1.00,0.32>}
{0.4667, <0.53,1.00,0.31>}
{0.4706, <0.55,1.00,0.30>}
{0.4745, <0.56,1.00,0.29>}
{0.4784, <0.57,1.00,0.28>}
{0.4824, <0.59,1.00,0.27>}
{0.4863, <0.60,1.00,0.26>}
{0.4902, <0.61,1.00,0.25>}
{0.4941, <0.62,0.99,0.25>}
{0.4980, <0.63,0.99,0.24>}
{0.5020, <0.64,0.99,0.23>}
{0.5059, <0.65,0.99,0.23>}
{0.5098, <0.66,0.99,0.22>}
{0.5137, <0.67,0.98,0.22>}
{0.5176, <0.68,0.98,0.22>}
{0.5216, <0.70,0.98,0.21>}
{0.5255, <0.71,0.97,0.21>}
{0.5294, <0.72,0.97,0.21>}
{0.5333, <0.73,0.96,0.21>}
{0.5373, <0.74,0.96,0.21>}
{0.5412, <0.75,0.96,0.20>}
{0.5451, <0.76,0.95,0.20>}
{0.5490, <0.77,0.95,0.20>}
{0.5529, <0.78,0.94,0.20>}
{0.5569, <0.79,0.94,0.20>}
{0.5608, <0.80,0.93,0.20>}
{0.5647, <0.80,0.92,0.20>}
{0.5686, <0.81,0.92,0.21>}
{0.5725, <0.82,0.91,0.21>}
{0.5765, <0.83,0.91,0.21>}
{0.5804, <0.84,0.90,0.21>}
{0.5843, <0.85,0.89,0.21>}
{0.5882, <0.86,0.89,0.21>}
{0.5922, <0.87,0.88,0.21>}
{0.5961, <0.88,0.87,0.22>}
{0.6000, <0.88,0.87,0.22>}
{0.6039, <0.89,0.86,0.22>}
{0.6078, <0.90,0.85,0.22>}
{0.6118, <0.91,0.84,0.22>}
{0.6157, <0.91,0.84,0.22>}
{0.6196, <0.92,0.83,0.22>}
{0.6235, <0.93,0.82,0.23>}
{0.6275, <0.93,0.81,0.23>}
{0.6314, <0.94,0.80,0.23>}
{0.6353, <0.94,0.80,0.23>}
{0.6392, <0.95,0.79,0.23>}
{0.6431, <0.96,0.78,0.23>}
{0.6471, <0.96,0.77,0.23>}
{0.6510, <0.97,0.76,0.23>}
{0.6549, <0.97,0.76,0.23>}
{0.6588, <0.97,0.75,0.23>}
{0.6627, <0.98,0.74,0.22>}
{0.6667, <0.98,0.73,0.22>}
{0.6706, <0.98,0.72,0.22>}
{0.6745, <0.99,0.71,0.22>}
{0.6784, <0.99,0.70,0.21>}
{0.6824, <0.99,0.69,0.21>}
{0.6863, <0.99,0.68,0.21>}
{0.6902, <0.99,0.67,0.20>}
{0.6941, <0.99,0.66,0.20>}
{0.6980, <1.00,0.65,0.20>}
{0.7020, <1.00,0.64,0.19>}
{0.7059, <1.00,0.63,0.19>}
{0.7098, <1.00,0.62,0.18>}
{0.7137, <1.00,0.61,0.18>}
{0.7176, <1.00,0.60,0.17>}
{0.7216, <1.00,0.59,0.17>}
{0.7255, <1.00,0.58,0.16>}
{0.7294, <0.99,0.56,0.16>}
{0.7333, <0.99,0.55,0.15>}
{0.7373, <0.99,0.54,0.15>}
{0.7412, <0.99,0.53,0.14>}
{0.7451, <0.99,0.52,0.14>}
{0.7490, <0.99,0.50,0.13>}
{0.7529, <0.98,0.49,0.13>}
{0.7569, <0.98,0.48,0.12>}
{0.7608, <0.98,0.47,0.12>}
{0.7647, <0.98,0.46,0.11>}
{0.7686, <0.97,0.45,0.11>}
{0.7725, <0.97,0.43,0.10>}
{0.7765, <0.97,0.42,0.10>}
{0.7804, <0.96,0.41,0.09>}
{0.7843, <0.96,0.40,0.09>}
{0.7882, <0.95,0.39,0.08>}
{0.7922, <0.95,0.38,0.08>}
{0.7961, <0.95,0.37,0.07>}
{0.8000, <0.94,0.36,0.07>}
{0.8039, <0.94,0.35,0.07>}
{0.8078, <0.93,0.33,0.06>}
{0.8118, <0.93,0.32,0.06>}
{0.8157, <0.92,0.31,0.05>}
{0.8196, <0.92,0.31,0.05>}
{0.8235, <0.91,0.30,0.05>}
{0.8275, <0.90,0.29,0.05>}
{0.8314, <0.90,0.28,0.04>}
{0.8353, <0.89,0.27,0.04>}
{0.8392, <0.89,0.26,0.04>}
{0.8431, <0.88,0.25,0.04>}
{0.8471, <0.87,0.25,0.03>}
{0.8510, <0.87,0.24,0.03>}
{0.8549, <0.86,0.23,0.03>}
{0.8588, <0.85,0.22,0.03>}
{0.8627, <0.85,0.21,0.02>}
{0.8667, <0.84,0.21,0.02>}
{0.8706, <0.83,0.20,0.02>}
{0.8745, <0.82,0.19,0.02>}
{0.8784, <0.82,0.18,0.02>}
{0.8824, <0.81,0.18,0.02>}
{0.8863, <0.80,0.17,0.02>}
{0.8902, <0.79,0.16,0.01>}
{0.8941, <0.78,0.16,0.01>}
{0.8980, <0.77,0.15,0.01>}
{0.9020, <0.76,0.14,0.01>}
{0.9059, <0.76,0.14,0.01>}
{0.9098, <0.75,0.13,0.01>}
{0.9137, <0.74,0.12,0.01>}
{0.9176, <0.73,0.12,0.01>}
{0.9216, <0.72,0.11,0.01>}
{0.9255, <0.71,0.11,0.01>}
{0.9294, <0.70,0.10,0.01>}
{0.9333, <0.69,0.10,0.00>}
{0.9373, <0.68,0.09,0.00>}
{0.9412, <0.66,0.08,0.00>}
{0.9451, <0.65,0.08,0.00>}
{0.9490, <0.64,0.07,0.00>}
{0.9529, <0.63,0.07,0.00>}
{0.9569, <0.62,0.06,0.00>}
{0.9608, <0.61,0.06,0.00>}
{0.9647, <0.60,0.05,0.00>}
{0.9686, <0.58,0.05,0.00>}
{0.9725, <0.57,0.04,0.01>}
{0.9765, <0.56,0.04,0.01>}
{0.9804, <0.55,0.04,0.01>}
{0.9843, <0.53,0.03,0.01>}
{0.9882, <0.52,0.03,0.01>}
{0.9922, <0.51,0.02,0.01>}
{0.9961, <0.49,0.02,0.01>}
{1.0000, <0.48,0.02,0.01>}
}

#declare summer =array mixed [256][2] {
{0.0000, <0.00,0.50,0.40>}
{0.0039, <0.00,0.50,0.40>}
{0.0078, <0.01,0.50,0.40>}
{0.0118, <0.01,0.51,0.40>}
{0.0157, <0.02,0.51,0.40>}
{0.0196, <0.02,0.51,0.40>}
{0.0235, <0.02,0.51,0.40>}
{0.0275, <0.03,0.51,0.40>}
{0.0314, <0.03,0.52,0.40>}
{0.0353, <0.04,0.52,0.40>}
{0.0392, <0.04,0.52,0.40>}
{0.0431, <0.04,0.52,0.40>}
{0.0471, <0.05,0.52,0.40>}
{0.0510, <0.05,0.53,0.40>}
{0.0549, <0.05,0.53,0.40>}
{0.0588, <0.06,0.53,0.40>}
{0.0627, <0.06,0.53,0.40>}
{0.0667, <0.07,0.53,0.40>}
{0.0706, <0.07,0.54,0.40>}
{0.0745, <0.07,0.54,0.40>}
{0.0784, <0.08,0.54,0.40>}
{0.0824, <0.08,0.54,0.40>}
{0.0863, <0.09,0.54,0.40>}
{0.0902, <0.09,0.55,0.40>}
{0.0941, <0.09,0.55,0.40>}
{0.0980, <0.10,0.55,0.40>}
{0.1020, <0.10,0.55,0.40>}
{0.1059, <0.11,0.55,0.40>}
{0.1098, <0.11,0.55,0.40>}
{0.1137, <0.11,0.56,0.40>}
{0.1176, <0.12,0.56,0.40>}
{0.1216, <0.12,0.56,0.40>}
{0.1255, <0.13,0.56,0.40>}
{0.1294, <0.13,0.56,0.40>}
{0.1333, <0.13,0.57,0.40>}
{0.1373, <0.14,0.57,0.40>}
{0.1412, <0.14,0.57,0.40>}
{0.1451, <0.15,0.57,0.40>}
{0.1490, <0.15,0.57,0.40>}
{0.1529, <0.15,0.58,0.40>}
{0.1569, <0.16,0.58,0.40>}
{0.1608, <0.16,0.58,0.40>}
{0.1647, <0.16,0.58,0.40>}
{0.1686, <0.17,0.58,0.40>}
{0.1725, <0.17,0.59,0.40>}
{0.1765, <0.18,0.59,0.40>}
{0.1804, <0.18,0.59,0.40>}
{0.1843, <0.18,0.59,0.40>}
{0.1882, <0.19,0.59,0.40>}
{0.1922, <0.19,0.60,0.40>}
{0.1961, <0.20,0.60,0.40>}
{0.2000, <0.20,0.60,0.40>}
{0.2039, <0.20,0.60,0.40>}
{0.2078, <0.21,0.60,0.40>}
{0.2118, <0.21,0.61,0.40>}
{0.2157, <0.22,0.61,0.40>}
{0.2196, <0.22,0.61,0.40>}
{0.2235, <0.22,0.61,0.40>}
{0.2275, <0.23,0.61,0.40>}
{0.2314, <0.23,0.62,0.40>}
{0.2353, <0.24,0.62,0.40>}
{0.2392, <0.24,0.62,0.40>}
{0.2431, <0.24,0.62,0.40>}
{0.2471, <0.25,0.62,0.40>}
{0.2510, <0.25,0.63,0.40>}
{0.2549, <0.25,0.63,0.40>}
{0.2588, <0.26,0.63,0.40>}
{0.2627, <0.26,0.63,0.40>}
{0.2667, <0.27,0.63,0.40>}
{0.2706, <0.27,0.64,0.40>}
{0.2745, <0.27,0.64,0.40>}
{0.2784, <0.28,0.64,0.40>}
{0.2824, <0.28,0.64,0.40>}
{0.2863, <0.29,0.64,0.40>}
{0.2902, <0.29,0.65,0.40>}
{0.2941, <0.29,0.65,0.40>}
{0.2980, <0.30,0.65,0.40>}
{0.3020, <0.30,0.65,0.40>}
{0.3059, <0.31,0.65,0.40>}
{0.3098, <0.31,0.65,0.40>}
{0.3137, <0.31,0.66,0.40>}
{0.3176, <0.32,0.66,0.40>}
{0.3216, <0.32,0.66,0.40>}
{0.3255, <0.33,0.66,0.40>}
{0.3294, <0.33,0.66,0.40>}
{0.3333, <0.33,0.67,0.40>}
{0.3373, <0.34,0.67,0.40>}
{0.3412, <0.34,0.67,0.40>}
{0.3451, <0.35,0.67,0.40>}
{0.3490, <0.35,0.67,0.40>}
{0.3529, <0.35,0.68,0.40>}
{0.3569, <0.36,0.68,0.40>}
{0.3608, <0.36,0.68,0.40>}
{0.3647, <0.36,0.68,0.40>}
{0.3686, <0.37,0.68,0.40>}
{0.3725, <0.37,0.69,0.40>}
{0.3765, <0.38,0.69,0.40>}
{0.3804, <0.38,0.69,0.40>}
{0.3843, <0.38,0.69,0.40>}
{0.3882, <0.39,0.69,0.40>}
{0.3922, <0.39,0.70,0.40>}
{0.3961, <0.40,0.70,0.40>}
{0.4000, <0.40,0.70,0.40>}
{0.4039, <0.40,0.70,0.40>}
{0.4078, <0.41,0.70,0.40>}
{0.4118, <0.41,0.71,0.40>}
{0.4157, <0.42,0.71,0.40>}
{0.4196, <0.42,0.71,0.40>}
{0.4235, <0.42,0.71,0.40>}
{0.4275, <0.43,0.71,0.40>}
{0.4314, <0.43,0.72,0.40>}
{0.4353, <0.44,0.72,0.40>}
{0.4392, <0.44,0.72,0.40>}
{0.4431, <0.44,0.72,0.40>}
{0.4471, <0.45,0.72,0.40>}
{0.4510, <0.45,0.73,0.40>}
{0.4549, <0.45,0.73,0.40>}
{0.4588, <0.46,0.73,0.40>}
{0.4627, <0.46,0.73,0.40>}
{0.4667, <0.47,0.73,0.40>}
{0.4706, <0.47,0.74,0.40>}
{0.4745, <0.47,0.74,0.40>}
{0.4784, <0.48,0.74,0.40>}
{0.4824, <0.48,0.74,0.40>}
{0.4863, <0.49,0.74,0.40>}
{0.4902, <0.49,0.75,0.40>}
{0.4941, <0.49,0.75,0.40>}
{0.4980, <0.50,0.75,0.40>}
{0.5020, <0.50,0.75,0.40>}
{0.5059, <0.51,0.75,0.40>}
{0.5098, <0.51,0.75,0.40>}
{0.5137, <0.51,0.76,0.40>}
{0.5176, <0.52,0.76,0.40>}
{0.5216, <0.52,0.76,0.40>}
{0.5255, <0.53,0.76,0.40>}
{0.5294, <0.53,0.76,0.40>}
{0.5333, <0.53,0.77,0.40>}
{0.5373, <0.54,0.77,0.40>}
{0.5412, <0.54,0.77,0.40>}
{0.5451, <0.55,0.77,0.40>}
{0.5490, <0.55,0.77,0.40>}
{0.5529, <0.55,0.78,0.40>}
{0.5569, <0.56,0.78,0.40>}
{0.5608, <0.56,0.78,0.40>}
{0.5647, <0.56,0.78,0.40>}
{0.5686, <0.57,0.78,0.40>}
{0.5725, <0.57,0.79,0.40>}
{0.5765, <0.58,0.79,0.40>}
{0.5804, <0.58,0.79,0.40>}
{0.5843, <0.58,0.79,0.40>}
{0.5882, <0.59,0.79,0.40>}
{0.5922, <0.59,0.80,0.40>}
{0.5961, <0.60,0.80,0.40>}
{0.6000, <0.60,0.80,0.40>}
{0.6039, <0.60,0.80,0.40>}
{0.6078, <0.61,0.80,0.40>}
{0.6118, <0.61,0.81,0.40>}
{0.6157, <0.62,0.81,0.40>}
{0.6196, <0.62,0.81,0.40>}
{0.6235, <0.62,0.81,0.40>}
{0.6275, <0.63,0.81,0.40>}
{0.6314, <0.63,0.82,0.40>}
{0.6353, <0.64,0.82,0.40>}
{0.6392, <0.64,0.82,0.40>}
{0.6431, <0.64,0.82,0.40>}
{0.6471, <0.65,0.82,0.40>}
{0.6510, <0.65,0.83,0.40>}
{0.6549, <0.65,0.83,0.40>}
{0.6588, <0.66,0.83,0.40>}
{0.6627, <0.66,0.83,0.40>}
{0.6667, <0.67,0.83,0.40>}
{0.6706, <0.67,0.84,0.40>}
{0.6745, <0.67,0.84,0.40>}
{0.6784, <0.68,0.84,0.40>}
{0.6824, <0.68,0.84,0.40>}
{0.6863, <0.69,0.84,0.40>}
{0.6902, <0.69,0.85,0.40>}
{0.6941, <0.69,0.85,0.40>}
{0.6980, <0.70,0.85,0.40>}
{0.7020, <0.70,0.85,0.40>}
{0.7059, <0.71,0.85,0.40>}
{0.7098, <0.71,0.85,0.40>}
{0.7137, <0.71,0.86,0.40>}
{0.7176, <0.72,0.86,0.40>}
{0.7216, <0.72,0.86,0.40>}
{0.7255, <0.73,0.86,0.40>}
{0.7294, <0.73,0.86,0.40>}
{0.7333, <0.73,0.87,0.40>}
{0.7373, <0.74,0.87,0.40>}
{0.7412, <0.74,0.87,0.40>}
{0.7451, <0.75,0.87,0.40>}
{0.7490, <0.75,0.87,0.40>}
{0.7529, <0.75,0.88,0.40>}
{0.7569, <0.76,0.88,0.40>}
{0.7608, <0.76,0.88,0.40>}
{0.7647, <0.76,0.88,0.40>}
{0.7686, <0.77,0.88,0.40>}
{0.7725, <0.77,0.89,0.40>}
{0.7765, <0.78,0.89,0.40>}
{0.7804, <0.78,0.89,0.40>}
{0.7843, <0.78,0.89,0.40>}
{0.7882, <0.79,0.89,0.40>}
{0.7922, <0.79,0.90,0.40>}
{0.7961, <0.80,0.90,0.40>}
{0.8000, <0.80,0.90,0.40>}
{0.8039, <0.80,0.90,0.40>}
{0.8078, <0.81,0.90,0.40>}
{0.8118, <0.81,0.91,0.40>}
{0.8157, <0.82,0.91,0.40>}
{0.8196, <0.82,0.91,0.40>}
{0.8235, <0.82,0.91,0.40>}
{0.8275, <0.83,0.91,0.40>}
{0.8314, <0.83,0.92,0.40>}
{0.8353, <0.84,0.92,0.40>}
{0.8392, <0.84,0.92,0.40>}
{0.8431, <0.84,0.92,0.40>}
{0.8471, <0.85,0.92,0.40>}
{0.8510, <0.85,0.93,0.40>}
{0.8549, <0.85,0.93,0.40>}
{0.8588, <0.86,0.93,0.40>}
{0.8627, <0.86,0.93,0.40>}
{0.8667, <0.87,0.93,0.40>}
{0.8706, <0.87,0.94,0.40>}
{0.8745, <0.87,0.94,0.40>}
{0.8784, <0.88,0.94,0.40>}
{0.8824, <0.88,0.94,0.40>}
{0.8863, <0.89,0.94,0.40>}
{0.8902, <0.89,0.95,0.40>}
{0.8941, <0.89,0.95,0.40>}
{0.8980, <0.90,0.95,0.40>}
{0.9020, <0.90,0.95,0.40>}
{0.9059, <0.91,0.95,0.40>}
{0.9098, <0.91,0.95,0.40>}
{0.9137, <0.91,0.96,0.40>}
{0.9176, <0.92,0.96,0.40>}
{0.9216, <0.92,0.96,0.40>}
{0.9255, <0.93,0.96,0.40>}
{0.9294, <0.93,0.96,0.40>}
{0.9333, <0.93,0.97,0.40>}
{0.9373, <0.94,0.97,0.40>}
{0.9412, <0.94,0.97,0.40>}
{0.9451, <0.95,0.97,0.40>}
{0.9490, <0.95,0.97,0.40>}
{0.9529, <0.95,0.98,0.40>}
{0.9569, <0.96,0.98,0.40>}
{0.9608, <0.96,0.98,0.40>}
{0.9647, <0.96,0.98,0.40>}
{0.9686, <0.97,0.98,0.40>}
{0.9725, <0.97,0.99,0.40>}
{0.9765, <0.98,0.99,0.40>}
{0.9804, <0.98,0.99,0.40>}
{0.9843, <0.98,0.99,0.40>}
{0.9882, <0.99,0.99,0.40>}
{0.9922, <0.99,1.00,0.40>}
{0.9961, <1.00,1.00,0.40>}
{1.0000, <1.00,1.00,0.40>}
}

#declare cool =array mixed [256][2] {
{0.0000, <0.00,1.00,1.00>}
{0.0039, <0.00,1.00,1.00>}
{0.0078, <0.01,0.99,1.00>}
{0.0118, <0.01,0.99,1.00>}
{0.0157, <0.02,0.98,1.00>}
{0.0196, <0.02,0.98,1.00>}
{0.0235, <0.02,0.98,1.00>}
{0.0275, <0.03,0.97,1.00>}
{0.0314, <0.03,0.97,1.00>}
{0.0353, <0.04,0.96,1.00>}
{0.0392, <0.04,0.96,1.00>}
{0.0431, <0.04,0.96,1.00>}
{0.0471, <0.05,0.95,1.00>}
{0.0510, <0.05,0.95,1.00>}
{0.0549, <0.05,0.95,1.00>}
{0.0588, <0.06,0.94,1.00>}
{0.0627, <0.06,0.94,1.00>}
{0.0667, <0.07,0.93,1.00>}
{0.0706, <0.07,0.93,1.00>}
{0.0745, <0.07,0.93,1.00>}
{0.0784, <0.08,0.92,1.00>}
{0.0824, <0.08,0.92,1.00>}
{0.0863, <0.09,0.91,1.00>}
{0.0902, <0.09,0.91,1.00>}
{0.0941, <0.09,0.91,1.00>}
{0.0980, <0.10,0.90,1.00>}
{0.1020, <0.10,0.90,1.00>}
{0.1059, <0.11,0.89,1.00>}
{0.1098, <0.11,0.89,1.00>}
{0.1137, <0.11,0.89,1.00>}
{0.1176, <0.12,0.88,1.00>}
{0.1216, <0.12,0.88,1.00>}
{0.1255, <0.13,0.87,1.00>}
{0.1294, <0.13,0.87,1.00>}
{0.1333, <0.13,0.87,1.00>}
{0.1373, <0.14,0.86,1.00>}
{0.1412, <0.14,0.86,1.00>}
{0.1451, <0.15,0.85,1.00>}
{0.1490, <0.15,0.85,1.00>}
{0.1529, <0.15,0.85,1.00>}
{0.1569, <0.16,0.84,1.00>}
{0.1608, <0.16,0.84,1.00>}
{0.1647, <0.16,0.84,1.00>}
{0.1686, <0.17,0.83,1.00>}
{0.1725, <0.17,0.83,1.00>}
{0.1765, <0.18,0.82,1.00>}
{0.1804, <0.18,0.82,1.00>}
{0.1843, <0.18,0.82,1.00>}
{0.1882, <0.19,0.81,1.00>}
{0.1922, <0.19,0.81,1.00>}
{0.1961, <0.20,0.80,1.00>}
{0.2000, <0.20,0.80,1.00>}
{0.2039, <0.20,0.80,1.00>}
{0.2078, <0.21,0.79,1.00>}
{0.2118, <0.21,0.79,1.00>}
{0.2157, <0.22,0.78,1.00>}
{0.2196, <0.22,0.78,1.00>}
{0.2235, <0.22,0.78,1.00>}
{0.2275, <0.23,0.77,1.00>}
{0.2314, <0.23,0.77,1.00>}
{0.2353, <0.24,0.76,1.00>}
{0.2392, <0.24,0.76,1.00>}
{0.2431, <0.24,0.76,1.00>}
{0.2471, <0.25,0.75,1.00>}
{0.2510, <0.25,0.75,1.00>}
{0.2549, <0.25,0.75,1.00>}
{0.2588, <0.26,0.74,1.00>}
{0.2627, <0.26,0.74,1.00>}
{0.2667, <0.27,0.73,1.00>}
{0.2706, <0.27,0.73,1.00>}
{0.2745, <0.27,0.73,1.00>}
{0.2784, <0.28,0.72,1.00>}
{0.2824, <0.28,0.72,1.00>}
{0.2863, <0.29,0.71,1.00>}
{0.2902, <0.29,0.71,1.00>}
{0.2941, <0.29,0.71,1.00>}
{0.2980, <0.30,0.70,1.00>}
{0.3020, <0.30,0.70,1.00>}
{0.3059, <0.31,0.69,1.00>}
{0.3098, <0.31,0.69,1.00>}
{0.3137, <0.31,0.69,1.00>}
{0.3176, <0.32,0.68,1.00>}
{0.3216, <0.32,0.68,1.00>}
{0.3255, <0.33,0.67,1.00>}
{0.3294, <0.33,0.67,1.00>}
{0.3333, <0.33,0.67,1.00>}
{0.3373, <0.34,0.66,1.00>}
{0.3412, <0.34,0.66,1.00>}
{0.3451, <0.35,0.65,1.00>}
{0.3490, <0.35,0.65,1.00>}
{0.3529, <0.35,0.65,1.00>}
{0.3569, <0.36,0.64,1.00>}
{0.3608, <0.36,0.64,1.00>}
{0.3647, <0.36,0.64,1.00>}
{0.3686, <0.37,0.63,1.00>}
{0.3725, <0.37,0.63,1.00>}
{0.3765, <0.38,0.62,1.00>}
{0.3804, <0.38,0.62,1.00>}
{0.3843, <0.38,0.62,1.00>}
{0.3882, <0.39,0.61,1.00>}
{0.3922, <0.39,0.61,1.00>}
{0.3961, <0.40,0.60,1.00>}
{0.4000, <0.40,0.60,1.00>}
{0.4039, <0.40,0.60,1.00>}
{0.4078, <0.41,0.59,1.00>}
{0.4118, <0.41,0.59,1.00>}
{0.4157, <0.42,0.58,1.00>}
{0.4196, <0.42,0.58,1.00>}
{0.4235, <0.42,0.58,1.00>}
{0.4275, <0.43,0.57,1.00>}
{0.4314, <0.43,0.57,1.00>}
{0.4353, <0.44,0.56,1.00>}
{0.4392, <0.44,0.56,1.00>}
{0.4431, <0.44,0.56,1.00>}
{0.4471, <0.45,0.55,1.00>}
{0.4510, <0.45,0.55,1.00>}
{0.4549, <0.45,0.55,1.00>}
{0.4588, <0.46,0.54,1.00>}
{0.4627, <0.46,0.54,1.00>}
{0.4667, <0.47,0.53,1.00>}
{0.4706, <0.47,0.53,1.00>}
{0.4745, <0.47,0.53,1.00>}
{0.4784, <0.48,0.52,1.00>}
{0.4824, <0.48,0.52,1.00>}
{0.4863, <0.49,0.51,1.00>}
{0.4902, <0.49,0.51,1.00>}
{0.4941, <0.49,0.51,1.00>}
{0.4980, <0.50,0.50,1.00>}
{0.5020, <0.50,0.50,1.00>}
{0.5059, <0.51,0.49,1.00>}
{0.5098, <0.51,0.49,1.00>}
{0.5137, <0.51,0.49,1.00>}
{0.5176, <0.52,0.48,1.00>}
{0.5216, <0.52,0.48,1.00>}
{0.5255, <0.53,0.47,1.00>}
{0.5294, <0.53,0.47,1.00>}
{0.5333, <0.53,0.47,1.00>}
{0.5373, <0.54,0.46,1.00>}
{0.5412, <0.54,0.46,1.00>}
{0.5451, <0.55,0.45,1.00>}
{0.5490, <0.55,0.45,1.00>}
{0.5529, <0.55,0.45,1.00>}
{0.5569, <0.56,0.44,1.00>}
{0.5608, <0.56,0.44,1.00>}
{0.5647, <0.56,0.44,1.00>}
{0.5686, <0.57,0.43,1.00>}
{0.5725, <0.57,0.43,1.00>}
{0.5765, <0.58,0.42,1.00>}
{0.5804, <0.58,0.42,1.00>}
{0.5843, <0.58,0.42,1.00>}
{0.5882, <0.59,0.41,1.00>}
{0.5922, <0.59,0.41,1.00>}
{0.5961, <0.60,0.40,1.00>}
{0.6000, <0.60,0.40,1.00>}
{0.6039, <0.60,0.40,1.00>}
{0.6078, <0.61,0.39,1.00>}
{0.6118, <0.61,0.39,1.00>}
{0.6157, <0.62,0.38,1.00>}
{0.6196, <0.62,0.38,1.00>}
{0.6235, <0.62,0.38,1.00>}
{0.6275, <0.63,0.37,1.00>}
{0.6314, <0.63,0.37,1.00>}
{0.6353, <0.64,0.36,1.00>}
{0.6392, <0.64,0.36,1.00>}
{0.6431, <0.64,0.36,1.00>}
{0.6471, <0.65,0.35,1.00>}
{0.6510, <0.65,0.35,1.00>}
{0.6549, <0.65,0.35,1.00>}
{0.6588, <0.66,0.34,1.00>}
{0.6627, <0.66,0.34,1.00>}
{0.6667, <0.67,0.33,1.00>}
{0.6706, <0.67,0.33,1.00>}
{0.6745, <0.67,0.33,1.00>}
{0.6784, <0.68,0.32,1.00>}
{0.6824, <0.68,0.32,1.00>}
{0.6863, <0.69,0.31,1.00>}
{0.6902, <0.69,0.31,1.00>}
{0.6941, <0.69,0.31,1.00>}
{0.6980, <0.70,0.30,1.00>}
{0.7020, <0.70,0.30,1.00>}
{0.7059, <0.71,0.29,1.00>}
{0.7098, <0.71,0.29,1.00>}
{0.7137, <0.71,0.29,1.00>}
{0.7176, <0.72,0.28,1.00>}
{0.7216, <0.72,0.28,1.00>}
{0.7255, <0.73,0.27,1.00>}
{0.7294, <0.73,0.27,1.00>}
{0.7333, <0.73,0.27,1.00>}
{0.7373, <0.74,0.26,1.00>}
{0.7412, <0.74,0.26,1.00>}
{0.7451, <0.75,0.25,1.00>}
{0.7490, <0.75,0.25,1.00>}
{0.7529, <0.75,0.25,1.00>}
{0.7569, <0.76,0.24,1.00>}
{0.7608, <0.76,0.24,1.00>}
{0.7647, <0.76,0.24,1.00>}
{0.7686, <0.77,0.23,1.00>}
{0.7725, <0.77,0.23,1.00>}
{0.7765, <0.78,0.22,1.00>}
{0.7804, <0.78,0.22,1.00>}
{0.7843, <0.78,0.22,1.00>}
{0.7882, <0.79,0.21,1.00>}
{0.7922, <0.79,0.21,1.00>}
{0.7961, <0.80,0.20,1.00>}
{0.8000, <0.80,0.20,1.00>}
{0.8039, <0.80,0.20,1.00>}
{0.8078, <0.81,0.19,1.00>}
{0.8118, <0.81,0.19,1.00>}
{0.8157, <0.82,0.18,1.00>}
{0.8196, <0.82,0.18,1.00>}
{0.8235, <0.82,0.18,1.00>}
{0.8275, <0.83,0.17,1.00>}
{0.8314, <0.83,0.17,1.00>}
{0.8353, <0.84,0.16,1.00>}
{0.8392, <0.84,0.16,1.00>}
{0.8431, <0.84,0.16,1.00>}
{0.8471, <0.85,0.15,1.00>}
{0.8510, <0.85,0.15,1.00>}
{0.8549, <0.85,0.15,1.00>}
{0.8588, <0.86,0.14,1.00>}
{0.8627, <0.86,0.14,1.00>}
{0.8667, <0.87,0.13,1.00>}
{0.8706, <0.87,0.13,1.00>}
{0.8745, <0.87,0.13,1.00>}
{0.8784, <0.88,0.12,1.00>}
{0.8824, <0.88,0.12,1.00>}
{0.8863, <0.89,0.11,1.00>}
{0.8902, <0.89,0.11,1.00>}
{0.8941, <0.89,0.11,1.00>}
{0.8980, <0.90,0.10,1.00>}
{0.9020, <0.90,0.10,1.00>}
{0.9059, <0.91,0.09,1.00>}
{0.9098, <0.91,0.09,1.00>}
{0.9137, <0.91,0.09,1.00>}
{0.9176, <0.92,0.08,1.00>}
{0.9216, <0.92,0.08,1.00>}
{0.9255, <0.93,0.07,1.00>}
{0.9294, <0.93,0.07,1.00>}
{0.9333, <0.93,0.07,1.00>}
{0.9373, <0.94,0.06,1.00>}
{0.9412, <0.94,0.06,1.00>}
{0.9451, <0.95,0.05,1.00>}
{0.9490, <0.95,0.05,1.00>}
{0.9529, <0.95,0.05,1.00>}
{0.9569, <0.96,0.04,1.00>}
{0.9608, <0.96,0.04,1.00>}
{0.9647, <0.96,0.04,1.00>}
{0.9686, <0.97,0.03,1.00>}
{0.9725, <0.97,0.03,1.00>}
{0.9765, <0.98,0.02,1.00>}
{0.9804, <0.98,0.02,1.00>}
{0.9843, <0.98,0.02,1.00>}
{0.9882, <0.99,0.01,1.00>}
{0.9922, <0.99,0.01,1.00>}
{0.9961, <1.00,0.00,1.00>}
{1.0000, <1.00,0.00,1.00>}
}