/* usaf - Ulam Spiral (animation) Fun */

#version 3.8;

global_settings {assumed_gamma 1}

/* guard */
#if (!final_frame)
  #error "oops, must run this scene from the .ini file provided."
#end


//#declare verbose_ = false;
#declare verbose_ = true;

//#declare log_frames_ = false;
#declare log_frames_ = true;

/* the Wikipedia article suggests that '1' on the spiral can, in fact,
 * be any integer, they give example '41'; requires corresponding csv
 * and setting start/end frames in ini.
 */
#declare addend_ = 0;


light_source {<-1,1,-1> * 1e3 color srgb 1 parallel}
light_source {<1,1,-1> * 1e3 color srgb 1 parallel}

#include "filed.inc"
#include "foreach.inc"
#include "ruled.inc"
#include "usaf.inc"

/* file/record layouts.
 * camera: {locy, locz, latz}
 * items:  {(isPrime), point}
 * logger: {frame, {state}}
 * state:  {prev, curr, face, stride, leg, n}
 */
#declare camrcd_ = array [3] {"F8","F8","F8"};
#declare itmrcd_ = array [2] {"B","V33"};
#declare logrcd_ = array [7] {"I","V20","V20","I","I","I","I"};
#declare objrcd_ = array [6] {"V20","V20","I","I","I","I"};

/* small primes lookup, load before setting working directory */
#declare primes_ = dictionary {
  .File     : "usaf.csv",
  .Access   : "r",
  .Fields   : array [1] {"I"},
  .hasNames : true
};
Filed(primes_)

/* ideally use RAM disk.  want same path in .ini file */
#declare fild_workingDir = "/tmp/render/";

/* 40° over 320 frames */
#macro m_mkAngle(n_) n_ * .125 #end

#if (frame_number)
  // check have needed files.
  #if (!usaf__chkFilesExist(true))
    #error "oops, missing state and or items files."
  #elseif (!usaf__haveCamFile())
    #error "oops, missing camera vars file."
  #end
  // update camera, set angle too.
  #declare cv_ = dictionary {
    .File    : usaf__data_files_[3],
    .Access  : "r",
    .Fields  : camrcd_,
    .Strict  : false,
    .Verbose : verbose_
  };
  Filed(cv_)
  #switch (frame_number)
    #range (0,159)
      usaf__incr(cv_.Data[0][0],.01)
      usaf__incr(cv_.Data[0][1],.10)
      usaf__incr(cv_.Data[0][2],.05)
    #range (0,319)
      #local angle_ = 30 + m_mkAngle(frame_number);
      #break
    #else
      usaf__incr(cv_.Data[0][0],.005)
      usaf__incr(cv_.Data[0][1],.0115)
      #local angle_ = 70;
  #end
  #local cv_.Access = "w";
  Filed(cv_)
  // load state, step object, save new state.
  #declare state_ = dictionary {
    .File    : usaf__data_files_[0],
    .Access  : "r",
    .Fields  : objrcd_,
    .Strict  : false,
    .Verbose : verbose_
  };
  Filed(state_)
  usaf__obj(state_.Data[0])
  #local state_.Access = "w";
  Filed(state_)
  // append items, starts at frame 0, hence...
  #declare items_ = dictionary {
    .File    : usaf__data_files_[1],
    .Access  : "a",
    .Fields  : itmrcd_,
    .Data    : array {
                array mixed [2] {
                  (usaf__isPrime(primes_.Data,(1 + frame_number + addend_))),
                  (usaf__pos2point(state_.Data[0][1]))}
               },
    .Verbose : verbose_
  };
  Filed(items_)
  #undef items_
  // append log.
  #if (log_frames_)
    #declare logger_ = dictionary {
      .File     : usaf__data_files_[2],
      .Access   : "a",
      .Fields   : logrcd_,
      .Data     : array,
      .Verbose  : verbose_
    };
    usaf__add2log(logger_,frame_number,state_.Data[0])
    Filed(logger_)
    #undef logger_
  #end
#else
  // frame 0, check have no files, and create initial set.
  #if (!usaf__chkFilesExist(false))
    #error "oops, found stale state and or items files."
  #elseif (usaf__haveCamFile())
    #error "oops, found stale camera vars file."
  #end
  #declare (state_,cv_) = usaf__frame_0_init();
  #declare angle_ = 30;
#end


Ruled(dictionary {
  .norm : <0,1,0>,
  .offs : -.05,
  .divs : 1,
  .bg   : pigment {color rgbt .975},
  .dim  : false
})

/* read up-to-date items.  make line begin in "floor" */
#declare items_ = dictionary {
  .File    : usaf__data_files_[1],
  .Access  : "r",
  .Fields  : itmrcd_,
  .Verbose : verbose_
};
Filed(items_)

#declare tmp_ = dictionary {.last_: <.5,-.1,.5>};

Foreach(items_.Data, dictionary {.Macro: "usaf__mkItems", .Arg: "tmp_"})

object {
  usaf__data_obj_
  pigment {color rgb <1,0,0>}
  rotate <0,usaf__data_rotates_[state_.Data[0][2]],0>
  translate <(state_.Data[0][1].x+.5),0,(state_.Data[0][1].y+.5)>
}

/* three full turns over 4K frames */
#declare dpf_ = 1080 / 4096;

#declare location_ = vrotate(<0,cv_.Data[0][0],-cv_.Data[0][1]>,
                             <0,(frame_number * dpf_),0>);

#declare look_at_ = vrotate(<0,0,-cv_.Data[0][2]>,
                            <0,(frame_number * dpf_),0>);

camera {
  location location_
  right x * (4/3)
  up y
  angle angle_
  look_at look_at_
}

