#include "kolors.inc"
#include "metals.inc"
#include "stones.inc"
#include "math.inc"
#include "anim.inc"

light_source { <10, 50, -30> rgb 1 }
camera {
     location <0.0, 6.0, -15.0>
     up y
     right x*(image_width/image_height)
     look_at 0.0
     }

#default {
     pigment { White }
     finish { ambient 0.1 diffuse 0.6 }
     }

#declare time = 10;
#declare frame_rate = 60;
#declare frame_count = frame_rate * time;
#declare tick = (final_clock - initial_clock) / time;

#macro index(T)
	(tick*T)
#end

torus { 5.0, 0.25
#if(clock <= index(5))
     rotate (5*1080/2)*pow((clock - 0)/index(5),2)*x
#else
     rotate 5*1080*((clock - index(5))/index(5))*x
#end
#if(clock > index(3) & clock <= index(9))
     rotate (6*1080/2)*pow((clock - index(3))/index(6),2)*y
#end
#if(clock > index(9))
     rotate 1080*((clock - index(9))/index(1))*y
#end
     }

/*
difference {
     plane { y, 0 }
     sphere { 0.0, 5.0 }
          pigment { White*0.625 }
          finish { ambient 0 diffuse 0.4 }
     }

difference {
     intersection {
          torus { 5.0, 0.75 }
          cylinder { -0.5*y, 0.5*y, 6.0 }
          }
     sphere { 0.0, 4.9375 }
     }

union {
     union {
          difference {
               cylinder { -0.375*y, 0.375*y, 4.875 }
               cylinder { -0.4375*y, 0.4375*y, 4.625 }
               }
          difference {
               cylinder { -0.375*y, 0.375*y, 4.5 }
               cylinder { -0.4375*y, 0.4375*y, 4.25 }
               }
          }
     difference {
          cylinder { -0.375*y, 0.375*y, 4.125 }
          cylinder { -0.4375*y, 0.4375*y, 3.875 }
               rotate (10*1080/2)*pow((clock - 0)/index(10),2)*x
          }
     }
*/
