#declare _LE_baseobj=
union
{
    #declare Triangle =
    polygon
    {
        4
        <0.33, 0.0>, <0.44, -0.05>, <0.44, 0.05>, <0.33, 0.0>
        rotate 180.0*z
    }

    object { Triangle }
    object { Triangle rotate 90*z }
    object { Triangle rotate 180*z}
    object { Triangle rotate -90*z}

    disc { 0, z, 0.4, 0.38 }

    polygon
    { 10,
      <-0.15,-0.15,0>, <0.15,-0.15,0>, <0.15,0.15,0>, <-0.15,0.15,0>, <-0.15,-0.15,0>
      <-0.13,-0.13,0>, <0.13,-0.13,0>, <0.13,0.13,0>, <-0.13,0.13,0>, <-0.13,-0.13,0>
    }

    #declare Atemp = Look - Loc
    #declare Azimuth = degrees(atan2(Atemp.z,Atemp.x))

    #if ( Atemp.x < 0 & Atemp.z <= 0) #declare Azimuth = 360 + Azimuth #end
    #if ( Atemp.z < 0 & Atemp.x >= 0 ) #declare Azimuth = 360 + Azimuth #end
    #if (Azimuth > 360) #declare Azimuth = Azimuth - 360 #end
    #if (Azimuth < 0 ) #declare Azimuth = Azimuth + 360 #end

    #declare Az=15*(div(int(Azimuth),15))

    union // Compass
    {
        #declare A = Azimuth - 104
        #while ( A <= Azimuth + 104 )
            #if ( mod(int(A),15) = 0)
                #if ( mod(int(A),90) != 0)
                    polygon
                    {
                        5
                        <-0.01,-0.06,0>, <0.01,-0.06,0>, <0.01,0.06,0>, <-0.01,0.06,0>, <-0.01,-0.06,0>
                        translate x*(A-Azimuth)/150
                    }
                #else
                    polygon
                    {
                        5
                        <-0.01,-0.1,0>, <0.01,-0.1,0>, <0.01,0.1,0>, <-0.01,0.1,0>, <-0.01,-0.1,0>
                        translate x*(A-Azimuth)/150
                    }
                    #switch ( int(A)+360*(A<0)-360*(A>360) )
                    #case (0)
                        text
                        {
                            ttf "C:\WIN95\Fonts\Arial.ttf",
                            "N",
                            0.01,0
                            scale <0.197463, 0.203563, 1.0>
                            translate <-0.05,-0.275,0>+x*(A-Azimuth)/150
                        }
                    #break

                    #case (90)
                        text
                        {
                            ttf "C:\WIN95\Fonts\Arial.ttf",
                            "E",
                            0.01,0
                            scale <0.197463, 0.203563, 1.0>
                            translate <-0.05,-0.275,0>+x*(A-Azimuth)/150
                        }
                    #break

                    #case (180)
                    text
                    {
                        ttf "C:\WIN95\Fonts\Arial.ttf",
                        "S",
                        0.01,0
                        scale <0.197463, 0.203563, 1.0>
                        translate <-0.05,-0.275,0>+x*(A-Azimuth)/150
                    }
                    #break

                    #case (270)
                    text
                    {
                        ttf "C:\WIN95\Fonts\Arial.ttf",
                        "W",
                        0.01,0
                        scale <0.197463, 0.203563, 1.0>
                        translate <-0.09,-0.285,0>+x*(A-Azimuth)/150
                    }
                    #break
                #end
            #end
        #end
        #declare A = A + 1
    #end
//  translate <(Az-Azimuth)/150,1.45,0>
    translate <0,1.45,0>
    }

// For the compass, a pointer...

    object { Triangle rotate -90*z translate 1.2*y }

    union  // This is the tilt indicator
    {
        prism
        {
            linear_sweep
            linear_spline
            -0.01,0.0
            13
            <0.4, 0.0>, <0.1, -0.1>, <-0.1, -0.1>, <-0.4, 0.0>, <-1.2, 0.0>, <-0.6, 0.1>, <-0.3, 0.2>,
            <-0.2, 0.4>, <0.2, 0.4>, <0.3, 0.2>, <0.6, 0.1>, <1.2, 0.0>, <0.4, 0.0>
            rotate -x*90
            rotate Ang*z
            scale 0.3
        }

        object { Triangle rotate 180*z}
        object { Triangle rotate 0*z}
        difference
        {
            cylinder { -0.001*z, 0.001*z, 0.401 }
            cylinder { -0.002*z, 0.002*z, 0.38 }
        }
        text
        {
            ttf "c:\win95\fonts\ariblk.ttf"
            str (Ang,-4,1)
            0.001,0.05*x
            scale 0.15
            translate <-0.2,-0.25,0>
        }
        translate <1.6,1.2,0>
    }

    difference  // This is the missile crosshair
    {
        box { <-1, -1, -1>, <1, 1, 1> scale <0.145107, 0.145107, 0.01> }
        box { <-1, -1, -1>, <1, 1, 1> scale <0.130408, 0.130408, 0.011>}
    }

#declare Alt=int(Loc.y)

  union  // Altimeter
  {
    #declare B = Alt - 6
    #while ( B <= Alt + 6 )
      #if ( B >= 0 )
        #if ( mod(B,5) != 0)
          box { -1, 1 scale <0.06,0.01,0.001> translate y*(B-Alt)/10 }
        #else
          box { -1, 1 scale <0.1,0.01,0.001> translate y*(B-Alt)/10-x*0.04 }
          text
          { ttf "C:\WIN95\Fonts\Arial.ttf",
            str (B*10,0,0),
            0.01,0.05*x
            scale <0.175,0.17,1>
            translate <0.1,0.1,0> translate y*((B-Alt)/10-0.15)
          }
        #end
      #end

      #declare B = B + 1
    #end
    translate <1.7,(Alt-Loc.y)/10,0>
  }

object { Triangle translate 1.85*x} // For the altimeter
union // Radar
{
    difference
    {
        cylinder { -0.001*z, 0.001*z, 0.401 }
        cylinder { -0.002*z, 0.002*z, 0.38 }
    }
    cylinder
    { -0.001*z, 0.001*z, 0.37
      texture
      { pigment
        { radial
          color_map
          {
          [0 color Green]
          [0.025 color Green]
          [0.025 color Green filter 0.5]
          [0.2 color Green filter 1]
          [1 color Green filter 1]
          }
          rotate 90*x
          rotate -z*clock*360*15
        }
        finish { ambient 1 }
      }
    }
    translate <-1.6,1.2,0>
}

    union  // this is the automap
    {
        height_field
        {
            gif "hf1.gif"
            texture
            {
                pigment
                {
                    gradient y
                    color_map
                    {
                        [0 color White filter 1]
                        [1 color White filter 0.25]
                    }
                }
                finish { ambient 1 }
            }

            texture
            {
                pigment
                {
                    gradient y frequency 10
                    color_map
                    {
                        [0 color Cyan filter 1]
                        [0.45 color Cyan filter 1]
                        [0.45 color Cyan filter 0]
                        [0.55 color Cyan filter 0]
                        [0.55 color Cyan filter 1]
                        [1 color Cyan filter 1]
                    }
                }
                finish { ambient 1 }
            }

            texture
            {
                pigment
                {
                    gradient x
                    frequency 60
                    color_map
                    {
                        [0.0 color Green filter 1]
                        [0.9 color Green filter 1]
                        [0.9 color Green filter 0.25]
                        [1. color Green filter 0.25]
                    }
                }
                finish { ambient 1 }
            }

            texture
            {
                pigment
                {
                    gradient z
                    frequency 60
                    color_map
                    {
                        [0.0 color Green filter 1]
                        [0.9 color Green filter 1]
                        [0.9 color Green filter 0.25]
                        [1. color Green filter 0.25]
                    }
                }
                finish { ambient 1 }
            }

            translate <-0.5,0,-0.5>
            scale <0.7999999,0.0001,0.7999999>
            scale <10,1,10>
            translate x*(Loc.x-256)*5/256+z*(Loc.z+256)*5/256
            clipped_by { cylinder { 0.001*y, -0.001*y, 0.37 } }
            rotate -90*x
        }

        text
        {
              ttf "C:\WIN95\Fonts\Arial.ttf",
              "N",
              0.01,0
              scale <0.15, 0.16, 0.001>
              translate <-0.05,0.41,0>
              rotate 90*z
        }

        text
        {
              ttf "C:\WIN95\Fonts\Arial.ttf",
              "W",
              0.01,0
              scale <0.15, 0.16, 0.001>
              translate <-0.075,0.41,0>
              rotate 180*z
        }

        text
        {
              ttf "C:\WIN95\Fonts\Arial.ttf",
              "S",
              0.01,0
              scale <0.15, 0.16, 0.001>
              translate <-0.05,0.41,0>
              rotate -90*z
        }

        text
        {
              ttf "C:\WIN95\Fonts\Arial.ttf",
              "E",
              0.01,0
              scale <0.15, 0.16, 0.001>
              translate <-0.05,0.41,0>
              rotate 0*z
        }

        difference
        {
            cylinder { -0.001*z, 0.001*z, 0.401 }
            cylinder { -0.002*z, 0.002*z, 0.38 }
        }
        rotate (Azimuth)*z
        translate <-1.6,-1,0>
    }

    object { Triangle rotate 90*z scale <1.25,0.5,1> translate <-1.6,-0.485,-0.005> }

//translate 0.001*z
}

#declare effect_location=Look
#declare camera_location=Loc
#declare camera_look_at=Look
#declare camera_sky=vrotate(y, Ang*z)
#declare custom_effect_file="my_lens.lfx"
#declare spot_type=0
#declare glow_type=0
#declare streak_type=0
#declare rays_type=0
#declare effect_always_on_top=true

#include "mylens.inc"

#declare _LE_baseobj=
prism
{ // Crosshair
  linear_sweep
  linear_spline
  0.01,0.0
  21  // control points
  <0.3, -0.3>,
  <0.1, -0.3>,
  <0.1, -1.0>,
  <-0.1, -1.0>,
  <-0.1, -0.3>,
  <-0.3, -0.3>,
  <-0.3, -0.1>,
  <-1.0, -0.1>,
  <-1.0, 0.1>,
  <-0.3, 0.1>,
  <-0.3, 0.3>,
  <-0.1, 0.3>,
  <-0.1, 1.0>,
  <0.1, 1.0>,
  <0.1, 0.3>,
  <0.3, 0.3>,
  <0.3, 0.1>,
  <1.0, 0.1>,
  <1.0, -0.1>,
  <0.3, -0.1>,
  <0.3, -0.3>
  rotate -x*90
  scale 0.1
  }

#declare effect_location=Point
#declare camera_location=Loc
#declare camera_look_at=Look
#declare camera_sky=vrotate(y, Ang*z)
#declare custom_effect_file="my_lens.lfx"
#declare spot_type=0
#declare glow_type=0
#declare streak_type=0
#declare rays_type=0
#declare effect_always_on_top=true

#include "mylens.inc"
