// Persistence of Vision Ray Tracer Scene Description File
// File: test.pov
// Vers: MegaPov 0.7
// Desc: test for Clutter macro
// Date: 9th July 2001 22.24
// Auth: Jonathan Rafael Ghiglia
//


// ----------------------------------------

#declare Location = <-2, 3, -4>;
#declare Look_at = <0, 0, 0>;

camera
{
  location  Location
  look_at   Look_at
}

sky_sphere { pigment { rgb <0.6, 0.8, 1> } }

light_source {
<0,3.5,5> rgb <60/255,60/255,90/255>*2.5
fade_distance 5 fade_power 3 
}


light_source
{ <4, 5, -5>
  rgb <1, 1, 1>*2.5
  fade_power 2
  fade_distance 5
 }

// ---------------------------------------- 

#include "clutter.mcr"   

#declare total_objects=2000; // 2 minutes and 20 sec of parsing with my Athlon


#declare F = function { y-sin(-pi/2+x*10)/(10+(x*x+y*y)^2*2)}  
                            
                            
//---------land
#declare land= isosurface {
function {F(sqrt(x^2+z^2),y,z)}
max_gradient 1.40
contained_by {box {<-5,-1,-5>,<5,1,5>}   }     
translate <5,0,5>}     
  
//-----objects array-
#declare ob_ar=array[2]
#declare ob_ar[0]=sphere {0,0.05 translate 0.05*y}
#declare ob_ar[1]= cone {0,0.025,0.2*y,0}

//------objects related array
#declare ob_rel_ar=array[2][2]
#declare ob_rel_ar[0][0]=total_objects/2;
#declare ob_rel_ar[0][1]=0.05;
#declare ob_rel_ar[1][0]=total_objects/2;
#declare ob_rel_ar[1][1]=0.025;  

//--------obstacles array
#declare obstacle_ar=array[1][2]
#declare obstacle_ar[0][0]=<5,0,5>;
#declare obstacle_ar[0][1]=<0,0,0>; // no obstacle   

//----------probability array
#declare p=array[2][2]
#declare p[0][0]=0;
#declare p[0][1]=1;
#declare p[1][0]=0;
#declare p[1][1]=1;

//------------probability map array
#declare map =array[2]
#declare map[0]= pigment {function {max(0,min(1,x))} color_map {[0 rgb 1][0.8 rgb 0]} scale 10} //more spheres on the left
#declare map[1]= pigment {function {max(0,min(1,x))} color_map {[0.2 rgb 0][1 rgb 1]} scale 10} //more cones on the right

//----------textures array
#declare tex_ar=array[2][2]
#declare tex_ar[0][0]= texture {pigment {rgb <1,.3,.1>} finish {specular 0.7 roughness 0.005}}
#declare tex_ar[0][1]= texture {pigment {rgb <.1,.3,1>} finish {specular 0.7 roughness 0.005}}
#declare tex_ar[1][0]= texture {pigment {rgb <1,.6,.2>*0.9} finish {ambient 0 diffuse 0.2 specular 1.5 roughness 0.03 reflection 0.5*<1,.6,.2> brilliance 1.5}}
#declare tex_ar[1][1]= texture {pigment {rgb <1,.95,.9>*0.9} finish {ambient 0 diffuse 0.2 specular 1.5 roughness 0.03 reflection 0.5*<1,.95,.9> brilliance 1.5}}

//----------map for textures interpolation array
#declare map_tex=array[2]
#declare map_tex[0]=pigment {function {max(0,min(1,x))} color_map {[0 rgb 0][1 rgb 1]} scale 10} //from blue to red
#declare map_tex[1]=pigment {function {max(0,min(1,x))} color_map {[0 rgb 0][1 rgb 1]} scale 10} //from chrome to gold


                             


object {
clutter (
ob_ar,
ob_rel_ar,
obstacle_ar,
10,
10,
p,
map,
true,
tex_ar,
map_tex,
land,
true,
1000,
seed(1000000),
2,
"clu.inc")
translate <-5,0,-5>
}

object {land 
pigment {rgb 1}
translate <-5,0,-5>
finish { ambient 0 diffuse 0.5 specular 0.4 roughness 0.01 reflection 0.2 }
}