// ************************************************************************
// ************************************************************************
// O_HOUSE0.POV                                           Ver. 1.0  Aug 99
// aka HELPME
// Our House Final Version Test Platform
// ************************************************************************

// ************************************************************************
// Define Global Settings                                             *****
// ************************************************************************

#version 3.0
//global_settings { assumed_gamma 1.8 }

#include "o_house0.inc"                // Our_House elements

// ************************************************************************
// Define Ambient Lights                                              *****
// ************************************************************************

/*
light_source {
   < 200, 100, -200 >
   color White
   area_light < 2, 0, 0 >, < 0, 0, 2 >, 2, 2
   adaptive 1
   jitter
   atmospheric_attenuation on
             } // end light source

light_source {
   < 675, 100, -675 >
   color White
   area_light < 2, 0, 0 >, < 0, 0, 2 >, 2, 2
   adaptive 1
   jitter
   atmospheric_attenuation on
   shadowless
             } // end light source

light_source {
   < 200, 100, -210 >
   color White
             } // end light source
*/

// ************************************************************************
// Define Sky                                                         *****
// ************************************************************************

//background { color LightBlue }
sky_sphere { pigment  { Black } }                // real night
//sky_sphere { pigment { Starfield2A } }           // stars

//sky_sphere { pigment  { LightBlue } }            // day
//sky_sphere { pigment  { MidnightBlue } }         // twilight
//sky_sphere { pigment { Bright_AquaBlue4
//                       scale < 0.6, 0.15, 0.15 > } }  // clouds

/*
object { sphere { <0, 0, 0>, 2010 }
         texture { LB_Tex }
         hollow
       } // end background sphere

object { Sphere
         pigment { Bright_AquaBlue4  scale < 0.6, 0.15, 0.15 > }
         finish {
            ambient 0.2
            diffuse 0.5 } //end finish
         scale < 2000, 700, 2000 >
         hollow
       } // end cloud sphere

fog { color rgbf < 0.7, 0.9, 1, 0.6 >
      distance 4000
      fog_type 2
      fog_offset 3
      fog_alt 5
      turbulence 0.75
      turb_depth 0.3
    } // end fog
*/

// ************************************************************************
// Define Spotlights                                                  *****
// ************************************************************************

#declare Test_Spot =
light_source {
   < 20, 40, -50 >
   color White
   spotlight
   radius 20
   falloff 15
   tightness 15
   point_at < 20, 0, -30 >
             } // end Test Spotlight 1

// ************************************************************************
// Define Camera                                                      *****
// ************************************************************************

#declare Camera_BS =
camera {
   direction < 0, 0, 2 >
   location  < 145, 45, -250 >         // SE of center
   look_at   <  10, 20,    0 > }       // The Beauty Shot

#declare Camera_SE =
camera {
   direction < 0, 0, 8 >
   location  < 120, 20, -250 >         // SE of center
   look_at   < -20,  5,    0 > }       //    long shot

#declare Camera_SE_2 =
camera {
   direction < 0, 0, 2.5 >
   location  < 190, 35, -100 >         // SE of center
   look_at   <   0, 20,  60 > }        //

#declare Camera_SW =
camera {
   direction < 0, 0, 3 >
   location  < -60, 80, -200 >         // SW of center
   look_at   <   0, 10, 50 > }         //            medium

#declare Camera_South =
camera {
   direction < 0, 0, 3 >
   location  < 10, 10, -50 >           // south of cntr
   look_at   < 10, 10, 50 > }          //

#declare Camera_West =
camera {
   direction <    0, 0,  2 >
   location  < -190, 6, 10 >           // West
   look_at   <    0, 9, 60 > }         //   of room 2 cntr

#declare Camera_East =
camera {
   direction <   0,  0, 2 >
   location  < 150, 20, 20 >           // East
   look_at   <   0, 20, 20 > }         //   of cntr

#declare Camera_Above =
camera {
   direction < 0, 0, 2 >
   location  < 0, 300, 49 >            // Above
   look_at   < 0, 0, 50 > }            //    cntr

// ************************************************************************
//  Define Test Scene                                                 *****
// ************************************************************************

// CAMERA
//camera { Camera_BS }
camera { Camera_SE }
//camera { Camera_SW }
//camera { Camera_SE_2 }
//camera { Camera_South }
//camera { Camera_West }
//camera { Camera_East }
//camera { Camera_Above }

// LIGHTS
//object { Test_Spot }                   //variable

// FLOOR
//object { Clip_Floor }
//object { Check_Floor }
object { Test_Floor }
//object { Grass_Floor }

// ************************************************************************
// ************************************************************************

//  Generate this image :

//object { Our_House }
//object { New_Wing_1 }
//object { Room_1A  translate <  60, SmallSpan,  0 > }    // east room
//object { Room_1B  translate < -60, SmallSpan,  0 > }    // west room
object { Atrium_1 translate <   0, SmallSpan,  0 > }    // atrium
//object { Room_2   translate <   0, SmallSpan, 50 > }    // north room

// ************************************************************************
// ************************************************************************
// Michael Brendan Hurley, SDE, Ltd.                         Nov 98-Aug 99
// ************************************************************************
                                 
