
#include "embedded_parse_api.h"
#include <sstream>
#include <cstdio>
#include <cstdlib>
#include <cstring>

static std::string esc(const std::string& s){
  std::string o; o.reserve(s.size()+16);
  for(char c: s){
    switch(c){
      case '"': o += "\""; break;
      case '\': o += "\\"; break;
      case '
': o += "\n"; break;
      case '
': o += "\r"; break;
      case '	': o += "\t"; break;
      default: o += c;
    }
  }
  return o;
}

namespace povjson {
  std::string to_json(const Report& r){
    std::ostringstream os; os << '{';
    os << ""versionUsed":"" << esc(r.versionUsed) << "",";
    os << ""files":[";
    for(size_t i=0;i<r.files.size();++i){ if(i) os << ','; os << '"' << esc(r.files[i]) << '"'; }
    os << "],"messages":[";
    for(size_t i=0;i<r.messages.size();++i){ const auto& m=r.messages[i]; if(i) os << ','; os << '{';
      os << ""severity":"" << esc(m.severity) << "",";
      os << ""category":"" << esc(m.category) << "",";
      if(!m.code.empty()) os << ""code":"" << esc(m.code) << "",";
      os << ""text":"" << esc(m.text) << "",";
      os << ""file":"" << esc(m.file) << "",";
      os << ""line":" << m.line << ","column":" << m.column;
      if(!m.near.empty()) os << ","near":"" << esc(m.near) << """;
      if(!m.suggestion.empty()) os << ","suggestion":"" << esc(m.suggestion) << """;
      os << '}';
    }
    os << "]}"; return os.str();
  }
}

struct ParseEnv { std::string version = "3.8"; } G;
static const char* make_cstr(const std::string& s){ char* p=(char*)std::malloc(s.size()+1); if(!p) return nullptr; std::memcpy(p,s.data(),s.size()); p[s.size()]=0; return p; }

static povjson::Report simulate(const std::string& fname, const std::string& text){
  povjson::Report R; R.versionUsed = G.version; R.files.push_back(fname);
  // demo messages; replace with real parser wiring
  if(text.find("#version") == std::string::npos){
    R.messages.push_back({"warning","version","W3800","Using v3.8 defaults; add '#version 3.8;' explicitly.",fname,1,0,"",""});
  }
  return R;
}

extern "C" {
  int pov_init_parse_env(const char* json_options){ (void)json_options; G.version = "3.8"; return 0; }
  const char* pov_parse_text(const char* filename, const char* file_text){ auto js = povjson::to_json(simulate(filename?filename:"(memory)", file_text?file_text:"")); return make_cstr(js); }
  const char* pov_parse_file(const char* filename){ auto js = povjson::to_json(simulate(filename?filename:"(file)", "")); return make_cstr(js); }
  void pov_free_json(const char* ptr){ if(ptr) std::free((void*)ptr); }
}
