--Copyright Philippe Gibone for the modifications made on the original model by MB CORTIE
--Version 1
SeaShell={}

function SeaShell:init()
--Par dfaut les paramtres sont ceux de l'ammonite

	self.ShellList			= {"Ammonite", "Cerith", "Codakia", "Conus", "Epitonium", "Helcion", "Lamellibranch", "Lyria", "Lyria + ripples", "Natalina", "Nautile", "Oxystele", "Planorbis", "Struthiolaria", "Turbo", "Turritella", "Waves"}
	self.Shell			= 1
	self.Amplitude 			= 0.19
	self.DemiAxePrincipal		= 0.1
	self.DemiAxeSecondaire 		= 0.09
		
	self.Alpha			= 80
	self.Beta			= 90
	self.Phi			= 1
	self.Mu				= 1
	self.Omega			= 1
		
	self.NodulePlace		= 10
	self.NoduleHeight		= 0.2
	self.NoduleNombre		= 15
	self.NoduleWidth1		= 100
	self.NoduleWidth2		= 20
	self.NoduleStepDivider		= 1
		
	self.RipplesNombre		= 0
	self.RipplesAmplitude		= 1
	
	self.WavesStartNumber		= 0
	self.WavesEndNumber		= 0
	self.WavesAmplitude		= 1

	self.SpiralAngleMin		= 0
	self.SpiralAngleMax		= 1200
	self.SpiralAngleStep		= 4
	self.SpiralWireStepMultiplier	= 5
	self.EllipseAngleMin		= -190
	self.EllipseAngleMax		= 190	
	self.EllipseAngleStep		= 4
	self.EllipseWireStepMultiplier	= 5
	
	self.RimSize			= 0
	
	self.sMu			= sin(rad(self.Mu))
	self.cMu			= cos(rad(self.Mu))
	self.sBeta			= sin(rad(self.Beta))
	self.cBeta			= cos(rad(self.Beta))
	self.tAlpha			= tan(rad(self.Alpha))
	
	self.Texture			= ""
	self.TextureInterior		= ""
end

function SeaShell:destroy()
end

function SeaShell:load(stream)
	stream:readByte()
	self.Amplitude 			= stream:readDouble()
	self.DemiAxePrincipal		= stream:readDouble()
	self.DemiAxeSecondaire 		= stream:readDouble()
	
	self.Alpha			= stream:readDouble()
	self.Beta			= stream:readDouble()
	self.Phi			= stream:readDouble()
	self.Mu				= stream:readDouble()
	self.Omega			= stream:readDouble()
	
	self.NodulePlace		= stream:readDouble()
	self.NoduleHeight		= stream:readDouble()
	self.NoduleNombre		= stream:readDouble()
	self.NoduleWidth1		= stream:readDouble()
	self.NoduleWidth2		= stream:readDouble()
	self.NoduleStepDivider		= stream:readDouble()
	
	self.RipplesNombre		= stream:readDouble()
	self.RipplesAmplitude		= stream:readDouble()
	
	self.WavesStartNumber		= stream:readDouble()
	self.WavesEndNumber		= stream:readDouble()
	self.WavesAmplitude		= stream:readDouble()
	
	self.SpiralAngleMin		= stream:readDouble()
	self.SpiralAngleMax		= stream:readDouble()
	self.SpiralAngleStep		= stream:readDouble()
	self.SpiralWireStepMultiplier	= stream:readDouble()
	
	self.EllipseAngleMin		= stream:readDouble()
	self.EllipseAngleMax		= stream:readDouble()
	self.EllipseAngleStep		= stream:readDouble()
	self.EllipseWireStepMultiplier	= stream:readDouble()
	self.RimSize			= stream:readDouble()
	
	self.Texture			= stream:readString()
	self.TextureInterior		= stream:readString()

	self.sMu			= sin(rad(self.Mu))
	self.cMu			= cos(rad(self.Mu))
	self.sBeta			= sin(rad(self.Beta))
	self.cBeta			= cos(rad(self.Beta))
	self.tAlpha			= tan(rad(self.Alpha))
end

function SeaShell:save(stream)
	stream:writeByte(1)
	stream:writeDouble(self.Amplitude)
	stream:writeDouble(self.DemiAxePrincipal)
	stream:writeDouble(self.DemiAxeSecondaire)
	
	stream:writeDouble(self.Alpha)
	stream:writeDouble(self.Beta)
	stream:writeDouble(self.Phi)
	stream:writeDouble(self.Mu)
	stream:writeDouble(self.Omega)
	
	stream:writeDouble(self.NodulePlace)
	stream:writeDouble(self.NoduleHeight)
	stream:writeDouble(self.NoduleNombre)
	stream:writeDouble(self.NoduleWidth1)
	stream:writeDouble(self.NoduleWidth2)
	stream:writeDouble(self.NoduleStepDivider)
		 
	stream:writeDouble(self.RipplesNombre)
	stream:writeDouble(self.RipplesAmplitude)
	
	stream:writeDouble(self.WavesStartNumber)
	stream:writeDouble(self.WavesEndNumber)
	stream:writeDouble(self.WavesAmplitude)
	
	stream:writeDouble(self.SpiralAngleMin)
	stream:writeDouble(self.SpiralAngleMax)
	stream:writeDouble(self.SpiralAngleStep)
	stream:writeDouble(self.SpiralWireStepMultiplier)
	
	stream:writeDouble(self.EllipseAngleMin)
	stream:writeDouble(self.EllipseAngleMax)
	stream:writeDouble(self.EllipseAngleStep)
	stream:writeDouble(self.EllipseWireStepMultiplier)

	stream:writeDouble(self.RimSize)
	
	stream:writeString(self.Texture)
	stream:writeString(self.TextureInterior)	
end

function SeaShell:getProperties()
	return	"SeaShell",
		"A931A14288F2DF34",
		"0000000800000000"..
		"0000000700000000"..
		"0000007780000000"..
		"0000007778000000"..
		"0000077788000000"..
		"000087777F800000"..
		"0000877F77F00000"..
		"0008F77778700000"..
		"000F787778780000"..
		"00077888887F8000"..
		"000878877877F800"..
		"0000888788877700"..
		"0000088888887800"..
		"0000008877788000"..
		"0000000077780000"..
		"0000000008800000"
end

function SeaShell:getDialog(dialog)
      	dialog:addSeparator("Sea Shell")
	self.ShellListID		= dialog:addListBox(self.ShellList,self.Shell)

      	dialog:addSeparator("Linear parameters")
--	self.AmplitudeID		= dialog:addEditBox("Amplitude  :",self.Amplitude        ,-100,100,3)
	self.AmplitudeID		= dialog:addTextEdit("Amplitude :",self.Amplitude)

--	self.DemiAxePrincipalID		= dialog:addEditBox("MajorRadius:",self.DemiAxePrincipal ,-100,100,3)	
--	self.DemiAxeSecondaireID	= dialog:addEditBox("MinorRadius:",self.DemiAxeSecondaire,-100,100,3)		
	self.DemiAxePrincipalID		= dialog:addTextEdit("MajorRadius:",self.DemiAxePrincipal)	
	self.DemiAxeSecondaireID	= dialog:addTextEdit("MinorRadius:",self.DemiAxeSecondaire)			

      	dialog:addSeparator("Angular parameters")
--     	self.AlphaID			= dialog:addEditBox("Alpha:",self.Alpha,-180,180,1)
--	self.BetaID			= dialog:addEditBox("Beta :",self.Beta ,-180,180,1)
--	self.MuID			= dialog:addEditBox("Mu   :",self.Mu   ,-180,180,1)
--	self.PhiID			= dialog:addEditBox("Phi  :",self.Phi  ,-180,180,1)
--	self.OmegaID			= dialog:addEditBox("Omega:",self.Omega,-180,180,1)
      	self.AlphaID			= dialog:addTextEdit("Alpha:",self.Alpha)
	self.BetaID			= dialog:addTextEdit("Beta :",self.Beta )
	self.MuID			= dialog:addTextEdit("Mu   :",self.Mu  )
	self.PhiID			= dialog:addTextEdit("Phi  :",self.Phi )
	self.OmegaID			= dialog:addTextEdit("Omega:",self.Omega)

      	dialog:addSeparator("Spiral")	
--	self.SpiralAngleMinID		= dialog:addEditBox("Start:",self.SpiralAngleMin ,-3600,3600,0)
--	self.SpiralAngleMaxID		= dialog:addEditBox("End  :",self.SpiralAngleMax ,-3600,3600,0)
--	self.SpiralAngleStepID		= dialog:addEditBox("Step :",self.SpiralAngleStep,1,120,0)
--	self.SpiralWireStepMultiplierID	= dialog:addEditBox("Wire multiplier :",self.SpiralWireStepMultiplier,1,100,0)
	self.SpiralAngleMinID		= dialog:addTextEdit("Start:",self.SpiralAngleMin)
	self.SpiralAngleMaxID		= dialog:addTextEdit("End  :",self.SpiralAngleMax)
	self.SpiralAngleStepID		= dialog:addTextEdit("Step :",self.SpiralAngleStep)
	self.SpiralWireStepMultiplierID	= dialog:addTextEdit("Wire multiplier :",self.SpiralWireStepMultiplier)
	
      	dialog:addSeparator("Ellipse")	
--	self.EllipseAngleMinID		= dialog:addEditBox("Start:",self.EllipseAngleMin ,-360,360,0)
--	self.EllipseAngleMaxID		= dialog:addEditBox("End  :",self.EllipseAngleMax ,-360,360,0)
--	self.EllipseAngleStepID		= dialog:addEditBox("Step :",self.EllipseAngleStep,1,120,0)
--	self.EllipseWireStepMultiplierID= dialog:addEditBox("Wire multiplier :",self.EllipseWireStepMultiplier,1,100,0)
	self.EllipseAngleMinID		= dialog:addTextEdit("Start:",self.EllipseAngleMin )
	self.EllipseAngleMaxID		= dialog:addTextEdit("End  :",self.EllipseAngleMax )
	self.EllipseAngleStepID		= dialog:addTextEdit("Step :",self.EllipseAngleStep)
	self.EllipseWireStepMultiplierID= dialog:addTextEdit("Wire multiplier :",self.EllipseWireStepMultiplier)

      	dialog:addSeparator("Nodules")
--     	self.NoduleNombreID		= dialog:addEditBox("Number:",self.NoduleNombre, 0,30,1)
--	self.NodulePlaceID		= dialog:addEditBox("Place :",self.NodulePlace ,-180,180,0)
--	self.NoduleHeightID		= dialog:addEditBox("Height:",self.NoduleHeight,-18,18,2)	
--	self.NoduleWidth1ID		= dialog:addEditBox("Width1:",self.NoduleWidth1,1,180,2)	
--	self.NoduleWidth2ID		= dialog:addEditBox("Width2:",self.NoduleWidth2,1,180,2)	
--	self.NoduleStepDividerID	= dialog:addEditBox("Step Divider:",self.NoduleStepDivider,1,100,0)	
      	self.NoduleNombreID		= dialog:addTextEdit("Number:",self.NoduleNombre)
	self.NodulePlaceID		= dialog:addTextEdit("Place :",self.NodulePlace )
	self.NoduleHeightID		= dialog:addTextEdit("Height:",self.NoduleHeight)	
	self.NoduleWidth1ID		= dialog:addTextEdit("Width1:",self.NoduleWidth1)	
	self.NoduleWidth2ID		= dialog:addTextEdit("Width2:",self.NoduleWidth2)	
	self.NoduleStepDividerID	= dialog:addTextEdit("Step Divider:",self.NoduleStepDivider)	

      	dialog:addSeparator("Ripples")
--	self.RipplesNombreID		= dialog:addEditBox("Number   :",self.RipplesNombre   ,-100,100,0)	
--	self.RipplesAmplitudeID		= dialog:addEditBox("Amplitude:",self.RipplesAmplitude,-18,18,2)	
	self.RipplesNombreID		= dialog:addTextEdit("Number   :",self.RipplesNombre)	
	self.RipplesAmplitudeID		= dialog:addTextEdit("Amplitude:",self.RipplesAmplitude)	

      	dialog:addSeparator("Waves")
--	self.WavesStartNumberID		= dialog:addEditBox("Start    :",self.WavesStartNumber,0,100,0)	
--	self.WavesEndNumberID		= dialog:addEditBox("End      :",self.WavesEndNumber  ,0,100,0)	
--	self.WavesAmplitudeID		= dialog:addEditBox("Amplitude:",self.WavesAmplitude  ,-18,18,2)	
	self.WavesStartNumberID		= dialog:addTextEdit("Start    :",self.WavesStartNumber)	
	self.WavesEndNumberID		= dialog:addTextEdit("End      :",self.WavesEndNumber  )	
	self.WavesAmplitudeID		= dialog:addTextEdit("Amplitude:",self.WavesAmplitude  )	

      	dialog:addSeparator("Rim")	
--	self.RimSizeID			= dialog:addEditBox("Size  :",self.RimSize  ,0 ,18,2)	
	self.RimSizeID			= dialog:addTextEdit("Size  :",self.RimSize)	

	dialog:addSeparator("Texture")	
	self.TextureID			= dialog:addTexture(self.Texture)

	dialog:addSeparator("Interior Texture")	
	self.TextureInteriorID		= dialog:addTexture(self.TextureInterior)
	
end

function SeaShell:copy(from)
	self.ShellList		= from.ShellList
	self.Shell		= from.Shell
	self.Amplitude		= from.Amplitude
 	self.DemiAxePrincipal 	= from.DemiAxePrincipal
 	self.DemiAxeSecondaire	= from.DemiAxeSecondaire
 	self.Alpha  		= from.Alpha
 	self.Beta  		= from.Beta
 	self.Phi  		= from.Phi
 	self.Mu   		= from.Mu
 	self.Omega  		= from.Omega

 	self.NodulePlace 	= from.NodulePlace
 	self.NoduleHeight 	= from.NoduleHeight
 	self.NoduleNombre 	= from.NoduleNombre
 	self.NoduleWidth1 	= from.NoduleWidth1
 	self.NoduleWidth2 	= from.NoduleWidth2
	self.NoduleStepDivider	= from.NoduleStepDivider
	
	self.RipplesNombre 	= stream:readDouble()
 	self.RipplesAmplitude 	= stream:readDouble()

 	self.WavesStartNumber 	= from.WavesStartNumber
 	self.WavesEndNumber 	= from.WavesEndNumber
 	self.WavesAmplitude 	= from.WavesAmplitude
	
	self.SpiralAngleMin 	= from.SpiralAngleMin
 	self.SpiralAngleMax 	= from.SpiralAngleMax
 	self.SpiralAngleStep 	= from.SpiralAngleStep
	self.SpiralWireStepMultiplier	= from.SpiralWireStepMultiplier

 	self.EllipseAngleMin 	= from.EllipseAngleMin
 	self.EllipseAngleMax 	= from.EllipseAngleMax
 	self.EllipseAngleStep 	= from.EllipsAngleStep
	self.EllipseWireStepMultiplier	= from.EllipseWireStepMultiplier
	
	self.RimSize		= from.RimSize

 	self.Texture		= from.Texture
 	self.TextureInterior	= from.TextureInterior

 	self.sMu  		= from.sMu
 	self.cMu  		= from.cMu
 	self.sBeta  		= from.sBeta
 	self.cBeta  		= from.cBeta
 	self.tAlpha  		= from.tAlpha
end

function SeaShell:CheckNumber(Valeur, Minimum, Maximum)
	local Nombre, Retour
	
	Nombre = tonumber(tostring(Valeur))
	
	if Nombre == nil then
		Retour = 0
	elseif Nombre < tonumber(tostring(Minimum)) then
		Retour = -1
	elseif Nombre > tonumber(tostring(Maximum)) then
		Retour = -2
	else
		return 1	
	end
	messageBox("Error", "Enter a number between " .. Minimum .. " & " .. Maximum)
	return Retour
end

function SeaShell:valueChanged(id,value)

	if id == self.ShellListID then
		self.Shell = value
		if self.Shell == 1 then --Ammonite
			self.Amplitude 		= 0.19
			self.DemiAxePrincipal	= 0.1
			self.DemiAxeSecondaire 	= 0.09
		
			self.Alpha		= 80
			self.Beta		= 90
			self.Phi		= 1
			self.Mu			= 1
			self.Omega		= 1
		
			self.NodulePlace	= 10
			self.NoduleHeight	= 0.2
			self.NoduleNombre	= 15
			self.NoduleWidth1	= 100
			self.NoduleWidth2	= 20
	
			self.RipplesNombre	= 0
			self.RipplesAmplitude	= 1
	
			self.WavesStartNumber	= 0
			self.WavesEndNumber	= 0
			self.WavesAmplitude	= 1
	
			self.SpiralAngleMin	= 0
			self.SpiralAngleMax	= 1200
			self.SpiralAngleStep	= 4
			self.EllipseAngleMin	= -190
			self.EllipseAngleMax	= 190	
			self.EllipseAngleStep	= 4

			self.RimSize		= 0
		end
		if self.Shell == 2 then --Cerith
			self.Amplitude 		= .55
			self.DemiAxePrincipal	= .13
			self.DemiAxeSecondaire 	= .15
		
			self.Alpha		= 87
			self.Beta		= 3
			self.Phi		= 1
			self.Mu			= 1
			self.Omega		= 1
		
			self.NodulePlace	= 20
			self.NoduleHeight	= 0.05
			self.NoduleNombre	= 10.2
			self.NoduleWidth1	= 5
			self.NoduleWidth2	= 5
	
			self.RipplesNombre	= 0
			self.RipplesAmplitude	= 1
	
			self.WavesStartNumber	= 0
			self.WavesEndNumber	= 0
			self.WavesAmplitude	= 1
	
			self.SpiralAngleMin	= 0
			self.SpiralAngleMax	= 3300
			self.SpiralAngleStep	= 20
			self.EllipseAngleMin	= -180
			self.EllipseAngleMax	= 100	
			self.EllipseAngleStep	= 8

			self.RimSize		= 0
		end
	
		if self.Shell == 3 then --Codakia
			self.Amplitude 		= 1.05e-007
			self.DemiAxePrincipal	= 1e-007
			self.DemiAxeSecondaire 	= 1.05e-007
		
			self.Alpha		= 37
			self.Beta		= 90
			self.Phi		= 0
			self.Mu			= 1
			self.Omega		= 1
		
			self.NodulePlace	= 0
			self.NoduleHeight	= 0
			self.NoduleNombre	= 0
			self.NoduleWidth1	= 110
			self.NoduleWidth2	= 10
	
			self.RipplesNombre	= 0
			self.RipplesAmplitude	= 1
	
			self.WavesStartNumber	= 0
			self.WavesEndNumber	= 0
			self.WavesAmplitude	= 1
	
			self.SpiralAngleMin	= -180
			self.SpiralAngleMax	=  720
			self.SpiralAngleStep	= 20
			self.EllipseAngleMin	= -180
			self.EllipseAngleMax	= 180
			self.EllipseAngleStep	= 20

			self.RimSize		= 0
		end
		if self.Shell == 4 then --Conus
			self.Amplitude 		= 7
			self.DemiAxePrincipal	= 4.3
			self.DemiAxeSecondaire 	= 1
		
			self.Alpha		= 87
			self.Beta		= 7
			self.Phi		= 78
			self.Mu			= 0
			self.Omega		= 0
		
			self.NodulePlace	= 0
			self.NoduleHeight	= 0
			self.NoduleNombre	= 0
			self.NoduleWidth1	= 110
			self.NoduleWidth2	= 10
	
			self.RipplesNombre	= 0
			self.RipplesAmplitude	= 1
	
			self.WavesStartNumber	= 0
			self.WavesEndNumber	= 0
			self.WavesAmplitude	= 1
	
			self.SpiralAngleMin	= -2160
			self.SpiralAngleMax	=  720
			self.SpiralAngleStep	= 20
			self.EllipseAngleMin	= -180
			self.EllipseAngleMax	= 2	
			self.EllipseAngleStep	= 20

			self.RimSize		= 0
		end
		if self.Shell == 5 then --Epitonium
			self.Amplitude 		= 5.6
			self.DemiAxePrincipal	= 1.5
			self.DemiAxeSecondaire 	= 1.5
		
			self.Alpha		= 85
			self.Beta		= 7
			self.Phi		= 0
			self.Mu			= 12
			self.Omega		= 55
		
			self.NodulePlace	= 0
			self.NoduleHeight	= 1
			self.NoduleNombre	= 7.23
			self.NoduleWidth1	= 110
			self.NoduleWidth2	= 10
	
			self.RipplesNombre	= 50
			self.RipplesAmplitude	= 1
	
			self.WavesStartNumber	= 0
			self.WavesEndNumber	= 0
			self.WavesAmplitude	= 1
	
			self.SpiralAngleMin	= -720
			self.SpiralAngleMax	=  1080
			self.SpiralAngleStep	= 20
			self.EllipseAngleMin	= -180
			self.EllipseAngleMax	= 180	
			self.EllipseAngleStep	= 20

			self.RimSize		= 0
		end
		if self.Shell == 6 then --Helcion
			self.Amplitude 		= 4.5e-017
			self.DemiAxePrincipal	= 4e-017
			self.DemiAxeSecondaire 	= 3.1e-017
		
			self.Alpha		= 18
			self.Beta		= 90
			self.Phi		= 0
			self.Mu			= 0
			self.Omega		= -40
		
			self.NodulePlace	= 0
			self.NoduleHeight	= 0
			self.NoduleNombre	= 0
			self.NoduleWidth1	= 110
			self.NoduleWidth2	= 10
	
			self.RipplesNombre	= 0
			self.RipplesAmplitude	= 1
	
			self.WavesStartNumber	= 0
			self.WavesEndNumber	= 0
			self.WavesAmplitude	= 1
	
			self.SpiralAngleMin	= 0
			self.SpiralAngleMax	= 720
			self.SpiralAngleStep	= 4
			self.EllipseAngleMin	= -180
			self.EllipseAngleMax	= 180	
			self.EllipseAngleStep	= 4

			self.RimSize		= 0
		end		
		if self.Shell == 7 then --Lammelibranch
			self.Amplitude 		= 0.025
			self.DemiAxePrincipal	= 0.025
			self.DemiAxeSecondaire 	= 0.04
		
			self.Alpha		= 45
			self.Beta		= 90
			self.Phi		= 0
			self.Mu			= 0
			self.Omega		= 0
		
			self.NodulePlace	= 0
			self.NoduleHeight	= 0
			self.NoduleNombre	= 1
			self.NoduleWidth1	= 1
			self.NoduleWidth2	= 1
	
			self.RipplesNombre	= 50
			self.RipplesAmplitude	= 1
	
			self.WavesStartNumber	= 0
			self.WavesEndNumber	= 0
			self.WavesAmplitude	= 1
	
			self.SpiralAngleMin	= 0
			self.SpiralAngleMax	= 360
			self.SpiralAngleStep	= 10
			self.EllipseAngleMin	= -180
			self.EllipseAngleMax	= 180	
			self.EllipseAngleStep	= 10

			self.RimSize		= 0
		end
		if self.Shell == 8 then --Lyria
			self.Amplitude 		= 5.0
			self.DemiAxePrincipal	= 4.0
			self.DemiAxeSecondaire 	= 1.4
		
			self.Alpha		= 84
			self.Beta		= -19
			self.Phi		= 45
			self.Mu			= 1
			self.Omega		= -2
		
			self.NodulePlace	= 0
			self.NoduleHeight	= .8
			self.NoduleNombre	= 8
			self.NoduleWidth1	= 6
			self.NoduleWidth2	= 27
	
			self.RipplesNombre	= 0
			self.RipplesAmplitude	= 1
	
			self.WavesStartNumber	= 0
			self.WavesEndNumber	= 0
			self.WavesAmplitude	= 1
	
			self.SpiralAngleMin	= 0
			self.SpiralAngleMax	=  1120
			self.SpiralAngleStep	= 10
			self.EllipseAngleMin	= -50
			self.EllipseAngleMax	= 20	
			self.EllipseAngleStep	= 10

			self.RimSize		= 0
		end
		if self.Shell == 9 then --Lyria + Ripples
			self.Amplitude 		= 5.0
			self.DemiAxePrincipal	= 4.0
			self.DemiAxeSecondaire 	= 1.4
		
			self.Alpha		= 84
			self.Beta		= -19
			self.Phi		= 45
			self.Mu			= 1
			self.Omega		= -2
		
			self.NodulePlace	= 0
			self.NoduleHeight	= .8
			self.NoduleNombre	= 8
			self.NoduleWidth1	= 6
			self.NoduleWidth2	= 27
	
			self.RipplesNombre	= 50
			self.RipplesAmplitude	= 1
	
			self.WavesStartNumber	= 0
			self.WavesEndNumber	= 0
			self.WavesAmplitude	= 1
	
			self.SpiralAngleMin	= 0
			self.SpiralAngleMax	=  1120
			self.SpiralAngleStep	= 5
			self.EllipseAngleMin	= -50
			self.EllipseAngleMax	= 20	
			self.EllipseAngleStep	= 5

			self.RimSize		= 0
		end
		if self.Shell == 10 then --Natalina
			self.Amplitude 		= 2.5
			self.DemiAxePrincipal	= 1.2
			self.DemiAxeSecondaire 	= 1.6
		
			self.Alpha		= 80
			self.Beta		= 40
			self.Phi		= 55
			self.Mu			= 10
			self.Omega		= 30
		
			self.NodulePlace	= 0
			self.NoduleHeight	= 0
			self.NoduleNombre	= 1
			self.NoduleWidth1	= 1
			self.NoduleWidth2	= 1
	
			self.RipplesNombre	= 0
			self.RipplesAmplitude	= 1
	
			self.WavesStartNumber	= 0
			self.WavesEndNumber	= 0
			self.WavesAmplitude	= 1
	
			self.SpiralAngleMin	= 0
			self.SpiralAngleMax	=  950
			self.SpiralAngleStep	= 20
			self.EllipseAngleMin	= -280
			self.EllipseAngleMax	= 100	
			self.EllipseAngleStep	= 20

			self.RimSize		= 0
		end
		if self.Shell == 11 then --Nautile
			self.Amplitude 		= 2.0
			self.DemiAxePrincipal	= 2.0
			self.DemiAxeSecondaire 	= 1.5
		
			self.Alpha		= 80
			self.Beta		= 90
			self.Phi		= 0
			self.Mu			= 0
			self.Omega		= 0
		
			self.NodulePlace	= 0
			self.NoduleHeight	= 0
			self.NoduleNombre	= 1
			self.NoduleWidth1	= 1
			self.NoduleWidth2	= 1
	
			self.RipplesNombre	= 0
			self.RipplesAmplitude	= 1
	
			self.WavesStartNumber	= 0
			self.WavesEndNumber	= 0
			self.WavesAmplitude	= 1
	
			self.SpiralAngleMin	= 0
			self.SpiralAngleMax	= 800
			self.SpiralAngleStep	= 20
			self.EllipseAngleMin	= -180
			self.EllipseAngleMax	= 180	
			self.EllipseAngleStep	= 20

			self.RimSize		= 0
		end
		if self.Shell == 12 then --Oxystle
			self.Amplitude 		= 4.7
			self.DemiAxePrincipal	= 4.0
			self.DemiAxeSecondaire 	= 1.9
		
			self.Alpha		= 84.9
			self.Beta		= 7
			self.Phi		= -36
			self.Mu			= 1
			self.Omega		= -2
		
			self.NodulePlace	= 0
			self.NoduleHeight	= 0
			self.NoduleNombre	= 1
			self.NoduleWidth1	= 1
			self.NoduleWidth2	= 1
	
			self.RipplesNombre	= 0
			self.RipplesAmplitude	= 1
	
			self.WavesStartNumber	= 0
			self.WavesEndNumber	= 0
			self.WavesAmplitude	= 1
	
			self.SpiralAngleMin	= -3600
			self.SpiralAngleMax	=  720
			self.SpiralAngleStep	= 20
			self.EllipseAngleMin	= -70
			self.EllipseAngleMax	= 70	
			self.EllipseAngleStep	= 20

			self.RimSize		= 0
		end
		if self.Shell == 13 then --Planorbis
			self.Amplitude 		= 4.5
			self.DemiAxePrincipal	= 2
			self.DemiAxeSecondaire 	= 3
		
			self.Alpha		= 84
			self.Beta		= 85
			self.Phi		= 10
			self.Mu			= 45
			self.Omega		= 5
		
			self.NodulePlace	= 0
			self.NoduleHeight	= 0
			self.NoduleNombre	= 0
			self.NoduleWidth1	= 5
			self.NoduleWidth2	= 5
	
			self.RipplesNombre	= 0
			self.RipplesAmplitude	= 1
	
			self.WavesStartNumber	= 0
			self.WavesEndNumber	= 0
			self.WavesAmplitude	= 1
	
			self.SpiralAngleMin	= -180
			self.SpiralAngleMax	=  720
			self.SpiralAngleStep	= 20
			self.EllipseAngleMin	= -150
			self.EllipseAngleMax	= 130
			self.EllipseAngleStep	= 20

			self.RimSize		= 0
		end
		if self.Shell == 14 then --Struthiolaria
			self.Amplitude 		= 5.0
			self.DemiAxePrincipal	= 1.8
			self.DemiAxeSecondaire 	= 1.6
		
			self.Alpha		= 86.9
			self.Beta		= 13
			self.Phi		= 40
			self.Mu			= 10
			self.Omega		= 30
		
			self.NodulePlace	= -15
			self.NoduleHeight	= .5
			self.NoduleNombre	= 16
			self.NoduleWidth1	= 5
			self.NoduleWidth2	= 5
	
			self.RipplesNombre	= 0
			self.RipplesAmplitude	= 1
	
			self.WavesStartNumber	= 0
			self.WavesEndNumber	= 0
			self.WavesAmplitude	= 1
	
			self.SpiralAngleMin	= -2880
			self.SpiralAngleMax	=  720
			self.SpiralAngleStep	= 20
			self.EllipseAngleMin	= -168
			self.EllipseAngleMax	= 40	
			self.EllipseAngleStep	= 20

			self.RimSize		= 0
		end
		if self.Shell == 15 then --Turbo
			self.Amplitude 		= .5
			self.DemiAxePrincipal	= .3
			self.DemiAxeSecondaire 	= .3
		
			self.Alpha		= 83
			self.Beta		= 45
			self.Phi		= 30
			self.Mu			= 5
			self.Omega		= 5
		
			self.NodulePlace	= 30
			self.NoduleHeight	= .2
			self.NoduleNombre	= 5
			self.NoduleWidth1	= 30
			self.NoduleWidth2	= 30
	
			self.RipplesNombre	= 0
			self.RipplesAmplitude	= 1
	
			self.WavesStartNumber	= 0
			self.WavesEndNumber	= 0
			self.WavesAmplitude	= 1
	
			self.SpiralAngleMin	= -720
			self.SpiralAngleMax	= 900
			self.SpiralAngleStep	= 10
			self.EllipseAngleMin	= -230
			self.EllipseAngleMax	= 80	
			self.EllipseAngleStep	= 10

			self.RimSize		= 0
		end		
		if self.Shell == 16 then --Turritella
			self.Amplitude 		= 1
			self.DemiAxePrincipal	= .13
			self.DemiAxeSecondaire 	= .15
		
			self.Alpha		= 88
			self.Beta		= 5
			self.Phi		= 55
			self.Mu			= 1
			self.Omega		= 0
		
			self.NodulePlace	= 0
			self.NoduleHeight	= 0
			self.NoduleNombre	= 1
			self.NoduleWidth1	= 1
			self.NoduleWidth2	= 1
	
			self.RipplesNombre	= 0
			self.RipplesAmplitude	= 1
	
			self.WavesStartNumber	= 0
			self.WavesEndNumber	= 0
			self.WavesAmplitude	= 1
	
			self.SpiralAngleMin	= 0
			self.SpiralAngleMax	= 3600
			self.SpiralAngleStep	= 10
			self.EllipseAngleMin	= -200
			self.EllipseAngleMax	= 70	
			self.EllipseAngleStep	= 10

			self.RimSize		= 0
		end		
		if self.Shell == 17 then --Waves
			self.Amplitude 		= 5.6
			self.DemiAxePrincipal	= 1.5
			self.DemiAxeSecondaire 	= 1.5
		
			self.Alpha		= 85
			self.Beta		= 7
			self.Phi		= 0
			self.Mu			= 12
			self.Omega		= 55
		
			self.NodulePlace	= 0
			self.NoduleHeight	= 0
			self.NoduleNombre	= 1
			self.NoduleWidth1	= 1
			self.NoduleWidth2	= 1
	
			self.RipplesNombre	= 0
			self.RipplesAmplitude	= 1
	
			self.WavesStartNumber	= 0
			self.WavesEndNumber	= 20
			self.WavesAmplitude	= .5
	
			self.SpiralAngleMin	= -720
			self.SpiralAngleMax	=  1080
			self.SpiralAngleStep	= 20
			self.EllipseAngleMin	= -50
			self.EllipseAngleMax	= 168	
			self.EllipseAngleStep	= 20

			self.RimSize		= 0
		end
		self.sMu	= sin(rad(self.Mu))
		self.cMu	= cos(rad(self.Mu))
		self.sBeta	= sin(rad(self.Beta))
		self.cBeta	= cos(rad(self.Beta))
		self.tAlpha	= tan(rad(self.Alpha))		
		self:redraw()
	end
	if id == self.AlphaID then
		if self:CheckNumber(value, -180, 180) == 1 then
			self.Alpha 	= tonumber(value)
			self.tAlpha	= tan(rad(self.Alpha))
		else
			value = self.Alpha
		end
		self:redraw()		
	end
	if id == self.BetaID then
		if self:CheckNumber(value, -180, 180) == 1 then
			self.Beta 	= tonumber(value)
			self.sBeta	= sin(rad(self.Beta))
			self.cBeta	= cos(rad(self.Beta))
		else
			value = self.Beta
		end
		self:redraw()		
	end
	if id == self.MuID then
		if self:CheckNumber(value, -180, 180) == 1 then
			self.Mu 	= tonumber(value)
			self.sMu	= sin(rad(self.Mu))
			self.cMu	= cos(rad(self.Mu))
		else
			value = self.Mu
		end
		self:redraw()		
	end
	if id == self.PhiID then
		if self:CheckNumber(value, -180, 180) == 1 then
			self.Phi	= tonumber(value)
		else
			value = self.Phi
		end
		self:redraw()		
	end
	if id == self.OmegaID then
		if self:CheckNumber(value, -180, 180) == 1 then
			self.Omega 	= tonumber(value)
		else
			value = self.Omega
		end
		self:redraw()		
	end
	if id == self.AmplitudeID then
		if self:CheckNumber(value, -100, 100) == 1 then
			self.Amplitude 	= tonumber(value)
		else
			value = self.Amplitude
		end
		self:redraw()		
	end
	if id == self.DemiAxePrincipalID then
		if self:CheckNumber(value, -100, 100) == 1 then
			self.DemiAxePrincipal 	= tonumber(value)
		else
			value = self.DemiAxePrincipal
		end
		self:redraw()		
	end		
	if id == self.DemiAxeSecondaireID then
		if self:CheckNumber(value, -100, 100) == 1 then
			self.DemiAxeSecondaire 	= tonumber(value)
		else
			value = self.DemiAxeSecondaire
		end
		self:redraw()		
	end		
	if id == self.NoduleNombreID then
		if self:CheckNumber(value, 0, 36) == 1 then
			self.NoduleNombre = tonumber(value)
		else
			value = self.NoduleNombre
		end
		self:redraw()		
	end		
	if id == self.NodulePlaceID then
		if self:CheckNumber(value, -180, 180) == 1 then
			self.NodulePlace = tonumber(value)
		else
			value = self.NodulePlace
		end
		self:redraw()		
	end		
	if id == self.NoduleHeightID then
		if self:CheckNumber(value, -18, 18) == 1 then
			self.NoduleHeight 	= tonumber(value)
		else
			value = self.NoduleHeight
		end
		self:redraw()		
	end		
	if id == self.NoduleWidth1ID then
		if self:CheckNumber(value, 1, 180) == 1 then
			self.NoduleWidth1 	= tonumber(value)
		else
			value = self.NoduleWidth1
		end
		self:redraw()		
	end		
	if id == self.NoduleWidth2ID then
		if self:CheckNumber(value, 1, 180) == 1 then
			self.NoduleWidth2 	= tonumber(value)
		else
			value = self.NoduleWidth2
		end
		self:redraw()		
	end	
	if id == self.NoduleStepDividerID then
		if self:CheckNumber(value, 1, 100) == 1 then
			self.NoduleStepDivider 	= tonumber(value)
		else
			value = self.NoduleStepDivider
		end
		self:redraw()		
	end	
	if id == self.RipplesNombreID then
		if self:CheckNumber(value, -100, 100) == 1 then
			self.RipplesNombre 	= tonumber(value)
		else
			value = self.RipplesNombre
		end
		self:redraw()		
	end		
	if id == self.RipplesAmplitudeID then
		if self:CheckNumber(value, -18, 18) == 1 then
			self.RipplesAmplitude 	= tonumber(value)
		else
			value = self.RipplesAmplitude
		end
		self:redraw()		
	end	
	if id == self.WavesStartNumberID then
		if self:CheckNumber(value, 0, 100) == 1 then
			self.WavesStartNumber 	= tonumber(value)
		else
			value = self.WavesStartNumber
		end
		self:redraw()		
	end 
	if id == self.WavesEndNumberID then
		if self:CheckNumber(value, 0, 100) == 1 then
			self.WavesEndNumber 	= tonumber(value)
		else
			value = self.WavesEndNumber
		end
		self:redraw()		
	end 
	if id == self.WavesAmplitudeID then
		if self:CheckNumber(value, -18, 18) == 1 then
			self.WavesAmplitude 	= tonumber(value)
		else
			value = self.WavesAmplitude
		end
		self:redraw()		
	end 
	if id == self.SpiralAngleMinID then
		if self:CheckNumber(value, -3600, 3600) == 1 then
			self.SpiralAngleMin 	= tonumber(value)
		else
			value = self.SpiralAngleMin
		end
		self:redraw()		
	end 
	if id == self.SpiralAngleMaxID then
		if self:CheckNumber(value, -3600, 3600) == 1 then
			self.SpiralAngleMax 	= tonumber(value)
		else
			value = self.SpiralAngleMax
		end
		self:redraw()		
	end 
	if id == self.SpiralAngleStepID then
		if self:CheckNumber(value, 1, 120) == 1 then
			self.SpiralAngleStep 	= tonumber(value)
		else
			value = self.SpiralAngleStep
		end
		self:redraw()		
	end 
	if id == self.SpiralWireStepMultiplierID then
		if self:CheckNumber(value, 1, 100) == 1 then
			self.SpiralWireStepMultiplier 	= tonumber(value)
		else
			value = self.SpiralWireStepMultiplier
		end
		self:redraw()		
	end 
	if id == self.EllipseAngleMinID then
		if self:CheckNumber(value, -3600, 3600) == 1 then
			self.EllipseAngleMin 	= tonumber(value)
		else
			value = self.EllipseAngleMin
		end
		self:redraw()		
	end 
	if id == self.EllipseAngleMaxID then
		if self:CheckNumber(value, -3600, 3600) == 1 then
			self.EllipseAngleMax 	= tonumber(value)
		else
			value = self.EllipseAngleMax
		end
		self:redraw()		
	end 
	if id == self.EllipseAngleStepID then
		if self:CheckNumber(value, 1, 120) == 1 then
			self.EllipseAngleStep 	= tonumber(value)
		else
			value = self.EllipseAngleStep
		end
		self:redraw()		
	end 
	if id == self.EllipseWireStepMultiplierID then
		if self:CheckNumber(value, 1, 100) == 1 then
			self.EllipseWireStepMultiplier 	= tonumber(value)
		else
			value = self.EllipseWireStepMultiplier
		end
		self:redraw()		
	end 
	if id == self.RimSizeID then
		if self:CheckNumber(value, 0, 18) == 1 then
			self.RimSize 	= tonumber(value)
		else
			value = self.RimSize
		end
	end 

	if id == self.TextureID then
		self.Texture = value
	end 
	if id == self.TextureInteriorID then
		self.TextureInterior = value
	end 
	scene:invalidate()
end

function SeaShell:getInside(x,y,z)
	return nil
end

-- l_
function SeaShell:NodulePosition(x)
	local pi = 3.141592
	if self.NoduleNombre == 0 then
		return 1
	else
		return (2*pi/self.NoduleNombre)*(self.NoduleNombre*x/(2*pi) - floor(self.NoduleNombre*x/(2*pi) + .5))
	end
end

-- h_
function SeaShell:ShellRadius(x,y)
	return (1/sqrt((cos(x)/self.DemiAxePrincipal)*(cos(x)/self.DemiAxePrincipal) + (sin(x)/self.DemiAxeSecondaire)*(sin(x)/self.DemiAxeSecondaire)) + self.NoduleHeight*exp(-(2*(x-rad(self.NodulePlace))/rad(self.NoduleWidth1))*(2*(x-rad(self.NodulePlace))/rad(self.NoduleWidth1)) - (2*self:NodulePosition(y)/rad(self.NoduleWidth2))*(2*self:NodulePosition(y)/rad(self.NoduleWidth2))))
end


--k_ 
function SeaShell:Ripples(x)
	if (self.RipplesAmplitude == 0) then
		return 1
	elseif (self.RipplesNombre == 0) then
        	return 1          
	else
        	return (self.RipplesAmplitude * sqrt(self.RipplesNombre*self.RipplesNombre+2*self.RipplesNombre+2-2*(self.RipplesNombre+1)*cos(self.RipplesNombre*x))/self.RipplesNombre) + 1 - self.RipplesAmplitude          
        end
end


--w_
function SeaShell:Waves(x)
local WavesNumber	
	if (self.WavesStartNumber + self.WavesEndNumber == 0) then
		return 1
	else
		WavesNumber = self.WavesStartNumber + (self.WavesEndNumber - self.WavesStartNumber)*(x - self.SpiralAngleMin)/(self.SpiralAngleMax - self.SpiralAngleMin)
        	return self.WavesAmplitude*sqrt(WavesNumber*WavesNumber+2*WavesNumber+2-2*(WavesNumber+1)*cos(WavesNumber*x))/WavesNumber + 1 - self.WavesAmplitude          
--pour plus tard        #declare w_ = function(x) { wa*(1 + sqrt(sqrt((cos(ww(x)*x)+1)/2)))/2 + 1 - wa}        	
        end
end

--X_

function SeaShell:fX(x, y)
	return ( self.Amplitude*self.sBeta*cos(y)+ self:Waves(y)*self:Ripples(x)*self:ShellRadius(x,y)*(cos(x+rad(self.Phi))*cos(rad(self.Omega)+y) - sin(x+rad(self.Phi))*self.sMu*sin(y+rad(self.Omega))))*exp(y/self.tAlpha)
end
function SeaShell:fY(x,y)
	return (-self.Amplitude*self.sBeta*sin(y)- self:Waves(y)*self:Ripples(x)*self:ShellRadius(x,y)*(cos(x+rad(self.Phi))*sin(rad(self.Omega)+y) + sin(x+rad(self.Phi))*self.sMu*sin(y+rad(self.Omega))))*exp(y/self.tAlpha)
end
function SeaShell:fZ(x,y)
	return (-self.Amplitude*self.cBeta + self:Waves(y)*self:Ripples(x)*self:ShellRadius(x,y)*sin(x+rad(self.Phi))*self.cMu) * exp(y/self.tAlpha)
end


function SeaShell:wireframe(wire)
	
	local u, v
	local uStep, vStep
	
	uStep = self.EllipseAngleStep * self.EllipseWireStepMultiplier
	vStep = self.SpiralAngleStep  * self.SpiralWireStepMultiplier
	u = self.EllipseAngleMin
	while (u + uStep <= self.EllipseAngleMax )
	do
		v = self.SpiralAngleMin
		while (v + vStep <= self.SpiralAngleMax)
		do
			wire:line(self:fX(rad(u), rad(v)), self:fY(rad(u),rad(v)), self:fZ(rad(u),rad(v)), self:fX(rad(u), rad(v+vStep)) , self:fY(rad(u), rad(v+vStep)) , self:fZ(rad(u), rad(v+vStep)))
			wire:line(self:fX(rad(u), rad(v)), self:fY(rad(u),rad(v)), self:fZ(rad(u),rad(v)), self:fX(rad(u+uStep), rad(v)), self:fY(rad(u+uStep), rad(v)), self:fZ(rad(u+uStep), rad(v)))
			v = v + vStep
		end
		wire:line(self:fX(rad(u), rad(v)), self:fY(rad(u),rad(v)), self:fZ(rad(u),rad(v)), self:fX(rad(u+uStep), rad(v)), self:fY(rad(u+uStep), rad(v)), self:fZ(rad(u+uStep), rad(v)))
		u = u + uStep
	end
	v = self.SpiralAngleMin
	while (v + vStep <= self.SpiralAngleMax)
	do
		wire:line(self:fX(rad(u), rad(v)), self:fY(rad(u),rad(v)), self:fZ(rad(u),rad(v)), self:fX(rad(u), rad(v+vStep)) , self:fY(rad(u), rad(v+vStep)) , self:fZ(rad(u), rad(v+vStep)))
		v = v + vStep
	end
end

function SeaShell:toPOV(pov)
	
	pov:write("#declare a      = ", self.DemiAxePrincipal, ";")
        pov:write("#declare b      = ", self.DemiAxeSecondaire, ";")
        pov:write("#declare A      = ", self.Amplitude, ";")
        pov:write("#declare Alpha  = radians(", self.Alpha, ");");      
        pov:write("#declare Beta   = radians(", self.Beta, ");");
        pov:write("#declare Mu     = radians(", self.Mu, ");");   
        pov:write("#declare Phi    = radians(", self.Phi, ");");
        pov:write("#declare Omega  = radians(", self.Omega, ");");     
        pov:write("#declare L      = ", self.NoduleHeight, ";")
        pov:write("#declare P      = radians(", self.NodulePlace, ");")
        pov:write("#declare W1     = radians(", self.NoduleWidth1, ");");
        pov:write("#declare W2     = radians(", self.NoduleWidth2, ");");
        pov:write("#declare N      = ", self.NoduleNombre, ";")   

        pov:write("#declare m      = ", self.RipplesNombre, ";") 
	pov:write("#declare ra     = ", self.RipplesAmplitude, ";")
        pov:write("#declare minw   = ", self.WavesStartNumber, ";") 
        pov:write("#declare maxw   = ", self.WavesEndNumber, ";") 
        pov:write("#declare wa     = ", self.WavesAmplitude, ";")
	
	pov:write("#declare rr     = ", self.RimSize,";")

        pov:write("#declare vvMin  = ", self.SpiralAngleMin, ";")
        pov:write("#declare vvMax  = ", self.SpiralAngleMax, ";")
	pov:write("#declare vvStep = ", self.SpiralAngleStep, ";")     
        pov:write("#declare uuMin  = ", self.EllipseAngleMin, ";")
        pov:write("#declare uuMax  = ", self.EllipseAngleMax, ";")
	pov:write("#declare uuStep = ", self.EllipseAngleStep, ";")



	pov:write("#declare uuNum = floor((uuMax - uuMin) / uuStep);")
	pov:write("#declare vvNum = floor((vvMax - vvMin) / vvStep);")
	pov:write("#declare sMu = sin(Mu);")
	pov:write("#declare cMu = cos(Mu);")
	pov:write("#declare sBeta = sin(Beta);")
	pov:write("#declare cBeta = cos(Beta);")
	pov:write("#declare tAlpha = tan(Alpha);")

	pov:write("#ifdef (round)")
	pov:write("	#undef round")
	pov:write("#end")    
	pov:write("#ifdef (l_)")
	pov:write("	#undef l_")
	pov:write("#end")    
	pov:write("#ifdef (h_)")
	pov:write("	#undef h_")
	pov:write("#end")    
	pov:write("#ifdef (k_)")
	pov:write("	#undef k_")
	pov:write("#end")    
	pov:write("#ifdef (w_)")
	pov:write("	#undef w_")
	pov:write("#end")    
	pov:write("#ifdef (ww)")
	pov:write("	#undef ww")
	pov:write("#end")    
	pov:write("#ifdef (X_)")
	pov:write("	#undef X_")
	pov:write("#end")    
	pov:write("#ifdef (Y_)")
	pov:write("	#undef Y_")
	pov:write("#end")    
	pov:write("#ifdef (Z_)")
	pov:write("	#undef Z_")
	pov:write("#end")    

	pov:write("#declare round = function(x) {int(x+.5)}")

	pov:write("#if (N = 0)")
	pov:write("	#declare l_ = function(y) {0} ")
	pov:write("	#declare L = 0;")
	pov:write("#else ")
	pov:write("	#declare l_ = function(y) {(2*pi/N)*(N*abs(y)/(2*pi) - round(N*abs(y)/(2*pi)))} ")
	pov:write("#end")

	pov:write("#declare h_ = function(x,y) {1/sqrt((cos(x)/a)*(cos(x)/a) + (sin(x)/b)*(sin(x)/b)) + L*exp(-(2*(x-P)/W1)*(2*(x-P)/W1) - (2*l_(y)/W2)*(2*l_(y)/W2))}")
	pov:write("#if (m = 0)")
        pov:write("	#declare k_ = function(x) {1}")
	pov:write("#else")
	pov:write("	#declare k_ = function(x) {(ra*sqrt(m*m+2*m+2-2*(m+1)*cos(m*x))/m)+1-ra}")
	pov:write("#end")

	pov:write("#if (minw + maxw = 0)")
	pov:write("        #declare w_ = function(x) {1}")
	pov:write("#else")
	pov:write("        #declare ww = function(x) {minw + (maxw-minw)*(x-vvMin)/(vvMax-vvMin)}")
	pov:write("        #declare w_ = function(x) {wa*sqrt(ww(x)*ww(x)+2*ww(x)+2-2*(ww(x)+1)*cos(ww(x)*x))/ww(x) + 1 - wa}")
	pov:write("#end ")

	pov:write("#declare X_ = function(x,y) {( A*sBeta*cos(y)+w_(y)*k_(x)*h_(x,y)*(cos(x+Phi)*cos(Omega+y) - sin(x+Phi)*sMu*sin(y+Omega)))*exp(y/tAlpha)}")
	pov:write("#declare Y_ = function(x,y) {(-A*sBeta*sin(y)-w_(y)*k_(x)*h_(x,y)*(cos(x+Phi)*sin(Omega+y) + sin(x+Phi)*sMu*sin(y+Omega)))*exp(y/tAlpha)}")
	pov:write("#declare Z_ = function(x,y) {(-A*cBeta + w_(y)*k_(x)*h_(x,y)*sin(x+Phi)*cMu) * exp(y/tAlpha)}")

	if self.RimSize > 0 then
		pov:write("union {")
	end
	pov:write("mesh2 {")
  	pov:write("vertex_vectors { (uuNum + 1) * (vvNum + 1),")
  	pov:write("#declare uu = uuMin;")
  	pov:write("#while (uu <= uuMax)")
       	pov:write("	#declare vv = vvMin;")
       	pov:write("	#while (vv <= vvMax      )")
	pov:write("		<X_(radians(uu), radians(vv)), Y_(radians(uu), radians(vv)), Z_(radians(uu), radians(vv))>")
	pov:write("		#declare vv = vv + vvStep;")
	pov:write("	#end")
	pov:write("	#declare uu = uu + uuStep;")
	pov:write("#end")
	pov:write("  }")
	pov:write("face_indices {")
  	pov:write("uuNum*vvNum*2,")
  	pov:write("#declare uu = 0;")

  	pov:write("#while (uu < uuNum)")
	pov:write("	#declare vv = 0;")
	pov:write("	#while (vv < vvNum )")
	pov:write("		<(vvNum+1)*uu + vv,(vvNum+1)*(uu+1) + vv, (vvNum+1)*(uu+1) + vv + 1>")
	pov:write("		<(vvNum+1)*uu + vv,(vvNum+1)*(uu+1) + vv + 1, (vvNum+1)*uu + vv + 1>")
	pov:write("		#declare vv = vv + 1;")
	pov:write("	#end")
	pov:write("	#declare uu = uu + 1;")
	pov:write("#end")
	pov:write("}")
	if self.RimSize > 0 then
		pov:write("}")
		pov:write("#declare uu = uuMin;")
		pov:write("#declare vv = vvMin +vvNum*vvStep;")
		pov:write("#while (uu <= uuMax)   ")
		pov:write("    	sphere {<X_(radians(uu), radians(vv)), Y_(radians(uu), radians(vv)), Z_(radians(uu), radians(vv))>, rr}")
		pov:write("    	cylinder {<X_(radians(uu), radians(vv)), Y_(radians(uu), radians(vv)), Z_(radians(uu), radians(vv))>,")
		pov:write("               <X_(radians(uu+uuStep), radians(vv)), Y_(radians(uu+uuStep), radians(vv)), Z_(radians(uu+uuStep), radians(vv))>, rr}")
		pov:write("    	#declare uu = uu + uuStep;")
		pov:write("#end")
	end

	if self.TextureInterior == "" then
		pov:texture(gsub(self.Texture, "%s", "%_") )
	else
		pov:write("interior_texture{", gsub(self.Texture, "%s", "%_"),"}")
		pov:texture(gsub(self.TextureInterior, "%s", "%_") )
	end
	
	pov:transforms(self.xforms)
	pov:write("}")
end

registerClass(SeaShell,"SeaShell")
