
// -----------------------------------------------------------------------------------------
//                     S P R I T E    M A T E R I A L S 
//------------------------------------------------------------------------------------------

#declare C_khaki_green =        rgb <0.45, 0.5, 0.2> ;
#declare C_green_apple =        rgb <0.50, 1.0, 0.3> ; 
#declare C_pea_green =          rgb <0.7, 1.0, 0.4> ; 
#declare C_forest_green =       rgb <0.0, 0.1, 0.02> ; 
#declare C_olive_green =        rgb <0.35, 0.4, 0.05> ;

#declare CM_plant_stem =
color_map { 
    [0.0 .2 color C_olive_green color C_olive_green]  
    [0.2 .5 color C_olive_green color C_olive_green * .7]
    [0.5 1.0 color C_olive_green *.7 color C_olive_green]  
}  

// --- S T E M  
#declare M_stem_A = 
material {  
    texture {
        pigment {
              bozo
              turbulence 0.6
              colour_map { CM_plant_stem}
        }  
       finish {
          ambient .2
          diffuse .5 
          emission 0
       }
    }
} 




//--- clear -----------------------------------------------------
#declare imgDiffuse =  "plants/plant_D/maps/clear.png"  

#declare M_clear = 
material { 
    texture { 
        pigment { 
            image_map { 
                png imgDiffuse 
                map_type 0 
                interpolate 4 
             }
         }
    finish {
        phong 0
        phong_size 0
        ambient .3
        }

    }
     scale <1,1,1> translate <-.5,0,0> 
}



//--- leaf D_a -----------------------------------------------------
#declare imgDiffuse = "plants/plant_D/maps/leaf_D_a.png" ; 
#declare imgBump =    "plants/plant_D/maps/leaf_D_a.png" ;

#declare M_leaf_D_a = 
material { 
    texture { 
        pigment { 
            image_map { 
                png imgDiffuse 
                map_type 0 
                interpolate 4 
                }
            }
        finish {
        phong 0
        phong_size 0 
        diffuse 1
        ambient .5
        }
    }
    scale <1,1,1> translate <-.5,0,0> 
}


//--- leaf D_b -----------------------------------------------------
#declare imgDiffuse = "plants/plant_D/maps/leaf_D_b.png" ; 
#declare imgBump =    "plants/plant_D/maps/leaf_D_b.png" ;

#declare M_leaf_D_b = 
material { 
    texture { 
        pigment { 
            image_map { 
                png imgDiffuse 
                map_type 0 
                interpolate 4 
                }
            }
        finish {
        phong 0
        phong_size 0 
        diffuse 1
        ambient .5
        }
    }
    scale <1,1,1> translate <-.5,0,0> 
}

//--- leaf D_c -----------------------------------------------------
#declare imgDiffuse = "plants/plant_D/maps/leaf_D_c.png" ; 
#declare imgBump =    "plants/plant_D/maps/leaf_D_c.png" ;

#declare M_leaf_D_c = 
material { 
    texture { 
        pigment { 
            image_map { 
                png imgDiffuse 
                map_type 0 
                interpolate 4 
                }
            }
        finish {
        phong 0
        phong_size 0 
        diffuse 1
        ambient .5
        }
    }
    scale <1,1,1> translate <-.5,0,0> 
}

  
//--- cubic spline sweep
#declare sf=1;
#declare stem_sweep_A =
sphere_sweep {
     cubic_spline
     8,
     <-0.000, 0.000, 0.000> , 0.016*sf, 
     <-0.000, 0.000, 0.000> , 0.016*sf, 
     <-0.000, 0.613, 0.000> , 0.016*sf, 
     <0.002, 1.167, -0.029> , 0.012*sf, 
     <-0.000, 1.737, -0.000> , 0.007*sf, 
     <0.009, 1.856, 0.022> , 0.006*sf, 
     <0.068, 1.929, 0.063> , 0.005*sf, 
     <0.068, 1.929, 0.063> , 0.005*sf
     tolerance 0.000001
     }


#declare stem_A = object { stem_sweep_A material {M_stem_A} }      


//--- linear spline sweep
#declare sf=1;
#declare stem_sweep_B =
sphere_sweep {
     linear_spline
     6,
     <0.009, 1.856, 0.022> , 0.006*sf, 
     <0.009, 1.856, 0.022> , 0.006*sf, 
     <-0.012, 1.946, 0.029> , 0.006*sf, 
     <-0.017, 2.078, 0.065> , 0.006*sf, 
     <0.001, 2.205, 0.135> , 0.006*sf, 
     <0.001, 2.205, 0.135> , 0.006*sf
     tolerance 0.000001
     }

#declare stem_B = object { stem_sweep_B material {M_stem_A} } 






     
// -----------------------------------------------------------------------------------------
//                     S P R I T E    C U R V E 
//------------------------------------------------------------------------------------------

#declare sprite_clip = plane { <0,0,1>,0 material {M_clear}} ;

#declare sprite_curve = 
    intersection{
       sphere { <0,0,0>, .5 translate <0,.5,0> }
       object { sprite_clip }
   }



// -----------------------------------------------------------------------------------------
//                      C U R V E    B I L L B O A R D S  
//------------------------------------------------------------------------------------------
#declare BB_leaf_D_a = object { sprite_curve material {M_leaf_D_a} }
#declare BB_leaf_D_b = object { sprite_curve material {M_leaf_D_b} }
#declare BB_leaf_D_c = object { sprite_curve material {M_leaf_D_c} }

// -----------------------------------------------------------------------------------------
//                      P L A N T    B I L L B O A R D  A
//------------------------------------------------------------------------------------------


#declare BB_leaf_D_c = object { BB_leaf_D_c scale <1,1.2,.12> rotate <20,0,0> translate <0,0,.04>}

#declare BB_plant_D_leaf_cluster = object { 
union {
    object { BB_leaf_D_c rotate <0,0,0> rotate <0,0,0>    translate <0,0,0> } 
    object { BB_leaf_D_c rotate <0,0,0> rotate <0,120,0> translate <0,.2,0> } 
    object { BB_leaf_D_c rotate <0,0,0> rotate <0,240,0> translate <0,.08,0> } 
    object { BB_leaf_D_c rotate <0,0,0> rotate <0,190,0> translate <0,.5,0> }
     
    }
}


// -----------------------------------------------------------------------------------------
//                      P L A N T  D
//------------------------------------------------------------------------------------------

#declare plant_D = object { 
union { 
    
    object { stem_A }    
    object { stem_B }  
    object { BB_leaf_D_b scale <1,1,.4> rotate <30,0,0> translate <0.001, 2.11, 0.18> }
    object { BB_leaf_D_b scale <-1,1,.3> rotate <20,0,0> rotate <50,0,0>  translate <0.05, 1.856, .02> }
    
    object { BB_leaf_D_a scale <1.2,1.2,-.3> rotate <-40,0,0> rotate <0,40,0>  translate <-0.02, 1.556, .015> }
    object { BB_leaf_D_a scale <1.2,1.2,-.3> rotate <-40,0,0> rotate <0,-50,0>  translate <0.02, 1.4, .015> }
     
    object { BB_plant_D_leaf_cluster rotate <0,0,0> translate <0, 0, 0> }
    }  
}