//--- Smooth triangle billboard panel & creased and arched bb panel
//    miller 11.10.23
//    data export from blender as .obj - formatted for POV  



//--- 1x1 billboard
#declare ST_plane = 
   union { 
    smooth_triangle {
        < .5, 0, 0>,   <0,0,1>, 
        <-.5, 1, 0>,   <0,0,1>, 
        <-.5, 0, 0>,   <0,0,1>
        } 
    smooth_triangle {
        < .5, 0, 0>,   <0,0,1>, 
        < .5, 1, 0>,   <0,0,1>, 
        <-.5, 1, 0>,   <0,0,1>
        } 
    }
    
//--- triangle points and normals for creased arched panel  
#declare p1 = <-0.50, 0.00, 0.00> ;
#declare p2 = <0.50, 0.00, 0.00> ;
#declare p3 = <-0.50, 1.00, 0.60> ;
#declare p4 = <0.50, 1.00, 0.60> ;
#declare p5 = <0.00, 0.00, 0.250> ;
#declare p6 = <0.00, 1.00, 0.850> ;
#declare p7 = <-0.50, 0.50, 0.10> ;
#declare p8 = <0.50, 0.50, 0.10> ;
#declare p9 = <0.00, 0.50, 0.350> ;
#declare p10 = <0.50, 0.750, 0.30> ;
#declare p11 = <0.00, 0.750, 0.550> ;
#declare p12 = <-0.50, 0.750, 0.30> ;
#declare p13 = <-0.50, 0.250, 0.00> ;
#declare p14 = <0.50, 0.250, 0.00> ;
#declare p15 = <0.00, 0.250, 0.250> ;

#declare n1 = <-0.1048, 0.2515, 0.8384>;
#declare n2 = <0.1048, 0.2515, 0.8384>;
#declare n3 = <0.1190, 0.0952, 0.9524>;
#declare n4 = <-0.1190, 0.0952, 0.9524>;
#declare n5 = <0.1131, 0.1809, 0.9044>;
#declare n6 = <-0.1131, 0.1809, 0.9044>;
#declare n7 = <-0.1213, -0.0, 0.9701>;
#declare n8 = <0.1213, -0.0, 0.9701>;

//--- creased arched panel 
#declare ST_leaf = 
   union { 
    //--left 1/2
    smooth_triangle { p11, n1, p4,  n1, p6,  n1 }
    smooth_triangle { p11, n1, p10, n1, p4,  n1 }
    smooth_triangle { p9,  n1, p10, n1, p11, n1 } 
    smooth_triangle { p9,  n1, p8,  n1, p10, n1 }
    smooth_triangle { p15, n1, p8,  n1, p9,  n1 } 
    smooth_triangle { p15, n1, p14, n1, p8,  n1 }
    smooth_triangle { p2,  n1, p15, n1, p5,  n1 } 
    smooth_triangle { p2,  n1, p14, n1, p15, n1 }
    //--right 1/2
    smooth_triangle { p11, n5, p3,  n5, p12, n5 } 
    smooth_triangle { p11, n5, p6,  n5, p3,  n5 }
    smooth_triangle { p9,  n5, p12, n5, p7,  n5 } 
    smooth_triangle { p9,  n5, p11, n5, p12, n5 }
    smooth_triangle { p15, n5, p7,  n5, p13, n5 }
    smooth_triangle { p15, n5, p9,  n5, p7,  n5 }
    smooth_triangle { p1,  n5, p15, n5, p13, n5 }
    smooth_triangle { p1,  n5, p5,  n5, p15, n5 }
    }


