// sprite test scene
// m.miller 11.10.23

#version 3.8; 
#declare quality = 1;
background { color rgb< .2,.25,.3> }


#switch (quality)
#case (0)
    global_settings {    
        max_trace_level 7
        ambient_light <.013,.01,.01> 
        assumed_gamma 1                 
    }
#break
#case (1)
    #local p_start		=	64/image_width;
    #local p_end_tune	=	4/image_width;
    #local p_end_final	=	2/image_width;
    global_settings {
        max_trace_level 10
        assumed_gamma 1   
        subsurface {}
        radiosity {    
            pretrace_start p_start 
            pretrace_end   p_end_tune  
            count 30                   
            nearest_count 5           
            error_bound 1.0             
            recursion_limit 4 
            low_error_factor 0.5          
            subsurface on 
        }  
    }   
#break
#else
    global_settings {    
        max_trace_level 7
        ambient_light <.013,.01,.01> * .1
        assumed_gamma 1                 
    }
#end


//--- ground plane  
#declare C_gray70 = rgb <0.7,0.7,0.7> ; 
#declare F_matt = finish { ambient .2 diffuse 1 phong 0 phong_size 0 emission 0 } 
#declare T_gray70_matt = texture{ pigment {C_gray70} finish {F_matt}};
#declare M_gray70_matt = material{ texture{T_gray70_matt}};

object {plane {<0,1,0>,0} material {M_gray70_matt} }
 

// -----------------------------------------------------------------------------------------
//                     P L A N T S
//------------------------------------------------------------------------------------------

#include "plants/plant_A/plant_A.inc"
object { plant_A rotate <0,20,0> translate <-6,0,0>}

#include "plants/plant_B/plant_B.inc"
object { plant_B rotate <0,20,0> translate <-4,0,0>}

#include "plants/plant_C/plant_C.inc"
object { plant_C rotate <0,20,0> translate <-2,0,0>}

#include "plants/plant_D/plant_D.inc"
object { plant_D rotate <0,20,0> translate <0,0,0>}

#include "plants/plant_E/plant_E.inc"
object { plant_E rotate <0,0,0> translate <2.5,0,1>}

#include "plants/plant_F/plant_F.inc"
object { plant_F rotate <0,-40,0> translate <4.3,0,0>}




#declare cam_A =
    camera {
        up <0, 1, 0>  
        angle 28    
        location <-1,10,-25> 
        look_at <-1,1,0>
    } 

camera {cam_A}


// -----------------------------------------------------------------------------------------
//                      L I G H T S
//------------------------------------------------------------------------------------------ 

#declare light_A =
light_source {
    <0,0,0> 
    #declare light_color = color red .05 green .04 blue .04 ;                      
    light_color * 20                  
    area_light
    <40, 0, 0> <0, 0, 40>         
    24,24                         
    adaptive 1                    
    jitter                        
    circular                      
    orient                     
    fade_distance 1000
    fade_power 2     
    translate <-200,400,-500>
}   
light_A  
   



