//generic leaf plant

#include "plants/billboard_and_leaf.inc"


// -----------------------------------------------------------------------------------------
//                     S T E M
//------------------------------------------------------------------------------------------

#declare C_khaki_green =        rgb <0.45, 0.7, 0.2> ;
#declare C_green_apple =        rgb <0.50, 1.0, 0.3> ; 
#declare C_pea_green =          rgb <0.7, 1.0, 0.4> ; 
#declare C_forest_green =       rgb <0.1, 0.1, 0.02> ; 
#declare C_olive_green =        rgb <0.35, 0.8, 0.05> ;

#declare CM_plant_stem =
color_map { 
    [0.0 .2 color C_olive_green color C_olive_green]  
    [0.2 .5 color C_olive_green color C_olive_green * .7]
    [0.5 1.0 color C_olive_green *.7 color C_olive_green]  
}  

// --- stem material 
#declare M_stem_D = material { 
    texture {
        pigment {
              bozo
              turbulence 0.6
              colour_map { CM_plant_stem}
        }  
       finish {
          ambient .2
          diffuse .5 
          emission 0
       }
    }
} 

//--- cubic spline sweep
#declare sf=1;
#declare stem_sweep_A =
sphere_sweep {
     cubic_spline
     8,
     <-0.000, 0.000, 0.000> , 0.016*sf, 
     <-0.000, 0.000, 0.000> , 0.016*sf, 
     <-0.000, 0.613, 0.000> , 0.016*sf, 
     <0.002, 1.167, -0.029> , 0.012*sf, 
     <-0.000, 1.737, -0.000> , 0.007*sf, 
     <0.009, 1.856, 0.022> , 0.006*sf, 
     <0.068, 1.929, 0.063> , 0.005*sf, 
     <0.068, 1.929, 0.063> , 0.005*sf
     tolerance 0.000001
     }


#declare stem_A = object { stem_sweep_A material {M_stem_A} }      


//--- linear spline sweep
#declare sf=1;
#declare stem_sweep_B =
sphere_sweep {
     linear_spline
     6,
     <0.009, 1.856, 0.022> , 0.006*sf, 
     <0.009, 1.856, 0.022> , 0.006*sf, 
     <-0.012, 1.946, 0.029> , 0.006*sf, 
     <-0.017, 2.078, 0.065> , 0.006*sf, 
     <0.001, 2.205, 0.135> , 0.006*sf, 
     <0.001, 2.205, 0.135> , 0.006*sf
     tolerance 0.000001
     }

#declare stem_B = object { stem_sweep_B material {M_stem_A} } 

// -----------------------------------------------------------------------------------------
//                     L E A F   D
//------------------------------------------------------------------------------------------

// --- leaf F1 material
#declare imgDiffuse =   "plants/plant_F/leaf_F1.png" 
#declare M_leaf_F1 = 
    material{texture{pigment{image_map{png imgDiffuse map_type 0 interpolate 4 }}
    finish{F_matt}}
    scale <1,1,1> rotate x*0 translate <-.5,0,0>  
}


// --- leaf F2 material
#declare imgDiffuse =   "plants/plant_F/leaf_F2.png" 
#declare M_leaf_F2 = 
    material{texture{pigment{image_map{png imgDiffuse map_type 0 interpolate 4 }}
    finish{F_matt}}
    scale <1,1,1> rotate x*0 translate <-.5,0,0>  
}


// --- leaf F3 material
#declare imgDiffuse =   "plants/plant_F/leaf_F3.png" 
#declare M_leaf_F3 = 
    material{texture{pigment{image_map{png imgDiffuse map_type 0 interpolate 4 }}
    finish{F_matt}}
    scale <1,1,1> rotate x*0 translate <-.5,0,0>  
}




#declare leaf_F1 = object { ST_leaf material{M_leaf_F1} scale <1,1,1> translate <0,0,0>}
#declare leaf_F1 = object { leaf_F1 scale <1,1,1> rotate <0,0,0> translate <0,0,0> } 

#declare leaf_F2 = object { ST_leaf material{M_leaf_F2} scale <1,1,1> translate <0,0,0>}
#declare leaf_F2 = object { leaf_F2 scale <1,1,1> rotate <0,0,0> translate <0,0,0> } 

#declare leaf_F3 = object { ST_leaf material{M_leaf_F3} scale <1,1,1> translate <0,0,0>}
#declare leaf_F3 = object { leaf_F3 scale <1,1,1> rotate <10,0,0> translate <0,0,0> } 





#declare leaf_F3_cluster = object { 
union {
    object { leaf_F3 scale <.6,1.1,.5> rotate <0,0,0> translate <.02,0,-.163> } 
    object { leaf_F3 scale <.6,1,.5> rotate <0,120,0> translate <-.05,0,0.04> } 
    object { leaf_F3 scale <.6,1.2,.5> rotate <0,240,0> translate <0.11,0,0> }
    }
}


// -----------------------------------------------------------------------------------------
//                     P L A N T   D
//------------------------------------------------------------------------------------------
#declare plant_F = 
object { 
    union { 
        object { stem_A }    
        object { stem_B } 
        object { leaf_F3_cluster translate <-.03,0,.021> }
        object { leaf_F3 rotate <0,30,0> scale <1,.8,.5> translate <-.1,.8,-.121> }  
        object { leaf_F1 rotate <40,0,0> scale <1,.8,.5> translate <-.01, 2.11, -.07> }
        object { leaf_F1 rotate <10,0,0> rotate <0,-60,0> scale <1,.8,.5> translate <.21, 1.6, -.065> }
        object { leaf_F2 rotate <0,0,0> rotate <30,90,0> scale <.5,.8,.5>  translate <-.04, 2.0, .070> }

        }
}  