//generic leaf plant

#include "plants/billboard_and_leaf.inc"


// -----------------------------------------------------------------------------------------
//                     S T E M
//------------------------------------------------------------------------------------------

#declare C_khaki_green =        rgb <0.45, 0.5, 0.2> ;
#declare C_green_apple =        rgb <0.50, 1.0, 0.3> ; 
#declare C_pea_green =          rgb <0.7, 1.0, 0.4> ; 
#declare C_forest_green =       rgb <0.0, 0.1, 0.02> ; 
#declare C_olive_green =        rgb <0.35, 0.4, 0.05> ;

#declare CM_plant_stem =
color_map { 
    [0.0 .2 color C_olive_green color C_olive_green]  
    [0.2 .5 color C_olive_green color C_olive_green * .7]
    [0.5 1.0 color C_olive_green *.7 color C_olive_green]  
}  

// --- stem material 
#declare M_stem_A = material { 
    texture {
        pigment {
              bozo
              turbulence 0.6
              colour_map { CM_plant_stem}
        }  
       finish {
          ambient .2
          diffuse .5 
          emission 0
       }
    }
} 

//--- cubic spline sweep
#declare sf=1;
#declare plant_A_stem =
sphere_sweep {
     cubic_spline
     6,
     <-0.000, 0.000, 0.000> , 0.035*sf, 
     <-0.000, 0.000, 0.000> , 0.035*sf, 
     <-0.034, 0.485, -0.068> , 0.035*sf, 
     <0.000, 0.836, 0.015> , 0.026*sf, 
     <-0.034, 1.377, 0.044> , 0.01*sf, 
     <-0.034, 1.377, 0.044> , 0.01*sf,  

     tolerance 0.000001
     }

// -----------------------------------------------------------------------------------------
//                     L E A F   A
//------------------------------------------------------------------------------------------

// --- leaf A material
#declare imgDiffuse =   "plants/plant_A/leaf_A.png" 
#declare M_leaf_A = 
    material{texture{pigment{image_map{png imgDiffuse map_type 0 interpolate 4 }}
    finish{F_matt}}
    scale <1,1,1> rotate x*0 translate <-.5,0,0>  
}

#declare leaf_A = object { ST_leaf material{M_leaf_A} scale <1,1,1> translate <0,0,-.25>}
#declare leaf_A = object { leaf_A rotate <70,0,0> translate <0,0,0> } 

#declare leaf_A_cluster = object { 
union {
    object { leaf_A rotate <0,0,0> rotate <0,0,0> translate <0,.2,0> } 
    object { leaf_A rotate <0,0,0> rotate <0,120,0> translate <0,0,0> } 
    object { leaf_A rotate <0,0,0> rotate <0,240,0> translate <0,.08,0> }
    }
}


// -----------------------------------------------------------------------------------------
//                     P L A N T    A
//------------------------------------------------------------------------------------------
#declare plant_A = 
object { 
    union {
        object { plant_A_stem  material{M_stem_A scale .05} }
        object { leaf_A_cluster translate <-.03,.7,.021> }
        object { leaf_A_cluster scale <.8,.8,.8> rotate <0,70,0> translate <-.03,1.1,.025> }
        object { leaf_A scale <.6,.5,.6> rotate <-30,0,0> translate <-0.034, 1.377, 0.044> } 
        object { leaf_A scale <.4,.4,.4> rotate <-40,0,0> rotate <0,120,0>  translate <-0.034, 1.377, 0.044> } 
        }
}  