// brain bots on processing unit 
// m.miller 07.14.23

#version 3.8; 
global_settings {  
    max_trace_level 7
    ambient_light <.013,.01,.01> * 20
    assumed_gamma 1                
}                        

// lighting 
//      1 = no lights  
//      2 = modelinging / elevations
//      3 = final 
 
#declare lighting = 2;


// -----------------------------------------------------------------------------------------
//                     M E C H A N I C A L   F I S H 
//------------------------------------------------------------------------------------------
#include "robot_fish.inc"  
object { robot_fish rotate <0,0,0> translate <0,0,0> }
object { robot_fish scale <.8,.8,.8> rotate <0,-40,0> translate <180,40,40> }



// -----------------------------------------------------------------------------------------
//                     L I G H T S 
//------------------------------------------------------------------------------------------
#declare light_top_left =
light_source {
    <0,0,0> 
    #declare light_color = color red 1 green 1 blue 1 ;                      
    light_color * 8                  
    area_light
    <20, 0, 0> <0, 0, 20>         
    16, 16                          
    adaptive 1                    
    jitter                        
    circular                      
    orient                     
    fade_distance 100
    fade_power 2     
    translate <0,0,0>  
}  

// light
#declare light_bottom_right =
light_source {
    <0,0,0> 
    #declare light_color = color red .6 green 1 blue .9 ;                      
    light_color * 20                  
    area_light
    <20, 0, 0> <0, 0, 20>         
    16, 16                          
    adaptive 1                    
    jitter                        
    circular                      
    orient                     
    fade_distance 50
    fade_power 2     
    translate <0,0,0>  
    shadowless
}  


// light
#declare light_A =
light_source {
    <0,0,0> 
    #declare light_color = color red .3 green 1 blue .7 ;                      
    light_color * 50                  
    area_light
    <5, 0, 0> <0, 0, 5>         
    16, 16                          
    adaptive 1                    
    jitter                        
    circular                      
    orient                     
    fade_distance 10
    fade_power 2     
    translate <0,0,0>   
    shadowless
}  

// light
#declare light_B =
light_source {
    <0,0,0> 
    #declare light_color = color red .2 green .5 blue 1 ;                      
    light_color * 200                  
    area_light
    <5, 0, 0> <0, 0, 5>         
    16, 16                          
    adaptive 1                    
    jitter                        
    circular                      
    orient                     
    fade_distance 30
    fade_power 2     
    translate <0,0,0>   
    //shadowless
}  


// light
#declare light_C =
light_source {
    <0,0,0> 
    #declare light_color = color red 0 green 1 blue .7 ;                      
    light_color * 100                  
    area_light
    <15, 0, 0> <0, 0, 15>         
    16, 16                          
    adaptive 1                    
    jitter                        
    circular                      
    orient                     
    fade_distance 30
    fade_power 2     
    translate <0,0,0>   
    shadowless
} 

#if (lighting = 1)
    //no lights
#end

#if (lighting = 2)
    object {light_top_left translate <-200, 400, -200>}    
    object {light_bottom_right translate <200, -200, -100>} 
#end

#if (lighting = 3)
    object {light_A translate <0,100,-150>}
    object {light_B translate <-200,100,100>}
    object {light_C translate <100,-100,-200>} 
#end

// -----------------------------------------------------------------------------------------
//                      S K Y  D O M E
//------------------------------------------------------------------------------------------ 
background { rgb <0.12, 0.11, 0.1> * 1 } 
 
#macro bg_sphere (sc, pos, rot, img) 
object {
    sphere  
        { 0 1 
        hollow
        pigment{
            image_map{ 
                //hdr img
                //jpeg img   
                png img        
                map_type 1 
                interpolate 4 
                }
      }        
      finish { 
        ambient  1.0 
        diffuse  1 
        emission 1
        }
      scale sc  
      translate pos
      rotate <0, rot, 0>  
      } 
}  
#end

#declare img = "background_1k.png"
// bg_sphere (scale, position, rotation, image) 
object { bg_sphere (<2000,2000,2000>, <0,10,0>, 320, img) scale <-1,1,1> }






// -----------------------------------------------------------------------------------------
//                      C A M E R A S
//------------------------------------------------------------------------------------------ 
#declare cam_front =
    camera {
        up <0, 1, 0>  
        angle .3    
        location <70,0,-50000> 
        look_at <70,0,0>
    } 

#declare cam_top =
    camera {
        up <0, 1, 0>  
        angle .5    
        location <140,50000,-.5> 
        look_at <140,0,0>
    } 
    
#declare cam_side =
    camera {
        up <0, 1, 0>  
        angle 1    
        location <-5000,370,-100> 
        look_at <0,370,-100>
    } 

#declare cam_A =
    camera {
        up <0, 1, 0>  
        angle 45   
        location <-100,80,-200> 
        look_at <60,20,0>
    } 

//camera {cam_front}    //hide sky & stage
//camera {cam_side}     //hide sky & stage
//camera {cam_elev}     //hide sky & stage
camera {cam_A}  