//   mechanical fish / steam punkish
//   m.miller 9.9.2023


#include "shapes.inc" 
#include "shapes2.inc" 
#include "fish_materials.inc " 


#declare _m_metal =  M_chrome;  
#declare _m_metal2 = M_red_gloss;
#declare _m_void =   M_red_matt ;    
#declare _m_eye =    M_teal_metal ;


// -----------------------------------------------------------------------------------------
//                      U N D E R L A Y 
//------------------------------------------------------------------------------------------ 
#declare imgDiffuse = "fish_underlay.jpg" ; 
#declare imgBump = "fish_underlay.jpg"    ;
#declare imgSize = <200,200,1> ;
#declare imgPos =  <2.5,-61.5,150> ;
#declare show_underlay =0;

#declare M_underlay =
material {
    texture { pigment {image_map { jpeg imgDiffuse map_type 0 interpolate 4  }}
    finish { ambient 1.0 diffuse 1 emission .25 }
    normal { bump_map { jpeg imgBump map_type 0 interpolate 4 } bump_size .05 }
    }
    scale imgSize
    translate imgPos 
}

#if (show_underlay)
    box {<0,0,0>,imgSize translate imgPos material {M_underlay} no_shadow}
#end


// -----------------------------------------------------------------------------------------
//                      B O D Y   P O I N T S 
//------------------------------------------------------------------------------------------ 
//--- pointArray 
#declare pointDataCount = 8 ;
#declare pointArray = array mixed [pointDataCount][2] ;
#declare pointArray[0][0] = <8.321, -3.986, 0.000>  ;
#declare pointArray[0][1] = 8.690 ;
#declare pointArray[1][0] = <17.990, -0.628, 0.000>  ;
#declare pointArray[1][1] = 13.496 ;
#declare pointArray[2][0] = <35.953, 2.394, -0.000>  ;
#declare pointArray[2][1] = 20.113 ;
#declare pointArray[3][0] = <54.222, 3.865, -0.000>  ;
#declare pointArray[3][1] = 25.867 ;
#declare pointArray[4][0] = <72.151, 1.438, -0.000>  ;
#declare pointArray[4][1] = 27.150 ;
#declare pointArray[5][0] = <95.067, -0.313, 0.000>  ;
#declare pointArray[5][1] = 21.514 ;
#declare pointArray[6][0] = <116.501, -0.852, 0.000>  ;
#declare pointArray[6][1] = 14.494 ;
#declare pointArray[7][0] = <133.891, -0.852, 0.000>  ;
#declare pointArray[7][1] = 10.674 ;


// -----------------------------------------------------------------------------------------
//                      B O D Y   
//------------------------------------------------------------------------------------------ 
//--- body shell
#declare sf=1;
#declare body_shell =
sphere_sweep {
     cubic_spline
     10,
     <8.321, -3.986, 0.000> , 8.690*sf, 
     <8.321, -3.986, 0.000> , 8.690*sf, 
     <22.237, -1.841, 0.000> , 17.024*sf, 
     <36.075, 0.817, -0.000> , 22.131*sf, 
     <53.858, 1.438, -0.000> , 27.591*sf, 
     <72.151, 1.438, -0.000> , 27.150*sf, 
     <95.067, -0.313, 0.000> , 21.514*sf, 
     <116.501, -0.852, 0.000> , 14.494*sf, 
     <133.891, -0.852, 0.000> , 10.674*sf, 
     <133.891, -0.852, 0.000> , 10.674*sf
     tolerance 0.000001
     }


//--- body cavity
#declare sf=.92;
#declare body_cavity =
sphere_sweep {
     cubic_spline
     10,
     <8.321, -3.986, 0.000> , 8.690*sf, 
     <8.321, -3.986, 0.000> , 8.690*sf, 
     <22.237, -1.841, 0.000> , 17.024*sf, 
     <36.075, 0.817, -0.000> , 22.131*sf, 
     <53.858, 1.438, -0.000> , 27.591*sf, 
     <72.151, 1.438, -0.000> , 27.150*sf, 
     <95.067, -0.313, 0.000> , 21.514*sf, 
     <116.501, -0.852, 0.000> , 14.494*sf, 
     <133.891, -0.852, 0.000> , 10.674*sf, 
     <133.891, -0.852, 0.000> , 10.674*sf
     tolerance 0.000001
     }
     
//--- mouth cavity
#declare sf=.88;
#declare mouth_cavity =
sphere_sweep {
     cubic_spline
     10,
     <8.321, -3.986, 0.000> , 8.690*sf, 
     <8.321, -3.986, 0.000> , 8.690*sf, 
     <22.237, -1.841, 0.000> , 17.024*sf, 
     <36.075, 0.817, -0.000> , 22.131*sf, 
     <53.858, 1.438, -0.000> , 27.591*sf, 
     <72.151, 1.438, -0.000> , 27.150*sf, 
     <95.067, -0.313, 0.000> , 21.514*sf, 
     <116.501, -0.852, 0.000> , 14.494*sf, 
     <133.891, -0.852, 0.000> , 10.674*sf, 
     <133.891, -0.852, 0.000> , 10.674*sf
     tolerance 0.000001
     }
     
//--- body blot
#declare sf=1.2;
#declare body_blot =
sphere_sweep {
     cubic_spline
     10,
     <8.321, -3.986, 0.000> , 8.690*sf, 
     <8.321, -3.986, 0.000> , 8.690*sf, 
     <17.990, -0.628, 0.000> , 13.496*sf, 
     <35.953, 2.394, -0.000> , 20.113*sf, 
     <54.222, 3.865, -0.000> , 25.867*sf, 
     <72.151, 1.438, -0.000> , 27.150*sf, 
     <95.067, -0.313, 0.000> , 21.514*sf, 
     <116.501, -0.852, 0.000> , 14.494*sf, 
     <133.891, -0.852, 0.000> , 10.674*sf, 
     <133.891, -0.852, 0.000> , 10.674*sf
     tolerance 0.000001
     }
       
//--- body blot
#declare sf=1.1;
#declare body_blot =
sphere_sweep {
     cubic_spline
     10,
     <8.321, -3.986, 0.000> , 8.690*sf, 
     <8.321, -3.986, 0.000> , 8.690*sf, 
     <17.990, -0.628, 0.000> , 13.496*sf, 
     <35.953, 2.394, -0.000> , 20.113*sf, 
     <54.222, 3.865, -0.000> , 25.867*sf, 
     <72.151, 1.438, -0.000> , 27.150*sf, 
     <95.067, -0.313, 0.000> , 21.514*sf, 
     <116.501, -0.852, 0.000> , 14.494*sf, 
     <133.891, -0.852, 0.000> , 10.674*sf, 
     <133.891, -0.852, 0.000> , 10.674*sf
     tolerance 0.000001
     }





 
// -----------------------------------------------------------------------------------------
//                      V O I D   F O R   R I B S  
//------------------------------------------------------------------------------------------ 
#declare void_ribs =
#declare rad = .25 ;
union { 
    #declare sc = <5.000, 35.936, 45.001> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <87.000, 0.000, 0.000> } 
    #declare sc = <5.000, 35.936, 45.001> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <101.000, 0.000, 0.000> } 
    #declare sc = <5.000, 35.936, 45.001> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <115.000, 0.000, 0.000> } 
    #declare sc = <5.000, 35.936, 45.001> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <129.000, 0.000, 0.000> } 
    #declare sc = <5.000, 35.936, 45.001> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <144.000, 0.000, 0.000> } 
    #declare sc = <5.000, 35.936, 45.001> ;
    //object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <73.000, 0.000, 0.000> } 
      }
      


// -----------------------------------------------------------------------------------------
//                      F R A M E 
//------------------------------------------------------------------------------------------ 

#include "robot_face_cuts.inc"


#declare body_frame = 
union { 
    difference {
        object {body_shell}                                                        // exterior shell
        object {body_cavity material {_m_void}}                                    // shell cavity
        object {void_ribs}                                                         // vertical rib cuts
       
        union {     
            object {face_cut_A }                                                   // face cuts
            object {face_cut_B }                                                   // ...
            object {face_cut_C }
            object {face_cut_D }
            object {face_cut_E }
            object {face_cut_F } 
            rotate <-90,0,0>
            }
        material {_m_metal}
    }
    
    difference {
        object {body_cavity material {_m_void}}                                         //inner shell
        object {mouth_cavity material {_m_void}}                                        //mouth void
          
        object {cylinder{<0,0,-50>,<0,0,50>,1} translate <30,12,0> material {_m_metal}}  //nose hole 
        object {face_cut_F rotate <-90,0,0>} 
        plane {<-1,0,0>,0 translate <80,0,0> } 
    }    
    
     
    union { 
    sphere {<0,0,0>, 2.5 scale <1,1,.7>  translate <80,0,-26.5>}   
    sphere {<0,0,0>, 2.5 scale <1,1,.7>  translate <94,0,-23>} 
    sphere {<0,0,0>, 2.5 scale <1,1,.7>  translate <108,0,-19>} 
    sphere {<0,0,0>, 2.5 scale <1,1,.7>  translate <122,0,-14>} 
    sphere {<0,0,0>, 2.5 scale <1,1,.7>  translate <136,0,-10.5>}  
    
    sphere {<0,0,0>, 2.5 scale <1,1,.7>  translate <80,0,26.5>}   
    sphere {<0,0,0>, 2.5 scale <1,1,.7>  translate <94,0,23>} 
    sphere {<0,0,0>, 2.5 scale <1,1,.7>  translate <108,0,19>} 
    sphere {<0,0,0>, 2.5 scale <1,1,.7>  translate <122,0,14>} 
    sphere {<0,0,0>, 2.5 scale <1,1,.7>  translate <136,0,10.5>}  
    material {_m_eye}
    }
                
}  



// -----------------------------------------------------------------------------------------
//                      R I B S   S O C K E T S
//------------------------------------------------------------------------------------------ 
#declare sockets = 
union { 
    difference {
        intersection {
            union {
                object {cylinder{<0,0,-50>,<0,0,50>,5} translate <80,0,0>} 
                object {cylinder{<0,0,-50>,<0,0,50>,5} translate <94,0,0>} 
                object {cylinder{<0,0,-50>,<0,0,50>,5} translate <108,0,0>} 
                object {cylinder{<0,0,-50>,<0,0,50>,5} translate <122,0,0>} 
                object {cylinder{<0,0,-50>,<0,0,50>,5} translate <136,0,0>} 
            }
            object {body_shell} 
            material {_m_metal}
        }
    object {cylinder{<0,0,-50>,<0,0,50>,12} translate <56,11,0>} 
    object {body_cavity material {_m_void}}
    }     
}  



// -----------------------------------------------------------------------------------------
//                      E Y E 
//------------------------------------------------------------------------------------------ 
#declare eye = union {
    union {
        difference {
            union { 
                #for (i,0,8)
                    torus {14,1 rotate <0,0,i*45> translate <0,0,0>} 
                #end 
            torus {14,3 rotate <90,0,0> translate <0,0,0>} 
            material {_m_metal}  
            } 
            plane {<0,0,1>,0 translate <0,0,-11.5> material {_m_metal} }
        }    
        sphere {<0,0,0>, 14 material {_m_metal2}} 
        torus {8.75,1 rotate <90,0,0> translate <0,0,-11> material {_m_metal}}
          
    }
    sphere {<0,0,0>,6 scale <1,1,.5> rotate <0,0,0> translate <0,0,-12> material {_m_eye}}  
}




// -----------------------------------------------------------------------------------------
//                      F I N S
//------------------------------------------------------------------------------------------
#declare sf=1;
#declare spine_A =
sphere_sweep {
     cubic_spline
     9,
     <61.580, 26.893, -0.000> , 2.308*sf, 
     <61.580, 26.893, -0.000> , 2.308*sf, 
     <61.629, 31.953, -0.000> , 2.308*sf, 
     <61.938, 36.812, -0.000> , 2.308*sf, 
     <62.342, 40.199, -0.000> , 1.260*sf, 
     <63.813, 48.231, -0.000> , 0.956*sf, 
     <66.088, 56.402, -0.000> , 0.668*sf, 
     <66.914, 58.764, -0.000> , 0.478*sf, 
     <66.914, 58.764, -0.000> , 0.478*sf
     tolerance 0.000001
     }



//--- cubic spline sweep
#declare sf=1;
#declare spine_B =
sphere_sweep {
     cubic_spline
     9,
     <69.049, 26.797, -0.000> , 2.308*sf, 
     <69.049, 26.797, -0.000> , 2.308*sf, 
     <69.806, 31.392, -0.000> , 2.308*sf, 
     <70.888, 35.983, -0.000> , 2.308*sf, 
     <71.753, 39.166, -0.000> , 1.260*sf, 
     <73.969, 45.460, -0.000> , 0.956*sf, 
     <76.695, 51.514, -0.000> , 0.668*sf, 
     <77.868, 53.717, -0.000> , 0.478*sf, 
     <77.868, 53.717, -0.000> , 0.478*sf
     tolerance 0.000001
     }


#declare sf=1;
#declare spine_C =
sphere_sweep {
     cubic_spline
     9,
     <77.912, 26.073, -0.000> , 2.308*sf, 
     <77.912, 26.073, -0.000> , 2.308*sf, 
     <79.101, 30.105, -0.000> , 2.308*sf, 
     <80.378, 33.761, -0.000> , 2.308*sf, 
     <81.610, 36.777, -0.000> , 1.260*sf, 
     <83.372, 40.620, -0.000> , 0.956*sf, 
     <86.364, 46.145, -0.000> , 0.668*sf, 
     <87.679, 48.270, -0.000> , 0.478*sf, 
     <87.679, 48.270, -0.000> , 0.478*sf
     tolerance 0.000001
     }

//--- cubic spline sweep
#declare sf=1;
#declare spine_D =
sphere_sweep {
     cubic_spline
     9,
     <85.526, 24.492, -0.000> , 2.308*sf, 
     <85.526, 24.492, -0.000> , 2.308*sf, 
     <87.087, 27.861, -0.000> , 2.308*sf, 
     <88.704, 30.995, -0.000> , 2.308*sf, 
     <90.194, 33.624, -0.000> , 1.260*sf, 
     <92.328, 36.922, -0.000> , 0.956*sf, 
     <94.890, 40.571, -0.000> , 0.668*sf, 
     <96.432, 42.573, -0.000> , 0.478*sf, 
     <96.432, 42.573, -0.000> , 0.478*sf
     tolerance 0.000001
     }

#declare sf=1;
#declare spine_E =
sphere_sweep {
     cubic_spline
     9,
     <93.452, 22.132, -0.000> , 2.308*sf, 
     <93.452, 22.132, -0.000> , 2.308*sf, 
     <95.250, 25.118, -0.000> , 2.308*sf, 
     <96.751, 27.319, -0.000> , 2.308*sf, 
     <98.434, 29.619, -0.000> , 1.260*sf, 
     <100.444, 32.114, -0.000> , 0.956*sf, 
     <102.727, 34.688, -0.000> , 0.668*sf, 
     <104.481, 36.492, -0.000> , 0.478*sf, 
     <104.481, 36.492, -0.000> , 0.478*sf
     tolerance 0.000001
     }

//--- cubic spline sweep
#declare sf=1;
#declare spine_F =
sphere_sweep {
     cubic_spline
     9,
     <45.086, -20.196, 0.000> , 3.170*sf, 
     <45.086, -20.196, 0.000> , 3.170*sf, 
     <46.986, -23.426, 0.000> , 2.766*sf, 
     <48.525, -26.629, 0.000> , 1.545*sf, 
     <51.293, -33.174, 0.000> , 1.260*sf, 
     <54.262, -41.443, 0.000> , 0.956*sf, 
     <56.388, -47.437, 0.000> , 0.668*sf, 
     <57.705, -52.051, 0.000> , 0.478*sf, 
     <57.705, -52.051, 0.000> , 0.478*sf
     tolerance 0.000001
     }


 
#declare spines =
union {                  
    object {spine_A translate <-1,0,0>}    
    object {spine_B}
    object {spine_C}  
    object {spine_D}    
    object {spine_E} 
    object {spine_F translate <0,0,-20>} 
    object {spine_F translate <0,0,20>} 
    material {_m_metal}
}


// -----------------------------------------------------------------------------------------
//                      F I N S 
//------------------------------------------------------------------------------------------
//--- misc sphere pints 
#declare pointDataCount = 12 ;
#declare pointArray = array mixed [pointDataCount][2] ;
#declare pointArray[0][0] = <40.500, -16.500, -20.000>  ;
#declare pointArray[0][1] = 7.000 ;
#declare pointArray[1][0] = <40.500, -16.500, 20.000>  ;
#declare pointArray[1][1] = 7.000 ;
#declare pointArray[2][0] = <163.000, 0.000, 0.000>  ;
#declare pointArray[2][1] = 3.536 ;
#declare pointArray[3][0] = <172.451, 3.578, -0.000>  ;
#declare pointArray[3][1] = 1.090 ;
#declare pointArray[4][0] = <172.393, -2.125, -0.000>  ;
#declare pointArray[4][1] = 1.090 ;
#declare pointArray[5][0] = <169.890, -7.130, -0.000>  ;
#declare pointArray[5][1] = 1.090 ;
#declare pointArray[6][0] = <170.239, 8.233, -0.000>  ;
#declare pointArray[6][1] = 1.090 ;
#declare pointArray[7][0] = <195.705, 28.040, -0.000>  ;
#declare pointArray[7][1] = 1.090 ;
#declare pointArray[8][0] = <195.705, 15.519, -0.000>  ;
#declare pointArray[8][1] = 1.090 ;
#declare pointArray[9][0] = <195.705, -0.004, -0.000>  ;
#declare pointArray[9][1] = 1.090 ;
#declare pointArray[10][0] = <195.705, -15.371, -0.000>  ;
#declare pointArray[10][1] = 1.090 ;
#declare pointArray[11][0] = <195.705, -27.773, -0.000>  ;
#declare pointArray[11][1] = 1.090 ;


#declare misc_parts =
union {
    #for (i,2,pointDataCount-1)
        #declare sz = pointArray[i][1];
        sphere {<0,0,0>,1 scale <sz,sz,sz> translate pointArray[i][0]}
    #end  
    cylinder {pointArray[0][0],pointArray[0][0]+<0,0,10>,3}
    cylinder {pointArray[1][0],pointArray[1][0]+<0,0,-10>,3} 
    torus {5,2 rotate <90,0,0> translate pointArray[0][0]} 
    torus {5,2 rotate <90,0,0> translate pointArray[1][0]} 
    
    difference {
        sphere {<0,0,0>,5 translate pointArray[0][0]}  
        plane {<0,0,1>,0  translate <0,0,-23>} 
    }
    difference {
        sphere {<0,0,0>,5 translate pointArray[1][0]}   
        plane {<0,0,-1>,0  translate <0,0,23>} 
    }
    
    sphere {<0,0,0>,2 translate <40.500, -16.500, -23.000> } 
    sphere {<0,0,0>,7 scale <.8,1,.25> translate <59,31.5,0>}        //  upper fin edge
    material {_m_metal}
}    




// -----------------------------------------------------------------------------------------
//                      F I N S 
//------------------------------------------------------------------------------------------

//--- cubic spline sweep
#declare sf=1;
#declare fin_A = 
difference {
    sphere_sweep {
         cubic_spline
         8,
         <58.133, 31.348, 0.000> , 7.249*sf, 
         <58.133, 31.348, 0.000> , 7.249*sf, 
         <68.958, 31.278, 0.000> , 6.726*sf, 
         <77.897, 29.951, 0.000> , 6.175*sf, 
         <85.788, 27.786, 0.000> , 5.701*sf, 
         <91.731, 25.658, 0.000> , 5.174*sf, 
         <97.454, 23.087, 0.000> , 4.604*sf, 
         <97.454, 23.087, 0.000> , 4.604*sf
         tolerance 0.001

         }
         plane {<1,0,0>,0 translate <59,0,0>}
         material {_m_metal}   
}


// -----------------------------------------------------------------------------------------
//                      M E C H   F I S H
//------------------------------------------------------------------------------------------
#declare robot_fish = 
union { 
    object {body_frame}  
    object {sockets}    
    object {eye rotate <26,0,0> rotate <0,5,0> scale <.8,.8,.7> translate <56,12,-24> } 
    object {eye rotate <-26,0,0>rotate <0,-5,0> scale <.8,.8,.7> translate <56,12,24> }  
    object {misc_parts}
    union{
        object {fin_A  scale <1,1,.3> translate <0,0,0> }  
        object {spines scale <1,1,1> translate <0,0,0> }
        scale <1,1,.75>
    } 
    scale <1,1,.85>   //thinner depth ?
}         

