// tanks and pipes combined to build processing units
// m.miller 8.1.23


// -----------------------------------------------------------------------------------------
//                    P I P E   R I G 
//------------------------------------------------------------------------------------------ 

#include "macro_beam.inc"    
#include "default_materials.inc"

#declare _metal_A = M_chrome;
#declare _metal_B = M_blue_gloss;
#declare _metal_C = M_green_gloss;

//--- for model study  - rem for final
#declare _metal_A = M_gray50_satin;

// -----------------------------------------------------------------------------------------
//                      B O L T   H E A D  
//------------------------------------------------------------------------------------------
#macro make_bolt_head(rad,len)
    #declare bolt_rad=.5;
    #declare bolt_length=.5; 
    #declare slot_depth =  (rad*bolt_rad)/3;
    #declare slot_offset = len/3;
    #declare bolt_cut = (rad*bolt_rad)/1.2;
    difference {
        union { 
            cylinder {<0,0,0>,<0,len,0>,rad*bolt_rad }
            sphere {<0,0,0>, .5 scale <rad,len/2,rad> translate <0,len,0> }
            sphere {<0,0,0>, .5 scale <rad,len/2,rad> translate <0,0,0> }
        }
        plane { <1,0,0>, 0 translate <-bolt_cut,0,0> rotate <0,0,0>}
        plane { <1,0,0>, 0 translate <-bolt_cut,0,0> rotate <0,60,0>}
        plane { <1,0,0>, 0 translate <-bolt_cut,0,0> rotate <0,120,0>}
        plane { <1,0,0>, 0 translate <-bolt_cut,0,0> rotate <0,180,0>}
        plane { <1,0,0>, 0 translate <-bolt_cut,0,0> rotate <0,240,0>}
        plane { <1,0,0>, 0 translate <-bolt_cut,0,0> rotate <0,300,0>}
    }
#end 



#macro make_flange()
    #declare x1 = 0;
    #declare x2 = r-b;
    #declare x3 = r;
    #declare x4 = r;
    #declare x5 = r-b;
    #declare x6 = 0; 
    #declare y1 = 0;
    #declare y2 = 0;
    #declare y3 = b;
    #declare y4 = h-b;
    #declare y5 = h;
    #declare y6 = h; 
    
    difference {
        lathe{  
          linear_spline 
          6,      
          <x1,y1>, 
          <x2,y2>, 
          <x3,y3>,
          <x4,y4>,
          <x5,y5>,
          <x6,y6> 
          material{mat1}
         }
      torus {r,b translate <0,h/2,0>  material{mat2}}
      }
      
      #if (show_bolts)
        #declare a=360/bolt_count;
        #for(i,0,bolt_count-1)
            object {bolt translate <r*.8,h,0> rotate <0,i*a,0> material{mat1}} 
            object {bolt translate <r*.8,0,0> rotate <0,0,180> rotate <0,i*a,0> material{mat1}}
        #end
      #end    
#end
 




#macro make_pipe() 
    union{
        cylinder {<0,b,0>,<0,h-b,0>,r}
        cylinder {<0,0,0>,<0,h,0>,r-b}
        torus {r-b, b translate <0,h-b,0>}   
        torus {r-b, b translate <0,b,0>}  
        material{mat1}
        }
#end


#macro make_cove_connection() 
    difference{
        cylinder {<0,0,0>,<0,h,0>,r}
        torus {r, b translate <0,h/2,0>}  
        material{mat1}
        }
#end



#macro make_elbo() 
    difference{
        torus {r1, r2 rotate <90,0,0>}
        plane {<0,1,0>,0}
        plane {<-1,0,0>,1}
        translate <r1,0,0>  
        material{mat1}
        }
#end


#macro make_tank_A() 
    union {
        sphere {<0,0,0>,1 scale <r1,r1,r1>} 
        torus {r1,b}
        difference {
            sphere {<0,0,0>,1 scale <r2,r2,r2>} 
            plane {<0,-1,0>,0}
        }
    }
     
    material{mat1}
#end
     



#macro make_pill() 
    union{
        #if (left_cap) sphere {<0,0,0>,1 scale <r1,r1,r1> translate <0,0,0>}   #end
        #if (right_cap) sphere {<0,0,0>,1 scale <r1,r1,r1> translate <w,0,0>}  #end
        cylinder {<0,0,0>,<w,0,0>,r1}
        #if (ribs>0)
            #declare gap = w/ribs-1; 
            #declare rib = torus {r1,b rotate <0,0,90>}
            #for (i,0,ribs)
                 #declare nx = (i*gap)+(b*i);
                 object {rib translate <nx,0,0>} 
            #end
        #end
        material{mat1}
        }
#end


#macro make_tube() 
    union{
        difference {
            cylinder {<0,b,0>,<0,h-r3,0>,r1} 
            cylinder {<0,-1,0>,<0,h+1,0>,r2}
        }
        torus {r1-r3, r3 translate <0,h-r3,0>} 
        torus {r1-r3, r3 translate <0,+r3,0>} 
        torus {r2-r3, r3 translate <0,h-r3,0>} 
        torus {r2-r3, r3 translate <0,+r3,0>}
        difference {
            cylinder {<0,0,0>,<0,h,0>,r1-r3} 
            cylinder {<0,-1,0>,<0,h+1,0>,r2-r3}
        }
        
        material{mat1}
        }
#end

 
// --- flange_10
#declare r =            10;
#declare h =            3;
#declare b =            .25;
#declare mat1 =         _metal_A;
#declare mat2 =         M_black_gloss;
#declare show_bolts =   true; 
#declare bolt_count =   8;  
#declare bolt =         make_bolt_head(2,1); 
#declare flange_10 =    union { make_flange() }; 


// --- flange_8
#declare r =            8;
#declare h =            2;
#declare b =            .25;
#declare mat1 =         _metal_A;
#declare mat2 =         M_black_gloss;
#declare show_bolts =   true; 
#declare bolt_count =   8;  
#declare bolt =         make_bolt_head(1.5,.75); 
#declare flange_8 =    union { make_flange() }; 

// --- flange_8b
#declare r =            8;
#declare h =            3;
#declare b =            .25;
#declare mat1 =         _metal_A;
#declare mat2 =         M_black_gloss;
#declare show_bolts =   false; 
#declare bolt_count =   8;  
#declare bolt =         make_bolt_head(1,.5); 
#declare flange_8b =    union { make_flange() }; 

// --- pipe_A 
#declare r =            5;
#declare h =            10;
#declare b =            .5;
#declare mat1 =         _metal_A;
#declare mat2 =         M_black_gloss;
#declare pipe_A =       union { make_pipe() };


// --- pipe_B 
#declare r =            5;
#declare h =            20;
#declare b =            .5;
#declare mat1 =         _metal_A;
#declare mat2 =         M_black_gloss;
#declare pipe_B =       union { make_pipe() };


// --- pipe_C 
#declare r =            5;
#declare h =            20;
#declare b =            .5;
#declare mat1 =         _metal_A;
#declare mat2 =         M_black_gloss;
#declare pipe_B =       union { make_pipe() };

// --- pipe_D 
#declare r =            7;
#declare h =            5;
#declare b =            .5;
#declare mat1 =         _metal_A;
#declare mat2 =         M_black_gloss;
#declare pipe_D =       union { make_pipe() };


// --- pipe_E 
#declare r =            8;
#declare h =            10;
#declare b =            .5;
#declare mat1 =         _metal_A;
#declare mat2 =         M_black_gloss;
#declare pipe_E =       union { make_pipe() };

// --- pipe_F 
#declare r =            3;
#declare h =            8;
#declare b =            .5;
#declare mat1 =         _metal_A;
#declare mat2 =         M_black_gloss;
#declare pipe_F =       union { make_pipe() };


// --- pipe_G 
#declare r =            30;
#declare h =            12;
#declare b =            2;
#declare mat1 =         _metal_A;
#declare mat2 =         M_black_gloss;
#declare pipeG =       union { make_pipe() };

// --- pipe_H 
#declare r =            19;
#declare h =            100;
#declare b =            2;
#declare mat1 =         _metal_A;
#declare mat2 =         M_black_gloss;
#declare pipeH =       union { make_pipe() };


// --- pipe_I 
#declare r =            22;
#declare h =            25;
#declare b =            2;
#declare mat1 =         _metal_A;
#declare mat2 =         M_black_gloss;
#declare pipeI =       union { make_pipe() };

// --- pipe_leg_A 
#declare r =            2;
#declare h =            70;
#declare b =            .75;
#declare mat1 =         _metal_A;
#declare mat2 =         M_black_gloss;
#declare pipe_leg_A =       union { make_pipe() };




// --- cove_A
#declare r =            4.5;
#declare h =            3;
#declare b =            1;
#declare mat1 =         _metal_A;
#declare mat2 =         M_black_gloss;
#declare cove_A =       union { make_cove_connection() };


// --- elbo_A
#declare r1 =           15;
#declare r2 =           5;
#declare b =            1;
#declare mat1 =         _metal_A;
#declare elbo_A =      union { make_elbo() };

// --- elbo_B
#declare r1 =           6;
#declare r2 =           2;
#declare b =            .5;
#declare mat1 =         _metal_A;
#declare elbo_B =       union { make_elbo() };



// --- tank_A
#declare r1 =           25;
#declare r2 =           28;
#declare b =            3;
#declare mat1 =         _metal_A;
#declare tank_A =       union { make_tank_A() };


// --- pill_A
#declare r1 =           10;
#declare w =            140; 
#declare ribs =         3;
#declare b =            .75;
#declare left_cap =     true;  
#declare right_cap =    true;
#declare mat1 =         _metal_A;
#declare pill_A =       union { make_pill() };

// --- pill_B
#declare r1 =           30;
#declare w =            30; 
#declare ribs =         2;
#declare b =            1;  
#declare left_cap =     true;  
#declare right_cap =    true;
#declare mat1 =         _metal_A;
#declare pill_B =       union { make_pill() };

// --- pill_C
#declare r1 =           28;
#declare w =            85; 
#declare ribs =         0;
#declare b =            1;  
#declare left_cap =     true;  
#declare right_cap =    true;
#declare mat1 =         _metal_A;
#declare pill_C =       union { make_pill() };


// --- tube_A
#declare r1 =           10;
#declare r2 =           7;
#declare r3 =           1; 
#declare h =            10;
#declare ribs =         3;
#declare b =            .5;
#declare mat1 =         _metal_A;
#declare tube_A =       union { make_tube() };



#declare mat1 =         _metal_A;
#declare r =            2;
#declare h =            20;



#declare tank_leg =
union { 
   object { pipe_leg_A translate <0,-70,0>}
   sphere { <0,0,0>, 1 scale <3,5,3> translate <0,0,0>} 
   sphere { <0,0,0>, 1 scale <3,5,3> translate <0,-70,0>}
   material{mat1}
}




#declare connection_pipe_A =
union {
    object { flange_8 rotate <0,0,90> translate <15,48,0> }
    object { elbo_A translate <0,33,0> }
    object { pipe_B translate <0,13,0> }
    object { cove_A translate <0,10,0> }
    object { pipe_A }
    object { flange_10 } 
    object { cove_A translate <0,10,0> }
    object { flange_8 rotate <0,0,0> translate <0,33,0> }
}

#declare connection_pipe_B =
union {
    object { pipe_B translate <0,13,0> }                                    //  y+33
    object { cove_A translate <0,10,0> }
    object { pipe_A }
    object { flange_10 } 
    object { cove_A translate <0,10,0> }
    object { flange_8 rotate <0,0,0> translate <0,33,0> }
}

//-- ball shape tank 
#declare ball_tank =
union {
    object { pipe_D translate <0,23,0> }
    object { tank_A translate <0,0,0> }  
    union {
        object { tank_leg translate <-28,-5,0> }
        object { tank_leg translate <28,-5,0> }
        object { tank_leg translate <0,-5,28> }
        object { tank_leg translate <0,-5,-28> } 
        rotate <0,45,0>
        }
}


#declare pipe_coupling_A =
union {
    object { pipe_F translate <0,13,0> }  
    sphere {<0,0,0>,6.5 translate <0,13,0> material{mat1} }
    object { flange_8b translate <0,10,0> }  
    object { pipe_E translate <0,0,0> }
}



#declare pipe_coupling_B =
union {
    object { tube_A }
    sphere {<0,0,0>,1 scale <5,3,5> translate <0,9,0> material{mat1} }
}  




#declare process_tank_A =
union {
    object { connection_pipe_A translate <0,28,0> }                     //   x+15 y+76
    object { ball_tank translate <0,0,0> }
    object { pipe_coupling_A rotate <0,0,-55> translate <15,10,0> }
    object { pipe_coupling_A rotate <0,0,180> translate <0,-23,0> }
    cylinder {<0,0,0>,<30,0,0>,5 translate <15,76,0> material{mat1}}   
    object {pipe_coupling_B scale <.5,.5,.5> rotate <-140,0,0> translate <0,-19,-17>}
    object {pipe_coupling_B scale <.5,.5,.5> rotate <0,0,140> translate <-17,-19,0>}
    object {pipe_coupling_B scale <.5,.5,.5> rotate <0,0,45> translate <-16,15,0>}
    
       
}


#declare process_tank_B =
union {
    object { connection_pipe_B translate <0,28,0> }                    //   35+28
    object { ball_tank translate <0,0,0> }
    object { pipe_coupling_A rotate <0,0,-55> translate <15,10,0> }
    object { pipe_coupling_A rotate <0,0,180> translate <0,-23,0> } 
    object { pipe_coupling_A rotate <-55,0,0> translate <0,10,-15> } 
    cylinder {<0,0,0>,<0,8,0>,7 translate <0,63,0> material{mat1}}
    object {pipe_coupling_B scale <.5,.5,.5> rotate <-140,0,0> translate <0,-19,-17>}
    object {pipe_coupling_B scale <.5,.5,.5> rotate <0,0,140> translate <-17,-19,0>}
    object {pipe_coupling_B scale <.5,.5,.5> rotate <0,0,45> translate <-16,15,0>}
}
 


#declare process_tank_C =
union {
    object { pill_A translate <0,0,0> }                               //   y76
    
}

#declare tank_D_stand =
#declare rad = .25 ;
union { 
    #declare sc = <3.000, 16.000, 3.000> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-21.000, 16.000, -21.000> } 
    #declare sc = <3.000, 16.000, 3.000> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <21.000, 16.000, -21.000> } 
    #declare sc = <3.000, 16.000, 3.000> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <21.000, 16.000, 21.000> } 
    #declare sc = <3.000, 16.000, 3.000> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-21.000, 16.000, 21.000> } 
    #declare sc = <5.852, 0.576, 5.852> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-21.000, 0.500, 21.000> } 
    #declare sc = <5.852, 0.456, 5.852> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <21.000, 0.500, 21.000> } 
    #declare sc = <5.852, 0.576, 5.852> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <21.000, 0.500, -21.000> } 
    #declare sc = <5.852, 0.576, 5.852> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-21.000, 0.500, -21.000> } 
    #declare sc = <1.440, 7.680, 1.440> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-21.000, 28.591, 21.000> } 
    #declare sc = <1.440, 7.680, 1.440> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <21.000, 28.591, 21.000> } 
    #declare sc = <1.440, 7.680, 1.440> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <21.000, 28.591, -21.000> } 
    #declare sc = <1.440, 7.680, 1.440> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-21.000, 28.591, -21.000> } 
      }

#declare process_tank_D = 
union {
    union {
        object { cove_A translate <0,70,0> }  
        object { flange_10 rotate <0,0,0> translate <0,62,0> } 
        cylinder {<0,0,0>,<0,15,0>,5 translate <0,55,0> material{mat1}} 
        object { pill_B rotate <0,0,90> translate <0,0,0> } 
        translate <0,42,0>
    }      
    object {tank_D_stand material{mat1}}
}


#declare process_tank_E = 
union {
 
    object { pill_C rotate <0,0,90> translate <0,0,0> } 
    object { pipeG translate <0,72,0> } 
    object { pipeG translate <0,0,0> }   
    #declare rib = torus {28,1 rotate <90,0,0> material {mat1}}
    #for (i,0,11)
         object {rib rotate <0,i*30,0> translate <0,85,0>}
    #end
    object { pipe_coupling_A rotate <-90,0,0> translate <0,45,-22> } 
    object { pipe_coupling_A scale <1.2,1,1.2> rotate <0,0,180> translate <0,-22,0> }
}



#declare process_tank_F = 
union {
    object { pipeH translate <0,0,0> } 
    object { pipeI translate <0,40,0> }
    sphere {<0,0,0>,19 translate <0,110,0>  material {mat1}} 
    object { flange_10 rotate <0,0,0> translate <0,134,0> } 
    cylinder {<0,0,0>,<0,9,0>,5 translate <0,125,0> material{mat1}}     
    
    #declare post = 
    union {
        cylinder {<0,0,0>,<0,7,0>,2 }
        sphere {<0,0,0>,2 translate <0,7,0>}
        sphere {<0,0,0>,2 translate <0,0,0>}
        material{mat1} 
    }
    
    #for (i,0,8)
        object {post translate <18,90,0> rotate <0,i*45,0> } 
        object {pipe_coupling_B scale <.35,.35,.35> rotate <0,0,90> translate <-17,110,0> rotate <0,i*45,0>}
    #end
        
}    


#declare pipe_cluster_A =                          
union {
    object { process_tank_A translate <0,154,0> }     // right ball tank
    object { process_tank_D translate <0,0,0> }       // base pill tanks
}


#declare pipe_cluster_B =                          
union {
    object { process_tank_B translate <0,154,0> }     // right ball tank
    object { process_tank_D translate <0,0,0> }       // base pill tanks
}




#declare process_pipes_A = 
union { 
    cylinder {<0,0,0>,<0,-77,0>,2 }  
    cylinder {<0,0,0>,<0,-5,0>, 2.5} 
    torus {2,1 translate <0,-5,0>}
    object { elbo_B rotate <180,0,0> translate <0,-77,0>  }   
    cylinder {<0,0,0>,<5,0,0>,2 translate <5,-83,0>}    
    object { elbo_B rotate <0,0,-90> translate <10,-83,0>  }
    cylinder {<0,0,0>,<0,-73,0>,2  translate <16,-88,0>}  
    object { elbo_B rotate <180,0,0> translate <16,-161,0>  } 
    cylinder {<0,0,0>,<15,0,0>,2 translate <21,-167,0>}  
    cylinder {<0,0,0>,<15,0,0>,3 translate <24,-167,0>} 
    torus {2,.5 translate <0,-77,0>}
    torus {2,.5 rotate <0,0,90> translate <5,-83,0>}
    torus {2,.5 rotate <0,0,90> translate <10,-83,0>}
    torus {2,.5 translate <16,-88,0>}
    torus {2,.5 translate <16,-161,0>}  
    torus {2,.5 rotate <0,0,90> translate <21,-167,0>} 
    torus {2,1 rotate <0,0,90> translate <24,-167,0>}
    material{mat1}
}


#declare top_cone =
union {
    cone {<0,0,0>,12<0,4,0>11 }
    cone {<0,0,0>,10<0,69,0>8 }
    torus {6,2 translate <0,69,0> }
    sphere {<0,0,0>,6 translate <0,69,0>}
    cone {<0,69,0>,1.5<0,110,0>.75 }  
    sphere {<0,0,0>,4 translate <0,110,0>} 
    
    torus {9.4,1 translate <0,15,0> }
    torus {9.1,1 translate <0,26,0> }
    torus {8.8,1 translate <0,37,0> }
    torus {8.5,1 translate <0,48,0> }
    torus {8.2,1 translate <0,59,0> }
    material{mat1}
}




#include "tower_frame.inc"
#include "tower_railing.inc"



#declare process_unit =
union { 
    object { tower_railing translate <0,0,0> material{mat1}}                                    // top railing
    object { tower_frame translate <0,0,0> material{mat1}}                                      // main tower frame
    object { tower_stand translate <0,0,0> material{mat1}}                                      // tower stand
    
    object { pipe_cluster_A translate <-82,0,34> }                                              // left side tanks and pipes
    object { pipe_cluster_A translate <-82,0,-34> }
    object { process_tank_F translate  <0,0,0> }                                                // center base pill tanks 
    object { process_tank_E translate  <0,180,0> }                                              // top vert pill tanks  
    
    object { pipe_cluster_B translate <82,0,0> }
    object { process_tank_C translate <-45,230,0> }                                             // top horz. pill tank
    
    object { process_tank_C rotate <0,90,0> translate <-46,230,62> }                            // top horz. pill tank
    object { process_tank_C scale <1.05,1.05,1.05> rotate <0,90,0> translate <-82,57,67> }      // top horz. pill tank
    object { process_tank_F scale <.7,.7,.7> rotate  <-90,0,0> translate <0,30,20> }            // center base pill tanks   

    object { process_pipes_A translate <-46,222,-12> }                                          // vert side pipes  
    object { process_pipes_A translate <-46,222,-5> }                                           // vert side pipes  
    object { process_pipes_A translate <-46,222,2> }                                            // vert side pipes  
    
    union {
        object { process_pipes_A translate <-46,222,-12> }                                      // vert side pipes  
        object { process_pipes_A translate <-46,222,-5> }                                       // vert side pipes  
        object { process_pipes_A translate <-46,222,2> } 
        scale <-1,1,1>       
    }  
    
    object { top_cone translate <0,290,0> }                                                     // top cone  
}     


#declare process_unit_horz =
union { 

    object { tower_frame translate <0,0,0> material{mat1}}                                      // main tower frame

    object { pipe_cluster_A translate <-82,0,34> }                                              // left side tanks and pipes
    object { pipe_cluster_A translate <-82,0,-34> }
    object { process_tank_F translate  <0,0,0> }                                                // center base pill tanks 
    object { process_tank_E translate  <0,180,0> }                                              // top vert pill tanks  
    
    object { pipe_cluster_B translate <82,0,0> }
    object { process_tank_C translate <-45,230,0> }                                             // top horz. pill tank
    
    object { process_tank_C rotate <0,90,0> translate <-46,230,62> }                            // top horz. pill tank
    object { process_tank_C scale <1.05,1.05,1.05> rotate <0,90,0> translate <-82,57,67> }      // top horz. pill tank
    object { process_tank_F scale <.7,.7,.7> rotate  <-90,0,0> translate <0,30,20> }            // center base pill tanks   

    object { process_pipes_A translate <-46,222,-12> }                                          // vert side pipes  
    object { process_pipes_A translate <-46,222,-5> }                                           // vert side pipes  
    object { process_pipes_A translate <-46,222,2> }                                            // vert side pipes  
    
    union {
        object { process_pipes_A translate <-46,222,-12> }                                      // vert side pipes  
        object { process_pipes_A translate <-46,222,-5> }                                       // vert side pipes  
        object { process_pipes_A translate <-46,222,2> } 
        scale <-1,1,1>       
    }  
                                              
}