// I- Beam with holes - macro 
// m.miller 07.14.23


// -----------------------------------------------------------------------------------------
//                    I - B E A M 
//------------------------------------------------------------------------------------------ 

#include "shapes.inc"
#include "shapes2.inc"

#macro i_beam() 
#declare void_width =   (beam_width-web_width)/2;
#declare void_height =   beam_height-(flange_height*2);
#declare beam_left =    -beam_width/2  ;
#declare beam_right =    beam_width/2  ; 
#declare beam_top =      beam_height/2 ;
#declare beam_bottom =  -beam_height/2 ;
#declare beam_back  =   -beam_depth/2 ;
#declare beam_front  =   beam_depth/2 ;  
#declare void_cutter = Round_Box(<-void_width,(-void_height/2)-.01,-beam_depth-1>,<void_width,(void_height/2)+.01,beam_depth+1>, web_fillet   , 0)  
#declare flange = Round_Box(<beam_left,-flange_height/2,beam_back>,<beam_right,flange_height/2,beam_front>, flange_fillet , 0)  


#declare web = difference {
    box { <beam_left,beam_bottom + flange_height,beam_back>,<beam_right,beam_top - flange_height,beam_front> }
    object { void_cutter translate <beam_right,0,0>}  
    object { void_cutter translate <beam_left,0,0>}
} 

#declare hole_cutter = cylinder {<beam_left,0,0>,<beam_right,0,0>, hole_rad}
    
union {
    #if (web_holes) 
        #declare hole_count = (beam_depth/hole_spacing) + 1 ; 
        #declare hole_start = beam_back+(hole_spacing*2) ;
        difference {
            object {web scale <0,0,.99> translate <0,0,0>}
            union {
                #for (i,0,hole_count)
                    #declare nz = (i * hole_spacing) + hole_offset; 
                    object {hole_cutter translate <0,0,nz> }
                #end 
                translate <0,0,beam_back>
            }       
            }
    #else
        object {web scale <1,1,.99> translate <0,0,0>}
    #end  
    
    object {flange  translate <0,beam_top-(flange_height/2),0>}
    object {flange  translate <0,beam_bottom+(flange_height/2),0>}
 } 
#end






