// brain bots on processing unit 
// m.miller 07.14.23

#version 3.8; 
global_settings {  
    max_trace_level 7
    ambient_light <.013,.01,.01> * 10
    assumed_gamma 1                
}                        

// lighting 
//      1 = no lights  
//      2 = modelinging / elevations
//      3 = final 
 
#declare lighting = 2;


// -----------------------------------------------------------------------------------------
//                     P R O C E S S I N G    U N I T 
//------------------------------------------------------------------------------------------
#include "pipes_tanks.inc" 
object { process_unit rotate <0,0,0> translate <0,0,0> }


// -----------------------------------------------------------------------------------------
//                     BRAIN BOTS
//------------------------------------------------------------------------------------------
#declare butt_light_on = 1;  
#declare helmet_on = 1;
#declare brains_on = 1;

#include "brain_bot.inc"  
#include "bot_A_tenticles.inc" 
#include "bot_B_tenticles.inc" 

#declare bot_pose_A =
union {
    object { bot_A_leg_left }
    object { bot_A_leg_right }  
    object { bot_A_arm_left }
    object { bot_A_arm_right }
    object { brain_bot scale <2.3,2.3,2.3> rotate <0,0,-15> translate <78,403.0,38.25>}  
    translate <0,0,0>
} 

#declare bot_pose_B =
union {
    object { bot_B_leg_left }
    object { bot_B_leg_right }  
    object { bot_B_arm_left }
    object { bot_B_arm_right }  
    object { brain_bot scale <2.3,2.3,2.3> rotate <0,15,0> translate <139.5,203,52.35>} 
    translate <18,40,0>
}  

object {bot_pose_A} 
object {bot_pose_B} 




// -----------------------------------------------------------------------------------------
//                     L I G H T S 
//------------------------------------------------------------------------------------------




// light
#declare light_top_left =
light_source {
    <0,0,0> 
    #declare light_color = color red .3 green 1 blue .7 ;                      
    light_color * 50                  
    area_light
    <5, 0, 0> <0, 0, 5>         
    16, 16                          
    adaptive 1                    
    jitter                        
    circular                      
    orient                     
    fade_distance 100
    fade_power 2     
    translate <0,0,0>  
    //shadowless
}  

// light
#declare light_bottom_right =
light_source {
    <0,0,0> 
    #declare light_color = color red .3 green 1 blue .7 ;                      
    light_color * 10                  
    area_light
    <5, 0, 0> <0, 0, 5>         
    16, 16                          
    adaptive 1                    
    jitter                        
    circular                      
    orient                     
    fade_distance 100
    fade_power 2     
    translate <0,0,0>  
    //shadowless
}  


// light
#declare light_process_unit =
light_source {
    <0,0,0> 
    #declare light_color = color red .3 green 1 blue .7 ;                      
    light_color * 50                  
    area_light
    <5, 0, 0> <0, 0, 5>         
    16, 16                          
    adaptive 1                    
    jitter                        
    circular                      
    orient                     
    fade_distance 8
    fade_power 2     
    translate <0,0,0>   
    shadowless
}  

// light
#declare light_process_unit_shadow =
light_source {
    <0,0,0> 
    #declare light_color = color red 0 green 1 blue .7 ;                      
    light_color * 200                  
    area_light
    <5, 0, 0> <0, 0, 5>         
    16, 16                          
    adaptive 1                    
    jitter                        
    circular                      
    orient                     
    fade_distance 8
    fade_power 2     
    translate <0,0,0>   
    //shadowless
}  


// light
#declare light_process_unit_shadow_2 =
light_source {
    <0,0,0> 
    #declare light_color = color red 0 green 1 blue .7 ;                      
    light_color * 50                  
    area_light
    <5, 0, 0> <0, 0, 5>         
    16, 16                          
    adaptive 1                    
    jitter                        
    circular                      
    orient                     
    fade_distance 8
    fade_power 2     
    translate <0,0,0>   
    //shadowless
} 

#if (lighting = 3)
    object {light_process_unit translate <0,100,-150>}
    object {light_process_unit_shadow translate <0,100,-150>}
    object {light_process_unit_shadow_2 translate <-100,400,-100>} 
#end

#if (lighting = 2)
    object {light_top_left translate <-500, 1000, -500>}    
    object {light_bottom_right translate <500, -1000, 200>} 
#end

// -----------------------------------------------------------------------------------------
//                      S K Y  D O M E
//------------------------------------------------------------------------------------------ 
background { rgb <0.12, 0.11, 0.1> * 1 } 
 
#macro bg_sphere (sc, pos, rot, img) 
object {
    sphere  
        { 0 1 
        hollow
        pigment{
            image_map{ 
                //hdr img
                //jpeg img   
                png img        
                map_type 1 
                interpolate 4 
                }
      }        
      finish { 
        ambient  1.0 
        diffuse  1 
        emission 3
        }
      scale sc  
      translate pos
      rotate <0, rot, 0>  
      } 
}  
#end

#declare img = "background_4k.png"
// bg_sphere (scale, position, rotation, image) 
object { bg_sphere (<2000,2000,2000>, <0,10,0>, 320, img) scale <-1,1,1> }






// -----------------------------------------------------------------------------------------
//                      C A M E R A S
//------------------------------------------------------------------------------------------ 
#declare cam_front =
    camera {
        up <0, 1, 0>  
        angle .5    
        location <50,200,-50000> 
        look_at <140,200,0>
    } 

#declare cam_top =
    camera {
        up <0, 1, 0>  
        angle .5    
        location <140,50000,-.5> 
        look_at <140,0,0>
    } 
    
#declare cam_side =
    camera {
        up <0, 1, 0>  
        angle 1    
        location <-5000,370,-100> 
        look_at <0,370,-100>
    } 

#declare cam_A =
    camera {
        up <0, 1, 0>  
        angle 50    
        location <200,-40,-50> 
        look_at <0,-40,-50>
    } 
    
#declare cam_B =
    camera {
        up <0, 1, 0>  
        angle 30    
        location <-60,120,-550> 
        look_at <-50,100,0>
    } 


#declare cam_C =
    camera {
        up <0, 1, 0>  
        angle 65    
        location <-100,-30,-270> 
        look_at <-40,130,0>
    } 

#declare cam_D =
    camera {
        up <0, 1, 0>  
        angle 45    
        location <0,700,-480> 
        look_at <0,315,0>
    } 
    
    
#declare cam_E =
    camera {
        up <0, 1, 0>  
        angle 93    
        location <160,350,-340> 
        look_at <70,310,0>
    } 
//camera {cam_front}    //hide sky & stage
//camera {cam_side}     //hide sky & stage
//camera {cam_elev}     //hide sky & stage
   



#declare cam_F =
    camera {
        up <0, 1, 0>  
        angle 80    
        location <144,350,-520> 
        look_at <60,280,0>
    } 
//camera {cam_front}    //hide sky & stage
//camera {cam_side}     //hide sky & stage
//camera {cam_elev}     //hide sky & stage
camera {cam_E}  