// gearbox review
// m.miller 05.23.23

#version 3.8; 
global_settings {    
    max_trace_level 7
    ambient_light <.013,.01,.01> * 2 
    assumed_gamma 1                 
}                        

    
// -----------------------------------------------------------------------------------------
//                      S K Y
//------------------------------------------------------------------------------------------ 
background { rgb <0.12, 0.11, 0.1> * 10 } 
#declare img = "room_2k.jpg"

#macro bg_sphere (sc, pos, rot) 
object {
    sphere  
        { 0 1 
        hollow
        pigment{
            image_map{ 
                //hdr img
                jpeg img          
                map_type 1 
                interpolate 4 
                }
      }        
      finish { 
        ambient  1.0 
        diffuse  1 
        emission 1
        }
      scale sc  
      translate pos
      rotate <0, rot, 0>  
      } 
}  
#end

object { bg_sphere (<2000,2000,2000>, <0,100,0>, 250)}

      
// -----------------------------------------------------------------------------------------
//                      S T A G E 
//------------------------------------------------------------------------------------------  
#include "stage.inc"  
object { stage scale <10,10,10> translate <0,-1,0>}


// -----------------------------------------------------------------------------------------
//                     G E A R B O X
//------------------------------------------------------------------------------------------
#include "gear_box.inc"
gear_box


// -----------------------------------------------------------------------------------------
//                      C A M E R A 
//------------------------------------------------------------------------------------------ 
#declare cam_front =
    camera {
        up <0, 1, 0>  
        angle 33    
        location <30,70,-100> 
        look_at <0,2,0>
    } 

#declare cam_top =
    camera {
        up <0, 1, 0>  
        angle 3    
        location <0,2000,-.1> 
        look_at <0,0,0>
    } 
    
#declare cam_elev =
    camera {
        up <0, 1, 0>  
        angle 10    
        location <-1000,200,> 
        look_at <0,50,0>
    } 

#declare cam_iso =
    camera {
        up <0, 1, 0>  
        angle 50    
        location <0,100,-2> 
        look_at <0,0,0>
    } 
    

//camera {cam_front}
//camera {cam_side} 
//camera {cam_top} 
camera {cam_front}  




// -----------------------------------------------------------------------------------------
//                      L I G H T S 
//------------------------------------------------------------------------------------------ 
#declare light_left =
light_source {
    <0,0,0> 
    #declare light_color = color red .05 green .05 blue .05 ;                      
    light_color * 5                  
    area_light
    <50, 0, 0> <0, 0, 50>         
    10, 10                          
    adaptive 0                    
    jitter                        
    circular                      
    orient                     
    fade_distance 400
    fade_power 2     
    translate <-200,200,100>
}   
light_left

#declare light_right =
light_source {
    <0,0,0> 
    #declare light_color = color red .05 green .05 blue .05 ;                      
    light_color * 30                  
    area_light
    <50, 0, 0> <0, 0, 50>         
    10, 10                          
    adaptive 0                    
    jitter                        
    circular                      
    orient                     
    fade_distance 400
    fade_power 2     
    translate <200,200,-200>
}   
light_right


// --- under
#declare light_U =
light_source {
    <0,0,0> 
    #declare light_color = color red .06 green .05 blue .04 ;                      
    light_color * 20                  
    area_light
    <300, 0, 0> <0, 0, 300>         
    4, 4                          
    adaptive 0                    
    jitter                        
    circular                      
    orient                     
    fade_distance 80
    fade_power 2     
    translate <100, -100, 100> 
    shadowless 
}   
light_U 