// gear_box for Jack Head
// m.miller 05.23.23

#include "shapes.inc"
#include "shapes2.inc"
#include "gear_box_materials.inc"
#declare M_brass_A = material {M_brass_old scale <2.5,2.5,2.5>}
#declare M_brass_B = material {M_brass_old_stained}


// -----------------------------------------------------------------------------------------
//                      B O L T   H E A D  
//------------------------------------------------------------------------------------------
#macro make_bolt_head(rad,len)
    #declare bolt_rad=.5;
    #declare bolt_length=.5; 
    #declare slot_depth =  (rad*bolt_rad)/3;
    #declare slot_offset = len/3;
    #declare bolt_cut = (rad*bolt_rad)/1.2;
    difference {
        union { 
            cylinder {<0,0,0>,<0,len,0>,rad*bolt_rad }
            sphere {<0,0,0>, .5 scale <rad,len/2,rad> translate <0,len,0> }
            sphere {<0,0,0>, .5 scale <rad,len/2,rad> translate <0,0,0> }
        }
        plane { <1,0,0>, 0 translate <-bolt_cut,0,0> rotate <0,0,0>}
        plane { <1,0,0>, 0 translate <-bolt_cut,0,0> rotate <0,60,0>}
        plane { <1,0,0>, 0 translate <-bolt_cut,0,0> rotate <0,120,0>}
        plane { <1,0,0>, 0 translate <-bolt_cut,0,0> rotate <0,180,0>}
        plane { <1,0,0>, 0 translate <-bolt_cut,0,0> rotate <0,240,0>}
        plane { <1,0,0>, 0 translate <-bolt_cut,0,0> rotate <0,300,0>}
    }
#end 



#macro make_gear()
    #declare tooth = cylinder {<0,0,0>,<0,gear_height,0> 1 scale <tooth_width,1,tooth_height> }
    union {
       #if (show_teeth)
           #for (i,0,tooth_cnt-1)
                #declare n_ang = tooth_ang * i;
                object {tooth translate <0,0,tooth_rad> rotate <0,n_ang,0> }
           #end 
       #end
       difference {
            cylinder {<0,0,0>,<0,gear_height,0>, tooth_rad}
            cylinder {<0,-1,0>,<0,gear_height+1,0>, void_rad}
       }
       box {<-.5,0,-.5>,<.5,gear_height,.5> scale <gear_arm_width,1,void_rad*2>}
       box {<-.5,0,-.5>,<.5,gear_height,.5> scale <void_rad*2,1,gear_arm_width>}
       cylinder {<0,0,0>,<0,gear_height,0>, center_rad}
       cylinder {<0,-gear_height,0>,<0,gear_height*2,0>, center_rad/1.5}
    }
#end


#declare pointDataCount = 18 ;
#declare pointArray = array[pointDataCount] ;
#declare pointArray[0] =    <-2,        0,  18.000>  ;
#declare pointArray[1] =    <-11.600,   0,  18.000>  ;
#declare pointArray[2] =    <11.600,    0,  18.000>  ;
#declare pointArray[3] =    <0,         0,  0>  ;
#declare pointArray[4] =    <0,         0,  0>  ;
#declare pointArray[5] =    <0,         0,  0>  ;
#declare pointArray[6] =    <0,         0,  14.120>  ;
#declare pointArray[7] =    <0,         0,  6 >  ;
#declare pointArray[8] =    <11.639,    0,  -6.00>  ;
#declare pointArray[9] =    <0,         0,  -6.00>  ;
#declare pointArray[10] =   <-11.615,   0,  -6.00>  ;
#declare pointArray[11] =   <11.640,    0,  -18>  ;
#declare pointArray[12] =   <-11.615,   0,  -6.00>  ;
#declare pointArray[13] =   <0,         0,  -6.00>  ;
#declare pointArray[14] =   <-11.640,   0,  -18>  ;
#declare pointArray[15] =   <11.640,    0,  4.771>  ;
#declare pointArray[16] =   <7.000,     0,  8.000>  ;
#declare pointArray[17] =   <-11.600,   0,  10.493>  ;



#declare tooth_cnt =        48;
#declare tooth_width =      .3;
#declare tooth_height =     1;
#declare tooth_ang =        360/tooth_cnt;
#declare tooth_rad =        11; 
#declare void_rad =         9.5;
#declare gear_height =      .25;
#declare gear_height =      .25;
#declare gear_arm_width =   1.2;
#declare center_rad =       2.5;
#declare show_teeth =       1;
#declare gear_A = make_gear()


#declare tooth_cnt =        24;
#declare tooth_width =      .3;
#declare tooth_height =     1;
#declare tooth_ang =        360/tooth_cnt;
#declare tooth_rad =        4.55; 
#declare void_rad =         3.55;
#declare gear_height =      .25;
#declare gear_height =      .25;
#declare gear_arm_width =   .75;
#declare center_rad =       1.5;
#declare show_teeth =       1;
#declare gear_B = make_gear()


#declare tooth_cnt =        36;
#declare tooth_width =      .3;
#declare tooth_height =     1;
#declare tooth_ang =        360/tooth_cnt;
#declare tooth_rad =        6.6; 
#declare void_rad =         5.55;
#declare gear_height =      .25;
#declare gear_height =      .25;
#declare gear_arm_width =   .75;
#declare center_rad =       2;
#declare show_teeth =       1;
#declare gear_C = make_gear()


#declare tooth_cnt =        30;
#declare tooth_width =      .3;
#declare tooth_height =     1;
#declare tooth_ang =        360/tooth_cnt;
#declare tooth_rad =        6.1; 
#declare void_rad =         5;
#declare gear_height =      .25;
#declare gear_height =      .25;
#declare gear_arm_width =   .75;
#declare center_rad =       1.5;
#declare show_teeth =       1;
#declare gear_D = make_gear()

#declare tooth_cnt =        20;
#declare tooth_width =      .3;
#declare tooth_height =     1;
#declare tooth_ang =        360/tooth_cnt;
#declare tooth_rad =        3.75; 
#declare void_rad =         2.75;
#declare gear_height =      .25;
#declare gear_height =      .25;
#declare gear_arm_width =   .75;
#declare center_rad =       1.5;
#declare show_teeth =       1;
#declare gear_E = make_gear()



#declare frame_height = 10; 

#declare frame_post = 
union {
    cylinder {<0,0,0>,<0,frame_height,0>,.5 translate <0,0,0>}
    cylinder {<0,frame_height,0>,<0,frame_height+1,0>,.25 translate <0,0,0>}
    material {M_chrome_old}
}
#declare nut_A =  object { make_bolt_head(1.25,.35)         material {M_chrome_old}}
#declare nut_B =  object { make_bolt_head(1.25,1)           material {M_chrome_old}}
#declare washer = object { cylinder {<0,0,0>,<0,.2,0>,.8}   material {M_chrome_old}}


#declare bracket_shell =
difference {
    Round_Box(<-2,-1,-2>,<2,1,2>, 1 , 1)
    plane {<0,0,-1>,0 translate <0,0,1>}
    plane {<0,0,1>,0 translate <0,0,-1>} 
    plane {<0,1,0>,0 translate <0,0,0> } 
    Round_Box(<-1.9,-.8,-2>,<1.9,.8,2>, .8 , 1)
}


#declare bracket =
union{
     union { 
         difference {
             union {
             object { bracket_shell }
             object { bracket_shell rotate <180,0,0> translate <3.9,0,0> } 
             translate <0,1,0>
             } 
             plane {<1,0,0>,0 translate <0,0,0>}
             plane {<-1,0,0>,0 translate <4,0,0>}
         } 
         cylinder {<0,0,0>,<0,.2,0>,1 translate <4,0,0>}
         cylinder {<0,0,0>,<0,.2,0>,1 translate <0,1.8,0>}
         translate <3,0,0> 
     }
     cylinder {<0,1,0>,<0,3,0>,.2}
     cylinder {<0,0,0>,<0,.2,0>,.6 translate <0,1.8,0>}  
     sphere {<0,0,0>,.4 scale <1,.7,1> translate <0,2,0,> }
     sphere {<0,0,0>,.2 scale <1,1,1>  translate <0,2.3,0,> }
     prism { 
        linear_spline
        1.8, 2, 5,
        <.25,-.3>, 
        <2.5,-.5>, 
        <2.5, .5>, 
        <.25, .3>, 
        <.25,-.3>
        }
      sphere {<0,0,0>,.2 scale <1,1.5,1> translate <6,.3,0>} 
      sphere {<0,0,0>,.2 scale <1,1.5,1> translate <7,.3,0>} 
      material {M_chrome_old}
}



#declare armature = 
union {
    difference {
        // body
        #declare rad = 1 ;
        #declare sc = <14.000, 2.000, 21.00> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, 0.000, 0.000> } 
        
        plane { <0,1,0>,0  translate <0,-.1,0> }
        plane { <0,-1,0>,0  translate <0,.1,0> }
        #declare rad = .5 ;
        #declare sc = <3.927, 1.536, 9.376> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-5.593, 0.000, 5.323> } 
        #declare sc = <9.574, 1.536, 9.376> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, 0.000, -17.533> } 
        #declare sc = <3.927, 1.536, 9.376> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <5.581, 0.000, 5.323> } 
    
        #declare punch_A = cylinder {<0,0,0>,<0,1,0>,1.2}
        #declare punch_B = cylinder {<0,-1,0>,<0,1,0>,.3}
        
        #for (i,0,pointDataCount-1)
            object { punch_A translate pointArray[i]  material {M_brass_B}} 
            object { punch_B translate pointArray[i]  material {M_brass_B}}
        #end
    }
    difference {
        union {
            cylinder {<0,-.1,0>,<0,.1,0>,1.3 translate <7,0,8>}
            box {<7,-.1,-1.3>,<9.6,.1,1.3> translate <0,0,8>}
        }
        object { punch_A translate pointArray[16]} 
        object { punch_B translate pointArray[16]} 
    }    
}




#declare show_back_gear =   1;
#declare show_front_gear =  1;
#declare show_top_gear =    1;
#declare show_misc_parts =  1;

#declare gear_box =
union {
    object { armature translate <0,0,0>             material {M_brass_B }}
    object { armature translate <0,frame_height,0>  material {M_brass_B }}
    
    #if (show_back_gear)
        union {   //back gears
            object { gear_A rotate <0,30,0> scale <1,1,1> translate pointArray[10] } 
            object { gear_A rotate <0,-12.5,0> scale <1,1,1> translate pointArray[8] } 
            object { gear_B rotate <0,36,0> scale <1,1,1> translate pointArray[7] }
            translate <0,4,0>
            material {M_brass_B }
        }
    #end  
    
    #if (show_front_gear)
     union {   //front gears
        object { gear_A rotate <0,30,0> scale <1,1,1> translate pointArray[10] } 
        object { gear_D rotate <0,42,0> scale <1,1,1> translate pointArray[15] }
        object { gear_B rotate <0,66,0> scale <1,1,1> translate pointArray[7] } 
        object { gear_C rotate <0,55,0> scale <1,1,1> translate pointArray[0] }
        object { gear_E rotate <0,54,0> scale <1,1,1> translate pointArray[8] }
        translate <0,7,0>
        material {M_brass_B }
    }
    #end  


    #if (show_top_gear)
        //top gears
        object { gear_B 
            rotate <0,66,0> 
            scale <1,1,1> 
            translate pointArray[0]  
            material {M_brass_B } 
            translate <0,10.2,0>
        } 
    #end 
        
    #if (show_misc_parts)
        object {frame_post translate pointArray[0] }
        object {frame_post translate pointArray[1] }
        object {frame_post translate pointArray[2] }  
        object {frame_post translate pointArray[3] }
        object {frame_post translate pointArray[7] }
        object {frame_post translate pointArray[8] }
        object {frame_post translate pointArray[11] }  
        object {frame_post translate pointArray[12] }    
        object {frame_post translate pointArray[14] } 
        object {frame_post translate pointArray[15] } 
        object {frame_post translate pointArray[17] } 
        
        object {nut_A translate pointArray[1] translate <0,10.2,0> }
        object {nut_A translate pointArray[2] translate <0,10.2,0> }
        object {nut_A translate pointArray[3] translate <0,10.2,0> }
        object {nut_A translate pointArray[11] translate <0,10.2,0> }
        object {nut_A translate pointArray[13] translate <0,10.2,0> }
        object {nut_A translate pointArray[14] translate <0,10.2,0> }
    
        object {nut_B translate pointArray[7] translate <0,10,0> }
        object {nut_B translate pointArray[8] translate <0,10,0> }
        object {nut_B translate pointArray[12] translate <0,10,0> }
        object {nut_B translate pointArray[15] translate <0,10,0> } 
        object {nut_B translate pointArray[17] translate <0,10,0> } 
        
         
        object {washer translate pointArray[1] translate <0,10,0> }
        object {washer translate pointArray[2] translate <0,10,0> }
        object {washer translate pointArray[3] translate <0,10,0> }
        object {washer translate pointArray[11] translate <0,10,0> }
        object {washer translate pointArray[13] translate <0,10,0> }
        object {washer translate pointArray[14] translate <0,10,0> }      
        
        object { bracket scale <1.2,.5,1.2> rotate <0,0,0> translate pointArray[0] translate <0,10.15,0> } 
        object { bracket scale <1.2,.5,1.2> rotate <0,90,0> translate pointArray[2] translate <0,10.15,0> }
    #end
       
}