//stage



// -----------------------------------------------------------------------------------------
//                      C O L O R S
//------------------------------------------------------------------------------------------ 
#declare C_white =          color rgb<1,1,1>  ;
#declare C_blue =           color rgb<0,.5,.9>  ;
#declare C_light_blue =     color red 0.6 green 0.8 blue 1; 
#declare C_horizon_blue =   color red .82 green 1 blue .98; 
#declare C_gray60 =         color red 0.6 green 0.6 blue 0.6; 
#declare C_gray30 =         color red 0.3 green 0.3 blue 0.3; 

#declare F_stage =
finish {
    reflection {.2, .7 fresnel on } 
    conserve_energy 
    brilliance 1
    ambient .1
    diffuse .5 
    phong .5    
    phong_size 80
    specular .3 
    roughness .03 
}

#declare CM_stage =
color_map {
    [ 0.0     C_gray30 ]  
    [ 0.1     C_gray60 ]
    [ 0.15    C_horizon_blue ]
    [ 0.2     C_light_blue ]
    [ 1.0     C_blue ]
    }

#declare M_stage =
material {
    texture {
        pigment {
            gradient y
            color_map{CM_stage }
        }
    finish {F_stage}    
    }
}

#declare stage =
union {
    box {<-.5,0,-1>,<.5,-.01,1> }   
    difference {
        box {<-.5,0,0>,<.5,1,1> } 
        cylinder { <-.65,0,0>,<.65,0,0>, .5 translate <0,.5,0>}
    }                              
    material {M_stage scale <1,1.1,1> translate <0,-.1,0>}
    scale <1000,200,500>  translate <0,0,0> rotate <0,0,0>
    no_shadow
} 



#declare light_left =
light_source {
    <0,0,0> 
    #declare light_color = color red .05 green .05 blue .05 ;                      
    light_color * 30                  
    area_light
    <40, 0, 0> <0, 0, 40>         
    12,12                          
    adaptive 1                    
    jitter                        
    circular                      
    orient                     
    fade_distance 400
    fade_power 2     
    translate <-200,200,50>
}   
light_left

#declare light_right =
light_source {
    <0,0,0> 
    #declare light_color = color red .05 green .05 blue .05 ;                      
    light_color * 10                  
    area_light
    <40, 0, 0> <0, 0, 40>         
    12,12                          
    adaptive 1                    
    jitter                        
    circular                      
    orient                     
    fade_distance 400
    fade_power 2     
    translate <200,200,-200>
}   
light_right