// box_mapped boxes
// m.miller 05.21.23

#version 3.8; 
global_settings {    
    max_trace_level 7
    ambient_light <.013,.01,.01> * 20
    assumed_gamma 1                 
}                        


       
// -----------------------------------------------------------------------------------------
//                      S T A G E 
//------------------------------------------------------------------------------------------  
#include "stage.inc"  
object { stage scale <.5,.5,.5>  }


 
  
// -----------------------------------------------------------------------------------------
//                     B O X   M A P P E D   B O X E S
//------------------------------------------------------------------------------------------
#include "shapes.inc"
#include "shapes2.inc"
#include "macro_mapped_box.inc"
#include "materials.inc"


//#declare _mat =       M_uv;
//#declare _mat =       M_stone;
#declare _mat =         M_wood;
#declare _z_dir =       1;


#declare _fillet =   .2;
#declare _width =    5; 
#declare _height =   5;
#declare _depth =    10;
object { make_mapped_box(_width, _height, _depth, _fillet, _mat, _z_dir) translate <0,0,-_depth/2> rotate <0,30,0> translate <-10,0,0>}


#declare _fillet =   1.5;
#declare _width =    5; 
#declare _height =   5;
#declare _depth =    10; 
object { 
    difference {
        make_mapped_box(_width, _height, _depth, _fillet, _mat, _z_dir)
        plane { <0,0,1>, 0 translate <0,0,1> material {_mat} } 
    }    
    translate <0,0,-_depth/2> rotate <0,30,0> translate <0,0,0>
}

#declare _fillet =   1.5;
#declare _width =    5; 
#declare _height =   5;
#declare _depth =    10;
object {  make_mapped_box(_width, _height, _depth, _fillet ,_mat, _z_dir) translate <0,0,-_depth/2> rotate <90,0,0> translate <-4,-3,-12> }


#declare _fillet =   2.5;
#declare _width =    5; 
#declare _height =   5;
#declare _depth =    15; 
object { make_mapped_box(_width, _height, _depth, _fillet, _mat, _z_dir) translate <0,0,-_depth/2> rotate <0,30,0> translate <7,0,-4>}


#declare _fillet =   2.5;
#declare _width =    5; 
#declare _height =   5;
#declare _depth =    5; 
object { make_mapped_box(_width, _height, _depth, _fillet, _mat, _z_dir) translate <0,0,-_depth/2> rotate <0,90,0> translate <9,0,-12>}




// -----------------------------------------------------------------------------------------
//                      C A M E R A 
//------------------------------------------------------------------------------------------ 

#declare cam_A =
    camera {
        up <0, 1, 0>  
        angle 60    
        location <0,15,-30> 
        look_at <0,0,-3>
    } 

camera {cam_A}