//  cork screw materials
//  m.miller 05.20.23

#declare C_white =          color rgb<1,1,1>  ;
#declare C_black =          color rgb<0,0,0>  ;
#declare C_clear  =         rgbt 1 ;
#declare C_rust_red =       color rgb <0.6, 0.3, 0.25> ;
#declare C_rust_red_film =  color rgbt <0.5, 0.3, 0.25,.5> ;
#declare C_rust_gray =      color rgb <0.80, 0.80, 0.85> ;
#declare C_rust_gray_dark = color rgb <0.70, 0.70, 0.80>  ;
#declare C_rust_gray_film = color rgbt <0.5, 0.5, 0.5,.5> ; 
#declare C_rust_tan_film =  color rgbt <0.75, 0.6, 0.5,.75> ; 
#declare C_gray50 =         color red 0.5 green 0.5 blue 0.5;
#declare C_gray80 =         color red 0.8 green 0.8 blue 0.8; 



#declare C_map_rust_overlay = 
color_map {
    [0.0        C_clear ]
    [0.2        C_rust_red_film ]
    [0.25       C_rust_red_film * 1.5] 
    [0.35       C_rust_gray_film]
    [0.45       C_clear]
    [0.9        C_clear]
    [1.000      C_clear]
}


#declare C_map_rust_normal = 
color_map {
    [0.0        C_white ]
    [0.2        C_gray50 ]
    [0.25       C_black ] 
    [0.35       C_gray50 ]
    [0.45       C_gray80 ]
    [0.9        C_white ]
    [1.000      C_white ]
}


#declare F_metal_polished  =
finish {
    reflection {0, 1 fresnel on }
    conserve_energy 
    brilliance 5
    ambient 0
    diffuse .5 
    phong 5    
    phong_size 40
    metallic
    specular .4
    roughness 1/20
    reflection .5   
}


#declare F_matt =
finish {
    ambient 1
    diffuse 0   
    phong 0
    phong_size 0  
    emission 0
}
 
#declare F_gloss =
finish {
    ambient .2
    diffuse 1   
    phong 1
    phong_size 100  
    reflection {.01, .72 fresnel}
}



//--- stained overlay map
#declare imgDiffuse = "cork_screw_diffuse.png" 
#declare T_cork_screw =

texture {
   pigment { 
        image_map {
            png imgDiffuse     
            map_type 0
            interpolate 4 
            }
  }

    finish { 
        F_matt
    }
    scale <40,80,1> 
    translate <-20,0,0>     
}



//--- spotted reddish dents no finish
#declare sz = <1,1,1>*.5 ;   
#declare turb = .5; 
#declare bump = .1;
#declare T_rust_spots =
texture { 
    pigment { 
        spotted 
        color_map {C_map_rust_overlay} 
        turbulence turb
        scale sz
        } 

    finish{F_matt}
    
    normal {
        pigment_pattern{ 
            spotted 
            color_map {C_map_rust_normal} 
            turbulence turb
            scale sz
         }  
         bump_size bump
     }   
 }


//--- chrome
#declare T_metal_chrome = 
texture{ 
    pigment{ color red 0.8 green 0.8 blue 0.8 }   
    finish{ F_metal_polished }
 }
 
 


#declare M_cork_screw =
material { 
   texture { T_metal_chrome scale <1,1,1>}
   texture { T_rust_spots   scale <.1,.1,.1>}
   texture { T_cork_screw   scale <1,1,1>}
}  



#declare M_white_gloss =
material {
    texture {
       pigment { C_white }
       finish  { F_gloss }
   }
}