//old classic corkscrew / bottle opener
//m.miller 05.20.23



// -----------------------------------------------------------------------------------------
//                    C O R K S C R E W
//------------------------------------------------------------------------------------------  
#include "corkscrew_materials.inc"
#include "shapes.inc"
#include "shapes2.inc"

//--- top opener
#declare top_opener =
sphere_sweep {
     cubic_spline
     20,
     <0.008, 58.359, 0.000> , 1.813
     <0.008, 58.359, 0.000> , 1.813
     <1.508, 58.340, 0.000> , 1.779
     <4.243, 58.802, 0.000> , 1.417
     <6.102, 59.989, 0.000> , 1.341
     <8.112, 63.380, 0.000> , 1.509
     <8.454, 65.770, 0.000> , 1.518
     <7.416, 67.000, 0.000> , 1.138
     <4.368, 68.682, 0.000> , 0.837
     <1.877, 69.354, 0.000> , 0.803
     <0.000, 69.5, 0.000> , 0.803
     <-1.769, 69.354, 0.000> , 0.803
     <-4.310, 68.697, 0.000> , 0.830
     <-6.971, 67.284, 0.000> , 1.130
     <-8.455, 65.785, 0.000> , 1.514
     <-7.918, 63.142, 0.000> , 1.515
     <-5.861, 59.807, 0.000> , 1.343
     <-4.012, 58.646, 0.000> , 1.402
     <-1.324, 58.360, 0.000> , 1.758
     <-1.324, 58.360, 0.000> , 1.758
     tolerance 0.000001
     }




#declare p1 = <0.000, 61, 0.000>  ;
#declare p2 = <0.000, 52, 0.000>  ;
#declare p3 = <0.000, 31.3, 0.000>  ;
#declare p4 = <0.000, 40, 0.000>  ;
#declare p5 = <0.000, 29.919, 0.000>  ;
#declare p6 = <0.000, 24, 0.000> ; 

#declare rib = 
union {
    cylinder {<0,0,0>,<0,1,0>,2.2}
    torus {2.2,.5 translate <0,.5,0>}
}



//---screw top shaft 
#declare screw_shaft =
object {
    union {
        difference {
            cylinder { p1,p2,2.5 }
            plane {<0,0,1>, 0 rotate <15,0,0> translate <0.000, 61, -.3> }  
            plane {<0,0,-1>, 0 rotate <-15,0,0> translate <0.000, 60.281, .3> }
        }
        sphere {<0,0,0>,1 scale <2.5,.7,2.5> translate p2}
        cylinder { p2,p6,1.6 } 
        union {
            object { rib translate <0,0,0>}
            object { rib translate <0,-2.5,0>}
            object { rib translate <0,-5,0>}
            object { rib translate <0,-7.5,0>}
            object { rib translate <0,-10,0>} 
            object { rib translate <0,-12.5,0>}
            object { rib translate <0,-15,0>}
            translate <0,49.5,0>
            } 
    }
}


//---screw collar 
#declare screw_collar =
object { 
        difference {
            union {
                cylinder { p4,p5,3.51 } 
                sphere {<0,0,0>,1 scale <3.51,.7,3.51> translate p4} 
                sphere {<0,0,0>,1 scale <3.51,.7,3.51> translate p5}
            }
            box {<-12,0,-.85>,<12,10,.85> translate <0,29,0>} 
            cylinder { <0,0,0>,<0,100,0>,3 }
        }

} 


//---screw  
#declare screw =  
#declare _r1 = 0.55 ;
#declare _r2 = 1.1 ;
#declare _r_inc = 1 ;
#declare _turns = 5 ;
#declare _samples = (360/_r_inc)*_turns ;
#declare _height = 27 ;
object {
    union {
        #for (i, 0, _samples-1 )
            #declare _nY = (_height/_samples) * i ;
            #declare _nR = i * _r_inc ;
            sphere {<0,0,0>,_r1 translate <_r2,_nY,0> rotate <0,_nR,0>}
        #end
    }
}    
    
//---screw tip 
#declare screw_tip =  
#declare _r1 = 0.55 ;
#declare _r2 = 1.1 ;
#declare _r_inc = 1 ;
#declare _turns = .5 ;
#declare _samples = (360/_r_inc)*_turns ;
#declare _height = 2.7 ;
object {
    union {
        #for (i, 0, _samples-1 )
            #declare _nY = (_height/_samples) * -i ;
            #declare _nR = i * _r_inc ; 
            #declare _nS = _r1 * (1 -(i/_samples)) ; 
            sphere {<0,0,0>,_nS translate <_r2,_nY,0> rotate <0,_nR,0>}
        #end
    }
} 


//---body
#declare body = 
union {
    difference {
        lathe{ 
              cubic_spline
              41,
             <0.000, 38.011>,
             <0.000, 38.011>,
             <2.988, 37.750>,
             <8.024, 37.420>,
             <9.363, 37.059>,
             <10.026, 36.410>,
             <10.361, 35.589>,
             <10.374, 34.677>,
             <10.035, 33.850>,
             <9.389, 33.220>,
             <8.578, 32.889>,
             <7.208, 32.535>,
             <6.707, 32.284>,
             <6.278, 31.678>,
             <6.278, 29.997>,
             <6.278, 25.011>,
             <6.278, 19.979>,
             <6.278, 14.970>,
             <6.278, 10.996>,
             <6.577, 9.662>,
             <7.230, 8.424>,
             <8.142, 7.117>,
             <8.481, 5.492>,
             <8.481, 3.121>,
             <8.108, 2.512>,
             <7.632, 2.523>,
             <7.643, 3.147>,
             <7.643, 5.433>,
             <7.398, 6.919>,
             <6.549, 8.209>,
             <5.929, 9.516>,
             <5.667, 11.002>,
             <5.667, 15.000>,
             <5.667, 19.997>,
             <5.667, 24.994>,
             <5.667, 28.051>,
             <5.491, 29.266>,
             <4.570, 29.952>,
             <3.316, 30.266>,
             <0.000, 30.266>,
             <0.000, 30.266>
              } 
              
        box {<-12,0,0>,<12,30,-12> translate <0,9.5,-1.5>} 
        box {<-12,0,0>,<12,30, 12> translate <0,9.5, 1.5>}     
        #declare rad = 1 ;
        #declare sc = <5.2, 10.320, 8> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <0.000, 19.309, 0.000> } 
       
        box {<-12,0,-.75>,<12,10,.75> translate <0,29,0>}
       
       }
    torus {8.48, .6 translate <0,2.5,0>} 
    torus {6.28, 1 translate <0,9,0>}  
    sphere { <0,0,0>,1.42 scale <1,1,.5> translate <8.13,35.13,-1.5>}
    sphere { <0,0,0>,1.42 scale <1,1,.5> translate <8.13,35.13,1.5>}
    sphere { <0,0,0>,1.42 scale <1,1,.5> translate <-8.13,35.13,-1.5>}
    sphere { <0,0,0>,1.42 scale <1,1,.5> translate <-8.13,35.13,1.5>}
    
}



#declare cut_A =
object {
    prism {
        linear_spline
        -5, 5, 35,
        < 6.762,0.000>,
        < 6.762,11.920>,
        < 6.762,31.620>,
        < 2.901,31.808>,
        < 2.901,37.797>,
        < 3.528,38.424>,
        < 4.841,37.719>,
        < 5.429,38.365>,
        < 4.645,39.678>,
        < 5.606,40.305>,
        < 6.644,39.051>,
        < 7.428,39.247>,
        < 7.467,40.776>,
        < 8.604,40.795>,
        < 8.722,39.247>,
        < 9.525,38.973>,
        < 10.544,40.266>,
        < 11.367,39.639>,
        < 10.681,38.326>,
        < 11.250,37.679>,
        < 12.700,38.307>,
        < 13.209,37.483>,
        < 12.112,36.445>,
        < 12.386,35.622>,
        < 13.621,35.602>,
        < 13.758,34.544>,
        < 12.327,34.230>,
        < 11.994,33.505>,
        < 12.798,32.800>,
        < 14.953,31.330>,
        < 17.053,31.330>,
        < 17.053,43.961>,
        <0.000,43.961>,
        <0.000, 0.000>
        < 6.762,0.000>
    }    
    scale <1,1,1> 
    rotate <-90,0,0> 
    translate <0,0,0>
}

//---handle
#declare handle =  
difference {
    sphere_sweep {
         cubic_spline
         6,
         <8.130, 35.301, 0.000> , 6
         <8.130, 35.301, 0.000> , 6
         <7, 29.866, 0.000> , 4.427
         <7, 14.447, 0.000> , 4.427
         <4, 4.109, 0.000> , 9
         <4, 4.109, 0.000> , 9
         tolerance 0.000001
         }
     cylinder {<-20,0,0>,<20,0,0>,20 scale <1,1.75,.3> translate <8.13,35.13,-7> } 
     cylinder {<-20,0,0>,<20,0,0>,20 scale <1,1.75,.3> translate <8.13,35.13, 7> }
     sphere {<0,0,0>,16 scale <1,1,2> translate <-5.4,1,0>}
     cut_A
}

#declare sleeve =
lathe{ 
      cubic_spline
      12,
     <5.567, 7.904>,
     <5.567, 7.904>,
     <6.416, 6.614>,
     <6.661, 5.128>,
     <6.661, 2.842>,
     <6.979, 2.150>,
     <7.773, 2.343>,
     <7.499, 2.816>,
     <7.499, 5.187>,
     <7.160, 6.812>,
     <6.248, 8.119>,
     <6.248, 8.119>
      }
      
      
#macro corkscrew(r) 
union {
   
    union {
        object { top_opener scale <1,1,.45> material {M_cork_screw translate <0,-5,0>} }
        object { screw_shaft scale <1,1,1>  material {M_cork_screw translate <0,-5,0>} }
        object { screw translate <0,-2,0> }
        object { screw_tip translate <0,-2,0> }
        
        translate <0,-r/5,0>  
    }
    union { 
        object { screw_collar  translate <0,0,0> }
        object { body translate <0,0,0> }  
        object { handle scale <1,1,.35>  translate <-8.13,-35.13,0> rotate <0,0,r> translate <8.13,35.13,0>}
        object { handle scale <-1,1,.35> translate <8.13,-35.13,0> rotate <0,0,-r> translate <-8.13,35.13,0>}
     }
     object { sleeve material {M_white_gloss} translate <0,-.5,0> } 
     translate <0,5,0>
     material {M_cork_screw }
     
} 
#end



