// object review
// m.miller 04.22.23

#version 3.8; 
global_settings {    
    max_trace_level 7
    ambient_light <.013,.01,.01> * 2                  
}                        

// -----------------------------------------------------------------------------------------
//                      S T A G E
//------------------------------------------------------------------------------------------ 
#declare light_left =
light_source {
    <0,0,0> 
    #declare light_color = color red .05 green .05 blue .05 ;                      
    light_color * 5                  
    area_light
    <150, 0, 0> <0, 0, 150>         
    8, 8                          
    adaptive 0                    
    jitter                        
    circular                      
    orient                     
    fade_distance 400
    fade_power 2     
    translate <-200,200,-50>
}   
light_left

#declare light_right =
light_source {
    <0,0,0> 
    #declare light_color = color red .05 green .05 blue .05 ;                      
    light_color * 10                  
    area_light
    <150, 0, 0> <0, 0, 150>         
    8, 8                          
    adaptive 0                    
    jitter                        
    circular                      
    orient                     
    fade_distance 400
    fade_power 2     
    translate <200,50,-200>
}   
light_right




// -----------------------------------------------------------------------------------------
//                      S T A G E
//------------------------------------------------------------------------------------------ 
#include "stage.inc"    
stage



// -----------------------------------------------------------------------------------------
//                      S C R E W   D R I V E R S   
//------------------------------------------------------------------------------------------ 
#include "screwdrivers.inc"                                                                       
#declare standard =  1; 
#declare phillips =  2;
#declare grip_A   =  1;   //plastic craftsman
#declare grip_B   =  2;   //plastic craftsman - with blue end
#declare grip_C   =  3;   //plastic simple
#declare grip_D   =  4;   //old wood style 


// -----------------------------------------------------------------------------------------
//                      S C R E W   D R I V E R S   - elevation
//------------------------------------------------------------------------------------------ 

//--- classic craftsman - gold resin and red
#declare M1 = material {M_glass_gold};    
#declare M2 = material {M_gold_gloss};
#declare M3 = material {M_red_gloss}; 
object { make_screwdriver(grip_A,phillips,M1,M2,M3) scale <1,1,1> rotate <0,30,0> translate <-40,0,60>}

//--- classic craftsman - gold resin and red and blue
#declare M1 = material {M_glass_gold};    
#declare M2 = material {M_red_gloss};
#declare M3 = material {M_blue_charcoal_gloss}; 
object { make_screwdriver(grip_B,phillips,M1,M2,M3) scale <1,1,1> rotate <0,30,0> translate <-20,0,60>}

//--- simple black and green
#declare M1 = material {M_black_gloss};    
#declare M2 = material {M_black_gloss};
#declare M3 = material {M_sea_green_gloss}; 
object { make_screwdriver(grip_C,phillips,M1,M2,M3) scale <.9,1,.9> rotate <0,60,0> translate <0,0,60>}

//--- simple green resin and yellow
#declare M1 = material {M_glass_green};    
#declare M2 = material {M_yellow_gloss};
#declare M3 = material {M_glass_gold}; 
object { make_screwdriver(grip_C,standard,M1,M2,M3) scale <1,1,1> rotate <0,30,0> translate <20,0,60>}


//--- old wood style 
#declare M1 = material {M_wood_handle scale <1,1,1>};    
#declare M2 = material {M_steel_aged_2 scale <2,4,2>};
#declare M3 = material {M_steel_aged_2 scale <2,4,2>}; 
object { make_screwdriver(grip_D,standard,M1,M2,M3) scale <1,.9,1> rotate <0,30,0> translate <40,0,60>}



// -----------------------------------------------------------------------------------------
//                      S C R E W   D R I V E R S   - plan
//------------------------------------------------------------------------------------------ 
//--- classic craftsman - gold resin and red
#declare M1 = material {M_glass_gold};    
#declare M2 = material {M_gold_gloss};
#declare M3 = material {M_red_gloss}; 
object { make_screwdriver(grip_A,phillips,M1,M2,M3) scale <1,1,1> rotate <90,10,0> translate <-40,4,0>}

//--- classic craftsman - gold resin and red and blue
#declare M1 = material {M_glass_gold};    
#declare M2 = material {M_red_gloss};
#declare M3 = material {M_blue_charcoal_gloss}; 
object { make_screwdriver(grip_B,phillips,M1,M2,M3) scale <1,1,1> rotate <90,10,0> translate <-20,4,0>}

//--- simple black and green
#declare M1 = material {M_black_gloss};    
#declare M2 = material {M_black_gloss};
#declare M3 = material {M_sea_green_gloss}; 
object { make_screwdriver(grip_C,phillips,M1,M2,M3) scale <.9,1,.9> rotate <0,-50,0> rotate <90,10,0> translate <0,3,0>}

//--- simple green resin and yellow
#declare M1 = material {M_glass_green};    
#declare M2 = material {M_yellow_gloss};
#declare M3 = material {M_glass_gold}; 
object { make_screwdriver(grip_C,standard,M1,M2,M3) scale <1,1,1> rotate <0,-50,0> rotate <90,10,0> translate <20,4,0>}


//--- old wood style 
#declare M1 = material {M_wood_handle scale <1,1,1>};    
#declare M2 = material {M_steel_aged_2};
#declare M3 = material {M_steel_aged_2}; 
object { make_screwdriver(grip_D,standard,M1,M2,M3) scale <1,1,1> rotate <90,10,0> translate <40,4,0>}


//--- sample material
//sphere {<0,0,0>,20 translate <0,20,0> material {M_steel_aged_2}}


// -----------------------------------------------------------------------------------------
//                      C A M E R A S
//------------------------------------------------------------------------------------------ 
#declare cam_front =
    camera {
        up <0, 1, 0>  
        angle 10    
        location <100,200,-1000> 
        look_at <0,50,0>
    } 

#declare cam_elev =
    camera {
        up <0, 1, 0>  
        angle 1.3    
        location <100,200,-10000> 
        look_at <0,50,0>
    } 
    
#declare cam_side =
    camera {
        up <0, 1, 0>  
        angle 10    
        location <-1000,200,> 
        look_at <0,50,0>
    } 

#declare cam_iso =
    camera {
        up <0, 1, 0>  
        angle 15    
        location <100,150,-450> 
        look_at <0,20,0>
    } 
    

//camera {cam_front}
//camera {cam_side} 
//camera {cam_elev} 
camera {cam_iso}